<?php
// must be run within Dokuwiki
if(!defined('DOKU_INC')) die();

/**
 * Synchronet authentication backend
 *
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Stephen Hurd <deuce@synchro.net>
 */
class auth_plugin_authsbbs extends DokuWiki_Auth_Plugin {
	public function __construct() {
        global $config_cascade;

		parent::__construct();
		$this->cando['addUser']		= false;
		$this->cando['delUser']		= false;
		$this->cando['modLogin']	= false;
		$this->cando['modPass']		= false;
		$this->cando['modName']		= false;
		$this->cando['modMail']		= false;
		$this->cando['modGroups']	= false;
		$this->cando['getUsers']	= true;
		$this->cando['getUserCount']= true;
		$this->cando['getGroups']	= true;
		$this->cando['external']	= false;
		$this->cando['logout']		= true;

        if(@is_readable($this->getConf('user.dat')))
 			$this->success = true;
	}

	public function checkPass($user, $pass) {
		$u = $this->_getUser($user);
		if($u == null)
			return false;
		if(strtolower($u['pass'])==strtolower($pass))
			return true;
		return false;
	}

	public function getUserData($user) {
		$u = $this->_getUser($user);
		if($u == null)
			return false;
		return $u;
	}

	public function retrieveGroups($start, $limit) {
		global $conf;
		$ret=array();

		if($limit==0)
			$limit=99;
		if($start <= 0 && $limit+$start >= 1)
			array_push($ret, $conf['defaultgroup']);
		if($start <= 1 && $limit+$start >= 2)
			array_push($ret, 'admin');
		if($start <= 2 && $limit+$start >= 3)
			array_push($ret, 'guest');
		if($start <= 3 && $limit+$start >= 4)
			array_push($ret, 'readonly');
		return $ret;
	}

	public function isCaseSensitive() {
		return false;
	}

	public function getUserCount($filter=null) {
		return count($this->_getFilteredUsers($filter));
	}

	public function retrieveUsers($start, $limit, $filter=null) {
		return array_slice($this->_getFilteredUsers($filter), $start, $limit);
	}

	protected function _parseFlags($val) {
		$fv = '';
		for($bit=0; $bit < 32; $bit++) {
			if($val & (1<<$bit))
				$fv .= chr(ord('A')+$bit);
		}
		return $fv;
	}

	protected function _parseUserRec($rec) {
		global $conf;

		$ur = array();
		$misc = base_convert(substr($rec, 538, 8), 16, 10);
		if($misc & ((1<<0)|(1<<6)))	// DELETED or INACTIVE
			return null;
		$ur['user']  = rtrim(substr($rec, 0, 25),"\3");
		$ur['name']   = rtrim(substr($rec, 25, 25),"\3");
		$ur['handle'] = rtrim(substr($rec, 50, 8),"\3");
		$ur['mail']   = rtrim(substr($rec, 184, 60),"\3");
		$ur['pass']   = rtrim(substr($rec, 318, 8),"\3");
		$ur['grps']   = array();
		$ur['rest'] = $this->_parseFlags(base_convert(substr($rec, 525, 8), 16, 10));
		if(stripos($ur['rest'],'P')!==false)
			array_push($ur['grps'], 'readonly');
		elseif(stripos($ur['rest'],'G')!==false)
			array_push($ur['grps'], 'guest');
		else
			array_push($ur['grps'], $conf['defaultgroup']);
		$ur['flags']  = array();
		$ur['flags'][1] = $this->_parseFlags(base_convert(substr($rec, 499, 8), 16, 10));
		$ur['flags'][2] = $this->_parseFlags(base_convert(substr($rec, 509, 8), 16, 10));
		$ur['flags'][3] = $this->_parseFlags(base_convert(substr($rec, 744, 8), 16, 10));
		$ur['flags'][4] = $this->_parseFlags(base_convert(substr($rec, 752, 8), 16, 10));
		if(substr($rec, 497, 2) >= 90 || stripos($ur['flags'][substr($this->getConf('adminFlag'),0,1)],substr($this->getConf('adminFlag'),1,1))!==false)
			array_push($ur['grps'], 'admin');
		return $ur;
	}

	protected function _getUser($user) {
		$uf = fopen($this->getConf('user.dat'), 'rb');
		//if(flock(&uf, 1))
		while(!feof($uf)) {
			$rec = fread($uf, 834);
			$ur = array();
			if($rec!==false) {
				$ur=$this->_parseUserRec($rec);
				if($ur==null)
					continue;
				if(strtolower($ur['user']) != strtolower($user))
					continue;
				fclose($uf);
				return $ur;
			}
		}
		fclose($uf);
		return null;
	}

	protected function _getFilteredUsers($filter) {
		$ret=array();

		$uf = fopen($this->getConf('user.dat'), 'rb');
		//flock(&uf, LOCK_SH);
		while(!feof($uf)) {
			$rec = fread($uf, 834);
			if($rec!==false) {
				$ur=$this->_parseUserRec($rec);
				if($ur==null)
					continue;
				$bad=false;
				if($filter != null) {
        			foreach($filter as $item => $pattern) {
            			if($item == 'grps') {
							$gotgrp=false;
							foreach($ur['grps'] as $grp) {
								if(stripos($grp, $pattern)!==false)
									$gotgrp=true;
							}
							if(!$gotgrp)
								$bad=true;
            			} else {
							if(stripos($ur[$item], $pattern)===false)
								$bad=true;
            			}
						if($bad)
							break;
					}
				}
				if(!$bad)
					$ret[$ur['user']]=$ur;
			}
		}
		fclose($uf);
		return $ret;
	}
}
