{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
{
Detects the BBS under which the door is running. At this time RA, QBBS and
SBBS are supported.

The way of working is simple. First look for the BBS= environment variable.
If it's set, use it's value. If it is not set, look for the QUICKBBS=
environment variable. If it's found, report QBBS, if not report RA.
RA is the default sinds I'm an RA sysop myself..;-)

- 12 feb 92: Release

}

Unit BBSTypes;
Interface
Uses Dos;

Type BBSTypeList    = (
                       NO_BBS,    { No BBS could be detected }

                       RA_BBS,    { RemoteAccess             }
                       S_BBS,     { SuperBBS                 }
                       Q_BBS,     { QuickBBS                 }

                       LAST_BBS   { Last member of list      }
                      );

Var CurrentBBSType : BBSTypeList;

Implementation

Type BBSIndentifier = String[10];

Const BBSTypeParams : Array[Succ(No_BBS)..Pred(Last_BBS)] of BBSindentifier
                    = (
                      'RA',
                      'SBBS',
                      'QBBS'
                      );


Function DetectBBSType:BBSTypeList;
Var BBSPtr : BBSTypeList;
    BBSStr : BBSIndentifier;
    C      : Byte;

Begin
BBSPtr:=No_BBS;

BBSStr:=GetEnv('BBS');
If BBSStr<>''
   Then Begin
        For C:=1 To Length(BBSStr) Do
          BBSStr[C]:=Upcase(BBSStr[C]);

        BBSPtr:=Pred(LAST_BBS);
        While (BBSPtr>No_BBS) And (BBSStr<>BBSTypeParams[BBSPtr]) Do
         BBSPtr:=Pred(BBSPtr);
        End;

If BBSPtr>No_BBS
   Then Begin
        DetectBBSType:=BBSPtr;
        Exit;
        End;


If GetEnv('Quick')<>''  { Second way of detecting QBBS }
   Then Begin
        DetectBBSType:=Q_BBS;
        Exit;
        End;

DetectBBSType:=RA_BBS;   { Default value! }
End;

Begin
CurrentBBSType:= DetectBBSType;
End.
