; Desqview detection procedures for TP5.5
;
; (C) Copyright LiveSystems 1992,1993
;
; Written by Gerhard Hoogterp,
; Release 1 feb 1990
; version 1.1
;

TITLE DESQVIEW
LOCALS @@

DATA SEGMENT WORD PUBLIC

; Externals

EXTRN DVUSED      : BYTE   ; Is DV in use?
EXTRN DVMAJOR 	  : BYTE   ; Major release nr
EXTRN DVMINOR 	  : BYTE   ; Minor release nr.
EXTRN VBUFSEG 	  : WORD   ; Videobuffer segment
EXTRN VBUFOFS 	  : WORD   ; Videobuffer ofset
EXTRN DIRECTVIDEO : BYTE   ; TP's Directvideo boolean.

TempSeg    DW   ?                       ; reserve a word
Critical   DB   ?                       ; Reserve a byte

DATA ENDS

CODE SEGMENT BYTE PUBLIC

     ASSUME CS:CODE,DS:DATA

; Procedure CheckDv

     PUBLIC CheckDv

CheckDv:

        PUSH BX                         ; Save BX
        PUSH CX                         ;      Cx
        PUSH DX                         ; and  Dx
        MOV  CX,'DE'                    ; Set the needed values
        MOV  DX,'SQ'                    ;
        MOV  AX,2B01H                   ; Call the DOS SetDAte Routing
        INT  21H                        ;
        CMP  AL,0FFH                    ; If DOS sees it as illegal
        JE   No_Desq                    ; (Ax=$FF) Then jump to No_Desq
        MOV  DVUSED,01H                 ; Set DvUsed to True
        MOV  DVMAJOR,BH                 ; Fill DvMajor with Bh
        MOV  DVMINOR,BL                 ; Fill DvMinor with Bl
        MOV  DIRECTVIDEO,00             ; Turn Directvideo on
        JMP  END_CHECK                  ; Exit

No_Desq:                                ; DV is not running
        MOV  DVUSED,00H                 ; Set DvUsed to false
        XOR  AX,AX                      ; and Clear AX
End_Check:
        POP  DX                         ; Restore the used regs.
        POP  CX
        POP  BX
        RET

; Procedure Get_Video_Buffer;

PUBLIC Get_Video_Buffer

Get_Video_Buffer:
        PUSH BP                         ; Store BP
        MOV  BP,SP                      ; Put the Sp into Bp
        PUSH DI                         ; store the used vars
        PUSH ES                         ; Ds:Di
        MOV  ES,VBUFSEG                 ; Put the already found values
        MOV  TEMPSEG,ES
        MOV  DI,VBUFOFS                 ; into Es:Di
        MOV  AH,0FEH                    ; Call the Get Video bios routine
        INT  10H                        ; through Int $10
        MOV  VBUFSEG,ES                 ; put the found values into the vars
        MOV  VBUFOFS,DI                 ;
        MOV  AX,ES
        CMP  TEMPSEG,AX                 ; Check if the segment has changed
        POP  ES                         ; restore the used regs
        POP  DI                         ; Es:Di
        POP  BP                         ; restore the Bp
        RET

api_Call:
        PUSH AX                         ; Store AX
        MOV AX,101AH                    ; Switch to the DV stack
        INT 15H                         ;
        MOV AX,BX                       ; Do the DV_Api_Call
        INT 15H                         ;
        MOV AX,1025H                    ; Switch back to appl.stack
        INT 15H                         ;
        POP AX                          ;
        RET                             ;

; Procedure Dv_Pause

PUBLIC DV_PAUSE

DV_PAUSE:
        CMP  DVUSED,00H                 ; Check if DV is running
        JZ   DV_P_EXIT                  ; If not, exit
        PUSH BX                         ; save BX
        MOV  BX,1000H                   ; Fill Bx with the API func. number
        CALL API_CALL                   ; make the API call
        POP  BX                         ; restore BX
DV_P_EXIT:                              ;
        RETF

; PROCEDURE DV_START_CRITICAL

PUBLIC DV_START_CRITICAL

DV_START_CRITICAL:
        CMP  DVUSED,00H                 ; Check if DV is running
        JZ   DV_SQ_EXIT                 ; If not, exit
        PUSH BX                         ; save BX
        MOV  CRITICAL,01H
        MOV  BX,101BH                   ; Fill Bx with the API func. number
        CALL API_CALL                   ; make the API call
        POP  BX                         ; restore BX
DV_SQ_EXIT:                             ;
        RETF

; PROCEDURE DV_STOP_CRITICAL

PUBLIC DV_STOP_CRITICAL

DV_STOP_CRITICAL:
        CMP  DVUSED,00H                 ; Check if DV is running
        JZ   DV_SPQ_EXIT                ; If not, exit
        CMP  CRITICAL,00H
        JZ   DV_SPQ_EXIT
        PUSH BX                         ; save BX
        MOV  BX,101CH                   ; Fill Bx with the API func. number
        CALL API_CALL                   ; make the API call
        POP  BX                         ; restore BX
DV_SPQ_EXIT:                            ;
        RETF

CODE    ENDS

        END
