{A+,B-,D-,E-,F-,I-,L-,N-,O-,R-,S+,V-}
{$M 10000,0,0}

{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
{---------------------------------------------------------------------------|

 Description:

 Frame is a simple framework for a door written with the RADoor toolbox. It
 has the main initializations already where they should, and the important
 variables in place. Simply stuff some code at the spot marked X and compile.
 that's all. Compiling this frame without anything further and the compiler
 toggles as above resulted in an EXE file with the following values in the
 Get Info window of TP5.5:

    CodeSize   32560 bytes
    DataSize   28812 bytes

 Not too much for an all singing, all dancing door featuring everything a door
 should feature, supporting 3 BBSses almost transparant to the sysop and
 programmer..

- 2 Feb 92: Release

}


Program FRAME;
Uses
     Fossil,     { The fossil routines + Timing. This is the     }
                 {  body of the door!                            }
     UserHook,   { Demo/default userhook procedures              }
     Filter,     { The default output filter                     }
     GlobInfo,   { the global record with all the nessecary info }
     RA,         { The RA init code                              }
     SuperBBS,   { The SBBS init Code                            }
     QuickBBS,   { The QBBS init code                            }
     LowLevel,   { The lowlevel stuff                            }
     DoorSys,    { Misc. Door routines.                          }
     BBSTypes,   { Autodetect BBS Type. Default RA               }
     CRT,        { TP CRT unit                                   }
     DOS;        { TP DOS unit                                   }

{----------------------------------------------------------------------------|
  The name and the version of the program together with the FossilObject
  variable which every door needs.
|----------------------------------------------------------------------------}


Const  ProgramName    = 'FRAME';
       ProgramVersion = '2.0';
       LastUpdate     = '12 Feb 1992';

Var Foss       : FossilObject;


{----------------------------------------------------------------------------|
 Start here your own variables, procedures and functions.
|----------------------------------------------------------------------------}




{----------------------------------------------------------------------------|
 Start of main module
|----------------------------------------------------------------------------}
Begin
ClrScr;
WriteLn(ProgramName,' ',ProgramVersion,' (c) LiveSystems 1990,1991   ALL RIGHTS RESERVED,  NO GUARANTEES');
WriteLn('Written by G.Hoogterp. E-mail address 2:283/1.2 Last Revision '+LastUpdate);
WriteLn('Use <FileName> -? to see commandline parameter summary.');

If ExistParameter('?')
   Then Begin
        WriteLn('Usage: ');
        WriteLn;
        WriteLn(' <FileName.EXE [-T:<TimeLimit>] [-N:*N] [-P:*P] [-NOS]');
        WriteLn;
        WriteLn(' -T:     Limit the time available in the door.');
        WriteLn(' -N:     Give nodenumber for multiline setups.');
        WriteLn(' -P:     Give ComPort to use.');
        WriteLn(' -NOS    Turn local sounds OFF for default.');
        Halt;
        End;

{ The parameters mentioned here are read in the RA.PAS unit as they are more
  or less RA dependend and the result has to be stuffed into the global info
  record. }

{----------------------------------------------------------------------------|
 Grab the BBS specific stuff into the GlobalInfo record
|----------------------------------------------------------------------------}

Case CurrentBBStype Of
 RA_BBS : InitRA;
 S_BBS  : InitSBBS;
 Q_BBS  : InitQBBS;
End;

{----------------------------------------------------------------------------|
 And let the LOGfile know who's talking.
|----------------------------------------------------------------------------}

LogIt('Started: '+ProgramName+' '+ProgramVersion+' under '+GlobalInfo.BBSName);

{----------------------------------------------------------------------------|
  Initialize the userhooks, Timeout detection etc.
|----------------------------------------------------------------------------}

With GlobalInfo Do
 Begin
 Foss.AssignF(ComPort-1,BaudRate);   { Inti the fossil }
 If Foss.Error<>0
    Then Begin
         WriteLn(#254' Couldn''t initialize fossil!');
         LogIt('Couldn''t init fossil!');
         Halt;
         End;

 Foss.InitTimer(                         { Init the timeout procedures              }
                GlobalInfo.Warnings,     { Warning before pushed back to the BBS    }
                GlobalInfo.TimeOutTime   { Timeout time before and between warnings }
                );


 Foss.InitOutputFilter(UsedFilter); { Set the output filter            }
 Foss.InitInputFilter(AllCharSet);  { Set the input filter for ReadLnF }

{------ SysOp Keys and StatusLine procedures are in the USERHOOK.TPU ---------}

 Foss.InitSysopKeys(SysopKeys);     { Set the SYSOP keys procedure            }
 Foss.InitStatLine(StatusLine);     { Set the statusline procedure            }

{---- Initialize the output filter using the info in the GlobalInfo record ---}

 InitUsedFilter(UseGraphics,UseAVATAR,LeftBracket,RightBracket,'^');
 End;


{--- Initialize the colortable, These are the colors used in my programs -----}

ColorTable[0]:=LightCyan;           { Normal text color                       }
ColorTable[1]:=LightRed;            { Hotkey's and lines                      }
ColorTable[2]:=White;               { Userinput and info highlight            }
ColorTable[3]:=Yellow;              { Info                                    }
ColorTable[4]:=(Blue Shl 4)+White;  { Statusline color                        }
ColorTable[5]:=LightRed;            { Lines and frames                        }
ColorTable[6]:=(Red shl 4)+White;   { User input fields                       }

{---------- Initialise the strings in the FOSSIL.PAS unit --------------------}

PressEnterOrStopString := '^0Press ^[^1ENTER^0^] to continue, ^[^1S^0^] to Stop: ^2';
PressEnterString       := '^0Press ^[^1ENTER^0^] to continue: ^2';
Warning1String         := '^1^[^2 You have only 2 minutes left!^1^]^2';
Warning2String         := '^1^[^2 You have only 1 minute left! ^1^]^2';
AttentionString        := '^2HELLO???';
LockOutString          := '^1--- You''ve been locked out of the system! Don''t call back..';
HangUpString           := '^1--- The Sysop hungup the phone, call back an other time.';
TimeUpString           := '^1Sorry, you reached your daily timelimit. Hope to see you back an other time.';
UsedStopKey            := 'S';


{----------------------------------------------------------------------------|
  The mainbody of the DOOR goes here.
|----------------------------------------------------------------------------}


                                   { Mark -> X }


{----------------------------------------------------------------------------|
  Finalize the DOOR and say a nice thank you to the user for spending his
  online time and money on your door..
|----------------------------------------------------------------------------}

Case CurrentBBSType Of
 RA_BBS : If Not RAUpdateExitInfo
             Then LogIt('Couldn''t update the EXITINFO.BBS!');
 S_BBS  : If Not SBBSUpdateExitInfo
             Then LogIt('Couldn''t update the EXITINFO.BBS!');
 Q_BBS  : If Not QBBSUpdateExitInfo
             Then LogIt('Couldn''t update the EXITINFO.BBS!');
End;

Foss.ClrScrF;  { Clear the screen }
Foss.WriteLnF('Thanks for using '+ProgramName+'.');

{----------------------------------------------------------------------------|
  Tell the LogFile that we're finished. Gives the fossil some extra time
  to get the ThankYou out of it's mouth....
|----------------------------------------------------------------------------}

LogIt('Stopped: '+ProgramName+' '+ProgramVersion);

{----------------------------------------------------------------------------|
 And close the fossil again..
|----------------------------------------------------------------------------}

Foss.CloseF;
End.

{----------------------------------------------------------------------------|
   And that's it! That's all.. I can't make things simpler..
   Oh well, actualy I could, but not without giving up flexability and
   usability.....
|----------------------------------------------------------------------------}
