{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
{--------------------------------------------------------------------------|
 Description:

  This unit contains all the SBBS specific stuff. It's main purpose is to
  fill the GlobalInfo record. Doing things this way it's easier to make a
  door less system dependable. As long as you only use the information
  in GlobalInfo in your doors, it's easy to make versions for other BBSses
  or to add support for more than one BBS. (Detect in your mainprogram and
  call the right initprocedure!)

  If an other BBS doesn't support some information which is contained in the
  GlobalInfo record, it's up to YOU to provide usable values!

|--------------------------------------------------------------------------}
{$Define UseMultiLanguage}  {Turn multilang. support for logging on/off}


Unit SuperBBS;
Interface
Uses Dos,
     CRT,
{$IfDef UseMultiLanguage}
     Language, { Language support, needed for Logging         }
{$EndIf}
     FileObj,  { Typed file handling object                   }
     Fossil,   { Fossil object, needed for online msgs.       }
     GlobInfo; { The globale info. Thisone needs to be filled }

Const  SBBS = 2; { This is a unike BBS tag to indentify the current  }
                 { BBS in the global info. Make tags for other BBSes }
                 { Also unique. At least for your own programs!      }


Var   SBBSPath : ComStr;


Type  SBBSMsgToIdxRecord = String[35];
      SBBSFlagType       = Array[1..4] of Byte;

      SBBSLineIdxRec     = Record
                            User        : SBBSMsgToIdxRecord;
                            Attribute   : Byte;
                            Status      : Byte;
                            Baud        : Word;
                            City        : String[25];
                            ExtraSpace  : Array[1..10] of byte;
                           End;

(*  Attribute :

     Bit 0 = Line in use
         1 = Do not disturb mode

    Status (Not bit-mapped) :

     Nr  0 = Doing nothing
         1 = Downloading file(s)
         2 = Uploading file(s)
         3 = Reading messages
         4 = Entering message (also onlinemsg)
         5 = Chatting with SysOp
         6 = Using external program, etc...
         7 = Logging on

*)

  SBBSNameIdx = Record
                  Name            : SBBSMsgToIdxRecord;
                  Alias           : SBBSMsgToIdxRecord;
                  UserRecPtr      : Integer;
                  ExtraUserRecPtr : Integer;
                  ExtraSpace      : Array[1..4] of byte;
                End;

  SBBSUserRecord = Record                                 (*  USERS.BBS   *)
                     Name             : SBBSMsgToIdxRecord;
                     City             : String[25];
                     Password         : String[15];
                     DataPhone        : String[12];
                     HomePhone        : String[12];
                     LastTime         : String[5];
                     LastDate         : String[8];
                     Attrib           : Byte;
                     Flags            : SBBSFlagType;
                     Credit           : Integer;
                     Pending          : Integer;
                     MsgsPosted       : Word;
                     HighMsgRead      : Word;
                     SecLvl           : Word;
                     Times            : Word;
                     Ups              : Word;
                     Downs            : Word;
                     UpK              : Word;
                     DownK            : Word;
                     TodayK           : Integer;
                     Elapsed          : Integer;
                     Len              : Integer;
                     ExtraSpace1      : Array[1..2] of byte;
                     Age              : Byte;
                     ExtraUserRecPtr  : Integer;
                     ExtraSpace2      : Array[1..3] of Byte;
                   End;

    (*  Attrib:

          bit 0: Deleted user
          bit 1: Screen clear codes
          bit 2: More prompt
          bit 3: ANSI graphics
          bit 4: No-Kill
          bit 5: Ignore Download Hours
          bit 6: ANSI editor
          bit 7: Do not disturb mode ON

    *)

  SBBSExtraUserRec=Record                                 (*  SUSERS.BBS  *)
                     Name              : SBBSMsgToIdxRecord;
                     Birthday          : String[8];
                     Attrib            : Word;
                     Flags             : Array[1..4] of Byte; { Not yet used }
                     Firsttime         : String[5];
                     FirstDate         : String[8];
                     CombinedBoards    : Array[1..25]  of Byte;
                     SysOpComment      : String[79];
                     DefaultProto      : Char;                { Not yet used }
                     UserRecPtr        : Integer;
                     Colors            : Array[1..10] of byte;
                     FileListType      : Byte;                { Not yet used }
                     Alias             : SBBSMsgToIdxRecord;
                     MinutesUsed       : Longint;
                     ViewFileName      : String[12]; { SeeAlso attrib bits 4 - 6 }
                     MenuToRun         : String[8];
                     Timeinbank        : Word;
                     TodayCalls        : Byte;
                     LanguageFileN     : String[8];  { *.LNG }
                     ExtraSpace        : Array[1..425] of Byte;
                   End;

(*  Attrib:

      Bit  0: MailCheck at logon
      Bit  1: Newfiles Check at logon
      Bit  2: No downloadratio
      Bit  3: Female
      Bit  4: Delete file after viewing
      Bit  5: Display file only once
      Bit  6: File viewed
      Bit  7: Fullscreen viewer
      Bit  8:
      Bit  9:
      Bit 10:
      Bit 11:
      Bit 12:
      Bit 13:
      Bit 14:
      Bit 15:
*)

    SBBSNetAddress = Record
                       Zone   : Word;
                       Net    : Word;
                       Node   : Word;
                       Point  : Word;
                     End;

    SBBSSysInfoRecord = Record                           (* SYSINFO.BBS  *)
                          CallCount  : LongInt;
                          LastCaller : SBBSMsgToIdxRecord;
                          ExtraSpace : Array[1..128] of Byte;
                        End;

    SBBSTimeLogRecord = Record                              (* TIMELOG.BBS  *)
                          StartDate   : String[8];
                          BusyPerHour : Array[0..23] of Integer;
                          BusyPerDay  : Array[0..6] of Integer;
                        End;


    SBBSEventRecord = Record
                        Status      : Byte; { 0=Disabled 1=Enabled }
                        RunTime     : String[5];
                        ErrorLevel  : Byte;
                        Days        : Byte;
                        Forced      : Boolean;
                        LastTimeRun : String[8];
                      End;

    SBBSBoardRecord = Record
                        Name:         String[16];
                        Typ         : Byte; { 0=Standard 1=Net 3=Echo }
                        Kinds       : Byte; { 0=Private & Public
                                              1=Private 2=Public 3=Read-Only }
                        Combined    : Boolean;
                        Aliases     : Boolean;

                        ReadSecLvl  : Integer;
                        ReadFlags   : SBBSFlagType;

                        WriteSecLvl : Integer;
                        WriteFlags  : SBBSFlagType;

                        SysopSecLvl : Integer;
                        SysopFlags  : SBBSFlagType;
                      End;

     SBBSConfigRecord = Record
                          CommPort       : Integer;
                          InitBaud       : Word;
                          InitTimes      : Word;
                          AnswerWait     : Word;
                          ModemInitStr   : String[70];
                          ModemBusyStr   : String[70];
                          ModemInitResp  : String[40];
                          ModemBusyResp  : String[40];
                          Resp300        : String[40];
                          Resp1200       : String[40];
                          Resp2400       : String[40];

                          MenuPath       : String[66];
                          TextPath       : String[66];
                          NetPath        : String[66];

                          MinBaud        : Integer;
                          GraphicsBaud   : Integer;
                          XferBaud       : Integer;
                          LowBaudStart   : String[5];
                          LowBaudEnd     : String[5];
                          DownloadStart  : String[5];
                          DownloadEnd    : String[5];
                          PagingStart    : String[5];
                          PagingEnd      : String[5];

                          MatrixZone     : Integer;
                          MatrixNet      : Integer;
                          MatrixNode     : Integer;
                          AkaNet         : Array[1..5] of Integer;
                          AkaNode        : Array[1..5] of Integer;
                          NetMailBoard   : Integer;

                          DefaultSec     : Integer;
                          DefaultCredit  : Integer;
                          DefaultFlags   : SBBSFlagType;

                          EditorCmdStr   : String[70];
                          OriginLine     : String[60];
                          SysopName      : SBBSMsgToIdxRecord;
                          AutoLogonChar  : Boolean;
                          FastLogon      : Boolean;
                          ScreenBlanking : Boolean;
                          UseLastRead    : Boolean;
                          MonoMode       : Boolean;
                          DirectWrite    : Boolean;
                          SnowCheck      : Boolean;
                          NetEchoExit    : Boolean;
                          OneWordNames   : Boolean;
                          CheckMail      : Boolean;
                          AskHomePhone   : Boolean;
                          AskDataPhone   : Boolean;
                          GraphicsAvail  : Boolean;
                          InactiveTimeOut: Integer;
                          LogonTime      : Integer;
                          DefFgColor     : Integer;
                          DefBgColor     : Integer;
                          PasswordTries  : Integer;
                          MaxPageTimes   : Integer;
                          PageBellLen    : Integer;

                          Use_Xmodem     : Boolean;
                          Use_Xmodem1k   : Boolean;
                          Use_Ymodem     : Boolean;
                          Use_YmodemG    : Boolean;
                          Use_Sealink    : Boolean;
                          Use_Zmodem     : Boolean;
                          Inp_Fields     : Boolean;
                          QuoteStr       : String[3];
                          UploadCredit   : Integer;
                          LoadingMessage : String[70];
                          SelectionPrompt: String[70];

                          VersionID      : Word;
                          Resp4800       : String[40];
                          Resp9600       : String[40];

                          AkaZone        : Array[1..5] of Integer;

                          MatrixPoint    : Integer;
                          AkaPoint       : Array[1..5] of Integer;

                          UseAka         : Array[1..200] of Byte;
                          AskAge         : Boolean;         { Not used }
                          SystemName     : String[40];
                          RegKey         : Longint;

                          EntryfieldColor: Byte;
                          MenuBorderColor: Byte;

                          SysOpSeclvl    : Integer;
                          AllowDelMsgs   : Boolean;

                          EventRec       : Array[1..30] of SBBSEventRecord;
                          BoardRec       : Array[1..200] of SBBSBoardRecord;
                        End;

  SBBSExtraConfig = Record
                      SystemPath         : String[66];
                      MsgBasePath        : String[66];
                      TempPath           : String[66];
                      RedirectDevice     : String[12];
                      Resp19200          : String[40];
                      Resp38400          : String[40];
                      ShowSecurity       : Boolean;
                      ShowPswdAtLogon    : Boolean;
                      BetaCode           : Longint;
                      DefaultBoard       : Array[1..200] of boolean;
                      Empty1             : Array[1..284] of byte;
                      AllowCat           : Boolean;
                      Answerboard        : Byte;
                      Use7bitChars       : Boolean;
                      BufferSize         : Word;
                      Empty2             : Array[1..45] of byte;
                      EntryColor         : Byte;
                      FilesBeforeRatio   : Byte;
                      MinSpace           : Word;
                      ClearTemp          : Boolean;
                      Empty3             : Array[1..163] of byte;
                      UseAliasSystem     : Boolean;
                      Ansilogon          : Byte; {0 = No,1 = Yes,2 = Auto detect}
                      ExcludeSysOp       : Boolean;
                      Empty4             : Array[1..122] of byte;
                      AltFkeys           : Array[1..10] of string[60];
                      Checkfiles         : Boolean;
                      PasswordBoard      : Byte;
                      Alt_J_Swaptoems    : Boolean;
                      MaxTimeInBank      : Word;
                      NoBirthDayAsk      : Boolean;
                      MaxDescLines       : Byte;
                      Empty5             : Array[1..45] of byte;
                      FastMailCheck      : Boolean;
                      DefaultColors      : Array[1..10] of byte;
                      Empty6             : Array[1..45] of byte;
                      LinesInSystem      : Byte;
                      CommonDir          : String[79];
                      VersionNumber      : Word;
                      FullScrChatBaud    : Word;
                      PressEnterColor    : Byte;
                      AreaSelectColor    : Array[1..3] of byte;
                      StatusLineColor    : Byte;
                      VirusChkMode       : Byte;
                      WorkPath           : String[79];
                      WatchCDatDos       : Boolean;
                      UseCtrlX           : Boolean;
                      MsgAfterPageBoard  : Byte;
                      SearchAliases      : Boolean;
                      EchoConvert        : Boolean;
                      Extraspace         : Array[1..3765] of Byte;
                    End;

  SBBSGosubDataType = Array[1..20] of String[8];

  SBBSExitRecord = Record
                     BaudRate            : Word;
                     SysInfo             : SBBSSysInfoRecord;
                     TimeLogInfo         : SBBSTimeLogRecord;
                     UserInfo            : SBBSUserRecord;
                     EventInfo           : SBBSEventRecord;
                     NetMailEntered      : Boolean;
                     EchoMailEntered     : Boolean;
                     LoginTime           : String[5];
                     LoginDate           : String[8];
                     TmLimit             : Integer;
                     LoginSec            : LongInt;
                     Credit              : LongInt;
                     UserRecNum          : Integer;
                     ReadThru            : Integer;
                     PageTimes           : Integer;
                     DownLimit           : Integer;
                     WantChat            : Boolean;
                     GosubLevel          : Byte;
                     GosubData           : SBBSGosubDataType;
                     Menu                : String[8];
                   End;


{--------------------------------------------------------------------------|
  Variables which contain the CONFIG and the EXITINFO.BBS info. Note
  that I included SBBS in the variable name to avoid conflicts with the names
  of other BBS's their configuration files.
|--------------------------------------------------------------------------}

Var SBBSExitInfo  : SBBSExitRecord;
    SBBSConfig    : SBBSConfigRecord;
    SBBSEConfig   : SBBSExtraConfig;
    SBBSEUser     : SBBSExtraUserRec;

{--------------------------------------------------------------------------|
  And the procedures to read and write the configuration info.

  InitSBBS should be called once at the start of your program to initialize
           your door for RemoteAccess.

  UpdateExitInfo
         Rewrites the EXITINFO.BBS Record. To avoid problems with newer
         version of SBBS, which probably add fields to this file, only
         as much bytes are read and written as the size of the record
         defined in this unit. As long as the file is upward compatible
         this should avoid conflicts.
         The function returns false if it wasn't able to write the info.

         The users TimeLimit and Security are always updated while writing,
         Other field you have to change for yourself.

|--------------------------------------------------------------------------}


Procedure InitSBBS;
Function SBBSUpdateExitInfo:Boolean;

Implementation
Uses LowLevel; { To avoid a circular reference error }

Const UseLog : Boolean = False; { Is set to TRUE as soon as a LogProcedure }
                                { is installed                             }

Const Months : Array[1..12] Of String[3] =
      ('Jan','Feb','Mar','Apr','May','Jun',
       'Jul','Aug','Sep','Oct','Nov','Dec');


{$F+}
Procedure SBBSLogIt(LogLine  : MaxlogStr);
{$F-}

Var Log    : Text;
    temp   : Integer;
    Hour   : Word;
    Minute : Word;
    Second : Word;
    Year   : Word;
    Month  : Word;
    Day    : Word;
    Dum    : Word;

Begin
If Not UseLog
   Then Exit;
{$IfDef UseMultiLanguage}
  LogLine:=ExpandString(LogLine);
{$EndIf}
GetTime(Hour,Minute,Second,Dum);
GetDate(Year,Month,Day,Dum);

LogLine:= SF(Day,2)+'-'+
          Months[Month]+'-'+
          SF(Year-1900,2)+' '+

          SF(Hour,2)+':'+
          SF(Minute,2)+'  '+
          LogLine;


FileMode:=ReadWrite+ShareDenyNone;
Assign(Log,GlobalInfo.LogFileName);
Append(Log);
If IoResult<>0
   Then Rewrite(Log);
WriteLn(Log,LogLine);
Close(Log);
If IoResult<>0
   Then Begin
        WriteLn(#254#7#7#7' Can''t LOG anymore !!!');
        UseLog:=False;
        End;
End;

{----------------------------------------------------------------------------|
 Read config function
|----------------------------------------------------------------------------}


Function ReadSBBSConfig:Boolean;
Var Conf : FileObject;
    EConf: FileObject;
    Size : Word;

Begin
ReadSBBSConfig:=False;

FillChar(SBBSConfig,SizeOf(SBBSConfig),#00);
FillChar(SBBSEConfig,SizeOf(SBBSEConfig),#00);


Conf.Open('CONFIG.BBS',1,ReadOnly+ShareDenyNone);
If Conf.Error<>0
   Then Begin
        Conf.Open(SBBSPath+'CONFIG.BBS',1,ReadOnly+ShareDenyNone);
        EConf.Open(SBBSPath+'SCONFIG.BBS',1,ReadOnly+ShareDenyNone);
        If (Conf.Error<>0) Or
           (EConf.Error<>0)
           Then Begin
                Conf.Close;
                EConf.Close;
                Exit;
                End;
        End
   Else Begin
        EConf.Open('SCONFIG.BBS',1,ReadOnly+ShareDenyNone);
        If EConf.Error<>0
           Then Begin
                Conf.Close;
                Exit;
                End;
        End;

Size:=SizeOf(SBBSConfig);
Conf.ReadBuffer(SBBSConfig,Size);

Size:=SizeOf(SBBSEConfig);
EConf.ReadBuffer(SBBSEConfig,Size);

Conf.Close;
EConf.Close;

With GlobalInfo Do
 Begin
 BBStag  := SBBS;
 BBSName := 'SuperBBS v.'+S(Hi(SBBSEConfig.VersionNumber),0)+'.'+
                          SF(Lo(SBBSEConfig.VersionNumber),2);

 OnlineStatus:=Normal;
 SystemStatus:=S_OK;

 LogfileName   := 'SYSTEM.LOG';
 LogType       := 0;
 LogIt := SbbsLogIt;

 UseLog        := True;
 TimeOutTime   := SBBSConfig.InactiveTimeout;
 Warnings      := 2; { My constante! }


 UserFilePath  := SBBSEConfig.MsgBasePath;
 CompletePath(UserFilePath);
 CommonDir     := SBBSEConfig.CommonDir;
 CompletePath(CommonDir);

 LeftBracket   := '[';
 RightBracket  := ']';

 SysopName     := SBBSConfig.SysOpName;
 SystemName    := SBBSConfig.SystemName;
 SystemLocation:= '* Unknown *';

 LocalMono     := SBBSConfig.MonoMode;

 If ExistParameter('P:')
    Then ComPort:=Str2Nr(GrabParameter('P:'))
    Else ComPort := SBBSConfig.CommPort;

 MultiLine     := SBBSEConfig.LinesInSystem>1;
 End; {With}

{---- To make sure the major paths are all nice and complete... ---------}

CompletePath(SBBSConfig.MenuPath);
CompletePath(SBBSConfig.TextPath);
CompletePath(SBBSConfig.NetPath);
CompletePath(SBBSEConfig.MsgBasePath);
CompletePath(SBBSEConfig.SystemPath);

ReadSBBSConfig  := True;
End;



{---- ExitInfo.bbs procedures -----------------------------------------}

{
 If you want to use the update exitinfo, you have to tell the sysop to
 provide the *E parameter on the commandline. Otherwise SBBS doesn't read
 the ExitInfo on return from a door..
}

{----------------------------------------------------------------------------|
 Update ExitInfo function
|----------------------------------------------------------------------------}


Function SBBSUpdateExitInfo:Boolean;
Var Info : FileObject;
    Size : Word;
Begin
SBBSUpdateExitInfo:=False;

If GlobalInfo.MultiLine
   Then Info.Open('EXITINFO.BBS',1,ReadWrite+ShareDenyNone)
   Else Info.Open(GlobalInfo.SystemPath+'EXITINFO.BBS',1,ReadWrite+ShareDenyNone);

If Info.Error <> 0
   Then Exit;

Size:=SizeOf(SBBSExitInfo);

SBBSExitInfo.UserInfo.SecLvl:=GlobalInfo.UserSecurity;
SBBSExitInfo.TmLimit:=GlobalInfo.MinRemaining;

Info.GotoRecord(0);
Info.WriteBuffer(SBBSExitInfo,Size);
Info.Close;

SBBSUpdateExitInfo:=Info.Error=0;
End;

{----------------------------------------------------------------------------|
 Read ExitInfo function
|----------------------------------------------------------------------------}

Function ReadExitInfo:Boolean;
Var Info : FileObject;
    Size : Word;

Begin
ReadExitInfo:=False;
FillChar(SBBSExitInfo,SizeOf(SBBSExitInfo),#00);

If GlobalInfo.MultiLine
   Then Info.Open('EXITINFO.BBS',1,ReadOnly+ShareDenyNone)
   Else Info.Open(GlobalInfo.SystemPath+'EXITINFO.BBS',1,ReadOnly+ShareDenyNone);

If Info.Error <> 0
   Then Begin
        LogIt('ExitInfo.bbs not found!');
        Exit;
        End;

Size:=SizeOf(SBBSExitInfo);
Info.ReadBuffer(SBBSExitInfo,Size);
Info.Close;

Size := SizeOf(SBBSEUser);
Info.Open(GlobalInfo.SystemPath+'SUsers.bbs',1,ReadOnly+ShareDenyNone);

If Info.Error<>0
   Then Begin
        LogIt('SUSER.BBS not found!');
        Exit;
        End;
Info.GotoRecord(SBBSExitInfo.UserInfo.ExtraUserRecPtr*Size);
Info.ReadBuffer(SBBSEUser,Size);
Info.Close;

With GlobalInfo Do
 Begin
 ScreenLength := SBBSExitInfo.UserInfo.Len;
 ScreenWidth  := 80;

 UserName     := SBBSExitInfo.UserInfo.Name;
 UserHandle   := SBBSEUser.Alias;
 UserAge      := SBBSExitInfo.UserInfo.Age;
 UserBirthDay := SBBSEUser.BirthDay;
 UserGroup    := 1;

 If UserHandle=''
    Then UserHandle:=SBBSExitInfo.UserInfo.Name;

 UserLocation := SBBSExitInfo.UserInfo.City;
 UserSecurity := SBBSExitInfo.UserInfo.SecLvl;

 UseGraphics  := (SBBSExitInfo.UserInfo.Attrib  And $08 ) = $08;
 UseAVATAR    := False; { Not in SBBS }
 UseMoreYN    := (SBBSExitInfo.UserInfo.Attrib  And $04 ) = $04;
 UseClrScr    := (SBBSExitInfo.UserInfo.Attrib  And $02 ) = $02;
 UseQuietMode := (SBBSExitInfo.UserInfo.Attrib  And $80 ) = $80;
 BaudRate     := SBBSExitInfo.BaudRate;
 MinRemaining := SBBSExitInfo.TmLimit;
 TimeLimit    := SBBSExitInfo.TmLimit;
 End; {With}

GlobalInfo.IEMSI.Session:= False;


ReadExitInfo:= True;
End;



{--------------------------------------------------------------------------|
  INITSBBS:

  Read the SBBS configuration files (CONFIG.RA and EXITINFO.BBS) and fill
  and check for the standard commandline parameters.

  -T:<Time>     Maximal time in this door, overrules the EXITINFO.BBS setting
                The time has to be given in minutes. Mostly here for
                compatability with RAdoor 2.3
  -N:<Node>     Node number, there's no other way under SBBS.
                Defaults to node 1
  -P:<CommPort> Overrules the CONFIG.BBS Comport setting. Usefull for multiline
                Systems.
  -NOS          Turns off local noise for default.

  Further the GlobalInfo variables SystemPath and HomeDir are filled:

  SystemPath    Path to the SBBS system directory. The environment variable
                SBBS= has to be there.

  HomeDir       The directory from where the door was fired up. I usual
                use this directory to look for auxilary files. The homedir
                is found by stripping the filename of ParamStr(0). The user
                can ALWAYS overrule this value by setting an environment
                variable <PROGNAME> with an other path. PROGNAME is the REAL
                name of the program (the EXE file) minus the path and the
                extention!

|--------------------------------------------------------------------------}



Procedure InitSBBS;

Var ProgName : String[8];
    Dum      : String[4];
    TTime    : Word;
Begin
SBBSPath:=GetEnv('SBBS');
CompletePath(SBBSPath);
GlobalInfo.SystemPath:=SBBSPath;


FSplit(ParamStr(0),GlobalInfo.HomeDir,ProgName,Dum);
If GetEnv(ProgName)<>''
   Then GlobalInfo.HomeDir:=GetEnv(ProgName);
If GlobalInfo.HomeDir<>''
   Then CompletePath(GlobalInfo.HomeDir);


GlobalInfo.Node:=Str2Nr(GrabParameter('N:'));
If GlobalInfo.Node=0
   Then GlobalInfo.Node:=1;

If Not ReadSBBSConfig
   Then Begin
        WriteLn(#254' Couldn''t read SBBS CONFIG info !');
        Halt;
        End;


If Not ReadExitInfo
   Then Begin
        WriteLn(#254' Couldn''t read EXITINFO.BBS!');
        Halt;
        End;

If ExistParameter('T:')
   Then Begin
        TTime:=Str2Nr(GrabParameter('T:'));
        If TTime<=GlobalInfo.MinRemaining
           Then GlobalInfo.MinRemaining:=TTime;
        End;

GlobalInfo.Language:=SBBSEUser.LanguageFileN;
If GlobalInfo.Language=''
   Then GlobalInfo.Language:='ENG';

If ExistParameter('NOS')
   Then GlobalInfo.LocalNoise:=False;

End;

End.
