{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
{---------------------------------------------------------------------------|

 Description

  This unit defines the procedures for handling the statusline and
  the sysop keys. The statusline is a simple one-liner because I
  prefer to see things the user sees them.. But if you prefer a two or
  more lines, be my guest and change it here..;)

|-------------------------------------------------------------------------}

Unit UserHook;
Interface
Uses Dos,
     Crt,
     KeyDefs,   { Keyboard definitions       }
     GlobInfo;  { Global information record  }

{---------------------------------------------------------------------------|
  StatusLine handles a 4 levels statusline and is easy to maintain to
             provide more info if needed. Just add an other level to the
             statusline and the SysOpKeys procedure.

  SysOpKeys  accepts an extended keycode (as defined in the KeyDefs unit)
             and does whatever it takes to accomplish the requested task.
             Note that I use the Control-PgUp and Control-PgDn keys here
             for incrementing and decrementing the users time. I didn't
             have the urge to keep things RA compatible and this way I
             avoid problems with the SmartReadKey function in the fossil
             unit.

 SetStatLineStatus  Sets a default statusline.
|-------------------------------------------------------------------------}

Procedure StatusLine;
Procedure SysopKeys(Key : Char);
Procedure SetStatLineStatus(Stat : Byte);

Implementation
Uses RA;

{ I know this isn't the most foolproof methode of hiding the cursor.. }

Procedure Cursor_On;
Var regs : Registers;
Begin
Regs.Ah:=$01;
Regs.Ch:=$06;
Regs.Cl:=$07;
Intr($10,Regs);
End;

Procedure Cursor_Off;
Var regs : Registers;
Begin
Regs.Ah:=$01;
Regs.Ch:=$16;
Regs.Cl:=$0;
Intr($10,Regs);
End;

Var OldMin         : Word;
    StatLineStatus : Byte;

Procedure StatusLine;
Var Mx,My,Mc : Byte;
Begin
If GlobalInfo.MinRemaining=OldMin
   Then Exit;

Cursor_Off; { Gives a more quiet screen }

OldMin:=GlobalInfo.MinRemaining;

Mx:=CRT.WhereX;
MY:=CRT.WhereY;
MC:=CRT.TextAttr;

CRT.Window(1,1,80,25);
CRT.GotoXy(1,25);
CRT.TextAttr:=$70;

Case StatLineStatus Of
   1 : Begin
       With GlobalInfo Do
        Begin
        Write(' ',UserName,'':35-Length(UserName),
              '  Sec: ',UserSecurity:5,
              '  Time left: ',MinRemaining:3);
        End;
       End;
   2 : Begin
       With GlobalInfo Do
        Begin
        Write(' Sound ');
        If LocalNoise
           Then Write('[',#14,']')
           Else Write('[-]');
        Write('  Multiline ');
        If MultiLine
           Then Write('[*]')
           Else Write('[-]');
        Write('  DesqView ');
        If DesqView
           Then Write('[*]')
           Else Write('[-]');
        Write('  WarnSysop ');
        If OnlineStatus=WarnOnLeaving
           Then Write('[W]')
           Else Write('[-]');
        End; {With}
       End;
   3 : Write(' ALT: H - hangup, L - LockOut, W - WarnSysop');
   4 : Write(' CTRL: PgUp/PgDn - Inc/Dec time');
   5 : Begin
       If GlobalInfo.IEMSI.Session
          Then Write(' IEMSI: ',GlobalInfo.IEMSI.Software)
          Else Begin
               If GlobalInfo.BBSTag=1
                  Then Write(' IEMSI: Not used')
                  Else Write(' IEMSI: Not supported on this system.');
               End;
       End;
   6 : Begin
       With GlobalInfo Do
        Write(' AKA: ',UserHandle,'':35-Length(UserHandle));
       End;
   7 : Begin
       With GlobalInfo Do
        Begin
        Write(' Birthday: ',UserBirthday);
        If UserAge>0
           Then Write('  Age: ',UserAge:2)
           Else Write('  Age: UnKnown');
        End;
       End;
   9 : Write(' F1 - UserInfo, F2 - SystInfo, F3 - ALT-Keys, F4 - CTRL-keys');
  10 : Write(' F5 - IEMSI  F6 - Handle  F7 - Age/Birthday');
End; {Case}

If StatLineStatus<>99
   Then Begin
        Write('F9/F10 - Help':80-WhereX);
        CRT.ClrEol;
        CRT.Window(1,1,80,24);
        End;
CRT.TextAttr:=Mc;
CRT.GotoXy(Mx,My);
Cursor_On;
End;

Procedure SysopKeys(Key : Char);
Begin
Case Key Of
 SF1    : StatLineStatus:=99;
 F1     : StatLineStatus:=1;
 F2     : StatLineStatus:=2;
 F3     : StatLineStatus:=3;
 F4     : StatLineStatus:=4;
 F5     : StatlineStatus:=5;
 F6     : StatLineStatus:=6;
 F7     : StatLineStatus:=7;
 F9     : StatLineStatus:=9;
 F10    : StatlineStatus:=10;
 ALTS   : Begin
          GlobalInfo.LocalNoise   := Not GlobalInfo.localNoise;
          StatLineStatus:=2;
          End;
 ALTH   : GlobalInfo.OnlineStatus := HangUpLine;
 ALTL   : GlobalInfo.OnlineStatus := LockOutUser;
 ALTW   : Begin
          If GlobalInfo.OnlineStatus = WarnOnLeaving
             Then GlobalInfo.OnLineStatus := Normal
             Else GlobalInfo.OnLineStatus := WarnOnLeaving;
          StatLineStatus:=2;
          End;
 CPgUpK : Begin
          Inc(GlobalInfo.MinRemaining);
          StatLineStatus:=1;
          End;
 CPgDnK : Begin
          Dec(GlobalInfo.MinRemaining);
          StatLineStatus:=1;
          End;
End;
OldMin:=61;
End;

Procedure SetStatLineStatus(Stat : Byte);
Begin
StatLineStatus:=Stat;
End;

Begin
OldMin:=61;
StatLineStatus:=1;
End.
