{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}


{A+,B-,D-,E-,F-,I-,L-,N-,O-,R-,S+,V-}
{$M 10000,0,640000}

Program langCompiler;
Uses Dos,
     LowLevel;

Const MaxSentence = 500;

Type SentencePtr    = ^SentenceRecord;
     SentenceRecord = Record
                        Nr    : Word;
                        Line  : String;
                       End;

     Sentences      = Array[1..MaxSentence] of SentencePtr;

     SpecialRecord  = Record
                       FileId    : Array[1..32] Of Char;
                       VersionNr : Word;
                       ProgName  : String[8];
                       LanguageID: String[3];           { ENG/NL     }
                       YesDef    : Char;                { Y          }
                       NoDef     : Char;                { N          }
                       StopDef   : Char;                { S          }
                       YesNorm   : Char;                { y          }
                       NoNorm    : Char;                { n          }
                       StopNorm  : Char;                { s          }
                       BrackRgt  : Char;                { [          }
                       BrackLft  : Char;                { ]          }
                       ENTER     : String[10];          { ENTER      }
                       Colors    : Array[0..9] Of Byte; { Colortable }
                       Entries   : Word;
                      End;

     IndexEntryRec  = Record
                       Nr    : Word;
                       Start : Word;
                       Len   : Byte;
                      End;




Type KeyStr   = String[10];
     KeyWords = ( K_LangID    , K_ProgName ,
                  K_BrackRight, K_BrackLeft,
                  K_YesDef    , K_NoDef    , K_StopDef  ,
                  K_YesNorm   , K_NoNorm   , K_StopNorm ,
                  K_Enter     , K_Color,
                  K_End
                );

Const KeyStrings : Array[K_LangId..Pred(K_End)] of KeyStr =
                   (
                   'LANGID'     , 'PROGNAME'  ,
                   'BRACKRIGHT' , 'BRACKLEFT' ,
                   'YESDEF'     , 'NODEF'     , 'STOPDEF' ,
                   'YESNORM'    , 'NONORM'    , 'STOPNORM',
                   'ENTER'      , 'COLOR'
                   );

Function FindKey(Key : KeyStr):KeyWords;
Var Temp : KeyWords;
Begin
Temp:=K_LangID;
While (Temp<K_End) And (KeyStrings[Temp]<>Key) Do
 Temp:=Succ(Temp);
FindKey:=Temp;
End;




Var Lines    : Sentences;
    Special  : SpecialRecord;
    Search   : SearchRec;

Procedure InitArray;
Var Count : Word;
Begin
For Count:=1 To MaxSentence Do
 Lines[Count]:=NIL;
End;

Procedure DisposeArray;
Var Count : Word;
Begin
For Count:=1 To MaxSentence Do
 If Lines[Count]<>NIL
    Then Dispose(Lines[Count]);
End;
Function CheckLine(Var S : String;Nr : Word):Boolean;
Var Count : Byte;
Begin
CheckLine:=False;
Count:=1;
While Count<=Length(S) Do
 Begin
 If S[Count] In ['%','^']
   Then Begin
        If ((Count+1)>Length(S))
           Then Begin
                WriteLn(#254' Missing argument in line #',Nr);
                WriteLn(S);
                WriteLn('':Count,'^');
                Exit;
                End;
        Case S[Count] of
         '^' : Begin
               If Not (S[Count+1] In ['0'..'9'])
                  Then Begin
                       WriteLn(#254' Illegal colornumber in line #',Nr);
                       WriteLn(S);
                       WriteLn('':Count,'^');
                       Exit;
                       End;
               End;
         '%' : Begin
               If Not (Upcase(S[Count+1]) in ['Y','N','S','R','L','E'])
                  Then Begin
                       WriteLn(#254' Unknown indentifier in line #',Nr);
                       WriteLn(S);
                       WriteLn('':count,'^');
                       Exit;
                       End
                  Else Begin
                       If S[Count+1] in ['r','l','e']
                          then S[Count+1]:=Upcase(S[Count+1]);
                       End;
               End;
        End; {Case}
        Inc(Count,1);
        End; {If}
 Inc(Count);
 End; {While}
CheckLine:=True;
End;




Procedure ReadLanguageFile(FileName : PathStr);
Var LFile : Text;
    Line  : String;
    LineNr: Word;
    ColNr : Byte;
    Key   : KeyStr;
    StrNr : Word;

Begin
Assign(LFile,FileName);
Reset(LFile);
If IoResult<>0
   Then Begin
        WriteLn(#254' Couldn''t open '+FileName);
        Halt(1);
        End;

LineNr:=0;
While Not Eof(LFile) Do
 Begin
 ReadLn(LFile,Line);
 Inc(LineNr);
 If (Line<>'') And (Line[1]<>';')
    Then Begin
         Key:=FindToken(Line,' ');
         Key:=UpStr(Key);
         SkipLeadingSpaces(Line);
         While Line[Length(Line)]<>'"' Do
           Dec(Line[0]);
         If (Line[1]<>'"') Or
            (Line[Length(Line)]<>'"')
            Then Begin
                 WriteLn(#254' Missing " in line #',LineNr);
                 Close(LFile);
                 DisposeArray;
                 Halt(1);
                 End;
         Delete(Line,1,1);
         Dec(Line[0]);

         Case FindKey(Key) Of
           K_LangId      : Begin
                           Line:=UpStr(Line);
                           Special.LanguageID:=Line;
                           End;
           K_ProgName    : Begin
                           Line:=UpStr(Line);
                           Special.ProgName:=Line;
                           End;
           K_YesDef      : Special.YesDef:=Line[1];
           K_NoDef       : Special.NoDef:=Line[1];
           K_Stopdef     : Special.StopDef:=Line[1];
           K_YesNorm     : Special.YesNorm:=Line[1];
           K_NoNorm      : Special.NoNorm:=Line[1];
           K_StopNorm    : Special.StopNorm:=Line[1];
           K_BrackRight  : Special.BrackRgt:=Line[1];
           K_BrackLeft   : Special.BrackLft:=Line[1];
           K_Enter       : Special.Enter:=Line;
           K_Color       : Begin
                           ColNr:=Str2Nr(FindToken(Line,','));
                           If ColNr>9
                              Then Begin
                                   WriteLn(#254' Illegal color number in line #',LineNr);
                                   Close(LFile);
                                   DisposeArray;
                                   Halt(1);
                                   End;
                           Special.Colors[ColNr]:=Str2Nr(Line);
                           End;
           K_End         : Begin
                           If Key[1]<>']'
                              Then Begin
                                   WriteLn(#254' Unrecognised info on line #',LineNr);
                                   Close(LFile);
                                   DisposeArray;
                                   Halt(1);
                                   End;
                           Delete(Key,1,1);
                           StrNr:=Str2Nr(Key);
                           If (StrNr=0) Or (StrNr>MaxSentence)
                              Then Begin
                                   WriteLn(#254' Illegal StringTag in line #',LineNr);
                                   Close(LFile);
                                   DisposeArray;
                                   Halt(1);
                                   End;
                           New(Lines[StrNr]);
                           If Not CheckLine(Line,LineNr)
                              Then Begin
                                   Close(LFile);
                                   DisposeArray;
                                   Halt(1);
                                   End;
                           Lines[StrNr]^.Nr:=StrNr;
                           Lines[StrNr]^.Line:=Line;
                           Inc(Special.Entries);
                           End;
         End; {Case}
         End; {If}
 End; {While}
Close(LFile);
End;



Procedure WriteLanguageFile(FileName : PathStr);
Var Out   : File;
    Idx   : IndexEntryRec;
    Entry : Word;
    Count : Word;
    Start : Word;

Begin
Assign(Out,FileName);
Rewrite(Out,1);
If IoResult<>0
   Then Begin
        WriteLn(#254' Couldn''t write languagefile.');
        DisposeArray;
        Halt(1);
        End;

BlockWrite(Out,Special,SizeOf(Special));
If IoResult<>0
   Then Begin
        WriteLn(#254' Error writing language header.');
        DisposeArray;
        Close(Out);
        Halt(1);
        End;

FillChar(IDX,SizeOf(Idx),#00);
For Count:=1 To MaxSentence Do
 Begin
 If Lines[Count]<>NIL
    Then Begin
         BlockWrite(Out,IDX,SizeOf(IDX));
         If IoResult<>0
            Then Begin
                 WriteLn(#254' Error writing index.');
                 DisposeArray;
                 Close(Out);
                 Halt(1);
                 End;
         End;
 End;

Entry:=0;
Start:=FilePos(Out);

For Count:=1 to MaxSentence Do
 Begin
 If Lines[Count]<>NIL
    Then Begin
         IDX.Nr:=Lines[Count]^.Nr;
         IDX.Len:=Length(Lines[Count]^.Line);
         IDX.Start:=FileSize(Out)-Start;

         BlockWrite(Out,Lines[Count]^.Line[1],Length(Lines[Count]^.Line));

         Seek(Out,SizeOf(Special)+(Entry*SizeOf(Idx)));
         BlockWrite(Out,IDX,SizeOf(Idx));
         Seek(Out,FileSize(Out));
         Inc(Entry);
         End;
 End;

Close(Out);
End;




Var FileName    : PathStr;
    Path        : PathStr;
    Dum         : String[10];
    FileID      : String[32];

Begin
WriteLn('LangComp 1.0 (c) LiveSystems 1991,1992 ALL RIGHTS RESERVED, NO GUARANTEES');
WriteLn('Written by G.Hoogterp. E-mail address 2:283/1.2 Last Revision 09 Nov 1991');
WriteLn;
If ParamCount=0
   Then Begin
        WriteLn(#254' Usage:  LangComp <Input FileSpec>');
        WriteLn(#254' The output goes to a file LANGUAGE.<LanguageID>');
        WriteLn(#254' you may use wildcards in the filespec.');
        Halt;
        End;

FileName:=ParamStr(1);
FSplit(FileName,Path,Dum,Dum);

FindFirst(FileName,AnyFile,Search);
While DosError=0 Do
 Begin
 InitArray;
 FillChar(Special,SizeOf(Special),#00);

 FileId:='LiveSystems language file v1.00'^Z;
 Move(FileID[1],Special.FileId,Length(FileID));
 Special.VersionNr:=$0100;

 WriteLn(#254' Reading file ',Search.Name);
 ReadLanguageFile(Path+Search.Name);

 WriteLn(#254' Writing file '+Special.ProgName+'.'+Special.LanguageID);
 WriteLanguageFile(Path+Special.ProgName+'.'+Special.LanguageID);

 DisposeArray;
 FindNext(Search);
 End;

End.
