{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}

{---------------------------------------------------------------------------|

 Description:

 This unit provides the toolbox with a standard output filter. This makes it
 easy to give your programs a nice consistent look and feel...
 Features:

     - HighAscii translation for ASCII users. This way you don't have to
       care about the special language characters and linedrawing symbols.
       This filter translates them into comparible low-ascii.

     - Easy colormapping. Indirect color access through a colortable.
       You define up to 10 color-combination in your program (Just TextAttr
       values) and use ^0..^9 in the output strings. The filter translates
       them into the correct ansi or avatar sequence, or skips them completely
       for ASCII users.
       The ANSI translation is smart, that is, it always sends the shortest
       string needed..

     - You can define the used EscapeCharacter, default the ^ is used, but
       it can be anything, also HighAscii.

     - The filter tries to be smart about and Clear until End Of Line.
       If you put an ^! in your text, it's translated to the ANSI or
       AVATAR ClrEol sequence. For ASCII an #13<79 Spaces>#13 is send.
       This isn't the fasted methode, but as the unit doesn't know where
       on the line it is, it's a failsave methode.. Anyone who knows a
       better way is welcome..


|---------------------------------------------------------------------------}

Unit MLFilter;  { Output filter with multilanguage support }
Interface
Uses Dos,
     LowLevel,
     Language;

{----------------------------------------------------------------------------|
  Color definitions so you don't need the CRT unit for these
|----------------------------------------------------------------------------}

Const Black        = 0;
      Blue         = 1;
      Green        = 2;
      Cyan         = 3;
      Red          = 4;
      Magenta      = 5;
      Brown        = 6;
      LightGray    = 7;
      DarkGray     = 8;
      LightBlue    = 9;
      LightGreen   = 10;
      LightCyan    = 11;
      LightRed     = 12;
      LightMagenta = 13;
      Yellow       = 14;
      White        = 15;
      Blink        = 128;

{---------------------------------------------------------------------------|
  The table for the HighAscii translation.
  Translates diacritical characters and linedrawing symbols plus a few
  special characters. (The #254 which is often used as attention bullet
  into a * f.e.)
|---------------------------------------------------------------------------}

Const TransTable : Array[#128..#255] of Char =
                  (
{128}             'C'  ,'u'  ,'e'  ,'a'  ,'a'  ,'a'  ,'a'  ,'c',
{136}             'e'  ,'e'  ,'e'  ,'i'  ,'i'  ,'i'  ,'A'  ,'A',

{144}             'E'  ,' '  ,' '  ,'o'  ,'o'  ,'o'  ,'u'  ,'u',
{152}             'y'  ,'O'  ,'U'  ,'c'  ,' '  ,'O'  ,' ' ,'f',

{160}             'a'  ,'i'  ,'o'  ,'u'  ,'n'  ,'N'  ,'a'  ,'o',
{168}             '?'  ,' '  ,' '  ,' '  ,' '  ,'i'  ,' '  ,' ',

{176}             ' '  ,' '  ,' '  ,'|'  ,'+'  ,'+'  ,'+'  ,'+',
{184}             '+'  ,'+'  ,'|'  ,'+'  ,'+'  ,'+'  ,'+'  ,'+',

{192}             '+'  ,'+'  ,'+'  ,'+'  ,'-'  ,'+'  ,'+'  ,'+',
{200}             '+'  ,'+'  ,'+'  ,'+'  ,'+'  ,'-'  ,'+'  ,'+',

{208}             '+'  ,'+'  ,'+'  ,'+'  ,'+'  ,'+'  ,'+'  ,'+',
{216}             '+'  ,'+'  ,'+'  ,' '  ,' '  ,' '  ,' '  ,' ',

{224}             'a'  ,'b' ,'g'  ,' '  ,' '  ,' '  ,' '  ,' ',
{232}             ' '  ,' '  ,' '  ,' '  ,' '  ,' '  ,' '  ,' ',

{240}             '='  ,' '  ,' '  ,' '  ,' '  ,' '  ,'/'  ,' ',
{248}             ' '  ,' '  ,' '  ,' '  ,' '  ,' '  ,'*'  ,' '
                  );




{---------------------------------------------------------------------------|
 Colortable for up to 10 TextAttr bytes. Should be more than enough in most
 cases. Can be expanded without to much hassel. Although in my humble opinion
 to many colors makes a program to "busy". Keep it simple..;)

 You should provide the contents of the table in the mainprogram. You can
 use the same colorattributes as for normal CRT usage.
|---------------------------------------------------------------------------}

Const ColorTable   : Array[0..9] Of Byte =
                     (
                       $0F,   { Color 0 }
                       $0F,   { Color 1 }
                       $0F,   { Color 2 }
                       $0F,   { Color 3 }
                       $0F,   { Color 4 }
                       $0F,   { Color 5 }
                       $0F,   { Color 6 }
                       $0F,   { Color 7 }
                       $0F,   { Color 8 }
                       $0F    { Color 9 }
                     );

{---------------------------------------------------------------------------|
  Initialize the filter options.

  Because I liked to keep the filter as standalone as possible you have to
  initialize the filter yourself.

  Grap     Graphics (Use ANSI)  Default OFF
  Avt      AVATAR               Default OFF
  EscChar  Escape character.    Default  ^
|---------------------------------------------------------------------------}

Procedure InitUsedFilter( Grap,
                          Avt     : Boolean;
                          Lang    : PathStr;
                          EscChar : Char
                        );

{---------------------------------------------------------------------------|
 And the filter itself. Note that the header comformes the OutputFilterType
 procedure type definition in the FOSSIL unit, so if you write your own
 filter, it MUST have the same definition:

    Procedure <ProcedureName>(Var <StringName> : String);

 It should be compiled in FAR mode. (When in an units interface section
 this is automaticaly)

|---------------------------------------------------------------------------}


Procedure UsedFilter(Var InStr : String);

Implementation

{---------------------------------------------------------------------------|
  The default values of the filtervariables
|---------------------------------------------------------------------------}

Const EscapeChar   : Char    = '^';
      Graphics     : Boolean = False;
      Avatar       : Boolean = False;


{---------------------------------------------------------------------------|
  The initialization procedure
|---------------------------------------------------------------------------}
Procedure InitUsedFilter( Grap,
                          Avt     : Boolean;
                          Lang    : PathStr;
                          EscChar : Char
                        );
Begin
Graphics:=Grap;
Avatar:=AVT;
If InitLanguageData(Lang)<>0
   Then Begin
        WriteLn(#254' Error reading languagedata!!');
        Halt(1);
        End;
EscapeChar:=EscChar;
End;


{---------------------------------------------------------------------------|
  S  Translates a Word to a string of an given length. (Max. 20 characters)
|---------------------------------------------------------------------------}


Type Str20 = String[20];

Function S(Num : Word;Len : Byte):Str20;
Var Temp : Str20;
Begin
Str(Num:Len,Temp);
S:=Temp;
End;


{---------------------------------------------------------------------------|
  Byte2Ansi translates an TextMode attribute byte into the shortest ANSI
            sequence. This is done by storing the last foreground and
            background colors and only sending something if there are
            changes.
|---------------------------------------------------------------------------}

Var LastFG    : Byte;
    LastBG    : Byte;

Function Byte2Ansi(B : Byte):Str20;
Const AnsiTable : Array[0..7] Of Byte
                = (0,4,2,6,1,5,3,7);

Var FG,BG : Byte;
    Tmp   : Str20;
    Temp  : Byte;

Begin
Tmp:='';

BG:=(B And $70) Shr 4;
FG:=(B and $0F);
If FG<>LastFG
   Then Begin
        Temp:=FG;
        If (FG>7)
           Then Begin
                Dec(FG,8);
                If LastFG<=7
                   Then Tmp:=Tmp+'0;1';
                End
           Else Begin
                If LastFG>7
                   Then Tmp:=Tmp+'0';
                End;
        If (B And $80)=$80
           Then Tmp:=Tmp+';6';
        Tmp:=Tmp+';'+S(AnsiTable[FG]+30,0);
        LastFG:=Temp;
        End;
If BG<>LastBG
   Then Begin
        LastBG:=BG;
        Tmp:=Tmp+';'+S(AnsiTable[BG]+40,0);
        End;

If Tmp[1]=';'
   Then Delete(Tmp,1,1);
If Tmp<>''
   Then Byte2Ansi:=#27'['+Tmp+'m'
   Else Byte2Ansi:='';
End;

{---------------------------------------------------------------------------|
   EmptyLine is the string used to clear the line with an ^! in ASCII mode.

   UsedFilter is the output filter procedure.
|---------------------------------------------------------------------------}

Var EmptyLine : String[80];

Procedure UsedFilter(Var InStr : String);
Var StrCount : Byte;
    TempStr  : String;
    Index    : Byte;
    LangNr   : String[5];
Begin
InStr:=ExpandString(InStr);  { Do the language translation }
TempStr:='';
StrCount:=1;
While StrCount <= Length(InStr) Do
 Begin
 If (InStr[StrCount]=EscapeChar) And
    (StrCount<Length(InStr))
    Then Begin
         Inc(StrCount);
         Case InStr[StrCount] Of
           '!'     : Begin
                     If Graphics Or Avatar
                        Then Begin
                             If AVATAR
                                Then TempStr:=TempStr+^V^G
                                Else TempStr:=TempStr+#27'[K';
                             End
                        Else TempStr:=TempStr+#13+EmptyLine+#13;
                     Inc(StrCount);
                     End;
           '0'..'9': Begin
                     If Graphics Or Avatar
                        Then Begin
                             Index:=Ord(InStr[StrCount])-48;
                             If AVATAR
                                Then TempStr:=TempStr+^V^A+Chr(ColorTable[Index])
                                Else TempStr:=TempStr+Byte2Ansi(ColorTable[Index]);
                             End;
                     Inc(StrCount);
                     End;
           '^'     : TempStr:=TempStr+'^';
         End; {Case}
         End
    Else Begin
         If (InStr[StrCount]=#12) And
            (Graphics And (Not AVATAR))
            Then TempStr:=TempStr+#27'[2J'
            Else Begin
                 If (InStr[StrCount]>#127) And
                    (Not (Graphics or Avatar))
                    Then TempStr:=TempStr+TransTable[InStr[StrCount]]
                    Else TempStr:=TempStr+InStr[StrCount];
                 End;
         Inc(StrCount);
         End;
 End; {While}
InStr:=TempStr;
End;

Begin
FillChar(EmptyLine,SizeOf(EmptyLine),#32);
EmptyLine[0]:=#79;
LastFG:=0;
LastBG:=0;
End.
