{$A+,B-,D-,E-,F-,I-,L-,N-,O-,R-,S+,V-}
{$M 10000,10000,10000}
{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}

{---------------------------------------------------------------------------|

 Description:

 MLFrame is a simple framework for a door written with the RADoor toolbox.
 It has the main initializations already where they should, and the important
 variables in place. Simply stuff some code at the spot marked X and compile.
 that's all. Compiling this frame without anything further code and the
 compiler toggles as above resulted in an EXE file with the following values
 in the Get Info window of TP5.5:

    CodeSize   30720 bytes
    DataSize   25652 bytes

 Not too much for an all singing, all dancing door featuring everything a door
 should feature!
}


Program MLframe;
Uses DOS,
     CRT,
     BBSTypes,   { BBS detection routine                         }
     UserHook,   { Demo/default userhook procedures              }
     Language,   { The multilanguage support                     }
     MLFilter,   { The default Multilanguage output filter       }
     LowLevel,   { The lowlevel stuff                            }
     DoorSys,    { Misc. Door routines.                          }
     GlobInfo,   { the global record with all the nessecary info }

     RA,         { The RA init code                              }
     SuperBBS,   { The SBBS init Code                            }
     QuickBBS,   { the QBBS init Code                            }

     Fossil;     { The fossil routines + Timing. This is the     }
                 {  body of the door!                            }


{----------------------------------------------------------------------------|
  The name and the version of the program together with the FossilObject
  variable which every door needs.
|----------------------------------------------------------------------------}


Const  ProgramName    = 'MLframe';
       ProgramVersion = '1.0';
       LastUpdate     = '4 Sep 1992';
       ProgName       = 'MLFrame';

Var Foss       : FossilObject;
    Slang      : String[3];


{----------------------------------------------------------------------------|
 Start here your own variables, procedures and functions.
|----------------------------------------------------------------------------}



{----------------------------------------------------------------------------|
 Start of main module
|----------------------------------------------------------------------------}
Begin

WriteLn(ProgramName,' ',ProgramVersion,' (c) LiveSystems 1992,1993   ALL RIGHTS RESERVED,  NO GUARANTEES');
WriteLn('Written by G.Hoogterp. E-mail address 2:283/1.2 Last Revision '+LastUpdate);
WriteLn('Use ??.EXE -? to see commandline parameter summary.');

If ExistParameter('?')
   Then Begin
        WriteLn('Usage: ');
        WriteLn;
        WriteLn(' ??.EXE [-T:<TimeLimit>] [-N:*N] [-P:*P] [-NOS]');
        WriteLn;
        WriteLn(' -T:     Set timelimit.');
        WriteLn(' -N:     Give nodenumber for multiline setups.');
        WriteLn(' -P:     Give ComPort to use.');
        WriteLn(' -NOS    No sound please');

        Halt;
        End;

{ The parameters mentioned here are read in the RA.PAS unit as they are more
  or less RA dependend and the result has to be stuffed into the global info
  record. }

{----------------------------------------------------------------------------|
 Grab the BBS specific stuff into the GlobalInfo record
|----------------------------------------------------------------------------}

Case CurrentBBStype Of
 RA_BBS : InitRA;
 S_BBS  : InitSBBS;
 Q_BBS  : InitQBBS;
End;


Slang:=GlobalInfo.Language;

If Not ExistFile(GlobalInfo.HomeDir+ProgName+'.'+Slang)
   Then Begin
        If Not ExistFile(GlobalInfo.HomeDir+ProgName+'.ENG')
           Then Begin
                LogIt('Couldn''t find language file..');
                WriteLn(#254' Couldn''t find language file..');
                Halt;
                End
           Else Slang:='ENG';
        End;


{----------------------------------------------------------------------------|
 And let the LOGfile know who's talking.
|----------------------------------------------------------------------------}

LogIt('Started: '+ProgramName+' '+ProgramVersion+' under '+GlobalInfo.BBSName);

{----------------------------------------------------------------------------|
  Initialize the userhooks, Timeout detection etc.
|----------------------------------------------------------------------------}

With GlobalInfo Do
 Begin
 Foss.AssignF(ComPort-1,BaudRate);   { Inti the fossil }
 If Foss.Error<>0
    Then Begin
         WriteLn(#254' Couldn''t initialize fossil!');
         LogIt('Couldn''t init fossil!');
         Halt;
         End;

 Foss.InitTimer(    { Init the timeout procedures              }
                GlobalInfo.Warnings,     { Warning before pushed back to the BBS    }
                GlobalInfo.TimeOutTime   { Timeout time before and between warnings }
                );


 Foss.InitOutputFilter(UsedFilter); { Set the output filter            }
 Foss.InitInputFilter(AllCharSet);  { Set the input filter for ReadLnF }

 Foss.InitSysopKeys(SysopKeys);     { Set the SYSOP keys procedure     }
 Foss.InitStatLine(StatusLine);     { Set the statusline procedure     }

 { Initialize the output filter using the info in the GlobalInfo record}

 InitUsedFilter(UseGraphics,UseAVATAR,GlobalInfo.HomeDir+ProgName+'.'+Slang,'^');
 End;


{ Initialize the colortable, I only use these colors in ALL my programs}

Move(Specials.Colors,ColorTable,10);

PressEnterString       := ']001';
PressEnterOrStopString := ']002';
Warning1String         := ']004';
Warning2String         := ']005';
AttentionString        := ']006';
LockOutString          := ']007';
HangUpString           := ']008';
TimeUpString           := ']009';
UsedStopKey            := Specials.StopDef;

{----------------------------------------------------------------------------|
  The mainbody of the DOOR goes here.
|----------------------------------------------------------------------------}




{----------------------------------------------------------------------------|
  Finalize the DOOR and say a nice thank you to the user for spending his
  online time and money on your door..
|----------------------------------------------------------------------------}

Case GlobalInfo.BBSTag Of
 RABBS : If Not RAUpdateExitInfo
            Then LogIt('Couldn''t update the EXITINFO.BBS!');
 SBBS  : If Not SBBSUpdateExitInfo
            Then LogIt('Couldn''t update the EXITINFO.BBS!');
 QBBS  : If Not QBBSUpdateExitInfo
            Then LogIt('Couldn''t update the EXITINFO.BBS!');

End;

Foss.ClrScrF;  { Clear the screen }
Foss.WriteLnF(']010'+ProgramName+' '+ProgramVersion+'.');
Delay(1000);

{----------------------------------------------------------------------------|
  Tell the LogFile that we're finished. Gives the fossil some extra time
  to get the ThankYou out of it's mouth....
|----------------------------------------------------------------------------}

LogIt('Stopped: '+ProgramName+' '+ProgramVersion);

{----------------------------------------------------------------------------|
 And close the fossil again..
|----------------------------------------------------------------------------}

Foss.CloseF;
End.

{----------------------------------------------------------------------------|
   And that's it! That's all.. I can't make things simpler..
   Oh well, actualy I could, but not without giving up flexability and
   usability.....
|----------------------------------------------------------------------------}
