(* Hung TH 941109 *)
(***************************************************************************)
Procedure my_putchar( chr, attr, x, y : Byte );
 	Var
   	regs : Registers;
 	Begin
 		regs.ah := $09;
   	regs.bh := $00;
   	regs.cx := $01;
   	regs.al := chr;
	   regs.bl := attr;
   	Intr( $10, regs );
 	End;

(***************************************************************************)
Function real_cords_func: Word;
	Var
   	regs : Registers;
	Begin
   	regs.ah := $03;
      regs.bh := $00;
      Intr( $10, regs );
      Inc( regs.dl );
      Inc( regs.dh );
      real_cords_func := regs.dx;
   End;
(***************************************************************************)
(* $I myreadln.pin		*)
(***************************************************************************)
(*
	This procedure reads a string but also check which key that was hit to
	terminat input of string, those keys are up to you	to define (ASCII code
	or scancode).
   x_end is the horizontal screen koordinat that you allow the input string
   to reach.
   The first argument is as you can see a own defined variabletype.
	This variable must be a record of one String[] and one Integer.
	Like this:

	Type
   	spec_line = Record
      					line : String[64];
      					i : Integer;
    					End;

   Then you must declare the variable ofcurse:

   Var
   	variable : spec_line;

*)
Procedure my_readln( Var line : spec_line; x_field, bkclr, txtclr : Byte );
   Var
      ch, sc, leftX, leftY, rightX, rightY : Byte;
      Regs : Registers;
      end_written : Boolean;
      x_pos, y_start, x_start, x_end : Integer;
      oldxy, oldattr : Word;
   Const
   	TABSIZE = '   ';
	Begin

      oldxy := real_cords_func;
      oldattr := TextAttr;
   	leftX := 1+Lo( WindMin );
      leftY := 1+Hi( WindMin );
      rightX := 1+Lo( WindMax );
      rightY := 1+Hi( WindMax );

   	line.line := '';
      line.i := 0;
      x_start := Lo( oldxy );
      y_start := Hi( oldxy );
      x_end := x_start + x_field;

      Window( x_start, y_start, x_start + x_field-1, y_start );
  		TextBackGround( bkclr );
  		TextColor( txtclr );
      Clrscr;

      x_start := WhereX;
      y_start := WhereY;
		x_end := x_field;
      end_written := FALSE;

      Repeat

         	Regs.AH := $10;
         	Intr( $16, Regs );		(* reading directly from keyb-buffer	*)
         	sc := Regs.AH;				(* keystroke in scancode 					*)
       		ch := Regs.AL;          (* character if any							*)

         		If (ch<>224) and (ch<>27) and (ch<>0) and (ch<>9) Then
         		(* arrow-keys *) (* ESC *)   (* F-keys *) (* TAB *)
          	 	 Begin
             		x_pos := WhereX;
             		If (x_pos<=x_end) and (ch<>8) Then                                   (* Inget skrivs ut till skrmen om *)
                   Begin
                     If not end_written Then
                      Begin
                        If (ch<>13) Then
         					my_putchar( ch, bkclr shl 4 + txtclr, WhereX, WhereY );
                        If (ch<>13) and (ch<>8) and (x_pos<=x_end) Then
            					line.line := line.line + Chr( ch );
                      End;
                     If WhereX<x_end Then
                      Begin
                     	GotoXY( WhereX+1, WhereY );
                        end_written := FALSE;
                      End
                     Else
                      	end_written := TRUE;
                   End;

          	 	 End;

         		If (ch = 9) and ((WhereX+3)<x_end) Then       (* if TAB *)
             	 Begin
         			Write( TABSIZE );
               	line.line := line.line + TABSIZE;
             	 End;

            	If (ch=8) and (WhereX=x_end) and (end_written) Then
                Begin
                	ch := 0;
                	my_putchar( ch, bkclr shl 4 + txtclr, WhereX, WhereY );
                  Delete( line.line, Length( line.line ), 1 );
                  end_written := FALSE;
                End;

               If (ch=8) and (WhereX>x_start) and (not end_written) Then
                Begin
                	GotoXY( WhereX-1, WhereY );
                  my_putchar( 0, bkclr shl 4 + txtclr, WhereX, WhereY );
                  Delete( line.line , Length( line.line ), 1 );
                  end_written := FALSE;
                End;

      Until (sc=$01) or (ch=13); (* until ch = ESC or ENTER *) (* or define your own keys *)

      line.i := ch;

      Window( leftX, leftY, rightX, rightY );

      regs.ah := $02;
      regs.bh := $00;
      regs.dx := oldxy;
      Intr( $10, regs );
      TextAttr := oldattr;
   End;
(***************************************************************************)

