
{ --------------------------------------------------------------------- }
{ Palette unit (text and graphics modes)                                }
{ Usable procedures:                                                    }
{   fadeup    -- fade the palette up                                    }
{   fadedown  -- fade the palette down                                  }
{   getpal256 -- fill the parameter Pal with the palette values         }
{   setpal256 -- fill the palette values with the parameter Pal         }
{ --------------------------------------------------------------------- }

UNIT Palett;

INTERFACE

uses Dos;

{ structure in which the palette information is stored }
type
  PaletteType = Array[0..255,1..3] Of byte; { 256 Red/Green/Blue (RGB)    }

var
  OldPlt  : PaletteType;                { internal palette structure  }
                                        { which contains the standard }
                                        { palette                     }
{ forward declarations }
procedure GetPal256 (var Pal : PaletteType);
procedure SetPal256 (var Pal : PaletteType);
procedure FadeUp;
procedure FadeDown;

IMPLEMENTATION

procedure GetPal256 (var Pal : PaletteType);
{
    Load Pal Structure with the 256 RGB palette values.
}
var
  Loope : word;
begin
  port[$3C7] := 0;
  { when a read is made on port $3C9 it increment port $3C7 so no changing }
  { of the register port ($3C7) needs to be performed here                 }
  for Loope := 0 to 255 do
    begin
      Pal[Loope,1] := port[$3C9];   { Read red value   }
      Pal[Loope,2] := port[$3C9];   { Read green value }
      Pal[Loope,3] := port[$3C9];   { Read blue value  }
    end
end;

procedure SetPal256 (var Pal : PaletteType);
{
    Loads the palette registers with the values in Pal.
}
begin
  asm
        push    ds              { preserve segment registers }
        push    es
        mov     cx, 256 * 3     { 256 RBG values             }
        mov     dx, 03dah
    { by waiting for the retrace to end it avoids static }
    { when the palette is altered                        }
@retrace1:
        in      al, dx          { wait for no retrace        }
        and     al, 8           { check for retrace          }
        jnz     @retrace1       { so loop until it goes low  }
@retrace2:
        in      al, dx          { wait for retrace           }
        and     al, 8           { check for retrace          }
        jz      @retrace2       { so loop until it goes high }
        lds     si, Pal         { ds:si = @Pal               }
        mov     dx, 3c8h        { set up for a blitz-white   }
        mov     al, 0           { from this register         }
        cli                     { disable interrupts         }
        out     dx, al          { starting register          }
        inc     dx              { set up to update DAC       }
        cld                     { clear direction flag       }
        rep     outsb           { 768 multiple out's         }
                                { rapid update acheived      }
        sti                     { end of critical section    }
        pop     es              { restore segment registers  }
        pop     ds
  end { asm }
end; { SetPal286 }

procedure fadedown;
{
    Fades the palette down with little or no static.
}
var
  Plt     : PaletteType;
  i, j, k : integer;
begin
  plt := OldPlt;
  for k := 0 to 63 do           { Fade down in 64 steps }
    begin
      for j := 0 to 255 do
        for i := 1 to 3 do
          if Plt[j,i] <> 0 then
            dec(Plt[j,i]);      { decrease palette numbers gradually }
      SetPal256(Plt);           { gradually fade down the palette    }
    end
end;

procedure fadeup;
{
    Fades the palette up with little or no static.
}
var
  Plt     : PaletteType;
  i, j, k : integer;
begin
  GetPal256(Plt);               { Load current palette }
  for k := 1 to 63 do           { Fade up in 64 steps  }
    begin
      for j := 0 to 255 do
        for i := 1 to 3 do
          if Plt[j,i] <> OldPlt[j,i] then
            inc(Plt[j,i]);      { bring palette back to the norm }
        SetPal256(Plt);         { gradually fades up the palette }
                                { to the normal values           }
    end
end;

begin
  { load the standard palette }
  GetPal256(OldPlt)
end.

