{$O+,F+}  UNIT F_FIle;

 {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +                        - FILE & DIR ROUTINES UNIT -                      +
  +    Version 1.1                                                           +
  +    DD. 6 juni 1994                                                       +
  +                                                                          +
  +    (c) Ron Huiskes / InterSoft 1993                                      +
  +        All Rights Reserved                                               +
  +                                                                          +
  +    This unit is copyright material by Ron Huiskes and InterSoft,         +
  +    it is NOT Public domain or Shareware. It may NOT be spread.           +
  +    Please contact InterSoft for a license to use this unit.              +
  +                                                                          +
  +    Author    : Ron Huiskes                                               +
  +    FidoNet   : 2:281/506                                                 +
  +    Usenet    : rh@intfhq.hacktic.nl                                      +
  +                                                                          +
  +    SnailMail : P.o. Box 528                                              +
  +                2280 AM Rijswijk zh                                       +
  +                The Netherlands                                           +
  +                                                                          +
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}


{ v1.1 : Added findnext procedure in some occasions for novell 3.11 ncp
         search bug }

INTERFACE

USES Crt, Dos;

{-----------------------------------------------------------------------------}

FUNCTION Exist( Str:String ) : Boolean;
FUNCTION Delete_File( Str:String ) : Boolean;
FUNCTION Create_File( Str:String ) : Boolean;
FUNCTION File_Split( Part:byte ; Full:String ) : String;
FUNCTION File_Directory( Full:String ) : String;
FUNCTION CopyFile( SourceFile, TargetFile:string ): byte;
FUNCTION File_Size( Str:String ) : LongInt;

{-----------------------------------------------------------------------------}

IMPLEMENTATION

FUNCTION Exist( Str:String ) : Boolean;
{-------------------------------------}
Var
  Inf: SearchRec;
Begin
  FindFirst(Str,AnyFile,Inf);
  Exist := (DOSError = 0);
  While doserror = 0 do findnext(inf); { novell 3.11 }
End;  

FUNCTION File_Size( Str:String ) : LongInt;
Var
  Sr : SearchRec;
Begin
  FindFirst(Str,AnyFile,Sr);
  If doserror <> 0 then
    File_Size := 0 Else
    File_Size := sr.size;
  While doserror= 0 do findnext(sr); { novell 3.11 }
End;

FUNCTION Delete_File ( Str:String ) : Boolean;
{--------------------------------------------}
Var
  T : Text;
Begin
  If not Exist(Str) then 
    Begin
      Delete_File := False;
      Exit;
    End;
  Assign(T,Str);
  {$i-} SetFAttr(T, 0); {$I+}
  If IoResult <> 0 then {};
  {$I-} Erase(T); {$I+}
  Delete_File := (IoResult = 0);
End;

FUNCTION Create_File ( Str:String ) : Boolean;
{--------------------------------------------}
Var
  T : text;
Begin
  If Exist(Str) then
    Begin
      Create_File := False;
      Exit;
    End;
  Assign(T,Str);
  {$I-} Rewrite(t); {$I+}
  If ioresult <> 0 then
    Create_File := false else
      begin
        Close(t);
        Create_file := true;
      end;
End;

FUNCTION File_Split(Part:byte;Full:string): string;
{-------------------------------------------------}
Var
   D : DirStr;
   N : NameStr;
   E : ExtStr;
Begin
  FSplit(Full,D,N,E);
  Case Part of
    1 : File_Split := D;
    2 : File_Split := N+E;
    3 : File_Split := N;
    4 : File_Split := E;
  End;
End;

FUNCTION File_Directory(Full:string): string;
{-------------------------------------------}
Var
  Temp : string;
  P : byte;
Begin
  Temp := File_Split(1,Full);
  P := Pos(':',Temp);
  If (Temp[length(Temp)]  ='\') and (temp <> '\') then
    Delete(temp,length(Temp),1);      {remove last backslash}
   File_Directory := Temp;
End;


Function CopyFile(SourceFile, TargetFile:string): byte;
{return codes:  0 successful
                1 source and target the same
                2 cannot open source
                3 unable to create target
                4 error during copy}
var
  Source,
  Target : file;
  BRead,
  Bwrite : word;
  FileBuf  : array[1..8192] of char;
begin
    If SourceFile = TargetFile then
    begin
        CopyFile := 1;
        exit;
    end;
    Assign(Source,SourceFile);
    {$I-}
    Reset(Source,1);
    {$I+}
    If IOResult <> 0 then
    begin
        CopyFile := 2;
        exit;
    end;
    Assign(Target,TargetFile);
    {$I-}
    Rewrite(Target,1);
    {$I+}
    If IOResult <> 0 then
    begin
        CopyFile := 3;
        exit;
    end;
    Repeat
         BlockRead(Source,FileBuf,SizeOf(FileBuf),BRead);
         BlockWrite(Target,FileBuf,Bread,Bwrite);
    Until (Bread = 0) or (Bread <> BWrite);
    Close(Source);
    Close(Target);
    If Bread <> Bwrite then
       CopyFile := 4
    else
       CopyFile := 0;
end; {of func CopyFile}


END.
