
program rm_call;

uses dos, crt, s_string, f_file;

type
  Rm_CallRecord         = record
    time  : string[5];
    endt  : string[5];
    baud  : longint;
    line  : byte;
    name  : string[55];
  end;

  HistoryRecord         = record
        w_cps                : word;
        l_speed              : longint;
        l_inb,
        l_outb               : longint;
        s_session,
        s_node,
        s_name               : string[40];
        s_system             : string[40];
        s_start              : string[5];
        w_mins               : word;
        l_cost               : longint;
        s_date               : string[11];
  end; {HistoryRecord}

  LASTCALLrecord = record
        Line           : Byte;
        Name,
        Handle         : string[35];
        City           : String[25];
        Baud           : Word;
        Times          : LongInt;
        LogOn          : String[5];
        LogOff         : String[5];
        Attribute      : Byte;
  end;

var
  h      : historyrecord;
  hfile  : file of historyrecord;
  l      : lastcallrecord;
  lfile  : file of lastcallrecord;
  rm     : array[1..800] of rm_callrecord;
  rmtel  : word;
  day    : string[2];
  bbs    : string;
  bbstel : word;
  textpath : string;

procedure readlastcall(name:string);
begin
  writeln('Reading '+name);

  filemode := 64;
  assign(lfile,name);
  {$I-} reset(lfile); {$I+}
  if ioresult <> 0 then
    begin
      writeln(' ERROR opening '+name);
      exit;
    end;
  while not eof(lfile) do
    begin
      read(lfile,l);
      if l.logoff >= l.logon then
        begin
          inc(rmtel);
          inc(bbstel);
          rm[rmtel].time := l.logon;
          rm[rmtel].endt := l.logoff;
          rm[rmtel].name := l.name+', '+l.city;
          rm[rmtel].baud := l.baud;
          rm[rmtel].line := l.line;
        end;
    end;
  close(lfile);
end;

function endtijd(start:string; mins:word):string;
var
  u,m : word;
  tmp : string;
begin
  u := str_to_int(first(2,start));
  m := str_to_int(last(2,start));
  
  while mins > 0 do
    begin
      inc(m);
      if m > 59 then
        begin
          inc(u);
          m := 0;
          if u > 23 then u := 0;
        end;
      dec(mins);
    end;
  if u < 10 then tmp := '0'+int_to_str(u)+':' else tmp := int_to_str(u)+':';
  if m < 10 then tmp := tmp + '0'+int_to_Str(m) else tmp := tmp + int_to_str(m);
  endtijd := tmp;
end;

procedure readhistory(line:byte; name:string);
var tmp : string;
begin
  writeln('Reading '+name);
  filemode := 64;
  assign(hfile,name);
  {$I-} reset(hfile); {$I+}
  if ioresult <> 0 then
    begin
      writeln(' ERROR opening '+name);
      exit;
    end;
  while not eof(hfile) do
    begin
      read(hfile,h);
      if extractwords(1,1,h.s_date) = day then
        begin
          if endtijd(h.s_start,h.w_mins) >= h.s_start then
            begin

              inc(rmtel);
              rm[rmtel].endt := endtijd(h.s_start,h.w_mins);
              rm[rmtel].time := h.s_start;
              rm[rmtel].name := h.s_name+', '+h.s_system;

              tmp := h.s_node;
              if pos('.',tmp) <> 0 then tmp := first(pos('.',tmp)-1,tmp);
              rm[rmtel].name := expand(first(52-length(tmp),rm[rmtel].name),52-length(tmp));
              rm[rmtel].name := rm[rmtel].name + ' '+'['+ tmp+']';

              rm[rmtel].baud := h.l_speed;
              rm[rmtel].line := line;
            end;     
        end;
    end;
  close(hfile);
end;

procedure read_ctl;
var
  t   : text;
  tmp1,
  tmp : string;
  D: DirStr;
  N: NameStr;
  E: ExtStr;

begin
  filemode := 66;
  tmp := paramstr(0);
  fsplit(tmp,d,n,e);
  if d <> '' then
    begin
      if last(1,d) <> '\' then d:= d + '\';
    end;
  writeln('Reading '+d+'RM_CALL.CTL');
  assign(t,d+'RM_CALL.CTL');
  {$I-} reset(t); {$I+}
  if ioresult <> 0 then
    begin
      writeln(' ERROR opening '+d+'RM_CALL.CTL file');
      halt;
    end;
  while not eof(t) do
    begin
      readln(t,tmp);
      if first(1,strip('B',' ',tmp)) <> ';' then
        begin
          tmp1 := upper(extractwords(1,1,tmp));
          if tmp1 = 'LASTCALL' then readlastcall(extractwords(2,1,tmp)) else
          if tmp1 = 'MCMAIL' then readhistory(str_to_int(extractwords(2,1,tmp)),extractwords(3,1,tmp)) else
          if tmp1 = 'BBS' then bbs := extractwords(2,wordcnt(tmp)-1,tmp) else
          if tmp1 = 'TEXTPATH' then textpath := extractwords(2,1,tmp) else
          writeln(' ERROR unknown keyword '+tmp1);
        end;
    end;
  if textpath <> '' then
    begin
      if last(1,textpath) <> '\' then textpath := textpath + '\';
    end;
end;

procedure sort_it;
var
  x       : word;
  rmbak   : rm_callrecord;
  changed : boolean;
begin
  writeln('Sorting ('+int_to_str(rmtel)+' calls)');
  repeat
    changed := false;

    for x := 1 to rmtel-1 do
      begin
        if rm[x].time > rm[x+1].time then
          begin
            changed := true;
            rmbak := rm[x];
            rm[x] := rm[x+1];
            rm[x+1] := rmbak;
          end;
      end;

  until not changed;
end;

function tottime:string;
var y, tel, tal : word;
    bu, bm, eu, em : word;
begin
  tal := 0;
  for y := 1 to rmtel do
    begin
      bu := str_to_int(first(2,rm[y].time));
      bm := str_to_int(last(2,rm[y].time));
      eu := str_to_int(first(2,rm[y].endt));
      em := str_to_int(last(2,rm[y].endt));

      tel := 0;
      while (bu < eu) or (bm < em) do
        begin
          inc(tel);
          inc(bm);
          if bm = 60 then
            begin
              bm := 0;
              inc(bu);
              if bu = 24 then bu := 0;
            end;
        end;
      if tel = 0 then tel := 1;

      inc(tal,tel);
    end;
  
  if tal > 60 then
    begin
     bu := tal div 60;
     bm := tal - (bu*60);
     tottime := int_to_str(bu)+' hrs '+ int_to_str(bm)+' mins';
    end else
     tottime := int_to_str(tal)+' mins';
end;

procedure write_todays;
var
  x  : word;
  t1 : text;
begin
  writeln('writing '+textpath+'TODAYS.ASC');

  assign(t1,textpath+'TODAYS.BAK');
  rewrite(t1);

  writeln(t1,'');
  writeln(t1,' '+^K+'[0BCalls todays at '+bbs);
  writeln(t1,'');
  writeln(t1,' '+^K+'[09Call        Name                                         Node      Line  Baud ');
  writeln(t1,' '+^K+'[01'+replicate(77,''));

  for x := 1 to rmtel do
    begin
      writeln(t1,' '+^K+'[09'+
        rm[x].time+'-'+rm[x].endt+' '+^K+'[0B'+
        expand(rm[x].name,55)+'  '+^K+'[09'+
        int_to_str(rm[x].line)+'  '+^K+'[0B'+
        allign(int_to_str(rm[x].baud),5));
    end;

  writeln(t1,'');
  writeln(t1,' '+^K+'[0B'+int_to_str(rmtel)+^K+'[09 calls today ('+^K+'[0B'+int_to_str(bbstel)
     +^K+'[09 on bbs), total online time '+tottime+'.');
  writeln(t1,'');
  write(t1,' '+^K+'[0DPress [Enter]'+^A+^L);

  close(t1);
  
  if file_size(textpath+'todays.bak') < file_size(textpath+'todays.asc') then
    begin
      writeln('Writing '+textpath+'YSTERDAY.ASC');
      copyfile(textpath+'TODAYS.ASC',textpath+'YSTERDAY.ASC');
      delete_file(textpath+'todays.asc');
      rename(t1,textpath+'TODAYS.ASC');
    end else
    begin
      delete_file(textpath+'TODAYS.ASC');
      rename(t1,textpath+'TODAYS.ASC');
    end;
end;

procedure write_last12;
var
  x  : word;
  t1 : text;
begin
  writeln('writing '+textpath+'WELCOME1.ASC');

  assign(t1,textpath+'WELCOME1.ASC');
  rewrite(t1);

  writeln(t1,^L);
  writeln(t1,' '+^K+'[0BLast 12 calls to '+bbs);
  writeln(t1,'');
  writeln(t1,' '+^K+'[09Call        Name                                         Node      Line  Baud ');
  writeln(t1,' '+^K+'[01'+replicate(77,''));

  for x := rmtel-11 to rmtel do
    begin
       if x > 0 then
         begin
           writeln(t1,' '+^K+'[09'+
             rm[x].time+'-'+rm[x].endt+' '+^K+'[0B'+
             expand(rm[x].name,55)+'  '+^K+'[09'+
             int_to_str(rm[x].line)+'  '+^K+'[0B'+
             allign(int_to_str(rm[x].baud),5));
         end;
    end;

  writeln(t1,'');
  writeln(t1,' '+^K+'[09Total Minutes Online : '+^K+'[0B'+tottime);
  writeln(t1,' '+^K+'[09Total Callers Today  : '+^K+'[0B'+int_to_str(rmtel));
  writeln(t1,' '+^K+'[09Bbs Callers Today    : '+^K+'[0B'+int_to_str(bbstel));
  writeln(t1,'');
  write(t1,' '+^K+'[0DPress [Enter]'+^A+^L);
  close(t1);
end;


procedure init;
var
  y, m, d, dow : Word;
begin
  writeln;
  textattr := 14;
  writeln('RM_CALL v1.0 - Lastcallers creator for McMail and RemoteAccess');
  textattr := 11;
  writeln('Copyright (c) Ron Huiskes / Intersoft 1995. All Rights Reserved.');
  textattr := 7;
  writeln;

  rmtel := 0;
  bbstel := 0;
  textpath := '';
  bbs := '';

  GetDate(y,m,d,dow);
  if d > 9 then day := int_to_str(d) else day := '0'+int_to_str(d);
end;

{--------------------}

begin
  init;
  read_ctl;
  sort_it;
  write_todays;
  write_last12;
end.
