{$O+,F+}  UNIT S_String;

 {++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +                        - STRING ROUTINES UNIT -                          +
  +    Version 1.7                                                           +
  +    DD. 23 mei 1994                                                        +
  +                                                                          +
  +    (c) Ron Huiskes / InterSoft 1991-94                                   +
  +        All Rights Reserved                                               +
  +                                                                          +
  +    This unit is copyright material by Ron Huiskes and InterSoft,         +
  +    it is NOT Public domain or Shareware. It may NOT be spread.           +
  +    Please contact InterSoft for a license to use this unit.              +
  +                                                                          +
  +    Author    : Ron Huiskes                                               +
  +    FidoNet   : 2:281/506                                                 +
  +                                                                          +
  +    SnailMail : P.o. Box 528                                              +
  +                2280 AM Rijswijk zh                                       +
  +                The Netherlands                                           +
  +                                                                          +
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{ version 1.4 added function allign.
              same as expand function, only expands to the left
  version 1.5 added overtype function
  version 1.6 added versionstr function
  version 1.7 added replace function + str_to_real function
}


INTERFACE

USES Crt;

{-----------------------------------------------------------------------------}

FUNCTION VersionStr (V : Word) : String;
FUNCTION Expand(Str:String;Len:Byte):String;
FUNCTION Allign(Str:String;Len:Byte):String;
FUNCTION Last(N:Byte;Str:String):String;
FUNCTION First(N:Byte;Str:String):String;
FUNCTION Upper(Str:String):String;
FUNCTION Lower(Str:String):String;
FUNCTION Proper(Str:String):String;
FUNCTION WordCnt(Str:String):Byte;
FUNCTION ExtractWords(StartWord,NoWords:Byte;Str:String):String;
FUNCTION Int_To_Str(Number:LongInt):String;
FUNCTION Str_To_Int(Str:String):Word;
FUNCTION Str_to_Long(Str:String):LongInt;
Function Str_to_Real(Str:string):real;
FUNCTION Replicate(N : Byte; Character:Char):String;
FUNCTION Strip(L,C:Char;Str:String):String;
FUNCTION Real_to_str(Number:real;Decimals:byte):String;
FUNCTION OverType(N:byte;StrS,StrT:String):String;
FUNCTION Replace(L,C:Char;Str:String):String;

{-----------------------------------------------------------------------------}

IMPLEMENTATION

Function Str_to_Real(Str:string):real;
{------------------------------------}
var
  code : integer;
  Temp : real;
begin
    If length(Str) = 0 then
       Str_to_Real := 0
    else
    begin
        If Copy(Str,1,1)='.' Then
           Str:='0'+Str;
        If (Copy(Str,1,1)='-') and (Copy(Str,2,1)='.') Then
           Insert('0',Str,2);
        If Str[length(Str)] = '.' then
           Delete(Str,length(Str),1);
       val(Str,temp,code);
       if code = 0 then
          Str_to_Real := temp
       else
          Str_to_Real := 0;
    end;
end;


FUNCTION VersionStr (V : Word) : String;
{--------------------------------------}
Var
  S : String;
Begin
  S := Int_to_str(V);
  While length(S) < 3 do S := '0' + S;
  Versionstr := first(length(s)-2,S)+'.'+last(2,S);
End;

FUNCTION Expand(Str:String;Len:Byte):String;
{------------------------------------------}
BEGIN
  WHILE Length(Str) < Len DO
    Str := Str + ' ';
  Str := First(Len,Str);
  Expand := Str;
END;

FUNCTION Allign(Str:String;Len:Byte):String;
{------------------------------------------}
BEGIN
  WHILE Length(Str) < Len DO
    Str := ' ' + Str;
  Allign := Str;
END;

FUNCTION Last(N:Byte;Str:String):String;
{--------------------------------------}
VAR
  Temp : String;
BEGIN
  IF N >= Length(Str) THEN Temp := ''
    ELSE Temp := Copy(Str,Succ(Length(Str) - N),N);
  If (length(Str) = 0) or (n < 1) then Temp := '';
  Last := Temp;
END; 

FUNCTION First(N:Byte;Str:String):String;
{---------------------------------------}
VAR
  Temp : String;
BEGIN
  IF N >= Length(Str) THEN Temp := Str
    ELSE Temp := Copy(Str,1,N);
  IF (Length(Str) = 0) or (n < 1) then Temp := '';
  First := Temp;
END;

FUNCTION Upper(Str:String):String;
{--------------------------------}
VAR
  I : Integer;
BEGIN
  FOR I := 1 TO Length(Str) DO Str[I] := UpCase(Str[I]);
  Upper := Str;
END;

FUNCTION Lower(Str:String):String;
{--------------------------------}
VAR
  I : Integer;
BEGIN
  FOR I := 1 TO Length(Str) DO
    IF Ord(Str[I]) IN [65..90] THEN
       Str[I] := Chr(Ord(Str[I]) + 32);
  Lower := Str;
END;

FUNCTION Proper(Str:String):String;
{---------------------------------}
VAR
  I : Integer;
  SpaceBefore: Boolean;
BEGIN
  SpaceBefore := True;
  Str := Lower(Str);
  FOR I := 1 TO Length(Str) DO
    IF SpaceBefore AND (Ord(Str[I]) IN [97..122]) THEN
      BEGIN
        SpaceBefore := False;
        Str[I] := UpCase(Str[I]);
      END
       ELSE
         IF (SpaceBefore = False) AND (Str[I] = ' ') THEN
           SpaceBefore := True;
  Proper := Str;
END;

FUNCTION LocWord(StartAT,Wordno:Byte;Str:String):Byte;
{----------------------------------------------------}
{local proc used by PosWord and Extract word}
VAR
  W,L: Integer;
  SpaceBefore: Boolean;
BEGIN
  IF (Str = '') OR (Wordno < 1) OR (StartAT > Length(Str)) THEN
    BEGIN
      LocWord := 0;
      Exit;
    END;
  SpaceBefore := True;
  W := 0;
  L := Length(Str);
  StartAT := Pred(StartAT);
  WHILE (W < Wordno) AND (StartAT <= Length(Str)) DO
    BEGIN
      StartAT := Succ(StartAT);
      IF SpaceBefore AND (Str[StartAT] <> ' ') THEN
        BEGIN
          W := Succ(W);
          SpaceBefore := False;
        END
        ELSE
          IF (SpaceBefore = False) AND (Str[StartAT] = ' ') THEN
                SpaceBefore := True;
    END;
  IF W = Wordno THEN LocWord := StartAT ELSE LocWord := 0;
END;

FUNCTION WordCnt(Str:String):Byte;
{--------------------------------}
VAR
  W,I: Integer;
  SpaceBefore: Boolean;
BEGIN
  IF Str = '' THEN
    BEGIN
      WordCnt := 0;
      Exit;
    END;
  SpaceBefore := True;
  W := 0;
  FOR  I :=  1 TO Length(Str) DO
    BEGIN
      IF SpaceBefore AND (Str[I] <> ' ') THEN
        BEGIN
          W := Succ(W);
          SpaceBefore := False;
        END
        ELSE
          IF (SpaceBefore = False) AND (Str[I] = ' ') THEN
            SpaceBefore := True;
    END;
  WordCnt := W;
END;

FUNCTION ExtractWords(StartWord,NoWords:Byte;Str:String):String;
{--------------------------------------------------------------}
VAR
  Start, finish : Integer;
BEGIN
  IF Str = '' THEN
    BEGIN
      ExtractWords := '';
      Exit;
    END;
  Start := LocWord(1,StartWord,Str);
  IF Start <> 0 THEN
       finish := LocWord(Start,Succ(NoWords),Str)
    ELSE
    BEGIN
      ExtractWords := '';
      Exit;
    END;
  IF finish <> 0 THEN
    REPEAT
       finish := Pred(finish);
    UNTIL Str[finish] <> ' '
     ELSE
       finish := Length(Str);
  ExtractWords := Copy(Str,Start,Succ(finish-Start));
END;

FUNCTION Int_To_Str(Number:LongInt):String;
{-----------------------------------------}
VAR
  Temp : String;
BEGIN
  Str(Number,Temp);
  Int_To_Str := Temp;
END;

FUNCTION  Str_To_Int(Str:String):Word;
{------------------------------------}
VAR
  Temp,code : Word;
BEGIN
  IF Length(Str) = 0 THEN
       Str_To_Int := 0
    ELSE
    BEGIN
      Val(Str,Temp,code);
      IF code = 0 THEN
         Str_To_Int := Temp
       ELSE
         Str_To_Int := 0;
    END;
END;

FUNCTION Replicate(N : Byte; Character:Char):String;
{--------------------------------------------------}
VAR
 tempstr : String;
BEGIN
 IF N = 0 THEN
    tempstr := ''
   ELSE
   BEGIN
     IF (N > 255) THEN
       N := 1;
     FillChar(tempstr,N+1,Character);
     tempstr[0] := Chr(N);
   END;
 Replicate := tempstr;
END;

FUNCTION Strip(L,C:Char;Str:String):String;
{-----------------------------------------}
{L is left,center,right,all,ends}
VAR
  I : Word;
BEGIN
  CASE UpCase(L) OF
   'L' : BEGIN       {Left}
           WHILE (Str[1] = C) AND (Length(Str) > 0) DO
             Delete(Str,1,1);
         END;
   'R' : BEGIN       {Right}
           WHILE (Str[Length(Str)] = C) AND (Length(Str) > 0) DO
             Delete(Str,Length(Str),1);
         END;
   'B' : BEGIN       {Both left and right}
           WHILE (Str[1] = C) AND (Length(Str) > 0) DO
             Delete(Str,1,1);
           WHILE (Str[Length(Str)] = C) AND (Length(Str) > 0)  DO
             Delete(Str,Length(Str),1);
         END;
   'A' : BEGIN       {All}
           I := 1;
           REPEAT
             IF (Str[I] = C) AND (Length(Str) > 0) THEN
               Delete(Str,I,1)
                 ELSE
                  I := Succ(I);
           UNTIL (I > Length(Str)) OR (Str = '');
         END;
   END;
   Strip := Str;
END;  {Func Strip}

FUNCTION Str_to_Long(Str:String):LongInt;
{---------------------------------------}
VAR
  code : Integer;
  Temp : LongInt;
BEGIN
    IF Length(Str) = 0 THEN
       Str_to_Long := 0
    ELSE
    BEGIN
       Val(Str,Temp,code);
       IF code = 0 THEN
          Str_to_Long := Temp
       ELSE
          Str_to_Long := 0;
    END;
END;

FUNCTION Real_to_Str(Number:real;Decimals:byte):String;
{-----------------------------------------------------}
VAR
  Temp : string;                                       
BEGIN
  Str(Number:20:Decimals,Temp);                        
  REPEAT                                               
    If copy(Temp,1,1) = ' ' then delete(Temp,1,1);  
  UNTIL copy(temp,1,1) <> ' ';                         
  If Decimals = 255 then                          
    BEGIN
      Temp := Strip('R','0',Temp);                      
      If Temp[Length(temp)] = '.' then                  
        Delete(temp,Length(temp),1);                   
    END;
  Real_to_Str := Temp;                                 
END;

FUNCTION OverType(N:byte;StrS,StrT:string):string;
{------------------------------------------------}
{Overlays StrS onto StrT at Pos N}
var
  L : byte;
  StrN : string;
begin
    L := N + pred(length(StrS));
    If L < length(StrT) then
       L := length(StrT);
    If L > 255 then
       Overtype := copy(StrT,1,pred(N)) + copy(StrS,1,255-N)
        else
    begin
       Fillchar(StrN[1],L,' ');
       StrN[0] := chr(L);
       Move(StrT[1],StrN[1],length(StrT));
       Move(StrS[1],StrN[N],length(StrS));
       OverType := StrN;
    end;
end;  {Func OverType}

FUNCTION Replace(L,C:Char;Str:String):String;
{-------------------------------------------}
{Replace char L with char C in Str string}
Var
  Tmp : String;
  X   : Byte;
Begin
  Tmp := '';
  For X := 1 to Length(str) do
    Begin
      If Str[x] = L then
        Tmp := Tmp + C Else
          Tmp := Tmp + Str[x];
    End;
  Replace := Tmp;
End;

END. {unit}
