# ---------------------------------------------------------------------------
# DALINE.MPS v1.0b6: Oneliner for Mystic BBS v1.06.
# ---------------------------------------------------------------------------
#   DA-LINE version 1.0b6 is a FREEWARE One-liner MPE module written
#   for use with MySTIC BBs software version 1.06 and later. As of
#   version 1.00b5 I will being releasing the source code feel free to
#   make any modifications to this module that you want. I ask in
#   return though if you do modify it and distribute it to first get
#   in touch with me. Also you must include the source code (.MPS),
#   and not charge any money for your modified version of DA-LINE.
#   Please not to take my name off the status bar, you may included
#   yours if you wish.
#
#   I can be reached by email at: aric2746@students.nj.devry.edu
#
#   Features:
#       Can have up to a maximum of 65535 One-liners
#       Screening of the One-liner through a Censor database
#       Includes light Bars to scroll through One-liners
#       Custom headers and footer files
#       Complete color configuration
#       Custom String Configuration
#       Supports for NON-ANSi callers
#       Screen names can be posted as Anonymous, Handle, or Initials
#       Inactivity support
#
#   The next version will be the final version and will included the
#   Remaining features.
#
#   Remaining Features:
#       Random Schemes
#       Edit / Delete One-liners
#
#   Read WHATSNEW.DOC to find the new features.
#
# Another FREEWARE Mystic BBS modification. (C) 1999 Antonio Rico.
# ---------------------------------------------------------------------------
# Read DALINE.DOC for other information
# ---------------------------------------------------------------------------

uses user
GetThisUser                   # Gets user information

Var ANILocation   string      # Hold path of DA-LINE.MPE
Var MPEpos        integer     # Postion of DA-LINE.MPE in ANILocation

Var OptF String array (1..7)  # See proc Read_Config_File
Var StrF String array (1..15) # See proc Read_String_File

Var DalineMax     word        # SysOp maximum One-liners allowed
Var DalinePos     word        # Holds One-liner position
Var DalineCurrent word        # Current number of One-liners
Var DalineData    string      # Holds current One-liner
Var OkCOPY        boolean     # Holds true if copy was ok

Var FooterY       byte        # Ending coridnates of DA-LINEF.*
Var HeaderY       byte        # Starting coridnates of highlight bar
Var CurrentY      word        # Holds current highlight number
Var DalineText    string      # Holds the new One-liner
Var Position      byte        # Loop used for XxXxXxXxXxX -> ok??
Var fRecOrTen     word        # 10 or file size used to write One-liners

Var Str           string      # The string to be centered
Var StrD          string      # Centered String
Var GetChar       char        # Holds the key entered from KB buffer
Var GetCharDone   boolean     # Is User finished playing with DA-LINE

Var Handle        string      # Holds the handle type [A, H, I]
Var HandleLength  byte        # Used to figure out the room for the onliner
Var Choose        string      # Prompts the user for type of handle [A, H, I]

Var HandleSize    byte        # Holds the length of UserName
Var Index         byte        # Holds current letter poistion of HandleSize
Var Char          string      # Checks for a blank space

Var CensorData    string      # Holds current censored word 
Var CensorPos     byte        # Holds current censored word postion
Var CensorChar    char        # Replaces censored word with this character
Var DalineUp      string      # Allows search of upper and lower case letters

Var Stupid        word        #MIDE v003 doesn't support order of operations

#--------------------------------------------------------------------------#
Proc Clear_Input
#Begin
    GotoXY( 1, FooterY - 4)      # Starts at row 1, column FooterY
    WriteLn ('                                                                               ') 
    GotoXY (1, FooterY - 4)      # Starts at row 1, column FooterY
#End
Pend Clear_Input

#--------------------------------------------------------------------------#
Proc Write_Status
#Begin
    GotoXY (1, FooterY - 2)       # Starts at row 1, column FooterY 
    StrD := PadCT(Str, 80 - Index, ' ')  # Pads string to center
    Write (StrD)                  # Display string to screen
#End
Pend Write_Status 

#--------------------------------------------------------------------------#
Proc Exit_Daline
  Str := '|01DA-LINE v1.0b6+ Coded By: |07Antonio Rico' # Status Bar - Advertise
  Write_Status                                         # Write it on screen
  Delay (900)                                          # Delay a while
  
  Str := OptF(2)                        # Status Bar - BBs Name
  Write_Status                          # Write it on screen
  Delay(900)                            # Delay a while
Pend Exit_Daline

#--------------------------------------------------------------------------#
Proc Get_BarON
#Begin
  fOpen(1, Bin, Reset, ANILocation + 'DA-LINE.DAT')
  fSeek(1, DalinePos - 1 * 78)
  fReadRec (1, DalineData, 77)
  fClose(1)

  # Finds the position of closing Bracket
  Position := pos(' ', DalineData)

  # Highlights the username
  Write (StrF(1) + StrF(5) + PadRT(DalineData, Position - 1, ' ') + '|16')

  # Moves cursor to a nice spot =p
  GotoXY(Length(StrF(10))-2, FooterY - 4)
#End
Pend Get_BarON

#--------------------------------------------------------------------------#
Proc Get_BarOFF
#Begin
  # Finds the position of closing Bracket
  Position := pos(' ', DalineData)

  # Displays the unhighlighted username
  write (StrF(1) + StrF(3) + Copy(DalineData, 1, Position - 1) + StrF(2))
#End
Pend Get_BarOFF

#--------------------------------------------------------------------------#
Proc Write_Index
#Begin
 GotoXY (62, HeaderY)
 if DalinePos < 10
   write(StrF(6) + '0' + DalinePos + ' ' + StrF(7) + ' '+ DalineCurrent + StrF(8))
 elseif DalinePos < 99
   write(StrF(6) + DalinePos + ' ' + StrF(7) + ' ' + DalineCurrent + StrF(8))
 elseif DalinePos < 999
   write(StrF(6) + DalinePos + ' ' + StrF(7) + ' ' + DalineCurrent + StrF(8) + StrF(9))
 elseif DalinePos < 9999
   write(StrF(6) + DalinePos + ' ' + StrF(7) + ' ' + DalineCurrent + StrF(8) + StrF(9) + StrF(9))
 elseif DalinePos < 99999
   write(StrF(6) + DalinePos + ' ' + StrF(7) + ' ' + DalineCurrent + StrF(8) + StrF(9) + StrF(9) + StrF(9))
 endif
#End
Pend Write_Index

#--------------------------------------------------------------------------#
Proc Move_UP
#Begin
  if DalinePos > 1 then
    #Begin
      DalinePos := DalinePos - 1
      if CurrentY = 1 then
       #Begin
          fOpen(1, Bin, Reset, ANILocation + 'DA-LINE.DAT')
          fSeek(1, DalinePos - 1 * 78)
          for Position := 1 to 10
            GotoXY(1, HeaderY + Position)
            fReadRec (1, DalineData, 77)
            write('                                                                                ')
            GotoXY(1, HeaderY + Position)
            Insert(StrF(2) + StrF(4), DalineData, Pos(' ', DalineData))
            write(StrF(1) + StrF(3) + DalineData)
          fend
          fClose(1)
          GotoXY(1, HeaderY + 1)
          Get_BarON
       #End
      else
       #Begin
          GotoXY (1, HeaderY + CurrentY)
          Get_BarOFF
          CurrentY := CurrentY - 1
          GotoXY (1, HeaderY + CurrentY)
          Get_BarON
       #End
      endif
    #End
  endif
  Write_Index
#End
Pend Move_UP

#--------------------------------------------------------------------------#
Proc Move_DOWN
#Begin
  If DalinePos < DalineCurrent then
    #Begin
      DalinePos := DalinePos + 1
      if CurrentY = 10 then            
       #Begin
         fOpen(1, Bin, Reset, ANILocation + 'DA-LINE.DAT')
         for Position := 1 to 10
           GotoXY(1, HeaderY + 11 - Position)
           fSeek(1, DalinePos - Position * 78)
           fReadRec (1, DalineData, 77)
           write('                                                                                ')
           GotoXY(1, HeaderY + 11 - Position)    
           Insert(StrF(2) + StrF(4), DalineData, Pos(' ', DalineData))
           write(StrF(1) + StrF(3) + DalineData)
         fend
         fClose(1)
         GotoXY(1, HeaderY + 10)
         Get_BarON
       #End
      else
       #Begin
          GotoXY (1, HeaderY+CurrentY)
          Get_BarOFF
          CurrentY := CurrentY + 1
          GotoXY (1, HeaderY+CurrentY)
          Get_BarON
       #End
      endif
    #End 
  endif
  Write_Index
#End
Pend Move_DOWN

#--------------------------------------------------------------------------#
Proc Move_Left
#Begin
  if DalineCurrent < 10
   #Begin
      GotoXY(1, HeaderY + CurrentY)
      Get_BarOff
      DalinePos := 1
      CurrentY := 1
      GotoXY(1, HeaderY + CurrentY)
      Get_BarON
   #End
  elseif DalinePos >= 10 
   #Begin
      DalinePos := DalinePos - 9
      fOpen(1, Bin, Reset, ANILocation + 'DA-LINE.DAT')
      fSeek(1, DalinePos - 1 * 78)
      for Position := 1 to 10
        GotoXY(1, HeaderY + Position)
        fReadRec (1, DalineData, 77)
        write('                                                                                ')
        GotoXY(1, HeaderY + Position)
        Insert(StrF(2) + StrF(4), DalineData, Pos(' ', DalineData))
        write(StrF(1) + StrF(3) + DalineData)
      fend
      fClose(1)
      GotoXY(1, HeaderY + 1)
      CurrentY := 1
      Get_BarON
   #End   
  elseif DalinePos > 1
   #Begin
     DalinePos := DalinePos - DalinePos + 1
     fOpen(1, Bin, Reset, ANILocation + 'DA-LINE.DAT')
     fSeek(1, DalinePos - 1 * 78)
     for Position := 1 to 10
       GotoXY(1, HeaderY + Position)
       fReadRec (1, DalineData, 77)
       write('                                                                                ')
       GotoXY(1, HeaderY + Position)
       Insert(StrF(2) + StrF(4), DalineData, Pos(' ', DalineData))
       write(StrF(1) + StrF(3) + DalineData)
     fend
     fClose(1)
     CurrentY := 1
     GotoXY(1, HeaderY + 1)
     Get_BarON
   #End
  endif
  Write_Index
#End
Pend Move_Left

#--------------------------------------------------------------------------#
Proc Move_Right
#Begin
  if DalineCurrent < 10
   #Begin
      GotoXY(1, HeaderY + CurrentY)
      Get_BarOff
      DalinePos := fRecOrTen
      CurrentY := fRecOrTen
      GotoXY(1, HeaderY + CurrentY)
      Get_BarON
   #End
  elseif DalineCurrent - DalinePos >= 10
   #Begin
     DalinePos := DalinePos + 9
     fOpen(1, Bin, Reset, ANILocation + 'DA-LINE.DAT')
     for Position := 1 to 10
       GotoXY(1, HeaderY + 11 - Position)
       fSeek(1, DalinePos - Position * 78)
       fReadRec (1, DalineData, 77)
       write('                                                                                ')
       GotoXY(1, HeaderY + 11 - Position)    
       Insert(StrF(2) + StrF(4), DalineData, Pos(' ', DalineData))
       write(StrF(1) + StrF(3) + DalineData)
     fend
     fClose(1)
     GotoXY(1, HeaderY + 10)
     CurrentY := 10
     Get_BarON
   #End
  elseif DalinePos < Dalinecurrent
     DalinePos := DalineCurrent - DalinePos + DalinePos
     fOpen(1, Bin, Reset, ANILocation + 'DA-LINE.DAT')
     for Position := 1 to 10
       GotoXY(1, HeaderY + 11 - Position)
       fSeek(1, DalinePos - Position * 78)
       fReadRec (1, DalineData, 77)
       write('                                                                                ')
       GotoXY(1, HeaderY + 11 - Position)    
       Insert(StrF(2) + StrF(4), DalineData, Pos(' ', DalineData))
       write(StrF(1) + StrF(3) + DalineData)
     fend
     fClose(1)
     GotoXY(1, HeaderY + 10)
     CurrentY := 10
     Get_BarON
  endif
  Write_Index
#End
Pend Move_Right

#==========================================================================#
Proc Path_Get
#Begin
   #Holds the location of DA-LINE.MPE
   ANILocation := ParamStr(0)              

   #Returns the starting postion of DA-LINE.MPE in ANILocation
   MPEpos := Length(ANILocation) - Pos('.', ANILocation) - 7

   #Copies DA-LINE.MPE from ANILocation starting at MPEpos
   ANILocation := Copy(ANILocation, 1, MPEpos)
#End
PEnd Path_Get

#--------------------------------------------------------------------------#
Proc Exist_Config_File
#Begin
  If Not fExist(ANILocation + 'DA-LINE.CFG') then
   #Begin
     WriteLn ('|CR|04DA-LINE ERROR: |07DA-LINE.CFG Configuration File not found.')
     WriteLn ('                     In ' + ANILocation)
     Char := Readkey
     Halt
   #End
  EndIf
#End
PEnd Exist_Config_File

#--------------------------------------------------------------------------#
Proc Exist_String_File
#Begin
  If Not fExist(ANILocation + 'DA-LINE.STG') then
   #Begin
      WriteLn ('|CR|04DA-LINE ERROR: |07DA-LINE.STG String File not found.')
      WriteLn ('                     In ' + ANILocation)
      Char := Readkey
      Halt
   #End
  EndIf
#End
PEnd Exist_String_File

#--------------------------------------------------------------------------#
Proc Exist_Censor_File
#Begin
  If upper(OptF(3)) = 'Y' then
   #Begin
      If Not fExist(ANILocation + 'DA-LINE.CEN') then
       #Begin
          WriteLn ('|CR|04DA-LINE ERROR: |07DA-LINE.CEN Censor File Not Found.')
          WriteLn ('                     In ' + ANILocation)
          Char := Readkey
          Halt
       #End
      EndIf
   #End
  EndIf
#end
Pend Exist_Censor_File

#--------------------------------------------------------------------------#
Proc Read_Config_File
#Begin
 fOpen (1, Text, Reset, ANILocation + 'DA-LINE.CFG')
 fReadLn (1, OptF(1))  # Maximum number of One-liners
 fReadLn (1, OptF(2))  # Color Code and BBs Name  
 fReadLn (1, OptF(3))  # Censor One-liner
 fReadLn (1, OptF(4))  # Deleted censored word(s)
 fReadLn (1, OptF(5))  # Replace censored word with this character
 fReadLn (1, OptF(6))  # Allow Anonymous Posts
 fReadLn (1, OptF(7))  # Anonymous post Handle
 fClose (1)
#End
PEnd Read_Config_File

#--------------------------------------------------------------------------#
Proc Read_String_File
#Begin
 fOpen (1, Text, Reset, ANILocation + 'DA-LINE.STG')

#STRING#
 fReadLn (1, StrF(1)) # Color Code and Opening Bracket for UserName
 fReadLn (1, StrF(2)) # Color Code and Closing Bracket for UserName
 fReadLn (1, StrF(3)) # Color Code for UserName
 fReadLn (1, StrF(4)) # Color Code for Oneliner Color
 fReadLn (1, StrF(5)) # Color Code and character for Highlighted One-liner
 fReadLn (1, StrF(6)) # Color Code, Opening Bracket and Color Code Minimum Index
 fReadLn (1, StrF(7)) # Color Code for 'OF' and Color Code Maximum Index
 fReadLn (1, StrF(8)) # Color Code and Closing Bracket
 fReadLn (1, StrF(9)) # Last ASCII character that in DA-LINEH.*
#INPUT#
 fReadLn (1, StrF(10))  # Navigation opition
 fReadLn (1, StrF(11))  # Select Handle format 
#STATUS BAR#
 fReadLn (1, StrF(12))  # Invalid Input
 fReadLn (1, StrF(13))  # Handle Format
 fReadLn (1, StrF(14))  # Enter One-liner
 fReadLn (1, StrF(15))  # One-liner Empty
 fClose (1)
#End
PEnd Read_String_File

#--------------------------------------------------------------------------#
Proc Get_Anonymous
  # Anonymous Handle was chosen read prompt from line 5 of config file
  Handle := OptF(7)
  # Calculates the avaible space for the oneliner
  HandleLength := 80 - Length (OptF(7)) - 4
Pend Get_Anonymous

#--------------------------------------------------------------------------#
Proc Get_Handle
  # Regular Handle was chosen so assgin UserAlias from GetThisUser
  Handle := UserAlias
  # Calculates the avaible space for the oneliner
  HandleLength := 80 - Length (UserAlias) - 4
Pend Get_Handle

#--------------------------------------------------------------------------#
Proc Get_Initials  
  Char   := copy(UserAlias, 1, 1)       # Gets the first Initial
  Handle := Handle + Char               # Appends first initial to char

  HandleSize := Length(UserAlias)       # Gets the Length of the handle
  Index := 2                            # Starts at the second letter
  repeat 
    #begin
      Char := copy(UserAlias, Index, 1) # Get the next Character
      If Char = ' ' then                # Was a blank detected
       #begin     
          Index := Index + 1            # Assumes next character is a Initial
          Char := copy(UserAlias, Index, 1)  # Get Initial
          Handle := Handle + Char            # Append the new Initial
       #end
      else Index := Index + 1                # Go to the next Character
      EndIf
    #end
  until Index > HandleSize 

  # The Users handle was one letter, so append a little something
  if length(Handle) <= 1 
    then Handle := Handle + '-'
    else Handle := Handle
  endif

  # Calculates the avaible space for the oneliner
  HandleLength := 80 - 2 - 4 
Pend Get_Initials

Proc Handle_Type
  # How should the handle be displayed
  if     OptF(6) = 'A' then Get_Anonymous  # Anonymous Handle chosen       
  elseif OptF(6) = 'H' then Get_Handle     # Regular Handle chosen
  elseif OptF(6) = 'I' then Get_Initials   # Initials Handle chosen  
  elseif OptF(6) = 'C' then                # User gets to select Handle
    #begin      
      repeat
        Str := StrF(13)           # Status Bar - Handle Format
        Write_Status              # Write it on screen 
        Clear_Input               # Clear the input window
        write (StrF(11))          # Input - Select Handle Format Opition
        Choose := Input (1, 1, 2, '')
        if     Choose = 'A' then Get_Anonymous # Anonymous Handle chosen
        elseif Choose = 'H' then Get_Handle    # Regular Handle chosen
        elseif Choose = 'I' then Get_Initials  # Initials Handle chosen 
        else
         #Begin
            Str := StrF(12)       # Status Bar - Invalid Key
            Write_Status          # Write it on screen  
            delay(450)            # Delay for a short time
            Str := ''             # Status Bar - Clear Invaild Key
            Write_Status          # Write it on screen
         #End
        endif              
      until Choose = 'A' or Choose = 'H' or Choose = 'I'
    #end
  endif
Pend Handle_Type

#--------------------------------------------------------------------------#
Proc Display_Middle
#Begin
  fOpen (1, bin, Reset, ANILocation + 'DA-LINE.DAT')   # Open DA-LINE.DAT

  DalineCurrent := filesize(1) / 78        # Current number of One-liners
  DalineMax := Str2Int (OptF(1))           # SysOp maximum # of One-liners

  # If the current file size of DA-LINE.DAT is > then the SysOp
  # specified number of one-liners then get the most recent
  # maximum number of One-liners. 

  if DalineCurrent > DalineMax
    #Begin
      fOpen (2, bin, Rewrite, ANILocation + 'DA-LINE.TMP') # Open DA-LINE.TMP
      fSeek (1, DalineCurrent - DalineMax * 78)
      for Position := 1 to DalineMax
        fReadRec (1, DalineData, 77)                   
        fWriteRec(2, DalineData, 77)                    
      fend
      fClose(1)                                          # Close DA-LINE.DAT
      fClose(2)                                          # Close DA-LINE.TMP
      fErase(ANILocation + 'DA-LINE.DAT')                # Erase DA-LINE.DAT
      OkCOPY := fCopy (ANILocation + 'DA-LINE.TMP',   
                       ANILocation + 'DA-LINE.DAT')      # *.TMP -> *.DAT  
      fErase(ANILocation + 'DA-LINE.TMP')                # Erase DA-LINE.TMP
      fOpen (1, bin, Reset, ANILocation + 'DA-LINE.DAT') # Open DA-LINE.DAT
      DalineCurrent := filesize(1) / 78
    #End
  endif
  
  # If the current number of one-liners is > ten, then
  # go back into DA-LINE.DAT 10 positions to get the 10 most
  # recent one-lines. Set fRecTen = to 10 to display 10 one-liners.
  # Set DalinePos = to Current One-Liner.
  # -------------------------ELSE----------------------------------
  # The current One-liners are less < ten, go back into DA-LINE.DAT
  # "DalineCurrent" positions to get the current number of One-liners.
  # Set fRecTen = to "DalineCurent" to display the current number of
  # One-liners.

  if DalineCurrent > 10 then
   #Begin   
      fSeek (1, DalineCurrent - 10 * 78)  # Go Back ten file records
      DalinePos := DalineCurrent - 9      # Holds current One-liner position
      fRecOrTen := 10                     # Display 10 One-liners
   #End
  else                              
   #Begin
      fSeek (1,0)                         # Start from first record
      Stupid := DalineCurrent - 1         
      DalinePos := DalineCurrent - Stupid # Holds Current One-liner position
      fRecOrTen := DalineCurrent          # Display current # of One-liners
   #End
  endif

  # Display 10 One-liners or X amount
  for Position := 1 to fRecOrTen
     fReadRec(1, DalineData, 77)           
     Insert(StrF(2) + StrF(4), DalineData, Pos(' ', DalineData))
     writeln(StrF(1) + StrF(3) + DalineData)
  fend
  fClose(1)                               # Close DA-LINE.DAT
#End
Pend Display_Middle

#--------------------------------------------------------------------------#
Proc Display_Daline
#Begin
  dispFile(ANILocation + '\DA-LINEH')  # Displays the header 
  If IsNoFile Then
    WriteLn ('|04DALINE ERROR: |06DA-LINEH.ANS not found.')
    WriteLn ('                 In ' + ANILocation)
    Char := Readkey
  EndIf
  HeaderY := WhereY - 1                # Starting Y of highlight bar

  Display_Middle                       # Displays the One-liners  

  dispFile(ANILocation + '\DA-LINEF')  # Displays the Footer
  If IsNoFile Then
    WriteLn ('|04DALINE ERROR: |06DA-LINEF.ANS not found.')
    WriteLn ('                 In ' + ANILocation)
    Char := Readkey
  EndIF
  FooterY := WhereY                    # Ending Y used for string placement  

  GotoXY (62, HeaderY)                 # Display the One-liner index
  writeln(StrF(6)+ DalinePos+ ' '+ StrF(7)+ ' '+ DalineCurrent+ StrF(8))    

  GotoXY(1, HeaderY + 1)               # Goto the first One-liner
  Get_BarON                            # Display highlight bar
#End
PEnd Display_Daline

#--------------------------------------------------------------------------#
Proc Input_Daline
#Begin 
  Clear_Input                             # Input - Clear Line
  Write(StrF(10))                         # prompt for Navigation
 
  CurrentY := 1                           # Initialize variable
  GetCharDone := true                     # Initialize variable
Repeat
     GetChar := ReadKey                   # Input one key
  
     if IsArrow then
        if  GetChar = 'H' then      
           Move_UP                        # Call proc Move_UP          
        elseif GetChar = 'P'         
           Move_DOWN                      # Call proc Move_DOWN
        elseif GetChar = 'K'         
           Move_LEFT                      # Call proc Move_LEFT
        elseif GetChar = 'M'         
           Move_RIGHT                     # Call proc Move_RIGHT
        endif 
     elseif GetChar = chr(97) or GetChar = chr(65)
       #Begin
          Handle_Type                     # What type of handle [A, H, I]
          Str := StrF(14)                 # Status Bar - Enter One-liner
          Write_Status                    # Write it on screen  
          Clear_Input                     # Clear Input window
          Write(StrF(1) + StrF(3) + Handle + StrF(2) + ' ') 
          DaLineText := Input(HandleLength, HandleLength, 11, '')
          GetCharDone := false            # flag false to end repeat

          if DaLineText = '' then         # If the oneliner is blank exit
           #Begin
              Str := StrF(15)             # Status Bar - Aborted One-liner 
              Write_Status                # Write it on screen
              Delay(450)                  # Delay a while
              Exit_Daline                 # Display BBs Information
              Halt                        # Exit
           #End
          endif
        #End
     elseif GetChar <> Chr(27) and GetCharDone then
        #Begin
           Str := StrF(12)                # Status Bar - Invalid Key
           Write_Status                   # Write it on screen  
           delay(450)                     # Delay for a short time
           Str := ''                      # Status Bar - Clear Invaild Key
           Write_Status                   # Write it on screen
        #End         
     elseif GetCharDone then
        #Begin
           Exit_Daline                    # Display BBs Information
           Halt                           # Exit
        #End
     endif #Check Input
until not GetCharDone 
#End
PEnd Input_Daline

#--------------------------------------------------------------------------#
Proc Censor_One_Liner
#Begin
  fOpen(1, Text, Reset, ANILocation + 'DA-LINE.CEN')

  # Stores a copy of variable DalineText in upper case to work
  # around the searching of lower and upper case characters
  DalineUP := upper(DalineText)  
    
  While Not Eof(1)
    fReadLn(1, CensorData)
    CensorPos := Pos(Upper(CensorData), DaLineUP)

    # If CensorPos equals 0 then there were no words to censor
    # in the one-liner, otherwise we found the censored word.
    # Depending on the users choice, the word gets Deleted or 
    # gets replaced with the user defined character in its place.
    If CensorPos > 0 then
      If Upper(OptF(4)) = 'Y'
        then 
          #Begin
            if Copy(DalineUP, CensorPos + Length(CensorData), 1) = '.' or
               Copy(DalineUP, CensorPos + Length(CensorData), 1) = '"' or
               Copy(DalineUP, CensorPos + Length(CensorData), 1) = '''' or
               Copy(DalineUP, CensorPos + Length(CensorData), 1) = '!' or
               Copy(DalineUP, CensorPos + Length(CensorData), 1) = '?' or
               Copy(DalineUP, CensorPos + Length(CensorData), 1) = ',' or
               Copy(DalineUP, CensorPos + Length(CensorData), 1) = ';' 
            then Delete(DalineText, CensorPos - 1, Length(CensorData) + 1)
            else Delete(DalineText, CensorPos, Length(CensorData) + 1)
            endif
          #End
        else 
         #Begin
          Delete(DalineText, CensorPos, Length(CensorData))
          CensorChar := copy (OptF(5), 1, 1)
          Insert(PadLT('', Length(CensorData), CensorChar), DalineText, CensorPos)
         #End
      Endif
    EndIf
  Wend
  fClose(1)
#end
Pend Censor_One_liner

#--------------------------------------------------------------------------#
Proc Write_One_liner
#begin  
  DalineText    := Handle + ' ' + DalineText   # Holds the new One-liner

  fOpen(1, bin, reset, ANILocation + 'DA-LINE.DAT')  # Open DA-LINE.DAT

  if DalineMax > DalineCurrent then
   #Begin
      fseek (1, filesize(1))              # Goto the end of the file
      fWriteRec(1, DalineText, 77)        # Append the new One-liner
   #End
  else
    #Begin           
      DalineCurrent := DalineCurrent - 1  # Maximum One-liners - 1
      for Position := 1 to DalineCurrent
        fSeek(1, Position * 78)           # Forward One file record 
        fReadRec (1, DalineData, 77)      # Read current record 
        fSeek(1, Position -1 * 78)        # Backwards Two file records
        fWriteRec(1, DalineData, 77)      # Write current record 
      fend  
      fWriteRec(1, DalineText, 77)        # Append Maximum new One-liner
    #End
  endif
  fClose(1)                               # Close DA-LINE.DAT
  Exit_Daline                             # Display BBs Information
#End
PEnd Write_One_Liner

###############################
# START of main program block #
###############################
#Begin
  # User doesn't have ansi emulation then display message and exit
  if Graphics = 0 then
     Writeln('')
     Write('Ansi Graphics is Required to run Da-line 1.00b6!')
     Char := ReadKey
     Halt
  endif

  Path_Get                # Get Path
  Exist_Config_File       # Does Configuration file exist
  Exist_String_File       # Does String file exist
  Exist_Censor_File       # Does Censor file exist
  Read_Config_File        # Lets get rolling
  Read_String_File        # Lets get the ball into gear
  Display_Daline          # Display DA-LINE
  Input_Daline            # Get User input
  If upper(OptF(3)) = 'Y' # Censor One-liner??
   Censor_One_Liner        # Yep! #
  EndIf                    # Nope! # 
  Write_One_liner         # Write new One-liner!!
#End

