                                 title CTRLALT
cseg segment
         assume cs:cseg, ds:cseg
         org 100H
begin:   jmp install
         ascbuffer label byte
db 13,'CTRLALT Version 1.00   April, 1986',13,10
db       'Copyright R.M.Wilson and B.Simon',26
;--------------------------------------------------------------------------
background = 1FH             ;    CHANGE COLORS
mainattr = 30H               ;   HERE FOR ASCII
border = 19H                 ;      TABLES  
attrlabel=1BH

monobackground = 07H         ;    CHANGE MONOCHROME 
monomainattr = 70H           ;        ATTRIBUTES
monoborder = 0FH             ;           HERE

colxor = 2AH                 ; Attributes to XOR for highlighting
monoxor = 77H                ;        for ^@P and ^@<Enter>
asccolxor = 5FH              ;      ...and, respectively,
ascmonoxor =  0FFH           ;     for ASCII tables (^@A and H).

colcopyattr = 1EH            ; When COPY command is used.  1EH=Yellow/Blue
monocopyattr = 07H           ;         07H=White/Black

begoff = 246       ;Offset for upper left corner of decimal ASCII table.
hexbegoff = 166    ;Ditto for hex.               
attrbegoff= 1546   ;Ditto for Attribute table.
ansibegoff= 1610   ;Ditto for ANSI table.

callcombo = 0CH    ;0CH for Ctrl-Alt, 06H for Ctrl-Shift, 0AH for Shift-Alt.
;------------------------------------------------------------------------
              ;**** DEFAULTS
attrchar   db 24      ;Character used initially by CTRL-ALT-T
drawmode   dw 1       ;0-6   Initial mode for Box Drawing (ALT-NUMPAD). 
drawdown   db 0       ;For Alt-Grey:   1=dn/rt, 0=neutral, -1=up/lf
              ;Following are for CTRL-ALT-I
fastflag   db 0FFH    ;0 if slow, 0FFH if fast inserting is wanted.
carretflag db 0FFH    ;0 if backspacing, 0FFH if carriage returns are wanted.
;-------------------------------------------------------------------------
              ;**** SCAN CODES FOR COMMAND KEYS FOLLOW:
commands db 1FH,2EH,25H,18H,1EH,19H,23H,43H
         db 1CH,17H,10H,0CH,0DH,30H,12H
         db 0BH,2,3,4,5,6,7
         db 14H,13H,8,9,0AH
         db 2FH,2CH,31H
              ;**** CORRESPONDING SUBROUTINES TO JUMP TO:
comaddr  dw  Switch,Copy,Kill,Otherasc,decAsc,Print,Hexasc,back2dos
         dw  cUt,Insert,stopstart,slowspeed,fastspeed,Backsp,asciiEnter
         dw  setdraw,setdraw,setdraw,setdraw,setdraw,setdraw,setdraw
         dw  showaTtrs,carRets,setdrawup,unsetdrawdown,setdrawdown
         dw  Vanilla,Zilch,showaNsi
;-------------------------------------------------------------------------
              ;**** SCAN CODES FOR CTRL-ALT-P  SUBCOMMANDS FOLLOW:
prtcoms db 1CH,19H,50H,48H,49H,51H,1EH,1,1FH,4FH,47H,13H
begincodes label byte ;Control codes to prn only below.
        db 30H,11H,2EH,20H,14H,3H,16H,9H
        db 25H,2,21H,12H,17H,10H,31H,18H
              ;**** CORRESPONDING SUBROUTINES TO JUMP TO:
prtaddr dw enter,enter,dnarr,uparr,pgup,pgdn,all,esc,pswitch,pend,phome,reset
codeaddr dw bold,wide,cond,dstrike,tiny,charset2,underline,lf8   
         dw skipperf,unidir,topform,emph,pica,qual,newpage,alloff
;-------------------------------------------------------------------------
              ;**** SCAN CODES FOR CTRL-ALT-ENTER SUBCOMMANDS FOLLOW:
cutcoms db   16H,50H,48H,4DH,4BH,1H,52H,1CH,17H,37H
        db   19H,49H,51H,4EH,4AH,2EH,1FH,47H,4FH
        db   12H
              ;**** CORRESPONDING SUBROUTINES TO JUMP TO:
cutaddr dw ccut,cdnarr,cuparr,crtarr,clfarr,cesc,tack,tack,immenter,prtbox
        dw prtbox,cpgdn,cpgup,cgplus,cgminus,ccopy,cswitch,home,end
        dw immenter
;-------------------------------------------------------------------------
              ;**** SCAN CODES FOR CTRL-ALT-A/H SUBCOMMANDS FOLLOW:
asccoms db  30H,12H,48H,50H,4DH,4BH,37H,19H,1
        db  47H,4FH,1CH
              ;**** CORRESPONDING SUBROUTINES TO JUMP TO:
ascaddr dw  ascbuff,ascins,ascup,ascdn,ascrt,asclf,ascprn,ascprn,ascesc
        dw  aschome,ascend,ascins
;------------------------------------------------------------------------------
bold        db  27,69,27,71,0FFH    ;emph & double strike          
dstrike     db  27,71,0FFH
underline   db  27,45,1,0FFH
tiny        db  27,83,1,27,65,5,27,50,15,0FFH
lf8         db  27,48,0FFH
charset2    db  27,54,0FFH
cond        db  15,0FFH
wide        db  27,87,1,0FFH
skipperf    db  27,78,8,0FFH
unidir      db  27,85,1,0FFH
topform     db  12,0FFH
emph        db  27,69,0FFH
pica        db  27,58,0FFH    ;proprinter
qual        db  27,73,2,0FFH  ;proprinter
newpage     db  27,52,0FFH    ;proprinter
alloff      db  27,70,27,72,18,27,87,0,27,84,27,79,27,55
            db  27,45,0,27,65,12,27,50,27,73,0,13,0FFH
;####################################################################
         oldvec = 5CH
         oldtvec= 60H
;####################################################################
on_flag  db 0   ;1--Marking, 2--^@P
myint:   push ax                       ;Replacement for Interrupt 9.
         push ds
         sub ax,ax
         mov ds,ax
         mov al,ds:[417H]
         and al,0FH            
         cmp al,callcombo             
         je readport
         cmp al,8  ;alt      
         jne exit
         cmp cs:drawmode,0
         je exit
         in al,60H
         sub al,47H
         jc exit
         cmp al,11
         ja exit
         jmp draw
readport:in al,60H ;Read port to see what happened.
         push bp
         cld
         xor bp,bp
         ck:cmp al, cs:commands[bp]
         je lets_go
         inc bp
         cmp bp,offset comaddr - offset commands ;number of commands
         jl ck 
         pop bp
exit:    pop ds
         pop ax
         jmp dword ptr cs:[oldvec]     
lets_go: push es
         push bx
         push cx
         push dx
         push si
         push di
         call reset_keyboard
         shl bp,1
         jmp cs:comaddr[bp]
reset_keyboard:
         cli
             in al,61H    ;This stuff is necessary for PC and XT  
             mov ah,al    ;...could be omitted for AT.            
             or al,80H 
             out 61H,al
             xchg ah,al
             out 61H,al
         mov al,20H
         out 20H,al
         sti                      
         ret
;==========================================
back2dos:mov ah,4CH
         int 21H
;==========================================
vanilla: mov ax,0B000H
         mov es,ax
         mov al,7
         jmp short l34
copy:    call aim
         rep movsw
         l34:mov di,1
         mov cx,2000
         clr:stosb
         inc di
         loop clr
         jmp short endint
kill:    call aim
         mov ax,720H
         rep stosw
         jmp short endint
                     aim: mov cx,2000   ;Sets cx,es,ds,si=di=0,al,xorattr
                          mov ax,0B000H
                          xor si,si
                          xor di,di
                          mov ds,di
                          mov bl,byte ptr ds:[410H]
                          mov ds,ax
                          mov es,ax
                          add ah,8H
                          test bl,10H
                          je cmon
                          mov es,ax
                          mov cs:xorattr,monoxor 
                          mov al,colcopyattr
                          ret
                     cmon:mov ds,ax       ;color monitor in use
                          mov cs:xorattr,colxor
                          mov al,monocopyattr
                          ret
;==========================================
endint:  pop di
endint2: pop si
         pop dx
         pop cx
         pop bx
         pop es
         pop bp
         pop ds
         pop ax
         iret
;==============================
switch:  call aim ; sets si,di,cx,bl
         push bx  ;  get cursor
         push cx
         mov ah,3
         xor bh,bh
         int 10H
         mov ch,20H   ;turn off cursor
         mov ah,1
         int 10H
         pop cx
         pop bx
         push ds
         mov ds,di
         xor bl,10H
         mov ds:[410H],bl
         pop ds
         mov ax,3
         int 10H
         xor di,di             
         rep movsw
         mov ah,2   ;set cursor at dx
         xor bh,bh
         int 10H
         jmp endint
;==========================================
xorxor = colxor XOR monoxor
xorattr db 44H
print:   test cs:on_flag,2
         je ov274
         jmp endint
         ov274:or cs:on_flag,2
         xor dx,dx
         mov ah,2
         int 17H
         test ah,8
         jne badprn
         test ah,20H
         je ov678
         badprn:mov ax,0E07H
         int 10H
         jmp esc
         ov678:call aim
         push ds
         pop es
         xor bh,bh
         mov ah,3
         int 10H     ;dh is cursor row
         mov ax,160
         mul dh
         mov dx,ax
         inc dx
         mov bp,1    ;number of marked rows
marknwait:call mark
         xor ah,ah
         int 16H
         call mark
         xor bx,bx
         comp:cmp ah, cs:prtcoms[bx]
         je gotcom
         inc bx
         cmp bx,offset prtaddr -offset prtcoms    ;no. of commands
         jl comp
         jmp marknwait
gotcom:  cmp bx,offset begincodes - offset prtcoms 
         jge sendcodes 
         shl bx,1
         jmp cs:prtaddr[bx]
sendcodes:push si
         push dx
         sub bx,offset begincodes - offset prtcoms
         shl bx,1
         mov si,cs:codeaddr[bx]
         xor dx,dx       
      more:xor ah,ah      
         mov al,cs:[si]  
         inc si          
         cmp al,0FFH     
         je done2        
         int 17H         
         jmp more        
reset:   push si
         push dx
         xor dx,dx
         mov ah,1
         int 17H
     done2:pop dx
         pop si
         jmp marknwait
pend:    mov ax,bp
         mov dx,1+160*25
         mov bl,160
         mul bl
         sub dx,ax
      jmw:jmp marknwait
phome:   mov dx,1
         jmp marknwait
pswitch: mov ax,es   
         xor ah,8H
         mov es,ax
         xor cs:xorattr,xorxor
         jmp marknwait
dnarr:   inc bp
         mov bx,bp
         mov ax,160
         mul bl
         add ax,dx
         cmp ax,4160
         jle jmw
         dec bp
         jmp marknwait
uparr:   dec bp
         jne jmw
         inc bp
         jmp marknwait
pgup:    sub dx,160
         jge jmw
         add dx,160
         jmp marknwait
pgdn:    mov ax,bp
         mov bl,160
         mul bl
         add ax,dx
         cmp ax,4000
         jg jmw
         add dx,160
         jmp marknwait
all:     mov dx,1
         mov bp,25
enter:   push es   ;start si-1 offset, do bp lines
         pop ds
         mov si,dx
         xor dx,dx
         dec si
         mn:mov cx,80
         up9:lodsb
         xor ah,ah
         mov bl,al    ;Filter out ASCII 0-1F, 80-9F.
         and bl,7FH
         cmp bl,20H
         jae ov134
         mov al,20H
         ov134:int 17H
         inc si
         loop up9
         mov ax,0DH
         int 17H
         mov ax,0AH
         int 17H
         dec bp
         jne mn
esc:     and cs:on_flag,0FDH
         jmp endint
                     mark:  mov si,bp
                            mov di,dx
                            mov al,cs:xorattr
                            up3:mov cx,80
                            up4:xor byte ptr es:[di],al
                            inc di
                            inc di
                            loop up4
                            dec si
                            jnz up3
                            ret
;=====================================================
numrows dw 0
numcols dw 0
upleft  dw 0
screen dw 0B800H
showattrs:
         cmp cs:asciionflag,0
         je ov76
         jmp ei
         ov76:mov cs:asciionflag,'T'
         mov cs:upleft,attrbegoff
         call attrsetup
         call fewhexnos
         wt:call attrdisplay
         xor ah,ah
         int 16H
         cmp ah,1H
         je ov39
         mov di,attrbegoff+12
         mov cs:attrchar,al
         mov dx,ax    ;save
         mov si, offset scan
         mov ah,attrlabel
         call write4
         call hexndec
         mov di,attrbegoff+1610
         mov si,offset ascii
         mov cx,5
         call write
         mov dh,dl
         call hexndec
         jmp wt
         ov39:jmp restore
hexndec: inc di
         inc di
         mov bh,dh
         call showbx
         mov al,'H'
         stosw
         add di,4
         mov al,dh
         call decshowal
         ret
write4:  mov cx,4
write:   lods byte ptr cs:[si]
         stosw
         loop write
         ret
scan db 'Scan'
ascii db 'Ascii'
otherasc:call aim
         push es
         pop cs:screen
         push cs:upleft
         push cs:numrows
         push cs:numcols
         call decload
         call monoclear    ;and border
         call display
         call hexload
         call monoclear    ;and border
         call hexdisplay
         pop cs:numcols
         pop cs:numrows
         pop cs:upleft
         ei:jmp endint
decasc:  cmp cs:asciionflag,0
         jne ei
         call aim
         push ds
         pop cs:screen
         call decload
         call savenclear       ;and border
         call display          ;and numbers
         jmp asciiwait 
hexasc:  cmp cs:asciionflag,0
         jne ei
         call aim
         push ds
         pop cs:screen
         call hexload
         call savenclear       ;and border
         call hexdisplay       ;and hexnums
         jmp asciiwait 
decload: mov cs:upleft,begoff
         mov cs:numrows,15
         mov cs:numcols,34
         ret
hexload: mov cs:upleft,hexbegoff
         mov cs:numrows,19
         mov cs:numcols,22
         ret
savenclear: mov ax,cs:screen
         mov ds,ax
         push cs
         pop es
         mov di,offset store
         mov si,cs:upleft      ;save
         mov bp,cs:numrows
         up81:mov cx,cs:numcols
         rep movsw
         add si,160
         sub si,cs:numcols
         sub si,cs:numcols
         dec bp
         jnz up81
    monoclear:mov ax,cs:screen
         mov es,ax
         mov di,cs:upleft            ;background and ascii chars
         mov bp,cs:numrows                   ; no. of rows
         mov al,20H
         mov ah,background
         cmp cs:screen,0B000H
         jne row
         mov ah,monobackground
         row:mov cx,cs:numcols
         rep stosw
         add di,160
         sub di,cs:numcols
         sub di,cs:numcols
         dec bp
         jnz row
         mov ax,cs:numcols    ;Do border.
         dec ax
         dec ax
         shl ax,1
         mov bx,ax    ;colb
         neg ax
         add ax,156
         mov dx,ax    ;rest
         mov di,cs:upleft
         mov ah, border
         cmp cs:screen,0B000H
         jne ov737
         mov ah,monoborder
         ov737:mov al,201
         stosw
         call horiz
         mov al,187
         stosw
         mov di,cs:upleft
         mov cx,cs:numrows
         dec cx
         dec cx
         mov al,186
         add di,160
         up0:stosw
         add di,bx  ;colb
         stosw
         add di,dx  ;rest
         loop up0
         mov al,200
         stosw
         call horiz
         mov al,188
         stosw
         ret
   horiz:   mov cx,cs:numcols
            dec cx
            dec cx
            mov al,205
            rep stosw
            ret
;=========================
attrdisplay:
         xor bl,bl
         mov di,cs:upleft
         add di,328
         mov bp,8
         mov al,cs:attrchar
         wrr:call eightattr
         inc di
         inc di
         call eightattr
         add di,126
         dec bp
         jnz wrr
         ret 
           eightattr:mov cx,8
                   ffff:mov ah,bl
                   cmp cs:asciionflag,'N'
                   jne ov764
                        push bx    ;This routine converts ah to 'ansi'
                        mov bl,ah 
                        and bx,0FH
                        mov dl,cs:ansiperm[bx]
                        push cx
                        mov cl,4
                        shr ah,cl
                        mov bl,ah
                        mov ah,cs:ansiperm[bx]
                        shl ah,cl
                        pop cx
                        add ah,dl
                        pop bx
                   ov764:stosw
                   inc bl
                   loop ffff
                   ret             
;----------------------------------------------------
attrsetup:call aim
         push ds
         pop cs:screen
         mov cs:numrows,11                       
         mov cs:numcols,22
         call savenclear   ;and border
         ret
showansi:
         cmp cs:asciionflag,0
         je ov732
         jmp ei
         ov732:mov cs:asciionflag,'N'
         mov cs:upleft,ansibegoff
         call attrsetup
         mov di,168+ansibegoff
         mov ah,2
         up333:mov cx,8
         mov al,'0'
         up891:stosb
         inc di 
         inc al
         loop up891
         inc di
         inc di
         dec ah
         jne up333
         mov di,322+ansibegoff   
         mov cl,8
         mov al,'0'
         up99:mov byte ptr es:[di],'4'
         inc di
         inc di
         stosb
         add di,157
         inc al
         loop up99
         add di,18
         mov ah,attrlabel 
         mov si,offset ansilabel
         call write4 
         mov di,12+ansibegoff
         mov si,offset ansihead1
         call write4
         add di,10
         mov si,offset ansihead2
         call write4
         call attrdisplay
         xor ah,ah
         int 16H
         jmp restore
ansihead1  db '0;3x'
ansihead2  db '1;3x'
ansilabel  db 'ANSI'
ansiperm   db 0,0100B,0010B,0110B,0001B,0101B,0011B,0111B
           db 1,1100B,1010B,1110B,1001B,1101B,1011B,1111B  
;======================================================
display: xor bl,bl          ;char counter
         mov di,cs:upleft
         add di,170
         mov bp,13
      writeasc:
         call fivech
         call fivech
         add di,10
         call fivech
         call fivech
         add di,102
         dec bp
         jnz writeasc
numbers:     ;for ASCII table
         mov di,begoff+166
         mov cl,13
         mov al,'0'
         call numtype
         mov di,begoff+164
         mov cl,13
         up55:stosb
         add di,33
         inc al
         stosb
         add di,125
         inc al
         cmp al,39H
         jle ok
         sub al,10
         ok:loop up55
         mov di,begoff+162
         mov cl,5
         mov al,30H
         call numtype
         mov cl,5
         inc al
         call numtype
         inc al
         mov cl,3
         call numtype
         ret 
             numtype:stosb
                add di,33
                stosb
                add di,125
                loop numtype
                ret
hexdisplay:mov bl,0
         mov di, cs:upleft
         add di,328
         mov bp,16
         wr:call eightch
         call eightch
         add di,124
         dec bp
         jnz wr
hexnumbers:mov di,168+hexbegoff
         call puthexhead
         mov di,322+hexbegoff
         mov si,offset hexheader
         mov cx,16
         up112:movs es:byte ptr[di], cs:[si]
         inc di
         mov byte ptr es:[di],'0'
         add di,158
         loop up112
         ret
                        eightch:mov cx,8
                        jmp short ov898
                        fivech:mov cx,5
                        ov898:mov ah,mainattr
                        cmp cs:screen,0B000H
                        jne ov899
                        mov ah,monomainattr
                        ov899:mov al,bl
                        stosw
                        inc bl
                        loop ov899
                        inc di
                        inc di
                        ret
fewhexnos:mov di,168+attrbegoff
         call puthexhead
         mov di,322+attrbegoff   
         mov cx,8
         mov al,'0'
         up02:stosb
         inc di
         mov byte ptr es:[di],'0'
         add di,158
         inc al
         loop up02
         ret
puthexhead:mov cx,8
         mov si,offset hexheader
         ytr:movs es:byte ptr[di], cs:[si]
         inc di
         loop ytr
         inc di
         inc di
         mov cl,8
         lp9:movs es:byte ptr[di], cs:[si]
         inc di
         loop lp9
         ret
hexheader db '0123456789ABCDEF'
                      showbx:mov cx,2   ;cx 4 or 2 shows bx or bh
                             llp:rol bx,1
                             rol bx,1
                             rol bx,1
                             rol bx,1
                             push bx
                             and bx,000FH
                             mov al,cs:hexheader[bx]
                             mov ah,attrlabel
                             stosw
                             pop bx
                             loop llp
                             ret
                   decshowal:    ;converts al to decimal
                             aam
                             mov bl,al
                             or bl,'0'             
                             xchg al,ah            
                             aam
                             or ax,'00'            
                             mov dh,al             
                             mov al,ah             
                             mov ah,attrlabel      
                             stosw                 
                             mov al,dh             
                             stosw                 
                             mov al,bl             
                             stosw                 
                             ret                   
;--------------------------------------------------------------------------
asciicuroff dw begoff+171
asciihexcuroff dw  hexbegoff+329
asciionflag db 0
ascbuffptr dw 0
asciitowrite db 0                    ;flag
asciiwait:mov cs:asciionflag,0FFH    ;set it
         mov cs:buffflag,0
         mov di,cs:asciicuroff
         mov ax,es
         cmp cs:upleft,begoff
         je ov734
         mov di,cs:asciihexcuroff
         ov734:mov bh,asccolxor
         mov ax,ds
         cmp ah,0B8H ;color?
         je amark
         mov bh,ascmonoxor
    amark:cmp cs:upleft, begoff
         je ov87
         mov cs:asciihexcuroff,di
         jmp short ov88
         ov87:mov cs:asciicuroff,di
         ov88:xor es:[di],bh
         xor ah,ah
         int 16H
         xor es:[di],bh
         xor bp,bp
         asccomp:cmp ah,cs:asccoms[bp]
         je ascgotcom
         inc bp
         cmp bp,offset ascaddr - offset asccoms ;no. of commands
         jl asccomp
         jmp amark
ascgotcom:shl bp,1
         jmp cs:ascaddr[bp]
ascup:   sub di,160          ;UpArr
         ch2:or di,di
         jge amark
         add di,160 
         jmp short amark
ascdn:   add di,160          ;DnArr
         ch1:cmp di,4000
         jl amark
         sub di,160
         jmp short amark
ascrt:   inc di            ;RtArr
         inc di
         jmp short ch1
asclf:   dec di
         dec di            ;LfArr
         jmp short ch2
aschome: cmp cs:upleft,begoff
         je ov91
         mov di,hexbegoff+329    
         jmp amark
         ov91:mov di,begoff+171  
         jmp amark
ascend:  cmp cs:upleft,begoff
         je ov92
         mov di,hexbegoff+329+2432    
         jmp amark
         ov92:mov di,begoff+329+1816    
         jmp amark
ascins:  cmp cs:buffflag,0
         jne ov71                      
         mov cs:ascbuffptr,0
         ov71:call getasc
         mov cs:ascwriteptr,0
         mov cs:asciitowrite,0FFH      ;set it
         mov cs:worktodoflag,0FFH
ascesc:  jmp restore
ascprn:  xor dx,dx            ;PrtSc
         xor ah,ah
         mov al,es:[di-1]
         int 17H
         jmp amark
asciienter:mov cs:ascwriteptr,0
         mov cs:asciitowrite,0FFH    ;set it
         mov cs:worktodoflag,0FFH
         jmp endint
buffflag db 0
ascbuff: cmp cs:buffflag,0
         jne ov36
         not cs:buffflag
         mov cs:ascbuffptr,0
         ov36:call getasc
         jmp amark
getasc:  mov al,es:[di-1]          ;get char from screen; put in buffer
         mov bp,cs:ascbuffptr      ;location for next char
         cmp bp,64
         jl ov23
         pop ax 
         jmp restore
         ov23:mov byte ptr cs:ascbuffer[bp],al
         inc cs:ascbuffptr
         ret
ascwriteptr dw 0                                        
ent2:    mov bx,cs:ascwriteptr
         mov al,cs:ascbuffer[bx]    
         xor ah,ah                  ;Move word (char. and scan code)
         mov word ptr ds:[bp],ax    ;into buffer and
         mov ds:[1CH],cx            ;change buffer tail pointer.
         inc cs:ascwriteptr
         inc bx
         cmp bx,cs:ascbuffptr
         jge ov13
         jmp send
         ov13:mov cs:asciitowrite,0
         jmp done
;----------------------------------------------------------------------
restore: push cs
         pop ds
         mov si,offset store
         mov di,upleft 
         mov bp,numrows
         up65:mov cx,numcols
         rep movsw
         add di,160
         sub di,numcols
         sub di,numcols
         dec bp
         jnz up65
         mov asciionflag,0
         jmp endint
;=========================================================================
stopstart:not cs:worktodoflag    
         jmp endint
slowspeed:mov cs:fastflag,0
         jmp endint
fastspeed:mov cs:fastflag,0FFH
         jmp endint
backsp:  mov cs:carretflag,0
         jmp endint
carrets: mov cs:carretflag,0FFH
         jmp endint
zilch:   mov cs:carretflag,'Z' 
         jmp endint
;--------------------------------
stuffptr dw 0
tnumrows dw 0
rowptr dw 0
tnumcols dw 0
colptr dw  0
worktodoflag db 0
goingbackflag db 0
downflag db 0
docrflag db 0
timeint: cmp cs:worktodoflag,0  
         je tend
         cld 
         sti
         push ds
         push cx
         push bx
         push ax
         push bp
         mov bp,40H
         mov ds,bp
loo:     mov bp,ds:[1CH]
         mov cx,bp
         inc cx
         inc cx
         cmp cl,3EH
         jl ov
         sub cl,20H
      ov:cmp cx,ds:[1AH]
         je send                  ;If equal, buffer full; exit.
         cmp cs:asciitowrite,0
         je ov9
         jmp ent2
         ov9:cmp cs:stuffptr,0    
         je done                  
         call getword             ;Else, move word (char. and scan code)
         mov word ptr ds:[bp],ax  ;     into buffer and
         mov ds:[1CH],cx          ;     change buffer tail pointer.
         cmp cs:rowptr,0
         je done
         cmp cs:stuffptr,0 
         jle done
         cmp cs:fastflag,0
         jz send
         jmp loo
done:    mov cs:worktodoflag,0
send:    pop bp
         pop ax
         pop bx
         pop cx
         pop ds
tend:    jmp dword ptr cs:[oldtvec] 
getword: cmp cs:carretflag,'Z'
         jne b99
         xor ah,ah
         mov bx,cs:stuffptr
         mov al,cs:stuff[bx]
         dec cs:stuffptr
         ret 
         b99:cmp cs:docrflag,0       ;See if we need a Carriage Return.
         je b0
         mov cs:docrflag,0
         mov ax,1C0DH
         jmp b6 
         b0:cmp cs:downflag,0        ;See if we need a DownArrow.
         je b1
         mov cs:downflag,0
         mov ax,5000H     ;DnArr
         b6:mov bx,cs:tnumcols                
         mov cs:colptr,bx
         rr:ret
         b1:cmp cs:goingbackflag,0   ;See if we need LeftArrow.
         je b2
         mov ax,4B00H     ;LfArr
         dec cs:colptr
         jne rr   
         mov cs:downflag,0FFH  ;Need a down next.
         mov cs:goingbackflag,0
         ret
         b2:xor ah,ah          ;Get character from stuff.
         mov bx,cs:stuffptr   
         mov al,cs:stuff[bx]
         dec cs:stuffptr
         dec cs:colptr
         jnz rr
         dec cs:rowptr         ;Another row to do if this not zero.
         jz rr
         cmp cs:carretflag,0
         je b3
         mov cs:docrflag,0FFH
         ret
         b3:mov cs:goingbackflag,0FFH   ;go back 
         mov bx,cs:tnumcols                
         mov cs:colptr,bx
         ret 
;=====================================================
prtbox:  call setup        ;bp=no.cols, cx=no.rows
         mov bx,cx
         dec si            ;offset to begin
         xor dx,dx
         up71:mov cx,bp
       lp6:lodsb
         mov ah,0
         int 17H
         inc si
         loop lp6
         mov ax,0DH
         int 17H
         mov ax,0AH
         int 17H
         add si,160
         sub si,bp
         sub si,bp
         dec bx
         jnz up71
         jmp cesc
;========================================================
ccopy:   call setup   ;cx no. rows, bp no. cols
         dec si
         mov di,si
        lp08:mov dx,bp  ;no. cols
        up13:movsb
         inc di
         inc si
         dec dx
         jnz up13
         add si,160
         sub si,bp
         sub si,bp
         mov di,si
         loop lp08
         jmp cesc
;----------------------------------------------
cswitch: push es
         push ds
         pop es
         pop ds
         xor cs:xorattr,xorxor
         jmp cmarknwait
;----------------------------------------------------
immenter:call cccut
         and cs:on_flag,0FEH
insert:  cli
         push cs
         pop ds
         mov worktodoflag,0FFH
         mov asciitowrite,0
         mov bx,tnumcols
         mov colptr,bx
         mov ax,tnumrows
         mov rowptr,ax
         mul bl
         mov stuffptr,ax 
         mov goingbackflag,0
         mov downflag,0
         sti
         jmp endint
;------------------------------------------------------
beginflag db 0
cut:     test cs:on_flag,1
         je ov284
         jmp endint
         ov284: or cs:on_flag,1
         mov cs:beginflag,0
         call aim     ;ds points to screen
         mov ah,3
         xor bh,bh
         int 10H      ;cursor row, col in dx  (upper left of box)
         mov bx,dx    ;bx contains row, col of lower right
cmarknwait:call markbox
         xor ah,ah
         int 16H
         push ax
         call markbox
         pop ax
         xor bp,bp
         ccomp:cmp ah,cs:cutcoms[bp]
         je gotcutcom
         inc bp
         cmp bp,offset cutaddr - offset cutcoms  ;no. of commands 
         jl ccomp
         jmp cmarknwait
gotcutcom:shl bp,1
         jmp cs:cutaddr[bp]
cdnarr:  cmp bh,24
         jge j1
         inc bh
         cmp cs:beginflag,0
         jne j1
         mov dx,bx
         j1:jmp cmarknwait
cuparr:  cmp cs:beginflag,0
         jne ov6
         or bh,bh
         je j1
         dec bh
         dec dh
         jmp cmarknwait
         ov6:cmp bh,dh
         jle j1
         dec bh
         jmp cmarknwait
crtarr:  cmp bl,79
         jge j1
         inc bl
         cmp cs:beginflag,0
         jne j1
         mov dx,bx
         jmp cmarknwait
clfarr:  cmp cs:beginflag,0
         jne ov7
         or bl,bl
         je j1
         dec bl
         dec dl
         jmp cmarknwait
         ov7:cmp bl,dl
         jle j1
         dec bl
         jmp cmarknwait
home:    sub bx,dx
         xor dx,dx
         jmp cmarknwait
end:     mov ax,184FH
         sub ax,bx
         add bx,ax
         add dx,ax
         jmp cmarknwait
tack:    cmp cs:beginflag,1
         je ccut
         mov cs:beginflag,1
         jcm:jmp cmarknwait
ccut:    call cccut
cesc:    and cs:on_flag,0FEH
         jmp endint
     cccut:
         call setup   ;bp=no.cols, cx=no.rows
         mov cs:tnumrows,cx
         mov cs:tnumcols,bp
         mov bx,cx
         dec si               ;offset to begin
         mov di,offset stuff         
         mov ax,bp
         mul bl
         mov cs:stuffptr,ax   ;no.chars
         add di,ax
         mm:mov al,ds:[si]
         mov cs:[di],al
         dec di
         inc si
         inc si
         dec bp
         jnz mm
         mov bp,cs:tnumcols
         add si,160
         sub si,bp
         sub si,bp
         loop mm
         ret
cpgdn:   or dh,dh
         je jcm
         dec dh
         dec bh
         jmp cmarknwait
cpgup:   cmp bh,24
         je jcm
         inc dh
         inc bh
         jmp cmarknwait
cgplus:  cmp bl,79
         je  jcm
         inc bl
         inc dl
         jmp cmarknwait
cgminus: or dl,dl
         je jcm
         dec dl
         dec bl
         jmp cmarknwait
                   markbox:  call setup
                             mov al,cs:xorattr
                             nextrw:mov di,bp
                             xx:xor byte ptr ds:[si],al
                             inc si
                             inc si
                             dec di
                             jnz xx
                             add si,160
                             sub si,bp
                             sub si,bp
                             loop nextrw
                             ret
                    setup:   mov al,dh    ;start rows
                             mov cl,dh
                             mov bp,dx    ;bp=start col in low byte
                             and bp,0FFH
                             mov ch,160   
                             mul ch       ;ax contains offset of start,but..
                             xor ch,ch    ;cx=start rows
                             mov si,ax
                             inc si
                             push dx
                             xor dh,dh
                             add si,dx
                             add si,dx    ;offset to start
                             pop dx
                             neg bp
                             add bp,bx
                             and bp,0FFH
                             inc bp       ;no.cols to mark
                             push bx
                             xchg bh,bl
                             xor bh,bh
                             sub bx,cx
                             inc bx        
                             mov cx,bx    ;no. of rows
                             pop bx
                             ret
;--------------------------------------------------------------------------
setdraw: shr bp,1
         sub bp,15  
         mov cs:drawmode,bp
         jmp endint
drawchars db  '¿Ŵ'
          db  '˻ιʼ'
          db  'ѸصϾ'
          db  'ҷ׶н'
          db  '߮ܯ'
          db  ''
draw:    cli
         push bp           
         push es           
         push bx           
         push cx           
         push dx
         push si
         mov bl,al        ;between 0 and 10
         mov dl,al        ;save it here too
         call reset_keyboard
         mov ax,cs:drawmode
         mov si,ax        ;store drawmode
         dec ax     
         mov cl,11
         mul cl           ;ax contains 11 times drawmode-1
         add bl,al
         xor bh,bh
         mov al,cs:drawchars[bx]
         mov bp,40H
         mov ds,bp
         call put_ax
         cmp si,4   ;check drawmode
         ja ov54
         or si,si
         je ov54
         cmp cs:drawdown,1
         jne ov57
         cmp dl,7
         jne ov54 
         mov ax,4B00H 
         call put_ax 
         mov ah,50H 
         call put_ax
         jmp short ov54
         ov57:cmp cs:drawdown,-1
         jne ov54
         cmp dl,7
         jne ov58
         mov ax,4B00H
         call put_ax
         mov ah,48H
         call put_ax
         jmp short ov54
         ov58:cmp dl,3
         jne ov54
         mov ax,4B00H
         call put_ax     
         call put_ax
         ov54: 
         jmp endint2 
put_ax:  mov bp,ds:[1CH]
         mov cx,bp
         inc cx
         inc cx
         cmp cx,3EH
         jl ov8
         sub cx,20H     
      ov8:cmp cx,ds:[1AH]
         je ov721                 ;If equal, buffer full; exit.
         mov word ptr ds:[bp],ax  ;Else, move word (char. and scan code)
         mov ds:[1CH],cx          ;into buffer and change buffer tail pointer.  
         ov721:ret
setdrawdown:mov cs:drawdown,1
         jmp endint
unsetdrawdown:mov cs:drawdown,0
         jmp endint
setdrawup:mov cs:drawdown,-1
         jmp endint
;----------------------------------------------------------------------------
store    label word              ;dw 510 dup ()
stuff    = offset store +1020    ;db 2001 dup ()
;##############################################################################
install: mov ax,3509H                   ;9 is keyboard interrupt
         int 21H                        ;get old int vector
         mov word ptr cs:[oldvec],bx    ;and save it
         mov word ptr cs:[oldvec+2],es
         mov dx,offset myint
         mov ax,2509H                   ;set new int vector with ds:dx
         int 21H    
         mov ax,3508H                   ;timer interrupt
         int 21H                        ;get old int vector
         mov word ptr cs:[oldtvec],bx   ;and save it
         mov word ptr cs:[oldtvec+2],es
         mov dx, offset timeint
         mov ax,2508H                   ;set new int vector with ds:dx
         int 21H    
         mov dx,offset install          ;prepare to leave resident
         add dx,3021
         int 27H
cseg ends
end begin
