        {************************************************************}
        {                                                            }
        {                 }
        {               ۰   ۰        }
        {              ۱   ۱      }
        {                                                           }
        {    C0PRi6H (c) 1995-97 B DiMeS. LL Ri6HS RSRVD     }
        {         }
        {               T Y P E D E C L A R A T I O N                }
        {                                                            }
        {  fr MegaTIC Copyright (c) 1995-97 by DiMeS, Dirk Mertens  }
        {                                                            }
        {  Diese Datei dient der Entwicklung von  Zusatzprogrammen   }
        {  fr MegaTIC und darf ohne ausdrckliche Genehmigung des   }
        {  Programmautors fr  eigene Programme verwendet  werden.   }
        {                                                            }
        {************************************************************}

{**************************************************************************

  HINWEISE ZUM AUFBAU DER DATENSTRUKTUR

  1.) Externe Datentypen --------------------------------------------------

  Folgende Datentypen wirst Du in dieser Datei nicht finden :

  - PStringCollection
    Dieser Typ ist in der OBJECTS-Unit von Turbo-Vision 2.0 deklariert.


  2.) IDs und die Zuordnungen --------------------------------------------

  Ein Record, das ein Feld mit dem Anfang ID_.... enthlt, speichert
  darin eine eigene eindeutige Zuordnungsnummer.
  Fr den Zugriff auf ID's anderer Records gibt es Felder, die
  mit ..._ID enden.

  Ein Beispiel :

     TFileEchoInfo = RECORD
       ..
       ID_FEcho  : Word;  -> Der EIGENE ID (fngt mit ID_ an)
       Packer_ID : Word;  -> Der ID des benutzten Packers (hrt mit _ID auf)
       ..
     End;

  Im Feld "ID_FEcho" wird ein Index gespeichert, der nicht doppelt vorkommen
  darf, das heisst, das kein anderes Echo denselben Indexwert haben darf.

  Im Feld "Packer_ID" wird der Index dex Packers gespeichert, mit dem z.B.
  neue Dateien in diesem Echo gepackt werden sollen.

  Durch diese Indexwerte ist es mglich, eindeutige Zuordnungen zu machen.

  *** Einfache Zuordnungen ***
  Der Typ TPackerInfo hat das Feld "ID_Packer", in dem ein eindeutiger
  Index fr den eigenen Datensatz festgehalten wird.

  Der Typ TFileList hat das Feld "Packer_ID", aber in diesem Feld wird
  der ID-Wert des Packers festgehalten, der zum Komprimieren der fertigen
  Dateilisten benutzt wird. Die berprfung, ob der aktuelle Packerdatensatz
  derjenige ist, der benutzt werden soll, luft folgendermassen ab:

    FileList.Packer_ID -----> Packer.ID_Packer

    If FileList.Packer_ID = Packer.ID_Packer then Benutze_den:=True;

  *** Multiple Zuordnungen (Mehrfachauswahl) ***
  Der Typ TUserInfo hat z.B. das Feld FILEECHOS, das ein Array sein muss,
  weil ein User gleichzeitig auf mehrere Echos aufgeschaltet sein kann.

  Die berprfung, ob ein User auf ein FileEcho aufgeschaltet ist, fhrt
  man also folgendermassen durch :

    If User.FileEchos[FileEcho.ID_FEcho] <> 0 then Aufgeschaltet:=True;

  Andere Werte (nicht nur 0 und 1) sind natrlich auch mglich. So kann
  ein User z.B. fr ein FileEcho die Werte OFF/ON/RECEIVE/SEND/BOTH haben.

    Case User.FileEchos[FileEcho.ID_FEcho] of
      FEcho_OFF     : Write('Nicht aufgeschaltet'); Wert -> 0
      FEcho_ON      : Write('Aufgeschaltet');       Wert -> 1
      FEcho_RECEIVE : Write('Empfangen');           Wert -> 2
      FEcho_SEND    : Write('Senden');              Wert -> 3
      FEcho_BOTH    : Write('Beides');              Wert -> 4
    End;


  Zwei Beispiele :

                          FileEcho_1.ID_FEcho
  1) User_1.FileEchos[...1..............]
                      123456789 usw. ist der Array-Index

     -> Der Wert von "FileEcho_1.ID_FEcho" ist "4".
     -> "User_1.FileEchos[4]" hat den Wert "1".
     --> User_1 ist mit dem Wert "FEcho_ON" fr "FileEcho_1" aufgeschaltet.

                          FileEcho_1.ID_FEcho
  2) User_2.FileEchos[...3...0..........]
                              FileEcho_2.ID_FEcho
                      123456789 usw. ist der Array-Index

     -> Der Wert von "FileEcho_1.ID_FEcho" ist "4".
     -> "User_2.FileEchos[4]" hat den Wert "3".
     --> User_2 ist mit dem Wert "FEcho_SEND" fr "FileEcho_1" aufgeschaltet.

     -> Der Wert von "FileEcho_2.ID_FEcho" ist "8".
     -> "User_2.FileEchos[8]" hat den Wert "0".
     --> Mit dem Wert "FEcho_OFF" fr "FileEcho_2" wird festgelegt, dass
         er auf dieses Echo NICHT aufgeschaltet ist.



  Die Ergebniswerte sind durch die Konstanten festgelegt : FECHO_xxx,
  die Du im Anschluss an die Typendeklaration von TFileEchoInfo findest.

{**************************************************************************}

{}
{$I MTS_RA.200}    { RA-Filebase-Struktur  v. 2.02  bis 2.50 }
{}
{}
{$I MTS_PB.212}                       { PB-Filebase-Struktur }
{}
{}
{$I MTS_EZY.120}                  { Ezycom-Filebase-Struktur }
{}
{}
{$I MTS_CONC.200}                { Concord-Filebase-Struktur }
{}
{}
{$I MTS_SG.138}                  { Shotgun-Filebase-Struktur }
{}

  { Namen der CONFIG-Dateien }
  CONST
      DataPath        = 'DATA\';  { Pfad fr alle CFG-Dateien }

      MTCfgName       = DataPath + 'MTIC.CFG';    { Name der Main-Config-Datei }
      AKAName         = DataPath + 'MT_AKAS.CFG'; { AKAs }
      UserName        = DataPath + 'MT_USER.CFG'; { Benutzer }
      UserLibName     = DataPath + 'MT_ULIB.CFG'; { Benutzer-Bibliothek }
      FileGroupName   = DataPath + 'MT_FGRP.CFG'; { Filegruppen }
      FileEchoName    = DataPath + 'MT_FECH.CFG'; { Fileechos }
      StartUpName     = DataPath + 'MT_STRT.CFG'; { Startup-Check Dateinamen }
      AnnounceName    = DataPath + 'MT_ANNO.CFG'; { Announce-Gruppen }
      OriginName      = DataPath + 'MT_ORIG.CFG'; { Origins }
      AliasName       = DataPath + 'MT_ALIA.CFG'; { Magics/Aliase }
      FFindName       = DataPath + 'MT_FIND.CFG'; { Filefind-Areas }
      IndexName       = DataPath + 'MT_INDX.CFG'; { Fast-FileRequest-Index }
      ForwardName     = DataPath + 'MT_FORW.CFG'; { Forward-Konfiguration }
      MagicName       = DataPath + 'MT_MGIC.CFG'; { Magic-Konfiguration }

      AnnounceSave    = DataPath + 'MT_ANNO.SAV'; { Announce - Sicherung }
      OutboundName    = DataPath + 'MT_OUTB.CFG'; { Liste der Outbound-Dateien }
      OutboundNew     = DataPath + 'MT_OUTB.TMP'; { Temporrer Outbound }
      TICSave         = DataPath + 'MT_PTIC.SAV'; { Sicherungskopie zu packender TICfiles }

      PackerName      = DataPath + 'MT_PACK.CFG'; { Packer-Einstellungen }
      DupeName        = DataPath + 'MT_DUPE.CFG'; { Dupes }
      ReqUserName     = DataPath + 'MT_REQU.CFG'; { Request User Information }

      MTIDXName       = '_MTFILES.IDX';            { NewFiles IDX }

      MFM_Ext         = '.MFM';       { Endung der MFM-Dateien }
      MFMPath         = 'MFM\';       { Pfad fr MFM-Dateien }

{}
{ Generelle Typenfestlegungen                                }
{}
  CONST
    MaxGroups = 255;          { Maximale Anzahl DateiGruppen }
    MaxEchos  = 3072;         { Maximale Anzahl DateiEchos   }

    sk_AnnHead    = 'ANNHEAD';    { Keywords used in templates }
    sk_AreaStart  = 'AREASTART';
    sk_FileLoop   = 'FILELOOP';
    sk_AreaEnd    = 'AREAEND';
    sk_TotalEnd   = 'TOTALEND';
    sk_AnnFoot    = 'ANNFOOT';
    sk_FLInfo     = 'LISTSPEC';
    sk_FLHead     = 'FLHEAD';
    sk_FLFoot     = 'FLFOOT';
    sk_REQHead    = 'REQHEAD';
    sk_REQFoot    = 'REQFOOT';
    sk_REQFail    = 'REQFAIL';
    sk_REQFLoop   = 'FAILLOOP';
    sk_TwitUser   = 'TWITUSER';
    sk_TwitText   = 'TWITTEXT';
    sk_FFHeader   = 'FFHEADER';
    sk_FFFooter   = 'FFFOOTER';

  TYPE
    PGroupArray = ^TGroupArray;
    TGroupArray = Array[0..MaxGroups] of Word;

  TYPE
    PEchoArray  = ^TEchoArray;
    TEchoArray  = Array[0..MaxEchos]  of Word;


{}
{ FIDO-Adresse                                               }
{}
  TYPE
    PAddr = ^TAddr;
    TAddr = Record
      Zone  ,
      Net   ,
      Node  ,
      Point : Word;
    End;

{}
{ System-Pfade / benutzt in T_MTConfigType                   }
{}
  TYPE
    PPathType = ^TPathType;
    TPathType = Record
      NetMail,
      Mailer,
      Inbound,
      OutBound,
      Packets,
      TICs,
      Bad,
      Temp,
      Old,
      BBS,
      LOG,
      Sem,
      MsgBase,
      Infected,
      Passthru,
      DupeDir
                  : String[60];

      FreeSpace   : Array[1..488] of Byte;
    End;

{}
{ System-Konfiguration / benutzt in T_MTConfigType           }
{}
  TYPE
    PDefault = ^TDefault;
    TDefault = Record
      LogStyle       : Word;
      LogMode        : Word;
      CheckCRC       : Word;
      OnCRCError     : Word;
      DIZMode        : Word;
      Other          : Word;
      AddDLC         : Word;
      DLCFormat      : String[7];
      DLCPos         : LongInt;
      System         : Word;
      OutboundSystem : Word;
      TICOptions     : Word;
      BBSType        : Word;

      FreeSpace   : Array[1..52] of Byte;
    End;

  CONST
    { LogStyle       : Word; }
        ls_FD        = $00;           { FrontDoor }
        ls_BT        = $01;           { BinkleyTerm }
    { LogMode        : Word; }
        lm_Normal    = $00;           { Normaler LOG-Modus }
        lm_Extend    = $01;           { Erweiterter LOG-Modus }
        lm_Debug     = $02;           { Debug LOG-Modus }
    { CheckCRC       : Word; }
        ch_CRC       = $01;           { berprfe CRC-Sum ? }
    { OnCRCError     : Word; }
        er_Del       = $00;           { CRC-Error : Datei lschen }
        er_Mov       = $01;           { CRC-Error : Ins BAD-Verzeichnis }
        er_Ign       = $02;           { CRC-Error : Ignorieren }
    { DIZMode        : Word; }
        us_DIZ       = $01;           { Benutze FILE_ID wenn Desc = '' }
        us_LDIZ      = $02;           { Benutze FILE_ID wenn LDesc = '' }
        us_DIZAlways = $04;           { Benutze IMMER die FILE_ID.DIZ }
        us_AddDIZ    = $08;           { Fge FILE_ID.DIZ von LongDesc hinzu }
        us_AddLine   = $10;           { Fr "DIZ added" Line hinzu }
    { Other          : Word }
        us_Comment   = $01;           { Fge Banner zu Archiven hinzu }
        us_LongInOne = $02;           { LongDesc in einer Textzeile }
        us_StripAsc  = $04;           { Strip Hi-ASCII-Characters }
        us_NoANSI    = $08;           { Filter ANSI from LongDesc }
    { AddDLC         : Word; }
        ad_DLC       = $01;           { Fge Downloadcounter hinzu }
    { System         : Word; }
        sy_Sync      = $01;           { Synchronisiere Filebase und MTIC }
        sy_AdvTICs   = $02;           { Erstelle Advanced TICs }
        sy_Suppress  = $04;           { Bildschirmausgabe unterbinden }
    { OutboundSystem : Word; }
        ob_FD        = $00;           { FrontDoor }
        ob_BT        = $01;           { BinkleyTerm / Domain-Outbound }
        ob_McM       = $02;           { McMail / Zone-Outbound }
    { TICOptions     : Word; }
        to_AddAKA    = $01;           { Fge alle AKAs hinzu }
        to_AddPoints = $02;           { Fge Points hinzu }
    { BBSType        : Word }
        bt_R20       = $00;           { RA als BBS-Software }
        bt_PB        = $01;           { Proboard }
        bt_Max       = $02;           { Maximus }
        bt_BBS       = $03;           { FILES.BBS - Mailer only }
        bt_EZY       = $04;           { EzyCom }
        bt_R25       = $05;           { RemoteAccess 2.50 }
        bt_CO        = $06;           { Concord }
        bt_SG        = $07;           { Shotgun }

{}
{ Einstellungen / benutzt in T_MTConfigType                  }
{}
  TYPE
    PMoreInfo = ^TMoreInfo;
    TMoreInfo = Record
      MaxMsgSize  : Word;             { Size of *.MSG }
      Options     : Word;             { Some options }
      UserSort    : Word;             { How to sort the users }

      FBBSOpt     : Word;             { Options for FILES.BBS }
      DLC         : String[5];        { Dormat of Downloadcounter }
      ListChar    : String[1];        { ListChar for FILES.BBS }
      Spaces      : LongInt;          { Spaces to indent }

      AnnOpt      : Word;             { Options for Announcements }
      AreaSep     : String[1];        { Character for Area-separation }
      AnnOr       : Word;             { Orientation for AreaDesc }

      _4DOSOpt    : Word;             { Options for DESCRIPT.ION }
      _4MaxLen    : LongInt;

      DateFmt     : Word;             { Format des Datums }

      FreeSpace   : Array[1..65] of Byte;
    End;

  CONST
    { MaxMsgSize }
      mm_16 = $00;                    { 16 k }
      mm_32 = $01;                    { 32 k }
      mm_64 = $02;                    { 64 k }

    { Options }
      mo_SecureTIC = $01;             { Secure TIC filenames }
      mo_Msg2Sys   = $02;             { At Error : Netmail to Sysop }
      mo_CloseWin  = $04;             { Close graphical window }
      mo_IgnoreBSY = $08;             { Ignore MTIC.BSY }

    { UserSort }   {+}
      us_SurName   = $00;             { Sort users for surname... }
      us_LastName  = $01;             { ... lastname ... }
      us_AKA       = $02;             { ... or AKA }

    { FBBSOpt }
      fo_First     = $01;             { New files at begin of FILES.BBS }
      fo_AddDLC    = $02;             { Add Downloadcounter }
      fo_AddSize   = $04;             { Add filesize }
      fo_AddDate   = $08;             { Add filedate }

    { AnnOpt }     {+}
      ao_Hard      = $01;             { use hardcoded announcements }
      ao_Size      = $02;             { Display filesize }
      ao_Date      = $04;             {    "    filedate }
      ao_Area      = $08;             {    "    area statistics }
      ao_Total     = $10;             {    "    total statistics }
      ao_High      = $20;             { highlight area with ">" }

    { AnnOr }
      ao_Left      = $00;             { Orientation Left }
      ao_Center    = $01;             { Centered }
      ao_Right     = $02;             { Right }

    { _4DOSOpt }    {+}
      fd_Update    = $01;             { Update DESCRIPT.ION }
      fd_StripHi   = $02;             { Filter HiAsc from Desc }
      fd_StripDLC  = $04;             { Filter DLC from Desc }

    { DateFmt }
      df_german  = 01;                { DD/MM/YY }
      df_america = 02;                { MM/DD/YY }
      { intern }
      df_day     = 05;
      df_month   = 06;
      df_year    = 07;

{}
{ Einstellungen2 / benutzt in T_MTConfigType                 }
{}
  TYPE
    PMoreInfo2 = ^TMoreInfo2;
    TMoreInfo2 = Record
      DupeLimit  : LongInt;             { Max number of dupe records }
      DupeSw     : Word;                { Settings for Dupechecker }
      DupeOpt    : Word;                { What to do when found dupe }

      MinFree    : LongInt;             { Min kb Space free to process TIC }

      MaxArcs    : LongInt;             { Max # of CFG-Archives }
      PackerName : String[3];

      Prio_Class : Word;                { Idle/Normal/Foreground/T-critical }
      Prio_Delta : LongInt;             { -31 to 31 }

      FreeSpace : Array[1..180] of Byte;

      Packer_ID : Word;                 { Packer to create CFG-Backups with }
    End;

  CONST
  { DupeSw }
    ds_Ext       = $01;               { dupe must have same ext  }
    ds_Area      = $02;               { and same Area }
    ds_CRC       = $04;               { and same CRC }
    ds_Date      = $08;               { and date }
    ds_Time      = $10;               { and time }

  { DupeOpt }
    do_Kill      = $00;
    do_Move      = $01;
    do_Pass      = $02;

  { Prio_Class }
    pc_Idle       = $00;
    pc_Regular    = $01;
    pc_TimeCritic = $02;
    pc_Server     = $03;

{}
{ Special Infos  / benutzt in T_MTConfigType                 }
{}
  TYPE
    TSpecialInfo = Record
      Info : Array[1..210] of Byte;
    End;

{}
{ BBSInfo - / benutzt in T_MTConfigType                      }
{}
  TYPE
    PBBSInfo = ^TBBSInfo;
    TBBSInfo = Record
      BBSName     : String[30];  { Name der BBS }
      SysopName   : String[30];  { Name des Sysops }
      Location    : String[30];  { Ort der BBS }

      Banner      : STRING[60];  { Name des Bannerfiles fr Archive }

      Sem_Rescan  : String[12];  { Rescan-Semaphore }

      ScanUtilDOS : String[70];  { Virenscanner fr DOS }
      ScanUtilOS2 : String[70];  { Virenscanner fr OS2 }
      ScanError   : LongInt;     { Errorlevel fr Virenscanner }
      ScanOptions : Word;        { Aktion bei gefundenem Virus }

      CRCFile     : String[49];  { Skullcheck-CRC-Datei }
      CRCCheck    : Word;        { Auch CRC-Summen berprfen }
      CRCVersion  : Word;        { Text oder binr }

      MaxTICAge   : LongInt;     { Maximales Alter der TIC-Dateien }

      FreeSpace   : Array[1..50] of Byte;
    End;


    CONST
      { ScanOptions }
      so_MoveBad = $01;   { Ins BAD-Verzeichnis verschieben }
      so_Delete  = $02;   { Lsche Datei }
      so_Netmail = $04;   { Netmail an den Sysop }
      so_Boot    = $08;   { Starte Rechner neu }

      { CRC_Check }
      cc_UseIt     = $01;  { SkChk-Liste aktivieren }
      cc_CheckCRC  = $02;  { Auch CRC-Daten berprfen }
      cc_CheckSize = $04;  { Auch Dateigrsse berprfen }

{}
{ MFMInfo / benutzt in T_MTConfigType                        }
{}
  TYPE
    PMFMInfo = ^TMFMInfo;
    TMFMInfo = Record
      Header,              { Header jeder Nachricht }
      MT_Help,             { Hilfe zur Bedienung }
      MT_Info,             { Info ber MegaTIC }
      U_Status,            { Userstatus }
      U_InfoTxt,           { UserInfo }
      L_List,              { Liste aller Echos }
      A_Link,              { Antwort auf eine zugeschaltete Area }
      A_Unlink,            { Antwort auf eine abgeschaltete Area }
      L_Link,              { Liste aller angeschlossenen Areas }
      L_Unlink,            { Liste aller nicht angeschlossenen Areas }
      U_Switch,            { Antwort auf einen genderten Scahlter }
      U_AccWarn,           { Account-Warung }
      U_AccBye,            { Abschaltung wegen Account = 0 }
      Footer,              { Footer jeder Nachricht }

      AnnHead,             { Announcen-Header }
      AnnFoot,             { Announcen-Footer }

      FileSend,            { Der Befehl %SENDME }

      Request,             { Template fr File-Requests }
      FileFind,            { Antwort fr File-Find-Requests }
      Remind,              { Anschrieb fr Remind-System }
      Error,               { Allgemeines Error-Template }
      AnnTPL,              { Allgemeines Announce-Template }
      FList                { Template for Filelist }

                  : STRING[8];

      FreeSpace   : ARRAY[1..81] OF Byte;
    End;

{}
{ FILELISTEN-Generator / benutzt in T_MTConfigType           }
{}
TYPE
  TFileList = Record
    Path     : String[50];  { Pfad fr die Listen }
    NameAll  : String[12];  { Name der All-Files-Liste }
    NameNew  : String[12];  { Name der New-Files-Liste }
    DaysNew  : LongInt;     { Ma fr dafr, ob Dateien neu sind }
    MinSec   : LongInt;     { Minimale und Maximale DL-Sec einer Area um.. }
    MaxSec   : LongInt;     { ..in die Filelisten aufgenommen zu werden }
    BBSBoard : String[39];  { Name der BBS-Area }
    Options  : Word;

    DirList  : String[12];  { Liste mit Pfaden fr Requestprozessor }
    DirExt   : String[3];   { Optionale Extension fr jede Pfadangabe }

    FreeSpace : Array[1..10] of Byte;

    Packer_ID : Word;       { ID des zu benutzenden Packers }
    Board_ID  : Word;       { BBS-Board fr die fertigen Listen }
  End;

CONST
  { FileList-Infos }
    fi_Name = $01;
    fi_Size = $02;
    fi_Date = $04;
    fi_DL   = $08;
    fi_Desc = $10;

  { FileList-Options }
    fo_Del  = $01;
    fo_KeyW = $02;

{}
{ Upload-Checker Infos / benutzt in T_MTConfigType           }
{}
  TYPE
    PMaxInfoRec = ^TMaxInfoRec;
    TMaxInfoRec = Record
      FileArea  : Word;
      ACS       : Word;
      Desc      : String[60];
      Download  : String[80];
      Upload    : String[80];
      AreaType  : Byte;
    End;

  TYPE
    PUploadInfo = ^TUploadInfo;
    TUploadInfo = Record
      BoardName  : STRING[40];   { Name der BBS-Area }
      Options    : Word;
      Check      : Word;         { Prfe alle/neu neue Files }
      FileInfos  : Word;         { Fge JPG/GIF specs hinzu  }

      NoCheck    : ARRAY[1..8] OF STRING[12]; { bergehe diese Dateinamen }

      SaveSpace  : ARRAY[1..194] OF Byte;

      LastCall   : LongInt;      { Letzter Aufruf der Upscan-Funktion }

      RABoard    : FILESRecord;  { Daten des RA-Boards fr Uploads }
      PBBoard    : TPBFileArea;  { Daten des PB-Boards fr Uploads }
      MAXBoard   : TMaxInfoRec;  { Daten des MAX-Boards fr Uploads }

      BoardNr    : Word;         { Nummer des Boards fr Uploads }
      Packer_ID  : Word;         { ID des zu benutzenden Umpackers }
    End;

  CONST
    { Check }
    uc_New   = $00;
    uc_All   = $01;

    { FileInfos }
    uf_AddSpec = $01;

{}
{ Listen-To / Hre auf / benutzt in T_MTConfigType           }
{}

  TYPE
    TListenInfo = RECORD
      Name      : ARRAY[1..8] OF STRING[15]; { Hre auf diese Aliasnamen }
      Options   : Word;
      SaveSpace : Array[1..30]  of Byte;
    END;

  CONST
    { ListenInfo.Options }
    lo_LIST      = $001;
    lo_UNLINKED  = $002;
    lo_PAUSE     = $004;
    lo_RESUME    = $008;
    lo_SENDME    = $010;
    lo_RESCAN    = $020;
    lo_TICPACK   = $040;
    lo_FILEPACK  = $080;
    lo_HidePw    = $100;
    lo_KeepMail  = $200;
    lo_KeepReply = $400;

{}
{ Infos fr Requestprozessor / benutzt in T_MTConfigType     }
{}
  TYPE
    PSRIFInfo = ^TSRIFInfo;
    TSRIFInfo = Record
      Sysop, AKA, Site, Location, Phone : STRING;
      Baud, DTE, Port, Time : LongInt;
      Mailer, MailerCode, Serial, Version, SessionTyp,
      RequestList, ResponseList, RemoteStatus, SystemStatus : STRING;
    End;

    PLimitInfo = ^TLimitInfo;
    TLimitInfo = Record
      Files, Time, Byte, AMin, AMax : LongInt;
    End;

    PConnectInfo = ^TConnectInfo;
    TConnectInfo = Record
      Sysop   : String[20];
      AKA     : String[20];
      Baud    : LongInt;
      Session : String[20];
      Port    : Byte;
    End;

    TNewUserInfo = Record
      Options     : Word;
      InfoFile    : String[80];
    End;

    PRequestInfo = ^TRequestInfo;
    TRequestInfo = RECORD
      Normal,
      Protected : TLimitInfo;  { Limits fr div. Sessiontypen }
      InfoFile  : String[80];
      MOptions  : Word;
      TICArea   : String[30];

      Mode      : Word;
      CDRoms    : String[19];
      NewUser   : TNewUserInfo;

      SaveSpace : ARRAY[1..50] OF Byte;
    END;

  CONST
    { Options }
    ro_Report    = $01;  { Sende Report }
    ro_CopySysop = $02;  { Kopie des Reports an Sysop }
    ro_Exist     = $04;  { berprfe Dateien auf Existenz }
    ro_SendTIC   = $08;  { Sende TIC-Files }
    ro_FilesRDC  = $10;  { Update FILES.RDC }

    { Mode }
    rm_McM       = $00;  { Mcmail als Mailer }
    rm_Cant      = $01;  { Cantaloup oder Binkley als Mailer }
    rm_FD        = $02;  { Frontdoor }
    rm_IM        = $03;  { InterMail }

    { NewUser }
    nu_TICs      = $01;
    nu_TICCRC    = $02;
    nu_TICLDesc  = $04;


{}
{ Infos fr Filefind-System / benutzt in T_MTConfigType      }
{}
 TYPE
   PFFindInfo = ^TFFindInfo;
   TFFindInfo = Record
     MaxFinds   : LongInt;   { Die Suche nach x Vorkommen abbrechen }
     DaysOld    : LongInt;   { Max. Alter von FileFind-Requests }
     AMin, AMax : LongInt;   { MIN und MAX Downloadsec. der Areas }
     Options    : Word;

     SaveSpace  : Array[1..20] of Byte;
   End;

 CONST
   { Options }
   fo_Local = $01;           { Auch lokale Requests ausfhren }
   fo_RCVD  = $02;           { RCVed-Flag, auch wenn Suche nicht erfolgreich }

{}
{ Infos fr UPD-System      / benutzt in T_MTConfigType      }
{}
 TYPE
   PUSRInfo = ^TUSRInfo;
   TUSRInfo = Record
     What  : Word;       { DOS and/or OS2 }
     Where : Word;       { analog or ISDN }
     Attr  : Word;       { What attributes }
     Pwd   : String[10]; { Password from Supportsite }
   End;

 CONST
   { What }
     uw_DOS = $01;
     uw_OS2 = $02;

   { Where }
     uw_Modem = $00;
     uw_ISDN  = $01;

   { Attr }
     u_Crash = $00;
     u_Immed = $01;

{}
{ Haupt-Konfiguration von MegaTIC / Datei : MTIC.CFG         }
{}
  TYPE
    T_MTConfigType = Record
      Language  : Word;         { Sprache }
      Path      : TPathType;    { SETUP : Pfade }
      Default   : TDefault;     { SETUP : System }
      BBSInfo   : TBBSInfo;     { SETUP : Schnittstellen }
      MFM       : TMFMInfo;     { SETUP : MFM-Dateinamen }
      FList     : TFileList;    { SETUP : Filelisten }
      Upload    : TUploadInfo;  { SETUP : Uploadscanner }
      Listen    : TListenInfo;  { SETUP : Aliasnamen }
      Request   : TRequestInfo; { SETUP : Requestprozessor }
      FFInd     : TFFindInfo;   { SETUP : FileFind-System }
      More      : TMoreInfo;    { SETUP : Einstellungen II }
      More2     : TMoreInfo2;   { SETUP : Einstellungen III }
      Special   : TSpecialInfo; { SETUP : Spezielle Infos }
      USR       : TUSRInfo;     { SETUP : Update Service Requests }

      FreeSpace : Array[1..73] of Byte;

      TICNumber : LongInt;    { Nchste TIC-Nummer fr ausgehende TICs }
      LastCall  : LongInt;    { Wurde MTIC heute schon aufgerufen ? }
      CRC32     : LongInt;    { Viren Check-CRC-Summe von MegaTIC }
      Color     : String[12]; { Name der aktuellen Farbpalette }
      Version   : String[10]; { Version des Programms }
      Date      : LongInt;    { Complilier-Datum des Programms }
      Installed : Boolean;    { Erstinstallation ? }

      FreeSpace2: ARRAY[1..49] OF Byte;
    End;

    F_MTConfigType = File of T_MTConfigType;

{************************************************************}
{************************************************************}
{                                                            }
{ Ab hier beginnen die Datentypen, die in Listen vorkommen,  }
{ also z.B. User, FileEchos usw.                             }
{ Die Daten sind in den entprechenden Dateien sequentiell    }
{ gespeichert und es kann mit einem normalen Typ der Art     }
{ TYPE FILETYP : FILE of TYP                                 }
{ auf die Daten zugegriffen werden.                          }
{                                                            }
{************************************************************}
{************************************************************}


{}
{ RAINFO / Defaultwerte fr die automatische Erstellung von  }
{          Echos in der RA-Filebase / benutzt in             }
{          TFileGroupInfo                                    }
{}
TYPE
  PRA_Info = ^TRA_Info;
  TRA_Info = Record
    Start : LongInt;

    DLSec : LongInt;
    DL_A, DL_B, DL_C, DL_D : String[8];

    LiSec : LongInt;
    Li_A, Li_B, Li_C, Li_D : String[8];

    ULSec : LongInt;
    UL_A, UL_B, UL_C, UL_D : String[8];

    Switches : Word;

    DL_Days,
    FD_Days,
    Move_Area,
    Min_Age   : LongInt;

    Password : String[15];
    Group,
    Def_Cost,
    Uploads,
    Alt1,
    Alt2,
    Alt3     : LongInt;

    Switches2 : Word;
  End;

{}
{ PBINFO 2.11 / Proboard / benutzt in TFileGroupInfo         }
{}
TYPE
  PPB_Info = ^TPB_Info;
  TPB_Info = Record
    Start      : LongInt;

    Flags      : String[32];
    Level      : LongInt;

    Options    : Word;
    Groups     : Array[0..3] of LongInt;
    AllGroups  : Word;
    DateFmt    : Word;

    MaxFiles   : LongInt;
    MaxKb      : LongInt;
    MinAge     : LongInt;

    FreeSpace   : Array[1..125] of Byte;
  End;

{}
{ COINFO 2.11 / Concord / benutzt in TFileGroupInfo          }
{}
TYPE
  TSecFlag = Record
    Flag : String[8];
  End;

  TSecRec = Record
    Level : LongInt;
    Flags : Array[1..10] of TSecFlag;
    anAge : LongInt;
    aBPS  : LongInt;
  End;

  PCO_Info = ^TCO_Info;
  TCO_Info = Record
    Start      : LongInt;
    Active     : Word;
    aGroup     : String[3];
    Upload     : LongInt;
    aPassword  : String[8];
    OpenF      : String[5];
    OpenT      : String[5];
    Offline    : Word;
    Options    : Word;
    Sec        : Array[1..3] of TSecRec;
  End;

{}
{ SGINFO 1.38 / Shotgun / benutzt in TFileGroupInfo          }
{}
  PSG_Info = ^TSG_Info;
  TSG_Info = Record
    Start       : LongInt;
    View_Access : LongInt;
    DL_Access   : LongInt;
    Flags       : String[8];
    Sub         : LongInt;
    Report      : LongInt;
    Sort        : Word;
  End;

{}
{ MAXINFO / Maximus / benutzt in TFileGroupInfo              }
{}
TYPE
  PMAX_Info = ^TMAX_Info;
  TMAX_Info = Record
    Start       : LongInt;
    Security    : Word;
    Attribute   : Word;
    Upload      : String[90];
    UpIsDown    : Word;
    FreeSpace   : Array[1..99] of Byte;
  End;

{}
{ EZYInfo / EzyCom  / benutzt in TFileGroupInfo              }
{}
TYPE
  TEZFilePathInfo = Record
    FPSec       : LongInt;               { FilePath Flags }
    FP_A, FP_B, FP_C, FP_D : String[8];

    Password  : String[8];
    MinAge    : LongInt;
    Attribute : Word;
  End;

  PEZ_Info = ^TEZ_Info;
  TEZ_Info = Record
    Start       : LongInt;

    LISec       : LongInt;
    LI_A, LI_B, LI_C, LI_D : String[8];  { DL Flags }
    UPSec       : LongInt;
    UP_A, UP_B, UP_C, UP_D : String[8];  { DL Flags }
    SYSec       : LongInt;
    SY_A, SY_B, SY_C, SY_D : String[8];  { Sys Flags }


    Attribute   : Word;
    Convert     : Word;

    FileGroup   : String[1];
    MinimumAge  : LongInt;
    UpFileArea  : LongInt;

    FilePath : TEZFilePathInfo;

    FreeSpace   : Array[1..7] of Byte;
  End;

{}
{ File Group                                                 }
{}
  TYPE
    TEchoMatching = Record
      Name : Array[1..12] of String[15];
    End;

  TYPE
    PFileEchoAdvanced = ^TFileEchoAdvanced;
    TFileEchoAdvanced = Record
      KeepDays    : LongInt;    { # of days to keep files in area }
      KeepFiles   : LongInt;    { # of files to keep max in area }
      MaintOpt    : Word;       { Options for filearea-maintenance }
      KillDead    : LongInt;    { Kill dead area after x days }

      FreeSpace    : Array[1..40] of Byte;
    End;

  TYPE
    PAutoAddInfo = ^TAutoAddInfo;
    TAutoAddInfo = Record
      AutoAddPath  : String[70];    { Basispfad fr autom. erstellte Echos }

      Batch        : String[60];    { Vorgabewerte fr automatisch erstelltes }
      OrderSec     : LongInt;       { Fileecho. Siehe auch TFileEchoInfo }
      WriteSec     : LongInt;
      Options      : Word;
      Banner       : Word;
      Replaced     : Word;
      Incoming     : Word;
      PackerName   : String[20];    { nur programmintern/Name des Packers }

      Advanced     : TFileEchoAdvanced;

      FreeSpace    : Array[1..20] of Byte;

      Packer_ID    : Word;          { ID des zu verwendenden Packers }
    End;

  TYPE
    PFileGroupInfo = ^TFileGroupInfo;
    TFileGroupInfo = Record
      Description : String[30];        { Beschreibung der Dateigruppe }
      AKAString   : String[19];        { Die benutzte AKA als Text }
      Options     : Word;
      FakeZone    : LongInt;

      FreeSpace   : Array[1..20] of Byte;

      TICList     : Pointer;    { nur programmintern }
      RA_Info     : TRA_Info;   { Default-Settings fr RemoteAcess-Echos }
      PB_Info     : TPB_Info;   { Default-Settings fr Proboard-Echos }
      MAX_Info    : TMAX_Info;  { Default-Settings fr Maximus-Echos }
      EZ_Info     : TEZ_Info;   { Default-Settings fr EzyCom-Echos }

      AKA_ID      : Word;       { ID der zu verwendenden AKA }
      ID_FGroup   : Word;       { ID der FileGruppe }

      EchoMatch   : TEchoMatching; { Echozuordnung per Name z.B. GFD* }
      AutoData    : TAutoAddInfo;
    End;

  CONST
    { Multiple Werte fr ID_FGroup }
    FGroup_OFF    = 00;        { nicht aufgeschaltet }
    FGroup_ON     = 01;        { aufgeschaltet }
    FGroup_AUTO   = 02;        { aufgeschaltet und autoconnect }
    FGroup_CR_ADD = 03;        { aufgeschaltet, autoconnect und create }
    FGroup_CR_NRM = 04;        { aufgeschaltet und create }

    { options }
    go_NoAutoZone = $01;       { no AutoZone AKA matching }

{}
{ Packer info - Einstellungen fr Packprogramme              }
{}
  TYPE
    TParamInfo = Record
      Path        : String[60];   { Pfad zum Packer }
      Pack_w      : String[60];   { Befehl zum Packen mit Pfad }
      Pack_o      : String[60];   { Befehl zum Packen ohne Pfad }
      Unpack_w    : String[60];   { Befehl zum Entpacken mit Pfad }
      Unpack_o    : String[60];   { Befehl zum Entpacken ohne Pfad }
      Banner      : String[60];   { Befehl zum Banner zufgen/lschen }
      LChar       : String[01];   { List-Character }
    End;

  TYPE
    PPackerInfo = ^TPackerInfo;
    TPackerInfo = Record
      Description : String[30];   { Allgemeine Beschreibung }
      PType       : System.Word;  { Type: Packer or ACU }
      Ext         : String[3];    { Extension }
      ID          : String[12];   { Identifizierungs-String des Packprogramms }

      DOSp        : TParamInfo;   { DOS-Parameter }
      OS2p        : TParamInfo;   { OS2-Parameter }

      ACU_Err     : LongInt;      { Virus-Errorlevel fr ACU }
      Pack_Err    : LongInt;      { Lowest Compression program fail error }

      SaveSpace   : Array[1..16] of Byte;

      ID_Packer   : System.Word;  { ID des Packers }
    End;

 CONST
   { PType }
     pt_Packer  = $00;
     pt_ACU     = $01;

{}
{ TICInfo / Eintrag in der TIC-List mit Infos ber TIC-File  }
{           nur programmintern / wird nicht auf Festplatte   }
{           gespeichert                                      }
{}
  TYPE
    PTICInfo = ^TTICInfo;
    TTICInfo = Record
      Name     : String[40];

      FName    : String[12];
      FSize    : LongInt;
      FDesc    : String;
    End;

{}
{ Pack Info / Record des Users mit Infos ber zu packende    }
{             TIC-Dateien / nur programmintern / wird nicht  }
{             auf Festplatte gespeichert                     }
{}
  TYPE
    PTICPackInfo = ^TTICPackInfo;
    TTICPackInfo = Record
      PackCount   : Word;
      Packer_ID   : Word;

      TICPackList : Pointer;
      ToAddr,
      FrAddr      : TAddr;
    End;

{}
{ AKA                                                        }
{}
  TYPE
    PAKAInfo = ^TAKAInfo;
    TAKAInfo = Record
      Zone        ,
      Net         ,
      Node        ,
      Point       : LongInt;
      Domain      : String[15];
      MainAKA     : Word;
      Dimension   : Word;

      FreeSpace   : Array[1..18] of Byte;

      ID_AKA      : Word; { ID der AKA }
    End;

  CONST
    NullAKA : TAKAInfo = (Zone:0; Net:0; Node:0; Point:0);

  CONST
    { AKA.Dimension }
    ad_3D = $00;
    ad_4D = $01;

{}
{ User Library                                               }
{}
  TYPE
    PUserLibInfo = ^TUserLibInfo;
    TUserLibInfo = Record
      Description : String[20];
      Active      : Word;
      Connect     : Word;
      Domain      : String[15];
      SecLevel    : LongInt;
      Rescan      : LongInt;
      Account     : String[7];
      AccountType : Word;
      Switches    : Word;
      MailF       : Word;
      FileF       : Word;

      FreeSpace   : Array[1..45] of Byte;

      FileGroups  : TGroupArray; { Zugeordnete Filegruppen }
      FileEchos   : TEchoArray;  { Zugeordnete Fileechos }
    End;

{}
{ User Info                                                  }
{}
  TYPE
    PUserAdvanced = ^TUserAdvanced;
    TUserAdvanced = Record
      FZone        ,
      FNet         ,
      FNode        ,
      FPoint       : LongInt;

      MFMExt       : String[3];

      SaveSpace    : Array[1..30] of Byte;
    End;

  TYPE
    PUserInfo = ^TUserInfo;
    TUserInfo = Record
      Name        : String[40];
      Zone        ,
      Net         ,
      Node        ,
      Point       : LongInt;
      Active      : Word;         { active/remind/paused/notify }
      Connect     : Word;         { Send/receive/both }
      Domain      : String[15];
      PassWord    : String[10];
      SecLevel    : LongInt;
      Rescan      : LongInt;
      AccountHandle : Word;       { Sende Netmail-Warnung / Deaktiviere Sub-AKA }
      WarningDays   : LongInt;
      Switches    : Word;         { Verschiedene Schalter }
      MailF       : Word;         { Flags fr Mails }
      FileF       : Word;         { Flags fr Files }
      PackerName  : String[3];    { Ext des eventuell ausgewhlten Packers }

      Advanced    : TUserAdvanced;

      ID_User     : Word;         { ID des Users }

      FreeSpace2  : Array[1..10] of Byte;

      ID_SubAKA   : LongInt;      { ID der Sub-AKA; programmintern }

      PackerInfo  : TTICPackInfo; { nur programmintern / s.o. }
      SubAKAName  : String[12];   { Name der Sub-AKA-Datei }

      FileGroups  : TGroupArray;  { Dem User zugeordnete Filegruppen }
      FileEchos   : TEchoArray;   { Dem User zugeordnete Fileechos }
    End;

  CONST
    { Active }
    ui_Active  = $01;
    ui_Remind  = $02;
    ui_Paused  = $04;
    ui_Notify  = $08;

    { Connect }
    ui_ReceiveFrom = $00;
    ui_SendTo      = $01;
    ui_Both        = $02;

    { Switches }
    ui_TICS     = $01;   { User bekommt TICs }
    ui_Pack     = $02;   { Packet TIC-Dateien }
    ui_InfoTxt  = $04;   { User bekommt Info-Texte }
    ui_4D       = $08;   { Sende 4D-Seen-Bys }
    ui_Strip    = $10;   { Keine Seen-Bys in TIC-Dateien }
    ui_PackUse  = $20;   { Packe auch Usefiles in Archive }

    { Msg-Typen fr MailF und FileF }
    ua_Crash  = $01;
    ua_Hold   = $02;
    ua_Direct = $04;
    ua_Normal = $08;
    ua_Imm    = $10;
    ua_Frq    = $20;


{}
{ File Echo                                                  }
{}
  TYPE
    PFileEchoInfo = ^TFileEchoInfo;
    TFileEchoInfo = Record
      Name        : String[50];
      Description : String[50];
      Path        : String[70];

      Batch       : String[70];
      BBSArea     : LongInt;    { interne BBS-Nummer des FileEchos }
      Dead        : LongInt;    { soviel Tage kamen keine Files mehr }

      OrderSec    : LongInt;
      WriteSec    : LongInt;

      Options     : Word;       { Verschiedene Settings }

      Banner      : Word;       { Was soll mit einem Archiv-Banner passieren }
      Replaced    : Word;       { Was soll mit ersetzten Dateien passieren }
      Incoming    : Word;       { Besondere Behandlung fr eingehende Dateien }
      PackerName  : String[14]; { nur programmintern/Name des Packers }

      Advanced    : TFileEchoAdvanced;

      FreeSpace   : Array[1..18] of Byte;

      {* -- Fields not occuring in the dialog -- *}
      AnnSize     : Comp;       { nur programmintern, Gre der Files     }
      FCount      : Word;       { mitgefhrte Werte fr File-Echo- }
      FSize       : LongInt;    { Statistiken / am Anfang alle auf 0 gesetzt }

      Created     : LongInt;    { Erstellungsdatum des Echos/gepacktes Format }

      FBBSName    : String[70]; { Fr PB/Concord: Pfad der FILES.BBS
                                  Fr Maximus: Name der Filearea
                                }
      Packer_ID   : Word;       { ID des zu verwendenden Packers }

      AnnCount    : Word;       { nur programmintern, Menge der Files     }

      FreeSpace2  : Array[1..4] of Byte;

      AnnList     : Pointer;    { nur programmintern, Liste der Announcen }

      FGroup_ID   : Word;       { ID der Dateigruppe }
      ID_FEcho    : Word;       { eigener ID des FileEchos }

      LastFile    : LongInt;    { Datum des letzten gehatchten Files }
      NewFiles    : Boolean;    { New files in this echo since last HATCH
                                  needed for DESCRIPT.ION update }
      Unlink      : Byte;       { For AUTOUNLINK Feature }

      FreeSpace3  : Array[1..28] of Byte;
    End;

  CONST
    { Options }
    eo_Sync     = $001;           { Sync Fileecho }
    eo_Force    = $002;           { Mandatory }
    eo_NoID     = $004;           { Don't add FILE_ID.DIZ }
    eo_Public   = $008;           { Area is public }
    eo_Pass     = $010;           { Area is passthrough }
    eo_Auto     = $020;           { Area is autounlink }
    eo_NoDupe   = $040;           { No dupecheck in this area }
    eo_ForceCon = $080;           { Force Arc Convert }
    eo_NFHatch  = $100;           { Hatch New Files in this Echo }

    { Incoming }
    ei_Touch   = $01;
    ei_Check   = $02;
    ei_VScan   = $04;
    ei_Repack  = $08;

    { Replaced }
    er_Kill    = 0;
    er_Move    = 1;
    er_Rename  = 2;

    { Multiple Werte fr ID_FEcho }
    FEcho_OFF     = 0;
    FEcho_ON      = 1;
    FEcho_RECEIVE = 2;
    FEcho_SEND    = 3;
    FEcho_BOTH    = 4;

    { Banner }
    eb_Leave      = 0;
    eb_Replace    = 1;
    eb_Kill       = 2;

    { Advanced.MaintOpt }
    mo_KillSpec   = $01;
    mo_Move       = $02;

    { Unlink }
    eu_Linked     = $01;
    eu_Cut        = $02;

{}
{ SubAKAInfo - SubAKAs eines Users                           }
{}

TYPE
  PSubAKAInfo = ^TSubAKAInfo;
  TSubAKAInfo = Record
    Zone,
    Net,
    Node,
    Point        : LongInt;
    Domain       : String[12];

    SubSwitches  : Word;          { Active / AutoCreate }
    Account      : String[7];     { Menge des Accounts }
    AccountType  : Word;          { Keiner / Tage / Anzahl kb }

    AccountDate  : LongInt;       { Start des Accounts }

    AKAString    : String[25];    { Which forced AKA to use, text only }

    { Does not appear in the dialog }
    AKA_ID       : Word;          { ID of forced AKA }

    FreeSpace    : Array[1..5] of Byte;
  End;

  CONST
    { Sub Switches }
    ss_SubActive = $01;   { active }
    ss_Create    = $02;   { may create areas }
    ss_Forward   = $04;   { forward requests allowed }
    ss_FakeZone  = $08;   { Use FakeZone Outbound }
    ss_FakeAKA   = $10;   { Use FakeAKA Outbound }

    { Account-Handle }
    ah_Disable = $01;
    ah_Warn    = $02;

    { AccountType }
    ac_Free = $00;
    ac_DLkb = $01;
    ac_Days = $02;


{}
{ StartupInfo / berprfung der Archive bei Programmstart    }
{               die eventuell TIC-Dateien enthalten          }
{}
  TYPE
    PStartupInfo = ^TStartupInfo;
    TStartupInfo = Record
      FileName : String[12]     { berprfe auf Archiv beim Start }
    End;

{}
{ Announce Gruppen                                           }
{}
  TYPE
    PAnnounceInfo = ^TAnnounceInfo;
    TAnnounceInfo = Record
      GroupName  : String[30];  { Name der Announcegruppe }
      Options    : Word;        { Aktiv ? }

      AKAName    : String[20];   { programmintern / Verwendete AKA als Text }
      MsgArea    : String[30];   { Name einer evtl. Echomail-Area }
      MsgPwd     : String[8];    { optionales Passwort }
      FromN      : String[36];   { Von     : }
      ToN        : String[36];   { An      : }
      Subject    : String[72];   { Subject : }

      SaveSpace  : Array[1..48] of Byte;

      Origin_ID  : Word;         { ID der zu verwendenden Origin-Line }
      AKA_ID     : Word;         { ID der zu verwendenden AKA }

      FileEchos  : TEchoArray;   { Einzubeziehende FileEchos }
      Systems    : TEchoArray;   { Zu benachrichtigende Netmail-Systeme }
      AutoAdd    : TGroupArray;  { Gruppen, deren Fileechos autozuadden sind }
    End;

  CONST
    { Options }
    ao_Active = $01;

{}
{ Origin-Lines                                               }
{}
  TYPE
    POriginInfo = ^TOriginInfo;
    TOriginInfo = Record
      Text      : String[60];   { Text in der Origin-Line }
      SaveSpace : Array[1..20] of Byte;

      ID_Origin : Word;         { ID der Origin-Line }
    End;

{}
{ Skullcheck CRC-Files / fr temporre Liste zum Laden der   }
{                        CRC-Datei / nur programmintern      }
{}
  TYPE
    PSkChkInfo = ^TSkChkInfo;
    TSkChkInfo = Record
      Size      : LongInt;
      CRC32     : String[8];
      FName     : String[13];

      SaveSpace : Array[0..1] of Byte;
    End;

{}
{ AliasNamen/Magics fr Request-Prozessor                    }
{}
  TYPE
    PAliasInfo = ^TAliasInfo;
    TAliasInfo = Record
      Alias     : String[20];   { Alias/Magic }
      FName     : String[70];   { Name der zugehrigen Datei }
      Password  : String[15];   { Password fr den Aliasnamen }
      Options   : Word;

      SaveSpace : Array[1..2] of Byte;
    End;

  CONST
    ao_First  = $00;
    ao_Latest = $01;

{}
{ User fr Requestprozessor                                  }
{}
  TYPE
    PReqUserInfo = ^TReqUserInfo;
    TReqUserInfo = Record
      Name    : String[80];
      AKA     : String[20];
      Active  : Word;
      Options : Word;
      TICarea : String[20];
      A_Files : LongInt;
      A_Bytes : LongInt;
      T_Files : LongInt;
      T_Bytes : LongInt;
      LastReq : LongInt;

      SaveSpace : Array[1..20] of Byte;
    End;

  CONST
    { Active }
    ra_Active  = $01;

    { Options }
    ru_TICs     = $01;
    ru_TICCRC   = $02;
    ru_TICLDesc = $04;
    ru_Ignore   = $08;
    ru_NoReport = $10;

{}
{ Filefind-Areas                                             }
{}
 TYPE
   PFFindAreaInfo = ^TFFindAreaInfo;
   TFFindAreaInfo = Record
     Description : String[40];   { Beschreibung }
     Active      : Word;
     AKAString   : String[30];   { programmintern / benutzte AKA als String }
     OriginStr   : String[60];   { programmintern / Origin als String }

     F_BaseType  : Word;         { MsgBase Typ der "FROM/Scan"-Msgbase }
     F_JAM       : String[70];     { Pfad }
     F_SQUISH    : String[70];     { Pfad }
     F_HUDSON    : LongInt;        { Nummer }
     F_NETMAIL   : String[70];     { Pfad }
     F_EZY_B     : LongInt;        { Nummer und }
     F_EZY_P     : String[70];     { Pfad }

     T_BaseType  : Word;         { Msgbase Typ der "TO/Reply"-MsgBase }
     T_BaseName  : String[70];     { Name der Reply-Base wenn <> Netmail }
     T_BasePWD   : String[20];     { optionales Password fr Reply-Base }

     SaveSpace   : Array[1..20]  of Byte;

     Origin_ID   : Word;   { ID der zu verwendenen Origin-Line }
     AKA_ID      : Word;   { ID der zu verwendenen AKA }
   End;

   { FROM BaseType }
   CONST
     fb_JAM      = $00;
     fb_SQUISH   = $01;
     fb_HUDSON   = $02;
     fb_NETMAIL  = $03;
     fb_EZY      = $04;

   { TO BaseType }
   CONST
     tb_NETMAIL  = $00;
     tb_ECHOMAIL = $01;

{}
{ Forward-Manager System                                     }
{}
  TYPE
    TAutoUpdate = Record
      Active    : Word;               { Aktiv ? }
      Command   : String[30];         { Befehl fr die Arealiste }
      Freq      : Word;               { Wie oft Arealiste anfordern ? }

      SaveSpace : Array[1..20] of Byte;
    End;

    PForwardInfo = ^TForwardInfo;
    TForwardInfo = Record
      Group     : String[30];         { Name der zugehrigen Dateigruppe }
      Active    : Word;               { Aktiv ? }
      UP_Name   : String[30];         { Name des Uplinks }
      Up_AKA    : String[30];         { AKA des Uplinks }
      Password  : String[30];         { AreaMgr-Passwort beim Uplink }
      AreaMgr   : String[15];         { Alias des AreaMgr }
      AreaList  : String[70];         { Name der fidonet.na Datei }

      SaveSpace : Array[1..50] of Byte;

      FGroup_ID : Word;               { ID der Dateigruppe }
      User_ID   : Word;               { ID des Uplinks }

      UpDate    : TAutoUpdate;        { s.o. }
    End;

  CONST
    { AutoUpdate.Freq }
      au_Daily   = $00;
      au_Weekly  = $01;
      au_Monthly = $02;

{}
{ Magic-System                                               }
{}
  TYPE
    PMagicInfo = ^TMagicInfo;
    TMagicInfo = Record
      MagicName : String[25];            { Name des Magictypen }
      MagicBuf  : Array[1..200] of Byte; { Puffer zum Speichern der Daten }

      MagicType : Byte;                  { Typ des Magic-Eintrags }
    End;

  CONST
    { MagicType }
      mt_NoType      = 00;
      mt_CopyFile    = 01;
      mt_DeleteFile  = 02;
      mt_ExecCom     = 03;
      mt_NoHatch     = 04;
      mt_Unpack      = 05;
      mt_Rename      = 06;

{}
{ Outbound-System                                            }
{}
  TYPE
    POutboundInfo = ^TOutboundInfo;
    TOutboundInfo = Record
      Addr : TAddr;            { Dest-Addr for this entry }
      Name : String[128];      { Filename for DestAddr }
      Kill : Boolean;          { Kill file after sending }
      Flag : Char;             { Crash oder Hold }
    End;


{}
{ Sicherung zu packender TIC-Files                           }
{}
  TYPE
    POutTICInfo = ^TOutTICInfo;
    TOutTICInfo = Record
      ID     : Word;
      FrAddr : TAddr;          { Source-Addr for this entry }
      ToAddr : TAddr;          { Dest-Addr for this entry }
      Name   : String[128];    { Filename for DestAddr }
    End;

{}
{ Dupe-Checker                                               }
{}
  TYPE
    PDupeInfo = ^TDupeInfo;
    TDupeInfo = Record
      Name : String[8];
      Ext  : String[3];
      CRC  : LongInt;
      Date : LongInt;
      Area : String[40];
    End;

{}
{ MiscAKAInfo / Mischung aus User und seinen SubAKAs /       }
{               nur programmintern / wird nicht auf          }
{               Festplatte gespeichert                       }
{}
TYPE
  PSubAKAMisc = ^TSubAKAMisc;
  TSubAKAMisc = Record
    { Von TUserInfo }
    Name          : String[40];
    Zone        ,
    Net         ,
    Node        ,
    Point         : Longint;
    Active        : Word;
    Connect       : Word;
    m_Domain      : String[15];
    PassWord      : String[10];
    SecLevel      : LongInt;
    Rescan        : LongInt;
    AccountHandle : Word;
    WarningDays   : LongInt;
    Switches      : Word;
    MailF         : Word;
    FileF         : Word;
    ID_User       : Word;

    SubAKAName    : String[12];
    Advanced      : TUserAdvanced;

    { Von TSubAKAInfo }
    Domain        : String[12];
    SubSwitches   : Word;
    Account       : String[7];
    AccountType   : Word;
    AccountDate   : LongInt;
    AKAString     : String[25];
    AKA_ID        : Word;
  End;

  CONST
    UserCopy     = 6 * 2 + 7 * 4 + 41 + 16 + 11;
    AdvancedCopy = 4 * 4 + 4;
    SubAKACopy   = 1 * 4 + 3 * 2 +  8 + 13 + 26;


CONST
  { SubAkaMisc.Active }
  ui_MAINAKA  = $10; { Kennzeichen da dies die MAIN-AKA ist
                       wird nicht gespeichert / nur programmintern }

  ui_NOSUBAKA = $20; { Kennzeichen, da dies ein Eintrag ist, der
                       keine Sub-AKAs hat, d.h. es gibt nur die
                       MainAKA / nur programmintern }

        {************************************************************}
        {              -------- ENDE DER DATEI --------              }
        {************************************************************}

