//#include <iostream.h>
#include <windows.h>
#include <winsock.h>

#include <process.h>
#include <stdio.h>

#include "textfile.h"
#include "wcserver.h"
#pragma hdrstop

void HoroscopeHandler(void *p)
{
  printf("In HoroscopeHandler\r\n");

  SOCKET s = (SOCKET)p;
  char buf[1024]; // general purpose data buffer
  int RBChoice = 0; // variable for our radio button choice
  memset(buf, 0, sizeof(buf)); // intializes data buffer

  while (TRUE) {
   int i = 0;
   while (i < sizeof(buf)){
      /* Data is being received in a stream format one
         text character at a time.
       */
      int r = recv(s, &buf[i], 1, 0);
      if (r <=0) { // if no data received then bail out
        closesocket(s); // all done so close the socket
        return;
      }
      if (buf[i] == '\r') {
        // carriage return received
        break;
      }
    printf(buf);
    printf("\r\n");
    i++;
   }
  char fn[_MAX_PATH];
  /* transfers data from "buf" to "RBChoice" 
     in integer format
  */
   
    //sscanf(buf, "%d\r", & RBChoice);
  sscanf(buf, "%d", &RBChoice);
  char Hline[1024];
  /* formats file name to correct selection */
  wsprintf(fn, "Hscope%d.Dat", RBChoice);
  printf("Name of chosen file: ");
  printf(fn);
  printf("\r\n");

  TTextFile MyFile(fn, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
    if (MyFile.IsOk()) {
      DWORD read = sizeof(Hline);
      if (MyFile.ReadLine(Hline, read) == FALSE) {
        if (GetLastError() == ERROR_HANDLE_EOF) {
          MyFile.SetFilePointer(0, FILE_BEGIN);
          read = sizeof(Hline);
          MyFile.ReadLine(Hline, read); 
        }  
      }
      printf(Hline);
      send(s, Hline, strlen(Hline), 0);
      MyFile.CloseHandle();
   
    }
  }
}

int main(int, char *[])
{
 
  // Connect to the default wildcat server

  if (!WildcatServerConnect(NULL)) {
    return 1;
  }
  if (!WildcatServerCreateContext()) {
    return 1;
  }

  // Initialize and load WinSock

  WSAData wsaData;
  WSAStartup(MAKEWORD(1, 1), &wsaData);
  SOCKET s = socket(AF_INET, SOCK_STREAM, 0);
  sockaddr_in sin;
  sin.sin_family = PF_INET;
  sin.sin_addr.s_addr = INADDR_ANY;
  sin.sin_port = 0;
  bind(s, (sockaddr *)&sin, sizeof(sin));
  int n = sizeof(sin);
  getsockname(s, (sockaddr *)&sin, &n);

  // Register service with Wildcat!

  TWildcatService service;
  ZeroMemory(&service, sizeof(service));
  strcpy(service.Name, "Horoscope");
  strcpy(service.Vendor, "Mustang Software, Inc.");
  service.Version = 1;
  service.Port = ntohs(sin.sin_port);
  RegisterService(service);

  printf("Horoscope service active on %s/%d\n", inet_ntoa(*(struct in_addr *)&service.Address), ntohs(sin.sin_port));
  listen(s, 5);
  
  /* the below "while" statement is nothing but an
     endless loop which listens to a socket for incoming
     requests.
   */

  while (1) { 
    sockaddr_in tin;
    int n = sizeof(tin);
    SOCKET t = accept(s, (sockaddr *)&tin, &n);
    
    /* The subject of threads is an advanced windows
       programming topic you will need to know about
       in order to develop online interactive Wildcat
       applications. I would highly recommend that you
       obtain the following listed book which covers
       that subject as well as other advanced windows
       developer topics for Visual C++:

       Advanced Windows - The Developer's Guide to the
        Win32 API for Windows NT 3.5 and Windows 95
        by Jeffrey Richter and published by Microsoft
        Press -  ISBN 1-55615-677-4
     */
    
    _beginthread(HoroscopeHandler, 0, (void *)t);
  }
  return 0;
}
