#include "common1.h"
#pragma hdrstop

#include "findserv.h"
#include "resource.h"

/* In this unit we are creating a dialog box called "Find Service"
    and trying to find the service you name on the WC5 server.
    If successful, we pass on the information on which socket the
    service you requested can be found and then move on elsewhere.
    If not, we bomb out and let you know what happens.  The
    findserv.cpp unit would make a good general purpose unit to add
    to most client applications. This unit will be used by both the
    Horoscope and Tic, Tac, Toe dialogs of our master client application.
 */ 


///////////////////////////////////////////////////////////////////////////////
// CFindServiceDialog

const UINT WM_NAVIGATORNOTIFY   = WM_USER + 123;

class CFindServiceDialog: public CDialog {
public:
  CFindServiceDialog(const char *servicename);
  ~CFindServiceDialog();
  //{{AFX_DATA(CFindServiceDialog)
  enum { IDD = IDD_FINDSERVICE };
  CString ServiceName;
  TWildcatService ServiceInfo;
  //}}AFX_DATA
protected:
  SOCKET Socket;
protected:
  long DoNavigatorNotify(void *data, int size);
protected:
  //{{AFX_MSG(CFindServiceDialog)
  virtual BOOL OnInitDialog();
  virtual void DoDataExchange(CDataExchange *pDX);
  afx_msg long OnNavigatorNotify(UINT wParam, long lParam);
  //}}AFX_MSG                    
  DECLARE_MESSAGE_MAP();
};                      

BEGIN_MESSAGE_MAP(CFindServiceDialog, CDialog)
  //{{AFX_MSG_MAP(CFindServiceDialog)
  ON_MESSAGE(WM_NAVIGATORNOTIFY, OnNavigatorNotify)
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

CFindServiceDialog::CFindServiceDialog(const char *servicename)
 : CDialog(CFindServiceDialog::IDD), ServiceName(servicename)
{
  //{{AFX_DATA_INIT(CFindServiceDialog)
  //}}AFX_DATA_INIT
} 

CFindServiceDialog::~CFindServiceDialog()
{
  if (Socket != INVALID_SOCKET) {  // if socket still active, then close it
    closesocket(Socket);
  }
}

BOOL CFindServiceDialog::OnInitDialog()
{
  // Things to do when we start the dialog up
  
  BOOL ret = CDialog::OnInitDialog();
  // Get from Wildcat the service we name
  Socket = GetServiceByName(GetSafeHwnd(), WM_NAVIGATORNOTIFY, ServiceName);
  // if we didn't get it, then post a message
  if (Socket == INVALID_SOCKET) {
    PostMessage(WM_COMMAND, IDCANCEL);
  }
  return ret;
}

void CFindServiceDialog::DoDataExchange(CDataExchange *pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CFindServiceDialog)
  DDX_Text(pDX, IDC_SERVICENAME, ServiceName);
  //}}AFX_DATA_MAP
}

long CFindServiceDialog::DoNavigatorNotify(void *data, int size)

/* This handles the wrGetServiceByName response, and structure, we
    receive from the WC5 server
 */

{
  if (size < sizeof(TWildcatRequest)) {
    return 0;
  }          
  
  switch (((TWildcatRequest*)data)->type) {
    case wrGetServiceByName: {  // from wcgui.h
      if (size == sizeof(TGetServiceByName_Response)) {
        TGetServiceByName_Response *r = (TGetServiceByName_Response*)data;
        ServiceInfo = r->info;
        PostMessage(WM_COMMAND, IDOK);
      }
      return 1;
    }
  }        
  
  return 0;
}

afx_msg long CFindServiceDialog::OnNavigatorNotify(UINT wParam, long lParam)

/* Handles our GetServiceByName(GetSafeHwnd(), WM_NAVIGATORNOTIFY, ServiceName)
   request.
 */ 

{
  SOCKET s = (SOCKET)wParam;
  if (s == INVALID_SOCKET) {
    return FALSE;
  }
  if (WSAGETSELECTEVENT(lParam) & FD_CLOSE) { // close notify
    while (TRUE) {
      char buf[8192];
      memset(buf, 0, sizeof(buf));
      int read = recv(s, buf, sizeof(buf), 0);
      if (read <= 0) {
        break;
      }
      DoNavigatorNotify(buf, read);
    };
    closesocket(s);
    Socket = INVALID_SOCKET;
    PostMessage(WM_COMMAND, IDCANCEL);
    return FALSE;
  } else 
  if (WSAGETSELECTEVENT(lParam) & FD_READ) { // read notify
    char buf[8192];
    memset(buf, 0, sizeof(buf));
    int read = recv(wParam, buf, sizeof(buf), 0);
    if (read <= 0) {
      closesocket(s);
      Socket = INVALID_SOCKET;
      PostMessage(WM_COMMAND, IDCANCEL);
      return FALSE;
    }
    return DoNavigatorNotify(buf, read);
  } 
  return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
// FindWildcatService

long FindWildcatService(const char *name, TWildcatService &service)
{
  CFindServiceDialog dlg(name);
  if (dlg.DoModal() == IDOK) {
    service = dlg.ServiceInfo;
    return TRUE;
  }
  return FALSE;
}