// hscope.cpp : implementation file
//

#include "common1.h"
#pragma hdrstop

#include <direct.h>

#include "framesdi.h"
#include "hscope.h"
#include "findserv.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

const UINT WM_RUNCLIENTMSG         = RegisterWindowMessage(WcVersionRunClientMessage);
/////////////////////////////////////////////////////////////////////////////
// CHScope dialog


CHScope::CHScope(CWnd* pParent /*=NULL*/)
	: CDialog(CHScope::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHScope)
	m_horoscope_sign = -1; // no radio button is initially chosen
	//}}AFX_DATA_INIT

  Startup = TRUE;
  Disconnect = FALSE;
  ServiceSocket = INVALID_SOCKET;

  InitReceive();
}

void CHScope::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHScope)
	DDX_Radio(pDX, IDC_RADIO1, m_horoscope_sign);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHScope, CDialog)
	//{{AFX_MSG_MAP(CHScope)
	ON_BN_CLICKED(IDC_BUTTON1, OnSubmit1)
	ON_MESSAGE(WM_SERVICENOTIFY, OnServiceNotify)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CHScope message handlers

CHScope::~CHScope()
{
  if (ServiceSocket != INVALID_SOCKET) {
    closesocket(ServiceSocket);
    ServiceSocket = INVALID_SOCKET;
  }
  WildcatNavigatorCleanup(GetSafeHwnd());
}  

BOOL CHScope::OnInitDialog()
{
  BOOL ret = CDialog::OnInitDialog();
  
  // is Navigator running?            
  if(WildcatNavigatorStartup(GetSafeHwnd(), WM_SERVICENOTIFY) == 0){
    
    // Checks to ensure we have the latest version of the client
    // uncomment the below code to implement it..
   
   /*if (WcCheckClientVersion(HOROSCOPE_CLIENT_NAME,
       HOROSCOPE_CLIENT_VERSION) == 0) {
      Disconnect = TRUE;
      PostMessage(WM_COMMAND, IDOK);
      return FALSE;
    }               */

    // Calls FindWildcatService from the findserv.cpp unit 
    if (FindWildcatService(HOROSCOPE_SERVICE_NAME, Service) == FALSE) {
      Disconnect = TRUE;
      PostMessage(WM_COMMAND, IDOK);
      return FALSE;
    }

    
    /* The following 8 lines of code takes the information obtained by the
        FindWildcatService function call and allows us to open a socket
        directly to the service.
     */
    SOCKADDR_IN sin;
    memset(&sin, 0, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = Service.Address;
    sin.sin_port = htons((u_short)Service.Port);
    
    ServiceSocket = OpenService(GetSafeHwnd(), WM_SERVICENOTIFY, &sin, TRUE);
    if (ServiceSocket == INVALID_SOCKET) {
      PostMessage(WM_COMMAND, IDOK);
    }

  } else { 
    PostMessage(WM_COMMAND, IDOK);
  }

  return ret;
}

afx_msg LRESULT CHScope::OnServiceNotify(UINT wParam, long lParam)
{ 
  if (wParam == WPARAM_CLOSE) {                       	
    Disconnect = TRUE;
    if (ServiceSocket != INVALID_SOCKET) {
      closesocket(ServiceSocket);
      ServiceSocket = INVALID_SOCKET;
    }
    PostMessage(WM_COMMAND, IDOK);
  }

  SOCKET s = (SOCKET)wParam;
  if (s == INVALID_SOCKET || s != ServiceSocket) {
    return FALSE;
  }
  
  if (WSAGETSELECTEVENT(lParam) & FD_CLOSE) { // close notify
    char buf[8192];
    memset(buf, 0, sizeof(buf));
    int ret = recv(s, buf, sizeof(buf), 0); // how many bytes did we receive?
    while (ret > 0) {   // as long as we got more than 0....
      
      // Adds the horoscope text to the list box
      ListBox1().AddString(buf);
      ret = recv(s, buf, sizeof(buf), 0); // Updates ret
    }
    if (ret <= 0) {
      closesocket(s);
      ServiceSocket = INVALID_SOCKET;
      PostMessage(WM_COMMAND, IDOK);
      return FALSE;
    }
  } else
  if (WSAGETSELECTEVENT(lParam) & FD_READ) { // read notify
    char buf[8192];
    memset(buf, 0, sizeof(buf));
    int ret = recv(s, buf, sizeof(buf), 0); // how many bytes did we receive?
    while (ret > 0) {   // as long as we got more than 0....

      // Adds the horoscope text to the list box
      ListBox1().AddString(buf);
      ret = recv(s, buf, sizeof(buf), 0); // Updates ret
    }
  }
  return FALSE;
}

void CHScope::InitReceive()
{
 /* Sets our variable to a blank in preparation for receipt
    of a string from the WC5 service
  */
 HoroscopeText = " ";
}

void CHScope::OnSubmit1()
{
  /*  We submit our horoscope radio button choice to the WC5 Horoscope Service */
  
  char Buf2[8192];  // general purpose data buffer
  memset(Buf2, 0, sizeof(Buf2));  // initializes the data buffer
  /* Checks for which radio button you have currently selected in the
      horoscope dialog box */
  UpdateData(TRUE);  
  InitReceive(); // blanks the HoroscopeText variable
  /*  The sprintf function formats and stores a series of characters and
       values in "Buf2".  The 2nd parameter of sprintf controls the format
       of the data. Although not shown in this particular function call you can
       send MANY mixed data types in the same function call.  An example:
          
       wsprintf(buf, "%s, %d, %d, %s\r", command, player1, player2, message);
       
       Adding the "\r" adds a carriage return character to the data item so
       that on the receiving end we will know when we have reached the end
       of that data item.  A terminator character should be used for fields
       where the length of the data item may be unknown to the service.
   */
  wsprintf(Buf2, "%d\r", m_horoscope_sign);
  
  // Sends the data to WC5
  send(ServiceSocket, Buf2, strlen(Buf2), 0);
}

void DoHoroscope()
{
  // Adds the Horoscope Client to the Connection Manager's Toolbar
  
  char navinifile[_MAX_PATH];
  getcwd(navinifile, sizeof(navinifile));
  if (navinifile[strlen(navinifile)] != '\\') {
    strcat(navinifile, "\\");
  }   
  
  strcat(navinifile, "wcnav.ini");
  WritePrivateProfileString("ToolBar", HOROSCOPE_CLIENT_NAME, HOROSCOPE_CLIENT_NAME, navinifile);	
	
  CHScope MyHScope;
	
	MyHScope.DoModal(); // Make's the horoscope dialog box visible
	
}

