// mainfrm.cpp : implementation of the CMainFrame class
//
#include "common1.h"
#pragma hdrstop

#include "framesdi.h"

#include "mainfrm.h"
#include "msgch.h"
#include "hscope.h"
#include "tttoe.h"
#include <stdio.h>
#include <direct.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif 

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_WILDCAT_REQUESTMESSAGES, OnWildcatRequestmessages)
	ON_COMMAND(ID_WILDCAT_USERSONLINE, OnWildcatUsersonline)
	ON_COMMAND(ID_WILDCAT_HOROSCOPE, OnWildcatHoroscope)
	ON_MESSAGE(WM_UPDATEWHOSONLINE, UpdateWhosOnline)
	ON_COMMAND(ID_WILDCAT_TICTACTOE, OnWildcatTictactoe)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SOCKETNOTIFY, OnSockNotify)
	ON_MESSAGE(WM_SOCKETNOTIFY_MESSAGE, OnSockNotifyMessage)
	ON_MESSAGE(WM_SOCKETNOTIFY_UONLINE, OnSockNotifyUOnline)
	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_WILDCAT_PAGE,
	ID_WILDCAT_MESSAGES,
	ID_WILDCAT_FILES,
	ID_WILDCAT_EXPORTADDRESSLIST,
	ID_WILDCAT_ADDKEYTOREGISTRY,
	ID_WILDCAT_SYSTEMPAGE,
	ID_WILDCAT_REQUESTMESSAGES,
	ID_WILDCAT_USERSONLINE,
	ID_WILDCAT_HOROSCOPE,
	ID_WILDCAT_TICTACTOE,
		ID_SEPARATOR,
	ID_APP_ABOUT,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{            
  if (myFile.m_hFile != CFile::hFileNull) {  // if file is still open, then closes it
    myFile.Close();
  }
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;      // fail to create
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/* Use the function below to define what you want to do when you receive a message
    notifying you of a network event.  In this case we are NOT expecting a
    reply of any sort so no code is present. */ 

LRESULT CMainFrame::OnSockNotify(WPARAM wp, LPARAM lp)
{
  return 0;
}

void CMainFrame::OnWildcatRequestmessages() // "RM" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Request Messages ("RM") toolbar button (or menu item) is
            selected we are routed to this function.
       b.  If successful we will request, and receive, a list of messages from the
            designated conference (#1) starting at message #1.  In addition received
            messages will be routed to a text file on disk called RMessage.TXT where
            we can look at them later.  
       c.  If unsuccessful at any stage we get a warning message box and exit.
       
       NOTE:  This function requires the service of "cloadpxy.h" (Wildcat Proxy API),
              and "wildsock.h" (with Wildsock.Lib)
    */	
	
  CMsgCh MyMsgCh; // from msgch.h
	MyMsgCh.DoModal(); // Make's the options dialog box visible
	 // updates the value of MyMsgCh.m_CheckBoxValue
	UpdateData(TRUE);
	 // assigns the value from the check box 
	BOOL mmc = TRUE;
	if(MyMsgCh.m_CheckBoxValue){mmc = TRUE;}
	if(!MyMsgCh.m_CheckBoxValue){mmc = FALSE;}
	rmin = 0; // intializes the global variable
	
	
	/*     Opens a socket to the Navigator Server agent. The WM_SOCKETNOTIFY_MESSAGE
	       parameter is defined as a constant in the FRAMESDI.H portion of the code. Upon
	       receipt of a Network event message (WM_SOCKETNOTIFY_MESSAGE) you are routed to
	       the message map in this unit (see above) and eventually to the
	       LRESULT CMainFrame::OnSockNotifyMessage(WPARAM wp, LPARAM lp) function you will
	       find also here in this unit (see below).  In addition that function has been
	       added to the public area of the CMainFrame class of MAINFRM.H.
	       NOTE:  "s" is assigned our created socket...
	 */
      SOCKET s = ListMessagesByAreaNumber(AfxGetMainWnd()->GetSafeHwnd(),
      WM_SOCKETNOTIFY_MESSAGE, 1, 1, 20, mmc, FALSE); 
        /* Checks for valid socket, if not valid exits  */
        if(s == INVALID_SOCKET){ 
	     AfxMessageBox("Socket NOT opened!", MB_ICONSTOP|MB_OK, 0);
	     return;
	    }

		// Creates file called "AddrList.Txt" and Opens for read/write output 
      char* pszFileName = "RMessage.txt";  // name of output file
		  if(!myFile.Open(pszFileName,
		    CFile::modeCreate | CFile::modeReadWrite)) {
		    AfxMessageBox("Unable to create file", MB_ICONSTOP|MB_OK, 0);
		    return;
		  }
    
      // let's you know the task is completed
      AfxMessageBox("RMessage.txt file has been created!", MB_ICONSTOP|MB_OK, 0);
      
    /* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown/cleanup functions in FRAMESDI.CPP
	*/	
}

/* Use the function below to define what you want to do when you receive a message
    notifying you of a network event.  In this case we ARE expecting a
    reply so code is present. */
    
LRESULT CMainFrame::OnSockNotifyMessage(WPARAM wp, LPARAM lp)
{
	
/* General discussion:
   
   a.  WSAGETSELECTEVENT lets you determine the current status of your socket.
       If "& FD_CLOSE" then it reads and processes whatever remaining data may be there
       and then performs a closesocket function call.  If "& FD_READ" then reads and
       processes whatever data may have come in from the server.  In a nutshell
       the WSAGETSELECTEVENT function tells windows to notify your program when
       the socket is ready to read.  When your socket receives data, Windows will
       send the corresponding message identifier (in this case: WM_SOCKETNOTIFY_MESSAGE)
       to the Message map above.  The message map which is acting like a switch
       statement will then route you to this function. 
   b.  The (recv(s, MyBuf, sizeof(MyBuf), 0)) function call takes the following
       parameters:
       (1) s = your socket.
       (2) MyBuf = the message buffer where you want the data stored.  The recv
           function copies data from the incoming data queue to this message buffer.
       (3) sizeof(MyBuf) =  the buffer length.  This tells wildsock the maximum number of
           bytes the buffer can store.
       (4) 0 = Special flag. In response to "0" the recv function will simply copy data
           from the transport layers incoming data queue to your program's message
           buffer.
   c.  Remember: ALL navigator client operations are ASYNCHRONOUS. In reference to
       sockets this means that a program initiates an operation by calling a function
       that immediately returns.  An asynchronous function call is responsible ONLY
       for initiating the operation, it does NOT wait around for the operation to complete.
       The CFramesdiDoc::OnWildcatRequestmessages() in Framedoc.cpp is one such example
       and the one that eventually ends up here, assuming there are no problems.
   d.  For a complete explanation of winsock type operations and Internet Programming
       in general, I would recommend you obtain the following book (for Visual C++ &
       Visual Basic programmers):
       
       Internet Programming by Kris Jamsa and Ken Cope, Copyright 1995 by Jamsa Press.
       ISBN 1-884133-12-6
       
   e.  You need to include "wcgui.h" and "wildsock.h" for this function to work.
   f.  One more thing to note:  This function call will be made repeatedly by windows
       until ALL your data is received.  As a result do NOT include any routines which
       by there nature will cause a problem if repeated.  An example would be an
       incremented variable which is initialized here and when the function is called
       again would be re-initizled once more. Another example would be to open the file
       here and close it here as well. The net result would be that an existing file
       would be overwrote EACH time the function cycles. 
*/   
  // struct for Message Header Response (wcgui.h)
  TListMessages_MsgHeader_Response *mhr; 
  // struct for Message Text Response (wcgui.h)
  TListMessages_MsgText_Response *mtr; 
  char MyBuf[8192];  // defines a general purpose data buffer
  int ret;  // variable to store how many bytes we received  
  char data[4096]; // array for storing string data
  char sresult[17]; // variable for storing value of converted integer
  
  ret = 0;
  memset(sresult, 0, sizeof(sresult));
  memset(&mhr, 0, sizeof(mhr));
  memset(&mtr, 0, sizeof(mtr));                    
  memset(MyBuf, 0, sizeof(MyBuf));                      
  SOCKET s = (SOCKET)wp;
  if (WSAGETSELECTEVENT(lp) & FD_CLOSE) {
    ret = recv(s, MyBuf, 8192, 0); // how many bytes did we receive?
    while (ret > 0) {   // as long as we got more than 0....
      // determines what struct type came back
      TWildcatRequest* tw = (TWildcatRequest*)MyBuf;  // what op code came back?
      switch(tw->type){
        // the message header struct came back.(wcgui.h)
        case wrListMessages_MsgHeader: {  
         /* You got your header data!  With the below command we are casting the
            received data into our prepared structure.  Think of casting as
            telling windows that we want the received data to conform to our
            prepared data template */ 
         mhr = (TListMessages_MsgHeader_Response *)MyBuf; 
         if(rmin>0){
          memset(data, 0, sizeof(data)); // initializes Data array
          strcpy(data, "\r\n"); // adds a carriage return & line feed to file
          myFile.Write(data, strlen(data));
          }
         memset(data, 0, sizeof(data)); // initialize data
         strcpy(data, "Message Number: "); // copy string to data array
         itoa((int) mhr->mh.Number, sresult, 0xa); // convert integer to ascii
         strcat(data, sresult); // concantenate string
         strcat(data, "\r\n"); 
         myFile.Write(data, strlen(data)); // writes "data" string to our file
	
         memset(data, 0, sizeof(data));
         strcpy(data, "From: ");
         strcat(data, mhr->mh.From.Name);
         strcat(data, "\r\n");
         myFile.Write(data, strlen(data));
	           
         memset(data, 0, sizeof(data));
         strcpy(data, "To: ");
         strcat(data, mhr->mh.To.Name);
         strcat(data, "\r\n");
         myFile.Write(data, strlen(data));
	           
         memset(data, 0, sizeof(data));
         strcpy(data, "Subject: ");
         strcat(data, mhr->mh.Subject);
         strcat(data, "\r\n");
         myFile.Write(data, strlen(data));
	           
         memset(data, 0, sizeof(data));
         strcpy(data, "Conference Number: ");
         itoa((int)mhr->mh.Conference, sresult, 0xa);
         strcat(data, sresult);
         strcat(data, "\r\n");
         myFile.Write(data, strlen(data));                                            
         rmin++;
         break;
        }
        // the message text struct came back. (wcgui.h)
        case wrListMessages_MsgText: {  
         /* You got your msg text data!  With the below command we are casting the
            received data into our prepared structure.  Think of casting as
            telling windows that we want the received data to conform to our
            prepared data template */         
         mtr = (TListMessages_MsgText_Response *)MyBuf; 
         memset(data, 0, sizeof(data));
         // copies only the length of the 1024 byte block used by mtr->text
         strncpy(data, mtr->text, mtr->len);
         strcat(data, "\r\n");
         myFile.Write(data, strlen(data));
         break; 
        }
      } 
      ret = recv(s, MyBuf, 8192, 0); // update how many bytes did we receive?
    }  
    closesocket(s);  // don't forget to do this here!
  } else 
  if (WSAGETSELECTEVENT(lp) & FD_READ) {
    ret = recv(s, MyBuf, 8192, 0); // how many bytes did we receive?
    while (ret > 0) {  // as long as we got more than 0....
       // determines what struct type came back
       TWildcatRequest* tw = (TWildcatRequest*)MyBuf; // what op code came back?
       switch(tw->type){
        // the message header struct came back. (wcgui.h)
        case wrListMessages_MsgHeader: {  
         /* You got your header data!  With the below command we are casting the
            received data into our prepared structure.  Think of casting as
            telling windows that we want the received data to conform to our
            prepared data template */           
           mhr = (TListMessages_MsgHeader_Response *)MyBuf; 
           if(rmin>0){
            memset(data, 0, sizeof(data)); // initializes Data array
            strcpy(data, "\r\n"); // adds a carriage return & line feed to file
            myFile.Write(data, strlen(data));
            }
           memset(data, 0, sizeof(data));
           strcpy(data, "Message Number: ");
           itoa((int)mhr->mh.Number, sresult, 0xa);
           strcat(data, sresult);
           strcat(data, "\r\n");
           myFile.Write(data, strlen(data));

           memset(data, 0, sizeof(data));
           strcpy(data, "From: ");
           strcat(data, mhr->mh.From.Name);
           strcat(data, "\r\n");
           myFile.Write(data, strlen(data));
           
           memset(data, 0, sizeof(data));
           strcpy(data, "To: ");
           strcat(data, mhr->mh.To.Name);
           strcat(data, "\r\n");
           myFile.Write(data, strlen(data));
           
           memset(data, 0, sizeof(data));
           strcpy(data, "Subject: ");
           strcat(data, mhr->mh.Subject);
           strcat(data, "\r\n");
           myFile.Write(data, strlen(data));
           
           memset(data, 0, sizeof(data));
           strcpy(data, "Conference Number: ");
           itoa((int)mhr->mh.Conference, sresult, 0xa);
           strcat(data, sresult);
           strcat(data, "\r\n");
           myFile.Write(data, strlen(data));                                            
           rmin++;
           break;
        }
        // the message text struct came back. (wcgui.h)
        case wrListMessages_MsgText: {  
         /* You got your msg text data!  With the below command we are casting the
            received data into our prepared structure.  Think of casting as
            telling windows that we want the received data to conform to our
            prepared data template */
           mtr = (TListMessages_MsgText_Response *)MyBuf; 
           memset(data, 0, sizeof(data));
           // copies only the length of the 1024 byte block used by mtr->text
           strncpy(data, mtr->text, mtr->len);
           strcat(data, "\r\n");
           myFile.Write(data, strlen(data));
           break; 
        }
      } 
      ret = recv(s, MyBuf, 8192, 0);   // update how many bytes did we receive?
    }
  }
  return 0;
}

void CMainFrame::OnWildcatUsersonline() // "UO" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Users Online ("UO") toolbar button (or menu item) is
            selected we are routed to this function.
       b.  If successful we will request, and receive, a list of users online which
            will be displayed in an on screen listbox.  
       c.  If unsuccessful at any stage we get a warning message box and exit.
       d.  A user configurable timer has been included to allow the system to
            update the list box in the dialog at set intervals.
       
       NOTE:  This function requires the service of "cloadpxy.h" (Wildcat Proxy API),
              and "wildsock.h" (with Wildsock.Lib). 
    */

  MyUOLine = new CUOline( this ); // creates the modeless dialog box

	/*     Opens a socket to the Navigator Server agent. The WM_SOCKETNOTIFY_UONLINE
	       parameter is defined as a constant in the FRAMESDI.H portion of the code. Upon
	       receipt of a Network event message (WM_SOCKETNOTIFY_UONLINE) you are routed to
	       the message map in this unit (see above) and eventually to the
	       LRESULT CMainFrame::OnSockNotifyUOnline(WPARAM wp, LPARAM lp) function you will
	       find also here in this unit (see below).  In addition that function has been
	       added to the public area of the CMainFrame class of MAINFRM.H.
	       NOTE:  "s" is assigned our created socket...
	 */
    SOCKET s = GetWhosOnline(AfxGetMainWnd()->GetSafeHwnd(), WM_SOCKETNOTIFY_UONLINE); 
        /* Checks for valid socket, if not valid exits  */
    s1 = s;  // s1 is a global socket variable
    if(s == INVALID_SOCKET){ 
      AfxMessageBox("Socket NOT opened!", MB_ICONSTOP|MB_OK, 0);
      return;
    }   
  /* Note:  See CFramesdiApp::CFramesdiApp() (ie; the Constructor)
	          and CFramesdiApp::~CFramesdiApp() (ie; the destructor)
	          for required master startup and shutdown/cleanup functions in FRAMESDI.CPP
	*/
}

LRESULT CMainFrame::OnSockNotifyUOnline(WPARAM wp, LPARAM lp)
{

  /*  General discussion:
       a.  See the LRESULT CMainFrame::OnSockNotifyMessage(WPARAM wp, LPARAM lp)
            function above for comments that also apply here.
       b.  A Modal dialog will not work in this case as the dialog box must
            be updated, and a modal dialog would stop program execution
            and data flow if put here.
   */
  
  // struct for Who's Online Response (wcgui.h)
  TWhosOnline_Response *wolr; 
  char MyBuf[8192];  // defines a general purpose data buffer
  int ret;  // variable to store how many bytes we received  
	
	ret = 0;
	memset(MyBuf, 0, sizeof(MyBuf));
	memset(&wolr, 0, sizeof(wolr));	
  SOCKET s = (SOCKET)wp;
  if (WSAGETSELECTEVENT(lp) & FD_CLOSE) {
    ret = recv(s, MyBuf, 8192, 0); // how many bytes did we receive?
    while (ret > 0) {   // as long as we got more than 0....
      // determines what struct type came back
      TWildcatRequest* tw = (TWildcatRequest*)MyBuf;  // what op code came back?
      switch(tw->type){
        // the message header struct came back.(wcgui.h)
        case wrGetUserInfo: {
            wolr = (TWhosOnline_Response *)MyBuf;
            MyUOLine->ListBox1().AddString(wolr->NodeInfo.User.Name);
            break;
            }
      }
      ret = recv(s, MyBuf, 8192, 0); // Updates ret
    }
    closesocket(s);  // don't forget to do this here!
    if (s == s1) {
      s1 = INVALID_SOCKET; 
    }
  } else  
  if (WSAGETSELECTEVENT(lp) & FD_READ) {
    ret = recv(s, MyBuf, 8192, 0); // how many bytes did we receive?
    while (ret > 0) {  // as long as we got more than 0....
       // determines what struct type came back
       TWildcatRequest* tw = (TWildcatRequest*)MyBuf; // what op code came back?
       switch(tw->type){
        // the message header struct came back. (wcgui.h)
        case wrGetUserInfo: {
            wolr = (TWhosOnline_Response *)MyBuf;
            MyUOLine->ListBox1().AddString(wolr->NodeInfo.User.Name);
            break;
            }
      }
      ret = recv(s, MyBuf, 8192, 0); // Updates ret
    }
  }      
  return 0;
}

LRESULT CMainFrame::UpdateWhosOnline(WPARAM, LPARAM)
{
    if (s1 == INVALID_SOCKET) {
     MyUOLine->ListBox1().ResetContent(); // clears the list box
     /* adds an "updating" string to list box to let you know the timer
        is working correctly and the user list IS being updated.
     */
     MyUOLine->ListBox1().AddString("Updating...");
     /* calls LRESULT CMainFrame::OnSockNotifyUOnline(WPARAM wp, LPARAM lp)
        above (after going through the message map of course..)
     */
     s1 = GetWhosOnline(AfxGetMainWnd()->GetSafeHwnd(), WM_SOCKETNOTIFY_UONLINE); 
    }
  return 0;
}

void CMainFrame::OnWildcatHoroscope() // "H" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Horoscope ("H") toolbar button (or menu item) is
            selected we are routed to this function.
       b.  If successful we will be able to obtain a one line horoscope
            for our particular astrological sign.  
       c.  If unsuccessful at any stage we get a warning message box and exit.
       d.  This is a client/server application example, albeit a non-interactive one.
       e.  For additional indepth help with windows based client/server online
           application programming I would recommend the following excellent
           Visual C++ book (comes with source code & cd-rom):
           
           NetWarriors in C++ - Programming Multiplayer Games for Windows
            by Joe Gradecki - ISBN 0-471-11337-9(pbk) - Published by
            Wiley Computer Publishing
            
       f.  Here is an abbreviated flow chart:
       
           (1) DoHoroscope() (see below function call) goes to DoHoroscope()
                in HSCOPE.CPP and then to the CHScope::OnInitDialog()
                function.
           (2) FindWildcatService(HOROSCOPE_SERVICE_NAME, Service) goes
                to CFindServiceDialog::OnInitDialog() in FINDSERV.CPP
                If everything is successful in FINDSERV.CPP the socket
                on which the service is listening will be returned. In
                FINDSERV.CPP the flow is:
                (a) GetServiceByName(GetSafeHwnd(), 
                    WM_NAVIGATORNOTIFY, ServiceName) is establishes a 
                    the WM_NAVIGATORNOTIFY message in the message map 
                (b) Upon receipt of ON_MESSAGE(WM_NAVIGATORNOTIFY, 
                    OnNavigatorNotify) (see the message map in findserv.cpp)
                    we move to the CFindServiceDialog::OnNavigatorNotify
                    function in findserv.cpp
                (c) Now we go to CFindServiceDialog::DoNavigatorNotify 
                    (FINDSERV.CPP) and pass the socket address back to the
                    FindWildcatService in HSCOPE.CPP that called us.
           (3)  Now we OpenService(GetSafeHwnd(), 
                 WM_SERVICENOTIFY, &sin, TRUE) (in HSCOPE.CPP). This opens
                 the service to the socket address we received. We also
                 establish the WM_SERVICENOTIFY message in the HSCOPE.CPP
                 message map to handle any notification messages
                 received from the service.
           (4)  Now we submit our astrology sign choice by hitting
                 the radio button to submit our choice.  This takes us to
                 the CHScope::OnSubmit1() function in HSCOPE.CPP
           (5)  Upon receipt of ON_MESSAGE(WM_SERVICENOTIFY, 
                 OnServiceNotify) we move to the CHScope::OnServiceNotify
                 function in HSCOPE.CPP where we handle the incoming data from the
                 service in reply to our request.
           (6)  That's it! (Whew!!)          
    */  
  
  DoHoroscope();    
}

void CMainFrame::OnWildcatTictactoe()  // "TTT" button command on toolbar
{
    /* What we are accomplishing here:
       a.  When the Tic, Tac, Toe ("TTT") toolbar button (or menu item) is
            selected we are routed to this function.
       b.  If successful we will be able to play a game of Tic, Tac, Toe
            with a second person logged onto WC5.  
       c.  If unsuccessful at any stage we get a warning message box and exit.
       d.  This is an interactive client/server application example.
       e.  For additional indepth help with windows based client/server online
           application programming I would recommend the following excellent
           Visual C++ book (comes with source code & cd-rom):
           
           NetWarriors in C++ - Programming Multiplayer Games for Windows
            by Joe Gradecki - ISBN 0-471-11337-9(pbk) - Published by
            Wiley Computer Publishing
            
       f.  Here is an abbreviated flow chart:
       
           (1) DoTicTacToe() (see below function call) goes to DoTicTacToe()
                in TTTOE.CPP and then to the MyTicTacToe::OnInitDialog()
                function.
           (2) FindWildcatService(TICTACTOE_SERVICE_NAME, Service) goes
                to CFindServiceDialog::OnInitDialog() in FINDSERV.CPP
                If everything is successful in FINDSERV.CPP the socket
                on which the service is listening will be returned. In
                FINDSERV.CPP the flow is:
                (a) GetServiceByName(GetSafeHwnd(), 
                    WM_NAVIGATORNOTIFY, ServiceName) is establishes a 
                    the WM_NAVIGATORNOTIFY message in the message map 
                (b) Upon receipt of ON_MESSAGE(WM_NAVIGATORNOTIFY, 
                    OnNavigatorNotify) (see the message map in findserv.cpp)
                    we move to the CFindServiceDialog::OnNavigatorNotify
                    function in findserv.cpp
                (c) Now we go to CFindServiceDialog::DoNavigatorNotify 
                    (FINDSERV.CPP) and pass the socket address back to the
                    FindWildcatService in TTTOE.CPP that called us.
           (3)  Now we OpenService(GetSafeHwnd(), 
                 WM_SERVICENOTIFY_AGAIN, &sin, TRUE) (in TTTOE.CPP). This opens
                 the service to the socket address we received. We also
                 establish the WM_SERVICENOTIFY_AGAIN message in the TTTOE.CPP
                 message map to handle any notification messages
                 received from the service.
           (4)  Now our application starts up and we wait for another player
                 to come on line.
           (5)  Upon receipt of ON_MESSAGE(WM_SERVICENOTIFY_AGAIN, 
                 OnServiceNotify_Again) we move to the MyTicTacToe::OnServiceNotify_Again
                 function in TTTOE.CPP where we handle the incoming data from the
                 service in reply to our request.
           (6)  That's it! (Whew!!)          
    */  
  
  DoTicTacToe();
}
