// tttoe.cpp : implementation file
//
#include "common1.h"
#pragma hdrstop

#include <direct.h>

#include "framesdi.h"
#include "findserv.h"
#include "tttoe.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


TPlayerMove pm;

BOOL NotMyTurnNow;

int OldMove;

/////////////////////////////////////////////////////////////////////////////
// TicTacToe dialog

TicTacToe::TicTacToe(CWnd* pParent /*=NULL*/)
	: CDialog(TicTacToe::IDD, pParent)
{
	//{{AFX_DATA_INIT(TicTacToe)
	m_msgfromyou = "";
	m_msgtoyou = "";
	m_edit11 = "";
	m_edit12 = "";
	m_edit13 = "";
	m_edit21 = "";
	m_edit22 = "";
	m_edit23 = "";
	m_edit31 = "";
	m_edit32 = "";
	m_edit33 = "";
  
  GlobalTop = 0;
	//}}AFX_DATA_INIT
  
  Startup = TRUE;
  Disconnect = FALSE;
  ServiceSocket = INVALID_SOCKET;	
}

void TicTacToe::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TicTacToe) 
	DDX_Text(pDX, IDC_MSGFROMYOU, m_msgfromyou);
	DDV_MaxChars(pDX, m_msgfromyou, 33);
	DDX_Text(pDX, IDC_MSGTOYOU, m_msgtoyou);
	DDV_MaxChars(pDX, m_msgtoyou, 33);
	DDX_Text(pDX, IDC_EDIT11, m_edit11);
	DDV_MaxChars(pDX, m_edit11, 1);
	DDX_Text(pDX, IDC_EDIT12, m_edit12);
	DDV_MaxChars(pDX, m_edit12, 1);
	DDX_Text(pDX, IDC_EDIT13, m_edit13);
	DDV_MaxChars(pDX, m_edit13, 1);
	DDX_Text(pDX, IDC_EDIT21, m_edit21);
	DDV_MaxChars(pDX, m_edit21, 1);
	DDX_Text(pDX, IDC_EDIT22, m_edit22);
	DDV_MaxChars(pDX, m_edit22, 1);
	DDX_Text(pDX, IDC_EDIT23, m_edit23);
	DDV_MaxChars(pDX, m_edit23, 1);
	DDX_Text(pDX, IDC_EDIT31, m_edit31);
	DDV_MaxChars(pDX, m_edit31, 1);
	DDX_Text(pDX, IDC_EDIT32, m_edit32);
	DDV_MaxChars(pDX, m_edit32, 1);
	DDX_Text(pDX, IDC_EDIT33, m_edit33);
	DDV_MaxChars(pDX, m_edit33, 1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(TicTacToe, CDialog)
	//{{AFX_MSG_MAP(TicTacToe)
  ON_MESSAGE(WM_SERVICENOTIFY_AGAIN, OnServiceNotify_Again)
	ON_BN_CLICKED(IDC_BTN11, OnBtn11)
	ON_BN_CLICKED(IDC_BTN12, OnBtn12)
	ON_BN_CLICKED(IDC_BTN13, OnBtn13)
	ON_BN_CLICKED(IDC_BTN21, OnBtn21)
	ON_BN_CLICKED(IDC_BTN22, OnBtn22)
	ON_BN_CLICKED(IDC_BTN23, OnBtn23)
	ON_BN_CLICKED(IDC_BTN31, OnBtn31)
	ON_BN_CLICKED(IDC_BTN32, OnBtn32)
	ON_BN_CLICKED(IDC_BTN33, OnBtn33)
	ON_BN_CLICKED(IDC_SENDMSGBTN, OnSendmsgbtn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// TicTacToe message handlers

TicTacToe::~TicTacToe()
{
  if (ServiceSocket != INVALID_SOCKET) {
    closesocket(ServiceSocket);
    ServiceSocket = INVALID_SOCKET;
  }
}

BOOL TicTacToe::OnInitDialog()
{
  BOOL ret = CDialog::OnInitDialog();
  
  NotMyTurnNow = TRUE;
  
  // is Navigator running?            
  if(WildcatNavigatorStartup(GetSafeHwnd(), 
       WM_SERVICENOTIFY_AGAIN) == 0){
    
    // Checks to ensure we have the latest version of the client
    // uncomment the below code to implement it..
   
   /*if (WcCheckClientVersion(TICTACTOE_CLIENT_NAME, 
       TICTACTOE_CLIENT_VERSION) == 0) {
      Disconnect = TRUE;
      PostMessage(WM_COMMAND, IDOK);
      return FALSE;
    }               */

    // Calls FindWildcatService from the findserv.cpp unit 
    if (FindWildcatService(TICTACTOE_SERVICE_NAME, Service) == FALSE) {
      Disconnect = TRUE;
      PostMessage(WM_COMMAND, IDOK);
      return FALSE;
    }

    
    /* The following 8 lines of code takes the information obtained
        by the FindWildcatService function call and allows us to
        opens a socket directly to the service.
     */
    SOCKADDR_IN sin;
    memset(&sin, 0, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = Service.Address;
    sin.sin_port = htons((u_short)Service.Port);
    
    /* when something is received through the socket we will
       be notified under the "WM_SERVICENOTIFY_AGAIN" windows
       message.  Essentially a callback function..
     */
    ServiceSocket = OpenService(GetSafeHwnd(), 
       WM_SERVICENOTIFY_AGAIN, &sin, TRUE);
    if (ServiceSocket == INVALID_SOCKET) {
      PostMessage(WM_COMMAND, IDOK);
    }

  } else { 
    PostMessage(WM_COMMAND, IDOK);
  }
  m_msgtoyou = "Connecting with service...";
  UpdateData(FALSE);
  
  /* initializes the data structure */
  memset(&pm, 0, sizeof(pm));
  
  /* The ID code of our structure type.  By using an ID code you could
     have multiple data structures to send and receive from your
     single socket.  At the receiving end you would use a switch
     statement which would determine what structure type data has been
     received and then "cast" it correctly into the correct structure
     type.
   */
  pm.type = etPlayerMove; // see the TTTOE.H unit for further info
  
  /* The size of our game data structure.  This ensures that at the
     receiving end the correct amount of data has been received
     for the structure type sent.
;   */
  pm.size = sizeof(pm);
      
  /* which game are you in? 0 = none at present */
  pm.MyGameNumber = 99;
  
  /* 0 for not played yet, 1 for player 1, 2 for player 2 */
  pm.MyPlayerNumber = 0; 
 	
 	/* 0 for not played yet, 1 yes, 2 for no, 3 for notified but not yet moved */
 	pm.PermissionToMove = 0; 
  
  /* 0 for not yet playing, 1 waiting for another player, 
     2 for inplay, 3 for game over
   */	
  pm.IsThereAWinnerYet = 0;  
  
  /*  Your move: 0 for not played yet, 1 thru 9 for selected board spot */
  pm.MovePosition = 0;
  OldMove = 0;
  
  /*  His move: 0 for not played yet, 1 thru 9 for selected board spot */
  pm.OMovePosition = 0;
      
  /*  holds messages going and coming from the TTT service */
  memset(pm.TTTServiceMessage, 0, 
    sizeof(pm.TTTServiceMessage));
	strcpy(pm.TTTServiceMessage, m_msgfromyou);  
  
  SubmitPlayerData(&pm); // send initial game data to the WC5 TTT service
  
  return ret;
}
 
/* perform actions on the data we receive from the service */
void TicTacToe::ProcessServiceActions(struct TPlayerMove *MyPlayerInfo) 
{
	m_msgtoyou = "";
  
  /* passes information from our local MyPlayerInfo
     structure to the Global "pm" structure.
   */
  pm.MyGameNumber = MyPlayerInfo->MyGameNumber;
  pm.MyPlayerNumber = MyPlayerInfo->MyPlayerNumber;
  pm.PermissionToMove = MyPlayerInfo->PermissionToMove;
  pm.IsThereAWinnerYet = MyPlayerInfo->IsThereAWinnerYet;
  pm.MovePosition = MyPlayerInfo->MovePosition;
  pm.OMovePosition = MyPlayerInfo->OMovePosition;
  strcpy(pm.TTTServiceMessage, MyPlayerInfo->TTTServiceMessage);  
  m_msgtoyou = pm.TTTServiceMessage;  
  m_msgfromyou = "";
  UpdateData(FALSE);
  memset(pm.TTTServiceMessage, 0, 
    sizeof(pm.TTTServiceMessage));
  
  PostPlayerMove(&pm); // posts incoming opponent player move   
  
  CheckForGameOver(&pm); // is the game over yet?
    
  if((pm.PermissionToMove == 1) && (pm.IsThereAWinnerYet == 2)){  // it's your turn
     NotMyTurnNow = FALSE;
     AfxMessageBox("It's your turn!!", MB_ICONEXCLAMATION|MB_OK, 0);
  }
} 

/* alter the below procedure to process your various application data structures */
void TicTacToe::ProcessStructure(const TBaseStruct *bs)
{
  if (bs == NULL) {
    return;
  }
  switch (bs->type) {
    case etPlayerMove: { // this type structure arrived so process it
      if (bs->size == sizeof(TPlayerMove)) {
        TPlayerMove *MyPlayerInfo = (TPlayerMove*)bs;
        ProcessServiceActions(MyPlayerInfo);
      }                                      
      break;            
    }
    case etPlayerMessage: { // this type structure arrived so process it
      if (bs->size == sizeof(TPlayerMessage)) {
        // process the TPlayerMessage structure.
      }                                         
      break;
    }
  }
}

/* checks to ensure we get all the data we expect to get */
void TicTacToe::HandleIncoming(void *data, int size)
{ 
  if (data == NULL || size == 0) {
    return;
  }
  
  // add the new data we just received to our global memory buffer.
  // Rightfully, this should be making sure we don't overflow the 
  // buffer, but for simplicity, that code will be omitted.
  
  memcpy(&GlobalBuffer[GlobalTop], data, size);
  GlobalTop += size;
  
  // Check to see if we have enough in the buffer to extract a structure.
  // If the amount of data we have in our global buffer meets or exceeds
  // the size of our base structure AND the size of the structure we are 
  // trying to read, then pass the structre to the ProcessStructre 
  // procedure. Once the structure has been processed, we need to extract 
  // the structure from our gloabl buffer, and slide down any data beyond
  // where the structre ended.
  // 
  // Let me illistrate though how this is going to work. Each box below 
  // illistrates our global memory buffer. The data in the buffer is 
  // displayed as either an asterisk (*) or a lowercase oh (o). The unused 
  // portion of the buffer is illistrated through a period. 
  //
  //   [--------------------]  The first time into this routine, our buffer
  //   [oooooooooo..........]  will be completely blank. The data we just 
  //   [....................]  will be added to our global buffer (in this 
  //   [....................]  case 10 bytes). However, by inspecting the 
  //   [--------------------]  buffer, we determine that the structure we 
  //                           are trying to extract is 12 bytes long. We 
  // do not yet have enough in our buffer to process this structure. 
  // Therefore, we exit without acting upon the data in our global buffer.
  //    
  //   [--------------------]  The second time this routine is called, we 
  //   [**********oooooooooo]  have read an additional 15 bytes of data.
  //   [ooooo...............]  This is added to our gloabl memory buffer.
  //   [....................]  We now have enough in our buffer to extract
  //   [--------------------]  and proceess the 12 byte structure. Once 
  //                           extracted, however, we do not want to re-
  // process the same structure again. Therefore, we need to remove the 
  // twelve bytes comprising the structure, and slide down the data beyond
  // where the structure ends. 
  //
  //   [--------------------]  In this final example, we see that our buffer
  //   [*************ooooooo]  has been reset to not include the original 
  //   [ooo.................]  structure. In addition, we have received an 
  //   [....................]  additional 10 bytes. If the next structure in
  //   [--------------------]  is complete within our global buffer, we can 
  //                           go ahead and extract and process it. Otherwise,
  //  we will need to wait for one or more additional iterations.
  
  if (GlobalTop >= sizeof(TBaseStruct)) {
    TBaseStruct *bs = (TBaseStruct*)GlobalBuffer;
    while (GlobalTop >= bs->size) {
      ProcessStructure(bs);
      GlobalTop -= bs->size;
      memmove(GlobalBuffer, &GlobalBuffer[(int)bs->size], (size_t)GlobalTop);
    }
  }
}
  
afx_msg LRESULT TicTacToe::OnServiceNotify_Again(WPARAM wp, LPARAM lp)
{                                                               
  /* Don't change a thing here! */
  
  SOCKET s = wp;
  if (WSAGETSELECTEVENT(lp) & FD_CLOSE) { // close notify
    while (TRUE) {
      char buf[8192];
      int read = recv(s, buf, sizeof(buf), 0);
      if (read <= 0) {
        break;
      }
      HandleIncoming(buf, read);
    }
    closesocket(s);
    return 0;
  } else 
  if (WSAGETSELECTEVENT(lp) & FD_READ) { // read notify
    char buf[8192];
    int read = recv(s, buf, sizeof(buf), 0);
    if (read <= 0) {
      closesocket(s);
    }
    HandleIncoming(buf, read);
    return 0;
  }
  return 0;
}

/* post the opponents move we received from the service */
void TicTacToe::PostPlayerMove(TPlayerMove *pm)
{
  if(OldMove != pm->OMovePosition){
	switch(pm->OMovePosition){
	 case 0:{   
	  break;
	 }
	 case 1:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit11 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit11 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 2:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit12 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit12 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 3:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit13 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit13 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 4:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit21 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit21 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 5:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit22 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit22 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 6:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit23 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit23 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 7:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit31 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit31 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 8:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit32 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit32 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }
	 case 9:{
     if(pm->MyPlayerNumber == 1){  // it's player 1 so place a "O"
  	   m_edit33 = "O";
  	 }
  	 if(pm->MyPlayerNumber == 2){  // it's player 2 so place a "X"
  	   m_edit33 = "X";
  	 }	  
    UpdateData(FALSE);
	  break;
	 }	 	 	 	 	 	 
	 default:{
	  break;
	 }
  }
 }
}

/* checks for notification from the service on status of the game */                  
void TicTacToe::CheckForGameOver(struct TPlayerMove *pm)
{
	switch(pm->IsThereAWinnerYet){
	 case 0:{ // game not yet begun
	  break;
	 }
	 case 1:{ // waiting for another player
	  break;
	 }
	 case 2:{ // in play
	  break;
	 }
	 case 3:{   // the game is over!
	  AfxMessageBox("Game Over!!", 
	     MB_ICONEXCLAMATION|MB_OK, 0);
	     PostMessage(WM_COMMAND, IDOK);
	  break;
	 }	 
	 default:{
	  break;
	 }
	}
 }

/* sends data to the WC5 TTT service */
void TicTacToe::SubmitPlayerData(struct TPlayerMove *pm)
{
  memset(pm->TTTServiceMessage, 0, 
     sizeof(pm->TTTServiceMessage));
  strcpy(pm->TTTServiceMessage, m_msgfromyou);
  
  /* send the "pm" structure with all it's data to
     the TTT service.  The is a very good method for sending
     mixed data types to the service.  The Sizeof function 
     should reflect the base structure type, in this case
     "TPlayerMove", and not the assigned variable name to
     ensure that the size is correctly determined.
   */
  send(ServiceSocket, (LPSTR)pm, sizeof(TPlayerMove), 0);
}

void DoTicTacToe()
{
  /* The next 6 lines adds the Tic, Tac, Toe Client
     icon to the Connection Manager's Toolbar
  */
  
  char navinifile[_MAX_PATH];
  getcwd(navinifile, sizeof(navinifile));
  if (navinifile[strlen(navinifile)] != '\\') {
    strcat(navinifile, "\\");
  }   
  
  strcat(navinifile, "wcnav.ini");
  WritePrivateProfileString("ToolBar", TICTACTOE_CLIENT_NAME, 
    TICTACTOE_CLIENT_NAME, navinifile);	
	
  TicTacToe MyTicTacToe;
	
	MyTicTacToe.DoModal(); // Make's the Tic, Tac, Toe dialog box visible
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn11()
{
	/* the game's started and there is no winner or draw */
	if((NotMyTurnNow == FALSE) && (pm.IsThereAWinnerYet == 2)){
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit11 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit11 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit11 = "O";
  	 }
     UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 1;  // post move
     SubmitPlayerData(&pm); // submit the move
     NotMyTurnNow = TRUE;
    }
	 }
  }
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn12()
{
	if((NotMyTurnNow == FALSE) && 
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw  */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit12 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit12 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit12 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 2;  // post move
     SubmitPlayerData(&pm); // submit the move 
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn13()
{
	if((NotMyTurnNow == FALSE) && 
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit13 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit13 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit13 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 3;  // post move
     SubmitPlayerData(&pm); // submit the move 
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn21()
{
	if((NotMyTurnNow == FALSE) &&
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit21 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit21 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit21 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 4;  // post move
     SubmitPlayerData(&pm); // submit the move
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn22()
{
	if((NotMyTurnNow == FALSE) &&
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit22 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit22 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit22 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 5;  // post move
     SubmitPlayerData(&pm); // submit the move
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn23()
{
	if((NotMyTurnNow == FALSE) &&
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit23 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit23 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit23 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 6;  // post move
     SubmitPlayerData(&pm); // submit the move
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn31()
{
	if((NotMyTurnNow == FALSE) &&
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit31 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit31 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit31 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 7;  // post move
     SubmitPlayerData(&pm); // submit the move
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn32()
{
	if((NotMyTurnNow == FALSE) &&
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit32 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit32 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit32 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 8;  // post move
     SubmitPlayerData(&pm); // submit the move
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the row, column button we pushed */
void TicTacToe::OnBtn33()
{
	if((NotMyTurnNow == FALSE) &&
	 (pm.IsThereAWinnerYet == 2)){ /* the game's started and there is
	   no winner or draw */
   if(pm.PermissionToMove == 1){ // it's your turn
    if(m_edit33 == ""){  // it's a blank spot
     if(pm.MyPlayerNumber == 1){  // it's player 1 so place a "x"
  	   m_edit33 = "X";
  	 }
  	 if(pm.MyPlayerNumber == 2){  // it's player 2 so place a "o"
  	   m_edit33 = "O";
  	 }
   	 UpdateData(FALSE); // put the "x" or "o" on the screen in the box
     pm.MovePosition = 9;  // post move
     SubmitPlayerData(&pm); // submit the move
     NotMyTurnNow = TRUE;
    }
	 }
  }	
}

/* corresponds to the send message button on the dialog */
void TicTacToe::OnSendmsgbtn()
{
	UpdateData(TRUE);
}
