'shared variables defined

Dim Shared selected$               'current object
Dim Shared selectobjectmode%       'object select mode on/off
Dim Shared objects$(12)            'objects in directory
Dim Shared selectedred%            'object average red component
Dim Shared selectedgreen%          'object average green component
Dim Shared selectedblue%           'object average blue component
Dim Shared colourchart(34, 3) As Integer 'colours to go ...
Dim Shared colourinmode%           'we're selecting a colour
Dim Shared frozen%                 'frozen yes/no
Dim Shared penred%                 'pen average red component
Dim Shared pengreen%               'pen average green component
Dim Shared penblue%                'pen average blue component
Dim Shared sizex%                  'object size x
Dim Shared sizey%                  'object size y
Dim Shared brush%                  'paintbrush size 0-2 ~ 1, 3, 5 pixel block
Dim Shared picloaded%              'frozen & object loaded
Dim Shared zoomx%                  'current zoom state for x: 100% = normal size
Dim Shared zoomy%                  'current zoom state for y
Dim Shared oldx%                   'where object was - only copyblock
Dim Shared oldy%                   ' where necesary
Dim Shared xpos%                   'doing a x pos calc
Dim Shared coltest%                'for auto colour select
Dim Shared colourbaron%            'colourbar only for ranges - not which=1
Dim Shared w0%, w1%, w2%, w3%, r1%, r2%, r3%  'colour object change ranges
Dim Shared w02%, w12%, w22%, w32%, r12%, r22%, r32%  'colour draw change ranges
Dim Shared col1%, col2%            'for colour select screen
Dim Shared pixelpatch%             'patch for stray pixel
Dim Shared original%               'indicates original colour for object
Dim Shared logo%                   'is the logo showing
Dim Shared bodystatus%             'body draw state
Dim Shared bodymovex%, bodymovey%  'body start co-ords
Dim Shared bodyx2%, bodyy2%        'end co-ords
Dim Shared b1%, b2%, b3%, b4%      'remove body block
Dim Shared bbb1%, bbb2%, bbb3%, bbb4%      'for body OK
Dim Shared bodydirection%          'which side of square
Dim Shared linex%, liney%          'for paint line
Dim Shared lastpicsaved%           'saved counter
Dim Shared drawred%                'draw average red component
Dim Shared drawgreen%              'draw average green component
Dim Shared drawblue%               'draw average blue component
Dim Shared picselect%              'awaiting pic select for store/print
Dim Shared olderx%, oldery%        'old x&y sizes
Dim Shared anychange%              'did a body change occur? (4 y/n)
Dim Shared jump%                   '% for body increase/decrease
Dim Shared bodyzoom%               'size of the current zoom
Dim Shared onoff%, onoff3%, onoff4%, onoff5%'menus which are open
Dim Shared oldmidx%, oldmidy%      'old v/hscroll1.values
Dim Shared slide%                  'current slide showing
Dim Shared area%(4801, 2)          'fading array of x,y co-ords
Dim Shared delayslide%             'waiting for slide change
Dim Shared slidetext$()            'text for slideshow
Dim Shared currentslide%           'current slide
Dim Shared slidestext%             'how many slides are there
Dim Shared moveorgx%, moveorgy%    'old left,top pos before body
Dim Shared viewdelay%              'the views delay flag = plz wait
Dim Shared printstate%             'printstate%
Dim Shared key0%                   'key 0 for background view
Dim Shared zoomstep%               'zoom/body/move step size
Dim Shared stepperbusy%            'busy changing step size
Dim Shared greystate%              'greyscale is on
Dim Shared z1%, z2%, z3%, z4%, z5%, z6%   'for greyscale at the zoom
Dim Shared widthx%, widthy%        'for body
Dim Shared m1%, m2%, m3%, m4%      'remove body block

Sub body ()
  If Not viewdelay% And frozen% And selectobjectmode% = 0 And colourinmode% = 0 And bodystatus% = 0 And picselect% = 0 And picloaded% Then
    bodystatus% = 1
    grabit.MousePointer = 5
  End If
End Sub

Sub bodyend (abc%)
  If abc% And anychange% Then   'Cancel
    grabit.HScroll1.Value = oldmidx%
    grabit.VScroll1.Value = oldmidy%
    sizex% = olderx%
    sizey% = oldery%
    Call restorerle
    Call copyblock(0, 0, 640, 480, 2, 1)
    q% = maskimage(selected$, getxpos%(), getypos%(), 0, 3, 1)
    Call copyblock(0, 0, 640, 480, 1, 0)
  Else   'Ok
    Call restorerle
    Call storerle
    Call copyblock(0, 0, sizex%, sizey%, 5, 3)
    Call setactivepage(4)
    If bodydirection = 1 Then
      sizey% = yzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 0)
    ElseIf bodydirection = 2 Then
      sizey% = yzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 1)
    ElseIf bodydirection = 3 Then
      sizex% = xzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 0)
    ElseIf bodydirection = 4 Then
      sizex% = xzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 1)
    End If
  End If
  grabit.bodyplus.Visible = False
  grabit.Bodyminus.Visible = False
  grabit.bodyok.Visible = False
  grabit.bodynotok.Visible = False
  grabit.Line (b1%, b2%)-(b3%, b4%), RGB(0, 128, 0), B
  bodystatus% = 0
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
  Call resetundo
  oldx% = 0
  oldy% = 0
End Sub

Sub bodymove (direct%)
  If bodystatus% = 4 And sizex% < 600 Then
    grabit.MousePointer = 11
    anychange% = True
    testx% = getxpos%()
    testy% = getypos%()
    x1% = bodymovex%
    x2% = bodyx2%
    y1% = bodymovey%
    y2% = bodyy2%
    oldx% = sizex%
    oldy% = sizey%
    oldtestx% = testx%
    oldtesty% = testy%
    jump% = (zoomstep% * 2) + 1
    If direct% = 1 Then
      bodyzoom% = bodyzoom% + jump%
    Else
      bodyzoom% = bodyzoom% - jump%
    End If
    If bodyzoom% > 300 Then bodyzoom% = 300
    If bodyzoom% < 0 Then bodyzoom% = 0
    
    Call restorerle
    Call storerle
    Call copyblock(0, 0, olderx%, oldery%, 3, 5)
    Call setactivepage(5)
    If bodydirection = 1 Then
      sizey% = yzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 0)
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(0, 128, 0), B
      newysize% = round%(widthy% * (bodyzoom% / 100!))
      b2% = m2% - (newysize% - widthy%)
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(255, 0, 0), B
      grabit.Refresh
      grabit.VScroll1.Value = moveorgy% - (sizey% \ 2)
      If sizey% \ 2 <> sizey% / 2 Then
	grabit.VScroll1.Value = grabit.VScroll1.Value - 1
      End If
    ElseIf bodydirection = 2 Then
      sizey% = yzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 1)
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(0, 128, 0), B
      newysize% = round%(widthy% * (bodyzoom% / 100!))
      b4% = m4% + newysize% - widthy%
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(255, 0, 0), B
      grabit.Refresh
      grabit.VScroll1.Value = moveorgy% + (sizey% \ 2)
    ElseIf bodydirection = 3 Then
      sizex% = xzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 0)
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(0, 128, 0), B
      newxsize% = round%(widthx% * (bodyzoom% / 100!))
      If bodyzoom% > 100 Then
	If newxsize% And 3 <> 0 Then newxsize% = newxsize% + (4 - (newxsize% And 3))
      Else
	If newxsize% And 3 <> 0 Then newxsize% = newxsize% - (newxsize% And 3)
      End If
      b1% = m1% - (newxsize% - widthx%)
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(255, 0, 0), B
      grabit.Refresh
      grabit.HScroll1.Value = moveorgx% - (sizex% \ 2)
      If moveorgx% > (CInt(((CInt(grabit.HScroll1.Value \ 4) * 4) - (sizex% \ 2)) \ 4) * 4) + sizex% Then
	grabit.HScroll1.Value = grabit.HScroll1.Value + 4
      ElseIf moveorgx% < (CInt(((CInt(grabit.HScroll1.Value \ 4) * 4) - (sizex% \ 2)) \ 4) * 4) + sizex% Then
	grabit.HScroll1.Value = grabit.HScroll1.Value - 4
      End If
    ElseIf bodydirection = 4 Then
      sizex% = xzoomblock(bbb1%, bbb2%, bbb3%, bbb4%, bodyzoom%, 1)
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(0, 128, 0), B
      newxsize% = round%(widthx% * (bodyzoom% / 100!))
      If bodyzoom% > 100 Then
	If newxsize% And 3 <> 0 Then newxsize% = newxsize% + (4 - (newxsize% And 3))
      Else
	If newxsize% And 3 <> 0 Then newxsize% = newxsize% - (newxsize% And 3)
      End If
      b3% = m3% + newxsize% - widthx%
      grabit.Line (b1%, b2%)-(b3%, b4%), RGB(255, 0, 0), B
      grabit.Refresh
      grabit.HScroll1.Value = moveorgx% + (sizex% \ 2)
      If moveorgx% > CInt(((CInt(grabit.HScroll1.Value \ 4) * 4) - (sizex% \ 2)) \ 4) * 4 Then
	grabit.HScroll1.Value = grabit.HScroll1.Value + 4
      ElseIf moveorgx% < CInt(((CInt(grabit.HScroll1.Value \ 4) * 4) - (sizex% \ 2)) \ 4) * 4 Then
	grabit.HScroll1.Value = grabit.HScroll1.Value - 4
      End If
    End If
    testx% = getxpos%()
    testy% = getypos%()
    If testx% < oldtestx% Then
      qwer1% = testx%
    Else
      qwer1% = oldtestx%
    End If
    If testy% < oldtesty% Then
      qwer2% = testy%
    Else
      qwer2% = oldtesty%
    End If
    If sizex% > oldx% Then
      qwer3% = sizex%
    Else
      qwer3% = oldx%
    End If
    If sizey% > oldy% Then
      qwer4% = sizey%
    Else
      qwer4% = oldy%
    End If
    Call copyblock(qwer1%, qwer2%, qwer1% + qwer3%, qwer2% + qwer4%, 2, 1)
    q% = maskimage(selected$, getxpos%(), getypos%(), 0, 5, 1)
    Call copyblock(qwer1%, qwer2%, qwer1% + qwer3%, qwer2% + qwer4%, 1, 0)
    grabit.MousePointer = 0
  End If
End Sub

Sub brushcolourdraw ()
  grabit.Picture1.FillColor = RGB(drawred%, drawgreen%, drawblue%)
  grabit.Picture1.Cls
  Select Case brush%
  Case 0
    grabit.Picture1.Circle (7, 7), 2
  Case 1
    grabit.Picture1.Circle (7, 7), 4
  Case 2
    grabit.Picture1.Circle (7, 7), 6
  End Select
End Sub

Sub brushsize ()
  grabit.Picture1.Cls
  brush% = brush% + 1
  If brush% = 3 Then brush% = 0
  Select Case brush%
  Case 0
    Call setbrushsize(3)
    grabit.Picture1.Circle (7, 7), 2
  Case 1
    Call setbrushsize(5)
    grabit.Picture1.Circle (7, 7), 4
  Case 2
    Call setbrushsize(8)
    grabit.Picture1.Circle (7, 7), 6
  End Select
End Sub

Sub chartcolour (x, y)
  p% = 124 + ((x / 100) * 480)
  If y <= 36 Then
    ttt% = grabit.HScroll6.Value
    Call setupcolourbarindicators(p%, ttt%)
    grabit.HScroll5.Value = p%
  Else
    ttt% = grabit.HScroll5.Value
    Call setupcolourbarindicators(ttt%, p%)
    grabit.HScroll6.Value = p%
  End If
End Sub

Sub colourbar ()
  If colourbaron% Then
    colourinmode% = 2
    vtemp% = grabit.HScroll5.Value
    If greystate% Then
      Call colourmixdo(vtemp%)
      greystate% = True
    Else
      Call colourmixdo(vtemp%)
    End If
    Call drawbar
    If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
  End If
End Sub

Sub colourbarcopyaround ()
  Call copyblock(0, 0, 640, 2, 1, 0)      'top of bar
  Call copyblock(0, 0, 92, 34, 1, 0)      'left of bar
  Call copyblock(638, 0, 2, 34, 1, 0)     'right
  Call copyblock(0, 34, 640, 462, 1, 0)   'below
End Sub

Sub colourbarnew (page%)
  Call setactivepage(page%)
  For x% = 76 To 168 Step 4
    p@ = (x% - 76) / 100
    c1% = w1% + (r1% * p@)
    c2% = w2% + (r2% * p@)
    c3% = w3% + (r3% * p@)
    Call blockrgb(x%, 225, 4, 35, c1%, c2%, c3%)
    c1% = w12% + (r12% * p@)
    c2% = w22% + (r22% * p@)
    c3% = w32% + (r32% * p@)
    Call blockrgb(x%, 260, 4, 35, c1%, c2%, c3%)
  Next x%
End Sub

Sub colourbarshow ()
  Call setactivepage(0)
  For x% = 92 To 620 Step 4
    p@ = (x% - 92) / 528
    c1% = w1% + (r1% * p@)
    c2% = w2% + (r2% * p@)
    c3% = w3% + (r3% * p@)
    Call blockrgb(x%, 2, 4, 16, c1%, c2%, c3%)
    c1% = w12% + (r12% * p@)
    c2% = w22% + (r22% * p@)
    c3% = w32% + (r32% * p@)
    Call blockrgb(x%, 18, 4, 16, c1%, c2%, c3%)
  Next x%
End Sub

Sub colourmix (topornot%)
  If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    grabit.MousePointer = 11
    scrollgone (2)
    Call setactivepage(1)
    Call clearpage(1)
    tmp% = 1
    Open selected$ + "-2.mmp" For Binary As #1
    dum$ = "  "
    Get #1, 13, dum$
    sx% = (Asc(Right$(dum$, 1)) * 256 + Asc(Left$(dum$, 1)))
    Get #1, 15, dum$
    sy% = (Asc(Right$(dum$, 1)) * 256 + Asc(Left$(dum$, 1)))
    Close
    yspot% = (480 - (sy% * 4)) \ 2
    col1% = yspot%
    col2% = sy%
    z% = 2
    For y% = 0 To 3
      For x% = 0 To 3
	Open selected$ + ".rgb" For Input As #1
	Line Input #1, tr$
	Line Input #1, tg$
	Line Input #1, tb$
	Close 1
	wow1% = (colourchart(z%, 1) + colourchart(z% - 1, 1)) \ 2
	wow2% = (colourchart(z%, 2) + colourchart(z% - 1, 2)) \ 2
	wow3% = (colourchart(z%, 3) + colourchart(z% - 1, 3)) \ 2
	newr% = 100 + (wow1% - Val(tr$)) / Val(tr$) * 100
	newg% = 100 + (wow2% - Val(tg$)) / Val(tg$) * 100
	newb% = 100 + (wow3% - Val(tb$)) / Val(tb$) * 100
	q% = colmiximage(selected$ + "-2", x% * 140 + 80, yspot%, tmp%, 1, Val(tr$), Val(tg$), Val(tb$), newr%, newg%, newb%)
	tmp% = 0
	z% = z% + 2
      Next x%
      yspot% = yspot% + sy%
    Next y%
    Call copyblock(0, 0, 640, 480, 1, 0)
    Call setactivepage(0)
    colourinmode% = topornot%
    grabit.MousePointer = 0
  End If
End Sub

Sub colourmixdo (which%)
  If Not viewdelay% And frozen% And colourinmode% = 1 And selectobjectmode% = False And picselect% = 0 And bodystatus% = 0 Then
    q% = pcv_clearvideorect(0, 0, 641, 480)
    If which% = 1 Then
      colourinmode% = 2
      GoTo test
    End If
    w0% = (which% - 2) * 2 + 1
    If colourchart(w0%, 1) < colourchart(w0% + 1, 1) Then
      w1% = colourchart(w0%, 1)
    Else
      w1% = colourchart(w0% + 1, 1)
    End If
    If colourchart(w0%, 2) < colourchart(w0% + 1, 2) Then
      w2% = colourchart(w0%, 2)
    Else
      w2% = colourchart(w0% + 1, 2)
    End If
    If colourchart(w0%, 3) < colourchart(w0% + 1, 3) Then
      w3% = colourchart(w0%, 3)
    Else
      w3% = colourchart(w0% + 1, 3)
    End If
    r1% = Abs(colourchart(w0%, 1) - colourchart(w0% + 1, 1))
    r2% = Abs(colourchart(w0%, 2) - colourchart(w0% + 1, 2))
    r3% = Abs(colourchart(w0%, 3) - colourchart(w0% + 1, 3))
    w02% = w0%
    w12% = w1%
    w22% = w2%
    w32% = w3%
    r12% = r1%
    r22% = r2%
    r32% = r3%
    colourinmode% = 2
    which% = 360
  End If
test:
  If frozen% And colourinmode% = 2 And selectobjectmode% = False Then
    grabit.MousePointer = 11
    If which% = 1 Then
      newr% = 100
      newg% = 100
      newb% = 100
      penred% = selectedred%
      pengreen% = selectedgreen%
      penblue% = selectedblue%
      original% = -1
      drawred% = selectedred%
      drawgreen% = selectedgreen%
      drawblue% = selectedblue%
    Else
      p@ = (which% - 92) / 528
      c1% = w1% + (r1% * p@)
      c2% = w2% + (r2% * p@)
      c3% = w3% + (r3% * p@)
      newr% = 100 + (c1% - selectedred%) / selectedred% * 100
      newg% = 100 + (c2% - selectedgreen%) / selectedgreen% * 100
      newb% = 100 + (c3% - selectedblue%) / selectedblue% * 100
      penred% = c1%
      pengreen% = c2%
      penblue% = c3%
      original% = 0
      drawred% = penred%
      drawgreen% = pengreen%
      drawblue% = penblue%
    End If
    
    If coltest% <> 0 Then
      Call copyblock(0, 0, 640, 480, 2, 1)
      Call copyblock(0, 0, sizex%, sizey%, 4, 3)
    End If
    
    Call setactivepage(3)
    If which% <> 1 Then
      Call colourchange(selectedred%, selectedgreen%, selectedblue%, newr%, newg%, newb%)
      z1% = selectedred%
      z2% = selectedgreen%
      z3% = selectedblue%
      z4% = newr%
      z5% = newg%
      z6% = newb%
    End If
    q% = maskimage(selected$, getxpos%(), getypos%(), 0, 3, 1)
    If onoff3% And colourbaron% Then Call colourbarnew(1)
    If which% <> 1 Then
      If grabit.HScroll5.Value <> which% Then
	grabit.HScroll5.Value = which%
	grabit.HScroll6.Value = which%
      End If
      colourbaron% = True
      Call copyblock(0, 0, 640, 480, 1, 0)
    Else
      colourbaron% = False
      Call copyblock(0, 0, 640, 480, 1, 0)
    End If
    brushcolourdraw
    scrollhere
    colourinmode% = False
    grabit.MousePointer = 0
    pixelpatch% = 0
    drawbar
    greystate% = False
    Call resetundo
  End If
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
End Sub

Sub drawbar ()
  p@ = (grabit.HScroll6.Value - 92) / 528
  If colourbaron% Then
    drawred% = w12% + (r12% * p@)
    drawgreen% = w22% + (r22% * p@)
    drawblue% = w32% + (r32% * p@)
    p2@ = (grabit.HScroll5.Value - 92) / 528
    drawred2% = w1% + (r1% * p@)
    drawgreen2% = w2% + (r2% * p@)
    drawblue2% = w3% + (r3% * p@)
    drawred2% = drawred% * ((100 + (selectedred% - drawred2%) / drawred2% * 100) / 100)
    drawgreen2% = drawgreen% * ((100 + (selectedgreen% - drawgreen2%) / drawgreen2% * 100) / 100)
    drawblue2% = drawblue% * ((100 + (selectedblue% - drawblue2%) / drawblue2% * 100) / 100)
  End If
  Call initcolours(drawred%, drawgreen%, drawblue%)
  Call defcolours(drawred2%, drawgreen2%, drawblue2%)
  brushcolourdraw
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
End Sub

Sub ending ()
  freememory
  q% = pcv_disablevideo()
  q% = pcv_exit()
  End
End Sub

Sub freeze ()
  frozen% = True
  penred% = 137
  pengreen% = 117
  penblue% = 86
  zoomx% = 0
  zoomy% = 0
  colourbaron% = 0
  original% = -1
  sizex% = 0
  sizey% = 0
  q% = pcv_freezevideo()
  Call copyblock(0, 0, 640, 480, 0, 2)
End Sub

Sub freezetoggle ()
  If bodystatus% = 0 Then
    If frozen% = False Then
      freeze
      target (0)
      Call resetundo
    Else
      unfreeze
      scrollgone (1)
      colourinmode% = False
      selectobjectmode% = False
      picselect% = False
      target (12)
    End If
  End If
End Sub

Sub freezetogglepre ()
  Call freezetoggle
  If frozen% Then Call views(1)
End Sub

Function getxpos% ()
  
  'used to use scroll-bars
  
  xpos% = True
  xtemp% = grabit.HScroll1.Value
  If grabit.HScroll1.Value < (sizex% \ 2) + 8 Then xtemp% = (sizex% \ 2) + 8
  If grabit.HScroll1.Value > 639 - (sizex% \ 2) Then xtemp% = 639 - (sizex% \ 2)
  grabit.HScroll1.Value = CInt(xtemp% \ 4) * 4
  getxpos% = CInt((grabit.HScroll1.Value - (sizex% \ 2)) \ 4) * 4
  xpos% = False
End Function

Function getypos% ()
  
  'used to use scroll-bars
  
  xpos% = True
  getypos% = grabit.VScroll1.Value - (sizey% \ 2)
  xpos% = False
End Function

Sub greyscaledo ()
  If Not greystate% And Not viewdelay% And frozen% And selectobjectmode% = 0 And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    grabit.MousePointer = 11
    setactivepage (3)
    Call greyscale
    Call copyblock(0, 0, sizex%, sizey%, 3, 4)
    scrollaround
    w1% = colourchart%(33, 1)
    w2% = colourchart%(33, 2)
    w3% = colourchart%(33, 3)
    r1% = colourchart(34, 1) - colourchart(33, 1)
    r2% = colourchart(34, 2) - colourchart(33, 2)
    r3% = colourchart(34, 3) - colourchart(33, 3)
    w12% = w1%
    w22% = w2%
    w32% = w3%
    r12% = r1%
    r22% = r2%
    r32% = r3%
    colourbaron% = True
    Call copyblock(0, 0, 640, 480, 1, 0)
    brushcolourdraw
    scrollhere
    colourinmode% = False
    pixelpatch% = 0
    drawbar
    c1% = w1% + (r1% * .5)
    c2% = w2% + (r2% * .5)
    c3% = w3% + (r3% * .5)
    penred% = c1%
    pengreen% = c2%
    penblue% = c3%
    original% = 0
    drawred% = penred%
    drawgreen% = pengreen%
    drawblue% = penblue%
    selectedred% = penred%
    selectedgreen% = pengreen%
    selectedblue% = penblue%
    greystate% = True
    grabit.MousePointer = 0
  End If
End Sub

Sub initializegrabit ()
  
  'called when form is loaded
  
  'maximize window, display it
  grabit.WindowState = 2
  grabit.Show
  grabit.Refresh

  'the GRABIT working directory
  ChDir "\windows\grabit"
  
  'standard PC-Video initialization for full-screen video
  q% = pcv_loadconfiguration()
  q% = pcv_initialize()
  If q% = 0 Then
    q% = MsgBox("The video capture adaptor was NOT found.", 48, "I have a problem !")
    End
  End If
  q% = pcv_setcolorkey(2)
  q% = pcv_createwindow(0, 0, 640, 480, 1)
  q% = pcv_setwindowsize(640, 480, 0)
  q% = pcv_setwindowposition(0, 0)
  q% = pcv_setvideosource(0)
  q% = pcv_enablevideo()
  q% = pcv_freezevideo()
  q% = pcv_clearvideorect(0, 0, 641, 480)
  q% = pcv_unfreezevideo()
  
  'ask user for which framegrabber is installed
  'the call to INITDLL needs to be told which card is installed
  card% = MsgBox("Select YES for" + Chr$(10) + Chr$(10) + "PE-Von PV100" + Chr$(10) + "Adda Aver 2000" + Chr$(10) + "Aitech Pro PC-Video" + Chr$(10) + Chr$(10) + Chr$(10) + "Select NO for" + Chr$(10) + Chr$(10) + "Creative Labs VideoBlaster", 3, "Which framegrabber do you have installed ?")
  If card% <> 6 And card% <> 7 Then
    q% = MsgBox("You cancelled - ending program.", 0, "The End")
    End
  End If
  
  grabit.MousePointer = 11

  '1st parameter inidicates number of extra pages to allocate (768K each)
  'minimum of one page must be allocated
  '2nd parameter indicates card type: 0 = PE-Von PV100, Adda Aver 2000, Aitech Pro PC-Video
  '                                   1 = Creative Labs VideoBlaster
  'note we are asking for 5 extra pages which is about 4MB so you better have
  '8MB installed or you'll wait forever ...
  Call initdll(5, card% - 6)
  Call setactivepage(0)
  
  'default object
  selected$ = "obj01"
  selectobjectmode% = False
  Open "obj01.rgb" For Input As #1
  Input #1, selectedred%
  Input #1, selectedgreen%
  Input #1, selectedblue%
  Close
  
  'load the colour chart values
  Open "colormap" For Input As #1
  For q% = 1 To 32
    Input #1, colourchart%(q%, 1)
    Input #1, colourchart%(q%, 2)
    Input #1, colourchart%(q%, 3)
    Input #1, dummy%
  Next q%
  Close
  colourchart%(33, 1) = 50
  colourchart%(33, 2) = 50
  colourchart%(33, 3) = 50
  colourchart%(34, 1) = 200
  colourchart%(34, 2) = 200
  colourchart%(34, 3) = 200

  brushsize
  original% = -1
  
  target (12)
  
  Call resetundo
  
  'load the slide-show random fading co-ordinates
  Open "fader" For Input As #123
  For q% = 1 To 4800
    Line Input #123, l$
    area%(q%, 1) = Val(l$)
    Line Input #123, l$
    area%(q%, 2) = Val(l$)
    Line Input #123, l$
  Next q%
  Close 123
  
  'load the slide-show 'macro'
  ReDim Preserve slidetext$(50, 8)
  Open "slidetxt" For Input As #123
  foundthestart% = False
  Do Until EOF(123)
    If Not foundthestart% Then Line Input #123, l$
    If l$ = "BEGIN" Then foundthestart% = True
    If foundthestart% Then
      slidestext% = slidestext% + 1
      For q% = 1 To 8
	Line Input #123, l$
	slidetext$(slidestext%, q%) = LTrim$(RTrim$(l$))
      Next q%
      If Not EOF(123) Then Line Input #123, l$
    End If
  Loop
  Close 123
  
  zoomstep% = 3
  grabit.stepsize.Value = zoomstep%

  grabit.initmess.Visible = False

  grabit.MousePointer = 0
End Sub

Sub keyboardhandler (xyz%)
  
  'the scroll-bar via the FX icon can be adjusted via the keypad as well
  
  If Not stepperbusy% Then
    stepperbusy% = True
    Select Case xyz%
    Case 96, 45   '0
      If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
	Call copyblock(0, 0, 640, 480, 2, 0)
	Call printvideo
	key0% = True
      End If
    Case -1, 97, 35  '1
      zoomstep% = 1
    Case -2, 98, 40  '2
      zoomstep% = 2
    Case -3, 99, 34  '3
      zoomstep% = 3
    Case -4, 100, 37  '4
      zoomstep% = 4
    Case -5, 101, 12  '5
      zoomstep% = 5
    Case -6, 102, 39  '6
      zoomstep% = 6
    Case -7, 103, 36  '7
      zoomstep% = 7
    Case -8, 104, 38  '8
      zoomstep% = 8
    Case -9, 105, 33  '9
      zoomstep% = 9
    End Select
    If xyz% > 0 Then
      grabit.stepsize.Value = zoomstep%
    End If
    stepperbusy% = False
  End If
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
End Sub

Sub loadpic ()
  If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    grabit.MousePointer = 11
    Call noicons
    picselect% = True
    Call setactivepage(0)
    q% = savemmp("temp.mmp", 0, 0, 640, 480)
    Call clearpage(0)
    Call blockrgb(0, 237, 628, 4, 200, 200, 200)
    Call blockrgb(312, 0, 4, 480, 200, 200, 200)
    q% = shrinkimage("store0.mmp", 0, 0, 49)
    q% = shrinkimage("store1.mmp", 316, 0, 49)
    q% = shrinkimage("store2.mmp", 0, 240, 49)
    q% = shrinkimage("store3.mmp", 316, 240, 49)
    grabit.MousePointer = 0
  End If
End Sub

Sub loadpicshow (x, y)
  logo% = -1
  Call printvideo
  If x < 316 Then
    If y < 240 Then
      q% = loadmmp("store0.mmp", 0, 0)
    Else
      q% = loadmmp("store2.mmp", 0, 0)
    End If
  Else
    If y < 240 Then
      q% = loadmmp("store1.mmp", 0, 0)
    Else
      q% = loadmmp("store3.mmp", 0, 0)
    End If
  End If
End Sub

Sub mirrordo ()
  If Not viewdelay% And frozen% And selectobjectmode% = 0 And colourinmode% = 0 And bodystatus% = 0 And picselect% = 0 Then
    grabit.MousePointer = 11
    Call setactivepage(4)
    Call mirror(0)
    Call setactivepage(3)
    Call mirror(1)
    scrollaround
    If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
    grabit.MousePointer = 0
  End If
End Sub

Sub mousecheckker (x, y, button%, updown%)
  
Static chkx1%, chkx2%, chky1%, chky2%

  If picselect% And updown% Then
    Call loadpicshow(x, y)
  ElseIf bodystatus% = 1 And Not updown% Then
    If button% = 1 Then
      bodymovex% = (x \ 4) * 4
      bodymovey% = (y \ 4) * 4
      bodystatus% = 2
      grabit.MousePointer = 0
    End If
  ElseIf bodystatus% = 2 And Not updown% Then
    If button% = 1 Then
      x1% = bodymovex%
      x2% = (x \ 4) * 4
      y1% = bodymovey%
      y2% = (y \ 4) * 4
      If x1% > x2% Then
	xtemp% = x1%
	x1% = x2%
	x2% = xtemp%
      End If
      If y1% > y2% Then
	xtemp% = y1%
	y1% = y2%
	y2% = xtemp%
      End If
      b1% = x1%
      b2% = y1%
      b3% = x2%
      b4% = y2%
      testx% = getxpos%()
      testy% = getypos%()
      If x1% < testx% Then x1% = testx%
      If y1% < testy% Then y1% = testy%
      If x2% > testx% + sizex% Then x2% = testx% + sizex%
      If y2% > testy% + sizey% Then y2% = testy% + sizey%
      If (x1% >= testx%) And (x1% <= testx% + sizex%) And (x2% >= testx%) And (x2% <= testx% + sizex%) And (y1% >= testy%) And (y1% <= testy% + sizey%) And (y2% >= testy%) And (y2% <= testy% + sizey%) Then
	If bodymovex% <> (x \ 4) * 4 And bodymovey% <> (y \ 4) * 4 Then
	  chkx1% = bodymovex%
	  chky1% = bodymovey%
	  chkx2% = x
	  chky2% = y
	  If chkx1% > chkx2% Then
	    xtemp% = chkx1%
	    chkx1% = chkx2%
	    chkx2% = xtemp%
	  End If
	  If chky1% > chky2% Then
	    xtemp% = chky1%
	    chky1% = chky2%
	    chky2% = xtemp%
	  End If
	  bodymovex% = x1%
	  bodymovey% = y1%
	  bodyx2% = x2%
	  bodyy2% = y2%
	  bodystatus% = 3
	End If
      End If
    End If
  ElseIf bodystatus% = 3 And Not updown% Then
    If y > bodymovey% And y < bodyy2% And x > bodymovex% And x < bodyx2% Then
      'do nothing
    Else
      x1% = bodymovex%
      x2% = bodyx2%
      y1% = bodymovey%
      y2% = bodyy2%
      If y <= chky1% Then
	bodydirection% = 1
	moveorgy% = getypos() + sizey%
      ElseIf y >= chky2% Then
	bodydirection% = 2
	moveorgy% = getypos()
      ElseIf x <= chkx1% Then
	bodydirection% = 3
	moveorgx% = getxpos() + sizex%
      ElseIf x >= chkx2% Then
	bodydirection% = 4
	moveorgx% = getxpos()
      End If
      If x < 30 Then x = 30
      If x > 610 Then x = 610
      If y < 30 Then y = 30
      If y > 450 Then y = 450
      grabit.bodyplus.Left = x - 32
      grabit.bodyplus.Top = y - 32
      grabit.Bodyminus.Left = x
      grabit.Bodyminus.Top = y - 32
      grabit.bodyok.Left = x - 32
      grabit.bodyok.Top = y
      grabit.bodynotok.Left = x
      grabit.bodynotok.Top = y
      grabit.bodyplus.Visible = True
      grabit.Bodyminus.Visible = True
      grabit.bodyok.Visible = True
      grabit.bodynotok.Visible = True
      bodystatus% = 4
      Call storerle
      olderx% = sizex%
      oldery% = sizey%
      oldmidx% = grabit.HScroll1.Value
      oldmidy% = grabit.VScroll1.Value
      anychange% = False
      jump% = 0
      bodyzoom% = 100
      testx% = getxpos%()
      testy% = getypos%()
      bbb1% = x1% - testx%
      bbb2% = y1% - testy%
      bbb3% = x2% - testx%
      bbb4% = y2% - testy%
      widthx% = b3% - b1%
      widthy% = b4% - b2%
      m1% = b1%
      m2% = b2%
      m3% = b3%
      m4% = b4%
    End If
  ElseIf Not updown% Then
      index% = -1
      If selectobjectmode% = 1 Then
	y = y - 1
	index% = ((x - 80) \ 132) + ((y \ 160) * 4) + 1
	If index% > 12 Then index% = 12
	If index% <> -1 Then
	  selectobjectmode% = 2
	  overlaycheck (index%)
	End If
      ElseIf colourinmode% = 1 Then
	If y > 480 - col1% Then y = 479 - col1%
	index% = ((x - 80) \ 140) + (((y - col1%) \ col2%) * 4) + 2
	If index% > 17 Then index% = 17
	If index% <> -1 Then colourmixdo (index%)
      ElseIf colourinmode% = 2 Then
	colourmixdo (x)
      ElseIf colourinmode% = 99 Then
	w02% = (((x - 80) \ 140) + (((y - col1%) \ col2%) * 4)) * 2 + 1
	If colourchart(w02%, 1) < colourchart(w02% + 1, 1) Then
	  w12% = colourchart(w02%, 1)
	Else
	  w12% = colourchart(w02% + 1, 1)
	End If
	If colourchart(w02%, 2) < colourchart(w02% + 1, 2) Then
	  w22% = colourchart(w02%, 2)
	Else
	  w22% = colourchart(w02% + 1, 2)
	End If
	If colourchart(w02%, 3) < colourchart(w02% + 1, 3) Then
	  w32% = colourchart(w02%, 3)
	Else
	  w32% = colourchart(w02% + 1, 3)
	End If
	r12% = Abs(colourchart(w02%, 1) - colourchart(w02% + 1, 1))
	r22% = Abs(colourchart(w02%, 2) - colourchart(w02% + 1, 2))
	r32% = Abs(colourchart(w02%, 3) - colourchart(w02% + 1, 3))
	Call copyblock(0, 0, 640, 480, 2, 1)
	q% = maskimage(selected$, getxpos%(), getypos%(), 0, 3, 1)
	colourbaron% = True
	Call copyblock(0, 0, 640, 480, 1, 0)
	brushcolourdraw
	scrollhere
	colourinmode% = False
	grabit.MousePointer = 0
	pixelpatch% = 0
	drawbar
	Call resetundo
	If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
      Else
	linex% = 0
	liney% = 0
	Call mousepaint(x, y, button)
      End If
  End If
End Sub

Sub mousecheckker2 (x, y, button%)
  If printstate% Then
    Call setxycursor(640, 480)
    If button% <> 0 Then
      Call printvideorestore
    End If
  End If
End Sub

Sub mousepaint (x, y, button%)
  
Static patch%
If patch% = 0 Then
  If Not frozen% Then
    Call target(12)
  Else
    Call target(0)
  End If
  patch% = 1
End If

If bodystatus% = 2 Then
  grabit.Line -(bodymovex%, bodymovey%), RGB(0, 128, 0), B
  grabit.Line (bodymovex%, bodymovey%)-((x \ 4) * 4, (y \ 4) * 4), RGB(255, 0, 0), B
End If

If Not viewdelay% And frozen% And selectobjectmode% = 0 And colourinmode% = 0 And bodystatus% = 0 And picselect% = 0 Then
  Select Case brush%
  Case 0
    adjust% = 2
    brushcheck% = -1
  Case 1
    adjust% = 3
    brushcheck% = -2
  Case 2
    adjust% = 4
    brushcheck% = -4
  End Select
  testx% = getxpos%()
  testy% = getypos%()
  If pixelpatch% And y < 481 + brushcheck% And y > 7 + brushcheck% Then
    If x - 6 > testx% Then
      If y - 6 > testy% Then
	If x + 6 < testx% + sizex% Then
	  If y + 6 < testy% + sizey% Then
	    If button% = 1 Then
	      If linex% <> 0 And liney% <> 0 Then
		x1% = linex%
		x2% = x - adjust%
		y1% = liney%
		y2% = y - adjust%
		If x1% <> x2% Or y1% <> y2% Then
		  If y1% <> y2% And (Abs(y1% - y2%) >= Abs(x1% - x2%)) Then
		    hill@ = Abs((x1% - x2%) / (y2% - y1%))
		    stepper% = adjust% - 1
		    If y1% > y2% Then stepper% = -stepper%
		    For yer% = y1% To y2% Step stepper%
		      If x2% < x1% Then
			xer% = Int(x1% - (Abs(yer% - y1%) * hill@))
		      Else
			xer% = Int((Abs(yer% - y1%) * hill@) + x1%)
		      End If
		      Call setactivepage(0)
		      Call drawcircle(xer%, yer%)
		      Call setcolourtable(0)
		      Call setactivepage(4)
		      Call rlechange(1)
		      Call drawcircle(xer% - testx%, yer% - testy%)
		      Call rlechange(0)
		      Call setcolourtable(1)
		      Call setactivepage(3)
		      Call drawcircle(xer% - testx%, yer% - testy%)
		    Next yer%
		  ElseIf x1% <> x2% And (Abs(y1% - y2%) <= Abs(x1% - x2%)) Then
		    hill@ = Abs((y1% - y2%) / (x2% - x1%))
		    stepper% = adjust% - 1
		    If x1% > x2% Then stepper% = -stepper%
		    For xer% = x1% To x2% Step stepper%
		      If y2% < y1% Then
			yer% = Int(y1% - (Abs(xer% - x1%) * hill@))
		      Else
			yer% = Int((Abs(xer% - x1%) * hill@) + y1%)
		      End If
		      Call setactivepage(0)
		      Call drawcircle(xer%, yer%)
		      Call setcolourtable(0)
		      Call setactivepage(4)
		      Call rlechange(1)
		      Call drawcircle(xer% - testx%, yer% - testy%)
		      Call rlechange(0)
		      Call setcolourtable(1)
		      Call setactivepage(3)
		      Call drawcircle(xer% - testx%, yer% - testy%)
		    Next xer%
		  End If
		End If
	      Else
		Call setactivepage(0)
		Call drawcircle(x - adjust%, y - adjust%)
		Call setcolourtable(0)
		Call setactivepage(4)
		Call rlechange(1)
		Call drawcircle(x - adjust% - testx%, y - adjust% - testy%)
		Call rlechange(0)
		Call setcolourtable(1)
		Call setactivepage(3)
		Call drawcircle(x - adjust% - testx%, y - adjust% - testy%)
		Call toggleiconsalloff
	      End If
	      linex% = x - adjust%
	      liney% = y - adjust%
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	    ElseIf button = 2 Then
	      If linex% <> 0 And liney% <> 0 Then
		x1% = linex%
		x2% = x - adjust%
		y1% = liney%
		y2% = y - adjust%
		If x1% <> x2% Or y1% <> y2% Then
		  If y1% <> y2% And (Abs(y1% - y2%) >= Abs(x1% - x2%)) Then
		    hill@ = Abs((x1% - x2%) / (y2% - y1%))
		    stepper% = adjust% - 1
		    If y1% > y2% Then stepper% = -stepper%
		    For yer% = y1% To y2% Step stepper%
		      If x2% < x1% Then
			xer% = Int(x1% - (Abs(yer% - y1%) * hill@))
		      Else
			xer% = Int((Abs(yer% - y1%) * hill@) + x1%)
		      End If
		      Call setactivepage(4)
		      Call rlechange(1)
		      Call clearcircle(xer% - testx%, yer% - testy%)
		      Call rlechange(0)
		      Call setactivepage(3)
		      Call clearcircle(xer% - testx%, yer% - testy%)
		      Call copycircle(xer%, yer%, 2, 0)
		    Next yer%
		  ElseIf x1% <> x2% And (Abs(y1% - y2%) <= Abs(x1% - x2%)) Then
		    hill@ = Abs((y1% - y2%) / (x2% - x1%))
		    stepper% = adjust% - 1
		    If x1% > x2% Then stepper% = -stepper%
		    For xer% = x1% To x2% Step stepper%
		      If y2% < y1% Then
			yer% = Int(y1% - (Abs(xer% - x1%) * hill@))
		      Else
			yer% = Int((Abs(xer% - x1%) * hill@) + y1%)
		      End If
		      Call setactivepage(4)
		      Call rlechange(1)
		      Call clearcircle(xer% - testx%, yer% - testy%)
		      Call rlechange(0)
		      Call setactivepage(3)
		      Call clearcircle(xer% - testx%, yer% - testy%)
		      Call copycircle(xer%, yer%, 2, 0)
		    Next xer%
		  End If
		End If
	      Else
		Call setactivepage(4)
		Call rlechange(1)
		Call clearcircle(x - adjust% - testx%, y - adjust% - testy%)
		Call rlechange(0)
		Call setactivepage(3)
		Call clearcircle(x - adjust% - testx%, y - adjust% - testy%)
		Call copycircle(x - adjust%, y - adjust%, 2, 0)
		Call toggleiconsalloff
	      End If
	      linex% = x - adjust%
	      liney% = y - adjust%
	    End If
	  Else
	    linex% = 0
	    liney% = 0
	  End If
	Else
	  linex% = 0
	  liney% = 0
	End If
      Else
	linex% = 0
	liney% = 0
      End If
    Else
      linex% = 0
      liney% = 0
    End If
  End If
  pixelpatch% = -1
End If
End Sub

Sub movieact (x, y)
  If zoomstep% < 4 Then
    stepper% = 4
  ElseIf zoomstep% < 7 Then
    stepper% = 8
  Else
    stepper% = 12
  End If
  If Not viewdelay% And frozen% And selectobjectmode% = 0 And colourinmode% = 0 And bodystatus% = 0 And picselect% = 0 Then
    Call toggleiconsalloff
    Do
      If x < 40 And 40 - y > x Then
	Exit Sub
      ElseIf x > 40 And y < x - 40 Then
	Exit Sub
      ElseIf x < 40 And y - 40 > x Then
	Exit Sub
      ElseIf x > 40 And x - 40 > 80 - y Then
	Exit Sub
      End If
      If x > y Then
	If x > 80 - y Then
	  grabit.HScroll1.Value = grabit.HScroll1.Value + stepper%
	Else
	  If grabit.VScroll1.Value - stepper% >= grabit.VScroll1.Min Then
	    grabit.VScroll1.Value = grabit.VScroll1.Value - stepper%
	  End If
	End If
      Else
	If x > 80 - y Then
	  If grabit.VScroll1.Value + stepper% <= grabit.VScroll1.Max Then
	    grabit.VScroll1.Value = grabit.VScroll1.Value + stepper%
	  End If
	Else
	  grabit.HScroll1.Value = grabit.HScroll1.Value - stepper%
	End If
      End If
    Loop Until getinputstate() <> 0
  End If
End Sub

Sub noicons ()
  Call toggleiconsalloff
  grabit.Command1.Visible = False
  grabit.Command2.Visible = False
  grabit.Command3.Visible = False
  grabit.Commandzoom.Visible = False
  grabit.choicesbutton.Visible = False
  grabit.Undobutton.Visible = False
  grabit.Picture1.Visible = False
  grabit.Picture2.Visible = False
  grabit.Picture3.Visible = False
  grabit.Picture4.Visible = False
  grabit.Picture5.Visible = False
  grabit.Picture6.Visible = False
  grabit.Picture7.Visible = False
  grabit.Picture8.Visible = False
  grabit.movie.Visible = False
  grabit.grabitQUIT.Visible = False
  grabit.registerBMP.Visible = False
  grabit.Refresh
End Sub

Sub noiconsreturn ()
  grabit.Command1.Visible = True
  grabit.Command2.Visible = True
  grabit.Command3.Visible = True
  grabit.Commandzoom.Visible = True
  grabit.choicesbutton.Visible = True
  grabit.Undobutton.Visible = True
  grabit.Picture1.Visible = True
  grabit.Picture2.Visible = True
  grabit.Picture3.Visible = True
  grabit.Picture4.Visible = True
  grabit.Picture5.Visible = True
  grabit.Picture6.Visible = True
  grabit.Picture7.Visible = True
  grabit.movie.Visible = True
  grabit.grabitQUIT.Visible = True
  grabit.registerBMP.Visible = True
  grabit.Refresh
End Sub

Sub overlay ()
  If Not viewdelay% And colourinmode% = False And selectobjectmode% = False And picselect% = 0 And bodystatus% = 0 Then
    If Not frozen% Then freezetoggle
    grabit.MousePointer = 11
    scrollgone (2)
    q% = pcv_clearvideorect(0, 0, 641, 480)
    selectobjectmode% = 1
    For x% = 1 To 12
      objects$(x%) = "obj" + Right$("0" + LTrim$(Str$(x%)), 2) + "-2.mmp"
    Next x%
    y% = 1
    Call setactivepage(1)
    Call clearpage(1)
    For dumm% = 0 To 2
      For x% = 80 To 476 Step 132
	Open Left$(objects$(y%), 5) + ".rgb" For Input As #1
	Line Input #1, tr$
	Line Input #1, tg$
	Line Input #1, tb$
	Close 1
	newr% = 100 + (penred% - Val(tr$)) / Val(tr$) * 100
	newg% = 100 + (pengreen% - Val(tg$)) / Val(tg$) * 100
	newb% = 100 + (penblue% - Val(tb$)) / Val(tb$) * 100
	If greystate% Then
	  q% = greymiximage(Left$(objects$(y%), InStr(objects$(y%), ".") - 1), x%, dumm% * 160, 1, 1, Val(tr$), Val(tg$), Val(tb$), newr%, newg%, newb%)
	Else
	  q% = colmiximage(Left$(objects$(y%), InStr(objects$(y%), ".") - 1), x%, dumm% * 160, 1, 1, Val(tr$), Val(tg$), Val(tb$), newr%, newg%, newb%)
	End If
	y% = y% + 1
      Next x%
    Next dumm%
    Call copyblock(0, 0, 640, 480, 1, 0)
    grabit.MousePointer = 0
  End If
End Sub

Sub overlaycheck (object%)
  If selectobjectmode% = 2 Then
    grabit.MousePointer = 11
    If penred% = selectedred% And pengreen% = selectedgreen% And penblue% = selectedblue% Then
      penred% = 0
      pengreen% = 0
      penblue% = 0
    End If
    selected$ = Left$(objects$(object%), 5)
    If Not greystate% Then
      Open selected$ + ".rgb" For Input As #1
      Input #1, selectedred%
      Input #1, selectedgreen%
      Input #1, selectedblue%
      Input #1, tempwidth$
      Input #1, temphight$
      Close
    End If
    If penred% = 0 And pengreen% = 0 And penblue% = 0 Then
      penred% = selectedred%
      pengreen% = selectedgreen%
      penblue% = selectedblue%
    End If

    Open selected$ + ".mmp" For Binary As #1
    dum$ = "  "
    Get #1, 13, dum$
    sizex% = (Asc(Right$(dum$, 1)) * 256 + Asc(Left$(dum$, 1)))
    Get #1, 15, dum$
    sizey% = (Asc(Right$(dum$, 1)) * 256 + Asc(Left$(dum$, 1)))
    Close

    grabit.Picture1.FillColor = RGB(penred%, pengreen%, penblue%)
    brushcolourdraw
    coltest% = picloaded%
    picloaded% = True
    
    change% = 100
    If coltest% = 0 Then
      grabit.HScroll1.Value = 319
      grabit.VScroll1.Value = 239
    End If
    z1% = 12345
    If zoomx% = 0 Then
      Call zoom(change%, -1, 0)
    Else
      Call zoom(-4, -1, 0)
    End If
    selectobjectmode% = False
    grabit.MousePointer = 0
    If coltest% = 0 Then
      Call colourmix(1)
      coltest% = 1
    Else
      scrollhere
    End If
    oldx% = getxpos%()
    oldy% = getypos%()
    pixelpatch% = 0
    Call initvariance(15)
    drawbar
    Call resetundo
  End If
End Sub

Sub printvideo ()
  If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And bodystatus% = 0 Then
    Call setxycursor(640, 480)
    Call noicons
    printstate% = True
  End If
End Sub

Sub printvideorestore ()
  Call noiconsreturn
  If logo% Then
    q% = loadmmp("temp.mmp", 0, 0)
  End If
  If key0% Then
    Call zoom(-4, 0, 0)
    key0% = False
  End If
  Call enablemouse
  If picselect% Then
    Call setxycursor(101, 352)
  ElseIf logo% = -1 Then
    Call setxycursor(101, 56)
  Else
    Call setxycursor(150, 316)
  End If
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
  logo% = 0
  picselect% = 0
  printstate% = 0
End Sub

Function round% (q!)
  If q! - Int(q!) >= .5 Then
    round% = Int(q!) + 1
  Else
    round% = Int(q!)
  End If
End Function

Sub scrollaround ()
  If Not viewdelay% And frozen% And Not colourinmode% And selectobjectmode% = 0 And Not xpos% And picloaded% And picselect% = 0 And bodystatus% = 0 Then
    x% = getxpos%()
    y% = getypos%()
    If oldx% = 0 And oldy% = 0 Then
      Call copyblock(0, 0, 640, 480, 2, 1)
    Else
      If x% <> oldx% Then
	If x% > oldx% Then
	  Call copyblock(oldx%, y%, sizex% + x% - oldx%, sizey%, 2, 1)
	Else
	  Call copyblock(x%, y%, sizex% + oldx% - x%, sizey%, 2, 1)
	End If
      Else
	If y% > oldy% Then
	  Call copyblock(x%, oldy%, sizex%, sizey% + y% - oldy%, 2, 1)
	Else
	  Call copyblock(x%, y%, sizex%, sizey% + oldy% - y%, 2, 1)
	End If
      End If
    End If
    q% = maskimage(selected$, x%, y%, 0, 3, 1)
    
    If oldx% = 0 And oldy% = 0 Then
      Call copyblock(0, 0, 640, 480, 1, 0)
    Else
      If x% <> oldx% Then
	If x% > oldx% Then
	  Call copyblock(oldx%, y%, sizex% + x% - oldx%, sizey%, 1, 0)
	Else
	  Call copyblock(x%, y%, sizex% + oldx% - x%, sizey%, 1, 0)
	End If
      Else
	If y% > oldy% Then
	  Call copyblock(x%, oldy%, sizex%, sizey% + y% - oldy%, 1, 0)
	Else
	  Call copyblock(x%, y%, sizex%, sizey% + oldy% - y%, 1, 0)
	End If
      End If
    End If
    oldx% = x%
    oldy% = y%
    Call resetundo
    If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
  End If
End Sub

Sub scrollgone (yeah%)
  grabit.movie.Visible = False
  grabit.Picture1.Visible = False
  If yeah% = 2 Then grabit.registerBMP.Visible = False
End Sub

Sub scrollhere ()
  grabit.movie.Visible = True
  grabit.Picture1.Visible = True
  grabit.registerBMP.Visible = True
End Sub

Sub setupcolourbarindicators (ppp1%, ppp2%)
  If (((ppp1% - 124) / 480) * 100) + 74 < 80 Then
    grabit.colpos1.Left = 80
  ElseIf (((ppp1% - 124) / 480) * 100) + 74 > 167 Then
    grabit.colpos1.Left = 167
  Else
    grabit.colpos1.Left = (((ppp1% - 124) / 480) * 100) + 74
  End If
  If (((ppp2% - 124) / 480) * 100) + 74 < 80 Then
    grabit.colpos2.Left = 80
  ElseIf (((ppp2% - 124) / 480) * 100) + 74 > 167 Then
    grabit.colpos2.Left = 167
  Else
    grabit.colpos2.Left = (((ppp2% - 124) / 480) * 100) + 74
  End If
End Sub

Sub showlogo (from%)
  If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    Call setactivepage(0)
    logo% = -from%
    q% = savemmp("temp.mmp", 0, 0, 640, 480)
    Call printvideo
    q% = loadmmp("logo.mmp", 0, 0)
  End If
End Sub

Sub sinkin ()
  If Not viewdelay% And frozen% And selectobjectmode% = 0 And colourinmode% = 0 And bodystatus% = 0 And picselect% = 0 Then
    q% = maskimage(selected$, getxpos%(), getypos%(), 0, 3, 2)
  End If
End Sub

Sub slideshow ()
  q% = MsgBox("Start the Slide Show Demonstation ?", 1, "Slideshow Demonstation")
  If q% = 1 Then
    Call noicons
    Call setactivepage(0)
    freeze
    Call clearpage(0)
    target (0)
    Call resetundo
    grabit.Slideshowexit.Visible = True
    grabit.democaption.Visible = True
    grabit.slideshowtimer.Enabled = True
    Call setxycursor(613, 460)
    Call slideshowshow
  End If
End Sub

Sub slideshowend ()
    grabit.democaption.Visible = False
    grabit.Slideshowexit.Visible = False
    grabit.slideshowtimer.Enabled = False
    Call clearpage(0)
    unfreeze
    colourinmode% = False
    selectobjectmode% = False
    picselect% = False
    target (12)
    Call noiconsreturn
    delayslide% = 0
    slide% = 0
End Sub

Sub slideshowshow ()
Static forward%
  If delayslide% >= (Val(slidetext$(currentslide%, 2)) * 4) Or delayslide% = 0 Then
    currentslide% = currentslide% + 1
    If currentslide% > slidestext% Then currentslide% = 1
    grabit.democaption.Visible = False
    grabit.democaption.FontSize = slidetext$(currentslide%, 4)
    grabit.democaption.Caption = slidetext$(currentslide%, 3)
    grabit.democaption.ForeColor = RGB(Val(slidetext$(currentslide%, 5)), Val(slidetext$(currentslide%, 6)), Val(slidetext$(currentslide%, 7)))
    grabit.democaption.Visible = True
    Call setactivepage(1)
    If slidetext$(currentslide%, 1) <> "NONE" And Dir$(slidetext$(currentslide%, 1) + ".mmp") <> "" Then
      q% = loadmmp(slidetext$(currentslide%, 1) + ".mmp", 0, 0)
      If forward% Then
	For xyz% = 1 To 4800
	  Call copyblock(area%(xyz%, 1), area%(xyz%, 2), 8, 8, 1, 0)
	Next xyz%
      Else
	For xyz% = 4800 To 1 Step -1
	  Call copyblock(area%(xyz%, 1), area%(xyz%, 2), 8, 8, 1, 0)
	Next xyz%
      End If
      forward% = forward% Xor 1
    Else
      Call clearpage(1)
      For xyz% = 1 To 4800
	Call copyblock(area%(xyz%, 1), area%(xyz%, 2), 8, 8, 1, 0)
      Next xyz%
    End If
    delayslide% = 1
  End If
  If slidetext$(currentslide%, 8) = "Y" And (delayslide% Mod 4 = 0) Then
    grabit.democaption.ForeColor = RGB(0, 128, 0)
  Else
    grabit.democaption.ForeColor = RGB(Val(slidetext$(currentslide%, 5)), Val(slidetext$(currentslide%, 6)), Val(slidetext$(currentslide%, 7)))
  End If
  delayslide% = delayslide% + 1
End Sub

Sub storepic ()
  If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    grabit.MousePointer = 11
    Call setactivepage(0)
    q% = savemmp("store" + LTrim$(RTrim$(Str$(lastpicsaved%))) + ".mmp", 0, 0, 640, 480)
    lastpicsaved% = lastpicsaved% + 1
    If lastpicsaved% = 4 Then lastpicsaved% = 0
    grabit.MousePointer = 0
    If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
  End If
End Sub

Sub target (col%)
 If col% = 12 Then
    grabit.Line (240, 2)-(240, 478), RGB(255, 0, 0)
    grabit.Line (410, 2)-(410, 478), RGB(255, 0, 0)
    grabit.Line (2, 260)-(638, 260), RGB(255, 0, 0)
  Else
    grabit.Line (240, 2)-(240, 478), RGB(0, 128, 0)
    grabit.Line (410, 2)-(410, 478), RGB(0, 128, 0)
    grabit.Line (2, 260)-(638, 260), RGB(0, 128, 0)
  End If
End Sub

Sub toggleicon1 ()
  If onoff% = False Then
    onoff% = True
  Else
    onoff% = False
  End If
  grabit.freeze.Visible = onoff%
  grabit.Picture8.Visible = onoff%
  grabit.Before.Visible = onoff%
  grabit.Picture9.Visible = onoff%
  grabit.Front.Visible = onoff%
  grabit.Picture10.Visible = onoff%
  grabit.Profile.Visible = onoff%
  grabit.Picture11.Visible = onoff%
End Sub

Sub toggleicon3 ()
  If onoff3% = False Then
    onoff3% = True
  Else
    onoff3% = False
  End If
  grabit.colourhair.Visible = onoff3%
  grabit.Picture12.Visible = onoff3%
  grabit.colourbrush.Visible = onoff3%
  grabit.Picture13.Visible = onoff3%
  grabit.greyscale.Visible = onoff3%
  grabit.Picture14.Visible = onoff3%

  If onoff3% And colourbaron% Then
    ttt1% = grabit.HScroll5.Value
    ttt2% = grabit.HScroll6.Value
    Call setupcolourbarindicators(ttt1%, ttt2%)
    grabit.chart.Visible = True
    grabit.colpos1.Visible = True
    grabit.colpos2.Visible = True
    Call colourbarnew(0)
  End If

  If Not onoff3% And colourbaron% Then
    grabit.chart.Visible = False
    grabit.colpos1.Visible = False
    grabit.colpos2.Visible = False
    Call copyblock(76, 225, 96, 70, 2, 1)
    q% = maskimage(selected$, getxpos%(), getypos%(), 0, 3, 1)
    Call copyblock(76, 225, 96, 70, 1, 0)
  End If
End Sub

Sub toggleicon4 ()
  If onoff4% = False Then
    onoff4% = True
  Else
    onoff4% = False
  End If
  grabit.Picturezoom.Visible = onoff4%
  grabit.picturezoombutton.Visible = onoff4%
  grabit.bodybutton.Visible = onoff4%
  grabit.Picture15.Visible = onoff4%
  grabit.mirrorbutton.Visible = onoff4%
  grabit.Picture16.Visible = onoff4%
  grabit.stepsize.Visible = onoff4%
  grabit.combine.Visible = onoff4%
  grabit.Picture21.Visible = onoff4%
End Sub

Sub toggleicon5 ()
  If onoff5% = False Then
    onoff5% = True
  Else
    onoff5% = False
  End If
  grabit.storebutton.Visible = onoff5%
  grabit.Picture17.Visible = onoff5%
  grabit.loadbutton.Visible = onoff5%
  grabit.Picture18.Visible = onoff5%
  grabit.Printcommand.Visible = onoff5%
  grabit.Picture19.Visible = onoff5%
  grabit.spare.Visible = onoff5%
  grabit.Picture20.Visible = onoff5%
End Sub

Sub toggleicons (index%)
  'off
  If onoff% = True Then
    If index% = 1 Then
      Call toggleicon1
      Exit Sub
    Else
      Call toggleicon1
    End If
  End If
  If onoff3% = True Then
    If index% = 3 Then
      Call toggleicon3
      Exit Sub
    Else
      Call toggleicon3
    End If
  End If
  If onoff4% = True Then
    If index% = 4 Then
      Call toggleicon4
      Exit Sub
    Else
      Call toggleicon4
    End If
  End If
  If onoff5% = True Then
    If index% = 5 Then
      Call toggleicon5
      Exit Sub
    Else
      Call toggleicon5
    End If
  End If
  'on
  If index% = 1 And onoff% = False Then
    Call toggleicon1
  End If
  If index% = 3 And onoff3% = False Then
    Call toggleicon3
  End If
  If index% = 4 And onoff4% = False Then
    Call toggleicon4
  End If
  If index% = 5 And onoff5% = False Then
    Call toggleicon5
  End If
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
End Sub

Sub toggleiconsalloff ()
  If onoff% Then toggleicon1
  If onoff3% Then toggleicon3
  If onoff4% Then toggleicon4
  If onoff5% Then toggleicon5
End Sub

Sub undo ()
  If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    grabit.undotimer.Enabled = True
    Call undocircle
    Call undocircle
    Call undocircle
    Call undocircle
    Call undocircle
    Call undocircle
  End If
End Sub

Sub undoall ()
  If Not viewdelay% And frozen% And selectobjectmode% = False And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    Call toggleiconsalloff
    grabit.MousePointer = 11
    Call zoom(-4, 0, 0)
    grabit.MousePointer = 0
  End If
End Sub

Sub undoend ()
  grabit.undotimer.Enabled = False
End Sub

Sub unfreeze ()
  q% = pcv_unfreezevideo()
  frozen% = 0
  picloaded% = 0
  greystate% = False
End Sub

Sub viewend ()
  q% = pcv_unfreezevideo()
  viewdelay% = False
  grabit.freezetimer.Enabled = False
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
  grabit.MousePointer = 0
End Sub

Sub views (side%)
  If selectobjectmode% = 0 And colourinmode% = 0 And bodystatus% = 0 And picselect% = 0 Then
    grabit.MousePointer = 11
    Call setactivepage(0)
    If Not frozen% Then   'store
      grabit.freezetimer.Enabled = True
      q% = pcv_freezevideo()
      viewdelay% = True
      If side% = 0 Then
	q% = savemmp("before.mmp", 0, 0, 640, 480)
      ElseIf side% = 1 Then
	q% = savemmp("front.mmp", 0, 0, 640, 480)
      ElseIf side% = 2 Then
	q% = savemmp("profile.mmp", 0, 0, 640, 480)
      End If
    Else                    'load
      If side% = 0 Then
	q% = loadmmp("before.mmp", 0, 0)
      ElseIf side% = 1 Then
	q% = loadmmp("front.mmp", 0, 0)
      Else
	q% = loadmmp("profile.mmp", 0, 0)
      End If
      Call copyblock(0, 0, 640, 480, 0, 2)
      scrollaround
      If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
      grabit.MousePointer = 0
    End If
  End If
End Sub

Sub zoom (updown%, special%, both%)
  If Not viewdelay% And frozen% And (selectobjectmode% = False Or special%) And picloaded% And colourinmode% = False And picselect% = 0 And bodystatus% = 0 Then
    If updown% < 0 Then
      If updown% = -1 Then
	If both% = 0 Then
	  zoomx% = 100
	  zoomy% = 100
	ElseIf both% = 1 Then
	  zoomx% = 100
	ElseIf both% = 2 Then
	  zoomy% = 100
	End If
      ElseIf updown% = -2 Then
	If both% = 0 Then
	  zoomx% = zoomx% - zoomstep%
	  zoomy% = zoomy% - zoomstep%
	ElseIf both% = 1 Then
	  zoomx% = zoomx% - zoomstep%
	ElseIf both% = 2 Then
	  zoomy% = zoomy% - zoomstep%
	End If
      ElseIf updown% = -3 Then
	If both% = 0 Then
	  zoomx% = zoomx% + zoomstep%
	  zoomy% = zoomy% + zoomstep%
	ElseIf both% = 1 Then
	  zoomx% = zoomx% + zoomstep%
	ElseIf both% = 2 Then
	  zoomy% = zoomy% + zoomstep%
	End If
      End If
    Else
      zoomx% = updown%
      zoomy% = updown%
    End If
    
    If zoomx% < 65 Then zoomx% = 65
    If zoomx% > 135 Then zoomx% = 135
    If zoomy% < 65 Then zoomy% = 65
    If zoomy% > 135 Then zoomy% = 135

    q% = maskimage(selected$, x%, y%, 1, 3, 3)
    Open selected$ + ".mmp" For Binary As #1
    dum$ = "  "
    Get #1, 13, dum$
    sizex% = (Asc(Right$(dum$, 1)) * 256 + Asc(Left$(dum$, 1)))
    Get #1, 15, dum$
    sizey% = (Asc(Right$(dum$, 1)) * 256 + Asc(Left$(dum$, 1)))
    Close
    setactivepage (3)
    
    If zoomx% <> 100 Then sizex% = xzoomimage(zoomx%)
    If zoomy% <> 100 Then sizey% = yzoomimage(zoomy%)
    
    Call copyblock(0, 0, 640, 480, 2, 1)
    Call copyblock(0, 0, sizex%, sizey%, 3, 4)
    If coltest% <> 0 Then
      newr% = 100 + (penred% - selectedred%) / selectedred% * 100
      newg% = 100 + (pengreen% - selectedgreen%) / selectedgreen% * 100
      newb% = 100 + (penblue% - selectedblue%) / selectedblue% * 100
      If greystate% Then
	If z1% <> 12345 Then
	  Call colourchange(z1%, z2%, z3%, z4%, z5%, z6%)
	End If
	Call greyscale
	Call copyblock(0, 0, sizex%, sizey%, 3, 4)
      ElseIf newr% <> 100 Or newg% <> 100 Or newb% <> 100 Then
	Call colourchange(selectedred%, selectedgreen%, selectedblue%, newr%, newg%, newb%)
      End If
      q% = maskimage(selected$, getxpos%(), getypos%(), 0, 3, 1)
      Call copyblock(0, 0, 640, 480, 1, 0)
    End If
    oldx% = 0
    oldy% = 0
    Call resetundo
    drawbar
  End If
  If grabit.registerBMP.Visible Then grabit.registerBMP.SetFocus
End Sub

Sub zoomit (x, y)
  If Not viewdelay% And frozen% And selectobjectmode% = 0 And picloaded% And colourinmode% = 0 And picselect% = 0 And bodystatus% = 0 Then
    grabit.MousePointer = 11
    If x < 31 Then
      If y < 31 Then
	If x > y Then
	  Call zoom(-3, 0, 2)  'y +
	Else
	  Call zoom(-2, 0, 1)  'x -
	End If
      Else
	If x > 62 - y Then
	  Call zoom(-2, 0, 2)  'y -
	Else
	  Call zoom(-2, 0, 1)  'x -
	End If
      End If
    Else
      If y < 31 Then
	If x > 62 - y Then
	  Call zoom(-3, 0, 1)  'x +
	Else
	  Call zoom(-3, 0, 2)  'y +
	End If
      Else
	If x - 31 < y - 31 Then
	  Call zoom(-2, 0, 2)  'y -
	Else
	  Call zoom(-3, 0, 1)  'x +
	End If
      End If
    End If
    grabit.MousePointer = 0
  End If
End Sub

