/*
 * RWindows 0.5a Beta release 2    Windows startup screen randomizer
 * Copyright (C) 1994 Michael Lea
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the Licence, or any later
 * version.
 */

#include <stdio.h>
#include <strings.h>
#include <time.h>
#include <stdlib.h>
#include "strext.h"

// #define DEBUG

#define ZIPFILE "system\\startup.zip"           // default zip file
#define MAXSIZE 50416                           // maximum RLE size

#define Z_NOFILES -12                           // offsets from end of zip-file
#define Z_OFFSET -6

#define Z_FLEN 24                               // offsets from beginning of zip-file
#define Z_NLEN 28
#define Z_NAME 18

char *convpath(char *s);                        // convert a unix-style path to a dos-style path
char *stripname(char *s);                       // strip the filename from a full pathname

unsigned short gotopos(FILE *zip);              // sets the file pointer to the start of file record
						// returns no. of files in the zip file

unsigned long getfile(FILE *zip, int num, char *file);
						// gets the numth file name from the zip file

int unzip(char *zip, char *file, char *path);   // unzip file from zip

int cp(char *path, char *file);                 // copy files into WIN.COM

int rm(char *path, char *file);                 // remove file

main(int argc, char *argv[])
{
	printf("RWindows 0.5a, Copyright (C) 1994 Michael Lea\n");
	printf("RWindows comes with ABSOLUTELY NO WARRANTY; This is free software,\n");
	printf("and you are welcome to redistribute it under certain conditions;\n");
	printf("see the file \"README.TXT\" for details.\n\n");

	char progpath[strlen(argv[0]) + 1];

// DETERMINE WHAT DIRECTORY THE PROGRAM IS BEING RUN FROM (the Windows path)

	strcpy(progpath, argv[0]);
	convpath(progpath);
	stripname(progpath);

// CONSTRUCT THE FULL PATH TO THE ZIP FILE (the System directory)

	char filepath[255];
	strcpy(filepath, progpath);
	if (argc > 1)
		strcat(filepath, "system\\", argv[1]);
	else
		strcat(filepath, ZIPFILE);

// OPEN THE ZIP-FILE FOR READING

	FILE *zfp;
	zfp = fopen(filepath, "rb");
	if (zfp == NULL)
		abort();

// READ NUMBER OF FILES IN ZIP FILE & PICK VALID NUMBER (0 to nofiles-1)

	unsigned short nofiles = gotopos(zfp);
	srand(time(NULL));
	int rnum = rand() % nofiles;

#ifdef DEBUG
	printf("current time: %d\n", time(NULL));
	printf("%d files, using file no. %d\n", nofiles, rnum);
#endif

// GET THE FILE NAME TO USE, AND CHECK IS SIZE TO SEE IF IT'S VALID

	char fname[255];
	unsigned long fsize = getfile(zfp, rnum, fname);
	if (fsize > MAXSIZE)
	{
		printf("ERROR: Selected file was too big.\n");
		exit(1);
	}

// UNZIP THE FILE

#ifdef DEBUG
	printf("selected file: %s\nfile size: %d", fname, fsize);
#else
	unzip(filepath, fname, progpath);

// CREATE THE NEW "WIN.COM", REMOVE THE .RLE FILE, AND RUN WINDOWS

	cp(progpath, fname);
	rm(progpath, fname);
	system("win.com");
#endif
}

char *convpath(char *s)
{
	int i;

// REPLACE ALL "/"s WITH "\"s (for DOS-based directory structure)

	for (i = 0; i < strlen(s); i++)
		if (s[i] == '/') s[i] = '\\';
	return s;
}

char *stripname(char *s)
{
	int i;

// REMOVE EVERYTHING AFTER THE LAST "\"

	for (i = strlen(s) - 1; i >= 0; i--)
		if (s[i] == '\\')
		{
			s[i + 1] = '\0';
			return s;
		}
	return s;
}

unsigned short gotopos(FILE *zip)
{
	unsigned short files;
	unsigned long offset;

// GET NUMBER OF FILES IN ZIP-FILE
	
	fseek(zip, Z_NOFILES, SEEK_END);
	fread(&files, sizeof(unsigned short), 1, zip);

// GET OFFSET FROM BEGINNING OF FILE TO FIND START OF FILE INFORMATION AT

	fseek(zip, Z_OFFSET, SEEK_END);
	fread(&offset, sizeof(unsigned long), 1, zip);

// MOVE FILE POINTER TO BEGINNING OF FILE INFORMATION & RETURN NUMBER OF FILES

	fseek(zip, offset, SEEK_SET);
	return files;
}

unsigned long getfile(FILE *zip, int num, char *file)
{
	unsigned int namelen;
	unsigned long filesize;

// SKIP OVER num FILES

	for(; num > 0; num--)
	{
		fseek(zip, Z_NLEN, SEEK_CUR);
		fread(&namelen, sizeof(unsigned int), 1, zip);
		fseek(zip, (Z_NAME - sizeof(unsigned int) + namelen), SEEK_CUR);
	}

// GET SIZE OF FILE, AND LENGTH OF FILE-NAME

	fseek(zip, Z_FLEN, SEEK_CUR);
	fread(&filesize, sizeof(unsigned long), 1, zip);
	fread(&namelen, sizeof(unsigned int), 1, zip);

// GET THE ACTUAL FILE NAME & RETURN FILE SIZE

	fseek(zip, (Z_NAME - sizeof(unsigned int)), SEEK_CUR);
	fread(file, sizeof(char), namelen, zip);
	file[namelen] = '\0';
	return filesize;
}

int unzip(char *zip, char *file, char *path)
{
	char cmd[255];

#ifdef DEBUG
	printf("unzipping %s\n", file);
#endif

	strcpy(cmd, "pkunzip -o ");
	strcat(cmd, zip, " ", path, "system ", file);
	return (system(cmd));
}

int cp(char *path, char *file)
{
	char cmd[255];

#ifdef DEBUG
	printf("copying files into win.com\n");
#endif

	strcpy(cmd, "copy /b ");
	strcat(cmd, path, "system\\win.cnf + ", path, "system\\vgalogo.lgo + ", path);
	strcat(cmd, "system\\", file, " ", path, "win.com");
	return (system(cmd));
}

int rm(char *path, char *file)
{
	char fpath[strlen(path)+strlen(file)+1];

#ifdef DEBUG
	printf("removing %s\n", file);
#endif

	strcpy(fpath, path);
	strcat(fpath, "system\\", file);
	return (remove(fpath));
}
