/*

   Sample UDK (user-defined key) dll

   (compiled under MSC 8.0 (VC++))

   You may do whatever you want with this.  It's free.

*/
#include <windows.h>
#include <memory.h>


/*
      
   MF.dll will call this function and pass the following parameters:
   pass:
      val 1   (LPSTR a)
      val 2   (LPSTR b)
      length  (Size of keys to compare)
      type    (This will be a number >= 100)
   
   the 'type' is the 'type of index' specified when the index's where
   created.  (i.e. When you called mfCreateDB you passed an array of
   index types.  One of those 'types' was >= 100.  Whatever that
   # was, it is now passed to you (as the type).  This allows you to
   support multiple UDK's in one function.

   You should return:
   returns:
      0 == equal
      1 == val 1 > val 2
      -1 == val 1 < val 2

   Demonstrated in this example is a reverse-sorting for character fields
   and a variable length char and INT field.  The 'type' passed for
   these fields is:
      1001 = reverse sorting characters
      1002 = variable length char and INT


*/
int FAR PASCAL _export mfUDK(LPSTR a, LPSTR b, int len, int type)
{
   int iReturnValue;

   switch(type){
      case 1001:
            // _fmemcmp is a MS-C runtime library routine.  (It is actually
            // pretty quick, believe it or not...)
            // Anycase, it returns the EXACT same parameters we need to
            // return from this function...
            // NOTE: To show the reverse-sorting, we just switched the
            // order of the parameters to fmemcmp.  For 'alphabetical' 
            // we would have put 'a' and then 'b'.
         return(_fmemcmp((LPSTR)b, (LPSTR)a, len));
         break;

      case 1002:
            // NOTE: By using the value of  'len' we can make this 
            // a 'variable' length string routine.  e.g. if the user
            // made the key an 80 bytes, this routine would still
            // work (by comparing the first 78 bytes and then the integer
            // tacked onto the end...)

         iReturnValue = _fmemcmp((LPSTR)a, (LPSTR)b, len-2);
            // We can stop checking now because the keys first set of 
            // keys (the char[len]) doesn't match, therefore the value
            // of the INT is irrelevant)
         if (iReturnValue != 0)
               return (iReturnValue);
         if (*(int FAR *)(a+len-2) < *(int FAR *)(b+len-2))
            return (-1);
         if (*(int FAR *)(a+len-2) > *(int FAR *)(b+len-2))
            return (1);

         return(0);  // exact match...
         break;
   }

}


/*----------------------------------------------------------------------
   This is required for 'windows' dll's.
   Generally, you put any startup code that you might require,
   initialize variables, allocate memory, etc...
*/
int FAR PASCAL LibMain(
        HANDLE  hModule,
        WORD    wDataSeg,
        WORD    cbHeapSize,
        LPSTR   lpszCmdLine
        )
{
   return 1;
}
