 Rem File: Dndpack for Dndbbs Version v5.0a Release r2.0
 Rem $Include: 'Dndpack.inc'
 On Error Goto ErrMain0
 Call Get.Command
 Call Open.Arrays
 Call Get.Config
 Call Increase.Files
 Call Make.FileNames
 Call Open.Files
 Call Pack.Files
 Color 7,0
 Print "Returning to system."
MainExit0:
 End 0
ErrMain0:
 Resume MainExit0
 End 1

Function Timeit!
 t1$ = Format$(Now, "hh:mm:ss") ' seconds past midnight
 t1! = CSNG(INT(VAL(MID$(t1$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(t1$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(t1$, 7, 2))))
 Timeit!=t1!
End Function

Function Time.Elapsed(Start.Time!,Wait.Time!)
 Elapsed.Time!=Timeit!-Start.Time!
 If Elapsed.Time!<SFalse Then
    Elapsed.Time!=Elapsed.Time!+86400!
 Endif
 If Elapsed.Time!>=Wait.Time! Then
    Time.Elapsed=True
 Else
    Time.Elapsed=False
 Endif
End Function

Function Form$(Var#)
 Form$=Format$(Var#,"#,##0;;"+Chr$(34)+"zero"+Chr$(34))
End Function

Function GetFilename$(Var1$,Var2$)
 On Local Error Goto Error.Trap100
 Var=16
 Do
    Var=Var+1
    VarF$=Var1$+Mid$(Str$(Var),2)+"."+Var2$
    If Dir$(VarF$)=Nul Then
       GetFilename$=VarF$
       Exit Function
    Endif
 Loop
Error.Resume100:
 Exit Function
Error.Trap100:
 Color 7,0
 Print "Error opening temporary filename. Free more file space."
 Call Terminate.Program
 Resume Error.Resume100
End Function

Function ValidDate(Var$)
 On Local Error Goto DateError
 Var$=Rtrim$(Var$)
 If Len(Var$)=10 Then ' mm-dd-yyyy
    For Var=1 To 10
       V$=Mid$(Var$,Var,1)
       Select Case Var
       Case 1, 2, 4, 5, 7, 8, 9, 10
          If V$>="0" And V$<="9" Then
             Eat$ = Nul
          Else
             Goto DateResume
          Endif
       Case Else
          If V$ <> "-" Then
             Goto DateResume
          Endif
       End Select
    Next
 Endif
 Temp#=DateValue(Var$)
 If Temp# Then
    TempC$=Var$
    ValidDate=True
    Exit Function
 Endif
DateResume:
 ValidDate=False
 Exit Function
DateError:
 Resume DateResume
End Function

Sub Sleep.Second(Var!)
 On Local Error Goto Error.Trap5a
 Timer.Temp!=Timeit!
 Do
    If Time.Elapsed(Timer.Temp!,Var!) Then
       Exit Do
    Endif
 Loop
Error.Resume5a:
 Exit Sub
Error.Trap5a:
 Resume Error.Resume5a
End Sub

Sub Terminate.Program
 On Local Error Goto ErrMain42
 Color 7,0
 Print
 Print "Now exiting the Dndbbs pack utility."
 Call Decrease.Files
MainExit42:
 End 0
ErrMain42:
 Resume MainExit42
End Sub

Sub Decrease.Files
 On Local Error Goto Error.Trap10
 Close
 InregsX.AX=&H6200
 Call InterruptX(&H21,InregsX,OutregsX)
 PSP.Segment=OutregsX.BX
 Def Seg=PSP.Segment
 Poke &H32,20
 Poke &H34,&H18
 Def Seg
 Close
Error.Resume10:
 Exit Sub
Error.Trap10:
 Resume Error.Resume10
End Sub

Sub Pack.Files
 On Local Error Goto ErrResume13
 Color 15,0
 Print "Dndpack utility v"+Version$+" r"+Release$

 ' get config
 Call Read.Config

 ' start pre-pack init
 Call Init.Dnd.Pack(Var)
 If Var=False Then
    Color 14,0
    Print "Unable to start pack."
    Color 7,0
    Call Terminate.Program
    End 0
 Endif

 ' start pack
 Color 14,0
 Print "Starting pack.."
 Strng=Format$(Now,"hh:mm:ss")
 Print #LogFile,"Pack log started "+DateS$+" "+Strng+"."
 Var1=TempD : Var2=TempX : Var3=Temp9
 Call Pack
 Color 14,0
 Print "Finishing pack.."
 Close
 If Var1 Or Var2 Or Var3 Then Exit Sub
 ' offline players inventory
 FileName=MessWork.FileName+"4"+File.Extension1
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 ' online users inventory
 FileName=MessWork.FileName+"6"+File.Extension1
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 ' online monsters
 FileName=MessWork.FileName+"3"+File.Extension1
 If Dir$(FileName)<>Nul Then
    Open FileName For Random Shared As #MessWorkFile3 Len=MessWorkRecLen3
    For Var!=1! To Lof(MessWorkFile3)/MessWorkRecLen3
       Call Read.Record(MessWorkFile3,Var!)
       If MessWorkRecord3.IsAutomaton=False Then
          MessWorkRecord3.Index=SFalse
          Call Write.Record(MessWorkFile3,Var!)
       Endif
    Next
 Endif
 ' online monsters inventory
 FileName=MessWork.FileName+"5"+File.Extension1
 If Dir$(FileName)<>Nul Then
    Open FileName For Random Shared As #MessWorkFile5 Len=MessWorkRecLen5
    For Var!=1! To Lof(MessWorkFile5)/MessWorkRecLen5
       Call Read.Record(MessWorkFile5,Var!)
       If MessWorkRecord5.IsAutomaton=False Then
          MessWorkRecord5.Index=SFalse
          Call Write.Record(MessWorkFile5,Var!)
       Endif
    Next
 Endif
 Close
 Call Restart.Nodes
 Call Update.Usage.File
ErrExit13:
 Exit Sub
ErrResume13:
 Resume ErrExit13
End Sub

Sub Get.Command
 On Local Error Goto ErrResume13y
 ' check usage
 If Command$="/?" Then
    Goto Boot.Usage
 Endif
 If Command$="-?" Then
    Goto Boot.Usage
 Endif

 ' store command line
 Var$=Command$

 ' pack users before date
 Var=Instr(Var$,"/A:")
 TempC$=Nul
 If Var Then
    Var1$=Mid$(Var$,Var+3,10)
    TempA=ValidDate(Var1$)
    If TempA=False Then
       Goto Boot.Usage
    Endif
    Var$=Left$(Var$,Var-1)+Mid$(Var$,Var+13)
 Endif

 ' pack deleted users
 Var=Instr(Var$,"/B")
 If Var Then
    TempB=True
    Var$=Left$(Var$,Var-1)+Mid$(Var$,Var+2)
 Endif

 ' pack dead users
 Var=Instr(Var$,"/C")
 If Var Then
    TempC=True
    Var$=Left$(Var$,Var-1)+Mid$(Var$,Var+2)
 Endif

 ' pack bank
 Var=Instr(Var$,"/D")
 If Var Then
    TempD=True
    Var$=Left$(Var$,Var-1)+Mid$(Var$,Var+2)
 Endif

 ' pack mail
 Var=Instr(Var$,"/E")
 If Var Then
    TempX=True
    Var$=Left$(Var$,Var-1)+Mid$(Var$,Var+2)
 Endif

 ' pack coins
 Var=Instr(Var$,"/F")
 If Var Then
    Temp9=True
    Var$=Left$(Var$,Var-1)+Mid$(Var$,Var+2)
 Endif

 ' check to over-ride specific node number
 NodeX=Nul
 Var$=Ltrim$(Var$)
 Var$=Rtrim$(Var$)
 If Left$(Var$,3)="/N:" Then
    VarQ$=Mid$(Var$,4)
    Select Case Len(VarQ$)
    Case 0
       NodeX=Nul
       Var$=Nul
    Case 1
       Select Case VarQ$
       Case "0" To "9", "A" To "Z"
          NodeX=VarQ$
          Var$=Nul
       Case Else
          Goto Boot.Usage
       End Select
    Case 2
       VarQ=Int(Val(VarQ$))
       If VarQ>=10 And VarQ<=99 Then
          NodeX=Mid$(Str$(VarQ),2)
          Var$=Nul
       Else
          Goto Boot.Usage
       Endif
    End Select
 Endif

 ' check line
 If Len(Var$) Then
    Goto Boot.Usage
 Endif
 Exit Sub

Boot.Usage:
 Color 15,0
 Print "Dndpack v"+Version$+" r"+Release$
 Print "Usage:"
 Color 14,0
 Print "  Dndpack [/A:date][/B][/C][/D][/E][/F][/N:##]"
 Color 15,0
 Print "Where:"
 Color 14,0
 Print "  /A:mm-dd-yyyy  pack users before date."
 Print "  /B  pack deleted users."
 Print "  /C  pack dead users."
 Print "  /D  pack bank."
 Print "  /E  pack email."
 Print "  /F  pack coins."
 Print "  /N:##  optional node from 0-9,A-Z,10-99."
 Print "Dndpack.cfg  file contents override command line settings."
 Color 7,0
 Print "Exit to system."
 End 0
ErrExit13y:
 Exit Sub
ErrResume13y:
 Resume ErrExit13y
End Sub

Sub Read.Config
 On Local Error Goto ErrResume13x
 TempB=False
 TempC=False
 TempC$="01-01-1980"
 Filename=DND.Path+"DNDPACK.CFG"
 Close #TempFile2
 If Dir$(Filename)="" Then
    Open Filename For Output As #TempFile2
    Print #TempFile2,";dndpack override switches"
    Print #TempFile2,"PackDate=01-01-1980"
    Print #TempFile2,"PackDeleted=On"
    Print #TempFile2,"PackDead=Off"
 Endif
 Close #TempFile2
 Open Filename For Input As #TempFile2
 Do
    If Eof(TempFile2) Then
       Exit Do
    Endif
    Line Input #TempFile2,Data.Line$
    Data.Line$=Ucase$(Rtrim$(Ltrim$(Data.Line$)))
    If Len(Data.Line$) Then
       If Left$(Data.Line$,1)<>";" Then
          VarQ=Instr(Data.Line$,"'")
          If VarQ Then
             Data.Line$=Left$(Data.Line$,VarQ-1)
             Data.Line$=Rtrim$(Data.Line$)
          Endif
          VarX=Instr(Data.Line$,"=")
          If VarX Then
             Var1$=Left$(Data.Line$,VarX-1)
             Var2$=Mid$(Data.Line$,VarX+1)
             Var1$=Rtrim$(Ltrim$(Var1$))
             Var2$=Rtrim$(Ltrim$(Var2$))
             Select Case Var1$
             Case "PACKDATE"
                TempA=ValidDate(Var2$)
                If TempA=False Then
                   Color 14,0
                   Print "Error opening "+Lcase$(FileName)+" (error: bad date)."
                   Print "Edit Packdate= setting in Dndpack.cfg."
                   Color 7,0
                   Call Terminate.Program
                Endif
             Case "PACKDELETED"
                Select Case Var2$
                Case "ON","TRUE","-1"
                   TempB=True
                End Select
             Case "PACKDEAD"
                Select Case Var2$
                Case "ON","TRUE","-1"
                   TempC=True
                End Select
             End Select
          Endif
       Endif
    Endif
 Loop
ErrExit13x:
 Exit Sub
ErrResume13x:
 Resume ErrExit13x
End Sub

Sub Read.Config2(Var1,Var2,Var1!,Var2!)
 On Local Error Goto ErrResume13x2
 Var1=3 : Var2=6 : Var1!=60! : Var2!=10
 Filename=DND.Path+"DNDPACK.CFG"
 If Dir$(Filename)="" Then
    Exit Sub
 Endif
 Close #TempFile2
 Open Filename For Input As #TempFile2
 Do
    If Eof(TempFile2) Then
       Exit Do
    Endif
    Line Input #TempFile2,Data.Line$
    Data.Line$=Ucase$(Rtrim$(Ltrim$(Data.Line$)))
    If Len(Data.Line$) Then
       If Left$(Data.Line$,1)<>";" Then
          VarQ=Instr(Data.Line$,"'")
          If VarQ Then
             Data.Line$=Left$(Data.Line$,VarQ-1)
             Data.Line$=Rtrim$(Data.Line$)
          Endif
          VarX=Instr(Data.Line$,"=")
          If VarX Then
             Var1$=Left$(Data.Line$,VarX-1)
             Var2$=Mid$(Data.Line$,VarX+1)
             Var1$=Rtrim$(Ltrim$(Var1$))
             Var2$=Rtrim$(Ltrim$(Var2$))
             Select Case Var1$
             Case "SYSTEM.SHUTDOWN.COUNTER"
                VarA=Int(Val(Var2$))
                If VarA>=1 And VarA<=10 Then
                   Var1=Int(Val(Var2$))
                Endif
             Case "SYSTEM.SHUTDOWN.MESSAGE"
                VarA=Int(Val(Var2$))
                If VarA>=1 And VarA<=10 Then
                   Var2=Int(Val(Var2$))
                Endif
             Case "SYSTEM.SHUTDOWN.TIMER1"
                VarA!=Int(Val(Var2$))
                If VarA!>=1 And VarA!<=60 Then
                   Var1!=Int(Val(Var2$))
                Endif
             Case "SYSTEM.SHUTDOWN.TIMER2"
                VarA!=Int(Val(Var2$))
                If VarA!>=1 And VarA!<=60 Then
                   Var2!=Int(Val(Var2$))
                Endif
             End Select
          Endif
       Endif
    Endif
 Loop
ErrExit13x2:
 Exit Sub
ErrResume13x2:
 Resume ErrExit13x2
End Sub

Sub Pack
 On Local Error Goto ErrResume13c
 TempB!=SFalse
 TempD!=SFalse
 Var1=TempD : Var2=TempX : Var3=Temp9
 If Var1 Then
    Call Pack.Bank
    Color 14,0
    Print "Bank packed.."
 Endif
 If Var2 Then
    Call Pack.Bases
    Call Pack.Messages
    Color 14,0
    Print "Mail packed.."
 Endif
 If Var3 Then
    Call Pack.Coins
    Color 14,0
    Print "Coins packed.."
 Endif
 If Var1 Or Var2 Or Var3 Then Exit Sub
 Call Repair.Rooms
 Call Pack.Rooms
 Call Repair.Monsters
 Call Repair.Nonplayers
 Call Pack.Monsters
 Call Repair.Users
 Call Pack.Users
 Call Repair.Teams
 Call Pack.Teams
 Call Pack.Containers
 Call Pack.Bases
 Call Pack.Messages
 Call Pack.Object.Desc
 Call Pack.Scroll.Desc
 Call Pack.Coins
 Call Pack.Bank
 Color 14,0
 If TempD!<=SFalse Then
    Print "No records packed.."
 Else
    Print "Records packed: "+Form$(Cdbl(TempD!))
    Print "Bytes packed: "+Form$(Cdbl(TempB!))
 Endif
 FileName=DND.Path+"PACK"+Log.Extension
 If TempD!<=SFalse Then
    TempD!=SFalse
 Endif
 If TempB!<=SFalse Then
    TempB!=SFalse
 Endif
 Strng="--Records packed: "+Form$(Cdbl(TempD!))
 Print #LogFile,Strng
 Strng="--Bytes packed: "+Form$(Cdbl(TempB!))
 Print #LogFile,Strng
ErrExit13c:
 Exit Sub
ErrResume13c:
 Resume ErrExit13c
End Sub

Sub Update.Usage.File
 On Local Error Goto ErrResume13b
 Strng=Format$(Now,"hh:mm:ss")
 Close #TempFile2
 Open Usage.FileName For Random Shared As #TempFile2 Len=26
 Field #TempFile2,26 As S$
 Lset S$="DND Usage File v"+Version$+Chr$(13)+Chr$(10)+Chr$(26)
 Put #TempFile2,1
 Field #TempFile2,10 As D$, 8 As T$, 8 As X$
 If Lof(TempFile2)/26<2 Then
    Lset D$=DateS$
    Lset T$=Strng
    Lset X$=Mkd$(0#)
    Put #TempFile2,2
 Endif
 If Lof(TempFile2)/26<3 Then
    Lset D$=DateS$
    Lset T$=Strng
    Lset X$=Mkd$(0#)
    Put #TempFile2,3
 Endif
 Get #TempFile2,3
 Var#=Cvd(X$)
 Var#=Var#+1#
 Lset D$=DateS$
 Lset T$=Strng
 Lset X$=Mkd$(Var#)
 Put #TempFile2,3
ErrExit13b:
 Exit Sub
ErrResume13b:
 Resume ErrExit13b
End Sub

Sub Init.Dnd.Pack(Var)
 On Local Error Goto ErrResume13a
 Call Read.Config2(VarQ1, VarQ2, VarQ1!, VarQ2!)
 ' check any nodes active.
 Var=False
 Call Search.Mess2(Var2)
 If Var2=False Then
    Var=True
    Exit Sub
 Endif
 Color 15,0
 Print "Initializing nodes.."
 ' send suspend message to active nodes.
 For Temp=False To MaxNodes
    Call Read.Message.Record(MessWorkFile1,Temp+1)
    MessWorkRecord1.SuspendNode=True
    Call Write.Message.Record(MessWorkFile1,Temp+1)
 Next
 Call Sleep.Second(5!)
 ' recheck active nodes.
 Call Search.Mess2(Var2)
 If Var2=False Then
    Var=True
    Exit Sub
 Endif
 ' send shutdown warning to online users.
 Color 15,0
 Print "System shutdown warning 1 sent."
 VarC=VarQ1
 VarD=1
 Var$=Chr$(7)+"Shutting down for maintenance in"+Str$(VarC)+" minutes!!"
 Call Write.Node(5,Var$)
 Var1!=Timeit!
 Do
    Call Sleep.Second(1!)
    ' recheck users online.
    Call Search.Mess2(Var2)
    If Var2=False Then
       Var=True
       Exit Do
    Endif
    If Time.Elapsed(Var1!,VarQ1!) Then
       VarC=VarC-1
       If VarC=False Then
          Exit Do
       Endif
       VarD=VarD+1
       Color 15,0
       Print "System shutdown warning"+Str$(VarD)+" sent."
       Var$="Shutting down for maintenance in"+Str$(VarC)+" minute"
       If VarC>1 Then
          Var$=Var$+"s"
       Endif
       Var$=Chr$(7)+Var$+"!!"
       Call Write.Node(5,Var$)
       Var1!=Timeit!
    Endif
 Loop
 ' resend shutdown message.
 Color 15,0
 Print "Shutting down nodes."
 Var$=Chr$(7)+"System now shutting down!!"
 Call Write.Node(5,Var$)
 VarC=False
 For Temp=False To MaxNodes
    Call Read.Message.Record(MessWorkFile1,Temp+1)
    MessWorkRecord1.SuspendNode=True
    Call Write.Message.Record(MessWorkFile1,Temp+1)
 Next
 Call Sleep.Second(5!)
 ' recheck active nodes.
 Call Search.Mess2(Var2)
 If Var2=False Then
    Var=True
    Exit Sub
 Endif
 ' send suspend message.
 VarD=1
 Color 15,0
 Print "System shutdown message 1 sent."
 Var1$="Suspend"
 Call Write.Node(30,Var1$)
 Var1!=Timeit!
 Do
    If Time.Elapsed(Var1!,VarQ2!) Then
       VarD=VarD+1
       Color 15,0
       Print "System shutdown message"+Str$(VarD)+" sent."
       ' resend suspend message.
       For Temp=False To MaxNodes
          Call Read.Message.Record(MessWorkFile1,Temp+1)
          MessWorkRecord1.SuspendNode=True
          Call Write.Message.Record(MessWorkFile1,Temp+1)
       Next
       Var1$="Suspend"
       Call Write.Node(30,Var1$)
       Var1!=Timeit!
       VarC=VarC+1
       If VarC>=VarQ2 Then
          Color 15,0
          Print "Failure shutting down nodes. Run "+Chr$(34)+"Dndutil /C"+Chr$(34)+"."
          Var=False
          Exit Sub
       Endif
    Endif
    ' recheck active nodes.
    Call Search.Mess2(Var2)
    If Var2=False Then
       Var=True
       Exit Sub
    Endif
 Loop
ErrExit13a:
 Exit Sub
ErrResume13a:
 Resume ErrExit13a
End Sub

Sub Restart.Nodes
 On Local Error Goto ErrResume13d
 FileName=MessWork.FileName+"1"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile1 Len=MessWorkRecLen1
 FileName=MessWork.FileName+"2"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile2 Len=MessWorkRecLen2
 Var1$="Suspend"
 Call Write.Node(31,Var1$)
 For Temp=False To MaxNodes
    Call Read.Message.Record(MessWorkFile1,Temp+1)
    MessWorkRecord1.SuspendNode=1
    Call Write.Message.Record(MessWorkFile1,Temp+1)
 Next
ErrExit13d:
 Exit Sub
ErrResume13d:
 Resume ErrExit13d
End Sub

Sub Write.Node(Var1,Var1$)
 On Local Error Goto Error.Trap9a
 Temp$=String$(MaxNodes+1,"0")
 For Temp4=False To MaxNodes
    Call Read.Message.Record(MessWorkFile1,Temp4+1)
    Var=False
    If MessWorkRecord1.UserIndex=False Then
       If MessWorkRecord1.RoomNumber=False Then
          Var=True
       Endif
    Endif
    If Var Then
       Mid$(Temp$,Temp4+1,1)="1"
    Endif
 Next
 If Temp$=String$(MaxNodes+1,"1") Then
    Exit Sub
 Endif
 For Var!=1 To Lof(MessWorkFile2)/MessWorkRecLen2
    Call Read.Record(MessWorkFile2,Var!)
    If MessWorkRecord2.Flags=String$(MaxNodes+1,"1") Then
       Exit For
    Endif
    VarX!=Csng(Time.Override)
    If VarX!>SFalse Then
       If Time.Elapsed(MessWorkRecord2.MessageTime,VarX!) Then
          Exit For
       Endif
    Endif
 Next
 Var1$="System: "+Var1$
 MessWorkRecord2.Flags=Temp$
 MessWorkRecord2.Message=Var1$
 MessWorkRecord2.MessageTime=Timeit!
 MessWorkRecord2.MessageType=Var1
 MessWorkRecord2.Node=False
 MessWorkRecord2.RoomNumber=False
 MessWorkRecord2.UserIndex=False
 MessWorkRecord2.UserName="<monitor>"
 MessWorkRecord2.Message2=Nul
 Call Write.Record(MessWorkFile2,Var!)
Error.Resume9a:
 Exit Sub
Error.Trap9a:
 Resume Error.Resume9a
End Sub

Sub Pack.Rooms
 On Local Error Goto ErrResume65
 Color 14,0
 Print "Making backup of room inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"ROOMINV.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA!=Lof(RoomInvFile)
 TempC!=Lof(RoomInvFile)/MessWorkRecLen6
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(RoomInvFile)/MessWorkRecLen6
    Call Read.Record(RoomInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 12,0
 Print "Packing room inventory file.."
 Close #RoomInvFile
 FileName=RoomInv.FileName
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #RoomInvFile Len=MessWorkRecLen6
 For Temp!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp!)
    Temp5!=RoomRecord.First
    If Temp5! Then
       RoomRecord.First=SFalse
       RoomRecord.Last=SFalse
       Call Write.Record(RoomFile,Temp!)
       Do
          Call Read.TempFile(7,Temp5!)
          Temp6!=MessWorkRecord6.Next
          Temp7!=Lof(RoomInvFile)/MessWorkRecLen6+1!
          Call Add.List.Node(Temp7!)
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp5!=Temp6!
       Loop
    Endif
 Next
 TempC!=TempC!-Lof(RoomInvFile)/MessWorkRecLen6
 TempD!=TempD!+TempC!
 TempA!=TempA!-Lof(RoomInvFile)
 TempB!=TempB!+TempA!
 Color 14,0
 Print "Making backup of room description file.."
 Close #TempFile1
 FileName=Data.Path1+"ROOMDESC.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA!=Lof(RoomDescFile)
 TempC!=Lof(RoomDescFile)/RoomDescLen
 Open FileName For Random Shared As #TempFile1 Len=RoomDescLen
 For Var5!=1! To Lof(RoomDescFile)/RoomDescLen
    Call Read.Record(RoomDescFile,Var5!)
    Call Write.TempFile(8,Var5!)
 Next
 Color 12,0
 Print "Packing room description file.."
 Close #RoomDescFile
 FileName=Room.Desc.FileName
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Temp5!=SFalse
 Open FileName For Random Shared As #RoomDescFile Len=RoomDescLen
 For Var!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Var!)
    For Temp5=1 To 19
       Var6!=RoomRecord.LongDesc(Temp5)
       If Var6!>SFalse And Var6!<=Lof(TempFile1)/RoomDescLen Then
          Call Read.TempFile(8,Var6!)
          Temp5!=Temp5!+1!
          Call Write.Record(RoomDescFile,Temp5!)
          RoomRecord.LongDesc(Temp5)=Temp5!
       Endif
    Next
    Call Write.Record(RoomFile,Var!)
 Next
 TempC!=TempC!-Lof(RoomDescFile)/RoomDescLen
 TempD!=TempD!+TempC!
 TempA!=TempA!-Lof(RoomDescFile)
 TempB!=TempB!+TempA!
ErrExit65:
 Exit Sub
ErrResume65:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+" packing rooms."
 Resume ErrExit65
End Sub

Sub Pack.Monsters
 On Local Error Goto ErrResume53
 Color 14,0
 Close #TempFile1
 FileName=Data.Path1+"MONINV.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA!=Lof(MonInvFile)
 TempC!=Lof(MonInvFile)/MessWorkRecLen6
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(MonInvFile)/MessWorkRecLen6
    Call Read.Record(MonInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Close #MonInvFile
 FileName=MonInv.FileName
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #MonInvFile Len=MessWorkRecLen6
 For Temp5!=1! To Lof(MonsterFile)/MonsterRecLen
    Call Read.Record(MonsterFile,Temp5!)
    Temp!=MonsterRecord.First
    If Temp! Then
       MonsterRecord.First=SFalse
       MonsterRecord.Last=SFalse
       Call Write.Record(MonsterFile,Temp5!)
       Do
          Call Read.TempFile(7,Temp!)
          Temp6!=MessWorkRecord6.Next
          Temp7!=Lof(MonInvFile)/MessWorkRecLen6+1!
          Call Add.List.Node1(Temp7!)
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp!=Temp6!
       Loop
    Endif
 Next
 Color 14,0
 Print "Monster inventory file packed."
 For Temp5!=1! To Lof(NonplayerFile)/MonsterRecLen
    Call Read.Record(NonplayerFile,Temp5!)
    Temp!=MonsterRecord.First
    If Temp! Then
       MonsterRecord.First=SFalse
       MonsterRecord.Last=SFalse
       Call Write.Record(NonplayerFile,Temp5!)
       Do
          Call Read.TempFile(7,Temp!)
          Temp6!=MessWorkRecord6.Next
          Temp7!=Lof(MonInvFile)/MessWorkRecLen6+1!
          Call Add.List.Node2(Temp7!)
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp!=Temp6!
       Loop
    Endif
 Next
 Color 14,0
 Print "Nonplayer inventory file packed."
 TempC!=TempC!-Lof(MonInvFile)/MessWorkRecLen6
 TempD!=TempD!+TempC!
 TempA!=TempA!-Lof(MonInvFile)
 TempB!=TempB!+TempA!
ErrExit53:
 Exit Sub
ErrResume53:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+" packing monsters."
 Resume ErrExit53
End Sub

Sub Add.List.Node1(VarZ!)
 On Local Error Goto ErrorTrp27a
 If MonsterRecord.First=SFalse Then
    MonsterRecord.First=VarZ!
    MonsterRecord.Last=VarZ!
    Call Write.Record(MonsterFile,Temp5!)
    MessWorkRecord6.Prev=SFalse
    MessWorkRecord6.Next=SFalse
    Call Write.Record(MonInvFile,VarZ!)
    Exit Sub
 Endif
 MessWorkRecord6.Prev=MonsterRecord.Last
 MessWorkRecord6.Next=SFalse
 Call Write.Record(MonInvFile,VarZ!)
 Call Read.Record(MonInvFile,MonsterRecord.Last)
 MessWorkRecord6.Next=VarZ!
 Call Write.Record(MonInvFile,MonsterRecord.Last)
 Call Read.Record(MonInvFile,VarZ!)
 MonsterRecord.Last=VarZ!
 Call Write.Record(MonsterFile,Temp5!)
ErrorRsm27a:
 Exit Sub
ErrorTrp27a:
 Resume ErrorRsm27a
End Sub

Sub Add.List.Node2(VarZ!)
 On Local Error Goto ErrorTrp27b
 If MonsterRecord.First=SFalse Then
    MonsterRecord.First=VarZ!
    MonsterRecord.Last=VarZ!
    Call Write.Record(NonplayerFile,Temp5!)
    MessWorkRecord6.Prev=SFalse
    MessWorkRecord6.Next=SFalse
    Call Write.Record(MonInvFile,VarZ!)
    Exit Sub
 Endif
 MessWorkRecord6.Prev=MonsterRecord.Last
 MessWorkRecord6.Next=SFalse
 Call Write.Record(MonInvFile,VarZ!)
 Call Read.Record(MonInvFile,MonsterRecord.Last)
 MessWorkRecord6.Next=VarZ!
 Call Write.Record(MonInvFile,MonsterRecord.Last)
 Call Read.Record(MonInvFile,VarZ!)
 MonsterRecord.Last=VarZ!
 Call Write.Record(NonplayerFile,Temp5!)
ErrorRsm27b:
 Exit Sub
ErrorTrp27b:
 Resume ErrorRsm27b
End Sub

Sub Pack.Users
 On Local Error Goto ErrResume11
 Temp#=DFalse
 If TempA Then
    Temp#=Int(DateValue(TempC$))
 Endif
 Color 14,0
 Print "Making backup of user file.."
 FileName=Left$(User.Filename,Instr(User.Filename,"."))+"bak"
 Close #TempFile1
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA!=Lof(UserFile)
 TempC!=Lof(UserFile)/UserRecLen
 Open FileName For Random Shared As #TempFile1 Len=UserRecLen
 For Temp3!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp3!)
    Call Write.TempFile(4,Temp3!)
 Next
 VarZ!=SFalse
 FileName=User.Filename
 Close #UserFile
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #UserFile Len=UserRecLen
 Close #TempFile3
 Open Log.FileName For Random Shared As #TempFile3 Len=LogRecLen
 Close #TempFile4
 FileName=DND.Path+"writing.log"
 Open FileName For Random Shared As #TempFile4 Len=LogRecLen
 Temp1!=SFalse
 For Temp3!=1! To Lof(TempFile1)/UserRecLen
    Call Read.TempFile(4,Temp3!)
    Call New.Stats
    Out3=UserRecord.CodeName
    Temp=False
    If TempA Then
       Out2=UserRecord.DateOn
       TempQ=ValidDate(Out2)
       If TempQ Then
          If Int(DateValue(Out2))<Temp# Then
             Temp=True
          Endif
       Endif
    Endif
    If TempB Then
       If Left$(Out3,9)=Deleted$ Then
          Temp=True
       Endif
    Endif
    If TempC Then
       If UserRecord.Level=False Then
          Temp=True
       Endif
    Endif
    If Temp Then
       Gosub Clear.LogFile
       Gosub Clear.ScrollFile
       Call Clear.Team
       Call Clear.UserInv
       Call Clear.Containers
       VarZ!=VarZ!+1!
    Else
       Temp1!=Temp1!+1!
       Call Write.Record(UserFile,Temp1!)
       If Temp3!<>Temp1! Then
          Gosub Update.LogFile
          Gosub Update.ScrollFile
          Call Update.Team
          Call Update.UserInv
          Call Update.Containers
       Endif
    Endif
 Next
 Close #TempFile3
 Close #TempFile4
 TempC!=TempC!-Lof(UserFile)/UserRecLen
 TempD!=TempD!+TempC!
 TempA!=TempA!-Lof(UserFile)
 TempB!=TempB!+TempA!
 Color 14,0
 Print "Making backup of user inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"USERINV.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA!=Lof(UserInvFile)
 TempC!=Lof(UserInvFile)/MessWorkRecLen6
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(UserInvFile)/MessWorkRecLen6
    Call Read.Record(UserInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 12,0
 Print "Packing user inventory file.."
 Close #UserInvFile
 FileName=UserInv.FileName
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #UserInvFile Len=MessWorkRecLen6
 For Temp5!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp5!)
    Temp4!=UserRecord.First
    If Temp4! Then
       UserRecord.First=SFalse
       UserRecord.Last=SFalse
       Call Write.Record(UserFile,Temp5!)
       Do
          Call Read.TempFile(7,Temp4!)
          Temp6!=MessWorkRecord6.Next
          Temp7!=Lof(UserInvFile)/MessWorkRecLen6+1!
          Call Add.List.Node3(Temp7!)
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Next
 TempC!=TempC!-Lof(UserInvFile)/MessWorkRecLen6
 TempD!=TempD!+TempC!
 TempA!=TempA!-Lof(UserInvFile)
 TempB!=TempB!+TempA!
 Strng=" Users deleted:"+Str$(VarZ!)
 Print #LogFile,Strng
 Exit Sub
Clear.LogFile:
 For Var1!=1! To Lof(TempFile3)/LogRecLen
    Get #TempFile3,Var1!,LogRecord
    If LogRecord.User=Temp3! Then
       LogRecord.User=SFalse
       Put #TempFile3,Var1!,LogRecord
    Endif
 Next
 Return
Clear.ScrollFile:
 For Var1!=1! To Lof(TempFile4)/LogRecLen
    Get #TempFile4,Var1!,LogRecord
    If LogRecord.User=Temp3! Then
       LogRecord.User=SFalse
       Put #TempFile4,Var1!,LogRecord
    Endif
 Next
 Return
Update.LogFile:
 For Var1!=1! To Lof(TempFile3)/LogRecLen
    Get #TempFile3,Var1!,LogRecord
    If LogRecord.User=Temp3! Then
       LogRecord.User=Temp1!
       Put #TempFile3,Var1!,LogRecord
    Endif
 Next
 Return
Update.ScrollFile:
 For Var1!=1! To Lof(TempFile4)/LogRecLen
    Get #TempFile4,Var1!,LogRecord
    If LogRecord.User=Temp3! Then
       LogRecord.User=Temp1!
       Put #TempFile4,Var1!,LogRecord
    Endif
 Next
 Return
ErrExit11:
 Exit Sub
ErrResume11:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+" packing users."
 Print "Filename=";Filename
 Resume ErrExit11
End Sub

Sub Update.Team
 On Local Error Goto ErrResume11i
 For Var1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Var1!)
    For Var2=1 To 5
       Var2!=TeamRecord.UserIndex(Var2)
       If Var2!=Temp3! Then
          TeamRecord.UserIndex(Var2)=Temp1!
       Endif
    Next
    Call Write.Record(TeamFile,Var1!)
 Next
ErrExit11i:
 Exit Sub
ErrResume11i:
 Resume ErrExit11i
End Sub

Sub Update.UserInv
 On Local Error Goto ErrResume11g
 For Var1!=1! To Lof(UserInvFile)/MessWorkRecLen6
    Call Read.Record(UserInvFile,Var1!)
    If MessWorkRecord6.User=Temp3! Then
       MessWorkRecord6.User=Temp1!
       Call Write.Record(UserInvFile,Var1!)
    Endif
 Next
ErrExit11g:
 Exit Sub
ErrResume11g:
 Resume ErrExit11g
End Sub

Sub Update.Containers
 On Local Error Goto ErrResume11f
 For Var1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Var1!)
    If ContainerRecord.UserNumber=Temp3! Then
       ContainerRecord.UserNumber=Temp1!
       Call Write.Record(ContainerFile,Var1!)
    Endif
 Next
ErrExit11f:
 Exit Sub
ErrResume11f:
 Resume ErrExit11f
End Sub

Sub Clear.Team
 On Local Error Goto ErrResume11e
 For Var1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Var1!)
    For Var2=1 To 5
       Var2!=TeamRecord.UserIndex(Var2)
       If Var2!=Temp3! Then
          TeamRecord.Member(Var2)=Nul
          TeamRecord.UserIndex(Var2)=SFalse
          TeamRecord.Activated(Var2)=False
       Endif
    Next
    Call Write.Record(TeamFile,Var1!)
 Next
ErrExit11e:
 Exit Sub
ErrResume11e:
 Resume ErrExit11e
End Sub

Sub Clear.UserInv
 On Local Error Goto ErrResume6a
 For Var1!=1! To Lof(UserInvFile)/MessWorkRecLen6
    Call Read.Record(UserInvFile,Var1!)
    If MessWorkRecord6.User=Temp3! Then
       MessWorkRecord6.User=SFalse
       MessWorkRecord6.Room=SFalse
       MessWorkRecord6.Index=SFalse
       MessWorkRecord6.Charges=False
       MessWorkRecord6.Plus=False
       MessWorkRecord6.Prev=SFalse
       MessWorkRecord6.Next=SFalse
       Call Write.Record(UserInvFile,Var1!)
    Endif
 Next
ErrExit6a:
 Exit Sub
ErrResume6a:
 Resume ErrExit6a
End Sub

Sub Clear.Containers
 On Local Error Goto ErrResume11c
 For Var1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Var1!)
    If ContainerRecord.UserNumber=Temp3! Then
       Call Clear.Container
       Call Write.Record(ContainerFile,Var1!)
    Endif
 Next
ErrExit11c:
 Exit Sub
ErrResume11c:
 Resume ErrExit11c
End Sub

Sub Add.List.Node3(VarZ!)
 On Local Error Goto ErrorTrp27c
 If UserRecord.First=SFalse Then
    UserRecord.First=VarZ!
    UserRecord.Last=VarZ!
    Call Write.Record(UserFile,Temp5!)
    MessWorkRecord6.Prev=SFalse
    MessWorkRecord6.Next=SFalse
    Call Write.Record(UserInvFile,VarZ!)
    Exit Sub
 Endif
 MessWorkRecord6.Prev=UserRecord.Last
 MessWorkRecord6.Next=SFalse
 Call Write.Record(UserInvFile,VarZ!)
 Call Read.Record(UserInvFile,UserRecord.Last)
 MessWorkRecord6.Next=VarZ!
 Call Write.Record(UserInvFile,UserRecord.Last)
 Call Read.Record(UserInvFile,VarZ!)
 UserRecord.Last=VarZ!
 Call Write.Record(UserFile,Temp5!)
ErrorRsm27c:
 Exit Sub
ErrorTrp27c:
 Resume ErrorRsm27c
End Sub

Sub Pack.Teams
 On Local Error Goto ErrResume94
 Color 14,0
 Print "Making backup of team file.."
 FileName=Left$(Team.FileName,Instr(Team.FileName,"."))+"bk1"
 Close #TempFile1
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA!=Lof(TeamFile)
 TempC!=Lof(TeamFile)/TeamRecLen
 Open FileName For Random Shared As #TempFile1 Len=TeamRecLen
 For Temp3!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp3!)
    Call Write.TempFile(3,Temp3!)
 Next
 FileName=Team.FileName
 Close #TeamFile
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TeamFile Len=TeamRecLen
 VarQ!=SFalse
 VarZ!=SFalse
 For Temp3!=1! To Lof(TempFile1)/TeamRecLen
    Call Read.TempFile(3,Temp3!)
    For Var=1 To MaxTeamMembers
       Var2!=TeamRecord.UserIndex(Var)
       Temp1$=TeamRecord.Member(Var)
       Temp1$=Rtrim$(Temp1$)
       Temp1$=Lcase$(Temp1$)
       Temp=False
       If Var2!<>SFalse And Temp1$<>Nul Then
          If Var2!>SFalse And Var2!<=Lof(UserFile)/UserRecLen Then
             Temp=False
          Else
             Temp=True
          Endif
          If Temp=False Then
             Call Read.Record(UserFile,Var2!)
             Call New.Stats
             Out3=UserRecord.CodeName
             Out3=Rtrim$(Out3)
             Out3=Lcase$(Out3)
             If Out3<>Temp1$ Then
                Temp=True
             Endif
             If Left$(Out3,9)=Deleted$ Then
                Temp=True
             Endif
             'If UserRecord.Level=False Then
             '   Temp=True
             'Endif
          Endif
       Endif
       If Temp Then
          TeamRecord.Member(Var)=Nul
          TeamRecord.UserIndex(Var)=False
          VarZ!=VarZ!+1!
       Endif
    Next
    Call Write.Record(TeamFile,Temp3!)
 Next
 Strng=" Users deleted:"+Str$(VarZ!)
 Print #LogFile,Strng
 FileName=Left$(Team.FileName,Instr(Team.FileName,"."))+"bk2"
 Close #TempFile1
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=TeamRecLen
 For Temp3!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp3!)
    Call Write.TempFile(3,Temp3!)
 Next
 Color 14,0
 Print "Making backup of team inventory file.."
 FileName=Left$(TeamInv.FileName,Instr(TeamInv.FileName,"."))+"bak"
 Close #TempFile2
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile2 Len=MessWorkRecLen6
 TempA2!=Lof(TeamInvFile)
 TempC2!=Lof(TeamInvFile)/MessWorkRecLen6
 For Temp3!=1! To Lof(TeamInvFile)/MessWorkRecLen6
    Call Read.Record(TeamInvFile,Temp3!)
    Call Write.TempFile(9,Temp3!)
 Next
 Color 12,0
 Print "Packing teams.."
 FileName=Team.FileName
 Close #TeamFile
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TeamFile Len=TeamRecLen
 FileName=TeamInv.FileName
 Close #TeamInvFile
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TeamInvFile Len=MessWorkRecLen6
 Temp1!=SFalse
 VarX!=SFalse
 VarZ1!=SFalse
 For Temp3!=1! To Lof(TempFile1)/TeamRecLen
    Call Read.TempFile(3,Temp3!)
    Temp1$=TeamRecord.Name
    Temp1$=Rtrim$(Temp1$)
    Temp1$=Lcase$(Temp1$)
    If Temp1$=Deleted$ Or Temp1$=Nul Or TeamRecord.Deleted Then
       Var=True
    Else
       Var=False
    Endif
    If Var=False Then
       Var=True
       For Var3=1 To MaxTeamMembers
          VarQ!=TeamRecord.UserIndex(Var3)
          If VarQ!>SFalse And VarQ!<=Lof(UserFile)/UserRecLen Then
             Var=False
             Exit For
          Endif
       Next
    Endif
    If Var Then
       VarX!=VarX!+1!
       VarZ1!=VarZ1!+1!
    Else
       Temp1!=Temp1!+1!
       TeamRecord.First=SFalse
       TeamRecord.Last=SFalse
       Call Write.Record(TeamFile,Temp1!)
       For VarZ2!=1! To Lof(TempFile2)/MessWorkRecLen6
          Call Read.TempFile(9,VarZ2!)
          If MessWorkRecord6.User=Temp3! Then
             Var4=False
             Var5!=MessWorkRecord6.Index
             If Var5!>SFalse And Var5!<=Lof(TreasureFile)/TreasureRecLen Then
                Var4=True
             Else
                If Var5!<SFalse Then
                   Var5!=Abs(Var5!)
                   If Var5!>SFalse And Var5!<=Lof(ObjectFile)/ObjectRecLen Then
                      Var4=True
                   Endif
                Endif
             Endif
             If Var4 Then
                MessWorkRecord6.User=Temp1!
                VarY!=Lof(TeamInvFile)/MessWorkRecLen6+1!
                Call Add.List.Node4(Temp1!,VarY!)
             Endif
          Endif
       Next
    Endif
 Next
 Strng=" Teams deleted:"+Str$(VarZ1!)
 Print #LogFile,Strng
 TempC!=TempC!-Lof(TeamFile)/TeamRecLen
 TempC2!=TempC2!-Lof(TeamInvFile)/MessWorkRecLen6
 TempD!=TempD!+TempC!+TempC2!
 TempA!=TempA!-Lof(TeamFile)
 TempA2!=TempA2!-Lof(TeamInvFile)
 TempB!=TempB!+TempA!+TempA2!
ErrExit94:
 Exit Sub
ErrResume94:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+" packing teams."
 Resume ErrExit94
End Sub

Sub New.Stats
 On Local Error Goto ErrResume99
 Temp#=Cdbl(Training.Stats(UserRecord.ClassType,1))*Cdbl(UserRecord.Level)
 If Temp#>MaxInt Then
    Temp#=MaxInt
 Endif
 UserRecord.Fatigue=Cint(Temp#)
 UserRecord.FatigueMax=Cint(Temp#)
 Temp#=Cdbl(Training.Stats(UserRecord.ClassType,2))*Cdbl(UserRecord.Level)
 If Temp#>MaxInt Then
    Temp#=MaxInt
 Endif
 UserRecord.Vitality=Cint(Temp#)
 UserRecord.VitalityMax=Cint(Temp#)
 Temp#=Cdbl(Training.Stats(UserRecord.ClassType,3))*Cdbl(UserRecord.Level)
 If Temp#>MaxInt Then
    Temp#=MaxInt
 Endif
 UserRecord.Magic=Cint(Temp#)
 UserRecord.MagicMax=Cint(Temp#)
 Temp#=Cdbl(Training.Stats(UserRecord.ClassType,4))*Cdbl(UserRecord.Level)
 If Temp#>MaxInt Then
    Temp#=MaxInt
 Endif
 UserRecord.Psionic=Cint(Temp#)
 UserRecord.PsionicMax=Cint(Temp#)
 If UserRecord.Fatigue<False Or _
 UserRecord.Fatigue>UserRecord.FatigueMax Then
    UserRecord.Fatigue=UserRecord.FatigueMax
 Endif
 If UserRecord.Vitality<False Or _
 UserRecord.Vitality>UserRecord.VitalityMax Then
    UserRecord.Vitality=UserRecord.VitalityMax
 Endif
 If UserRecord.Magic<False Or _
 UserRecord.Magic>UserRecord.MagicMax Then
    UserRecord.Magic=UserRecord.MagicMax
 Endif
 If UserRecord.Psionic<False Or _
 UserRecord.Psionic>UserRecord.PsionicMax Then
    UserRecord.Psionic=UserRecord.PsionicMax
 Endif
ErrExit99:
 Exit Sub
ErrResume99:
 Resume ErrExit99
End Sub

Sub Add.List.Node4(VarY!,VarZ!)
 On Local Error Goto ErrorTrp27d
 If TeamRecord.First=SFalse Then
    TeamRecord.First=VarZ!
    TeamRecord.Last=VarZ!
    Call Write.Record(TeamFile,VarY!)
    MessWorkRecord6.Prev=SFalse
    MessWorkRecord6.Next=SFalse
    Call Write.Record(TeamInvFile,VarZ!)
    Exit Sub
 Endif
 MessWorkRecord6.Prev=TeamRecord.Last
 MessWorkRecord6.Next=SFalse
 Call Write.Record(TeamInvFile,VarZ!)
 Call Read.Record(TeamInvFile,TeamRecord.Last)
 MessWorkRecord6.Next=VarZ!
 Call Write.Record(TeamInvFile,TeamRecord.Last)
 Call Read.Record(TeamInvFile,VarZ!)
 TeamRecord.Last=VarZ!
 Call Write.Record(TeamFile,VarY!)
ErrorRsm27d:
 Exit Sub
ErrorTrp27d:
 Resume ErrorRsm27d
End Sub

Sub Repair.Rooms
 On Local Error Goto ErrResume65a
 Color 14,0
 Print "Making backup of room inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"ROOMINV2.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(RoomInvFile)/MessWorkRecLen6
    Call Read.Record(RoomInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 15,0
 Print "Repairing room inventory file.."
 Temp5!=SFalse
 VarZ1!=SFalse
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.First
    Temp3!=RoomRecord.Last
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(RoomInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Or MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             MessWorkRecord6.Next=SFalse
             Call Write.Record(RoomInvFile,Temp2!)
          Endif
       Else
          Call Read.Record(RoomInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             Call Write.Record(RoomInvFile,Temp2!)
          Endif
          Call Read.Record(RoomInvFile,Temp3!)
          If MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Next=SFalse
             Call Write.Record(RoomInvFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    VarY1!=0!
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.First
    If Temp2! Then
       Do
          Call Read.Record(RoomInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(RoomInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1a
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    VarY1!=0!
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(RoomInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(RoomInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2a
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.First
    If Temp2! Then
       Do
          Call Read.Record(RoomInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(RoomInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Prev Then
                Gosub Truncate1a
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(RoomInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(RoomInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Next Then
                Gosub Truncate2a
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.First
    If Temp2! Then
       Do
          Call Read.Record(RoomInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          Temp3!=MessWorkRecord6.Room
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             MessWorkRecord6.Room=Temp1!
             Call Write.Record(RoomInvFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Room inventory file repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1a:
 VarZ2!=VarZ2!+1!
 Call Read.Record(RoomInvFile,Temp2!)
 MessWorkRecord6.Next=SFalse
 Call Write.Record(RoomInvFile,Temp2!)
 RoomRecord.Last=Temp2!
 Call Write.Record(RoomFile,Temp1!)
 Return
Truncate2a:
 VarZ2!=VarZ2!+1!
 Call Read.Record(RoomInvFile,Temp2!)
 MessWorkRecord6.Prev=SFalse
 Call Write.Record(RoomInvFile,Temp2!)
 RoomRecord.First=Temp2!
 Call Write.Record(RoomFile,Temp1!)
 Return
ErrExit65a:
 Exit Sub
ErrResume65a:
 Resume ErrExit65a
End Sub

Sub Repair.Monsters
 On Local Error Goto ErrResume65b
 Color 14,0
 Print "Making backup of monster inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"MONINV2.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(MonInvFile)/MessWorkRecLen6
    Call Read.Record(MonInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 15,0
 Print "Repairing monster inventory file.."
 Var4!=SFalse
 VarZ1!=SFalse
 For Temp1!=1! To Lof(MonsterFile)/MonsterRecLen
    Call Read.Record(MonsterFile,Temp1!)
    Temp2!=MonsterRecord.First
    Temp3!=MonsterRecord.Last
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(MonInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Or MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             MessWorkRecord6.Next=SFalse
             Call Write.Record(MonInvFile,Temp2!)
          Endif
       Else
          Call Read.Record(MonInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             Call Write.Record(MonInvFile,Temp2!)
          Endif
          Call Read.Record(MonInvFile,Temp3!)
          If MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Next=SFalse
             Call Write.Record(MonInvFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(MonsterFile)/MonsterRecLen
    VarY1!=0!
    Call Read.Record(MonsterFile,Temp1!)
    Temp2!=MonsterRecord.First
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1b
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(MonsterFile)/MonsterRecLen
    VarY1!=0!
    Call Read.Record(MonsterFile,Temp1!)
    Temp2!=MonsterRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2b
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(MonsterFile)/MonsterRecLen
    Call Read.Record(MonsterFile,Temp1!)
    Temp2!=MonsterRecord.First
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Prev Then
                Gosub Truncate1b
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(MonsterFile)/MonsterRecLen
    Call Read.Record(MonsterFile,Temp1!)
    Temp2!=MonsterRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Next Then
                Gosub Truncate2b
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(MonsterFile)/MonsterRecLen
    Call Read.Record(MonsterFile,Temp1!)
    Temp2!=MonsterRecord.First
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          Temp3!=MessWorkRecord6.Index
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             MessWorkRecord6.Index=Temp1!
             Call Write.Record(MonInvFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Monster inventory file repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1b:
 VarZ2!=VarZ2!+1!
 Call Read.Record(MonInvFile,Temp2!)
 MessWorkRecord6.Next=SFalse
 Call Write.Record(MonInvFile,Temp2!)
 MonsterRecord.Last=Temp2!
 Call Write.Record(MonsterFile,Temp1!)
 Return
Truncate2b:
 VarZ2!=VarZ2!+1!
 Call Read.Record(MonInvFile,Temp2!)
 MessWorkRecord6.Prev=SFalse
 Call Write.Record(MonInvFile,Temp2!)
 MonsterRecord.First=Temp2!
 Call Write.Record(MonsterFile,Temp1!)
 Return
ErrExit65b:
 Exit Sub
ErrResume65b:
 Resume ErrExit65b
End Sub

Sub Repair.Nonplayers
 On Local Error Goto ErrResume65d
 Color 14,0
 Print "Making backup of nonplayer inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"MONINV3.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(MonInvFile)/MessWorkRecLen6
    Call Read.Record(MonInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 15,0
 Print "Repairing nonplayer inventory file.."
 Var4!=SFalse
 VarZ1!=SFalse
 For Temp1!=1! To Lof(NonplayerFile)/MonsterRecLen
    Call Read.Record(NonplayerFile,Temp1!)
    Temp2!=MonsterRecord.First
    Temp3!=MonsterRecord.Last
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(MonInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Or MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             MessWorkRecord6.Next=SFalse
             Call Write.Record(MonInvFile,Temp2!)
          Endif
       Else
          Call Read.Record(MonInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             Call Write.Record(MonInvFile,Temp2!)
          Endif
          Call Read.Record(MonInvFile,Temp3!)
          If MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Next=SFalse
             Call Write.Record(MonInvFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(NonplayerFile)/MonsterRecLen
    VarY1!=0!
    Call Read.Record(NonplayerFile,Temp1!)
    Temp2!=MonsterRecord.First
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(NonplayerFile)/MonsterRecLen
    VarY1!=0!
    Call Read.Record(NonplayerFile,Temp1!)
    Temp2!=MonsterRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(NonplayerFile)/MonsterRecLen
    Call Read.Record(NonplayerFile,Temp1!)
    Temp2!=MonsterRecord.First
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Prev Then
                Gosub Truncate1
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(NonplayerFile)/MonsterRecLen
    Call Read.Record(NonplayerFile,Temp1!)
    Temp2!=MonsterRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(MonInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Next Then
                Gosub Truncate2
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(NonplayerFile)/MonsterRecLen
    Call Read.Record(NonplayerFile,Temp1!)
    Temp2!=MonsterRecord.First
    If Temp2! Then
       Do
          Call Read.Record(MonInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          Temp3!=Abs(MessWorkRecord6.Index)
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             MessWorkRecord6.Index=-Temp1!
             Call Write.Record(MonInvFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Nonplayer inventory file repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1:
 VarZ2!=VarZ2!+1!
 Call Read.Record(MonInvFile,Temp2!)
 MessWorkRecord6.Next=SFalse
 Call Write.Record(MonInvFile,Temp2!)
 MonsterRecord.Last=Temp2!
 Call Write.Record(NonplayerFile,Temp1!)
 Return
Truncate2:
 VarZ2!=VarZ2!+1!
 Call Read.Record(MonInvFile,Temp2!)
 MessWorkRecord6.Prev=SFalse
 Call Write.Record(MonInvFile,Temp2!)
 MonsterRecord.First=Temp2!
 Call Write.Record(NonplayerFile,Temp1!)
 Return
ErrExit65d:
 Exit Sub
ErrResume65d:
 Resume ErrExit65d
End Sub

Sub Repair.Users
 On Local Error Goto ErrResume11a
 Color 14,0
 Print "Making backup of user inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"USERINV2.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(UserInvFile)/MessWorkRecLen6
    Call Read.Record(UserInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 15,0
 Print "Repairing user inventory file.."
 Temp5!=SFalse
 VarZ1!=SFalse
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.First
    Temp3!=UserRecord.Last
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(UserInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Or MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             MessWorkRecord6.Next=SFalse
             Call Write.Record(UserInvFile,Temp2!)
          Endif
       Else
          Call Read.Record(UserInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             Call Write.Record(UserInvFile,Temp2!)
          Endif
          Call Read.Record(UserInvFile,Temp3!)
          If MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Next=SFalse
             Call Write.Record(UserInvFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    VarY1!=0!
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.First
    If Temp2! Then
       Do
          Call Read.Record(UserInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(UserInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1c
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    VarY1!=0!
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(UserInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(UserInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2c
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.First
    If Temp2! Then
       Do
          Call Read.Record(UserInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(UserInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Prev Then
                Gosub Truncate1c
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(UserInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(UserInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Next Then
                Gosub Truncate2c
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.First
    If Temp2! Then
       Do
          Call Read.Record(UserInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          Temp3!=MessWorkRecord6.User
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             MessWorkRecord6.User=Temp1!
             Call Write.Record(UserInvFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="User inventory file repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1c:
 VarZ2!=VarZ2!+1!
 Call Read.Record(UserInvFile,Temp2!)
 MessWorkRecord6.Next=SFalse
 Call Write.Record(UserInvFile,Temp2!)
 UserRecord.Last=Temp2!
 Call Write.Record(UserFile,Temp1!)
 Return
Truncate2c:
 VarZ2!=VarZ2!+1!
 Call Read.Record(UserInvFile,Temp2!)
 MessWorkRecord6.Prev=SFalse
 Call Write.Record(UserInvFile,Temp2!)
 UserRecord.First=Temp2!
 Call Write.Record(UserFile,Temp1!)
 Return
ErrExit11a:
 Exit Sub
ErrResume11a:
 Resume ErrExit11a
End Sub

Sub Repair.Teams
 On Local Error Goto ErrResume65c
 Color 14,0
 Print "Making backup of team inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"TEAMINV2.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(TeamInvFile)/MessWorkRecLen6
    Call Read.Record(TeamInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 15,0
 Print "Repairing team inventory file.."
 Var4!=SFalse
 VarZ1!=SFalse
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.First
    Temp3!=TeamRecord.Last
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(TeamInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Or MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             MessWorkRecord6.Next=SFalse
             Call Write.Record(TeamInvFile,Temp2!)
          Endif
       Else
          Call Read.Record(TeamInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             Call Write.Record(TeamInvFile,Temp2!)
          Endif
          Call Read.Record(TeamInvFile,Temp3!)
          If MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Next=SFalse
             Call Write.Record(TeamInvFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    VarY1!=0!
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.First
    If Temp2! Then
       Do
          Call Read.Record(TeamInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(TeamInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1d
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    VarY1!=0!
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(TeamInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(TeamInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2d
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.First
    If Temp2! Then
       Do
          Call Read.Record(TeamInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(TeamInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Prev Then
                Gosub Truncate1d
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(TeamInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(TeamInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Next Then
                Gosub Truncate2d
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.First
    If Temp2! Then
       Do
          Call Read.Record(TeamInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          Temp3!=MessWorkRecord6.User
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             MessWorkRecord6.User=Temp1!
             Call Write.Record(TeamInvFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Team inventory file repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1d:
 VarZ2!=VarZ2!+1!
 Call Read.Record(TeamInvFile,Temp2!)
 MessWorkRecord6.Next=SFalse
 Call Write.Record(TeamInvFile,Temp2!)
 TeamRecord.Last=Temp2!
 Call Write.Record(TeamFile,Temp1!)
 Return
Truncate2d:
 VarZ2!=VarZ2!+1!
 Call Read.Record(TeamInvFile,Temp2!)
 MessWorkRecord6.Prev=SFalse
 Call Write.Record(TeamInvFile,Temp2!)
 TeamRecord.First=Temp2!
 Call Write.Record(TeamFile,Temp1!)
 Return
ErrExit65c:
 Exit Sub
ErrResume65c:
 Resume ErrExit65c
End Sub

Sub Add.List.Node(VarZ!)
 On Local Error Goto ErrorTrp27e
 If RoomRecord.First=SFalse Then
    RoomRecord.First=VarZ!
    RoomRecord.Last=VarZ!
    Call Write.Record(RoomFile,Temp!)
    MessWorkRecord6.Prev=SFalse
    MessWorkRecord6.Next=SFalse
    Call Write.Record(RoomInvFile,VarZ!)
    Exit Sub
 Endif
 MessWorkRecord6.Prev=RoomRecord.Last
 MessWorkRecord6.Next=SFalse
 Call Write.Record(RoomInvFile,VarZ!)
 Call Read.Record(RoomInvFile,RoomRecord.Last)
 MessWorkRecord6.Next=VarZ!
 Call Write.Record(RoomInvFile,RoomRecord.Last)
 Call Read.Record(RoomInvFile,VarZ!)
 RoomRecord.Last=VarZ!
 Call Write.Record(RoomFile,Temp!)
ErrorRsm27e:
 Exit Sub
ErrorTrp27e:
 Resume ErrorRsm27e
End Sub

Sub Search.Mess2(Var)
 On Local Error Goto ErrMain40
 Var=False
 For VarX=1 To MaxNodes+1
    If VarX<=Lof(MessWorkFile1)/MessWorkRecLen1 Then
       Call Read.Message.Record(MessWorkFile1,VarX)
       If MessWorkRecord1.ActiveNode Then
          Var=-1
          Exit Sub
       Endif
       If MessWorkRecord1.UserIndex>SFalse Then
          Var=-1
          Exit Sub
       Endif
    Endif
 Next
MainExit40:
 Exit Sub
ErrMain40:
 Resume MainExit40
End Sub

Sub Open.Arrays
 On Local Error Goto Array.Error
 InregsX.AX=&H1000
 Call InterruptX(&H2F,InregsX,OutregsX)
 If (OutregsX.AX And &HFF)=&HFF Then
    Share.Installed=True
 Else
    Share.Installed=False
 Endif
 Redim Training.Stats(1 To MaxClassNames,1 To MaxTrainStats) As Integer
 Exit Sub
Array.Error:
 Color 7,0
 Print "Error opening arrays. Free more RAM."
 Call Terminate.Program
End Sub

Sub Get.Config
 On Local Error Goto Config.Error
 DND.Path=Environ$("DNDBBS")
 If DND.Path<>Nul Then
    If Right$(DND.Path,1)<>"\" Then
       DND.Path=DND.Path+"\"
    Endif
 Endif
 FileName=DND.Path+"DND"+NodeX+".CFG"
 Close #TempFile2
 Open FileName For Input Shared As #TempFile2
 Line Input #TempFile2,Var$
 For Temp1=1 To MaxConfigArray1
    Input #TempFile2,Var!
 Next
 For Temp1=1 To MaxConfigArray2
    Input #TempFile2,Var%
    If Temp1=132 Then
       Time.Override=Var%
    Endif
 Next
 For Temp1=1 To MaxConfigArray3
    Line Input #TempFile2,Var$
    Select Case Temp1
    Case 11
       Data.Path1=Var$
    Case 13
       MonTalk.FileName=Var$
    Case 15
       File.Extension1=Var$
    Case 16
       Room.FileName=Var$
    Case 17
       Object.FileName=Var$
    Case 18
       Monster.FileName=Var$
    Case 19
       Treasure.FileName=Var$
    Case 21
       User.FileName=Var$
    Case 22
       NonPlayer.FileName=Var$
    Case 51
       Usage.FileName=Var$
    Case 53
       Data.Path3=Var$
    Case 54
       Data.Path4=Var$
    Case 57
       Team.FileName=Var$
    Case 58
       Public.FileName=Var$
    Case 59
       Message.Base.FileName=Var$
    Case 60
       Private.FileName=Var$
    Case 62
       File.Extension2=Var$
    Case 68
       MessWork.FileName=Var$
    Case 73
       Log.Filename=Var$
    Case 80
       Container.FileName=Var$
    Case 86
       UserInv.FileName=Var$
    Case 87
       CtnInv.FileName=Var$
    Case 88
       TeamInv.FileName=Var$
    Case 89
       RoomInv.FileName=Var$
    Case 90
       MonInv.FileName=Var$
    Case 93
       Room.Desc.FileName=Var$
    Case 96
       Bank.FileName=Var$
    Case 98
       InterestRate3=Csng(Val(Var$))
    Case 99
       Bank.Log.FileName=Var$
    Case 100
       Log.Extension=Var$
    End Select
 Next
 For Temp1=1 To 10
    For Temp2=1 To 4
       Input #TempFile2,Training.Stats(Temp1,Temp2)
    Next
 Next
 Exit Sub
Config.Error:
 Var2=Err
 Color 15,0
 Print "Error reading "+FileName+". Run Dndcnfg."
 Color 7, 0
 Call Terminate.Program
End Sub

Sub Increase.Files
 On Local Error Goto Increase.Error
 Close
 InregsX.AX=&H6200
 Call InterruptX(&H21,InregsX,OutregsX)
 PSP.Segment=OutregsX.BX
 Def Seg=PSP.Segment
 Command.Line=&H80
 Command.Tail=Command.Line+60
 For Var=1 To 54
    Poke Command.Tail+Var-1,&HFF
 Next
 For Var=1 To 4
    File.Handle=Peek(&H18+Var-1)
    Poke Command.Tail+Var-1,File.Handle
 Next
 Poke &H32,54
 Poke &H34,Command.Tail
 Def Seg
 Close
 Exit Sub
Increase.Error:
 Color 7,0
 Print "Error increasing file handles."
 Print "Increase files= in config.sys or config.nt, or run Dndcnfg."
 Call Terminate.Program
End Sub

Sub Make.FileNames
 On Local Error Goto Config.Error2
 Out2=Environ$("DNDDAT")
 If Out2<>Nul Then
    If Right$(Out2,1)<>"\" Then
       Out2=Out2+"\"
    Endif
    Data.Path1=Out2
 Endif
 Out2=Environ$("DNDTEMP")
 If Out2<>Nul Then
    If Right$(Out2,1)<>"\" Then
       Out2=Out2+"\"
    Endif
    Data.Path3=Out2
 Endif
 Out2=Environ$("DNDMESS")
 If Out2<>Nul Then
    If Right$(Out2,1)<>"\" Then
       Out2=Out2+"\"
    Endif
    Data.Path4=Out2
 Endif
 User.FileName=Data.Path1+User.FileName+File.Extension1
 NonPlayer.FileName=Data.Path1+NonPlayer.FileName+File.Extension1
 Room.FileName=Data.Path1+Room.FileName+File.Extension1
 Object.FileName=Data.Path1+Object.FileName+File.Extension1
 Monster.FileName=Data.Path1+Monster.FileName+File.Extension1
 Treasure.FileName=Data.Path1+Treasure.FileName+File.Extension1
 MonTalk.FileName=Data.Path1+MonTalk.FileName+File.Extension1
 Team.FileName=Data.Path1+Team.FileName+File.Extension1
 Container.FileName=Data.Path1+Container.FileName+File.Extension1
 Message.Base.FileName=Data.Path4+Message.Base.FileName+File.Extension1
 UserInv.FileName=Data.Path1+UserInv.FileName+File.Extension1
 CtnInv.FileName=Data.Path1+CtnInv.FileName+File.Extension1
 TeamInv.FileName=Data.Path1+TeamInv.FileName+File.Extension1
 RoomInv.FileName=Data.Path1+RoomInv.FileName+File.Extension1
 MonInv.FileName=Data.Path1+MonInv.FileName+File.Extension1
 Room.Desc.FileName=Data.Path1+Room.Desc.FileName+File.Extension1
 Usage.FileName=Data.Path1+Usage.FileName+File.Extension1
 Log.FileName=Data.Path1+Log.FileName+File.Extension1
 MessWork.FileName=Data.Path3+MessWork.FileName
 Exit Sub
Config.Error2:
 Var2=Err
 Color 15,0
 Print "Error making filename."
 Print "Increase files= in config.sys, config.nt, or run Dndcnfg."
 Color 7,0
 Call Terminate.Program
End Sub

Sub Open.Files
 On Local Error Goto Open.Error
 Close
 BufferRecLen=Len(BufferRecord)
 LogRecLen=Len(LogRecord)
 ContainerRecLen=Len(ContainerRecord)
 MessBaseRecLen=Len(MessageBaseRecord)
 MessageRecLen=Len(BufferRecord)
 MonsterRecLen=Len(MonsterRecord)
 NewMessRecLen=Len(NewMessages)
 TableRecLen=Len(TableRecord)
 UserRecLen=Len(UserRecord)
 UserProfileRecLen=Len(UserProfile)
 MonTalkRecLen=Len(BufferRecord)
 NonPlayerRecLen=Len(MonsterRecord)
 ObjectRecLen=Len(ObjectRecord)
 RoomDescLen=Len(BufferRecord)
 RoomRecLen=Len(RoomRecord)
 TeamRecLen=Len(TeamRecord)
 TreasureRecLen=Len(TreasureRecord)
 MessWorkRecLen1=Len(MessWorkRecord1)
 MessWorkRecLen2=Len(MessWorkRecord2)
 MessWorkRecLen3=Len(MessWorkRecord3)
 MessWorkRecLen4=Len(MessWorkRecord4)
 MessWorkRecLen5=Len(MessWorkRecord5)
 MessWorkRecLen6=Len(MessWorkRecord6)
 MessWorkRecLen7=Len(MessWorkRecord7)
 FileName=DND.Path+"ACCOUNTS.SIC"
 Open FileName For Random Shared As #SicFile Len=UserProfileRecLen
 FileName=User.FileName
 Open FileName For Random Shared As #UserFile Len=UserRecLen
 FileName=NonPlayer.FileName
 Open FileName For Random Shared As #NonPlayerFile Len=NonPlayerRecLen
 FileName=Room.FileName
 Open FileName For Random Shared As #RoomFile Len=RoomRecLen
 FileName=Object.FileName
 Open FileName For Random Shared As #ObjectFile Len=ObjectRecLen
 FileName=Monster.FileName
 Open FileName For Random Shared As #MonsterFile Len=MonsterRecLen
 FileName=Treasure.FileName
 Open FileName For Random Shared As #TreasureFile Len=TreasureRecLen
 FileName=MonTalk.FileName
 Open FileName For Random Shared As #MonTalkFile Len=MonTalkRecLen
 FileName=Team.FileName
 Open FileName For Random Shared As #TeamFile Len=TeamRecLen
 FileName=Container.FileName
 Open FileName For Random Shared As #ContainerFile Len=ContainerRecLen
 FileName=Message.Base.FileName
 Open FileName For Random Shared As #MessBaseFile Len=MessBaseRecLen
 FileName=UserInv.FileName
 Open FileName For Random Shared As #UserInvFile Len=MessWorkRecLen6
 FileName=CtnInv.FileName
 Open FileName For Random Shared As #CtnInvFile Len=MessWorkRecLen6
 FileName=TeamInv.FileName
 Open FileName For Random Shared As #TeamInvFile Len=MessWorkRecLen6
 FileName=RoomInv.FileName
 Open FileName For Random Shared As #RoomInvFile Len=MessWorkRecLen6
 FileName=MonInv.FileName
 Open FileName For Random Shared As #MonInvFile Len=MessWorkRecLen6
 FileName=Room.Desc.FileName
 Open FileName For Random Shared As #RoomDescFile Len=RoomDescLen
 FileName=MessWork.FileName+"1"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile1 Len=MessWorkRecLen1
 FileName=MessWork.FileName+"2"+File.Extension1
 Open FileName For Random Shared As #MessWorkFile2 Len=MessWorkRecLen2
 FileName=DND.Path+"PACK"+Log.Extension
 Open Filename For Append As #LogFile
 Exit Sub
Open.Error:
 Var2=Err
 Color 15,0
 Print "Error opening "+FileName+"."
 Print "Increase files= in config.sys, config.nt, or run Dndcnfg."
 Color 7,0
 Call Terminate.Program
End Sub
