 Rem File: Dndpack2 for Dndbbs Version v5.0a Release r2.0
 Rem $Include: 'Dndpack.inc'

Sub Pack.Containers
 On Local Error Goto ErrResume121
 Call Repair.Room.Containers
 Call Repair.User.Containers
 Call Repair.Team.Containers
 Call Repair.Within.Containers
 Call Repair.Container.Inventory(1)
 Color 14,0
 Print "Making backup of container file..."
 FileName=Left$(Container.Filename,Instr(Container.Filename,"."))+"bak"
 Close #TempFile1
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA!=Lof(ContainerFile)
 TempC!=Lof(ContainerFile)/ContainerRecLen
 Open FileName For Random Shared As #TempFile1 Len=ContainerRecLen
 For Temp3!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp3!)
    Temp=False
    If ContainerRecord.WithinContainer=False Then
       Var1!=ContainerRecord.RoomNumber
       Var2!=ContainerRecord.UserNumber
       If Var1!=SFalse And Var2!=SFalse Then
          Temp=True
       Endif
       If Var1!>Lof(RoomFile)/RoomRecLen Then
          Temp=True
       Endif
       If Var2!>Lof(UserFile)/UserRecLen Then
          Temp=True
       Endif
       If Var2!>SFalse And Var2!<=Lof(UserFile)/UserRecLen Then
          Call Read.Record(UserFile,Var2!)
          Out3=UserRecord.CodeName
          If Left$(Out3,9)=Deleted$ Then
             Temp=True
          Endif
       Endif
    Endif
    If ContainerRecord.DeletedContainer Then
       Temp=True
    Endif
    If Temp Then
       Call Delete.Container.Contents(Temp3!)
       ContainerRecord.DeletedContainer=True
    Endif
    Call Write.TempFile(5,Temp3!)
 Next
 FileName=Container.Filename
 Close #ContainerFile
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #ContainerFile Len=ContainerRecLen
 Color 12,0
 Print "Packing container file.."
 ' pack room containers
 For Temp5!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp5!)
    Temp4!=RoomRecord.First2
    If Temp4! Then
       RoomRecord.First2=SFalse
       RoomRecord.Last2=SFalse
       Call Write.Record(RoomFile,Temp5!)
       Do
          Call Read.TempFile(5,Temp4!)
          Temp6!=ContainerRecord.Next
          If ContainerRecord.DeletedContainer=False Then
             If ContainerRecord.WithinContainer=False Then
                If Rtrim$(ContainerRecord.ContainerName)<>Nul Then
                   Temp7!=Lof(ContainerFile)/ContainerRecLen+1!
                   Call Add.Room.Container(Temp7!)
                   Call Move.Container.Contents(Temp4!,Temp7!)
                Endif
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Next
 ' pack user containers
 For Temp5!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp5!)
    Temp4!=UserRecord.First2
    If Temp4! Then
       UserRecord.First2=SFalse
       UserRecord.Last2=SFalse
       Call Write.Record(UserFile,Temp5!)
       Do
          Call Read.TempFile(5,Temp4!)
          Temp6!=ContainerRecord.Next
          If ContainerRecord.DeletedContainer=False Then
             If ContainerRecord.WithinContainer=False Then
                If Rtrim$(ContainerRecord.ContainerName)<>Nul Then
                   Temp7!=Lof(ContainerFile)/ContainerRecLen+1!
                   Call Add.User.Container(Temp7!)
                   Call Move.Container.Contents(Temp4!,Temp7!)
                Endif
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Next
 ' pack team containers
 For Temp5!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp5!)
    Temp4!=TeamRecord.First2
    If Temp4! Then
       TeamRecord.First2=SFalse
       TeamRecord.Last2=SFalse
       Call Write.Record(TeamFile,Temp5!)
       Do
          Call Read.TempFile(5,Temp4!)
          Temp6!=ContainerRecord.Next
          If ContainerRecord.DeletedContainer=False Then
             If ContainerRecord.WithinContainer=False Then
                If Rtrim$(ContainerRecord.ContainerName)<>Nul Then
                   Temp7!=Lof(ContainerFile)/ContainerRecLen+1!
                   Call Add.Team.Container(Temp7!)
                   Call Move.Container.Contents(Temp4!,Temp7!)
                Endif
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Next
 ' pack containers within containers
 Temp5!=SFalse
 Do
    Temp5!=Temp5!+1!
    If Temp5!>Lof(ContainerFile)/ContainerRecLen Then
       Exit Do
    Endif
    Call Read.Record(ContainerFile,Temp5!)
    Temp4!=ContainerRecord.First2
    If Temp4! Then
       ContainerRecord.First2=SFalse
       ContainerRecord.Last2=SFalse
       Call Write.Record(ContainerFile,Temp5!)
       Do
          Call Read.TempFile(5,Temp4!)
          Temp6!=ContainerRecord.Next
          If ContainerRecord.DeletedContainer=False Then
             If ContainerRecord.WithinContainer Then
                If Rtrim$(ContainerRecord.ContainerName)<>Nul Then
                   Temp7!=Lof(ContainerFile)/ContainerRecLen+1!
                   Call Write.Record(ContainerFile,Temp7!)
                   Call Add.Within.Container(Temp7!)
                   Call Move.Container.Contents(Temp4!,Temp7!)
                Endif
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Loop
 Call Repair.Container.Inventory(2)
 Color 14,0
 Print "Making backup of container inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"CTNINV.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 TempA2!=Lof(CtnInvFile)
 TempC2!=Lof(CtnInvFile)/MessWorkRecLen6
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(CtnInvFile)/MessWorkRecLen6
    Call Read.Record(CtnInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 12,0
 Print "Packing container inventory file.."
 Close #CtnInvFile
 FileName=CtnInv.FileName
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #CtnInvFile Len=MessWorkRecLen6
 For Temp5!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp5!)
    Temp4!=ContainerRecord.First
    If Temp4! Then
       ContainerRecord.First=SFalse
       ContainerRecord.Last=SFalse
       Call Write.Record(ContainerFile,Temp5!)
       Do
          Call Read.TempFile(7,Temp4!)
          Temp6!=MessWorkRecord6.Next
          Temp7!=Lof(CtnInvFile)/MessWorkRecLen6+1!
          Call Add.List.Node5(Temp7!)
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Next
 TempC!=TempC!-Lof(ContainerFile)/ContainerRecLen
 TempC2!=TempC2!-Lof(CtnInvFile)/MessWorkRecLen6
 TempD!=TempD!+TempC!+TempC2!
 TempA!=TempA!-Lof(ContainerFile)
 TempA2!=TempA2!-Lof(CtnInvFile)
 TempB!=TempB!+TempA!+TempA2!
ErrExit121:
 Exit Sub
ErrResume121:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Pack.Containers"
 Resume ErrExit121
End Sub

Sub Delete.Container.Contents(VarX!)
 On Local Error Goto ErrResume12z
 ContainerRecord.First=SFalse
 ContainerRecord.Last=SFalse
 For VarQ!=1! To Lof(CtnInvFile)/MessWorkRecLen6
    Call Read.Record(CtnInvFile,VarQ!)
    If MessWorkRecord6.Index=VarX! Then
       MessWorkRecord6.User=SFalse
       MessWorkRecord6.Index=SFalse
       MessWorkRecord6.Charges=False
       MessWorkRecord6.Plus=False
       MessWorkRecord6.Room=SFalse
       MessWorkRecord6.Prev=SFalse
       MessWorkRecord6.Next=SFalse
       Call Write.Record(CtnInvFile,VarQ!)
    Endif
 Next
ErrExit12z:
 Exit Sub
ErrResume12z:
 Resume ErrExit12z
End Sub

Sub Move.Container.Contents(Var1!,Var2!)
 On Local Error Goto ErrResume12x
 For VarQ!=1! To Lof(CtnInvFile)/MessWorkRecLen6
    Call Read.Record(CtnInvFile,VarQ!)
    If MessWorkRecord6.Index=Var1! Then
       MessWorkRecord6.Index=Var2!
       Call Write.Record(CtnInvFile,VarQ!)
    Endif
 Next
ErrExit12x:
 Exit Sub
ErrResume12x:
 Resume ErrExit12x
End Sub

Sub Add.Within.Container(VarQ!)
 On Local Error Goto ErrTrap40a
 Call Read.Record(ContainerFile,Temp5!)
 If ContainerRecord.First2=SFalse Then
    ContainerRecord.First2=VarQ!
    ContainerRecord.Last2=VarQ!
    Call Write.Record(ContainerFile,Temp5!)
    Call Read.Record(ContainerFile,VarQ!)
    ContainerRecord.Prev=SFalse
    ContainerRecord.Next=SFalse
    Call Write.Record(ContainerFile,VarQ!)
 Else
    VarR!=ContainerRecord.Last2
    Call Read.Record(ContainerFile,VarQ!)
    ContainerRecord.Prev=VarR!
    ContainerRecord.Next=SFalse
    Call Write.Record(ContainerFile,VarQ!)
    Call Read.Record(ContainerFile,VarR!)
    ContainerRecord.Next=VarQ!
    Call Write.Record(ContainerFile,VarR!)
    Call Read.Record(ContainerFile,Temp5!)
    ContainerRecord.Last2=VarQ!
    Call Write.Record(ContainerFile,Temp5!)
    Call Read.Record(ContainerFile,VarQ!)
 Endif
ErrResume40a:
 Exit Sub
ErrTrap40a:
 Resume ErrResume40a
End Sub

Sub Add.User.Container(VarA!)
 On Local Error Goto ErrResume141h
 ContainerRecord.SwapFlag=False
 If UserRecord.First2=SFalse Then
    UserRecord.First2=VarA!
    UserRecord.Last2=VarA!
    Call Write.Record(UserFile,Temp5!)
    ContainerRecord.Prev=SFalse
    ContainerRecord.Next=SFalse
    Call Write.Record(ContainerFile,VarA!)
    Exit Sub
 Endif
 ContainerRecord.Prev=UserRecord.Last2
 ContainerRecord.Next=SFalse
 Call Write.Record(ContainerFile,VarA!)
 Call Read.Record(ContainerFile,UserRecord.Last2)
 ContainerRecord.Next=VarA!
 Call Write.Record(ContainerFile,UserRecord.Last2)
 Call Read.Record(ContainerFile,VarA!)
 UserRecord.Last2=VarA!
 Call Write.Record(UserFile,Temp5!)
ErrExit141h:
 Exit Sub
ErrResume141h:
 Resume ErrExit141h
End Sub

Sub Add.Team.Container(VarA!)
 On Local Error Goto ErrResume141i
 If TeamRecord.First2=SFalse Then
    TeamRecord.First2=VarA!
    TeamRecord.Last2=VarA!
    Call Write.Record(TeamFile,Temp5!)
    ContainerRecord.Prev=SFalse
    ContainerRecord.Next=SFalse
    Call Write.Record(ContainerFile,VarA!)
    Exit Sub
 Endif
 ContainerRecord.Prev=TeamRecord.Last2
 ContainerRecord.Next=SFalse
 Call Write.Record(ContainerFile,VarA!)
 Call Read.Record(ContainerFile,TeamRecord.Last2)
 ContainerRecord.Next=VarA!
 Call Write.Record(ContainerFile,TeamRecord.Last2)
 Call Read.Record(ContainerFile,VarA!)
 TeamRecord.Last2=VarA!
 Call Write.Record(TeamFile,Temp5!)
ErrExit141i:
 Exit Sub
ErrResume141i:
 Resume ErrExit141i
End Sub

Sub Add.List.Node5(VarZ!)
 On Local Error Goto ErrorTrp27f
 If ContainerRecord.First=SFalse Then
    ContainerRecord.First=VarZ!
    ContainerRecord.Last=VarZ!
    Call Write.Record(ContainerFile,Temp5!)
    MessWorkRecord6.Prev=SFalse
    MessWorkRecord6.Next=SFalse
    Call Write.Record(CtnInvFile,VarZ!)
    Exit Sub
 Endif
 MessWorkRecord6.Prev=ContainerRecord.Last
 MessWorkRecord6.Next=SFalse
 Call Write.Record(CtnInvFile,VarZ!)
 Call Read.Record(CtnInvFile,ContainerRecord.Last)
 MessWorkRecord6.Next=VarZ!
 Call Write.Record(CtnInvFile,ContainerRecord.Last)
 Call Read.Record(CtnInvFile,VarZ!)
 ContainerRecord.Last=VarZ!
 Call Write.Record(ContainerFile,Temp5!)
ErrorRsm27f:
 Exit Sub
ErrorTrp27f:
 Resume ErrorRsm27f
End Sub

Sub Repair.Room.Containers
 On Local Error Goto ErrResume11x1
 Color 15,0
 Print "Repairing room containers.."
 VarZ1!=SFalse
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.First2
    Temp3!=RoomRecord.Last2
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Or ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
       Else
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
          Call Read.Record(ContainerFile,Temp3!)
          If ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    VarY1!=0!
    Temp2!=RoomRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1f
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
    VarY1!=0!
    Call Read.Record(RoomFile,Room)
    Temp2!=RoomRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2f
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Prev Then
                Gosub Truncate1f
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Next Then
                Gosub Truncate2f
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(RoomFile)/RoomRecLen
    Call Read.Record(RoomFile,Temp1!)
    Temp2!=RoomRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Next
          Temp3!=ContainerRecord.RoomNumber
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             ContainerRecord.RoomNumber=Temp1!
             Call Write.Record(ContainerFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Room containers repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1f:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Next=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 RoomRecord.Last2=Temp2!
 Call Write.Record(RoomFile,Temp1!)
 Return
Truncate2f:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Prev=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 RoomRecord.First2=Temp2!
 Call Write.Record(RoomFile,Temp1!)
 Return
ErrExit11x1:
 Exit Sub
ErrResume11x1:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Repair.Room.Containers"
 Resume ErrExit11x1
End Sub

Sub Repair.User.Containers
 On Local Error Goto ErrResume11x2
 Color 15,0
 Print "Repairing user containers.."
 VarZ1!=SFalse
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.First2
    Temp3!=UserRecord.Last2
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Or ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
       Else
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
          Call Read.Record(ContainerFile,Temp3!)
          If ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    VarY1!=0!
    Temp2!=UserRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1g
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
    VarY1!=0!
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2g
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Prev Then
                Gosub Truncate1g
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Next Then
                Gosub Truncate2g
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(UserFile)/UserRecLen
    Call Read.Record(UserFile,Temp1!)
    Temp2!=UserRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Next
          Temp3!=ContainerRecord.UserNumber
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             ContainerRecord.UserNumber=Temp1!
             Call Write.Record(ContainerFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="User containers repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1g:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Next=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 UserRecord.Last2=Temp2!
 Call Write.Record(UserFile,Temp1!)
 Return
Truncate2g:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Prev=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 UserRecord.First2=Temp2!
 Call Write.Record(UserFile,Temp1!)
 Return
ErrExit11x2:
 Exit Sub
ErrResume11x2:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Repair.User.Containers"
 Resume ErrExit11x2
End Sub

Sub Repair.Team.Containers
 On Local Error Goto ErrResume11x4
 Color 15,0
 Print "Repairing team containers.."
 VarZ1!=SFalse
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.First2
    Temp3!=TeamRecord.Last2
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Or ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
       Else
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
          Call Read.Record(ContainerFile,Temp3!)
          If ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    VarY1!=0!
    Temp2!=TeamRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1i
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
    VarY1!=0!
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2i
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Prev Then
                Gosub Truncate1i
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Next Then
                Gosub Truncate2i
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(TeamFile)/TeamRecLen
    Call Read.Record(TeamFile,Temp1!)
    Temp2!=TeamRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Next
          Temp3!=ContainerRecord.UserNumber
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             ContainerRecord.UserNumber=Temp1!
             Call Write.Record(ContainerFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Team containers repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1i:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Next=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 TeamRecord.Last2=Temp2!
 Call Write.Record(TeamFile,Temp1!)
 Return
Truncate2i:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Prev=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 TeamRecord.First2=Temp2!
 Call Write.Record(TeamFile,Temp1!)
 Return
ErrExit11x4:
 Exit Sub
ErrResume11x4:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Repair.Team.Containers"
 Resume ErrExit11x4
End Sub

Sub Repair.Within.Containers
 On Local Error Goto ErrResume11x3
 Color 15,0
 Print "Repairing containers within containers.."
 VarZ1!=SFalse
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.First2
    Temp3!=ContainerRecord.Last2
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Or ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
       Else
          Call Read.Record(ContainerFile,Temp2!)
          If ContainerRecord.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Prev=SFalse
             Call Write.Record(ContainerFile,Temp2!)
          Endif
          Call Read.Record(ContainerFile,Temp3!)
          If ContainerRecord.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             ContainerRecord.Next=SFalse
             Call Write.Record(ContainerFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    VarY1!=0!
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1h
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    VarY1!=0!
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2h
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.First2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Next
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Prev Then
                Gosub Truncate1h
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.Last2
    If Temp2! Then
       Do
          Call Read.Record(ContainerFile,Temp2!)
          Temp6!=ContainerRecord.Prev
          If Temp6!>SFalse Then
             Call Read.Record(ContainerFile,Temp6!)
             If Temp2!<>ContainerRecord.Next Then
                Gosub Truncate2h
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Containers within containers repaired."
 Print #LogFile,Strng
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1h:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Next=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 Call Read.Record(ContainerFile,Temp1!)
 ContainerRecord.Last2=Temp2!
 Call Write.Record(ContainerFile,Temp1!)
 Return
Truncate2h:
 VarZ2!=VarZ2!+1!
 Call Read.Record(ContainerFile,Temp2!)
 ContainerRecord.Prev=SFalse
 Call Write.Record(ContainerFile,Temp2!)
 Call Read.Record(ContainerFile,Temp1!)
 ContainerRecord.First2=Temp2!
 Call Write.Record(ContainerFile,Temp1!)
 Return
ErrExit11x3:
 Exit Sub
ErrResume11x3:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Repair.Within.Containers"
 Resume ErrExit11x3
End Sub

Sub Repair.Container.Inventory(VarQ)
 On Local Error Goto ErrResume11b
 Color 14,0
 Print "Making backup of container inventory file.."
 Close #TempFile1
 FileName=Data.Path1+"CTNINV"+Mid$(Str$(VarQ),2)+".BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=MessWorkRecLen6
 For Temp5!=1! To Lof(CtnInvFile)/MessWorkRecLen6
    Call Read.Record(CtnInvFile,Temp5!)
    Call Write.TempFile(7,Temp5!)
 Next
 Color 15,0
 Print "Repairing container inventory file.."
 Var4!=SFalse
 VarZ1!=SFalse
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.First
    Temp3!=ContainerRecord.Last
    If Temp2!>SFalse And Temp3!>SFalse Then
       If Temp2!=Temp3! Then
          Call Read.Record(CtnInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Or MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             MessWorkRecord6.Next=SFalse
             Call Write.Record(CtnInvFile,Temp2!)
          Endif
       Else
          Call Read.Record(CtnInvFile,Temp2!)
          If MessWorkRecord6.Prev<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Prev=SFalse
             Call Write.Record(CtnInvFile,Temp2!)
          Endif
          Call Read.Record(CtnInvFile,Temp3!)
          If MessWorkRecord6.Next<>SFalse Then
             VarZ1!=VarZ1!+1!
             MessWorkRecord6.Next=SFalse
             Call Write.Record(CtnInvFile,Temp3!)
          Endif
       Endif
    Endif
 Next
 VarZ2!=SFalse
 Close #TempFile1
 FileName=GetFilename$("TABLE","BK3")
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    VarY1!=0!
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.First
    If Temp2! Then
       Do
          Call Read.Record(CtnInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(CtnInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate1e
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    VarY1!=0!
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(CtnInvFile,Temp2!)
          VarY1!=VarY1!+1!
          Lset S$=Mks$(Temp2!)
          Put #TempFile1,VarY1!
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(CtnInvFile,Temp6!)
             For Temp7!=1! To VarY1!
                Get #TempFile1,Temp7!
                Temp8!=Cvs(S$)
                If Temp6!=Temp8! Then
                   Gosub Truncate2e
                   Exit Do
                Endif
             Next
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Close #TempFile1
 Kill Filename
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.First
    If Temp2! Then
       Do
          Call Read.Record(CtnInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          If Temp6!>SFalse Then
             Call Read.Record(CtnInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Prev Then
                Gosub Truncate1e
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.Last
    If Temp2! Then
       Do
          Call Read.Record(CtnInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Prev
          If Temp6!>SFalse Then
             Call Read.Record(CtnInvFile,Temp6!)
             If Temp2!<>MessWorkRecord6.Next Then
                Gosub Truncate2e
                Exit Do
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 VarZ3!=SFalse
 For Temp1!=1! To Lof(ContainerFile)/ContainerRecLen
    Call Read.Record(ContainerFile,Temp1!)
    Temp2!=ContainerRecord.First
    If Temp2! Then
       Do
          Call Read.Record(CtnInvFile,Temp2!)
          Temp6!=MessWorkRecord6.Next
          Temp3!=MessWorkRecord6.Index
          If Temp3!<>Temp1! Then
             VarZ3!=VarZ3!+1!
             MessWorkRecord6.Index=Temp1!
             Call Write.Record(CtnInvFile,Temp2!)
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp2!=Temp6!
       Loop
    Endif
 Next
 Strng="Container inventory file repaired."
 Print #LogFile,Strng
 If VarQ=1 Then
    Strng=" (container pack)"
    Print #LogFile,Strng
 Endif
 If VarQ=2 Then
    Strng=" (container inventory pack)"
    Print #LogFile,Strng
 Endif
 Strng=" Reset"+Str$(VarZ1!)+" nodes."
 Print #LogFile,Strng
 Strng=" Deleted"+Str$(VarZ2!)+" nodes."
 Print #LogFile,Strng
 Strng=" Repaired"+Str$(VarZ3!)+" nodes."
 Print #LogFile,Strng
 Exit Sub
Truncate1e:
 VarZ2!=VarZ2!+1!
 Call Read.Record(CtnInvFile,Temp2!)
 MessWorkRecord6.Next=SFalse
 Call Write.Record(CtnInvFile,Temp2!)
 ContainerRecord.Last=Temp2!
 Call Write.Record(ContainerFile,Temp1!)
 Return
Truncate2e:
 VarZ2!=VarZ2!+1!
 Call Read.Record(CtnInvFile,Temp2!)
 MessWorkRecord6.Prev=SFalse
 Call Write.Record(CtnInvFile,Temp2!)
 ContainerRecord.First=Temp2!
 Call Write.Record(ContainerFile,Temp1!)
 Return
ErrExit11b:
 Exit Sub
ErrResume11b:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Repair.Container.Inventory"
 Resume ErrExit11b
End Sub

Sub Add.Room.Container(VarA!)
 On Local Error Goto ErrResume141g
 If RoomRecord.First2=SFalse Then
    RoomRecord.First2=VarA!
    RoomRecord.Last2=VarA!
    Call Write.Record(RoomFile,Temp5!)
    ContainerRecord.Prev=SFalse
    ContainerRecord.Next=SFalse
    Call Write.Record(ContainerFile,VarA!)
 Else
    ContainerRecord.Prev=RoomRecord.Last2
    ContainerRecord.Next=SFalse
    Call Write.Record(ContainerFile,VarA!)
    Call Read.Record(ContainerFile,RoomRecord.Last2)
    ContainerRecord.Next=VarA!
    Call Write.Record(ContainerFile,RoomRecord.Last2)
    Call Read.Record(ContainerFile,VarA!)
    RoomRecord.Last2=VarA!
    Call Write.Record(RoomFile,Temp5!)
 Endif
ErrExit141g:
 Exit Sub
ErrResume141g:
 Resume ErrExit141g
End Sub

Sub Clear.Container
 On Local Error Goto ErrResume116a
 ContainerRecord.ContainerName=Nul
 ContainerRecord.ContainerShort=Nul
 ContainerRecord.NamePrefix="in it"
 ContainerRecord.ContainerMax=False
 ContainerRecord.Closed=False
 ContainerRecord.Locked=False
 ContainerRecord.KeyNumber=SFalse
 ContainerRecord.UserNumber=SFalse
 ContainerRecord.RoomNumber=SFalse
 ContainerRecord.DeletedContainer=False
 ContainerRecord.InvisibleContainer=False
 ContainerRecord.Weight=False
 ContainerRecord.WithinContainer=SFalse
 ContainerRecord.Disappears=SFalse
 ContainerRecord.ContainerIndex=SFalse
 ContainerRecord.Size=False
 ContainerRecord.Material=False
 ContainerRecord.Permanent=False
 ContainerRecord.SelfImplodes=False
 ContainerRecord.First=SFalse
 ContainerRecord.Last=SFalse
 ContainerRecord.First2=SFalse
 ContainerRecord.Last2=SFalse
 ContainerRecord.Prefix1=""
 ContainerRecord.Damaged=False
 ContainerRecord.Scanned=False
ErrExit116a:
 Exit Sub
ErrResume116a:
 Resume ErrExit116a
End Sub

Sub Pack.Bank
 On Local Error Goto ErrResume44x
 BankRecLen=Len(BankRecord)
 Close #TempFile1
 FileName=Data.Path1+Bank.FileName+File.Extension1
 Open FileName For Random Shared As #TempFile1 Len=BankRecLen
 ' calculate bank's account interest.
 p2# = DFalse
 Dnow$=DateS$
 Tnow$=Format$(Now,"hh:mm:ss")
 ' search for first bank account record
 f = False
 FOR z! = 1! TO LOF(TempFile1) / BankRecLen
    Get TempFile1,z!,BankRecord
    IF BankRecord.UserIndex = True THEN
       TempX#=BankRecord.Balance ' initial balance
       f = True
       EXIT FOR
    END IF
 NEXT
 IF f THEN
    ' first balance record
    d1$ = BankRecord.DatePost
    t1$ = BankRecord.TimePost
    Gosub Bank.Balance
    a1# = TempX#
    ' search for second bank record
    f = False
    FOR z! = z! + 1! TO LOF(TempFile1) / BankRecLen
       Get TempFile1,z!,BankRecord
       IF BankRecord.UserIndex = True THEN
          f = True
          EXIT FOR
       END IF
    NEXT
    IF f THEN
       DO
          ' next transaction record
          d2$ = BankRecord.DatePost
          t2$ = BankRecord.TimePost
          Gosub Bank.Balance
          a2# = TempX#
          GOSUB Process1
          ' store previous date/time
          d1$ = d2$
          t1$ = t2$
          ' flat rate (no accrued interest).
          a1# = a2#
          ' search for next transaction record
          f = False
          FOR z! = z! + 1! TO LOF(TempFile1) / BankRecLen
             Get TempFile1,z!,BankRecord
             IF BankRecord.UserIndex = True THEN
                f = True
                EXIT FOR
             END IF
          NEXT
          IF f = False THEN
             EXIT DO
          END IF
       LOOP
    END IF
    d2$ = Dnow$
    t2$ = Tnow$
    GOSUB Process1
 END IF
 VarZ#=TempX#
 p3#=DFalse
 MaxDbl#=CDBL(1D+308)
 If TempX#+p2#<=MaxDbl# Then
    p3#=p2#
    TempX#=TempX#+p2#
 Else
    p3#=p2#
 Endif
 ' pack bank.
 Close #TempFile1
 FileName=Data.Path1+Bank.FileName+".BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=BankRecLen
 Close #TempFile2
 FileName2$=Data.Path1+Bank.FileName+File.Extension1
 Open FileName2$ For Random Shared As #TempFile2 Len=BankRecLen
 For Temp5!=1! To Lof(TempFile2)/BankRecLen
    Get TempFile2,Temp5!,BankRecord
    Put TempFile1,Temp5!,BankRecord
 Next
 Close #TempFile2
 If Dir$(FileName2$)<>Nul Then
    Kill FileName2$
 Endif
 Open FileName2$ For Random Shared As #TempFile2 Len=BankRecLen
 For Temp5!=1! To Lof(TempFile1)/BankRecLen
    Get #TempFile1,Temp5!,BankRecord
    If BankRecord.UserIndex>SFalse Then
       If BankRecord.Deleted=False Then
          Temp7!=Lof(TempFile2)/BankRecLen+1!
          Put #TempFile2,Temp7!,BankRecord
       Endif
    Endif
 Next
 ' write bank balance.
 BankRecord.UserIndex = True
 BankRecord.DatePost = Dnow$
 BankRecord.TimePost = Tnow$
 BankRecord.Balance = TempX#
 BankRecord.PostAmount = DFalse
 BankRecord.PostType = "A"
 BankRecord.PostSubType = "A"
 BankRecord.PostSubType2 = False
 BankRecord.From = Nul
 BankRecord.To = Nul
 z! = LOF(TempFile2) / BankRecLen + 1!
 Put TempFile2,z!,BankRecord
 Color 10,0
 Call Amount2(TempX#,Var$)
 Print "Bank balance:"+Var$+" gold."
 ' write bank interest.
 BankRecord.UserIndex = True
 BankRecord.DatePost = Dnow$
 BankRecord.TimePost = Tnow$
 BankRecord.Balance = TempX#
 BankRecord.PostAmount = p3#
 BankRecord.PostType = "I"
 BankRecord.PostSubType = "I"
 BankRecord.PostSubType2 = 1
 BankRecord.From = Nul
 BankRecord.To = Nul
 z! = LOF(TempFile2) / BankRecLen + 1!
 Put TempFile2,z!,BankRecord
 Color 10,0
 Call Amount2(p3#,Var$)
 Print "Bank interest:"+Var$+" gold."
 Close #TempFile1
 Close #TempFile2
 ' roll over log files.
 FileName=Data.Path1+Bank.FileName+"9"+Log.Extension
 If Dir$(FileName)<>Nul Then
    FileName2$=Data.Path1+Bank.Log.FileName+Log.Extension
    Close #TempFile1
    Close #TempFile2
    Open FileName For Input As #TempFile1
    Open FileName2$ For Append As #TempFile2
    Do Until Eof(TempFile1)
       Line Input #TempFile1,Var$
       Print #TempFile2,Var$
    Loop
    Close #TempFile1
    Close #TempFile2
 Endif
 For Var=9 To 1 Step -1
    FileName=Data.Path1+Bank.FileName+Mid$(Str$(Var),2)+Log.Extension
    If Dir$(FileName)<>Nul Then
       Kill FileName
    Endif
    FileName2$=Data.Path1+Bank.FileName+Mid$(Str$(Var-1),2)+Log.Extension
    If Dir$(FileName2$)<>Nul Then
       Gosub Roll.Over.Logfile
    Endif
 Next
 FileName=Data.Path1+Bank.FileName+"0"+Log.Extension
 FileName2$=Data.Path1+Bank.FileName+Log.Extension
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 If Dir$(FileName2$)<>Nul Then
    Gosub Roll.Over.Logfile
 Endif
 Close #TempFile1
 Close #TempFile2
 If Dir$(FileName2$)<>Nul Then
    Kill FileName2$
 Endif
 ' write log file.
 Close #TempFile2
 FileName2$=Data.Path1+Bank.FileName+Log.Extension
 Open FileName2$ For Output Shared As #TempFile2
 Call Amount2(VarZ#,Var$)
 Strng="Bank: Pack; "+Dnow$+", "+Tnow$+"; Bank balance:"+Var$+" gold."
 Print #TempFile2,Strng
 Call Amount2(p3#,Var$)
 Strng="Bank: Pack; "+Dnow$+", "+Tnow$+"; Bank interest:"+Var$+" gold."
 Print #TempFile2,Strng
 Strng="Bank file packed."
 Print #LogFile,Strng
 Call Amount2(TempX#,Var$)
 Strng=" Bank balance:"+Var$+" gold."
 Print #LogFile,Strng
 Call Amount2(p3#,Var$)
 Strng=" Bank interest:"+Var$+" gold."
 Print #LogFile,Strng
 Exit Sub

' copy log files for backup.
Roll.Over.Logfile:
 Close #TempFile1
 Close #TempFile2
 Open FileName For Output As #TempFile1
 Open FileName2$ For Input As #TempFile2
 Do Until Eof(TempFile2)
    Line Input #TempFile2,Var$
    Print #TempFile1,Var$
 Loop
 Close #TempFile1
 Close #TempFile2
 Return

' calculate bank balance.
Bank.Balance:
 TempY#=BankRecord.PostAmount
 Select Case BankRecord.PostType
 Case "C" ' deposit
    MaxDbl#=CDBL(1D+308)
    If TempX#+TempY#<=MaxDbl# Then
       TempX#=TempX#+TempY#
    Endif
 Case "D" ' withdraw
    MaxDbl#=CDBL(1D+308)
    MaxDbl#=-MaxDbl#
    If TempX#-TempY#>=MaxDbl# Then
       TempX#=TempX#-TempY#
    Endif
 End Select
 Return

' subroutine processes yearly interest on a balance for a date/time range.
Process1:
 d1# = cdbl(DateValue(d1$))
 If Val(Left$(t1$,2))>23 Then
    V = Val(Mid$(t1$,1,2))
    V = V MOD 24
    V$ = Right$("00"+Mid$(Str$(V),2), 2)
    Mid$(t1$,1,2)=V$
 Endif
 If Valid.Time(t1$)=0 Then t1$="00:00:00"
 t1# = cdbl(TimeValue(t1$))
 d2# = cdbl(DateValue(d2$))
 If Val(Left$(t2$,2))>23 Then
    V = Val(Mid$(t2$,1,2))
    V = V MOD 24
    V$ = Right$("00"+Mid$(Str$(V),2), 2)
    Mid$(t2$,1,2)=V$
 Endif
 If Valid.Time(t2$)=0 Then t2$="00:00:00"
 t2# = cdbl(TimeValue(t2$))
 d3# = d2# - d1#
 H1% = Hour(t1#)
 M1% = Minute(t1#)
 S1% = Second(t1#)
 t1! = CSNG(H1%) * 3600! + CSNG(M1%) * 60! + CSNG(S1%)
 H2% = Hour(t2#)
 M2% = Minute(t2#)
 S2% = Second(t2#)
 t2! = CSNG(H2%) * 3600! + CSNG(M2%) * 60! + CSNG(S2%)
 ' calculate seconds elapsed from previous login.
 IF d3# = 0# THEN
    t3# = cdbl(t2!) - cdbl(t1!)
 ELSE
    IF d3# >= 1# THEN
       t3# = cdbl(86400!) - cdbl(t1!) + cdbl(t2!)
       t3# = t3# + cdbl(86400!) * (d3# - 1#)
    END IF
 END IF
 ' calculate days in year range.
 L#=365#
 L1=Val(Right$(d1$,4))
 L2=Val(Right$(d2$,4))
 FOR Var=L1 TO L2
    ' calculate leap years.
    f=False
    IF (Var MOD 4)=False THEN
       f=True
       IF (Var MOD 100)=False THEN
          f=False
          IF (Var MOD 400)=False THEN
             f=True
          END IF
       END IF
    END IF
    IF f THEN
       ' check leap year date range.
       d4$="01-01-"+Mid$(Str$(Var),2)
       d5$="12-31-"+Mid$(Str$(Var),2)
       d4#=DateValue(d4$)
       d5#=DateValue(d5$)
       If d1#<=d4# And d2#>=d5# Then
          L#=L#+1# ' add one day.
       Endif
    Endif
 NEXT
 ' calculate interest based on seconds in time interval.
 T#=86400#*L#
 R#=Cdbl(InterestRate3/100!)
 p1#=a1#*t3#/T#*R# ' 365 days @ rate / second.
 p1#=INT(p1#) ' round to one gold.
 ' add to accrued interest.
 IF p1#>0# THEN
    p2#=p2#+p1# ' flatrate (not compounded).
 END IF
 RETURN
ErrExit44x:
 Exit Sub
ErrResume44x:
 Print "Error"+Str$(Err)+" in bank processing."
 Resume ErrExit44x
End Sub

' 00:00:00 - 23:59:59
Function Valid.Time(V$)
 Valid.Time=-1
 If Len(V$)<>8 Then
    Valid.Time=0
    Exit Function
 Endif
 ' scan all chars first
 For V=1 To 8
    Select Case V
    Case 3, 6
       If Mid$(V$,V,1)<>":" Then
          Valid.Time=0
          Exit Function
       Endif
    Case Else
       If Mid$(V$,V,1)>="0" And Mid$(V$,V,1)<="9" Then
          Eat$ = Nul
       Else
          Valid.Time=0
          Exit Function
       Endif
    End Select
 Next
 ' scan values next
 If Val(Mid$(V$,1,2))>=0 And Val(Mid$(V$,1,2))<=23 Then
    Eat$=""
 Else
    Valid.Time=0
    Exit Function
 Endif
 If Val(Mid$(V$,4,2))>=0 And Val(Mid$(V$,4,2))<=59 Then
    Eat$=""
 Else
    Valid.Time=0
    Exit Function
 Endif
 If Val(Mid$(V$,7,2))>=0 And Val(Mid$(V$,7,2))<=59 Then
    Eat$=""
 Else
    Valid.Time=0
    Exit Function
 Endif
End Function

Sub Amount(Var#,Var$)
 If Instr(Str$(Var#),"D") Then
    Var$=Str$(Var#)
 Else
    Var$=" "+Form$(Var#)
 Endif
End Sub

Sub Pack.Bases
 On Local Error Goto ErrResume133
 Color 14,0
 Print "Making backup of message bases file."
 FileName=Left$(Message.Base.Filename,Instr(Message.Base.Filename,"."))+"bak"
 Close #TempFile1
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=MessBaseRecLen
 For Temp3!=1! To Lof(MessBaseFile)/MessBaseRecLen
    Call Read.Record(MessBaseFile,Temp3!)
    Call Write.TempFile(6,Temp3!)
 Next
 FileName=Message.Base.Filename
 Close #MessBaseFile
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #MessBaseFile Len=MessBaseRecLen
 TempZ#=DFalse
 Temp1!=SFalse
 For Temp3!=1! To Lof(TempFile1)/MessBaseRecLen
    Call Read.TempFile(6,Temp3!)
    If MessageBaseRecord.BaseDeleted Then
       TempZ#=TempZ#+1#
    Endif
    If MessageBaseRecord.BaseDeleted=False Then
       Temp1!=Temp1!+1!
       Call Write.Record(MessBaseFile,Temp1!)
    Endif
 Next
 Strng="Message base file packed."
 Print #LogFile,Strng
 Strng=" "+Str$(TempZ#)+" message bases deleted."
 Print #LogFile,Strng
ErrExit133:
 Exit Sub
ErrResume133:
 Resume ErrExit133
End Sub

Sub Pack.Messages
 On Local Error Goto ErrResume139
 Color 12,0
 Print "Packing messages.."
 Temp3!=Lof(MessBaseFile)/MessBaseRecLen+2!
 For Var!=1! To Temp3!
    Select Case Var!
    Case 1!
       TempA$="public"
       TempX$=Public.Filename
    Case 2!
       TempA$="private"
       TempX$=Private.Filename
    Case 3! To Temp3!
       Call Read.Record(MessBaseFile,Temp3!-2!)
       TempA$=Rtrim$(MessageBaseRecord.BaseMessName)
       TempX$=Rtrim$(MessageBaseRecord.BaseFileName)
    End Select

    Close #TableFile, #MessageFile
    FileName=Data.Path4+TempX$+".TBL"
    Open FileName For Random Shared As #TableFile Len=TableRecLen
    FileName=Data.Path4+TempX$+".DAT"
    Open FileName For Random Shared As #MessageFile Len=MessageRecLen

    ' pack new message pointers
    FileName=Data.Path4+TempX$+".NEW"
    Gosub PackNewFile
    FileName=Data.Path4+TempX$+".NW2"
    Gosub PackNewFile
    FileName=Data.Path4+TempX$+".NW3"
    Gosub PackNewFile

    ' pack threads
    Var3!=Lof(TableFile)/TableRecLen
    If Var3!=SFalse Then
       Var3!=1!
    Endif
    Close #TempFile1
    FileName=Data.Path4+TempX$+".BK5"
    Open FileName For Random Shared As #TempFile1 Len=4
    Field #TempFile1,4 As S$
    For VarX!=1! To Var3!
       Call Read.Record(TableFile,VarX!)
       TempZ!=TableRecord.Thread
       Lset S$=Mks$(TempZ!)
       Put #TempFile1,VarX!
    Next
    For VarX!=1! To Var3!
       Call Read.Record(TableFile,VarX!)
       If TableRecord.Killed Then
          Get #TempFile1,VarX!
          VarZ!=Cvs(S$)
          For TempY!=VarX!+1! To Var3!
             Get #TempFile1,TempY!
             If Cvs(S$)=VarX! Then
                Lset S$=Mks$(VarZ!)
                Put #TempFile1,TempY!
                If VarZ!=SFalse Then
                   For TempZ!=TempY!+1! To Var3!
                      Get #TempFile1,TempZ!
                      If Cvs(S$)=TempY! Then
                         Exit For
                      Endif
                   Next
                   If TempZ!>Var3! Then
                      Call Read.Record(TableFile,TempY!)
                      TableRecord.Reply=False
                      Call Write.Record(TableFile,TempY!)
                   Endif
                Endif
             Endif
          Next
          For TempY!=VarX!+1! To Var3!
             Get #TempFile1,TempY!
             VarZ!=Cvs(S$)
             If VarZ!>=VarX! Then
                VarZ!=VarZ!-1!
                Lset S$=Mks$(VarZ!)
                Put #TempFile1,TempY!
             Endif
          Next
       Endif
    Next
    For VarX!=1! To Var3!
       Call Read.Record(TableFile,VarX!)
       Get #TempFile1,VarX!
       TableRecord.Thread=Cvs(S$)
       Call Write.Record(TableFile,VarX!)
    Next

    ' pack messages
    Close #TempFile1
    FileName=Data.Path4+TempX$+".bk1"
    If Dir$(FileName)<>Nul Then
       Kill FileName
    Endif
    Open FileName For Random Shared As #TempFile1 Len=TableRecLen
    For VarX!=1! To Lof(TableFile)/TableRecLen
       Call Read.Record(TableFile,VarX!)
       Call Write.TempFile(1,VarX!)
    Next
    Close #TempFile2
    FileName=Data.Path4+TempX$+".bk2"
    If Dir$(FileName)<>Nul Then
       Kill FileName
    Endif
    Open FileName For Random Shared As #TempFile2 Len=MessageRecLen
    For VarX!=1! To Lof(MessageFile)/MessageRecLen
       Call Read.Record(MessageFile,VarX!)
       Call Write.TempFile(2,VarX!)
    Next
    Close #TableFile, #MessageFile, #TempFile1, #TempFile2
    FileName=Data.Path4+TempX$+".tbl"
    If Dir$(FileName)<>Nul Then
       Kill FileName
    Endif
    FileName=Data.Path4+TempX$+".dat"
    If Dir$(FileName)<>Nul Then
       Kill FileName
    Endif
    FileName=Data.Path4+TempX$+".tbl"
    Open FileName For Random Shared As #TableFile Len=TableRecLen
    FileName=Data.Path4+TempX$+".dat"
    Open FileName For Random Shared As #MessageFile Len=MessageRecLen
    FileName=Data.Path4+TempX$+".bk1"
    Open FileName For Random Shared As #TempFile1 Len=TableRecLen
    FileName=Data.Path4+TempX$+".bk2"
    Open FileName For Random Shared As #TempFile2 Len=MessageRecLen
    VarQ!=SFalse
    TempZ!=SFalse
    TempZ#=DFalse
    For VarX!=1! To Lof(TempFile1)/TableRecLen
       Call Read.TempFile(1,VarX!)
       If TableRecord.Killed Then
          TempZ#=TempZ#+1#
       Endif
       If TableRecord.Killed=False Then
          Temp8!=TableRecord.Start
          Temp9!=Temp8!+Csng(TableRecord.Length)-1!
          VarQ!=VarQ!+1!
          TableRecord.Start=TempZ!+1!
          Call Write.Record(TableFile,VarQ!)
          For TempA!=Temp8! To Temp9!
             Call Read.TempFile(2,TempA!)
             TempZ!=TempZ!+1!
             Call Write.Record(MessageFile,TempZ!)
          Next
       Endif
    Next
    Close #TempFile1
    Close #TempFile2
 Next
 Strng="Message base mail files packed."
 Print #LogFile,Strng
 Strng=" "+Str$(TempZ#)+" messages deleted."
 Print #LogFile,Strng
 Exit Sub

' pack new message pointers
PackNewFile:
 Close #NewFile
 Open FileName For Random Shared As #NewFile Len=NewMessRecLen
 Var2!=Lof(NewFile)/NewMessRecLen
 If Var2!=SFalse Then
    NewMessages.LastMessage=0!
    Call Write.Record(NewFile,1!)
    Exit Sub
 Endif

 Close #TempFile1
 FileName=Data.Path4+TempX$+".BK4"
 Open FileName For Random Shared As #TempFile1 Len=4
 Field #TempFile1,4 As S$

 For Var1!=1! To Var2!
    Call Read.Record(NewFile,Var1!)
    TempZ!=NewMessages.LastMessage
    Lset S$=Mks$(TempZ!)
    Put #TempFile1,Var1!
 Next

 For VarX!=1! To Lof(TableFile)/TableRecLen
    Call Read.Record(TableFile,VarX!)
    If TableRecord.Killed Then
       For Var1!=1! To Var2!
          Get #TempFile1,Var1!
          TempZ!=Cvs(S$)
          If TempZ!<=VarX! Then
             TempZ!=TempZ!-1!
             Lset S$=Mks$(TempZ!)
             Put #TempFile1,Var1!
          Endif
       Next
    Endif
 Next

 For Var1!=1! To Var2!
    Get #TempFile1,Var1!
    TempZ!=Cvs(S$)
    NewMessages.LastMessage=TempZ!
    Call Write.Record(NewFile,Var1!)
 Next
 Close #TempFile1
 Return
ErrExit139:
 Exit Sub
ErrResume139:
 Print "Error packing messages";Err
 Resume ErrExit139
End Sub

Sub Pack.Object.Desc
 ' moves objdesc.dat from \dndbbs to \dndbbs\dnddat (08-07-2020)
 On Local Error Goto ErrResume65e
 Color 14,0
 Print "Making backup of object description file.."
 Close #TempFile1
 FileName=Data.Path1+"OBJDESC.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=BufferRecLen
 Close #ObjDescFile
 FileName=DND.Path+"OBJDESC.DAT"
 VarX$=" moved."
 If Dir$(FileName)="" Then
    VarX$=" copied."
    FileName=Data.Path1+"OBJDESC.DAT"
 Endif
 Open FileName For Random Shared As #ObjDescFile Len=BufferRecLen
 TempA!=Lof(ObjDescFile)
 TempC!=Lof(ObjDescFile)/BufferRecLen
 For Var5!=1! To Lof(ObjDescFile)/BufferRecLen
    Get ObjDescFile,Var5!,BufferRecord
    Put #TempFile1,Var5!,BufferRecord
 Next
 Color 12,0
 Print "Packing object description file.."
 Close #ObjDescFile
 FileName=DND.Path+"OBJDESC.DAT"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 FileName=Data.Path1+"OBJDESC.DAT"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #ObjDescFile Len=BufferRecLen
 Temp5!=SFalse
 VarZ!=0!
 For Var!=1! To Lof(ObjectFile)/ObjectRecLen
    Get ObjectFile,Var!,ObjectRecord
    For Temp5=1 To 19
       Var6!=ObjectRecord.ObjDesc(Temp5)
       If Var6!>SFalse And Var6!<=Lof(TempFile1)/BufferRecLen Then
          Get #TempFile1,Var6!,BufferRecord
          Temp5!=Temp5!+1!
          Put ObjDescFile,Temp5!,BufferRecord
          ObjectRecord.ObjDesc(Temp5)=Temp5!
          VarZ!=VarZ!+1!
       Endif
    Next
    Put ObjectFile,Var!,ObjectRecord
 Next
' TempC!=TempC!-Lof(ObjDescFile)/BufferRecLen
' TempD!=TempD!+TempC!
' TempA!=TempA!-Lof(ObjDescFile)
' TempB!=TempB!+TempA!
 Strng="Object description file packed."
 Print #LogFile,Strng
 Strng=" "+Str$(VarZ!)+" messages"+VarX$
 Print #LogFile,Strng
ErrExit65e:
 Exit Sub
ErrResume65e:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+" packing object description."
 Resume ErrExit65e
End Sub

Sub Pack.Scroll.Desc
 On Local Error Goto ErrResume65f
 Color 14,0
 Print "Making backup of scroll description file.."
 Close #TempFile1
 Close #TempFile2
 Close #TempFile3
 Close #TempFile4
 FileName=DND.Path+"WRITING.BAK"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #TempFile1 Len=LogRecLen

 Close #ObjDescFile
 FileName=DND.Path+"WRITING.LOG"
 Open FileName For Random Shared As #ObjDescFile Len=LogRecLen
 TempA!=Lof(ObjDescFile)
 TempC!=Lof(ObjDescFile)/LogRecLen
 For Var5!=1! To Lof(ObjDescFile)/LogRecLen
    Get #ObjDescFile,Var5!,LogRecord
    Put #TempFile1,Var5!,LogRecord
 Next

 Color 12,0
 Print "Packing scroll description file.."
 Close #ObjDescFile
 FileName=DND.Path+"WRITING.LOG"
 If Dir$(FileName)<>Nul Then
    Kill FileName
 Endif
 Open FileName For Random Shared As #ObjDescFile Len=LogRecLen
 VarZ!=0!
 Temp5!=SFalse
 For Var!=1 To Lof(RoomFile)/RoomRecLen
    Get #RoomFile,Var!,RoomRecord
    Temp4!=RoomRecord.First
    If Temp4! Then
       Do
          Get RoomInvFile,Temp4!,MessWorkRecord6
          Temp6!=MessWorkRecord6.Next
          Temp2!=MessWorkRecord6.Index
          If Temp2!>SFalse And Temp2!<=Lof(TreasureFile)/TreasureRecLen Then
             Get TreasureFile,Temp2!,TreasureRecord
             If TreasureRecord.Scroll=1 Then
                For Var=1 To 4
                   Temp1!=MessWorkRecord6.Desc(Var)
                   If Temp1!>SFalse And Temp1!<=Lof(TempFile1)/LogRecLen Then
                      Get #TempFile1,Temp1!,LogRecord
                      Temp5!=Temp5!+1!
                      Put ObjDescFile,Temp5!,LogRecord
                      MessWorkRecord6.Desc(Var)=Temp5!
                   Endif
                Next
                Put RoomInvFile,Temp4!,MessWorkRecord6
                VarZ!=VarZ!+1!
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Next

 For Var!=1 To Lof(UserFile)/UserRecLen
    Get #UserFile,Var!,UserRecord
    Temp4!=UserRecord.First
    If Temp4! Then
       Do
          Get UserInvFile,Temp4!,MessWorkRecord6
          Temp6!=MessWorkRecord6.Next
          Temp2!=MessWorkRecord6.Index
          If Temp2!>SFalse And Temp2!<=Lof(TreasureFile)/TreasureRecLen Then
             Get TreasureFile,Temp2!,TreasureRecord
             If TreasureRecord.Scroll=1 Then
                For Var=1 To 4
                   Temp1!=MessWorkRecord6.Desc(Var)
                   If Temp1!>SFalse And Temp1!<=Lof(TempFile1)/LogRecLen Then
                      Get #TempFile1,Temp1!,LogRecord
                      Temp5!=Temp5!+1!
                      Put ObjDescFile,Temp5!,LogRecord
                      MessWorkRecord6.Desc(Var)=Temp5!
                   Endif
                Next
                Put UserInvFile,Temp4!,MessWorkRecord6
                VarZ!=VarZ!+1!
             Endif
          Endif
          If Temp6!=SFalse Then
             Exit Do
          Endif
          Temp4!=Temp6!
       Loop
    Endif
 Next
' TempC!=TempC!-Lof(ObjDescFile)/LogRecLen
' TempD!=TempD!+TempC!
' TempA!=TempA!-Lof(ObjDescFile)
' TempB!=TempB!+TempA!
 Strng="Scroll description file packed."
 Print #LogFile,Strng
 Strng=" "+Str$(VarZ!)+" messages copied."
 Print #LogFile,Strng
ErrExit65f:
 Exit Sub
ErrResume65f:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+" packing scroll description."
 Resume ErrExit65f
End Sub

Sub Pack.Coins
 On Local Error Goto ErrResume121z
 Color 14,0
 Print "Making backup of coins data file.."
 Close #TempFile1
 FileName=DND.Path+"coins.dat"
 Open FileName For Random Shared As #TempFile1 Len=16
 Field #TempFile1, 4 As R1$, 8 As G1$, 2 As P1x$, 2 As P2x$
 If Lof(TempFile1)=0 Then Exit Sub
 Close #TempFile2
 FileName2$=DND.Path+"coins.bkp"
 If Dir$(FileName2$)<>"" Then Kill FileName2$
 Color 12,0
 Print "Packing coins data file.."
 Open FileName2$ For Random Shared As #TempFile2 Len=16
 Field #TempFile2, 4 As R2$, 8 As G2$, 2 As P1y$, 2 As P2y$
 VarZ!=0!
 For V!=1! To Lof(TempFile1)/16!
    Get #TempFile1,V!
    If Cvs(R1$)<>0! Then
       Lset R2$=R1$ : Lset G2$=G1$ : Lset P1y$=P1x$ : Lset P2y$=P2x$
       X!=Lof(TempFile2)/16!+1! : Put TempFile2,X!
       VarZ!=VarZ!+1!
    Endif
 Next
 Close TempFile1, TempFile2
 Kill Filename : Name FileName2$ As FileName
 Strng="Coins file packed."
 Print #LogFile,Strng
 Strng=" "+Str$(VarZ!)+" records copied."
 Print #LogFile,Strng
 Exit Sub
ErrExit121z:
 Exit Sub
ErrResume121z:
 Error.Num=Err
 Color 10,0
 Print "Error"+Str$(Error.Num)+": Pack.Coins"
 Resume ErrExit121z
End Sub

Sub Amount2(Var#,Var$)
 VarX$=Ltrim$(Str$(Var#)) ' 1.111D308
 V=Instr(VarX$,"D")
 If V Then
    If Mid$(VarX$,2,1)="." Then
       VarX$=Left$(VarX$,1)+Mid$(VarX$,V)
    Endif
    Var$=" "+VarX$
 Else
    Var$=" "+Form$(Var#)
 Endif
End Sub
