REM File: Import/Export v1.3a for Dndbbs Version v5.0a Release r2.0a 01/10/2022 PD.

REM compile:
REM bc import/e/o;
REM link import,,,vbdos/e;

REM $INCLUDE: 'io10.inc'
Declare Function InkeyX$()

' declare constants
Const More$="-more-"
Const Version$="v1.3a"

' declare common variables
Common Shared Debug As Integer
Common Shared Max.Row As Integer
Common Shared TempX2 As Integer
Common Shared Supported.Call As Integer

' declare spell structure
COMMON SHARED SpellRecord AS SpellType
COMMON SHARED SpellRecLen AS SINGLE

' declare treasure structure
COMMON SHARED TreasureRecord AS TreasureType
COMMON SHARED TreasureRecLen AS SINGLE

' declare name arrays
COMMON SHARED Class.Name() AS STRING * 15
COMMON SHARED InventoryNames() AS STRING * 8
COMMON SHARED ANSIPrefixChar AS STRING

' declare dta filename variable
COMMON SHARED ASCIIZ AS STRING * 260

' declare savescreen arrays
Common Shared Temp.Array1() As Integer
Common Shared Temp.Array2() As Integer

' declare config file constants
Const MaxUserCommands=155
Const MaxDMcommands=20
Const MaxSysopCommands=15
Const MaxNodeCommands=16
Const MaxLetters=26
Const MaxStrips=50

 DECLARE FUNCTION KeyIS()
 DECLARE FUNCTION KeyboardChar$()
 DECLARE FUNCTION KeyboardLine$()
 DECLARE FUNCTION Timeit! ()

Function Timeit!
 t1$ = Format$(Now, "hh:mm:ss") ' seconds past midnight
 t1! = CSNG(INT(VAL(MID$(t1$, 1, 2)))) * 3600! + CSNG(INT(VAL(MID$(t1$, 4, 2)))) * 60! + CSNG(INT(VAL(MID$(t1$, 7, 2))))
 Timeit!=t1!
End Function

' special inkey$ function
Function InkeyX$
 StartTime2# = Timeit!
 Do
    X$ = KeyboardChar$
    If Len(X$) Then
       If X$ = Chr$(0) + Chr$(83) Then
          Debug = Not Debug
       Else
          InkeyX$ = X$
          Exit Function
       Endif
    Endif
    RunTime2# = Timeit! - StartTime2#
    IF RunTime2# < 0# THEN RunTime2# = RunTime2# + 86400#
    IF RunTime2# >= 1# THEN
       StartTime2# = Timeit!
       Var1 = CSRLIN
       Var2 = POS(0)
       CALL Edit.Status.Line
       Locate Var1,Var2,1
    END IF
 Loop
End Function

' checks keyboard buffer
FUNCTION KeyIS
 InregsX.AX = &H0100
 CALL InterruptX(&H16, InregsX, OutregsX)
 IF (OutregsX.Flags AND &H40) = &H40 THEN
    KeyIS = False
 ELSE
    KeyIS = True
 END IF
END FUNCTION

' reads character directly from keyboard including extended keys.
FUNCTION KeyboardChar$
 IF KeyIS = 0 THEN
    EXIT FUNCTION
 END IF
 InregsX.AX = &H0000
 CALL InterruptX(&H16, InregsX, OutregsX)
 Key1 = (OutregsX.AX AND &HFF)
 IF Key1 = False THEN ' extended key
    Key2 = (OutregsX.AX AND &HFF00) / 256
    KeyboardChar$ = CHR$(0) + CHR$(Key2)
 ELSE
    KeyboardChar$ = CHR$(Key1)
 END IF
END FUNCTION

' uses direct keyboard input to get an input line.
FUNCTION KeyboardLine$
 Var$ = Nul
 DO
    LOCATE ,,1
    Var2$=InkeyX$
    IF Len(Var2$) THEN ' check keyboard
       Select Case Len(Var2$)
       Case 1
       SELECT CASE Var2$
       CASE CHR$(13) ' return
          EXIT DO
       CASE CHR$(27) ' escape
          FOR V% = LEN(Var$) TO 1 STEP -1
             IF POS(0) > 1 THEN ' check cursor location
                LOCATE CSRLIN, POS(0) - 1, 0
                PRINT " ";
                LOCATE CSRLIN, POS(0) - 1, 1
             ELSE ' line-wrap
                LOCATE CSRLIN - 1, 80, 0
                PRINT " ";
                LOCATE CSRLIN - 1, 80, 1
             END IF
          NEXT   
          Var$ = Nul
       CASE CHR$(8) ' backspace
          IF LEN(Var$) > 0 THEN
             Var$ = LEFT$(Var$, LEN(Var$) - 1)
             IF POS(0) > 1 THEN ' check cursor location
                LOCATE CSRLIN, POS(0) - 1, 0
                PRINT " ";
                LOCATE CSRLIN, POS(0) - 1, 1
             ELSE ' line-wrap
                LOCATE CSRLIN - 1, 80, 0
                PRINT " ";
                LOCATE CSRLIN - 1, 80, 1
             END IF
          END IF
       CASE ELSE ' store input
          PRINT Var2$;
          LOCATE , , 1
          Var$ = Var$ + Var2$
       END SELECT
       Case 2
          SELECT CASE Right$(Var2$,1)
          CASE CHR$(83) ' delete
             Debug = Not Debug
          End Select
       End Select
    END IF
 LOOP

 ' return input line
 KeyboardLine$ = Var$
END FUNCTION

' declare command error routine
ON ERROR GOTO MainError
Call Stdin(Var)
X$ = Inkey$

' define record lengths
SpellRecLen = LEN(SpellRecord)
TreasureRecLen = LEN(TreasureRecord)

' define name arrays
REDIM Class.Name(1 TO 10) AS STRING * 15
REDIM InventoryNames(1 TO 10) AS STRING * 8

' init files
Call Read.Rows(Var)
Max.Row=Var
Call Save.Screen(0)
Current.Dir$ = CURDIR$
CLOSE
Temp$ = Current.Dir$
If Right$(Temp$,1)<>"\" Then
   Temp$=Temp$+"\"
Endif
TempSpellFile$ = Temp$ + "SPELLS.DND"
TempTreasureFile$ = Temp$ + "TREASURE.DND"
'IF DIR$(TempSpellFile$) <> "" THEN
'   KILL TempSpellFile$
'END IF
'IF DIR$(TempTreasureFile$) <> "" THEN
'   KILL TempTreasureFile$
'END IF
GOSUB GetConfig

' start import loop
CLOSE
CLS
CALL Edit.Status.Line
LOCATE Max.Row-1, 1, 1
DO
   COLOR 15, 0
   PRINT "Import/Export "+Version$+" utility."
   COLOR 14, 0
   PRINT "Options:"
   COLOR 15, 0
   PRINT "(1)Text file menu"
   PRINT "(2)Data file menu"
   PRINT "(3)Import files"
   PRINT "(4)Export files"
   PRINT "(5)Search files"
   PRINT "(6)Quit and write data files"
   COLOR 14, 0
   PRINT "Enter option(?=Help):";
   Char$ = InkeyX$
   PRINT Char$
   If Char$ = "?" Then
      Char$ = ""
      Call Out.FileX("IMPORT.TXT")
   Endif
   Var1 = INT(VAL(Char$))
   SELECT CASE Var1
   CASE 1 ' text file menu
      DO
	 COLOR 15, 0
	 PRINT "Text File Menu:"
	 COLOR 14, 0
	 PRINT "Options:"
	 COLOR 15, 0
	 PRINT "(1)Add menu"
	 PRINT "(2)Edit menu"
	 PRINT "(3)List menu"
	 PRINT "(4)Quit"
	 COLOR 14, 0
	 PRINT "Enter option:";
         Char$ = InkeyX$
	 PRINT Char$
	 Var1 = INT(VAL(Char$))
	 SELECT CASE Var1
	 CASE 1 ' add
	    DO
	       COLOR 15, 0
	       PRINT "Text File Add Menu:"
	       COLOR 14, 0
	       PRINT "Options:"
	       COLOR 15, 0
	       PRINT "(1)Spells file"
	       PRINT "(2)Treasure file"
	       PRINT "(3)Quit add menu"
	       COLOR 14, 0
	       PRINT "Enter option:";
               Char$ = InkeyX$
	       PRINT Char$
	       Var1 = INT(VAL(Char$))
	       SELECT CASE Var1
	       CASE 1 ' spells
                  DO
                     PRINT "Enter spells text filename: ";
                     x$ = KeyboardLine$
                     Print
                     IF x$<>"" Then
                        Exit Do
                     Endif
                  LOOP
		  IF DIR$(x$) = "" THEN
		     PRINT "Spells text file not found."
		  ELSE
		     DO
			CLOSE
			OPEN x$ FOR INPUT AS #1
                        LineNumber! = 0!
			EofMarker = 0
			DO
			   IF EOF(1) THEN
			      EXIT DO
			   END IF
			   LINE INPUT #1, z$
			   IF RTRIM$(LTRIM$(LCASE$(z$))) = "<eof>" THEN
			      EofMarker = -1
			      EXIT DO
			   END IF
                           LineNumber! = LineNumber! + 1!
			LOOP
			Valid = 0
			IF EofMarker = 0 THEN
			   PRINT "<eof> not found."
			ELSE
                           IF LineNumber! MOD 18! = 0! THEN
			      Valid = -1
			      SpellFile$ = x$
			   ELSE
			      PRINT "Spell records not 18 lines in file."
			   END IF
			END IF
			IF Valid THEN
			   PRINT "Spell text file loaded."
			   EXIT DO
			END IF
			COLOR 15, 0
			PRINT "Edit "; x$; "(y/n)";
			z$ = ""
			DO
                           z$ = InkeyX$
			   IF LEN(z$) THEN
			      z$ = LCASE$(z$)
			      IF z$ = "n" THEN
				 PRINT
				 EXIT DO
			      END IF
			      IF z$ = "y" THEN
				 PRINT
				 EXIT DO
			      END IF
			   END IF
			LOOP
			IF z$ = "n" THEN
			   EXIT DO
			END IF
			IF z$ = "y" THEN
			   CLOSE
			   CALL ScrnEdit(x$)
			END IF
		     LOOP
		  END IF
                  CALL MorePrompt(X)
	       CASE 2 ' treasure
                  DO
                     PRINT "Enter treasure text filename: ";
                     x$ = KeyboardLine$
                     Print
                     If x$<>"" Then
                        Exit Do
                     Endif
                  LOOP
		  IF DIR$(x$) = "" THEN
                     PRINT "Treasure text file not found."
		  ELSE
		     DO
			CLOSE
			OPEN x$ FOR INPUT AS #1
                        LineNumber! = 0!
			EofMarker = 0
			DO
			   IF EOF(1) THEN
			      EXIT DO
			   END IF
			   LINE INPUT #1, z$
			   IF RTRIM$(LTRIM$(LCASE$(z$))) = "<eof>" THEN
			      EofMarker = -1
			      EXIT DO
			   END IF
                           LineNumber! = LineNumber! + 1!
			LOOP
			Valid = 0
			IF EofMarker = 0 THEN
			   PRINT "<eof> not found."
			ELSE
                           IF LineNumber! MOD 58! = 0! THEN
			      Valid = -1
			      TreasureFile$ = x$
			   ELSE
			      PRINT "Treasure records not 58 lines in file."
			   END IF
			END IF
			IF Valid THEN
                           PRINT "Treasure text file loaded."
			   EXIT DO
			END IF
			COLOR 15, 0
			PRINT "Edit "; x$; "(y/n)";
			z$ = ""
			DO
                           z$ = InkeyX$
			   IF LEN(z$) THEN
			      z$ = LCASE$(z$)
			      IF z$ = "n" THEN
				 PRINT
				 EXIT DO
			      END IF
			      IF z$ = "y" THEN
				 PRINT
				 EXIT DO
			      END IF
			   END IF
			LOOP
			IF z$ = "n" THEN
			   EXIT DO
			END IF
			IF z$ = "y" THEN
			   CLOSE
			   CALL ScrnEdit(x$)
			END IF
		     LOOP
		  END IF
                  CALL MorePrompt(X)
	       CASE 3 ' quit
		  EXIT DO
	       END SELECT
	    LOOP
	 CASE 2 ' edit
	    DO
	       COLOR 15, 0
	       PRINT "Text File Edit Menu:"
	       COLOR 14, 0
	       PRINT "Options:"
	       COLOR 15, 0
	       PRINT "(1)Spells file"
	       PRINT "(2)Treasure file"
	       PRINT "(3)Quit add menu"
	       COLOR 14, 0
	       PRINT "Enter option:";
               Char$ = InkeyX$
	       PRINT Char$
	       Var1 = INT(VAL(Char$))
	       SELECT CASE Var1
	       CASE 1 ' spells
		  IF LEN(SpellFile$) THEN
		     CALL ScrnEdit(SpellFile$)
                  ELSE
                     PRINT "Spells.txt file not loaded."
		  END IF
	       CASE 2 ' treasure
		  IF LEN(TreasureFile$) THEN
		     CALL ScrnEdit(TreasureFile$)
                  ELSE
                     PRINT "Treasure.txt file not loaded."
		  END IF
	       CASE 3 ' quit
		  EXIT DO
	       END SELECT
	    LOOP
	 CASE 3 ' list
	    DO
	       COLOR 15, 0
	       PRINT "Text File List Menu:"
	       COLOR 14, 0
	       PRINT "Options:"
	       COLOR 15, 0
	       PRINT "(1)Spells file"
	       PRINT "(2)Treasure file"
	       PRINT "(3)Quit list menu"
	       COLOR 14, 0
	       PRINT "Enter option:";
               Char$ = InkeyX$
	       PRINT Char$
	       Var1 = INT(VAL(Char$))
	       SELECT CASE Var1
	       CASE 1 ' spells
		  IF LEN(SpellFile$) = 0 THEN
		     PRINT "Spells text file not loaded."
		  ELSE
		     CLOSE
		     OPEN SpellFile$ FOR INPUT AS #1
                     LineNumber! = 0!
                     DisplayNumber = 1
		     COLOR 15, 0
		     PRINT "Spells:"
		     DO
			IF EOF(1) THEN
			   EXIT DO
			END IF
			LINE INPUT #1, x$
			x$ = RTRIM$(LTRIM$(LCASE$(x$)))
			IF x$ = "<eof>" THEN
			   EXIT DO
			END IF
                        IF LineNumber! MOD 18! = 0! THEN
			   DisplayNumber = DisplayNumber + 1
                           IF DisplayNumber = Max.Row - 2 THEN
                              CALL MorePrompt(X)
			      DisplayNumber = 0
                              IF X THEN
                                 EXIT DO
                              END IF
			   END IF
			   IF LEN(x$) THEN
			      MID$(x$, 1, 1) = UCASE$(MID$(x$, 1, 1))
			   END IF
			   COLOR 14, 0
                           PRINT x$;" (line ";Ltrim$(Str$(LineNumber!+1!));")"
			END IF
                        LineNumber! = LineNumber! + 1!
		     LOOP
		     IF DisplayNumber THEN
                        CALL MorePrompt(X)
		     END IF
		  END IF
	       CASE 2 ' treasure
		  IF LEN(TreasureFile$) = 0 THEN
		     PRINT "Treasure text file not loaded."
		  ELSE
		     CLOSE
		     OPEN TreasureFile$ FOR INPUT AS #1
                     LineNumber! = 0!
                     DisplayNumber = 1
		     COLOR 15, 0
		     PRINT "Treasure:"
		     DO
			IF EOF(1) THEN
			   EXIT DO
			END IF
			LINE INPUT #1, x$
			x$ = RTRIM$(LTRIM$(LCASE$(x$)))
			IF x$ = "<eof>" THEN
			   EXIT DO
			END IF
                        IF LineNumber! MOD 58! = 0! THEN
			   DisplayNumber = DisplayNumber + 1
                           IF DisplayNumber = Max.Row - 2 THEN
                              CALL MorePrompt(X)
			      DisplayNumber = 0
                              IF X THEN
                                 EXIT DO
                              END IF
			   END IF
			   IF LEN(x$) THEN
			      MID$(x$, 1, 1) = UCASE$(MID$(x$, 1, 1))
			   END IF
			   COLOR 14, 0
                           PRINT x$;" (line ";Ltrim$(Str$(LineNumber!+1!));")"
			END IF
                        LineNumber! = LineNumber! + 1!
		     LOOP
		     IF DisplayNumber THEN
                        CALL MorePrompt(X)
		     END IF
		  END IF
	       CASE 3 ' quit
		  EXIT DO
	       END SELECT
	    LOOP
	 CASE 4 ' quit
	    EXIT DO
	 END SELECT
      LOOP
   CASE 2 ' data file menu
      DO
	 COLOR 15, 0
	 PRINT "Data File Menu:"
	 COLOR 14, 0
	 PRINT "Options:"
	 COLOR 15, 0
	 PRINT "(1)Edit spells.dat"
	 PRINT "(2)Edit treasure.dat"
         PRINT "(3)Quit"
	 COLOR 14, 0
	 PRINT "Enter option:";
         Char$ = InkeyX$
	 PRINT Char$
	 Var1 = INT(VAL(Char$))
	 SELECT CASE Var1
	 CASE 1 ' edit spells
	    IF Imported1 = 0 THEN
	       PRINT "Spells.txt file not imported."
	    ELSE
               CLOSE
               OPEN TempSpellFile$ FOR RANDOM AS #1 LEN = SpellRecLen
               OPEN TempTreasureFile$ FOR RANDOM AS #2 LEN = TreasureRecLen
               CALL FindSpell(Var!)
               IF Var! = 0! THEN
                  PRINT "Spell name not found."
               ELSE
                  CALL ChangeSpell(Var!)
               END IF
	    END IF
	 CASE 2 ' edit treasure
            IF Imported2 = 0 THEN
               PRINT "Treasure.txt file not imported."
            ELSE
               CLOSE
               OPEN TempSpellFile$ FOR RANDOM AS #1 LEN = SpellRecLen
               OPEN TempTreasureFile$ FOR RANDOM AS #2 LEN = TreasureRecLen
               CALL FindTreasure(Var!)
               IF Var! = 0! THEN
                  PRINT "Treasure name not found."
               ELSE
                  CALL ChangeTreasure(Var!)
               END IF
            END IF
         CASE 3 ' quit
	    EXIT DO
	 END SELECT
      LOOP
   CASE 3 ' import file menu
      DO
	 COLOR 15, 0
	 PRINT "Import File Menu:"
	 COLOR 14, 0
	 PRINT "Options:"
	 COLOR 15, 0
	 PRINT "(1)Import spells text file"
	 PRINT "(2)Import treasure text file"
	 PRINT "(3)Quit"
	 COLOR 14, 0
	 PRINT "Enter option:";
         Char$ = InkeyX$
	 PRINT Char$
	 Var1 = INT(VAL(Char$))
	 SELECT CASE Var1
	 CASE 1 ' spells
	    IF LEN(SpellFile$) = 0 THEN
	       PRINT "Spell text file not loaded."
	    ELSE
	       CLOSE
	       IF DIR$(TempSpellFile$) <> "" THEN
		  KILL TempSpellFile$
	       END IF
	       OPEN TempSpellFile$ FOR RANDOM AS #1 LEN = SpellRecLen
	       OPEN SpellFile$ FOR INPUT AS #2
	       Rec = 1
	       LineNumber = 0
	       DO
		  IF EOF(2) THEN
		     EXIT DO
		  END IF
		  LINE INPUT #2, x$
		  IF LCASE$(RTRIM$(LTRIM$(x$))) = "<eof>" THEN
		     EXIT DO
		  END IF
		  LineNumber = LineNumber + 1
		  SELECT CASE LineNumber
		  CASE 1
		     SpellRecord.SpellName = LCASE$(x$)
		  CASE 2
		     SpellRecord.Chant = UCASE$(x$)
		  CASE 3
		     SpellRecord.Desc = x$
		  CASE 4
		     SpellRecord.Level = INT(VAL(x$))
		  CASE 5
		     SpellRecord.SpellType = 0
		     IF LEN(x$) THEN
                        Temp5 = INSTR("ABCDEFGHIJKLMNOPRSTUVWXYZ12345678", UCASE$(x$))
			IF Temp5 THEN
			   SpellRecord.SpellType = Temp5
			END IF
		     END IF
		  CASE 6
		     SpellRecord.Teleport = 0
		     IF SpellRecord.SpellType = 10 THEN
			IF x$ = "-1" THEN
			   SpellRecord.Teleport = -1
			ELSE
			   SpellRecord.Teleport = INT(VAL(x$))
			END IF
		     END IF
		  CASE 7
		     SpellRecord.Psionic = 0
		     IF x$ = "-1" THEN
			SpellRecord.SpellType = 15
			SpellRecord.Psionic = -1
		     END IF
		  CASE 8
		     SpellRecord.PsionicMode = 0
		     IF UCASE$(x$) = "A" THEN
			SpellRecord.PsionicMode = 1
		     END IF
		     IF UCASE$(x$) = "D" THEN
			SpellRecord.PsionicMode = 2
		     END IF
		  CASE 9
		     SpellRecord.ClassType = 0
		     FOR x = 1 TO LEN(x$)
			z$ = UCASE$(MID$(x$, x, 1))
			SELECT CASE z$
			CASE "A"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 1
			CASE "B"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 2
			CASE "C"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 3
			CASE "D"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 4
			CASE "E"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 5
			CASE "F"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 6
			CASE "G"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 7
			CASE "H"
			   SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ 8
			CASE "X"
			   FOR V = 1 TO 8
			      SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ V
			   NEXT
			CASE "N"
			   SpellRecord.ClassType = 0
			END SELECT
		     NEXT
		  CASE 10 TO 14
		     SpellRecord.Ingred(LineNumber - 9) = INT(VAL(x$))
		  CASE 15
		     SpellRecord.SpellFlag = 0
		     FOR x = 1 TO LEN(x$)
			z$ = UCASE$(MID$(x$, x, 1))
			SELECT CASE z$
			CASE "A"
			   SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 2 ^ 0
			CASE "B"
			   SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 2 ^ 1
			CASE "C"
			   SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 2 ^ 2
			CASE "X"
			   FOR V = 0 TO 2
			      SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 2 ^ V
			   NEXT
			CASE "N"
			   SpellRecord.SpellFlag = 0
			END SELECT
		     NEXT
		  CASE 16
		     IF x$ = "-1" THEN
			SpellRecord.Equation = -1
		     ELSE
			SpellRecord.Equation = 0
		     END IF
		  CASE 17
		     SpellRecord.SpellEquate = UCASE$(x$)
		  CASE 18
		     SpellRecord.Prefix1 = UCASE$(x$)
		  END SELECT
		  IF LineNumber = 18 THEN
		     PUT #1, Rec, SpellRecord
		     Rec = Rec + 1
		     LineNumber = 0
		  END IF
	       LOOP
	       PRINT "Spell text file imported."
	       Imported1 = -1
	    END IF
            CALL MorePrompt(X)
	 CASE 2 ' treasure
	    IF LEN(TreasureFile$) = 0 THEN
	       PRINT "Treasure text file not loaded."
	    ELSE
	       CLOSE
	       IF DIR$(TempTreasureFile$) <> "" THEN
		  KILL TempTreasureFile$
	       END IF
	       OPEN TempTreasureFile$ FOR RANDOM AS #1 LEN = TreasureRecLen
	       OPEN TreasureFile$ FOR INPUT AS #2
	       Rec = 1
	       LineNumber = 0
	       DO
		  IF EOF(2) THEN
		     EXIT DO
		  END IF
		  LINE INPUT #2, x$
		  IF LCASE$(RTRIM$(LTRIM$(x$))) = "<eof>" THEN
		     EXIT DO
		  END IF
		  LineNumber = LineNumber + 1
		  SELECT CASE LineNumber
		  CASE 1
		     TreasureRecord.TreasureName = LCASE$(x$)
		  CASE 2
		     TreasureRecord.ShortName = UCASE$(x$)
		  CASE 3
		     TreasureRecord.Weight = INT(VAL(x$))
		  CASE 4
		     TreasureRecord.Gold = INT(VAL(x$))
		  CASE 5
		     TreasureRecord.Spell = INT(VAL(x$))
		  CASE 6
		     TreasureRecord.Container = 0
		     TreasureRecord.ContainerMax = 0
		     TreasureRecord.ContainerSize = 0
		     TreasureRecord.WeaponNumber = 0
		     TreasureRecord.TwoHanded = 0
		     SELECT CASE UCASE$(x$)
		     CASE "1" ' container
			TreasureRecord.Container = -1
		     CASE "A" ' armor
			TreasureRecord.WeaponNumber = 1
		     CASE "B" ' Boots
			TreasureRecord.WeaponNumber = 2
		     CASE "C" ' Cloak
			TreasureRecord.WeaponNumber = 3
		     CASE "H" ' Helmet
			TreasureRecord.WeaponNumber = 8
		     CASE "R1" ' Ring (left-handed)
			TreasureRecord.WeaponNumber = 4
		     CASE "R2" ' Ring (right-handed)
			TreasureRecord.WeaponNumber = 9
		     CASE "S" ' Shield
			TreasureRecord.WeaponNumber = 5
		     CASE "T" ' Bracers
			TreasureRecord.WeaponNumber = 6
		     CASE "U" ' Amulet
			TreasureRecord.WeaponNumber = 10
		     CASE "W1" ' Weapon
			TreasureRecord.WeaponNumber = 7
		     CASE "W2" ' Weapon (two-handed)
			TreasureRecord.WeaponNumber = 7
			TreasureRecord.TwoHanded = -1
		     END SELECT
		  CASE 7
		     TreasureRecord.RequireStr = INT(VAL(x$))
		  CASE 8
		     TreasureRecord.RequireDex = INT(VAL(x$))
		  CASE 9
		     TreasureRecord.RequireInt = INT(VAL(x$))
		  CASE 10
		     TreasureRecord.Plus = INT(VAL(x$))
		  CASE 11
		     IF x$ = "-1" THEN
			TreasureRecord.Coin = -1
		     ELSE
			TreasureRecord.Coin = 0
		     END IF
		  CASE 12
		     IF x$ = "-1" THEN
			TreasureRecord.Scroll = -1
		     ELSE
			TreasureRecord.Scroll = 0
		     END IF
		  CASE 13
		     TreasureRecord.Charges = INT(VAL(x$))
		  CASE 14
		     IF x$ = "-1" THEN
			TreasureRecord.Potion = -1
		     ELSE
			TreasureRecord.Potion = 0
		     END IF
		  CASE 15
		     TreasureRecord.Liquid = 0
		     IF TreasureRecord.Potion THEN
			IF x$ = "-1" THEN
			   TreasureRecord.Liquid = -1
			END IF
		     END IF
		  CASE 16
		     TreasureRecord.LiquidType = 0
		     IF TreasureRecord.Liquid THEN
			IF x$ = "1" OR x$ = "2" THEN
			   TreasureRecord.LiquidType = INT(VAL(x$))
			END IF
		     END IF
		  CASE 17
		     TreasureRecord.LiquidFlags = 0
		  CASE 18
		     TreasureRecord.PotionType = 0
		     IF TreasureRecord.Potion THEN
			TreasureRecord.PotionType = INT(VAL(x$))
		     END IF
		  CASE 19
		     IF x$ = "-1" THEN
			TreasureRecord.MixPotion = -1
		     ELSE
			TreasureRecord.MixPotion = 0
		     END IF
		  CASE 20
		     TreasureRecord.NewPotion = 0
		     IF TreasureRecord.Potion THEN
			TreasureRecord.NewPotion = INT(VAL(x$))
		     END IF
		  CASE 21
		     IF x$ = "-1" THEN
			TreasureRecord.Ammunition = -1
		     ELSE
			TreasureRecord.Ammunition = 0
		     END IF
		  CASE 22
		     IF x$ = "-1" THEN
			TreasureRecord.Loadable = -1
		     ELSE
			TreasureRecord.Loadable = 0
		     END IF
		  CASE 23
		     TreasureRecord.AmmoLoads = 0
		     IF TreasureRecord.Loadable THEN
			TreasureRecord.AmmoLoads = INT(VAL(x$))
		     END IF
		  CASE 24
		     IF x$ = "-1" THEN
			TreasureRecord.Invisible = -1
		     ELSE
			TreasureRecord.Invisible = 0
		     END IF
		  CASE 25
		     TreasureRecord.Proficiency = 0
		     SELECT CASE UCASE$(x$)
		     CASE "B" ' Blunt
			TreasureRecord.Proficiency = 1
		     CASE "P" ' Pole
			TreasureRecord.Proficiency = 2
		     CASE "S" ' Sharp
			TreasureRecord.Proficiency = 3
		     CASE "T" ' Thrusting
			TreasureRecord.Proficiency = 4
		     END SELECT
		  CASE 26
		     TreasureRecord.RingSpell = 0
		     TreasureRecord.RingType = 0
		     SELECT CASE UCASE$(x$)
		     CASE "A" ' Any spell
			TreasureRecord.RingSpell = -1
			TreasureRecord.RingType = 3
		     CASE "F" ' Fumbling
			TreasureRecord.RingSpell = -1
			TreasureRecord.RingType = 8
		     CASE "I" ' Inventory damage
			TreasureRecord.RingSpell = -1
			TreasureRecord.RingType = 7
		     CASE "L" ' Level drain
			TreasureRecord.RingSpell = 0
			TreasureRecord.RingType = 2
		     CASE "O" ' Offense/invisible spell
			TreasureRecord.RingSpell = 0
			TreasureRecord.RingType = 3
		     CASE "P" ' Poison
			TreasureRecord.RingSpell = 0
			TreasureRecord.RingType = 1
		     CASE "R" ' Rusting
			TreasureRecord.RingSpell = -1
			TreasureRecord.RingType = 5
		     CASE "S" ' Stealing
			TreasureRecord.RingSpell = -1
			TreasureRecord.RingType = 6
		     CASE "T" ' Teleporting
			TreasureRecord.RingSpell = -1
			TreasureRecord.RingType = 9
		     CASE "X" ' All traps
			TreasureRecord.RingSpell = -1
			TreasureRecord.RingType = 4
		     END SELECT
		  CASE 27
		     IF TreasureRecord.RingType = 3 THEN
			TreasureRecord.RingSpell = INT(VAL(x$))
		     END IF
		  CASE 28
		     IF x$ = "-1" THEN
			TreasureRecord.Edible = -1
		     ELSE
			TreasureRecord.Edible = 0
		     END IF
		  CASE 29
		     IF x$ = "-1" THEN
			TreasureRecord.Rustable = -1
		     ELSE
			TreasureRecord.Rustable = 0
		     END IF
		  CASE 30
		     TreasureRecord.RustPercent = INT(VAL(x$))
		  CASE 31
		     IF x$ = "-1" THEN
			TreasureRecord.Stealable = -1
		     ELSE
			TreasureRecord.Stealable = 0
		     END IF
		  CASE 32
		     TreasureRecord.StealPercent = INT(VAL(x$))
		  CASE 33
		     IF x$ = "-1" THEN
			TreasureRecord.LaunchAmmo = -1
		     ELSE
			TreasureRecord.LaunchAmmo = 0
		     END IF
		  CASE 34
		     IF x$ = "-1" THEN
			TreasureRecord.Launchable = -1
		     ELSE
			TreasureRecord.Launchable = 0
		     END IF
		  CASE 35
		     TreasureRecord.LaunchLoads = 0
		     IF TreasureRecord.Launchable THEN
			TreasureRecord.LaunchLoads = INT(VAL(x$))
		     END IF
		  CASE 36
		     IF x$ = "-1" THEN
			TreasureRecord.Movable = -1
		     ELSE
			TreasureRecord.Movable = 0
		     END IF
		  CASE 37
		     IF x$ = "-1" THEN
			TreasureRecord.Vehicle = -1
		     ELSE
			TreasureRecord.Vehicle = 0
		     END IF
		  CASE 38
		     TreasureRecord.VehicleType = 0
		     SELECT CASE UCASE$(x$)
		     CASE "L" ' Land terrain
			TreasureRecord.VehicleType = 1
		     CASE "W" ' Water terrain
			TreasureRecord.VehicleType = 2
		     CASE "X" ' All terrain
			TreasureRecord.VehicleType = 3
		     END SELECT
		  CASE 39
		     IF x$ = "-1" THEN
			TreasureRecord.LightType = -1
		     ELSE
			TreasureRecord.LightType = 0
		     END IF
		  CASE 40
		     TreasureRecord.LightCharges = INT(VAL(x$))
		  CASE 41
		     IF x$ = "-1" THEN
			TreasureRecord.FuelType = -1
		     ELSE
			TreasureRecord.FuelType = 0
		     END IF
		  CASE 42
		     TreasureRecord.FuelCharges = INT(VAL(x$))
		  CASE 43
		     IF x$ = "-1" THEN
			TreasureRecord.Locked = -1
		     ELSE
			TreasureRecord.Locked = 0
		     END IF
		  CASE 44
		     TreasureRecord.ContainerMax = INT(VAL(x$))
		  CASE 45
		     TreasureRecord.ContainerPrefix = LCASE$(x$)
		  CASE 46
		     TreasureRecord.ContainerDisappears = INT(VAL(x$))
		  CASE 47
		     TreasureRecord.ContainerSize = INT(VAL(x$))
		  CASE 48
		     TreasureRecord.RestrictItem(1) = INT(VAL(x$))
		  CASE 49
		     TreasureRecord.RestrictItem(2) = INT(VAL(x$))
		  CASE 50
		     TreasureRecord.RestrictItem(3) = INT(VAL(x$))
		  CASE 51
		     TreasureRecord.TrapType = 0
		     SELECT CASE UCASE$(x$)
		     CASE "P" ' Poison
			TreasureRecord.TrapType = 1
		     CASE "H" ' Hits
			TreasureRecord.TrapType = 2
		     CASE "E" ' Explodes
			TreasureRecord.TrapType = 3
		     CASE "W" ' Weapon
			TreasureRecord.TrapType = 4
		     END SELECT
		  CASE 52
		     TreasureRecord.TrapHits = INT(VAL(x$))
		  CASE 53
		     TreasureRecord.TrapItem = INT(VAL(x$))
		  CASE 54
		     TreasureRecord.KeyNumber = INT(VAL(x$))
		  CASE 55
		     IF x$ = "-1" THEN
			TreasureRecord.MasterKey = -1
		     ELSE
			TreasureRecord.MasterKey = 0
		     END IF
		  CASE 56
		     TreasureRecord.Prefix1 = UCASE$(x$)
                     TreasureRecord.ProperName = ""
		  CASE 57
		     IF x$ = "-1" THEN
			TreasureRecord.Permanent = -1
		     ELSE
			TreasureRecord.Permanent = 0
		     END IF
                  CASE 58
		     IF x$ = "-1" THEN
			TreasureRecord.StaysInRoom = -1
		     ELSE
			TreasureRecord.StaysInRoom = 0
		     END IF
		  END SELECT
		  IF LineNumber = 58 THEN
		     PUT #1, Rec, TreasureRecord
		     Rec = Rec + 1
		     LineNumber = 0
		  END IF
	       LOOP
	       PRINT "Treasure text file imported."
	       Imported2 = -1
	    END IF
            CALL MorePrompt(X)
	 CASE 3 ' quit
	    EXIT DO
	 END SELECT
      LOOP
   CASE 4 ' export file menu
      DO
	 COLOR 15, 0
         PRINT "Export File Menu:"
	 COLOR 14, 0
	 PRINT "Options:"
	 COLOR 15, 0
         PRINT "(1)Export spells text file"
         PRINT "(2)Export treasure text file"
	 PRINT "(3)Quit"
	 COLOR 14, 0
	 PRINT "Enter option:";
         Char$ = InkeyX$
	 PRINT Char$
	 Var1 = INT(VAL(Char$))
	 SELECT CASE Var1
	 CASE 1 ' spells
            DndSpellFile$ = Data.Path1$ + DataFile2$ + File.Extension1$
            CLOSE
            OPEN DndSpellFile$ FOR RANDOM AS #1 LEN = SpellRecLen
            Var1! = LOF(1) / SpellRecLen
            If Var1!>0! Then
               Print "Spell datafile range to export from(1-"+Ltrim$(Str$(Var1!))+")";
               Z$ = KeyboardLine$
               Print
               Var2! = Int(Val(Z$))
               If Var2!>=1! And Var2!<=Var1! Then
                  Print "Spell datafile range to export to("+Ltrim$(Str$(Var2!))+"-"+Ltrim$(Str$(Var1!))+")";
                  Z$ = KeyboardLine$
                  Print
                  Var3! = Int(Val(Z$))
                  If Var3!>=Var2! And Var3!<=Var1! Then
                     Print "Export spells ";Var2!;"-";Var3!
                     Print "Enter export text filename: ";
                     Var$ = KeyboardLine$
                     Print
                     Yes=-1
                     If Rtrim$(Var$)="" Then
                        Yes=0
                     Else
                        If Dir$(Var$)<>"" Then
                           Yes=0
                           Print Var$;" exists. Write anyway(y/n)? ";
                           X$ = KeyboardLine$
                           Print
                           If Ucase$(X$)="Y" Then
                              Yes=-1
                           Endif
                        Endif
                     Endif
                     If Yes Then
                        Print "Writing ";Var$
                        Close #2
                        Open Var$ For Output As #2
                        For V!=Var2! To Var3!
                           Get #1,V!,SpellRecord
                           Print #2, SpellRecord.SpellName
                           Print #2, SpellRecord.Chant
                           Print #2, SpellRecord.Desc 
                           Print #2, SpellRecord.Level 
                           Print #2, SpellRecord.SpellType
                           Print #2, SpellRecord.Teleport
                           Print #2, SpellRecord.Psionic
                           Print #2, SpellRecord.PsionicMode
                           Print #2, SpellRecord.ClassType
                           For VarZ=1 To 5
                              Print #2, SpellRecord.Ingred(VarZ)
                           Next
                           Print #2, SpellRecord.SpellFlag 
                           Print #2, SpellRecord.Equation
                           Print #2, SpellRecord.SpellEquate 
                           If Rtrim$(SpellRecord.Prefix1)="" Then
                              Print #2, ""
                           Else
                              Print #2, SpellRecord.Prefix1
                           Endif
                        Next
                        Print #2, "<eof>"
                        Close #2
                     Endif
                  Endif
               Endif
            Endif
            CALL MorePrompt(X)
         CASE 2 ' treasure
            DndTreasureFile$ = Data.Path1$ + DataFile1$ + File.Extension1$
            CLOSE
            OPEN DndTreasureFile$ FOR RANDOM AS #1 LEN = TreasureRecLen
            Var1! = LOF(1) / TreasureRecLen
            If Var1!>0! Then
               Print "Treasure datafile range to export from(1-"+Ltrim$(Str$(Var1!))+"): ";
               Z$ = KeyboardLine$
               Print
               Var2! = Int(Val(Z$))
               If Var2!>=1! And Var2!<=Var1! Then
                  Print "Treasure datafile range to export to("+Ltrim$(Str$(Var2!))+"-"+Ltrim$(Str$(Var1!))+"): ";
                  Z$ = KeyboardLine$
                  Print
                  Var3! = Int(Val(Z$))
                  If Var3!>=Var2! And Var3!<=Var1! Then
                     Print "Export treasure ";Var2!;"-";Var3!
                     Print "Enter export text filename";
                     Input Var$
                     Yes=-1
                     If Rtrim$(Var$)="" Then
                        Yes=0
                     Else
                        If Dir$(Var$)<>"" Then
                           Yes=0
                           Print Var$;" exists. Write anyway(y/n)? ";
                           X$ = KeyboardLine$
                           Print
                           If Ucase$(X$)="Y" Then
                              Yes=-1
                           Endif
                        Endif
                     Endif
                     If Yes Then
                        Print "Writing ";Var$
                        Close #2
                        Open Var$ For Output As #2
                        For V!=Var2! To Var3!
                           Get #1,V!,TreasureRecord
                           Print #2, TreasureRecord.TreasureName 
                           Print #2, TreasureRecord.ShortName
                           Print #2, TreasureRecord.Weight 
                           Print #2, TreasureRecord.Gold
                           Print #2, TreasureRecord.Spell 
                           If TreasureRecord.Container Then
                              Print #2, "1"
                           Else
                              If TreasureRecord.WeaponNumber = 1 Then
                                 Print #2, "A"
                              Endif
                              If TreasureRecord.WeaponNumber = 2 Then
                                 Print #2, "B"
                              Endif
                              If TreasureRecord.WeaponNumber = 3 Then
                                 Print #2, "C"
                              Endif
                              If TreasureRecord.WeaponNumber = 8 Then
                                 Print #2, "H"
                              Endif
                              If TreasureRecord.WeaponNumber = 4 Then
                                 Print #2, "R1"
                              Endif
                              If TreasureRecord.WeaponNumber = 9 Then
                                 Print #2, "R2"
                              Endif
                              If TreasureRecord.WeaponNumber = 5 Then
                                 Print #2, "S"
                              Endif
                              If TreasureRecord.WeaponNumber = 6 Then
                                 Print #2, "T"
                              Endif
                              If TreasureRecord.WeaponNumber = 10 Then
                                 Print #2, "U"
                              Endif
                              If TreasureRecord.WeaponNumber = 7 Then
                                 Print #2, "W1"
                              Endif
                              If TreasureRecord.WeaponNumber = 7 Then
                                 Print #2, "W2"
                              Endif
                           Endif
                           Print #2, TreasureRecord.RequireStr
                           Print #2, TreasureRecord.RequireDex 
                           Print #2, TreasureRecord.RequireInt 
                           Print #2, TreasureRecord.Plus
                           Print #2, TreasureRecord.Coin
                           Print #2, TreasureRecord.Scroll
                           Print #2, TreasureRecord.Charges
                           Print #2, TreasureRecord.Potion
                           Print #2, TreasureRecord.Liquid
                           Print #2, TreasureRecord.LiquidType 
                           Print #2, TreasureRecord.LiquidFlags
                           Print #2, TreasureRecord.PotionType 
                           Print #2, TreasureRecord.MixPotion
                           Print #2, TreasureRecord.NewPotion 
                           Print #2, TreasureRecord.Ammunition 
                           Print #2, TreasureRecord.Loadable 
                           Print #2, TreasureRecord.AmmoLoads 
                           Print #2, TreasureRecord.Invisible 
                           Print #2, TreasureRecord.Proficiency
                           Print #2, TreasureRecord.RingType
                           Print #2, TreasureRecord.RingSpell 
                           Print #2, TreasureRecord.Edible
                           Print #2, TreasureRecord.Rustable
                           Print #2, TreasureRecord.RustPercent 
                           Print #2, TreasureRecord.Stealable 
                           Print #2, TreasureRecord.StealPercent 
                           Print #2, TreasureRecord.LaunchAmmo 
                           Print #2, TreasureRecord.Launchable 
                           Print #2, TreasureRecord.LaunchLoads 
                           Print #2, TreasureRecord.Movable 
                           Print #2, TreasureRecord.Vehicle
                           Print #2, TreasureRecord.VehicleType 
                           Print #2, TreasureRecord.LightType 
                           Print #2, TreasureRecord.LightCharges
                           Print #2, TreasureRecord.FuelType
                           Print #2, TreasureRecord.FuelCharges 
                           Print #2, TreasureRecord.Locked
                           Print #2, TreasureRecord.ContainerMax 
                           Print #2, TreasureRecord.ContainerPrefix
                           Print #2, TreasureRecord.ContainerDisappears 
                           Print #2, TreasureRecord.ContainerSize 
                           Print #2, TreasureRecord.RestrictItem(1) 
                           Print #2, TreasureRecord.RestrictItem(2) 
                           Print #2, TreasureRecord.RestrictItem(3)
                           Print #2, TreasureRecord.TrapType 
                           Print #2, TreasureRecord.TrapHits 
                           Print #2, TreasureRecord.TrapItem 
                           Print #2, TreasureRecord.KeyNumber 
                           Print #2, TreasureRecord.MasterKey
                           If Rtrim$(TreasureRecord.Prefix1)="" Then
                              Print #2, ""
                           Else
                              Print #2, TreasureRecord.Prefix1
                           Endif
                           Print #2, TreasureRecord.Permanent
                           Print #2, TreasureRecord.StaysInRoom 
                        Next
                        Print #2,"<eof>"
                        Close #2
                     Endif
                  Endif
               Endif
            Endif
            CALL MorePrompt(X)
         CASE 3 ' quit
            EXIT DO
         END SELECT
      LOOP
   CASE 5 ' search filespec
      COLOR 15, 0
      PRINT "Enter pathname\filespec? ";
      Filespec1$ = Keyboardline$
      Print
      Line.Count = 2
      Total.Bytes# = 0#
      Total.Dirs# = 0#
      Total.Files# = 0#
      GOSUB DisplayHeader
      VarQ3=0

      ' check dirs/files
      For VarQ=1 To 2

         ' restore directory search dta
         InregsX.AX = &H1A00
         InregsX.DS = VARSEG(DTAfile)
         InregsX.DX = VARPTR(DTAfile)
         Call InterruptX(&H21,InregsX,OutregsX)

         ' find first filename
         ASCIIZ = Filespec1$ + CHR$(0)
         InregsX.AX = &H4E00
         InregsX.CX = &H37 ' directory/filename bitmask
         InregsX.DS = VARSEG(ASCIIZ)
         InregsX.DX = VARPTR(ASCIIZ)
         Call InterruptX(&H21,InregsX,OutregsX)

         ' check carry flag
         IF (OutregsX.Flags AND &H1) = &H0 THEN
            VarQ3=-1
            Continuous = 0
            DO
               COLOR 14, 0
               GOSUB DisplayFile
               If Continuous = 0 Then
                  IF Line.Count = Max.Row-2 THEN
                     Line.Count = 2
                     COLOR 15, 0
                     PRINT "More(y/n/c):";
                     Quit=0
                     DO
                        Char$ = InkeyX$
                        Print
                        Select Case Ucase$(Char$)
                        Case "N"
                           Line.Count = 0
                           Quit=-1
                           EXIT DO
                        Case "C"
                           Continuous = -1
                           Exit Do
                        Case " ", "Y", Chr$(13)
                           Exit Do
                        END Select
                     LOOP
                     PRINT
                     If Quit Then
                        Exit Do
                     Endif
                     GOSUB DisplayHeader
                  END IF
               Endif

               ' find next filename
               InregsX.AX = &H4F00
               Call InterruptX(&H21,InregsX,OutregsX)

               ' check carry flag
               IF (OutregsX.Flags AND &H1) = &H1 THEN
                  EXIT DO
               END IF
            LOOP
         END IF

         ' restore basic dta
         InregsX.AX = &H1A00
         InregsX.DS = BASIC.DTA.SEG
         InregsX.DX = BASIC.DTA.OFF
         Call InterruptX(&H21,InregsX,OutregsX)

         ' check break flags
         If Quit Then
            Exit For
         Endif
      Next

      Gosub PrintTotals
      COLOR 15, 0
      PRINT More$;
      Char$ = InkeyX$
      Print
   CASE 6 ' quit & write
      Valid = -1
      IF Imported1 OR Imported2 THEN
         PRINT "Add imported files to dndbbs data files(y/n)? ";
         Char$ = KeyboardLine$
         Print
         Char$ = UCASE$(Char$)
         IF Char$ = "Y" THEN
            GOSUB WriteFiles
            Print "Files written to disk:"
            CALL MorePrompt(X)
         END IF
      END IF
      EXIT DO
   END SELECT
LOOP
Temp$ = SPACE$(79)
CALL Display.Status.Line(0, Temp$)
COLOR 7
CLS
Call Save.Screen(-1)
'Locate Max.Row,1,1
If TempX2=0 Then TempX2=1
Locate TempX2,1,1
Print
color 15
PRINT "Exiting Import Program."
COLOR 7
END

' display list header
DisplayHeader:
 COLOR 15, 0
 PRINT "Filename      Date        Time      Size         Attr"
 PRINT "------------  ----------  --------  -----------  ----"
 Color 14, 0
 RETURN

' display a directory/filename/datetime/filesize/fileattr
DisplayFile:

 ' check directory/filename
 VarQ2=0
 Attribute = ASC(DTAfile.FileAttr)
 IF (Attribute AND &H10) = &H10 THEN
    If VarQ=1 Then
       VarQ$ = "<DIR>"
       Total.Dirs# = Total.Dirs# + 1#
       VarQ2=-1
    Endif
 ELSE
    If VarQ=2 Then
       ' store file size
       File.Size# = ASC(MID$(DTAfile.FileSize, 4, 1))
       File.Size# = File.Size# * &H100 + ASC(MID$(DTAfile.FileSize, 3, 1))
       File.Size# = File.Size# * &H100 + ASC(MID$(DTAfile.FileSize, 2, 1))
       File.Size# = File.Size# * &H100 + ASC(MID$(DTAfile.FileSize, 1, 1))

       ' calculate filespec totals
       Total.Bytes# = Total.Bytes# + File.Size#
       Total.Files# = Total.Files# + 1#
       Call Make.Format(File.Size#, VarQ$)
       VarQ2=-1
    Endif
 END IF

 ' check display flag
 If VarQ2=0 Then
    Return
 Endif

 ' construct file date and time for display
 File.Work.Time = ASC(MID$(DTAfile.FileTime, 2, 1))
 File.Work.Time = File.Work.Time * &H100 + ASC(MID$(DTAfile.FileTime, 1, 1))
 File.Work.Date = ASC(MID$(DTAfile.FileDate, 2, 1))
 File.Work.Date = File.Work.Date * &H100 + ASC(MID$(DTAfile.FileDate, 1, 1))
 WorkHour = INT(File.Work.Time / 2048)
 WorkMinute = INT((File.Work.Time AND &H7E0) / 32)
 WorkSeconds = INT((File.Work.Time AND &H1F) / 2)
 WorkYear = INT(File.Work.Date / 512)
 WorkMonth = INT((File.Work.Date AND &H1E0) / 32)
 WorkDay = INT(File.Work.Date AND &H1F)
 WorkYear = WorkYear + 1980
 File.Date = RIGHT$(STR$(WorkMonth + 100), 2) + "-" + RIGHT$(STR$(WorkDay + 100), 2) + "-" + MID$(STR$(WorkYear), 2)
 File.Time = RIGHT$(STR$(WorkHour + 100), 2) + ":" + RIGHT$(STR$(WorkMinute + 100), 2) + ":" + RIGHT$(STR$(WorkSeconds + 100), 2)

 ' make display line
 File3$ = DTAfile.ASCIIZfilename
 File3$ = LEFT$(File3$, INSTR(File3$, CHR$(0)) - 1)
 File3$ = LCASE$(File3$)
 MID$(File3$, 1, 1) = UCASE$(MID$(File3$, 1, 1))
 Display.Line$ = File3$ + SPACE$(14 - LEN(File3$))
 VarQ$=Left$(VarQ$,12)
 VarQ$=Space$(12-Len(VarQ$))+VarQ$
 Display.Line$ = Display.Line$ + File.Date + "  " + File.Time + " " + VarQ$

 ' check attribute bits
 VarZ1$ = Space$(4)
 IF (Attribute AND 1) = 1 THEN ' read-only
    Mid$(VarZ1$,1,1)="O"
 END IF
 IF (Attribute AND 2) = 2 THEN ' hidden
    Mid$(VarZ1$,2,1)="H"
 END IF
 IF (Attribute AND 4) = 4 THEN ' system
    Mid$(VarZ1$,3,1)="S"
 END IF
 IF (Attribute AND &H20) = &H20 THEN ' archive
    Mid$(VarZ1$,4,1)="A"
 END IF
 VarZ1$ = "  " + VarZ1$
 VarZ1$ = Rtrim$(VarZ1$)

 ' make display line
 Display.Line$ = Display.Line$ + VarZ1$

 ' display filename info
 COLOR 14, 0
 PRINT Display.Line$
 Line.Count = Line.Count + 1
 RETURN

PrintTotals:
 Color 14,0
 If VarQ3=0 Then
    Print "No files found."
    Return
 Endif

 Color 15,0
 Print String$(12,"-") + Space$(24) + STRING$(11,"-")
 Call Amount(Total.Files#,Total.Line$)
 Total.Line$ = Ltrim$(Total.Line$)
 If Total.Files# = 1# Then
    Total.Line$ = Total.Line$ + " File  "
 Else
    Total.Line$ = Total.Line$ + " Files  "
 Endif
 Call Amount(Total.Dirs#,Var$)
 Var$ = Ltrim$(Var$)
 Total.Line$ = Total.Line$ + Var$
 If Total.Dirs# = 1# Then
    Total.Line$ = Total.Line$ + " Dir"
 Else
    Total.Line$ = Total.Line$ + " Dirs"
 Endif
 Total.Line$ = Left$(Total.Line$, 35)
 Total.Line$ = Total.Line$ + SPACE$(35 - LEN(Total.Line$))
 Call Make.Format(Total.Bytes#, Strng2$)
 Print Total.Line$ + Space$(12-Len(Strng2$)) + Strng2$
 Return

GetConfig:
 DND.Path$ = ENVIRON$("DNDBBS")
 IF DND.Path$ <> "" THEN
    IF RIGHT$(DND.Path$, 1) <> "\" THEN
       DND.Path$ = DND.Path$ + "\"
    END IF
 END IF
 Filename2$ = DND.Path$ + "DND.CFG"
 CommandLine$ = COMMAND$
 Select Case CommandLine$
 Case "?", "/?", "-?"
    Goto Boot.Usage
 End Select
 IF LEN(CommandLine$) THEN
    Select Case Len(CommandLine$)
    Case 1
       Select Case CommandLine$
       Case "0" to "9", "A" to "Z"
          Filename2$ = DND.Path$ + "DND" + CommandLine$ + ".CFG"
       Case Else
          Filename2$ = DND.Path$ + "DND" + CommandLine$ + ".CFG"
          Error 53
       End Select
    Case 2
       Select Case CommandLine$
       Case "10" to "99"
          Filename2$ = DND.Path$ + "DND" + CommandLine$ + ".CFG"
       Case Else
          Filename2$ = DND.Path$ + "DND" + CommandLine$ + ".CFG"
          Error 53
       End Select
    Case Else
       Filename2$ = DND.Path$ + "DND" + CommandLine$ + ".CFG"
       Error 53
    End Select
 END IF
 CLOSE #1
 OPEN Filename2$ FOR INPUT SHARED AS #1
 LINE INPUT #1, Var$
 FOR Temp1 = 1 TO MaxConfigArray1
    INPUT #1, Var!
 NEXT
 FOR Temp1 = 1 TO MaxConfigArray2
    INPUT #1, Var%
 NEXT
 FOR Temp1 = 1 TO MaxConfigArray3
    LINE INPUT #1, Var$
    IF Temp1 = 11 THEN
       Data.Path1$ = Var$
    END IF
    IF Temp1 = 15 THEN
       File.Extension1$ = Var$
    END IF
    IF Temp1 = 19 THEN
       DataFile1$ = Var$
    END IF
    IF Temp1 = 20 THEN
       DataFile2$ = Var$
    END IF
    IF Temp1 = 85 THEN
       ANSIPrefixChar = Rtrim$(Var$)
    END IF
 NEXT
 FOR Temp1 = 1 TO 10
    FOR Temp2 = 1 TO 4
       INPUT #1, Var
    NEXT
 NEXT
 FOR Temp1 = 1 TO 20
    LINE INPUT #1, Var$
 NEXT
 FOR Temp1 = 1 TO 10
    LINE INPUT #1, Var$
 NEXT
 FOR Temp1 = 1 TO 8
    LINE INPUT #1, Var$
 NEXT
 FOR Temp1 = 1 TO 10
    LINE INPUT #1, Class.Name(Temp1)
 NEXT
 For Temp1=1 To 7
    Line Input #1,Var$
 Next
 For Temp1=1 To 12
    Line Input #1,Var$
 Next
 For Temp1=1 To 10
    Line Input #1,Var$
 Next
 For Temp1=1 To 4
    Line Input #1,Var$
 Next
 For Temp1=1 To 3
    Line Input #1,Var$
 Next
 For Temp1=1 To 3
    Line Input #1,Var$
 Next
 For Temp1=1 To MaxUserCommands
    Line Input #1,Var$
    For Temp2=1 To 3
       Line Input #1,Var$
    Next
    Input #1,Var%
    For Temp2=1 To 8
       Input #1,Var%
    Next
    For Temp2=1 To 4
       Input #1,Var%
    Next
    Input #1,Var%
    Input #1,Var%
 Next
 For Temp1=1 To MaxDMCommands
    Line Input #1,Var$
    Input #1,Var%
    For Temp2=1 To 3
       Input #1,Var%
    Next
 Next
 For Temp1=1 To MaxSysopCommands
    Line Input #1,Var$
    Input #1,Var%
 Next
 For Temp1=1 To MaxNodeCOmmands
    Line Input #1,Var$
    For Temp2=1 To 8
       Input #1,Var%
    Next
 Next
 For Temp1=1 To MaxLetters
    Input #1,Var%
 Next
 For Temp1=1 To MaxStrips
    Line Input #1,Var$
 Next
 For Temp1=1 To 10
    Line Input #1,Var$
    Input #1,Var%
    Input #1,Var%
 Next
 For Temp1=1 To 10
    Line Input #1,InventoryNames(Temp1)
 Next
 DndSpellFile$ = Data.Path1$ + DataFile2$ + File.Extension1$
 DndTreasureFile$ = Data.Path1$ + DataFile1$ + File.Extension1$
 RETURN

Boot.Usage:
 Color 15
 Print "Import "+Version$+" usage:"
 Color 14
 Print "  Import [<node>]"
 Color 15
 Print "Where:"
 Color 14
 Print "  <node> is optional config file override"
 Print "   and is 0-9,A-Z,10-99."
 Color 7
 End

WriteFiles:
 ' write spell file.
 If Imported1 Then
    CLOSE
    OPEN TempSpellFile$ FOR RANDOM AS #1 LEN = SpellRecLen
    OPEN DndSpellFile$ FOR RANDOM AS #2 LEN = SpellRecLen
    FOR Var! = 1! TO LOF(1) / SpellRecLen
       GET #1, Var!, SpellRecord
       Var3! = LOF(2) / SpellRecLen + 1!
       PUT #2, Var3!, SpellRecord
    NEXT
    PRINT "Spell data file imported to dndbbs data files."
 Endif
 ' write treasure file.
 If Imported2 Then
    CLOSE
    OPEN TempTreasureFile$ FOR RANDOM AS #1 LEN = TreasureRecLen
    OPEN DndTreasureFile$ FOR RANDOM AS #2 LEN = TreasureRecLen
    FOR Var! = 1! TO LOF(1) / TreasureRecLen
       GET #1, Var!, TreasureRecord
       Var3! = LOF(2) / TreasureRecLen + 1!
       PUT #2, Var3!, TreasureRecord
    NEXT
    PRINT "Treasure data file imported to dndbbs data files."
 Endif
 RETURN

MainError:
 Temp$ = SPACE$(79)
 CALL Display.Status.Line(0, Temp$)
 Locate Max.Row,1,1
 PRINT
 COLOR 15, 0
 PRINT "Import "+Version$+" error:"
 COLOR 14, 0
 SELECT CASE ERR
 CASE 7
    PRINT "Out of memory."
 CASE 9
    PRINT "Subscript out of range."
 CASE 52
    PRINT "Bad file name or number."
 CASE 53
    PRINT "File '"+Filename2$+"' not found."
 CASE 55
    PRINT "File already open."
 CASE 57
    PRINT "Device I/O error."
 CASE 61
    PRINT "Disk full."
 CASE 62
    PRINT "Input past eof."
 CASE 67
    PRINT "Not enough file handles."
 CASE 68
    PRINT "Device unavailable."
 CASE 70
    PRINT "Permission denied."
 CASE 71
    PRINT "Disk not ready."
 CASE 75
    PRINT "Path/File access error."
 CASE 76
    PRINT "Pathname not found."
 CASE ELSE
    PRINT "Untrapped error" + STR$(ERR) + "."
 END SELECT
 COLOR 15
 PRINT "Exiting Import Program."
 COLOR 7
 END

' define clock display function
Function FClock$
 FClock$=Format$(Now,"ddd dd mmm yyyy\, hh:mm:ss")
End Function

' define formatting function
FUNCTION Form$ (Var#)
 Form$ = Format$(Var#, "#,##0;;" + CHR$(34) + "zero" + CHR$(34))
END FUNCTION

SUB ChangeSpell (Var!)
 On Local Error Goto ErrorTrap10
 GET #1, Var!, SpellRecord
 DO
    CALL DisplaySpell(Var!)
    COLOR 15, 0
    PRINT "Spell change option(q to quit)? "; 
    Out2$ = KeyboardLine$ : Print
    SELECT CASE UCASE$(Out2$)
    CASE "A"
       PRINT "Spell name(30 characters)? ";
       Out2$ = KeyboardLine$ : Print
       Out2$ = LCASE$(Out2$)
       SpellRecord.SpellName = Out2$
    CASE "B"
       PRINT "Spell chant(80 characters)? ";
       Out2$ = KeyboardLine$ : Print
       Out2$ = UCASE$(Out2$)
       SpellRecord.Chant = Out2$
    CASE "C"
       PRINT "Spell cast description(80 characters)? ";
       Out2$ = KeyboardLine$ : Print
       SpellRecord.Desc = Out2$
    CASE "D"
       PRINT "Spell level(1-32767)? ";
       Out2$ = KeyboardLine$ : Print
       SpellRecord.Level = INT(VAL(Out2$))
    CASE "E"
       CALL SpellTypes
       PRINT "Spell type option(q to quit)? ";
       Out2$ = KeyboardLine$ : Print
       Out2$ = UCASE$(Out2$)
       Temp5 = INSTR("ABCDEFGHIJKLMNOPRSTUVWXYZ12345678Q", Out2$)
       IF Temp5 THEN
          IF Temp5 <= 33 THEN
	     SpellRecord.SpellType = Temp5
	     IF Temp5 = 10 THEN
		SpellRecord.Teleport = 0
		DO
		   PRINT "[R]oom prompt for teleport"
		   PRINT "[T]eleport to room number"
                   PRINT "Spell teleport option(q to quit)? ";
                   Out2$ = KeyboardLine$ : Print
		   SELECT CASE UCASE$(Out2$)
		   CASE "R"
		      SpellRecord.Teleport = -1
                   CASE "T"
                      PRINT "Room number it teleports to? ";
                      Out2$ = KeyboardLine$ : Print
		      Var2! = INT(VAL(Out2$))
		      SpellRecord.Teleport = Var2!
		   CASE "Q"
		      EXIT DO
		   END SELECT
		LOOP
	     END IF
	  END IF
       END IF
    CASE "F"
       PRINT "Spell is psionic spell(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       SpellRecord.Psionic = 0
       SpellRecord.PsionicMode = 0
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  SpellRecord.Psionic = -1
	  SpellRecord.PsionicMode = 0
	  SpellRecord.SpellType = 15
	  DO
	     PRINT "[A]ttack mode"
	     PRINT "[D]efense mode"
             PRINT "Spell psionic option(q to quit)? ";
             Out2$ = KeyboardLine$ : Print
	     SELECT CASE UCASE$(Out2$)
	     CASE "A"
		SpellRecord.PsionicMode = 1
	     CASE "D"
		SpellRecord.PsionicMode = 2
	     CASE "Q"
		EXIT DO
	     END SELECT
	  LOOP
       END IF
    CASE "G"
       DO
	  FOR Temp5 = 1 TO 8
	     PRINT "[" + CHR$(64 + Temp5) + "]" + RTRIM$(Class.Name(Temp5))
	  NEXT
	  PRINT "[N]one"
	  PRINT "[X]All"
          PRINT "Spell class option(q to quit)? ";
          Out2$ = KeyboardLine$ : Print
	  Out2$ = UCASE$(Out2$)
	  SELECT CASE Out2$
	  CASE "A" TO "H"
	     Temp5 = INSTR("ABCDEFGH", Out2$)
	     SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ Temp5
	  CASE "N"
	     SpellRecord.ClassType = 0
	  CASE "X"
	     FOR Temp5 = 1 TO 8
		SpellRecord.ClassType = SpellRecord.ClassType OR 2 ^ Temp5
	     NEXT
	  CASE "Q"
	     EXIT DO
	  END SELECT
       LOOP
    CASE "H"
       PRINT "Enter five treasure items for spell ingredients:"
       PRINT "Press <enter> for none."
       FOR Temp9 = 1 TO 5
	  CALL FindTreasure(Var2!)
	  SpellRecord.Ingred(Temp9) = Var2!
       NEXT
    CASE "I"
       DO
	  PRINT "[A]use command"
	  PRINT "[B]read scroll"
	  PRINT "[C]cast spell"
	  PRINT "[N]one"
	  PRINT "[X]All"
          PRINT "Spell ingredient option(q to quit)? ";
          Out2$ = KeyboardLine$ : Print
	  SELECT CASE UCASE$(Out2$)
	  CASE "A"
	     SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 1
	  CASE "B"
	     SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 2
	  CASE "C"
	     SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 4
	  CASE "N"
	     SpellRecord.SpellFlag = 0
	  CASE "X"
	     SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 1
	     SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 2
	     SpellRecord.SpellFlag = SpellRecord.SpellFlag OR 4
	  CASE "Q"
	     EXIT DO
	  END SELECT
       LOOP
    CASE "J"
       PRINT "Spell has offense equation(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       SpellRecord.Equation = 0
       SpellRecord.SpellEquate = ""
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
          PRINT "Enter spell equation? ";
          Out2$ = KeyboardLine$ : Print
	  IF LEN(Out2$) THEN
	     SpellRecord.Equation = -1
	     SpellRecord.SpellEquate = UCASE$(Out2$)
	  END IF
       END IF
    CASE "K"
       PRINT "ANSI prefix code(8 characters, ? for help)? ";
       Out2$ = KeyboardLine$ : Print
       Out2$ = UCASE$(Out2$)
       IF Out2$ = "?" THEN
	  CALL DisplayPrefix
       ELSE
	  SpellRecord.Prefix1 = Out2$
       END IF
    CASE "Q"
       EXIT DO
    END SELECT
 LOOP
 PUT #1, Var!, SpellRecord
 PRINT "Spell '" + RTRIM$(SpellRecord.SpellName) + "' changed."
ErrorResume10:
 Exit Sub
ErrorTrap10:
 Print "Error ChangeSpell;";Err
 Resume ErrorResume10
END SUB

SUB ChangeTreasure (Var!)
 On Local Error Goto ErrorTrap11
 GET #2, Var!, TreasureRecord
 DO
    CALL DisplayTreasure(Var!)
    COLOR 15, 0
    PRINT "Treasure change option(q to quit)? ";
    Out2$ = KeyboardLine$ : Print
    SELECT CASE UCASE$(Out2$)
    CASE "A"
       PRINT "Treasure name(30 characters)? ";
       Out2$ = KeyboardLine$ : Print
       Out2$ = LCASE$(Out2$)
       TreasureRecord.TreasureName = Out2$
    CASE "B"
       PRINT "Treasure identifier(30 characters)? ";
       Out2$ = KeyboardLine$ : Print
       Out2$ = UCASE$(Out2$)
       TreasureRecord.ShortName = Out2$
    CASE "C"
       PRINT "Weight(1-32767)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Weight = INT(VAL(Out2$))
    CASE "D"
       PRINT "Gold value(1-32767)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Gold = INT(VAL(Out2$))
    CASE "E"
       DO
	  PRINT "[1]Container"
	  PRINT "[A]rmor"
	  PRINT "[B]oots"
	  PRINT "[C]loak"
	  PRINT "[H]elmet"
	  PRINT "[R]ing"
	  PRINT "[S]hield"
	  PRINT "[T]Bracers"
	  PRINT "[U]Amulet"
	  PRINT "[W]eapon"
	  PRINT "[X]None"
          PRINT "Treasure type option(q to quit)? ";
          Out2$ = KeyboardLine$ : Print
	  Out2$ = UCASE$(Out2$)
	  SELECT CASE Out2$
	  CASE "Q"
	     EXIT DO
	  CASE "X"
	     TreasureRecord.WeaponNumber = 0
	     TreasureRecord.Container = 0
	     TreasureRecord.ContainerMax = 0
	     TreasureRecord.ContainerSize = 0
	     TreasureRecord.TwoHanded = 0
	     TreasureRecord.RequireStr = 0
	     TreasureRecord.RequireDex = 0
	     TreasureRecord.RequireInt = 0
	  CASE "1"
	     TreasureRecord.WeaponNumber = 0
	     TreasureRecord.TwoHanded = 0
	     TreasureRecord.Container = -1
	  CASE ELSE
	     IF LEN(Out2) = 1 THEN
		Var = INSTR("ABHRSTWCU", Out2$)
		IF Var THEN
		   IF Var = 9 THEN
		      Var = 10
		   END IF
		   TreasureRecord.Container = 0
		   TreasureRecord.ContainerMax = 0
		   TreasureRecord.ContainerSize = 0
		   TreasureRecord.WeaponNumber = Var
		   TreasureRecord.TwoHanded = 0
		   IF Var = 4 THEN
                      PRINT "Ring type (L)eft, (R)ight handed? ";
                      Out2$ = KeyboardLine$ : Print
		      Out2$ = UCASE$(Out2$)
		      IF Out2$ = "R" THEN
			 TreasureRecord.WeaponNumber = 9
		      END IF
		   END IF
		   IF Var = 7 THEN
                      PRINT "Two-Handed weapon(y/n)? ";
                      Out2$ = KeyboardLine$ : Print
		      IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
			 TreasureRecord.TwoHanded = -1
		      ELSE
			 TreasureRecord.TwoHanded = 0
		      END IF
		   END IF
                   PRINT "Requires minimum strength(0-32767)? ";
                   Out2$ = KeyboardLine$ : Print
		   TreasureRecord.RequireStr = INT(VAL(Out2$))
                   PRINT "Requires minimum dexterity(0-32767)? ";
                   Out2$ = KeyboardLine$ : Print
		   TreasureRecord.RequireDex = INT(VAL(Out2$))
                   PRINT "Requires minimum intelligence(0-32767)? ";
                   Out2$ = KeyboardLine$ : Print
		   TreasureRecord.RequireInt = INT(VAL(Out2$))
		END IF
	     END IF
	  END SELECT
       LOOP
    CASE "F"
       PRINT "Hit plus(1-32767)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Plus = INT(VAL(Out2$))
    CASE "G"
       PRINT "Charges(0-32767,-1=safe vehicle)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Charges = INT(VAL(Out2$))
    CASE "H"
       DO
	  PRINT "[B]lunt"
	  PRINT "[P]ole"
	  PRINT "[S]harp"
	  PRINT "[T]hrusting"
	  PRINT "[N]one"
          PRINT "Treasure weapon class option(q to quit)? ";
          Out2$ = KeyboardLine$ : Print
	  SELECT CASE UCASE$(Out2$)
	  CASE "B"
	     TreasureRecord.Proficiency = 1
	  CASE "P"
	     TreasureRecord.Proficiency = 2
	  CASE "S"
	     TreasureRecord.Proficiency = 3
	  CASE "T"
	     TreasureRecord.Proficiency = 4
	  CASE "N"
	     TreasureRecord.Proficiency = 0
	  CASE "Q"
	     EXIT DO
	  END SELECT
       LOOP
    CASE "I"
       PRINT "Treasure is permanent(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Permanent = -1
       ELSE
	  TreasureRecord.Permanent = 0
       END IF
       PRINT "Treasure stays in room(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.StaysInRoom = -1
       ELSE
	  TreasureRecord.StaysInRoom = 0
       END IF
    CASE "J"
       PRINT "Treasure is edible(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Edible = -1
       ELSE
	  TreasureRecord.Edible = 0
       END IF
    CASE "K"
       PRINT "Treasure is magical(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Spell = 0!
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  CALL FindSpell(Var2!)
	  IF Var2! = 0! THEN
	     PRINT "Spell not found."
	  ELSE
	     TreasureRecord.Spell = Var2!
	  END IF
       END IF
    CASE "L"
       PRINT "Treasure is ring(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.RingType = 0
       TreasureRecord.RingSpell = 0
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  DO
	     PRINT "Protection against:"
	     PRINT "[A]ny spell" ' 3
	     PRINT "[F]umbling" ' 8
	     PRINT "[I]nventory damage" ' 7
	     PRINT "[L]evel drain" ' 2
	     PRINT "[O]ffense/invisible spell" ' 3
	     PRINT "[P]oison" ' 1
	     PRINT "[R]usting" ' 5
	     PRINT "[S]tealing" ' 6
	     PRINT "[T]eleporting" ' 9
	     PRINT "[X]All traps" ' 4
             PRINT "Treasure ring option(q to quit)? ";
             Out2$ = KeyboardLine$ : Print
	     SELECT CASE UCASE$(Out2$)
	     CASE "A"
		TreasureRecord.RingSpell = -1
		TreasureRecord.RingType = 3
	     CASE "F"
		TreasureRecord.RingSpell = -1
		TreasureRecord.RingType = 8
	     CASE "I"
		TreasureRecord.RingSpell = -1
		TreasureRecord.RingType = 7
	     CASE "O"
		CALL FindSpell(Var2!)
		IF Var2! = 0! THEN
		   PRINT "Spell not found."
		ELSE
		   IF SpellRecord.SpellType = Offense THEN
		      TreasureRecord.RingSpell = Var2!
		      TreasureRecord.RingType = 3
		   ELSE
		      IF SpellRecord.SpellType = Invisibly THEN
			 TreasureRecord.RingSpell = Var2!
			 TreasureRecord.RingType = 3
		      ELSE
			 PRINT "Spell is not an offense/invisible type."
		      END IF
		   END IF
		END IF
	     CASE "L"
		TreasureRecord.RingSpell = 0
		TreasureRecord.RingType = 2
	     CASE "P"
		TreasureRecord.RingSpell = 0
		TreasureRecord.RingType = 1
	     CASE "R"
		TreasureRecord.RingSpell = -1
		TreasureRecord.RingType = 5
	     CASE "S"
		TreasureRecord.RingSpell = -1
		TreasureRecord.RingType = 6
	     CASE "T"
		TreasureRecord.RingSpell = -1
		TreasureRecord.RingType = 9
	     CASE "X"
		TreasureRecord.RingSpell = -1
		TreasureRecord.RingType = 4
	     CASE "Q"
		EXIT DO
	     END SELECT
	  LOOP
       END IF
    CASE "M"
       PRINT "Treasure is a light(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.LightType = 0
       TreasureRecord.LightCharges = 0
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
          PRINT "Light charges(1-32767)? ";
          Out2$ = KeyboardLine$ : Print
	  TreasureRecord.LightType = -1
	  TreasureRecord.LightCharges = INT(VAL(Out2$))
       END IF
    CASE "N"
       PRINT "Treasure is a vehicle(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Vehicle = 0
       TreasureRecord.VehicleType = 0
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Vehicle = -1
	  PRINT "[A]ir terrain"
	  PRINT "[L]and terrain"
	  PRINT "[W]ater terrain"
	  PRINT "[X]all terrain"
          PRINT "Enter vehicle terrain type(A/L/W/X)? ";
          Out2$ = KeyboardLine$ : Print
	  SELECT CASE UCASE$(Out2$)
	  CASE "A"
	     TreasureRecord.VehicleType = Air
	  CASE "L"
	     TreasureRecord.VehicleType = Land
	  CASE "W"
	     TreasureRecord.VehicleType = Water
	  CASE "X"
	     TreasureRecord.VehicleType = AllTerrain
	  END SELECT
       END IF
    CASE "O"
       PRINT "Ammunition(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Ammunition = -1
       ELSE
	  TreasureRecord.Ammunition = 0
       END IF
    CASE "P"
       PRINT "Treasure is a loadable device(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Loadable = 0
       TreasureRecord.AmmoLoads = 0!
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  PUT #2, Var!, TreasureRecord
	  PRINT "Treasure which loads this device:"
	  CALL FindTreasure(Var2!)
	  IF Var2! = 0! THEN
	     GET #2, Var!, TreasureRecord
	     TreasureRecord.Loadable = 0
	     TreasureRecord.AmmoLoads = 0!
	  ELSE
	     GET #2, Var2!, TreasureRecord
	     IF TreasureRecord.Ammunition = 0 THEN
		GET #2, Var!, TreasureRecord
		PRINT "That treasure is not ammunition."
		TreasureRecord.Loadable = 0
		TreasureRecord.AmmoLoads = 0!
	     ELSE
		GET #2, Var!, TreasureRecord
		TreasureRecord.Loadable = -1
		TreasureRecord.AmmoLoads = Var2!
	     END IF
	  END IF
	  PUT #2, Var!, TreasureRecord
       END IF
    CASE "R"
       PRINT "Treasure launchs from devices(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.LaunchAmmo = -1
       ELSE
	  TreasureRecord.LaunchAmmo = 0
       END IF
    CASE "S"
       PRINT "Treasure is a launchable device(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Launchable = 0
       TreasureRecord.LaunchLoads = 0!
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  PUT #2, Var!, TreasureRecord
	  PRINT "Treasure which launchs from this device?"
	  CALL FindTreasure(Var2!)
	  IF Var2! = 0! THEN
	     GET #2, Var!, TreasureRecord
	     TreasureRecord.Launchable = 0
	     TreasureRecord.LaunchLoads = 0!
	  ELSE
	     GET #2, Var2!, TreasureRecord
	     IF TreasureRecord.LaunchAmmo = 0 THEN
		GET #2, Var!, TreasureRecord
		PRINT "That treasure does not launch from devices."
		TreasureRecord.Launchable = 0
		TreasureRecord.LaunchLoads = 0!
	     ELSE
		GET #2, Var!, TreasureRecord
		TreasureRecord.Launchable = -1
		TreasureRecord.LaunchLoads = Var2!
	     END IF
	  END IF
	  PUT #2, Var!, TreasureRecord
       END IF
    CASE "T"
       PRINT "Launchable device can be moved(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Movable = -1
       ELSE
	  TreasureRecord.Movable = 0
       END IF
    CASE "U"
       PRINT "Treasure is coins(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Coin = -1
       ELSE
	  TreasureRecord.Coin = 0
       END IF
    CASE "V"
       PRINT "Treasure is potion(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Potion = -1
       ELSE
	  TreasureRecord.Potion = 0
       END IF
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
          PRINT "Treasure is a liquid(y/n)? ";
          Out2$ = KeyboardLine$ : Print
	  IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	     TreasureRecord.Liquid = -1
	  ELSE
	     TreasureRecord.Liquid = 0
	  END IF
	  IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
             PRINT "Drinking type(1=sip,2=gulp)? ";
             Out2$ = KeyboardLine$ : Print
	     Var = INT(VAL(Out2$))
	     SELECT CASE Var
	     CASE 1, 2
		TreasureRecord.LiquidType = Var
	     CASE ELSE
		TreasureRecord.LiquidType = 1
	     END SELECT
	  ELSE
             PRINT "Potion can be poured into another(y/n)? ";
             Out2$ = KeyboardLine$ : Print
	     TreasureRecord.PotionType = 0!
	     IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
		PUT #2, Var!, TreasureRecord
		PRINT "Potion name to pour into:"
		CALL FindTreasure(Var2!)
		IF Var2! = 0! THEN
		   GET #2, Var!, TreasureRecord
		   TreasureRecord.PotionType = 0!
		ELSE
		   GET #2, Var2!, TreasureRecord
		   IF TreasureRecord.Potion = 0 THEN
		      GET #2, Var!, TreasureRecord
		      PRINT "That treasure is not a potion."
		      TreasureRecord.PotionType = 0!
		   ELSE
		      GET #2, Var!, TreasureRecord
		      TreasureRecord.PotionType = Var2!
		   END IF
		END IF
		PUT #2, Var!, TreasureRecord
	     END IF
             PRINT "Potion can be mixed(y/n)? ";
             Out2$ = KeyboardLine$ : Print
	     IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
		TreasureRecord.MixPotion = -1
	     ELSE
		TreasureRecord.MixPotion = 0
	     END IF
             PRINT "Potion becomes another(y/n)? ";
             Out2$ = KeyboardLine$ : Print
	     TreasureRecord.NewPotion = 0
	     IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
		PUT #2, Var!, TreasureRecord
		PRINT "New potion name:"
		CALL FindTreasure(Var2!)
		IF Var2! = 0! THEN
		   GET #2, Var!, TreasureRecord
		   TreasureRecord.NewPotion = 0!
		ELSE
		   GET #2, Var2!, TreasureRecord
		   IF TreasureRecord.Potion = 0 THEN
		      GET #2, Var!, TreasureRecord
		      PRINT "That treasure is not a potion."
		      TreasureRecord.NewPotion = 0!
		   ELSE
		      GET #2, Var!, TreasureRecord
		      TreasureRecord.NewPotion = Var2!
		   END IF
		END IF
	     END IF
	  END IF
	  PUT #2, Var!, TreasureRecord
       END IF
    CASE "W"
       PRINT "Treasure is scroll(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Scroll = -1
       ELSE
	  TreasureRecord.Scroll = 0
       END IF
    CASE "X"
       PRINT "Treasure is invisible(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Invisible = -1
       ELSE
	  TreasureRecord.Invisible = 0
       END IF
    CASE "Y"
       PRINT "Item is a master key(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.MasterKey = -1
	  TreasureRecord.KeyNumber = 0
       ELSE
	  TreasureRecord.MasterKey = 0
          PRINT "Key number(1-999999)? ";
          Out2$ = KeyboardLine$ : Print
	  TreasureRecord.KeyNumber = INT(VAL(Out2$))
       END IF
    CASE "Z"
       PRINT "Treasure is fuel(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.FuelType = 0
       TreasureRecord.FuelCharges = 0
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
          PRINT "Fuel charges(1-32767)? ";
          Out2$ = KeyboardLine$ : Print
	  TreasureRecord.FuelType = -1
	  TreasureRecord.FuelCharges = INT(VAL(Out2$))
       END IF
    CASE "1"
       PRINT "Treasure can rust(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Rustable = 0
       TreasureRecord.RustPercent = 0
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
          PRINT "Percent chance weapon will rust during room rust rate(1-100)? ";
          Out2$ = KeyboardLine$ : Print
	  Temp = INT(VAL(Out2$))
	  IF Temp >= 1 AND Temp <= 100 THEN
	     TreasureRecord.Rustable = -1
	     TreasureRecord.RustPercent = Temp
	  ELSE
	     TreasureRecord.Rustable = 0
	     TreasureRecord.RustPercent = 0
	  END IF
       END IF
    CASE "2"
       PRINT "Treasure can be stolen(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.Stealable = 0
       TreasureRecord.StealPercent = 0
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
          PRINT "Percent chance treasure stolen during room steal rate(1-100)? ";
          Out2$ = KeyboardLine$ : Print
	  Temp = INT(VAL(Out2$))
	  IF Temp >= 1 AND Temp <= 100 THEN
	     TreasureRecord.Stealable = -1
	     TreasureRecord.StealPercent = Temp
	  ELSE
	     TreasureRecord.Stealable = 0
	     TreasureRecord.StealPercent = 0
	  END IF
       END IF
    CASE "3"
       PRINT "Container disappears with another when placed in each other(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.ContainerDisappears = 0!
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  PUT #2, Var!, TreasureRecord
	  PRINT "Container name which disappears:"
	  CALL FindTreasure(Var2!)
	  IF Var2! = 0! THEN
	     GET #2, Var!, TreasureRecord
	     TreasureRecord.ContainerDisappears = 0!
	     PRINT "Treasure item not found."
	  ELSE
	     GET #2, Var2!, TreasureRecord
	     IF TreasureRecord.Container = 0 THEN
		GET #2, Var!, TreasureRecord
		TreasureRecord.ContainerDisappears = 0!
		PRINT "Treasure item is not another container."
	     ELSE
		GET #2, Var!, TreasureRecord
		TreasureRecord.ContainerDisappears = Var2!
	     END IF
	  END IF
	  PUT #2, Var!, TreasureRecord
       END IF
    CASE "4"
       PRINT "Container is locked(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
	  TreasureRecord.Locked = -1
       ELSE
	  TreasureRecord.Locked = 0
       END IF
       Strng$ = "Container is trapped: "
       IF TreasureRecord.TrapType = 0 THEN
	  Strng$ = Strng$ + "No"
       END IF
       IF TreasureRecord.TrapType THEN
	  SELECT CASE TreasureRecord.TrapType
	  CASE 1
	     Strng$ = Strng$ + "poison needles."
	  CASE 2
	     Strng$ = Strng$ + "hits for"
	  CASE 3
	     Strng$ = Strng$ + "explodes for"
	  CASE 4
	     Strng$ = Strng$ + "shooting weapon: "
	     Var1! = TreasureRecord.TrapItem
	     IF Var1! > 0! AND Var1! <= LOF(2) / TreasureRecLen THEN
		PUT #2, Var!, TreasureRecord
		GET #2, Var1!, TreasureRecord
		Out3$ = TreasureRecord.TreasureName
		Out3$ = RTRIM$(Out3$)
		Out3$ = LCASE$(Out3$)
		Strng$ = Strng$ + Out3$
		GET #2, Var!, TreasureRecord
	     END IF
	  END SELECT
	  SELECT CASE TreasureRecord.TrapType
	  CASE 2, 3
	     IF TreasureRecord.TrapHits = 0 THEN
		Strng$ = Strng$ + " no hits."
	     ELSE
		IF TreasureRecord.TrapHits > 0 THEN
		   Strng$ = Strng$ + STR$(TreasureRecord.TrapHits) + " fatigue."
		ELSE
		   IF TreasureRecord.TrapHits < 0 THEN
		      Strng$ = Strng$ + STR$(ABS(TreasureRecord.TrapHits)) + " vitality."
		   END IF
		END IF
	     END IF
	  END SELECT
       END IF
       PRINT Strng$
       PRINT "Change trap type(y/n)? ";
       Out2$ = KeyboardLine$ : Print
       IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
          PRINT "Container is trapped(y/n)? ";
          Out2$ = KeyboardLine$ : Print
	  IF LEFT$(UCASE$(Out2$), 1) = "Y" THEN
             PRINT "Container trap is (P)oison/(H)its/(E)xplodes/(W)eapon? ";
             Out2$ = KeyboardLine$ : Print
	     SELECT CASE UCASE$(Out2$)
	     CASE "W"
		TreasureRecord.TrapType = 4
		PUT #2, Var!, TreasureRecord
		CALL FindTreasure(Var2!)
		GET #2, Var!, TreasureRecord
		TreasureRecord.TrapItem = Var2!
		PUT #2, Var!, TreasureRecord
	     CASE "P"
		TreasureRecord.TrapType = 1
		TreasureRecord.TrapHits = 0
	     CASE "H"
		TreasureRecord.TrapType = 2
                PRINT "Hits for (F)atigue/(V)itality? ";
                Out2$ = KeyboardLine$ : Print
		SELECT CASE UCASE$(Out2$)
		CASE "F"
                   PRINT "Hits of fat(1-32767)? ";
                   Out2$ = KeyboardLine$ : Print
		   IF INT(VAL(Out2$)) > 0 AND INT(VAL(Out2$)) <= 32767 THEN
		      TreasureRecord.TrapHits = INT(VAL(Out2$))
		   END IF
		CASE "V"
                   PRINT "Hits of vit(1-32767)? ";
                   Out2$ = KeyboardLine$ : Print
		   IF INT(VAL(Out2$)) > 0 AND INT(VAL(Out2$)) <= 32767 THEN
		      TreasureRecord.TrapHits = -INT(VAL(Out2$))
		   END IF
		END SELECT
	     CASE "E"
		TreasureRecord.TrapType = 3
                PRINT "Hits for (F)atigue/(V)itality/(N)one? ";
                Out2$ = KeyboardLine$ : Print
		SELECT CASE UCASE$(Out2$)
		CASE "N"
		   TreasureRecord.TrapHits = 0
		CASE "F"
                   PRINT "Hits of fat(1-32767)? ";
                   Out2$ = KeyboardLine$ : Print
		   IF INT(VAL(Out2$)) > 0 AND INT(VAL(Out2$)) <= 32767 THEN
		      TreasureRecord.TrapHits = INT(VAL(Out2$))
		   END IF
		CASE "V"
                   PRINT "Hits of vit(1-32767)? ";
                   Out2$ = KeyboardLine$ : Print
		   IF INT(VAL(Out2$)) > 0 AND INT(VAL(Out2$)) <= 32767 THEN
		      TreasureRecord.TrapHits = -INT(VAL(Out2$))
		   END IF
		END SELECT
	     END SELECT
	  ELSE
	     TreasureRecord.TrapType = 0
	     TreasureRecord.TrapHits = 0
	     TreasureRecord.TrapItem = 0!
	  END IF
       END IF
    CASE "5"
       PRINT "Max container items(1-32767/-1=unlimited)? ";
       Out2$ = KeyboardLine$ : Print
       Var = INT(VAL(Out2$))
       TreasureRecord.ContainerMax = Var
    CASE "6"
       PRINT "Container name prefix(in it)? ";
       Out2$ = KeyboardLine$ : Print
       TreasureRecord.ContainerPrefix = LCASE$(Out2$)
    CASE "7"
       PRINT "Container size:"
       PRINT "[0]any"
       PRINT "[1]small"
       PRINT "[2]medium"
       PRINT "[3]large"
       PRINT "Enter size(0,1,2,3)? ";
       Out2$ = KeyboardLine$ : Print
       Var = INT(VAL(Out2$))
       SELECT CASE Var
       CASE 0, 1, 2, 3
	  TreasureRecord.ContainerSize = Var
       CASE ELSE
	  TreasureRecord.ContainerSize = 0
       END SELECT
       PUT #2, Var!, TreasureRecord
       PRINT "Enter restricted items:"
       FOR VarQ = 1 TO 3
	  CALL FindTreasure(Var2!)
	  GET #2, Var!, TreasureRecord
	  TreasureRecord.RestrictItem(VarQ) = Var2!
	  PUT #2, Var!, TreasureRecord
       NEXT
       GET #2, Var!, TreasureRecord
    CASE "8"
       PRINT "ANSI prefix code(8 characters, ? for help)? ";
       Out2$ = KeyboardLine$ : Print
       Out2$ = UCASE$(Out2$)
       IF Out2$ = "?" THEN
	  CALL DisplayPrefix
       ELSE
	  TreasureRecord.Prefix1 = Out2$
       END IF
    CASE "Q"
       EXIT DO
    END SELECT
 LOOP
 PUT #2, Var!, TreasureRecord
 PRINT "Treasure '" + RTRIM$(TreasureRecord.TreasureName) + "' changed."
ErrorResume11:
 Exit Sub
ErrorTrap11:
 Print "Error ChangeTreasure;";Err
 Resume ErrorResume11
END SUB

' display status line
SUB Display.Status.Line (Var, Var$)
 IF Var THEN
    COLOR 14, 1
 ELSE
    COLOR 15, 0
 END IF
 LOCATE Max.Row, 1, 0
 PRINT Var$;
 LOCATE Max.Row, 80
 IF Var THEN
    COLOR 0, 1
 ELSE
    COLOR 7, 0
 END IF
 PRINT " ";
 LOCATE Max.Row-1, 1, 1
 COLOR 15, 0
END SUB

SUB DisplayPrefix
 COLOR 15, 0
 PRINT "ANSI prefix code(8 characters):"
 PRINT
 PRINT "fore-   back-   color     foreground"
 PRINT "ground  ground  value     hilight"
 PRINT "------  ------  ------    ----------"
 PRINT " " + ANSIPrefixChar + "F0     " + ANSIPrefixChar + "B0    Black     " + ANSIPrefixChar + "F8  Gray"
 PRINT " " + ANSIPrefixChar + "F1     " + ANSIPrefixChar + "B1    Blue      " + ANSIPrefixChar + "F9  Light blue"
 PRINT " " + ANSIPrefixChar + "F2     " + ANSIPrefixChar + "B2    Green     " + ANSIPrefixChar + "FA  Light green"
 PRINT " " + ANSIPrefixChar + "F3     " + ANSIPrefixChar + "B3    Cyan      " + ANSIPrefixChar + "FB  Light cyan"
 PRINT " " + ANSIPrefixChar + "F4     " + ANSIPrefixChar + "B4    Red       " + ANSIPrefixChar + "FC  Light red"
 PRINT " " + ANSIPrefixChar + "F5     " + ANSIPrefixChar + "B5    Magenta   " + ANSIPrefixChar + "FD  Light magenta"
 PRINT " " + ANSIPrefixChar + "F6     " + ANSIPrefixChar + "B6    Brown     " + ANSIPrefixChar + "FE  Yellow"
 PRINT " " + ANSIPrefixChar + "F7     " + ANSIPrefixChar + "B7    White     " + ANSIPrefixChar + "FF  High-intensity white"
 CALL MorePrompt(X)
END SUB

SUB DisplaySpell (Var!)
 On Local Error Goto ErrorTrap12
 COLOR 14, 0
 PRINT "Spell number" + STR$(Var!) + ":"
 PRINT "[A]Spell name: " + RTRIM$(SpellRecord.SpellName)
 PRINT "[B]Spell chant: " + RTRIM$(SpellRecord.Chant)
 PRINT "[C]Spell cast description: "
 PRINT RTRIM$(SpellRecord.Desc)
 PRINT "[D]Spell level:" + STR$(SpellRecord.Level)
 PRINT "[E]Spell type: ";
 SELECT CASE SpellRecord.SpellType
 CASE 1
    PRINT "Enchant"
 CASE 2
    PRINT "Offense"
 CASE 3
    PRINT "Bless"
 CASE 4
    PRINT "Wish"
 CASE 5
    PRINT "Poison"
 CASE 6
    PRINT "Vigor"
 CASE 7
    PRINT "Heal"
 CASE 8
    PRINT "Curepoison"
 CASE 9
    PRINT "Level Drain"
 CASE 10
    IF SpellRecord.Teleport < 0! THEN
       PRINT "Prompts for teleport room"
    ELSE
       PRINT "Teleport to Room" + STR$(SpellRecord.Teleport)
    END IF
 CASE 11
    PRINT "Befuddle"
 CASE 12
    PRINT "Turn Undead"
 CASE 13
    PRINT "Pass Door"
 CASE 14
    PRINT "Conjure"
 CASE 15
    PRINT "Psionic"
 CASE 16
    PRINT "Detect Lock"
 CASE 17
    PRINT "Detect Evil"
 CASE 18
    PRINT "Detect Trap"
 CASE 19
    PRINT "Intoxicate"
 CASE 20
    PRINT "Set Trap"
 CASE 21
    PRINT "Hide"
 CASE 22
    PRINT "Search"
 CASE 23
    PRINT "Invisibility"
 CASE 24
    PRINT "Identify"
 CASE 25
    PRINT "Enlighten"
 CASE 26
    PRINT "Illuminate"
 CASE 27
    PRINT "Psyche"
 CASE 28
    PRINT "Telepathy"
 CASE 29
    PRINT "Curse"
 CASE 30
    PRINT "Damnate"
 CASE 31
    PRINT "Resurrect"
 CASE 32
    PRINT "Grant Wish"
 CASE 33
    PRINT "Steal Wish"
 CASE ELSE
    PRINT "<none>"
 END SELECT
 PRINT "[F]Spell is psionic spell: ";
 IF SpellRecord.Psionic = 0 THEN
    PRINT "No"
 ELSE
    PRINT "Yes, ";
    SELECT CASE SpellRecord.PsionicMode
    CASE 1
       PRINT "Attack"
    CASE 2
       PRINT "Defense"
    CASE ELSE
       PRINT "<none>"
    END SELECT
 END IF
 PRINT "[G]Character classes which can cast this spell:"
 Strng$ = ""
 TempA = 0
 FOR Temp9 = 1 TO 8
    IF SpellRecord.ClassType AND 2 ^ Temp9 THEN
       Strng2$ = Class.Name(Temp9)
       Strng2$ = RTRIM$(Strng2$)
       MID$(Strng2$, 1, 1) = UCASE$(MID$(Strng2$, 1, 1))
       Strng$ = Strng$ + Strng2$ + ", "
       TempA = -1
    END IF
 NEXT
 IF TempA THEN
    Strng$ = LEFT$(Strng$, LEN(Strng$) - 2) + "."
 ELSE
    Strng$ = "<none>"
 END IF
 PRINT Strng$
 PRINT "[H]Spell ingredients:"
 Strng$ = ""
 TempA = 0
 FOR Temp9 = 1 TO 5
    TempB! = SpellRecord.Ingred(Temp9)
    IF TempB! > 0! THEN
       IF TempB! <= LOF(2) / TreasureRecLen THEN
	  GET #2, TempB!, TreasureRecord
	  Strng2$ = TreasureRecord.TreasureName
	  Strng2$ = RTRIM$(Strng2$)
	  Strng2$ = LCASE$(Strng2$)
	  MID$(Strng2$, 1, 1) = UCASE$(MID$(Strng2$, 1, 1))
	  Strng$ = Strng$ + Strng2$ + ", "
	  TempA = -1
       END IF
    END IF
 NEXT
 IF TempA THEN
    Strng$ = LEFT$(Strng$, LEN(Strng$) - 2) + "."
 ELSE
    Strng$ = "<none>"
 END IF
 PRINT Strng$
 PRINT "[I]Spell casting type which requires ingredients:"
 Strng$ = ""
 TempA = 0
 IF SpellRecord.SpellFlag AND Use.Spell.Type THEN
    Strng$ = "use command, "
    TempA = -1
 END IF
 IF SpellRecord.SpellFlag AND Scroll.Spell.Type THEN
    Strng$ = Strng$ + "read scroll, "
    TempA = -1
 END IF
 IF SpellRecord.SpellFlag AND Cast.Spell.Type THEN
    Strng$ = Strng$ + "cast spell, "
    TempA = -1
 END IF
 IF TempA THEN
    Strng$ = LEFT$(Strng$, LEN(Strng$) - 2) + "."
 ELSE
    Strng$ = "<none>"
 END IF
 PRINT Strng$
 PRINT "[J]Spell has offense equation: ";
 IF SpellRecord.Equation THEN
    PRINT "Yes"
 ELSE
    PRINT "No"
 END IF
 IF SpellRecord.Equation THEN
    Strng$ = SpellRecord.SpellEquate
    Strng$ = RTRIM$(Strng$)
    Strng$ = "Equation: " + Strng$
    PRINT Strng$
 END IF
 PRINT "[K]ANSI Prefix code: ";
 IF RTRIM$(SpellRecord.Prefix1) = "" THEN
    PRINT "<none>"
 ELSE
    PRINT RTRIM$(SpellRecord.Prefix1)
 END IF
ErrorResume12:
 Exit Sub
ErrorTrap12:
 Print "Error DisplaySpell;";Err
 Resume ErrorResume12
END SUB

SUB DisplayTreasure (Var!)
 On Local Error Goto ErrorTrap13
 COLOR 14, 0
 PRINT "Treasure number" + STR$(Var!) + ":"
 Strng$ = "[A]Treasure: " + TreasureRecord.TreasureName
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[U]Treasure is coins: "
 IF TreasureRecord.Coin THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[B]Identifier: " + LCASE$(TreasureRecord.ShortName)
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[V]Treasure is a potion: "
 IF TreasureRecord.Potion THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 IF TreasureRecord.Liquid THEN
    Strng$ = Strng$ + " (liquid)"
 END IF
 PRINT Strng$
 Strng$ = "[C]Weight: " + Form$(Cdbl(TreasureRecord.Weight))
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[W]Treasure is a scroll: "
 IF TreasureRecord.Scroll THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Call Amount(TreasureRecord.Gold,Var$)
 Strng$ = "[D]Gold coin value:" + Var$
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[X]Treasure is invisible: "
 IF TreasureRecord.Invisible THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[E]Treasure type: "
 VarQ = TreasureRecord.WeaponNumber
 IF VarQ >= 1 AND VarQ <= 10 THEN
    Var$ = RTRIM$(InventoryNames(VarQ))
    SELECT CASE VarQ
    CASE 2, 6
       Var$ = Var$ + "s"
    CASE 4
       Var$ = Var$ + "(left hand)"
    CASE 9
       Var$ = Var$ + "(right hand)"
    CASE 7
       IF TreasureRecord.TwoHanded THEN
	  Var$ = Var$ + "(two-handed)"
       END IF
    END SELECT
 ELSE
    IF TreasureRecord.Container THEN
       Var$ = "Container"
    ELSE
       IF TreasureRecord.Spell THEN
	  Var$ = "Magical"
       ELSE
	  IF TreasureRecord.Vehicle THEN
	     Var$ = "Vehicle"
	  ELSE
	     Var$ = "Treasure"
	  END IF
       END IF
    END IF
 END IF
 IF LEN(Var$) THEN
    MID$(Var$, 1, 1) = UCASE$(MID$(Var$, 1, 1))
    Strng$ = Strng$ + Var$
 END IF
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[Y]Treasure key number: "
 IF TreasureRecord.MasterKey THEN
    Strng$ = Strng$ + "<master>"
 ELSE
    IF TreasureRecord.KeyNumber > 0! THEN
       Strng$ = Strng$ + "(#" + RIGHT$(STR$(TreasureRecord.KeyNumber + 1000000!), 6) + ")"
    ELSE
       Strng$ = Strng$ + "No"
    END IF
 END IF
 PRINT Strng$
 Strng$ = "[F]Hit plus: " + Form$(Cdbl(ABS(TreasureRecord.Plus)))
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[Z]Treasure is fuel: "
 IF TreasureRecord.FuelType = 0 THEN
    Strng$ = Strng$ + "No"
 ELSE
    Strng$ = Strng$ + "Yes:" + STR$(TreasureRecord.FuelCharges) + " charges"
 END IF
 PRINT Strng$
 Strng$ = "[G]"
 IF TreasureRecord.Charges = -1 THEN
    IF TreasureRecord.Vehicle THEN
       Strng$ = Strng$ + "Charges: <safe>"
    ELSE
       Strng$ = Strng$ + "Charges: <bad range>"
    END IF
 ELSE
    Strng$ = Strng$ + "Charges: " + Form$(Cdbl(TreasureRecord.Charges))
 END IF
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[1]Weapon rusts: "
 IF TreasureRecord.Rustable THEN
    Strng$ = Strng$ + "Yes:" + STR$(TreasureRecord.RustPercent) + "%"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[H]Weapon class: "
 SELECT CASE TreasureRecord.Proficiency
 CASE 1
    Strng$ = Strng$ + "Blunt"
 CASE 2
    Strng$ = Strng$ + "Pole"
 CASE 3
    Strng$ = Strng$ + "Sharp"
 CASE 4
    Strng$ = Strng$ + "Thrusting"
 CASE ELSE
    Strng$ = Strng$ + "None"
 END SELECT
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[2]Weapon is stealable: "
 IF TreasureRecord.Stealable THEN
    Strng$ = Strng$ + "Yes:" + STR$(TreasureRecord.StealPercent) + "%"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[I]Treasure is permanent: "
 IF TreasureRecord.Permanent THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[3]Container disappears: "
 IF TreasureRecord.Container THEN
    IF TreasureRecord.ContainerDisappears THEN
       Strng$ = Strng$ + "Yes:" + STR$(TreasureRecord.ContainerDisappears)
    ELSE
       Strng$ = Strng$ + "No"
    END IF
 ELSE
    Strng$ = Strng$ + "<n/a>"
 END IF
 PRINT Strng$
 Strng$ = "[J]Treasure is edible: "
 IF TreasureRecord.Edible THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[4]Container is locked: "
 IF TreasureRecord.Container THEN
    IF TreasureRecord.Locked THEN
       Strng$ = Strng$ + "Yes"
    ELSE
       Strng$ = Strng$ + "No"
    END IF
 ELSE
    Strng$ = Strng$ + "<n/a>"
 END IF
 IF TreasureRecord.TrapType THEN
    Strng$ = Strng$ + " (trapped)"
 END IF
 PRINT Strng$
 Strng$ = "[K]Treasure is magical: "
 Var1! = TreasureRecord.Spell
 IF Var1! = 0! THEN
    Strng$ = Strng$ + "No"
 ELSE
    IF Var1! > 0! AND Var1! <= LOF(1) / SpellRecLen THEN
       GET #1, Var1!, SpellRecord
       Strng$ = Strng$ + RTRIM$(SpellRecord.SpellName)
    END IF
 END IF
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[5]Container maximum:"
 IF TreasureRecord.ContainerMax = -1 THEN
    Strng$ = Strng$ + " <unlimited>"
 ELSE
    IF TreasureRecord.ContainerMax THEN
       Strng$ = Strng$ + STR$(TreasureRecord.ContainerMax)
    ELSE
       Strng$ = Strng$ + " <n/a>"
    END IF
 END IF
 PRINT Strng$
 Strng$ = "[L]Ring protection: "
 SELECT CASE TreasureRecord.RingType
 CASE 0
    Strng$ = Strng$ + "None"
 CASE 1
    Strng$ = Strng$ + "Poison"
 CASE 2
    Strng$ = Strng$ + "Level drain"
 CASE 3
    Var1! = TreasureRecord.RingSpell
    IF Var1! = -1! THEN
       Strng$ = Strng$ + "Any spell"
    ELSE
       IF Var1! > 0! AND Var1! <= LOF(1) / SpellRecLen THEN
	  GET #1, Var1!, SpellRecord
	  Strng$ = Strng$ + RTRIM$(LCASE$(SpellRecord.SpellName))
       END IF
    END IF
 CASE 4
    Strng$ = Strng$ + "Traps"
 CASE 5
    Strng$ = Strng$ + "Rusting"
 CASE 6
    Strng$ = Strng$ + "Stealing"
 CASE 7
    Strng$ = Strng$ + "Inventory Damage"
 CASE 8
    Strng$ = Strng$ + "Fumbling"
 CASE 9
    Strng$ = Strng$ + "Teleporting"
 CASE ELSE
    Strng$ = Strng$ + "None"
 END SELECT
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[6]Container prefix: "
 IF TreasureRecord.Container THEN
    Strng$ = Strng$ + RTRIM$(TreasureRecord.ContainerPrefix)
 ELSE
    Strng$ = Strng$ + "<n/a>"
 END IF
 Strng$ = LEFT$(Strng$, 79)
 PRINT Strng$
 Strng$ = "[M]Treasure is a light:"
 IF TreasureRecord.LightType = 0 THEN
    Strng$ = Strng$ + " No"
 ELSE
    Strng$ = Strng$ + STR$(TreasureRecord.LightCharges) + " charges"
 END IF
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[7]Container size: "
 IF TreasureRecord.Container THEN
    SELECT CASE TreasureRecord.ContainerSize
    CASE 1
       Strng$ = Strng$ + "Small"
    CASE 2
       Strng$ = Strng$ + "Medium"
    CASE 3
       Strng$ = Strng$ + "Large"
    CASE ELSE
       Strng$ = Strng$ + "Any"
    END SELECT
 ELSE
    Strng$ = Strng$ + "<n/a>"
 END IF
 IF TreasureRecord.Container THEN
    FOR VarS = 1 TO 3
       IF TreasureRecord.RestrictItem(VarS) THEN
	  Strng$ = Strng$ + " (items)"
	  EXIT FOR
       END IF
    NEXT
 END IF
 PRINT Strng$
 Strng$ = "[N]Treasure is a vehicle: "
 IF TreasureRecord.Vehicle = 0 THEN
    Strng$ = Strng$ + "No"
 ELSE
    Strng$ = Strng$ + "Yes: "
    SELECT CASE TreasureRecord.VehicleType
    CASE Air
       Strng$ = Strng$ + "Air"
    CASE Land
       Strng$ = Strng$ + "Land"
    CASE Water
       Strng$ = Strng$ + "Water"
    CASE AllTerrain
       Strng$ = Strng$ + "All Terrain"
    END SELECT
 END IF
 Strng$ = LEFT$(Strng$, 40)
 Strng$ = Strng$ + SPACE$(40 - LEN(Strng$))
 Strng$ = Strng$ + "[8]ANSI Prefix code: "
 IF RTRIM$(TreasureRecord.Prefix1) = "" THEN
    Strng$ = Strng$ + "<none>"
 ELSE
    Strng$ = Strng$ + RTRIM$(TreasureRecord.Prefix1)
 END IF
 PRINT Strng$
 Strng$ = "[O]Treasure loads from devices: "
 IF TreasureRecord.Ammunition THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[P]Treasure is loadable: "
 IF TreasureRecord.Loadable THEN
    Strng$ = Strng$ + "Yes: Loads("
    Var2! = TreasureRecord.AmmoLoads
    IF Var2! > 0! AND Var2! <= LOF(2) / TreasureRecLen THEN
       PUT #2, Var!, TreasureRecord
       GET #2, Var2!, TreasureRecord
       Strng$ = Strng$ + RTRIM$(TreasureRecord.TreasureName) + ")"
       GET #2, Var!, TreasureRecord
    ELSE
       Strng$ = Strng$ + "<none>)"
    END IF
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[R]Treasure launchs from devices: "
 IF TreasureRecord.LaunchAmmo THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[S]Treasure is launchable: "
 IF TreasureRecord.Launchable THEN
    Strng$ = Strng$ + "Yes: Launchs("
    Var2! = TreasureRecord.LaunchLoads
    IF Var2! > 0! AND Var2! <= LOF(2) / TreasureRecLen THEN
       PUT #2, Var!, TreasureRecord
       GET #2, Var2!, TreasureRecord
       Strng$ = Strng$ + RTRIM$(TreasureRecord.TreasureName) + ")"
       GET #2, Var!, TreasureRecord
    ELSE
       Strng$ = Strng$ + "<none>)"
    END IF
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
 Strng$ = "[T]Launchable device can be moved: "
 IF TreasureRecord.Movable THEN
    Strng$ = Strng$ + "Yes"
 ELSE
    Strng$ = Strng$ + "No"
 END IF
 PRINT Strng$
ErrorResume13:
 Exit Sub
ErrorTrap13:
 Print "Error DisplayTreasure;";Err
 Resume ErrorResume13
END SUB

' display editor status line
SUB Edit.Status.Line
 Temp$ = "DND Import > time: " + Fclock$ 
 IF Debug THEN
    Var2# = FRE(-1) + FRE("A") ' far+near segments
    Var2$ = Format$(Var2#, "#,##0.00;;")
    Temp$ = "Import utility - Free RAM: " + Var2$ + " bytes."
 END IF
 Temp$ = LEFT$(Temp$, 79)
 Temp$ = Temp$ + SPACE$(79 - LEN(Temp$))
 CALL Display.Status.Line(-1, Temp$)
END SUB

SUB FindSpell (Var!)
 On Local Error Goto ErrorTrap14
 COLOR 15, 0
 Var! = 0!
 PRINT "Spell name, or number" + "(1-" + MID$(STR$(LOF(1) / SpellRecLen), 2) + ")?";
 Out2$ = KeyboardLine$ : Print
 IF Out2$ = "" THEN
    EXIT SUB
 END IF
 Temp7! = 0!
 Out2$ = LCASE$(Out2$)
 IF INSTR(Out2$, "#") THEN
    Temp7! = VAL(MID$(Out2$, INSTR(Out2$, "#") + 1))
    Out2$ = LEFT$(Out2$, INSTR(Out2$, "#") - 1)
 END IF
 TempQ! = 0!
 FOR Var2! = 1! TO LOF(1) / SpellRecLen
    GET #1, Var2!, SpellRecord
    IF LEFT$(SpellRecord.SpellName, LEN(Out2$)) = Out2$ THEN
       TempQ! = TempQ! + 1!
       IF Temp7! = 0! OR TempQ! = Temp7! THEN
	  Var! = Var2!
	  EXIT SUB
       END IF
    END IF
 NEXT
 Var2! = INT(VAL(Out2$))
 IF Var2! > 0! AND Var2! <= LOF(1) / SpellRecLen THEN
    Var! = Var2!
 END IF
ErrorResume14:
 Exit Sub
ErrorTrap14:
 Print "Error FindSpell;";Err
 Resume ErrorResume14
END SUB

SUB FindTreasure (Var!)
 On Local Error Goto ErrorTrap15
 COLOR 15, 0
 Var! = 0!
 PRINT "Treasure name, or number(1-" + MID$(STR$(LOF(2) / TreasureRecLen), 2) + ")? ";
 Out2$ = KeyboardLine$ : Print
 IF Out2$ = "" THEN
    EXIT SUB
 END IF
 Temp7! = 0!
 Out2$ = LCASE$(Out2$)
 IF INSTR(Out2$, "#") THEN
    Temp7! = VAL(MID$(Out2$, INSTR(Out2$, "#") + 1))
    Out2$ = LEFT$(Out2$, INSTR(Out2$, "#") - 1)
 END IF
 TempQ! = 0!
 FOR Var2! = 1! TO LOF(2) / TreasureRecLen
    GET #2, Var2!, TreasureRecord
    IF LEFT$(TreasureRecord.TreasureName, LEN(Out2$)) = Out2$ THEN
       TempQ! = TempQ! + 1!
       IF Temp7! = 0! OR TempQ! = Temp7! THEN
	  Var! = Var2!
	  EXIT SUB
       END IF
    END IF
 NEXT
 Var2! = INT(VAL(Out2$))
 IF Var2! > 0! AND Var2! <= LOF(2) / TreasureRecLen THEN
    Var! = Var2!
 END IF
ErrorResume15:
 Exit Sub
ErrorTrap15:
 Print "Error FindTreasure;";Err
 Resume ErrorResume15
END SUB

' main fullscreen editor
SUB Scrnedit (OutX$)
 ON LOCAL ERROR GOTO Error.Trap72
 CALL Edit.Status.Line
 Filename$ = ""
 DO
    Filename$ = OutX$
    REDIM Temp.ArrayS(1024) AS STRING
    CLOSE #5
    IF DIR$(Filename$) <> "" THEN
       OPEN Filename$ FOR INPUT AS #5
       Max.Lines = 0
       DO WHILE NOT EOF(5)
	  LINE INPUT #5, Out2$
	  Max.Lines = Max.Lines + 1
          IF Max.Lines > 1024 THEN
	     PRINT "File too large."
	     Filename$ = ""
	     EXIT DO
          END IF
	  Temp.ArrayS(Max.Lines) = Out2$
       LOOP
       IF LEN(Filename$) = 0 THEN
          CLOSE
	  ERASE Temp.ArrayS
          Print "Use edit.com(y/n)? ";
          Out2$ = KeyboardLine$ : Print
          If Ucase$(Out2$)="Y" Then
             Filename$=OutX$
             Shell "Edit.com "+Filename$
          Endif
	  EXIT DO
       END IF
    END IF
    IF Max.Lines = 0 THEN
       Max.Lines = 1
       Line.Number = 1
    END IF
    Xcoor = 1
    Ycoor = 1
    Column = 1
    Row = 1
    Line.Number = 1
    Line.Length = 78
    GOSUB Display.Screen
    DO
       V = Column + Ycoor - 1
       Var# = Cdbl(Line.Number)
       If Var# = 0# Then
          Var$ = " 0"
       Else
          Call Amount(Var#,Var$)
       Endif
       If V = 0 Then
          Var2$ = " 0"
       Else
          Call Amount(Cdbl(V),Var2$)
       Endif
       Strng$ = "Row" + Var$ + " Column" + Var2$
       If V > 0 And V <= Len(Temp.ArrayS(Line.Number)) Then
          V2 = Asc(Mid$(Temp.ArrayS(Line.Number), V, 1))
          Strng$ = Strng$ + " Ascii" + Str$(V2)
          Select Case V2
          Case 0
             Strng$ = Strng$ + " (nul)"
          Case 1
             Strng$ = Strng$ + " (soh)"
          Case 2
             Strng$ = Strng$ + " (stx)"
          Case 3
             Strng$ = Strng$ + " (etx)"
          Case 4
             Strng$ = Strng$ + " (eot)"
          Case 5
             Strng$ = Strng$ + " (enq)"
          Case 6
             Strng$ = Strng$ + " (ack)"
          Case 7
             Strng$ = Strng$ + " (bel)"
          Case 8
             Strng$ = Strng$ + " (bs)"
          Case 9
             Strng$ = Strng$ + " (tab)"
          Case 10
             Strng$ = Strng$ + " (lf)"
          Case 11
             Strng$ = Strng$ + " (vt)"
          Case 12
             Strng$ = Strng$ + " (np)"
          Case 13
             Strng$ = Strng$ + " (cr)"
          Case 14
             Strng$ = Strng$ + " (so)"
          Case 15
             Strng$ = Strng$ + " (si)"
          Case 16
             Strng$ = Strng$ + " (dle)"
          Case 17
             Strng$ = Strng$ + " (dc1)"
          Case 18
             Strng$ = Strng$ + " (dc2)"
          Case 19
             Strng$ = Strng$ + " (dc3)"
          Case 20
             Strng$ = Strng$ + " (dc4)"
          Case 21
             Strng$ = Strng$ + " (nak)"
          Case 22
             Strng$ = Strng$ + " (syn)"
          Case 23
             Strng$ = Strng$ + " (etb)"
          Case 24
             Strng$ = Strng$ + " (can)"
          Case 25
             Strng$ = Strng$ + " (em)"
          Case 26
             Strng$ = Strng$ + " (eof)"
          Case 27
             Strng$ = Strng$ + " (esc)"
          Case 28
             Strng$ = Strng$ + " (fs)"
          Case 29
             Strng$ = Strng$ + " (gs)"
          Case 30
             Strng$ = Strng$ + " (rs)"
          Case 31
             Strng$ = Strng$ + " (us)"
          Case 32
             Strng$ = Strng$ + " (spc)"
          Case 255
             Strng$ = Strng$ + " (?)"
          Case Else
             Strng$ = Strng$ + " (" + Chr$(V2) + ")"
          End Select
       Endif
       Strng$ = Strng$ + SPACE$(41 - LEN(Strng$))
       COLOR 14, 1
       LOCATE Max.Row-1, 1
       PRINT Strng$;
       LOCATE Xcoor, Ycoor
       COLOR 15, 0
       TempX$ = InkeyX$
       Print TempX$
       SELECT CASE LEN(TempX$)
       CASE 1
	  SELECT CASE TempX$
	  CASE CHR$(13) ' insert line
	     IF Max.Lines < 1024 THEN
                ' above
                IF Column + Ycoor - 1 = 1 THEN
                   FOR Temp1 = Max.Lines TO Line.Number STEP -1
                      Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                   NEXT
                   Temp.ArrayS(Line.Number) = ""
                   Max.Lines = Max.Lines + 1
                   Line.Number = Line.Number + 1
                   IF Xcoor < Max.Row - 2 THEN
                      Xcoor = Xcoor + 1
                   END IF
                ELSE
                   ' below
                   IF Column + Ycoor - 1 > LEN(Temp.ArrayS(Line.Number)) THEN
                      Line.Number = Line.Number + 1 ' below
                      FOR Temp1 = Max.Lines TO Line.Number STEP -1
                         Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                      NEXT
                      Temp.ArrayS(Line.Number) = ""
                      Max.Lines = Max.Lines + 1
                      IF Xcoor < Max.Row - 2 THEN
                         Xcoor = Xcoor + 1
                      END IF
                   ELSE
                      ' split line
                      FOR Temp1 = Max.Lines TO Line.Number + 1 STEP -1
                         Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                      NEXT
                      T$ = Temp.ArrayS(Line.Number)
                      U$ = MID$(T$, Column + Ycoor - 1)
                      T$ = LEFT$(T$, Column + Ycoor - 2)
                      Temp.ArrayS(Line.Number) = T$
                      Line.Number = Line.Number + 1 ' below
                      Temp.ArrayS(Line.Number) = U$
                      Max.Lines = Max.Lines + 1
                      IF Xcoor < Max.Row - 2 THEN
                         Xcoor = Xcoor + 1
                      END IF
                   END IF
                END IF
		Column = 1
		Ycoor = 1
		GOSUB Display.Screen
	     END IF
	  CASE CHR$(8) ' backspace
	     Q = Column + Ycoor - 1
             IF Line.Number <= 1 AND Q <= 1 THEN ' no backspace at 1,1
                Eat$ = ""
	     ELSE
                ' remove current line
                IF Temp.ArrayS(Line.Number) = "" THEN
                   ' pack array
                   FOR Temp1 = Line.Number TO Max.Lines - 1
                      Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                   NEXT
                   IF Xcoor > 1 THEN
                      Xcoor = Xcoor - 1
                   END IF
                   Line.Number = Line.Number - 1
                   Max.Lines = Max.Lines - 1
                   ' position at eol
                   End.Line = LEN(Temp.ArrayS(Line.Number))
                   IF End.Line >= 80 THEN
                      Column = End.Line - 78
                      Ycoor = End.Line - Column + 2
                   ELSE
                      Ycoor = End.Line - Column + 2
                   END IF
                   GOSUB Display.Screen
                ELSE
                   ' concatenate previous line
                   IF Column + Ycoor - 1 <= 1 THEN
                      IF Line.Number > 1 THEN
                         IF Line.Number <= Max.Lines THEN
                            Var=0
                            If Temp.ArrayS(Line.Number-1)="" Then
                               If Ycoor=1 Then
                                  Var=-1
                               Endif
                            Endif

                            ' position at eol
                            If Var=0 Then
                               End.Line = LEN(Temp.ArrayS(Line.Number-1))
                            Endif

                            Temp.ArrayS(Line.Number - 1) = Temp.ArrayS(Line.Number - 1) + Temp.ArrayS(Line.Number)
                            FOR Temp1 = Line.Number TO Max.Lines - 1
                               Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                            NEXT
                            If Xcoor > 1 Then
                               Xcoor = Xcoor - 1
                            Endif
                            Line.Number = Line.Number - 1
                            Max.Lines = Max.Lines - 1
                            Column = 1
                            Ycoor = 1

                            ' position at eol
                            If Var=0 Then
                               IF End.Line >= 80 THEN
                                  Column = End.Line - 78
                                  Ycoor = End.Line - Column + 2
                               ELSE
                                  Ycoor = End.Line - Column + 2
                               END IF
                            Endif

                            GOSUB Display.Screen
                         END IF
                     END IF
                  ELSE
                      ' backspace 1 character
                      IF Column + Ycoor - 2 > False THEN
                         T$ = Temp.ArrayS(Line.Number)
                         T$ = LEFT$(T$, Column + Ycoor - 3) + MID$(T$, Column + Ycoor - 1)
                         Temp.ArrayS(Line.Number) = T$
                         ' move cursor 1 left
                         IF Ycoor > 1 THEN
                            Ycoor = Ycoor - 1
                            GOSUB Display.Screen
                         ELSE
                            IF Column > 1 THEN
                               Column = Column - 1
                               GOSUB Display.Screen
                            END IF
                         END IF
                      END IF
                   END IF
                END IF
             END IF
	  CASE CHR$(9) ' tab
	     IF Column + Ycoor + 7 <= LEN(Temp.ArrayS(Line.Number)) THEN
		IF Ycoor + 8 < 80 THEN
		   Ycoor = Ycoor + 8
		ELSE
		   Column = Column + 8
		   GOSUB Display.Screen
		END IF
	     ELSE ' end
		End.Line = LEN(Temp.ArrayS(Line.Number))
		IF End.Line >= 80 THEN
		   Column = End.Line - 78
		   Ycoor = End.Line - Column + 2
		   GOSUB Display.Screen
		ELSE
		   Ycoor = End.Line - Column + 2
		END IF
	     END IF
	  CASE CHR$(27) ' escape, exit editor
	     EXIT DO
	  CASE ELSE ' insert character
             SELECT CASE ASC(TempX$)
             CASE 12, 32 TO 126
                If Line.Number > 0 Then
                   T$ = Temp.ArrayS(Line.Number)
                   T$ = LEFT$(T$, Column + Ycoor - 2) + TempX$ + MID$(T$, Column + Ycoor - 1)
                   Temp.ArrayS(Line.Number) = T$
                   IF Column + Ycoor - 1 <= LEN(Temp.ArrayS(Line.Number)) THEN
                      IF Ycoor < 80 THEN
                         Ycoor = Ycoor + 1
                         GOSUB Display.Screen
                      ELSE
                         Column = Column + 1
                         GOSUB Display.Screen
                      END IF
                   END IF
                Endif
             END SELECT
	  END SELECT
       CASE 2
	  Temp = ASC(MID$(TempX$, 2, 1))
	  SELECT CASE Temp
          CASE 0 ' ctrl-break, exit editor
	     EXIT DO
	  CASE 15 ' shift-tab
	     IF Column + Ycoor - 8 > 0 THEN
		IF Column + Ycoor - 7 > 1 THEN
		   Ycoor = Ycoor - 7
		ELSE
		   IF Column > 8 THEN
		      Column = Column - 7
		      GOSUB Display.Screen
		   END IF
		END IF
	     ELSE ' home
		IF Column > 1 THEN
		   Column = 1
		   Ycoor = 1
		   GOSUB Display.Screen
		ELSE
		   Column = 1
		   Ycoor = 1
		END IF
	     END IF
          CASE 83, 147 ' delete/control-delete
	     Q = Column + Ycoor - 1
             ' no delete at 1,1
             IF (Line.Number <= 1 AND Q < 1) OR Max.Lines < 1 THEN
                Eat$ = ""
	     ELSE
                ' remove line
                IF Temp.ArrayS(Line.Number) = "" THEN
                   IF Line.Number = 1 AND Max.Lines = 1 THEN ' 1,1
                      Eat$ = ""
                   ELSE
                      ' pack array
                      FOR Temp1 = Line.Number TO Max.Lines - 1
                         Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                      NEXT
                      IF Line.Number = Max.Lines THEN
                         Line.Number = Line.Number - 1
                         IF Xcoor > 1 THEN
                            Xcoor = Xcoor - 1
                         END IF
                      END IF
                      Max.Lines = Max.Lines - 1
                      Column = 1
                      Ycoor = 1
                      GOSUB Display.Screen
                   END IF
                ELSE
                   ' delete line
                   IF LEN(Temp.ArrayS(Line.Number))<1 THEN
                      Temp.ArrayS(Line.Number) = ""
                      GOSUB Display.Screen
                   ELSE
                      ' concatenate line
                      IF Column + Ycoor - 1 > LEN(Temp.ArrayS(Line.Number)) THEN
                         If Line.Number + 1 <= Max.Lines Then
                            T$ = Temp.ArrayS(Line.Number)
                            T$ = T$ + Temp.ArrayS(Line.Number + 1)
                            Temp.ArrayS(Line.Number) = T$

                            ' pack array
                            FOR Temp1 = Line.Number + 1 TO Max.Lines - 1
                               Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                            NEXT
                            Max.Lines = Max.Lines - 1

                            GOSUB Display.SCreen
                         Endif
                      ELSE
                         ' delete character
                         T$ = Temp.ArrayS(Line.Number)
                         T$ = LEFT$(T$, Column + Ycoor - 2) + MID$(T$, Column + Ycoor)
                         Temp.ArrayS(Line.Number) = T$
                         GOSUB Display.Screen
                      END IF
                   END IF
                END IF
             END IF
	  CASE 71 ' home
	     IF Column > 1 THEN
		Column = 1
		Ycoor = 1
		GOSUB Display.Screen
	     ELSE
		Column = 1
		Ycoor = 1
	     END IF
	  CASE 79 ' end
	     End.Line = LEN(Temp.ArrayS(Line.Number))
	     IF End.Line >= 80 THEN
		Column = End.Line - 78
		Ycoor = End.Line - Column + 2
		GOSUB Display.Screen
	     ELSE
		Ycoor = End.Line - Column + 2
	     END IF
          CASE 75, 155 ' left/alt-left
	     IF Ycoor > 1 THEN
		Ycoor = Ycoor - 1
	     ELSE
		IF Column > 1 THEN
		   Column = Column - 1
		   GOSUB Display.Screen
		END IF
	     END IF
          CASE 77, 157 ' right/alt-right
	     IF Column + Ycoor - 1 <= LEN(Temp.ArrayS(Line.Number)) THEN
		IF Ycoor < 80 THEN
		   Ycoor = Ycoor + 1
		ELSE
		   Column = Column + 1
		   GOSUB Display.Screen
		END IF
	     END IF
          CASE 72, 141, 152 ' up/ctrl-up/alt-up
	     Var = 0
	     IF Line.Number > 1 THEN
		Line.Number = Line.Number - 1
		IF Xcoor = 1 THEN
		   Var = -1
		ELSE
		   Xcoor = Xcoor - 1
		END IF
		End.Line = LEN(Temp.ArrayS(Line.Number)) + 1
		IF Column + Ycoor - 1 > End.Line THEN
		   Ycoor = End.Line - Column + 1
		   IF Ycoor <= 0 THEN
		      Ycoor = End.Line
		      IF Column > 1 THEN
			 Var = -1
		      END IF
		      Column = 1
		   END IF
		END IF
		IF Var THEN
		   GOSUB Display.Screen
		END IF
	     END IF
          CASE 80, 145, 160 ' down/ctrl-dn/alt-dn
	     Var = 0
             IF Line.Number < Max.Lines THEN
		Line.Number = Line.Number + 1
                IF Xcoor >= Max.Row - 2 THEN
		   Var = -1
                ELSE
		   Xcoor = Xcoor + 1
		END IF
		End.Line = LEN(Temp.ArrayS(Line.Number)) + 1
		IF Column + Ycoor - 1 > End.Line THEN
		   Ycoor = End.Line - Column + 1
		   IF Ycoor <= 0 THEN
		      Ycoor = End.Line
		      IF Column > 1 THEN
			 Var = -1
		      END IF
		      Column = 1
		   END IF
		END IF
		IF Var THEN
		   GOSUB Display.Screen
		END IF
	     END IF
          CASE 73, 132 ' ^U, pageup/ctrl-pageup
	     IF Line.Number > 1 THEN
                IF Line.Number - 22 > 1 THEN
                   Line.Number = Line.Number - 22
		ELSE
		   Line.Number = 1
		END IF
		Xcoor = 1
		End.Line = LEN(Temp.ArrayS(Line.Number)) + 1
		IF Column + Ycoor - 1 > End.Line THEN
		   Ycoor = End.Line - Column + 1
		   IF Ycoor <= 0 THEN
		      Ycoor = End.Line
		      IF Column > 1 THEN
			 Var = -1
		      END IF
		      Column = 1
		   END IF
		END IF
		GOSUB Display.Screen
	     END IF
          CASE 81, 118 ' ^N, pagedown/ctrl-pagedn
	     IF Line.Number < Max.Lines THEN
		IF Line.Number + 22 < Max.Lines THEN
		   Line.Number = Line.Number + 22
                   Xcoor = 1
		ELSE
		   Line.Number = Max.Lines
                   IF Max.Lines < Max.Row - 3 THEN
                      Xcoor = Max.Lines
                   ELSE
                      Xcoor = Max.Row - 3
                   END IF
		END IF
		End.Line = LEN(Temp.ArrayS(Line.Number)) + 1
		IF Column + Ycoor - 1 > End.Line THEN
		   Ycoor = End.Line - Column + 1
		   IF Ycoor <= 0 THEN
		      Ycoor = End.Line
		      IF Column > 1 THEN
			 Var = -1
		      END IF
		      Column = 1
		   END IF
		END IF
		GOSUB Display.Screen
	     END IF
	  CASE 116 ' control-right
             IF Column + Ycoor - 1 > LEN(Temp.ArrayS(Line.Number)) THEN ' eol
                If Line.Number + 1 <= Max.Lines Then
                   Line.Number = Line.Number + 1
                   IF Xcoor = Max.Row - 3 THEN
                      Var = -1
                   ELSE
                      Xcoor = Xcoor + 1
                   END IF
                   Ycoor = 1
                   Column = 1
                   GOSUB Display.Screen
                Endif
             Else
                P = 0
                FOR Temp2 = Column + Ycoor - 1 TO LEN(Temp.ArrayS(Line.Number))
                   P = P + 1
                   IF MID$(Temp.ArrayS(Line.Number), Temp2, 1) = " " THEN
                      IF MID$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " THEN
                         EXIT FOR
                      END IF
                   END IF
                NEXT
                'shift right
                FOR Var3 = 1 TO P
                   IF Ycoor < 80 THEN
                      Ycoor = Ycoor + 1
                   ELSE
                      Column = Column + 1
                   END IF
                NEXT
                GOSUB Display.Screen
             Endif
	  CASE 115 ' control-left
             If Column + Ycoor - 1 <= 1 Then
                If Line.Number > 1 Then
                   Line.Number = Line.Number - 1
                   IF Xcoor = 1 THEN
                      Var = -1
                   ELSE
                      Xcoor = Xcoor - 1
                   END IF
                   End.Line = LEN(Temp.ArrayS(Line.Number))
                   IF End.Line >= 80 THEN
                      Column = End.Line - 78
                      Ycoor = End.Line - Column + 2
                   ELSE
                      Ycoor = End.Line - Column + 2
                   END IF
                   GOSUB Display.Screen
                Endif
             Else
                P = 0
                V = 0
                FOR Temp2 = Column + Ycoor - 3 TO 1 STEP -1
                   P = P + 1
                   IF MID$(Temp.ArrayS(Line.Number), Temp2, 1) = " " THEN
                      IF MID$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " THEN
                         V = -1
                         EXIT FOR
                      END IF
                   END IF
                NEXT
                IF V = 0 THEN
                   P = P + 1
                END IF
                ' shift left
                FOR Var3 = 1 TO P
                   IF Ycoor > 1 THEN
                      Ycoor = Ycoor - 1
                   ELSE
                      IF Column > 1 THEN
                         Column = Column - 1
                      END IF
                   END IF
                NEXT
                GOSUB Display.Screen
             Endif
	  CASE 119 ' control-home
             If Max.Lines > 0 Then
                Line.Number = 1
                Xcoor = 1
                Ycoor = 1
                Column = 1
                GOSUB Display.Screen
             Endif
	  CASE 117 ' control-end
             If Max.Lines > 0 Then
                Line.Number = Max.Lines
                IF Max.Lines < Max.Row - 3 THEN
                   Xcoor = Max.Lines
                ELSE
                   Xcoor = Max.Row - 3
                END IF
                Ycoor = 1
                Column = 1
                GOSUB Display.Screen
             Endif
          CASE 82 ' insert
             If Line.Number > 0 Then
                Var = False
                Ascii$ = ""
                Gosub Display.Ascii.Line
                Do
                   Var$ = InkeyX$
                   If Len(Var$) = 1 Then
                      If Var$=Chr$(8) Then
                         If Len(Ascii$)>0 Then
                            Ascii$=Left$(Ascii$,Len(Ascii$)-1)
                            Gosub Display.Ascii.Line
                            Var=Var-1
                            Locate Max.Row-1, 27
                            Print Ascii$ + " ";
                            Locate Max.Row-1, 27
                            Print Ascii$;
                         Endif
                      Endif
                      If Var$=Chr$(13) Then
                         Exit Do
                      Endif
                      If Lcase$(Var$) = "x" Or Lcase$(Var$)="o" Or Lcase$(Var$)="b" Then
                         If Var=0 Then
                            Ascii$ = Ascii$ + Lcase$(Var$)
                            Gosub Display.Ascii.Line
                            Var = Var + 1
                            Locate Max.Row-1, 26 + Var
                            Strng$ = Lcase$(Var$)
                            Print Strng$;
                         Endif
                      Endif
                      If Lcase$(Var$) >= "a" And Lcase$(Var$) <= "f" Then
                         If Var>=1 And Var<3 Then
                            If Left$(Ascii$,1)="x" Then
                               Var = Var + 1
                               Locate Max.Row-1, 26 + Var
                               Strng$ = Var$
                               Print Strng$;
                               Ascii$ = Ascii$ + Var$
                            Endif
                         Endif
                      Endif
                      If Left$(Ascii$,1)="o" Then
                         If Var$ >= "0" And Var$ <= "7" Then
                            If Var<4 Then
                               Var = Var + 1
                               Locate Max.Row-1, 26 + Var
                               Strng$ = Var$
                               Print Strng$;
                               Ascii$ = Ascii$ + Var$
                            Endif
                         Endif
                      Else
                         If Left$(Ascii$,1)="b" Then
                            If Var$ = "0" Or Var$ = "1" Then
                               If Var<9 Then
                                  Var = Var + 1
                                  Locate Max.Row-1, 26 + Var
                                  Strng$ = Var$
                                  Print Strng$;
                                  Ascii$ = Ascii$ + Var$
                               Endif
                            Endif
                         Else
                            If Var$ >= "0" And Var$ <= "9" Then
                               If Var<3 Then
                                  Var = Var + 1
                                  Locate Max.Row-1, 26 + Var
                                  PRINT Var$;
                                  Ascii$ = Ascii$ + Var$
                               Endif
                            Endif
                         Endif
                      Endif
                   Endif
                LOOP
                COLOR 15, 0

                ' insert ascii character
                If Left$(Ascii$,1)="x" Then
                   Ascii.Value=Int(Val("&H"+Mid$(Ascii$,2)))
                Else
                   If Left$(Ascii$,1)="o" Then
                      Ascii.Value=Int(Val("&O"+Mid$(Ascii$,2)))
                   Else
                      If Left$(Ascii$,1)="b" Then ' binary
                         Ascii$=Mid$(Ascii$,2)
                         Gosub Binary.String
                      Else
                         Ascii.Value = Int(Val(Ascii$))
                      Endif
                   Endif
                Endif
                If Ascii.Value >= 0 And Ascii.Value <= 255 Then
                   Select Case Ascii.Value
                   Case 0, 7 To 13, 26 To 31 ' unprintable characters
                      Eat$=""
                   Case Else
                      TempX$ = Chr$(Ascii.Value)
                      T$ = Temp.ArrayS(Line.Number)
                      T$ = LEFT$(T$, Column + Ycoor - 2) + TempX$ + MID$(T$, Column + Ycoor - 1)
                      Temp.ArrayS(Line.Number) = T$

                      IF Column + Ycoor - 1 <= LEN(Temp.ArrayS(Line.Number)) THEN
                         IF Ycoor < 80 THEN
                            Ycoor = Ycoor + 1
                            GOSUB Display.Screen
                         ELSE
                            Column = Column + 1
                            GOSUB Display.Screen
                         END IF
                      END IF
                   End Select
                Endif
             Endif
	  END SELECT
       END SELECT
    LOOP
    COLOR 15, 0
    CLS
    CALL Edit.Status.Line
    LOCATE Max.Row-1, 1
    DO
       Q = 0
       PRINT "Write "; Filename$; " to disk(y/n)? ";
       Char$ = KeyboardLine$
       Print
       Char$ = UCASE$(Char$)
       IF Char$ = "Y" THEN
          Q = -1
          EXIT DO
       END IF
       IF Char$ = "N" THEN
          EXIT DO
       END IF
    LOOP
    IF Q THEN
       CLOSE #5
       OPEN Filename$ FOR OUTPUT AS #5
       FOR Count = 1 TO Max.Lines
	  PRINT #5, Temp.ArrayS(Count)
       NEXT
       PRINT "File stored to disk."
    END IF
    ERASE Temp.ArrayS
    EXIT DO
 LOOP
 EXIT SUB

Display.Ascii.Line:
  COLOR 15, 1
  Locate Max.Row-1,1,1
  COLOR 15,1
  Strng$ = SPACE$(41)
  PRINT Strng$;
  Locate Max.Row-1,1,1
  If Left$(Ascii$,1)="x" Then
     Var2$ = "Enter 2-digit ascii code: " 
  Else
     If Left$(Ascii$,1)="o" Then
        Var2$ = "Enter 3-digit ascii code: "
     Else
        If Left$(Ascii$,1)="b" Then
           Var2$ = "Enter 8-digit ascii code: "
        Else
           Var2$ = "Enter 3-digit ascii code: " 
        Endif
     Endif
  Endif
  VarC = Len(Var2$) + Len(Ascii$)
  Var2$ = Var2$ + SPACE$(41 - LEN(Var2$))
  PRINT Var2$;
  Locate Max.Row-1, VarC, 1
  RETURN

Binary.String:
  Ascii.Value = False
  Binary.Power = False
  FOR Binary.Digit = LEN(Ascii$) TO 1 STEP -1
      OutX2$ = MID$(Ascii$, Binary.Digit, 1)
      SELECT CASE OutX2$
          CASE "0"
              ' nul
          CASE "1"
              Ascii.Value = Ascii.Value + 2 ^ Binary.Power
      END SELECT
      Binary.Power = Binary.Power + 1
  NEXT
  RETURN

' redisplay editor screen
Display.Screen:
 COLOR 15, 0
 CLS
 LOCATE 1, 1
 Count = 0
 DO
    Count = Count + 1
    IF Count = Max.Row - 1 THEN
       EXIT DO
    END IF
    IF Count + Line.Number - Xcoor > Max.Lines THEN
       EXIT DO
    END IF
    LOCATE Count, 1
    Strng$ = MID$(Temp.ArrayS(Count + Line.Number - Xcoor), Column)
    IF LEN(Strng$) > 80 THEN
       Strng$ = LEFT$(Strng$, 80)
    END IF
    PRINT Strng$;
 LOOP
 IF Count < Max.Row-1 THEN
    LOCATE Count, 1
    PRINT "<end of file>";
 END IF
 COLOR 14, 1
 LOCATE Max.Row-1, 1
 PRINT SPACE$(78);
 COLOR 0, 1
 LOCATE Max.Row-1, 79, 0
 PRINT " ";
 LOCATE Max.Row-1, 80, 0
 PRINT " ";
 COLOR 15, 0
 CALL Edit.Status.Line
 RETURN
Error.Resume72:
 EXIT SUB
Error.Trap72:
 RESUME Error.Resume72
END SUB

SUB SpellTypes
 COLOR 15, 0
 Print "[A]Enchant      [S]Detect Trap"
 Print "[B]Offense      [T]Intoxicate"
 Print "[C]Bless        [U]Set Trap"
 Print "[D]Wish         [V]Hide"
 Print "[E]Poison       [W]Search"
 Print "[F]Vigor        [X]Invisibility"
 Print "[G]Heal         [Y]Identify"
 Print "[H]Curepoison   [Z]Enlighten"
 Print "[I]Level Drain  [1]Illuminate"
 Print "[J]Teleport     [2]Psyche"
 Print "[K]Befuddle     [3]Telepathy"
 Print "[L]Turn Undead  [4]Curse"
 Print "[M]Pass Door    [5]Damnate"
 Print "[N]Conjure      [6]Resurrect"
 Print "[O]Psionic      [7]Grant Wish"
 Print "[P]Detect Lock  [8]Steal Wish"
 Print "[R]Detect Evil"
 CALL MorePrompt(X)
END SUB

SUB MorePrompt(Var)
 Var=False
 COLOR 15, 0
 PRINT More$;
 DO
    X$ = InkeyX$
    IF LEN(X$) THEN
       IF X$ = CHR$(13) THEN
          COLOR 15, 0
          PRINT
          EXIT SUB
       END IF
       IF UCASE$(X$) = "N" THEN
          COLOR 15, 0
          PRINT
          Var = True
          EXIT SUB
       END IF
       COLOR 15, 0
       PRINT
       EXIT SUB
    END IF
 LOOP
END SUB

Sub Read.Rows(Var)
 On Local Error Goto Error.Trap62x
 Temp1=60
 Locate 60,1,0
 Var=60
 Exit Sub
Next.Trap0:
 Temp1=50
 Locate 50,1,0
 Var=50
 Exit Sub
Next.Trap1:
 Temp1=43
 Locate 43,1,0
 Var=43
 Exit Sub
Next.Trap2:
 Var=25
Error.Resume62x:
 Exit Sub
Error.Trap62x:
 If Temp1=60 Then
    Resume Next.Trap0
 Endif
 If Temp1=50 Then
    Resume Next.Trap1
 Endif
 If Temp1=43 Then
    Resume Next.Trap2
 Endif
 Resume Error.Resume62x
End Sub

Sub Amount(Var#,Var$)
 If Instr(Str$(Var#),"D") Then
    Var$=Str$(Var#)
 Else
    Var$=" "+Form$(Var#)
 Endif
End Sub

Sub Save.Screen(Var)
 On Local Error Goto Error.Trap62
 If Var=False Then
    VarX3=(Max.Row-1)*80+80
    Redim Temp.Array1(VarX3) As Integer
    Redim Temp.Array2(VarX3) As Integer
    For Var1=1 To Max.Row
       For Var2=1 To 80
          TempZ1=Screen(Var1,Var2)
          TempZ2=Screen(Var1,Var2,1)
          VarX2=(Var1-1)*80+Var2
          Temp.Array1(VarX2)=TempZ1
          Temp.Array2(VarX2)=TempZ2
       Next
    Next
 Else
    Cls
    For VarX=Max.Row To 1 Step -1
       For VarY=1 To 80
          VarX2=(VarX-1)*80+VarY
          If Temp.Array1(VarX2)<>32 Then
             Goto Next.Line
          Endif
       Next
    Next
Next.Line:
    TempX2=VarX
    For Var1=1 To VarX ' Max.Row
       For Var2=1 To 80
          VarX2=(Var1-1)*80+Var2
          VarB=Int(Temp.Array2(VarX2)/16)
          VarF=Temp.Array2(VarX2) Mod 16
          TempZ1=Temp.Array1(VarX2)
          Locate Var1,Var2,0
          Color VarF,VarB
          Print Chr$(TempZ1);
       Next
    Next
 Endif
Error.Resume62:
 Exit Sub
Error.Trap62:
 Resume Error.Resume62
End Sub

Sub Make.Format(Var#, Var$)
 On Local Error Goto ErrTrap13
 Var2#=Var#
 If Var2#<=0 Then
    Var$="0.00 B"
    Exit Sub
 Endif
 TempA=False
 Do
    If Var2#<1024# Then
       Exit Do
    Endif
    Var2#=Var2#/1024#
    TempA=TempA+1
    If TempA=8 Then
       Exit Do
    Endif
 Loop
 Strng$=Nul
 If TempA>=1 And TempA<=8 Then
    Strng$=Mid$("KMGTPEZY",TempA,1)
 Endif
 Var$=Format$(Var2#,"#,##0.00;;")+" "+Strng$+"B"
ErrResume13:
 Exit Sub
ErrTrap13:
 Resume ErrResume13
End Sub

Sub Stdin(Var)
 Var=0
 ' check stdin length
 InregsX.AX = &H4202 ' eof
 InregsX.BX = 0 ' stdin
 InregsX.CX = 0
 InregsX.DX = 0
 CALL InterruptX(&H21, InregsX, OutregsX)
 IF OutregsX.AX = 0 THEN ' no input found
     EXIT SUB
 END IF
 Print "Illegal standard input attempted."
 END
End Sub

' simple subroutine to display a file
SUB Out.FileX (FilenameZ$)
 ON LOCAL ERROR GOTO Open.Error
 DND.Path$ = ENVIRON$("DNDBBS")
 IF DND.Path$ <> "" THEN
    IF RIGHT$(DND.Path$, 1) <> "\" THEN
       DND.Path$ = DND.Path$ + "\"
    END IF
 END IF
 Z = Max.Row - 2
 Q = Freefile
 If Q=0 Then exit sub
 VarZZ$ = DND.Path$ + FilenameZ$
 OPEN VarZZ$ FOR INPUT AS #Q
 DO UNTIL EOF(Q)
    LINE INPUT #Q, Var$
    x = x + 1
    COLOR 15
    PRINT Var$
    IF x = Z THEN
       x = 0
       IF C = 0 THEN
          COLOR 14
          PRINT "More(y/n/q/c/?):";
	  DO
             x$ = INKEYX$
	     IF UCASE$(x$) = "C" THEN PRINT : C = -1: EXIT DO
             IF UCASE$(x$) = "Q" THEN PRINT : Close #Q : EXIT SUB
             IF UCASE$(x$) = "N" THEN PRINT : Close #Q : EXIT SUB
	     IF UCASE$(x$) = "Y" THEN PRINT : EXIT DO
	     IF UCASE$(x$) = " " THEN PRINT : EXIT DO
	     IF UCASE$(x$) = CHR$(13) THEN PRINT : EXIT DO
	     IF UCASE$(x$) = "?" THEN
		PRINT
                COLOR 15
		PRINT " Y = Yes"
		PRINT " N = No"
		PRINT " Q = Quit"
		PRINT " C = Continuous"
		PRINT "  <space> = continue"
		PRINT "  <enter> = continue"
                COLOR 14
                PRINT "More(y/n/q/c/?):";
	     END IF
	  LOOP
       END IF
    END IF
 LOOP
 Close #Q
 EXIT SUB
Open.Error:
 PRINT VarZZ$; " not found."
 EXIT SUB
END SUB

