Rem Convert program for v5.1a maintenance upgrade.
Rem Renames *.new to *.dat, upgrades old record lengths,
Rem and upgrades room/user containers for permanent attribute.

' declare include file
Rem $Include: 'dndcnvt.inc'

' declare error routine
On Error Goto Error.Routine

' declare all record structure lengths
OldContainerRecLen=Len(OldContainerRec)
NewContainerRecLen=Len(NewContainerRec)

OldRoomRecLen=Len(OldRoomRec)
NewRoomRecLen=Len(NewRoomRec)

OldSpellRecLen=Len(OldSpellRec) ' v4.4a
NewSpellRecLen=Len(NewSpellRec) ' v4.7a

OldMonsterRecLen=Len(OldMonsterRec) ' v4.4a
NewMonsterRecLen=Len(NewMonsterRec) ' v4.7a

OldTreasureRecLen=Len(OldTreasureRec) ' v4.4a
NewTreasureRecLen=Len(NewTreasureRec) ' v4.7a

UserRecLen1=Len(UserRec1) ' v4.4a
UserRecLen2=Len(UserRec2) ' v4.5a
UserRecLen3=Len(UserRec3) ' v4.7a

' display banner
Color 15,0
Print "Dndcnvt for v5.1a:"

' After first run, dndcnvt will delete or rename .new files.
If Dir$("*.new")=Nul Then
   Color 14,0
   Print "No new data files found."
   Color 15,0
   ' otherwise users.dat might need converting.
   Print "Continue anyway(y/n)? ";
   Locate ,,1
   Var$=Nul
   While Var$=Nul
      Var$=Inkey$
   Wend
   Var$=Lcase$(Var$)
   Print Var$
   If Var$<>"y" Then
      Color 7,0
      Print "Exiting to system."
      End
   Endif
Endif

' Display header
Color 15,0
Print "Creates/converts v4.4a, v4.5a, v4.6a, and v4.7a+ files to v5.1a."

' Display info
Color 14,0
Print "This program does not convert any versions previous to v4.4a."

' Get user response
Color 15,0
Print "If you are sure about converting, then press Y to continue,"
Print "otherwise exit to Dos and delete all .dat files, then restart"
Print "this conversion program which will then rename all new .dat files: ";
Locate ,,1
Var$=Nul
While Var$=Nul
   Var$=Inkey$
Wend
Var$=Lcase$(Var$)
Print Var$
If Var$<>"y" Then
   Color 7,0
   Print "Exiting to system:"
   End
Endif

' Display info
Color 14,0
Print "This program will now convert a selected version from the following:"

' Get version type upgrade
Color 15,0
Print "Enter version number upgrading from:"
Print "(1)v4.4a, (2)v4.5a, (3)v4.6a, (4)v4.7a+, (5)New Install: ";
Locate ,,1
Var$=Nul
While Var$=Nul
   Var$=Inkey$
Wend
Select Case Var$
Case "1"
   Print "1"
   Version.Type=1
Case "2"
   Print "2"
   Version.Type=2
Case "3", "4", "5"
   Print Var$
   Version.Type=3
Case Else
   Print Lcase$(Var$)
   Color 7,0
   Print "Exiting to system:"
   End
End Select

' convert old users.dat files first
Gosub Upgrade.User.File
' go through all .new files
Do
   ' see if .new file exists
   Var1$=Dir$("*.new")
   If Var1$=Nul Then
      Exit Do
   Endif
   Var1$=Lcase$(Var1$)

   ' check if file is a data help file
   Help.File=False
   Select Case Var1$
   Case "logon.new"
      Help.File=True
   Case "help.new"
      Help.File=True
   Case "edithelp.new"
      Help.File=True
   Case "dmhelp.new"
      Help.File=True
   End Select
   If Help.File Then
      Imbedded=Instr(Var1$,".")
      Var2$=Left$(Var1$,Imbedded)+"dat"
      If Dir$(Var2$)<>Nul Then
         Kill Var2$ ' remove old help file
      Endif
      Number.Converted=Number.Converted+1
      Name Var1$ As Var2$ ' rename the new help file
      Color 13,0
      Print "File "+Var1$+" renamed to "+Var2$
   Else
      ' make sure users.dat is not distributed
      If Var1$="users.new" Then
         Kill Var1$
      Endif
      If Var1$<>"users.new" Then
         ' See if corresponding .dat file exists
         Imbedded=Instr(Var1$,".")
         Var2$=Left$(Var1$,Imbedded)+"dat"
         If Dir$(Var2$)=Nul Then
            ' Rename the .new file to .dat file
            Number.Converted=Number.Converted+1
            Name Var1$ As Var2$
            Color 13,0
            Print "File "+Var1$+" renamed to "+Var2$
         Else
            ' Remove the .new file
            Kill Var1$
            ' convert the .dat file
            Gosub Convert.Data.File
         Endif
      Endif
   Endif
Loop
Color 14,0
Select Case Number.Converted
Case 0
   Print "No data files";
Case 1
   Print "One data file";
Case Is>1
   Print Mid$(Str$(Number.Converted),2);" data files";
End Select
Print " created/converted to v5.1a."
Color 7,0
Print "Exiting to system."
End

' data file conversion selection
Convert.Data.File:
' check version type upgrade
If Version.Type=1 Then
   ' Old spells was 258 bytes per record, new file is 216 bytes.
   If Var2$="spells.dat" Then
      Open Var2$ For Random As #TempFile1 Len=1
      Record.Length!=Lof(TempFile1)
      Close #TempFile1
      If Record.Length!>0! Then
         If Record.Length!/258!=Record.Length!\258! Then
            Number.Converted=Number.Converted+1
            Gosub Upgrade.Spell.File
            Color 13,0
            Print "Spells.dat file upgraded from v4.4a to v4.9a."
         Endif
      Endif
   Endif
   ' Old monster was 186 bytes per record, new file is 144 bytes.
   If Var2$="monsters.dat" Then
      Open Var2$ For Random As #TempFile1 Len=1
      Record.Length!=Lof(TempFile1)
      Close #TempFile1
      If Record.Length!>0! Then
         If Record.Length!/186!=Record.Length!\186! Then
            Number.Converted=Number.Converted+1
            Gosub Upgrade.Monster.File
            Color 13,0
            Print "Monsters.dat file upgraded from v4.4a to v4.9a."
         Endif
      Endif
   Endif
   ' Old nonplayer was 186 bytes per record, new file is 144 bytes.
   If Var2$="nonplyrs.dat" Then
      Open Var2$ For Random As #TempFile1 Len=1
      Record.Length!=Lof(TempFile1)
      Close #TempFile1
      If Record.Length!>0! Then
         If Record.Length!/186!=Record.Length!\186! Then
            Number.Converted=Number.Converted+1
            Gosub Upgrade.Nonplayer.File
            Color 13,0
            Print "Nonplyrs.dat file upgraded from v4.4a to v4.9a."
         Endif
      Endif
   Endif
   ' Old treasure was 150 bytes per record, new file is 140 bytes.
   If Var2$="treasure.dat" Then
      Open Var2$ For Random As #TempFile1 Len=1
      Record.Length!=Lof(TempFile1)
      Close #TempFile1
      If Record.Length!>0! Then
         If Record.Length!/150!=Record.Length!\150! Then
            Number.Converted=Number.Converted+1
            Gosub Upgrade.Treasure.File
            Color 13,0
            Print "Treasure.dat file upgraded from v4.4a to v4.9a."
         Endif
      Endif
   Endif
Endif
' check version type upgrade
If Version.Type=1 Or Version.Type=2 Then
   ' Old rooms was 978 bytes per record, new file is 980 bytes.
   If Var2$="rooms.dat" Then
      Open Var2$ For Random As #TempFile1 Len=1
      Record.Length!=Lof(TempFile1)
      Close #TempFile1
      If Record.Length!>0! Then
         If Record.Length!/978!=Record.Length!\978! Then
            Number.Converted=Number.Converted+1
            Gosub Upgrade.Room.File
            Color 13,0
            Print "Rooms.dat file upgraded from v4.5a to v4.9a."
         Endif
      Endif
   Endif
Endif
Return

Upgrade.User.File:
' check version type upgrade
If Version.Type=1 Then
   ' old v4.4a users was 1104 bytes per record,
   ' new v4.5a file is 1106 bytes.
   Open "users.dat" For Random As #TempFile1 Len=1
   Record.Length!=Lof(TempFile1)
   Close #TempFile1
   If Record.Length!>0! Then
      If Record.Length!/1104!=Record.Length!\1104! Then
         Number.Converted=Number.Converted+1
         Gosub Upgrade.User.File1
         Color 13,0
         Print "Users.dat file upgraded from v4.4a to v4.5a."
      Endif
   Endif
Endif
' check version type upgrade
If Version.Type=1 Or Version.Type=2 Then
   ' old v4.5a users was 1106 bytes per record,
   ' new v4.7a file is 1112 bytes.
   Open "users.dat" For Random As #TempFile1 Len=1
   Record.Length!=Lof(TempFile1)
   Close #TempFile1
   If Record.Length!>0! Then
      If Record.Length!/1106!=Record.Length!\1106! Then
         Number.Converted=Number.Converted+1
         Gosub Upgrade.User.File2
         Color 13,0
         Print "Users.dat file upgraded from v4.5a to v4.9a."
      Endif
   Endif
Endif
Return

' convert spells.dat from v4.4a to v4.9a.
Upgrade.Spell.File:
If Dir$("spells.bkp")<>Nul Then
   Kill "spells.bkp"
Endif
Name "spells.dat" As "spells.bkp"
Open "spells.bkp" For Random As #TempFile1 Len=OldSpellRecLen
Open "spells.dat" For Random As #TempFile2 Len=NewSpellRecLen
For Var1=1 To Lof(TempFile1)/OldSpellRecLen
   Get TempFile1,Var1,OldSpellRec
   NewSpellRec.SpellName=OldSpellRec.SpellName
   NewSpellRec.Chant=OldSpellRec.Chant
   NewSpellRec.Level=OldSpellRec.Level
   NewSpellRec.SpellType=OldSpellRec.SpellType
   NewSpellRec.Teleport=OldSpellRec.Teleport
   NewSpellRec.Psionic=OldSpellRec.Psionic
   NewSpellRec.PsionicMode=OldSpellRec.PsionicMode
   NewSpellRec.ClassType=OldSpellRec.ClassType
   NewSpellRec.Desc=OldSpellRec.Desc
   For Var2=1 To 5
      NewSpellRec.Ingred(Var2)=OldSpellRec.Ingred(Var2)
   Next
   NewSpellRec.SpellFlag=OldSpellRec.SpellFlag
   Put TempFile2,Var1,NewSpellRec
Next
Close #TempFile1
Close #TempFile2
Return

' convert treasure.dat from v4.4a to v4.9a.
Upgrade.Treasure.File:
If Dir$("treasure.bkp")<>Nul Then
   Kill "treasure.bkp"
Endif
Name "treasure.dat" As "treasure.bkp"
Open "treasure.bkp" For Random As #TempFile1 Len=OldTreasureRecLen
Open "treasure.dat" For Random As #TempFile2 Len=NewTreasureRecLen
For Var1=1 To Lof(TempFile1)/OldTreasureRecLen
   Get TempFile1,Var1,OldTreasureRec
   NewTreasureRec.TreasureName=OldTreasureRec.TreasureName
   NewTreasureRec.ShortName=OldTreasureRec.ShortName
   NewTreasureRec.Weight=OldTreasureRec.Weight
   NewTreasureRec.Gold=OldTreasureRec.Gold
   NewTreasureRec.Spell=OldTreasureRec.Spell
   NewTreasureRec.Plus=OldTreasureRec.Plus
   NewTreasureRec.Coin=OldTreasureRec.Coin
   NewTreasureRec.Keyed=OldTreasureRec.Keyed
   NewTreasureRec.Scroll=OldTreasureRec.Scroll
   NewTreasureRec.Charges=OldTreasureRec.Charges
   NewTreasureRec.Potion=OldTreasureRec.Potion
   NewTreasureRec.Armor=OldTreasureRec.Armor
   NewTreasureRec.Shield=OldTreasureRec.Shield
   NewTreasureRec.Weapon=OldTreasureRec.Weapon
   NewTreasureRec.Container=OldTreasureRec.Container
   NewTreasureRec.Type=OldTreasureRec.Type
   NewTreasureRec.Locked=OldTreasureRec.Locked
   NewTreasureRec.Closed=OldTreasureRec.Closed
   NewTreasureRec.Loadable=OldTreasureRec.Loadable
   NewTreasureRec.Ammunition=OldTreasureRec.Ammunition
   NewTreasureRec.AmmoLoads=OldTreasureRec.AmmoLoads
   NewTreasureRec.Invisible=OldTreasureRec.Invisible
   NewTreasureRec.Permanent=OldTreasureRec.Permanent
   NewTreasureRec.Proficiency=OldTreasureRec.Proficiency
   NewTreasureRec.RingType=OldTreasureRec.RingType
   NewTreasureRec.RingSpell=OldTreasureRec.RingSpell
   NewTreasureRec.Edible=OldTreasureRec.Edible
   NewTreasureRec.Rustable=OldTreasureRec.Rustable
   NewTreasureRec.RustPercent=OldTreasureRec.RustPercent
   NewTreasureRec.Stealable=OldTreasureRec.Stealable
   NewTreasureRec.StealPercent=OldTreasureRec.StealPercent
   NewTreasureRec.Launchable=OldTreasureRec.Launchable
   NewTreasureRec.LaunchLoads=OldTreasureRec.LaunchLoads
   NewTreasureRec.LaunchAmmo=OldTreasureRec.LaunchAmmo
   NewTreasureRec.Movable=OldTreasureRec.Movable
   NewTreasureRec.Vehicle=OldTreasureRec.Vehicle
   NewTreasureRec.VehicleHits=OldTreasureRec.VehicleHits
   NewTreasureRec.VehicleType=OldTreasureRec.VehicleType
   NewTreasureRec.LightType=OldTreasureRec.LightType
   NewTreasureRec.LightCharges=OldTreasureRec.LightCharges
   NewTreasureRec.FuelType=OldTreasureRec.FuelType
   NewTreasureRec.FuelCharges=OldTreasureRec.FuelCharges
   Put TempFile2,Var1,NewTreasureRec
Next
Close #TempFile1
Close #TempFile2
Return

' convert monsters.dat from v4.4a to v4.9a.
Upgrade.Monster.File:
If Dir$("monsters.bkp")<>Nul Then
   Kill "monsters.bkp"
Endif
Name "monsters.dat" As "monsters.bkp"
Open "monsters.bkp" For Random As #TempFile1 Len=OldMonsterRecLen
Open "monsters.dat" For Random As #TempFile2 Len=NewMonsterRecLen
For Var1=1 To Lof(TempFile1)/OldMonsterRecLen
   Get TempFile1,Var1,OldMonsterRec
   NewMonsterRec.MonsterName=OldMonsterRec.MonsterName
   NewMonsterRec.PluralName=OldMonsterRec.PluralName
   For Var2=1 To 5
      NewMonsterRec.Treasure(Var2)=OldMonsterRec.Treasure(Var2)
   Next
   NewMonsterRec.Experience=OldMonsterRec.Experience
   NewMonsterRec.Gold=OldMonsterRec.Gold
   NewMonsterRec.NumberAppearing=OldMonsterRec.NumberAppearing
   NewMonsterRec.Level=OldMonsterRec.Level
   NewMonsterRec.Hits=OldMonsterRec.Hits
   NewMonsterRec.Poison=OldMonsterRec.Poison
   NewMonsterRec.LevelDrain=OldMonsterRec.LevelDrain
   NewMonsterRec.Spell=OldMonsterRec.Spell
   NewMonsterRec.Block=OldMonsterRec.Block
   NewMonsterRec.Prevent=OldMonsterRec.Prevent
   NewMonsterRec.Follow=OldMonsterRec.Follow
   NewMonsterRec.Magic=OldMonsterRec.Magic
   NewMonsterRec.Jail=OldMonsterRec.Jail
   NewMonsterRec.Teleport=OldMonsterRec.Teleport
   NewMonsterRec.FollowPercent=OldMonsterRec.FollowPercent
   NewMonsterRec.BlockPercent=OldMonsterRec.BlockPercent
   NewMonsterRec.PreventPercent=OldMonsterRec.PreventPercent
   NewMonsterRec.SpellPercent=OldMonsterRec.SpellPercent
   NewMonsterRec.PoisonPercent=OldMonsterRec.PoisonPercent
   NewMonsterRec.DrainPercent=OldMonsterRec.DrainPercent
   NewMonsterRec.Rate=OldMonsterRec.Rate
   NewMonsterRec.RatePercent=OldMonsterRec.RatePercent
   NewMonsterRec.Permanent=OldMonsterRec.Permanent
   For Var2=1 To 5
      NewMonsterRec.Talk(Var2)=OldMonsterRec.Talk(Var2)
   Next
   NewMonsterRec.Psionic=OldMonsterRec.Psionic
   NewMonsterRec.PsionicSpell=OldMonsterRec.PsionicSpell
   Put TempFile2,Var1,NewMonsterRec
Next
Close #TempFile1
Close #TempFile2
Return

' convert nonplyrs.dat from v4.4a to v4.9a.
Upgrade.Nonplayer.File:
If Dir$("nonplyrs.bkp")<>Nul Then
   Kill "nonplyrs.bkp"
Endif
Name "nonplyrs.dat" As "nonplyrs.bkp"
Open "nonplyrs.bkp" For Random As #TempFile1 Len=OldMonsterRecLen
Open "nonplyrs.dat" For Random As #TempFile2 Len=NewMonsterRecLen
For Var1=1 To Lof(TempFile1)/OldMonsterRecLen
   Get TempFile1,Var1,OldMonsterRec
   NewMonsterRec.MonsterName=OldMonsterRec.MonsterName
   NewMonsterRec.PluralName=OldMonsterRec.PluralName
   For Var2=1 To 5
      NewMonsterRec.Treasure(Var2)=OldMonsterRec.Treasure(Var2)
   Next
   NewMonsterRec.Experience=OldMonsterRec.Experience
   NewMonsterRec.Gold=OldMonsterRec.Gold
   NewMonsterRec.NumberAppearing=OldMonsterRec.NumberAppearing
   NewMonsterRec.Level=OldMonsterRec.Level
   NewMonsterRec.Hits=OldMonsterRec.Hits
   NewMonsterRec.Poison=OldMonsterRec.Poison
   NewMonsterRec.LevelDrain=OldMonsterRec.LevelDrain
   NewMonsterRec.Spell=OldMonsterRec.Spell
   NewMonsterRec.Block=OldMonsterRec.Block
   NewMonsterRec.Prevent=OldMonsterRec.Prevent
   NewMonsterRec.Follow=OldMonsterRec.Follow
   NewMonsterRec.Magic=OldMonsterRec.Magic
   NewMonsterRec.Jail=OldMonsterRec.Jail
   NewMonsterRec.Teleport=OldMonsterRec.Teleport
   NewMonsterRec.FollowPercent=OldMonsterRec.FollowPercent
   NewMonsterRec.BlockPercent=OldMonsterRec.BlockPercent
   NewMonsterRec.PreventPercent=OldMonsterRec.PreventPercent
   NewMonsterRec.SpellPercent=OldMonsterRec.SpellPercent
   NewMonsterRec.PoisonPercent=OldMonsterRec.PoisonPercent
   NewMonsterRec.DrainPercent=OldMonsterRec.DrainPercent
   NewMonsterRec.Rate=OldMonsterRec.Rate
   NewMonsterRec.RatePercent=OldMonsterRec.RatePercent
   NewMonsterRec.Permanent=OldMonsterRec.Permanent
   For Var2=1 To 5
      NewMonsterRec.Talk(Var2)=OldMonsterRec.Talk(Var2)
   Next
   NewMonsterRec.Psionic=OldMonsterRec.Psionic
   NewMonsterRec.PsionicSpell=OldMonsterRec.PsionicSpell
   Put TempFile2,Var1,NewMonsterRec
Next
Close #TempFile1
Close #TempFile2
Return

' convert rooms.dat from v4.5a to v4.9a.
Upgrade.Room.File:
If Dir$("rooms.bkp")<>Nul Then
   Kill "rooms.bkp"
Endif
Name "rooms.dat" As "rooms.bkp"
Open "rooms.bkp" For Random As #TempFile1 Len=OldRoomRecLen
Open "rooms.dat" For Random As #TempFile2 Len=NewRoomRecLen
For Var1=1 To Lof(TempFile1)/OldRoomRecLen
   Get TempFile1,Var1,OldRoomRec
   NewRoomRec.Action=OldRoomRec.Action
   NewRoomRec.MonsterClass=OldRoomRec.MonsterClass
   NewRoomRec.ShortDesc=OldRoomRec.ShortDesc
   For Var2=1 To 5
      NewRoomRec.LongDesc(Var2)=OldRoomRec.LongDesc(Var2)
   Next
   For Var2=1 To 12
      NewRoomRec.Direct(Var2)=OldRoomRec.Direct(Var2)
   Next
   For Var2=1 To 20
      NewRoomRec.Flags(Var2)=OldRoomRec.Flags(Var2)
      NewRoomRec.Object(Var2)=OldRoomRec.Object(Var2)
      NewRoomRec.ObjCharges(Var2)=False
      NewRoomRec.Treasure(Var2)=OldRoomRec.Treasure(Var2)
      NewRoomRec.TreCharges(Var2)=OldRoomRec.TreCharges(Var2)
   Next
   NewRoomRec.Container.Closed=OldRoomRec.Container.Closed
   NewRoomRec.Container.ContainerName=OldRoomRec.Container.ContainerName
   NewRoomRec.Container.Locked=OldRoomRec.Container.Locked
   NewRoomRec.Container.Keyed=OldRoomRec.Container.Keyed
   NewRoomRec.Container.ShortName=OldRoomRec.Container.ShortName
   For Var2=1 To 5
      NewRoomRec.Container.Charges(Var2)=OldRoomRec.Container.Charges(Var2)
      NewRoomRec.Container.Inventory(Var2)=OldRoomRec.Container.Inventory(Var2)
      NewRoomRec.Container.Invisible(Var2)=OldRoomRec.Container.Invisible(Var2)
      NewRoomRec.Container.TreasureName(Var2)=OldRoomRec.Container.TreasureName(Var2)
   Next
   NewRoomRec.Container.Permanent=True ' this is the new container attribute!
   Put TempFile2,Var1,NewRoomRec
Next
Close #TempFile1
Close #TempFile2
Return

' convert users.dat from v4.4a to v4.5a.
Upgrade.User.File1:
If Dir$("users.bkp")<>Nul Then
   Kill "users.bkp"
Endif
Name "users.dat" As "users.bkp"
Open "users.bkp" For Random As #TempFile1 Len=UserRecLen1
Open "users.dat" For Random As #TempFile2 Len=UserRecLen2
For Var1=1 To Lof(TempFile1)/UserRecLen1
   Get TempFile1,Var1,UserRec1
   UserRec2.CodeName=UserRec1.Codename
   UserRec2.PassWord=UserRec1.Password
   UserRec2.ClassName=UserRec1.Classname
   UserRec2.ClassType=UserRec1.ClassType
   For Var2=1 To 20
      UserRec2.Inv(Var2)=UserRec1.Inv(Var2)
      UserRec2.Charges(Var2)=UserRec1.Charges(Var2)
      UserRec2.Object(Var2)=UserRec1.Object(Var2)
      UserRec2.ObjCharges(Var2)=False
   Next
   For Var2=1 To 7
      UserRec2.Stats(Var2)=UserRec1.Stats(Var2)
   Next
   For Var2=1 To 4
      UserRec2.Weapons(Var2)=UserRec1.Weapons(Var2)
   Next
   UserRec2.Room=Csng(UserRec1.Room) ' increased from integer to single.
   UserRec2.Level=UserRec1.Level
   UserRec2.Experience=UserRec1.Experience
   UserRec2.Gold=UserRec1.Gold
   UserRec2.NumCalls=UserRec1.Numcalls
   UserRec2.Fatigue=UserRec1.Fatigue
   UserRec2.FatigueMax=UserRec1.Fatiguemax
   UserRec2.Vitality=UserRec1.Vitality
   UserRec2.VitalityMax=UserRec1.Vitalitymax
   UserRec2.Magic=UserRec1.Magic
   UserRec2.MagicMax=UserRec1.MagicMax
   UserRec2.Poison=UserRec1.Poison
   UserRec2.Borrow=UserRec1.Borrow
   UserRec2.Invisible=UserRec1.Invisible
   UserRec2.Race=UserRec1.Race
   UserRec2.Proficiency=UserRec1.Proficiency
   UserRec2.Bank=UserRec1.Bank
   UserRec2.Sort=UserRec1.Sort
   UserRec2.MonstersKilled=UserRec1.MonstersKilled
   UserRec2.Brief=UserRec1.Brief
   UserRec2.DateOn=UserRec1.DateOn
   UserRec2.Beauty=UserRec1.Beauty
   UserRec2.Glamour=UserRec1.Glamour
   UserRec2.Psionic=UserRec1.Psionic
   UserRec2.PsionicMax=UserRec1.PsionicMax
   UserRec2.Align1=UserRec1.Align1
   UserRec2.Align2=UserRec1.Align2
   UserRec2.Flags=UserRec1.Flags
   UserRec2.MaxCalls=UserRec1.MaxCalls
   UserRec2.FromHour=UserRec1.FromHour
   UserRec2.FromMin=UserRec1.FromMin
   UserRec2.ToHour=UserRec1.ToHour
   UserRec2.ToMin=UserRec1.ToMin
   UserRec2.Echo=UserRec1.Echo
   UserRec2.LastMessage=UserRec1.LastMessage
   UserRec2.Linefeeds=UserRec1.Linefeeds
   UserRec2.Linelength=UserRec1.Linelength
   UserRec2.Pagelength=UserRec1.Pagelength
   UserRec2.Wordwrap=UserRec1.WordWrap
   For Var2=1 To 3
      UserRec2.Container(Var2).Closed=UserRec1.Container(Var2).Closed
      UserRec2.Container(Var2).ContainerName=UserRec1.Container(Var2).ContainerName
      UserRec2.Container(Var2).Locked=UserRec1.Container(Var2).Locked
      UserRec2.Container(Var2).Keyed=UserRec1.Container(Var2).Keyed
      UserRec2.Container(Var2).ShortName=UserRec1.Container(Var2).ShortName
      For Var3=1 To 5
         UserRec2.Container(Var2).Charges(Var3)=UserRec1.Container(Var2).Charges(Var3)
         UserRec2.Container(Var2).Inventory(Var3)=UserRec1.Container(Var2).Inventory(Var3)
         UserRec2.Container(Var2).Invisible(Var3)=UserRec1.Container(Var2).Invisible(Var3)
         UserRec2.Container(Var2).TreasureName(Var3)=UserRec1.Container(Var2).TreasureName(Var3)
      Next
   Next
   Put TempFile2,Var1,UserRec2
Next
Close #TempFile1
Close #TempFile2
Return

' convert users.dat from v4.5a to v4.9a.
Upgrade.User.File2:
If Dir$("users.bkp")<>Nul Then
   Kill "users.bkp"
Endif
Name "users.dat" As "users.bkp"
Open "users.bkp" For Random As #TempFile1 Len=UserRecLen2
Open "users.dat" For Random As #TempFile2 Len=UserRecLen3
For Var1=1 To Lof(TempFile1)/UserRecLen2
   Get TempFile1,Var1,UserRec2
   UserRec3.CodeName=UserRec2.Codename
   UserRec3.PassWord=UserRec2.Password
   UserRec3.ClassName=UserRec2.Classname
   UserRec3.ClassType=UserRec2.ClassType
   For Var2=1 To 20
      UserRec3.Inv(Var2)=UserRec2.Inv(Var2)
      UserRec3.Charges(Var2)=UserRec2.Charges(Var2)
      UserRec3.Object(Var2)=UserRec2.Object(Var2)
      UserRec3.ObjCharges(Var2)=False
   Next
   For Var2=1 To 7
      UserRec3.Stats(Var2)=UserRec2.Stats(Var2)
   Next
   For Var2=1 To 4
      UserRec3.Weapons(Var2)=UserRec2.Weapons(Var2)
   Next
   UserRec3.Room=UserRec2.Room
   UserRec3.Level=UserRec2.Level
   UserRec3.Experience=UserRec2.Experience
   UserRec3.Gold=UserRec2.Gold
   UserRec3.NumCalls=UserRec2.Numcalls
   UserRec3.Fatigue=UserRec2.Fatigue
   UserRec3.FatigueMax=UserRec2.Fatiguemax
   UserRec3.Vitality=UserRec2.Vitality
   UserRec3.VitalityMax=UserRec2.Vitalitymax
   UserRec3.Magic=UserRec2.Magic
   UserRec3.MagicMax=UserRec2.MagicMax
   UserRec3.Poison=UserRec2.Poison
   UserRec3.Borrow=UserRec2.Borrow
   UserRec3.Invisible=UserRec2.Invisible
   UserRec3.Race=UserRec2.Race
   UserRec3.Proficiency=UserRec2.Proficiency
   UserRec3.Bank=UserRec2.Bank
   UserRec3.Sort=UserRec2.Sort
   UserRec3.MonstersKilled=UserRec2.MonstersKilled
   UserRec3.Brief=UserRec2.Brief
   UserRec3.DateOn=UserRec2.DateOn
   UserRec3.Beauty=UserRec2.Beauty
   UserRec3.Glamour=UserRec2.Glamour
   UserRec3.Psionic=UserRec2.Psionic
   UserRec3.PsionicMax=UserRec2.PsionicMax
   UserRec3.Align1=UserRec2.Align1
   UserRec3.Align2=UserRec2.Align2
   UserRec3.Flags=UserRec2.Flags
   UserRec3.MaxCalls=UserRec2.MaxCalls
   UserRec3.FromHour=UserRec2.FromHour
   UserRec3.FromMin=UserRec2.FromMin
   UserRec3.ToHour=UserRec2.ToHour
   UserRec3.ToMin=UserRec2.ToMin
   UserRec3.Echo=UserRec2.Echo
   UserRec3.LastMessage=UserRec2.LastMessage
   UserRec3.Linefeeds=UserRec2.Linefeeds
   UserRec3.Linelength=UserRec2.Linelength
   UserRec3.Pagelength=UserRec2.Pagelength
   UserRec3.Wordwrap=UserRec2.Wordwrap
   For Var2=1 To 3
      UserRec3.Container(Var2).Closed=UserRec2.Container(Var2).Closed
      UserRec3.Container(Var2).ContainerName=UserRec2.Container(Var2).ContainerName
      UserRec3.Container(Var2).Locked=UserRec2.Container(Var2).Locked
      UserRec3.Container(Var2).Keyed=UserRec2.Container(Var2).Keyed
      UserRec3.Container(Var2).ShortName=UserRec2.Container(Var2).ShortName
      For Var3=1 To 5
         UserRec3.Container(Var2).Charges(Var3)=UserRec2.Container(Var2).Charges(Var3)
         UserRec3.Container(Var2).Inventory(Var3)=UserRec2.Container(Var2).Inventory(Var3)
         UserRec3.Container(Var2).Invisible(Var3)=UserRec2.Container(Var2).Invisible(Var3)
         UserRec3.Container(Var2).TreasureName(Var3)=UserRec2.Container(Var2).TreasureName(Var3)
      Next
      UserRec3.Container(Var2).Permanent=True ' this is the new container attribute!
   Next
   Put TempFile2,Var1,UserRec3
Next
Close #TempFile1
Close #TempFile2
Return

Error.Routine:
 Close
 Color 15, 0
 Print "Dndcnvt exited with a critical error ";
 Select Case Err
 Case 53
    Print "File not found."
 Case 55
    Print "File already open."
 Case 57
    Print "Media error."
 Case 61
    Print "Disk full."
 Case 62
    Print "Input past eof."
 Case 67
    Print "Not enough file handles."
 Case 68
    Print "Device unavailable."
 Case 70
    Print "Permission denied."
 Case 71
    Print "Disk not ready."
 Case 76
    Print "Pathname not found."
 Case Else
    Print "Untrapped error" + Str$(Err) + "."
 End Select
 Print "Create a new directory and retry the unzip/convert process again."
 Color 7,0
 End
