 Rem * Filename: dnds3.bas Version: v5.1a r1.0a
 Rem * This subprogram contains most of the attack and player death routines.

 Rem $Include: 'dnddoor.inc'

 Rem * routine to attack a monster, or object.
 Rem * input variables:
 Rem *   Parsed.Command1 - contains the attack target.
 Rem *   Room - contains room number user is in.
 Rem * work variables:
 Rem *   Prefix1 - contains prefix to target (he/the/it).
 Rem *   (constants) - command numbers.

Sub Attack.Monster
 On Local Error Resume Next ' local error resume
 Prefix1=Nul ' reset target prefix
 Monster.Number=False ' reset monster target number
 If Room=1! Then ' compare room number
    Outpt="This is a safe haven!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare room number
 Call Check.Room.Objects ' verify target is an object in room
 If Index.Number Then ' compare object index
    If ObjectRecord.JailTrap Then ' check object jails attacker
       Jail.Room.Number=ObjectRecord.RoomLink
       Call Jail ' routine to send player to jail room
    Else ' compare check jail object
       Outpt="Nothing happens.." ' make message
       Call IO.O ' send message
    Endif ' end compare jail object
    Exit Sub ' exit routine
 Endif ' end compare object index
 Previous.Command=False ' reset number of previous attack command
 If Intoxicated>False Then ' compare player is drunk
    Outpt="You are too drunk to fight!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare drunk player
 Call Check.Monster ' verify target is monster
 If Monster.Number=False Then ' check monster index
    If Parser=False Then ' verify command type
       Call Get.Last.Monster(Monster.Found) ' routine to get default monster
       If Monster.Found Then ' check monster exists
          Parsed.Command1=Last.Monster ' store monster name
       Endif ' end check monster
    Endif ' end verufy command
    If Monster.Number=False Then ' verify target found
       Outpt="You can't attack that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify target
 Endif ' end compare monster target
 If MonsterArray(Monster.Number).Jail Then ' verify monster jails attacker
    Jail.Room.Number=MonsterRecord.Teleport ' store jail room number
    Call Jail ' routine to send player to jail room
    Exit Sub ' exit routine
 Endif ' end verify jail monster
 Call The.Or.An ' routine to get prefix
 Outpts=MonsterArray(Monster.Number).MonsterName ' store monster target name
 Outpts=Rtrim$(Outpts) ' trim monster name
 Outpts=Lcase$(Outpts) ' lowercase monster name
 Select Case Last.Command.Number ' make selection of attack command number
 Case Charm ' charm
    If UserRecord.ClassType=Lady Then ' compare class type of player
       If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check magic monster
       If Int(Rnd*10+4)>UserRecord.Beauty Then ' calculate lady hits
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end calculate hits
       MonsterArray(Monster.Number).Magic=5 ' update monster befuddle rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
    Outpt="Your class does not allow that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Beguile ' beguile
    If UserRecord.ClassType=Lady Then ' compare class type of player
       If Int(Rnd*12+5)>(UserRecord.Beauty+UserRecord.Glamour) Then ' calculate
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end calculate monster death
       Call Monster.Died ' calculated monster died
       Exit Sub ' exit routine
    Endif ' end compare class type
    Outpt="Your class does not allow that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Circled ' circle
    If MonsterArray(Monster.Number).Magic<=True Then ' compare magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare magic monster
    ' compute
    Calculate#=(Rnd*5+UserRecord.Level)>MonsterArray(Monster.Number).Level
    If Calculate# Then ' compare circle monster
       Previous.Command=True ' reset previous attack command number
       MonsterArray(Monster.Number).Magic=4 ' update befuddle monster rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare circled monster
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Feint ' feint
    If MonsterArray(Monster.Number).Magic<=True Then ' compare magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare magic monster
    Calculate#=UserRecord.Stats(4)>(Rnd*5+MonsterArray(Monster.Number).Level/2)
    If Calculate# Then ' compare calculated befuddle
       Previous.Command=Last.Command.Number ' store last command number
       MonsterArray(Monster.Number).Magic=3 ' update monster befuddle rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare calculation
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Resist, Parry ' parry, resist
    Previous.Command=Last.Command.Number ' store last command number
    Outpt="It worked!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Turn ' turn
    Magic.Spell=12 ' force turn spell cast
 Case Bemuse ' bemuse
    If UserRecord.ClassType=Lady Then ' compare player class type
       If MonsterArray(Monster.Number).LevelDrain Then ' check monster type
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end compare class type
       If Int(Rnd*8+5)>UserRecord.Glamour Then ' calculate lady level drain
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end calculate level drain
       MonsterArray(Monster.Number).Level=MonsterArray(Monster.Number).Level-1
       Outpt="You drain a level from the "+Outpts+"!" ' decrement monster level
       Call IO.O ' send message
       If MonsterArray(Monster.Number).Level<=False Then ' check monster level
          Outpt="You killed the "+Outpts+"!" ' make message
          Call IO.O ' send message
          Call Monster.Died ' routine for dead monster
          Exit Sub ' exit routine
       Endif ' end compare dead monster
    Endif ' end compare lady class
    Outpt="Your class does not allow that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Befuddle ' befuddle
    If MonsterArray(Monster.Number).Magic<=True Then ' compare magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare magic monster
    If (UserRecord.Stats(3)+UserRecord.Stats(4))> _
    (Rnd*10+MonsterArray(Monster.Number).Level/2) Then ' calculate befuddle
       Previous.Command=True ' reset previous command number
       MonsterArray(Monster.Number).Magic=6 ' update monster befuddle rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end calculate befuddle
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Lunge, Dodge ' lunge, dodge
    If Weapon5 Then ' verify player holding shield
       Weapon3=False ' reset shield
       Weapon5=False ' reset shield
       Outpt="You return your shield!" ' make message
       Call IO.O ' send message
    Endif ' end verify shield
 Case Beat, Punch ' beat, punch
    If Weapon6 Then ' verify holding weapon
       Weapon2=False ' reset weapon
       Weapon6=False ' reset weapon
       Weapon10=False ' reset weapon
       Outpt="You return your weapon!" ' make message
       Call IO.O ' send message
    Endif ' end verify weapon
 Case Shield, Guard ' shield, guard
    If Weapon3 Then ' verify holding shield
       Previous.Command=True ' reset previous command
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify shield
    Previous.Command=False ' reset previous command
    Outpt="You are not holding a shield!" ' make error message
    Call IO.O ' send message
    Exit Sub ' exit routine
 End Select ' end select command number
 Select Case Magic.Spell ' select attack of spell number
 Case Poison ' poison spell
    If MonsterArray(Monster.Number).Poison Then ' check monster is poisoned
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end random chance
    ' poison monster rounds
    MonsterArray(Monster.Number).Poison=UserRecord.Level
    Outpt="You poison the "+Outpts+"!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case LevelDrain ' leveldrain spell
    If MonsterArray(Monster.Number).LevelDrain Then ' check monster is undead
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check random chance
    MonsterArray(Monster.Number).Level=MonsterArray(Monster.Number).Level-1
    Outpt="You drain a level from the "+Outpts+"!" ' decrement monster level
    Call IO.O ' send message
    If MonsterArray(Monster.Number).Level<=False Then ' check monster level
       Outpt="You killed the "+Outpts+"!" ' make message
       Call IO.O ' send message
       Call Monster.Died ' routine for dead monster
    Endif ' end check monster level
    Exit Sub ' exit routine
 Case Befuddled ' befuddle spell
    If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check magic monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
    Endif ' end chance
    MonsterArray(Monster.Number).Magic=4 ' update monster befuddle rounds
    Outpt="It worked!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case TurnUndead ' turn undead spell
    ' check monster undead
    If MonsterArray(Monster.Number).LevelDrain=False Then
       Outpt="That's not undead!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check monster
    Calculate#=(Rnd*UserRecord.Level+2)>MonsterArray(Monster.Number).Level
    If Calculate# Then ' calculate cast spell
       Outpt="You damned the "+Outpts+"!" ' make message
       Call IO.O ' send message
       MonsterArray(Monster.Number).Level=MonsterArray(Monster.Number).Level-1
       Outpt="You drain a level from the "+Outpts+"!" ' decrement monster level
       Call IO.O ' send message
       If MonsterArray(Monster.Number).Level<=False Then ' check monster level
          Outpt="You killed the "+Outpts+"!" ' make message
          Call IO.O ' send message
          Call Monster.Died ' routine for dead monster
          Exit Sub ' exit routine
       Endif ' end check monster level
    Endif ' end calculate undead spell
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Intoxicate ' intoxicate spell
    If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
       Intoxicated=UserRecord.Level ' store intoxicated rounds counter
       Outpt="You just became very drunk!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check magic monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check chance
    MonsterArray(Monster.Number).Magic=3 ' update monster befuddle rounds
    Outpt="It worked!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 End Select ' end selection of magic spell number
 If Magic.Spell=False Then ' compare spell being cast
    If UserRecord.Fatigue<=False Then ' check player fatigue
       UserRecord.Fatigue=False ' reset fatigue
       Outpt="You are too exhausted to fight!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check player fatigue
    ' normal attack can't hit magical monsters, only spells can
    If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
       Outpt="A magical force prevents your attack!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check magic monster
 Endif ' end compare spell being cast
 ' nonplayers can't be attacked by normal weapons or spells.
 ' check permanent nonplayer
 If MonsterArray(Monster.Number).Permanent<True Then
    Outpt="A mysterious force prevents your attack!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check nonplayer
 ' calculate miss on monster
 Calculate#=(Rnd*10+MonsterArray(Monster.Number).Level/10)>UserRecord.Stats(4)
 If Calculate# Then ' player missed
    If Magic.Spell Then ' check spell being cast
       Outpt="You missed!" ' spell missed message
       Call IO.O ' send output message
       Exit Sub ' exit routine
    Endif ' end check spell being cast
    ' attacking with a weapon
    Calculate#=(Rnd*10)>UserRecord.Stats(1) ' calculate fumble
    If Calculate# Then ' fumbled
       Call Fumble ' routine to drop weapon, shield
    Endif ' end fumble check
    Outpt="You missed the "+Outpts+"!" ' make miss message
    Call IO.O ' send output message
    Exit Sub ' exit routine
 Endif ' end check player missed
 ' calculate attack weapon bonus multiplier
 If Magic.Spell=False Then ' verify attack by weapon, not spell
    Outpt=Nul ' reset output string
    Multiplier=1 ' reset multiplier
    Select Case Weapon6 ' select type of weapon being held
    Case False ' no weapon being held
       Outpt="Punch!" ' punch with fists
    Case Else ' weapon is being held
       Select Case Rnd ' select random chance
       Case Is>.96 ' highest probability
          Outpt="Deathly damage!" ' make damage message
          Multiplier=4 ' set multiplier
       Case Is>.91 ' median probability
          Outpt="Triple damage!" ' make damage message
          Multiplier=3 ' set multiplier
       Case Is>.86 ' lowest probability
          Outpt="Double damage!" ' make damage message
          Multiplier=2 ' set multiplier
       End Select ' end selection of random chance for weapon
    End Select ' end selection of weapon type
 Endif ' end verify weapon attack
 Select Case Last.Command.Number ' selection of attack command number
 Case Killed ' kill
    If Outpt<>Nul Then ' check bonus hit string
       Call IO.O ' send bonus output message
    Endif ' end check bonus flag
 Case Lunge, Dodge ' lunge, dodge
    Multiplier=2 ' store lunge/dodge multiplier
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Backstab ' backstab
    If Hidden.Player Then ' verify player hidden for backstab
       Multiplier=Multiplier+1 ' increment hit multiplier
    Else ' player not hidden
       Outpt="The "+Outpts+" sees you!" ' make message
       Call IO.O ' send message
       Multiplier=Multiplier-1 ' decrement multiplier
    Endif ' end verify hidden player
 Case Thrust ' thrust
    Multiplier=Multiplier+1 ' increment hit multiplier for thrust
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Charge ' charge
    Outpt="Argh! You charge towards the "+Outpts+"!" ' make hit message
    Call IO.O ' send hit message
    Multiplier=Multiplier+1 ' increment hit multiplier
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Counter ' counter
    Multiplier=Multiplier+1 ' increment multiplier for counter attack
 Case Pummel ' pummel
    Outpt="Your fists fly at the monster!" ' make hit message
    Call IO.O ' send hit message
    Multiplier=2 ' set hit multiplier
 Case Beat, Punch ' beat, punch
    Multiplier=2 ' set hit multiplier
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Bewitch ' bewitch
    Multiplier=Multiplier+1 ' increment hit multiplier for bewitch attack
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Bewilder ' bewilder
    Multiplier=Multiplier+1 ' increment hit multiplier for bewilder attack
    Previous.Command=Last.Command.Number ' store last command attack number
 End Select ' end selection of attack command number
 If Magic.Spell=False Then ' verify weapon being used, not spell cast
    If Weapon6 Then ' check player holding weapon
       ' decrement weapon strikes remaining.
       ' store weapon strikes remaining
       Charges.Number=UserRecord.Charges(Weapon6)
       If Charges.Number>False Then ' check weapon strikes remaining
          Charges.Number=Charges.NUmber-1 ' decrement weapon strikes
       Endif ' end check strikes remaining
       ' store weapon strikes in user record
       UserRecord.Charges(Weapon6)=Charges.Number
       If Charges.Number=False Then ' verify weapon strikes
          Call Read.Record(TreasureFile,UserRecord.Inv(Weapon6)) ' get record
          Inpt=TreasureRecord.ShortName ' store weapon mnemonic
          Inpt=Rtrim$(Inpt) ' trim mnemonic
          Inpt=Lcase$(Inpt) ' lowercase mnemonic
          Outpt="Your "+Inpt+" breaks in half!" ' make weapon message
          Call IO.O ' send weapon message
          Call Discard.Inventory(Weapon6,False) ' weapon falls to ground
       Endif ' end verify remaining weapon strikes
    Endif ' end check player holding weapon
 Endif ' end verify weapon being used
 Magic.Spell=True ' reset spell cast flag
 Call Hit.Monster ' get actual hits on monster
End Sub ' end routine to attack monster

 Rem * routine to send player to jail room number.

Sub Jail
 On Local Error Resume Next ' local error resume
 Outpt="You were just thrown in jail!" ' make message
 Call IO.O ' send jail message
 If Jail.Room.Number=0! Then ' check jail room number
    Next.Room=1! ' reset player room number
 Else ' check jail room number
    Next.Room=Jail.Room.Number ' store new room number
 Endif ' end check jail room number
 Call Enter.Room ' send player to jail room
End Sub ' end routine to jail player

 Rem * routine to decrease the number of monsters in the room.

Sub Reduce.Monsters
 On Local Error Resume Next ' local error resume
 Inpt=Parsed.Command1 ' store command parameter
 Inpt=Rtrim$(Inpt) ' trim command parameter
 New.Monsters=Int(Val(Inpt)+.5) ' convert parameter to integer
 ' compare number to reduce
 If New.Monsters>=False And New.Monsters<Number.Monsters Then
    Number.Monsters=New.Monsters ' reduce monsters in room
    Outpt="Number of Monsters reduced to:"+Str$(Number.Monsters)+".."
    Call IO.O ' send monsters reduced message
 Endif ' end compare number to reduce
End Sub ' end routine to decrease monsters in room

 Rem * routine to kill off a monster.

Sub Kill.Monster
 On Local Error Resume Next ' local error resume
 Monster.Number=False ' reset monster number
 Call Check.Monster ' get monster number from command parameter
 If Monster.Number Then ' compare monster name found to kill
    Graphics.Off=True ' reset color
    Outpt="Evil Laughter Sounds From Above..." ' make message
    Call IO.O ' send message
    Outpt="   A Bolt Of Lightning Strikes..." ' make message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="The "+Outpts+" was just struck dead!" ' make monster died message
    Call IO.O ' send monster died message
    Call Monster.Died ' kill monster
    Exit Sub ' exit routine
 Endif ' end compare monster name
 Outpt="You can't kill that!" ' make error message
 Call IO.O ' send error message
End Sub ' end routine to kill monster

 Rem * routine to attack monster.
 Rem * input variables:
 Rem *   Monster.Number - number of monster in array to attack.
 Rem *   Outpts - name of monster being attacked.
 Rem * processing variables:
 Rem *   Calculate# - maximum possible hits on monster.

Sub Hit.Monster
 On Local Error Resume Next ' local error resume
 Hidden.Player=False ' reset hidden player
 If Last.Command.Number=PsiMode Then ' compare attack type
    ' calculate hits on monster for psionic attack
    Calculate#=Cdbl(Int(Rnd*UserRecord.Stats(2)+UserRecord.Stats(3)* _
    (Psi.Attack.Mode+Multiplier)))
 Else ' compare attack type
    ' calculate hits on monster for normal attack
    Calculate#=Cdbl(Int((Rnd*UserRecord.Stats(1)+UserRecord.Level/2)* _
    (Multiplier+(UserRecord.Weapons(UserRecord.Proficiency)/100))+Weapon2))
 Endif ' end compare attack type
 Magic.Spell=False ' reset magic spell being used to attack
 If Calculate#<=False Then ' check hits are zero
    Outpt="You missed!" ' make missed message
    Call IO.O ' send missed message
    Exit Sub ' exit routine
 Endif ' end check hits
 Outpt="You hit the "+Outpts+" for"+Str$(Calculate#)+" hits!" ' hits message
 Call IO.O ' send hits message
 Call Monster.Flees(Ran.Away) ' check if monster flees
 If Ran.Away Then ' compare flee
    Call Monster.Died ' routine for dead monster
    Exit Sub ' exit routine
 Endif ' end compare flee
 ' magical monsters don't attack until hit.
 ' check magical monster attacked
 If MonsterArray(Monster.Number).Magic=True Then
    MonsterArray(Monster.Number).Magic=-2 ' set magical monster to attack also
 Endif ' end check attacking a magical monster
 ' decrement the hits on the monster
 MonsterArray(Monster.Number).Hits=MonsterArray(Monster.Number).Hits-Calculate#
 If MonsterArray(Monster.Number).Hits<=False Then ' check monster still alive
    Outpt="You just killed the "+Outpts+"!" ' make message
    Call IO.O ' send message
    Call Monster.Died ' routine for dead monster
 Endif ' end check live monster
End Sub ' end routine to attack monster
 
 Rem * routine to calculate hits causes monster to run.
 Rem * output variables:
 Rem *   Ran.Away - true if monster flees.
 Rem * input variables:
 Rem *   Outpts - name of monster.

Sub Monster.Flees(Ran.Away)
 On Local Error Resume Next ' local error resume
 Ran.Away=False ' reset return variable
 If MonsterArray(Monster.Number).Magic>=False Then ' nonmagical monster
    If MonsterArray(Monster.Number).Permanent=False Then ' nonpermanent monster
       ' calculate hits on monster
       If MonsterArray(Monster.Number).Hits-Calculate#>False Then
          ' calculate 25% of hits
          If Calculate#>(MonsterArray(Monster.Number).Hits*.75) Then
             Outpt="The "+Outpts+" flees from your attack!" ' make message
             Call IO.O ' send message
             MonsterArray(Monster.Number).Experience= _
             Int(MonsterArray(Monster.Number).Experience/2) ' half experience
             Ran.Away=True ' reset return variable
          Endif ' end calculate hits on monster is 25%
       Endif ' end check if monster has hits remaining after attack
    Endif ' end verify permanent monster
 Endif ' end verify magical monster
End Sub ' end routine to check monster flees

 Rem * routine for dead monster.
 Rem * input variables:
 Rem *   Monster.Number - index of monster to array.
 Rem * processing variables:
 Rem *   Monsters.Killed - total monsters killed by player this session.
 Rem *   Choice - index of monster file.
 Rem *   Weapon6, Weapon10 - proficiency calculations.

Sub Monster.Died
 On Local Error Resume Next ' local error resume
 ' check permanent nonplayer
 If MonsterArray(Monster.Number).Permanent<True Then
    Call Remove.Monster ' nonplayer only leaves room
    Exit Sub ' exit routine
 Endif ' end check nonplayer
 Graphics.Off=True ' reset color
 Last.Command.Number=False ' reset last attack command number
 Outpt="On it you find " ' format message prefix
 Carriage.Return=True ' disable cr/lf
 Call IO.O ' send message prefix
 Number.Items=False ' number of items
 ' loop through monster array for all treasure to leave on ground
 For Treasure.Index=1 To 5 ' loop through monster inventory
    ' get next inventory
    Treasure.Number=MonsterArray(Monster.Number).Treasure(Treasure.Index)
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' file bounds
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       Call TreasureCharges(Charges.Amount) ' routine to get treasure charges
       ' add inventory to ground
       Call Add.Room.Treasure(Treasure.Number,Charges.Amount,False,Item.Added)
       If Item.Added Then ' compare return variable to add to room
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send message of previous treasure name
          ' format treasure name
          Outpt=Rtrim$(TreasureRecord.TreasureName)+", "
          Number.Items=Number.Items+1 ' increment number of items
       Endif ' end compare reutnr variable
    Endif ' end compare file bounds
 Next ' end loop through monster inventory
 If Number.Items=False Then ' compare number of items
    Outpt="nothing.." ' format message
 Else ' compare items
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' strip comma, add period
    If Number.Items>1 Then ' compare more than one item
       Outpt="and "+Outpt ' append to message
    Endif ' end compare number of items
 Endif ' end compare number of items
 Call IO.O ' send last part of message
 Call Share.Room.Record(Room) ' write the room record
 Monsters.Killed=Monsters.Killed+1 ' increment player monsters killed session
 ' increment player record
 UserRecord.MonstersKilled=UserRecord.MonstersKilled+1
 Choice=MonsterIndex(Monster.Number) ' store monster record number
 If MonsterArray(Monster.Number).Permanent=True Then ' check permanent monster
    Call Read.Record(MonsterFile,Choice) ' get permanent monster record
    MonsterRecord.Permanent=False ' clear permanent monster flag
    Call Share.Record(MonsterFile,Choice) ' put permanent monster record
 Endif ' end check permanent monster
 If Weapon6 And Weapon10 Then ' check player is holding a weapon
    ' calculate difference between player and monster level
    Level=MonsterArray(Monster.Number).Level-UserRecord.Level
    If Level>False Then ' check level is positive
       ' store player weapon proficiency number
       Proficient.Weapon=UserRecord.Proficiency
       ' check player is holding a weapon in his weapon proficiency
       If Weapon10=Proficient.Weapon Then
          Level=Level*10 ' compute proficiency for kill
       Else ' compare weapon proficiency for weapon held
          Level=Level*5 ' compute proficiency for kill
       Endif ' end compare weapon proficiency held
       If Level>100 Then ' check calculated proficiency over 100 percent
          Level=100 ' reset to 100 percent
       Endif ' end check maximum proficiency percent
       ' compare to current
       If Level>UserRecord.Weapons(Proficient.Weapon) Then
          ' proficiency, store new percent
          UserRecord.Weapons(Proficient.Weapon)=Level
          Outpt="Your "+Rtrim$(Weapon.Type.Name(Proficient.Weapon))+ _
          " weapon proficiency is now"+Str$(Level)+" percent!" ' make message
          Call IO.O ' send weapon message
       Endif ' end check maximum percent
    Endif ' end check attack level
 Endif ' end check player holding weapon
 Exp.Points#=MonsterArray(Monster.Number).Experience ' store monster experience
 Gold.Points#=MonsterArray(Monster.Number).Gold ' store monster gold
 If Gold.Points#<=False Then ' compare monster gold
    Gold.Points#=10 ' set to minimum
 Endif ' end compare monster gold
 Outpt="You gained"+Str$(Exp.Points#)+" experience points" ' make message
 If Gold.Points#>False Then ' compare gold
    Outpt=Outpt+" and"+Str$(Gold.Points#)+" gold" ' append gold message
 Endif ' end compare gold
 Outpt=Outpt+"!" ' append message
 Call IO.O ' send experience and gold message
 UserRecord.Gold=UserRecord.Gold+Gold.Points# ' increment player gold
 ' increment player experience
 UserRecord.Experience=UserRecord.Experience+Exp.Points#
 Call Remove.Monster ' take monster out of active monster array
 If UserRecord.Level>False Then ' verify player level
    ' calculate experience needed to reach next level
    Call Experience(Exp.Required#)
    If UserRecord.Experience>=Exp.Required# Then ' compare player experience
       Call Gold(Gold.Required#) ' routine calculates gold needed for level
       If UserRecord.Gold>=Gold.Required# Then ' compare to player gold
          Call Is.Training.Room(In.Room) ' check training room
          If In.Room Then ' check flag
             Call Train.Stats ' routine to train for next level
          Endif ' end check flag
       Endif ' end check player gold required
    Endif ' end check player experience required
 Endif ' end check player level
End Sub ' end monster death routine

 Rem * routine to remove a monster from the monster arrays.
 Rem * input variables:
 Rem *   Monster.Number - number of monster to remove.
 Rem * output variables:
 Rem *   Number.Monsters - number of monster currently in room.

Sub Remove.Monster
 On Local Error Resume Next ' local error resume
 ' loop through monster array from monster to remove
 For Array.Index=Monster.Number To 19 ' pack array
    ' move next array element
    MonsterIndex(Array.Index)=MonsterIndex(Array.Index+1)
    ' move next array element
    MonsterArray(Array.Index)=MonsterArray(Array.Index+1)
 Next ' end loop through all monsters in arrays
 Number.Monsters=Number.Monsters-1 ' decrement number of monsters in room
 If Number.Monsters<False Then ' compare number of monsters in room
    Number.Monsters=False ' reset numberof monsters to zero
 Endif ' end compare number of monsters
End Sub ' end routine to remove a monster

 Rem * routine for monsters to attack player.

Sub Monster.Attack
 On Local Error Resume Next ' local error resume
 Monster.Cycle=Monster.Cycle+1 ' increment attack counter
 If Monster.Cycle>=Room.Monster.Rate Then ' compare attack counter to
    Monster.Cycle=False ' room monster attack rate counter, reset to zero
 Endif ' end compare rate counters
 If Number.Monsters=False Then ' check monsters in room
    Exit Sub ' exit routine if no monsters
 Endif ' end check monsters in room
 If Room=1! Then ' check player in safe room
    Exit Sub ' exit routine for safe room
 Endif ' end check player in safe room
 For Monster.Number=1 To Number.Monsters ' loop through all monsters in room
    ' get monster befuddle rounds
    Inactive.Rounds=MonsterArray(Monster.Number).Magic
    If Inactive.Rounds>=False Then ' compare number of befuddle rounds
       If UserRecord.Stats(6)<=1 Then ' check player piety
          Inactive.Rounds=False ' monsters attack on sight for low piety
       Endif ' end check player piety
       ' compare inactive befuddle rounds for monster
       If Inactive.Rounds>False Then
          Inactive.Rounds=Inactive.Rounds-1 ' decrement befuddle rounds
       Endif ' end compare monster befuddle rounds
       ' store monster befuddle rounds
       MonsterArray(Monster.Number).Magic=Inactive.Rounds
    Endif ' end compare number of monster befuddle rounds
    If Inactive.Rounds<True Then ' check if magical monster is attacking
       ' reset befuddle rounds remaining for monster to zero
       Inactive.Rounds=False
    Endif ' end check magical monster is attacking
    ' routine for monster hit regeneration
    If MonsterArray(Monster.Number).Magic<=True Then ' check magical monster
       If MonsterArray(Monster.Number).Level>=15 Then ' check monster level
          If Monster.Cycle=False Then ' compare room monster update rate
             Calculate#=MonsterArray(Monster.Number).Hits ' store monster hits
             ' regenrate hits by ten percent
             Calculate#=Cdbl(Int(Calculate#+Calculate#*.1))
             If Calculate#>MaxInt Then ' check max integer
                ' store new monster hits
                MonsterArray(Monster.Number).Hits=MaxInt
             Endif ' end check integer
             If Calculate#<=MaxInt Then ' check max integer
                ' store new monster hits
                MonsterArray(Monster.Number).Hits=Calculate#
             Endif ' end check integer
          Endif ' end compare room monster update rate
       Endif ' end check monster level
    Endif ' end check magical monster
    ' continue with monster attack if player is not hidden,
    ' and monster is not befuddled.
    ' continue with monster attack
    If Hidden.Player=False And Inactive.Rounds=False Then
       Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
       Outpts=Rtrim$(Outpts) ' trim monster name
       Outpts=Lcase$(Outpts) ' lowercase monster name
       ' compute monster attack multiplier is monster level plus one
       Multiplier=MonsterArray(Monster.Number).Level+1 ' compute multiplier
       If MonsterArray(Monster.Number).Poison Then ' check monster is poisonous
          ' compute random chance of monster poison percent
          If Rnd<(MonsterArray(Monster.Number).PoisonPercent/100) Then
             Outpt="The "+Outpts+" casts a poison spell!" ' make message
             Call IO.O ' send poison message
             ' check player is wearing antipoison ring
             If Weapon8=1 Then ' check for ring
                Ring.Charges=UserRecord.Charges(Weapon7) ' store ring strikes
                ' decrement strikes
                Ring.Charges=Ring.Charges-MonsterArray(Monster.Number).Level
                If Ring.Charges<False Then ' compare strikes remaining
                   Ring.Charges=False ' store zero strikes
                Endif ' end compare strikes
                ' store strikes in record
                UserRecord.Charges(Weapon7)=Ring.Charges
                Outpt="Your ring absorbs the poison spell!" ' make message
                Call IO.O ' send ring protection message
                If Ring.Charges=False Then ' compare ring charges remaining
                   Outpt="Your ring disintegrated!" ' make message
                   Call IO.O ' send ring message
                   Call Discard.Inventory(Weapon7,True) ' ring falls to ground
                Endif ' end compare ring charges
             Else ' check for ring
                UserRecord.Poison=True ' reset user poisoned flag
                Outpt="You've been poisoned!" ' make message
                Call IO.O ' send poisoned message
             Endif ' end compare ring
          Endif ' end compute monster poisons
       Endif ' end compare monster is poisonous
       ' check monster is undead
       If MonsterArray(Monster.Number).LevelDrain Then
          ' compute random chance vs. undead monster leveldrain percent
          If Rnd<(MonsterArray(Monster.Number).DrainPercent/100) Then ' compute
             Outpt="The "+Outpts+" casts a level drain spell!" ' message
             Call IO.O ' send level drain message
             ' check player is wearing anti level drain ring
             If Weapon8=2 Then ' check for ring
                Ring.Charges=UserRecord.Charges(Weapon7) ' store ring strikes
                ' decrement ring charges
                Ring.Charges=Ring.Charges-MonsterArray(Monster.Number).Level
                If Ring.Charges<False Then ' compare strikes
                   Ring.Charges=False ' reset ring strikes
                Endif ' end compare strikes
                ' store srikes in record
                UserRecord.Charges(Weapon7)=Ring.Charges
                Outpt="Your ring absorbs the level drain!" ' make message
                Call IO.O ' send ring message
                If Ring.Charges=False Then ' check ring charges
                   Outpt="Your ring disintegrated!" ' make message
                   Call IO.O ' send ring charges message
                   Call Discard.Inventory(Weapon7,True) ' ring falls to ground
                Endif ' end check remaining ring charges
             Else ' check player wearing ring
                UserRecord.Level=UserRecord.Level-1 ' decrement player level
                Call New.Stats ' get updated statistics
                Outpt="You've been drained a level!" ' make message
                Call IO.O ' send leveldrain message
                If UserRecord.Level<=False Then ' compare player level to dead
                   UserRecord.Level=1 ' reset player level
                   Call The.Or.An ' get monster prefix
                   ' store message for death routine
                   Message1="You were just killed by "+Prefix1+" "+Outpts+"!"
                   Call Player.Died ' routine for dead player
                   Exit For ' exit monster attack loop
                Endif ' end compare player level
             Endif ' end check player has ring
          Endif ' end compute random chance
       Endif ' end check monster is undead
       Magic.Spell=False ' reset magic spell being cast
       ' get monster spell cast number
       Spell.Number=MonsterArray(Monster.Number).Spell
       ' file bounds
       If Spell.Number>False And _
       Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
          Call Read.Record(SpellFile,Spell.Number) ' get spell record
          Magic.Spell=SpellRecord.SpellType ' store monster spell cast type
          Multiplier=Int(MonsterArray(Monster.Number).Level) ' calculate spell
          Multiplier=Multiplier+Int(SpellRecord.Level/2+.5) ' attack multiplier
          If Magic.Spell=Offense Then ' compare spell type to offense attack
             ' compute random chance to monster spell percent
             If Rnd<(MonsterArray(Monster.Number).SpellPercent/100) Then
                ' make message of spell monster casts
                Outpt="The "+Outpts+" casts a "+ _
                Rtrim$(SpellRecord.SpellName)+" spell!" ' message
                Call IO.O ' send cast message
                ' check player is wearing antispell ring
                If Weapon8=3 Then ' check ring
                   ' check ring is generic antispell or the spell cast
                   If Weapon9=True Or Weapon9=Spell.Number Then ' check ring
                      ' store ring strikes
                      Ring.Charges=UserRecord.Charges(Weapon7)
                      ' subtract spell level
                      Ring.Charges=Ring.Charges-SpellRecord.Level
                      If Ring.Charges<False Then ' compare strikes
                         Ring.Charges=False ' reset strikes
                      Endif ' end compare strikes
                      UserRecord.Charges(Weapon7)=Ring.Charges ' store strikes
                      Outpt="Your ring absorbs the spell!" ' make message
                      Call IO.O ' send ring message
                      ' check remaining ring charges
                      If Ring.Charges=False Then ' compare
                         Outpt="Your ring disintegrated!" ' make message
                         Call IO.O ' send ring message
                         Call Discard.Inventory(Weapon7,True) ' falls to ground
                      Endif ' end compare ring charges
                   Endif ' end ring type
                Endif ' end check ring
             Endif ' end computer random chance
          Endif ' end compare spell attack type
       Endif ' end check spell file bounds
       ' check if monster is poisoned
       If MonsterArray(Monster.Number).Poison>False Then ' check poisoned
          If Monster.Cycle=False Then ' compare rounds counter
             ' decrement monster poisoned rounds counter
             MonsterArray(Monster.Number).Poison= _
             MonsterArray(Monster.Number).Poison-1 ' decrement
             Outpt="Poison drains the "+Outpts+"!" ' make message
             Call IO.O ' send poisoned message
             ' calculate hits on monster from poison.
             ' store monster hits
             Monster.Hits#=MonsterArray(Monster.Number).Hits
             ' store monster level
             Monster.Level#=MonsterArray(Monster.Number).Level
             ' compute poison
             Poison.Hits#=Int(UserRecord.Level*UserRecord.Stats(7))
             ' compute poison
             Monster.Hits#=Int(Monster.Hits#-Poison.Hits#/Monster.Level#)
             ' store monster hits
             MonsterArray(Monster.Number).Hits=Monster.Hits#
             ' check monster hits
             If MonsterArray(Monster.Number).Hits<=False Then
                Outpt="The "+Outpts+" died from poison!" ' make message
                Call IO.O ' send died message
                Call Monster.Died ' routine for dead monster
                Exit For ' exit monster attack routine
             Endif ' end check monster hits
          Endif ' end compare rounds counter
       Endif ' end check monster is poisoned
       ' calculate monster misses
       Calculate#=(UserRecord.Stats(4)/2)> _
       (Rnd*10+MonsterArray(Monster.Number).Level/10) ' calculate miss
       If Calculate# Then ' compare miss equation
          Outpt="The "+Outpts+" fumbled!" ' make message
          Call IO.O ' send missed message
       Else ' compare miss
          If Previous.Command=True Then ' compare previous attack command type
             Multiplier=Multiplier-1 ' decrement monster multiplier
             Previous.Command=False ' reset last attack command type
          Endif ' end compare previous attack command type
          ' compare psionic monster
          If MonsterArray(Monster.Number).Psionic=False Then ' compare
             ' calculate normal hits on player
             Calculate#=Cdbl(Int(Rnd*(MonsterArray(Monster.Number).Hits/10- _
             (Weapon1+Weapon3)/2)*Multiplier))
          Else ' calculate psionic hits on player
             ' calculate psionic hits on player
             Calculate#=Cdbl(Int(Rnd*(MonsterArray(Monster.Number).Hits/10- _
             Psi.Defense.Mode)*MonsterArray(Monster.Number).Psionic))
          Endif ' end compare attack type
          Call The.Or.An ' get prefix of monster name
          Prefix1="The " ' reset prefix
          Call Get.Hits(Calculate#) ' routine to hit player
          If Calculate#=True Then ' return variable for dead player
             Exit For ' exit monster attack loop
          Endif ' end check dead player
       Endif ' end compare monster miss equation
    Endif ' end compare monster befuddle rounds
 Next ' end loop through all monsters in room
End Sub ' end routine for monster attacks

 Rem * routine to hit player.
 Rem * input variables:
 Rem *   Calculate# - actual hits.
 Rem * output variables:
 Rem *   Calculate# - true if player died.

Sub Get.Hits(Calculate#)
 On Local Error Resume Next ' local error resume
 ' selecting the previous attack command player used modifies the actual
 ' hits by the type of attack, and reduces or increases the actual hits
 Select Case Previous.Command ' select the previous attack command
 Case Lunge ' lunge
    Calculate#=Calculate#-UserRecord.Stats(4)/2-UserRecord.Stats(1)/2
 Case Dodge ' dodge
    Calculate#=Calculate#-(UserRecord.Stats(4)+UserRecord.Stats(1))/2
 Case Feint ' feint
    Calculate#=Calculate#-UserRecord.Stats(4)/2-UserRecord.Stats(1)
 Case Parry ' parry
    Calculate#=Calculate#-UserRecord.Stats(4)-UserRecord.Stats(1)
 Case Thrust ' thrust
    Calculate#=Calculate#+UserRecord.Stats(4)/2+UserRecord.Stats(1)
 Case Charge ' charge
    Calculate#=Calculate#+UserRecord.Stats(4)+UserRecord.Stats(1)
 Case Resist ' resist
    Calculate#=Calculate#-UserRecord.Stats(1)/2
 Case Beat ' beat
    Calculate#=Calculate#+UserRecord.Stats(4)/2+UserRecord.Stats(1)/2
 Case Punch ' punch
    Calculate#=Calculate#+(UserRecord.Stats(4)+UserRecord.Stats(1))/2
 Case Bewitch ' bewitch
    Calculate#=Int(Calculate#/2)-UserRecord.Beauty
 Case Bewilder ' bewilder
    Calculate#=Int(Calculate#/2)-UserRecord.Glamour
 End Select ' end selection of previous attack command
 If Calculate#<=False Then ' compare hits on player to miss
    Outpt=Prefix1+Outpts+" missed!" ' make message
    Call IO.O ' send miss message
    Calculate#=False ' return value for live player
    Exit Sub ' exit routine
 Endif ' end compare hits to miss
 If Monster.Number Then ' check monster is attacking
    If Magic.Spell=False Then ' check monster using spell
       Outpt=Prefix1+Outpts+" attacks you" ' make attack message
       ' check monster using psionic
       If MonsterArray(Monster.Number).Psionic Then
          Outpt=Outpt+" with psionics" ' append psionic attack message
       Endif ' end compare monster using psionics
       Outpt=Outpt+"!" ' append exclamation
       Call IO.O ' send attack message
    Endif ' end compare monster using spell
 Endif ' end compare monster attacking
 If UserRecord.Invisible Then ' check player is invisible
    Outpt="Your invisibility protects you!" ' make message
    Call IO.O ' send invisible message
    Calculate#=False ' return value for live player
    Exit Sub ' exit routine
 Endif ' end compare invisible player
 If Vehicle2 Then ' check if player is using a vehicle
    If Rnd>.75 Then ' random chance vehicle is hit
       Call Read.Record(TreasureFile,Vehicle3) ' get vehicle treasure record
       Inpt=TreasureRecord.ShortName ' store vehicle name
       Inpt=Rtrim$(Inpt) ' trim name
       Inpt=Lcase$(Inpt) ' lowercase name
       Outpt=Prefix1+Outpts+" hits your "+Inpt+" for"+Str$(Calculate#)+" hits!"
       Call IO.O ' send message of hits on vehicle
       Vehicle2=Vehicle2-Calculate# ' decrement vehicle hits
       RoomRecord.TreCharges(Vehicle1)=Vehicle2 ' put vehicle in room
       If Vehicle2<=False Then ' compare remaining vehicle hits
          RoomRecord.Treasure(Vehicle1)=Vehicle3 ' put vehicle in room
          RoomRecord.TreCharges(Vehicle1)=False ' put vehicle in room
          Vehicle1=False ' remove vehicle from player
          Vehicle2=False ' remove vehicle from player
          Vehicle3=False ' remove vehicle from player
          Outpt=Prefix1+Outpts+" damaged your "+Inpt+"!" ' make message
          Call IO.O ' send vehicle message
       Endif ' end compare vehicle hits
    Endif ' end random chance to hit vehicle
    Calculate#=False ' return value for live player
    Call Share.Room.Record(RoomFile,Room) ' write room record
    Exit Sub ' exit routine
 Endif ' end check player using vehicle
 Outpt=Prefix1+Outpts+" hits you for"
 Call Hit.Player(Calculate#) ' routine to decrement hits on player statistics
 If UserRecord.Vitality=False Then ' check player vitality remaining
    Calculate#=True ' set player died flag
    Exit Sub ' exit routine
 Endif ' end check player died
 Calculate#=False ' return value for live player
 If Weapon5 Then ' check player holding shield
    ' store shield strikes remaining
    Charges.Number=UserRecord.Charges(Weapon5)
    If Charges.Number>False Then ' check shield strikes
       Charges.Number=Charges.Number-1 ' decrement shield strikes
    Endif ' end check shield strikes
    ' store shield strikes in user record
    UserRecord.Charges(Weapon5)=Charges.Number
    If Charges.Number=False Then ' compare shield charges
       ' get shield treasure record
       Call Read.Record(TreasureFile,UserRecord.Inv(Weapon5))
       Inpt=TreasureRecord.ShortName ' store treasure name
       Inpt=Rtrim$(Inpt) ' trim name
       Inpt=Lcase$(Inpt) ' lowercase name
       Outpt="Your "+Inpt+" breaks in half!" ' make message
       Call IO.O ' send weapon message
       Call Discard.Inventory(Weapon5,False) ' shield falls to ground
    Endif ' end compare remaining shield charges
 Endif ' end check player holding shield
 If Weapon4 Then ' check player is holding a armor
    Charges.Number=UserRecord.Charges(Weapon4) ' store armor strikes remaining
    If Charges.Number>False Then ' compare armor strikes
       Charges.Number=Charges.Number-1 ' decrement armor strikes
    Endif ' end compare armor strikes
    ' store armor strikes in user record
    UserRecord.Charges(Weapon4)=Charges.Number
    If Charges.Number=False Then ' check armor strikes remaining
       ' get treasure armor record
       Call Read.Record(TreasureFile,UserRecord.Inv(Weapon4))
       Inpt=TreasureRecord.ShortName ' store treasure name
       Inpt=Rtrim$(Inpt) ' trim name
       Inpt=Lcase$(Inpt) ' lowercase name
       Outpt="Your "+Inpt+" crumbles!" ' make message
       Call IO.O ' send armor message
       Call Discard.Inventory(Weapon4,False) ' falls to ground
    Endif ' end compare remaining armor charges
 Endif ' end check player holding armor
End Sub ' end routine to get hits on player

 Rem * routine to decrement hits on player from fatigue and vitality.
 Rem * input variables:
 Rem *   Hit.Points - hits to subtract, positive from fatigue,
 Rem *   negative from vitality.

Sub Hit.Player(Hit.Points#)
 On Local Error Resume Next ' local error resume
 If Hit.Points#>False Then ' check decrement from fatigue
    If UserRecord.Fatigue-Hit.Points#>=False Then ' compare the decrement
       ' subtract from fatigue
       UserRecord.Fatigue=UserRecord.Fatigue-Hit.Points#
       Outpt=Outpt+Str$(Hit.Points#)+" fatigue points!" ' make message
       Call IO.O ' send hits message
       Exit Sub ' exit routine
    Endif ' end compare the decrement
    ' get the difference from hits on fatigue
    Hit.Points#=Hit.Points#-UserRecord.Fatigue
    If UserRecord.Fatigue>False Then ' compare hits to fatigue remaining
       Outpt=Outpt+Str$(UserRecord.Fatigue)+" fatigue and" ' make message
    Endif ' end compare fatigue message, remaining difference hits vitlaity
    UserRecord.Fatigue=False ' reset player fatigue to zero
 Endif ' end decrement from fatigue
 Hit.Points#=Abs(Hit.Points#) ' convert hits on vitality to positive integer
 If Hit.Points#>False Then ' compare vitiality hits
    Outpt=Outpt+Str$(Hit.Points#)+" vitality points!" ' make message
    Call IO.O ' send hits message
    If UserRecord.Vitality-Hit.Points#<=False Then ' compare the decrement
       UserRecord.Vitality=False ' reset vitality
       Message1="You were just killed!" ' make died routine message
       Call Player.Died ' routine for dead player
       Exit Sub ' exit routine
    Endif ' end compare vitality decrement
    ' decrement player vitality
    UserRecord.Vitality=UserRecord.Vitality-Hit.Points#
 Endif ' end compare vitality hits
End Sub ' end routine to decrement hits on player

 Rem * routine to fumble weapon and shield from player to ground.

Sub Fumble
 On Local Error Resume Next ' local error resume
 If Weapon5 Or Weapon6 Then ' check if holding weapon or shield
    Outpt="You fumbled! " ' make first message
    Inpt="You dropped your " ' make second part of message
    Graphics.Off=True ' reset color
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' send first fumble message
    If Weapon5 Then ' check shield being held
       ' get shield treasure record
       Call Read.Record(TreasureFile,UserRecord.Inv(Weapon5))
       Treasure.Name$=TreasureRecord.ShortName ' get treasure name
       Treasure.Name$=Rtrim$(Treasure.Name$) ' trim name
       Treasure.Name$=Lcase$(Treasure.Name$) ' lowercase name
       Call Discard.Inventory(Weapon5,False) ' falls to ground
       If Weapon6 Then ' check weapon also being held
          Outpt=" and "+Treasure.Name$ ' make next part of message
       Else ' check weapon
          Outpt=Inpt+Treasure.Name$+"!" ' make message for shield only
       Endif ' end check weapon being held
    Endif ' end check shield held
    If Weapon6 Then ' check weapon being held
       ' get weapon treasure record
       Call Read.Record(TreasureFile,UserRecord.Inv(Weapon6))
       Treasure.Name$=TreasureRecord.ShortName ' get treasure name
       Treasure.Name$=Rtrim$(Treasure.Name$) ' trim name
       Treasure.Name$=Lcase$(Treasure.Name$) ' lowercase name
       Outpt=Inpt+Treasure.Name$+Outpt+"!" ' make last part of message
       Call Discard.Inventory(Weapon6,False) ' falls to ground
    Endif ' end check weapon held
    Call IO.O ' send fumble message
    Graphics.Off=False ' reset color
 Endif
End Sub ' end routine to fumble weapon and shield

 Rem * routine to get permanent monster encounters in a room.
 Rem * input variables:
 Rem *   Room - number of room player is currently in.

Sub Encounter.Permanent
 On Local Error Resume Next ' local error resume
 ' loop through all nonplayer records
 For Monster.Index=1 To Lof(NonPlayerFile)/Len(MonsterRecord)
    Call Read.Record(NonPlayerFile,Monster.Index) ' get nonplayer record
    ' store nonplayer room
    Monster.Rooms$=","+Rtrim$(MonsterRecord.PluralName)+","
    Player.Room$=","+Mid$(Str$(Room),2)+"," ' store current room
    ' verify nonplayer in current room
    If Instr(Monster.Rooms$,Player.Room$) Then
       If Number.Monsters<20 Then ' check maximum monsters in room
          Number.Monsters=Number.Monsters+1 ' increment monsters in room
          MonsterIndex(Number.Monsters)=Monster.Index ' store nonplayer index
          MonsterArray(Number.Monsters)=MonsterRecord ' store nonplayer record
          MonsterArray(Number.Monsters).Magic=True ' set magical monster
          MonsterArray(Number.Monsters).Permanent=-2 ' set nonplayer flag
       Endif ' end check maximum monsters
    Endif ' end verify current room
 Next ' end loop through nonplayer records
 If RoomRecord.MonsterClass Then ' check room monster class number
    For Monsters=1 To 10 ' loop through room monsterclass monsters
       ' get monster number
       Choice=Monster.Class(RoomRecord.MonsterClass,Monsters)
       If Choice>False And _
       Choice<=Lof(MonsterFile)/Len(MonsterRecord) Then ' bounds
          Call Read.Record(MonsterFile,Choice) ' get monster record
          If MonsterRecord.Permanent=True Then ' check if monster permanent
             Number.Appearing=1 ' set number of monsters to appear to one
             Call Get.Monster.Stats ' get the monster
          Endif ' end check permanent monster
       Endif ' end check file bounds
    Next ' end loop through room monsterclass
 Endif ' end check room monster class number
End Sub ' end routine to get permanent monsters

 Rem * routine to get one monster.
 Rem * input variables:
 Rem *   Parsed.Command1 - name or number of monster.
 Rem * working variables:
 Rem *   Choice - is the monster number.

Sub Summon.Monster
 On Local Error Resume Next ' local error resume
 If Room=1! Then ' check player in safe room
    Outpt="This is a safe haven!" ' display message
    Call IO.O ' send message
    Exit Sub ' exit routine for safe room
 Endif ' end check player in safe room
 Choice=False ' reset monster number
 Inpt=Parsed.Command1 ' store command parameter
 Call Parse.Num(Inpt,Parse.Value) ' parse number
 Parse.Count=False ' reset monster found counter
 For Monster.Index=1 To Lof(MonsterFile)/Len(MonsterRecord) 'loop through file
    Call Read.Record(MonsterFile,Monster.Index) ' get monster record
    ' compare monster record name to input monster name,
    ' truncated to input length
    If Left$(MonsterRecord.MonsterName,Len(Inpt))=Inpt Then ' compare
       Parse.Count=Parse.Count+1 ' increment monster found counter
       ' compare parsed number of monster to search for
       If Parse.Value=False Or Parse.Count=Parse.Value Then ' compare
          Exit For ' exit routine
       Endif ' end compare counters
    Endif ' end compare monster names
 Next ' end loop through monster file
 If Parse.Count=False Then ' check monster found
    Monster.Index=Int(Val(Inpt)+.5) ' convert input to integer
    ' file bounds
    If Monster.Index>False And _
    Monster.Index<=Lof(MonsterFile)/Len(MonsterRecord) Then
       Choice=Monster.Index ' store monster number
    Endif ' end check file bounds
 Else ' check file bounds
    Choice=Monster.Index ' store monster number
 Endif  ' end check file bounds
 If Choice>False Then ' check monster number found
    Call Get.Monster ' get the monster
 Endif ' end check monster number found
End Sub ' end routine to get a monster

 Rem * routine to get a random monster.
 Rem * processing variables:
 Rem *   Choice - is the monster number.

Sub Call.Monster
 On Local Error Resume Next ' local error resume
 If Room=1! Then ' check player in safe room
    Outpt="This is a safe haven!" ' display message
    Call IO.O ' send message
    Exit Sub ' exit routine for safe room
 Endif ' end check player in safe room
 Monster.Class=RoomRecord.MonsterClass ' store room monster class
 ' check monster class bounds
 If Monster.Class>False And Monster.Class<=Monclass.Max Then
    ' calculate a random monster from the room monsterclass
    Choice=Monster.Class(Monster.Class,Int(Rnd*10+1)) ' random
    Call Get.Monster ' get the monster
 Endif ' end check monsterclass bounds
End Sub ' end routine to get a random monster

 Rem * routine to get a random monster from the room monster class, computed
 Rem * from the monster encounter round rate counter, and the monster
 Rem * percentage.
 Rem * input variables:
 Rem *   Room - number of the current room.
 Rem *   Monster.Rate1 - counter of rounds from file.
 Rem *   Monster.Rate2 - counter of rounds for monster rate.

Sub Encounter.Monster
 On Local Error Resume Next ' local error resume
 If Room=1! Then ' check safe room
    Exit Sub ' exit routine
 Endif ' end check safe room
 Monster.Class=RoomRecord.MonsterClass ' store room monster class
 ' check monster class bounds
 If Monster.Class>False And Monster.Class<=Monclass.Max Then
    If Monster.Rate1=MaxInt Then ' check rate counter maximum integer
       Monster.Rate1=1 ' reset rate counter
    Else ' check rate
       Monster.Rate1=Monster.Rate1+1 ' increment rate
    Endif ' end check room monster counter rate
    For Monsters=1 To 10 ' loop through monsters with specified percentages
       If Monster.Rate(Monster.Class,Monsters) Then ' check monster rate
          ' verify monster rate equals room rate
          If Monster.Rate1/Monster.Rate(Monster.Class,Monsters)= _
          Int(Monster.Rate1/Monster.Rate(Monster.Class,Monsters)) Then
             ' verify random monster rate percentage
             If Rnd<(Monster.Percent(Monster.Class,Monsters)/100) Then ' verify
                ' store monster number
                Choice=Monster.Class(Monster.Class,Monsters)
                Call Get.Monster ' get the monster
             Endif ' end verify random rate
          Endif ' end verify monster rate percent
       Endif ' end check monster rate
    Next ' end loop through monster percentages
    Monster.Rate2=Monster.Rate2+1 ' increment monster rate for room
    If Monster.Rate2>=Room.Monster.Rate Then ' check monster rate
       Monster.Rate2=False ' reset monster rate
       Choice=Monster.Class(Monster.Class,Int(Rnd*10+1)) ' get random monster
       If MonsterRecord.Rate=False Then ' verify monster has specific rate
          If Rnd<.5 Then ' random chance for encounter
             Call Get.Monster ' get the monster
          Endif ' end random chance
       Endif ' end verify monster specific rate
    Endif ' end monster rate
 Endif ' end check room has monster class
End Sub ' end routine to random monster from rates and percentages

 Rem * routine to get monsters.
 Rem * input variables:
 Rem *   Choice - the number of the monster record.
 Rem * processing variables:
 Rem *   Number.Appearing - number of monsters to encounter.

Sub Get.Monster
 On Local Error Resume Next ' local error resume
 If Choice>False And _
 Choice<=Lof(MonsterFile)/Len(MonsterRecord) Then ' file bounds
    Call Read.Record(MonsterFile,Choice) ' get the monster record
    If MonsterRecord.Permanent=False Then ' verify monster not permanent
       ' calculate random number of monsters to encounter
       Number.Appearing=Int(Rnd*MonsterRecord.NumberAppearing)+1 ' calculate
       While Number.Appearing+Number.Monsters>20 ' loop to compare maximum
          Number.Appearing=Number.Appearing-1 ' monsters in room, decrementing
       Wend ' number appearing while room maximum is not exceeded
       Select Case Number.Appearing ' selection of number encountered
       Case 0 ' number appearing is greater than room can hold
          Exit Sub ' exit routine
       Case 1 ' format message for one monster
          ' compare monster name starting with a vowel
          If Instr("aeiou",Left$(MonsterRecord.MonsterName,1)) Then
             Outpt="an " ' format prefix to monster name
          Else ' check vowel
             Outpt="a " ' format prefix to monster name
          Endif ' end compare monster name
          Outpt=" "+Outpt+Rtrim$(MonsterRecord.MonsterName)
       Case Else ' format message for many monsters
          Outpt=Str$(Number.Appearing)+" "+Rtrim$(MonsterRecord.PluralName)
       End Select ' end selection of monsters appearing
       Outpt="You encounter"+Outpt+"!" ' make message
       Call IO.O ' send encounter message
       Call Get.Monster.Stats ' add the monster to the arrays
    Endif ' end verify not permanent
 Endif ' end check file bounds
End Sub ' end routine to get monsters

 Rem * routine to store monster statistics for encountered monster number.
 Rem * input variables:
 Rem *   Choice - is the monster number to the monster file.
 Rem *   Number.Appearing - the number of monsters of type choice to encounter.

Sub Get.Monster.Stats
 On Local Error Resume Next ' local error resume
 If Number.Monsters>=20 Then ' check room is full of monsters
    Exit Sub ' exit routine
 Endif ' end check room full
 For Monsters=1 To Number.Appearing ' loop through all number appearing
    If Number.Monsters<20 Then ' check room full of monsters
       Number.Monsters=Number.Monsters+1 ' increment the number of monsters
       MonsterIndex(Number.Monsters)=Choice ' store the monster record choice
       MonsterArray(Number.Monsters)=MonsterRecord ' store the monster record
       If MonsterArray(Number.Monsters).Psionic Then ' verify psionic monster
          ' get monster psionic spell number
          Spell.Number=MonsterArray(Number.Monsters).PsionicSpell
          MonsterArray(Number.Monsters).Psionic=False ' spell from array and
          If Spell.Number>False And _
          Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then ' reset with
             ' psionic spell number from spell file
             Call Read.Record(SpellFile,Spell.Number)
             If SpellRecord.Psionic Then ' check spell record is psionic
                If SpellRecord.PsionicMode=1 Then ' check psionic is offense
                   ' store the psionic spell level in the monster array
                   MonsterArray(Number.Monsters).Psionic=SpellRecord.Level
                Endif ' end check spell psionic type
             Endif ' end check spell is psionic
          Endif ' end check spell file bounds
       Endif ' end check monster is psionic
       If MonsterArray(Number.Monsters).Permanent=False Then ' check permanent
          For Treasure.Index=1 To 5 ' loop through all monster inventory
             If Rnd>.75 Then ' random chance
                ' clear monster treasure element
                MonsterArray(Number.Monsters).Treasure(Treasure.Index)=False
             Endif ' end random chance
          Next ' end loop through monster inventory
       Endif ' end check nonpermanent monster
    Endif ' end check maximum room monsters
 Next ' end loop through number appearing of monster type choice
 Action.Number=RoomRecord.Action ' store room action number
 ' check file bounds
 If Action.Number>False And _
 Action.Number<=Lof(ActionFile)/Len(ActionRecord) Then
    Call Read.Record(ActionFile,Action.Number) ' read action record
    ' check room action to monster choice
    If ActionRecord.MonsterTrigger=Choice Then
       ' check room action not talk activated
       If ActionRecord.MonsterTalk=False Then
          Action1$="As you step forward," ' make action message one
          Action2$="The monster hits you for" ' make action message two
          ' routine to activate actions by specific trigger
          Call Actions(Action1$,Action2$)
       Endif ' end check room action
    Endif ' end check room has monster trigger
 Endif ' end check file bounds
End Sub ' end routine to store encountered monster statistics

 Rem * routine for dead player.

Sub Player.Died
 On Local Error Resume Next ' local error resume
 UserRecord.Poison=False ' reset player poisoned
 Vehicle2=False ' reset vehicle
 Vehicle3=False ' reset vehicle
 Weapon1=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon2=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon3=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon4=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon5=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon6=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon7=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon8=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon9=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon10=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon11=False ' reset weapons, shield, armor, and rings being held/worn
 UserRecord.MonstersKilled=False ' reset user score
 If Normal.User=False Then ' check player is Asst. DM or DM or Sysop
    Outpt=Message1 ' copy death message
    Call IO.O ' send death message
    Outpt="You were resurrected!" ' make message
    Call IO.O ' send message
    Call Read.Room.Record(1!) ' get room record #1
    Resurrection.Room=RoomRecord.MonsterClass ' get resurrection room number
    Next.Room=Csng(Resurrection.Room) ' reset room number
    If Next.Room=0! Then ' check room number
       Next.Room=1! ' reset room
    Endif ' end check room number
    Number.Monsters=False ' reset number of monsters in room
    Call Enter.Room ' send player to room one
    Exit Sub ' exit routine
 Endif ' end compare normal user type
 ' rest of death routine for normal users
 Stat.Amount=UserRecord.Stats(5) ' store player constitution
 If Stat.Amount>1 Then ' check constitution positive
    UserRecord.Stats(5)=Stat.Amount-1 ' store decremented player constitution
 Endif ' end check constitution
 Stat.Amount=UserRecord.Stats(6) ' store player piety
 If Stat.Amount>1 Then ' check piety positive
    UserRecord.Stats(6)=Stat.Amount-1 ' store player decremented piety
 Endif ' end check piety
 If Rnd>.5 Then ' random chance for statistic decrement
    Stat.Number=Int(Rnd*4+1) ' choose random statistic to decrement
    Stat.Amount=UserRecord.Stats(Stat.Number) ' store random statistic
    If Stat.Amount>1 Then ' compare to positive value
       ' store player decremented statistic
       UserRecord.Stats(Stat.Number)=Stat.Amount-1
    Endif ' end compare value
 Endif ' end random chance
 Number.Monsters=False ' reset room monsters
 UserRecord.Poison=False ' reset player poisoned flag
 Weight=False ' reset player inventory weight
 For Array.Index=1 To 20 ' loop through player inventory
    Charges.Number=UserRecord.Charges(Array.Index) ' store inventory charges
    Index.Number=UserRecord.Inv(Array.Index) ' store inventory number
    If Index.Number Then ' verify inventory
       ' falls to ground
       Call Add.Room.Treasure(Index.Number,Charges.Number,False,Item.Added)
       If Item.Added=False Then ' return variable for full room
          Exit For ' exit inventory loop
       Endif ' end check return variable
    Endif ' end check inventory
 Next ' end loop through player inventory
 For Array.Index=1 To 20 ' loop through player inventory
    UserRecord.Inv(Array.Index)=False ' set inventory to zero
    UserRecord.Charges(Array.Index)=False ' set inventory to zero
 Next ' end loop through inventory
 Call Read.Room.Record(1!) ' get room record #1
 Resurrection.Room=RoomRecord.MonsterClass ' get resurrection room number
 Next.Room=Csng(Resurrection.Room) ' reset room number
 If Next.Room=0! Then ' check room number
    Next.Room=1! ' reset room
 Endif ' end check room number
 Room=Next.Room ' reset user room
 Outpt=Message1 ' copy death message
 Call IO.O ' send death message
 ' calculate player constitution roll
 Level=UserRecord.Level ' store user level
 Calculate#=(Int(Rnd*10+10)+UserRecord.Stats(5))>20 ' calculate
 If Calculate#=False Then ' compare constitution roll
    Outpt="Constitution roll failed!" ' make message
    Call IO.O ' send fail message
    Outpt="You were not resurrected!" ' make message
    Call IO.O ' send fail message
    Level=Int(Level/2-.5) ' player loses half levels
 Else ' end compare constitution roll
    ' player survives constitution roll
    Outpt="You were resurrected!" ' make message
    Call IO.O ' send message
    If UserRecord.Stats(6)<=1 Then ' compare piety
       Outpt="Except your piety failed!" ' player loses roll anyway
       Call IO.O ' send fail message
       Level=Int(Level/2-.5) ' player loses half levels
    Else ' compare piety
       Level=Level-1 ' decrement player level by one
    Endif ' end compare piety
 Endif ' end compare constitution roll
 If Level<False Then ' compare level
    Level=False ' reset level
 Endif ' end compare level
 UserRecord.Level=Level ' store user level
 Call More.Prompt ' pause for next screen
 Call Enter.Room ' routine to move player to room number
 Call Zero.Stats ' routine to clear player statistics
End Sub ' end routine for dead player

 Rem * routine to clear player statistics for death.

Sub Zero.Stats
 On Local Error Resume Next ' local error resume
 Call Experience(Calculate#) ' calculate new experience
 Calculate#=Calculate#-Int(Calculate#/10) ' calculate decremented experience
 If Calculate#<UserRecord.Experience Then ' compare new experience
    UserRecord.Experience=Calculate# ' reset experience
 Endif ' end compare new experience
 Call Gold(Calculate#) ' calculate new gold
 Calculate#=Calculate#-Int(Calculate#/10) ' calculate decremented gold
 If Calculate#<UserRecord.Gold Then ' compare new gold
    UserRecord.Gold=Calculate# ' reset player gold
 Endif ' end compare new gold
 Call New.Stats ' get new statistics for level
 UserRecord.Flags=UserRecord.Flags And Not Wished ' clear player flags
 UserRecord.Flags=UserRecord.Flags And Not Rerolled ' clear player flags
 UserRecord.Flags=UserRecord.Flags And Not Alignmented ' clear player flags
 For Stats=1 To 7 ' loop through player statistics
    If UserRecord.Stats(Stats)<=False Then ' compare statistcis to zero
       UserRecord.Stats(Stats)=1 ' reset statistic
    Endif ' end compare player statistics
 Next ' end loop through player statistics
 Call Put.User.Record ' store player record
End Sub ' end routine to clear dead player

 Rem * routine for player to learn a spell chant.
 Rem * processing variables:
 Rem *   Learned.Spells - array of 0s and 1s of learned spells.
 Rem * input variables:
 Rem *   Parsed.Command1 - contains name of spell to learn.

Sub Learn.Spell
 On Local Error Resume Next ' local error resume
 Spell.Found=False ' flag for spell name found
 For Spell.Number=1 To Lof(SpellFile)/Len(SpellRecord) ' loop through spells
    Call Read.Record(SpellFile,Spell.Number) ' get next spell record
    ' compare spell name with command parameter
    If Rtrim$(SpellRecord.SpellName)=Lcase$(Parsed.Command1) Then ' compare
       Spell.Found=True ' set spell flag found
       Exit For ' exit spell file loop
    Endif ' end compare spell names
 Next ' end loop through spell file
 If Spell.Found=False Then ' compare spell flag
    Outpt="You can't learn that spell!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end compare spell flag
 If Spell.Number>1024 Then ' compare spell maximum
    Outpt="You can't learn that spell!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end compare spell flag
 Outpt="Enter chant to learn: " ' format input prompt
 Call IO.I ' get input spell chant
 Inpt=Ucase$(Inpt) ' uppercase spell chant input
 If Rtrim$(SpellRecord.Chant)<>Inpt Then ' compare spell chant entered
    Outpt="Wrong spell chant!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end compare spell chants
 ' check length of learned spell flags
 If Spell.Number>Len(Learned.Spells) Then
    ' append 0s to learned spells
    Learned.Spells=Learned.Spells+String$(Spell.Number-Len(Learned.Spells),"0")
 Endif ' end check length of learned spells flags
 Mid$(Learned.Spells,Spell.Number,1)="1" ' set flag for spell learned
 Outpt="You now memorize the spell!" ' make message
 Call IO.O ' send spell message
End Sub ' end routine to learn spell

 Rem * routine for preprocessing spell casting.
 Rem * input variables:
 Rem *   Require.Chant - set to true if entering the spell chant is required.
 Rem * output variables:
 Rem *   Spell.Cast.Type - set to 1=use command, 2=scroll used, 4=cast command.
 Rem *   Spell.Number - number of the spell being used.
 Rem *   Spell.Chant - true if spell being used w/o chant.

Sub Cast.Spell(Require.Chant)
 On Local Error Resume Next ' local error resume
 If Weapon6 Then ' check player is holding a weapon
    Outpt="You must return your weapon first!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check weapon held
 Spell.Cast.Type=False ' reset casting variables
 Spell.Number=False ' reset casting variables
 Spell.Chant=False ' reset casting variables
 If Require.Chant Then ' check if chant required
    If UserRecord.Magic=False Then ' verify spell points remaining
       Outpt="You have no more spell points!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify spell points
    Outpt="Chant? " ' format input prompt
    Call IO.I ' get player input
    Inpt=Ucase$(Inpt) ' uppercase input
    Chant.Found=False ' set spell chant found flag
    ' loop through all spell records
    For Spell.Number=1 To Lof(SpellFile)/Len(SpellRecord)
       Call Read.Record(SpellFile,Spell.Number) ' get spell record
       Spell.Chant$=SpellRecord.Chant ' store spell chant
       Spell.Chant$=Rtrim$(Spell.Chant$) ' trim chant
       Spell.Chant$=Ucase$(Spell.Chant$) ' uppercase chant
       If Spell.Chant$=Inpt Then ' compare chants
          If SpellRecord.Psionic=False Then ' check for psionic spell
             Chant.Found=True ' set spell chant found flag
             Exit For ' exit spell file loop
          Endif ' end check psionic spell
       Endif ' end compare chants
       Spell.Chant$=SpellRecord.SpellName ' store spell name
       Spell.Chant$=Rtrim$(Spell.Chant$) ' trim name
       Spell.Chant$=Ucase$(Spell.Chant$) ' uppercase name
       If Spell.Chant$=Inpt Then ' compare spell names
          If SpellRecord.Psionic=False Then ' check for psionic spell
             ' check learned spells bounds
             If Spell.Number>1024 Then ' compare spell maximum
                Exit For ' exit spell file loop
             Endif ' end compare spell maximum
             If Spell.Number<=Len(Learned.Spells) Then
                ' check learned flag
                If Mid$(Learned.Spells,Spell.Number,1)="1" Then
                   Chant.Found=True ' set spell chant found flag
                   Exit For ' exit spell file loop
                Endif ' end check learned flag
             Endif ' end check bounds
          Endif ' end check for psionic spell
       Endif ' end compare spell names
    Next ' end loop through spell file
    If Chant.Found=False Then ' check spell chant found flag
       Outpt="Wrong spell chant!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check spell chant flag
    Spell.Cast.Type=Cast.Spell.Type ' store spell type being used
 Else ' compare chant required
    Call Find.Inventory ' check magic device being used
    If Index.Number=False Then ' verify device used
       Outpt="You can't use that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify device
    If TreasureRecord.Potion Then ' check device type
       Outpt="You can't use that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check device type
    If TreasureRecord.Edible Then ' check device type
       Outpt="You can't use that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check device
    If TreasureRecord.Scroll Then ' check device type
       Outpt="The scroll disintegrated!" ' make message
       Call IO.O ' send message
       Call Discard.Inventory(Array.Number,True) ' remove item from inventory
       Spell.Cast.Type=Scroll.Spell.Type ' store spell type being used
    Else ' check device type
       If TreasureRecord.Spell=False Then ' check device type spell type
          Outpt="That's not a magical device!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check device/spell type
       If UserRecord.Charges(Array.Number)=False Then ' compare spell charges
          Outpt="You can't, it's empty!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check spell charges
       Charges.Number=UserRecord.Charges(Array.Number) ' store spell charges
       Charges.Number=Charges.Number-1 ' decrement charges
       If Charges.Number<False Then ' compare zero
          Charges.Number=False ' set to zero
       Endif ' end compare zero
       UserRecord.Charges(Array.Number)=Charges.Number ' store spell charges
       Spell.Cast.Type=Use.Spell.Type ' store spell type being used
    Endif ' end compare device type
    Spell.Number=TreasureRecord.Spell ' store spell type
    Spell.Chant=True ' no chant required flag
 Endif ' end compare chant required
 Call Read.Record(SpellFile,Spell.Number) ' get the spell record being used
 Magic.Spell=SpellRecord.SpellType ' store the spell type being used
 Multiplier=SpellRecord.Level ' store the spell level
 Index.Number=False ' reset target variable
 If Parser Then ' check for second command parameter
    Parsed.Command1=Parsed.Command2 ' store second parameter
    Call Numeric ' get pound sign number
    Call Examine.Treasure ' check for treasure target
    If Index.Number=False Then ' treasure target found
       Call Num ' decrement target number
       Call Examine.Objects ' check for object target
       If Index.Number>False Then ' check object target found
          Outpt="Wrong spell target for chant" ' make message
          Call IO.O ' send message
          Exit Sub ' exit sub
       Endif ' end check object target
    Endif ' end check target
 Endif ' end check second parameter
 Call Magic(Spell.Chant) ' routine to use the magic spell
End Sub ' end spell preprocessing routine

 Rem * routine to cast a magic spell.
 Rem * input variables:
 Rem *   Magic.Spell - number of the spell type.
 Rem *   Chant.Used - true if spell being used w/o chant
 Rem *   Spell.Cast.Type - set to 1=use command, 2=scroll used, 4=cast command.
 Rem *   Spell.Number - number of the spell being used.
 Rem *   Index.Number - type of spell target.

Sub Magic(Chant.Used)
 On Local Error Resume Next ' local error resume
 Select Case Index.Number ' selection of the target type
 Case Is>False ' target is an item of treasure
    Select Case Magic.Spell ' selection of spell type for target of treasure
    Case Enchant ' enchant
       If TreasureRecord.Spell=False Then ' check treasure target spell type
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check treasure target spell type
    Case Vigor  ' vigor
       If TreasureRecord.Vehicle=False Then ' check treasure target vehicle
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check treasure target vehicle type
    Case Else ' check target type
       If Magic.Spell<>Hiding Then ' check spell type on treasure target
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check treasure target type
    End Select ' end selection of target spell type
 Case False ' target is not an item of treasure
    If Parser Then ' check target parameter flag
       Select Case Magic.Spell ' selection of spells w/ targets
       Case Offense, Poison, LevelDrain, Befuddled, TurnUndead, Intoxicate
          Index.Number=False
       Case Else ' spell w/o target
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       End Select ' end spell type selection
    Endif ' end check target parameter
 End Select ' end target selection type
 If Chant.Used=False Then ' check spell usage type
    If Multiplier>UserRecord.Level Then ' compare spell level to player level
       Outpt="You are not high enough level to cast the spell!" ' message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check spell/player levels
    If UserRecord.Magic=False Then ' check player magic points remaining
       Outpt="You have no more spell points!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check player magic points
    ' verify spell can be cast by player class type
    If (SpellRecord.ClassType And 2^UserRecord.ClassType)=False Then ' verify
       If Normal.User=True Then ' check player is Asst. DM/DM/Sysop
          Outpt="Your class can't cast that spell!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check player type
    Endif ' end verify spell type
    Charges.Number=UserRecord.Magic ' get player magic points
    ' decrement magic points by spell level
    Charges.Number=Charges.Number-Multiplier
    If Charges.Number<False Then ' check zero
       Charges.Number=False ' set to zero
    Endif ' end compare zero
    UserRecord.Magic=Charges.Number ' store player magic points remaining
 Endif ' end check spell usage type
 ' check spell ingredients.
 ' verify spell type uses ingredients
 If SpellRecord.SpellFlag And Spell.Cast.Type Then
    For Spell.Index=1 To 5 ' loop through spell ingredients
       ' get treasure ingredient number
       Ingredient.Number=SpellRecord.Ingred(Spell.Index)
       If Ingredient.Number>False And _
       Ingredient.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' bounds
          Player.Ingredient=False ' player has ingredient flag
          For Array.Index=1 To 20 ' loop through player inventory
             ' check player inventory
             If UserRecord.Inv(Array.Index)=Ingredient.Number Then
                Player.Ingredient=True ' set ingredient flag
                Exit For ' exit player inventory loop
             Endif ' end check player inventory is ingredient
          Next ' end loop through player inventory
          ' get treasure ingredient record
          Call Read.Record(TreasureFile,Ingredient.Number)
          If Player.Ingredient=False Then ' check player has ingredient flag
             Outpt="You don't have the correct spell ingredients!" ' message
             Call IO.O ' send message
             Inpt=TreasureRecord.TreasureName ' get treasure name
             Inpt=Rtrim$(Inpt) ' trim name
             Inpt=Lcase$(Inpt) ' lowercase name
             Outpt="You need "+Inpt+"!" ' make message
             Call IO.O ' send ingredient message
             Exit Sub ' exit routine
          Endif ' end check player ingredient flag
          ' check ingredient charges
          If UserRecord.Charges(Array.Index)=False Then
             Inpt=TreasureRecord.ShortName ' get treasure name
             Inpt=Rtrim$(Inpt) ' trim name
             Inpt=Lcase$(Inpt) ' lowercase name
             Outpt="The "+Inpt+" are used up!" ' make message
             Call IO.O ' send ingredient message
             Exit Sub ' exit routine
          Endif ' end check inrgedient charges
          ' decrement player ingredient charges
          UserRecord.Charges(Array.Index)=UserRecord.Charges(Array.Index)-1
       Endif ' end check file bounds
    Next ' end loop through spell ingredients
 Endif ' end verify spell requires ingredients
 Spell.Name$=SpellRecord.SpellName ' get spell name being cast
 Spell.Name$=Rtrim$(Spell.Name$) ' trim name
 Spell.Name$=Lcase$(Spell.Name$) ' lowercase name
 If Instr("aeiou",Left$(Spell.Name$,1)) Then ' check spell vowel
    Spell.Name$=" an "+Spell.Name$ ' append vowel
 Else ' check vowel
    Spell.Name$=" a "+Spell.Name$ ' append vowel
 Endif ' end check vowel spelling
 Outpt=SpellRecord.Desc ' get spell long cast description
 Outpt=Rtrim$(Outpt) ' trim description
 If Outpt=Nul Then ' check description length
    Outpt="You cast"+Spell.Name$+" spell!" ' make default cast description
 Endif ' end check description length
 Call IO.O ' send spell cast message
 Call Read.Room.Record(Room) ' get current room record
 Action.Number=RoomRecord.Action ' get room action number
 ' check file bounds
 If Action.Number>False And _
 Action.Number<=Lof(ActionFile)/Len(ActionRecord) Then
    Call Read.Record(ActionFile,Action.Number) ' read action record
    If ActionRecord.SpellTrigger=Spell.Number Then ' check for spell trigger
       Action1$="As the spell is cast," ' action message
       Action2$="You are hit for" ' action message
       Call Actions(Action1$,Action2$) ' routine for activated action
    Endif ' end check room for action triggered
 Endif ' end check file bounds
 ' check for magic traps in room
 For Array.Index=1 To 20 ' loop through room treasure
    If RoomRecord.Flags(Array.Index)=Magic.Trap Then ' check room for trap
       If RoomRecord.Treasure(Array.Index)=True Then ' check trap triggered
          If UserRecord.Stats(2)<Int(Rnd*6+10) Then ' random chance for trap
             ' hits on player for magical trap
             Calculate#=Cdbl(Int(Rnd*10+UserRecord.Level)* _
             RoomRecord.TreCharges(Array.Index))
             RoomRecord.Treasure(Array.Index)=False ' reset room trap
             RoomRecord.TreCharges(Array.Index)=False ' reset room trap
             RoomRecord.Flags(Array.Index)=False ' reset room trap
             Call Share.Room.Record(Room) ' write new room record
             Outpt="You triggered a magical trap!" ' message
             Call IO.O ' send trap message
             Outpt="The trap hit you for" ' hits message
             Call Hit.Player(Calculate#) ' routine to hit player
             Exit For ' exit room trap loop
          Endif ' end random chance
       Endif ' end trap trigger
    Endif ' end room trap
 Next ' end loop through room
 ' selections of the actual spell cast subroutines
 Select Case Magic.Spell ' select the spell type number
 Case Offense, Poison, LevelDrain, Befuddled, TurnUndead, Intoxicate
   Call Attack.Monster ' spell cast on monster target
 Case Enchant ' enchant (heal magic points)
    If Index.Number>False Then ' enchant on a target
       Call Read.Record(SpellFile,TreasureRecord.Spell) ' get target spell
       If SpellRecord.SpellType=4 Then ' compare target to wish device
          Outpt="You can't recharge that!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end compare wish item
       Calculate#=UserRecord.Charges(Array.Number) ' get charges of item
       Calculate#=Calculate#+UserRecord.Level ' calculate new item charges
       If Calculate#>MaxInt Then ' compare maximum integer
          Calculate#=MaxInt ' reduce to maximum integer
       Endif ' end compare maximum integer
       ' compare maximum treasure charges
       If Calculate#>TreasureRecord.Charges Then
          ' reduce to maximum treasure charges
          Calculate#=TreasureRecord.Charges
       Endif ' end compare charges
       UserRecord.Charges(Array.Number)=Cint(Calculate#) ' store new charges
       Outpt="You recharge it!" ' make message
       Call IO.O ' send message
    Else ' compare enchant on a target
       ' calculate player enchant
       Calculate#=UserRecord.Magic+UserRecord.Level+Multiplier ' calculate
       If Calculate#>MaxInt Then ' compare maximum integer
          Calculate#=MaxInt ' set to maximum integer
       Endif ' end compare maximum integer
       UserRecord.Magic=Cint(Calculate#) ' store player magic points
       Call New.Stats ' update player statistics
       Outpt="You now have"+Str$(UserRecord.Magic)+" magic points!" ' message
       Call IO.O ' send message
    Endif ' end compare enchant target
 Case Bless ' bless (heal piety)
    Outpt="Nothing happened.." ' default bless message
    If UserRecord.Stats(6)<MaxStat Then ' compare player piety points
       UserRecord.Stats(6)=UserRecord.Stats(6)+1 ' increment player piety
       Outpt="You feel a magical glow about you!" ' message
    Endif ' end compare piety
    Call IO.O ' send piety message
 Case Wish ' wish
    ' compare spell cast type
    If Spell.Cast.Type=Use.Spell.Type Or Spell.Cast.Type= _
    Scroll.Spell.Type Then ' compare
       ' reset player wish flag
       UserRecord.Flags=UserRecord.Flags And Not Wished ' reset
    Endif ' end compare spell cast type
    Graphics.Off=True ' reset color
    Outpt="The Ghods thunder.." ' message
    Call IO.O ' send ghod message
    Outpt="   What do you wish for?" ' format input prompt
    Graphics.Off=False ' reset color
    Call IO.I ' get player input
    Stored.Parsed.Command2=Inpt ' store item wish name
    Parsed.Command1=Stored.Parsed.Command2 ' store item wish name
    Call Numeric ' parse out pound sign
    Inpt=Parsed.Command1 ' store parsed item wish name
    Inpt=Lcase$(Inpt) ' lowercase item
    Call Drop(False) ' routine to get item from treasure file
 Case Vigor ' vigor (heal fatigue)
    If Index.Number>False Then ' check treasure target
       Call Read.Room.Record(Room) ' get current room
       Calculate#=RoomRecord.TreCharges(Array.Number) ' get vehicle hits
       Calculate#=Calculate#+UserRecord.Level*2 ' increment vehicle hits
       If Calculate#>MaxInt Then ' compare maximum integer
          Calculate#=MaxInt ' reset to maximum integer
       Endif ' end compare maximum integer
       Vehicle.Hits=Cint(Calculate#) ' convert to integer
       ' compare maximum vehicle hits
       If Vehicle.Hits>TreasureRecord.VehicleHits Then
          ' reset to maximum vehicle hits
          Vehicle.Hits=TreasureRecord.VehicleHits
       Endif ' end compare vehicle hits
       ' store new vehicle hits
       RoomRecord.TreCharges(Array.Number)=Vehicle.Hits
       Call Share.Room.Record(Room) ' write room record
       Outpts=TreasureRecord.ShortName ' get vehicle name
       Outpts=Rtrim$(Outpts) ' trim name
       Outpts=Lcase$(Outpts) ' lowercase name
       Outpt="The "+Outpts+" now has"+Str$(Vehicle.Hits)+" hits!" ' message
       Call IO.O ' send healed vehicle message
    Else ' compare target
       ' calculate player fatigue increase
       Calculate#=UserRecord.Fatigue+UserRecord.Level+Multiplier ' calculate
       If Calculate#>MaxInt Then ' compare to max integer
          Calculate#=MaxInt ' set to max integer
       Endif ' end compare max integer
       UserRecord.Fatigue=Cint(Calculate#) ' set player fatigue to new value
       Call New.Stats ' routine to update player statistics
       Outpt="You now have"+Str$(UserRecord.Fatigue)+" fatigue points!"
       Call IO.O ' send vigor message
    Endif ' end compare target
 Case Heal ' (heal vitality)
    ' calculate player vitality increase
    Calculate#=UserRecord.Vitality+UserRecord.Level+Multiplier ' calculate
    If Calculate#>MaxInt Then ' compare to max integer
       Calculate#=MaxInt ' set to max integer
    Endif ' end compare max integer
    UserRecord.Vitality=Cint(Calculate#) ' store new vitality
    Call New.Stats ' routine to update player statistics
    Outpt="You now have"+Str$(UserRecord.Vitality)+" vitality points!"
    Call IO.O ' send new vitality message
 Case CurePoison ' cure poison
    Outpt="Nothing happened.." ' default message
    If UserRecord.Poison Then ' check player is poisoned
       UserRecord.Poison=False ' clear player poisoned flag
       Outpt="The poison disappeared!" ' message
    Endif ' end check player poisoned
    Call IO.O ' send poison message
 Case Teleport ' teleport spell
    Next.Room=SpellRecord.Teleport ' copy teleportation room ro next room
    Teleported=True ' set teleporting flag
    Call Enter.Room ' routine to move player to new room
 Case PassDoor ' open nearby doors
    Pass.Door=True ' set passdoor flag
    Outpt="You hear a click!" ' passdoor message
    Call IO.O ' send passdoor message
 Case Conjure ' call up random monster
    For Array.Index=1 To Monclass.Max ' loop through all monster classes
       ' get a random monster choice
       Choice=Monster.Class(Array.Index,Int(Rnd*10+1))
       If Choice Then ' verify choice exists
          Call Read.Record(MonsterFile,Choice) ' get monster record
          ' compare monster to player level
          If MonsterRecord.Level=UserRecord.Level Then ' compare
             Call Get.Monster ' get the monster
             Exit Sub ' exit routine
          Endif ' end compare levels
       Endif ' end verify choice
    Next ' end loop through monster classes
    Outpt="Nothing conjures.." ' default message
    Call IO.O ' send message
 Case Psionic ' psionics
    Outpt="You can't cast a psi spell!" ' error message
    Call IO.O ' send error message
 Case DetectLock ' detect hidden or invisible doors
    For Array.Index=1 To 20 ' loop through room objects
       Object.Number=RoomRecord.Object(Array.Index) ' get room object nummber
       If Object.Number>False And _
       Object.Number<=Lof(ObjectFile)/Len(ObjectRecord) Then ' file bounds
          Call Read.Record(ObjectFile,Object.Number) ' get object record
          ' compare object invisible or hidden
          If ObjectRecord.Invisible Or ObjectRecord.Hidden Then ' compare
             Outpt="You detect hidden objects here!" ' display message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare object type
       Endif ' end check file bounds
    Next ' end loop through room objects
    Outpt="You detect nothing.." ' default message
    Call IO.O ' send message
 Case DetectEvil ' determine which direction the highest class monsters are
    High.Class=False ' highest monster class so far
    Monster.Direction=False ' direction of monster class
    For Direction.Number=1 To 12 ' loop through all room directions
       Call Read.Room.Record(Room) ' get current room record
       ' get next room direction
       Next.Direction!=RoomRecord.Direct(Direction.Number)
       If Next.Direction! Then ' compare room direction
          Call Read.Room.Record(Next.Direction!) ' get next room record
          ' compare monster class higher
          If RoomRecord.MonsterClass>High.Class Then ' compare
             High.Class=RoomRecord.MonsterClass ' store higher monster class
             Monster.Direction=Direction.Number ' store direction
          Endif ' end compare monster class
       Endif ' end compare room direction
    Next ' end loop through room directions
    Call Read.Room.Record(Room) ' get current room number
    If Monster.Direction Then ' verify room direction found w/ monsters
       ' make display message with room direction
       Outpt="You detect evil going "+Rtrim$(Direction(Monster.Direction))+"!"
    Else ' verify direction
       Outpt="You detect no evil presence.." ' make display message
    Endif ' end verify room direction
    Call IO.O ' send display message
 Case DetectTrap ' find traps in room objects
    For Array.Index=1 To 20 ' loop through room objects
       Object.Number=RoomRecord.Object(Array.Index) ' get object number
       If Object.Number>False And _
       Object.Number<=Lof(ObjectFile)/Len(ObjectRecord) Then ' file bounds
          Call Read.Record(ObjectFile,Object.Number) ' get object record
          If ObjectRecord.Trap Then ' verify object is a trap
             Outpt="You detect traps here!" ' make display message
             Call IO.O ' send display message
             Exit Sub ' exit routine
          Endif ' end verify object trap
       Endif ' end check file bounds
    Next ' end loop through room objects
    Outpt="You detect nothing.." ' make default display message
    Call IO.O ' send default message
 Case SetTrap ' sets a magical trap in room
    Trap.Set=False ' room full flag
    For Treasure.Number=1 To 20 ' loop through room treasure
       ' check empty treasure in room
       If RoomRecord.Treasure(Treasure.Number)=False Then
          Trap.Set=True ' set room full flag
          Exit For ' exit loop
       Endif ' end check empty treasure
    Next ' end loop room
    If Trap.Set=False Then ' check room full flag
       Outpt="You didn't set the trap!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check room flag
    If UserRecord.Stats(2)<Int(Rnd*5+5) Then ' calculate random percent
       Outpt="You didn't set the trap!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end calculate percent
    ' calculate trap percent
    If UserRecord.Stats(2)+UserRecord.Stats(3)<Int(Rnd*10+5) Then ' calculate
       Outpt="The trap explodes in your face!" ' make display message
       Call IO.O ' send message
       Calculate#=Cdbl(Int(Rnd*10+2)*UserRecord.Level) ' get hits on player
       Outpt="The trap hit you for" ' death message
       Call Hit.Player(Calculate#) ' routine to hit player
       Exit Sub ' exit routine
    Endif ' end trap percent
    RoomRecord.Treasure(Treasure.Number)=True ' set the trap activated
    RoomRecord.TreCharges(Treasure.Number)=UserRecord.Level ' set trap level
    RoomRecord.Flags(Treasure.Number)=Magic.Trap ' set trap flag
    Call Share.Room.Record(Room) ' write room record
    Outpt="You set a magical trap!" ' make display message
    Call IO.O ' send message
 Case Hiding ' spell to hide an item in room
    Item.Hidden=False ' room full flag
    For Array.Index=1 To 20 ' loop through room treasure
       ' found empty room treasure
       If RoomRecord.Treasure(Array.Index)=False Then
          Item.Hidden=True ' set room full flag
          Exit For ' exit loop
       Endif ' end check empty treasure
    Next ' end loop through room
    If Item.Hidden=False Then ' check room full flag
       Outpt="You didn't hide the object!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check room full flag
    If UserRecord.Stats(2)<Int(Rnd*5+4) Then ' calculate random percent
       Outpt="You didn't hide the object!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end random percent
    ' remove item from player inventory
    Call Discard.Inventory(Array.Number,True)
    RoomRecord.Treasure(Array.Index)=Index.Number ' add item to room
    ' add item charges to room
    RoomRecord.TreCharges(Array.Index)=Charges.Number
    RoomRecord.Flags(Array.Index)=Magically.Hidden ' set magically hidden flag
    Call Share.Room.Record(Room) ' write room record
    Outpt="You hide the object magically!" ' make display message
    Call IO.O ' send message
 Case Search ' displays magically hidden objects in room
    Graphics.Off=True ' reset color
    Outpt="You find " ' make first string part
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' send output
    Items.Displayed=False ' items displayed counter
    Item.Displayed=False ' item displayed flag
    Outpt=Nul ' reset output string
    For Array.Index=1 To 20 ' loop through room treasure
       Inpt=Nul ' next item string
       ' check hidden flag
       If RoomRecord.Flags(Array.Index)=Magically.Hidden Then
          ' store treasure number
          Treasure.Number=RoomRecord.Treasure(Array.Index)
          If Treasure.Number>False And _
          Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' bounds
             Call Read.Record(TreasureFile,Treasure.Number) ' get treasure
             Inpt=TreasureRecord.TreasureName ' store treasure name
             Inpt=Rtrim$(Inpt)+"[inv]" ' append treasure name
          Endif ' end check file bounds
       Endif ' end check treasure magically hidden flag
       If Outpt<>Nul And Inpt<>Nul Then ' check next output item
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send item to output
          ' increment items displayed counter
          Items.Displayed=Items.Displayed+1
       Endif ' end check output item
       If Inpt<>Nul Then ' check last item output
          Item.Displayed=True ' set item displayed flag
          Outpt=Inpt+", " ' append comma
       Endif ' end check items
    Next ' end loop through room
    If Item.Displayed=False Then ' check item displayed flag
       Outpt="nothing special.." ' default display message
    Endif ' end check item flag
    If Item.Displayed And Outpt<>Nul Then ' check item flag
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, add period
       If Items.Displayed>1 Then ' check number of items displayed
          Outpt="and "+Outpt ' append to string
       Endif ' end check item number
    Endif ' end check items
    Call IO.O ' send output
    Graphics.Off=False ' reset color
 Case Invisibility ' normal player invisibility spell
    Outpt="Didn't work!" ' default display message
    Level=Int((UserRecord.Level+4)/2) ' calculate level
    If Level>False Then ' check level for invisibility
       Invisible=Level ' set invisibility counter
       UserRecord.Invisible=True ' set player record invisible flag
       Outpt="You are now invisible!" ' make display message
    Endif ' end check invisible percent
    Call IO.O ' send display message
 Case Identify ' spell to display monster stattistics
    Parsed.Command1=Last.Monster ' get parameter in monster name
    Call Check.Monster ' check monster name
    If Monster.Number=False Then ' compare monster number found
       Outpt="You are not fighting a monster now!" ' make error message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare monster number
    Graphics.Off=True ' reset color
    Call The.Or.An ' get prefix
    Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
    Outpts=Rtrim$(Outpts) ' trim name
    Outpts=Lcase$(Outpts) ' lowercase name
    Level=MonsterArray(Monster.Number).Level ' store monster level
    ' format message with monster to player level
    Outpt="You are fighting "+Prefix1+Outpts+ _
    "(level"+Str$((Level-1)*2+1)+" to"+Str$(Level*2)+")"
    Call IO.O ' send level message
    Outpt="It has"+Str$(MonsterArray(Monster.Number).Hits)+" hits."
    Call IO.O ' display message of monster hit points
    Outpt="It has"+Str$(MonsterArray(Monster.Number).Experience)+" experience."
    Call IO.O ' display message of monster experience
    Outpt="It has"+Str$(MonsterArray(Monster.Number).Gold)+" gold."
    Call IO.O ' display message of monster gold
    Spell.Number=MonsterArray(Monster.Number).Spell ' get monster spell type
    ' file bounds
    If Spell.Number>False And _
    Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
       Call Read.Record(SpellFile,Spell.Number) ' get spell record
       ' format message with spell monster can cast
       Outpt="It can cast "+Rtrim$(SpellRecord.SpellName)+" spells."
       Call IO.O ' send spell message
    Endif ' end check file bounds
    If MonsterArray(Monster.Number).Poison Then ' check poisonous monster
       Outpt="It can poison." ' make message
       Call IO.O ' send message
    Endif ' end check poisonous monster
    If MonsterArray(Monster.Number).LevelDrain Then ' check undead monster
       Outpt="It can drain levels." ' make message
       Call IO.O ' send message
    Endif ' end check undead monster
    If MonsterArray(Monster.Number).Psionic Then ' check psionic monster
       Outpt="It can cast psi spells." ' make message
       Call IO.O ' send message
    Endif ' end check psionic monster
    If MonsterArray(Monster.Number).Magic Then ' compare magical monster
       Outpt="It's magical." ' make message
       Call IO.O ' send message
    Endif ' end check magical monster
    If MonsterArray(Monster.Number).Block Then ' check monster blocks
       Outpt="It blocks exits." ' make message
       Call IO.O ' send message
    Endif ' end check monster blocks
    If MonsterArray(Monster.Number).Prevent Then ' check monster takes
       Outpt="It prevents treasure take." ' make message
       Call IO.O ' send message
    Endif ' end check monster takes
    If MonsterArray(Monster.Number).Follow Then ' check monster follows
       Outpt="It follows users." ' make message
       Call IO.O ' send message
    Endif ' end check monster follows
    If MonsterArray(Monster.Number).Jail Then ' check monster jails
       Outpt="It jails attacker." ' make message
       Call IO.O ' send message
    Endif ' end check monster jails
    If MonsterArray(Monster.Number).Teleport Then ' check monster teleports
       Outpt="It can teleport." ' make message
       Call IO.O ' send message
    Endif ' end check monster teleports
    Graphics.Off=False ' reset color
 Case Enlighten ' locates hidden objects in room
    Graphics.Off=True ' reset color
    Outpt="You see " ' make first output string
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' output first string
    Items.Displayed=False ' items displayed counter
    Item.Displayed=False ' item displayed flag
    Outpt=Nul ' reset output string
    For Array.Index=1 To 20 ' loop through room treasure
       Inpt=Nul ' reset last item string
       ' compare item hidden
       If RoomRecord.Flags(Array.Index)=Hidden.Object Then
          ' store treasure number
          Treasure.Number=RoomRecord.Treasure(Array.Index)
          If Treasure.Number>False And _
          Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' bounds
             Call Read.Record(TreasureFile,Treasure.Number) ' get treasure
             Inpt=TreasureRecord.TreasureName ' get treasure name
             Inpt=Rtrim$(Inpt)+"[inv]" ' append to name
          Endif ' end check file bounds
       Endif ' end compare hidden item
       If Outpt<>Nul And Inpt<>Nul Then ' check next item display
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send item display
          ' increment items displayed counter
          Items.Displayed=Items.Displayed+1
       Endif ' end check items
       If Inpt<>Nul Then ' check last item displayed
          Item.Displayed=True ' set item displayed flag
          Outpt=Inpt+", " ' append comma
       Endif ' end check item
    Next ' end loop through room
    If Item.Displayed=False Then ' check item displayed flag
       Outpt="nothing special.." ' make message
    Endif ' end check item display flag
    If Item.Displayed And Outpt<>Nul Then ' check items displayed
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, add period
       If Items.Displayed>1 Then ' check number of items
          Outpt="and "+Outpt ' append to string
       Endif ' end check number of items
    Endif ' end check items
    Call IO.O ' send last output string
    Graphics.Off=False ' reset color
 Case Illuminate ' searches room for magic traps
    Graphics.Off=True ' reset color
    Outpt="You see " ' set first output string
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' send first string
    Items.Displayed=False ' set items displayed counter
    Item.Displayed=False ' set item displayed flag
    Outpt=Nul ' reset first item string
    For Array.Index=1 To 20 ' loop through all room treasure
       Inpt=Nul ' set next item displayed
       ' compare treasure magic trap
       If RoomRecord.Flags(Array.Index)=Magic.Trap Then
          If RoomRecord.Treasure(Array.Index)=True Then ' check trap active
             Inpt="a magical trap " ' make display message
             ' append magic trap hits to message
             Inpt=Inpt+"["+ _
             Mid$(Str$(RoomRecord.TreCharges(Array.Index)),2)+" hits]"
          Endif ' end check active trap
       Endif ' end compare magic trap
       If Outpt<>Nul And Inpt<>Nul Then ' check next item display
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send item output
          ' increment items displayed counter
          Items.Displayed=Items.Displayed+1
       Endif ' end check next item
       If Inpt<>Nul Then ' check items
          Item.Displayed=True ' set item displayed flag
          Outpt=Inpt+", " ' append comma
       Endif ' end check items
    Next ' end loop through room
    If Item.Displayed=False Then ' compare item displayed flag
       Outpt="nothing special.." ' make display message
    Endif ' end check item displayed flag
    If Outpt<>Nul Then ' check last item
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, add period
       If Items.Displayed>1 Then ' check number of items displayed
          Outpt="and "+Outpt ' append to string
       Endif ' end check number of items
    Endif ' end check items
    Call IO.O ' send last string
    Graphics.Off=False ' reset color
 Case Psyche ' heal psionic points
    ' calculate psionic points
    Calculate#=UserRecord.Psionic+UserRecord.Level+Multiplier ' calculate
    If Calculate#>MaxInt Then ' check max integer
       Calculate#=MaxInt ' set to max integer
    Endif ' end check max integer
    UserRecord.Psionic=Cint(Calculate#) ' store players new psionic points
    Call New.Stats ' routine to update player statistics
    Outpt="You now have"+Str$(UserRecord.Psionic)+" psionic points!" ' message
    Call IO.O ' send display message
 Case Else ' any other spell type
    Outpt="You can't cast that spell!" ' make error message
    Call IO.O ' send message
 End Select ' end selection of spell type number
End Sub ' end routine to cast magic spell

 Rem * routine to use psionic spell.
 Rem * processing variables:
 Rem *   Psi.Mode.Type - psi mode 1 or 2 (attack/defense).
 Rem * output variables:
 Rem *   Psi.Attack.Mode - level of psi spell.
 Rem *   Psi.Defense.Mode - level of psi spell.

Sub Psi.Mode
 On Local Error Resume Next ' local error resume
 Select Case Lcase$(Parsed.Command1) ' selection of command parameter
 Case "attack" ' attack command
    Psi.Mode.Type=PsiAttack ' store psi attack
 Case "defense" ' defense command
    Psi.Mode.Type=PsiDefense ' store psi defense
 Case Else ' other
    Outpt="You can only use psi mode attack or defense!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 End Select ' end psi type selection
 Outpt="Psi spell? " ' format input prompt
 Call IO.I ' get input
 Inpt=Ucase$(Inpt) ' uppercase input
 Inpt=Rtrim$(Inpt) ' trim input
 Spell.Found=False ' psi spell found flag
 ' loop through all spell records
 For Spell.Number=1 To Lof(SpellFile)/Len(SpellRecord)
    Call Read.Record(SpellFile,Spell.Number) ' get spell record
    Outpt=SpellRecord.Chant ' store spell chant
    Outpt=Rtrim$(Outpt) ' trim chant
    If Outpt=Inpt Then ' compare chant to input chant
       If SpellRecord.Psionic Then ' check spell is psi spell
          Spell.Found=True ' set psi spell flag found
          Exit For ' exit spell file loop
       Endif ' end check psi spell
    Endif ' end check chants
 Next ' end spell file loop
 If Spell.Found=False Then ' check psi spell found flag
    Outpt="Unknown psi spell!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check psi spell flag
 Spell.Name$=SpellRecord.SpellName ' store psi spell name
 Spell.Name$=Rtrim$(Spell.Name$) ' trim name
 Spell.Name$=Lcase$(Spell.Name$) ' lowercase name
 If Psi.Mode.Type<>SpellRecord.PsionicMode Then ' verify psi spell mode
    Outpt="Incorrect spell for psi mode!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end verify psi spell mode
 Level=SpellRecord.Level ' store psi spell level
 If UserRecord.Psionic<=False Then ' check player psionic points remaining
    Outpt="You have no more psi points!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check player psionic points
 Charges.Number=UserRecord.Psionic ' store player psionic points remaining
 ' decrement player psionic points by level of psi spell
 Charges.Number=Charges.Number-Level
 If Charges.Number<False Then ' compare to zero
    Charges.Number=False ' reset to zero
 Endif ' end compare zero
 UserRecord.Psionic=Charges.Number ' store player psionic points remaining
 Outpt="You cast a "+Spell.Name$+" psi spell!" ' make message
 Call IO.O ' send psi spell cast message
 Select Case Psi.Mode.Type ' selection of psi spell type
 Case PsiAttack ' attack mode
    Psi.Attack.Mode=Level ' set psi attack mode to psi spell level
    Parsed.Command1=Last.Monster ' store last monster attacked
    Call Attack.Monster ' attack monster
 Case PsiDefense ' defense mode
    Psi.Defense.Mode=Level ' set psi defense mode to psi spell level
    Outpt="Your psi defense mode is now active!" ' make message
    Call IO.O ' send psi message
 End Select ' end selection of psi spell type
End Sub ' end routine to cast a psi spell

 Rem * routine to get default monster name
 Rem * output variables:
 Rem *   Monster.Found - true for the first monster
 Rem *   Monster.Number - index of monster
 Rem *   Last.Monster - name of monster

Sub Get.Last.Monster(Monster.Found)
 On Local Error Resume Next ' local error resume
 Monster.Found=False ' reset return flag
 For Array.Number=1 To Number.Monsters ' search through monsters in room
    If MonsterArray(Array.Number).Magic>=False Then ' check monster magical
       If MonsterArray(Array.Number).Permanent>=True Then ' check permanent
          Word.Parse1=False ' reset parsing flag
          Word.Parse2=False ' reset parsing flag
          Outpts=MonsterArray(Array.Number).MonsterName ' get monster name
          Outpts=Rtrim$(Outpts) ' trim name
          Outpts=Ucase$(Outpts) ' uppercase name
          Word.Parse1=Instr(Word.Parse1+1,Outpts," ") ' search for space
          While Word.Parse1 ' loop while spaces
             Word.Parse2=Word.Parse1 ' store monster name parse
             Word.Parse1=Instr(Word.Parse1+1,Outpts," ") ' check spaces
          Wend ' end loop while spaces
          Monster.Found=True ' set return flag
          Monster.Number=Array.Number ' store monster array index
          Last.Monster=Mid$(Outpts,Word.Parse2+1) ' store monster name
          Exit Sub ' exit routine
       Endif ' end check permanent monster
    Endif ' end check magic monster
 Next ' end search through room
End Sub ' end routine to get first monster name
