 Rem * Filename: dnds5.bas Version: v5.1a r1.0a
 Rem * This subprogram contains all container, bank, and some display
 Rem * and main routines.

 Rem $Include: 'dnddoor.inc'

 Rem * routine to search player and room containers for parameter name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of container.
 Rem * output variables:
 Rem *   Index.Number - true if container name found.
 Rem *   Type.Number - 0 for container in inventory, 1 for container in room.

Sub Examine.Container
 On Local Error Resume Next ' local error resume
 Type.Number=False ' store container flag
 Call Check.Inventory.Container ' search player inventory containers
 If Index.Number=False Then ' check player container found
    Call Num ' decrement counters
    Type.Number=1 ' store container flag
    Call Check.Room.Container ' search room inventory containers
 Endif ' end check player container found
End Sub ' end routine to search inventory for container name

 Rem * routine to remove an item from player inventory and add to a container.

Sub Drop.Into.Container
 On Local Error Resume Next ' local error resume
 Call Parse ' get first parameter
 Call Numeric ' parse parameter number from # sign
 Call Check.Inventory.Treasure ' search for inventory to drop
 If Index.Number=False Then ' index to treasure file not found
    Outpt="You can't drop that!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check treasure index
 Item.Number=Array.Number ' store treasure index to array
 Item.Charges=Charges.Number ' store treasure charges
 Item.Index=Index.Number ' store treasure index to file
 Parsed.Command1=Parsed.Command2 ' get second parameter
 Call Numeric ' parse parameter number from # sign
 Call Examine.Container ' check player inventory and room for container
 If Index.Number=False Then ' index to treasure file not found
    Outpt="You can't drop that!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check index
 If ContainerRec.Locked>False Then ' check container locked
    Outpt="You can't, it's locked!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check container
 If ContainerRec.Closed>False Then ' check container closed
    Outpt="You can't, it's closed!" ' message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check container
 Container.Number=Array.Number ' store index of inventory array of container
 For Array.Counter=1 To 5 ' loop through container elements
    ' find empty container element
    If ContainerRec.Inventory(Array.Counter)=False Then
       Container.Name$=ContainerRec.ContainerName ' store container name
       Container.Name$=Rtrim$(Container.Name$) ' strip trailing blanks
       If Last.Command.Number=Hide.Command Then ' last command was hide
          ' set container record hide flag
          ContainerRec.Invisible(Array.Counter)=True
       Else ' not hide
          ' set container record hide
          ContainerRec.Invisible(Array.Counter)=False
       Endif ' end check last command
       ' store container record index
       ContainerRec.Inventory(Array.Counter)=Item.Index
       ' store container record charges
       ContainerRec.Charges(Array.Counter)=Item.Charges
       ' store container treasure name mnemonic
       ContainerRec.TreasureName(Array.Counter)=TreasureRecord.ShortName
       Select Case Type.Number ' select room or inventory
       Case 1 ' drop item into container in room
          RoomRecord.Container=ContainerRec ' set room container record
          Call Share.Room.Record(Room) ' put room record
       Case 0 ' dropped item in container in player inventory
          ' update player container
          UserRecord.Container(Container.Number)=ContainerRec
       End Select ' end select container drop
       Outpts=TreasureRecord.TreasureName ' store name of treasure dropped
       Outpts=Rtrim$(Outpts) ' strip trailing blanks
       If Last.Command.Number=Hide.Command Then ' last command hide
          Inpt=" hide " ' set equal to hide
       Else ' not hide
          Inpt=" drop " ' set equal to drop
       Endif ' end check last command
       Outpt="You"+Inpt+Outpts+" in "+Container.Name$+"!" ' format message
       Call IO.O ' send output
       Call Discard.Inventory(Item.Number,True) ' remove item from inventory
       Exit Sub ' return from routine
    Endif ' end check empty container record
 Next ' loop through container records
 Outpt="You can't, it's full!" ' message
 Call IO.O ' send output
End Sub ' end drop into container routine

 Rem * routine to take an item of treasure from a container and add to
 Rem * the player inventory.

Sub Take.From.Container
 On Local Error Resume Next ' local error resume
 Call ParseX ' parse second parameter
 Call Numeric ' parse parameter number from # sign
 Call Examine.Container ' check container mnemonic
 If Index.Number=False Then ' compare treasure index
    Outpt="You can't get that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container index
 If ContainerRec.Locked>False Then ' check container locked
    Outpt="You can't, it's locked!" ' message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container locked
 If ContainerRec.Closed>False Then ' check container closed
    Outpt="You can't, it's closed!" ' message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container closed
 Container.Number=Array.Number ' store container index of player inventory
 Container.Name$=ContainerRec.ContainerName ' store container name
 Container.Name$=Rtrim$(Container.Name$) ' edit container name
 Parsed.Command1=Parsed.Command2 ' get first parameter
 Call Numeric ' parse parameter number from # sign
 Item.Counter=False ' parsed number counter
 For Array.Counter=1 To 5 ' loop through all container treasure
    ' get treasure name from container
    Inpt=Rtrim$(ContainerRec.TreasureName(Array.Counter))
    If Len(Inpt) Then ' check treasure name length
       Inpt=Left$(Inpt,Len(Parsed.Command1)) ' truncate treasure name
       If Inpt=Parsed.Command1 Then ' compare to treasure to take
          Item.Counter=Item.Counter+1 ' increment parsed counter
          ' compare to parameter number
          If Parse.Number=False Or Item.Counter=Parse.Number Then
             Index.Number=ContainerRec.Inventory(Array.Counter) ' store treasure index
             ' check treasure index range
             If Index.Number>False And Index.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then
                Call Read.Record(TreasureFile,Index.Number) ' get treasure record
                Outpts=TreasureRecord.TreasureName ' format treasure name
                Outpts=Rtrim$(Outpts) ' trim name
                ' compute weight player carrying
                New.Weight#=Cdbl(Int(Weight+TreasureRecord.Weight))
                If New.Weight#>MaxInt Then ' check maximum integer
                   New.Weight#=MaxInt ' reduce to maximum integer
                Endif ' end check maximum integer
                Total.Weight#=Cdbl(UserRecord.Stats(1)) ' store player strength
                Total.Weight#=Total.Weight#*100 ' multiply weight player can carry
                If New.Weight#>Total.Weight# Then ' compare wieght player can carry
                   Outpt="You can't carry any more!" ' weight and make message
                   Call IO.O ' send message
                   Exit Sub ' exit routine
                Endif ' end compare weight
                ' get treasure charges
                Charges.Number=ContainerRec.Charges(Array.Counter)
                ' add treasure to inventory
                Call Add.Inventory(Index.Number,Charges.Number,Item.Added)
                If Item.Added Then ' flag set to add
                   Call Clear.Container(Array.Counter,False) ' clear container item
                   Select Case Type.Number ' select room or inventory
                   Case 1 ' flag indicating container in room or inventory
                      RoomRecord.Container=ContainerRec ' set room container record
                      Call Share.Room.Record(Room) ' write room record
                   Case 0 ' flag indicates player record
                      ' update player container
                      UserRecord.Container(Container.Number)=ContainerRec
                   End Select ' end compare room or inventory
                   Outpt="You take "+Outpts+" from "+Container.Name$+"!" ' message
                   Call IO.O ' send message
                   Exit Sub ' exit routine
                Endif ' end compare add flag
             Endif ' end check treasure index
          Endif ' end compare parsed number
       Endif ' end compare treasure name
    Endif ' end check treaure name length
 Next ' end loop through player container inventory
 Outpt="You can't get that!" ' make message
 Call IO.O ' send message
End Sub ' end take from container routine

 Rem * sets container elements to zero.
 Rem * input variables:
 Rem *   Item.Number - container item to clear.
 Rem *   Clear.Items - true to clear container, false to clear container item.

Sub Clear.Container(Item.Number,Clear.Items)
 On Local Error Resume Next ' local error resume
 If Clear.Items=False Then ' passed parameter to clear one container item 
    ContainerRec.Charges(Item.Number)=False ' container element to zero
    ContainerRec.Inventory(Item.Number)=False ' container element to zero
    ContainerRec.Invisible(Item.Number)=False ' container element to zero
    ContainerRec.TreasureName(Item.Number)=Nul ' container element to zero
 Else ' passed parameter to clear entire container
    ContainerRec.Closed=False ' container to zero
    ContainerRec.ContainerName=Nul ' container to zero
    ContainerRec.Keyed=False ' container to zero
    ContainerRec.Locked=False ' container to zero
    ContainerRec.ShortName=Nul ' container to zero
    ContainerRec.Permanent=False ' container to zero
    For Container.Item=1 To 5 ' loop through all container elements
       ContainerRec.Inventory(Container.Item)=False ' reset container element
       ContainerRec.Charges(Container.Item)=False ' reset container element
       ContainerRec.Invisible(Container.Item)=False ' reset container element
       ContainerRec.TreasureName(Container.Item)=Nul ' reset container element
    Next ' end loop all container elements
 Endif ' end passed parameter
End Sub ' end routine to clear container

 Rem * routine to display container information.
 Rem * input variables:
 Rem *   ContainerRec - container record to display.
 Rem *   Type.Number - item is in room/inventory.

Sub Show.Container
 On Local Error Resume Next ' local error resume
 If Type.Number Then ' container in room
    Prefix1="It's " ' format prefix
 Else ' container in inventory
    Prefix1="You are carrying " ' format prefix
 Endif ' end container check
 Graphics.Off=True ' reset color
 Outpt=Prefix1+Rtrim$(ContainerRec.ContainerName) ' make container name
 If ContainerRec.Keyed Then ' check container has a lock number
    Outpt=Outpt+"(#"+Right$(Str$(ContainerRec.Keyed+100000!),5)+")"
 Endif ' end append container lock number
 Outpt=Outpt+"." ' append to message
 Call IO.O ' send message of container name
 If ContainerRec.Locked>False Then ' verify container is locked
    Outpt="It's locked." ' make message
    Call IO.O ' send output
    Exit Sub ' exit routine
 Endif ' end verify locked container
 If ContainerRec.Closed>False Then ' verify container is closed
    Outpt="It's closed." ' make message
    Call IO.O ' send output
    Exit Sub ' exit routine
 Endif ' end verify closed container
 Outpt="It contains the following treasure:" ' message
 Call IO.O ' send prefix message
 Container.Count=False ' reset number of container items displayed
 Outpt=Nul ' reset message of container item
 For Array.Index=1 To 5 ' loop through all container items
    ' store container invisibility flag
    Invisible.Container=ContainerRec.Invisible(Array.Index)
    ' store container inventory number
    Container.Number=ContainerRec.Inventory(Array.Index)
    Display.Item=True ' reset flag to display container item
    If Container.Number Then ' check container item
       If Invisible.Container=True Then ' verify item is invisible
          If Normal.User Then ' determine non DM
             Display.Item=False ' set flag not to display item
          Endif ' end normal user
       Endif ' end invisible item
       If Display.Item=True Then ' check flag to display item
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send message of previous item
          ' get treasure record of container item
          Call Read.Record(TreasureFile,Container.Number)
          Outpts=TreasureRecord.TreasureName ' store treasure name
          Outpts=Rtrim$(Outpts) ' trim name
          If Invisible.Container=True Then ' compare invisible item
             Outpts=Outpts+"[inv]" ' sppend invisible message
          Endif ' end compare invisible
          Outpt=Outpts+", " ' append comma to item name
          ' increment number of items displayed
          Container.Count=Container.Count+1
          If Container.Count=1 Then ' check if first item displayed
             Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first item
          Endif ' end compare to first item
       Endif ' end check display flag
    Endif ' end check container item
 Next ' end loop through all five items
 If Container.Count=False Then ' check if any container items displayed
    Outpt="Nothing at all." ' make message
 Else ' check any container items displayed
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, append period
    If Container.Count>1 Then ' more than one item displayed
       Outpt="and "+Outpt ' append to message
    Endif ' end check item number
 Endif ' end check item number
 Call IO.O ' send message of last contaier item
 Graphics.Off=False ' reset color
End Sub ' end routine to display container information

 Rem * routine to search player inventory for container name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of container to search for.
 Rem * output variables:
 Rem *   Array.Number - container number.
 Rem *   Index.Number - true if container found.
 Rem *   Outpts - name of container.
 Rem * processing variables:
 Rem *   Parse.Count - increment counter.
 Rem *   Container.Name$ - container name.

Sub Check.Inventory.Container
 On Local Error Resume Next ' local error resume
 Index.Number=False ' reset container found flag
 Parse.Count=False ' reset counter
 If Parsed.Command1<>Nul Then ' check search string length
    For Array.Number=1 To 3 ' loop through player inventory containers
       ' store container name
       Container.Name$=Rtrim$(UserRecord.Container(Array.Number).ShortName)
       Outpts=Container.Name$ ' store container name
       If Container.Name$<>Nul Then ' check length of container name
          ' trim length of container name to length of search string
          Container.Name$=Left$(Container.Name$,Len(Parsed.Command1)) ' trim
          If Container.Name$=Parsed.Command1 Then ' compare container names
             Parse.Count=Parse.Count+1 ' increment counter
             ' check increment counter not specified,
             ' or counter equals increment counter.
             If Parse.Number=False Or Parse.Count=Parse.Number Then
                Index.Number=True ' set container found flag
                ' store container record
                ContainerRec=UserRecord.Container(Array.Number) ' store
                Exit For ' exit loop through player containers
             Endif ' end check counters
          Endif ' end compare container names
       Endif ' end check container name length
    Next ' end loop through player containers
 Endif ' end check search string length
End Sub ' end routine to search player inventory for container name

 Rem * routine to compare room container to search container name
 Rem * input variables:
 Rem *   Parsed.Command1 - name of container to ccompare.
 Rem * output variables:
 Rem *   Index.Number - room container matched.
 Rem *   Outpts - name of container.
 Rem * processing variables:
 Rem *   Parse.Count - increment counter.
 Rem *   Container.Name$ - container name.

Sub Check.Room.Container
 On Local Error Resume Next ' local error resume
 Index.Number=False ' reset container found flag
 Parse.Count=False ' reset counter
 If Parsed.Command1<>Nul Then ' check search string length
    ' get room container name
    Container.Name$=Rtrim$(RoomRecord.Container.ShortName)
    Outpts=Container.Name$ ' store container name
    If Container.Name$<>Nul Then ' check length of container name
       ' trim length of container name to length of search string
       Container.Name$=Left$(Container.Name$,Len(Parsed.Command1)) ' trim
       If Container.Name$=Parsed.Command1 Then ' compare container names
          Parse.Count=Parse.Count+1
          ' check increment counter not specified,
          ' or counter equals increment counter.
          If Parse.Number=False Or Parse.Count=Parse.Number Then
             Index.Number=True ' set container match flag
             ContainerRec=RoomRecord.Container ' store container record
          Endif ' end check counters
       Endif ' end compare names
    Endif ' end check container name
 Endif ' end check search string length
End Sub

 Rem * routine to remove an item of player inventory and add to room.

Sub Drop.Item
 On Local Error Resume Next ' local error resume
 Call Find.Object ' check inventory for object by mnemonic name
 If Index.Number Then ' returns index to objects file
    If Last.Command.Number=Hide.Command Then ' compare command to hide
       Outpt="You hide "+Outpts+"!" ' format hide message
       Hide.Item=True ' set hide flag
    Else ' not hide command
       Outpt="You drop "+Outpts+"!" ' format message
       Hide.Item=False ' set hide flag
    Endif ' end compare command
    Call Add.Room.Object(Index.Number,Hide.Item,Item.Added) ' add item
    If Item.Added Then ' check object added flag
       Call Discard.Inventory.Object(Array.Number) ' remove object
    Else ' check item added to room
       Outpt="You can't drop that!" ' message
    Endif ' end check item added to room objects
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check inventory for object
 Call Num ' decrement parse temp
 Call Find.Inventory ' check inventory for treasure by mnemonic name
 If Index.Number Then ' returns index to treasure file
    If Last.Command.Number=Hide.Command Then ' compare command to hide
       Outpt="You hide "+Outpts+"!" ' format hide message
       Hide.Item=Hidden.Object ' set hide flag
    Else ' not hide command
       Outpt="You drop "+Outpts+"!" ' format message
       Hide.Item=False ' set hide flag
    Endif ' end compare command
    ' add item to room
    Call Add.Room.Treasure(Index.Number,Charges.Number,Hide.Item,Item.Added)
    If Item.Added Then ' added to room flag
       Call Discard.Inventory(Array.Number,True) ' remove from player inventory
    Else ' not added
       Outpt="You can't drop that!" ' message
    Endif ' end check room flag
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check inventory for treasure
 Call Num ' decrement parse temp
 Call Check.Inventory.Container ' check player inventory for container
 If Index.Number Then ' returns index of container to treasure
    If Last.Command.Number=Hide.Command Then ' compare to hide command
       Outpt="You can't hide that!" ' message
       Call IO.O ' send output
       Exit Sub ' return from routine
    Endif ' end compare to hide command
    If Rtrim$(RoomRecord.Container.ShortName)<>Nul Then ' room container empty
       Outpt="You can't put more than one container in a room!" ' message
       Call IO.O ' output message
       Exit Sub ' exit routine
    Endif
    If Rtrim$(RoomRecord.Container.ShortName)=Nul Then ' room container empty
       ' store room container
       RoomRecord.Container=UserRecord.Container(Array.Number)
       Call Share.Room.Record(Room) ' record structure, put room record,
       Outpts=Rtrim$(ContainerRec.ContainerName) ' message
       Call Clear.Container(0,True) ' clear player container structure
       UserRecord.Container(Array.Number)=ContainerRec ' clear container record
       Outpt="You drop "+Outpts+"!" ' format message
       Call IO.O ' send output
       Exit Sub ' return from routine
    Endif ' end compare room container
 Endif ' end check container index
 Outpt="You can't drop that!" ' message
 Call IO.O ' send output
End Sub ' end drop item routine

 Rem * routine to take an object or item of treasure from the room and
 Rem * add to the player inventory.

Sub Take.Object
 On Local Error Resume Next ' local error resume
 Call Check.Room.Objects ' find the mnemonic of object to take
 If Index.Number Then ' verify object file index
    Object.Flag=False ' reset flag
    If Normal.User=False Then ' check DM/Sysop
       Object.Flag=True ' reset flag
    Else ' end check user type
       If ObjectRecord.Permanent=False Then ' verify object permanent
          Object.Flag=True ' reset flag
       Endif ' end check object
    Endif ' end check player type
    If Object.Flag Then ' check take flag
       ' routine to add object to user
       Call Add.Object(Index.Number,Item.Added)
       If Item.Added Then ' an empty object element
          ' routine to remove item from room
          Call Discard.Room.Object(Array.Number)
          Outpt="You take "+Outpts+"!" ' format message
          Call IO.O ' display message
       Else ' check empty object found
          Outpt="You can't carry any more!" ' format message
          Call IO.O ' display message
       Endif ' end compare empty object element
       Exit Sub ' exit routine
    Endif ' end find object to take
 Endif ' end normal player
 Call Num ' decrement parse temp
 Call Check.Room.Treasure ' find mnemonic of treasure to take
 If Index.Number Then ' treasure index found in room to take
    ' calculate weight player is carrying
    New.Weight#=Cdbl(Int(Weight+TreasureRecord.Weight))
    If New.Weight#>MaxInt Then ' check maximum integer
       New.Weight#=MaxInt ' reduce to maximum integer
    Endif ' end check maximum integer
    Total.Weight#=Cdbl(UserRecord.Stats(1)) ' store player strength
    Total.Weight#=Total.Weight#*100 ' multiply to weight player can carry
    If New.Weight#>Total.Weight# Then ' compare weight player can carry
       Outpt="You can't carry any more!" ' weight ten times player strength
       Call IO.O ' format message
       Exit Sub ' exit routine
    Endif ' end compare weight
    If UserRecord.ClassType<AsstDM Then ' normal class prevented to take item
       For Array.Counter=1 To Number.Monsters ' loop through all monsters
          ' check monster can prevent
          If MonsterArray(Array.Counter).Prevent Then
             ' compute random percent
             If Rnd<(MonsterArray(Array.Counter).PreventPercent/100) Then
                Inpt=MonsterArray(Array.Counter).MonsterName ' store name
                Inpt=Rtrim$(Inpt) ' format message
                Outpt="The "+Inpt+" prevents you from getting it!"
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end compare random calculation
          Endif ' end compare monster to prevent taking item
       Next ' end loop through all monsters in room
    Endif ' end compare player class
    If TreasureRecord.Coin Then ' check item is coins
       Outpt="You take "+Outpts+"!" ' format message
       Call IO.O ' send message
       UserRecord.Gold=UserRecord.Gold+TreasureRecord.Gold ' increment gold
       Outpt="You now have"+Str$(UserRecord.Gold)+" Gold!" ' message
       Call IO.O ' send message
       Call Discard.Room.Treasure(Array.Number) ' remove item from room
       Exit Sub ' exit routine
    Endif ' end compare item if coins
    ' add room item to inventory
    Call Add.Inventory(Index.Number,Charges.Number,Item.Added)
    If Item.Added Then ' return flag indicates successful addition to inventory
       Outpt="You take "+Outpts+"!" ' format message
       Call IO.O ' send message
       Call Discard.Room.Treasure(Array.Number) ' remove item from room
    Else ' compare flag
       Outpt="You can't carry any more!" ' make message
       Call IO.O ' send message
    Endif ' end compare flag
    Exit Sub ' exit routine
 Endif ' end item is treasure in room
 Call Num ' decrement parse temp
 Call Check.Room.Container ' verify item to take is a container
 If Index.Number Then ' found container index to treasure file
    ' loop through player inventory to find empty container
    For Array.Number=1 To 3
       ' compare container name
       If Rtrim$(UserRecord.Container(Array.Number).ShortName)=Nul Then
          ' store container record
          UserRecord.Container(Array.Number)=ContainerRec
          Outpts=Rtrim$(ContainerRec.ContainerName) ' format message
          Outpt="You get "+Outpts+"!" ' make message
          Call IO.O ' send message
          Call Clear.Container(0,True) ' clear entire container record
          RoomRecord.Container=ContainerRec ' clear room container
          Call Share.Room.Record(Room) ' write room record
          Exit Sub ' exit routine
       Endif ' end compare empty container mnemonic name
    Next ' loop through inventory
    Outpt="You can't carry more than three containers!" ' message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end verify taking container
 Outpt="You can't get that!" ' message
 Call IO.O ' send message
End Sub ' end take item routine

 Rem * routine to lock an object or container.
 Rem * Note: Allows DM/Sysop to add locks.

Sub Lock.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' container index to treasure file
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked>False Then ' container lock variable is already set
       Outpt="It's already locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked=False Then ' container has no lock setting
       If Normal.User Then ' check DM/Sysop
          Outpt="You can't lock that!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Else ' check DM/Sysop
          Outpt="Container has no lock. Add one(y/n)? " ' make input prompt
          No.Input.Out="N" ' default input
          Call IO.I ' get input
          If No Then ' compare response
             Exit Sub ' exit routine
          Endif ' end compare response
          Outpt="Add a key to the lock(y/n)? " ' make message
          No.Input.Out="N" ' default input
          Call IO.I ' get input
          If Yes Then ' check response
             Outpt="Key number(1-32767)? " ' make input prompt
             No.Input.Out="1" ' default input
             Call IO.I ' get user input
             ContainerRec.Keyed=Int(Val(Inpt)+.5) ' set object key number
          Endif ' end check response
       Endif ' check DM/Sysop
    Endif ' end compare container lock
    ContainerRec.Locked=1 ' set container variable to locked
    ContainerRec.Closed=1 ' set container variable to locked
    Select Case Type.Number ' select room or inventory
    Case 1 ' container is locked in room
       RoomRecord.Container=ContainerRec
       Call Share.Room.Record(Room) ' write room record
    Case 0 ' container is locked in player inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end compare container locked
    Outpt="You lock it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.RoomLink=False Then ' check object is a portal
       Outpt="You can't lock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare object portal
    If ObjectRecord.DoorLock=2 Then ' object is already locked
       Outpt="It's already locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare object lock
    If ObjectRecord.DoorLock=False Then ' object has no lock setting
       If Normal.User Then ' check DM/Sysop
          Outpt="You can't lock that!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Else ' check DM/Sysop
          Outpt="Object has no lock. Add one(y/n)? " ' make input prompt
          No.Input.Out="N" ' default input
          Call IO.I ' get input
          If No Then ' compare response
             Exit Sub ' exit routine
          Endif ' end compare response
          Outpt="Add a key to the lock(y/n)? " ' make message
          No.Input.Out="N" ' default input
          Call IO.I ' get input
          If Yes Then ' check response
             Outpt="Key number(1-32767)? " ' make input prompt
             No.Input.Out="1" ' default input
             Call IO.I ' get user input
             ObjectRecord.Keyed=Int(Val(Inpt)+.5) ' set object key number
          Endif ' end check response
       Endif ' check DM/Sysop
    Endif ' end compare object lock
    ObjectRecord.DoorLock=2 ' set object lock variable
    ObjectRecord.Closed=True ' set object lock variable
    Call Share.Record(ObjectFile,Index.Number) ' write object record
    Outpt="You lock it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check object
 Outpt="You can't lock that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to lock an item

 Rem * routine to unlock or picklock an object or container.

Sub Unlock.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container treasure index
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no lock setting
       Outpt="You can't unlock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked<False Then ' container lock variable already set
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Keyed=False Then ' container has no key number
       ContainerRec.Locked=True ' set container lock variable
       ContainerRec.Closed=1 ' set container lock variable
       Select Case Type.Number ' select room or inventory
       Case 1 ' container unlocked in room
          RoomRecord.Container=ContainerRec ' set room container record
          Call Share.Room.Record(Room) ' write room record
       Case 0 ' container is locked in player inventory
          ' update player container
          UserRecord.Container(Container.Number)=ContainerRec
       End Select ' end store container record
       Outpt="You unlock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container key number
    If Last.Command.Number=Picklock.Command Then ' picklock container
       If UserRecord.ClassType<>Thief Then ' compare player class to thief
          If Normal.User Then ' compare player type to normal
             Outpt="You can't picklock doors!" ' make message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare player type
       Endif ' end compare class to thief
       If Int(Rnd*UserRecord.Stats(1))+3<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Int(Rnd*UserRecord.Stats(2))+3<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Rnd<.2 Then ' random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end chance
       ContainerRec.Locked=True ' set container record to unlocked
       ContainerRec.Closed=1 ' set container record to unlocked
       Select Case Type.Number ' select room or inventory
       Case 1 ' container unlocked in room
          RoomRecord.Container=ContainerRec ' set room container record
          Call Share.Room.Record(Room) ' write room record
       Case 0 ' container unlocked in player inventory
          ' update player container
          UserRecord.Container(Container.Number)=ContainerRec
       End Select ' end set container record
       Outpt="You picklock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check picklock container
    ' compare player inventory key numbers to container key number
    Key.Number=ContainerRec.Keyed ' store container key number to unlock
    Inpt=Right$(Str$(Key.Number+100000!),5) ' format key number to string
    For Inventory.Number=1 To 20 ' loop through all player inventory
       ' player inventory treasure index
       If UserRecord.Inv(Inventory.Number) Then
          ' get treasure record
          Call Read.Record(TreasureFile,UserRecord.Inv(Inventory.Number))
          If TreasureRecord.Keyed Then ' compare inventory treasure to key
             Container.Locked=True ' container unlocked flag
             ' format key number in inventory to string
             Outpts=Right$(Str$(TreasureRecord.Keyed+100000!),5)
             For Digit.Counter=1 To 5 ' loop through all key number digits
                ' get value of key digit
                Key.Digit=Val(Mid$(Outpts,Digit.Counter,1))
                ' compare player inventory key digit to container key digit
                ' digits unequal
                If Key.Digit<>Val(Mid$(Inpt,Digit.Counter,1)) Then
                   ' player inventory key digit 0 matches
                   If Key.Digit>False Then
                      ' container is not unlocked flag
                      Container.Locked=False
                      Exit For ' exit loop, digit mismatch
                   Endif ' end compare key digit 0 matches any key number
                Endif ' end compare key digit matches specific key number
             Next ' end loop through all key digits in player inventory key
             ' key in player inventory found to match container
             If Container.Locked Then
                ContainerRec.Locked=True ' set container unlock
                ContainerRec.Closed=1 ' set container unlock
                Select Case Type.Number ' select room or inventory
                Case 1 ' container unlocked with key in room
                   RoomRecord.Container=ContainerRec ' set room container
                   Call Share.Room.Record(Room) ' write room record
                Case 0 ' container unlocked with key in player inventory
                   ' update player container
                   UserRecord.Container(Container.Number)=ContainerRec
                End Select ' end set container record
                Outpt="You unlock it!" ' make message
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end compare key match
          Endif ' end compare player inventory to a key
       Endif ' end compare player inventory
    Next ' end loop through all keys in player inventory
    Outpt="You don't have the key!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check container
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.RoomLink=False Then ' check object is a portal
       Outpt="You can't unlock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object portal
    If ObjectRecord.DoorLock=False Then ' object does not lock
       Outpt="You can't unlock that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object lock
    If ObjectRecord.DoorLock=1 Then ' object is already unlocked
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object lock
    If ObjectRecord.Keyed=False Then ' object has no key number
       ObjectRecord.DoorLock=1 ' set object unlocked
       ObjectRecord.Closed=True ' set object unlocked
       Call SHare.Record(ObjectFile,Index.Number) ' write object record
       Outpt="You unlock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object key number
    If Last.Command.Number=Picklock.Command Then ' picklock object
       If ObjectRecord.Hidden Then ' object is hidden
          Outpt="You can't picklock hidden doors!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end object hidden
       If UserRecord.ClassType<>Thief Then ' check player class to thief
          If Normal.User Then ' check player is normal
             Outpt="You can't picklock doors!" ' make message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare normal player
       Endif ' end compare class type
       If Int(Rnd*UserRecord.Stats(1))+3<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Int(Rnd*UserRecord.Stats(2))+3<7 Then ' compute random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end random chance
       If Rnd<.2 Then ' random chance
          Outpt="You didn't picklock it!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end chance
       ObjectRecord.DoorLock=1 ' set object unlocked
       ObjectRecord.Closed=True ' set object unlocked
       Call SHare.Record(ObjectFile,Index.Number) ' write object record
       Outpt="You picklock it!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end picklock
    ' compare player inventory key numbers to object key number
    Inpt=Right$(Str$(ObjectRecord.Keyed+100000!),5) ' format key number
    For Inventory.Number=1 To 20 ' loop through all player inventory
       ' player inventory treasure index
       If UserRecord.Inv(Inventory.Number) Then
          ' get treasure record
          Call Read.Record(TreasureFile,UserRecord.Inv(Inventory.Number))
          If TreasureRecord.Keyed Then ' compare treasure to key
             Container.Locked=True ' set object unlocked flag
             ' format player inventory key number to string
             Outpts=Right$(Str$(TreasureRecord.Keyed+100000!),5)
             For Digit.Counter=1 To 5 ' loop through all key number digits
                ' get inventory key digit
                Key.Digit=Val(Mid$(Outpts,Digit.Counter,1))
                ' compare player inventory key digit to container key digit
                ' compare to object
                If Key.Digit<>Val(Mid$(Inpt,Digit.Counter,1)) Then
                   If Key.Digit>False Then ' zero digit matches any key digit
                      Container.Locked=False ' set object is not unlocked flag
                      Exit For ' exit loop, found unmatching digit
                   Endif ' end compare matching zero digit
                Endif ' end compare both digits
             Next ' end loop through all digits
             If Container.Locked Then ' object key number matched
                ObjectRecord.DoorLock=1 ' set object unlocked
                ObjectRecord.Closed=True ' set object unlocked
                Call SHare.Record(ObjectFile,Index.Number) ' write object record
                Outpt="You unlock it!" ' make message
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end matching key number
          Endif ' end locate player inventory key
       Endif ' end find player inventory treasure
    Next ' end loop through all player inventory for keys
    Outpt="You don't have the key!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end unlock object
 Outpt="You can't unlock that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to unlock/picklock an item or container

 Rem * routine to close an object.

Sub Close.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container index to treasure file
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no lock to set
       Outpt="You can't close that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end container lock
    If ContainerRec.Locked>False Then ' check if container already locked
       Outpt="It's already closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end container lock
    If ContainerRec.Closed=False Then ' container has no close setting
       Outpt="You can't close that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    If ContainerRec.Closed>False Then ' container is already closed
       Outpt="It's already closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    ContainerRec.Closed=1 ' set container record closed variable
    Select Case Type.Number ' select room or inventory
    Case 1 ' container closed in room
       RoomRecord.Container=ContainerRec ' set room container record
       Call Share.Room.Record(Room) ' write room record
    Case 0 ' container closed in player inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end reset container
    Outpt="You close it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container index
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index to object file
    If ObjectRecord.DoorLock<>1 Then ' compare object already locked
       Outpt="You can't close that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare lock
    If ObjectRecord.Closed Then ' compare container already closed
       Outpt="It's already closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    ObjectRecord.Closed=True ' set object record closed variable
    Call SHare.Record(ObjectFile,Index.Number) ' write object record
    Outpt="You close it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end object search
 Outpt="You can't close that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to closed an item

 Rem * routine to open an item.

Sub Open.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container index
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no lock to set
       Outpt="You can't open that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked>False Then ' compare container lock variable
       Outpt="You can't, it's locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare lock
    If ContainerRec.Closed=False Then ' container has no close variable to set
       Outpt="You can't open that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare close
    If ContainerRec.Closed<False Then ' container is already open
       Outpt="It's already open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare close
    ContainerRec.Closed=True ' set container open variable
    Select Case Type.Number ' select room or inventory
    Case 1 ' container is opened in room
       RoomRecord.Container=ContainerRec ' reset room container
       Call Share.Room.Record(Room) ' write room record
    Case 0 ' container is open in inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end reset container
    Outpt="You open it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container
 Call Num ' reset parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.DoorLock<>1 Then ' compare object closed variable
       Outpt="You can't open that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare closed
    If ObjectRecord.Closed=False Then ' compare object open variable
       Outpt="It's already open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare opened
    ObjectRecord.Closed=False ' set object record open variable
    Call SHare.Record(ObjectFile,Index.Number) ' write object record
    Outpt="You open it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end object index
 Outpt="You can't open that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to open an item

 Rem * routine to smash open a locked item.

Sub Smash.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check container mnemonic
 If Index.Number Then ' found container index to treasure file
    Container.Number=Array.Number ' store container number
    If ContainerRec.Locked=False Then ' container has no available lock
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container lock
    If ContainerRec.Locked<False Then ' lock variable is already open
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare lock
    If ContainerRec.Keyed>False Then ' container has a key number
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare key number
    If Int(Rnd*UserRecord.Stats(2))+1<7 Then ' compute smash chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Int(Rnd*UserRecord.Stats(1))+1<7 Then ' compare smash chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Rnd<.2 Then ' random chance to smash lock
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    ContainerRec.Locked=True ' set container to unlocked
    ContainerRec.Closed=1 ' set container to closed
    Select Case Type.Number ' select room or inventory
    Case 1 ' container unlocked in room
       RoomRecord.Container=ContainerRec ' set new container record
       Call Share.Room.Record(Room) ' write room record
    Case 0 ' container unlocked in inventory
       ' update player container
       UserRecord.Container(Container.Number)=ContainerRec
    End Select ' end reset container
    Outpt="You smash it open!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare container index
 Call Num ' decrement parse temp
 Call Examine.Objects ' check object mnemonic
 If Index.Number Then ' found object index
    If ObjectRecord.Hidden Then ' object type is hidden
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object type
    If ObjectRecord.RoomLink=False Then ' object is not a portal
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end portal
    If ObjectRecord.Keyed Then ' object has a key number
       Outpt="You can't smash that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object key number
    If ObjectRecord.DoorLock=1 Then ' object lock is already open
       Outpt="It's already unlocked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end object lock
    If Int(Rnd*UserRecord.Stats(2))+1<7 Then ' compute random chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Int(Rnd*UserRecord.Stats(1))+1<7 Then ' compute random chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    If Rnd<.2 Then ' random chance
       Outpt="You didn't smash it open!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end chance
    ObjectRecord.DoorLock=1 ' set object record lock to open
    Call Share.Record(ObjectFile,Index.Number) ' write object record
    Outpt="You smash it open!" ' make message
    Call IO.O ' send message
    If ObjectRecord.Trap Then ' check object is trapped
       Call Traps ' initiate any object traps
    Endif ' end object trap
    Exit Sub ' exit routine
 Endif ' end object index
 Outpt="You can't smash that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to smash open lock

 Rem * routine to search a container.

Sub Search.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Container ' check player and room inventory for container name
 If Index.Number Then ' found container index, placed into container record
    If ContainerRec.Locked>False Then ' compare container lock
       Outpt="You can't, it's locked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container
    If ContainerRec.Closed>False Then ' compare container closed
       Outpt="You can't, it's closed!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container
    Outpt="You search the container.." ' make message
    Call IO.O ' send message
    Graphics.Off=True ' color white
    Outpt="In it you find " ' preceding message
    Item.Counter=False ' container contents counter
    For Array.Number=1 To 5 ' loop through all container contents
       If ContainerRec.Invisible(Array.Number) Then ' compare invisible item
          ' get container treasure index
          Inventory.Number=ContainerRec.Inventory(Array.Number)
          If Inventory.Number>False And _
             Inventory.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then
             ' read index from treasure file
             Call Read.Record(TreasureFile,Inventory.Number)
             If Rnd>.5 Then ' compute random chance
                Carriage.Return=True ' supress cr/lf
                Call IO.O ' send message
                Outpt=TreasureRecord.TreasureName ' get treasure name found
                Outpt=Rtrim$(Outpt)+", " ' format treasure name
                ' increment container contents counter
                Item.Counter=Item.Counter+1
             Endif ' end random chance
          Endif ' end check treasure file bounds
       Endif ' end compare container contents invisible
    Next ' end loop through all container contents
    If Item.Counter=False Then ' compare no contents found
       Outpt="In it you find nothing.." ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare container content counter
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' format message, strip trailing comma
    If Item.Counter>1 Then ' compare container content counter
       Outpt="and "+Outpt ' format message with last contents found
    Endif ' end compare content counter
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end find container to search
 Outpt="You can't search that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to search container

 Rem * routine to display verbose text on an item entered on the game prompt,
 Rem * including a room number, an object, an item of treasure, monster, and
 Rem * contents of a container.

Sub Display.Information
 On Local Error Resume Next ' local error resume
 If Not Normal.User Then ' check non DM
    ' convert parameter to number (i.e. Look 12)
    Room.Number!=Int(Val(Parsed.Command1)+.5)
    ' check room bounds
    If Room.Number!>False And Room.Number!<=Lof(RoomFile)/Len(RoomRecord) Then
       Swap Room.Number!,Room ' store current room number
       Call Read.Room.Record(Room) ' get room to display
       Call Show.Room ' routine to display room
       Swap Room.Number!,Room ' restore current room number
       Call Read.Room.Record(Room) ' get current room
       Exit Sub ' exit routine
    Endif ' end check room number
 Endif ' end check normal user
 Outpt=UserRecord.CodeName ' get user codename
 Call Decrypt(Outpt) ' decrypt codename
 Outpt=Left$(Outpt,Len(Parsed.Command1)) ' store parameter
 If Outpt=Parsed.Command1 Then ' compare look command to user codename
    Call Display.Stats ' display player statistics
    Exit Sub ' exit routine
 Endif ' end check command parameter
 Call Examine.Treasure ' routine to compare parameter to treasure name
 If Index.Number Then ' compare returned index to treasure file
    Call Show.Treasure ' routine to display information on an item of treasure
    Exit Sub ' exit routine
 Endif ' end compare display treasure item
 Call Num ' reduce number of item
 Call Examine.Container ' compare parameter to container name
 If Index.Number Then ' check container to display
    Call Show.Container ' routine to display information on a container
    Exit Sub ' exit routine
 Endif ' end display container
 Call Num ' reduce number of item
 Call Examine.Objects ' compare parameter to object
 If Index.Number Then ' check index to object record
    Call Show.Object ' routine to display information on an object
    Exit Sub ' exit routine
 Endif ' end check object
 Call Num ' reduce number of item
 Call Check.Monster ' compare parameter to monster name in room
 If Monster.Number Then ' check index of monster array in room
    Call Show.Monster ' routine to display information on a monster
    Exit Sub ' exit routine
 Endif ' end check monster name
 Outpt="You can't examine that!" ' make error message
 Call IO.O ' send error message
End Sub ' end routine to display item

 Rem * routine to display room description (short or long), objects in room,
 Rem * monsters in room, containers in room, and directions/exits from room.
 Rem * working variables:
 Rem *   Lit.Room - returned true if room is unlit.

Sub Show.Room
 On Local Error Resume Next ' local error resume
 Call Check.Lit.Room(Lit.Room) ' routine to determine if room is unlit
 If Lit.Room Then ' check unlit room
    Outpt="It's too dark to see!" ' make message
    Call IO.O ' send message output
    Exit Sub ' exit routine
 Endif ' end check unlit room
 Graphics.Off=True ' reser color
 ' check if user is in brief mode, or room has no long description
 Outpt=RoomRecord.LongDesc(1) ' store room short one line description
 Outpt=Rtrim$(Outpt) ' trim brief description
 ' find any null characters from old structures
 If Instr(Outpt,Chr$(0)) Then
    Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
 Endif ' end find old nulls
 If UserRecord.Brief Or Outpt=Nul Then
    If Normal.User=False Then ' compare non DM status
       Outpt="(room:"+Str$(Room)+", monclass:" ' display DM room statistics
       If Room=1! Then ' check safe haven room
          Outpt=Outpt+" <safe haven>" ' append room message
       Else ' check safe haven
          Outpt=Outpt+Str$(RoomRecord.MonsterClass) ' display room number
       Endif ' end check safe haven room number
       Outpt=Outpt+", action:"+Str$(RoomRecord.Action)+")"
       If Room=1! Then ' recheck safe haven room
          Outpt=Outpt+" (resurrection room:" ' display resurrection room
          If RoomRecord.MonsterClass=False Then ' check room number
             Outpt=Outpt+" <none>)" ' append default
          Else ' check room number
             Outpt=Outpt+Str$(RoomRecord.MonsterClass)+")" ' append room number
          Endif ' end check room number
       Endif ' end check safe haven room
       Call IO.O ' display room monster class
    Endif ' end compare normal user in brief description
    Outpt=RoomRecord.ShortDesc ' store room short one line description
    Outpt=Rtrim$(Outpt) ' trim brief description
    ' find any null characters from old structures
    If Instr(Outpt,Chr$(0)) Then
       Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
    Endif ' end find old nulls
    Call IO.O ' display room short description
 Else ' display room four line long description
    For Desc.Line=1 To 4 ' loop through all four long room description lines
       Outpt=RoomRecord.LongDesc(Desc.Line) ' get next room description line
       Outpt=Rtrim$(Outpt) ' trim room description line
       If Instr(Outpt,Chr$(0)) Then ' find any nul characters from old files
          Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
       Endif ' end find old nulls
       If Outpt=Nul Then ' check if long description ends
          Exit For ' exit long description display loop
       Endif ' end check description end
       Call IO.O ' display room description line
    Next ' end long room description loop
 Endif ' end check room description to display
 Exit.Displayed=False ' set flag for an exit displayed
 If UserRecord.Brief Then ' check user is in brief mode
    Outpt=Nul ' assign empty display string
 Else ' user is not in brief mode
    Outpt="The exits are " ' assign initial display string
 Endif ' end check brief mode
 For Direction.Number=1 To 12 ' loop through all room directions
    ' compare room structure for direction
    If RoomRecord.Direct(Direction.Number) Then
       ' append exit to string
       Outpt=Outpt+Rtrim$(Direction(Direction.Number))+", "
       Exit.Displayed=True ' set flag for an exit displayed
    Endif ' end compare room direction exists
 Next ' end loop through room directions
 If Exit.Displayed Then ' compare flag for an exit displayed
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' truncate trailing comma, add period
    If UserRecord.Brief Then ' check user in brief mode
       Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' set first letter uppercase
    Endif ' end check brief mode
    Call IO.O ' send room exit display
 Endif ' end compare exit displayed flag
 ' following displays all objects, treasure, monsters, and container in room
 If UserRecord.Brief=False Then ' check user is in brief mode
    Outpt="You see " ' assign intial string
    Carriage.Return=True ' set flag to disable return/linefeed
    Call IO.O ' send initial string
 Endif ' end check brief mode
 Outpt=Nul ' assign empty display string
 Items.Displayed=False ' reset number of items displayed
 Object.Displayed=False ' reset flag indicating an item has been displayed
 For Array.Index=1 To 20 ' loop through all 20 objects in room
    Display.Object=False ' set flag to show object
    Object.Number=RoomRecord.Object(Array.Index) ' store room object number
    ' compare range
    If Object.Number>False And _
    Object.Number<=Lof(ObjectFile)/Len(ObjectRecord) Then
       Call Read.Record(ObjectFile,Object.Number) ' get object record
       If ObjectRecord.Invisible Then ' check object is invisible
          If Normal.User Then ' verify non DM
             Display.Object=True ' set flag to show object off
          Endif ' end verify normal user
       Endif ' end check invisible object
       If RoomRecord.HiddenObj(Array.Index) Then ' check object is hidden
          If Normal.User Then ' verify non DM
             Display.Object=True ' set flag to show object off
          Endif ' end verify normal user
       Endif ' end check invisible object
       If ObjectRecord.Hidden Then ' check object is hidden
          If Normal.User Then ' verify non DM
             Display.Object=True ' set flag to show object off
          Endif ' end verify normal user
       Endif ' end check hidden object
       If Display.Object=False Then ' check display flag
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send display of previous item
          ' increment number of items displayed
          Items.Displayed=Items.Displayed+1
          If Items.Displayed=1 Then ' verify first item being displayed
             If UserRecord.Brief Then ' check user in brief mode
                Outpt="You see " ' send initial display string
                Carriage.Return=True ' set flag to disable return/linefeed
                Call IO.O ' send previous string
             Endif ' end check brief mode
          Endif ' end verify first item
          Outpt=ObjectRecord.ObjectName ' store object name
          Outpt=Rtrim$(Outpt) ' trim object name
          If ObjectRecord.DoorLock>1 Then ' check object is locked
             Outpt=Outpt+"[locked]" ' append message
          Else ' compare unlocked object
             If ObjectRecord.DoorLock Then ' check object has lock
                If ObjectRecord.Closed Then ' check object is closed
                   Outpt=Outpt+"[closed]" ' append message
                Endif ' end check closed object
             Endif ' end check object is lock
          Endif ' end check object is locked
          Hidden.Flag=RoomRecord.HiddenObj(Array.Index) ' store hidden flag
          If ObjectRecord.Hidden Then ' check object is hidden
             Outpt=Outpt+"[hidden]" ' append message
          Else ' check object not hidden
             ' check object is invisible/hidden
             If ObjectRecord.Invisible Or Hidden.Flag Then
                Outpt=Outpt+"[inv]" ' append message
             Endif ' end check invisible object
          Endif ' end check object hidden
          Outpt=Outpt+", " ' append comma
          Object.Displayed=True ' set flag indicating an item displayed
       Endif ' end check display flag
    Endif ' end compare object file record range
 Next ' end loop through objects in room
 For Array.Index=1 To 20 ' loop through all room treasure
    Display.Treasure=False ' set flag to display item
    Treasure.Number=RoomRecord.Treasure(Array.Index) ' store treasure number
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' compare range
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       ' compare invisible treasure flag
       If RoomRecord.Flags(Array.Index)>False Then
          If Normal.User Then ' check non DM
             Display.Treasure=True ' set flag to display item
          Endif ' end check normal user
       Endif ' end compare invisible treasure
       If TreasureRecord.Invisible Then ' check treasure is invisible
          If Normal.User Then ' check non DM
             Display.Treasure=True ' set display flag
          Endif ' end check normal user
       Endif ' end check invisible treasure
       If Display.Treasure=False Then ' compare display flag
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' display previous item
          ' increment number of items displayed
          Items.Displayed=Items.Displayed+1
          If Items.Displayed=1 Then ' check first item
             If UserRecord.Brief Then ' check user is in brief mode
                Outpt="You see " ' make initial string
                Carriage.Return=True ' set flag to disable return/linefeed
                Call IO.O ' send initial string
             Endif ' end check brief mode
          Endif
          Outpt=TreasureRecord.TreasureName ' get treasure name
          Outpt=Rtrim$(Outpt) ' trim treasure name
          If TreasureRecord.Keyed Then ' append key number to treasure name
             Outpt=Outpt+"(#"+Right$(Str$(TreasureRecord.Keyed+100000!),5)+")"
          Endif ' end compare treasure key number
          If TreasureRecord.Plus Then ' append plus number to treasure name
             Outpt=Outpt+"(+"+Mid$(Str$(Abs(TreasureRecord.Plus)),2)+")"
          Endif ' end compare treasure plus
          If TreasureRecord.Spell Then ' append spell plus to treasure name
             Call Read.Record(SpellFile,TreasureRecord.Spell) 'get spell record
             Outpt=Outpt+"(+"+Mid$(Str$(SpellRecord.Level),2)+")"
          Endif ' end compare treasure spell plus
          If TreasureRecord.Locked>False Then ' check treasure is locked
             Outpt=Outpt+"[locked]" ' append message
          Else ' check treasure locks
             If TreasureRecord.Locked<False Then ' check treasure lock
                If TreasureRecord.Closed>False Then ' check treasure is closed
                   Outpt=Outpt+"[closed]" ' append message
                Endif ' end check closed treasure
             Endif ' end check treasure lock
          Endif ' end check locked treasure
          If TreasureRecord.Invisible Then ' check treasure is invisible
             Outpt=Outpt+"[inv]" ' append message
          Else ' treasure is not invisible
             ' check invisible
             If RoomRecord.Flags(Array.Index)=Hidden.Object Then
                Outpt=Outpt+"[inv]" ' treasure flag, append message
             Endif ' end check invisible flag
          Endif ' end check invisible treasure
          If RoomRecord.Flags(Array.Index)=Magic.Trap Then ' check magic trap
             Outpt=Outpt+"[trap]" ' treasure flag, append message
          Endif ' end check magic trap flag
          Outpt=Outpt+", " ' append comma
          Object.Displayed=True ' set item displayed flag
       Endif ' end compare display flag
    Endif ' end compare treasure file record range
 Next ' end loop through treasure
 ContainerRec=RoomRecord.Container ' store room container into record
 If Rtrim$(ContainerRec.ShortName)<>Nul Then ' compare container name length
    Carriage.Return=True ' set flag to disable return/linefeed
    Call IO.O ' send previous string
    Items.Displayed=Items.Displayed+1 ' increment number of items displayed
    If Items.Displayed=1 Then ' check first item displayed
       If UserRecord.Brief Then ' check user is in brief mode
          Outpt="You see " ' make initial string
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send first string
       Endif ' end check brief mode
    Endif ' end check first display item
    Outpt=Rtrim$(ContainerRec.ContainerName) ' store container name
    If ContainerRec.Locked>False Then ' check container is locked
       Outpt=Outpt+"[locked]" ' append message
    Else ' container is not locked
       If ContainerRec.Closed>False Then ' check container is closed
          Outpt=Outpt+"[closed]" ' append message
       Endif ' end check closed container
    Endif ' end check locked container
    If ContainerRec.Keyed Then ' check container has a key number
       Outpt=Outpt+"(#"+Right$(Str$(ContainerRec.Keyed+100000!),5)+")"
    Endif ' append key number to container name
    Outpt=Outpt+", " ' append comma
    Object.Displayed=True ' set an item displayed flag
 Endif ' end compare container name length
 For Monster.Number=1 To Number.Monsters ' loop through all room monsters
    Carriage.Return=True ' set flag to disable return/linefeed
    Call IO.O ' send previous string
    Items.Displayed=Items.Displayed+1 ' increment number of items displayed
    If Items.Displayed=1 Then ' check first item
       If UserRecord.Brief Then ' check user is in brief mode
          Outpt="You see " ' make initial string
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send initial string
       Endif ' end check brief mode
    Endif ' end check first item
    Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
    Outpts=Rtrim$(Outpts) ' trim monster name
    Call The.Or.An ' routine to get prefix (a, an, the)
    Outpt=Outpt+Prefix1+Outpts+", " ' make message of monster
    Object.Displayed=True ' set an item displayed flag
 Next ' end loop through monsters in room
 If Object.Displayed=False Then ' compare flag indicating an item is displayed
    If UserRecord.Brief=False Then ' check user is in brief mode
       Outpt="nothing special." ' make last item string
    Else ' user is in brief mode
       Outpt="You see nothing." ' make entire message
    Endif ' end check brief mode
 Else ' an item was displayed
    If Outpt<>Nul Then ' compare string length
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, append period
       If Items.Displayed>1 Then ' check more than one item was displayed
          Outpt="and "+Outpt ' append to last item
       Endif ' end check item numbers
    Endif ' end check valid last item string
 Endif ' end check flag of items displayed
 Call IO.O ' send last display item
End Sub ' end routine to show room description, etc.

 Rem * routine to display player character inventory.

Sub Display.Inventory
 On Local Error Resume Next ' local error resume
 Treasure.Counter=False ' reset counter
 For Array.Index=1 To 20 ' loop through all player treasure inventory
    Treasure.Number=UserRecord.Inv(Array.Index) ' get treasure number
    If Treasure.Number Then ' compare number
       Treasure.Counter=Treasure.Counter+1 ' increment counter
    Endif ' end check compare
 Next ' end loop counting
 For Array.Index=1 To 20 ' loop through all player treasure inventory
    Treasure.Number=UserRecord.Object(Array.Index) ' get treasure number
    If Treasure.Number Then ' compare number
       Treasure.Counter=Treasure.Counter+1 ' increment counter
    Endif ' end check compare
 Next ' end loop counting
 Container.Count=False ' reset counter
 For Array.Index=1 To 3 ' loop through all player character containers
    ' store container into record
    ContainerRec=UserRecord.Container(Array.Index)
    ' compare container name length
    If Rtrim$(ContainerRec.ShortName)<>Nul Then
       Treasure.Counter=Treasure.Counter+1 ' increment counter
       Container.Count=Container.Count+1 ' increment counter
    Endif ' end check compare
 Next ' end loop counting
 Graphics.Off=True ' reset color
 If Treasure.Counter=1 Then ' check counter
    Outpt="You are carrying"+Str$(Treasure.Counter)+" item" ' weight message
 Else ' check counter
    Outpt="You are carrying"+Str$(Treasure.Counter)+" items" ' weight message
 Endif ' end check counter
 Outpt=Outpt+" weighing"+Str$(Weight+Container.Count)+" pounds:" ' weight message
 Call IO.O ' send output message
 Items.Displayed=False ' number of items displayed
 For Array.Index=1 To 20 ' loop through all player treasure inventory
    Treasure.Number=UserRecord.Inv(Array.Index) ' get treasure number
    If Treasure.Number Then ' compare number
       Carriage.Return=True ' disable return/linefeed
       Call IO.O ' send initial item
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       Outpts=TreasureRecord.TreasureName ' store treasure name
       Outpts=Rtrim$(Outpts) ' trim name
       If TreasureRecord.Keyed Then ' append key number to treasure name
          Outpts=Outpts+"(#"+Right$(Str$(TreasureRecord.Keyed+100000!),5)+")"
       Endif ' end compare treasure key number
       If TreasureRecord.Plus Then ' append plus number to treasure name
          Outpts=Outpts+"(+"+Mid$(Str$(Abs(TreasureRecord.Plus)),2)+")"
       Endif ' end compare treasure plus
       If TreasureRecord.Spell Then ' append spell plus to treasure name
          Call Read.Record(SpellFile,TreasureRecord.Spell) ' get spell record
          Outpts=Outpts+"(+"+Mid$(Str$(SpellRecord.Level),2)+")"
       Endif ' end compare treasure spell plus
       If TreasureRecord.LightType Then ' check treasure is a light
          If UserRecord.Charges(Array.Index)<False Then ' check light charges
             Outpts=Outpts+"[lit]" ' append message
          Endif ' end check charges
       Endif ' end check light
       If TreasureRecord.Locked>False Then ' check treasure is locked
          Outpts=Outpts+"[locked]" ' append message
       Else ' check treasure locks
          If TreasureRecord.Locked<False Then ' check treasure lock
             If TreasureRecord.Closed>False Then ' check treasure is closed
                Outpts=Outpts+"[closed]" ' append message
             Endif ' end check closed treasure
          Endif ' end check treasure lock
       Endif ' end check locked treasure
       If TreasureRecord.Invisible Then ' check treasure is invisible
          Outpts=Outpts+"[inv]" ' append message
       Endif ' end check invisible
       Outpt=Outpts+", " ' append comma
       Items.Displayed=Items.Displayed+1 ' increment item number
       If Items.Displayed=1 Then ' check first item
          Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
       Endif ' end check first item
    Endif ' end compare treasure number
 Next ' end loop through inventory treasure
 For Array.Index=1 To 20 ' loop through player object inventory
    Object.Number=UserRecord.Object(Array.Index) ' get object number
    If Object.Number Then ' compare object number
       Carriage.Return=True ' disable return/linefeed
       Call IO.O ' send previous item
       Call Read.Record(ObjectFile,Object.Number) ' get object record
       Outpts=ObjectRecord.ObjectName ' store object name
       Outpts=Rtrim$(Outpts) ' trim object name
       If ObjectRecord.Invisible Then ' compare object is invisible
          Outpts=Outpts+"[inv]" ' append to object name
       Endif ' end compare object invisible
       If ObjectRecord.Keyed Then ' compare object key, append number to name
          Outpts=Outpts+"(#"+Right$(Str$(ObjectRecord.Keyed+100000!),5)+")"
       Endif ' end compare object key number
       Outpt=Outpts+", " ' append comma
       Items.Displayed=Items.Displayed+1 ' increment item number
       If Items.Displayed=1 Then ' check first item
          Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
       Endif ' end check first item
    Endif ' end check object number
 Next ' end loop through object inventory
 For Array.Index=1 To 3 ' loop through all player character containers
    ' store container into record
    ContainerRec=UserRecord.Container(Array.Index)
    ' compare container name length
    If Rtrim$(ContainerRec.ShortName)<>Nul Then
       Carriage.Return=True ' disable retuen/linefeed
       Call IO.O ' send previous item
       Outpt=Rtrim$(ContainerRec.ContainerName) ' store container name
       If ContainerRec.Locked>False Then ' check container locked
          Outpt=Outpt+"[locked]" ' append message
       Else ' container not locked
          If ContainerRec.Closed>False Then ' check container closed
             Outpt=Outpt+"[closed]" ' append message
          Endif ' end check closed container
       Endif ' end check locked container
       If ContainerRec.Keyed Then ' check container key number
          Outpt=Outpt+"(#"+Right$(Str$(ContainerRec.Keyed+100000!),5)+")"
       Endif ' append container key number to message
       Outpt=Outpt+", " ' append comma
       Items.Displayed=Items.Displayed+1 ' increment item number
       If Items.Displayed=1 Then ' check first item
          Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
       Endif ' end check first item
    Endif ' end compare container name length
 Next ' end loop through player containers
 If Items.Displayed=False Then ' compare items displayed
    Outpt="Nothing at all." ' display message
 Else ' some items displayed
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, append period
    If Items.Displayed>1 Then ' check more than one item displayed
       Outpt="and "+Outpt ' add to message
    Endif ' end check item numbers
 Endif ' end compare items
 Call IO.O ' send last item
End Sub ' end routine to display player inventory

 Rem * routine to sell item of treasure, object, or container.

Sub Pawn.Shop
 On Local Error Resume Next ' local error resume
 Sell.Container=False ' item to sell is container flag
 Call Check.Inventory.Treasure ' routine to find treasure name
 If Index.Number=False Then ' check treasure index
    Call Num ' reduce counter
    Call Check.Inventory.Container ' routine to find container name
    Sell.Container=True ' set container for sale flag
    Container.Number=Array.Number ' store container number
    If Index.Number=False Then ' check treasure index
       Outpt="The Broker says: You can't sell that!" ' make error message
       Call IO.O ' send error message
       Exit Sub ' exit routine
    Endif ' end check index
 Endif ' end check index
 Outpts=TreasureRecord.ShortName ' store treasure name being sold
 If Sell.Container Then ' check container flag
    Item.Cost#=0# ' reset price of container contents
    Outpts=ContainerRec.ShortName ' store container name
    If ContainerRec.Locked>False Then ' check container lock
       Outpt="The Broker tries the lock and says: Arrghh!! Can't open it!"
       Call IO.O ' send lock message
       Exit Sub ' exit routine
    Endif ' end check container lock
    For Array.Index=1 To 5 ' loop through container contents
       ' store treasure number
       Treasure.Number=ContainerRec.Inventory(Array.Index)
       ' verify file bounds
       If Treasure.Number>False And _
       Treasure.Number<Lof(TreasureFile)/Len(TreasureRecord) Then
          Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
          ' verify item plus is not loadable or launchable object
          If TreasureRecord.Loadable=False And TreasureRecord.Launchable=False Then
             ' check item plus or spell
             If TreasureRecord.Plus Or TreasureRecord.Spell Then 
                ' compare charges
                If ContainerRec.Charges(Array.Index)=False Then
                   Item.Cost#=Item.Cost#+1# ' add 1 gold for discharged item
                Else ' compare charges
                   ' add treasure gold
                   Item.Cost#=Item.Cost#+Cdbl(Int(TreasureRecord.Gold*.95))
                Endif ' end compare charges
             Else ' compare item plus or spell
                ' add treasure gold
                Item.Cost#=Item.Cost#+Cdbl(Int(TreasureRecord.Gold*.9))
             Endif ' end compare item plus or spell
          Else ' compare item plus type
             ' add treasure gold
             Item.Cost#=Item.Cost#+Cdbl(Int(TreasureRecord.Gold))
          Endif ' end check item plus type
       Endif ' end verify file bounds
    Next ' end loop through container contents
    If Item.Cost#=0# Then ' compare container content price
       Item.Cost#=1# ' reset price
       Sell.Container=1 ' sell the container
    Else ' compare contents
       Outpts="contents of the "+Outpts ' make purchase message
    Endif ' end compare container contents
 Else ' check container
    Item.Cost#=Cdbl(Int(TreasureRecord.Gold*.9)) ' calculate price of treasure item
    ' verify item plus is not loadable or launchable object
    If TreasureRecord.Loadable=False And TreasureRecord.Launchable=False Then
       If TreasureRecord.Plus Or TreasureRecord.Spell Then ' verify charges
          If UserRecord.Charges(Array.Number)=False Then ' compare charges
             Item.Cost#=1# ' set price to 1
             Outpts="broken "+Outpts ' make broken item message
          Endif ' end compare charges
       Endif ' end compare charges left
    Endif ' end verify charges
 Endif ' end check container being sold
 Outpt="The Broker says: Well, I'll give you"+Str$(Item.Cost#)+ _
 " gold for the "+Rtrim$(Lcase$(Outpts))+"." ' message of price for items
 Call IO.O ' send purchase message
 Outpt="The Broker asks: Is that a deal(y/n)? " ' make input prompt
 No.Input.Out="Y" ' default input
 Call IO.I ' get input
 If Yes Then ' compare response
    UserRecord.Gold=UserRecord.Gold+Item.Cost# ' increment player gold
    Outpt="The Broker says: Great!" ' make purchase message
    If Sell.Container=True Then ' check container
       ' sell contents of container
       For Container.Item=1 To 5 ' loop through container contents
          ' routine resets container item
          Call Clear.Container(Container.Item,False)
       Next ' end loop through container contents
       ' store container record
       UserRecord.Container(Container.Number)=ContainerRec
    Else ' check container
       ' sell container
       If Sell.Container=1 Then ' check container
          Call Clear.Container(0,True) ' clear player container structure
          UserRecord.Container(Container.Number)=ContainerRec ' clear container record
       Else ' check sell item
          ' routine removes item from player
          Call Discard.Inventory(Array.Number,True)
       Endif ' end check sell item/container
    Endif ' end check container sold
 Else ' compare repsonse
    Outpt="The Broker says: Oh well!" ' make purchase message
 Endif ' end compare response
 Call IO.O ' send purchase message
End Sub ' end routine to sell items

 Rem * routine for monsters to talk.
 Rem * input variables:
 Rem *   Parsed.Command1 - command parameter of monster name.

Sub Talk.To.Monster
 On Local Error Resume Next ' local error resume
 Call Check.Monster ' get monster number
 If Monster.Number=False Then ' check monster found
    Outpt="You can't talk to that!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check monster number
 ' get random number of monster variable of monster talk record file
 Talk.Number=MonsterArray(Monster.Number).Talk(Int(Rnd*5+1))
 Outpt=Nul ' reset talk response string
 ' check bounds
 If Talk.Number>False And _
 Talk.Number<=Lof(MonTalkFile)/Len(MonsterTalkRecord) Then
    Call Read.Record(MonTalkFile,Talk.Number) ' get the random talk string
    Outpt=Rtrim$(MonsterTalkRecord.TalkMessage) ' trim talk response
 Endif ' end check monster talk file bounds
 If Outpt=Nul Then ' compare to length of string
    Outpt="The monster doesn't reply!" ' set string
 Endif ' end check string length
 Call IO.O ' send response
 Call Read.Room.Record(Room) ' get current room record
 ' compare monster number to room record talk action number
 Action.Number=RoomRecord.Action ' store room action number
 ' check file bounds
 If Action.Number>False And _
 Action.Number<=Lof(ActionFile)/Len(ActionRecord) Then
    Call Read.Record(ActionFile,Action.Number) ' read action record
    If MonsterIndex(Monster.Number)=ActionRecord.MonsterTalk Then ' compare
       Action1$="As you begin to speak," ' format action string one
       Action2$="The monster hits you for" ' format action string two
       ' routine to activate actions by specific trigger
       Call Actions(Action1$,Action2$)
    Endif ' end compare room monster talk action
 Endif ' end check file bounds
End Sub ' end routine to talk to monster

 Rem * routine to rust some item of player.
 Rem * input variables:
 Rem *   Room.Rust.Rate - number of rounds for rusting.
 Rem *   Rust.Rate - counter of rounds for rusting.

Sub Rust.Weapon
 On Local Error Resume Next ' local error resume
 If Room.Rust.Rate=False Then ' check room has rust rate
    Exit Sub ' exit routine
 Endif ' end check room rust rate
 Rust.Rate=Rust.Rate+1 ' increment rust rate counter
 If Rust.Rate<Room.Rust.Rate Then ' check rust rate counter
    Exit Sub ' exit routine
 Endif ' end check rust rate counter
 Rust.Rate=False ' reset rust rate counter
 Call Rust.Inventory(Weapon4) ' routine to rust armor
 Call Rust.Inventory(Weapon5) ' routine to rust shield
 Call Rust.Inventory(Weapon6) ' routine to rust weapon
 Call Rust.Inventory(Weapon7) ' routine to rust ring
End Sub ' end rust routine

 Rem * routine to rust item.
 Rem * input variables:
 Rem *   Weapon.Number - array index to treasure file record.

Sub Rust.Inventory(Weapon.Number)
 On Local Error Resume Next ' local error resume
 If Weapon.Number>False Then ' check treasure index
    ' store index to treasure file
    Treasure.Number=UserRecord.Inv(Weapon.Number)
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then 'compare bounds
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       If TreasureRecord.Rustable=True Then ' verify item can rust
          If Rnd<(TreasureRecord.RustPercent/100) Then ' check rust percent
             Outpt=TreasureRecord.ShortName ' store treasure name
             Outpt=Rtrim$(Outpt) ' trim name
             Outpt=Lcase$(Outpt) ' lowercase name
             Outpt="Your "+Outpt+" rusts!" ' make message
             Call IO.O ' send rust message
             ' remove item from inventory
             Call Discard.Inventory(Weapon.Number,True)
          Endif ' end check random rust percent
       Endif ' end verify item rusts
    Endif ' end compare file bounds
 Endif ' end check treasure index
End Sub ' end routine to rust items

 Rem * routine for monster to steal item from player inventory.
 Rem * input variables:
 Rem *   Room.Steal.Rate - number of rounds for stealing.
 Rem *   Steal.Rate - counter of rounds for stealing.

Sub Steal.Treasure
 On Local Error Resume Next ' local error resume
 If Room.Steal.Rate=False Then ' check room has steal rate
    Exit Sub ' exit routine
 Endif ' end check room steal rate
 Steal.Rate=Steal.Rate+1 ' increment steal rate counter
 If Steal.Rate<Room.Steal.Rate Then ' compare steal rates
    Exit Sub ' exit routine
 Endif ' end compare steal rates
 Steal.Rate=False ' reset steal rate counter
 If Number.Monsters=False Then ' check monsters in room
    Exit Sub ' exit routine
 Endif ' end compare monsters in room
 For Array.Index=1 To 20 ' loop through player inventory
    If UserRecord.Inv(Array.Index) Then ' check player has inventory
       Call Read.Record(TreasureFile,UserRecord.Inv(Array.Index)) ' get record
       If TreasureRecord.Stealable=True Then ' verify item can be stolen
          ' check random percentage item can be stolen
          If Rnd<(TreasureRecord.StealPercent/100) Then
             For Monster.Number=1 To Number.Monsters ' loop through monsters
                ' check permanent
                If MonsterArray(Monster.Number).Permanent=False Then
                   For Array.Number=1 To 5 ' loop through monsters inventory
                      ' locate empty inventory in monster
                      If MonsterArray(Monster.Number).Treasure(Array.Number)= _
                      False Then
                         ' store player inventory in monster inventory
                         MonsterArray(Monster.Number).Treasure(Array.Number)= _
                         UserRecord.Inv(Array.Index) ' store
                         ' monster name
                         Outpt=MonsterArray(Monster.Number).MonsterName
                         Outpt=Rtrim$(Outpt) ' trim name
                         Inpt=TreasureRecord.ShortName ' store treasure name
                         Inpt=Rtrim$(Inpt) ' trim name
                         Inpt=Lcase$(Inpt) ' lowercase name
                         Outpt="The "+Outpt+" steals your "+Inpt+"!" ' message
                         Call IO.O ' send stolen message
                         ' remove inventory from player
                         Call Discard.Inventory(Array.Index,True) ' remove
                         Exit Sub ' exit routine
                      Endif ' end locate emtpt monster inventory
                   Next ' end loop through monster inventory array
                Endif ' end check permanent monster
             Next ' end loop through monsters in room
          Endif ' end random percentage for stealing inventory
       Endif ' end verify item can be stolen
    Endif ' end check player inventory
 Next ' end loop through player inventory
End Sub ' end routine to steal item from player

 Rem * routine to offer treasure or gold to a monster to leave the room.
 Rem * processing variables:
 Rem *   Monster.Number - number of monster.
 Rem *   UserRecord.Gold - for offering gold.

Sub Offer
 On Local Error Resume Next ' local error resume
 Call ParseX ' get first command parameter
 If Parser=False Then ' check parameter
    Outpt="Offer to whom?" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check parameter
 Call Numeric ' parse parameter number from # sign
 Call Check.Monster ' get monster number
 If Monster.Number=False Then ' check monster
    Outpt="That's not here!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check monster number
 Parsed.Command1=Parsed.Command2 ' get second parameter
 Call Numeric ' parse parameter number from # sign
 Accept.Offer=False ' flag for monster to accept offer
 Player.Gold#=False ' stores amount of gold offered
 If MonsterArray(Monster.Number).Magic=False Then ' check magical monster
    If MonsterArray(Monster.Number).Permanent=False Then ' permanent monster
       Call Check.Inventory.Treasure ' parameter is item of player inventory
       If Index.Number Then ' player offers item of inventory
          Call TreasureCharges(Charges.Amount) ' get treasure item charges
          If Charges.Amount>False Then ' compare remaining charges
             If TreasureRecord.Spell Then ' check item is magical
                Call Read.Record(SpellFile,TreasureRecord.Spell) ' get record
                If SpellRecord.Level>=10 Then ' verify item spell level
                   Accept.Offer=True ' set accept flag
                Endif ' end compare spell level
             Else ' check magical item
                If TreasureRecord.Plus>=10 Then ' compare plus of item
                   ' set accept flag for plus greater than ten
                   Accept.Offer=True
                Endif ' end check item plus
             Endif ' end check magical item
          Endif ' end compare charges
       Else ' compare parameter to offer
          ' convert offer to integer
          Offer.Amount#=Cdbl(Int(Val(Parsed.Command1))+.5)
          If Offer.Amount#>False Then ' check value of offer
             ' compare value offered is greater than monster level
             Monster.Amount#=Cdbl(Int(MonsterArray(Monster.Number).Level*10))
             If Offer.Amount#>=Monster.Amount# Then ' compare
                ' compute player gold
                Player.Gold#=UserRecord.Gold-Offer.Amount#
                If Player.Gold#>=False Then ' check player gold
                   Accept.Offer=True ' set accept flag
                Endif ' end compare player has gold
             Endif ' end compare accept gold value offer
          Endif ' end check offer value
       Endif ' end item offered
    Endif ' end check parmanent monster
 Endif ' end check magical monster
 If Accept.Offer=False Then ' compare accept flag
    Outpt="The monster ignores your offer!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare accept flag
 Call Remove.Monster ' routine to take monster out of array
 If Player.Gold# Then ' check gold offered
    UserRecord.Gold=Player.Gold# ' decrement player gold value
    Outpt="The monster takes your offer and leaves!" ' make message
    Call IO.O ' send accept message
    Exit Sub ' exit routine
 Endif ' end check gold offered
 Call Discard.Inventory(Array.Number,True) ' remove item from player inventory
 Outpt="The monster trades with you and leaves!" ' make message
 Call IO.O ' send accept message
End Sub ' end routine to offer to monster

 Rem * routine to determine room direction for player to move to in panic.

Sub Panic
 On Local Error Resume Next ' local error resume
 Directions=False ' room direction counter
 For Direction.Number=1 To 12 ' loop through all room directions
    If RoomRecord.Direct(Direction.Number) Then ' get next room direction
       Call Restrict(Direction.Number,Restricted) ' routine checks valid room
       If Restricted=False Then ' compare restriction flag
          Directions=Directions+1 ' increment direction counter
       Endif ' end compare restricted room
    Endif ' end check next room direction
 Next ' end loop through room directions
 If Directions=False Then ' compare direction counter
    Outpt="There is nowhere to run! Try Appeal.." ' make panic error message
    Call IO.O ' send panic error message
    Exit Sub ' exit routine
 Endif ' end compare direction counter
 ' calculate random number of directions to search from direction counter
 New.Direction=Int(Rnd*Directions+1) ' calculate
 Direction.Counter=False ' reset search counter
 For Direction.Number=1 To 12 ' loop through room directions
    If RoomRecord.Direct(Direction.Number) Then ' compare room direction
       Call Restrict(Direction.Number,Restricted) ' check room restriction
       If Restricted=False Then ' check restriction flag
          Direction.Counter=Direction.Counter+1 ' increment search counter
          If Direction.Counter=New.Direction Then ' compare counters
             ' make panic message
             Outpt="You run away like a screaming madman!"
             Call IO.O ' send panic message
             Call Fumble ' routine for inventory fumble
             ' store next room direction
             Next.Room=RoomRecord.Direct(Direction.Number)
             Call Enter.Room ' routine to move player to room
             Exit Sub ' exit loop through room directions
          Endif ' end compare counters
       Endif ' end check restriction flag
    Endif ' end compare room direction
 Next ' end loop through room directions
 Outpt="Nothing happens.." ' default message
 Call IO.O ' send message
End Sub ' end routine for player panic

 Rem * routine to move player with low statistics or in a room with no exits.

Sub Appeal
 On Local Error Resume Next ' local error resume
 If UserRecord.Fatigue<(UserRecord.FatigueMax*.25) Then ' compare stats
    Outpt="Your fatigue is very low.." ' make message
    Call IO.O ' send message
    Outpt="You are teleported elsewhere!" ' make teleport message
    Call IO.O ' send teleport message
    Call Read.Room.Record(1!) ' get room record #1
    Resurrection.Room=RoomRecord.MonsterClass ' get resurrection room number
    Next.Room=Csng(Resurrection.Room) ' store resurrection room
    If Next.Room=0! Then ' check room number
       Next.Room=1! ' store new room number
    Endif ' end check room
    Teleported=True ' set teleporting flag
    Call Enter.Room ' routine moves player to room
    Exit Sub ' exit routine
 Endif ' end compare low statistics
 For Direction.Number=1 To 12 ' loop through room directions
    If RoomRecord.Direct(Direction.Number) Then ' compare room direction
       Call Restrict(Direction.Number,Restricted) ' routine checks valid room
       If Restricted=False Then ' compare restriction flag
          Outpt="There are exits in the room!" ' make error message
          Call IO.O ' send error message
          Exit Sub ' exit routine
       Endif ' end compare restriction flag
    Endif ' end compare room directions
 Next ' end loop through room directions
 For Array.Index=1 To 20 ' loop through room objects
    Object.Number=RoomRecord.Object(Array.Index) ' get object record
    ' file bounds
    If Object.Number>False And _
    Object.Number<=Lof(ObjectFile)/Len(ObjectRecord) Then
       Call Read.Record(ObjectFile,Object.Number) ' get object record
       If ObjectRecord.RoomLink>False Then ' compare object room number
          If ObjectRecord.JailTrap=False Then ' check object jail trap
             Call Restrict(12,Restricted) ' routine checks valid room to go to
             If Restricted=False Then ' compare restriction flag
                Outpt="There are objects with exits in the room!" ' make error message
                Call IO.O ' send error message
                Exit Sub ' exit routine
             Endif ' end check restriction flag
          Endif ' end check object jail trap
       Endif ' end compare object room link number
    Endif ' end check file bounds
 Next ' end loop through objects in room
 Outpt="You are teleported elsewhere!" ' make teleport message
 Call IO.O ' send teleport message
 Call Read.Room.Record(1!) ' get room record #1
 Resurrection.Room=RoomRecord.MonsterClass ' get resurrection room number
 Next.Room=Csng(Resurrection.Room) ' store resurrection room
 If Next.Room=0! Then ' check room number
    Next.Room=1! ' store new room number
 Endif ' end check room
 Number.Monsters=False ' reset number of monsters
 Teleported=True ' set teleporting flag
 Call Enter.Room ' routine moves player to room
End Sub ' end routine to appeal player to new room

 Rem * routine to calculate bank interest.

Sub Bank.Interest
 On Local Error Resume Next ' local error resume
 Outpt=UserRecord.DateOn ' get player last date online
 Call Decrypt(Outpt) ' decrypt date
 If Date$<>Outpt Then ' compare date to today
    Interest.Days=DateValue(Date$)-DateValue(Outpt) ' calculate difference
    If Interest.Days>False Then ' check difference of dates
       If UserRecord.Bank>False Then ' verify players bank balance
          Total.Interest#=False ' reset total interest
          ' loop through days since last online
          For Total.Days=1 To Interest.Days
             ' compute interest for each day
             Interest#=Int(UserRecord.Bank*.065)
             ' add interest to account
             UserRecord.Bank=UserRecord.Bank+Interest#
             Total.Interest#=Total.Interest#+Interest# ' add interest to total
          Next ' end loop through dates
          If Total.Interest#>False Then ' compare total interest
             ' make new balance message
             Outpt="The bank reports interest posting of"+ _
             Str$(Total.Interest#)+" gold to your account!"
             Call IO.O ' send display message
          Endif ' end compare interest
       Endif ' end verify bank balance
       If UserRecord.Borrow>False Then ' verify players bank loan
          Total.Interest#=False ' reset total interest
          ' loop through days since last online
          For Total.Days=1 To Interest.Days
             ' compaute interest for each day
             Interest#=Int(UserRecord.Borrow*.075)
             ' add interest to loan
             UserRecord.Borrow=UserRecord.Borrow+Interest#
             Total.Interest#=Total.Interest#+Interest# ' add interest to total
          Next ' end loop through dates
          If Total.Interest#>False Then ' compare total interest
             ' make new balance message
             Outpt="The bank reports interest posting of"+ _
             Str$(Total.Interest#)+" gold to your loan!"
             Call IO.O ' send display message
          Endif ' end compare interest
       Endif ' end verify loan balance
    Endif ' end check difference of dates
 Endif ' end compare todays date
 Outpt=Date$ ' store todays date
 Call Valid(Outpt,10) ' validate date string
 Call Encrypt(Outpt,True) ' encrypt date string
 UserRecord.DateOn=Outpt ' store new date in player record
 Call Share.Record(UserFile,User.Index) ' routine to write player record
End Sub ' end routine to calculate bank balances

 Rem * routine to process bank commands.

Sub Bank
 On Local Error Resume Next ' local error resume
 Call Put.User.Record ' routine to write user record
 Do ' loop through bank menu
    Graphics.Off=False ' reset color
    Outpt="Bank menu options:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]ccount" ' make display message
    Call IO.O ' send message
    Outpt="[B]orrow" ' make display message
    Call IO.O ' send message
    Outpt="[D]eposit" ' make display message
    Call IO.O ' send message
    Outpt="[P]ayback" ' make display message
    Call IO.O ' send message
    Outpt="[T]ransfer" ' make display message
    Call IO.O ' send message
    Outpt="[W]ithdraw" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="The broker asks: What can I do for you(q to quit)? " ' input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of bank option
    Case "A" ' option to display bank balances
       Outpt="He fumbles with his ledgers and says:" ' make display message
       Call IO.O ' send message
       Graphics.Off=True ' reset color
       Outpt="The current account interest rate is 6.5 percent." ' message
       Call IO.O ' send message
       Outpt="The current lending interest rate is 7.5 percent." ' message
       Call IO.O ' send message
       ' make display message
       Outpt="You have"+Str$(UserRecord.Gold)+ _
       " gold and"+Str$(UserRecord.Bank)+" in the bank."
       Call IO.O ' send message
       Outpt="You have borrowed"+Str$(UserRecord.Borrow)+ _
       " gold from the bank." ' make display message
       Call IO.O ' send message
    Case "B" ' option to borrow gold from bank
       Outpt="How much will you borrow(1-32767)? " ' make input prompt
       Call IO.I ' get user input
       Borrow.Amount#=Cdbl(Int(Val(Inpt))+.5) ' convert input to double
       ' compare input range
       If Borrow.Amount#<=False Or Borrow.Amount#>MaxInt Then
          Outpt="The broker says: You can't borrow that much!" ' make message
          Call IO.O ' send message
       Else ' check input range
          Outpt="The broker hands you the gold." ' make display message
          Call IO.O ' send message
          ' add gold to player gold
          UserRecord.Gold=UserRecord.Gold+Borrow.Amount#
          ' add gold to player loan
          UserRecord.Borrow=UserRecord.Borrow+Borrow.Amount#
       Endif ' end check input range
    Case "D" ' option to deposit gold in bank
       If UserRecord.Gold<=False Then ' check player gold
          Outpt="You have no gold to deposit!" ' make display message
          Call IO.O ' send message
       Else ' check player gold
          Outpt="How much(1-"+Mid$(Str$(UserRecord.Gold),2)+")? " ' prompt
          Call IO.I ' get user input
          Deposit.Amount#=Cdbl(Int(Val(Inpt))+.5) ' convert input to double
          ' compare input range
          If Deposit.Amount#<=False Or Deposit.Amount#>UserRecord.Gold Then
             Outpt="You don't have that much gold!" ' make display message
             Call IO.O ' send message
          Else ' check input range
             ' add gold to bank account
             UserRecord.Bank=UserRecord.Bank+Deposit.Amount#
             ' subtract gold from player
             UserRecord.Gold=UserRecord.Gold-Deposit.Amount#
             Outpt="You hand him the gold." ' make display message
             Call IO.O ' send message
          Endif ' end check input range
       Endif ' end check player gold
    Case "P" ' option to pay back loan
       If UserRecord.Borrow<=False Then ' check player loan
          Outpt="You don't have any loan with the bank!" ' make message
          Call IO.O ' send message
       Else ' check loan
          If UserRecord.Bank>False Then ' check player bank account
             Outpt="The broker asks: Pay back with your current bank account? "
             No.Input.Out="Y" ' default input
             Call IO.I ' get user input
             If Yes Then ' check input response
                ' compute difference between player bank account and loan
                If UserRecord.Borrow-UserRecord.Bank<=False Then ' compute
                   ' subtract loan from player bank account
                   UserRecord.Bank=UserRecord.Bank-UserRecord.Borrow ' subtract
                   UserRecord.Borrow=False ' reset loan amount
                   Outpt="The broker says: Your loan is paid off!" ' message
                   Call IO.O ' send message
                Else ' check computation
                   ' subtract player bank account from loan
                   UserRecord.Borrow=UserRecord.Borrow-UserRecord.Bank
                   UserRecord.Bank=False ' reset player bank account
                   Outpt="The broker says: Your balance paid part of the loan!"
                   Call IO.O ' send display message
                Endif ' end check loan/bank account difference
             Endif ' end check user input
          Endif ' end check player bank account
          If UserRecord.Borrow>False Then ' check player loan amount
             If UserRecord.Gold>False Then ' check player gold
                Outpt="The broker asks: Pay back with your current gold? "
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                If Yes Then ' check input response
                   ' compute difference between player gold and loan
                   If UserRecord.Borrow-UserRecord.Gold<=False Then ' compute
                      ' subtract loan from player gold
                      UserRecord.Gold=UserRecord.Gold-UserRecord.Borrow
                      UserRecord.Borrow=False ' reset loan
                      Outpt="The broker says: Your loan is paid off!" ' message
                      Call IO.O ' send message
                   Else ' check computation
                      ' subtract player gold from loan
                      UserRecord.Borrow=UserRecord.Borrow-UserRecord.Gold
                      UserRecord.Gold=False ' reset player gold
                      Outpt="The broker says: Your gold paid part of the loan!"
                      Call IO.O ' send display message
                   Endif ' end loan/player gold difference
                Endif ' end check user input
             Endif ' end check player gold
          Endif ' end check player loan
       Endif ' end check player loan
    Case "T" ' option to tranfer bank funds to another player
       If UserRecord.Bank<=False Then ' check player bank account
          Outpt="You have nothing in your account to transfer!" ' make message
          Call IO.O ' send message
       Else ' check player bank account
          Outpt="How much(1-"+Mid$(Str$(UserRecord.Bank),2)+")? " ' prompt
          Call IO.I ' get user input
          Transfer.Amount#=Cdbl(Int(Val(Inpt))+.5) ' convert input to double
          ' check input range
          If Transfer.Amount#<=False Or Transfer.Amount#>UserRecord.Bank Then
             Outpt="You don't have that much gold in the bank!" ' make message
             Call IO.O ' send message
          Else ' check input range
             Call Share.Record(UserFile,User.Index) ' write current user record
             Outpt="Transfer to what player? " ' make input prompt
             Call IO.I ' get user input
             Inpt=Ucase$(Inpt) ' uppercase input
             Inpt=Rtrim$(Inpt) ' trim input
             Player.Found=False ' reset player found flag
             For User.Number=1 To Lof(UserFile)/Len(UserRecord) ' loop file
                Call Read.Record(UserFile,User.Number) ' read user record
                Outpt=UserRecord.CodeName ' store codename
                Call Decrypt(Outpt) ' decrypt name
                Outpt=Rtrim$(Outpt) ' trim name
                If Outpt<>Deleted$ Then ' compare deleted codename
                   If Outpt<>Dead$ Then ' compare dead codename
                      If Outpt=Inpt Then ' compare codename to transfer
                         If User.Index<>User.Number Then ' check indexes
                            If (UserRecord.Flags And Locked.User)=False Then
                               Player.Found=True ' set player found flag
                               ' add amount to tranfer to player account
                               UserRecord.Bank=UserRecord.Bank+Transfer.Amount#
                               Call Share.Record(UserFile,User.Number) ' write
                               Exit For ' exit loop through user file
                            Endif ' end check locked user record
                         Endif ' end check indexes
                      Endif ' end check codename
                   Endif ' end check dead codename
                Endif ' end check deleted codename
             Next ' end loop through user file records
             If Player.Found Then ' check player found flag
                Outpt="The broker works with his ledgers for a while,"
                Call IO.O ' send display message
                Outpt="And says: "+Mid$(Str$(Transfer.Amount#),2)+ _
                " gold transferred to his account."
                Call IO.O ' send display message
             Else ' check player found flag
                Transfer.Amount#=False ' reset gold tranfered
                Outpt="There's nobody in my ledgers with that name!"
                Call IO.O ' send display message
             Endif ' end check player found flag
             Call Read.Record(UserFile,User.Index) ' read current user record
             ' subtract amount tranfered
             UserRecord.Bank=UserRecord.Bank-Transfer.Amount#
          Endif ' end check input range
       Endif ' end check player bank account
    Case "W" ' option to withdraw gold from bank account
       If UserRecord.Bank<=False Then ' check bank account
          Outpt="You have nothing to withdraw!" ' make display message
          Call IO.O ' send message
       Else ' check bank account
          If UserRecord.Borrow>False Then ' check bank loan
             Outpt="You must pay back your loan first!" ' make display message
             Call IO.O ' send message
          Else ' check bank loan
             Outpt="How much(1-"+Mid$(Str$(UserRecord.Bank),2)+")? " ' prompt
             Call IO.I ' get user input
             Withdraw.Amount#=Cdbl(Int(Val(Inpt))+.5) ' convert input to double
             If Withdraw.Amount#<=False Or _
             Withdraw.Amount#>UserRecord.Bank Then ' check input range
                Outpt="You don't have that much gold!" ' make display message
                Call IO.O ' send message
             Else ' check input range
                ' subtract from bank
                UserRecord.Bank=UserRecord.Bank-Withdraw.Amount#
                UserRecord.Gold=UserRecord.Gold+Withdraw.Amount# ' add to gold
                Outpt="The broker hands you the gold." ' make message
                Call IO.O ' send message
             Endif ' end check input range
          Endif ' end check bank loan
       Endif '  end check bank account
    Case "Q" ' option to exit bank menu
       Exit Do ' exit bank menu
    End Select ' end selection of bank option
 Loop ' end loop through bank menu
End Sub ' end bank routine
