Rem Format library in v7.0a BASIC for QB64 similar to BC7/VBDOS1 is PD 2025.
Rem   Version v1.0a:
Rem     Initial creation 09/30/2024.
Rem   Version v2.0a:
Rem     Adds StoreColor for Colorf function.
Rem     Adds KeyBoardLine$ function.
Rem     Adds Debug to StatusLine.
Rem     Adds some constants.
Rem   Version v3.0a:
Rem     Adds Control-Break trapping.
Rem     Adds statusline format strinng.
Rem     Adds titlebar timer trap.
Rem   Version v4.0a:
Rem     Adds extended LineInput$ function.
Rem   Version v5.0a:
Rem     Fixes date/time display in:
Rem      DateTimeClock$ and DateTimeClockSerial$ (serial##)
Rem   Version v6.0a:
Rem     Fixes realtime statusline display.
Rem   Version v7.0a:
Rem     Parses quotes in FormatX$ using InstrSub1 function.

' declare variables.
Dim Shared ControlBreak As Integer
Dim Shared Debug As Integer
Dim Shared Debug2 As Integer
Dim Shared ErrorChecking As Integer
Dim Shared KeyBreak As Integer
Dim Shared StatusLine2 As String
Dim Shared StoreColor As Integer
Dim Shared SyntaxError As Integer

' declare constants.
Const BackSpace = Chr$(8)
Const Ctrl.c = Chr$(3)
Const CR = Chr$(13)
Const LF = Chr$(10)
Const CRLF = Chr$(13) + Chr$(10)
Const Del = Chr$(83)
Const Esc = Chr$(27)
Const nul = ""
Const Quote = Chr$(34)
Const Semi = ";"
Const Version = "v7.0a"
Const True = -1
Const False = 0

' setup screen.
_ScreenMove _Middle
_Title "Format Utility " + Version

' set variables.
ErrorChecking = -1
StoreColor = 15
On Error GoTo ErrorRoutine

' start statusline timer trap.
GoSub StatusLine
On Timer(1) GoSub StatusLine
Timer On

' start ctrl-break timer trap.
t1 = _FreeTimer
On Timer(t1, 1) GoSub TimerTrap
Timer(t1) On
VarQ = _Exit

' start titlebar timer trap.
t2 = _FreeTimer
On Timer(t2, 1) GoSub TitleTrap
Timer(t2) On

' start program.
Colorf 14
Print "Format utility " + Version
Resume0:
Do
   Colorf 15
   Print "Menu selection:"
   Colorf 14
   Print " (D)ate/time loop"
   Print " (E)rror checking";
   If ErrorChecking Then
      Print " (on)"
   Else
      Print " (off)"
   End If
   Print " (F)ormat string"
   Print " (H)elp list"
   Print " (S)tatusline format";
   If Len(StatusLine2$) Then Print " (" + StatusLine2$ + ")";
   Print
   Print " (T)est format value"
   Print " (M)onth test"
   Print " (W)eekday test"
   Print " (V)erify date/time"
   Print " (Y)ear test"
   Print " (X)toggle titlebar"
   Print " (Z)toggle statusline"
   Colorf 15
   Print "Enter selection(Q to quit)? ";
   Locate , , 1
   Do
      _Limit 100
      If ControlBreak Then
         ControlBreak = 0
         GoTo Resume0
      End If
      x$ = InKey$
      If Len(x$) Then
         If Len(x$) = 1 Then
            If x$ = Ctrl.c Then ' ctrl-c
               Eat$ = nul
            Else
               If x$ = CR Then
                  Print
               Else
                  Print x$
               End If
               Exit Do
            End If
         End If
         If Len(x$) = 2 Then
            If x$ = Chr$(0) + Del Then
               Debug = Not Debug
            End If
         End If
      End If
   Loop
   Select Case LCase$(x$)
      Case "!" ' test an untrapped error.
         Error 999
      Case "*" ' test a syntax error
         X = Sqr(-1)
      Case "y"
         Colorf 15
         Print "Year is:"
         Colorf 14
         Y = YEAR(Now) ' Returns the year from serial number.
         Print " YEAR(Now):"; Y
         I = IsLeapYear(Y) ' Returns -1 if Y is a leapyear.
         Print " ISLEAPYEAR(" + LTrim$(Str$(Y)) + "): ";
         If I Then Print "Is leap year."
         If I = 0 Then Print "Is not leap year."
         J = DaysInYear(Y) ' Returns 365 or 366 if leapyear.
         Print " DAYSINYEAR(" + LTrim$(Str$(Y)) + "):"; J
         Call PressKey
      Case "h"
         Call DisplayFormatHelp(Var)
         If Var = 0 Then
            Call DisplayUsingHelp
         End If
      Case "x"
         Debug2 = Not Debug2
      Case "z"
         Debug = Not Debug
      Case "s"
         Colorf 15: Print "Enter statusline format: ";
         VarQ$ = LineInput$(CsrLin, Pos(0), 40)
         If VarQ$ = nul Then
            StatusLine2$ = nul
         Else
            SyntaxError = 0
            VarZ$ = VarQ$
            VarX$ = FormatX$(VarZ$)
            If SyntaxError = 0 Then
               StatusLine2$ = VarQ$
            End If
         End If
      Case "f"
         Colorf 15
         Print "Test FormatX$"
         Do
            Colorf 15: Print "Enter format(?=Help): ";
            VarQ$ = LineInput$(CsrLin, Pos(0), 40)
            If VarQ$ = nul Then Exit Do
            If VarQ$ = "?" Then
               Call DisplayFormatHelp(Var)
            Else
               SyntaxError = 0
               VarX$ = FormatX$(VarQ$)
               If SyntaxError = 0 Then
                  Colorf 14: Print "Result: "; VarX$
               End If
            End If
         Loop
      Case "v"
         Colorf 15
         Print "Test Date/Time:"
         Do
            Do
               Print "Year(0001-9999)? ";
               Y$ = KeyboardLine$
               Y% = Int(Val(Y$))
               If Y% >= 1 And Y% <= 9999 Then Exit Do
            Loop
            Do
               Print "Month(1-12)? ";
               M$ = KeyboardLine$
               M% = Int(Val(M$))
               If M% >= 1 And M% <= 12 Then Exit Do
            Loop
            Do
               V = DaysInMonth(M%)
               If M% = 2 Then ' february
                  If IsLeapYear(Y%) Then V = 29
               End If
               V$ = LTrim$(Str$(V))
               Print "Day(1-" + V$ + ")? ";
               D$ = KeyboardLine$
               D% = Int(Val(D$))
               If D% >= 1 And D% <= V Then Exit Do
            Loop
            If ValidDateNum(M%, D%, Y%) Then
               Exit Do
            End If
            Print "Invalid date."
         Loop
         Do
            Print "Hour(00-23)? ";
            H$ = KeyboardLine$
            H% = Int(Val(H$))
            If H% >= 0 And H% <= 23 Then Exit Do
         Loop
         Do
            Print "Minute(00-59)? ";
            N$ = KeyboardLine$
            N% = Int(Val(N$))
            If N% >= 0 And N% <= 59 Then Exit Do
         Loop
         Do
            Print "Second(00-59)? ";
            S$ = KeyboardLine$
            S% = Int(Val(S$))
            If S% >= 0 And S% <= 59 Then Exit Do
         Loop

         S## = DATETIMESERIAL##(H%, N%, S%, M%, D%, Y%)
         T$ = LTrim$(Str$(S##))
         If InStr(T$, ".") Then
            T1$ = Left$(T$, InStr(T$, ".") - 1)
            T2$ = Mid$(T$, InStr(T$, ".") + 1)
         Else
            T1$ = ""
            T2$ = T$
         End If
         T1$ = Right$("000000" + T1$, 6)

         Colorf 14
         Print "Serial: "; T1$; "."; T2$
         Print "Clock: "; DateTimeClockSerial$(S##)
         Print FORMATDATE$(S##); " "; FORMATTIME$(S##)
         Call PressKey
      Case "m"
         Colorf 15
         Print "Month is:"
         Colorf 14

         Print "  MONTHSHORT(MONTH(Now)) = ";
         Print MONTHSHORT(MONTH(Now))

         Print "  MONTHLONG(MONTH(Now)) = ";
         Print MONTHLONG(MONTH(Now))

         Colorf 15
         Print " Serial:"
         Colorf 14

         Print "  MONTHSHORTSERIAL(Now) = ";
         Print MONTHSHORTSERIAL(Now)

         Print "  MONTHLONGSERIAL(Now) = ";
         Print MONTHLONGSERIAL(Now)
         Call PressKey
      Case "w"
         Colorf 15
         Print "Weekday is:"
         Colorf 14

         Print "  WEEKDAYSHORT(MONTH(Now), DAY(Now), YEAR(Now)) = ";
         Print WEEKDAYSHORT(MONTH(Now), DAY(Now), YEAR(Now))

         Print "  WEEKDAYLONG(MONTH(Now), DAY(Now), YEAR(Now)) = ";
         Print WEEKDAYLONG(MONTH(Now), DAY(Now), YEAR(Now))

         Colorf 15
         Print " Serial:"
         Colorf 14

         Print "  WEEKDAYSHORTSERIAL(Now) = ";
         Print WEEKDAYSHORTSERIAL(Now)

         Print "  WEEKDAYLONGSERIAL(Now) = ";
         Print WEEKDAYLONGSERIAL(Now)
         Call PressKey
      Case "e"
         Colorf 14
         ErrorStart:
         Print "Error checking(y/n)?";
         Do
            _Limit 100
            If ControlBreak Then
               ControlBreak = 0
               Var$ = nul
               GoTo ErrorStart
            End If
            x$ = LCase$(InKey$)
            If x$ = "y" Then
               ErrorChecking = -1
               Exit Do
            End If
            If x$ = "n" Then
               ErrorChecking = 0
               Exit Do
            End If
         Loop
         Print x$
         If ErrorChecking Then
            Print "Error checking is on."
         Else
            Print "Error checking is off."
         End If
         Call PressKey
      Case "t"
         Colorf 15
         Print "Test Print Using"
         Colorf 14
         StartFormat:
         Do
            Colorf 15: Print "Test format(?=Help): ";
            f$ = LineInput$(CsrLin, Pos(0), 40)
            If f$ = "?" Then Call DisplayUsingHelp: GoTo StartFormat
            If f$ = nul Then
               Print "Use default values(y/n/q)? ";
               Do
                  _Limit 50
                  If ControlBreak Then
                     ControlBreak = 0
                     L = 0: F1$ = "######.#########": z$ = "now"
                     Print: GoTo NextFormat
                  End If
                  x$ = InKey$
                  If Len(x$) Then
                     x$ = LCase$(x$)
                     If x$ = "n" Then Print: GoTo StartFormat
                     If x$ = "q" Then Print: Exit Do
                     If x$ = "y" Then
                        L = 0: F1$ = "######.#########": z$ = "now"
                        Print: GoTo NextFormat
                     End If
                  End If
               Loop
               Exit Do
            End If
            g$ = PreParse(f$)
            L = CountSemicolons(g$)
            If L <= 2 Then
               Call GetFormat(F1$, F2$, F3$, g$)
               Print "Test value(Now): ";
               z$ = LineInput$(CsrLin, Pos(0), 40)
               If z$ = nul Then z$ = "now"
               NextFormat:
               Colorf 14: Print "Print Using:"
               If LCase$(z$) = "now" Then
                  If L = 0 Then
                     Print "Format: "; F1$; " Value: Now"
                     Print "Result:";: Print Using F1$; Now
                  End If
                  If L = 1 Then
                     Print "Format: "; F1$; Semi; F2$; " Value: Now"
                     Print "Result:";: Print Using F1$ + Semi + F2$; Now
                  End If
                  If L = 2 Then
                     Print "Format: "; F1$; Semi; F2$; Semi; F3$; " Value: Now"
                     Print "Result:";: Print Using F1$ + Semi + F2$ + Semi + F3$; Now
                  End If
               Else
                  z = Val(z$)
                  If L = 0 Then
                     Print "Format: "; F1$; " Value:"; z
                     Print "Result:";: Print Using F1$; z
                  End If
                  If L = 1 Then
                     Print "Format: "; F1$; Semi; F2$; " Value:"; z
                     Print "Result:";: Print Using F1$ + Semi + F2$; z
                  End If
                  If L = 2 Then
                     Print "Format: "; F1$; Semi; F2$; Semi; F3$; " Value:"; z
                     Print "Result:";: Print Using F1$ + Semi + F2$ + Semi + F3$; z
                  End If
               End If
            End If
         Loop
      Case "d"
         Cls
         Do
            _Delay 1
            If InKey$ = Esc Then Exit Do
            If ControlBreak Then
               ControlBreak = 0
               Exit Do
            End If
            Locate 1, 1, 1
            Colorf 12
            Print "Press <escape> to quit."
            Colorf 15
            Print "Current date/time is:"; Now; DateTimeClockSerial$(Now)
            Colorf 14
            S$ = "FORMATDATE$(Now); " + Quote + " " + Quote + "; FORMATTIME$(Now)"
            Colorf 10: Print S$; " = ";
            Colorf 11: Print FORMATDATE$(Now); " "; FORMATTIME$(Now)

            S$ = "PRINT MONTH(Now); " + Quote + "-" + Quote + "; DAY(Now); " + Quote + "-" + Quote + "; YEAR(Now)"
            Colorf 10: Print S$; " = ";
            Colorf 11
            Print Right$("00" + LTrim$(Str$(MONTH(Now))), 2);
            Print "-";
            Print Right$("00" + LTrim$(Str$(DAY(Now))), 2);
            Print "-";
            Print Right$("0000" + LTrim$(Str$(YEAR(Now))), 4)

            S$ = "PRINT HOUR(Now); " + Quote + ":" + Quote + "; MINUTE(Now); " + Quote + ":" + Quote + "; SECOND(Now)"
            Colorf 10: Print S$; " = ";
            Colorf 11
            Print Right$("00" + LTrim$(Str$(HOUR(Now))), 2);
            Print ":";
            Print Right$("00" + LTrim$(Str$(MINUTE(Now))), 2);
            Print ":";
            Print Right$("00" + LTrim$(Str$(SECOND(Now))), 2)

            Print
            Colorf 10: S$ = "D## = DATEVALUE(DATE$): T## = TIMEVALUE(TIME$)": Print S$
            S$ = "PRINT FORMATDATE$(D##); " + Quote + " " + Quote + "; FORMATTIME$(T##)": Print S$
            D## = DATEVALUE(Date$): T## = TIMEVALUE(Time$)
            Colorf 11: Print FORMATDATE$(D##); " "; FORMATTIME$(T##)

            Print
            Colorf 10: S$ = "D## = DATESERIAL(MONTH(Now), DAY(Now), YEAR(Now))": Print S$
            S$ = "T## = TIMESERIAL(HOUR(Now), MINUTE(Now), SECOND(Now))": Print S$
            S$ = "PRINT FORMATDATE$(D##); " + Quote + " " + Quote + "; PRINT FORMATTIME$(T##)"
            Print S$

            D## = DATESERIAL(MONTH(Now), DAY(Now), YEAR(Now))
            T## = TIMESERIAL(HOUR(Now), MINUTE(Now), SECOND(Now))
            Colorf 11: Print FORMATDATE$(D##); " "; FORMATTIME$(T##)
         Loop
      Case "q"
         Exit Do
   End Select
Loop
Colorf 7
End

' timer titlebar trap.
TitleTrap:
If Debug2 Then
   _Title "Format Utility " + Version + " " + Date$ + " " + Time$
Else
   _Title "Format Utility " + Version
End If
Return

' timer ctrl-break trap.
TimerTrap:
VarQ = _Exit
If VarQ Then ' Control-Break
   Color 15
   Print
   Print "Break (Q)uit/(R)esume:";
   Do
      x$ = InKey$
      If Len(x$) Then
         If LCase$(x$) = "q" Then
            Color 7, 0
            Print
            End
         End If
         If LCase$(x$) = "r" Then
            ControlBreak = -1
            KeyBreak = -1
            If Pos(0) > 1 Then
               Print
            End If
            Colorf StoreColor
            Return
         End If
         If LCase$(x$) = "z" Then
            Debug = Not Debug
         End If
      End If
   Loop
End If
Return

StatusLine:
X = CsrLin: Y = Pos(0)
Locate 25, 1
Color 15, 1
Var$ = "Format Utility " + Version + " " + Date$ + " " + Time$
If Debug Then
   Var$ = Var$ + " - " + DateTimeClock$
End If

StoreChecking = ErrorChecking
ErrorChecking = 0
VarQ$ = nul
If Len(StatusLine2$) Then
   SyntaxError = 0
   VarZ$ = StatusLine2$
   VarX$ = FormatX$(VarZ$)
   If SyntaxError = 0 Then
      VarQ$ = VarX$
   End If
End If
ErrorChecking = StoreChecking

If Len(VarQ$) Then
   If Len(Var$) + Len(VarQ$) + 1 < 80 Then
      Var$ = Var$ + " " + VarQ$
   End If
End If
Var$ = Left$(Var$, 80)
Var$ = Var$ + Space$(80 - Len(Var$))
Print Var$;
Locate X, Y, 1
Color StoreColor, 0
Return

ErrorRoutine:
Colorf 12
SyntaxError = -1
If Err = 5 Then
   If Pos(0) > 1 Then
      Print
   End If
   Print "Syntax error. Line:"; _ErrorLine
   Resume Next
End If
If Err = 92 Then
   Print "Syntax error in TIME$"
   Resume Next
End If
If Err = 93 Then
   Print "Syntax error in DATE$"
   Resume Next
End If
If Err = 94 Then
   Print "Syntax error in binary parse in FORMATX$"
   Resume Next
End If
If Err = 95 Then
   Print "Syntax error in octal parse in FORMATX$"
   Resume Next
End If
If Err = 96 Then
   Print "Syntax error in hexidecimal parse in FORMATX$"
   Resume Next
End If
If Err = 97 Then
   Print "Syntax error in quote parse in FORMATX$"
   Resume Next
End If
If Err = 98 Then
   Print "Syntax error in semicolons parse in FORMATX$"
   Resume Next
End If
If Err = 100 Then
   Print "Syntax error in month parser in FORMATX$"
   Resume Next
End If
If Err = 101 Then
   Print "Syntax error in year parser in FORMATX$"
   Resume Next
End If
If Err = 102 Then
   Print "Syntax error in time parser in FORMATX$"
   Resume Next
End If
If Err = 103 Then
   Print "Syntax error in day parser in FORMATX$"
   Resume Next
End If
If Err = 104 Then
   Print "Syntax error in hour parser in FORMATX$"
   Resume Next
End If
If Err = 105 Then
   Print "Syntax error in second parser in FORMATX$"
   Resume Next
End If
If Err = 106 Then
   Print "Syntax error in minute parser in FORMATX$"
   Resume Next
End If
Print "Critical error:"; Err; "in line:"; _ErrorLine
Colorf 15
Resume Resume0

' List of all 34 date/time functions.
'
' NOW() Returns a serial number of current date/time.
'  Year between 1753 and 2078 increased to 0001 and 9999.

' FORMATX$(expression, fmt$) Formats a value to a string format.

' MONTH(serial) Returns the month from a serial number
' DAY(serial) Returns the day of the month from a serial number
' YEAR(serial) Returns the year from serial number

' MONTHSHORT(month%) Returns the month from m% argument
' MONTHSHORTSERIAL(serial) Returns the month from serial number

' MONTHLONG(month%) Returns the month from m% argument
' MONTHLONGSERIAL(serial) Returns the month from serial number

' WEEKDAY(month%, day%, year%) Returns the day of the week from m%, d%, y% arguments
' WEEKDAYSERIAL(serial) Returns the day of the week from serial number

' WEEKDAYSHORT(month%, day%, year%) Returns the short name day of the week from m%, d%, y% arguments
' WEEKDAYSHORTSERIAL(serial) Returns the short name day of the week from serial number

' WEEKDAYLONG(month%, day%, year%) Returns the long name day of the week from m%, d%, y% arguments
' WEEKDAYLONGSERIAL(serial) Returns the long name day of the week from serial number

' HOUR(serial) Returns the hour from a serial number
' MINUTE(serial) Returns the minute from a serial number
' SECOND(serial) Returns the seconds from a serial number

' DATESERIAL(month%, day%, year%) Returns a serial number from m%, d%, y% arguments
' TIMESERIAL(hour%, minute%, second%) Returns a serial number from h%, m%, s% arguments

' DATEVALUE(date$) Returns a serial number from a date string
' TIMEVALUE(time$) Returns a serial number from a time string

' DATETIMECLOCK$()  Returns a formatted string of the current date/time
' DATETIMECLOCKSERIAL$(serial)  Returns a formatted string of the sepcified date/time
' DATETIMESERIAL(hour%, minute%, second%, month%, day%, year%)

' FORMATDATE$(serial) Returns a formatted date string from a serial number
' FORMATTIME$(serial) Returns a formatted time string from a serial number

' ISLEAPYEAR(Y) Returns -1 if Y is a leapyear.

' DAYSINMONTH (month%) Returns days in a month, February is 28.
' DAYSINWEEK (Z%) Returns 7
' MONTHSINYEAR (Z%) Returns 12
' DAYSINYEAR (year%) Returns 365 or 366 if leapyear
' DAYOFYEAR (month%, day%, year%) Returns day of the year
' DAYOFYEARSERIAL (serial) Returns day of the serial date

Function PreParse$ (fmt$)
   fmtout$ = nul
   fmttmp$ = fmt$
   P1 = 0: P2 = 0
   Do
      P1 = P1 + 1
      If P1 > Len(fmttmp$) Then Exit Do
      If Mid$(fmttmp$, P1, 1) = "\" Then
         P2 = P1 + 1
         If P2 > Len(fmttmp$) Then Exit Do
         Select Case Mid$(fmttmp$, P2, 1)
            Case "b" ' binary
               flag = 0
               C = 0
               P$ = nul
               Do
                  P2 = P2 + 1
                  If P2 > Len(fmttmp$) Then Exit Do
                  C = C + 1
                  If C > 8 Then
                     Exit Do
                  End If
                  V$ = Mid$(fmttmp$, P2, 1)
                  If V$ = "0" Or V$ = "1" Then
                     flag = -1
                     P$ = P$ + V$
                  Else
                     Exit Do
                  End If
                  If Val("&B" + P$) > 255 Then
                     If ErrorChecking Then
                        Error 94
                     End If
                     Exit Function
                  End If
               Loop
               If flag Then
                  fmttmp$ = Left$(fmttmp$, P1 - 1) + Chr$(Val("&B" + P$)) + Mid$(fmttmp$, P2)
                  P1 = P1 + Len(P$) - 2
               Else
                  P1 = P2
               End If
            Case "o" ' octal
               flag = 0
               C = 0
               P$ = nul
               Do
                  P2 = P2 + 1
                  If P2 > Len(fmttmp$) Then Exit Do
                  C = C + 1
                  If C > 3 Then
                     Exit Do
                  End If
                  V$ = Mid$(fmttmp$, P2, 1)
                  If V$ >= "0" And V$ <= "7" Then
                     flag = -1
                     P$ = P$ + V$
                  Else
                     Exit Do
                  End If
                  If Val("&O" + P$) > 255 Then
                     If ErrorChecking Then
                        Error 95
                     End If
                     Exit Function
                  End If
               Loop
               If flag Then
                  fmttmp$ = Left$(fmttmp$, P1 - 1) + Chr$(Val("&O" + P$)) + Mid$(fmttmp$, P2)
                  P1 = P1 + Len(P$) - 2
               Else
                  P1 = P2
               End If
            Case "x" ' hexidecimal
               flag = 0
               C = 0
               P$ = nul
               Do
                  P2 = P2 + 1
                  If P2 > Len(fmttmp$) Then Exit Do
                  C = C + 1
                  If C > 2 Then
                     Exit Do
                  End If
                  V$ = UCase$(Mid$(fmttmp$, P2, 1))
                  Select Case V$
                     Case "0" To "9", "A" To "F"
                        flag = -1
                        P$ = P$ + V$
                     Case Else
                        Exit Do
                  End Select
                  If Val("&H" + P$) > 255 Then
                     If ErrorChecking Then
                        Error 96
                     End If
                     Exit Function
                  End If
               Loop
               If flag Then
                  fmttmp$ = Left$(fmttmp$, P1 - 1) + Chr$(Val("&H" + P$)) + Mid$(fmttmp$, P2)
                  P1 = P1 + Len(P$) - 2
               Else
                  P1 = P2
               End If
         End Select
      End If
   Loop
   PreParse$ = fmttmp$
End Function

Sub GetFormat (F1$, F2$, F3$, fmt$)
   ' returns format string separated by semicolons
   F1$ = nul: F2$ = nul: F3$ = nul
   P1 = 0
   Do
      P1 = P1 + 1
      If P1 >= Len(fmt$) Then
         L = L + 1
         Select Case L
            Case 1
               F1$ = fmt$
            Case 2
               F2$ = fmt$
            Case 3
               F3$ = fmt$
         End Select
         Exit Do
      End If
      If Mid$(fmt$, P1, 1) = "\" Then ' skip any char after backslash
         P1 = P1 + 1
      Else
         If Mid$(fmt$, P1, 1) = Quote Then ' skip any matching quotes
            P1 = InStr(P1 + 1, fmt$, Quote)
         Else
            If Mid$(fmt$, P1, 1) = Semi Then
               L = L + 1
               Select Case L
                  Case 1
                     F1$ = Left$(fmt$, P1 - 1)
                  Case 2
                     F2$ = Left$(fmt$, P1 - 1)
                  Case 3
                     F3$ = Left$(fmt$, P1 - 1)
               End Select
               fmt$ = Mid$(fmt$, P1 + 1)
               P1 = 0
            End If
         End If
      End If
   Loop
End Sub

' One section only
'   The format applies to all numbers
' Two sections
'   The first section applies to positive numbers
'   and zeros; the second to negative numbers
' Three sections
'   The first section applies to positive numbers,
'   the second to negative numbers, the third to zeros
Function CountSemicolons (fmt$)
   ' remove special escape code
   fmttmp$ = fmt$
   Do
      V = InStr(fmttmp$, "\;")
      If V Then
         fmttmp$ = Left$(fmttmp$, V - 1) + Mid$(fmttmp$, V + 2)
      Else
         Exit Do
      End If
   Loop
   ' remove and test strings in quotes
   Do
      V1 = InStr(fmttmp$, Quote)
      If V1 Then
         V2 = InStr(V1 + 1, fmttmp$, Quote)
         If V2 Then
            fmttmp$ = Left$(fmttmp$, V1 - 1) + Mid$(fmttmp$, V2 + 1)
         Else
            If ErrorChecking Then
               Error 97
            End If
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop
   ' count remaining semicolons in string
   V1 = 0
   Do
      V1 = InStr(V1 + 1, fmttmp$, Semi)
      If V1 Then
         C = C + 1
      Else
         Exit Do
      End If
   Loop
   If C > 2 Then
      If ErrorChecking Then
         Error 98
      End If
   End If
   CountSemicolons = C
End Function

' Returns a formatted date from a serial number
Function FORMATDATE$ (serial##) ' yyyy mm dd 1
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)

   M% = Val(Mid$(S$, 5, 2))
   D% = Val(Mid$(S$, 7, 2))
   Y% = Val(Mid$(S$, 1, 4))
   FORMATDATE$ = Right$("00" + LTrim$(Str$(M%)), 2) + "-" + Right$("00" + LTrim$(Str$(D%)), 2) + "-" + Right$("0000" + LTrim$(Str$(Y%)), 4)
End Function

' Returns a formatted time from a serial number
Function FORMATTIME$ (serial##) ' hh mm ss
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Left$(S$, InStr(S$, ".") - 1)
   End If
   S$ = Right$("000000" + S$, 6)
   H% = Val(Mid$(S$, 1, 2))
   M% = Val(Mid$(S$, 3, 2))
   S% = Val(Mid$(S$, 5, 2))
   FORMATTIME$ = Right$("00" + LTrim$(Str$(H%)), 2) + ":" + Right$("00" + LTrim$(Str$(M%)), 2) + ":" + Right$("00" + LTrim$(Str$(S%)), 2)
End Function

' Returns the hour from a serial number
Function HOUR% (serial##) ' FF 00 00
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Left$(S$, InStr(S$, ".") - 1)
   End If
   S$ = Right$("000000" + S$, 6)
   H% = Val(Mid$(S$, 1, 2))
   HOUR% = H%
End Function

' Returns the minute from a serial number
Function MINUTE% (serial##) ' 00 FF 00
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Left$(S$, InStr(S$, ".") - 1)
   End If
   S$ = Right$("000000" + S$, 6)
   M% = Val(Mid$(S$, 3, 2))
   MINUTE% = M%
End Function

' Returns the seconds from a serial number
Function SECOND% (serial##) ' 00 00 FF
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Left$(S$, InStr(S$, ".") - 1)
   End If
   S$ = Right$("000000" + S$, 6)
   S% = Val(Mid$(S$, 5, 2))
   SECOND% = S%
End Function

' Returns the month from a serial number
Function MONTH% (serial##) ' 0000 FF 00 1
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   S% = Val(Mid$(S$, 5, 2))
   MONTH% = S%
End Function

' Returns the day of the month from a serial number
Function DAY% (serial##) ' 0000 00 FF 1
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   S% = Val(Mid$(S$, 7, 2))
   DAY% = S%
End Function

' Returns the year from serial number
Function YEAR% (serial##) ' FFFF 00 00 1
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   S% = Val(Mid$(S$, 1, 4))
   YEAR% = S%
End Function

' Returns the day of the week from serial number (sunday=0)
Function WEEKDAYSERIAL% (serial##) ' yyyy mm dd 1
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   M% = Val(Mid$(S$, 5, 2))
   D% = Val(Mid$(S$, 7, 2))
   Y% = Val(Mid$(S$, 1, 4))
   If M% < 3 Then M% = M% + 12: Y% = Y% - 1
   WEEKDAYSERIAL% = ((13 * M% + 3) \ 5 + D% + Y% + Y% \ 4 - Y% \ 100 + Y% \ 400 + 1) Mod 7
End Function

' Returns the day of the week from m%, d%, y% arguments
Function WEEKDAY% (m%, d%, y%)
   D1$ = Right$("00" + LTrim$(Str$(m%)), 2)
   D2$ = Right$("00" + LTrim$(Str$(d%)), 2)
   D3$ = Right$("0000" + LTrim$(Str$(y%)), 4)

   S$ = D1$ + "-" + D2$ + "-" + D3$
   If ValidDate(S$) = 0 Then
      If ErrorChecking Then
         Error 93
      End If
   End If
   m% = Val(D1$)
   d% = Val(D2$)
   y% = Val(D3$)
   If m% < 3 Then m% = m% + 12: y% = y% - 1
   WEEKDAY% = ((13 * m% + 3) \ 5 + d% + y% + y% \ 4 - y% \ 100 + y% \ 400 + 1) Mod 7
End Function

' Returns the short name day of the week from m%, d%, y% arguments
Function WEEKDAYSHORT$ (m%, d%, y%)
   D1$ = Right$("00" + LTrim$(Str$(m%)), 2)
   D2$ = Right$("00" + LTrim$(Str$(d%)), 2)
   D3$ = Right$("0000" + LTrim$(Str$(y%)), 4)

   S$ = D1$ + "-" + D2$ + "-" + D3$
   If ValidDate(S$) = 0 Then
      If ErrorChecking Then
         Error 93
      End If
   End If
   m% = Val(D1$)
   d% = Val(D2$)
   y% = Val(D3$)
   If m% < 3 Then m% = m% + 12: y% = y% - 1
   W% = ((13 * m% + 3) \ 5 + d% + y% + y% \ 4 - y% \ 100 + y% \ 400 + 1) Mod 7
   Select Case W%
      Case 0
         WEEKDAYSHORT$ = "Sun"
      Case 1
         WEEKDAYSHORT$ = "Mon"
      Case 2
         WEEKDAYSHORT$ = "Tue"
      Case 3
         WEEKDAYSHORT$ = "Wed"
      Case 4
         WEEKDAYSHORT$ = "Thu"
      Case 5
         WEEKDAYSHORT$ = "Fri"
      Case 6
         WEEKDAYSHORT$ = "Sat"
   End Select
End Function

' Returns the short name of the month from m% argument
Function MONTHSHORT$ (m%)
   If m% >= 1 And m% <= 12 Then
      Select Case m%
         Case 1
            MONTHSHORT$ = "Jan"
         Case 2
            MONTHSHORT$ = "Feb"
         Case 3
            MONTHSHORT$ = "Mar"
         Case 4
            MONTHSHORT$ = "Apr"
         Case 5
            MONTHSHORT$ = "May"
         Case 6
            MONTHSHORT$ = "Jun"
         Case 7
            MONTHSHORT$ = "Jul"
         Case 8
            MONTHSHORT$ = "Aug"
         Case 9
            MONTHSHORT$ = "Sep"
         Case 10
            MONTHSHORT$ = "Oct"
         Case 11
            MONTHSHORT$ = "Nov"
         Case 12
            MONTHSHORT$ = "Dec"
      End Select
   End If
End Function

' Returns the long name of the month from m% argument
Function MONTHLONG$ (m%)
   If m% >= 1 And m% <= 12 Then
      Select Case m%
         Case 1
            MONTHLONG$ = "January"
         Case 2
            MONTHLONG$ = "February"
         Case 3
            MONTHLONG$ = "March"
         Case 4
            MONTHLONG$ = "April"
         Case 5
            MONTHLONG$ = "May"
         Case 6
            MONTHLONG$ = "June"
         Case 7
            MONTHLONG$ = "July"
         Case 8
            MONTHLONG$ = "August"
         Case 9
            MONTHLONG$ = "September"
         Case 10
            MONTHLONG$ = "October"
         Case 11
            MONTHLONG$ = "November"
         Case 12
            MONTHLONG$ = "December"
      End Select
   End If
End Function

' Returns the short name day of the week from serial number
Function WEEKDAYSHORTSERIAL$ (serial##)
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   M% = Val(Mid$(S$, 5, 2))
   D% = Val(Mid$(S$, 7, 2))
   Y% = Val(Mid$(S$, 1, 4))
   If M% < 3 Then M% = M% + 12: Y% = Y% - 1
   W% = ((13 * M% + 3) \ 5 + D% + Y% + Y% \ 4 - Y% \ 100 + Y% \ 400 + 1) Mod 7
   Select Case W%
      Case 0
         WEEKDAYSHORTSERIAL$ = "Sun"
      Case 1
         WEEKDAYSHORTSERIAL$ = "Mon"
      Case 2
         WEEKDAYSHORTSERIAL$ = "Tue"
      Case 3
         WEEKDAYSHORTSERIAL$ = "Wed"
      Case 4
         WEEKDAYSHORTSERIAL$ = "Thu"
      Case 5
         WEEKDAYSHORTSERIAL$ = "Fri"
      Case 6
         WEEKDAYSHORTSERIAL$ = "Sat"
   End Select
End Function

' Returns the short name of the month from serial number
Function MONTHSHORTSERIAL$ (serial##)
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   M% = Val(Mid$(S$, 5, 2))
   If M% >= 1 And M% <= 12 Then
      Select Case M%
         Case 1
            MONTHSHORTSERIAL$ = "Jan"
         Case 2
            MONTHSHORTSERIAL$ = "Feb"
         Case 3
            MONTHSHORTSERIAL$ = "Mar"
         Case 4
            MONTHSHORTSERIAL$ = "Apr"
         Case 5
            MONTHSHORTSERIAL$ = "May"
         Case 6
            MONTHSHORTSERIAL$ = "Jun"
         Case 7
            MONTHSHORTSERIAL$ = "Jul"
         Case 8
            MONTHSHORTSERIAL$ = "Aug"
         Case 9
            MONTHSHORTSERIAL$ = "Sep"
         Case 10
            MONTHSHORTSERIAL$ = "Oct"
         Case 11
            MONTHSHORTSERIAL$ = "Nov"
         Case 12
            MONTHSHORTSERIAL$ = "Dec"
      End Select
   End If
End Function

' Returns the long name of the month from serial number
Function MONTHLONGSERIAL$ (serial##)
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   M% = Val(Mid$(S$, 5, 2))
   If M% >= 1 And M% <= 12 Then
      Select Case M%
         Case 1
            MONTHLONGSERIAL$ = "January"
         Case 2
            MONTHLONGSERIAL$ = "February"
         Case 3
            MONTHLONGSERIAL$ = "March"
         Case 4
            MONTHLONGSERIAL$ = "April"
         Case 5
            MONTHLONGSERIAL$ = "May"
         Case 6
            MONTHLONGSERIAL$ = "June"
         Case 7
            MONTHLONGSERIAL$ = "July"
         Case 8
            MONTHLONGSERIAL$ = "August"
         Case 9
            MONTHLONGSERIAL$ = "September"
         Case 10
            MONTHLONGSERIAL$ = "October"
         Case 11
            MONTHLONGSERIAL$ = "November"
         Case 12
            MONTHLONGSERIAL$ = "December"
      End Select
   End If
End Function

' Returns the long name day of the week from m%, d%, y% arguments
Function WEEKDAYLONG$ (m%, d%, y%)
   D1$ = Right$("00" + LTrim$(Str$(m%)), 2)
   D2$ = Right$("00" + LTrim$(Str$(d%)), 2)
   D3$ = Right$("0000" + LTrim$(Str$(y%)), 4)

   S$ = D1$ + "-" + D2$ + "-" + D3$
   If ValidDate(S$) = 0 Then
      If ErrorChecking Then
         Error 93
      End If
   End If
   m% = Val(D1$)
   d% = Val(D2$)
   y% = Val(D3$)
   If m% < 3 Then m% = m% + 12: y% = y% - 1
   W% = ((13 * m% + 3) \ 5 + d% + y% + y% \ 4 - y% \ 100 + y% \ 400 + 1) Mod 7
   Select Case W%
      Case 0
         WEEKDAYLONG$ = "Sunday"
      Case 1
         WEEKDAYLONG$ = "Monday"
      Case 2
         WEEKDAYLONG$ = "Tuesday"
      Case 3
         WEEKDAYLONG$ = "Wednesday"
      Case 4
         WEEKDAYLONG$ = "Thursday"
      Case 5
         WEEKDAYLONG$ = "Friday"
      Case 6
         WEEKDAYLONG$ = "Saturday"
   End Select
End Function

' Returns the long name day of the week from serial number
Function WEEKDAYLONGSERIAL$ (serial##)
   S$ = LTrim$(Str$(serial##))
   If InStr(S$, ".") Then
      S$ = Mid$(S$, InStr(S$, ".") + 1)
   End If
   S$ = Right$("000000000" + S$, 9)
   M% = Val(Mid$(S$, 5, 2))
   D% = Val(Mid$(S$, 7, 2))
   Y% = Val(Mid$(S$, 1, 4))
   If M% < 3 Then M% = M% + 12: Y% = Y% - 1
   W% = ((13 * M% + 3) \ 5 + D% + Y% + Y% \ 4 - Y% \ 100 + Y% \ 400 + 1) Mod 7
   Select Case W%
      Case 0
         WEEKDAYLONGSERIAL$ = "Sunday"
      Case 1
         WEEKDAYLONGSERIAL$ = "Monday"
      Case 2
         WEEKDAYLONGSERIAL$ = "Tuesday"
      Case 3
         WEEKDAYLONGSERIAL$ = "Wednesday"
      Case 4
         WEEKDAYLONGSERIAL$ = "Thursday"
      Case 5
         WEEKDAYLONGSERIAL$ = "Friday"
      Case 6
         WEEKDAYLONGSERIAL$ = "Saturday"
   End Select
End Function

' Returns a serial number from m%, d%, y% arguments
Function DATESERIAL## (m%, d%, y%)
   If ValidDateNum(m%, d%, y%) = 0 Then
      If ErrorChecking Then
         Error 93
      End If
   End If

   D## = y% * 10000 + m% * 100 + d%
   D## = D## * 10 + 1
   DATESERIAL## = D##
End Function

' Returns a serial number from h%, m%, s% arguments
Function TIMESERIAL## (h%, m%, s%)
   If ValidTimeNum(h%, m%, s%) = 0 Then
      If ErrorChecking Then
         Error 92
      End If
   End If

   T## = h% * 10000 + m% * 100 + s%
   TIMESERIAL## = T##
End Function

' Returns a serial number from time/date arguments
Function DATETIMESERIAL## (h%, n%, s%, m%, d%, y%)
   If ValidDateNum(m%, d%, y%) = 0 Then
      If ErrorChecking Then
         Error 93
      End If
   End If

   D## = y% * 10000 + m% * 100 + d%
   D## = D## * 10 + 1

   If ValidTimeNum(h%, n%, s%) = 0 Then
      If ErrorChecking Then
         Error 92
      End If
   End If

   T## = h% * 10000 + n% * 100 + s%

   S## = Val(LTrim$(Str$(T##)) + "." + LTrim$(Str$(D##)))
   DATETIMESERIAL## = S##
End Function

' Returns a serial number from a date string
Function DATEVALUE## (d$)
   If ValidDate(d$) = 0 Then
      If ErrorChecking Then
         Error 93
      End If
   End If
   M% = Val(Mid$(d$, 1, 2))
   D% = Val(Mid$(d$, 4, 2))
   Y% = Val(Mid$(d$, 7, 4))

   D## = Y% * 10000 + M% * 100 + D%
   D## = D## * 10 + 1
   DATEVALUE## = D##
End Function

' Returns a serial number from a time string
Function TIMEVALUE## (t$)
   ' "23:59:59" "2:24PM" or "14:24"
   S$ = RTrim$(t$): S$ = UCase$(S$)
   If Right$(S$, 2) = "PM" Then
      PM = -1
      S$ = Left$(S$, Len(S$) - 2)
   End If
   If Right$(S$, 2) = "AM" Then
      AM = -1
      S$ = Left$(S$, Len(S$) - 2)
   End If

   L1 = InStr(S$, ":")
   L2 = InStr(L1 + 1, S$, ":")

   If L1 Then
      H% = Val(Left$(S$, L1 - 1))
      If L2 = 0 Then
         M% = Val(Mid$(S$, L1 + 1))
      Else
         U$ = Left$(S$, L2 - 1)
         M% = Val(Mid$(U$, L1 + 1))
      End If
   Else
      H% = Val(S$)
   End If
   If L2 Then
      S% = Val(Mid$(S$, L2 + 1))
   End If
   If PM Then
      If H% <= 11 Then H% = H% + 12
   End If

   If ValidTimeNum(H%, M%, S%) = 0 Then
      If ErrorChecking Then
         Error 92
      End If
   End If

   T## = H% * 10000 + M% * 100 + S%
   TIMEVALUE## = T##
End Function

' Returns a serial number of current date/time.
Function Now##
   ' HH:MM:SS - &HFF FF FF  (left of decimal)
   ' YYYY/MM/DD - &HFFFF FF FF 1 (right of decimal)

   T$ = Time$
   D$ = Date$

   H% = Val(Mid$(T$, 1, 2))
   M% = Val(Mid$(T$, 4, 2))
   S% = Val(Mid$(T$, 7, 2))

   T## = H% * 10000 + M% * 100 + S%

   M% = Val(Mid$(D$, 1, 2))
   D% = Val(Mid$(D$, 4, 2))
   Y% = Val(Mid$(D$, 7, 4))

   ' make date with least significant byte
   D## = Y% * 10000 + M% * 100 + D%
   D## = D## * 10 + 1

   ' S## is 15-digit float accuracy of HHMMSS.YYYYMMDDb
   '  Year between 1753 and 2078 increased to 0001 and 9999.
   S## = Val(LTrim$(Str$(T##)) + "." + LTrim$(Str$(D##)))
   Now## = S##
End Function

Function ValidDate (Var$)
   ' mm-dd-yyyy
   Var$ = RTrim$(Var$)
   If Len(Var$) <> 10 Then
      ValidDate = False
      Exit Function
   End If
   For Var = 1 To 10
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8, 9, 10
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = nul
            Else
               ValidDate = False
               Exit Function
            End If
         Case Else
            If V$ <> "-" Then
               ValidDate = False
               Exit Function
            End If
      End Select
   Next
   M = Int(Val(Mid$(Var$, 1, 2)))
   D = Int(Val(Mid$(Var$, 4, 2)))
   Y = Int(Val(Mid$(Var$, 7, 4)))
   If M >= 1 And M <= 12 Then
      If D >= 1 And D <= 31 Then
         If Y >= 1 And Y <= 9999 Then
            ' set leapyear flag
            L = IsLeapYear(Y)
            Select Case M
               Case 1, 3, 5, 7, 8, 10, 12
                  If D <= 31 Then
                     ValidDate = -1
                     Exit Function
                  End If
               Case 4, 6, 9, 11
                  If D <= 30 Then
                     ValidDate = -1
                     Exit Function
                  End If
               Case 2
                  If L Then
                     If D <= 29 Then
                        ValidDate = -1
                        Exit Function
                     End If
                  End If
                  If D <= 28 Then
                     ValidDate = -1
                     Exit Function
                  End If
            End Select
         End If
      End If
   End If
   ValidDate = 0
End Function

Function ValidDateNum (m%, d%, y%)
   ' mm-dd-yyyy
   D1$ = Right$("00" + LTrim$(Str$(m%)), 2)
   D2$ = Right$("00" + LTrim$(Str$(d%)), 2)
   D3$ = Right$("0000" + LTrim$(Str$(y%)), 4)

   Var$ = D1$ + "-" + D2$ + "-" + D3$

   Var$ = RTrim$(Var$)
   If Len(Var$) <> 10 Then
      ValidDateNum = False
      Exit Function
   End If
   For Var = 1 To 10
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8, 9, 10
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = nul
            Else
               ValidDateNum = False
               Exit Function
            End If
         Case Else
            If V$ <> "-" Then
               ValidDateNum = False
               Exit Function
            End If
      End Select
   Next
   M = Int(Val(Mid$(Var$, 1, 2)))
   D = Int(Val(Mid$(Var$, 4, 2)))
   Y = Int(Val(Mid$(Var$, 7, 4)))
   If M >= 1 And M <= 12 Then
      If D >= 1 And D <= 31 Then
         If Y >= 1 And Y <= 9999 Then
            ' set leapyear flag
            L = IsLeapYear(Y)
            Select Case M
               Case 1, 3, 5, 7, 8, 10, 12
                  If D <= 31 Then
                     ValidDateNum = -1
                     Exit Function
                  End If
               Case 4, 6, 9, 11
                  If D <= 30 Then
                     ValidDateNum = -1
                     Exit Function
                  End If
               Case 2
                  If L Then
                     If D <= 29 Then
                        ValidDateNum = -1
                        Exit Function
                     End If
                  End If
                  If D <= 28 Then
                     ValidDateNum = -1
                     Exit Function
                  End If
            End Select
         End If
      End If
   End If
   ValidDateNum = 0
End Function

Function ValidTime (Var$)
   ' hh:mm:ss
   Var$ = RTrim$(Var$)
   If Len(Var$) <> 8 Then
      ValidTime = False
      Exit Function
   End If
   For Var = 1 To 8
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = nul
            Else
               ValidTime = False
               Exit Function
            End If
         Case Else
            If V$ <> ":" Then
               ValidTime = False
               Exit Function
            End If
      End Select
   Next
   H = Int(Val(Mid$(Var$, 1, 2)))
   M = Int(Val(Mid$(Var$, 4, 2)))
   S = Int(Val(Mid$(Var$, 7, 2)))
   If H >= 0 And H <= 23 Then
      If M >= 0 And M <= 59 Then
         If S >= 0 And S <= 59 Then
            ValidTime = -1
            Exit Function
         End If
      End If
   End If
   ValidTime = 0
End Function

Function ValidTimeNum (h%, m%, s%)
   ' hh:mm:ss

   T1$ = Right$("00" + LTrim$(Str$(h%)), 2)
   T2$ = Right$("00" + LTrim$(Str$(m%)), 2)
   T3$ = Right$("00" + LTrim$(Str$(s%)), 2)

   Var$ = T1$ + ":" + T2$ + ":" + T3$

   If Len(Var$) <> 8 Then
      ValidTimeNum = False
      Exit Function
   End If
   For Var = 1 To 8
      V$ = Mid$(Var$, Var, 1)
      Select Case Var
         Case 1, 2, 4, 5, 7, 8
            If V$ >= "0" And V$ <= "9" Then
               Eat$ = nul
            Else
               ValidTimeNum = False
               Exit Function
            End If
         Case Else
            If V$ <> ":" Then
               ValidTimeNum = False
               Exit Function
            End If
      End Select
   Next
   H = Int(Val(Mid$(Var$, 1, 2)))
   M = Int(Val(Mid$(Var$, 4, 2)))
   S = Int(Val(Mid$(Var$, 7, 2)))
   If H >= 0 And H <= 23 Then
      If M >= 0 And M <= 59 Then
         If S >= 0 And S <= 59 Then
            ValidTimeNum = -1
            Exit Function
         End If
      End If
   End If
   ValidTimeNum = 0
End Function

Function IsLeapYear (Y)
   ' set leapyear flag
   L = 0
   If Y / 4 = Y \ 4 Then
      L = -1
   End If
   If Y / 100 = Y \ 100 Then
      L = 0
   End If
   If Y / 400 = Y \ 400 Then
      L = -1
   End If
   IsLeapYear = L
End Function

Function DateTimeClock$
   ' Fri Jan 01 2010 hh:mm:ss

   V$ = WEEKDAYSHORTSERIAL$(Now) ' Fri
   V$ = V$ + " " + MONTHSHORTSERIAL$(Now) ' Jan

   V = DAY%(Now) ' 01
   V$ = V$ + " " + Right$("00" + LTrim$(Str$(V)), 2)

   V = YEAR%(Now) ' 2010
   V$ = V$ + " " + Right$("0000" + LTrim$(Str$(V)), 4)

   V$ = V$ + " " + Time$
   DateTimeClock$ = V$
End Function

Function DateTimeClockSerial$ (serial##)
   ' Fri Jan 01 2010 hh:mm:ss

   V$ = WEEKDAYSHORTSERIAL$(serial##) ' Fri
   V$ = V$ + " " + MONTHSHORTSERIAL$(serial##) ' Jan

   V = DAY%(serial##) ' 01
   V$ = V$ + " " + Right$("00" + LTrim$(Str$(V)), 2)

   V = YEAR%(serial##) ' 2010
   V$ = V$ + " " + Right$("0000" + LTrim$(Str$(V)), 4)

   V$ = V$ + " " + FORMATTIME$(serial##)
   DateTimeClockSerial$ = V$
End Function

Function DaysInMonth (M%)
   Select Case M%
      ' 31, 28/29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
      Case 1
         DaysInMonth = 31
      Case 2
         DaysInMonth = 28 ' less leapyear
      Case 3
         DaysInMonth = 31
      Case 4
         DaysInMonth = 30
      Case 5
         DaysInMonth = 31
      Case 6
         DaysInMonth = 30
      Case 7
         DaysInMonth = 31
      Case 8
         DaysInMonth = 31
      Case 9
         DaysInMonth = 30
      Case 10
         DaysInMonth = 31
      Case 11
         DaysInMonth = 30
      Case 12
         DaysInMonth = 31
   End Select
End Function

Function DaysInWeek
   DaysInWeek = 7
End Function

Function MonthsInYear
   MonthsInYear = 12
End Function

Function DaysInYear (Z%)
   If IsLeapYear(Z%) Then
      DaysInYear = 366
   Else
      DaysInYear = 365
   End If
End Function

Function DayOfYear (M%, D%, Y%)
   For Z = 1 To M% - 1
      V = V + DaysInMonth(Z)
      If Z = 2 And IsLeapYear(Y%) Then V = V + 1
   Next
   DayOfYear = V + D%
End Function

Function DayOfYearSerial (serial##)
   M% = MONTH(serial##)
   D% = DAY(serial##)
   Y% = YEAR(serial##)
   For Z = 1 To M% - 1
      V = V + DaysInMonth(Z)
      If Z = 2 And IsLeapYear(Y%) Then V = V + 1
   Next
   DayOfYearSerial = V + D%
End Function

' Converts a number to a string and formats it according to instructions
' contained in a format expression.
'
'    FORMATX$(expression)
'
'     expression  Numeric expression to format
'
'    PRINT USING fmt$; expression
'
'     fmt$ String expression consisting of display-format characters
'          that detail how the expression is displayed:
'          Date and time formats numeric expression formats
'
'    A format expression (fmt$) can have up to three sections separated by
'     semicolons (;). The first section formats positive values, the second
'     section formats negative values, and the third section formats zeros:
'
'         Usage Result
'         ----------------     ----------------------------------------------
'         One section only     The format applies to all numbers
'         Two sections         The first section applies to positive numbers
'                              and zeros; the second to negative numbers
'         Three sections       The first section applies to positive numbers,
'                              the second to negative numbers, and the third
'                              to zeros
'
'    If you have semicolons with nothing between them, the missing section
'     prevents that type of number from being displayed.
'
' Date and Time Formats
'
'  Date/time serial numbers can be formatted with date/time formats or with
'   numeric formats, since date/time serial numbers are stored as floating-
'   point values. Date and time formats are:
'
'         Symbol Description ' MM-DD-YYYY HH:MM:S
'         ------   ----------------------------------------------------------
'         d        Display the day as a number without leading zeros (1-31)
'         dd       Display the day as a number with leading zeros (01-31)
'         ddd      Display the day as an abbreviation (Sun-Sat)
'         dddd     Display the day as a full name (Sunday-Saturday)
'         ddddd    Display a serial date number as a complete date
'                  (including day, month, and year)
'
'         m        Display the month as a number without leading zeros (1-12);
'         mm       Display the month as a number with leading zeros (01-12);
'         mmm      Display the month as an abbreviation (Jan-Dec)
'         mmmm     Display the month as a full name (January-December)
'
'         y        Display the year as a two-digit number (00-99)
'         yyyy     Display the year as a four-digit number (1900-2040)
'
'         h        Display the hour as a number without leading zeros (0-23)
'         hh       Display the hour as a number with leading zeros (00-23)
'
'         n        Display the minute as a number without leading zeros (0-59"
'         nn       Display the minute as a number with leading zeros (00-59);
'
'         s        Display the second as a number without leading zeros (0-59)
'         ss       Display the second as a number with leading zeros (00-59)
'
'         ttttt    Display a time serial number as a complete time, including
'                  hour, minute, and second
'
'         cccc     Display full date/time in form Fri Jan 01 2010 hh:mm:ss
'
'         AM/PM    (Default) Use the 12-hour clock displaying AM or am with
'         am/pm    any hour before noon; PM or pm with any hour between noon
'                  and 11:59
'         A/P      Use the 12-hour clock displaying A or a with any hour
'         a/p      before noon; P or p with any hour between noon and 11:59
'         $f       prepended to format string to force parsing to lowercase."
'           otherwise all uppercase characters are ignored by the processor."
'
Function FormatX$ (VarQ$)
   SyntaxError = 0
   Var$ = VarQ$
   If Left$(LCase$(Var$), 2) = "$f" Then
      Var$ = LCase$(Var$)
      Var$ = Mid$(Var$, 3)
   End If
   If InstrSub1(Var$, "mmmmm") Then ' month error
      SyntaxError = -1
      If ErrorChecking Then
         Error 100
      End If
      Exit Function
   End If
   If InstrSub1(Var$, "yyyyy") Then ' year error
      SyntaxError = -1
      If ErrorChecking Then
         Error 101
      End If
      Exit Function
   End If
   If InstrSub1(Var$, "tttttt") Then ' time error
      SyntaxError = -1
      If ErrorChecking Then
         Error 102
      End If
      Exit Function
   End If
   If InstrSub1(Var$, "dddddd") Then ' date error
      SyntaxError = -1
      If ErrorChecking Then
         Error 103
      End If
      Exit Function
   End If
   If InstrSub1(Var$, "hhh") Then ' hour error
      SyntaxError = -1
      If ErrorChecking Then
         Error 104
      End If
      Exit Function
   End If
   If InstrSub1(Var$, "sss") Then ' second error
      SyntaxError = -1
      If ErrorChecking Then
         Error 105
      End If
      Exit Function
   End If
   If InstrSub1(Var$, "nnn") Then ' minute error
      SyntaxError = -1
      If ErrorChecking Then
         Error 106
      End If
      Exit Function
   End If
   Do
      V = InstrSub1(Var$, "cccc")
      If V Then
         Var$ = Left$(Var$, V - 1) + Chr$(5) + Chr$(5) + Mid$(Var$, V + 4)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "yyyy")
      If V Then
         Var$ = Left$(Var$, V - 1) + Right$(Date$, 4) + Mid$(Var$, V + 4)
      Else
         Exit Do
      End If
   Loop
   If InstrSub1(Var$, "yyy") Then
      SyntaxError = -1
      If ErrorChecking Then
         Error 101
      End If
      Exit Function
   End If
   If InstrSub1(Var$, "yy") Then
      SyntaxError = -1
      If ErrorChecking Then
         Error 101
      End If
      Exit Function
   End If
   Do
      V = InstrSub1(Var$, "AM/PM")
      If V Then
         Var$ = Left$(Var$, V - 1) + Chr$(1) + Chr$(1) + Mid$(Var$, V + 6)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "am/pm")
      If V Then
         Var$ = Left$(Var$, V - 1) + Chr$(2) + Chr$(2) + Mid$(Var$, V + 6)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "A/P")
      If V Then
         Var$ = Left$(Var$, V - 1) + Chr$(3) + Chr$(3) + Mid$(Var$, V + 4)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "a/p")
      If V Then
         Var$ = Left$(Var$, V - 1) + Chr$(4) + Chr$(4) + Mid$(Var$, V + 4)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "y")
      If V Then
         Var$ = Left$(Var$, V - 1) + Right$(Date$, 2) + Mid$(Var$, V + 1)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "ttttt")
      If V Then
         Var$ = Left$(Var$, V - 1) + Time$ + Mid$(Var$, V + 6)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "mmmm")
      If V Then
         V$ = MONTHLONG$(Now)
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 4)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "mmm")
      If V Then
         V$ = MONTHSHORT(MONTH(Now))
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 3)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "ss")
      If V Then
         V$ = Right$(Time$, 2)
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 2)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "s")
      If V Then
         X = Int(Val(Right$(Time$, 2)))
         V$ = LTrim$(Str$(X))
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 1)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "hh")
      If V Then
         V$ = Left$(Time$, 2)
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 2)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "h")
      If V Then
         X = Int(Val(Left$(Time$, 2)))
         V$ = LTrim$(Str$(X))
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 1)
      Else
         Exit Do
      End If
   Loop
   ' parse minute.
   Do
      V = InstrSub1(Var$, "nn")
      If V Then
         V$ = Mid$(Time$, 4, 2) ' minute
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 2)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "n")
      If V Then
         X = Int(Val(Mid$(Time$, 4, 2))) ' minute
         V$ = LTrim$(Str$(X))
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 1)
      Else
         Exit Do
      End If
   Loop
   ' parse month.
   Do
      V = InstrSub1(Var$, "mm")
      If V Then
         V$ = Left$(Date$, 2) ' month
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 2)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "m")
      If V Then
         X = Int(Val(Left$(Date$, 2))) ' month
         V$ = LTrim$(Str$(X))
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 1)
      Else
         Exit Do
      End If
   Loop
   ' parse date.
   P = 0
   Do
      V = InstrSub1(Var$, "ddddd")
      If V Then
         Var$ = Left$(Var$, V - 1) + Date$ + Mid$(Var$, V + 6)
         P = V + 6
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "dddd")
      If V Then
         V$ = WEEKDAYLONGSERIAL(Now)
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 5)
         P = V + Len(V$)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "ddd")
      If V Then
         V$ = WEEKDAYSHORTSERIAL(Now)
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 4)
         P = V + Len(V$)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "dd")
      If V Then
         V$ = Mid$(Date$, 4, 2) ' mm-dd-yyyy
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 2)
         P = V + Len(V$)
      Else
         Exit Do
      End If
   Loop
   Do
      V = InstrSub1(Var$, "d")
      If V Then
         X = Int(Val(Mid$(Date$, 4, 2)))
         V$ = LTrim$(Str$(X))
         Var$ = Left$(Var$, V - 1) + V$ + Mid$(Var$, V + 1)
         P = V + Len(V$)
      Else
         Exit Do
      End If
   Loop
   ' AM/PM    (Default) Use the 12-hour clock displaying AM or am with
   ' am/pm    any hour before noon; PM or pm with any hour between noon and 11:59
   Do
      V = InStr(Var$, Chr$(1) + Chr$(1))
      If V Then
         X = Int(Val(Left$(Time$, 2))) ' hour
         If X < 12 Then
            Var$ = Left$(Var$, V - 1) + "AM" + Mid$(Var$, V + 2)
         Else
            Var$ = Left$(Var$, V - 1) + "PM" + Mid$(Var$, V + 2)
         End If
      Else
         Exit Do
      End If
   Loop
   Do
      V = InStr(Var$, Chr$(2) + Chr$(2))
      If V Then
         X = Int(Val(Left$(Time$, 2))) ' hour
         If X < 12 Then
            Var$ = Left$(Var$, V - 1) + "am" + Mid$(Var$, V + 2)
         Else
            Var$ = Left$(Var$, V - 1) + "pm" + Mid$(Var$, V + 2)
         End If
      Else
         Exit Do
      End If
   Loop
   ' A/P      Use the 12-hour clock displaying A or a with any hour
   ' a/p      before noon; P or p with any hour between noon and 11:59
   Do
      V = InStr(Var$, Chr$(3) + Chr$(3))
      If V Then
         X = Int(Val(Left$(Time$, 2))) ' hour
         If X < 12 Then
            Var$ = Left$(Var$, V - 1) + "A" + Mid$(Var$, V + 2)
         Else
            Var$ = Left$(Var$, V - 1) + "P" + Mid$(Var$, V + 2)
         End If
      Else
         Exit Do
      End If
   Loop
   Do
      V = InStr(Var$, Chr$(4) + Chr$(4))
      If V Then
         X = Int(Val(Left$(Time$, 2))) ' hour
         If X < 12 Then
            Var$ = Left$(Var$, V - 1) + "a" + Mid$(Var$, V + 2)
         Else
            Var$ = Left$(Var$, V - 1) + "p" + Mid$(Var$, V + 2)
         End If
      Else
         Exit Do
      End If
   Loop
   ' special feature to display fully formatted date/time
   Do
      V = InStr(Var$, Chr$(5) + Chr$(5))
      If V Then
         Var$ = Left$(Var$, V - 1) + DateTimeClock$ + Mid$(Var$, V + 2)
      Else
         Exit Do
      End If
   Loop
   ' return formatted value
   Do
      X = InStr(Var$, Chr$(34))
      If X Then
         Var$ = Left$(Var$, X - 1) + Mid$(Var$, X + 1)
      Else
         Exit Do
      End If
   Loop
   FormatX$ = Var$
End Function

Function InstrSub1 (X$, Y$)
   Start$ = X$
   Find$ = Y$
   ' replace quotes
   Do
      X = InStr(Start$, Chr$(34))
      If X Then
         X2 = InStr(X + 1, Start$, Chr$(34))
         If X2 Then
            For Z = X To X2
               Mid$(Start$, Z, 1) = Chr$(0)
            Next
         Else
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop
   InstrSub1 = InStr(Start$, Find$)
End Function

Sub DisplayFormatHelp (Var)
   Var = 0
   Colorf 15
   Print "Date and time formats are:"
   Print
   Print "         Symbol   Description ' MM-DD-YYYY HH:MM:S"
   Print "         ------   ----------------------------------------------------------"
   Colorf 14
   Print "         d        Display the day as a number without leading zeros (1-31)"
   Print "         dd       Display the day as a number with leading zeros (01-31)"
   Print "         ddd      Display the day as an abbreviation (Sun-Sat)"
   Print "         dddd     Display the day as a full name (Sunday-Saturday)"
   Print "         ddddd    Display a serial date number as a complete date"
   Print "                  (including day, month, and year)"
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Var = -1
      Exit Sub
   End If
   Print "         m        Display the month as a number without leading zeros (1-12)"
   Print "         mm       Display the month as a number with leading zeros (01-12)"
   Print "         mmm      Display the month as an abbreviation (Jan-Dec)"
   Print "         mmmm     Display the month as a full name (January-December)"
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Var = -1
      Exit Sub
   End If
   Print "         y        Display the year as a two-digit number (00-99)"
   Print "         yyyy     Display the year as a four-digit number (1900-2040)"
   Print "         h        Display the hour as a number without leading zeros (0-23)"
   Print "         hh       Display the hour as a number with leading zeros (00-23)"
   Print "         n        Display the minute as a number without leading zeros (0-59)"
   Print "         nn       Display the minute as a number with leading zeros (00-59)"
   Print "         s        Display the second as a number without leading zeros (0-59)"
   Print "         ss       Display the second as a number with leading zeros (00-59)"
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Var = -1
      Exit Sub
   End If
   Print "         ttttt    Display a time serial number as a complete time, including"
   Print "                  hour, minute, and second"
   Print "         cccc     Display full date/time in form Fri Jan 01 2010 hh:mm:ss"
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Var = -1
      Exit Sub
   End If
   Print "         AM/PM    Use the 12-hour clock displaying AM or am with any hour"
   Print "         am/pm    before noon; PM or pm with any hour between noon and 11:59"
   Print "         A/P      Use the 12-hour clock displaying A or a with any hour"
   Print "         a/p      before noon; P or p with any hour between noon and 11:59"
   Print "         $f       prepended to format string to force parsing to lowercase."
   Print "           otherwise all uppercase characters are ignored by the processor."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Var = -1
      Exit Sub
   End If
End Sub

Sub DisplayUsingHelp
   Colorf 15
   Print "The following symbols create the expression used with print using:"
   Print "         Value              Description"
   Print "         ---------------    ------------------------------------------------"
   Colorf 14
   Print "         0                  Digit placeholder"
   Print "                             If the number has fewer digits than there are"
   Print "                              zeros (on either side of the decimal) in the"
   Print "                              format expression, leading or trailing zeros"
   Print "                              are displayed."
   Print "                             If the number has more digits to the right of"
   Print "                              the decimal point than there are zeros to the"
   Print "                             right of the decimal in the format expression,"
   Print "                              the number is rounded to as many decimal places"
   Print "                              as there are zeros."
   Print "                             If the number has more digits to the left of"
   Print "                             the decimal point than there are zeros to the"
   Print "                              left in the format expression, the extra digits"
   Print "                              are displayed."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Exit Sub
   End If
   Print "         #                  Digit placeholder"
   Print "                            Follows the same rules as for the 0 digit"
   Print "                              placeholder, except that extra zeros are not"
   Print "                              displayed if the number has fewer digits on"
   Print "                              either side of the decimal point than there"
   Print "                              are #'s on either side of the format."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Exit Sub
   End If
   Print "         .                  Decimal point"
   Print "                             This symbol determines how many digits (#'s or"
   Print "                              0's) display to the right and left of the"
   Print "                              decimal point. Note: Some international"
   Print "                              settings may cause the comma to be used"
   Print "                              as a decimal point rather than a period."
   Print "                             If the format contains only #'s to the left"
   Print "                              of this symbol, then numbers smaller than 1"
   Print "                              are begun with a decimal point. To avoid this,"
   Print "                              you should use 0 as the first digit placeholder"
   Print "                              to the left of a decimal point instead of #."
   Print "         %                  Percentage"
   Print "                             The expression is multiplied by 100 and the"
   Print "                              % character is inserted."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Exit Sub
   End If
   Print "         ,                  Thousands separator"
   Print "                              Separates thousands by commas (or"
   Print "                              by periods if the country code has been set to"
   Print "                              a country other than the United States) if the"
   Print "                              format contains a comma surrounded by #'s or 0's."
   Print "                             Two adjacent commas, or a comma immediately to"
   Print "                              the left of the decimal point location (whether"
   Print "                              there is a decimal specified or not) means"
   Print "                              " + Quote + "Omit the three digits that fall between these"
   Print "                              commas, or between the comma and the decimal"
   Print "                              point, rounding as needed." + Quote + "  Large numbers can"
   Print "                              be scaled using this technique. For example,"
   Print "                             the format string " + Quote + "##0,,." + Quote + " can be used to"
   Print "                              represent 100 million, as simple 100. Numbers"
   Print "                              smaller than 1 million are displayed as 0."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Exit Sub
   End If
   Print "         E- E+ e- e+        Scientific format"
   Print "                             If a format contains one digit placeholder"
   Print "                              (0 or #) to the right of an E-, E+, e-, or e+,"
   Print "                              then displays the number in scientific"
   Print "                              format and inserts an E or e between the number"
   Print "                              and its exponent."
   Print "                             The number of 0's or #'s to the right"
   Print "                              determines the number of digits in the"
   Print "                              exponent."
   Print "                            Use E- or e- to place a minus sign next to"
   Print "                              negative exponents. Use a E+ or e+ to place a"
   Print "                              minus sign next to negative exponents and a"
   Print "                              plus sign next to positive exponents."
   Print "         :  + $ () space   Display literal character"
   Print "                             To display a character other than one of these,"
   Print "                              precede the character with a backslash (\) or"
   Print "                             enclose the character(s) in double quotation"
   Print "                              marks (" + Quote + Quote + ")."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Exit Sub
   End If
   Print "         \                  Display next character in format string"
   Print "                             Many characters in the format string have a"
   Print "                              special meaning and cannot be displayed as"
   Print "                              literal characters unless they are preceded"
   Print "                              by a backslash. The backslash is not"
   Print "                              displayed. This is the same as enclosing the"
   Print "                              next character in double quotation marks."
   Print "                             Examples of such characters are the date-"
   Print "                              and time-formatting characters (y, m, d, h,"
   Print "                              s, a, and p) and the numeric-formatting"
   Print "                              characters (#, 0, %, E, e, comma, and"
   Print "                              period)."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Exit Sub
   End If
   Print "        " + Quote + "text" + Quote + "              Display text inside double quotes"
   Print "                             To include a text string in fmt$, you must"
   Print "                              use quote to enclose the text (34 is the"
   Print "                             ASCII code for double quotation mark)."
   Print "         :                  Time separator"
   Print "                             The time separator is used to separate hours,"
   Print "                              minutes, and seconds when time values are"
   Print "                              formatted."
   Print "         /                  Date separator"
   Print "                             The date separator is used to separate day,"
   Print "                              month, and year when date values are formatted."
   Call PressKey
   If KeyBreak Then
      KeyBreak = 0
      Exit Sub
   End If
   Colorf 15
   Print " Format Specifiers"
   Print
   Print "  The following characters are used to format numeric expressions:"
   Print
   Print "   Character   Description"
   Print "   ---------   -------------------------------------------------------------"
   Colorf 14
   Print "   #           Digit position"
   Print "   -           Placed after digit, prints trailing sign for negative numbers"
   Print "   .           Decimal point position"
   Print "   ,           Placed left of the decimal point, prints a comma every third"
   Print "               digit"
   Print "   $$          Prints leading $"
   Print "   +           Position of number sign"
   Print "   **          Fills leading spaces with *"
   Print "   ^^^^        Prints in exponential format"
   Print "   **$         Combines ** and $$"
   Print "   &           Prints entire string"
   Print "   \ \         Prints first n characters, where n is the number of blanks"
   Print "               between slashes + 2"
   Print "   !           Prints only the first character of the string"
   Print "   " + Quote + "           Insert quote with: \x22 = 34, \o042 = 34, \b100010 = 34"
   Print
   Print "   Note: Any character not in this list is printed as a literal."
   Call PressKey
End Sub

Sub PressKey
   If ControlBreak Then
      ControlBreak = 0
      KeyBreak = -1
      Exit Sub
   End If
   Color 15
   Print "Press a key:";
   Do
      _Limit 50
      If ControlBreak Then
         ControlBreak = 0
         KeyBreak = -1
         Exit Do
      End If
      x$ = InKey$
      If Len(x$) Then
         If x$ = Ctrl.c Then ' trap ctrl-c
            KeyBreak = -1
         End If
         Exit Do
      End If
   Loop
   Colorf StoreColor
   Print
End Sub

Sub Colorf (C)
   StoreColor = C
   Color C
End Sub

' Uses direct keyboard input to get an input line;
'  because Line Input does not display StatusLine during On Timer.
Function KeyboardLine$
   Var$ = nul
   Do
      Locate , , 1
      _Limit 100
      If ControlBreak Then
         ControlBreak = 0
         Var$ = nul
         KeyboardLine$ = Var$
         Exit Function
      End If
      Var2$ = InKey$
      If Len(Var2$) Then ' check keyboard
         Select Case Len(Var2$)
            Case 1
               Select Case Var2$
                  Case Ctrl.c ' ctrl-c
                     Eat$ = nul
                  Case CR ' return
                     Exit Do
                  Case Esc ' escape
                     For V% = Len(Var$) To 1 Step -1
                        If Pos(0) > 1 Then ' check cursor location
                           Locate CsrLin, Pos(0) - 1, 0
                           Print " ";
                           Locate CsrLin, Pos(0) - 1, 1
                        Else ' line-wrap
                           Locate CsrLin - 1, 80, 0
                           Print " ";
                           Locate CsrLin - 1, 80, 1
                        End If
                     Next
                     Var$ = nul
                  Case BackSpace ' backspace
                     If Len(Var$) > 0 Then
                        Var$ = Left$(Var$, Len(Var$) - 1)
                        If Pos(0) > 1 Then ' check cursor location
                           Locate CsrLin, Pos(0) - 1, 0
                           Print " ";
                           Locate CsrLin, Pos(0) - 1, 1
                        Else ' line-wrap
                           Locate CsrLin - 1, 80, 0
                           Print " ";
                           Locate CsrLin - 1, 80, 1
                        End If
                     End If
                  Case Else ' store input
                     Print Var2$;
                     Locate , , 1
                     Var$ = Var$ + Var2$
               End Select
            Case 2
               Select Case Right$(Var2$, 1)
                  Case Del ' delete
                     Debug = Not Debug
               End Select
         End Select
      End If
   Loop
   ' return input line
   Print
   KeyboardLine$ = Var$
End Function

' Uses direct extended keyboard input to get an input line;
'  because Line Input does not display StatusLine during On Timer.

'    XC = X-coordinate
'    YC = Y-coordinate
'    LC = Edit area length

Function LineInput$ (XC, YC, LC)
   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0
   ' display edit entry area.
   Insert = -1
   GoSub DisplayFileLine
   ' main input loop.
   Do
      ' get keypress.
      _Limit 100
      If ControlBreak Then
         ControlBreak = 0
         X$ = nul
         LineInput$ = X$
         Exit Function
      End If
      I$ = InKey$
      ' check key.
      If Len(I$) = 1 Then
         Select Case I$
            ' ctrl-c
            Case Ctrl.c
               Eat$ = nul
               ' enter key.
            Case CR
               Exit Do
               ' escape key.
            Case Esc
               If Len(X$) Then
                  Xposition1 = 1
                  Xposition2 = 0
                  X$ = nul
                  GoSub DisplayFileLine
               End If
               ' backspace.
            Case BackSpace
               If Len(X$) Then
                  If Xposition2 > 0 Then
                     If Insert Then ' destructive backspace
                        X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                     End If
                     Xposition2 = Xposition2 - 1
                     If Xposition2 - LC <= Xposition1 Then
                        Xposition1 = Xposition1 - 1
                        If Xposition1 < 1 Then
                           Xposition1 = 1
                        End If
                     End If
                     GoSub DisplayFileLine
                  End If
               End If
            Case Else
               ' append/insert character into edit area.
               OK = -1
               If Asc(I$) >= 0 And Asc(I$) <= 31 Then
                  OK = 0 ' disallow control charcters
               End If
               If OK Then
                  If Insert Then
                     X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                     Xposition2 = Xposition2 + 1
                     If Xposition2 > LC Then
                        Xposition1 = Xposition1 + 1
                     End If
                  Else
                     If Xposition2 + 1 > Len(X$) Then
                        X$ = X$ + I$ ' append
                        Xposition2 = Xposition2 + 1
                        If Xposition2 > LC Then
                           Xposition1 = Xposition1 + 1
                        End If
                     Else ' insert
                        Mid$(X$, Xposition2 + 1, 1) = I$
                        Xposition2 = Xposition2 + 1
                     End If
                  End If
                  GoSub DisplayFileLine
               End If
         End Select
      End If
      ' check extended key
      If Len(I$) = 2 Then
         Select Case Asc(Right$(I$, 1))
            Case 82 ' Insert
               Insert = Not Insert
               If Insert Then
                  Locate , , 1, 8, 8 ' line cursor
               Else
                  Locate , , 1, 0, 8 ' block cursor
               End If
            Case 83 ' Delete
               If Len(X$) > 0 Then
                  X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                  GoSub DisplayFileLine
               End If
            Case 71, 73, 119 ' Home/PageUp/Ctrl-Home
               If Xposition2 > 0 Then
                  Xposition1 = 1
                  Xposition2 = 0
                  GoSub DisplayFileLine
               End If
            Case 79, 81, 117 ' End/PageDown/Ctrl-End
               If Xposition2 < Len(X$) Then
                  Xposition2 = Len(X$)
                  Xposition1 = Xposition2 - LC + 1
                  If Xposition1 < 1 Then
                     Xposition1 = 1
                  End If
                  GoSub DisplayFileLine
               End If
            Case 75, 115, 155 ' Left/Ctrl-Left/Alt-Left
               If Len(X$) Then
                  If Xposition2 > 0 Then
                     Xposition2 = Xposition2 - 1
                     If Xposition2 - LC <= Xposition1 Then
                        Xposition1 = Xposition1 - 1
                        If Xposition1 < 1 Then
                           Xposition1 = 1
                        End If
                        GoSub DisplayFileLine
                     End If
                  End If
               End If
            Case 77, 116, 157 ' Right/Ctrl-Right/Alt-Right
               If Len(X$) Then
                  If Xposition2 < Len(X$) Then
                     Xposition2 = Xposition2 + 1
                     If Xposition2 > Xposition1 + LC - 1 Then
                        Xposition1 = Xposition1 + 1
                     End If
                     GoSub DisplayFileLine
                  End If
               End If
         End Select
      End If
   Loop
   Print
   LineInput$ = X$
   Locate , , 1, 8, 8
   _KeyClear
   Exit Function

   ' display edit line and position cursor.
   DisplayFileLine:
   Locate XC, YC, 1
   Print Space$(LC);
   Locate XC, YC, 1
   If Len(X$) Then
      Color 15
      Print Mid$(X$, Xposition1, LC);
   End If
   Locate XC, YC + Xposition2 - Xposition1 + 1, 1
   Color 7, 0
   Return
End Function

