REM: Include file for Hex Editor v8.0a PD 2016.

' initialize all default variables as integer.
DEFINT A-Z

' load all arrays during runtime.
REM $DYNAMIC

' declare multiple file structure.
TYPE FileType
 AsciiValue AS INTEGER
 ASCIIZ AS STRING*260
 Buffer AS STRING*1
 CopyPositionEnd AS DOUBLE
 CopyPositionPivot AS DOUBLE
 CopyPositionStart AS DOUBLE
 CurrentMarker AS SINGLE
 CurrentUndo AS SINGLE
 CurrentWindow2 AS INTEGER
 Filename AS STRING*12
 FileAttribute AS INTEGER
 FileByte AS STRING*1
 FileDisplay AS INTEGER
 FileLength AS DOUBLE
 FileLocked AS INTEGER
 FilePage AS DOUBLE
 FilePosition AS DOUBLE
 Handle AS INTEGER
 MarkerCount AS SINGLE
 Netpath AS STRING*260
 PageColumn AS DOUBLE
 PageRow AS DOUBLE
 ScreenRow AS INTEGER
 ShortFilename AS STRING*260
 StoreSearchString AS STRING*260
END TYPE

' declare windows filename/directory structure.
TYPE WinFileType
 Name AS STRING*260 ' asciiz
END TYPE

' declare marker filename structure.
TYPE MarkerFileType
' Markers1(9) AS DOUBLE
 Markers1 AS String * 72
END TYPE

' declare byte undo filename structure.
TYPE UndoFileType
' UndoByte1(9) AS INTEGER
 UndoByte1 AS String * 18
' UndoPosition1(9) AS DOUBLE
 UndoPosition1 AS String * 72
END TYPE

' declare multi array process filenames.
DIM SHARED MultiFilename1(1 TO 9) AS STRING
DIM SHARED MultiFilenames(1 TO 9) AS STRING

' declare undo structure.
DIM SHARED UndoFile AS UndoFileType

' declare undo variables.
DIM SHARED CurrentUndo AS SINGLE, UndoToggle AS INTEGER

' declare marker structure.
DIM SHARED MarkerFile AS MarkerFileType

' declare marker variables.
DIM SHARED CurrentMarker AS SINGLE, NewMarker AS SINGLE
DIM SHARED MarkerCount AS SINGLE, MarkerPosition AS SINGLE

' declare menu area storage arrays.
DIM SHARED Area1(24, 44) AS INTEGER, Area2(24, 44) AS INTEGER

' declare ascii character variables.
DIM SHARED Hline AS INTEGER, Vline AS INTEGER
DIM SHARED ULcorner AS INTEGER, URcorner AS INTEGER
DIM SHARED LLcorner AS INTEGER, LRcorner AS INTEGER

' declare temporary file position variables.
DIM SHARED FileDisplay AS INTEGER, FileDisplay2 AS INTEGER
DIM SHARED FileDisplayX AS INTEGER, ScreenRowX AS INTEGER
DIM SHARED Low AS DOUBLE, High AS DOUBLE, HeapSortOff AS INTEGER
DIM SHARED TempPosition AS DOUBLE, TempPosition1 AS DOUBLE
DIM SHARED TempPosition2 AS DOUBLE, TempPosition3 AS DOUBLE
DIM SHARED TempFiles(1 TO 9) AS STRING, SortMax As Single, SortMax2 As Single

' declare common program variables.
DIM SHARED AsciiValue AS INTEGER, AsciiValue2 AS INTEGER
DIM SHARED ASCIIValue3 AS DOUBLE, HexValue AS DOUBLE
DIM SHARED CurrentWindow AS INTEGER, CurrentWindow2 AS INTEGER
DIM SHARED PageColumn AS DOUBLE, PageRow AS DOUBLE
DIM SHARED ScreenDrawn AS INTEGER, ScreenRow AS INTEGER
DIM SHARED StatusMessage AS STRING, SupportedCall AS INTEGER

' declare common validity check variables.
DIM SHARED AllowWildCard AS INTEGER
DIM SHARED ValidFunction AS INTEGER, ValidASCIIValue AS INTEGER
DIM SHARED ValidString AS INTEGER, ValidHexValue AS INTEGER
DIM SHARED ValidByteString AS INTEGER, NumBytes AS INTEGER

' declare filename/file position variables.
DIM SHARED BlockByte AS STRING*32767, Column AS DOUBLE
DIM SHARED Column2 AS DOUBLE, DumpFile AS STRING, ExcludeFile AS STRING
DIM SHARED FileDumped AS INTEGER, Filename AS STRING
DIM SHARED FileByte AS STRING*1, FileBytePosition AS DOUBLE
DIM SHARED FileLength AS DOUBLE, FilePage AS DOUBLE
DIM SHARED FilePosition AS DOUBLE, FilePosition2 AS DOUBLE
DIM SHARED FirstByte AS DOUBLE, FilePage2 AS DOUBLE
DIM SHARED LastByte AS DOUBLE, LastPage AS DOUBLE
DIM SHARED NewByte AS DOUBLE, NextByte AS DOUBLE
DIM SHARED NextLine AS DOUBLE, NextPage AS DOUBLE
DIM SHARED NewPosition AS DOUBLE, NewPosition2 AS DOUBLE
DIM SHARED PageColumn2 AS DOUBLE, PageRow2 AS DOUBLE
DIM SHARED SeekPosition AS DOUBLE, SeekPosition2 AS DOUBLE
DIM SHARED ShortFilename AS STRING, StorePosition AS DOUBLE

' declare file search position variables.
DIM SHARED SearchBytePosition AS DOUBLE, StoreNumBytes AS INTEGER
DIM SHARED StoreSearchPosition AS DOUBLE, StoreSearchString AS STRING
DIM SHARED StoreSearchMulti AS INTEGER

' declare all long filename common variables.
DIM SHARED ASCIIZ AS STRING*260, ASCIIZ2 AS STRING*260
DIM SHARED Buffer AS STRING*1
DIM SHARED ConfigFile AS STRING, BASIC.DTA.OFF AS INTEGER
DIM SHARED BASIC.DTA.SEG AS INTEGER, Directory.ASCIIZ AS STRING
DIM SHARED ErrorTrap AS INTEGER
DIM SHARED FileAttribute AS INTEGER, FileLocked AS INTEGER
DIM SHARED FileDateTime AS STRING, FileSwitch AS INTEGER
DIM SHARED FileSize AS DOUBLE, FileSizeType AS INTEGER
DIM SHARED Handle AS INTEGER, QuietSwitch AS INTEGER
DIM SHARED Quote AS STRING, Windows.Detected AS INTEGER
DIM SHARED Wfile.Handle AS INTEGER
DIM SHARED Write.Error AS INTEGER, Load.Windows AS INTEGER
DIM SHARED Load.DOS AS INTEGER

' declare all common mouse variables.
DIM SHARED MouseX AS INTEGER, MouseY AS INTEGER
DIM SHARED MouseButton1 AS INTEGER, MouseButton2 AS INTEGER
DIM SHARED MouseButton3 AS INTEGER, MouseWheel AS INTEGER
DIM SHARED Old.Mouse.Row AS INTEGER, Old.Mouse.Column AS INTEGER
DIM SHARED Reset1 AS INTEGER, Time1 AS SINGLE

' declare filename variables for file menu box.
DIM SHARED Ambiguate AS INTEGER, AmbiguateSwitch AS INTEGER
DIM SHARED Attribute AS INTEGER, ASCIIZ3 AS STRING*260
DIM SHARED Current.Drive AS INTEGER, Drive.Box.Line AS INTEGER
DIM SHARED Default.Drive AS INTEGER, Last.Drive AS INTEGER
DIM SHARED Num.Dirs AS SINGLE, Num.Files AS SINGLE

' declare Alt-n keys array.
DIM SHARED Keys(1 TO 26) AS INTEGER

' declare filename sort variables for file menu box.
DIM SHARED FileSort AS INTEGER, DirSort AS INTEGER, Millisecond AS INTEGER

' declare requirement filename attribute bit variables for file menu box.
DIM SHARED RequireReadOnly AS INTEGER, RequireHidden AS INTEGER
DIM SHARED RequireSystem AS INTEGER, RequireArchive AS INTEGER

' declare requirement directory attribute bit variables for file menu box.
DIM SHARED RequireDirReadOnly AS INTEGER, RequireDirHidden AS INTEGER
DIM SHARED RequireDirSystem AS INTEGER, RequireDirArchive AS INTEGER

' declare sort structure for file menu box.
DIM SHARED WinFileStruc AS WinFileType

' declare menu screen location offsets for file menu box.
DIM SHARED Xcoor AS INTEGER, Ycoor AS INTEGER

' declare menu variables for DropDownMenu.
DIM SHARED CurrentMenu AS INTEGER, CurrentMenuSelection AS INTEGER

' declare variables for copy/paste.
DIM SHARED CopyByte AS STRING*1, CopyStart AS DOUBLE
DIM SHARED CopyPositionEnd AS DOUBLE, CopyPositionPivot AS DOUBLE
DIM SHARED CopyPositionStart AS DOUBLE

' declare structure for multiple files.
DIM SHARED File(1 TO 9) AS FileType

' declare multiple file variables.
DIM SHARED CurrentFile AS INTEGER, NumberFiles AS INTEGER

' declare temp file share variables.
DIM SHARED Process.Number AS INTEGER

' temp directory
DIM SHARED DRX AS STRING

' declare color variables.
DIM SHARED Black AS INTEGER, Blue AS INTEGER, Cyan AS INTEGER
DIM SHARED Green AS INTEGER, Magenta AS INTEGER, Plain AS INTEGER
DIM SHARED Red AS INTEGER, White AS INTEGER, Yellow AS INTEGER
DIM SHARED BackGround AS INTEGER, BackGround2 AS INTEGER

' declare color storage variables.
DIM SHARED Background.Color AS INTEGER, Foreground.Color AS INTEGER
DIM SHARED Video.Page AS INTEGER

' declare network path variables.
DIM SHARED CurrentNetPath AS STRING*260, DefaultNetPath AS STRING*260

' additional display purposes.
DIM SHARED Debug AS INTEGER, Debug2 AS INTEGER, Debug3 AS INTEGER
DIM SHARED 23 AS STRING, Z4 AS STRING

' declare default printer port variable.
DIM SHARED PrinterPort AS INTEGER

' declare constants.
CONST Nul=""
CONST False=0
CONST SFalse=0!
CONST DFalse=0#
CONST True=-1
CONST Author$="Erik Jon Oredson"
CONST Email="eoredson@gmail.com"
CONST Version="v8.0a"
CONST Release="r1.0a"
CONST Program="Hex Editor"
CONST Publish="03/01/2016"
CONST Status="Public Domain"
CONST Urls="www.filegate.net"

' declare maximum files/processes.
CONST MaxFiles=9 ' should not be changed
CONST MaxProcesses=9 ' should not be changed

' declare external libraries
DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
END DECLARE

