REM Program: Hex Editor v8.0a, Module 2 of 6, PD 2016.
REM Author: Erik Jon Oredson AS. Csci
REM Release: 03/01/2016.
REM Status: Public Domain.
REM Email: eoredson@gmail.com
REM Urls: www.filegate.net

' get include file.
REM $INCLUDE: 'hexedit.inc'

REM Subroutines:
REM   CalculatePosition1    --  calculate screen values given file position.
REM   CalculatePosition2    --  calculate screen values given variable.
REM   Colorf            --  specialized color function.
REM   Colorf2           --  specialized color function.
REM   DisplayBootUsage  --  display boot usage.
REM   DisplayScreen     --  display main editing screen.
REM   DisplayScreen2    --  display screen border.
REM   Deconcatenate     --  deconcatenates filename.
REM   DropDownMenu      --  starts top drop down menu.
REM   DisplayTab        --  redraws menu tab.
REM   DisplayCriticalError  --  display error trap message.
REM   ExcludeList       --  gets exluded filelist for menu.
REM   GetDrive          --  reads default drive/directory.
REM   InitializePaste   --  initialize paste file.
REM   InitPasteFiles    --  init paste files for new file.
REM   InitVars          --  inits some startup variables.
REM   Locatef           --  specialized locate function.
REM   MultiFileFunction     --  routine to process multiple files.
REM   OpenUndoFile      --  open undo/marker file.
REM   OpenPasteFiles    --  open paste files.
REM   Printf            --  specialized print function.
REM   ReadConfigFile    --  search for and read configure file.
REM   StoreServerName   --  stores default server name.

REM Gets default drive/directory.
SUB GetDrive(Drive.Number, Directory$)
 ' store current directory.
 Directory.ASCIIZ = GetD$
 Directory$ = Directory.ASCIIZ
 Drive.Number = ASC(LEFT$(Directory$, 1)) - 65 ' 0=a, 1=b, ..
END SUB

REM Store default server name.
SUB StoreServerName
 ' store default server name.
 Var$ = Environ$("COMPUTERNAME")
 If Len(Var$) Then
    DefaultNetPath = Var$
 Endif
END SUB

REM Subroutine to init variables.
SUB InitVars
 ' init a quote symbol.
 Quote = CHR$(34)

 ' reset default printer port.
 PrinterPort = 1

 ' reset default string store variable.
 StoreSearchMulti = -1

 ' init screen colors.
 Black = 0
 Blue = 9
 Cyan = 11
 Green = 10
 Magenta = 13
 Plain = 7
 Red = 12
 White = 15
 Yellow = 14
 BackGround = 1
 BackGround2 = 1

 ' init ascii characters.
 Hline = 205
 Vline = 186
 ULcorner = 201
 URcorner = 187
 LLcorner = 200
 LRcorner = 188

 ' check for Windows loaded.
 IF INSTR(_OS$, "[WINDOWS]") THEN
    Windows.Detected = True
    IF INSTR(_OS$, "[ANDROID]") THEN
       Windows.Detected = False
    END IF
 END IF

 ' check windows.
 IF Windows.Detected = 0 THEN
    SYSTEM
 END IF

 ' store mouse timing.
 MouseTime = 1!

 ' store max file menu box files
 SortMax = 32768!
 SortMax2 = 16384!

 ' get default drives.
 CALL GetDrives

 ' check temp directory
 FX$ = "C:\TEMP"
 IF _DIREXISTS(FX$) THEN
     Eat$ = Nul
 ELSE
     IF _FILEEXISTS(FX$) THEN
         KILL FX$
     END IF
     MKDIR FX$
 END IF
 DRX = FX$ + "\"

 ' init filename variables.
 ConfigFile = "hexedit.cfg"
 Var$ = Environ$("CONFIGFILE")
 If Len(Var$) Then
    If Instr(Var$,":") Then
       Eat$=Nul
    Else
       If Instr(Var$,"\") Then
          Eat$=Nul
       Else
          ConfigFile = Var$
       Endif
    Endif
 Endif
 DumpFile = "hexedit.dmp"
 Var$ = Environ$("DUMPFILE")
 If Len(Var$) Then
    If Instr(Var$,":") Then
       Eat$=Nul
    Else
       If Instr(Var$,"\") Then
          Eat$=Nul
       Else
          DumpFile = Var$
       Endif
    Endif
 Endif
 ExcludeFile = "hexedit.exd"
 Var$ = Environ$("EXCLUDEFILE")
 If Len(Var$) Then
    If Instr(Var$,":") Then
       Eat$=Nul
    Else
       If Instr(Var$,"\") Then
          Eat$=Nul
       Else
          ExcludeFile = Var$
       Endif
    Endif
 Endif
END SUB

REM subroutine to send string of characters to screen.
SUB Printf(Var1$)
 VarZ=Background.Color*16+Foreground.Color
 For VarX=1 To Len(Var1$)
    VarY=Asc(Mid$(Var1$,VarX,1))
    Print Chr$(VarY);
    ' reposition cursor.
    If Pos(0)+1<=80 Then
       Locate Csrlin,Pos(0)+1,0
    Endif
 Next
END SUB

REM subroutine stores recent color change.
SUB Colorf(Var)
 Foreground.Color=Var
 Color Var
END SUB

REM subroutine stores recent color change.
SUB Colorf2(Var1,Var2)
 Foreground.Color=Var1
 Background.Color=Var2
 Color Var1,Var2
END SUB

REM subroutine sets cursor position.
SUB LOCATEf(Var1,Var2,Var3)
 ' test end of page.
 If Var1>24 Then
    ' scroll screen.
    Print;
 Endif
 Locate Var1,Var2,Var3
END SUB

REM subroutine to access multiple file structure.
REM input variable:
REM   Var = 1 init new file.
REM   Var = 2 store current file.
REM   Var = 3 restore current file.
SUB MultiFileFunction(Var)
 Select Case Var
 Case 1 ' Init new file.
    File(CurrentFile).AsciiValue = False
    File(CurrentFile).ASCIIZ = ASCIIZ
    File(CurrentFile).Buffer = CHR$(0)
    File(CurrentFile).CopyPositionEnd = 0
    File(CurrentFile).CopyPositionPivot = 0
    File(CurrentFile).CopyPositionStart = 0
    File(CurrentFile).CurrentMarker = 0!
    File(CurrentFile).CurrentUndo = 0!
    File(CurrentFile).CurrentWindow2 = 0
    File(CurrentFile).FileDisplay = FileDisplayX
    File(CurrentFile).Filename = Filename
    File(CurrentFile).FileAttribute = FileAttribute
    File(CurrentFile).FileByte = CHR$(0)
    File(CurrentFile).FileLength = FileLength
    File(CurrentFile).FileLocked = FileLocked
    File(CurrentFile).FilePage = 1
    File(CurrentFile).FilePosition = 1
    File(CurrentFile).Handle = Handle
    File(CurrentFile).MarkerCount = 0!
    File(CurrentFile).NetPath = CurrentNetPath
    File(CurrentFile).PageColumn = 1
    File(CurrentFile).PageRow = 1
    File(CurrentFile).ScreenRow = ScreenRowX
    File(CurrentFile).ShortFilename = ShortFilename
    File(CurrentFile).StoreSearchString = ""
 Case 2 ' Store current file.
    File(CurrentFile).AsciiValue = AsciiValue
    File(CurrentFile).ASCIIZ = ASCIIZ
    File(CurrentFile).Buffer = Buffer
    File(CurrentFile).CopyPositionEnd = CopyPositionEnd
    File(CurrentFile).CopyPositionPivot = CopyPositionPivot
    File(CurrentFile).CopyPositionStart = CopyPositionStart
    File(CurrentFile).CurrentMarker = CurrentMarker
    File(CurrentFile).CurrentUndo = CurrentUndo
    File(CurrentFile).CurrentWindow2 = CurrentWindow2
    File(CurrentFile).FileDisplay = FileDisplay
    File(CurrentFile).Filename = Filename
    File(CurrentFile).FileAttribute = FileAttribute
    File(CurrentFile).FileByte = FileByte
    File(CurrentFile).FileLength = FileLength
    File(CurrentFile).FileLocked = FileLocked
    File(CurrentFile).FilePage = FilePage
    File(CurrentFile).FilePosition = FilePosition
    File(CurrentFile).Handle = Handle
    File(CurrentFile).MarkerCount = MarkerCount
    File(CurrentFile).NetPath = CurrentNetPath
    File(CurrentFile).PageColumn = PageColumn
    File(CurrentFile).PageRow = PageRow
    File(CurrentFile).ScreenRow = ScreenRow
    File(CurrentFile).ShortFilename = ShortFilename
    File(CurrentFile).StoreSearchString = StoreSearchString
 Case 3 ' Restore current file.
    AsciiValue = File(CurrentFile).AsciiValue
    ASCIIZ = File(CurrentFile).ASCIIZ
    Buffer = File(CurrentFile).Buffer
    CopyPositionEnd = 0
    CopyPositionPivot = 0
    CopyPositionStart = 0
    CurrentMarker = File(CurrentFile).CurrentMarker
    CurrentUndo = File(CurrentFile).CurrentUndo
    CurrentWindow2 = File(CurrentFile).CurrentWindow2
    FileDisplay = File(CurrentFile).FileDisplay
    Filename = File(CurrentFile).Filename
    FileAttribute = File(CurrentFile).FileAttribute
    FileByte = File(CurrentFile).FileByte
    FileLength = File(CurrentFile).FileLength
    FileLocked = File(CurrentFile).FileLocked
    FilePage = File(CurrentFile).FilePage
    FilePosition = File(CurrentFile).FilePosition
    Handle = File(CurrentFile).Handle
    MarkerCount = File(CurrentFile).MarkerCount
    CurrentNetPath = File(CurrentFile).NetPath
    PageColumn = File(CurrentFile).PageColumn
    PageRow = File(CurrentFile).PageRow
    ScreenRow = File(CurrentFile).ScreenRow
    ShortFilename = File(CurrentFile).ShortFilename
    If StoreSearchMulti Then
       StoreSearchString = File(CurrentFile).StoreSearchString
    Endif
 End Select
END SUB

REM subroutine to open undo/marker files,
REM   also counts opened hexedit processes.

SUB OpenUndoFile(Var2)
 ' reset process counter.
 Var = False
 Var2 = False

 ' get valid path for file.
 MultiFilename1(1)=Nul
 MultiFilename1(2)=Nul

 ' start counter loop.
 DO
    ' make temp filename with counter.
    V1$ = DRX + "UNDOBYTE.DA" + MID$(STR$(Var), 2)

    ' check file exists.
    CLOSE #6
    IF _FILEEXISTS(V1$)=0 THEN
       OPEN V1$ FOR RANDOM AS #6 LEN = LEN(UndoFile)
       MultiFilename1(1)=V1$
       EXIT DO
    END IF

    ' increment process counter.
    Var = Var + 1

    ' check maximum processes open.
    IF Var > MaxProcesses THEN ' needs to be 1 to 9.
       Var2 = True
       ErrorTrap = 90
       Exit Sub
    END IF
 LOOP

 ' store process number.
 Process.Number = Var

 ' make temp filename with process number.
 V1$ = DRX + "MARKERS1.DA" + MID$(STR$(Process.Number), 2)
 CLOSE #7
 OPEN V1$ FOR RANDOM AS #7 LEN = LEN(MarkerFile)
 MultiFilename1(2)=V1$
END SUB

REM subroutine to initialize paste file.
SUB InitializePaste(Var2)
 Var2 = False
 ' make temp filename with process number.
 V1$ = DRX + "COPYFILE.DA" + MID$(STR$(Process.Number), 2)
 MultiFilename1(3)=Nul
 CLOSE #4
 ' check file exists.
 IF _FILEEXISTS(V1$) THEN
    KILL V1$ ' delete file.
 END IF
 MultiFilename1(3)=V1$
END SUB

REM subroutine to open paste files.
SUB OpenPasteFiles(Var2)
 Var2 = False
 ' make filename with process number.
 V1$ = DRX + "COPYFILE.DA" + MID$(STR$(Process.Number), 2)
 ' make filename with process number and file number.
 V2$ = DRX + "UNDOFIL" + MID$(STR$(Process.Number), 2) + ".DA" + MID$(STR$(CurrentFile), 2)
 ' open files.
 CLOSE #4, #5
 OPEN V1$ FOR RANDOM AS #4 LEN = 1
 OPEN V2$ FOR RANDOM AS #5 LEN = 1
 MultiFilenames(CurrentFile) = V2$
END SUB

REM subroutine to init paste files for new file.
SUB InitPasteFiles(Var2)
 ' make filename with process number.
 V1$ = DRX + "COPYFILE.DA" + MID$(STR$(Process.Number), 2)
 ' make filename with process number and file number.
 V2$ = DRX + "UNDOFIL" + MID$(STR$(Process.Number), 2) + ".DA" + MID$(STR$(CurrentFile), 2)
 ' attempt to open file.
 CLOSE #4, #5
 OPEN V1$ FOR RANDOM AS #4 LEN = 1
 IF _FILEEXISTS(V2$) THEN
    KILL V2$ ' remove temp file.
 END IF
 OPEN V2$ FOR RANDOM AS #5 LEN = 1
 MultiFilenames(CurrentFile) = V2$
END SUB

REM Position calculation routines follow:

' displays cell position in string format type 1.
SUB FormatPosition1
 CALL CalculatePosition2
 IF CurrentWindow2 = False THEN
    PRINTf "(page: " + FormatX$(Cdbl(FilePage2 - 1), 1) + ","
 ELSE
    PRINTf "(page: " + RIGHT$("00000000" + HEX$(FilePage2 - 1), 8) + "H,"
 END IF
 PRINTf " row:" + MID$(STR$(PageRow2), 2) + ","
 PRINTf " column:" + MID$(STR$(PageColumn2), 2) + ")"
END SUB

' calculate current screen page number, row, and column, given file position.
SUB CalculatePosition1
 FilePage = INT((FilePosition - 1) / 320) + 1
 PageRow = INT((FilePosition - (FilePage - 1) * 320 - 1) / 20) + 1
 PageColumn = INT((FilePosition - (FilePage - 1) * 320) - (PageRow - 1) * 20)
END SUB

' calculate screen page number, row, and column, given variable.
SUB CalculatePosition2
 IF TempPosition3 = DFalse THEN
    FilePage2 = False
    PageRow2 = False
    PageColumn2 = False
 ELSE
    FilePage2 = INT((TempPosition3 - 1) / 320) + 1
    PageRow2 = INT((TempPosition3 - (FilePage2 - 1) * 320 - 1) / 20) + 1
    PageColumn2 = INT((TempPosition3 - (FilePage2 - 1) * 320) - (PageRow2 - 1) * 20)
 END IF
END SUB

REM Subroutine to get environment variable settings,
REM   and read custom config file variables.

SUB ReadConfigFile (Var$)
 ' check internal include file constants.
 VarX$="MaxFiles"
 If MaxFiles>9 Then
    Goto Error.Routine2
 Endif
 If MaxFiles<1 Then
    Goto Error.Routine2
 Endif
 If MaxFiles<>Int(MaxFiles) Then
    Goto Error.Routine2
 Endif
 VarX$="MaxProcesses"
 If MaxProcesses>9 Then
    Goto Error.Routine2
 Endif
 If MaxProcesses<1 Then
    Goto Error.Routine2
 Endif
 If MaxProcesses<>Int(MaxProcesses) Then
    Goto Error.Routine2
 Endif

 ' check for ambiguation variable.
 IF ENVIRON$("AMBIGUATE") <> Nul THEN
    AmbiguateSwitch = True
 END IF

 ' check for screen row variable.
 IF ENVIRON$("HEXSCREEN") <> Nul THEN
    ScreenRow = True
 END IF

 ' check for heap sort variable.
 IF ENVIRON$("HEXSORT") <> Nul THEN
    HeapSortOff = True
 END IF

 ' check for file date/time variable.
 IF ENVIRON$("FILESWITCH") <> Nul THEN
    X = INT(VAL(ENVIRON$("FILESWITCH")))
    SELECT CASE X
    CASE 0, 1, 2
       FileSwitch = X
    END SELECT
 END IF

 ' check for file menu box filesize display.
 IF ENVIRON$("FILESIZE") <> Nul THEN
    X$ = ENVIRON$("FILESIZE")
    SELECT CASE X$
    CASE "0", "B"
       FileSizeType = 0
    CASE "1", "K"
       FileSizeType = 1
    CASE "2", "M"
       FileSizeType = 2
    CASE "3", "G"
       FileSizeType = 3
    END SELECT
 END IF

 ' check for quiet variable.
 IF ENVIRON$("QUIET") <> Nul THEN
    X = INT(VAL(ENVIRON$("QUIET")))
    SELECT CASE X
    CASE -1, 0, 1, 2, 3, 4, 5, 6
       QuietSwitch = X
    END SELECT
 END IF

 ' init alternate characters.
 IF ENVIRON$("HEXCHARS") <> Nul THEN
    Hline = 45
    Vline = 124
    ULcorner = 43
    URcorner = 43
    LLcorner = 43
    LRcorner = 43
 END IF

 ' define screen offsets for file menu box.
 ' allows menu repositioning.
 Xcoor = 5
 Ycoor = 20

 ' check config variable.
 IF ENVIRON$("LOADWIN") <> Nul THEN
    Load.Windows = True
 END IF

 ' check config variable.
 IF ENVIRON$("LOADDOS") <> Nul THEN
    Load.DOS = True
 END IF

 ' check config variable.
 IF ENVIRON$("HEXCONFIG") <> Nul THEN
    EXIT SUB
 END IF

REM Read Hexedit?.cfg file,
REM   search current path, environment path, then path statement.

 ' search current path.
 File$ = GetD$
 IF RIGHT$(File$, 1) <> "\" THEN
    File$ = File$ + "\"
 END IF
 Config.Filename$ = File$ + ConfigFile
 IF _FILEEXISTS(Config.Filename$) THEN
    GOSUB ReadFile2
    IF ValidFile THEN
       EXIT SUB
    END IF
 END IF

 ' search environment path.
 File$ = ENVIRON$("HEXEDIT")
 IF LEN(File$) THEN
    File$ = RTRIM$(File$)
    File$ = LTRIM$(File$)
    IF LEFT$(File$, 1) = Chr$(34) Then
       File$ = Mid$(File$, 2)
    END IF
    IF RIGHT$(File$, 1) = Chr$(34) Then
       File$ = Left$(File$, Len(File$) - 1)
    END IF
    IF RIGHT$(File$, 1) <> "\" THEN
       File$ = File$ + "\"
    END IF
    ASCIIZ = File$ + ConfigFile + Chr$(0)
    CALL GetShortFilename(Config.Filename$)
    IF LEN(Config.Filename$) THEN
       IF _FILEEXISTS(Config.Filename$) THEN
          GOSUB ReadFile2
          IF ValidFile THEN
             EXIT SUB
          END IF
       END IF
    END IF
 END IF

 ' search path statement.
 Path$ = ENVIRON$("PATH")
 IF LEN(Path$) THEN
    DO
       ' parse path.
       Parse = INSTR(Path$, ";")
       IF Parse THEN
          File$ = LEFT$(Path$, Parse - 1)
          Path$ = MID$(Path$, Parse + 1)
       ELSE
          File$ = Path$
          Path$ = Nul
       END IF

       ' store filename.
       File$ = RTRIM$(File$)
       File$ = LTRIM$(File$)
       IF LEN(File$) THEN
          IF LEFT$(File$, 1) = Chr$(34) Then
             File$ = Mid$(File$, 2)
          END IF
          IF RIGHT$(File$, 1) = Chr$(34) Then
             File$ = Left$(File$, Len(File$) - 1)
          END IF
          IF RIGHT$(File$, 1) <> "\" THEN
             File$ = File$ + "\"
          END IF
          ASCIIZ = File$ + ConfigFile + Chr$(0)
          CALL GetShortFilename(Config.Filename$)
          IF LEN(Config.Filename$) THEN
             IF _FILEEXISTS(Config.Filename$) THEN
                GOSUB ReadFile2
                IF ValidFile THEN
                   EXIT SUB
                END IF
             END IF
          END IF
       END IF
       IF Path$ = Nul THEN
          EXIT DO
       END IF
    LOOP
 END IF
 EXIT SUB

' read in the data file.
ReadFile2:
 ' open filename.
 ErrorTrap = False
 ValidFile = False
 CLOSE #1
 OPEN Config.Filename$ FOR INPUT SHARED AS #1
 IF ErrorTrap THEN
    RETURN
 END IF
 ValidFile = True

 ' read input lines.
 DO WHILE NOT EOF(1)
    LINE INPUT #1, FileLine$

    ' remove appended comment.
    Var = Instr(FileLine$, "'")
    If Var Then
       If Var = 1 Then
          FileLine$ = Nul
       Else
          FileLine$ = Left$(FileLine$, Var - 1)
       Endif
    Endif

    ' store config line.
    FileLine2$ = FileLine$

    ' trim config line.
    Gosub Remove.Spaces

    ' check for prepended comment.
    IF LEFT$(FileLine$, 1) = ";" THEN
       FileLine$ = Nul
    END IF

    ' check assignment value.
    Parse = INSTR(FileLine$, "=")

    ' parse off left/right sides.
    IF Parse THEN

       ' get left/right side values.
       Char$ = LEFT$(FileLine$, Parse - 1)
       Setting$ = MID$(FileLine$, Parse + 1)

       ' get right side value for filenames
       ' enclosed in quotes containing spaces.
       Parse = INSTR(FileLine2$, "=")
       Setting2$ = MID$(FileLine2$, Parse + 1)
       Setting2$ = RTRIM$(Setting2$)
       Setting2$ = LTRIM$(Setting2$)

       ' check length of values.
       IF LEN(Char$) > 0 AND LEN(Setting$) > 0 THEN
          ' compare values.
          SELECT CASE UCASE$(Char$)
          ' check debug switches.
          CASE "DEBUG"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                Debug = False
             CASE "ON", "-1", "TRUE"
                Debug = True
             END SELECT
          CASE "DEBUG2"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                Debug2 = False
             CASE "ON", "-1", "TRUE"
                Debug2 = True
             END SELECT
          CASE "DEBUG3"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                Debug3 = False
             CASE "ON", "-1", "TRUE"
                Debug3 = True
             END SELECT
          ' check file sort maximum
          CASE "SORTMAX"
             Var!=0!
             Gosub Remove.Commas
             Select Case Ucase$(Right$(Var3$,1))
             Case "K"
                Var3$=Left$(Var3$,Len(Var3$)-1)
                Var3!=Int(Val(Var3$))
                If Var3!>=1! And Var3!<=16384! Then
                   Var!=Var3!*1024!
                Endif
             Case "M"
                Var3$=Left$(Var3$,Len(Var3$)-1)
                Var3!=Int(Val(Var3$))
                If Var3!>=1! And Var3!<=16! Then
                   Var!=Var3!*1048576!
                Endif
             Case ELSE
                Var!=INT(VAL(Var3$))
             END Select
             If Var!=-1! Then ' disable
                SortMax=-1!
             Endif
             If Var!>=1024! And Var!<=16777216! Then
                SortMax=Var!
             Endif
          ' check dir sort maximum
          CASE "SORTMAX2"
             Var!=0!
             Gosub Remove.Commas
             Select Case Ucase$(Right$(Var3$,1))
             Case "K"
                Var3$=Left$(Var3$,Len(Var3$)-1)
                Var3!=Int(Val(Var3$))
                If Var3!>=1! And Var3!<=16384! Then
                   Var!=Var3!*1024!
                Endif
             Case "M"
                Var3$=Left$(Var3$,Len(Var3$)-1)
                Var3!=Int(Val(Var3$))
                If Var3!>=1! And Var3!<=16! Then
                   Var!=Var3!*1048576!
                Endif
             Case ELSE
                Var!=INT(VAL(Var3$))
             END Select
             If Var!=-1! Then ' disable
                SortMax2=-1!
             Endif
             If Var!>=1024! And Var!<=16777216! Then
                SortMax2=Var!
             Endif
          ' check dump filename.
          CASE "DUMPFILE"
             DumpFile = Setting$
          ' check exclude filename.
          CASE "EXCLUDEFILE"
             ExcludeFile = Setting$
          ' check and concatenate loaded filenames.
          CASE "EDITFILE"
             IF Var$ = Nul THEN
                Var$ = Setting2$
             ELSE
                Var$ = Var$ + CHR$(13) + Setting2$
             END IF
          ' check windows detected override setting.
          CASE "LOADWINDOWS"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                Load.Windows = False
             CASE "ON", "-1", "TRUE"
                Load.Windows = True
             END SELECT
          ' check DOS detected override setting.
          CASE "LOADDOS"
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                Load.DOS = False
             CASE "ON", "-1", "TRUE"
                Load.DOS = True
             END SELECT
          ' check environment replacement variables.
          CASE "HEXDISPLAY" ' 64-byte display.
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                FileDisplayX = True
             CASE "ON", "-1", "TRUE"
                FileDisplayX = False
             END SELECT
          CASE "HEXSCREEN" ' help key list.
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                ScreenRowX = True
             CASE "ON", "-1", "TRUE"
                ScreenRowX = False
             END SELECT
          CASE "HEXSORT" ' file\dir sort.
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                HeapSortOff = True
             CASE "ON", "-1", "TRUE"
                HeapSortOff = False
             END SELECT
          CASE "AMBIGUATE" ' file menu box ambiguation.
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                AmbiguateSwitch = False
             CASE "ON", "-1", "TRUE"
                AmbiguateSwitch = True
             END SELECT
          CASE "QUIET" ' file menu box display.
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                QuietSwitch = False
             CASE "ON", "-1", "TRUE"
                QuietSwitch = True
             CASE ELSE
                SELECT CASE INT(VAL(Setting$))
                CASE 1 TO 6
                   QuietSwitch = INT(VAL(Setting$))
                END SELECT
             END SELECT
          CASE "FILESWITCH" ' file menu box date\time display.
             SELECT CASE INT(VAL(Setting$))
             CASE 0, 1, 2
                FileSwitch = INT(VAL(Setting$))
             END SELECT
          CASE "FILESIZE" ' file menu box filesize display.
             SELECT CASE UCASE$(Setting$)
             CASE "0", "B"
                FileSizeType = 0
             CASE "1", "K"
                FileSizeType = 1
             CASE "2", "M"
                FileSizeType = 2
             CASE "3", "G"
                FileSizeType = 3
             END SELECT
          CASE "MOUSEDRAGSCROLL" ' mouse drag scroll timer.
             MouseTime = CSNG(VAL(Setting$))
          CASE "PORT" ' default printer port.
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 1 AND NewValue <= 4 THEN
                PrinterPort = NewValue
             END IF
          CASE "SEARCH" ' default search variable.
             SELECT CASE UCASE$(Setting$)
             CASE "OFF", "0", "FALSE"
                StoreSearchMulti = False
             CASE "ON", "-1", "TRUE"
                StoreSearchMulti = True
             END SELECT
          CASE "LASTDRIVE" ' override last drive.
             SELECT CASE UCASE$(Setting$)
             CASE "C" TO "Z"
                Last.Drive=ASC(UCASE$(Setting$))-64
             END SELECT
          CASE "XCOOR" ' file menu box location.
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 2 THEN
                IF NewValue <= 8 THEN
                   Xcoor = NewValue
                END IF
             END IF
          CASE "YCOOR" ' file menu box location.
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 1 THEN
                IF NewValue <= 39 THEN
                   Ycoor = NewValue
                END IF
             END IF
          CASE ELSE
             ' custom color overrides.
             NewValue = INT(VAL(Setting$))
             IF NewValue >= 0 AND NewValue <= 7 THEN
                ' menu box ansi color override.
                SELECT CASE UCASE$(Char$)
                CASE "BACKGROUND"
                   BackGround = NewValue
                CASE "BACKGROUND2"
                   BackGround2 = NewValue
                END SELECT
             END IF
             IF NewValue >= 0 AND NewValue <= 15 THEN
                ' menu box ansi color overrides.
                SELECT CASE UCASE$(Char$)
                CASE "BLACK"
                   Black = NewValue
                CASE "BLUE"
                   Blue = NewValue
                CASE "CYAN"
                   Cyan = NewValue
                CASE "GREEN"
                   Green = NewValue
                CASE "MAGENTA"
                   Magenta = NewValue
                CASE "PLAIN"
                   Plain = NewValue
                CASE "RED"
                   Red = NewValue
                CASE "WHITE"
                   White = NewValue
                CASE "YELLOW"
                   Yellow = NewValue
                END SELECT
             END IF
             ' check ascii value.
             IF NewValue >= 0 AND NewValue <= 255 THEN
                ' menu box ansi character overrides.
                SELECT CASE UCASE$(Char$)
                CASE "HLINE"
                   Hline = NewValue
                CASE "VLINE"
                   Vline = NewValue
                CASE "ULCORNER"
                   ULcorner = NewValue
                CASE "URCORNER"
                   URcorner = NewValue
                CASE "LLCORNER"
                   LLcorner = NewValue
                CASE "LRCORNER"
                   LRcorner = NewValue
                END SELECT
             END IF
          END SELECT
       END IF
    END IF
 LOOP
 RETURN

TopProgram:
 CLOSE #1
 EXIT SUB

' remove spaces.
Remove.Spaces:
 Var1$ = FileLine$
 DO
    Parse = INSTR(Var1$, " ")
    IF Parse THEN
       Var1$ = LEFT$(Var1$, Parse - 1) + MID$(Var1$, Parse + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 FileLine$ = Var1$
 Return

' removes commas
Remove.Commas:
 Var3$=Setting$
 Do
    Var=Instr(Var3$,",")
    If Var Then
       Var3$=Left$(Var3$,Var-1)+Mid$(Var3$,Var+1)
    Else
       Exit Do
    Endif
 Loop
 Return

' critical error trap.
Error.Routine2:
 CLS
 ' display error message.
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor ReadConfigFile " + Version + " " + Release + " critical error trap:"
 ' display error.
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Bad "+VarX$+" CONST value in Hexedit.inc - Edit file and recompile."
 ' delete process filenames.
 CALL Delete.Process
 END 2
END SUB

REM Drop down menu subroutine:

REM Returns: variable CurrentMenu equals 1 to 7, or 0 if exit,
REM  variable CurrentMenuSelection is menu selection in CurrentMenu.

SUB DropDownMenu
 ' declare error trap.
 GOSUB StoreArea
TopProgram1:
 GOSUB DrawMenu
 GOSUB DrawCurrentMenuSelection

 ' keyboard/mouse input loop.
 DO
    CharInput$ = Nul

    ' call mouse subroutine.
    Z = MouseDriver

    ' check left mouse button.
    IF MouseButton1 THEN
       GOSUB MouseButton1X
    ELSE
       ' check right mouse button.
       IF MouseButton2 THEN
          GOSUB RestoreArea
          CurrentMenu = False
          EXIT SUB
       ELSE
          ' check mouse position.
          IF MouseX OR MouseY THEN
             GOSUB MoveMouse
          END IF
       END IF
    END IF

    ' store keyboard buffer.
    CharInput$ = INKEY$
    IF LEN(CharInput$) THEN
       SELECT CASE LEN(CharInput$)
       CASE 1
          CharInput$ = UCASE$(CharInput$)
          SELECT CASE ASC(CharInput$)
          CASE 65 TO 90 ' A - Z
             SELECT CASE CurrentMenu
             CASE 1
                VarZ = Instr("OCAVTX", CharInput$)
                IF VarZ THEN
                   GOSUB RestoreArea
                   CurrentMenuSelection = VarZ
                   EXIT SUB
                END IF
             CASE 2
                VarZ = Instr("AH", CharInput$)
                IF VarZ THEN
                   GOSUB RestoreArea
                   CurrentMenuSelection = VarZ
                   EXIT SUB
                END IF
             CASE 3
                VarZ = Instr("SF", CharInput$)
                IF VarZ THEN
                   GOSUB RestoreArea
                   CurrentMenuSelection = VarZ
                   EXIT SUB
                END IF
             CASE 4
                VarZ = Instr("ASRUB", CharInput$)
                IF VarZ THEN
                   GOSUB RestoreArea
                   CurrentMenuSelection = VarZ
                   EXIT SUB
                END IF
             CASE 5
                VarZ = Instr("BP", CharInput$)
                IF VarZ THEN
                   GOSUB RestoreArea
                   CurrentMenuSelection = VarZ
                   EXIT SUB
                END IF
             CASE 6
                VarZ = Instr("SF", CharInput$)
                IF VarZ THEN
                   GOSUB RestoreArea
                   CurrentMenuSelection = VarZ
                   EXIT SUB
                END IF
             CASE 7
                VarZ = Instr("SB", CharInput$)
                IF VarZ THEN
                   GOSUB RestoreArea
                   CurrentMenuSelection = VarZ
                   EXIT SUB
                END IF
             END SELECT
          CASE 9 ' Tab
             GOSUB MenuRight
          CASE 13 ' Enter
             GOSUB RestoreArea
             EXIT SUB
          CASE 27 ' Escape
             GOSUB RestoreArea
             CurrentMenu = False
             EXIT SUB
          END SELECT
       CASE 2
          SELECT CASE ASC(RIGHT$(CharInput$, 1))
          CASE 0 ' Control-Break
             GOSUB RestoreArea
             CurrentMenu = False
             EXIT SUB
          CASE 72, 141, 152 ' Up/Ctrl-Up/Alt-Up
             GOSUB MenuUp
          CASE 80, 145, 160 ' Down/Ctrl-Down/Alt-Down
             GOSUB MenuDown
          CASE 75, 15, 115, 155 ' Left/Shift-Tab/Ctrl-Left/Alt-Left
             GOSUB MenuLeft
          CASE 142, 74 ' Ctrl-Keypad-/Alt-Keypad-
             GOSUB MenuLeft
          CASE 77, 116, 157 ' Right/Ctrl-Right/Alt-Right
             GOSUB MenuRight
          CASE 144, 78 ' Ctrl-Keypad+/Alt-Keypad+
             GOSUB MenuRight
          CASE 71, 73, 119, 132 ' Home/PageUp/Ctrl-Home/Ctrl-PageUp
             GOSUB MenuFirst
          CASE 79, 81, 117, 118 ' End/PageDown/Ctrl-End/Ctrl-PageDown
             GOSUB MenuLast
          END SELECT
       END SELECT
    END IF
 LOOP
 EXIT SUB

' moves to menu first left
MenuFirst:
 IF CurrentMenu <> 1 THEN
    GOSUB RestoreArea
    CurrentMenu = 1
    GOSUB StoreArea
    GOSUB DrawMenu
    GOSUB DrawCurrentMenuSelection
 END IF
 RETURN

' moves to menu last right
MenuLast:
 IF CurrentMenu <> 7 THEN
    GOSUB RestoreArea
    CurrentMenu = 7
    GOSUB StoreArea
    GOSUB DrawMenu
    GOSUB DrawCurrentMenuSelection
 END IF
 RETURN

' moves one menu left, wrapping.
MenuLeft:
 GOSUB RestoreArea
 IF CurrentMenu = 1 THEN
    CurrentMenu = 7
 ELSE
    CurrentMenu = CurrentMenu - 1
 END IF
 GOSUB StoreArea
 GOSUB DrawMenu
 GOSUB DrawCurrentMenuSelection
 RETURN

' moves one menu right, wrapping.
MenuRight:
 GOSUB RestoreArea
 IF CurrentMenu = 7 THEN
    CurrentMenu = 1
 ELSE
    CurrentMenu = CurrentMenu + 1
 END IF
 GOSUB StoreArea
 GOSUB DrawMenu
 GOSUB DrawCurrentMenuSelection
 RETURN

' moves menu up, wrapping.
' selects CurrentMenuSelection variable.
MenuUp:
 SELECT CASE CurrentMenu
 CASE 1
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 6
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 2
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 3
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 4
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 5
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 5
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 6
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 7
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 1 THEN
       CurrentMenuSelection = 2
    ELSE
       CurrentMenuSelection = CurrentMenuSelection - 1
    END IF
    GOSUB DrawCurrentMenuSelection
 END SELECT
 RETURN

' moves menu down, wrapping.
' selects CurrentMenuSelection variable.
MenuDown:
 SELECT CASE CurrentMenu
 CASE 1
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 6 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 2
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 3
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 4
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 5 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 5
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 6
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 CASE 7
    GOSUB EraseCurrentMenuSelection
    IF CurrentMenuSelection = 2 THEN
       CurrentMenuSelection = 1
    ELSE
       CurrentMenuSelection = CurrentMenuSelection + 1
    END IF
    GOSUB DrawCurrentMenuSelection
 END SELECT
 RETURN

' removes hilight from current menu selection.
EraseCurrentMenuSelection:
 CALL HideM
 COLORf2 White, 0
 SelectColor = 0
 GOSUB DisplayCurrentMenuSelection
 COLORf2 White, 0
 CALL ShowM
 RETURN

' adds hilight to current menu selection.
DrawCurrentMenuSelection:
 CALL HideM
 COLORf2 White, 1
 SelectColor = 1
 GOSUB DisplayCurrentMenuSelection
 COLORf2 White, 0
 CALL ShowM
 RETURN

' draws current menu selection.
DisplayCurrentMenuSelection:
 SELECT CASE CurrentMenu
 CASE 1
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 7, 0
       PRINTf "Open New File  "
       Colorf2 Magenta, SelectColor
       Locatef 3, 7, 0
       Printf "O"
    CASE 2
       LOCATEf 4, 7, 0
       PRINTf "Close File     "
       Colorf2 Magenta, SelectColor
       Locatef 4, 7, 0
       Printf "C"
    CASE 3
       LOCATEf 5, 7, 0
       PRINTf "Close All Files"
       Colorf2 Magenta, SelectColor
       Locatef 5, 13, 0
       Printf "A"
    CASE 4
       LOCATEf 6, 7, 0
       PRINTf "View Files     "
       Colorf2 Magenta, SelectColor
       Locatef 6, 7, 0
       Printf "V"
    CASE 5
       LOCATEf 7, 7, 0
       PRINTf "Toggle Window  "
       Colorf2 Magenta, SelectColor
       Locatef 7, 7, 0
       Printf "T"
    CASE 6
       LOCATEf 8, 7, 0
       PRINTf "Exit Program   "
       Colorf2 Magenta, SelectColor
       Locatef 8, 8, 0
       Printf "x"
    END SELECT
 CASE 2
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 17, 0
       PRINTf "ANSI Chart"
       Colorf2 Magenta, SelectColor
       Locatef 3, 17, 0
       Printf "A"
    CASE 2
       LOCATEf 4, 17, 0
       PRINTf "HEX Chart "
       Colorf2 Magenta, SelectColor
       Locatef 4, 17, 0
       Printf "H"
    END SELECT
 CASE 3
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 27, 0
       PRINTf "HEX Screen Dump"
       Colorf2 Magenta, SelectColor
       Locatef 3, 31, 0
       Printf "S"
    CASE 2
       LOCATEf 4, 27, 0
       PRINTf "HEX File Dump  "
       Colorf2 Magenta, SelectColor
       Locatef 4, 31, 0
       Printf "F"
    END SELECT
 CASE 4
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 37, 0
       PRINTf "Append Bytes       "
       Colorf2 Magenta, SelectColor
       Locatef 3, 37, 0
       Printf "A"
    CASE 2
       LOCATEf 4, 37, 0
       PRINTf "Append ASCII String"
       Colorf2 Magenta, SelectColor
       Locatef 4, 50, 0
       Printf "S"
    CASE 3
       LOCATEf 5, 37, 0
       PRINTf "Redraw Screen      "
       Colorf2 Magenta, SelectColor
       Locatef 5, 37, 0
       Printf "R"
    CASE 4
       LOCATEf 6, 37, 0
       PRINTf "Undo Last Byte     "
       Colorf2 Magenta, SelectColor
       Locatef 6, 37, 0
       Printf "U"
    CASE 5
       LOCATEf 7, 37, 0
       PRINTf "Undo All Bytes     "
       Colorf2 Magenta, SelectColor
       Locatef 7, 46, 0
       Printf "B"
    END SELECT
 CASE 5
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 47, 0
       PRINTf "Jump To Byte"
       Colorf2 Magenta, SelectColor
       Locatef 3, 55, 0
       Printf "B"
    CASE 2
       LOCATEf 4, 47, 0
       PRINTf "Jump To Page"
       Colorf2 Magenta, SelectColor
       Locatef 4, 55, 0
       Printf "P"
    END SELECT
 CASE 6
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 57, 0
       PRINTf "HEX Screen Print"
       Colorf2 Magenta, SelectColor
       Locatef 3, 61, 0
       Printf "S"
    CASE 2
       LOCATEf 4, 57, 0
       PRINTf "HEX File Print  "
       Colorf2 Magenta, SelectColor
       Locatef 4, 61, 0
       Printf "F"
    END SELECT
 CASE 7
    SELECT CASE CurrentMenuSelection
    CASE 1
       LOCATEf 3, 65, 0
       PRINTf "Search String"
       Colorf2 Magenta, SelectColor
       Locatef 3, 72, 0
       Printf "S"
    CASE 2
       LOCATEf 4, 65, 0
       PRINTf "Search Bytes "
       Colorf2 Magenta, SelectColor
       Locatef 4, 72, 0
       Printf "B"
    END SELECT
 END SELECT
 RETURN

' draws menu.
DrawMenu:
 CurrentMenuSelection = 1
 GOSUB BoxBorder
 BoxDrawX1 = Xstore1
 BoxDrawX2 = Xstore2
 BoxDrawY1 = Ystore1
 BoxDrawY2 = Ystore2
 CALL HideM
 SELECT CASE CurrentMenu
 CASE 1
    BoxDrawLength = 17
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 7, 0
    PRINTf "Open New File  "
    LOCATEf 4, 7, 0
    PRINTf "Close File     "
    LOCATEf 5, 7, 0
    PRINTf "Close All Files"
    LOCATEf 6, 7, 0
    PRINTf "View Files     "
    LOCATEf 7, 7, 0
    PRINTf "Toggle Window  "
    LOCATEf 8, 7, 0
    PRINTf "Exit Program   "
    Colorf Magenta
    Locatef 3, 7, 0
    Printf "O"
    Locatef 4, 7, 0
    Printf "C"
    Locatef 5, 13, 0
    Printf "A"
    Locatef 6, 7, 0
    Printf "V"
    Locatef 7, 7, 0
    Printf "T"
    Locatef 8, 8, 0
    Printf "x"
 CASE 2
    BoxDrawLength = 12
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 17, 0
    PRINTf "ANSI Chart"
    LOCATEf 4, 17, 0
    PRINTf "HEX Chart "
    Colorf Magenta
    Locatef 3, 17, 0
    Printf "A"
    Locatef 4, 17, 0
    Printf "H"
 CASE 3
    BoxDrawLength = 17
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 27, 0
    PRINTf "HEX Screen Dump"
    LOCATEf 4, 27, 0
    PRINTf "HEX File Dump  "
    Colorf Magenta
    Locatef 3, 31, 0
    Printf "S"
    Locatef 4, 31, 0
    Printf "F"
 CASE 4
    BoxDrawLength = 21
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 37, 0
    PRINTf "Append Bytes       "
    LOCATEf 4, 37, 0
    PRINTf "Append ASCII String"
    LOCATEf 5, 37, 0
    PRINTf "Redraw Screen      "
    LOCATEf 6, 37, 0
    PRINTf "Undo Last Byte     "
    LOCATEf 7, 37, 0
    PRINTf "Undo All Bytes     "
    Colorf Magenta
    Locatef 3, 37, 0
    Printf "A"
    Locatef 4, 50, 0
    Printf "S"
    Locatef 5, 37, 0
    Printf "R"
    Locatef 6, 37, 0
    Printf "U"
    Locatef 7, 46, 0
    Printf "B"
 CASE 5
    BoxDrawLength = 14
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 47, 0
    PRINTf "Jump To Byte"
    LOCATEf 4, 47, 0
    PRINTf "Jump To Page"
    Colorf Magenta
    Locatef 3, 55, 0
    Printf "B"
    Locatef 4, 55, 0
    Printf "P"
 CASE 6
    BoxDrawLength = 18
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 57, 0
    PRINTf "HEX Screen Print"
    LOCATEf 4, 57, 0
    PRINTf "HEX File Print  "
    Colorf Magenta
    Locatef 3, 61, 0
    Printf "S"
    Locatef 4, 61, 0
    Printf "F"
 CASE 7
    BoxDrawLength = 15
    GOSUB DrawBox
    COLORf White
    LOCATEf 3, 65, 0
    PRINTf "Search String"
    LOCATEf 4, 65, 0
    PRINTf "Search Bytes "
    Colorf Magenta
    Locatef 3, 72, 0
    Printf "S"
    Locatef 4, 72, 0
    Printf "B"
 END SELECT
 CALL ShowM
 RETURN

' stores area under menu.
StoreArea:
 IF CurrentMenu = False THEN
    RETURN
 END IF
 CALL HideM
 GOSUB BoxBorder
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = Xstore1 TO Xstore2
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = Ystore1 TO Ystore2
       ColumnY1 = ColumnY1 + 1
       ' store ascii character.
       Area1(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2)
       ' store color. (undocumented: also stores background color).
       Area2(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2, 1)
    NEXT
 NEXT
 ' hilight menu tab.
 COLORf2 White, 1
 CALL DisplayTab(CurrentMenu)
 CALL ShowM
 RETURN

' restores area under menu.
RestoreArea:
 IF CurrentMenu = False THEN
    RETURN
 END IF
 CALL HideM
 GOSUB BoxBorder
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = Xstore1 TO Xstore2
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = Ystore1 TO Ystore2
       ColumnY1 = ColumnY1 + 1
       LOCATEf RowX2, ColumnY2, 1
       ' restore color.
       TempZ = Area2(RowX1, ColumnY1)
       ' undocumented: also stores background color.
       VarB = INT(TempZ / 16)
       VarF = TempZ MOD 16
       COLORf2 VarF, VarB
       ' restore ascii character.
       PRINTf CHR$(Area1(RowX1, ColumnY1))
    NEXT
 NEXT
 ' remove hilight menu tab.
 COLORf2 White, 0
 CALL DisplayTab(CurrentMenu)
 CALL ShowM
 RETURN

' returns borders of box.
BoxBorder:
 SELECT CASE CurrentMenu
 CASE 1
    Xstore1 = 2
    Xstore2 = 9
    Ystore1 = 6
    Ystore2 = 22
 CASE 2
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 16
    Ystore2 = 27
 CASE 3
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 26
    Ystore2 = 42
 CASE 4
    Xstore1 = 2
    Xstore2 = 8
    Ystore1 = 36
    Ystore2 = 56
 CASE 5
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 46
    Ystore2 = 59
 CASE 6
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 56
    Ystore2 = 73
 CASE 7
    Xstore1 = 2
    Xstore2 = 5
    Ystore1 = 64
    Ystore2 = 78
 END SELECT
 RETURN

' draws box from (BoxDrawX1,BoxDrawY1) To (BoxDrawX2,BoxDrawY2),
'  length of box from left to right being BoxDrawLength.
DrawBox:
 COLORf Yellow
 LOCATEf BoxDrawX1, BoxDrawY1, 0
 PRINTf CHR$(ULcorner) + STRING$(BoxDrawLength - 2, Hline) + CHR$(URcorner)
 FOR RowX1 = BoxDrawX1 + 1 TO BoxDrawX2 - 1
    LOCATEf RowX1, BoxDrawY1, 0
    PRINTf CHR$(Vline)
    LOCATEf RowX1, BoxDRawY2, 0
    PRINTf CHR$(Vline)
 NEXT
 LOCATEf BoxDrawX2, BoxDrawY1, 0
 PRINTf CHR$(LLcorner) + STRING$(BoxDrawLength - 2, Hline) + CHR$(LRcorner)
 RETURN

' process mouse move.
MoveMouse:
 ' select drop down menu.
 IF MouseX = 1 THEN
    NewMenuSelection = False
    SELECT CASE MouseY
    CASE 6 TO 9 ' File
       NewMenuSelection = 1
    CASE 16 TO 21 ' Charts
       NewMenuSelection = 2
    CASE 26 TO 29 ' Dump
       NewMenuSelection = 3
    CASE 36 TO 39 ' Edit
       NewMenuSelection = 4
    CASE 46 TO 49 ' Jump
       NewMenuSelection = 5
    CASE 56 TO 60 ' Print
       NewMenuSelection = 6
    CASE 64 TO 69 ' Search
       NewMenuSelection = 7
    END SELECT
    IF NewMenuSelection > False THEN
       IF NewMenuSelection <> CurrentMenu THEN
          IF CurrentMenu > False THEN
             GOSUB RestoreArea
          END IF
          CurrentMenu = NewMenuSelection
          CurrentMenuSelection = 1
          GOSUB StoreArea
          GOSUB DrawMenu
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
    IF CurrentMenu > False THEN
       CALL HideM
       COLORf2 White, 1
       CALL DisplayTab(CurrentMenu)
       CALL ShowM
    END IF
    RETURN
 END IF
 ' check mouse selection boundaries.
 SELECT CASE CurrentMenu
 CASE 1
    IF MouseX >=3 AND MouseX <= 8 THEN
       IF MouseY >= 7 AND MouseY <= 21 THEN
          IF MouseX - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = MouseX - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 2
    IF MouseX >=3 AND MouseX <= 4 THEN
       IF MouseY >= 17 AND MouseY <= 26 THEN
          IF MouseX - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = MouseX - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 3
    IF MouseX >=3 AND MouseX <= 4 THEN
       IF MouseY >= 27 AND MouseY <= 41 THEN
          IF MouseX - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = MouseX - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 4
    IF MouseX >=3 AND MouseX <= 7 THEN
       IF MouseY >= 37 AND MouseY <= 55 THEN
          IF MouseX - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = MouseX - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 5
    IF MouseX >=3 AND MouseX <= 5 THEN
       IF MouseY >= 47 AND MouseY <= 58 THEN
          IF MouseX - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = MouseX - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 6
    IF MouseX >=3 AND MouseX <= 5 THEN
       IF MouseY >= 57 AND MouseY <= 72 THEN
          IF MouseX - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = MouseX - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 CASE 7
    IF MouseX >=3 AND MouseX <= 5 THEN
       IF MouseY >= 65 AND MouseY <= 77 THEN
          IF MouseX - 2 <> CurrentMenuSelection THEN
             GOSUB EraseCurrentMenuSelection
             CurrentMenuSelection = MouseX - 2
          END IF
          GOSUB DrawCurrentMenuSelection
       END IF
    END IF
 END SELECT
 RETURN

' process left mouse button.
MouseButton1X:
 ExitMouse = False
 IF MouseX - 2 = CurrentMenuSelection THEN
    SELECT CASE CurrentMenu
    CASE 1
       IF MouseY >= 7 AND MouseY <= 21 THEN
          ExitMouse = True
       END IF
    CASE 2
       IF MouseY >= 17 AND MouseY <= 26 THEN
          ExitMouse = True
       END IF
    CASE 3
       IF MouseY >= 27 AND MouseY <= 41 THEN
          ExitMouse = True
       END IF
    CASE 4
       IF MouseY >= 37 AND MouseY <= 55 THEN
          ExitMouse = True
       END IF
    CASE 5
       IF MouseY >= 47 AND MouseY <= 58 THEN
          ExitMouse = True
       END IF
    CASE 6
       IF MouseY >= 57 AND MouseY <= 72 THEN
          ExitMouse = True
       END IF
    CASE 7
       IF MouseY >= 65 AND MouseY <= 77 THEN
          ExitMouse = True
       END IF
    END SELECT
    ' exit subroutine with menu selection.
    IF ExitMouse THEN
       GOSUB RestoreArea
       EXIT SUB
    END IF
 END IF
 RETURN

TopProgram2:
 EXIT SUB

END SUB

' inits mouse.
SUB ClearMouse
 WHILE _MOUSEINPUT: WEND ' empty buffer
END SUB

REM Deconcatenates a filename to a specified length
REM  with imbedded \..\ character strings.
REM
REM Input:
REM   Y$ - Netpath (full path)
REM   Z$ - DosPath (ambiguated)
REM   Z% - Length (32-64)
REM
REM Returns:
REM   Z$ - Concatenated path
REM     C:\path\..\path\
REM   or,
REM     For remote or default server:
REM       \\server name\share name\path\..\path\

SUB Deconcatenate(Y$,Z$,Z%)
 Y$ = UCASE$(Y$)
 Z$ = UCASE$(Z$)
 ' check netpath.
 IF LEN(Y$) THEN
    ' store net path.
    Y1$ = UCASE$(Y$)
    IF RIGHT$(Y1$, 1) <> "\" THEN
       Y1$ = Y1$ + "\"
    END IF

    ' check default net path.
    IF RTRIM$(DefaultNetPath) <> Nul THEN

       ' store default netpath.
       Z1$ = "\\" + UCASE$(RTRIM$(DefaultNetPath)) + "\"

       ' check netpath is in default path.
       IF LEFT$(Y1$, LEN(Z1$)) = Z1$ THEN

          ' ambiguate netpath.
          ASCIIZ3 = ASCIIZ
          ASCIIZ = Y1$ + CHR$(0)
          CALL GetShortFilename(Short.Filename$)
          ASCIIZ = ASCIIZ3

          ' store ambiguated netpath.
          N1$ = Short.Filename$
       END IF
    END IF
    IF N1$ = Nul THEN
       N1$ = Y1$
    END IF
    N1$ = UCASE$(N1$)

    ' truncate drive letter.
    IF MID$(N1$, 2, 1) = ":" THEN
       N1$ = MID$(N1$, 3)
    END IF

    ' truncate netpath from dospath.
    IF LEFT$(Z$, LEN(N1$)) = N1$ THEN
       Z$ = MID$(Z$, LEN(N1$) + 1)
    END IF

    ' get ending position of server name.
    Y2 = INSTR(3, Y1$, "\")

    ' get ending position of share name.
    Y3 = INSTR(Y2 + 1, Y1$, "\")

    ' get server\share name.
    Y1$ = LEFT$(Y1$, Y3)
 END IF

 ' check path
 IF INSTR(Z$, "\") = False THEN
    IF LEN(Y$) THEN
       Z$ = Y1$ + Z$
    END IF
    IF LEN(Z$) > Z% THEN
       Z$ = LEFT$(Z$, Z% - 3) + "..."
    END IF
    EXIT SUB
 END IF

 ' decrement length of netpath
 Z1% = Z%
 IF LEN(Y1$) THEN
    Z1% = Z1% - LEN(Y1$)
    IF Z1% <= 0 THEN
       Z$ = LEFT$(Y1$, Z% - 3) + "..."
       EXIT SUB
    END IF
    Z1% = Z1% + 1
 END IF

 ' deconcatenate path
 IF Y$ <> Nul THEN
    IF LEFT$(Z$, 1) <> "\" THEN
       Z$ = "\" + Z$
    END IF
 END IF
 DO
    IF LEN(Z$) > Z1% THEN
       V1 = INSTR(Z$, "\")
       IF V1 > 0 THEN
          DO
             IF MID$(Z$, V1, 4) = "\..\" THEN
                V1 = INSTR(V1 + 1, Z$, "\")
             ELSE
                EXIT DO
             END IF
          LOOP
          V2 = INSTR(V1 + 1, Z$, "\")
          IF V2 > 0 THEN
             Z$ = LEFT$(Z$, V1) + ".." + MID$(Z$, V2)
          ELSE
             EXIT DO
          END IF
       END IF
    ELSE
       EXIT DO
    END IF
    ' remove redundant paths
    DO
       V = INSTR(Z$, "\..\..\")
       IF V > 0 THEN
          Z$ = LEFT$(Z$, V - 1) + "\..\" + MID$(Z$, V + 7)
       ELSE
          EXIT DO
       END IF
    LOOP
 LOOP

 ' remove redundant paths
 DO
    V = INSTR(Z$, "\..\..\")
    IF V > 0 THEN
       Z$ = LEFT$(Z$, V - 1) + "\..\" + MID$(Z$, V + 7)
    ELSE
       EXIT DO
    END IF
 LOOP

 ' prepend net path
 IF LEN(Y1$) THEN
    IF Z$ = "\" THEN
       Z$ = Y1$
    ELSE
       IF LEFT$(Z$, 2) = "\\" THEN
          N1$ = Z$
       ELSE
          IF LEFT$(Z$, 1) = "\" THEN
             Z$ = Y1$ + MID$(Z$, 2)
          ELSE
             Z$ = Y1$ + Z$
          END IF
       END IF
    END IF
 END IF

 ' truncate to length
 IF LEN(Z$) > Z% THEN
    Z$ = LEFT$(Z$, Z% - 3) + "..."
 END IF
END SUB

REM Initialize files.
REM   Tests temp environment directories,
REM   temp directory, root, then default.

SUB OpenDataFiles(V1$, V2$)
 V$ = ENVIRON$("TMP")
 IF V$ = Nul THEN
    V$ = ENVIRON$("TEMP")
 END IF
 IF LEN(V$) THEN
    IF LEFT$(V$, 1) = CHR$(34) THEN
       V$ = MID$(V$, 2)
    END IF
    IF RIGHT$(V$, 1) = CHR$(34) THEN
       V$ = LEFT$(V$, LEN(V$) - 1)
    END IF
    IF RIGHT$(V$, 1) = "\" THEN
       F1$ = V$ + V1$
    ELSE
       F1$ = V$ + "\" + V1$
    END IF
    F2$ = Nul
    IF LEN(V2$) THEN
       IF RIGHT$(V$, 1) = "\" THEN
          F2$ = V$ + V2$
       ELSE
          F2$ = V$ + "\" + V2$
       END IF
    END IF
    IF TestFile(F1$) THEN
       IF F2$ = Nul THEN
          GOTO OpenDataFilename
       END IF
       IF TestFile(F2$) THEN
          GOTO OpenDataFilename
       END IF
    END IF
 END IF
 F1$ = "C:\TEMP\" + V1$
 IF LEN(V2$) THEN
    F2$ = "C:\TEMP\" + V2$
 END IF
 IF TestFile(F1$) THEN
    IF F2$ = Nul THEN
       GOTO OpenDataFilename
    END IF
    IF TestFile(F2$) THEN
       GOTO OpenDataFilename
    END IF
 END IF
 F1$ = "C:\" + V1$
 IF LEN(V2$) THEN
    F2$ = "C:\" + V2$
 END IF
 IF TestFile(F1$) THEN
    IF F2$ = Nul THEN
       GOTO OpenDataFilename
    END IF
    IF TestFile(F2$) THEN
       GOTO OpenDataFilename
    END IF
 END IF
 F1$ = V1$
 IF LEN(V2$) THEN
    F2$ = V2$
 END IF
 IF TestFile(F1$) THEN
    IF F2$ = Nul THEN
       GOTO OpenDataFilename
    END IF
    IF TestFile(F2$) THEN
       GOTO OpenDataFilename
    END IF
 END IF
 ERROR 76
 END

' returns filenames.
OpenDataFilename:
 V1$ = F1$
 V2$ = F2$
 EXIT SUB
END SUB

' initialize directory/filename record.
SUB OpenDataFiles1
 V1$ = "HEXEDIT1.DA" + MID$(STR$(Process.Number), 2)
 V2$ = "HEXEDIT2.DA" + MID$(STR$(Process.Number), 2)
 MultiFilename1(4)=Nul
 MultiFilename1(5)=Nul
 CLOSE #2, #3
 ' open filename random record structure for windows.
 OPEN V1$ FOR RANDOM AS #2 LEN = LEN(WinFileStruc)
 ' open directory random record structure for windows.
 OPEN V2$ FOR RANDOM AS #3 LEN = LEN(WinFileStruc)
 MultiFilename1(4)=V1$
 MultiFilename1(5)=V2$
END SUB

' redraws menu tab.
SUB DisplayTab(Var)
 SELECT CASE Var
 CASE 1 ' File
    LOCATEf 1, 6, 0
    PRINTf "File"
 CASE 2 ' Charts
    LOCATEf 1, 16, 0
    PRINTf "Charts"
 CASE 3 ' Dump
    LOCATEf 1, 26, 0
    PRINTf "Dump"
 CASE 4 ' Edit
    LOCATEf 1, 36, 0
    PRINTf "Edit"
 CASE 5 ' Jump
    LOCATEf 1, 46, 0
    PRINTf "Jump"
 CASE 6 ' Print
    LOCATEf 1, 56, 0
    PRINTf "Print"
 CASE 7 ' Search
    LOCATEf 1, 64, 0
    PRINTf "Search"
 END SELECT
 COLORf2 White, 0
END SUB

' display error trap message.
SUB DisplayCriticalError(Var)
 SELECT CASE Var
 CASE 5
    ' Ctrl-E TestError w/ debug will display
    '   syntax error for debug purposes.

    PRINTf "Syntax error."
 CASE 6
    PRINTf "Overflow."
 CASE 9
    PRINTf "Subscript out of range."
 CASE 14
    PRINTf "Out of string space."
 CASE 24
    PRINTf "Device timeout."
 CASE 25
    PRINTf "Device fault."
 CASE 27
    PRINTf "Out of paper."
 CASE 52
    PRINTf "Bad file name or number."
 CASE 53
    PRINTf "File not found."
 CASE 54
    PRINTf "Bad file mode."
 CASE 55
    PRINTf "File already open."
 CASE 57
    PRINTf "Device I/O error."
 CASE 58
    PRINTf "File already exists."
 CASE 59
    PRINTf "Bad record length."
 CASE 61
    PRINTf "Disk full."
 CASE 62
    PRINTf "Input past eof."
 CASE 63
    PRINTf "Bad record length."
 CASE 64
    PRINTf "Bad file name."
 CASE 67
    PRINTf "Not enough file handles."
 CASE 68
    PRINTf "Device unavailable."
 CASE 70
    PRINTf "Permission denied."
 CASE 71
    PRINTf "Disk not ready."
 CASE 72
    PRINTf "Disk-media error."
 CASE 75
    PRINTf "Path/File access error."
 CASE 76
    PRINTf "Pathname not found."
 CASE 81
    PRINTf "Invalid name."
 CASE 90
    PRINTf "Too many processes."
 CASE ELSE
    PRINTf "Untrapped error" + STR$(Var) + "."
 END SELECT
 END SUB

' construct file/dir exclusion list.
SUB ExcludeList(V1,Y$)
 IF V1 = 1 THEN
    LOCATEf Xcoor + 1, Ycoor + 2, 1
    PRINTf SPACE$(38)
    LOCATEf Xcoor + 1, Ycoor + 2, 1
    COLORf2 White, 0
    PRINTf "Enter file spec: "
    Y$ = lineinput$(Xcoor + 1, Ycoor + 19, 21)
 ELSE
    LOCATEf Xcoor + 1, Ycoor + 2, 1
    PRINTf SPACE$(38)
    LOCATEf Xcoor + 1, Ycoor + 2, 1
    COLORf2 White, 0
    PRINTf "Enter dir spec: "
    Y$ = lineinput$(Xcoor + 1, Ycoor + 18, 22)
 END IF
 IF LEN(Y$) THEN
    ' process filelist
    IF LEFT$(Y$, 1) = "@" THEN
       Filename2$ = UCASE$(MID$(Y$, 2))
       Y$ = Nul
       IF LEN(Filename2$) THEN
          Check.Disk = True
          Disk.Ready = False
          ErrorTrap = False
          CLOSE #1
          ASCIIZ3 = ASCIIZ
          ASCIIZ = Filename2$ + CHR$(0)
          CALL GetShortFilename(Short.Filename$)
          ASCIIZ = ASCIIZ3
          Filename2$ = Short.Filename$
          IF _FILEEXISTS(Filename2$) = 0 THEN
             LOCATEf Xcoor + 1, Ycoor + 2, 1
             PRINTf SPACE$(38)
             LOCATEf Xcoor + 1, Ycoor + 2, 1
             COLORf2 White, 0
             PRINTf "Filelist not found. Press <esc>:"
             CALL Prompt.Inkey
             RETURN
          END IF
          OPEN Filename2$ FOR INPUT AS #1
          Check.Disk = False
          IF Disk.Ready OR ErrorTrap THEN
             LOCATEf Xcoor + 1, Ycoor + 2, 1
             PRINTf SPACE$(38)
             LOCATEf Xcoor + 1, Ycoor + 2, 1
             COLORf2 White, 0
             PRINTf "Filelist not found. Press <esc>:"
             CALL Prompt.Inkey
             RETURN
          END IF
          DO UNTIL EOF(1)
             LINE INPUT #1, Y1$
             Y1$ = LTRIM$(Y1$)
             Y1$ = RTRIM$(Y1$)
             Y1$ = UCASE$(Y1$)
             IF LEN(Y1$) THEN
                IF LEFT$(Y1$, 1) = Quote THEN
                   Y1$ = MID$(Y1$, 2)
                   IF RIGHT$(Y1$, 1) = Quote THEN
                      Y1$ = LEFT$(Y1$, LEN(Y1$) - 1)
                   END IF
                END IF
                IF LEN(Y1$) THEN
                   IF INSTR(Y1$, " ") = False THEN
                      ' add excluded filename.
                      Y$ = Y$ + Y1$ + " "
                      IF LEN(Y$) > 4096 THEN
                         Y$ = Nul
                         EXIT DO
                      END IF
                   END IF
                END IF
             END IF
          LOOP
          LOCATEf Xcoor + 1, Ycoor + 2, 1
          PRINTf SPACE$(38)
          LOCATEf Xcoor + 1, Ycoor + 2, 1
          COLORf2 White, 0
          IF LEN(Y$) THEN
             PRINTf "Filelist loaded. Press <esc>:"
          ELSE
             PRINTf "Filelist not loaded. Press <esc>:"
          END IF
          CALL Prompt.Inkey
       END IF
    END IF
 END IF
 Y$ = LTRIM$(Y$)
 Y$ = RTRIM$(Y$)
END SUB

' display screen border.
SUB DisplayScreen2
 CLS
 COLORf Magenta
 PRINTf CHR$(ULcorner) + STRING$(76, Hline) + CHR$(URcorner)
 FOR Var2 = 2 TO 23
    LOCATEf Var2, 1, 0
    PRINTf CHR$(Vline)
    LOCATEf Var2, 78, 0
    PRINTf CHR$(Vline)
 NEXT
 LOCATEf 24, 1, 0
 PRINTf CHR$(LLcorner) + STRING$(76, Hline) + CHR$(LRcorner)
 COLORf Plain
END SUB

' display boot usage.
SUB DisplayBootUsage
 ' clear break flag
 DEF SEG = &H40
 POKE &H71, 0
 DEF SEG

 CLS
 COLORf White
 LOCATEf 1, 1, 0
 PRINTf "Hex Editor " + Version + " " + Release + "."
 COLORf Green
 LOCATEf 2, 1, 0
 PRINTf "Command Usage:"
 COLORf Yellow
 LOCATEf 3, 1, 0
 PRINTf "   Hexedit [@]<filename.ext>, [@]<filename.ext>, ..."
 COLORf Green
 LOCATEf 4, 1, 0
 PRINTf "Where:"
 COLORf Yellow
 LOCATEf 5, 1, 0
 PRINTf "   <filename.ext> is the file to edit.  May include drive/pathname, and"
 LOCATEf 6, 1, 0
 PRINTf "   supports long filenames in quotes. Filename may be omitted. Multiple"
 LOCATEf 7, 1, 0
 PRINTf "   files allowed with * and ? characters. Maximum of 9 files available."
 LOCATEf 8, 1, 0
 PRINTf "   Filename prepended with @ loads filelist from contents of text file."
 LOCATEf 9, 1, 0
 PRINTf "   May also contain server and share name if prepended as \\serv1\share\"
 COLORf Green
 LOCATEf 10, 1, 0
 PRINTf "Example:"
 COLORf Yellow
 LOCATEf 11, 1, 0
 PRINTf "   Hexedit " + CHR$(34) + "\dos\page.com" + CHR$(34)
 LOCATEf 12, 1, 0
 PRINTf "   Or use the file menu box by starting Hexedit without a filename."
 COLORf Green
 LOCATEf 13, 1, 0
 PRINTf "File Menu Box Usage:"
 COLORf Yellow
 LOCATEf 14, 1, 0
 PRINTf "   Navigate using cursors, selecting with <enter>, and switch windows"
 LOCATEf 15, 1, 0
 PRINTf "   with <tab> and Shift-<tab>. Exits to editor or DOS with <escape>."
 COLORf Green
 LOCATEf 16, 1, 0
 PRINTf "File Editor Usage:"
 COLORf Yellow
 LOCATEf 17, 1, 0
 PRINTf "   Enter editing functions or cursor movement through the hex values,"
 LOCATEf 18, 1, 0
 PRINTf "   while changing them with <enter>, <delete> or <insert> as you edit."
 COLORf Green
 LOCATEf 19, 1, 0
 PRINTf "Author status:"
 COLORf Yellow
 LOCATEf 20, 1, 0
 PRINTf "   Written by: "+Author$
 LOCATEf 21, 1, 0
 PRINTf "   Email: "+Email
 LOCATEf 22, 1, 0
 PRINTf "   Urls: "+Urls
 LOCATEf 23, 1, 0
 PRINTf ""
END SUB

' display main program editing screen.
SUB DisplayScreen
CALL HideM
CLS
COLORf Magenta
LOCATEf 1, 1, 0
PRINTf " " + CHR$(ULcorner)
PRINTf STRING$(3,HLine)
COLORf White
PRINTf "File"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Charts"
COLORf Magenta
PRINTf STRING$(4,HLine)
COLORf White
PRINTf "Dump"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Edit"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Jump"
COLORf Magenta
PRINTf STRING$(6,HLine)
COLORf White
PRINTf "Print"
COLORf Magenta
PRINTf STRING$(3,HLine)
COLORf White
PRINTf "Search"
COLORf Magenta
PRINTf CHR$(Hline)+Chr$(Hline)
COLORf Yellow
PRINTf Version
COLORf Magenta
PRINTf STRING$(1,HLine)
PRINTf CHR$(URcorner)
LOCATEf 2, 1, 0
PRINTf " " + CHR$(Vline) + STRING$(75, 32) + CHR$(Vline)
LOCATEf 3, 1, 0
PRINTf " " + CHR$(Vline) + " "
COLORf Green
PRINTf CHR$(ULcorner) + STRING$(46, Hline) + CHR$(URcorner) + " "
PRINTf CHR$(ULcorner) + STRING$(22, Hline) + CHR$(URcorner)
COLORf White
PRINTf "x"
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 4, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "0"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline)
COLORf White
PRINTf "<"
COLORf Green
PRINTf CHR$(Vline) + STRING$(22, 32) + CHR$(Vline)
COLORf White
PRINTf "?"
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 5, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "1"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline)
COLORf White
PRINTf "|"
COLORf Green
PRINTf CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 6, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "2"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 7, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "3"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 8, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "4"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 9, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "5"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 10, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "6"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 11, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "7"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 12, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "8"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 13, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "9"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 14, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "A"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 15, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "B"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 16, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "C"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 17, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "D"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 18, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "E"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline) + " " + CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 19, 1, 0
PRINTf " " + CHR$(Vline)
COLORf White
PRINTf "F"
COLORf Green
PRINTf CHR$(Vline) + STRING$(46, 32) + CHR$(Vline)
COLORf White
PRINTf "|"
COLORf Green
PRINTf CHR$(Vline) + STRING$(22, 32) + CHR$(Vline) + " "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 20, 1, 0
PRINTf " " + CHR$(Vline) + " "
COLORf Green
PRINTf CHR$(LLcorner) + STRING$(46, Hline) + CHR$(LRcorner)
COLORf White
PRINTf ">"
COLORf Green
PRINTf CHR$(LLcorner) + STRING$(22, Hline) + CHR$(LRcorner) + " "
COLORf Magenta
PRINTf CHR$(Vline)
' check to skip info line area.
IF ScreenRow THEN
   COLORf Magenta
   LOCATEf 21, 1, 0
   PRINTf " " + CHR$(LLcorner) + STRING$(75, Hline) + CHR$(LRcorner)
   COLORf Plain
   CALL ShowM
   EXIT SUB
END IF
LOCATEf 21, 1, 0
PRINTf " " + CHR$(Vline)
COLORf Yellow
PRINTf " Alt-A Append bytes, Alt-M Append string, Alt-C ANSI Chart, Alt-N New File "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 22, 1, 0
PRINTf " " + CHR$(Vline)
COLORf Yellow
PRINTf " Alt-H HEX Chart, Alt-R Redraw, Alt-S Search bytes, Alt-U Undo, Alt-X Exit "
COLORf Magenta
PRINTf CHR$(Vline)
LOCATEf 23, 1, 0
PRINTf " " + CHR$(Vline)
COLORf Yellow
PRINTf " Alt-J Jump, Alt-K Search string, Alt-D Dump, Alt-P Print, Alt-Z Undo All. "
COLORf Magenta
PRINTf CHR$(Vline)
COLORf Magenta
LOCATEf 24, 1, 0
PRINTf " " + CHR$(LLcorner) + STRING$(75, Hline) + CHR$(LRcorner)
COLORf Plain
CALL ShowM
END SUB

REM End-of-subprogram. Please deliver the cats now.
