REM Program: Hex Editor v8.0a, Module 6 of 6, PD 2016.
REM Author: Erik Jon Oredson AS. Csci
REM Release: 03/01/2016.
REM Status: Public Domain.
REM Email: eoredson@gmail.com
REM Urls: www.filegate.net www.simtel.net

' get include file.
REM $INCLUDE: 'hexedit.inc'

REM Replacement stub subroutines:
REM  LseekFile()
REM  ReadFile()
REM  Writefile()
REM  LockedFile()
REM  LocateCursor()
REM  LocateCursor2()
REM  LocateHilightCursor()
REM  BytePrint()
REM  DisplayX()
REM  DisplayPosition()
REM  ClearStatus()
REM  DisplayFilename()
REM  DisplayFileTitle()
REM  DisplayPageByte()
REM  ResetHilightBytes()
REM  ResetBytes()
REM  RestoreHilightBytes()
REM  ResetByte()
REM  ClearPageByte()
REM  ClearHilightByte()
REM  DisplayHilightByte()
REM  DisplayStatus1()
REM  DisplayStatus2()
REM  DisplayStatusLine()
REM  PromptKey()
REM  DisplayHexPage()
REM  RedrawRightWindow()
REM  RedrawWindow1()
REM  RedrawWindow2()
REM  PressKey()
REM  CheckASCIIValue(S$)
REM  CheckString(S$)
REM  CheckHexValue(S$)
REM  FormatPosition2(V%)
REM  AsciiToHex1(S$)
REM  AsciiToHex2(S$)
REM  CheckAsciiBytes(S$)
REM  CheckHexBytes(S$)
REM  GetShortFilename(S$)

REM position pointer in file.
SUB LseekFile
 SEEK Handle, SeekPosition
END SUB

REM read 1 byte from file.
SUB ReadFile
 GET Handle, SeekPosition, Buffer
END SUB

REM write 1 byte to file.
SUB WriteFile
 If FileLocked Then
    Write.Error = True
    Exit Sub
 Endif
 Check.Disk = True
 Disk.Ready = False
 Write.Error = False
 Buffer = FileByte
 PUT Handle, SeekPosition, Buffer
 Check.Disk = False
 IF Disk.Ready Then
    Write.Error = True
 Endif
END SUB

REM display file status message.
SUB LockedFile
 COLORf White
 If FileLocked Then
    If FileLength = False Then
       PRINTf "<locked file>"
    Else
       PRINTf "<read-only>"
    Endif
 Else
    PRINTf "<zero-byte>"
 Endif
 LOCATEf 1, 1, 0
END SUB

REM locate cursor on window.
SUB LocateCursor
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 IF CurrentWindow = False THEN
    LOCATEf PageRow + 3, Column + 5, 1
 ELSE
    LOCATEf PageRow + 3, PageColumn + 54, 1
 END IF
END SUB

REM select cursor on window.
SUB LocateCursor2
 IF CopyPositionStart = False THEN
    Call locatecursor
 ELSE
    Call locatehilightcursor
 END IF
END SUB

REM locate cursor on window for hilighted area.
SUB LocateHilightCursor
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 IF CurrentWindow = False THEN
    LOCATEf PageRow + 3, Column + 7, 1
 ELSE
    LOCATEf PageRow + 3, PageColumn + 55, 1
 END IF
END SUB

REM print byte at fileposition in edit area.
SUB BytePrint
 SeekPosition = FilePosition
 Call lseekfile
 Call readfile
 FileByte = Buffer
 ByteValue = ASC(FileByte)
 Column = CalculateColumn
 ' display hex byte.
 CALL HideM
 LOCATEf PageRow + 3, Column + 5, 0
 PRINTf RIGHT$("00" + HEX$(ByteValue), 2)
 ' check right window toggled.
 IF CurrentWindow2 = False THEN
    ' display ascii byte.
    LOCATEf PageRow + 3, PageColumn + 54, 0
    ' skip unprintable characters.
    SELECT CASE ByteValue
    CASE 0, 7, 9 TO 13, 28 TO 32
       PRINTf "."
    CASE ELSE
       PRINTf FileByte
    END SELECT
 END IF
 CALL ShowM
END SUB

REM display info on file being edited.
SUB DisplayPosition
 COLORf2 Yellow, 0
 StringLength = LEN("Editing file:" + RTRIM$(Filename) + " ") + 5
 LOCATEf 2, StringLength, 0
 PRINTf SPACE$(77 - StringLength)
 LOCATEf 2, StringLength, 0
 IF FileLength = False THEN
    Call lockedfile
    EXIT SUB
 END IF
 COLORf White
 IF CurrentWindow = False THEN
    PRINTf "Pos: " + FormatX$(FilePosition - 1 ,0) + " "
 ELSE
    PRINTf "Pos: " + RIGHT$("000000000000" + HEX$(FilePosition - 1), 8) + "H "
 END IF
 PRINTf "(Asc:" + STR$(AsciiValue)
 ' display ascii control code description
 If AsciiValue>=0 And AsciiValue<=32 Then
    PRINTf " :"
 Endif
 Select Case AsciiValue
 Case 0
    PRINTf "nul"
 Case 1
    PRINTf "soh"
 Case 2
    PRINTf "stx"
 Case 3
    PRINTf "etx"
 Case 4
    PRINTf "eot"
 Case 5
    PRINTf "enq"
 Case 6
    PRINTf "ack"
 Case 7
    PRINTf "bel"
 Case 8
    PRINTf "bs"
 Case 9
    PRINTf "tab"
 Case 10
    PRINTf "lf"
 Case 11
    PRINTf "vt"
 Case 12
    PRINTf "np"
 Case 13
    PRINTf "cr"
 Case 14
    PRINTf "so"
 Case 15
    PRINTf "si"
 Case 16
    PRINTf "dle"
 Case 17
    PRINTf "dc1"
 Case 18
    PRINTf "dc2"
 Case 19
    PRINTf "dc3"
 Case 20
    PRINTf "dc4"
 Case 21
    PRINTf "nak"
 Case 22
    PRINTf "syn"
 Case 23
    PRINTf "etb"
 Case 24
    PRINTf "can"
 Case 25
    PRINTf "em"
 Case 26
    PRINTf "eof"
 Case 27
    PRINTf "esc"
 Case 28
    PRINTf "fs"
 Case 29
    PRINTf "gs"
 Case 30
    PRINTf "rs"
 Case 31
    PRINTf "us"
 Case 32
    PRINTf "spc"
 End Select
 PRINTf ") "
 ' display hex code of ascii value
 'PRINTf "(Hex: " + RIGHT$("00" + HEX$(AsciiValue), 2) + "H)"
 Call locatecursor2
END SUB

REM clear top status area
SUB ClearStatus
 COLORf2 Yellow, 0
 LOCATEf 2, 4, 0
 PRINTf SPACE$(74)
 LOCATEf 2, 4, 0
END SUB

REM display name of file being edited.
SUB DisplayFilename
 Call DisplayX
 COLORf White
 IF FileLength = False THEN
    Call lockedfile
    EXIT SUB
 END IF
 Call displayposition
END SUB

REM display 64-byte name of file being editied.
SUB DisplayFileTitle
 ' redisplay line 3.
 LOCATEf 3, 4, 0
 COLORf Green
 PRINTf CHR$(ULcorner) + STRING$(46, Hline) + CHR$(URcorner) + " "
 PRINTf CHR$(ULcorner) + STRING$(22, Hline) + CHR$(URcorner)

 ' display filename.
 Z$ = RTRIM$(ShortFilename)
 N$ = RTRIM$(CurrentNetPath)
 IF N$ <> Nul THEN
    IF MID$(Z$, 2, 1) = ":" THEN
       Z$ = MID$(Z$, 3)
    END IF
 END IF
 CALL Deconcatenate(N$, Z$, 64)
 Z$ = MID$(STR$(CurrentFile), 2) + ": " + Z$
 Var = INT((80 - (LEN(RTRIM$(Z$))) + 2) / 2) - 1
 LOCATEf 3, Var, 0
 COLORf2 0, 7
 PRINTf " " + Z$ + " "
 COLORf2 7, 0
 Call locatecursor2
END SUB

REM display current byte being edited.
SUB DisplayPageByte
 ' check filename display.
 IF FileDisplay2 THEN
    FileDisplay2 = False
    Call DisplayX
    COLORf White
 END IF

 ' check filelength.
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF

 ' check hilighted bytes.
 IF CopyPositionStart > 0# THEN
    CALL ResetHilightBytes
 END IF

 ' display byte.
 COLORf Yellow
 Call byteprint

 ' store the current byte value being edited.
 AsciiValue = ASC(FileByte)
 Call displayposition
END SUB

REM reset hilight bytes.
SUB ResetHilightBytes
 Call ResetBytes

 ' adjust file position.
 IF PageColumn + 1 <= 20 THEN
    IF FilePosition + 1 <= FileLength THEN
       CALL ClearPageByte
       PageColumn = PageColumn + 1
       FilePosition = FilePosition + 1
       Call displaypagebyte
    END IF
 END IF
 COLORf Yellow
 Call byteprint
END SUB

REM reset hilighted byte.
SUB ResetBytes
 Reset1 = True
 Call ResetByte
 CopyPositionStart = False
 CopyPositionPivot = False
 CopyPositionEnd = False
 CopyStart = False
END SUB

REM restore hilighted bytes.
SUB RestoreHilightBytes
 CopyPositionStart=File(CurrentFile).CopyPositionStart
 CopyPositionPivot=File(CurrentFile).CopyPositionPivot
 CopyPositionEnd=File(CurrentFile).CopyPositionEnd
 FilePosition=File(CurrentFile).FilePosition
 Reset1 = False
 Call ResetByte
END SUB

REM draw byte area.
SUB ResetByte
 Temp# = FilePosition
 Temp2# = FilePage
 Var1# = CopyPositionStart
 Var2# = CopyPositionEnd

 ' reset hilighted positions.
 IF Var1# < (Temp2# - 1) * 320 + 1 THEN
    Var1# = (Temp2# - 1) * 320 + 1
 END IF
 IF Var2# > (Temp2# - 1) * 320 + 320 THEN
    Var2# = (Temp2# - 1) * 320 + 320
 END IF
 IF Var2# > FileLength THEN
    Var2# = FileLength
 END IF

 ' draw the bytes.
 FOR FilePosition = Var1# TO Var2#
    CALL CalculatePosition1
    IF Reset1 THEN
       COLORf White
    ELSE
       COLORf2 0, 7
    END IF
    Call byteprint
 NEXT
 COLORf2 7, 0
 FilePosition = Temp#
 CALL CalculatePosition1
END SUB

REM clear current byte on screen.
SUB ClearPageByte
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 IF CopyPositionStart > 0# THEN
    Call resethilightbytes
 END IF
 COLORf White
 Call byteprint
END SUB

REM clear current hilighted byte on screen.
SUB ClearHilightByte
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 COLORf White
 CALL BytePrint
END SUB

REM display current hilight byte being edited.
SUB DisplayHilightByte
 IF FileDisplay2 THEN
    FileDisplay2 = False
    Call DisplayX
    COLORf White
 END IF

 ' display byte.
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 COLORf2 0, 7
 CALL BytePrint
 COLORf2 7, 0

 ' store the current byte value being edited.
 AsciiValue = ASC(FileByte)
 CALL DisplayPosition
END SUB

REM display status area.
SUB DisplayX
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
END SUB

REM display status line message and prompt type 1.
SUB DisplayStatus1
 StatusMessage = StatusMessage + " Press <esc>:"
 CALL DisplayStatusLine
END SUB

REM display status line message and prompt type 2.
SUB DisplayStatus2
 StatusMessage = StatusMessage + " Press <esc> to continue:"
 CALL DisplayStatusLine
END SUB

REM display the status line message and prompt for key or mouse click.
SUB DisplayStatusLine
 Call clearstatus
 PRINTf StatusMessage
 Call locatecursor2
 Call PromptEscKey
 Call displayfilename
END SUB

REM prompts for escape key or left mouse click.
SUB PromptEscKey
 I$ = Nul
 DO
    I$ = Inkey$
    If Len(I$) Then
       ' check escape key pressed.
       IF I$ = CHR$(27) THEN
          EXIT DO
       END IF
       ' check control-break
       IF I$ = CHR$(0)+CHR$(0) THEN
          EXIT DO
       END IF
    Endif

    ' call mouse subroutine.
    Z = MouseDriver

    ' check left mouse button.
    IF MouseButton1 THEN
       EXIT DO
    END IF
 LOOP
END SUB

REM prompts for any key or left mouse click.
SUB PromptKey
 DO
    If Inkey$<>Nul Then
       EXIT DO
    Endif

    ' call mouse subroutine.
    Z = MouseDriver

    ' check left mouse button.
    IF MouseButton1 THEN
       EXIT DO
    END IF
 LOOP
END SUB

REM display screen of current page of hex/ascii values of file being edited.
SUB DisplayHexPage
 IF FileLength = False THEN
    Row = False
    Column = False
    CALL HideM
    FOR NextByte = 1 TO 320
       LOCATEf Row + 4, Column + 6, 0
       PRINTf "  "
       ColumnSpace = ColumnSpace + 1
       IF ColumnSpace = 4 THEN
          PRINTf " "
          Column = Column + 1
          ColumnSpace = False
       END IF
       Column = Column + 2
       IF Column > 44 THEN
          Row = Row + 1
          Column = False
       END IF
    NEXT
    CALL ShowM
    CALL RedrawRightWindow
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 COLORf White
 Row = False
 Column = False
 ColumnSpace = False
 CALL HideM
 FOR NextByte = (FilePage - 1) * 320 + 1 TO (FilePage - 1) * 320 + 320
    LOCATEf Row + 4, Column + 6, 0
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       Call lseekfile
       Call readfile
       FileByte = Buffer
       PRINTf RIGHT$("00" + HEX$(ASC(FileByte)), 2)
    ELSE
       PRINTf "  "
    END IF
    ColumnSpace = ColumnSpace + 1
    IF ColumnSpace = 4 THEN
       PRINTf " "
       Column = Column + 1
       ColumnSpace = False
    END IF
    Column = Column + 2
    IF Column > 44 THEN
       Row = Row + 1
       Column = False
    END IF
 NEXT
 CALL ShowM
 CALL RedrawRightWindow
END SUB

REM redraw right window.
SUB RedrawRightWindow
 IF CurrentWindow2 = False THEN
    CALL RedrawWindow1
 ELSE
    CALL RedrawWindow2
 END IF
END SUB

REM redraw right window of ascii values.
SUB RedrawWindow1
 IF FileLength = False THEN
    CALL HideM
    COLORf White
    Row = False
    Column = False
    FOR NextByte = 1 TO 320
       LOCATEf Row + 4, Column + 55, 0
       PRINTf " "
       Column = Column + 1
       IF Column > 19 THEN
          Row = Row + 1
          Column = False
       END IF
    NEXT
    LOCATEf 1, 1, 0
    CALL ShowM
    EXIT SUB
 END IF
 Row = False
 Column = False
 COLORf White
 CALL HideM
 FOR NextLine = 0 TO 15
    LOCATEf NextLine + 4, 54, 0
    PRINTf " "
 NEXT
 FOR NextByte = (FilePage - 1) * 320 + 1 TO (FilePage - 1) * 320 + 320
    LOCATEf Row + 4, Column + 55, 0
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       Call lseekfile
       Call readfile
       FileByte = Buffer
       ByteValue = ASC(FileByte)
       ' skip unprintable characters
       SELECT CASE ByteValue
       CASE 0, 7, 9 TO 13, 28 TO 32
          PRINTf "."
       CASE ELSE
          PRINTf FileByte
       END SELECT
    ELSE
       PRINTf " "
    END IF
    Column = Column + 1
    IF Column > 19 THEN
       Row = Row + 1
       Column = False
    END IF
 NEXT
 CALL ShowM
END SUB

REM redraw right window of hex ranges.
SUB RedrawWindow2
 CALL HideM
 Row = False
 FOR NextLine = (FilePage - 1) * 320 + 1 TO (FilePage - 1) * 320 + 320 STEP 20
    LOCATEf Row + 4, 54, 0
    Row = Row + 1
    IF NextLine <= FileLength THEN
       IF NextLine + 19 <= FileLength THEN
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(NextLine - 1), 8)
          COLORf Yellow
          PRINTf " - "
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(NextLine + 19 - 1), 8)
       ELSE
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(NextLine - 1), 8)
          COLORf Yellow
          PRINTf " - "
          COLORf White
          PRINTf "x" + RIGHT$("00000000" + HEX$(FileLength - 1), 8)
       END IF
    ELSE
       PRINTf SPACE$(22)
    END IF
 NEXT
 CALL ShowM
END SUB

REM key prompt.
SUB PressKey
 COLORf White
 PRINTf "Press a key:"
 WHILE INKEY$ = Nul
 WEND
END SUB

REM check valid ascii value
SUB CheckASCIIValue(ByteString$)
 ValidASCIIValue = False
 ASCIIValue3 = VAL(ByteString$)
 IF ASCIIValue3 <= 0# OR ASCIIValue3 > 2147483647# THEN
    StatusMessage = "Invalid ascii value."
    Call displaystatus2
    EXIT SUB
 END IF
 ValidASCIIValue = True
END SUB

REM check hex byte string.
SUB CheckString(ByteString$)
 ValidString=True
 FOR HexPosition=2 TO LEN(ByteString$)
    SELECT CASE UCASE$(MID$(ByteString$,HexPosition,1))
    CASE "0" To "9", "A" TO "F"
       ' nul activity
    CASE ELSE
       ValidString=False
       EXIT SUB
    END SELECT
 NEXT
END SUB

REM check hex byte value.
REM input:
REM   ByteString$ is packed hex string.
REM output:
REM   returns ValidHexValue True for valid hex value.
REM   returns HexValue contains value of hex string.
REM parameters:
REM   Hex string must be 8 characters or less.
REM   Hex value from 8000 to ffff return signed bit
REM     and must be incremented by 65536.
REM   Since 7fff ffff is max filesize,
REM     hex values from 8000 0000 to ffff ffff
REM     which are length 8 return negative value.
REM   Since hex values start from an offset of 0
REM     then the maximum value allowed is 7fff fffe.
SUB CheckHexValue(ByteString$)
 ValidHexValue = False
 StringLength2 = LEN(MID$(ByteString$,2))
 IF StringLength2 > 8 THEN
    StatusMessage = "Invalid hex value."
    Call displaystatus2
    EXIT SUB
 END IF
 CALL CheckString(ByteString$)
 IF ValidString=False THEN
    StatusMessage = "Invalid hex string."
    Call displaystatus2
    EXIT SUB
 END IF
 ByteString$ = MID$(ByteString$, 2)
 DO
    IF LEFT$(ByteString$, 1) = "0" THEN
       ByteString$ = MID$(ByteString$, 2)
    ELSE
       EXIT DO
    END IF
 LOOP
 StringLength2 = LEN(ByteString$)
 ByteString$ = "&H" + ByteString$
 HexValue = VAL(ByteString$)
 ' check signed bit error.
 IF StringLength2 = 4 THEN
    IF HexValue < 0 THEN
       HexValue = HexValue + 65536#
    END IF
 END IF
 IF StringLength2 = 8 THEN
    IF HexValue < 0 THEN
       StatusMessage = "Hex underflow."
       Call displaystatus2
       EXIT SUB
    END IF
 END IF
 IF HexValue >= 2147483647# THEN
    StatusMessage = "Hex overflow."
    Call displaystatus2
    EXIT SUB
 END IF
 ValidHexValue = True
 ' adjust hex offset.
 HexValue = HexValue + 1#
END SUB

REM check ascii byte string.
REM   input: ByteString$ is space-separated 3-byte ascii pair string.
REM   returns: ValidByteString equals true if string is valid,
REM     NumBytes is number of ascii byte pairs,
REM     ByteString$ is concatenated hex byte string.
SUB CheckAsciiBytes(ByteString$)
 AsciiByte$ = Nul
 ByteString$ = LTRIM$(ByteString$)
 ByteString$ = RTRIM$(ByteString$)
 IF LEN(ByteString$) = False THEN
    ValidByteString = False
    EXIT SUB
 END IF
 NumBytes = 1
 ValidByteString = True
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = MID$(ByteString$, StringPosition, 1)
    IF (StringPosition MOD 4) = False THEN
       IF Byte$ <> " " THEN
          ValidByteString = False
          EXIT SUB
       END IF
       NumBytes = NumBytes + 1
    ELSE
       SELECT CASE Byte$
       CASE "0" TO "9"
          AsciiByte$ = AsciiByte$ + Byte$
          IF LEN(AsciiByte$) = 3 THEN
             ByteValue = VAL(AsciiByte$)
             IF ByteValue >= False AND ByteValue <= 255 THEN
                AsciiByte$ = Nul
             ELSE
                ValidByteString = False
                EXIT SUB
             END IF
          END IF
       CASE ELSE
          ValidByteString = False
          EXIT SUB
       END SELECT
    END IF
 NEXT
 Var1$ = ByteString$
 DO
    Parse = INSTR(Var1$, " ")
    IF Parse THEN
       Var1$ = LEFT$(Var1$, Parse - 1) + MID$(Var1$, Parse + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 ByteString$ = Var1$
 CALL AsciiToHex1(ByteString$)
END SUB

REM check hex byte string.
REM   input: AllowWildcard true to allow ? character.
REM     ByteString$ is space-separated hex byte pair string.
REM   returns: ValidByteString equals true if string is valid,
REM     NumBytes is number of hex byte pairs,
REM     ByteString$ is concatenated hex byte string.
SUB CheckHexBytes(ByteString$)
 ByteString$ = LTRIM$(ByteString$)
 ByteString$ = RTRIM$(ByteString$)
 IF LEN(ByteString$) = False THEN
    ValidByteString = False
    EXIT SUB
 END IF
 NumBytes = 1
 ValidByteString = True
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = MID$(ByteString$, StringPosition, 1)
    IF (StringPosition MOD 3) = False THEN
       IF Byte$ <> " " THEN
          ValidByteString = False
          EXIT SUB
       END IF
       NumBytes = NumBytes + 1
    ELSE
       SELECT CASE Byte$
       CASE "0" TO "9", "A" TO "F", "a" TO "f", "?"
          IF Byte$ = "?" THEN
             IF AllowWildcard = False THEN
                ValidByteString = False
                EXIT SUB
             END IF
          END IF
          MID$(ByteString$, StringPosition, 1) = UCASE$(Byte$)
       CASE ELSE
          ValidByteString = False
          EXIT SUB
       END SELECT
    END IF
 NEXT
 Var1$ = ByteString$
 DO
    Parse = INSTR(Var1$, " ")
    IF Parse THEN
       Var1$ = LEFT$(Var1$, Parse - 1) + MID$(Var1$, Parse + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 ByteString$ = Var1$
END SUB

REM convert a 3-digit packed ascii string to a hex string.
SUB AsciiToHex1(ByteString$)
 Byte$ = Nul
 NewString$ = Nul
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = Byte$ + MID$(ByteString$, StringPosition, 1)
    IF LEN(Byte$) = 3 THEN
       NewString$ = NewString$ + RIGHT$("00" + HEX$(VAL(Byte$)), 2)
       Byte$ = Nul
    END IF
 NEXT
 ByteString$ = NewString$
END SUB

REM convert a 1-digit packed ascii string to a hex string.
SUB AsciiToHex2(ByteString$)
 Byte$ = Nul
 NewString$ = Nul
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = MID$(ByteString$, StringPosition, 1)
    NewString$ = NewString$ + RIGHT$("00" + HEX$(ASC(Byte$)), 2)
 NEXT
 ByteString$ = NewString$
END SUB

REM display cell position in string format.
SUB FormatPosition2(Var)
 IF Var = 1 THEN
    PRINTf "Marker#" + MID$(STR$(MarkerPosition), 2) + ":"
 ELSE
    PRINTf "Marker#" + MID$(STR$(MarkerPosition), 2) + " Position:"
 END IF
 TempPosition3 = Markers#(MarkerPosition)
 IF CurrentWindow = False THEN
    PRINTf MID$(STR$(TempPosition3 - 1), 2) + " "
 ELSE
    PRINTf RIGHT$("00000000" + HEX$(TempPosition3 - 1), 8) + "H "
 END IF
 CALL CalculatePosition2
 IF CurrentWindow = False THEN
    PRINTf "(page: " + FormatX$(Cdbl(FilePage2 - 1), 1) + ","
 ELSE
    PRINTf "(page:" + RIGHT$("00000000" + HEX$(FilePage2 - 1), 8) + "H,"
 END IF
 PRINTf "row:" + MID$(STR$(PageRow2), 2) + ","
 PRINTf "column:" + MID$(STR$(PageColumn2), 2) + ")"
 IF Var = 1 THEN
    PRINTf " Press <esc>:"
 END IF
END SUB

REM returns ambiguated filename.
SUB GetShortFilename(Short.Filename$)
 CONST MAX_PATH = 260
 ret = GetShortPathName(ASCIIZ, ASCIIZ2, MAX_PATH + 1)
 IF ret > 0 THEN
     Short.Filename$ = ASCIIZ2
 ELSE
     Short.Filename$ = ASCIIZ
 END IF
 Imbedded = INSTR(Short.Filename$, CHR$(0))
 IF Imbedded THEN
    Short.Filename$ = LEFT$(Short.Filename$, Imbedded - 1)
 END IF
END SUB

REM Mouse routines:
REM   MouseDriver       --  processes mouse activity.

FUNCTION MouseDriver
STATIC X1 AS INTEGER, Y1 AS INTEGER ' store old values
MouseX = 0: MouseY = 0
IF _MOUSEINPUT THEN
    MouseButton1 = _MOUSEBUTTON(1)
    MouseButton2 = _MOUSEBUTTON(2)
    MouseButton3 = _MOUSEBUTTON(3)
    MouseWheel = _MOUSEWHEEL
    X = CINT(_MOUSEX): Y = CINT(_MOUSEY) ' X,Y return single
    IF X <> X1 OR Y <> Y1 THEN
        X1 = X: Y1 = Y
        MouseX = Y: MouseY = X ' X,Y are reversed
        WHILE _MOUSEINPUT: WEND ' empty buffer
    END IF
END IF
END FUNCTION

SUB HideM ' has no function in windows
 EXIT SUB
END SUB

SUB ShowM ' has no function in windows
 EXIT SUB
END SUB

REM Functions:
REM   Conanicalize      --  trims a filename.
REM   CalculateColumn   --  calculate column groups.
REM   CalculateColumn2  --  calculate column groups.
REM   CalculatePosition3#  --  calculate mouse position.
REM   DumpLineRange$    --  format line range.
REM   Directories       --  get a directory from temp data file.
REM   Filenames         --  get a filename from temp data file.
REM   UndoByte          --  get an undo byte from temp data file.
REM   UndoPosition      --  get an undo position from temp data file.
REM   Markers           --  get a marker value from temp data file.

REM conanicalizes filename.
FUNCTION Conanicalize$ (Var$)
 Var1$ = Var$

 ' strip drive letter.
 Var1$ = UCASE$(Var1$)
 IF MID$(Var1$, 2, 1) = ":" THEN
    Var1$ = MID$(Var1$, 3)
 END IF

 ' strip dos path.
 DO
    Path = INSTR(Var1$, "\")
    IF Path THEN
       Var1$ = MID$(Var1$, Path + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 Conanicalize$ = Var1$
END FUNCTION

REM function to calculate column groups.
FUNCTION CalculateColumn
 SELECT CASE PageColumn
 CASE 1 TO 4
    CalculateColumn = (PageColumn - 1) * 2 + 1
 CASE 5 TO 8
    CalculateColumn = (PageColumn - 1) * 2 + 2
 CASE 9 TO 12
    CalculateColumn = (PageColumn - 1) * 2 + 3
 CASE 13 TO 16
    CalculateColumn = (PageColumn - 1) * 2 + 4
 CASE 17 TO 20
    CalculateColumn = (PageColumn - 1) * 2 + 5
 END SELECT
END FUNCTION

REM function to calculate column groups.
FUNCTION CalculateColumn2
 SELECT CASE PageColumn2
 CASE 1 TO 4
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 1
 CASE 5 TO 8
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 2
 CASE 9 TO 12
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 3
 CASE 13 TO 16
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 4
 CASE 17 TO 20
    CalculateColumn2 = (PageColumn2 - 1) * 2 + 5
 END SELECT
END FUNCTION

REM function to calculate mouse position.
FUNCTION CalculatePosition3#
 Var1# = (FilePage - 1) * 320 + (MouseX - 4) * 20
 SELECT CASE MouseX
 CASE 6, 7
    Var1# = Var1# + 1#
 CASE 8, 9
    Var1# = Var1# + 2#
 CASE 10, 11
    Var1# = Var1# + 3#
 CASE 12, 13
    Var1# = Var1# + 4#
 CASE 15, 16
    Var1# = Var1# + 5#
 CASE 17, 18
    Var1# = Var1# + 6#
 CASE 19, 20
    Var1# = Var1# + 7#
 CASE 21, 22
    Var1# = Var1# + 8#
 CASE 24, 25
    Var1# = Var1# + 9#
 CASE 26, 27
    Var1# = Var1# + 10#
 CASE 28, 29
    Var1# = Var1# + 11#
 CASE 30, 31
    Var1# = Var1# + 12#
 CASE 33, 34
    Var1# = Var1# + 13#
 CASE 35, 36
    Var1# = Var1# + 14#
 CASE 37, 38
    Var1# = Var1# + 15#
 CASE 39, 40
    Var1# = Var1# + 16#
 CASE 42, 43
    Var1# = Var1# + 17#
 CASE 44, 45
    Var1# = Var1# + 18#
 CASE 46, 47
    Var1# = Var1# + 19#
 CASE 48, 49
    Var1# = Var1# + 20#
 END SELECT
 CalculatePosition3# = Var1#
END FUNCTION

REM function to format line range.
FUNCTION DumpLineRange$
 Var$ = "File: " + RTRIM$(Filename) + " Bytes: "
 Var$ = Var$ + FormatX$(FirstByte,1) + "-"
 IF LastByte <= FileLength THEN
    Var$ = Var$ + FormatX$(LastByte,1)
 ELSE
    Var$ = Var$ + FormatX$(FileLength,1)
 END IF
 Var$ = Var$ + " (x" + RIGHT$("000000000000" + HEX$(FirstByte - 1), 8) + "-x"
 IF LastByte <= FileLength THEN
    Var$ = Var$ + RIGHT$("000000000000" + HEX$(LastByte - 1), 8)
 ELSE
    Var$ = Var$ + RIGHT$("000000000000" + HEX$(FileLength - 1), 8)
 END IF
 Var$ = Var$ + ")."
 DumpLineRange$ = Var$
END FUNCTION

REM filename structure function.
FUNCTION Filenames$ (Var1!)
 GET #2, Var1!, WinFileStruc
 Filenames$ = WinFileStruc.Name
END FUNCTION

REM directory structure function.
FUNCTION Directories$ (Var1!)
 GET #3, Var1!, WinFileStruc
 Directories$ = WinFileStruc.Name
END FUNCTION

REM undo structure function.
FUNCTION UndoByte%(Var1!)
 GET #6, Var1!, UndoFile
 UndoByte% = CVI( MID$( UndoFile.UndoByte1, (CurrentFile - 1) * 2 + 1, 2))
END FUNCTION

REM undo structure function.
FUNCTION UndoPosition#(Var1!)
 GET #6, Var1!, UndoFile
 UndoPosition# = CVD( MID$(UndoFile.UndoPosition1, (CurrentFile - 1) * 8 + 1, 8)
END FUNCTION

REM marker structure function.
FUNCTION Markers#(Var1!)
 GET #7, Var1!, MarkerFile
 Markers# = CVD( MID$(MarkerFile.Markers1, (CurrentFile - 1) * 8 + 1, 8))
END FUNCTION

REM Functions:
REM   MakeFilename?$  --  constructs filename for file menu box.

FUNCTION MakeFilename$(N$, C$, D$, X$)
 IF N$ = Nul THEN
    IF D$ = Nul THEN
       MakeFilename$ = C$ + ":\" + X$
    ELSE
       MakeFilename$ = C$ + ":\" + D$ + "\" + X$
    END IF
 ELSE
    IF D$ = Nul THEN
       MakeFilename$ = N$ + "\" + X$
    ELSE
       MakeFilename$ = N$ + "\" + D$ + "\" + X$
    END IF
 END IF
END FUNCTION

FUNCTION MakeFilename2$(N$, C$, D$)
 IF N$ = Nul THEN
    IF D$ = Nul THEN
       MakeFilename2$ = C$ + ":\"
    ELSE
       IF D$ = "\" THEN
          MakeFilename2$ = C$ + ":\"
       ELSE
          MakeFilename2$ = C$ + ":\" + D$
       END IF
    END IF
 ELSE
    IF D$ = Nul THEN
       MakeFilename2$ = N$ + "\"
    ELSE
       IF D$ = "\" THEN
          MakeFilename2$ = N$ + "\"
       ELSE
          MakeFilename2$ = N$ + "\" + D$
       END IF
    END IF
 END IF
END FUNCTION

FUNCTION MakeFilename3$(N$, C$, D$)
 IF N$ = Nul THEN
    IF D$ = Nul THEN
       MakeFilename3$ = C$ + ":\*.*"
    ELSE
       IF D$ = "\" THEN
          MakeFilename3$ = C$ + ":\*.*"
       ELSE
          MakeFilename3$ = C$ + ":\" + D$ + "\*.*"
       END IF
    END IF
 ELSE
    IF D$ = Nul THEN
       MakeFilename3$ = N$ + "\*.*"
    ELSE
       IF D$ = "\" THEN
          MakeFilename3$ = N$ + "\*.*"
       ELSE
          MakeFilename3$ = N$ + "\" + D$ + "\*.*"
       END IF
    END IF
 END IF
END FUNCTION

FUNCTION MakeFilename4$(N$, C$, D$)
 IF N$ = Nul THEN
    MakeFilename4$ = C$ + ":\" + D$
 ELSE
    IF D$ = "\" THEN
       MakeFilename4$ = N$ + "\"
    ELSE
       MakeFilename4$ = N$ + "\" + D$
    END IF
 END IF
END FUNCTION

REM Subroutines:
REM   GetFileLength(V%) --  get filelength from handle.
REM   GetFileAttr(Var$) --  get file attributes.
REM   Prompt.Inkey()    --  prompts for escape key.
REM   Error.Inkey(E$)   --  prompts for any key.
REM   InstrSub(V%,V1$,V2$)  --  match substrings.
REM   GetDrives()       --  get default drives.
REM   Pack.Files1()     --  Pack paste files.
REM   Pack.Arrays1()    --  Pack byte undo file arrays.
REM   Pack.Arrays2()    --  Pack marker file array.

REM read filelength from handle.
SUB GetFileLength(Var)
FileLength = 0
IF Var > 0 THEN
   FileLength = LOF(Var)
END IF
END SUB

REM get file attributes.
FUNCTION GetFileAttr(Var$)
   Var = GetFileAttributes (ASCIIZ)
   IF Var < 0 THEN
      Var = 0
   END IF
   GetFileAttr = Var
END FUNCTION

' prompt for escape key.
SUB Prompt.Inkey
 Z$ = Nul
 DO
    Z$ = INKEY$
    ' escape
    IF Z$=CHR$(27) THEN
       EXIT DO
    END IF
    ' control-break
    IF Z$=CHR$(0)+CHR$(0) THEN
       EXIT DO
    END IF
 LOOP
END SUB

' prompt for error key.
SUB Error.Inkey(E$)
 E$ = Nul
 DO
    E$ = INKEY$
    IF LEN(E$) THEN
       EXIT DO
    END IF
 LOOP
END SUB

' function to match substring with ?, * characters in substring.
SUB InstrSUB(Var,Var1$,Var2$)

' store string match variables
S2$ = Ucase$(Var2$)
S3$ = Ucase$(Var1$)

' check default instr
IF INSTR(S2$, "*") = 0 THEN
   IF INSTR(S2$, "?") = 0 THEN
      Var = INSTR(S3$, S2$)
      EXIT SUB
   END IF
END IF

Var = -1 ' assume match

' see if S2$ matches in S3$ with substrings
FOR S3 = 1 TO LEN(S3$)
   S1$ = MID$(S3$, S3)
   P1 = 1 ' pointer to S1$
   P2 = 1 ' pointer to S2$
   DO
      ' check token beyond string
      IF P2 >= LEN(S2$) THEN
         EXIT SUB
      END IF

      ' check character in S2$ at P2
      V$ = MID$(S2$, P2, 1)
      SELECT CASE V$
      CASE "*" ' global character
         ' scan to next char
         IF P2 >= LEN(S2$) THEN
            EXIT DO
         END IF
         S4$ = MID$(S2$, P2 + 1, 1)
         SELECT CASE S4$
         CASE "*", "?" ' imbedded
            P2 = P2 + 1
         CASE ELSE
            DO
               IF MID$(S1$, P1, 1) = S4$ THEN
                  EXIT DO
               END IF
               IF P1 >= LEN(S1$) THEN
                  EXIT DO
               END IF
               P1 = P1 + 1
            LOOP
            P2 = P2 + 1
         END SELECT
      CASE "?" ' wildcard character
         P1 = P1 + 1
         P2 = P2 + 1
      CASE ELSE ' ascii character
         IF MID$(S1$, P1, 1) <> V$ THEN ' no match
            EXIT DO
         END IF
         P1 = P1 + 1
         P2 = P2 + 1
      END SELECT
   LOOP
NEXT
Var = 0 ' no match
EXIT SUB
END SUB

' get default drives.
SUB GetDrives
 ' get current drive.
 Default.Drive = ASC(LEFT$(GetD$, 1)) - 65 ' 0=a, 1=b,..

 ' get maximum drives.
 Last.Drive = 26
END SUB

FUNCTION GetD$
 FileX$ = DRX + "tempfile.da" + Ltrim$(Str$(Process.Number))
 SHELL _HIDE "vol " > " + FileX$
 X = FreeFile
 OPEN FileX$ FOR INPUT SHARED AS #X
 IF EOF(X) = 0 THEN
    LINE INPUT #X, x$
    Y = INSTR(x$, "Volume in drive ")
    IF Y THEN
       GetD$ = MID$(x$, 18, 1) + ":\"
       Close #x
       exit function
    end if
 end if
 GetD$ = "C:\"
end function

REM File/Structure pack subroutines. (added: v8.0a 05/10/2012).
REM   Pack.Files1  -  Pack paste undo files w/debug.
REM   Pack.Arrays1  -  Pack byte undo file arrays.
REM   Pack.Arrays2  -  Pack marker file array.

' pack paste undo files.
'   kills current paste undo file.
SUB Pack.Files1
 If Debug3 Then
    Cls
 Endif
 Close #4
 Close #5
 V1$ = Rtrim$(MultiFilenames(CurrentFile))
 If Len(V1$) Then
    If _FILEEXISTS(V1$) Then
       Kill V1$
       If Debug3 Then
          COLORf White
          Print "Killed: "+V1$
       Endif
    Endif
 Endif
 For Var = CurrentFile To MaxFiles-1
    V1$ = Rtrim$(MultiFilenames(Var))
    V2$ = Rtrim$(MultiFilenames(Var+1))
    If Len(V2$) = 0 Then
       Exit For
    Endif
    If _FILEEXISTS(V2$) = 0 Then
       Exit For
    Endif
    If Len(V1$) Then
       Name V2$ As V1$
       If debug3 Then
          COLORf Yellow
          Print "Renamed: "+V2$+" AS "+V1$
       Endif
    Endif
 Next
 If Debug3 Then
    COLORf White
    Print "Press a key:";
    While Inkey$=""
    Wend
    Cls
    Print "Press Alt-R to redraw screen"
 Endif
End Sub

' pack byte undo file.
SUB Pack.Arrays1
 For Tmp1!=1! To Lof(6)/Len(UndoFile)
    GET #6, Tmp1!, UndoFile
    FOR Var = CurrentFile TO MaxFiles-1
       TempM = CVI( MID$( UndoFile.UndoByte1, Var * 2 + 1, 2))
       MID$( UndoFile.UndoByte1, (Var - 1) * 2 + 1, 2) = MKI$(TempM)

       TempM# = CVD( MID$( UndoFile.UndoPosition1, Var * 8 + 1, 8))
       MID$( UndoFile.UndoPosition1, (Var - 1) * 8 + 1, 8) = MKD$(TempM#)
    NEXT
    MID$( UndoFile.UndoByte1, (MaxFiles - 1) * 2 + 1, 2) = MKI$(0%)

    MID$( UndoFile.UndoPosition1, (MaxFiles - 1) * 8 + 1, 8) = MKD$(0#)
    PUT #6, Tmp1!, UndoFile
 Next
END SUB

' pack marker file.
SUB Pack.Arrays2
 For Tmp1!=1! To Lof(7)/Len(MarkerFile)
    GET #7, Tmp1!, MarkerFile
    FOR Var = CurrentFile TO MaxFiles-1
       TempM# = CVD( MID$( MarkerFile.Markers1, Var * 8 + 1, 8))
       MID$(MarkerFile.Markers1, (Var - 1) * 8 + 1, 8) = MKD$(TempM#)
    NEXT
    MID$(MarkerFile.Markers1, (MaxFiles - 1) * 8 + 1, 8) = MKD$(0#)
    PUT #7, Tmp1!, MarkerFile
 Next
END SUB

REM End-of-subprogram. Surprising it still works.
