Rem Program: Hex Editor v9.0a r3.0a Main Module PD 2025.

Rem Author: Erik Jon Oredson
Rem Release: 09/05/2025.
Rem Status: Public Domain
Rem Email: eoredson@gmail.com
Rem Urls: www.applewoodbbs.linkpc.net/files

Rem v8.0a r1.0a 2015:
Rem   Initial port to 32-bit.

Rem v8.0a r2.0a updates 04/14/2016:
Rem   Edited misspelled NETPATHEXISTS.
Rem   Removed Control-Break InkeyX$ checking.
Rem   Fixes Delete/Insert for RMDIR/MKDIR in DirBox.
Rem   Replaces all Shells to DIR with FindFile functions.
Rem   Replace Shell to VOL with GetVolumeInformation function.
Rem   Modify command line for temp directory creation override.

Rem v8.0a r3.0a updates 05/17/2016:
Rem   Adds [DRIVETYPE] to DriveType.
Rem   Prepends 0 to some .0 B display.
Rem   Fixes RETURN in SUB ExcludeList.
Rem   Adds call to DisplayCriticalError to Error.Routine
Rem   Reformats some hexidecimal display outputs.
Rem   No longer ignores floppy drive list in file menu box.

Rem v8.0a r3.0a updates 05/25/2016:
Rem   Forces only directory in dir box in file menu box to a '.' when
Rem    cdrom drive exists but has no media loaded.
Rem   Displays drive does not exist when removable drive other than
Rem    cdrom has no media.
Rem   Repairs left mouse button click in DropDownMenu/ViewFiles
Rem    for outside of menu box.
Rem   Adds MouseWheel/MouseButtons to FileMenuBoxMove/FileMenuBoxHelp.

Rem v8.0a r4.0a updates 06/20/2016:
Rem   Traps Ctrl-E character in FileMenuBox.
Rem   Restores background color in CriticalErrorTrap.
Rem   Adds missing declaration to MouseTime variable.
Rem   Fixes timing of call to _EXIT function.
Rem   Adds 1.2 second delay to ctrl-c for break trap.
Rem   Changes some single precision values to 1,048,576.
Rem   Adds FILELISTEXISTS function.

Rem v8.0a r5.0a updates 02/24/2017:
Rem   Replaces all GetModuleFilename with _CWD$
Rem   Forces default directory to StartDir$
Rem   Fixes mouse coordinate before mouse button.
Rem   Changes print from LPT to LPRINT.
Rem   Replaces MKDIR/RMDIR/KILL with library calls.

Rem v8.0a r6.0a updates 07/12/2017:
Rem   Replaces shell to screensaver to internal library call.
Rem   Repairs parameter call to CreateDirectory.

Rem v8.0a r7.0a updates 11/08/2017:
Rem   Loads filenames with ? characters in them.
Rem   Adds insert to createfile in filebox in file menu box.
Rem   Now recursively deletes directory in delete in dirbox in file menu box.
Rem   Replaces all KILL to DeleteFileA.

Rem v8.0a r8.0a updates 12/21/2022:
Rem   Fixes recursive clock$ function call.
Rem   Edits call to sendmessage for screen saver.

Rem v8.0a r9.0a updates 12/30/2022:
Rem   Increases maxfiles to 15.
Rem   Adds Alt-A to Alt-F for ViewFile.

Rem v8.0a rA.0a updates 02/10/2023:
Rem   Adds trap for Keypad-5 and Control-Keypad-5 keys.
Rem   Adds Ctrl-F1 to Ctrl-F10 to all File Menu Box Alt- keys.
Rem   Adds call to screen saver to Ctrl-F11/Ctrl-F12 in File Menu Box.

Rem v8.0a rB.0a updates 03/20/2023:
Rem   Edits file menu box help screen.

Rem v8.0a rC.0a updates 03/28/2023:
Rem   Adds hexedit.bmp to titlebar.

Rem v8.0a rD.0a updates 04/16/2023:
Rem   Replaces file menu box with dialog box.
Rem   Adds ErrorBox and MessageBox.
Rem   Adds ansi splash screen.
Rem   Now stores and restores windows coordinates.

Rem v8.0a rE.0a updates 04/20/2023:
Rem   Adds BreakBox for Ctrl-Break trap.
Rem   Updates dialogx.inc for correct title.
Rem   Includes more old hexeditor in oldsrc.zip
Rem   Fixes problem with CreateFile function call.

Rem v8.0a rF.0a updates 04/28/2023:
Rem   Removes some code from Sub ReadConfig and Sub WriteConfig.
Rem   Stores config filename node in Sub GetConfigFilename$
Rem   Adds Alt-F11 to test dialog box.
Rem   Adds Alt-F12 to test file menu box.
Rem   Forces config filename to current path.

Rem v8.0a rG.0a updates 05/18/2023:
Rem   Fixes \\ in directory display in Sub Menu3.

Rem v8.0a rH.0a updates 05/20/2023:
Rem   Fixes print display for Alt-F11 and Alt-F12
Rem   Adds Filemenubox setting to hexedit.cfg
Rem   Adds Errorbox2 to select file menu box/dialog box at start.

Rem v8.0a rI.0a updates 05/23/2023:
Rem   Adds more up/down scancodes to some message boxes.
Rem   Updates oldsrc.zip with newer Hexxit81 features.
Rem   Adds <escape> to exit system in call to ErrorBox2 in startup.

Rem v8.0a rJ.0a updates 06/01/2023:
Rem   Fixes netpath in Call Menu during startup box.
Rem   Calls Delete.Process in exit from startup box and breakbox.

Rem v8.0a rK.0a updates 06/10/2023:
Rem   Fixes error when started from netpath.

Rem v8.0a rL.0a updates 06/15/2023:
Rem   Fixes error when writing config to cd-rom drive.
Rem   Adds [FLOPPY] to DriveType in Function DriveExists.

Rem v8.0a rM.0a updates 08/15/2023:
Rem   Fixes MaxFiles in some UDTs.

Rem v8.0a rN.0a updates 08/20/2023:
Rem   Adds _ControlChr Off to top of main.
Rem   Removes some assigned screen save variables.

Rem v8.0a rO.0a updates 08/25/2023:
Rem   Adds MouseButton2 to Sub Menu.
Rem   Adds Control-F12 to edit hexedit.cfg

Rem v8.0a rP.0a updates 11/10/2023:
Rem   Now forces user to admin status.
Rem   Adds Left-DoubleClick mouse to Sub Menu.
Rem   Fixes search string during replace in ScrnEdit.

Rem Hexxit v8.0a rQ.0a updates 01/01/2024:
Rem   Hexxit oldsrc v8.2a upgrade notes:
Rem     Adds Insert filename in FileMenuBox in File box in Hexedit5.bas.
Rem   Hexxit oldsrc v8.3a upgrade notes:
Rem     Adds shell to treedel in delete dir in file box.

Rem Hexxit v8.0a rR.0a updates 01/10/2024:
Rem  Relaces LoadIcon with Icon2BMP.
Rem   Hexxit oldsrc v8.4a upgrade notes:
Rem     Repairs SortFilesX in Filebox.
Rem     Adds Ctrl-Fx to Alt-Fx in FileBox.
Rem     Increments MaxFiles to 15.

Rem Hexxit v8.0a rS.0a updates 02/20/2024:
Rem  Hexxit v8.5a upgrade notes:
Rem    Fixes call to Dir$
Rem    Fixes Windows.Detected default.

Rem v8.0a rT.0a updates 05/10/2024:
Rem  Fixes text length in ErrorBox/ErrorBox2/MessageBox.
Rem  Adds left/right in ErrorBox/ErrorBox2/MessageBox.
Rem  Now allows the Quote constant defined.

Rem v8.0a rU.0a updates 07/20/2024:
Rem  Adds $VersionInfo to dialogx.inc
Rem  Hexxit v8.6a upgrade notes:
Rem    Fixes integer assignment in Hexxit86 Oldsrc.zip
Rem    Edits printer assignment to 1-3 in Hexxit86 Oldsrc.zip

Rem v8.1a rV.0a updates 12/15/2024:
Rem  Fixes CDROM media inserted in Sub MediaExists.

Rem v8.1a rW.0a updates 12/25/2024:
Rem  Fixes parameter type mismatch in call to CheckExcluded.
Rem  Adds Alt-- and Alt-= to some menu functions.
Rem  Adds more _limit to Inkey$ loops.

Rem v8.1a rX.0a updates 02/25/2025:
Rem  Improves Control-Break checking.
Rem  Replaces GetOpenFilename$ with _OpenFileDialog$
Rem  Adjusts starting menubox during splashscreen.

Rem v8.1a rY.0a updates 04/10/2025:
Rem  Adds custom Command$ function.

Rem v8.1a rZ.0a updates 05/01/2025:
Rem  Fixes Shell to DOS.

Rem v9.0a r1.0a updates 05/25/2025:
Rem  Fixes Shell to DOS again.

Rem v9.0a r2.0a updates 08/20/2025:
Rem  Adds color to file menu box drivelist.

Rem v9.0a r3.0a updates 08/25/2025:
Rem  Fixes parameter mismatch in CreateDirectoryA.
Rem  Adds reboot and shutdown command to shell to shutdown.exe
Rem    Supports Windows/MACOSX/Linux.
Rem    Ctrl-Alt-F1 to reboot, Ctrl-Alt-F2 to shutdown.
Rem  Adds Ctrl-Alt-F3 to call Keymapper.

' initialize all default variables as long.
DefLng A-Z

' load all arrays during runtime.
Rem $Dynamic

' turn on low ascii prints.
_ControlChr Off

' declare window title.
' set screen mode and location.
Screen 0
Do: _Limit 10: Loop Until _ScreenExists
_Title "HEXEDIT"
_ScreenMove _Middle

' set all shared variables.
Rem $Include:'dialogx.inc'

' force user as admin
$If WIN Then
   If IsUserAnAdmin = 0 Then
      Call ShellExecute(0, "runas" + Chr$(0), Command$(0) + Chr$(0), Command$ + Chr$(0), 0, 5)
      System
   End If
$End If

Declare Dynamic Library "Shell32"
   Function IsUserAnAdmin& ()
   Sub ShellExecute Alias "ShellExecuteA" (ByVal hwnd As _Offset, lpOperation As String, lpFile As String, lpParameters As String, ByVal lpDirectory As _Offset, ByVal nShowCmd As Long)
End Declare

' declare multiple file structure.
Type FileType
   AsciiValue As Integer
   ASCIIZ As String * 260
   Buffer As String * 1
   CopyPositionEnd As Double
   CopyPositionPivot As Double
   CopyPositionStart As Double
   CurrentMarker As Single
   CurrentUndo As Single
   CurrentWindow2 As Integer
   Filename As String * 12
   FileAttribute As Integer
   FileByte As String * 1
   FileDisplay As Integer
   FileLength As Double
   FileLocked As Integer
   FilePage As Double
   FilePosition As Double
   Handle As Integer
   MarkerCount As Single
   Netpath As String * 260
   PageColumn As Double
   PageRow As Double
   ScreenRow As Integer
   ShortFilename As String * 260
   StoreSearchString As String * 260
End Type

' declare windows filename/directory structure.
Type WinFileType
   Name As String * 260 ' asciiz
End Type

' declare marker filename structure.
Type MarkerFileType
   Markers1 As String * 120 ' MaxFiles*8 double
End Type

' declare byte undo filename structure.
Type UndoFileType
   UndoByte1 As String * 30 ' MaxFiles*2 integer
   UndoPosition1 As String * 120 ' MaxFiles*8 double
End Type

' set keymapper arrays
Dim Shared KeyMap(3, 0 To 255) As Integer ' ascii
Dim Shared KeyMapExtended(3, 0 To 255) As Integer ' extended ascii

' declare arrays for screen store/restore
Dim Shared TempArrayY2(1 To 2000) As Integer ' screen char
Dim Shared TempArrayZ2(1 To 2000) As Integer ' char color

' declare multi array process filenames.
Dim Shared MultiFilename1(1 To 15) As String
Dim Shared MultiFilenames(1 To 15) As String

' declare undo structure.
Dim Shared UndoFile As UndoFileType

' declare undo variables.
Dim Shared CurrentUndo As Single, UndoToggle As Integer

' declare marker structure.
Dim Shared MarkerFile As MarkerFileType

' declare marker variables.
Dim Shared CurrentMarker As Single, NewMarker As Single
Dim Shared MarkerCount As Single, MarkerPosition As Single

' declare menu area storage arrays.
Dim Shared Area1(24, 44) As Integer, Area2(24, 44) As Integer

' declare ascii character variables.
Dim Shared Hline As Integer, Vline As Integer
Dim Shared ULcorner As Integer, URcorner As Integer
Dim Shared LLcorner As Integer, LRcorner As Integer

' declare temporary file position variables.
Dim Shared FileDisplay As Integer, FileDisplay2 As Integer
Dim Shared FileDisplayX As Integer, ScreenRowX As Integer
Dim Shared HeapSortOff As Integer
Dim Shared TempPosition As Double, TempPosition1 As Double
Dim Shared TempPosition2 As Double, TempPosition3 As Double
Dim Shared TempFiles(1 To 15) As String

' declare files/dirs maximum variables.
Dim Shared SortMax As Single, SortMax2 As Single

' declare common program variables.
Dim Shared AsciiValue As Integer '  AsciiValue2 As Integer
Dim Shared ASCIIValue3 As Double, HexValue As Double
Dim Shared CurrentWindow As Integer, CurrentWindow2 As Integer
Dim Shared PageColumn As Double, PageRow As Double
Dim Shared ScreenDrawn As Integer, ScreenRow As Integer
Dim Shared StatusMessage As String '  SupportedCall As Integer

' declare common validity check variables.
Dim Shared AllowWildCard As Integer
Dim Shared ValidFunction As Integer, ValidASCIIValue As Integer
Dim Shared ValidString As Integer, ValidHexValue As Integer
Dim Shared ValidByteString As Integer, NumBytes As Integer

' declare filename/file position variables.
Dim Shared BlockByte As String * 32767, Column As Double
Dim Shared DumpFile As String, ExcludeFile As String
Dim Shared FileDumped As Integer, Filename As String
Dim Shared FileByte As String * 1, FileBytePosition As Double
Dim Shared FileLength As Double, FilePage As Double
Dim Shared FilePosition As Double '  FilePosition2 As Double
Dim Shared FirstByte As Double, FilePage2 As Double
Dim Shared LastByte As Double, LastPage As Double
Dim Shared NewByte As Double, NextByte As Double
Dim Shared NextLine As Double, NextPage As Double
Dim Shared NewPosition As Double ' NewPosition2 As Double
Dim Shared PageColumn2 As Double, PageRow2 As Double
Dim Shared SeekPosition As Double, SeekPosition2 As Double
Dim Shared ShortFilename As String, StorePosition As Double

' declare file search position variables.
Dim Shared SearchBytePosition As Double, StoreNumBytes As Integer
Dim Shared StoreSearchPosition As Double, StoreSearchString As String
Dim Shared StoreSearchMulti As Integer

' declare all long filename common variables.
Dim Shared ASCIIZ As String * 260, ASCIIZ2 As String * 260
Dim Shared Buffer As String * 1, ConfigFile As String
Dim Shared Directory.ASCIIZ As String, ErrorTrap As Integer
Dim Shared FileAttribute As Integer, FileLocked As Integer
Dim Shared FileDateTime As String, FileSwitch As Integer
Dim Shared FileSize As Double, FileSizeType As Integer
Dim Shared Handle As Integer, QuietSwitch As Integer
Dim Shared Windows.Detected As Integer
Dim Shared Write.Error As Integer, Node As Integer

' declare all common mouse variables.
Dim Shared MouseX As Integer, MouseY As Integer
Dim Shared MouseButton1 As Integer, MouseButton2 As Integer
Dim Shared MouseButton3 As Integer, MouseWheel As Integer
Dim Shared Reset1 As Integer, Time1 As Single, MouseTime As Single
Dim Shared WheelReverse As Integer
Const ClickCount = 10 ' double click loop counter
Const ClickDelay = .1 ' double click loop delay

' declare filename variables for file menu box.
Dim Shared Ambiguate As Integer, AmbiguateSwitch As Integer
Dim Shared Attribute As Integer, ASCIIZ3 As String * 260
Dim Shared Current.Drive As Integer, Drive.Box.Line As Integer
Dim Shared Default.Drive As Integer, Last.Drive As Integer
Dim Shared Num.Dirs As Single, Num.Files As Single
Dim Shared CurrentDirectory As String

' declare Alt-n keys array.
Dim Shared Keys(1 To 26) As Integer

' declare filename sort variables for file menu box.
Dim Shared FileSort As Integer, DirSort As Integer ' Millisecond As Integer

' declare requirement filename attribute bit variables for file menu box.
Dim Shared RequireReadOnly As Integer, RequireHidden As Integer
Dim Shared RequireSystem As Integer, RequireArchive As Integer

' declare requirement directory attribute bit variables for file menu box.
Dim Shared RequireDirReadOnly As Integer, RequireDirHidden As Integer
Dim Shared RequireDirSystem As Integer, RequireDirArchive As Integer

' declare sort structure for file menu box.
Dim Shared WinFileStruc As WinFileType

' declare menu screen location offsets for file menu box.
Dim Shared Xcoor As Integer, Ycoor As Integer

' declare menu variables for DropDownMenu.
Dim Shared CurrentMenu As Integer, CurrentMenuSelection As Integer

' declare variables for copy/paste.
Dim Shared CopyByte As String * 1, CopyStart As Double
Dim Shared CopyPositionEnd As Double, CopyPositionPivot As Double
Dim Shared CopyPositionStart As Double

' declare structure for multiple files.
Dim Shared File(1 To 15) As FileType

' declare multiple file variables.
Dim Shared CurrentFile As Integer, NumberFiles As Integer

' declare temp file share variables.
Dim Shared Process.Number As Integer
Dim Shared Share.Count As Integer ' count violations
Dim Shared InErrorFlag As Integer

' temp directory
Dim Shared DRX As String

' fast exit variable
Dim Shared FastExit As Integer

' declare color variables.
Dim Shared Black As Integer, Blue As Integer, Cyan As Integer
Dim Shared Green As Integer, Magenta As Integer, Plain As Integer
Dim Shared Red As Integer, White As Integer, Yellow As Integer
Dim Shared BackGround As Integer, BackGround2 As Integer

' declare network path variables.
Dim Shared CurrentNetPath As String * 260, DefaultNetPath As String * 260
Dim Shared StartDir As String

' internal debug variables.
Dim Shared Debug As Integer, Debug2 As Integer, Debug3 As Integer
Dim Shared Control.Break As Integer

' additional display purposes.
Dim Shared DirLoadMessage As String, FileLoadMessage As String

' declare default printer port variable.
Dim Shared PrinterPort As Integer

' declare error variables.
Dim Shared Check.Disk As Integer
Dim Shared Disk.Ready As Integer

' allow unprintable characters.
Dim Shared CharPrint As Integer

' declare version constants.
$If VERSION < 4.0.0 Then
   Dim Shared Quote As String * 1
   Quote = Chr$(34)
$End If
$If VERSION >= 4.0.0 Then
   Const Quote = Chr$(34)
$End If

' declare some constants.
Const Nul = ""
Const False = 0
Const SFalse = 0!
Const DFalse = 0#
Const True = -1

' declare author constants.
Const Author$ = "Erik Jon Oredson"
Const Email = "eoredson@gmail.com"
Const Version = "v9.0a"
Const Release = "r3.0a"
Const Program = "Hex Editor"
Const Publish = "09/05/2025"
Const Status = "Public Domain"
Const Tweak = "t3.1a"
Const Urls = "www.applewoodbbs.linkpc.net/files"
Const YearRelease = "2025"

' declare maximum files/processes.
Const MaxFiles = 15 ' should not be changed
Const MaxProcesses = 9 ' should not be changed
Const MaxViolations = 1024 ' maximum share violations

' declare maximum files/dirs values for file menu box.
Const MaxPrecision = 1048576! ' maximum files/dirs
Const MaxPrecision1 = 1024! ' maximum kilos of files/dirs
Const MaxPrecision2 = 1! ' maximum megs of files/dirs

' declare library constants.
Const MAX_PATH = 260
Const MAX_PATH2 = 520
Const INVALID_HANDLE_VALUE = -1
Const ERROR_FILE_NOT_FOUND = 2
Const ERROR_NO_MORE_FILES = &H12
Const FILE_FLAG_BACKUP_SEMANTICS = &H02000000 ' CreateFile directory flag

' declare library structures.
Type FILETIME
   dwLowDateTime As _Unsigned Long
   dwHighDateTime As _Unsigned Long
End Type

Type SYSTEMTIME
   wYear As Integer
   wMonth As Integer
   wDayOfWeek As Integer
   wDay As Integer
   wHour As Integer
   wMinute As Integer
   wSecond As Integer
   wMilliseconds As Integer
End Type

Type WIN32_FIND_DATA
   dwFileAttributes As _Unsigned Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As _Unsigned Long
   nFileSizeLow As _Unsigned Long
   dwReserved0 As _Unsigned Long
   dwReserved1 As _Unsigned Long
   cFileName As String * Max_path
   cAlternateFileName As String * 14
End Type

' declare external kernel libraries.
Declare Dynamic Library "kernel32"
   Function GetLocalTime& (lpSystemTime As SYSTEMTIME)
   Function SetLocalTime& (lpSystemTime As SYSTEMTIME)
   Function GetSystemTime& (lpSystemTime As SYSTEMTIME)
   Function SetSystemTime& (lpSystemTime As SYSTEMTIME)

   Function FindFirstFileA~%& (ByVal lpFileName~%&, ByVal lpFindFileData~%&)
   Function FindNextFileA& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindFirstFileW~%& (lpwszFileName$, ByVal lpFindFileData~%&)
   Function FindNextFileW& (ByVal hFindFile~%&, ByVal lpFindFileData~%&)
   Function FindClose& (ByVal hFindFile~%&)

   Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, ByVal nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, ByVal nFileSystemNameSize&)
   Function GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
   Function GetDiskFreeSpaceExA& (filename$, free As _Unsigned _Integer64, total As _Unsigned _Integer64, free2 As _Unsigned _Integer64)
   Function SetVolumeLabelA% (d$, f$)

   Function GetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function SetFileTime& (ByVal hFile As _Offset, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, lpLastWriteTime As FILETIME)
   Function FileTimeToSystemTime& (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
   Function SystemTimeToFileTime& (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME)

   Function DeleteFileA% (F$)
   Function RemoveDirectoryA% (F$)
   Function CreateDirectoryA% (F$, ByVal X&)
   Function SetCurrentDirectoryA% (f$)
   Function CloseHandle& (ByVal hfile As _Offset)
   Function GetLastError& ()
   Function FormatMessageA& (ByVal f As Long, f$, ByVal e As Long, ByVal d As Long, g$, ByVal s As Long, h$)

   Function MultiByteToWideChar& (ByVal codePage~&, ByVal dwFlags~&, lpszMbstring$, ByVal byteCount&, lpwszWcstring$, ByVal wideCount&)
   Function WideCharToMultiByte& (ByVal codePage~&, ByVal dwFlags~&, lpWideString$, ByVal ccWideChar%, lpMultiByte$, ByVal multibyte%, ByVal defaultchar&, ByVal usedchar&)
   Function MoveFileW (f$, g$)
End Declare

' declare external libraries.
Declare Library
   Function GetFileAttributes& (f$)
   Function SetFileAttributes& (f$, ByVal a&)
   Function GetDriveType& (d$)
   Function GetShortPathName& (InP$, OutP$, ByVal length&)
   Function GetModuleFileNameA (ByVal Module As Long, FileName As String, ByVal nSize As Long)

   Function CreateFile& (filename$, ByVal access&, ByVal sharing&, ByVal sec_attr%&, ByVal create&, ByVal flags&, ByVal template%&)
   Function MoveFile (f$, g$)
   Function CopyFile (f$, g$, ByVal f%)
   Function EncryptFile (f$)
   Function DecryptFile (f$, ByVal f&)
   Function EncryptFileA (f$)
   Function DecryptFileA (f$, ByVal f&)
End Declare

' declare external libraries.
Declare Dynamic Library "user32"
   Function SendMessageA%& (ByVal hWnd%&, ByVal Msg~&, ByVal wParam~%&, ByVal lParam%&)
   Function GetDesktopWindow%& ()
End Declare

' declare screen saver call constants
Const wm_syscommand = &H112&
Const sc_screensave = &HF140&

' declare library variables.
Dim Shared finddata As WIN32_FIND_DATA, hfind As _Unsigned _Offset
Dim Shared SysTime As SYSTEMTIME, DriveType As String

' set windows coordinates
Dim Shared WindowX As Integer, WindowY As Integer
Dim Shared LoadMenuBox As Integer

' declare error trap.
On Error GoTo Error.Routine

' scancodes for Alt-A to Alt-Z.
Data 30,48,46,32,18,33,34,35,23,36
Data 37,38,50,49,24,25,16,19,31,20
Data 22,47,17,45,21,44

' read Alt-<key> data.
For Var = 1 To 26
   Read Keys(Var)
Next

' store default path
CurrentDirectory = _CWD$
If Right$(CurrentDirectory, 1) <> "\" Then
   CurrentDirectory = CurrentDirectory + "\"
End If

' force default path
x$ = _StartDir$
StartDir$ = x$
If Right$(StartDir$, 1) <> "\" Then
   StartDir$ = StartDir$ + "\"
End If
f$ = x$ + Chr$(0)
x = SetCurrentDirectoryA(f$)

' start timer trap.
On Timer(1) Timer.Trap
Timer On
VarQ = _Exit

' set title icon
i& = _LoadImage("HEXEDIT.BMP", 32)
If i& < -1 Then
   _Icon i&
   _FreeImage i&
Else
   ' old icon code
   If _FileExists("hexedit.ico") Then
      Call DisplayIcon("hexedit.ico")
   End If
End If

' declare window title.
_Title "HEXEDIT"

' check command line node.
CommandLine$ = Read.Command$
CommandLine$ = LTrim$(RTrim$(CommandLine$))
CommandLine$ = UCase$(CommandLine$)
Var = InStr(CommandLine$, "/F")
If Var Then
   LoadMenuBox = -1
   CommandLine$ = Left$(CommandLine$, Var - 1) + Mid$(CommandLine$, Var + 2)
End If
CommandLine$ = LTrim$(RTrim$(CommandLine$))
If Left$(CommandLine$, 1) = "/" Then
   Var$ = Mid$(CommandLine$, 2, 1)
   CommandLine$ = Mid$(CommandLine$, 3)
   If Var$ >= "1" And Var$ <= "9" Then
      Node = Int(Val(Var$))
   End If
End If
If Environ$("LOADMENUBOX") <> "" Then
   LoadMenuBox = -1
End If

' intialize some variables.
Call InitVars

' restore settings
Call ReadConfig
_ScreenMove WindowX, WindowY

' initialize server name.
Call StoreServerName

' read config file.
Call ReadConfigFile(Filename)

' get current drive/directory.
Call GetDrive(Drive.Number, Directory$)

' init undo/marker file.
Call OpenUndoFile(VarQ)

' check bad filename.
If VarQ Then
   GoTo Error.Exit
End If

' init paste file.
Call InitializePaste(VarQ)

' check bad filename.
If VarQ Then
   GoTo Error.Exit
End If

' reset menu filename flag.
IsMenuFile = False

' check command line.
Select Case Command$
   Case "/?", "-?"
      GoTo BootUsage
End Select

' check command line filename.
If CommandLine$ <> Nul Then
   GoTo StartFile
End If

' init splash screen.
If LoadMenuBox Then GoTo BeginFile
Call AnsiScreen(0)
t1 = _FreeTimer
t2! = 1!
On Timer(t1, t2!) CallSplash
Timer(t1) On

' startup menubox selection.
x = ErrorBox2(" Hexedit " + Version + " ", "Enter file menu:|Select Filebox/Dialogbox")
Timer(t1) Off

' escape = exit
If x = -2 Then
   Call Delete.Process
   System
End If
LoadMenuBox = x

' filename entry starts here.
BeginFile:

' store netpath/drive
If Left$(CurrentDirectory$, 2) = "\\" Then
   NetPath2$ = CurrentDirectory$ ' \\server\share\
   Drive$ = ""
Else
   Drive$ = Left$(CurrentDirectory$, 1) ' c:\dir
End If
If NetPath2$ = "" Then
   Directory$ = Mid$(CurrentDirectory$, 4) ' c:\dir
Else
   Directory$ = ""
End If
If LoadMenuBox Then
   ' call file menu box.
   Call Menu(NetPath2$, Drive$, Directory$, FileSpec1$, FileSpec2$)
Else
   ' call dialog menu box.
   Call Menu3(NetPath2$, Drive$, Directory$, FileSpec2$)
End If
NetPath$ = NetPath2$

' reset menu filename flag.
IsMenuFile = True

' check filename.
If FileSpec2$ = Nul Then
   ' verify a file open already.
   If NumberFiles >= 1 Then
      ASCIIZ = File(CurrentFile).ASCIIZ
      GoTo TopProgram
   End If
   ' exit program.
   GoTo BootUsage
End If

' construct filename from menu box.
If NetPath$ = Nul Then
   If Directory$ = Nul Then
      Filename = Drive$ + ":\" + FileSpec2$
   Else
      Filename = Drive$ + ":\" + Directory$ + "\" + FileSpec2$
   End If
Else
   If Directory$ = Nul Then
      Filename = NetPath$ + "\" + FileSpec2$
   Else
      Filename = NetPath$ + "\" + Directory$ + "\" + FileSpec2$
   End If
End If

' store filename from menu box.
CommandLine$ = Filename

' filename entry loop starts here.
StartFile:

' start filename entry loop.
Do
   ' check filenames
   If CommandLine$ = Nul Then
      Exit Do
   End If

   ' get filename from command line.
   CommandLine$ = RTrim$(CommandLine$)
   CommandLine$ = LTrim$(CommandLine$)

   ' check menu filename returned.
   If IsMenuFile Then
      Filename = CommandLine$
      CommandLine$ = Nul
   End If

   ' parse command line
   If IsMenuFile = False Then
      If Left$(CommandLine$, 1) = Quote Then
         Var = InStr(2, CommandLine$, Quote)
         If Var = False Then
            GoTo BeginFile
         End If
         Filename = Left$(CommandLine$, Var - 1)
         Filename = Mid$(Filename, 2)
         If Filename = Nul Then
            GoTo BeginFile
         End If
         CommandLine$ = Mid$(CommandLine$, Var + 1)
      Else
         Var = InStr(CommandLine$, " ")
         If Var Then
            Filename = Left$(CommandLine$, Var - 1)
            CommandLine$ = Mid$(CommandLine$, Var + 1)
         Else
            Filename = CommandLine$
            CommandLine$ = Nul
         End If
      End If
   End If

   ' trim filename.
   Filename = RTrim$(Filename)
   Filename = LTrim$(Filename)

   ' check long filename in quotes.
   If Left$(Filename, 1) = Quote Then
      If Right$(Filename, 1) = Quote Then
         Filename = Mid$(Filename, 2)
         Filename = Left$(Filename, Len(Filename) - 1)
      End If
   End If

   ' check max files.
   If NumberFiles = MaxFiles Then
      Exit Do
   End If

   ' check filenames.
   Var3$ = Filename
   Do
      ' check multiple filenames.
      Var3 = InStr(Var3$, Chr$(13))
      If Var3 Then
         Var$ = Left$(Var3$, Var3 - 1)
         Var3$ = Mid$(Var3$, Var3 + 1)
      Else
         If Len(Var3$) Then
            Var$ = Var3$
            Var3$ = Nul
         Else
            Exit Do
         End If
      End If

      ' check filelist exists.
      Var4$ = FILELISTEXISTS(Var$)
      If Len(Var4$) Then
         ' open filelist filename.
         Check.Disk = True
         Disk.Ready = False
         x2 = FreeFile
         Open Var4$ For Input As #x2
         Check.Disk = False
         If Disk.Ready = False Then

            ' read filelist files.
            Do Until EOF(x2)
               Line Input #x2, Var$
               Var$ = RTrim$(Var$)
               Var$ = LTrim$(Var$)
               If Len(Var$) Then

                  ' check max files.
                  If NumberFiles = MaxFiles Then
                     Exit Do
                  End If

                  ' load file.
                  GoSub LoadMultipleFile
               End If
            Loop
            Close #x2
         End If
      Else
         ' load file.
         GoSub LoadMultipleFile
      End If
   Loop
Loop

' check files loaded.
If NumberFiles = False Then
   GoTo BeginFile
End If

' main program loop starts here.
TopProgram:

' reset mouse activity.
Call ClearMouse

' setup editing screen.
GoSub RedrawScreen0
Call LocateCursor2

' keyboard/mouse input loop starts here.
StartLoop:

' keyboard/mouse input loop.
Do
   ' check for keypress or mouse activity.
   CharInput$ = Nul
   Do
      ' store keyboard buffer.
      CharInput$ = INKEYq$ ' get keymapped char
      If Len(CharInput$) Then
         Exit Do
      End If

      ' call mouse subroutine.
      Z = MouseDriver
      If MouseWheel = -1 Then
         If WheelReverse Then
            CharInput$ = Chr$(0) + Chr$(80) ' down
         Else
            CharInput$ = Chr$(0) + Chr$(72) ' up
         End If
         MouseWheel = 0
         Exit Do
      End If
      If MouseWheel = 1 Then
         If WheelReverse Then
            CharInput$ = Chr$(0) + Chr$(72) ' up
         Else
            CharInput$ = Chr$(0) + Chr$(80) ' down
         End If
         MouseWheel = 0
         Exit Do
      End If
      If MouseButton1 Then
         GoSub MouseMove1
      Else
         If MouseButton2 Then
            GoSub MouseMove2
         Else
            If MouseButton3 Then ' redraw screen
               Call MultiFileFunction(2)
               GoSub RedrawScreen0
            Else
               If MouseX Or MouseY Then
                  GoSub MoveMouse
               End If
            End If
         End If
      End If
   Loop
   Call LocateCursor2

   ' get shift state.
   Def Seg = &H40
   ShiftFlag = Peek(&H17)
   Def Seg

   ' store shift state.
   LeftShift = ShiftFlag And 1 ' left shift.
   RightShift = ShiftFlag And 2 ' right shift.
   CtrlShift = ShiftFlag And 4 ' either ctrl.
   AltShift = ShiftFlag And 8 ' either alt.

   ' check shift state.
   If CtrlShift = 4 And AltShift = 8 Then
      If Len(CharInput$) = 2 Then
         KeyX = Asc(Right$(CharInput$, 1))
         Select Case KeyX
            Case 104 ' Ctrl-Alt-F1
               Call ClearStatus
               Printf "Attempt to reboot(y/n)?"
               Var$ = ""
               Do
                  _Limit 50
                  Var$ = LCase$(InKey$)
                  If Var$ = "y" Or Var$ = "n" Then Exit Do
               Loop
               If Var$ = "y" Then
                  Call RebootFunc(Var2)
                  StatusMessage = "Reboot failed."
                  Call DisplayStatus2
               End If
               If Var$ = "n" Then
                  StatusMessage = "Reboot halted."
                  Call DisplayStatus2
               End If
            Case 105 ' Ctrl-Alt-F2
               Call ClearStatus
               Printf "Attempt to shutdown(y/n)?"
               Var$ = ""
               Do
                  _Limit 50
                  Var$ = LCase$(InKey$)
                  If Var$ = "y" Or Var$ = "n" Then Exit Do
               Loop
               If Var$ = "y" Then
                  Call ShutdownFunc(Var2)
                  StatusMessage = "Shutdown failed."
                  Call DisplayStatus2
               End If
               If Var$ = "n" Then
                  StatusMessage = "Shutdown halted."
                  Call DisplayStatus2
               End If
            Case 106 ' Ctrl-Alt-F3
               Call ClearStatus
               Printf "Enter Keymap Function?"
               Var1$ = LineInput$(2, 27, 10)
               Call Keymapper(Var1$)
               GoSub RedrawScreen0
            Case Else
               GoSub DisplayData4
         End Select
      End If
      LeftShift = 0: RightShift = 0
      CtrlShift = 0: AltShift = 0
      CharInput$ = Nul
   End If

   ' check shift flags.
   If LeftShift Or RightShift Then
      ' parse the key.
      Select Case Len(CharInput$)
         Case 1
            Select Case Asc(CharInput$)
               Case 124 ' | FirstFile
                  GoSub GotoFirstFile
               Case 35 ' # LastFile
                  GoSub GotoLastFile
               Case 33 ' ! = display page/row/column.
                  GoSub DisplayData1
               Case 34 ' " = display file path.
                  GoSub DisplayPath
               Case 63 ' ? = display filelength\undos.
                  GoSub DisplayInfo
               Case 123 ' { = display paste entries.
                  GoSub DisplayPasteUndos
               Case 126 ' ~ = display last page\markers.
                  GoSub DisplayLengths
               Case 8, 60 ' Backspace/< file left.
                  GoSub GotoPreviousFile
               Case 62 ' > file right
                  GoSub GotoNextFile
               Case 43 ' + = list range of markers.
                  If FileLength Then
                     Call MultiFileFunction(2)
                     Call Marker(1)
                     If ValidFunction Then
                        GoSub RedrawScreen0
                     End If
                  End If
                  ' byte hilighting functions.
               Case 52 ' Shift-Left
                  If FileLength Then
                     Call MouseButton1Drag(1)
                  End If
               Case 54 ' Shift-Right
                  If FileLength Then
                     Call MouseButton1Drag(2)
                  End If
               Case 56 ' Shift-Up
                  If FileLength Then
                     Call MouseButton1Drag(3)
                  End If
               Case 50 ' Shift-Down
                  If FileLength Then
                     Call MouseButton1Drag(4)
                  End If
               Case 57 ' Shift-PageUp
                  If FileLength Then
                     Call MouseButton1Drag(5)
                  End If
               Case 51 ' Shift-PageDown
                  If FileLength Then
                     Call MouseButton1Drag(6)
                  End If
               Case 49 ' Shift-End
                  If FileLength Then
                     Call MouseButton1Drag(7)
                  End If
               Case 55 ' Shift-Home
                  If FileLength Then
                     Call MouseButton1Drag(8)
                  End If
               Case Else ' Unknown key.
                  GoSub HelpLine
            End Select
         Case 2
            Select Case Asc(Right$(CharInput$, 1))
               Case 15 ' Shift-Tab = Toggle window.
                  If FileLength Then
                     GoSub TabWindow
                  End If
                  ' byte hilighting functions.
               Case 75 ' Shift-Left
                  If FileLength Then
                     Call MouseButton1Drag(1)
                  End If
               Case 77 ' Shift-Right
                  If FileLength Then
                     Call MouseButton1Drag(2)
                  End If
               Case 72 ' Shift-Up
                  If FileLength Then
                     Call MouseButton1Drag(3)
                  End If
               Case 80 ' Shift-Down
                  If FileLength Then
                     Call MouseButton1Drag(4)
                  End If
               Case 73 ' Shift-PageUp
                  If FileLength Then
                     Call MouseButton1Drag(5)
                  End If
               Case 81 ' Shift-PageDown
                  If FileLength Then
                     Call MouseButton1Drag(6)
                  End If
               Case 79 ' Shift-End
                  If FileLength Then
                     Call MouseButton1Drag(7)
                  End If
               Case 71 ' Shift-Home
                  If FileLength Then
                     Call MouseButton1Drag(8)
                  End If
               Case Else ' Unknown key.
                  GoSub HelpLine
            End Select
      End Select
   Else
      ' parse the key.
      Select Case Len(CharInput$)
         Case 1 ' single ascii key.
            Select Case Asc(CharInput$)
               Case 5 ' Control-E = TestError
                  If Debug Then
                     V = Sqr(-1) ' test syntax error.
                  End If
               Case 9 ' Tab = Toggle window.
                  If FileLength Then
                     GoSub TabWindow
                  End If
               Case 13 ' Enter = Change byte value.
                  If FileLocked Then
                     Call DisplayX
                     Call LockedFile
                  Else
                     If FileLength = 0 Then
                        Byte2 = 0
                        GoSub AppendIt
                     End If
                     If FileLength Then
                        GoSub ChangeHexValue
                     End If
                  End If
               Case 27 ' Escape = Start drop down menu.
                  If CurrentMenu <> 1 Then
                     ' remove hilight menu tab.
                     Colorf2 White, 0
                     Call DisplayTab(CurrentMenu)
                  End If
                  CurrentMenu = 1
                  CurrentMenuSelection = 1
                  GoTo Menu2
               Case 59 ' ; = display hilight range.
                  GoSub DisplayCopy
               Case 49 ' 1 = Add marker.
                  If FileLength Then
                     Call Marker(2)
                  End If
               Case 50 ' 2 = Add marker value.
                  If FileLength Then
                     Call Marker(3)
                  End If
               Case 51 ' 3 = Delete marker.
                  If FileLength Then
                     Call Marker(4)
                  End If
               Case 52 ' 4 = Delete specified marker.
                  If FileLength Then
                     Call Marker(5)
                  End If
               Case 53 ' 5 = Jump to previous marker.
                  If FileLength Then
                     Call Marker(6)
                  End If
               Case 54 ' 6 = Jump to current marker.
                  If FileLength Then
                     Call Marker(7)
                  End If
               Case 55 ' 7 = Jump to next marker.
                  If FileLength Then
                     Call Marker(8)
                  End If
               Case 56 ' 8 = Jump to specified marker.
                  If FileLength Then
                     Call Marker(9)
                  End If
               Case 57 ' 9 = List all markers.
                  If FileLength Then
                     Call MultiFileFunction(2)
                     Call Marker(10)
                     GoSub RedrawScreen0
                  End If
               Case 48 ' 0 = List specified markers.
                  If FileLength Then
                     Call Marker(11)
                  End If
               Case 45 ' - = List marker of value.
                  If FileLength Then
                     Call MultiFileFunction(2)
                     Call Marker(12)
                     GoSub RedrawScreen0
                  End If
               Case 61 ' = = Delete range of markers.
                  If FileLength Then
                     Call Marker(13)
                  End If
               Case 91 ' [ = Delete all markers.
                  If FileLength Then
                     Call Marker(14)
                  End If
               Case 93 ' ] = Delete markers of specified values.
                  If FileLength Then
                     Call Marker(15)
                  End If
                  ' toggle debug.
               Case 4 ' Control-D = Toggle debug variable.
                  GoSub ToggleDebug
               Case 6 ' Control-F = Toggle debug2 variable.
                  GoSub ToggleDebug2
               Case 7 ' Control-G = Toggle debug3 variable.
                  GoSub ToggleDebug3
                  ' clipboard functions.
               Case 3 ' Control-C = Copy paste area.
                  If FileLength Then
                     _Delay 1.2 ' delay for break
                     If Control.Break = 0 Then
                        Call Clipboard2(1)
                     End If
                  End If
               Case 22 ' Control-V = Paste area.
                  If FileLength Then
                     Call Clipboard2(2)
                  End If
               Case 24 ' Control-X = Undo current paste.
                  If FileLength Then
                     Call Clipboard2(3)
                  End If
               Case 26 ' Control-Z = Undo all pastes.
                  If FileLength Then
                     Call Clipboard2(4)
                  End If
                  ' remaining control functions.
               Case 19 ' Control-S = Windows screen saver.
                  GoSub SaveShell
               Case 20 ' Control-T = Toggle search string storage variable.
                  GoSub ToggleSearch
                  ' remaining functions.
               Case 32 ' Space = Display author and help key.
                  GoSub DisplayAuthor
               Case 8, 127 ' Backspace/Control-BackSpace = Goto previous file.
                  GoSub GotoPreviousFile
               Case Else ' Unknown key.
                  GoSub HelpLine2
            End Select
         Case 2 ' extended ascii key.
            Select Case Asc(Right$(CharInput$, 1))
               Case 94, 130 ' Control-F1/Alt-- = Display Date/Time
                  GoSub DisplayData2
               Case 95, 131 ' Control-F2/Alt-= = Display loaded files.
                  GoSub DisplayData3
               Case 30 ' Alt-A = Append multiple bytes.
                  If FileLocked Then
                     Call DisplayX
                     Call LockedFile
                  Else
                     GoSub AppendByte
                  End If
               Case 48 ' Alt-B = Append multiple null bytes.
                  If FileLocked Then
                     Call DisplayX
                     Call LockedFile
                  Else
                     GoSub AppendNullBytes
                  End If
               Case 46 ' Alt-C = ANSI Chart.
                  GoSub ANSIChart
               Case 32 ' Alt-D = HEX screen dump.
                  If FileLength Then
                     GoSub DumpScreen
                  End If
               Case 18 ' Alt-E = HEX file dump.
                  If FileLength Then
                     GoSub DumpHEXFile
                  End If
               Case 33, 148 ' Alt-F/Control-Tab = Start drop down menu.
                  If CurrentMenu <> 1 Then
                     ' remove hilight menu tab.
                     Colorf2 White, 0
                     Call DisplayTab(CurrentMenu)
                  End If
                  CurrentMenu = 1
                  CurrentMenuSelection = 1
                  GoTo Menu2
               Case 34 ' Alt-G = Append multiple specified bytes.
                  If FileLocked Then
                     Call DisplayX
                     Call LockedFile
                  Else
                     GoSub AppendAnyByte
                  End If
               Case 35 ' Alt-H = HEX chart.
                  GoSub HEXChart
               Case 36 ' Alt-J = Jump to byte.
                  If FileLength Then
                     GoSub JumpByte
                  End If
               Case 38 ' Alt-L = Jump to page.
                  If FileLength Then
                     GoSub JumpPage
                  End If
               Case 50 ' Alt-M = Append ASCII string.
                  If FileLocked Then
                     Call DisplayX
                     Call LockedFile
                  Else
                     GoSub AppendASCII
                  End If
               Case 49, 66, 101 ' Alt-N/F8/Control-F8 = Load new file.
                  If NumberFiles = MaxFiles Then
                     StatusMessage = "Maximum of" + Str$(MaxFiles) + " files open."
                     Call DisplayStatus2
                  Else
                     Call MultiFileFunction(2)
                     GoSub NewFile
                     GoTo BeginFile
                  End If
               Case 24 ' Alt-O = Print help screens.
                  GoSub PrintHelp
               Case 25 ' Alt-P = HEX screen print.
                  If FileLength Then
                     GoSub PrintScreen
                  End If
               Case 16 ' Alt-Q = Display help screens.
                  GoSub DisplayHelp
               Case 19 ' Alt-R = Redraw screen.
                  Call MultiFileFunction(2)
                  GoSub RedrawScreen0
               Case 20 ' Alt-T = HEX file print.
                  If FileLength Then
                     GoSub PrintFile
                  End If
               Case 22 ' Alt-U = Undo last byte change.
                  If FileLength Then
                     GoSub UndoByte
                  End If
               Case 17, 67, 102 ' Alt-W/F9/Control-F9 = Close current file.
                  GoSub CloseCurrentFile
                  If NumberFiles = False Then
                     GoSub NewFile
                     GoTo BeginFile
                  End If
               Case 45 ' Alt-X = Exit program.
                  Exit Do ' exit program.
               Case 21, 63 ' Alt-Y/F5 = Toggle right window.
                  If FileLength Then
                     GoSub ToggleRight
                  End If
               Case 44 ' Alt-Z = Undo all byte changes.
                  If FileLength Then
                     GoSub UndoAll
                  End If
               Case 129 ' Alt-0 = Close all files/Return to File Menu Box.
                  GoSub CloseAllFiles
                  GoSub NewFile
                  NumberFiles = False
                  GoTo BeginFile
               Case 59, 141 ' F1/Control-Up = Toggle filename display.
                  FileDisplay = Not FileDisplay
                  If FileDisplay = False Then
                     Call DisplayFileTitle
                  Else
                     GoSub DisplayScreen3
                  End If
               Case 60, 145 ' F2/Control-Down = Toggle bottom row help keys.
                  ScreenRow = Not ScreenRow
                  Call MultiFileFunction(2)
                  GoSub RedrawScreen0
               Case 37, 61 ' Alt-K/F3 = Search ascii string.
                  If FileLength Then
                     GoSub SearchASCII
                  End If
                  ' Alt-S/F4/Control-F4 = Search multiple bytes.
               Case 31, 62, 97
                  If FileLength Then
                     GoSub SearchBytes
                  End If
                  ' Alt-Right/F6/Control-F6 = Goto next file.
               Case 157, 64, 99
                  GoSub GotoNextFile
                  ' Alt-Left/F7/Control-F7 = Goto previous file.
               Case 155, 65, 100
                  GoSub GotoPreviousFile
                  ' Alt-V/Ctrl-F10/F10 = View files.
               Case 47, 103, 68
                  Call Viewfiles(Var)
                  If Var > False Then
                     NextFile = Var
                     GoSub SearchFile3
                  End If
                  Call DisplayFilename
               Case 96 ' Control-F3 = Continue search.
                  If FileLength Then
                     GoSub ContinueSearch
                  End If
               Case 133, 137 ' F11/Control-F11 = Drop to DOS.
                  GoSub DOSshell
               Case 139 ' Alt-F11
                  GoSub MenuBox2
               Case 140 ' Alt-F12
                  GoSub MenuBox
               Case 138 ' Control-F12 = edit config file
                  Call GetConfigFilename(f$)
                  If Len(f$) Then
                     Call Scrnedit(f$)
                     CharInput$ = Nul
                     GoSub RedrawScreen0
                  End If
               Case 23, 134 ' Alt-I/F12 = DOS Command.
                  GoSub DOScommand
               Case 143, 98 ' Control-Keypad-5/Control-F5 = Select Specific Filename.
                  GoSub SearchFile2
               Case 76, 113 ' Keypad-5/Alt-F10 = Hex/Dec calculator.
                  GoSub HEXCalculator
               Case 104 To 112 ' Alt-F1 to Alt-F9 = Select File.
                  NextFile = Asc(Right$(CharInput$, 1)) - 103
                  GoSub SearchFile3
               Case 120 To 128 ' Alt-1 to Alt-9 = Select file.
                  NextFile = Asc(Right$(CharInput$, 1)) - 119
                  GoSub SearchFile3
               Case 82 ' Insert = Change string value.
                  If FileLocked Then
                     Call DisplayX
                     Call LockedFile
                  Else
                     GoSub ChangeASCIIValues
                  End If
               Case 83 ' Delete = Change HEX string.
                  If FileLocked Then
                     Call DisplayX
                     Call LockedFile
                  Else
                     GoSub ChangeHEXValues
                  End If
               Case 72 ' Up
                  If FileLength Then
                     GoSub CursorUp
                  End If
               Case 80 ' Down
                  If FileLength Then
                     GoSub CursorDown
                  End If
               Case 75 ' Left
                  If FileLength Then
                     GoSub CursorLeft
                  End If
               Case 77 ' Right
                  If FileLength Then
                     GoSub CursorRight
                  End If
               Case 152, 73, 132 ' Alt-Up/PageUp/Control-PageUp
                  If FileLength Then
                     GoSub PageUp
                  End If
               Case 160, 81, 118 ' Alt-Down/PageDown/Control-PageDown
                  If FileLength Then
                     GoSub PageDown
                  End If
               Case 79 ' End
                  If FileLength Then
                     GoSub EndKey
                  End If
               Case 71 ' Home
                  If FileLength Then
                     GoSub HomeKey
                  End If
               Case 142, 74, 115 ' Control-Keypad-/Alt-Keypad-/Control-Left
                  If FileLength Then
                     GoSub CtrlLeftKey
                  End If
               Case 144, 78, 116 ' Control-Keypad+/Alt-Keypad+/Control-Right
                  If FileLength Then
                     GoSub CtrlRightKey
                  End If
               Case 117 ' Control-End
                  If FileLength Then
                     GoSub CtrlEndKey
                  End If
               Case 119 ' Control-Home
                  If FileLength Then
                     GoSub CtrlHomeKey
                  End If
               Case Else ' Unknown key.
                  GoSub HelpLine3
            End Select
      End Select
   End If
   Call LocateCursor2
Loop

' stop program.
StopLabel:

' clear hilighted byte.
Call ClearPageByte

' clear status areas.
Call ClearStatus
GoSub DisplayScreen3

' display goodbye message.
Colorf2 Yellow, 0
Locatef 2, 4, 0
Z$ = "You have been using a public domain program written by "
Z$ = Z$ + Author$ + ".."
Z$ = Left$(Z$, 74)
Printf Z$
Locatef 2, 4, 0

' clear file menu tab.
If CurrentMenu Then
   Colorf2 White, 0
   Call DisplayTab(CurrentMenu)
End If

' remove bottom lines of screen.
For Var = 21 To 24
   Locatef Var, 1, 0
   Printf Space$(78)
Next
Locatef 21, 1, 0
Colorf Magenta
Printf " " + Chr$(LLcorner) + String$(75, Hline) + Chr$(LRcorner)

' goto end of program.
GoTo StopLoop
End

' load filespec.
LoadMultipleFile:
' check max files.
If NumberFiles = MaxFiles Then
   Return
End If

' trim filename.
Filename = Var$
Filename = RTrim$(Filename)
Filename = LTrim$(Filename)

' check long filename in quotes.
If Left$(Filename, 1) = Quote Then
   If Right$(Filename, 1) = Quote Then
      Filename = Mid$(Filename, 2)
      Filename = Left$(Filename, Len(Filename) - 1)
   End If
End If

' check wildcard characters.
If InStr(Filename, "?") Or InStr(Filename, "*") Then
   ' store filename drive/directory
   D$ = Nul
   C$ = Nul
   N$ = Nul
   x$ = Nul
   ' get netpath
   If Left$(Filename, 2) = "\\" Then
      Net1 = InStr(3, Filename, "\")
      If Net1 Then
         Net2 = InStr(Net1 + 1, Filename, "\")
         If Net2 Then
            N$ = Left$(Filename, Net2 - 1)
            Filename = Mid$(Filename, Net2)
         End If
      End If
   End If
   ' get directory
   For Var = Len(Filename) To 1 Step -1
      If Mid$(Filename, Var, 1) = "\" Then
         D$ = Left$(Filename, Var)
         x$ = Mid$(Filename, Var + 1)
         Exit For
      End If
   Next
   ' restore filename
   If N$ <> Nul Then
      Filename = N$ + D$ + x$
   End If
   ' get drive
   If Mid$(Filename, 2, 1) = ":" Then
      C$ = Left$(Filename, 2)
      D$ = Mid$(D$, 3)
   End If
   ' check pathname
   If C$ = Nul Then
      If D$ = Nul Then
         Var$ = _CWD$
         C$ = Left$(Var$, 2)
         D$ = Mid$(Var$, 3)
      End If
   End If

   ' clear filename array.
   For VarZ = 1 To MaxFiles
      TempFiles(VarZ) = Nul
   Next
   ' store filename array.
   VarZ = False
   Filename = Filename + Chr$(0)
   hfind = FindFirstFileA(_Offset(Filename), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         x$ = finddata.cFileName
         VarX = InStr(x$, Chr$(0))
         If VarX Then
            x$ = Left$(x$, VarX - 1)
         End If
         If Len(x$) Then
            Attr = finddata.dwFileAttributes
            If (Attr And &H10) = &H0 Then
               If VarZ < MaxFiles Then
                  VarZ = VarZ + 1
                  If N$ = Nul Then
                     If Right$(D$, 1) = "\" Then
                        TempFiles(VarZ) = C$ + D$ + x$
                     Else
                        TempFiles(VarZ) = C$ + D$ + "\" + x$
                     End If
                  Else
                     If D$ = Nul Then
                        TempFiles(VarZ) = N$ + "\" + x$
                     Else
                        TempFiles(VarZ) = N$ + "\" + D$ + x$
                     End If
                  End If
               Else
                  Exit Do
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If

   ' load filename array.
   For VarZ = 1 To MaxFiles
      If RTrim$(TempFiles(VarZ)) <> "" Then
         ' check max files.
         If NumberFiles = MaxFiles Then
            Return
         End If
         Filename = RTrim$(TempFiles(VarZ))
         GoSub LoadNewFile
      End If
   Next
Else
   ' load single file.
   GoSub LoadNewFile
End If
Return

' loads filename.
LoadNewFile:
' check max files.
If NumberFiles = MaxFiles Then
   Return
End If

' store filename.
ASCIIZ = Filename + Chr$(0)

' open/create file.
GoSub OpenFile

' check open error.
If ValidFile Then

   ' get netpath
   GoSub ParseNetPath

   ' conanicalize filename.
   GoSub ShortFilename

   ' get length of file.
   Call GetFileLength(Handle)

   ' get exclusion list.
   GoSub CheckFile

   ' check excluded file.
   If VarP Then
      ' display open error dialog box.
      x = MessageBox(" Open Error ", "File " + Filename + "|is in exclusion list.")

      ' close handle.
      GoSub CloseFile

      ' restore current file.
      GoSub RestoreCurrentFile
      Return
   End If

   ' initialize new file.
   GoSub InitFile

   ' init paste files.
   Call InitPasteFiles(VarQ)

   ' check bad paste filename.
   If VarQ Then
      GoTo Error.Exit
   End If
End If
Return

' initialize new file.
InitFile:
NumberFiles = NumberFiles + 1
CurrentFile = NumberFiles
Call MultiFileFunction(1)
GoSub RestoreCurrentFile
Return

' check file exclusion list.
CheckFile:
VarP = False
Filename2$ = ExcludeFile
Var = InStr(Filename2$, "?")
If Var Then
   Mid$(Filename2$, Var, 1) = Mid$(Str$(Process.Number), 2)
End If
ASCIIZ3 = ASCIIZ
ASCIIZ = Filename2$ + Chr$(0)
Call GetShortFilename(Short.Filename$)
ASCIIZ = ASCIIZ3
Filename2$ = Short.Filename$
If _FileExists(Filename2$) Then
   Check.Disk = True
   Disk.Ready = False
   x3 = FreeFile
   Open Filename2$ For Input As #x3
   Check.Disk = False
   If Disk.Ready Then
      Return
   End If
   Y2$ = Filename
   Y2$ = UCase$(Y2$)
   For Y = Len(Y2$) To 1 Step -1
      If Mid$(Y2$, Y, 1) = "\" Then
         Y2$ = Mid$(Y2$, Y + 1)
         Exit For
      End If
   Next
   Do Until EOF(x3)
      Line Input #x3, Y1$
      Y1$ = LTrim$(Y1$)
      Y1$ = RTrim$(Y1$)
      Y1$ = UCase$(Y1$)
      If Left$(Y1$, 1) = Quote Then
         Y1$ = Mid$(Y1$, 2)
         If Right$(Y1$, 1) = Quote Then
            Y1$ = Left$(Y1$, Len(Y1$) - 1)
         End If
      End If
      Y1$ = LTrim$(Y1$)
      Y1$ = RTrim$(Y1$)
      If Len(Y1$) Then
         If InStr(Y1$, " ") = False Then
            ' check excluded file in filename.
            Call CheckExcluded(Y1$, Y2$, Exclude.File)
            If Exclude.File Then
               VarP = True
               Exit Do
            End If
         End If
      End If
   Loop
End If
Close #x3
Return

' search specific file name.
'   allows ? and * characters.
SearchFile2:
Call ClearStatus
Printf "Enter filename?"
Var1$ = LineInput$(2, 20, 10)
If Len(Var1$) Then
   For NextFile = CurrentFile + 1 To NumberFiles
      Var2$ = RTrim$(File(NextFile).Filename)
      If Len(Var2$) Then
         Call InstrSUB(VarX, Var2$, Var1$)
         If VarX Then
            GoTo SearchFile3
         End If
      End If
   Next
   For NextFile = 1 To CurrentFile
      Var2$ = RTrim$(File(NextFile).Filename)
      If Len(Var2$) Then
         Call InstrSUB(VarX, Var2$, Var1$)
         If VarX Then
            GoTo SearchFile3
         End If
      End If
   Next
End If
StatusMessage = "File not found."
Call DisplayStatus2
Return

' select specific file number.
SearchFile3:
If NextFile <= NumberFiles Then
   Call MultiFileFunction(2)
   CurrentFile = NextFile
   GoSub RestoreCurrentFile
   GoSub RedrawScreen2
End If
Return

' goto next file.
GotoNextFile:
If NumberFiles = 1 Then
   Return
End If
Call MultiFileFunction(2)
CurrentFile = CurrentFile + 1
If CurrentFile > NumberFiles Then
   CurrentFile = 1
End If
GoSub RestoreCurrentFile
GoSub RedrawScreen2
Return

' goto previous file.
GotoPreviousFile:
If NumberFiles = 1 Then
   Return
End If
Call MultiFileFunction(2)
CurrentFile = CurrentFile - 1
If CurrentFile = False Then
   CurrentFile = NumberFiles
End If
GoSub RestoreCurrentFile
GoSub RedrawScreen2
Return

' goto first file.
GotoFirstFile:
If CurrentFile = 1 Then
   Return
End If
Call MultiFileFunction(2)
CurrentFile = 1
GoSub RestoreCurrentFile
GoSub RedrawScreen2
Return

' goto last file.
GotoLastFile:
If CurrentFile = NumberFiles Then
   Return
End If
Call MultiFileFunction(2)
CurrentFile = NumberFiles
GoSub RestoreCurrentFile
GoSub RedrawScreen2
Return

' close current file.
CloseCurrentFile:
GoSub CloseFile
GoSub PackFileArray
Return

' pack file arrays and structures.
PackFileArray:
' pack file array.
For Var = CurrentFile To MaxFiles - 1
   File(Var) = File(Var + 1)
Next

' pack paste files.
Call Pack.Files1

' pack undo file.
Call Pack.Arrays1

' pack marker file.
Call Pack.Arrays2

' reduce files by one.
NumberFiles = NumberFiles - 1

' check remaining files.
If NumberFiles > False Then
   ' reset current file.
   If CurrentFile > NumberFiles Then
      CurrentFile = NumberFiles
   End If

   ' restore current file.
   GoSub RestoreCurrentFile
   GoSub RedrawScreen2
End If
Return

' prepare for new file.
NewFile:
' reset window.
Cls
Locatef 1, 1, 1
Printf "Loading.."
CurrentWindow = False
CurrentWindow2 = False
ScreenDrawn = False
Locatef 24, 1, 1
Colorf Plain
Return

' restore current file variables.
RestoreCurrentFile:
If NumberFiles = 0 Then
   Return
End If
Call MultiFileFunction(3)
Call OpenPasteFiles(VarQ)
If VarQ Then
   GoTo Error.Exit
End If
Call DisplayScreen
If FileDisplay = False Then
   Call DisplayFileTitle
   _Title "HEXEDIT - " + File(CurrentFile).Filename
Else
   GoSub DisplayScreen3
End If
Return

' display command line instructions.
BootUsage:
Call DisplayBootUsage
Colorf Plain
GoTo StopProgram

' display ANSI charts.
ANSIChart:
Call DisplayChart(1)
GoTo EndChart

' display HEX charts.
HEXChart:
Call DisplayChart(2)
GoTo EndChart

' display HEX calculator.
HEXCalculator:
Call HexCalc

EndChart:
Call MultiFileFunction(2)
GoSub RedrawScreen0
Return

' toggles state of search string storage variable.
ToggleSearch:
StoreSearchMulti = Not StoreSearchMulti
Call DisplayX
Colorf White
If StoreSearchMulti Then
   Printf "Store search string on."
Else
   Printf "Store search string off."
End If
Call LocateCursor2
Return

' toggles state of debug variable.
ToggleDebug:
Debug = Not Debug
Call DisplayX
Colorf White
If Debug Then
   Printf "Debug on."
Else
   Printf "Debug off."
End If
Call LocateCursor2
Return

' toggles state of debug2 variable.
ToggleDebug2:
Debug2 = Not Debug2
Call DisplayX
Colorf White
If Debug2 Then
   Printf "Debug2 on."
Else
   Printf "Debug2 off."
End If
Call LocateCursor2
Return

' toggles state of debug3 variable.
ToggleDebug3:
Debug3 = Not Debug3
Call DisplayX
Colorf White
If Debug3 Then
   Printf "Debug3 on."
Else
   Printf "Debug3 off."
End If
Call LocateCursor2
Return

' function for unknown ascii key.
HelpLine2:
Call DisplayX
Colorf White
If Debug Then
   Printf Mid$(Str$(Asc(CharInput$)), 2) + ": "
End If
GoTo HelpLineX

' function for unknown scan key.
HelpLine3:
Call DisplayX
Colorf White
If Debug Then
   Printf Mid$(Str$(Asc(Right$(CharInput$, 1))), 2) + ": "
End If
GoTo HelpLineX

' function for unknown key.
HelpLine:
Call DisplayX
Colorf White
HelpLineX:
Printf "Type Alt-Q for Help, Alt-O to print Help."
Call LocateCursor2
Return

' displays help screens.
DisplayHelp:
Call MultiFileFunction(2)
Call HelpScreen
GoSub RedrawScreen0
Return

' function for ? key.
DisplayInfo:
Call DisplayX
Colorf White
If FileLength = False Then
   Call LockedFile
   Return
End If
Attr$ = Nul
If (FileAttribute And 1) = 1 Then
   Attr$ = Attr$ + "o"
End If
If (FileAttribute And 2) = 2 Then
   Attr$ = Attr$ + "h"
End If
If (FileAttribute And 4) = 4 Then
   Attr$ = Attr$ + "s"
End If
If (FileAttribute And 32) = 32 Then
   Attr$ = Attr$ + "a"
End If
If Len(Attr$) Then
   Printf "(" + Attr$ + ") "
End If
If CurrentWindow2 = False Then
   Printf "(Length: " + FormatX$(FileLength, 1) + ") "
Else
   Printf "(Length: " + Right$("000000000000" + Hex$(FileLength - 1), 12) + "x) "
End If
Call LocateCursor2
Return

' function for space key.
DisplayAuthor:
Call DisplayX
Colorf White
Printf "Author: " + Author$ + " Type Alt-Q for help."
Call LocateCursor2
Return

' function for ! key.
DisplayData1:
Call DisplayX
Colorf White
If FileLength = False Then
   Call LockedFile
   Return
End If
TempPosition3 = FilePosition
Call FormatPosition1
Call LocateCursor2
Return

' function for Alt-- key.
DisplayData2:
Call DisplayX
Colorf White
Printf clock$
Call LocateCursor2
Return

' function for Alt-= key.
DisplayData3:
Call DisplayX
Colorf White
Printf "Loaded Files:" + Str$(NumberFiles) + " "
Printf "Last Drive: " + Chr$(Last.Drive + 64) + ":"
Call LocateCursor2
Return

' function for Ctrl-Alt-x key.
DisplayData4:
Call DisplayX
Colorf White
Printf "Ctrl-Alt-Key" + Str$(Asc(Right$(CharInput$, 1)))
Call LocateCursor2
Return

' function for ~ key.
DisplayLengths:
Call DisplayX
Colorf White
If FileLength = False Then
   Call LockedFile
   Return
End If
FilePage2 = Int((FileLength - 1) / 320) + 1
If CurrentWindow2 = False Then
   Printf "(Last page: " + FormatX$(CDbl(FilePage2 - 1), 1) + ") "
Else
   Printf "(Last page: " + Right$("00000000" + Hex$(FilePage2 - 1), 8) + "x) "
End If
' count markers
Var1! = SFalse
For Var2! = 1! To MarkerCount
   If Markers#(Var2!) > 0# Then
      Var1! = Var1! + 1!
   End If
Next
Printf "(Markers: " + FormatX$(CDbl(Var1!), 1) + ")"
Call LocateCursor2
Return

' function for ; key.
DisplayCopy:
Call DisplayX
Colorf White
If FileLength = False Then
   Call LockedFile
   Return
End If
If CurrentWindow2 = False Then
   Printf "(Copy position: "
   Printf FormatX$(CDbl(CopyPositionStart), 1) + " - "
   Printf FormatX$(CDbl(CopyPositionEnd), 1) + ") "
Else
   Printf "(CopyPosition: "
   If CopyPositionStart = False And CopyPositionEnd = False Then
      Printf "00000000H - 00000000H) "
   Else
      Printf Right$("00000000" + Hex$(CopyPositionStart - 1), 8) + "x - "
      Printf Right$("00000000" + Hex$(CopyPositionEnd - 1), 8) + "x) "
   End If
End If
Call LocateCursor2
Return

' { = display paste undos.
DisplayPasteUndos:
Call DisplayX
Colorf White
If FileLength = False Then
   Call LockedFile
   Return
End If
ByteEntries = 0%
If LOF(5) > 0 Then
   Get #5, 1, CopyByte
   ByteEntries = Asc(CopyByte) * 16 ^ 2
   Get #5, 2, CopyByte
   ByteEntries = ByteEntries + Asc(CopyByte)
End If
Printf FormatX$(CDbl(ByteEntries), 1) + " "
If ByteEntries = 1% Then
   Printf "paste undo stored."
Else
   Printf "paste undos stored."
End If
Call LocateCursor2
Return

' " = display path of file being edited.
DisplayPath:
Call ClearStatus
N$ = RTrim$(CurrentNetPath)
Z$ = RTrim$(ShortFilename)
If N$ <> Nul Then
   If Mid$(Z$, 2, 1) = ":" Then
      Z$ = Mid$(Z$, 3)
   End If
End If
Call Deconcatenate(N$, Z$, 64)
Var = Len(Z$)
Do
   Var = Var - 1
   If Var = False Then
      Z$ = Nul
      Exit Do
   End If
   If Mid$(Z$, Var, 1) = "\" Then
      Z$ = Left$(Z$, Var)
      Exit Do
   End If
Loop
If Z$ = Nul Then
   Z$ = "\"
End If
Printf "Editing path: " + Z$ + " "
FileDisplay2 = True
Call LocateCursor2
Return

' redraw editing screen
RedrawScreen0:
ScreenDrawn = True
GoSub RestoreCurrentFile
GoTo RedrawScreen2

RedrawScreen1:
ScreenDrawn = True
Call DisplayScreen

RedrawScreen2:
Call DisplayFilename
Call DisplayHexPage
Call DisplayPageByte
If FileDisplay = False Then
   Call DisplayFileTitle
Else
   GoSub DisplayScreen3
End If
Call RestoreHilightBytes
Return

' display filename border area.
DisplayScreen3:
Call DisplayScreen3X
Call LocateCursor2
Return

' search file for ascii string.
SearchASCII:
Call SearchFile(0, FoundString)
GoTo FinishSearch

' search file for hex string.
SearchBytes:
Call SearchFile(1, FoundString)
GoTo FinishSearch

' continue previous search.
ContinueSearch:
If RTrim$(StoreSearchString) = Nul Then
   StatusMessage = "No search string specified."
   Call DisplayStatus2
   Return
End If
Call SearchFile(2, FoundString)

' display search results.
FinishSearch:
' check byte comparison.
If FoundString = True Then
   FilePosition = SearchBytePosition
   Call CalculatePosition1
   If LastPage <> FilePage Then
      Call DisplayHexPage
   End If
End If
Call DisplayPageByte
If FoundString = False Then
   StatusMessage = "String not found."
   Call DisplayStatus2
   Return
End If
Call DisplayFilename
Return

' dump screen of current page of hex/ascii values to file.
DumpScreen:
' open dumpfile.
GoSub OpenDumpFile
If ValidFile = False Then
   Return
End If
' write screen.
Call DumpSub(1, x2)
Var = 1
GoSub DumpIt
Return

' dump file of current hex/ascii values to file.
DumpHEXFile:
' open dumpfile.
GoSub OpenDumpFile
If ValidFile = False Then
   Return
End If
' write file.
Call DumpSub(2, x2)
Var = 3
If FileDumped Then
   Var = 2
End If
GoSub DumpIt
Return

' display dump info.
DumpIt:
' redisplay page.
Call DisplayPageByte
' conanicalize filename.
Filename2$ = Conanicalize$(DumpFile)
Var2 = InStr(Filename2$, "?")
If Var2 Then
   Mid$(Filename2$, Var2, 1) = Mid$(Str$(Process.Number), 2)
End If
' display filename.
Select Case Var
   Case 1
      StatusMessage = "Screen dumped to: " + Quote + Filename2$ + Quote + "."
   Case 2
      StatusMessage = "File dumped to: " + Quote + Filename2$ + Quote + "."
   Case 3
      StatusMessage = "Partial file dumped to: " + Quote + Filename2$ + Quote + "."
End Select
Call DisplayStatus1
Return

' open dumpfile.
OpenDumpFile:
Column = False
ColumnSpace = False
HexLine$ = Nul
HexLine2$ = Nul

x2 = FreeFile
ErrorTrap = False
ValidFile = True

' store filename.
Filename2$ = DumpFile
Var = InStr(Filename2$, "?")
If Var Then
   Mid$(Filename2$, Var, 1) = Mid$(Str$(Process.Number), 2)
End If

' open filename for append.
Open Filename2$ For Append As #x2
If ErrorTrap Then
   Call MultiFileFunction(2)
   GoSub RedrawScreen0
   ValidFile = False
End If
Return

' print screen of current page of hex/ascii values to printer.
PrintScreen:

' start print.
Call PrintSub(1)
Call DisplayPageByte
StatusMessage = "Screen dumped to printer."
Call DisplayStatus1
Return

' print file of current hex/ascii values to printer.
PrintFile:

' start print.
Call PrintSub(2)
Call DisplayPageByte
If FileDumped Then
   StatusMessage = "File dumped to printer."
Else
   StatusMessage = "Partial file dumped to printer."
End If
Call DisplayStatus1
Return

' print help screens.
PrintHelp:

' start print.
Call PrintSub(3)
Call DisplayFilename
Return

' add multiple specified byte to file and locate there.
AppendAnyByte:
Call ClearStatus
Printf "Enter number of bytes?"
ByteString$ = LineInput$(2, 27, 10)
If Len(ByteString$) = False Then
   StatusMessage = "Invalid append bytes."
   Call DisplayStatus2
   Return
End If
If UCase$(Left$(ByteString$, 1)) = "H" Then
   Call CheckHexValue(ByteString$)
   If ValidHexValue = False Then
      Return
   End If
   NumBytes2# = HexValue - 1#
Else
   Call CheckASCIIValue(ByteString$)
   If ValidASCIIValue = False Then
      Return
   End If
   NumBytes2# = ASCIIValue3
End If
Call ClearStatus
ValidByteString = False
Printf "Enter hex byte?"
ByteString$ = LineInput$(2, 20, 2)
If Len(ByteString$) = 2 Then
   AllowWildCard = False
   Call CheckHexBytes(ByteString$)
   If ValidByteString Then
      Byte2 = Val("&H" + ByteString$)
   End If
End If
If ValidByteString = False Then
   StatusMessage = "Invalid append hex value."
   Call DisplayStatus2
   Return
End If
Call DisplayX
Colorf White
Printf " Appending specified bytes to file:"
CursorLocation = 53 + Len(RTrim$(Filename))
GoTo AppendBytes2

' add multiple null bytes to file and locate there.
AppendNullBytes:
Call ClearStatus
Printf "Enter number of bytes?"
ByteString$ = LineInput$(2, 27, 10)
If Len(ByteString$) = False Then
   StatusMessage = "Invalid append bytes."
   Call DisplayStatus2
   Return
End If
If UCase$(Left$(ByteString$, 1)) = "H" Then
   Call CheckHexValue(ByteString$)
   If ValidHexValue = False Then
      Return
   End If
   NumBytes2# = HexValue - 1#
Else
   Call CheckASCIIValue(ByteString$)
   If ValidASCIIValue = False Then
      Return
   End If
   NumBytes2# = ASCIIValue3
End If
Byte2 = False
Call DisplayX
Colorf White
Printf " Appending null bytes to file:"
CursorLocation = 48 + Len(RTrim$(Filename))

' append bytes past end of file.
AppendBytes2:
LastPage = FilePage
Call ClearPageByte
PercentDisplayed! = SFalse
Locatef 2, CursorLocation, 0
Printf " 0%"
BlockBytes# = Int(NumBytes2# / 32767#)
RemainingBytes# = NumBytes2# Mod 32767#
' write 32767 byte blocks.
If BlockBytes# > 0# Then
   BlockByte = String$(32767, Chr$(Byte2))
   For Byte1# = 1# To BlockBytes#
      If INKEYx$ = Chr$(27) Then
         GoTo EndAppend
      End If
      SeekPosition = FileLength + 1#
      FileLength = FileLength + 32767#
      Call LseekFile
      GoSub WriteBlockFile
      If Write.Error Then
         Call GetFileLength(Handle)
         SeekPosition = FileLength
         Call LseekFile
         GoTo EndAppend
      End If
      FilePosition = FileLength
      Call CalculatePosition1
      PercentCopied! = Int(CSng(Byte1# / BlockBytes#) * 100!)
      If PercentCopied! > PercentDisplayed! Then
         Locatef 2, CursorLocation, 0
         Printf Str$(PercentCopied!) + "%"
         PercentDisplayed! = PercentCopied!
      End If
   Next
End If
' write remaining bytes.
PercentDisplayed! = SFalse
Locatef 2, CursorLocation, 0
Printf " 0%  "
If RemainingBytes# > 0# Then
   FileByte = Chr$(Byte2)
   For Byte1# = 1# To RemainingBytes#
      FileLength = FileLength + 1#
      SeekPosition = FileLength
      Call LseekFile
      Call WriteFile
      If Write.Error Then
         Call GetFileLength(Handle)
         SeekPosition = FileLength
         Call LseekFile
         GoTo EndAppend
      End If
      FilePosition = FileLength
      Call CalculatePosition1
      If LastPage = FilePage Then
         Call ClearPageByte
      End If
      PercentCopied! = Int(CSng(Byte1# / RemainingBytes#) * 100!)
      If PercentCopied! > PercentDisplayed! Then
         Locatef 2, CursorLocation, 0
         Printf Str$(PercentCopied!) + "%"
         PercentDisplayed! = PercentCopied!
      End If
   Next
End If
EndAppend:
Call CalculatePosition1
If LastPage <> FilePage Then
   LastPage = FilePage
   Call DisplayHexPage
End If
Call DisplayPageByte
Call DisplayFilename
Return

' add multiple bytes of an ASCII string to file and locate there.
AppendASCII:
Call ClearStatus
Printf "Enter ASCII string?"
ByteString$ = LineInput$(2, 24, 53)
If Len(ByteString$) = False Then
   StatusMessage = "Invalid append string."
   Call DisplayStatus2
   Return
End If
NumBytes = Len(ByteString$)
Call AsciiToHex2(ByteString$)
GoTo StartAppend

' add multiple bytes to file and locate there.
'   left window specifies space-separated hex byte pairs,
'   right window specifies space-separated 3-byte ascii pairs.
AppendByte:
Call ClearStatus
If CurrentWindow = False Then
   Printf "Enter hex byte(s)?"
   ByteString$ = LineInput$(2, 23, 55)
   If Left$(ByteString$, 1) = "+" Then
      ByteString$ = Mid$(ByteString$, 2)
      Call CheckAsciiBytes(ByteString$)
   Else
      AllowWildCard = False
      Call CheckHexBytes(ByteString$)
   End If
Else
   Printf "Enter ascii byte(s)?"
   ByteString$ = LineInput$(2, 25, 53)
   If UCase$(Left$(ByteString$, 1)) = "H" Then
      ByteString$ = Mid$(ByteString$, 2)
      AllowWildCard = False
      Call CheckHexBytes(ByteString$)
   Else
      Call CheckAsciiBytes(ByteString$)
   End If
End If
If ValidByteString = False Then
   StatusMessage = "Invalid append string."
   Call DisplayStatus2
   Return
End If

' append the byte string.
StartAppend:
LastPage = FilePage
For Byte1 = 1 To NumBytes
   Call ClearPageByte
   Byte$ = Mid$(ByteString$, (Byte1 - 1) * 2 + 1, 2)
   Byte2 = Val("&H" + Byte$)
   GoSub AppendIt
   If ValidAppend = False Then
      Exit For
   End If
Next
Call DisplayFilename
Return

' appends a byte to file.
AppendIt:
ValidAppend = False
FileByte = Chr$(Byte2)
FileLength = FileLength + 1#
SeekPosition = FileLength
Call LseekFile
Call WriteFile
If Write.Error Then
   Call GetFileLength(Handle)
   SeekPosition = FileLength
   Call LseekFile
   Call DisplayPageByte
   Return
End If
ValidAppend = True
FilePosition = FileLength
Call CalculatePosition1
If LastPage <> FilePage Then
   LastPage = FilePage
   Call DisplayHexPage
End If
Call DisplayPageByte
Return

' jump to page position in file.
JumpPage:
Call ClearStatus
Printf "Enter page position?"
ByteString$ = LineInput$(2, 25, 10)
If UCase$(Left$(ByteString$, 1)) = "H" Then
   Call CheckHexValue(ByteString$)
   If ValidHexValue = False Then
      Return
   End If
   NextPage = HexValue
Else
   Call CheckASCIIValue(ByteString$)
   If ValidASCIIValue = False Then
      Return
   End If
   NextPage = ASCIIValue3
End If
' check the new page is there to jump to.
TempPosition3 = (NextPage - 1) * 320 + 1
If TempPosition3 >= 1 And TempPosition3 <= FileLength Then
   Call ClearPageByte
   LastPage = FilePage
   ' preserve current row, column.
   FilePosition = TempPosition3
   TempPosition2 = FilePosition + (PageRow - 1) * 20 + PageColumn - 1
   If TempPosition2 <= FileLength Then
      FilePosition = TempPosition2
   Else
      FilePosition = FileLength
   End If
   Call CalculatePosition1
   If LastPage <> FilePage Then
      Call DisplayHexPage
   End If
   Call DisplayPageByte
   Call DisplayFilename
   Return
End If
StatusMessage = "Invalid page."
Call DisplayStatus2
Return

' jump to a byte position in file.
JumpByte:
Call ClearStatus
Printf "Enter file position?"
ByteString$ = LineInput$(2, 25, 10)
If UCase$(Left$(ByteString$, 1)) = "H" Then
   Call CheckHexValue(ByteString$)
   If ValidHexValue = False Then
      Return
   End If
   NewByte = HexValue
Else
   Call CheckASCIIValue(ByteString$)
   If ValidASCIIValue = False Then
      Return
   End If
   NewByte = ASCIIValue3
End If
If NewByte >= 1 And NewByte <= FileLength Then
   If NewByte <> FilePosition Then
      Call ClearPageByte
      LastPage = FilePage
      FilePosition = NewByte
      Call CalculatePosition1
      If LastPage <> FilePage Then
         Call DisplayHexPage
      End If
      Call DisplayPageByte
   End If
   Call DisplayFilename
   Return
End If
StatusMessage = "Invalid byte."
Call DisplayStatus2
Return

' undo a byte from stored arrays of previous position/byte value.
UndoByte:
If CurrentUndo = 0! Then
   StatusMessage = "No bytes to restore."
   Call DisplayStatus2
   Return
End If
If CurrentUndo > 0! Then
   NextUndo! = CurrentUndo
   GoSub UndoIt
End If
Return

' undo all bytes from stored arrays of previous position/byte value.
UndoAll:
If CurrentUndo = 0! Then
   StatusMessage = "No bytes to restore."
   Call DisplayStatus2
   Return
End If
If CurrentUndo > 0! Then
   TotalUndos! = CurrentUndo
   For NextUndo! = TotalUndos! To 1! Step -1
      GoSub UndoIt
   Next
End If
Return

' Undo one byte.
UndoIt:
Call ClearPageByte
LastPage = FilePage
FileByte = Chr$(UndoByte%(NextUndo!))
FilePosition = UndoPosition#(NextUndo!)
CurrentUndo = CurrentUndo - 1!
SeekPosition = FilePosition
Call LseekFile
Call WriteFile
Call CalculatePosition1
If LastPage <> FilePage Then
   LastPage = FilePage
   Call DisplayHexPage
End If
Call DisplayPageByte
Return

Rem Cursor key routines:

' move cursor up.
CursorUp:
If PageRow - 1 >= 1 Then
   Call ClearPageByte
   PageRow = PageRow - 1
   FilePosition = FilePosition - 20
   Call DisplayPageByte
   Return
End If
Call ClearPageByte
Call DisplayPageByte
Return

' move cursor down.
CursorDown:
If PageRow + 1 <= 16 Then
   If FilePosition + 20 <= FileLength Then
      Call ClearPageByte
      PageRow = PageRow + 1
      FilePosition = FilePosition + 20
      If FilePosition > FileLength Then
         PageColumn = PageColumn - 1
         FilePosition = FilePosition - 1
      End If
      Call DisplayPageByte
      Return
   End If
End If
Call ClearPageByte
Call DisplayPageByte
Return

' move cursor left.
CursorLeft:
If PageColumn - 1 >= 1 Then
   If CopyPositionStart > False Then
      If PageColumn = 20 Then
         Call ClearPageByte
         Call DisplayPageByte
         Return
      End If
      If FilePosition = FileLength Then
         Call ClearPageByte
         Call DisplayPageByte
         Return
      End If
   End If
   Call ClearPageByte
   PageColumn = PageColumn - 1
   FilePosition = FilePosition - 1
   Call DisplayPageByte
Else
   Call ClearPageByte
   If PageColumn > 1 Then
      PageColumn = 1
      FilePosition = FilePosition - 1
   End If
   Call DisplayPageByte
End If
Return

' move cursor right.
CursorRight:
If PageColumn + 1 <= 20 Then
   If FilePosition + 1 <= FileLength Then
      Call ClearPageByte
      If PageColumn < 20 Then
         If FilePosition + 1 <= FileLength Then
            PageColumn = PageColumn + 1
            FilePosition = FilePosition + 1
         End If
      End If
      Call DisplayPageByte
      Return
   End If
End If
Call ClearPageByte
Call DisplayPageByte
Return

' end key.
EndKey:
' set to column 20
If PageColumn < 20 Then
   ' check column 20 is positioned before end of file
   If FilePosition - PageColumn + 20 <= FileLength Then
      Call ClearPageByte
      FilePosition = FilePosition - PageColumn + 20
      PageColumn = 20
      Call DisplayPageByte
   Else
      ' position end of file
      Call ClearPageByte
      FilePosition = FileLength
      Call CalculatePosition1
      Call DisplayPageByte
   End If
Else
   Call ClearPageByte
   Call DisplayPageByte
   Call LocateCursor
End If
Return

' home key.
HomeKey:
If PageColumn > 1 Then
   Call ClearPageByte
   FilePosition = FilePosition - PageColumn + 1
   PageColumn = 1
   Call DisplayPageByte
Else
   Call ClearPageByte
   If PageColumn > 1 Then
      PageColumn = 1
      FilePosition = FilePosition - 1
   End If
   Call DisplayPageByte
   Call LocateCursor
End If
Return

' control-left key.
CtrlLeftKey:
NewColumn = False
Select Case PageColumn
   Case 2, 3, 4
      NewColumn = 1
   Case 5
      NewColumn = 4
   Case 6, 7, 8
      NewColumn = 5
   Case 9
      NewColumn = 8
   Case 10, 11, 12
      NewColumn = 9
   Case 13
      NewColumn = 12
   Case 14, 15, 16
      NewColumn = 13
   Case 17
      NewColumn = 16
   Case 18, 19, 20
      NewColumn = 17
End Select
If NewColumn > False Then
   Call ClearPageByte
   FilePosition = FilePosition - PageColumn + NewColumn
   PageColumn = NewColumn
   Call DisplayPageByte
End If
Return

' control-right key.
CtrlRightKey:
NewColumn = False
Select Case PageColumn
   Case 1, 2, 3
      NewColumn = 4
   Case 4
      NewColumn = 5
   Case 5, 6, 7
      NewColumn = 8
   Case 8
      NewColumn = 9
   Case 9, 10, 11
      NewColumn = 12
   Case 12
      NewColumn = 13
   Case 13, 14, 15
      NewColumn = 16
   Case 16
      NewColumn = 17
   Case 17, 18, 19
      NewColumn = 20
End Select
If NewColumn Then
   ' check new column is positioned before end of file
   If FilePosition - PageColumn + NewColumn <= FileLength Then
      Call ClearPageByte
      FilePosition = FilePosition - PageColumn + NewColumn
      PageColumn = NewColumn
      Call DisplayPageByte
   Else
      ' position end of file
      Call ClearPageByte
      FilePosition = FileLength
      Call CalculatePosition1
      Call DisplayPageByte
   End If
End If
Return

' control-end key.
CtrlEndKey:
If FilePosition <> FileLength Then
   LastPage = FilePage
   Call ClearPageByte
   FilePosition = FileLength
   Call CalculatePosition1
   If LastPage <> FilePage Then
      Call DisplayHexPage
   End If
   Call DisplayPageByte
Else
   Call ClearPageByte
   Call DisplayPageByte
   Call LocateCursor
End If
Return

' control-home key.
CtrlHomeKey:
If FilePosition <> 1 Then
   LastPage = FilePage
   Call ClearPageByte
   FilePosition = 1
   Call CalculatePosition1
   If LastPage <> FilePage Then
      Call DisplayHexPage
   End If
   Call DisplayPageByte
End If
Return

' move one page up.
PageUp:
' check there is a page to move up.
If FilePosition - 320 >= 1 Then
   FilePage = FilePage - 1
   FilePosition = FilePosition - 320
   Call DisplayHexPage
   Call DisplayPageByte
Else
   ' check there is a first position on the first page to move up to.
   If FilePosition > 1 Then
      Call ClearPageByte
      PageRow = 1
      PageColumn = 1
      FilePosition = 1
      Call DisplayPageByte
   Else
      Call ClearPageByte
      Call DisplayPageByte
      Call LocateCursor
   End If
End If
Return

' move one page down.
PageDown:
' check there is a page to move down.
If FilePosition + 320 <= FileLength Then
   FilePage = FilePage + 1
   FilePosition = FilePosition + 320
   Call DisplayHexPage
   Call DisplayPageByte
Else
   ' check there is a last position on the last page to move down to.
   If FilePosition < FileLength Then
      Call ClearPageByte
      FilePosition = FileLength
      Call CalculatePosition1
      Call DisplayHexPage
      Call DisplayPageByte
   Else
      Call ClearPageByte
      Call DisplayPageByte
      Call LocateCursor
   End If
End If
Return

Rem More routines:

' switch editing windows.
TabWindow:
If CurrentWindow2 = False Then
   CurrentWindow = Not CurrentWindow
   Call DisplayPosition
   Call LocateCursor2
End If
Return

' switch right editing window.
ToggleRight:
CurrentWindow = False
CurrentWindow2 = Not CurrentWindow2
Call RedrawRightWindow
Call DisplayPageByte
Return

' change the byte value at the current position.
'   change by hex value in left window,
'   by ascii value in right window.
'   overrides with +255 in left window,
'   and with hff in right window.
ChangeHexValue:
Call ClearStatus
FileByte = Nul
ValidByteString = False
If CurrentWindow = False Then
   Printf "Enter hex byte value?"
   ByteString$ = LineInput$(2, 26, 4)
   If Left$(ByteString$, 1) = "+" Then
      ByteString$ = Mid$(ByteString$, 2)
      If Len(ByteString$) = 3 Then
         NewValue = Int(Val(ByteString$))
         If NewValue >= False And NewValue <= 255 Then
            ValidByteString = True
            FileByte = Chr$(NewValue)
         End If
      End If
   Else
      If Len(ByteString$) = 2 Then
         AllowWildCard = False
         Call CheckHexBytes(ByteString$)
         If ValidByteString Then
            NewValue = Val("&H" + ByteString$)
            FileByte = Chr$(NewValue)
         End If
      End If
   End If
Else
   Printf "Enter ascii byte value?"
   ByteString$ = LineInput$(2, 28, 4)
   If UCase$(Left$(ByteString$, 1)) = "H" Then
      ByteString$ = Mid$(ByteString$, 2)
      If Len(ByteString$) = 2 Then
         AllowWildCard = False
         Call CheckHexBytes(ByteString$)
         If ValidByteString Then
            NewValue = Val("&H" + ByteString$)
            FileByte = Chr$(NewValue)
         End If
      End If
   Else
      If Len(ByteString$) = 3 Then
         NewValue = Int(Val(ByteString$))
         If NewValue >= False And NewValue <= 255 Then
            ValidByteString = True
            FileByte = Chr$(NewValue)
         End If
      End If
   End If
End If
If ValidByteString = False Then
   StatusMessage = "Invalid byte."
   Call DisplayStatus2
   Return
End If
GoSub StoreUndo
SeekPosition = FilePosition
Call LseekFile
Call WriteFile
Call DisplayPageByte
Call DisplayFilename
Return

' change the ascii values with string starting at the current position.
ChangeASCIIValues:
Call ClearStatus
Printf "Enter ascii value(s)?"
ByteString$ = LineInput$(2, 26, 52)
If Len(ByteString$) = False Then
   StatusMessage = "Invalid ascii string."
   Call DisplayStatus2
   Return
End If
' init file.
If FileLength = 0 Then
   Byte2 = 0
   GoSub AppendIt
   If ValidAppend = False Then
      Return
   End If
Else
   ' store all current values.
   StorePosition = FilePosition
   For NumberBytes = 1 To Len(ByteString$)
      SeekPosition = FilePosition
      Call LseekFile
      Call ReadFile
      FileByte = Buffer
      AsciiValue = Asc(FileByte)
      GoSub StoreUndo
      If FilePosition = FileLength Then
         Exit For
      End If
      FilePosition = FilePosition + 1
   Next
   FilePosition = StorePosition
End If
' write ascii string.
ValidAppend = True
For NumberBytes = 1 To Len(ByteString$)
   If FilePosition > FileLength Then
      Byte2 = 0
      GoSub AppendIt
      If ValidAppend = False Then
         Exit For
      End If
   End If
   FileByte = Mid$(ByteString$, NumberBytes, 1)
   SeekPosition = FilePosition
   Call LseekFile
   Call WriteFile
   Call CalculatePosition1
   If LastPage <> FilePage Then
      LastPage = FilePage
      Call DisplayHexPage
   End If
   Call ClearPageByte
   FilePosition = FilePosition + 1
Next
If ValidAppend Then
   FilePosition = FilePosition - 1
End If
Call DisplayPageByte
Call DisplayFilename
Return

' change the hex values with string starting at the current position.
ChangeHEXValues:
Call ClearStatus
Printf "Enter HEX value(s)?"
ByteString$ = LineInput$(2, 24, 54)
If Len(ByteString$) = False Then
   StatusMessage = "Invalid hex string."
   Call DisplayStatus2
   Return
End If
' check hex string.
AllowWildCard = False
Call CheckHexBytes(ByteString$)
If ValidByteString = False Then
   StatusMessage = "Invalid hex string."
   Call DisplayStatus2
   Return
End If
' init file.
If FileLength = 0 Then
   Byte2 = 0
   GoSub AppendIt
   If ValidAppend = False Then
      Return
   End If
Else
   ' store all current values.
   StorePosition = FilePosition
   For NumberBytes = 1 To Len(ByteString$) Step 2
      SeekPosition = FilePosition
      Call LseekFile
      Call ReadFile
      FileByte = Buffer
      AsciiValue = Asc(FileByte)
      GoSub StoreUndo
      If FilePosition = FileLength Then
         Exit For
      End If
      FilePosition = FilePosition + 1
   Next
   FilePosition = StorePosition
End If
' write hex string.
ValidAppend = True
For NumberBytes = 1 To Len(ByteString$) Step 2
   If FilePosition > FileLength Then
      Byte2 = 0
      GoSub AppendIt
      If ValidAppend = False Then
         Exit For
      End If
   End If
   FileByte = Chr$(Val("&H" + Mid$(ByteString$, NumberBytes, 2)))
   SeekPosition = FilePosition
   Call LseekFile
   Call WriteFile
   Call CalculatePosition1
   If LastPage <> FilePage Then
      LastPage = FilePage
      Call DisplayHexPage
   End If
   Call ClearPageByte
   FilePosition = FilePosition + 1
Next
If ValidAppend Then
   FilePosition = FilePosition - 1
End If
Call DisplayPageByte
Call DisplayFilename
Return

' record the current byte position and value,
'   increment the number of undos in record structure array.
StoreUndo:
If CurrentUndo < 1048576! Then
   CurrentUndo = CurrentUndo + 1!
   Get #6, CurrentUndo, UndoFile
   Mid$(UndoFile.UndoByte1, (CurrentFile - 1) * 2 + 1, 2) = MKI$(AsciiValue)
   Mid$(UndoFile.UndoPosition1, (CurrentFile - 1) * 8 + 1, 8) = MKD$(FilePosition)
   Put #6, CurrentUndo, UndoFile
End If
Return

Rem Drop down input menu.

Menu2:
Call DropDownMenu
If CurrentMenu = False Then
   Call LocateCursor
   GoTo StartLoop
End If
Select Case CurrentMenu
   Case 1
      Select Case CurrentMenuSelection
         Case 1 ' Alt-N  Open new file
            If NumberFiles < MaxFiles Then
               Call MultiFileFunction(2)
               GoSub NewFile
               GoTo BeginFile
            End If
         Case 2 ' Alt-W  Close file
            GoSub CloseCurrentFile
            If NumberFiles = False Then
               GoSub NewFile
               GoTo BeginFile
            End If
         Case 3 ' Alt-0  Close All Files
            GoSub CloseAllFiles
            GoSub NewFile
            NumberFiles = False
            GoTo BeginFile
         Case 4 ' Alt-V  View files
            Call Viewfiles(Var)
            If Var > False Then
               NextFile = Var
               GoSub SearchFile3
            End If
            Call DisplayFilename
         Case 5 ' Alt-Y  Toggle window
            If FileLength Then
               GoSub ToggleRight
            End If
         Case 6 ' Alt-X  Exit program
            GoTo StopLabel
      End Select
   Case 2
      Select Case CurrentMenuSelection
         Case 1 ' Alt-C  ANSI Chart
            GoSub ANSIChart
         Case 2 ' Alt-H  HEX Chart
            GoSub HEXChart
      End Select
   Case 3
      If FileLength Then
         Select Case CurrentMenuSelection
            Case 1 ' Alt-D  HEX Screen Dump
               GoSub DumpScreen
            Case 2 ' Alt-E  HEX File Dump
               GoSub DumpHEXFile
         End Select
      End If
   Case 4
      Select Case CurrentMenuSelection
         Case 1 ' Alt-A  Append bytes
            GoSub AppendByte
         Case 2 ' Alt-M  Append ASCII string
            GoSub AppendASCII
         Case 3 ' Alt-R  Redraw screen
            Call MultiFileFunction(2)
            GoSub RedrawScreen0
         Case 4 ' Alt-U  Undo last byte
            If FileLength Then
               GoSub UndoByte
            End If
         Case 5 ' Alt-Z  Undo All bytes
            If FileLength Then
               GoSub UndoAll
            End If
      End Select
   Case 5
      If FileLength Then
         Select Case CurrentMenuSelection
            Case 1 ' Alt-J  Jump to byte
               GoSub JumpByte
            Case 2 ' Alt-L  Jump to page
               GoSub JumpPage
         End Select
      End If
   Case 6
      If FileLength Then
         Select Case CurrentMenuSelection
            Case 1 ' Alt-P  HEX Screen Print
               GoSub PrintScreen
            Case 2 ' Alt-T  HEX File Print
               GoSub PrintFile
         End Select
      End If
   Case 7
      If FileLength Then
         Select Case CurrentMenuSelection
            Case 1 ' Alt-K  Search for string
               GoSub SearchASCII
            Case 2 ' Alt-S  Search for bytes
               GoSub SearchBytes
         End Select
      End If
End Select
Call LocateCursor
GoTo StartLoop

Rem Long filename open routine:

Rem Open file in Windows.
Rem Create file if nonexistent.
Rem Returns:
Rem   ValidFile=True if open successful.
Rem   FileLocked=True if file locked.

OpenFile:
ErrorTrap = False
FileLocked = False
ValidFile = False
FileAttribute = False
Check.Disk = True
Disk.Ready = False
Handle = FreeFile
Open Filename For Binary Shared As #Handle
Check.Disk = False
If Disk.Ready Then
   Return
End If
ValidFile = True
' get file attribute.
FileAttribute = GetFileAttr(ASCIIZ)
' check file is read-only.
If (FileAttribute And 1) = 1 Then
   FileLocked = True
End If
Return

Rem close all files.
CloseAllFiles:
For Var = 1 To NumberFiles
   Handle = File(Var).Handle
   FileLocked = File(Var).FileLocked
   FileLength = File(Var).FileLength
   If Handle Then
      GoSub CloseFile
   End If
Next
Return

Rem close file.
CloseFile:
Close #Handle
Handle = 0
Return

Rem write byte block to file.
WriteBlockFile:
Share.Count = 0
If FileLocked Then
   Write.Error = True
   Return
End If
Write.Error = False
Check.Disk = True
Disk.Ready = False
SeekPosition2 = SeekPosition + 1
Seek Handle, SeekPosition2
Put Handle, , BlockByte
Check.Disk = False
If Disk.Ready Then
   Write.Error = True
End If
Return

Rem get netpath from filename
ParseNetPath: ' \\server\share\filename.ext
NetPath$ = Nul
If Left$(Filename, 2) = "\\" Then
   Net1 = InStr(3, Filename, "\")
   If Net1 Then
      Net2 = InStr(Net1 + 1, Filename, "\")
      If Net2 Then
         NetPath$ = Left$(Filename, Net2 - 1)
      End If
   End If
End If
Return

Rem conanicalize filename for display purposes.
ShortFilename:
' read ambiguated 8.3 filename.
ASCIIZ3 = ASCIIZ
Call GetShortFilename(Short.Filename$)
ASCIIZ = ASCIIZ3

' store 64-byte filename.
Filename = Short.Filename$
ShortFilename = Filename
CurrentNetPath = NetPath$

' read conanicalized 8.3 filename.
Filename = Conanicalize$(Filename)
Return

Rem Shell routines:

Rem Run DOS shell.
DOSshell:
Call MultiFileFunction(2)
Colorf Plain
Cls
Printf "Type 'Exit' to return to editor.."
Locatef 2, 1, 1
Comspec$ = Environ$("COMSPEC")
If Len(Comspec$) Then
   Shell Comspec$
Else
   Shell "CMD"
End If
GoSub RedrawScreen0
Return

Rem Run screen saver.
SaveShell:
s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
Call MultiFileFunction(2)
Colorf Plain
Cls
Printf "Press any key to return to editor.."
Locatef 2, 1, 1
Do
   If INKEYx$ <> "" Then
      Exit Do
   End If
Loop
GoSub RedrawScreen0
Return

Rem test menu box
MenuBox:
Call MultiFileFunction(2)
Call ClearStatus
Drive$ = Left$(_CWD$, 1) ' c:\dir
Directory$ = Mid$(_CWD$, 4)
Call Menu(NetPath2$, Drive$, Directory$, FileSpec1$, FileSpec2$)
Rem Concatenate upon return:
If NetPath2$ = Nul Then
   If Directory$ = Nul Then
      FilenameX$ = Drive$ + ":\" + FileSpec2$
   Else
      FilenameX$ = Drive$ + ":\" + Directory$ + "\" + FileSpec2$
   End If
Else
   If Directory$ = Nul Then
      FilenameX$ = NetPath2$ + "\" + FileSpec2$
   Else
      FilenameX$ = NetPath2$ + "\" + Directory$ + "\" + FileSpec2$
   End If
End If
Color Yellow
Print "File information:"
Color White
Print " Netpath: " + NetPath2$
Print " Drive: " + Drive$ + ":"
Print " Directory: " + Directory$
Print " Filename: " + FilenameX$
Color Yellow
Print "Press any key to return to editor.."
Locatef 2, 1, 1
Do
   If INKEYx$ <> "" Then
      Exit Do
   End If
Loop
GoSub RedrawScreen0
Return

Rem test dialog menu box
MenuBox2:
Call MultiFileFunction(2)
Call ClearStatus
Call Menu3(NetPath$, Drive$, Directory$, FileSpec2$)
Cls
Color Yellow
Print "File information:"
Color White
Print " Netpath= "; NetPath$
Print " Drive= "; Drive$; ":"
Print " Directory= "; Directory$
Print " Filename= "; FileSpec2$
Color Yellow
Printf "Press any key to return to editor.."
Locatef 2, 1, 1
Do
   If INKEYx$ <> "" Then
      Exit Do
   End If
Loop
GoSub RedrawScreen0
Return

Rem Run DOS command in shell.
DOScommand:
Call MultiFileFunction(2)
Call ClearStatus
Printf "Enter DOS command?"
InputString$ = LineInput$(2, 23, 55)
If Len(InputString$) Then
   ' open filename.
   x2 = FreeFile
   DOSfilename$ = "DOSEXIT" + Mid$(Str$(Process.Number), 2) + ".BAT"
   Open DOSfilename$ For Output Shared As #x2

   ' write DOS commands.
   Print #x2, "@ECHO OFF"
   Print #x2, InputString$
   Print #x2, "PAUSE"
   Print #x2, "EXIT"
   Close #x2

   ' clear screen
   Colorf Plain
   Cls

   ' shell to batch file.
   Shell DOSfilename$
End If
GoSub RedrawScreen0
Return

Rem Mouse routines:

' move mouse cursor for mouseover.
MoveMouse:
' check mouse boundaries.
If MouseX = 1 Then
   NewMenuSelection = False
   Select Case MouseY
      Case 6 To 9 ' File
         NewMenuSelection = 1
      Case 16 To 21 ' Charts
         NewMenuSelection = 2
      Case 26 To 29 ' Dump
         NewMenuSelection = 3
      Case 36 To 39 ' Edit
         NewMenuSelection = 4
      Case 46 To 49 ' Jump
         NewMenuSelection = 5
      Case 56 To 60 ' Print
         NewMenuSelection = 6
      Case 64 To 69 ' Search
         NewMenuSelection = 7
   End Select
   If NewMenuSelection > False Then
      If NewMenuSelection <> CurrentMenu Then
         If CurrentMenu > False Then
            ' remove hilight menu tab.
            Colorf2 White, 0
            Call DisplayTab(CurrentMenu)
         End If
      End If
      CurrentMenu = NewMenuSelection
      CurrentMenuSelection = 1
   End If
   ' hilight menu tab.
   If CurrentMenu > False Then
      Colorf2 White, 1
      Call DisplayTab(CurrentMenu)
   End If
   Call LocateCursor2
   Return
End If

' clear file menu tab.
If CurrentMenu Then
   Colorf2 White, 0
   Call DisplayTab(CurrentMenu)
End If

' move to new byte.
If MouseX > 3 And MouseX < 20 Then
   If MouseY > 5 And MouseY < 50 Then
      VarX = Screen(MouseX, MouseY)
      If VarX <> 32 Then
         NewPosition = CalculatePosition3#
         If NewPosition <> FilePosition Then
            Call ClearPageByte
            FilePosition = NewPosition
            Call CalculatePosition1
            Call DisplayPageByte
            Call DisplayFilename
         End If
      End If
   End If
End If
Return

' process left mouse button click.
MouseMove1:
' stop program.
If MouseX = 3 And MouseY = 77 Then
   GoTo StopLabel
End If
' help screen.
If MouseX = 4 And MouseY = 77 Then
   GoSub DisplayHelp
   Return
End If
' page up.
If MouseX = 4 And MouseY = 52 Then
   If FileLength Then
      GoSub PageUp
   End If
   Return
End If
' page down.
If MouseX = 20 And MouseY = 52 Then
   If FileLength Then
      GoSub PageDown
   End If
   Return
End If
' line up.
If MouseX = 5 And MouseY = 52 Then
   If FileLength Then
      GoSub CursorUp
   End If
   Return
End If
' line down.
If MouseX = 19 And MouseY = 52 Then
   If FileLength Then
      GoSub CursorDown
   End If
   Return
End If
' select drop down menu.
If MouseX = 1 Then
   Select Case MouseY
      Case 6 To 9 ' File
         NewMenuSelection = 1
      Case 16 To 21 ' Charts
         NewMenuSelection = 2
      Case 26 To 29 ' Dump
         NewMenuSelection = 3
      Case 36 To 39 ' Edit
         NewMenuSelection = 4
      Case 46 To 49 ' Jump
         NewMenuSelection = 5
      Case 56 To 60 ' Print
         NewMenuSelection = 6
      Case 64 To 69 ' Search
         NewMenuSelection = 7
      Case Else
         Return
   End Select
   If NewMenuSelection <> CurrentMenu Then
      If CurrentMenu > False Then
         ' remove hilight menu tab.
         Colorf2 White, 0
         Call DisplayTab(CurrentMenu)
      End If
   End If
   CurrentMenu = NewMenuSelection
   CurrentMenuSelection = 1
   ' hilight menu tab.
   Colorf2 White, 1
   Call DisplayTab(CurrentMenu)
   ' jump to file menu.
   GoTo Menu2
   Return
End If
If MouseX > 3 And MouseX < 20 Then
   If MouseY > 5 And MouseY < 50 Then
      VarX = Screen(MouseX, MouseY)
      If VarX <> 32 Then
         If FileLocked Then
            Call DisplayX
            Call LockedFile
            Return
         End If
         If FileLength Then
            GoSub ChangeHexValue
         End If
      End If
   End If
End If
Return

' process right mouse button click/drag.
MouseMove2:
If MouseX > 3 And MouseX < 20 Then
   If MouseY > 5 And MouseY < 50 Then
      VarX = Screen(MouseX, MouseY)
      If VarX <> 32 Then
         NewPosition = CalculatePosition3#
         CopyStart = NewPosition
         Do
            If MouseX Or MouseY Then
               If MouseY > 5 And MouseY < 50 Then
                  If MouseX > 3 And MouseX < 20 Then
                     Call MouseButton1Drag(0)
                  Else
                     If MouseX = 3 Then
                        Call MouseButton1Drag(9) ' pageup
                     Else
                        If MouseX = 20 Then
                           Call MouseButton1Drag(10) ' pagedown
                        End If
                     End If
                  End If
               End If
            End If
            Z = MouseDriver
         Loop Until MouseButton2 = 0
      End If
   End If
End If
Return

' critical error trap.
Error.Routine:
' trap error cascade.
If InErrorFlag Then
   System
End If

' check error return type.
ErrorTrap = Err
If Check.Disk Then
   Disk.Ready = Err
   Resume Next
End If

' check share violations.
If Err = 70 Then
   Share.Count = Share.Count + 1
   If Share.Count < MaxViolations Then
      Resume
   End If
End If
ScreenDrawn = False

' store background color of bottom row.
BG = Screen(25, 1, 1) \ 16

' display critical error.
Colorf White
Locatef 25, 1, 0
Printf "Error" + Str$(Err) + ": "
Call DisplayCriticalError(ErrorTrap)
Printf ": IDE" + Str$(_ErrorLine) + " Press R(etry), C(ontinue), Q(uit):"

' get keypress.
Do
   ErrorRespond$ = INKEYx$

   ' parse key.
   Select Case LCase$(ErrorRespond$)
      Case "r"
         Printf "r"
         Colorf2 7, BG
         Locatef 25, 1, 0
         Printf Space$(79)
         Colorf2 7, 0
         Resume
      Case "c"
         Printf "c"
         Colorf2 7, BG
         Locatef 25, 1, 0
         Printf Space$(79)
         Colorf2 7, 0
         Resume Next
      Case "q"
         Printf "q"
         Colorf2 7, BG
         Locatef 25, 1, 0
         Printf Space$(79)
         Colorf2 7, 0
         Resume StopLoop
   End Select
Loop
Call Delete.Process
End 2

' end of program.
StopLoop:
' close all files.
GoSub CloseAllFiles

' stop program.
StopProgram:
Colorf2 7, 0

' delete process filenames.
Call Delete.Process

' reset mouse activity.
Call ClearMouse

' store settings
Call WriteConfig

' terminate program.
If FastExit Then
   System
Else
   End 0
End If

' terminal error exits here.
Error.Exit:
' display error.
Colorf2 White, 0
Cls
Printf "Hex Editor " + Version + " " + Release + " critical error trap:"
Colorf Yellow
Locatef CsrLin + 1, 1, 0
Call DisplayCriticalError(ErrorTrap)
Printf "."
Locatef CsrLin + 1, 1, 0
Printf "Err:" + Str$(Err) + " IDE:" + Str$(_ErrorLine) + " Press R(etry), C(ontinue), Q(uit):"
Colorf Plain
' delete process filenames.
Call Delete.Process
End 2

' timer ctrl-break trap.
Sub Timer.Trap
   Control.Break = 0
   VarQ = _Exit
   If VarQ Then ' Control-Break
      _KeyClear
      _Delay .2
      _KeyClear
      Do While INKEYx$ <> ""
         _Limit 50
      Loop
      Control.Break = True
      If BreakBox = 0 Then
         Cls
         ' delete process filenames.
         Call Delete.Process
         System
      End If
   End If
End Sub

' new: 09/10/2025
Sub RebootFunc (Var)
   Var = -1
   $If WIN Then
      S$ = "%windir%\System32\shutdown.exe /r /t 0"
      Call ShellProgram(S$)
      Exit Sub
   $End If
   $If LINUX OR MAC Then
      S$ = "/sbin/shutdown -r now"
      Call ShellProgram(S$)
      Exit Sub
   $End If
   Var = 0
End Sub

' new: 09/10/2025
Sub ShutdownFunc (Var)
   Var = -1
   $If WIN Then
      S$ = "%windir%\System32\shutdown.exe /s /t 0"
      Call ShellProgram(S$)
      Exit Sub
   $End If
   $If LINUX OR MAC Then
      S$ = "/sbin/shutdown -h now"
      Call ShellProgram(S$)
      Exit Sub
   $End If
   Var = 0
End Sub

' new: 09/10/2025
Sub ShellProgram (Var$)
   FX$ = "HEXEDIT" + LTrim$(Str$(Node)) + ".BAT"
   X = FreeFile
   Open FX$ For Output As #X
   Print #X, "@ECHO OFF"
   Print #X, Var$
   Print #X, "PAUSE"
   Print #X, "EXIT"
   Close #X
   Shell FX$
   f$ = FX$ + Chr$(0)
   X = DeleteFileA(f$)
End Sub

' Def FNclock$=Format$(Now,"ddd dd mmm yy\, hh:mma/p")
Function clock$
   ' mm-dd-yyyy hh:mm:ss

   M = Val(Left$(Date$, 2))
   D = Val(Mid$(Date$, 4, 2))
   Y = Val(Right$(Date$, 2))
   If M < 3 Then M = M + 12: Y = Y - 1
   W = ((13 * M + 3) \ 5 + D + Y + Y \ 4 - Y \ 100 + Y \ 400 + 1) Mod 7
   var$ = Mid$("SunMonTueWedThuFriSat", W * 3 + 1, 3)
   var$ = var$ + " " + Mid$(Date$, 4, 2) ' dd

   T = (Val(Mid$(Date$, 1, 2)) - 1) * 3 + 1
   var$ = var$ + " " + Mid$("JanFebMarAprMayJunJulAugSepOctNovDec", T, 3)

   var$ = var$ + " " + Mid$(Date$, 9, 2) ' yy
   T = Val(Left$(Time$, 2))
   If T > 11 Then T = T - 12
   If T = 0 Then T = 12
   var$ = var$ + ", " + Right$("00" + LTrim$(Str$(T)), 2) ' hh
   var$ = var$ + ":" + Mid$(Time$, 4, 2) ' mm

   T = Val(Left$(Time$, 2))
   If T < 12 Then
      var$ = var$ + "a"
   Else
      var$ = var$ + "p"
   End If
   clock$ = var$
End Function

Rem Subroutines:
Rem   CalculatePosition1    --  calculate screen values given file position.
Rem   CalculatePosition2    --  calculate screen values given variable.
Rem   Colorf            --  specialized color function.
Rem   Colorf2           --  specialized color function.
Rem   DisplayBootUsage  --  display boot usage.
Rem   DisplayScreen     --  display main editing screen.
Rem   DisplayScreen2    --  display screen border.
Rem   Deconcatenate     --  deconcatenates filename.
Rem   DropDownMenu      --  starts top drop down menu.
Rem   DisplayTab        --  redraws menu tab.
Rem   DisplayCriticalError  --  display error trap message.
Rem   ExcludeList       --  gets exluded filelist for menu.
Rem   GetDrive          --  reads default drive/directory.
Rem   InitializePaste   --  initialize paste file.
Rem   InitPasteFiles    --  init paste files for new file.
Rem   InitVars          --  inits some startup variables.
Rem   Locatef           --  specialized locate function.
Rem   MultiFileFunction     --  routine to process multiple files.
Rem   OpenUndoFile      --  open undo/marker file.
Rem   OpenPasteFiles    --  open paste files.
Rem   Printf            --  specialized print function.
Rem   ReadConfigFile    --  search for and read configure file.
Rem   StoreServerName   --  stores default server name.

Rem Gets default drive/directory.
Sub GetDrive (Drive.Number, Directory$)
   ' store current directory.
   Directory.ASCIIZ = _CWD$
   Directory$ = Directory.ASCIIZ
   Drive.Number = Asc(Left$(Directory$, 1)) - 65 ' 0=a, 1=b, ..
   If Mid$(Directory$, 2, 1) = ":" Then
      Directory$ = Mid$(Directory$, 3)
   End If
   If Left$(Directory$, 1) = "\" Then
      Directory$ = Mid$(Directory$, 2)
   End If
End Sub

Rem Store default server name.
Sub StoreServerName
   ' store default server name.
   Var$ = Environ$("COMPUTERNAME")
   If Len(Var$) Then
      DefaultNetPath = Var$
   End If
End Sub

Rem Subroutine to init variables.
Sub InitVars
   ' reset default printer port.
   PrinterPort = 1

   ' reset default string store variable.
   StoreSearchMulti = True

   ' init screen colors.
   Black = 0
   Blue = 9
   Cyan = 11
   Green = 10
   Magenta = 13
   Plain = 7
   Red = 12
   White = 15
   Yellow = 14
   BackGround = 1
   BackGround2 = 1

   ' init ascii characters.
   Hline = 205
   Vline = 186
   ULcorner = 201
   URcorner = 187
   LLcorner = 200
   LRcorner = 188

   ' check for Windows loaded.
   If InStr(_OS$, "[WINDOWS]") Then
      Windows.Detected = True
      If InStr(_OS$, "[ANDROID]") Then
         Windows.Detected = False
      End If
   End If

   ' check windows.
   If Windows.Detected = 0 Then
      System
   End If

   ' store mouse timing.
   MouseTime = 1!

   ' store max file menu box files.
   SortMax = 32768!
   SortMax2 = 16384!

   ' get default drives.
   Call GetDrives

   ' check temp directory.
   FX$ = "C:\TEMP"
   If Node Then
      FX$ = "C:\TEMP" + LTrim$(Str$(Node))
   End If
   If _DirExists(FX$) = 0 Then
      If _FileExists(FX$) Then
         G$ = FX$ + Chr$(0)
         x = DeleteFileA(G$)
      End If
      G$ = FX$ + Chr$(0)
      x = CreateDirectoryA(G$, 0)
   End If
   DRX = FX$ + "\"

   ' init filename variables.
   ConfigFile = "hexedit.cfg"
   Var$ = Environ$("CONFIGFILE")
   If Len(Var$) Then
      If InStr(Var$, ":") Then
         Eat$ = Nul
      Else
         If InStr(Var$, "\") Then
            Eat$ = Nul
         Else
            ConfigFile = Var$
         End If
      End If
   End If
   DumpFile = "hexedit.dmp"
   Var$ = Environ$("DUMPFILE")
   If Len(Var$) Then
      If InStr(Var$, ":") Then
         Eat$ = Nul
      Else
         If InStr(Var$, "\") Then
            Eat$ = Nul
         Else
            DumpFile = Var$
         End If
      End If
   End If
   ExcludeFile = "hexedit.exd"
   Var$ = Environ$("EXCLUDEFILE")
   If Len(Var$) Then
      If InStr(Var$, ":") Then
         Eat$ = Nul
      Else
         If InStr(Var$, "\") Then
            Eat$ = Nul
         Else
            ExcludeFile = Var$
         End If
      End If
   End If
End Sub

Rem subroutine to send string of characters to screen.
Sub Printf (Var1$)
   For VarX = 1 To Len(Var1$)
      VarY = Asc(Mid$(Var1$, VarX, 1))
      Print Chr$(VarY);
   Next
End Sub

Rem subroutine stores recent color change.
Sub Colorf (Var)
   Color Var
End Sub

Rem subroutine stores recent color change.
Sub Colorf2 (Var1, Var2)
   Color Var1, Var2
End Sub

Rem subroutine sets cursor position.
Sub Locatef (Var1, Var2, Var3)
   ' test end of page.
   If Var1 > 24 Then
      ' scroll screen.
      Print ;
   End If
   Locate Var1, Var2, Var3
End Sub

Rem subroutine to access multiple file structure.
Rem input variable:
Rem   Var = 1 init new file.
Rem   Var = 2 store current file.
Rem   Var = 3 restore current file.
Sub MultiFileFunction (Var)
   Select Case Var
      Case 1 ' Init new file.
         File(CurrentFile).AsciiValue = False
         File(CurrentFile).ASCIIZ = ASCIIZ
         File(CurrentFile).Buffer = Chr$(0)
         File(CurrentFile).CopyPositionEnd = 0
         File(CurrentFile).CopyPositionPivot = 0
         File(CurrentFile).CopyPositionStart = 0
         File(CurrentFile).CurrentMarker = 0!
         File(CurrentFile).CurrentUndo = 0!
         File(CurrentFile).CurrentWindow2 = 0
         File(CurrentFile).FileDisplay = FileDisplayX
         File(CurrentFile).Filename = Filename
         File(CurrentFile).FileAttribute = FileAttribute
         File(CurrentFile).FileByte = Chr$(0)
         File(CurrentFile).FileLength = FileLength
         File(CurrentFile).FileLocked = FileLocked
         File(CurrentFile).FilePage = 1
         File(CurrentFile).FilePosition = 1
         File(CurrentFile).Handle = Handle
         File(CurrentFile).MarkerCount = 0!
         File(CurrentFile).Netpath = CurrentNetPath
         File(CurrentFile).PageColumn = 1
         File(CurrentFile).PageRow = 1
         File(CurrentFile).ScreenRow = ScreenRowX
         File(CurrentFile).ShortFilename = ShortFilename
         File(CurrentFile).StoreSearchString = ""
      Case 2 ' Store current file.
         File(CurrentFile).AsciiValue = AsciiValue
         File(CurrentFile).ASCIIZ = ASCIIZ
         File(CurrentFile).Buffer = Buffer
         File(CurrentFile).CopyPositionEnd = CopyPositionEnd
         File(CurrentFile).CopyPositionPivot = CopyPositionPivot
         File(CurrentFile).CopyPositionStart = CopyPositionStart
         File(CurrentFile).CurrentMarker = CurrentMarker
         File(CurrentFile).CurrentUndo = CurrentUndo
         File(CurrentFile).CurrentWindow2 = CurrentWindow2
         File(CurrentFile).FileDisplay = FileDisplay
         File(CurrentFile).Filename = Filename
         File(CurrentFile).FileAttribute = FileAttribute
         File(CurrentFile).FileByte = FileByte
         File(CurrentFile).FileLength = FileLength
         File(CurrentFile).FileLocked = FileLocked
         File(CurrentFile).FilePage = FilePage
         File(CurrentFile).FilePosition = FilePosition
         File(CurrentFile).Handle = Handle
         File(CurrentFile).MarkerCount = MarkerCount
         File(CurrentFile).Netpath = CurrentNetPath
         File(CurrentFile).PageColumn = PageColumn
         File(CurrentFile).PageRow = PageRow
         File(CurrentFile).ScreenRow = ScreenRow
         File(CurrentFile).ShortFilename = ShortFilename
         File(CurrentFile).StoreSearchString = StoreSearchString
      Case 3 ' Restore current file.
         AsciiValue = File(CurrentFile).AsciiValue
         ASCIIZ = File(CurrentFile).ASCIIZ
         Buffer = File(CurrentFile).Buffer
         CopyPositionEnd = 0
         CopyPositionPivot = 0
         CopyPositionStart = 0
         CurrentMarker = File(CurrentFile).CurrentMarker
         CurrentUndo = File(CurrentFile).CurrentUndo
         CurrentWindow2 = File(CurrentFile).CurrentWindow2
         FileDisplay = File(CurrentFile).FileDisplay
         Filename = File(CurrentFile).Filename
         FileAttribute = File(CurrentFile).FileAttribute
         FileByte = File(CurrentFile).FileByte
         FileLength = File(CurrentFile).FileLength
         FileLocked = File(CurrentFile).FileLocked
         FilePage = File(CurrentFile).FilePage
         FilePosition = File(CurrentFile).FilePosition
         Handle = File(CurrentFile).Handle
         MarkerCount = File(CurrentFile).MarkerCount
         CurrentNetPath = File(CurrentFile).Netpath
         PageColumn = File(CurrentFile).PageColumn
         PageRow = File(CurrentFile).PageRow
         ScreenRow = File(CurrentFile).ScreenRow
         ShortFilename = File(CurrentFile).ShortFilename
         If StoreSearchMulti Then
            StoreSearchString = File(CurrentFile).StoreSearchString
         End If
   End Select
End Sub

Rem subroutine to open undo/marker files,
Rem   also counts opened hexedit processes.

Sub OpenUndoFile (Var2)
   ' reset process counter.
   Var = False
   Var2 = False

   ' get valid path for file.
   MultiFilename1(1) = Nul
   MultiFilename1(2) = Nul

   ' start counter loop.
   Do
      ' make temp filename with counter.
      V1$ = DRX + "UNDOBYTE.DA" + Mid$(Str$(Var), 2)

      ' check file exists.
      Close #6
      If _FileExists(V1$) = 0 Then
         Open V1$ For Random As #6 Len = Len(UndoFile)
         MultiFilename1(1) = V1$
         Exit Do
      End If

      ' increment process counter.
      Var = Var + 1

      ' check maximum processes open.
      If Var > MaxProcesses Then ' needs to be 1 to 9.
         Var2 = True
         ErrorTrap = 90
         Exit Sub
      End If
   Loop

   ' store process number.
   Process.Number = Var

   ' make temp filename with process number.
   V1$ = DRX + "MARKERS1.DA" + Mid$(Str$(Process.Number), 2)
   Close #7
   Open V1$ For Random As #7 Len = Len(MarkerFile)
   MultiFilename1(2) = V1$
End Sub

Rem subroutine to initialize paste file.
Sub InitializePaste (Var2)
   Var2 = False
   ' make temp filename with process number.
   V1$ = DRX + "COPYFILE.DA" + Mid$(Str$(Process.Number), 2)
   MultiFilename1(3) = Nul
   Close #4
   ' check file exists.
   If _FileExists(V1$) Then
      G$ = V1$ + Chr$(0)
      x = DeleteFileA(G$)
   End If
   MultiFilename1(3) = V1$
End Sub

Rem subroutine to open paste files.
Sub OpenPasteFiles (Var2)
   Var2 = False
   ' make filename with process number.
   V1$ = DRX + "COPYFILE.DA" + Mid$(Str$(Process.Number), 2)
   ' make filename with process number and file number.
   V2$ = DRX + "UNDOFIL" + Mid$(Str$(Process.Number), 2) + ".DA" + Mid$(Str$(CurrentFile), 2)
   ' open files.
   Close #4, #5
   Open V1$ For Random As #4 Len = 1
   Open V2$ For Random As #5 Len = 1
   MultiFilenames(CurrentFile) = V2$
End Sub

Rem subroutine to init paste files for new file.
Sub InitPasteFiles (Var2)
   Var2 = 0
   ' make filename with process number.
   V1$ = DRX + "COPYFILE.DA" + Mid$(Str$(Process.Number), 2)
   ' make filename with process number and file number.
   V2$ = DRX + "UNDOFIL" + Mid$(Str$(Process.Number), 2) + ".DA" + Mid$(Str$(CurrentFile), 2)
   ' attempt to open file.
   Close #4, #5
   Open V1$ For Random As #4 Len = 1
   If _FileExists(V2$) Then
      G$ = V2$ + Chr$(0)
      x = DeleteFileA(G$)
   End If
   Open V2$ For Random As #5 Len = 1
   MultiFilenames(CurrentFile) = V2$
End Sub

Rem Position calculation routines follow:

' displays cell position in string format type 1.
Sub FormatPosition1
   Call CalculatePosition2
   If CurrentWindow2 = False Then
      Printf "(page: " + FormatX$(CDbl(FilePage2 - 1), 1) + ","
   Else
      Printf "(page: " + Right$("00000000" + Hex$(FilePage2 - 1), 8) + "x,"
   End If
   Printf " row:" + Mid$(Str$(PageRow2), 2) + ","
   Printf " column:" + Mid$(Str$(PageColumn2), 2) + ")"
End Sub

' calculate current screen page number, row, and column, given file position.
Sub CalculatePosition1
   FilePage = Int((FilePosition - 1) / 320) + 1
   PageRow = Int((FilePosition - (FilePage - 1) * 320 - 1) / 20) + 1
   PageColumn = Int((FilePosition - (FilePage - 1) * 320) - (PageRow - 1) * 20)
End Sub

' calculate screen page number, row, and column, given variable.
Sub CalculatePosition2
   If TempPosition3 = DFalse Then
      FilePage2 = False
      PageRow2 = False
      PageColumn2 = False
   Else
      FilePage2 = Int((TempPosition3 - 1) / 320) + 1
      PageRow2 = Int((TempPosition3 - (FilePage2 - 1) * 320 - 1) / 20) + 1
      PageColumn2 = Int((TempPosition3 - (FilePage2 - 1) * 320) - (PageRow2 - 1) * 20)
   End If
End Sub

Rem Subroutine to get environment variable settings,
Rem   and read custom config file variables.

Sub ReadConfigFile (Var$)
   ' check for ambiguation variable.
   If Environ$("AMBIGUATE") <> Nul Then
      AmbiguateSwitch = True
   End If

   ' check for screen row variable.
   If Environ$("HEXSCREEN") <> Nul Then
      ScreenRow = True
   End If

   ' check for heap sort variable.
   If Environ$("HEXSORT") <> Nul Then
      HeapSortOff = True
   End If

   ' check for fast exit to system variable.
   If Environ$("FASTEXIT") <> Nul Then
      FastExit = True
   End If

   ' check for character ascii print variable.
   If Environ$("CHARPRINT") <> Nul Then
      CharPrint = True
   End If

   ' check for mouse wheel reversal variable.
   If Environ$("REVERSEWHEEL") <> Nul Then
      WheelReverse = True
   End If

   ' check for file date/time variable.
   If Environ$("FILESWITCH") <> Nul Then
      X = Int(Val(Environ$("FILESWITCH")))
      Select Case X
         Case 0, 1, 2
            FileSwitch = X
      End Select
   End If

   ' check for file menu box filesize display.
   If Environ$("FILESIZE") <> Nul Then
      X$ = Environ$("FILESIZE")
      Select Case X$
         Case "0", "B"
            FileSizeType = 0
         Case "1", "K"
            FileSizeType = 1
         Case "2", "M"
            FileSizeType = 2
         Case "3", "G"
            FileSizeType = 3
      End Select
   End If

   ' check for quiet variable.
   If Environ$("QUIET") <> Nul Then
      X = Int(Val(Environ$("QUIET")))
      Select Case X
         Case -1, 0, 1, 2, 3, 4, 5, 6
            QuietSwitch = X
      End Select
   End If

   ' init alternate characters.
   If Environ$("HEXCHARS") <> Nul Then
      Hline = 45
      Vline = 124
      ULcorner = 43
      URcorner = 43
      LLcorner = 43
      LRcorner = 43
   End If

   ' define screen offsets for file menu box.
   ' allows menu repositioning.
   Xcoor = 5
   Ycoor = 20

   ' check config variable.
   If Environ$("HEXCONFIG") <> Nul Then
      Exit Sub
   End If

   Rem Read Hexedit?.cfg file,
   Rem   search current path, environment path, then path statement.

   ' search current path.
   File$ = _CWD$
   If Right$(File$, 1) <> "\" Then
      File$ = File$ + "\"
   End If
   Config.Filename$ = File$ + ConfigFile
   If _FileExists(Config.Filename$) Then
      GoSub ReadFile2
      If ValidFile Then
         Exit Sub
      End If
   End If

   ' search environment path.
   File$ = Environ$("HEXEDIT")
   If Len(File$) Then
      File$ = RTrim$(File$)
      File$ = LTrim$(File$)
      If Left$(File$, 1) = Quote Then
         File$ = Mid$(File$, 2)
      End If
      If Right$(File$, 1) = Quote Then
         File$ = Left$(File$, Len(File$) - 1)
      End If
      If Right$(File$, 1) <> "\" Then
         File$ = File$ + "\"
      End If
      ASCIIZ = File$ + ConfigFile + Chr$(0)
      Call GetShortFilename(Config.Filename$)
      If Len(Config.Filename$) Then
         If _FileExists(Config.Filename$) Then
            GoSub ReadFile2
            If ValidFile Then
               Exit Sub
            End If
         End If
      End If
   End If

   ' search path statement.
   Path$ = Environ$("PATH")
   If Len(Path$) Then
      Do
         ' parse path.
         Parse = InStr(Path$, ";")
         If Parse Then
            File$ = Left$(Path$, Parse - 1)
            Path$ = Mid$(Path$, Parse + 1)
         Else
            File$ = Path$
            Path$ = Nul
         End If

         ' store filename.
         File$ = RTrim$(File$)
         File$ = LTrim$(File$)
         If Len(File$) Then
            If Left$(File$, 1) = Quote Then
               File$ = Mid$(File$, 2)
            End If
            If Right$(File$, 1) = Quote Then
               File$ = Left$(File$, Len(File$) - 1)
            End If
            If Right$(File$, 1) <> "\" Then
               File$ = File$ + "\"
            End If
            ASCIIZ = File$ + ConfigFile + Chr$(0)
            Call GetShortFilename(Config.Filename$)
            If Len(Config.Filename$) Then
               If _FileExists(Config.Filename$) Then
                  GoSub ReadFile2
                  If ValidFile Then
                     Exit Sub
                  End If
               End If
            End If
         End If
         If Path$ = Nul Then
            Exit Do
         End If
      Loop
   End If
   Exit Sub

   ' read in the data file.
   ReadFile2:
   ' open filename.
   ErrorTrap = False
   ValidFile = False
   x2 = FreeFile
   Open Config.Filename$ For Input Shared As #x2
   If ErrorTrap Then
      Return
   End If
   ValidFile = True

   ' read input lines.
   Do While Not EOF(x2)
      Line Input #x2, FileLine$

      ' remove appended comment.
      Var = InStr(FileLine$, "'")
      If Var Then
         If Var = 1 Then
            FileLine$ = Nul
         Else
            FileLine$ = Left$(FileLine$, Var - 1)
         End If
      End If

      ' store config line.
      FileLine2$ = FileLine$

      ' trim config line.
      GoSub Remove.Spaces

      ' check for prepended comment.
      If Left$(FileLine$, 1) = ";" Then
         FileLine$ = Nul
      End If

      ' check assignment value.
      Parse = InStr(FileLine$, "=")

      ' parse off left/right sides.
      If Parse Then

         ' get left/right side values.
         Char$ = Left$(FileLine$, Parse - 1)
         Setting$ = Mid$(FileLine$, Parse + 1)

         ' get right side value for filenames
         ' enclosed in quotes containing spaces.
         Parse = InStr(FileLine2$, "=")
         Setting2$ = Mid$(FileLine2$, Parse + 1)
         Setting2$ = RTrim$(Setting2$)
         Setting2$ = LTrim$(Setting2$)

         ' check length of values.
         If Len(Char$) > 0 And Len(Setting$) > 0 Then
            ' compare values.
            Select Case UCase$(Char$)
               ' check debug switches.
               Case "DEBUG"
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        Debug = False
                     Case "ON", "-1", "TRUE"
                        Debug = True
                  End Select
               Case "DEBUG2"
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        Debug2 = False
                     Case "ON", "-1", "TRUE"
                        Debug2 = True
                  End Select
               Case "DEBUG3"
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        Debug3 = False
                     Case "ON", "-1", "TRUE"
                        Debug3 = True
                  End Select
               Case "FILEMENUBOX"
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        LoadMenuBox = False
                     Case "ON", "-1", "TRUE"
                        LoadMenuBox = True
                  End Select
               Case "REVERSEWHEEL"
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        WheelReverse = False
                     Case "ON", "-1", "TRUE"
                        WheelReverse = True
                  End Select
               Case "CHARPRINT"
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        CharPrint = False
                     Case "ON", "-1", "TRUE"
                        CharPrint = True
                  End Select
               Case "FASTEXIT"
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        FastExit = False
                     Case "ON", "-1", "TRUE"
                        FastExit = True
                  End Select
                  ' check file sort maximum
               Case "SORTMAX"
                  Var! = 0!
                  GoSub Remove.Commas
                  Select Case UCase$(Right$(Var3$, 1))
                     Case "K"
                        Var3$ = Left$(Var3$, Len(Var3$) - 1)
                        Var3! = Int(Val(Var3$))
                        If Var3! >= 1! And Var3! <= MaxPrecision1 Then
                           Var! = Var3! * 1024!
                        End If
                     Case "M"
                        Var3$ = Left$(Var3$, Len(Var3$) - 1)
                        Var3! = Int(Val(Var3$))
                        If Var3! <= MaxPrecision2 Then
                           Var! = Var3! * 1048576!
                        End If
                     Case Else
                        Var! = Int(Val(Var3$))
                  End Select
                  Var! = Int(Var!)
                  If Var! = -1! Then ' disable
                     SortMax = -1!
                  End If
                  If Var! > MaxPrecision Then
                     Var! = MaxPrecision
                  End If
                  If Var! >= 1024! And Var! <= MaxPrecision Then
                     SortMax = Var!
                  End If
                  ' check dir sort maximum
               Case "SORTMAX2"
                  Var! = 0!
                  GoSub Remove.Commas
                  Select Case UCase$(Right$(Var3$, 1))
                     Case "K"
                        Var3$ = Left$(Var3$, Len(Var3$) - 1)
                        Var3! = Int(Val(Var3$))
                        If Var3! >= 1! And Var3! <= MaxPrecision1 Then
                           Var! = Var3! * 1024!
                        End If
                     Case "M"
                        Var3$ = Left$(Var3$, Len(Var3$) - 1)
                        Var3! = Int(Val(Var3$))
                        If Var3! <= MaxPrecision2 Then
                           Var! = Var3! * 1048576!
                        End If
                     Case Else
                        Var! = Int(Val(Var3$))
                  End Select
                  Var! = Int(Var!)
                  If Var! = -1! Then ' disable
                     SortMax2 = -1!
                  End If
                  If Var! > MaxPrecision Then
                     Var! = MaxPrecision
                  End If
                  If Var! >= 1024! And Var! <= MaxPrecision Then
                     SortMax2 = Var!
                  End If
                  ' check dump filename.
               Case "DUMPFILE"
                  DumpFile = Setting$
                  ' check exclude filename.
               Case "EXCLUDEFILE"
                  ExcludeFile = Setting$
                  ' check and concatenate loaded filenames.
               Case "EDITFILE"
                  If Var$ = Nul Then
                     Var$ = Setting2$
                  Else
                     Var$ = Var$ + Chr$(13) + Setting2$
                  End If
                  ' check environment replacement variables.
               Case "HEXDISPLAY" ' 64-byte display.
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        FileDisplayX = True
                     Case "ON", "-1", "TRUE"
                        FileDisplayX = False
                  End Select
               Case "HEXSCREEN" ' help key list.
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        ScreenRowX = True
                     Case "ON", "-1", "TRUE"
                        ScreenRowX = False
                  End Select
               Case "HEXSORT" ' file\dir sort.
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        HeapSortOff = True
                     Case "ON", "-1", "TRUE"
                        HeapSortOff = False
                  End Select
               Case "AMBIGUATE" ' file menu box ambiguation.
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        AmbiguateSwitch = False
                     Case "ON", "-1", "TRUE"
                        AmbiguateSwitch = True
                  End Select
               Case "QUIET" ' file menu box display.
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        QuietSwitch = False
                     Case "ON", "-1", "TRUE"
                        QuietSwitch = True
                     Case Else
                        Select Case Int(Val(Setting$))
                           Case 1 To 6
                              QuietSwitch = Int(Val(Setting$))
                        End Select
                  End Select
               Case "FILESWITCH" ' file menu box date\time display.
                  Select Case Int(Val(Setting$))
                     Case 0, 1, 2
                        FileSwitch = Int(Val(Setting$))
                  End Select
               Case "FILESIZE" ' file menu box filesize display.
                  Select Case UCase$(Setting$)
                     Case "0", "B"
                        FileSizeType = 0
                     Case "1", "K"
                        FileSizeType = 1
                     Case "2", "M"
                        FileSizeType = 2
                     Case "3", "G"
                        FileSizeType = 3
                  End Select
               Case "MOUSEDRAGSCROLL" ' mouse drag scroll timer.
                  MouseTime = CSng(Val(Setting$))
               Case "PORT" ' default printer port.
                  NewValue = Int(Val(Setting$))
                  If NewValue >= 1 And NewValue <= 3 Then
                     PrinterPort = NewValue
                  End If
               Case "SEARCH" ' default search variable.
                  Select Case UCase$(Setting$)
                     Case "OFF", "0", "FALSE"
                        StoreSearchMulti = False
                     Case "ON", "-1", "TRUE"
                        StoreSearchMulti = True
                  End Select
               Case "LASTDRIVE" ' override last drive.
                  Select Case UCase$(Setting$)
                     Case "C" To "Z"
                        Last.Drive = Asc(UCase$(Setting$)) - 64
                  End Select
               Case "XCOOR" ' file menu box location.
                  NewValue = Int(Val(Setting$))
                  If NewValue >= 2 Then
                     If NewValue <= 8 Then
                        Xcoor = NewValue
                     End If
                  End If
               Case "YCOOR" ' file menu box location.
                  NewValue = Int(Val(Setting$))
                  If NewValue >= 1 Then
                     If NewValue <= 39 Then
                        Ycoor = NewValue
                     End If
                  End If
               Case Else
                  ' custom color overrides.
                  NewValue = Int(Val(Setting$))
                  If NewValue >= 0 And NewValue <= 7 Then
                     ' menu box ansi color override.
                     Select Case UCase$(Char$)
                        Case "BACKGROUND"
                           BackGround = NewValue
                        Case "BACKGROUND2"
                           BackGround2 = NewValue
                     End Select
                  End If
                  If NewValue >= 0 And NewValue <= 15 Then
                     ' menu box ansi color overrides.
                     Select Case UCase$(Char$)
                        Case "BLACK"
                           Black = NewValue
                        Case "BLUE"
                           Blue = NewValue
                        Case "CYAN"
                           Cyan = NewValue
                        Case "GREEN"
                           Green = NewValue
                        Case "MAGENTA"
                           Magenta = NewValue
                        Case "PLAIN"
                           Plain = NewValue
                        Case "RED"
                           Red = NewValue
                        Case "WHITE"
                           White = NewValue
                        Case "YELLOW"
                           Yellow = NewValue
                     End Select
                  End If
                  ' check ascii value.
                  If NewValue >= 0 And NewValue <= 255 Then
                     ' menu box ansi character overrides.
                     Select Case UCase$(Char$)
                        Case "HLINE"
                           Hline = NewValue
                        Case "VLINE"
                           Vline = NewValue
                        Case "ULCORNER"
                           ULcorner = NewValue
                        Case "URCORNER"
                           URcorner = NewValue
                        Case "LLCORNER"
                           LLcorner = NewValue
                        Case "LRCORNER"
                           LRcorner = NewValue
                     End Select
                  End If
            End Select
         End If
      End If
   Loop
   Close #x2
   Return

   ' remove spaces.
   Remove.Spaces:
   Var1$ = FileLine$
   Do
      Parse = InStr(Var1$, " ")
      If Parse Then
         Var1$ = Left$(Var1$, Parse - 1) + Mid$(Var1$, Parse + 1)
      Else
         Exit Do
      End If
   Loop
   FileLine$ = Var1$
   Return

   ' removes commas
   Remove.Commas:
   Var3$ = Setting$
   Do
      Var = InStr(Var3$, ",")
      If Var Then
         Var3$ = Left$(Var3$, Var - 1) + Mid$(Var3$, Var + 1)
      Else
         Exit Do
      End If
   Loop
   Return
End Sub

Sub GetConfigFilename (Filename$)
   ' search current path.
   File$ = _CWD$
   If Right$(File$, 1) <> "\" Then
      File$ = File$ + "\"
   End If
   Config.Filename$ = File$ + ConfigFile
   If _FileExists(Config.Filename$) Then
      Filename$ = Config.Filename$
      Exit Sub
   End If

   ' search environment path.
   File$ = Environ$("HEXEDIT")
   If Len(File$) Then
      File$ = RTrim$(File$)
      File$ = LTrim$(File$)
      If Left$(File$, 1) = Quote Then
         File$ = Mid$(File$, 2)
      End If
      If Right$(File$, 1) = Quote Then
         File$ = Left$(File$, Len(File$) - 1)
      End If
      If Right$(File$, 1) <> "\" Then
         File$ = File$ + "\"
      End If
      ASCIIZ = File$ + ConfigFile + Chr$(0)
      Call GetShortFilename(Config.Filename$)
      If Len(Config.Filename$) Then
         If _FileExists(Config.Filename$) Then
            Filename$ = Config.Filename$
            Exit Sub
         End If
      End If
   End If

   ' search path statement.
   Path$ = Environ$("PATH")
   If Len(Path$) Then
      Do
         ' parse path.
         Parse = InStr(Path$, ";")
         If Parse Then
            File$ = Left$(Path$, Parse - 1)
            Path$ = Mid$(Path$, Parse + 1)
         Else
            File$ = Path$
            Path$ = Nul
         End If

         ' store filename.
         File$ = RTrim$(File$)
         File$ = LTrim$(File$)
         If Len(File$) Then
            If Left$(File$, 1) = Quote Then
               File$ = Mid$(File$, 2)
            End If
            If Right$(File$, 1) = Quote Then
               File$ = Left$(File$, Len(File$) - 1)
            End If
            If Right$(File$, 1) <> "\" Then
               File$ = File$ + "\"
            End If
            ASCIIZ = File$ + ConfigFile + Chr$(0)
            Call GetShortFilename(Config.Filename$)
            If Len(Config.Filename$) Then
               If _FileExists(Config.Filename$) Then
                  Filename$ = Config.Filename$
                  Exit Sub
               End If
            End If
         End If
         If Path$ = Nul Then
            Exit Do
         End If
      Loop
   End If
   Exit Sub
End Sub

Rem Drop down menu subroutine:

Rem Returns: variable CurrentMenu equals 1 to 7, or 0 if exit,
Rem  variable CurrentMenuSelection is menu selection in CurrentMenu.

Sub DropDownMenu
   GoSub StoreArea
   GoSub DrawMenu
   GoSub DrawCurrentMenuSelection

   ' keyboard/mouse input loop.
   Do
      _Limit 100
      CharInput$ = Nul

      ' call mouse subroutine.
      Z = MouseDriver

      ' check left mouse button.
      If MouseButton1 Then
         GoSub MouseButton1X
      Else
         ' check right mouse button.
         If MouseButton2 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         Else
            ' check mouse position.
            If MouseX Or MouseY Then
               GoSub MoveMouse
            End If
         End If
      End If

      ' check mouse wheel.
      I$ = Nul
      If MouseWheel = -1 Then
         If WheelReverse Then
            I$ = Chr$(0) + Chr$(80) ' down
         Else
            I$ = Chr$(0) + Chr$(72) ' up
         End If
         MouseWheel = 0
      End If
      If MouseWheel = 1 Then
         If WheelReverse Then
            I$ = Chr$(0) + Chr$(72) ' up
         Else
            I$ = Chr$(0) + Chr$(80) ' down
         End If
         MouseWheel = 0
      End If

      ' store keyboard buffer.
      If I$ <> Nul Then
         CharInput$ = I$
      Else
         CharInput$ = INKEYx$
      End If
      If Len(CharInput$) Then
         Select Case Len(CharInput$)
            Case 1
               CharInput$ = UCase$(CharInput$)
               Select Case Asc(CharInput$)
                  Case 65 To 90 ' A - Z
                     Select Case CurrentMenu
                        Case 1
                           VarZ = InStr("OCAVTX", CharInput$)
                           If VarZ Then
                              GoSub RestoreArea
                              CurrentMenuSelection = VarZ
                              Exit Sub
                           End If
                        Case 2
                           VarZ = InStr("AH", CharInput$)
                           If VarZ Then
                              GoSub RestoreArea
                              CurrentMenuSelection = VarZ
                              Exit Sub
                           End If
                        Case 3
                           VarZ = InStr("SF", CharInput$)
                           If VarZ Then
                              GoSub RestoreArea
                              CurrentMenuSelection = VarZ
                              Exit Sub
                           End If
                        Case 4
                           VarZ = InStr("ASRUB", CharInput$)
                           If VarZ Then
                              GoSub RestoreArea
                              CurrentMenuSelection = VarZ
                              Exit Sub
                           End If
                        Case 5
                           VarZ = InStr("BP", CharInput$)
                           If VarZ Then
                              GoSub RestoreArea
                              CurrentMenuSelection = VarZ
                              Exit Sub
                           End If
                        Case 6
                           VarZ = InStr("SF", CharInput$)
                           If VarZ Then
                              GoSub RestoreArea
                              CurrentMenuSelection = VarZ
                              Exit Sub
                           End If
                        Case 7
                           VarZ = InStr("SB", CharInput$)
                           If VarZ Then
                              GoSub RestoreArea
                              CurrentMenuSelection = VarZ
                              Exit Sub
                           End If
                     End Select
                  Case 9 ' Tab
                     GoSub MenuRight
                  Case 13 ' Enter
                     GoSub RestoreArea
                     Exit Sub
                  Case 27 ' Escape
                     GoSub RestoreArea
                     CurrentMenu = False
                     Exit Sub
               End Select
            Case 2
               Select Case Asc(Right$(CharInput$, 1))
                  ' Up/Ctrl-Up/Alt-Up/Ctrl--/Alt-- = MoveUp
                  Case 72, 141, 152, 142, 74, 130
                     GoSub MenuUp
                     ' Down/Ctrl-Down/Alt-Down/Ctrl-+/Alt-= = MoveDown
                  Case 80, 145, 160, 144, 78, 131
                     GoSub MenuDown
                  Case 75, 15, 115, 155 ' Left/Shift-Tab/Ctrl-Left/Alt-Left
                     GoSub MenuLeft
                  Case 142, 74 ' Ctrl-Keypad-/Alt-Keypad-
                     GoSub MenuLeft
                  Case 77, 116, 157 ' Right/Ctrl-Right/Alt-Right
                     GoSub MenuRight
                  Case 144, 78 ' Ctrl-Keypad+/Alt-Keypad+
                     GoSub MenuRight
                  Case 71, 73, 119, 132 ' Home/PageUp/Ctrl-Home/Ctrl-PageUp
                     GoSub MenuFirst
                  Case 79, 81, 117, 118 ' End/PageDown/Ctrl-End/Ctrl-PageDown
                     GoSub MenuLast
               End Select
         End Select
      End If
   Loop
   Exit Sub

   ' moves to menu first left
   MenuFirst:
   If CurrentMenu <> 1 Then
      GoSub RestoreArea
      CurrentMenu = 1
      GoSub StoreArea
      GoSub DrawMenu
      GoSub DrawCurrentMenuSelection
   End If
   Return

   ' moves to menu last right
   MenuLast:
   If CurrentMenu <> 7 Then
      GoSub RestoreArea
      CurrentMenu = 7
      GoSub StoreArea
      GoSub DrawMenu
      GoSub DrawCurrentMenuSelection
   End If
   Return

   ' moves one menu left, wrapping.
   MenuLeft:
   GoSub RestoreArea
   If CurrentMenu = 1 Then
      CurrentMenu = 7
   Else
      CurrentMenu = CurrentMenu - 1
   End If
   GoSub StoreArea
   GoSub DrawMenu
   GoSub DrawCurrentMenuSelection
   Return

   ' moves one menu right, wrapping.
   MenuRight:
   GoSub RestoreArea
   If CurrentMenu = 7 Then
      CurrentMenu = 1
   Else
      CurrentMenu = CurrentMenu + 1
   End If
   GoSub StoreArea
   GoSub DrawMenu
   GoSub DrawCurrentMenuSelection
   Return

   ' moves menu up, wrapping.
   ' selects CurrentMenuSelection variable.
   MenuUp:
   Select Case CurrentMenu
      Case 1
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 1 Then
            CurrentMenuSelection = 6
         Else
            CurrentMenuSelection = CurrentMenuSelection - 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 2
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 1 Then
            CurrentMenuSelection = 2
         Else
            CurrentMenuSelection = CurrentMenuSelection - 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 3
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 1 Then
            CurrentMenuSelection = 2
         Else
            CurrentMenuSelection = CurrentMenuSelection - 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 4
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 1 Then
            CurrentMenuSelection = 5
         Else
            CurrentMenuSelection = CurrentMenuSelection - 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 5
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 1 Then
            CurrentMenuSelection = 2
         Else
            CurrentMenuSelection = CurrentMenuSelection - 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 6
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 1 Then
            CurrentMenuSelection = 2
         Else
            CurrentMenuSelection = CurrentMenuSelection - 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 7
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 1 Then
            CurrentMenuSelection = 2
         Else
            CurrentMenuSelection = CurrentMenuSelection - 1
         End If
         GoSub DrawCurrentMenuSelection
   End Select
   Return

   ' moves menu down, wrapping.
   ' selects CurrentMenuSelection variable.
   MenuDown:
   Select Case CurrentMenu
      Case 1
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 6 Then
            CurrentMenuSelection = 1
         Else
            CurrentMenuSelection = CurrentMenuSelection + 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 2
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 2 Then
            CurrentMenuSelection = 1
         Else
            CurrentMenuSelection = CurrentMenuSelection + 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 3
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 2 Then
            CurrentMenuSelection = 1
         Else
            CurrentMenuSelection = CurrentMenuSelection + 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 4
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 5 Then
            CurrentMenuSelection = 1
         Else
            CurrentMenuSelection = CurrentMenuSelection + 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 5
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 2 Then
            CurrentMenuSelection = 1
         Else
            CurrentMenuSelection = CurrentMenuSelection + 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 6
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 2 Then
            CurrentMenuSelection = 1
         Else
            CurrentMenuSelection = CurrentMenuSelection + 1
         End If
         GoSub DrawCurrentMenuSelection
      Case 7
         GoSub EraseCurrentMenuSelection
         If CurrentMenuSelection = 2 Then
            CurrentMenuSelection = 1
         Else
            CurrentMenuSelection = CurrentMenuSelection + 1
         End If
         GoSub DrawCurrentMenuSelection
   End Select
   Return

   ' removes hilight from current menu selection.
   EraseCurrentMenuSelection:
   Colorf2 White, 0
   SelectColor = 0
   GoSub DisplayCurrentMenuSelection
   Colorf2 White, 0
   Return

   ' adds hilight to current menu selection.
   DrawCurrentMenuSelection:
   Colorf2 White, 1
   SelectColor = 1
   GoSub DisplayCurrentMenuSelection
   Colorf2 White, 0
   Return

   ' draws current menu selection.
   DisplayCurrentMenuSelection:
   Select Case CurrentMenu
      Case 1
         Select Case CurrentMenuSelection
            Case 1
               Locatef 3, 7, 0
               Printf "Open New File  "
               Colorf2 Magenta, SelectColor
               Locatef 3, 7, 0
               Printf "O"
            Case 2
               Locatef 4, 7, 0
               Printf "Close File     "
               Colorf2 Magenta, SelectColor
               Locatef 4, 7, 0
               Printf "C"
            Case 3
               Locatef 5, 7, 0
               Printf "Close All Files"
               Colorf2 Magenta, SelectColor
               Locatef 5, 13, 0
               Printf "A"
            Case 4
               Locatef 6, 7, 0
               Printf "View Files     "
               Colorf2 Magenta, SelectColor
               Locatef 6, 7, 0
               Printf "V"
            Case 5
               Locatef 7, 7, 0
               Printf "Toggle Window  "
               Colorf2 Magenta, SelectColor
               Locatef 7, 7, 0
               Printf "T"
            Case 6
               Locatef 8, 7, 0
               Printf "Exit Program   "
               Colorf2 Magenta, SelectColor
               Locatef 8, 8, 0
               Printf "x"
         End Select
      Case 2
         Select Case CurrentMenuSelection
            Case 1
               Locatef 3, 17, 0
               Printf "ANSI Chart"
               Colorf2 Magenta, SelectColor
               Locatef 3, 17, 0
               Printf "A"
            Case 2
               Locatef 4, 17, 0
               Printf "HEX Chart "
               Colorf2 Magenta, SelectColor
               Locatef 4, 17, 0
               Printf "H"
         End Select
      Case 3
         Select Case CurrentMenuSelection
            Case 1
               Locatef 3, 27, 0
               Printf "HEX Screen Dump"
               Colorf2 Magenta, SelectColor
               Locatef 3, 31, 0
               Printf "S"
            Case 2
               Locatef 4, 27, 0
               Printf "HEX File Dump  "
               Colorf2 Magenta, SelectColor
               Locatef 4, 31, 0
               Printf "F"
         End Select
      Case 4
         Select Case CurrentMenuSelection
            Case 1
               Locatef 3, 37, 0
               Printf "Append Bytes       "
               Colorf2 Magenta, SelectColor
               Locatef 3, 37, 0
               Printf "A"
            Case 2
               Locatef 4, 37, 0
               Printf "Append ASCII String"
               Colorf2 Magenta, SelectColor
               Locatef 4, 50, 0
               Printf "S"
            Case 3
               Locatef 5, 37, 0
               Printf "Redraw Screen      "
               Colorf2 Magenta, SelectColor
               Locatef 5, 37, 0
               Printf "R"
            Case 4
               Locatef 6, 37, 0
               Printf "Undo Last Byte     "
               Colorf2 Magenta, SelectColor
               Locatef 6, 37, 0
               Printf "U"
            Case 5
               Locatef 7, 37, 0
               Printf "Undo All Bytes     "
               Colorf2 Magenta, SelectColor
               Locatef 7, 46, 0
               Printf "B"
         End Select
      Case 5
         Select Case CurrentMenuSelection
            Case 1
               Locatef 3, 47, 0
               Printf "Jump To Byte"
               Colorf2 Magenta, SelectColor
               Locatef 3, 55, 0
               Printf "B"
            Case 2
               Locatef 4, 47, 0
               Printf "Jump To Page"
               Colorf2 Magenta, SelectColor
               Locatef 4, 55, 0
               Printf "P"
         End Select
      Case 6
         Select Case CurrentMenuSelection
            Case 1
               Locatef 3, 57, 0
               Printf "HEX Screen Print"
               Colorf2 Magenta, SelectColor
               Locatef 3, 61, 0
               Printf "S"
            Case 2
               Locatef 4, 57, 0
               Printf "HEX File Print  "
               Colorf2 Magenta, SelectColor
               Locatef 4, 61, 0
               Printf "F"
         End Select
      Case 7
         Select Case CurrentMenuSelection
            Case 1
               Locatef 3, 65, 0
               Printf "Search String"
               Colorf2 Magenta, SelectColor
               Locatef 3, 72, 0
               Printf "S"
            Case 2
               Locatef 4, 65, 0
               Printf "Search Bytes "
               Colorf2 Magenta, SelectColor
               Locatef 4, 72, 0
               Printf "B"
         End Select
   End Select
   Return

   ' draws menu.
   DrawMenu:
   CurrentMenuSelection = 1
   GoSub BoxBorder
   BoxDrawX1 = Xstore1
   BoxDrawX2 = Xstore2
   BoxDrawY1 = Ystore1
   BoxDrawY2 = Ystore2
   Select Case CurrentMenu
      Case 1
         BoxDrawLength = 17
         GoSub DrawBox
         Colorf White
         Locatef 3, 7, 0
         Printf "Open New File  "
         Locatef 4, 7, 0
         Printf "Close File     "
         Locatef 5, 7, 0
         Printf "Close All Files"
         Locatef 6, 7, 0
         Printf "View Files     "
         Locatef 7, 7, 0
         Printf "Toggle Window  "
         Locatef 8, 7, 0
         Printf "Exit Program   "
         Colorf Magenta
         Locatef 3, 7, 0
         Printf "O"
         Locatef 4, 7, 0
         Printf "C"
         Locatef 5, 13, 0
         Printf "A"
         Locatef 6, 7, 0
         Printf "V"
         Locatef 7, 7, 0
         Printf "T"
         Locatef 8, 8, 0
         Printf "x"
      Case 2
         BoxDrawLength = 12
         GoSub DrawBox
         Colorf White
         Locatef 3, 17, 0
         Printf "ANSI Chart"
         Locatef 4, 17, 0
         Printf "HEX Chart "
         Colorf Magenta
         Locatef 3, 17, 0
         Printf "A"
         Locatef 4, 17, 0
         Printf "H"
      Case 3
         BoxDrawLength = 17
         GoSub DrawBox
         Colorf White
         Locatef 3, 27, 0
         Printf "HEX Screen Dump"
         Locatef 4, 27, 0
         Printf "HEX File Dump  "
         Colorf Magenta
         Locatef 3, 31, 0
         Printf "S"
         Locatef 4, 31, 0
         Printf "F"
      Case 4
         BoxDrawLength = 21
         GoSub DrawBox
         Colorf White
         Locatef 3, 37, 0
         Printf "Append Bytes       "
         Locatef 4, 37, 0
         Printf "Append ASCII String"
         Locatef 5, 37, 0
         Printf "Redraw Screen      "
         Locatef 6, 37, 0
         Printf "Undo Last Byte     "
         Locatef 7, 37, 0
         Printf "Undo All Bytes     "
         Colorf Magenta
         Locatef 3, 37, 0
         Printf "A"
         Locatef 4, 50, 0
         Printf "S"
         Locatef 5, 37, 0
         Printf "R"
         Locatef 6, 37, 0
         Printf "U"
         Locatef 7, 46, 0
         Printf "B"
      Case 5
         BoxDrawLength = 14
         GoSub DrawBox
         Colorf White
         Locatef 3, 47, 0
         Printf "Jump To Byte"
         Locatef 4, 47, 0
         Printf "Jump To Page"
         Colorf Magenta
         Locatef 3, 55, 0
         Printf "B"
         Locatef 4, 55, 0
         Printf "P"
      Case 6
         BoxDrawLength = 18
         GoSub DrawBox
         Colorf White
         Locatef 3, 57, 0
         Printf "HEX Screen Print"
         Locatef 4, 57, 0
         Printf "HEX File Print  "
         Colorf Magenta
         Locatef 3, 61, 0
         Printf "S"
         Locatef 4, 61, 0
         Printf "F"
      Case 7
         BoxDrawLength = 15
         GoSub DrawBox
         Colorf White
         Locatef 3, 65, 0
         Printf "Search String"
         Locatef 4, 65, 0
         Printf "Search Bytes "
         Colorf Magenta
         Locatef 3, 72, 0
         Printf "S"
         Locatef 4, 72, 0
         Printf "B"
   End Select
   Return

   ' stores area under menu.
   StoreArea:
   If CurrentMenu = False Then
      Return
   End If
   GoSub BoxBorder
   RowX1 = 0
   ColumnY1 = 0
   For RowX2 = Xstore1 To Xstore2
      RowX1 = RowX1 + 1
      ColumnY1 = 0
      For ColumnY2 = Ystore1 To Ystore2
         ColumnY1 = ColumnY1 + 1
         ' store ascii character.
         Area1(RowX1, ColumnY1) = Screen(RowX2, ColumnY2)
         ' store color. (undocumented: also stores background color).
         Area2(RowX1, ColumnY1) = Screen(RowX2, ColumnY2, 1)
      Next
   Next
   ' hilight menu tab.
   Colorf2 White, 1
   Call DisplayTab(CurrentMenu)
   Return

   ' restores area under menu.
   RestoreArea:
   If CurrentMenu = False Then
      Return
   End If
   GoSub BoxBorder
   RowX1 = 0
   ColumnY1 = 0
   For RowX2 = Xstore1 To Xstore2
      RowX1 = RowX1 + 1
      ColumnY1 = 0
      For ColumnY2 = Ystore1 To Ystore2
         ColumnY1 = ColumnY1 + 1
         Locatef RowX2, ColumnY2, 1
         ' restore color.
         TempZ = Area2(RowX1, ColumnY1)
         ' undocumented: also stores background color.
         VarB = Int(TempZ / 16)
         VarF = TempZ Mod 16
         Colorf2 VarF, VarB
         ' restore ascii character.
         Printf Chr$(Area1(RowX1, ColumnY1))
      Next
   Next
   ' remove hilight menu tab.
   Colorf2 White, 0
   Call DisplayTab(CurrentMenu)
   Return

   ' returns borders of box.
   BoxBorder:
   Select Case CurrentMenu
      Case 1
         Xstore1 = 2
         Xstore2 = 9
         Ystore1 = 6
         Ystore2 = 22
      Case 2
         Xstore1 = 2
         Xstore2 = 5
         Ystore1 = 16
         Ystore2 = 27
      Case 3
         Xstore1 = 2
         Xstore2 = 5
         Ystore1 = 26
         Ystore2 = 42
      Case 4
         Xstore1 = 2
         Xstore2 = 8
         Ystore1 = 36
         Ystore2 = 56
      Case 5
         Xstore1 = 2
         Xstore2 = 5
         Ystore1 = 46
         Ystore2 = 59
      Case 6
         Xstore1 = 2
         Xstore2 = 5
         Ystore1 = 56
         Ystore2 = 73
      Case 7
         Xstore1 = 2
         Xstore2 = 5
         Ystore1 = 64
         Ystore2 = 78
   End Select
   Return

   ' draws box from (BoxDrawX1,BoxDrawY1) To (BoxDrawX2,BoxDrawY2),
   '  length of box from left to right being BoxDrawLength.
   DrawBox:
   Colorf Yellow
   Locatef BoxDrawX1, BoxDrawY1, 0
   Printf Chr$(ULcorner) + String$(BoxDrawLength - 2, Hline) + Chr$(URcorner)
   For RowX1 = BoxDrawX1 + 1 To BoxDrawX2 - 1
      Locatef RowX1, BoxDrawY1, 0
      Printf Chr$(Vline)
      Locatef RowX1, BoxDrawY2, 0
      Printf Chr$(Vline)
   Next
   Locatef BoxDrawX2, BoxDrawY1, 0
   Printf Chr$(LLcorner) + String$(BoxDrawLength - 2, Hline) + Chr$(LRcorner)
   Return

   ' process mouse move.
   MoveMouse:
   ' select drop down menu.
   If MouseX = 1 Then
      NewMenuSelection = False
      Select Case MouseY
         Case 6 To 9 ' File
            NewMenuSelection = 1
         Case 16 To 21 ' Charts
            NewMenuSelection = 2
         Case 26 To 29 ' Dump
            NewMenuSelection = 3
         Case 36 To 39 ' Edit
            NewMenuSelection = 4
         Case 46 To 49 ' Jump
            NewMenuSelection = 5
         Case 56 To 60 ' Print
            NewMenuSelection = 6
         Case 64 To 69 ' Search
            NewMenuSelection = 7
      End Select
      If NewMenuSelection > False Then
         If NewMenuSelection <> CurrentMenu Then
            If CurrentMenu > False Then
               GoSub RestoreArea
            End If
            CurrentMenu = NewMenuSelection
            CurrentMenuSelection = 1
            GoSub StoreArea
            GoSub DrawMenu
            GoSub DrawCurrentMenuSelection
         End If
      End If
      If CurrentMenu > False Then
         Colorf2 White, 1
         Call DisplayTab(CurrentMenu)
      End If
      Return
   End If
   ' check mouse selection boundaries.
   Select Case CurrentMenu
      Case 1
         If MouseX >= 3 And MouseX <= 8 Then
            If MouseY >= 7 And MouseY <= 21 Then
               If MouseX - 2 <> CurrentMenuSelection Then
                  GoSub EraseCurrentMenuSelection
                  CurrentMenuSelection = MouseX - 2
               End If
               GoSub DrawCurrentMenuSelection
            End If
         End If
      Case 2
         If MouseX >= 3 And MouseX <= 4 Then
            If MouseY >= 17 And MouseY <= 26 Then
               If MouseX - 2 <> CurrentMenuSelection Then
                  GoSub EraseCurrentMenuSelection
                  CurrentMenuSelection = MouseX - 2
               End If
               GoSub DrawCurrentMenuSelection
            End If
         End If
      Case 3
         If MouseX >= 3 And MouseX <= 4 Then
            If MouseY >= 27 And MouseY <= 41 Then
               If MouseX - 2 <> CurrentMenuSelection Then
                  GoSub EraseCurrentMenuSelection
                  CurrentMenuSelection = MouseX - 2
               End If
               GoSub DrawCurrentMenuSelection
            End If
         End If
      Case 4
         If MouseX >= 3 And MouseX <= 7 Then
            If MouseY >= 37 And MouseY <= 55 Then
               If MouseX - 2 <> CurrentMenuSelection Then
                  GoSub EraseCurrentMenuSelection
                  CurrentMenuSelection = MouseX - 2
               End If
               GoSub DrawCurrentMenuSelection
            End If
         End If
      Case 5
         If MouseX >= 3 And MouseX <= 5 Then
            If MouseY >= 47 And MouseY <= 58 Then
               If MouseX - 2 <> CurrentMenuSelection Then
                  GoSub EraseCurrentMenuSelection
                  CurrentMenuSelection = MouseX - 2
               End If
               GoSub DrawCurrentMenuSelection
            End If
         End If
      Case 6
         If MouseX >= 3 And MouseX <= 5 Then
            If MouseY >= 57 And MouseY <= 72 Then
               If MouseX - 2 <> CurrentMenuSelection Then
                  GoSub EraseCurrentMenuSelection
                  CurrentMenuSelection = MouseX - 2
               End If
               GoSub DrawCurrentMenuSelection
            End If
         End If
      Case 7
         If MouseX >= 3 And MouseX <= 5 Then
            If MouseY >= 65 And MouseY <= 77 Then
               If MouseX - 2 <> CurrentMenuSelection Then
                  GoSub EraseCurrentMenuSelection
                  CurrentMenuSelection = MouseX - 2
               End If
               GoSub DrawCurrentMenuSelection
            End If
         End If
   End Select
   Return

   ' process left mouse button.
   MouseButton1X:

   ' test mouse click above menu and clear.
   If MouseX = 1 Then
      GoSub RestoreArea
      CurrentMenu = False
      Exit Sub
   End If

   ' test mouse click below menu and clear.
   Select Case CurrentMenu
      Case 1
         If MouseX > 9 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         End If
      Case 2
         If MouseX > 5 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         End If
      Case 3
         If MouseX > 5 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         End If
      Case 4
         If MouseX > 8 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         End If
      Case 5
         If MouseX > 6 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         End If
      Case 6
         If MouseX > 6 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         End If
      Case 7
         If MouseX > 6 Then
            GoSub RestoreArea
            CurrentMenu = False
            Exit Sub
         End If
   End Select

   ' test mouse click outside edges of menu.
   If MouseX > 1 Then
      Select Case CurrentMenu
         Case 1
            If MouseY < 6 Or MouseY > 22 Then
               GoSub RestoreArea
               CurrentMenu = False
               Exit Sub
            End If
         Case 2
            If MouseY < 16 Or MouseY > 27 Then
               GoSub RestoreArea
               CurrentMenu = False
               Exit Sub
            End If
         Case 3
            If MouseY < 26 Or MouseY > 42 Then
               GoSub RestoreArea
               CurrentMenu = False
               Exit Sub
            End If
         Case 4
            If MouseY < 36 Or MouseY > 56 Then
               GoSub RestoreArea
               CurrentMenu = False
               Exit Sub
            End If
         Case 5
            If MouseY < 46 Or MouseY > 59 Then
               GoSub RestoreArea
               CurrentMenu = False
               Exit Sub
            End If
         Case 6
            If MouseY < 56 Or MouseY > 73 Then
               GoSub RestoreArea
               CurrentMenu = False
               Exit Sub
            End If
         Case 7
            If MouseY < 66 Or MouseY > 78 Then
               GoSub RestoreArea
               CurrentMenu = False
               Exit Sub
            End If
      End Select
   End If

   ' test mouse click withhin menu.
   If MouseX - 2 = CurrentMenuSelection Then
      Select Case CurrentMenu
         Case 1
            If MouseY >= 7 And MouseY <= 21 Then
               GoSub RestoreArea
               Exit Sub
            End If
         Case 2
            If MouseY >= 17 And MouseY <= 26 Then
               GoSub RestoreArea
               Exit Sub
            End If
         Case 3
            If MouseY >= 27 And MouseY <= 41 Then
               GoSub RestoreArea
               Exit Sub
            End If
         Case 4
            If MouseY >= 37 And MouseY <= 55 Then
               GoSub RestoreArea
               Exit Sub
            End If
         Case 5
            If MouseY >= 47 And MouseY <= 58 Then
               GoSub RestoreArea
               Exit Sub
            End If
         Case 6
            If MouseY >= 57 And MouseY <= 72 Then
               GoSub RestoreArea
               Exit Sub
            End If
         Case 7
            If MouseY >= 65 And MouseY <= 77 Then
               GoSub RestoreArea
               Exit Sub
            End If
      End Select
   End If
   Return
End Sub

' inits mouse.
Sub ClearMouse
   While _MouseInput: Wend ' empty buffer
End Sub

Rem Deconcatenates a filename to a specified length
Rem  with imbedded \..\ character strings.
Rem
Rem Input:
Rem   Y$ - Netpath (full path)
Rem   Z$ - DosPath (ambiguated)
Rem   Z% - Length (32-64)
Rem
Rem Returns:
Rem   Z$ - Concatenated path
Rem     C:\path\..\path\
Rem   or,
Rem     For remote or default server:
Rem       \\server name\share name\path\..\path\

Sub Deconcatenate (Y$, Z$, Z%)
   Y$ = UCase$(Y$)
   Z$ = UCase$(Z$)
   ' check netpath.
   If Len(Y$) Then
      ' store net path.
      Y1$ = UCase$(Y$)
      If Right$(Y1$, 1) <> "\" Then
         Y1$ = Y1$ + "\"
      End If

      ' check default net path.
      If RTrim$(DefaultNetPath) <> Nul Then

         ' store default netpath.
         Z1$ = "\\" + UCase$(RTrim$(DefaultNetPath)) + "\"

         ' check netpath is in default path.
         If Left$(Y1$, Len(Z1$)) = Z1$ Then

            ' ambiguate netpath.
            ASCIIZ3 = ASCIIZ
            ASCIIZ = Y1$ + Chr$(0)
            Call GetShortFilename(Short.Filename$)
            ASCIIZ = ASCIIZ3

            ' store ambiguated netpath.
            N1$ = Short.Filename$
         End If
      End If
      If N1$ = Nul Then
         N1$ = Y1$
      End If
      N1$ = UCase$(N1$)

      ' truncate drive letter.
      If Mid$(N1$, 2, 1) = ":" Then
         N1$ = Mid$(N1$, 3)
      End If

      ' truncate netpath from dospath.
      If Left$(Z$, Len(N1$)) = N1$ Then
         Z$ = Mid$(Z$, Len(N1$) + 1)
      End If

      ' get ending position of server name.
      Y2 = InStr(3, Y1$, "\")

      ' get ending position of share name.
      Y3 = InStr(Y2 + 1, Y1$, "\")

      ' get server\share name.
      Y1$ = Left$(Y1$, Y3)
   End If

   ' check path
   If InStr(Z$, "\") = False Then
      If Len(Y$) Then
         Z$ = Y1$ + Z$
      End If
      If Len(Z$) > Z% Then
         Z$ = Left$(Z$, Z% - 3) + "..."
      End If
      Exit Sub
   End If

   ' decrement length of netpath
   Z1% = Z%
   If Len(Y1$) Then
      Z1% = Z1% - Len(Y1$)
      If Z1% <= 0 Then
         Z$ = Left$(Y1$, Z% - 3) + "..."
         Exit Sub
      End If
      Z1% = Z1% + 1
   End If

   ' deconcatenate path
   If Y$ <> Nul Then
      If Left$(Z$, 1) <> "\" Then
         Z$ = "\" + Z$
      End If
   End If
   Do
      If Len(Z$) > Z1% Then
         V1 = InStr(Z$, "\")
         If V1 > 0 Then
            Do
               If Mid$(Z$, V1, 4) = "\..\" Then
                  V1 = InStr(V1 + 1, Z$, "\")
               Else
                  Exit Do
               End If
            Loop
            V2 = InStr(V1 + 1, Z$, "\")
            If V2 > 0 Then
               Z$ = Left$(Z$, V1) + ".." + Mid$(Z$, V2)
            Else
               Exit Do
            End If
         End If
      Else
         Exit Do
      End If
      ' remove redundant paths
      Do
         V = InStr(Z$, "\..\..\")
         If V > 0 Then
            Z$ = Left$(Z$, V - 1) + "\..\" + Mid$(Z$, V + 7)
         Else
            Exit Do
         End If
      Loop
   Loop

   ' remove redundant paths
   Do
      V = InStr(Z$, "\..\..\")
      If V > 0 Then
         Z$ = Left$(Z$, V - 1) + "\..\" + Mid$(Z$, V + 7)
      Else
         Exit Do
      End If
   Loop

   ' prepend net path
   If Len(Y1$) Then
      If Z$ = "\" Then
         Z$ = Y1$
      Else
         If Left$(Z$, 2) = "\\" Then
            N1$ = Z$
         Else
            If Left$(Z$, 1) = "\" Then
               Z$ = Y1$ + Mid$(Z$, 2)
            Else
               Z$ = Y1$ + Z$
            End If
         End If
      End If
   End If

   ' deconcat \\
   If Left$(Z$, 2) = "\\" Then ParseNet = -1
   Do
      If InStr(Z$, "\\") Then
         Z$ = Left$(Z$, InStr(Z$, "\\")) + Mid$(Z$, InStr(Z$, "\\") + 2)
      Else
         Exit Do
      End If
   Loop
   If ParseNet Then Z$ = "\" + Z$

   ' truncate to length
   If Len(Z$) > Z% Then
      Z$ = Left$(Z$, Z% - 3) + "..."
   End If
End Sub

' initialize directory/filename record.
Sub OpenDataFiles1
   V1$ = DRX + "HEXEDIT1.DA" + Mid$(Str$(Process.Number), 2)
   V2$ = DRX + "HEXEDIT2.DA" + Mid$(Str$(Process.Number), 2)
   MultiFilename1(4) = Nul
   MultiFilename1(5) = Nul
   Close #2, #3
   ' open filename random record structure for windows.
   Open V1$ For Random As #2 Len = Len(WinFileStruc)
   ' open directory random record structure for windows.
   Open V2$ For Random As #3 Len = Len(WinFileStruc)
   MultiFilename1(4) = V1$
   MultiFilename1(5) = V2$
End Sub

' redraws menu tab.
Sub DisplayTab (Var)
   Select Case Var
      Case 1 ' File
         Locatef 1, 6, 0
         Printf "File"
      Case 2 ' Charts
         Locatef 1, 16, 0
         Printf "Charts"
      Case 3 ' Dump
         Locatef 1, 26, 0
         Printf "Dump"
      Case 4 ' Edit
         Locatef 1, 36, 0
         Printf "Edit"
      Case 5 ' Jump
         Locatef 1, 46, 0
         Printf "Jump"
      Case 6 ' Print
         Locatef 1, 56, 0
         Printf "Print"
      Case 7 ' Search
         Locatef 1, 64, 0
         Printf "Search"
   End Select
   Colorf2 White, 0
End Sub

' display error trap message.
Sub DisplayCriticalError (Var)
   Select Case Var
      Case 5
         ' Ctrl-E TestError w/ debug will display
         '   syntax error for debug purposes.

         Printf "Syntax error"
      Case 6
         Printf "Overflow"
      Case 9
         Printf "Subscript out of range"
      Case 14
         Printf "Out of string space"
      Case 24
         Printf "Device timeout"
      Case 25
         Printf "Device fault"
      Case 27
         Printf "Out of paper"
      Case 52
         Printf "Bad file name or number"
      Case 53
         Printf "File not found"
      Case 54
         Printf "Bad file mode"
      Case 55
         Printf "File already open"
      Case 57
         Printf "Device I/O error"
      Case 58
         Printf "File already exists"
      Case 59
         Printf "Bad record length"
      Case 61
         Printf "Disk full"
      Case 62
         Printf "Input past eof"
      Case 63
         Printf "Bad record length"
      Case 64
         Printf "Bad file name"
      Case 67
         Printf "Not enough file handles"
      Case 68
         Printf "Device unavailable"
      Case 70
         Printf "Permission denied"
      Case 71
         Printf "Disk not ready"
      Case 72
         Printf "Disk-media error"
      Case 75
         Printf "Path/File access error"
      Case 76
         Printf "Pathname not found"
      Case 81
         Printf "Invalid name"
      Case 90
         Printf "Too many processes"
      Case Else
         Printf "Untrapped error" + Str$(Var)
   End Select
End Sub

' construct file/dir exclusion list.
Sub ExcludeList (V1, Y$)
   If V1 = 1 Then
      Locatef Xcoor + 1, Ycoor + 2, 1
      Printf Space$(38)
      Locatef Xcoor + 1, Ycoor + 2, 1
      Colorf2 White, 0
      Printf "Enter file spec: "
      Y$ = LineInput$(Xcoor + 1, Ycoor + 19, 21)
   Else
      Locatef Xcoor + 1, Ycoor + 2, 1
      Printf Space$(38)
      Locatef Xcoor + 1, Ycoor + 2, 1
      Colorf2 White, 0
      Printf "Enter dir spec: "
      Y$ = LineInput$(Xcoor + 1, Ycoor + 18, 22)
   End If
   If Len(Y$) Then
      ' process filelist filename.
      Filename2$ = FILELISTEXISTS(Y$)
      If Len(Filename2$) Then
         Y$ = Nul

         ' open filelist filename.
         Check.Disk = True
         Disk.Ready = False
         x2 = FreeFile
         Open Filename2$ For Input As #x2
         Check.Disk = False
         If Disk.Ready Then
            Locatef Xcoor + 1, Ycoor + 2, 1
            Printf Space$(38)
            Locatef Xcoor + 1, Ycoor + 2, 1
            Colorf2 White, 0
            Printf "Filelist not found. Press <esc>:"
            Call PromptInkey
            Exit Sub
         End If
         Do Until EOF(x2)
            Line Input #x2, Y1$
            Y1$ = LTrim$(Y1$)
            Y1$ = RTrim$(Y1$)
            Y1$ = UCase$(Y1$)
            If Len(Y1$) Then
               If Left$(Y1$, 1) = Quote Then
                  Y1$ = Mid$(Y1$, 2)
                  If Right$(Y1$, 1) = Quote Then
                     Y1$ = Left$(Y1$, Len(Y1$) - 1)
                  End If
               End If
               If Len(Y1$) Then
                  If InStr(Y1$, " ") = False Then
                     ' add excluded filename.
                     Y$ = Y$ + Y1$ + " "
                     If Len(Y$) > 4096 Then
                        Y$ = Nul
                        Exit Do
                     End If
                  End If
               End If
            End If
         Loop
         Close #x2
         Locatef Xcoor + 1, Ycoor + 2, 1
         Printf Space$(38)
         Locatef Xcoor + 1, Ycoor + 2, 1
         Colorf2 White, 0
         If Len(Y$) Then
            Printf "Filelist loaded. Press <esc>:"
         Else
            Printf "Filelist not loaded. Press <esc>:"
         End If
         Call PromptInkey
      End If
   End If
   Y$ = LTrim$(Y$)
   Y$ = RTrim$(Y$)
End Sub

' display screen border.
Sub DisplayScreen2
   Cls
   Colorf Magenta
   Printf Chr$(ULcorner) + String$(76, Hline) + Chr$(URcorner)
   For Var2 = 2 To 23
      Locatef Var2, 1, 0
      Printf Chr$(Vline)
      Locatef Var2, 78, 0
      Printf Chr$(Vline)
   Next
   Locatef 24, 1, 0
   Printf Chr$(LLcorner) + String$(76, Hline) + Chr$(LRcorner)
   Colorf Plain
End Sub

' display boot usage.
Sub DisplayBootUsage
   Cls
   Colorf White
   Locatef 1, 1, 0
   Printf "Hex Editor " + Version + " " + Release + "."
   Colorf Green
   Locatef 2, 1, 0
   Printf "Command Usage:"
   Colorf Yellow
   Locatef 3, 1, 0
   Printf "   Hexedit [@]<filename.ext>, [@]<filename.ext>, ..."
   Colorf Green
   Locatef 4, 1, 0
   Printf "Where:"
   Colorf Yellow
   Locatef 5, 1, 0
   Printf "   <filename.ext> is the file to edit. May include drive/pathname. Also"
   Locatef 6, 1, 0
   Printf "   supports long filenames in quotes. Filename may be omitted. Multiple"
   Locatef 7, 1, 0
   Printf "   files allowed with * and ? characters. Maximum of 9 files available."
   Locatef 8, 1, 0
   Printf "   Filename prepended with @ loads filelist from contents of text file."
   Locatef 9, 1, 0
   Printf "   May also contain server and share name if prepended as \\server\share\"
   Locatef 10, 1, 0
   Printf "   Switches: /n is node, and /f override file menu box."
   Colorf Green
   Locatef 11, 1, 0
   Printf "Example:"
   Colorf Yellow
   Locatef 12, 1, 0
   Printf "   Hexedit \dos\page.com"
   Locatef 13, 1, 0
   Printf "   Or use the file menu box by starting Hexedit without a filename."
   Colorf Green
   Locatef 14, 1, 0
   Printf "File Menu Box Usage:"
   Colorf Yellow
   Locatef 15, 1, 0
   Printf "   Navigate using cursors, selecting with <enter>, and switch windows"
   Locatef 16, 1, 0
   Printf "   with <tab> and Shift-<tab>. Exits to editor or DOS with <escape>."
   Colorf Green
   Locatef 17, 1, 0
   Printf "File Editor Usage:"
   Colorf Yellow
   Locatef 18, 1, 0
   Printf "   Enter editing functions or cursor movement through the hex values,"
   Locatef 19, 1, 0
   Printf "   while changing them with <enter>, <delete> or <insert> as you edit."
   Colorf Green
   Locatef 20, 1, 0
   Printf "Author status:"
   Colorf Yellow
   Locatef 21, 1, 0
   Printf "   Written by: " + Author$
   Locatef 22, 1, 0
   Printf "   Email: " + Email
   Locatef 23, 1, 0
   Printf "   Urls: " + Urls
   Locatef 24, 1, 0
   Printf ""
End Sub

' display main program editing screen.
Sub DisplayScreen
   Cls
   Colorf Magenta
   Locatef 1, 1, 0
   Printf " " + Chr$(ULcorner)
   Printf String$(3, Hline)
   Colorf White
   Printf "File"
   Colorf Magenta
   Printf String$(6, Hline)
   Colorf White
   Printf "Charts"
   Colorf Magenta
   Printf String$(4, Hline)
   Colorf White
   Printf "Dump"
   Colorf Magenta
   Printf String$(6, Hline)
   Colorf White
   Printf "Edit"
   Colorf Magenta
   Printf String$(6, Hline)
   Colorf White
   Printf "Jump"
   Colorf Magenta
   Printf String$(6, Hline)
   Colorf White
   Printf "Print"
   Colorf Magenta
   Printf String$(3, Hline)
   Colorf White
   Printf "Search"
   Colorf Magenta
   Printf Chr$(Hline) + Chr$(Hline)
   Colorf Yellow
   Printf Version
   Colorf Magenta
   Printf String$(1, Hline)
   Printf Chr$(URcorner)
   Locatef 2, 1, 0
   Printf " " + Chr$(Vline) + String$(75, 32) + Chr$(Vline)
   Locatef 3, 1, 0
   Printf " " + Chr$(Vline) + " "
   Colorf Green
   Printf Chr$(ULcorner) + String$(46, Hline) + Chr$(URcorner) + " "
   Printf Chr$(ULcorner) + String$(22, Hline) + Chr$(URcorner)
   Colorf White
   Printf "x"
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 4, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "0"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline)
   Colorf White
   Printf "<"
   Colorf Green
   Printf Chr$(Vline) + String$(22, 32) + Chr$(Vline)
   Colorf White
   Printf "?"
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 5, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "1"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline)
   Colorf White
   Printf "|"
   Colorf Green
   Printf Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 6, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "2"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 7, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "3"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 8, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "4"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 9, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "5"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 10, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "6"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 11, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "7"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 12, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "8"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 13, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "9"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 14, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "A"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 15, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "B"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 16, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "C"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 17, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "D"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 18, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "E"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline) + " " + Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 19, 1, 0
   Printf " " + Chr$(Vline)
   Colorf White
   Printf "F"
   Colorf Green
   Printf Chr$(Vline) + String$(46, 32) + Chr$(Vline)
   Colorf White
   Printf "|"
   Colorf Green
   Printf Chr$(Vline) + String$(22, 32) + Chr$(Vline) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 20, 1, 0
   Printf " " + Chr$(Vline) + " "
   Colorf Green
   Printf Chr$(LLcorner) + String$(46, Hline) + Chr$(LRcorner)
   Colorf White
   Printf ">"
   Colorf Green
   Printf Chr$(LLcorner) + String$(22, Hline) + Chr$(LRcorner) + " "
   Colorf Magenta
   Printf Chr$(Vline)
   ' check to skip info line area.
   If ScreenRow Then
      Colorf Magenta
      Locatef 21, 1, 0
      Printf " " + Chr$(LLcorner) + String$(75, Hline) + Chr$(LRcorner)
      Colorf Plain
      Exit Sub
   End If
   Locatef 21, 1, 0
   Printf " " + Chr$(Vline)
   Colorf Yellow
   Printf " Alt-A Append bytes, Alt-M Append string, Alt-C ANSI Chart, Alt-N New File "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 22, 1, 0
   Printf " " + Chr$(Vline)
   Colorf Yellow
   Printf " Alt-H HEX Chart, Alt-R Redraw, Alt-S Search bytes, Alt-U Undo, Alt-X Exit "
   Colorf Magenta
   Printf Chr$(Vline)
   Locatef 23, 1, 0
   Printf " " + Chr$(Vline)
   Colorf Yellow
   Printf " Alt-J Jump, Alt-K Search string, Alt-D Dump, Alt-P Print, Alt-Z Undo All. "
   Colorf Magenta
   Printf Chr$(Vline)
   Colorf Magenta
   Locatef 24, 1, 0
   Printf " " + Chr$(LLcorner) + String$(75, Hline) + Chr$(LRcorner)
   Colorf Plain
End Sub

Rem Help/main screens for main menu and file menu.
Rem Ansi/Hex Charts and Print subroutines.
Rem Screen/File Dump and Print subroutines.
Rem Clipboard and ViewFile subroutines.

Rem File/directory sort subroutines.
Rem GetInfo subroutine for Attribute, Date/Time, FileSize.
Rem GetDriveInfo subroutine.
Rem DriveExists function.
Rem NetPathExists function.
Rem SearchFile subroutine.

Rem File box main menu.

Sub FileMainMenu
   Colorf2 White, BackGround
   Cls
   Locatef Xcoor, Ycoor, 0
   Colorf2 White, 0
   Colorf Yellow
   Printf Chr$(ULcorner) + String$(10, Hline)
   Colorf Green
   Printf "(<esc>=Quit,F9=Help)"
   Colorf Yellow
   Printf String$(9, Hline) + Chr$(URcorner)
   Locatef Xcoor + 1, Ycoor, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "Filename:"
   Colorf Yellow
   Printf Space$(29) + Chr$(Vline)
   Locatef Xcoor + 2, Ycoor, 0
   Printf Chr$(Vline) + Space$(39) + Chr$(Vline)
   Locatef Xcoor + 3, Ycoor, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "Files:          Dirs:          Drives:"
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor + 4, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(ULcorner) + String$(12, Hline) + Chr$(URcorner) + "  "
   Printf Chr$(ULcorner) + String$(12, Hline) + Chr$(URcorner) + "  "
   Printf Chr$(ULcorner) + String$(3, Hline) + Chr$(URcorner) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 5, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 6, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 7, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 8, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 9, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 10, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 11, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 12, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 13, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 14, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(12) + Chr$(Vline) + "  "
   Printf Chr$(Vline) + Space$(3) + Chr$(Vline) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Colorf Yellow
   Locatef Xcoor + 15, Ycoor, 0
   Printf Chr$(Vline)
   Colorf Magenta
   Printf " " + Chr$(LLcorner) + String$(12, Hline) + Chr$(LRcorner) + "  "
   Printf Chr$(LLcorner) + String$(12, Hline) + Chr$(LRcorner) + "  "
   Printf Chr$(LLcorner) + String$(3, Hline) + Chr$(LRcorner) + " "
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor + 16, Ycoor, 0
   Printf Chr$(LLcorner) + String$(39, Hline) + Chr$(LRcorner)
   Colorf White
   ' make file input box mouse symbols.
   Locatef Xcoor + 4, Ycoor + 16, 0
   Printf "<"
   Locatef Xcoor + 5, Ycoor + 16, 0
   Printf "|"
   Locatef Xcoor + 14, Ycoor + 16, 0
   Printf "|"
   Locatef Xcoor + 15, Ycoor + 16, 0
   Printf ">"
   ' make directory input box mouse symbols.
   Locatef Xcoor + 4, Ycoor + 32, 0
   Printf "<"
   Locatef Xcoor + 5, Ycoor + 32, 0
   Printf "|"
   Locatef Xcoor + 14, Ycoor + 32, 0
   Printf "|"
   Locatef Xcoor + 15, Ycoor + 32, 0
   Printf ">"
   ' make drive input box mouse symbols.
   Locatef Xcoor + 5, Ycoor + 39, 0
   Printf "|"
   Locatef Xcoor + 14, Ycoor + 39, 0
   Printf "|"
   ' make file menu box question symbol.
   Locatef Xcoor, Ycoor + 39, 0
   Printf "?"
   ' make file menu box exit symbol.
   Locatef Xcoor, Ycoor + 40, 0
   Printf "x"
   ' make remaining menu box areas.
   If Xcoor - 1 > 0 Then
      Colorf2 Green, BackGround
      Locatef Xcoor - 1, Ycoor, 0
      Printf "Hexedit " + Version + " For QB64 Windows PD " + YearRelease + "."
   End If
   Call BottomRow
End Sub

Rem File box bottom row menu.

Sub BottomRow
   If Xcoor + 17 <= 24 Then
      Colorf2 Green, BackGround
      Locatef Xcoor + 17, Ycoor, 0
      Printf "Path:"
   End If
   If Xcoor + 18 <= 24 Then
      Colorf2 Green, BackGround
      Locatef Xcoor + 18, Ycoor, 0
      Printf "File:"
   End If
   If Xcoor + 19 <= 24 Then
      Colorf2 Green, BackGround
      Locatef Xcoor + 19, Ycoor, 0
      Printf "Size:"
   End If
   Colorf2 Plain, Black
End Sub

Rem display filename border area.

Sub DisplayScreen3X
   Locatef 3, 2, 0
   Colorf Magenta
   Printf Chr$(Vline) + " "
   Colorf Green
   Printf Chr$(ULcorner) + String$(46, Hline) + Chr$(URcorner) + " "
   Printf Chr$(ULcorner) + String$(22, Hline) + Chr$(URcorner)
   Colorf White
   Printf "x"
   Colorf Magenta
   Printf Chr$(Vline)
End Sub

Rem Help screen subroutines:

' display help for file menu input box.
Sub DisplayHelp
   Xcoor2 = 5
   Ycoor2 = 3
   GoSub RedrawHelpScreen
   I$ = Nul
   Do
      I$ = Nul
      Do
         I$ = INKEYx$
         If I$ <> Nul Then
            Exit Do
         End If
         Z = MouseDriver ' get mouse
         If MouseButton1 Then
            MouseButton1 = False
            Call ClearMouse
            If Xcoor2 - 1 >= 1 Then
               Xcoor2 = Xcoor2 - 1
               GoSub RedrawHelpScreen
               Var = False
            End If
         End If
         If MouseButton2 Then
            MouseButton2 = False
            Call ClearMouse
            If Xcoor2 + 1 <= 12 Then
               Xcoor2 = Xcoor2 + 1
               GoSub RedrawHelpScreen
               Var = False
            End If
         End If
         If MouseButton3 Then
            I$ = Chr$(0) + Chr$(76) ' center box
            Exit Do
         End If
         If MouseWheel = -1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(80) ' down
            Else
               I$ = Chr$(0) + Chr$(72) ' up
            End If
            MouseWheel = 0
            Exit Do
         End If
         If MouseWheel = 1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(72) ' up
            Else
               I$ = Chr$(0) + Chr$(80) ' down
            End If
            MouseWheel = 0
            Exit Do
         End If
      Loop
      Var = False
      Select Case Len(I$)
         Case 1
            Select Case I$
               Case Chr$(27) ' ExitBox
                  Exit Do
               Case "|" ' SelectBox
                  If Xcoor2 <> 1 Then
                     Xcoor2 = 1
                     Var = True
                  End If
               Case "#" ' SelectBox
                  If Xcoor2 <> 12 Then
                     Xcoor2 = 12
                     Var = True
                  End If
               Case "1" To "9" ' SelectBox
                  If Int(Val(I$)) <> Xcoor2 Then
                     Xcoor2 = Int(Val(I$))
                     Var = True
                  End If
               Case "0" ' SelectBox
                  If Xcoor2 <> 10 Then
                     Xcoor2 = 10
                     Var = True
                  End If
               Case "-" ' SelectBox
                  If Xcoor2 <> 11 Then
                     Xcoor2 = 11
                     Var = True
                  End If
               Case "=" ' SelectBox
                  If Xcoor2 <> 12 Then
                     Xcoor2 = 12
                     Var = True
                  End If
            End Select
         Case 2
            VarQ = Asc(Right$(I$, 1))
            Select Case VarQ
               ' Up/Ctrl-Up/Alt-Up/Ctrl--,Alt-- = MoveUp
               Case 72, 141, 152, 142, 74, 130
                  If Xcoor2 - 1 >= 1 Then
                     Xcoor2 = Xcoor2 - 1
                     Var = True
                  End If
                  ' Down/Ctrl-Down/Alt-Down/Ctrl-+/Alt-= = MoveDown
               Case 80, 145, 160, 144, 78, 131
                  If Xcoor2 + 1 <= 12 Then
                     Xcoor2 = Xcoor2 + 1
                     Var = True
                  End If
               Case 76, 143 ' Keypad-5/Ctrl-Keypad-5 = CenterBox
                  If Xcoor2 <> 5 Then
                     Xcoor2 = 5
                     Var = True
                  End If
                  ' Home/PageUp/Ctrl-Home/Ctrl-PageUp = MoveTop
               Case 71, 73, 119, 132
                  If Xcoor2 <> 1 Then
                     Xcoor2 = 1
                     Var = True
                  End If
                  ' End/PageDown/Ctrl-End/Ctrl-PageDown = MoveBottom
               Case 79, 81, 117, 118
                  If Xcoor2 <> 12 Then
                     Xcoor2 = 12
                     Var = True
                  End If
            End Select
      End Select
      If Var Then
         Var = False
         GoSub RedrawHelpScreen
      End If
   Loop
   Exit Sub

   RedrawHelpScreen:
   Colorf2 White, BackGround2
   Cls
   Locatef Xcoor2, Ycoor2, 0
   Printf "            File Menu Box Function Keys Help Screen " + Version + " " + Release
   Locatef Xcoor2 + 1, Ycoor2, 0
   Colorf2 White, 0
   Colorf Yellow
   Printf Chr$(ULcorner) + String$(74, Hline) + Chr$(URcorner)
   Locatef Xcoor2 + 2, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "                  Press <escape> To Return To Menu:                      "
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 3, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "F1 - Change Drive  F8 - Attribute Specs Alt-F3 Dir Exclude List          "
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 4, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "F2 - Toggle Sort   F9 - Display Help    Alt-F4 Toggle File Sort Direction"
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 5, Ycoor2, 0
   Colorf Yellow
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "F3 - Move Menu     F10 - Exit Editor    Alt-F5 Toggle Dir Sort Direction "
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 6, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "F4 - Back Drive    F11 - Shell To DOS   Alt-F6 Toggle File Date/Time Info"
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 7, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "F5 - Forward Drive F12 - Load FileSpec  Alt-F7 Toggle File Size Info     "
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 8, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "F6 - Toggle Ambiguate  Alt-F1 Toggle Quiet   Alt-F8 Load Network Path    "
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 9, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "F7 - Redraw Menu Box   Alt-F2 Exclude List   Alt-F9 Load Default Net Path"
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 10, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "Alt-A to Alt-Z  Select Drive Letter   Alt-F10 Load Default Net Path Drive"
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 11, Ycoor2, 0
   Printf Chr$(Vline) + " "
   Colorf White
   Printf "Ctrl-F1 to Ctrl-F10 = Alt-Fx keys     Ctrl-F11 to Ctrl-F12 Screen Saver  "
   Colorf Yellow
   Printf Chr$(Vline)
   Locatef Xcoor2 + 12, Ycoor2, 0
   Printf Chr$(LLcorner) + String$(74, Hline) + Chr$(LRcorner)
   Colorf White
   Return
End Sub

' display help screens.
Sub HelpScreen
   GoSub DisplayHelpScreen1
   GoSub DisplayHelpScreen2
   GoSub DisplayHelpScreen3
   GoSub DisplayHelpScreen4
   GoSub DisplayHelpScreen5
   Exit Sub

   ' help screen header.
   HelpHeader:
   Call DisplayScreen2
   Locatef 2, 2, 0
   Colorf White
   Printf "Help screen: Hex Editor " + Version + " " + Release + " functions:"
   Return

   ' help screen 1.
   DisplayHelpScreen1:
   GoSub HelpHeader
   Colorf Red
   Locatef 3, 2, 0
   Printf "Function keys:"
   Colorf Yellow
   Locatef 4, 2, 0
   Printf "Alt-A  Append multiple bytes to file.   Alt-T  HEX File Print."
   Locatef 5, 2, 0
   Printf "Alt-B  Append multiple null bytes.      Alt-U  Undo last byte change."
   Locatef 6, 2, 0
   Printf "Alt-C  ANSI Chart.                      Alt-V  View files."
   Locatef 7, 2, 0
   Printf "Alt-D  HEX Screen Dump.                 Alt-W  Close file."
   Locatef 8, 2, 0
   Printf "Alt-E  HEX File Dump.                   Alt-X  Exit program."
   Locatef 9, 2, 0
   Printf "Alt-F  Start input menu.                Alt-Y  Toggle right window."
   Locatef 10, 2, 0
   Printf "Alt-G  Append multiple specified bytes. Alt-Z  Undo all bytes changes."
   Locatef 11, 2, 0
   Printf "Alt-H  Hex Chart.                       "
   Colorf Red
   Printf "Editing keys:"
   Colorf Yellow
   Locatef 12, 2, 0
   Printf "Alt-I  DOS shell.                       Tab    -- Switch windows."
   Locatef 13, 2, 0
   Printf "Alt-J  Jump to byte position.           Enter  -- Change byte value."
   Locatef 14, 2, 0
   Printf "Alt-K  Search for ASCII string.         Insert -- Change string value."
   Locatef 15, 2, 0
   Printf "Alt-L  Jump to page position.           Delete -- Change hex string."
   Locatef 16, 2, 0
   Printf "Alt-M  Append ASCII string to file.     Escape -- Input Menu."
   Locatef 17, 2, 0
   Printf "Alt-N  Open new file.                   (hex value numeral preceded)."
   Locatef 18, 2, 0
   Printf "Alt-O  Print help.                      (right window unprintable chars"
   Locatef 19, 2, 0
   Printf "Alt-P  HEX Screen Print.                are represented with a dot)."
   Locatef 20, 2, 0
   Printf "Alt-Q  Help screen.                     (ascii values preceded with H"
   Locatef 21, 2, 0
   Printf "Alt-R  Redraw screen.                   are treated as hexidecimal)."
   Locatef 22, 2, 0
   Printf "Alt-S  Search for multiple bytes.       (<escape> key exits search)."
   Locatef 23, 2, 0
   Call PressKey
   Return

   ' help screen 2.
   DisplayHelpScreen2:
   GoSub HelpHeader
   Colorf Red
   Locatef 3, 2, 0
   Printf "Marker keys:"
   Colorf Yellow
   Locatef 4, 2, 0
   Printf "1   add marker."
   Locatef 5, 2, 0
   Printf "2   add specific marker value."
   Locatef 6, 2, 0
   Printf "3   delete marker."
   Locatef 7, 2, 0
   Printf "4   delete specific marker."
   Locatef 8, 2, 0
   Printf "5   jump previous marker."
   Locatef 9, 2, 0
   Printf "6   jump current marker."
   Locatef 10, 2, 0
   Printf "7   jump next marker."
   Locatef 11, 2, 0
   Printf "8   jump specific marker."
   Locatef 12, 2, 0
   Printf "9   list all markers."
   Locatef 13, 2, 0
   Printf "0   list specific marker."
   Locatef 14, 2, 0
   Printf "-   list markers of value."
   Locatef 15, 2, 0
   Printf "+   list range of markers."
   Locatef 16, 2, 0
   Printf "=   delete a range."
   Locatef 17, 2, 0
   Printf "[   delete all markers."
   Locatef 18, 2, 0
   Printf "]   delete markers of value."
   Colorf Red
   Locatef 19, 2, 0
   Printf "Extended keys:"
   Colorf Yellow
   Locatef 20, 2, 0
   Printf "Ctrl-Alt-F1  Reboot."
   Locatef 21, 2, 0
   Printf "Ctrl-Alt-F2  Shutdown."
   Locatef 22, 2, 0
   Printf "Ctrl-Alt-F3  Keymapper."
   Locatef 23, 2, 0
   Call PressKey
   Return

   ' help screen 3.
   DisplayHelpScreen3:
   GoSub HelpHeader
   Colorf Red
   Locatef 3, 2, 0
   Printf "Information keys:"
   Colorf Yellow
   Locatef 4, 2, 0
   Printf "? key displays file length, and undos remaining."
   Locatef 5, 2, 0
   Printf "! key displays current page, row, and column."
   Locatef 6, 2, 0
   Printf "~ key displays last page and markers used."
   Locatef 7, 2, 0
   Printf Quote + " key displays current path of file being edited."
   Locatef 8, 2, 0
   Printf "; key displays the range of the current hilighted area."
   Locatef 9, 2, 0
   Printf "{ key displays number of pasted entries stored in the undo file."
   Colorf Red
   Locatef 10, 2, 0
   Printf "Display keys:"
   Colorf Yellow
   Locatef 11, 2, 0
   Printf "F1 key toggles 64-byte filename display."
   Locatef 12, 2, 0
   Printf "F2 key toggles lower screen help key list."
   Colorf Red
   Locatef 13, 2, 0
   Printf "DOS function keys:"
   Colorf Yellow
   Locatef 14, 2, 0
   Printf "F11 key opens DOS shell in editor or file menu box."
   Locatef 15, 2, 0
   Printf "F12 key prompts for DOS command in editor."
   Locatef 16, 2, 0
   Printf "Control-S Start screen saver.  Control-T Toggle search string."
   Locatef 17, 2, 0
   Colorf Red
   Printf "Hilight keys: "
   Colorf Yellow
   Printf "Shift-<key> hilights area, where <key> is:"
   Locatef 18, 2, 0
   Printf "<left>/<right>/<up>/<down>/<page up>/<page down>/<home>/<end>"
   Locatef 19, 2, 0
   Colorf Red
   Printf "Clipboard controls: "
   Colorf Yellow
   Printf "Control-C (copy) Control-V (paste)"
   Locatef 20, 2, 0
   Printf "Control-X (undo current paste)  Control-Z (undo all pastes)"
   Colorf Red
   Locatef 21, 2, 0
   Printf "Calculator key:"
   Colorf Yellow
   Printf "  Keypad-5/Alt-F10  "
   Colorf Red
   Printf "Repeat last search:"
   Colorf Yellow
   Printf "  Control-F3"
   Locatef 22, 2, 0
   Printf "Alt-- Date/Time Display  Alt-= Files Display"
   Locatef 23, 2, 0
   Call PressKey
   Return

   ' help screen 4.
   DisplayHelpScreen4:
   GoSub HelpHeader
   Colorf Red
   Locatef 3, 2, 0
   Printf "Multiple file keys:"
   Colorf Yellow
   Locatef 4, 2, 0
   Printf "F6 - Next File.      F8 - Load New File.   F10 - View Files."
   Locatef 5, 2, 0
   Printf "F7 - Previous File.  F9 - Close File.      Alt-0  Close All Files."
   Locatef 6, 2, 0
   Printf "Alt-1 To Alt-9  -  Select Specific File."
   Locatef 7, 2, 0
   Printf "Control-Keypad-5  -  Search All Currently Loaded Filenames."
   Locatef 8, 2, 0
   Printf "Key < Previous file, Key > Next file."
   Locatef 9, 2, 0
   Printf "Key | First file, Key # Last file."
   Colorf Red
   Locatef 10, 2, 0
   Printf "File menu box keys:"
   Colorf Yellow
   Locatef 11, 2, 0
   Printf "F1 - drive change.            F7 - redraw file menu box."
   Locatef 12, 2, 0
   Printf "F2 - toggle file sort.        F8 - attribute override."
   Locatef 13, 2, 0
   Printf "F3 - move file menu box.      F9 - display help."
   Locatef 14, 2, 0
   Printf "F4 - back 1 drive letter.     F10 - exit editor."
   Locatef 15, 2, 0
   Printf "F5 - forward 1 drive letter.  F11 - shell to DOS."
   Locatef 16, 2, 0
   Printf "F6 - toggle 8.3 ambiguation.  F12 - load filespec into Editor."
   Locatef 17, 2, 0
   Printf "Alt-A to Alt-Z - select drive letter, Alt-F1 Toggle Quiet."
   Locatef 18, 2, 0
   Printf "Alt-F2 File Exclude List.     Alt-F3 Dir Exclude List."
   Locatef 19, 2, 0
   Printf "Alt-F4 Toggle File Sort.      Alt-F5 Toggle Dir Sort."
   Locatef 20, 2, 0
   Printf "Alt-F6 Toggle File Date/Time. Alt-F7 Toggle File Size Info."
   Locatef 21, 2, 0
   Printf "Alt-F8 Load Network Path.     Alt-F9 Load Default Network Path."
   Locatef 22, 2, 0
   Printf "Alt-F10 Load Default Network Path Drive."
   Colorf Yellow
   Locatef 23, 2, 0
   Call PressKey
   Return

   ' help screen 5.
   DisplayHelpScreen5:
   Call DisplayScreen2
   Colorf White
   Locatef 2, 2, 0
   Var$ = "Hexedit information: "
   ' process number 0-9
   Var$ = Var$ + "[process #" + Mid$(Str$(Process.Number + 1), 2)
   ' machine name
   If Len(RTrim$(DefaultNetPath)) Then
      Var$ = Var$ + ":" + RTrim$(DefaultNetPath)
   End If
   If Len(Var$) > 77 Then
      Var$ = Left$(Var$, 75) + ".."
   End If
   Var$ = Var$ + "]"
   Printf Var$

   ' display program info
   Colorf Yellow
   Locatef 3, 2, 0
   Printf "Program: " + Program + " " + Version + " " + Release + "."
   Locatef 4, 2, 0
   Printf "Author: " + Author$
   Locatef 5, 2, 0
   Printf "Release: " + Publish
   Locatef 6, 2, 0
   Printf "Status: " + Status
   Locatef 7, 2, 0
   Printf "Email: " + Email
   Locatef 8, 2, 0
   Printf "Urls: " + Urls
   Locatef 9, 2, 0
   Call PressKey
   Return
End Sub

' routine to print screen/file/help.
' input variable:
'   Var1 = 1  PrintScreen
'   Var1 = 2  PrintFile
'   Var1 = 3  PrintHelp
Sub PrintSub (Var1)
   Select Case Var1
      Case 1
         Column = False
         ColumnSpace = False
         HexLine$ = Nul
         HexLine2$ = Nul
         FirstByte = (FilePage - 1) * 320 + 1
         LastByte = (FilePage - 1) * 320 + 320
         DumpLine$ = DumpLineRange$
         LPrint ""
         LPrint DumpLine$
         Temp# = FirstByte
         For NextByte = FirstByte To LastByte
            If NextByte <= FileLength Then
               SeekPosition = NextByte
               Call LseekFile
               Call ReadFile
               FileByte = Buffer
               ByteValue = Asc(FileByte)
               If ByteValue < 32 Then
                  HexLine2$ = HexLine2$ + "."
               Else
                  HexLine2$ = HexLine2$ + FileByte
               End If
               HexLine$ = HexLine$ + Right$("00" + Hex$(Asc(FileByte)), 2)
            Else
               HexLine$ = HexLine$ + "  "
               HexLine2$ = HexLine2$ + " "
            End If
            ColumnSpace = ColumnSpace + 1
            If ColumnSpace = 4 Then
               HexLine$ = HexLine$ + " "
               Column = Column + 1
               ColumnSpace = False
            End If
            Column = Column + 2
            If Column > 44 Then
               HexFile$ = HexLine$ + " " + HexLine2$
               HexFile$ = RTrim$(HexFile$)
               If Len(HexFile$) Then
                  HexFile$ = HexFile$ + Space$(67 - Len(HexFile$))
                  HexFile$ = HexFile$ + "x" + Right$("00000000" + Hex$(Temp# - 1#), 8)
                  LPrint HexFile$
               End If
               HexLine$ = Nul
               HexLine2$ = Nul
               Temp# = NextByte + 1#
               Column = False
            End If
         Next
         LPrint Chr$(12);
      Case 2
         Column = False
         ColumnSpace = False
         HexLine$ = Nul
         HexLine2$ = Nul

         ' calculate last page
         FirstByte = 1
         LastPage = Int((FileLength - 1) / 320) + 1
         LastByte = (LastPage - 1) * 320 + 320

         ' write to printer
         FileDumped = True
         ' display message about dumping.
         Colorf Yellow
         Locatef 2, 4, 0
         Printf Space$(74)
         Locatef 2, 4, 0
         Printf "Printing file: (Press <esc> to quit):"
         DumpLine$ = DumpLineRange$
         LPrint ""
         LPrint DumpLine$
         Temp# = FirstByte
         PercentDisplayed! = SFalse
         Locatef 2, 41, 0
         Printf " 0%"
         For NextByte = FirstByte To LastByte
            If NextByte <= FileLength Then
               SeekPosition = NextByte
               Call LseekFile
               Call ReadFile
               FileByte = Buffer
               ByteValue = Asc(FileByte)
               ' skip unprintable characters
               If ByteValue < 32 Then
                  HexLine2$ = HexLine2$ + "."
               Else
                  HexLine2$ = HexLine2$ + FileByte
               End If
               HexLine$ = HexLine$ + Right$("00" + Hex$(Asc(FileByte)), 2)
            Else
               HexLine$ = HexLine$ + "  "
               HexLine2$ = HexLine2$ + " "
            End If
            ColumnSpace = ColumnSpace + 1
            If ColumnSpace = 4 Then
               HexLine$ = HexLine$ + " "
               Column = Column + 1
               ColumnSpace = False
            End If
            Column = Column + 2
            If Column > 44 Then
               If INKEYx$ = Chr$(27) Then
                  FileDumped = False
                  Exit For
               End If
               HexFile$ = HexLine$ + " " + HexLine2$
               HexFile$ = RTrim$(HexFile$)
               If Len(HexFile$) Then
                  HexFile$ = HexFile$ + Space$(67 - Len(HexFile$))
                  HexFile$ = HexFile$ + "x" + Right$("00000000" + Hex$(Temp# - 1#), 8)
                  LPrint HexFile$
                  PercentCopied! = Int(CSng(NextByte / LastByte) * 100!)
                  If PercentCopied! > PercentDisplayed! Then
                     Locatef 2, 41, 0
                     Printf Str$(PercentCopied!) + "%"
                     PercentDisplayed! = PercentCopied!
                  End If
               End If
               HexLine$ = Nul
               HexLine2$ = Nul
               Temp# = NextByte + 1#
               Column = False
            End If
         Next
         LPrint Chr$(12);
      Case 3
         LPrint "Help screen: Hex Editor " + Version + " " + Release + " functions:"
         LPrint "Function keys:"
         LPrint " Alt-A  Append multiple bytes to file.   Alt-T  HEX File Print."
         LPrint " Alt-B  Append multiple null bytes.      Alt-U  Undo last byte change."
         LPrint " Alt-C  ANSI Chart.                      Alt-V  View files."
         LPrint " Alt-D  HEX Screen Dump.                 Alt-W  Close file."
         LPrint " Alt-E  HEX File Dump.                   Alt-X  Exit program."
         LPrint " Alt-F  Start input menu.                Alt-Y  Toggle right window."
         LPrint " Alt-G  Append multiple specified bytes. Alt-Z  Undo all byte changes."
         LPrint " Alt-H  HEX Chart.                       Editing keys:"
         LPrint " Alt-I  DOS shell.                       Tab    -- Switch windows."
         LPrint " Alt-J  Jump to byte position.           Enter  -- Change byte value."
         LPrint " Alt-K  Search for ASCII string.         Insert -- Change string value."
         LPrint " Alt-L  Jump to page position.           Delete -- Change hex string."
         LPrint " Alt-M  Append ASCII string to file.     Escape -- Input Menu."
         LPrint " Alt-N  Open new file.                   (hex value numeral preceded)."
         LPrint " Alt-O  Print help.                      (ascii values preceded with H"
         LPrint " Alt-P  HEX Screen Print.                treated as hexidecimal.)"
         LPrint " Alt-Q  Help screen.                     (right window unprintable chars"
         LPrint " Alt-R  Redraw screen.                   are represented with a dot)."
         LPrint " Alt-S  Search for multiple bytes.       (<escape> key exits search)."
         LPrint "Marker keys:"
         LPrint " 1  -  add marker              2  -  add specific marker value"
         LPrint " 3  -  delete marker           4  -  delete specific marker"
         LPrint " 5  -  jump previous marker    6  -  jump current marker"
         LPrint " 7  -  jump next marker        8  -  jump specific marker"
         LPrint " 9  -  list all markers        0  -  list specific marker"
         LPrint " -  -  list markers of value   +  -  list range of markers"
         LPrint " =  -  delete a range          [  -  delete all markers"
         LPrint " ]  -  delete markers of value"
         LPrint "Information keys:"
         LPrint " ? key displays file length, and undos remaining."
         LPrint " ! key displays current page, row, and column."
         LPrint " ~ key displays last page and markers used."
         LPrint " " + Quote + " key displays current path of file being edited."
         LPrint " ; key displays the range of the current hilighted area."
         LPrint " { key displays number of pasted entries stored in the undo file."
         LPrint "Calculator key:  Keypad-5/Alt-F10"
         LPrint "Repeat last search:  Control-F3"
         LPrint " Alt-- Date/Time Display  Alt-= Files Display"
         LPrint Chr$(12);
         LPrint "Help screen: Hex Editor " + Version + " " + Release + " functions:"
         LPrint "Display keys:"
         LPrint " F1 key toggles 64-byte filename display."
         LPrint " F2 key toggles lower screen help key list."
         LPrint "DOS function keys:"
         LPrint " F11 key opens DOS shell in editor or file menu box."
         LPrint " F12 key prompts for DOS command in editor."
         LPrint " Control-S Start screen saver.  Control-T Toggle search string."
         LPrint "Hilight keys:"
         LPrint " Shift-<key> hilights area, where <key> is:"
         LPrint " <left>/<right>/<up>/<down>/<page up>/<page down>/<home>/<end>"
         LPrint "Clipboard controls:"
         LPrint " Control-C (copy)                 Control-V (paste)"
         LPrint " Control-X (undo current paste)  Control-Z (undo all pastes)"
         LPrint "Multiple file keys:"
         LPrint " F6 - Next file.  F7 - Previous file  F8 - Load new file."
         LPrint " F9 - Close file. F10 - View files.   Alt-0 - Close all files."
         LPrint " Alt-1 to Alt-9  -  select specific file."
         LPrint " Control-Keypad-5  -  Search All Currently Loaded Filenames."
         LPrint " Key > Next file, Key < Previous file."
         LPrint "File menu box keys:"
         LPrint " F1 - Change Drive          F2 - Toggle Sort"
         LPrint " F3 - Move File Box         F4 - Back Drive"
         LPrint " F5 - Forward Drive         F6 - Toggle Ambiguate"
         LPrint " F7 - Redraw File Menu Box  F8 - Attribute Override"
         LPrint " F9 - Display Help          F10 - Exit Editor"
         LPrint " F11 - Shell To DOS         F12 - Load FileSpec into Editor"
         LPrint " Alt-A To Alt-Z - Select Drive Letter"
         LPrint " Alt-F1 Toggle Quiet Mode   Alt-F2 File Exclude List"
         LPrint " Alt-F3 Dir Exclude List    Alt-F4 Toggle File Sort"
         LPrint " Alt-F5 Toggle Dir Sort     Alt-F6 Toggle File date/time"
         LPrint " Alt-F7 Toggle File Size"
         LPrint "File Menu Box Network keys:"
         LPrint " Alt-F8  Load Network Path  Alt-F9  Load Default Network Path"
         LPrint " Alt-F10 Load Default Network Path Drive"
         LPrint Chr$(12);
   End Select
End Sub

' subroutine to dump screen/file contents to file.
' input variable:
'   Var1 = 1  DumpScreen
'   Var1 = 2  DumpFile
Sub DumpSub (Var1, x2)
   Select Case Var1
      Case 1
         FirstByte = (FilePage - 1) * 320 + 1
         LastByte = (FilePage - 1) * 320 + 320
         DumpLine$ = DumpLineRange$
         Print #x2, ""
         Print #x2, DumpLine$
         Temp# = FirstByte
         For NextByte = FirstByte To LastByte
            If NextByte <= FileLength Then
               SeekPosition = NextByte
               Call LseekFile
               Call ReadFile
               FileByte = Buffer
               ByteValue = Asc(FileByte)
               ' skip unprintable characters
               If ByteValue < 32 Then
                  HexLine2$ = HexLine2$ + "."
               Else
                  HexLine2$ = HexLine2$ + FileByte
               End If
               HexLine$ = HexLine$ + Right$("00" + Hex$(Asc(FileByte)), 2)
            Else
               HexLine$ = HexLine$ + "  "
               HexLine2$ = HexLine2$ + " "
            End If
            ColumnSpace = ColumnSpace + 1
            If ColumnSpace = 4 Then
               HexLine$ = HexLine$ + " "
               Column = Column + 1
               ColumnSpace = False
            End If
            Column = Column + 2
            If Column > 44 Then
               HexFile$ = HexLine$ + " " + HexLine2$
               HexFile$ = RTrim$(HexFile$)
               If Len(HexFile$) Then
                  HexFile$ = HexFile$ + Space$(67 - Len(HexFile$))
                  HexFile$ = HexFile$ + "x" + Right$("00000000" + Hex$(Temp# - 1#), 8)
                  Print #x2, HexFile$
               End If
               HexLine$ = Nul
               HexLine2$ = Nul
               Temp# = NextByte + 1#
               Column = False
            End If
         Next
      Case 2
         ' calculate last page
         FirstByte = 1
         LastPage = Int((FileLength - 1) / 320) + 1
         LastByte = (LastPage - 1) * 320 + 320

         ' write to file
         FileDumped = True
         Colorf Yellow
         Locatef 2, 4, 0
         Printf Space$(74)
         Locatef 2, 4, 0
         Printf "Writing file: (Press <esc> to quit):"
         DumpLine$ = DumpLineRange$
         Print #x2, ""
         Print #x2, DumpLine$
         Temp# = FirstByte
         PercentDisplayed! = SFalse
         Locatef 2, 40, 0
         Printf " 0%"
         For NextByte = FirstByte To LastByte
            If NextByte <= FileLength Then
               SeekPosition = NextByte
               Call LseekFile
               Call ReadFile
               FileByte = Buffer
               ByteValue = Asc(FileByte)
               ' skip unprintable characters
               If ByteValue < 32 Then
                  HexLine2$ = HexLine2$ + "."
               Else
                  HexLine2$ = HexLine2$ + FileByte
               End If
               HexLine$ = HexLine$ + Right$("00" + Hex$(Asc(FileByte)), 2)
            Else
               HexLine$ = HexLine$ + "  "
               HexLine2$ = HexLine2$ + " "
            End If
            ColumnSpace = ColumnSpace + 1
            If ColumnSpace = 4 Then
               HexLine$ = HexLine$ + " "
               Column = Column + 1
               ColumnSpace = False
            End If
            Column = Column + 2
            If Column > 44 Then
               If INKEYx$ = Chr$(27) Then
                  FileDumped = False
                  Exit For
               End If
               HexFile$ = HexLine$ + " " + HexLine2$
               HexFile$ = RTrim$(HexFile$)
               If Len(HexFile$) Then
                  HexFile$ = HexFile$ + Space$(67 - Len(HexFile$))
                  HexFile$ = HexFile$ + "x" + Right$("00000000" + Hex$(Temp# - 1#), 8)
                  Print #x2, HexFile$
                  PercentCopied! = Int(CSng(NextByte / LastByte) * 100!)
                  If PercentCopied! > PercentDisplayed! Then
                     Locatef 2, 40, 0
                     Printf Str$(PercentCopied!) + "%"
                     PercentDisplayed! = PercentCopied!
                  End If
               End If
               HexLine$ = Nul
               HexLine2$ = Nul
               Temp# = NextByte + 1#
               Column = False
            End If
         Next
   End Select
End Sub

' routine to display Ansi/Hex chart.
' input variable:
'   Var1 = 1  ANSI Chart
'   Var1 = 2  HEX Chart
Sub DisplayChart (Var1)
   Select Case Var1
      Case 1
         Call DisplayScreen2
         Colorf White
         Locatef 2, 2, 0
         Printf "ASCII Chart for characters 1 to 127:"
         Var2 = 3
         Locatef 3, 2, 0
         For Char = 1 To 127
            Select Case Char
               ' skip unprintable characters
               Case 0, 7, 9 To 13, 28 To 32
                  DisplayChar$ = " "
                  ' store character
               Case Else
                  DisplayChar$ = Chr$(Char)
            End Select
            Var$ = Mid$(Str$(Char), 2)
            Var1$ = Right$("00" + Var$, 3) + " "
            Colorf Green
            Printf Var1$
            Colorf Yellow
            Printf Chr$(Char) + " "
            ' check full screen line
            If (Char Mod 10) = False Then
               Var2 = Var2 + 1
               Locatef Var2, 2, 0
            End If
         Next
         Locatef 16, 2, 0
         Call PressKey
         Call DisplayScreen2
         Colorf White
         Locatef 2, 2, 0
         Printf "ASCII Chart for characters 128 to 255:"
         Var2 = 3
         Locatef 3, 2, 0
         For Char = 128 To 255
            DisplayChar$ = Chr$(Char)
            Var$ = Mid$(Str$(Char), 2)
            Var1$ = Right$("00" + Var$, 3) + " "
            Colorf Green
            Printf Var1$
            Colorf Yellow
            Printf DisplayChar$ + " "
            ' check full screen line
            If ((Char - 7) Mod 10) = False Then
               Var2 = Var2 + 1
               Locatef Var2, 2, 0
            End If
         Next
         Locatef 16, 2, 0
         Call PressKey
      Case 2
         Call DisplayScreen2
         Colorf White
         Locatef 2, 2, 0
         Printf "HEX Chart for characters 1 to 127:"
         Var2 = 3
         Locatef 3, 2, 0
         For Char = 1 To 127
            Select Case Char
               ' skip unprintable characters
               Case 0, 7, 9 To 13, 28 To 32
                  DisplayChar$ = " "
                  ' store character
               Case Else
                  DisplayChar$ = Chr$(Char)
            End Select
            Var$ = Hex$(Char)
            Var1$ = Right$("0" + Var$, 2) + " "
            Colorf Green
            Printf Var1$
            Colorf Yellow
            Printf Chr$(Char) + " "
            ' check full screen line
            If (Char Mod 10) = False Then
               Var2 = Var2 + 1
               Locatef Var2, 2, 0
            End If
         Next
         Locatef 16, 2, 0
         Call PressKey
         Colorf Plain
         Call DisplayScreen2
         Colorf White
         Locatef 2, 2, 0
         Printf "HEX Chart for characters 128 to 255:"
         Var2 = 3
         Locatef 3, 2, 0
         For Char = 128 To 255
            DisplayChar$ = Chr$(Char)
            Var$ = Hex$(Char)
            Var1$ = Right$("0" + Var$, 2) + " "
            Colorf Green
            Printf Var1$
            Colorf Yellow
            Printf DisplayChar$ + " "
            ' check full screen line
            If ((Char - 7) Mod 10) = False Then
               Var2 = Var2 + 1
               Locatef Var2, 2, 0
            End If
         Next
         Locatef 16, 2, 0
         Call PressKey
   End Select
End Sub

Rem Clipboard routines:

Sub Clipboard2 (Var)
   ' select clipboard routine.
   If Var = 1 Then GoTo CopyToClipboard
   If Var = 2 Then GoTo PasteFromClipboard
   ' Uses:
   '  StoreUndoPaste: store area to be over-written into paste undo file.

   If Var = 3 Then GoTo ClipboardUndo
   If Var = 4 Then GoTo ClipboardUndoAll
   ' Uses:
   '  UndoClipboard: restore last paste undo entry.

   Exit Sub

   ' copy hilighted area to clipboard file.
   CopyToClipboard:
   If CopyPositionStart = DFalse Then
      Call DisplayX
      Colorf White
      Printf "Total 0 bytes copied to clipboard."
      Call LocateCursor2
      Exit Sub
   End If
   ' store clipboard length.
   ByteLength# = CopyPositionEnd - CopyPositionStart + 1#
   If ByteLength# + 4# > 2147483647# Then
      StatusMessage = "Copy extends beyond clipboard file length."
      Call DisplayStatus2
      Exit Sub
   End If
   Call DisplayX
   Colorf White
   Printf "Copying bytes to clipboard."
   Call LocateCursor2
   Bytes$ = Right$("00000000" + Hex$(ByteLength#), 8)
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 1, 2)))
   Put #4, 1, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 3, 2)))
   Put #4, 2, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 5, 2)))
   Put #4, 3, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 7, 2)))
   Put #4, 4, CopyByte
   ' write clipboard.
   Temp# = FilePosition
   Temp2# = 4#
   For NextByte = CopyPositionStart To CopyPositionEnd
      SeekPosition = NextByte
      Call LseekFile
      Call ReadFile
      FileByte = Buffer
      Temp2# = Temp2# + 1#
      Put #4, Temp2#, FileByte
   Next
   FilePosition = Temp#
   Call DisplayX
   Colorf White
   UndoToggle = Not UndoToggle
   If UndoToggle Then
      Printf "(+)"
   Else
      Printf "(X)"
   End If
   Printf " " + FormatX$(ByteLength#, 1) + " bytes copied to clipboard."
   Call LocateCursor2
   Exit Sub

   ' paste clipboard to current file position.
   PasteFromClipboard:
   ' read clipboard length.
   If LOF(4) = 0 Then
      Call DisplayX
      Colorf White
      Printf "Total 0 bytes pasted from clipboard."
      Call LocateCursor2
      Exit Sub
   End If
   ' get clipboard length.
   ByteLength# = DFalse
   Get #4, 1, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte) * 16 ^ 6
   Get #4, 2, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte) * 16 ^ 4
   Get #4, 3, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte) * 16 ^ 2
   Get #4, 4, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte)
   ' check end of file.
   If FilePosition + ByteLength# - 1# > FileLength Then
      StatusMessage = "Paste extends beyond file length."
      Call DisplayStatus2
      Exit Sub
   End If
   ' clear hilight area.
   If CopyPositionStart > 0# Then
      Call ResetHilightBytes
   End If
   ' store paste area to undo clipboard file.
   GoSub StoreUndoPaste
   If ValidPaste = False Then
      Exit Sub
   End If
   ' write paste bytes.
   Temp# = FilePosition
   LastPage = FilePage
   For NextByte = 1# To ByteLength#
      Get #4, NextByte + 4#, FileByte
      SeekPosition = FilePosition
      Call LseekFile
      Call WriteFile
      Call CalculatePosition1
      If LastPage = FilePage Then
         Call ClearPageByte
      End If
      If NextByte < ByteLength# Then
         FilePosition = FilePosition + 1
      End If
   Next
   FilePosition = Temp#
   Call CalculatePosition1
   Call DisplayPageByte
   Call DisplayX
   Colorf White
   Printf "Entry #" + FormatX$(CDbl(ByteEntries), 1) + " pasted."
   Call LocateCursor2
   Exit Sub

   ' store area to be over-written into paste undo file.
   '   see also: Struc.txt describes file format.
   StoreUndoPaste:
   If LOF(5) = 0 Then
      CopyByte = Chr$(0)
      Put #5, 1, CopyByte
      Put #5, 2, CopyByte
   End If
   ValidPaste = True
   ' get maximum entries.
   ByteEntries = 0
   Get #5, 1, CopyByte
   ByteEntries = ByteEntries + Asc(CopyByte) * 16 ^ 2
   Get #5, 2, CopyByte
   ByteEntries = ByteEntries + Asc(CopyByte)
   If ByteEntries >= 32767 Then
      ValidPaste = False
      StatusMessage = "Paste undo entries extend beyond file length."
      Call DisplayStatus2
      Return
   End If
   ' scan to last entry position in paste undo file.
   Temp2# = 3#
   Temp3 = 1
   Do
      ' check last entry.
      If Temp3 > ByteEntries Then
         Exit Do
      End If
      ' skip file start position.
      Temp2# = Temp2# + 4#
      LengthOfRecord# = DFalse
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte) * 16 ^ 6
      Temp2# = Temp2# + 1#
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte) * 16 ^ 4
      Temp2# = Temp2# + 1#
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte) * 16 ^ 2
      Temp2# = Temp2# + 1#
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte)
      Temp2# = Temp2# + LengthOfRecord# + 1#
      Temp3 = Temp3 + 1
   Loop
   ' get maximum entries.
   TotalBytes# = Temp2# + ByteLength# + 8#
   If TotalBytes# >= 2147483647# Then
      ValidPaste = False
      StatusMessage = "Paste undo extends beyond file length."
      Call DisplayStatus2
      Return
   End If
   Call DisplayX
   Colorf White
   Printf "Pasting bytes from clipboard."
   Call LocateCursor2
   ' store new entry.
   ByteEntries = ByteEntries + 1
   Bytes$ = Right$("0000" + Hex$(ByteEntries), 4)
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 1, 2)))
   Put #5, 1, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 3, 2)))
   Put #5, 2, CopyByte
   ' store file position of undo paste area.
   Bytes$ = Right$("00000000" + Hex$(FilePosition), 8)
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 1, 2)))
   Put #5, Temp2#, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 3, 2)))
   Temp2# = Temp2# + 1#
   Put #5, Temp2#, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 5, 2)))
   Temp2# = Temp2# + 1#
   Put #5, Temp2#, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 7, 2)))
   Temp2# = Temp2# + 1#
   Put #5, Temp2#, CopyByte
   ' store length of undo paste area.
   Bytes$ = Right$("00000000" + Hex$(ByteLength#), 8)
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 1, 2)))
   Temp2# = Temp2# + 1#
   Put #5, Temp2#, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 3, 2)))
   Temp2# = Temp2# + 1#
   Put #5, Temp2#, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 5, 2)))
   Temp2# = Temp2# + 1#
   Put #5, Temp2#, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 7, 2)))
   Temp2# = Temp2# + 1#
   Put #5, Temp2#, CopyByte
   ' write undo clipboard.
   Temp# = FilePosition
   For NextByte = Temp# To Temp# + ByteLength# - 1#
      SeekPosition = NextByte
      Call LseekFile
      Call ReadFile
      FileByte = Buffer
      Temp2# = Temp2# + 1#
      Put #5, Temp2#, FileByte
   Next
   FilePosition = Temp#
   Return

   ' undo last paste from clipboard.
   ClipboardUndo:
   If LOF(5) = 0 Then
      CopyByte = Chr$(0)
      Put #5, 1, CopyByte
      Put #5, 2, CopyByte
      ValidPaste = False
   Else
      GoSub UndoClipboard
   End If
   Call DisplayX
   Colorf White
   If ValidPaste = False Then
      Printf "Total 0 bytes paste undo."
   Else
      Printf "Entry #" + FormatX$(CDbl(ByteEntries + 1), 1) + " paste undo."
   End If
   Call LocateCursor2
   Exit Sub

   ' undo all pastes from clipboard.
   ClipboardUndoAll:
   TotalEntries = 0
   If LOF(5) = 0 Then
      CopyByte = Chr$(0)
      Put #5, 1, CopyByte
      Put #5, 2, CopyByte
   Else
      ByteEntries = 0
      Get #5, 1, CopyByte
      ByteEntries = ByteEntries + Asc(CopyByte) * 16 ^ 2
      Get #5, 2, CopyByte
      ByteEntries = ByteEntries + Asc(CopyByte)
      If ByteEntries > 0 Then
         TotalEntries = ByteEntries
         Do
            GoSub UndoClipboard
            If ValidPaste = False Then
               Exit Do
            End If
         Loop
      End If
   End If
   Call DisplayX
   Colorf White
   Printf "Total " + FormatX$(CDbl(TotalEntries), 1) + " entries in paste undos."
   Call LocateCursor2
   Exit Sub

   ' restore last paste undo entry.
   UndoClipboard:
   ' get last entry.
   ByteEntries = 0
   Get #5, 1, CopyByte
   ByteEntries = ByteEntries + Asc(CopyByte) * 16 ^ 2
   Get #5, 2, CopyByte
   ByteEntries = ByteEntries + Asc(CopyByte)
   ValidPaste = True
   If ByteEntries = 0 Then
      ValidPaste = False
      Return
   End If
   ' scan to last entry position in paste undo file.
   Temp# = FilePosition
   Temp2# = 3#
   Temp3 = 1
   Do
      ' check last entry.
      If Temp3 = ByteEntries Then
         Exit Do
      End If
      ' skip file start position.
      Temp2# = Temp2# + 4#
      LengthOfRecord# = DFalse
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte) * 16 ^ 6
      Temp2# = Temp2# + 1#
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte) * 16 ^ 4
      Temp2# = Temp2# + 1#
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte) * 16 ^ 2
      Temp2# = Temp2# + 1#
      Get #5, Temp2#, CopyByte
      LengthOfRecord# = LengthOfRecord# + Asc(CopyByte)
      Temp2# = Temp2# + LengthOfRecord# + 1#
      Temp3 = Temp3 + 1
   Loop
   ' restore last entry.
   ByteEntries = ByteEntries - 1
   Bytes$ = Right$("0000" + Hex$(ByteEntries), 4)
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 1, 2)))
   Put #5, 1, CopyByte
   CopyByte = Chr$(Val("&H" + Mid$(Bytes$, 3, 2)))
   Put #5, 2, CopyByte
   ' restore file position of undo paste area.
   NextByte = DFalse
   Get #5, Temp2#, CopyByte
   NextByte = NextByte + Asc(CopyByte) * 16 ^ 6
   Temp2# = Temp2# + 1#
   Get #5, Temp2#, CopyByte
   NextByte = NextByte + Asc(CopyByte) * 16 ^ 4
   Temp2# = Temp2# + 1#
   Get #5, Temp2#, CopyByte
   NextByte = NextByte + Asc(CopyByte) * 16 ^ 2
   Temp2# = Temp2# + 1#
   Get #5, Temp2#, CopyByte
   NextByte = NextByte + Asc(CopyByte)
   ' restore length of undo paste area.
   ByteLength# = DFalse
   Temp2# = Temp2# + 1#
   Get #5, Temp2#, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte) * 16 ^ 6
   Temp2# = Temp2# + 1#
   Get #5, Temp2#, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte) * 16 ^ 4
   Temp2# = Temp2# + 1#
   Get #5, Temp2#, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte) * 16 ^ 2
   Temp2# = Temp2# + 1#
   Get #5, Temp2#, CopyByte
   ByteLength# = ByteLength# + Asc(CopyByte)
   ' undo paste area.
   Temp# = FilePosition
   Temp3# = NextByte
   LastPage = FilePage
   For FilePosition = Temp3# To Temp3# + ByteLength# - 1#
      Temp2# = Temp2# + 1#
      Get #5, Temp2#, FileByte
      SeekPosition = FilePosition
      Call LseekFile
      Call WriteFile
      Call CalculatePosition1
      If LastPage = FilePage Then
         Call ClearPageByte
      End If
   Next
   FilePosition = Temp#
   Call CalculatePosition1
   Call DisplayPageByte
   Call DisplayX
   Colorf White
   Printf "Undoing entry from paste file."
   Call LocateCursor2
   Return
End Sub

Rem Viewfile routine:

' returns Var=1 to MaxFiles of file number.
Sub Viewfiles (Var)
   GoSub StoreArea
   GoSub DrawMenu
   MenuSelect = 1
   GoSub DrawCurrentMenuSelection

   ' keyboard/mouse input loop.
   Do
      _Limit 100
      CharInput$ = Nul

      ' call mouse subroutine.
      Z = MouseDriver

      ' check left mouse button.
      If MouseButton1 Then
         GoSub MouseButton1Y
      Else
         ' check right mouse button.
         If MouseButton2 Then
            GoSub RestoreArea
            Var = False
            Exit Sub
         Else
            ' check mouse position.
            If MouseX Or MouseY Then
               GoSub MoveMouse
            End If
         End If
      End If

      ' check mouse wheel.
      I$ = Nul
      If MouseWheel = -1 Then
         If WheelReverse Then
            I$ = Chr$(0) + Chr$(80) ' down
         Else
            I$ = Chr$(0) + Chr$(72) ' up
         End If
         MouseWheel = 0
      End If
      If MouseWheel = 1 Then
         If WheelReverse Then
            I$ = Chr$(0) + Chr$(72) ' up
         Else
            I$ = Chr$(0) + Chr$(80) ' down
         End If
         MouseWheel = 0
      End If

      ' store keyboard buffer.
      If I$ <> Nul Then
         CharInput$ = I$
      Else
         CharInput$ = INKEYx$
      End If
      If Len(CharInput$) Then
         Select Case Len(CharInput$)
            Case 1
               Select Case Asc(CharInput$)
                  Case 13 ' Enter
                     GoSub RestoreArea
                     If MenuSelect > NumberFiles Then
                        Var = False
                     Else
                        Var = MenuSelect
                     End If
                     Exit Do
                  Case 27 ' Escape
                     GoSub RestoreArea
                     Var = False
                     Exit Do
                  Case Asc("!") ' shift-1
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = 10
                     GoSub DrawCurrentMenuSelection
                  Case Asc("@") ' shift-2
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = 11
                     GoSub DrawCurrentMenuSelection
                  Case Asc("#") ' shift-3
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = 12
                     GoSub DrawCurrentMenuSelection
                  Case Asc("$") ' shift-4
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = 13
                     GoSub DrawCurrentMenuSelection
                  Case Asc("%") ' shift-5
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = 14
                     GoSub DrawCurrentMenuSelection
                  Case Asc("^") ' shift-6
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = 15
                     GoSub DrawCurrentMenuSelection
                  Case 49 To 48 + MaxFiles ' 1 to MaxFiles
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = Asc(CharInput$) - 48
                     GoSub DrawCurrentMenuSelection
                  Case 65 To 90, 97 To 122 ' A - Z, a - z
                     GoSub Search.File2
               End Select
            Case 2
               VarX = Asc(Right$(CharInput$, 1))
               Select Case VarX
                  ' Up/Ctrl-Up/Alt-Up/Ctrl--,Alt-- = MoveUp
                  Case 72, 141, 152, 142, 74, 130
                     GoSub MenuUp
                     ' Down/Ctrl-Down/Alt-Down/Ctrl-+/Alt-= = MoveDown
                  Case 80, 145, 160, 144, 78, 131
                     GoSub MenuDown
                  Case 71, 73, 119, 132 ' Home/PageUp/Ctrl-Home/Ctrl-PageUp
                     GoSub MenuFirst
                  Case 79, 81, 117, 118 ' End/PageDown/Ctrl-End/Ctrl-PageDown
                     GoSub MenuLast
                  Case 59 To 67 ' F1 - F9
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = VarX - 58
                     GoSub DrawCurrentMenuSelection
                  Case 94 To 102 ' Ctrl-F1 to Ctrl-F9
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = VarX - 93
                     GoSub DrawCurrentMenuSelection
                  Case 104 To 112 ' Alt-F1 to Alt-F9
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = VarX - 103
                     GoSub DrawCurrentMenuSelection
                  Case 120 To 128 ' Alt-1 to Alt-9
                     GoSub EraseCurrentMenuSelection
                     MenuSelect = VarX - 119
                     GoSub DrawCurrentMenuSelection
                  Case Else
                     For VarZ = 1 To 6 ' Alt-A to Alt-F
                        If Keys(VarZ) = VarX Then
                           GoSub EraseCurrentMenuSelection
                           MenuSelect = VarZ + 9
                           GoSub DrawCurrentMenuSelection
                           Exit For
                        End If
                     Next
               End Select
         End Select
      End If
   Loop
   Exit Sub

   ' search filename.
   Search.File2:
   For VarX = MenuSelect + 1 To NumberFiles
      VarX$ = RTrim$(File(VarX).Filename)
      If Left$(VarX$, 1) = UCase$(CharInput$) Then
         GoSub EraseCurrentMenuSelection
         MenuSelect = VarX
         GoSub DrawCurrentMenuSelection
         Return
      End If
   Next
   For VarX = 1 To MenuSelect
      VarX$ = RTrim$(File(VarX).Filename)
      If Left$(VarX$, 1) = UCase$(CharInput$) Then
         GoSub EraseCurrentMenuSelection
         MenuSelect = VarX
         GoSub DrawCurrentMenuSelection
         Return
      End If
   Next
   Return

   ' draws menu.
   DrawMenu:
   BoxDrawX1 = 4
   BoxDrawX2 = MaxFiles + 5
   BoxDrawY1 = 6
   BoxDrawY2 = 21
   BoxDrawLength = 16
   GoSub DrawBox
   Colorf2 White, 0
   For Var2 = 1 To MaxFiles
      Locatef 4 + Var2, 7, 0
      Printf Hex$(Var2) + " "
      If Var2 > NumberFiles Then
         Printf "<none>      "
      Else
         Printf File(Var2).Filename
      End If
   Next
   Return

   ' draws box from (BoxDrawX1,BoxDrawY1) To (BoxDrawX2,BoxDrawY2),
   '  length of box from left to right being BoxDrawLength.
   DrawBox:
   Colorf Yellow
   Locatef BoxDrawX1, BoxDrawY1, 0
   Printf Chr$(ULcorner) + String$(BoxDrawLength - 2, Hline) + Chr$(URcorner)
   For RowX1 = BoxDrawX1 + 1 To BoxDrawX2 - 1
      Locatef RowX1, BoxDrawY1, 0
      Printf Chr$(Vline)
      Locatef RowX1, BoxDrawY2, 0
      Printf Chr$(Vline)
   Next
   Locatef BoxDrawX2, BoxDrawY1, 0
   Printf Chr$(LLcorner) + String$(BoxDrawLength - 2, Hline) + Chr$(LRcorner)
   Colorf2 0, 7
   Locatef 4, 9, 0
   Printf "View Files"
   Colorf Yellow
   Return

   ' stores area under menu.
   StoreArea:
   RowX1 = False
   ColumnY1 = False
   For RowX2 = 4 To MaxFiles + 5
      RowX1 = RowX1 + 1
      ColumnY1 = False
      For ColumnY2 = 6 To 21
         ColumnY1 = ColumnY1 + 1
         ' store ascii character.
         Area1(RowX1, ColumnY1) = Screen(RowX2, ColumnY2)
         ' store color. (undocumented: also stores background color).
         Area2(RowX1, ColumnY1) = Screen(RowX2, ColumnY2, 1)
      Next
   Next
   Return

   ' restores area under menu.
   RestoreArea:
   RowX1 = False
   ColumnY1 = False
   For RowX2 = 4 To MaxFiles + 5
      RowX1 = RowX1 + 1
      ColumnY1 = False
      For ColumnY2 = 6 To 21
         ColumnY1 = ColumnY1 + 1
         Locatef RowX2, ColumnY2, 1
         ' restore color.
         TempZ = Area2(RowX1, ColumnY1)
         ' undocumented: also stores background color.
         VarB = Int(TempZ / 16)
         VarF = TempZ Mod 16
         Colorf2 VarF, VarB
         ' restore ascii character.
         Printf Chr$(Area1(RowX1, ColumnY1))
      Next
   Next
   Return

   ' moves menu up, wrapping.
   MenuUp:
   GoSub EraseCurrentMenuSelection
   If MenuSelect = 1 Then
      MenuSelect = MaxFiles
   Else
      MenuSelect = MenuSelect - 1
   End If
   GoSub DrawCurrentMenuSelection
   Return

   ' moves menu down, wrapping.
   MenuDown:
   GoSub EraseCurrentMenuSelection
   If MenuSelect = MaxFiles Then
      MenuSelect = 1
   Else
      MenuSelect = MenuSelect + 1
   End If
   GoSub DrawCurrentMenuSelection
   Return

   ' moves menu to top
   MenuFirst:
   GoSub EraseCurrentMenuSelection
   If MenuSelect <> 1 Then
      MenuSelect = 1
   End If
   GoSub DrawCurrentMenuSelection
   Return

   ' moves menu to bottom
   MenuLast:
   GoSub EraseCurrentMenuSelection
   If MenuSelect <> MaxFiles Then
      MenuSelect = MaxFiles
   End If
   GoSub DrawCurrentMenuSelection
   Return

   ' removes hilight from current menu selection.
   EraseCurrentMenuSelection:
   Colorf2 White, 0
   GoSub DisplayCurrentMenuSelection
   Colorf2 White, 0
   Return

   ' adds hilight to current menu selection.
   DrawCurrentMenuSelection:
   Colorf2 White, 1
   GoSub DisplayCurrentMenuSelection
   Colorf2 White, 0
   Return

   ' draws current menu selection.
   DisplayCurrentMenuSelection:
   Locatef 4 + MenuSelect, 7, 0
   Printf Hex$(MenuSelect) + " "
   If MenuSelect > NumberFiles Then
      Printf "<none>      "
      Call ClearStatus
      Printf "View file " + Hex$(MenuSelect) + ": <none>"
   Else
      Printf File(MenuSelect).Filename
      GoSub DisplayPath
   End If
   Return

   ' display path of file being edited.
   DisplayPath:
   Call ClearStatus
   N$ = RTrim$(File(MenuSelect).Netpath)
   Z$ = RTrim$(File(MenuSelect).ShortFilename)
   If N$ <> Nul Then
      If Mid$(Z$, 2, 1) = ":" Then
         Z$ = Mid$(Z$, 3)
      End If
   End If
   Call Deconcatenate(N$, Z$, 64)
   Var = Len(Z$)
   Do
      Var = Var - 1
      If Var = False Then
         Z$ = Nul
         Exit Do
      End If
      If Mid$(Z$, Var, 1) = "\" Then
         Z$ = Left$(Z$, Var)
         Exit Do
      End If
   Loop
   If Z$ = Nul Then
      Z$ = "\"
   End If
   Printf "Viewing path: " + Z$ + " "
   FileDisplay2 = True
   Return

   ' process left mouse button.
   MouseButton1Y:
   If MouseX = 0 Then
      Return
   End If

   ' test mouse click outside of box,
   If MouseX < 4 Or MouseX > 14 Then
      GoSub RestoreArea
      Var = False
      Exit Sub
   End If
   If MouseY < 6 Or MouseY > 21 Then
      GoSub RestoreArea
      Var = False
      Exit Sub
   End If

   ' test mouse click inside of box.
   If MouseX >= 5 And MouseX <= 13 Then
      If MouseY >= 7 And MouseY <= 20 Then
         Var = MouseX - 4
         GoSub RestoreArea
         Exit Sub
      End If
   End If
   Return

   ' process mouse move.
   MoveMouse:
   ' check mouse selection boundaries.
   If MouseX >= 5 And MouseX <= 13 Then
      If MouseY >= 7 And MouseY <= 20 Then
         If MouseX - 4 <> MenuSelect Then
            GoSub EraseCurrentMenuSelection
            MenuSelect = MouseX - 4
         End If
         GoSub DrawCurrentMenuSelection
      End If
   End If
   Return
End Sub

' sorts Windows directories/filenames in
'   hexedit1.da?, hexedit2.da? files.
Sub SortFiles (Var1)
   Dim I1 As String, I2 As String
   ' sort windows filenames.
   If Var1 = 1 Then
      Num! = Num.Files
      ' perform heap sort.
      If FileSort Then
         ' descending.
         For I! = 2! To Num!
            J! = I!
            Do Until J! = 1!
               P! = J! \ 2!
               I1 = RTrim$(Filenames(J!))
               I2 = RTrim$(Filenames(P!))
               If I1 < I2 Then
                  WinFileStruc.Name = I2
                  Put #2, J!, WinFileStruc
                  WinFileStruc.Name = I1
                  Put #2, P!, WinFileStruc
                  J! = P!
               Else
                  Exit Do
               End If
            Loop
         Next
         For I! = Num! To 2! Step -1!
            I1 = RTrim$(Filenames(1!))
            I2 = RTrim$(Filenames(I!))
            WinFileStruc.Name = I2
            Put #2, 1!, WinFileStruc
            WinFileStruc.Name = I1
            Put #2, I!, WinFileStruc
            J! = 1!
            Do
               If 2! * J! > I! - 1! Then
                  Exit Do
               End If
               C! = 2! * J!
               If C! + 1! <= I! - 1! Then
                  If Filenames(C! + 1!) < Filenames(C!) Then
                     C! = C! + 1!
                  End If
               End If
               I1 = RTrim$(Filenames(J!))
               I2 = RTrim$(Filenames(C!))
               If I1 >= I2 Then
                  WinFileStruc.Name = I2
                  Put #2, J!, WinFileStruc
                  WinFileStruc.Name = I1
                  Put #2, C!, WinFileStruc
                  J! = C!
               Else
                  Exit Do
               End If
            Loop
         Next
      Else
         ' ascending.
         For I! = 2! To Num!
            J! = I!
            Do Until J! = 1!
               P! = J! \ 2!
               I1 = RTrim$(Filenames(J!))
               I2 = RTrim$(Filenames(P!))
               If I1 > I2 Then
                  WinFileStruc.Name = I2
                  Put #2, J!, WinFileStruc
                  WinFileStruc.Name = I1
                  Put #2, P!, WinFileStruc
                  J! = P!
               Else
                  Exit Do
               End If
            Loop
         Next
         For I! = Num! To 2! Step -1!
            I1 = RTrim$(Filenames(1!))
            I2 = RTrim$(Filenames(I!))
            WinFileStruc.Name = I2
            Put #2, 1!, WinFileStruc
            WinFileStruc.Name = I1
            Put #2, I!, WinFileStruc
            J! = 1!
            Do
               If 2! * J! > I! - 1! Then
                  Exit Do
               End If
               C! = 2! * J!
               If C! + 1! <= I! - 1! Then
                  If Filenames(C! + 1!) > Filenames(C!) Then
                     C! = C! + 1!
                  End If
               End If
               I1 = RTrim$(Filenames(J!))
               I2 = RTrim$(Filenames(C!))
               If I1 < I2 Then
                  WinFileStruc.Name = I2
                  Put #2, J!, WinFileStruc
                  WinFileStruc.Name = I1
                  Put #2, C!, WinFileStruc
                  J! = C!
               Else
                  Exit Do
               End If
            Loop
         Next
      End If
      ' sort windows directories.
   Else
      Num! = Num.Dirs
      Start! = 0!
      If RTrim$(Directories(1)) = ".." Then
         Start! = 1!
      End If
      If Start! >= Num! Then
         Exit Sub
      End If
      ' perform insertion sort.
      For R! = 2! + Start! To Num!
         I1 = RTrim$(Directories(R!))
         For J! = R! To 2! + Start! Step -1!
            I2 = RTrim$(Directories(J! - 1!))
            ' descending.
            If DirSort Then
               If I2 < I1 Then
                  WinFileStruc.Name = I2
                  Put #3, J!, WinFileStruc
               Else
                  Exit For
               End If
            Else
               ' ascending.
               If I2 > I1 Then
                  WinFileStruc.Name = I2
                  Put #3, J!, WinFileStruc
               Else
                  Exit For
               End If
            End If
         Next
         WinFileStruc.Name = I1
         Put #3, J!, WinFileStruc
      Next
   End If
End Sub

Sub GetInfo (VarZ, VarZ$)
   If VarZ = 0 Then
      X$ = Nul
      If (FileAttribute And 1) = 1 Then
         X$ = X$ + "o"
      End If
      If (FileAttribute And 2) = 2 Then
         X$ = X$ + "h"
      End If
      If (FileAttribute And 4) = 4 Then
         X$ = X$ + "s"
      End If
      If (FileAttribute And 32) = 32 Then
         X$ = X$ + "a"
      End If
      If X$ <> Nul Then
         X$ = " (" + X$ + ")"
      End If
      VarZ$ = X$
      Exit Sub
   End If
 
   ' construct file date and time for display.
   FileDateTime = Nul
   FileSize = False
   hfind = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      FileAttribute = finddata.dwFileAttributes
      FileSize = finddata.nFileSizeHigh * &H100000000~&& Or finddata.nFileSizeLow
      Select Case FileSwitch
         Case 0 ' last modified /TW
            x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
         Case 1 ' creation /TC
            x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
         Case 2 ' last accessed /TA
            x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
         Case Else ' /TW
            x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
      End Select
      FileDateTime = "[" + GetDateTime$(z) + "]"
      x = FindClose(hfind)
      Exit Sub
   End If

   ' get file attribute.
   FileAttribute = GetFileAttr(ASCIIZ)
End Sub

' returns MM-DD-YYYY HH:MM:SS
Function GetDateTime$ (z)
   z = 0
   Var$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
   Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
   Var$ = Var$ + LTrim$(Str$(SysTime.wYear)) + " "

   Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wHour)), 2) + ":"
   Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wMinute)), 2) + ":"
   Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wSecond)), 2)
   GetDateTime$ = Var$
End Function

' search file subroutine.
'   input:
'     Var = 0 search with ascii string input.
'     Var = 1 search with hex string input.
'     Var = 2 continue search from previous input.
'   output:
'     FoundString = 1 invalid search string input.
'     FoundString = 0 search string not found.
'     FoundString = -1 search string found.
'     SearchBytePosition = location of start of search string in file.
Sub SearchFile (Var, FoundString)
   FoundString = False
   ' check to continue search.
   If Var = 2 Then
      ByteString$ = RTrim$(StoreSearchString)
      NumBytes = StoreNumBytes
      GoTo StartSearch
   End If
   ' search multiple bytes of an ASCII string in file and locate there.
   If Var = 0 Then
      Call ClearStatus
      Printf "Enter ASCII string?"
      ByteString$ = LineInput$(2, 24, 54)
      If Len(ByteString$) = False Then
         StatusMessage = "Invalid search string."
         Call DisplayStatus2
         FoundString = 1
         Exit Sub
      End If
      NumBytes = Len(ByteString$)
      Call AsciiToHex2(ByteString$)
   Else
      ' search multiple bytes in file and locate there.
      '   left window specifies space-separated hex byte pairs,
      '   right window specifies space-separated 3-byte ascii pairs.
      Call ClearStatus
      If CurrentWindow = False Then
         Printf "Enter hex byte(s)?"
         ByteString$ = LineInput$(2, 23, 55)
         If Left$(ByteString$, 1) = "+" Then
            ByteString$ = Mid$(ByteString$, 2)
            Call CheckAsciiBytes(ByteString$)
         Else
            AllowWildCard = True
            Call CheckHexBytes(ByteString$)
         End If
      Else
         Printf "Enter ascii byte(s)?"
         ByteString$ = LineInput$(2, 25, 53)
         If UCase$(Left$(ByteString$, 1)) = "H" Then
            ByteString$ = Mid$(ByteString$, 2)
            AllowWildCard = True
            Call CheckHexBytes(ByteString$)
         Else
            Call CheckAsciiBytes(ByteString$)
         End If
      End If
      If ValidByteString = False Then
         StatusMessage = "Invalid search string."
         Call DisplayStatus2
         FoundString = 1
         Exit Sub
      End If
   End If
   StartSearch:
   ' display searching message.
   Call ClearStatus
   DisplayLength = Len(ByteString$)
   If DisplayLength > 28 Then
      Var$ = "Searching for " + Left$(ByteString$, 28) + "..."
   Else
      Var$ = "Searching for " + ByteString$ + ":"
   End If
   Var$ = Var$ + " (Press <esc> to quit)"
   CursorLocation = Len(Var$) + 4
   Printf Var$

   ' store search variables.
   FoundString = False
   Call ClearPageByte
   LastPage = FilePage
   OriginalString$ = ByteString$
   StoreSearchString = ByteString$
   StoreNumBytes = NumBytes
   ByteSearch1 = InStr(ByteString$, "?")
   StoreSearchPosition = FilePosition
   TotalByte$ = Nul

   ' check continue search.
   If Var = 2 Then
      ' check continue from last position.
      If StoreSearchPosition = FilePosition Then
         If FilePosition + 1 > FileLength Then
            Exit Sub
         End If
         ' reset search type.
         Var = 3
         ' increment from previous search position.
         FilePosition = FilePosition + 1
      End If
   End If

   ' store initial byte string.
   SearchBytePosition = FilePosition
   For FileBytePosition = FilePosition To FilePosition + NumBytes - 1
      If FileBytePosition > FileLength Then
         If Var = 3 Then
            FilePosition = FilePosition - 1
         End If
         FoundString = False
         Exit Sub
      End If
      SeekPosition = FileBytePosition
      Call LseekFile
      Call ReadFile
      FileByte = Buffer
      Byte$ = Hex$(Asc(FileByte))
      Byte$ = Right$("00" + Byte$, 2)
      TotalByte$ = TotalByte$ + Byte$
   Next

   ' reset search variables.
   Byte1# = 1#
   RemainingBytes# = FileLength - FilePosition + 1
   FileBytePosition = FilePosition + NumBytes - 1
   PercentDisplayed! = SFalse
   Locatef 2, CursorLocation, 0
   Printf " 0%"

   ' continue search.
   Do
      ' fill in ? character
      If ByteSearch1 Then
         ByteString$ = OriginalString$
         For TotalBytes = 1 To NumBytes * 2
            Byte1$ = Mid$(ByteString$, TotalBytes, 1)
            Byte2$ = Mid$(TotalByte$, TotalBytes, 1)
            If Byte1$ = "?" Then
               Mid$(ByteString$, TotalBytes, 1) = Byte2$
            End If
         Next
      End If

      ' compare byte strings
      If ByteString$ = TotalByte$ Then
         StoreSearchPosition = SearchBytePosition
         FoundString = True
         Exit Do
      End If

      ' get next byte
      FileBytePosition = FileBytePosition + 1
      If FileBytePosition > FileLength Then
         If Var = 3 Then
            FilePosition = FilePosition - 1
         End If
         FoundString = False
         Exit Do
      End If

      ' increment byte search variables.
      Byte1# = Byte1# + 1#
      SearchBytePosition = SearchBytePosition + 1#
      SeekPosition = FileBytePosition
      Call LseekFile
      Call ReadFile
      FileByte = Buffer
      Byte$ = Hex$(Asc(FileByte))
      Byte$ = Right$("00" + Byte$, 2)
      TotalByte$ = Mid$(TotalByte$, 3) + Byte$

      ' display percent remaining
      PercentCopied! = Int(CSng(Byte1# / RemainingBytes#) * 100!)
      If PercentCopied! > PercentDisplayed! Then
         Locatef 2, CursorLocation, 0
         Printf Str$(PercentCopied!) + "%"
         PercentDisplayed! = PercentCopied!
      End If

      ' check to exit search
      If INKEYx$ = Chr$(27) Then
         Exit Do
      End If
   Loop
End Sub

Rem constructs and checks filelist filename exists.
Rem   returns ambiguated filename.
Function FILELISTEXISTS$ (Var$)
   ' construct filelist filename.
   VarX$ = Var$
   V = InStr(VarX$, "@")
   If V = 0 Then
      FILELISTEXISTS$ = Nul
      Exit Function
   End If
   For V = Len(VarX$) To 1 Step -1
      If Mid$(VarX$, V, 1) = "@" Then
         Exit For
      End If
   Next
   If V = 1 Then ' @filelist.txt
      VarX$ = Mid$(VarX$, V + 1)
   Else
      If V > 1 Then
         If Mid$(VarX$, V - 1, 1) = "\" Then ' \dos\@filelist.txt
            VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
         Else
            If Mid$(VarX$, V - 1, 1) = ":" Then ' c:@filelist.txt
               VarX$ = Left$(VarX$, V - 1) + Mid$(VarX$, V + 1)
            End If
         End If
      End If
   End If
   ' check filelist filename exists.
   If InStr(V, VarX$, "\") Then ' c:\@path\filename.ext
      FILELISTEXISTS$ = Nul
   Else
      If _FileExists(VarX$) = 0 Then
         FILELISTEXISTS$ = Nul
      Else
         FILELISTEXISTS$ = VarX$
      End If
   End If
End Function

' test volume media inserted.
' returns -1 if error.
Function MEDIAEXISTS (V)
   ' check drive exists.
   If DRIVEEXISTS(V) Then
      MEDIAEXISTS = False
      Exit Function
   End If
   ' get drive info.
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   r = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If r Then ' non-zero if error.
      MEDIAEXISTS = True
   Else
      MEDIAEXISTS = False
   End If
End Function

' get drive information.
Sub GetDriveInfo (DriveAttribute$)
   ' reset drive info.
   DriveAttribute$ = Nul

   ' check drive exists.
   If DRIVEEXISTS(Current.Drive) Then
      Exit Sub
   End If

   ' get drive info.
   VarX$ = Chr$(Current.Drive + 64) + ":\" + Chr$(0)
   Vname$ = Space$(MAX_PATH)
   Fname$ = Space$(MAX_PATH)
   R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
   If R Then
      ' get volume label.
      tmp1$ = RTrim$(Vname$)
      v = InStr(tmp1$, Chr$(0))
      If v Then tmp1$ = Left$(tmp1$, v - 1)
      DriveAttribute$ = tmp1$

      ' check quiet switch.
      Select Case QuietSwitch
         Case -1, 4, 5, 6
            Exit Sub
      End Select

      ' serial number.
      Sname$ = Left$(Hex$(serial~&), 4) + "-" + Right$(Hex$(serial~&), 4)
      DriveAttribute$ = DriveAttribute$ + " (" + Sname$ + ")"

      ' file system type.
      tmp1$ = RTrim$(Fname$)
      v = InStr(tmp1$, Chr$(0))
      If v Then tmp1$ = Left$(tmp1$, v - 1)
      DriveAttribute$ = DriveAttribute$ + " [" + tmp1$ + "]"
      Exit Sub
   End If
   DriveAttribute$ = DriveType
End Sub

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
   If V = 1 Then
      DriveType = "[FLOPPY A]"
      DRIVEEXISTS = 0
      Exit Function
   End If
   If V = 2 Then
      DriveType = "[FLOPPY B]"
      DRIVEEXISTS = 0
      Exit Function
   End If
   VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
   VarX = GetDriveType(VarX$)
   DriveType = Nul
   Select Case VarX
      Case 0
         DriveType = "[UNKNOWN]"
      Case 1
         DriveType = "[BADROOT]"
      Case 2
         DriveType = "[REMOVABLE]"
      Case 3
         DriveType = "[FIXED]"
      Case 4
         DriveType = "[REMOTE]"
      Case 5
         DriveType = "[CDROM]"
      Case 6
         DriveType = "[RAMDISK]"
   End Select
   If VarX > 1 Then
      DRIVEEXISTS = 0
   Else
      DRIVEEXISTS = -1
   End If
End Function

' check netpath exists.
'  returns -1 if netpath not detected.
Function NETPATHEXISTS (Z$)
   VarX$ = Z$ + Chr$(0)
   VarX = GetDriveType(VarX$)
   If VarX > 1 Then
      NETPATHEXISTS = 0
   Else
      NETPATHEXISTS = -1
   End If
End Function

' delete process filenames.
Sub Delete.Process
   ' close all files.
   Close

   ' set error trap flag
   InErrorFlag = -1

   ' special debug purposes.
   If Debug2 Then
      Exit Sub
   End If

   ' DOS shell temp file.
   Var$ = "DOSEXIT" + Mid$(Str$(Process.Number), 2) + ".BAT"
   GoSub Remove.File

   ' multiple temp files. where ? is processnumber.
   Rem MultiFilename1(1) = d:\path\UNDOBYTE.DA? ' byte undo file.
   Rem MultiFilename1(2) = d:\path\MARKERS1.DA? ' marker file.
   Rem MultiFilename1(3) = d:\path\COPYFILE.DA? ' paste file.
   Rem MultiFilename1(4) = d:\path\HEXEDIT1.DA? ' filenames.
   Rem MultiFilename1(5) = d:\path\HEXEDIT2.DA? ' directories.

   For Var = 1 To 5
      Var$ = MultiFilename1(Var)
      GoSub Remove.File
   Next

   ' multiple paste undo files. where ? is processnumber, * is filenumber.
   Rem MultiFilenames(1 To 15) = d:\path\UNDOFIL?.DA*

   For Var = 1 To MaxFiles
      Var$ = MultiFilenames(Var)
      GoSub Remove.File
   Next
   Exit Sub

   ' remove temporary datafile.
   Remove.File:
   Var$ = RTrim$(Var$)
   If Len(Var$) Then
      If _FileExists(Var$) Then
         G$ = Var$ + Chr$(0)
         x = DeleteFileA(G$)
         If Debug Then
            Locatef CsrLin + 1, 1, 1
            Printf "Killed: " + Var$
         End If
      End If
   End If
   Return
End Sub

Rem Marker and Hilighting subroutines.
Rem Hex/Dec calculator subroutine.
Rem Formatting subroutine.
Rem File menu box move subroutine.
Rem File menu box file/dir override subroutine.
Rem File exclusion subourtine.
Rem Path override subroutines.
Rem Specialized LINE INPUT subroutine.
Rem LoadDirSpec menu subroutine.
Rem LoadFileSpec menu subroutine.

Rem Marker routines:

Sub Marker (Var)
   If Var = 1 Then GoTo ListMarkerRange
   If Var = 2 Then GoTo AddMarker
   If Var = 3 Then GoTo AddSpecificMarker
   If Var = 4 Then GoTo DeleteMarker
   If Var = 5 Then GoTo DeleteSpecificMarker
   If Var = 6 Then GoTo JumpPreviousMarker
   If Var = 7 Then GoTo JumpCurrentMarker
   If Var = 8 Then GoTo JumpNextMarker
   If Var = 9 Then GoTo JumpSpecificMarker
   If Var = 10 Then GoTo ListAllMarkers
   If Var = 11 Then GoTo ListSpecificMarker
   If Var = 12 Then GoTo ListMarkersOfValue
   If Var = 13 Then GoTo DeleteMarkerRange
   If Var = 14 Then GoTo DeleteAllMarkers
   If Var = 15 Then GoTo DeleteMarkersOfValue
   Exit Sub

   AddMarker:
   TempPosition3 = FilePosition
   GoSub AddMarkerValue
   Exit Sub

   AddMarkerValue:
   If MarkerCount = 1048576! Then
      StatusMessage = "Maximum markers are at 1,048,576."
      Call DisplayStatus2
      Return
   End If
   If MarkerCount < 1048576! Then
      MarkerCount = MarkerCount + 1!
      Get #7, MarkerCount, MarkerFile
      Mid$(MarkerFile.Markers1, (CurrentFile - 1) * 8 + 1, 8) = MKD$(TempPosition3)
      Put #7, MarkerCount, MarkerFile
      CurrentMarker = MarkerCount
   End If
   Return

   AddSpecificMarker:
   Call ClearStatus
   Printf "Enter file position?"
   ByteString$ = LineInput$(2, 25, 10)
   If UCase$(Left$(ByteString$, 1)) = "H" Then
      Call CheckHexValue(ByteString$)
      If ValidHexValue = False Then
         Exit Sub
      End If
      TempPosition3 = HexValue
   Else
      Call CheckASCIIValue(ByteString$)
      If ValidASCIIValue = False Then
         Exit Sub
      End If
      TempPosition3 = ASCIIValue3
   End If
   If TempPosition3 >= 1 And TempPosition3 <= FileLength Then
      GoSub AddMarkerValue
      Call LocateCursor2
      Call DisplayFilename
      Exit Sub
   End If
   StatusMessage = "Invalid file position."
   Call DisplayStatus2
   Exit Sub

   DeleteMarker:
   If CurrentMarker >= 1! And CurrentMarker <= MarkerCount Then
      Get #7, CurrentMarker, MarkerFile
      Mid$(MarkerFile.Markers1, (CurrentFile - 1) * 8 + 1, 8) = MKD$(0#)
      Put #7, CurrentMarker, MarkerFile
   End If
   Exit Sub

   DeleteSpecificMarker:
   Call ClearStatus
   Printf "Enter marker number?"
   ByteString$ = LineInput$(2, 25, 10)
   If Len(ByteString$) Then
      If UCase$(Left$(ByteString$, 1)) = "H" Then
         ByteString$ = "&" + ByteString$
      End If
      MarkerPosition = Int(Val(ByteString$))
      If MarkerPosition >= 1! And MarkerPosition <= MarkerCount Then
         Get #7, MarkerPosition, MarkerFile
         Mid$(MarkerFile.Markers1, (CurrentFile - 1) * 8 + 1, 8) = MKD$(0#)
         Put #7, MarkerPosition, MarkerFile
         Call LocateCursor2
         Call DisplayFilename
         Exit Sub
      End If
   End If
   StatusMessage = "Invalid marker number."
   Call DisplayStatus2
   Exit Sub

   JumpPreviousMarker:
   NewMarker = CurrentMarker
   Do
      If NewMarker <= 1! Then
         Exit Sub
      End If
      NewMarker = NewMarker - 1!
      If Markers#(NewMarker) > 0# Then
         CurrentMarker = NewMarker
         Exit Do
      End If
   Loop
   GoTo JumpCurrentMarker

   JumpNextMarker:
   NewMarker = CurrentMarker
   Do
      If NewMarker >= MarkerCount Then
         Exit Sub
      End If
      NewMarker = NewMarker + 1!
      If Markers#(NewMarker) > 0# Then
         CurrentMarker = NewMarker
         Exit Do
      End If
   Loop
   GoTo JumpCurrentMarker

   JumpSpecificMarker:
   Call ClearStatus
   Printf "Enter marker number?"
   ByteString$ = LineInput$(2, 25, 10)
   If Len(ByteString$) Then
      If UCase$(Left$(ByteString$, 1)) = "H" Then
         ByteString$ = "&" + ByteString$
      End If
      MarkerPosition = Int(Val(ByteString$))
      If MarkerPosition >= 1! And MarkerPosition <= MarkerCount Then
         If Markers#(MarkerPosition) > 0# Then
            CurrentMarker = MarkerPosition
            GoTo JumpCurrentMarker
         End If
      End If
   End If
   StatusMessage = "Invalid marker number."
   Call DisplayStatus2
   Exit Sub

   JumpCurrentMarker:
   If CurrentMarker >= 1! And CurrentMarker <= MarkerCount Then
      TempPosition = Markers#(CurrentMarker)
      If TempPosition >= 1 And TempPosition <= FileLength Then
         If TempPosition <> FilePosition Then
            Call ClearPageByte
            LastPage = FilePage
            FilePosition = TempPosition
            Call CalculatePosition1
            If LastPage <> FilePage Then
               Call DisplayHexPage
            End If
            Call DisplayPageByte
         End If
      End If
   End If
   Call DisplayFilename
   Exit Sub

   ListAllMarkers:
   Call DisplayScreen2
   Colorf White
   Locatef 2, 2, 0
   Printf "Marker list:"
   PageCount = False
   CountFlag = False
   Var2 = 2
   For MarkerPosition = 1! To MarkerCount
      If Markers#(MarkerPosition) > 0# Then
         PageCount = PageCount + 1
         CountFlag = True
         Colorf Yellow
         Var2 = Var2 + 1
         Locatef Var2, 2, 0
         Call FormatPosition2(2)
         If PageCount >= 20 Then
            PageCount = False
            Locatef 23, 2, 0
            Call PressKey
            Call DisplayScreen2
            Colorf White
            Locatef 2, 2, 0
            Printf "Marker list:"
            Var2 = 2
         End If
      End If
   Next
   If CountFlag = False Then
      Colorf Yellow
      Locatef 3, 2, 0
      Printf "No markers stored."
      Locatef 23, 2, 0
      Call PressKey
   End If
   If PageCount > False Then
      Locatef 23, 2, 0
      Call PressKey
   End If
   Exit Sub

   ListSpecificMarker:
   Call ClearStatus
   Printf "Enter marker number?"
   ByteString$ = LineInput$(2, 25, 10)
   If Len(ByteString$) Then
      If UCase$(Left$(ByteString$, 1)) = "H" Then
         ByteString$ = "&" + ByteString$
      End If
      MarkerPosition = Int(Val(ByteString$))
      If MarkerPosition >= 1! And MarkerPosition <= MarkerCount Then
         Call ClearStatus
         Call FormatPosition2(1)
         Call LocateCursor2
         Call PromptKey
         Call DisplayFilename
         Exit Sub
      End If
   End If
   StatusMessage = "Invalid marker number."
   Call DisplayStatus2
   Exit Sub

   ListMarkersOfValue:
   Call ClearStatus
   Printf "Enter marker value?"
   ByteString$ = LineInput$(2, 24, 10)
   If UCase$(Left$(ByteString$, 1)) = "H" Then
      Call CheckHexValue(ByteString$)
      If ValidHexValue = False Then
         Exit Sub
      End If
      TempPosition1 = HexValue
   Else
      Call CheckASCIIValue(ByteString$)
      If ValidASCIIValue = False Then
         Exit Sub
      End If
      TempPosition1 = ASCIIValue3
   End If
   Call DisplayScreen2
   Colorf White
   Locatef 2, 2, 0
   Printf "Marker list:"
   PageCount = False
   CountFlag = False
   Var2 = 2
   For MarkerPosition = 1! To MarkerCount
      If Markers#(MarkerPosition) = TempPosition1 Then
         PageCount = PageCount + 1
         CountFlag = True
         Colorf Yellow
         Var2 = Var2 + 1
         Locatef Var2, 2, 0
         Call FormatPosition2(2)
         If PageCount >= 20 Then
            PageCount = False
            Locatef 23, 2, 0
            Call PressKey
            Call DisplayScreen2
            Colorf White
            Locatef 2, 2, 0
            Printf "Marker list:"
            Var2 = 2
         End If
      End If
   Next
   If CountFlag = False Then
      Colorf Yellow
      Locatef 3, 2, 0
      Printf "No markers of value stored."
      Locatef 23, 2, 0
      Call PressKey
   End If
   If PageCount > False Then
      Locatef 23, 2, 0
      Call PressKey
   End If
   Exit Sub

   ListMarkerRange:
   Call ClearStatus
   Printf "Enter beginning marker number?"
   ByteString$ = LineInput$(2, 35, 10)
   If Len(ByteString$) Then
      If UCase$(Left$(ByteString$, 1)) = "H" Then
         ByteString$ = "&" + ByteString$
      End If
      MarkerPosition1 = Int(Val(ByteString$))
      If MarkerPosition1 >= 1! And MarkerPosition1 <= MarkerCount Then
         Call ClearStatus
         Printf "Enter ending marker number?"
         ByteString$ = LineInput$(2, 32, 10)
         If Len(ByteString$) Then
            If UCase$(Left$(ByteString$, 1)) = "H" Then
               ByteString$ = "&" + ByteString$
            End If
            MarkerPosition2 = Int(Val(ByteString$))
            If MarkerPosition2 >= 1! And MarkerPosition2 <= MarkerCount Then
               Call DisplayScreen2
               Colorf White
               Locatef 2, 2, 0
               Printf "Marker list:"
               PageCount = False
               CountFlag = False
               Var2 = 2
               For MarkerPosition = MarkerPosition1 To MarkerPosition2
                  If Markers#(MarkerPosition) > 0# Then
                     PageCount = PageCount + 1
                     CountFlag = True
                     Colorf Yellow
                     Var2 = Var2 + 1
                     Locatef Var2, 2, 0
                     Call FormatPosition2(2)
                     If PageCount >= 20 Then
                        PageCount = False
                        Locatef 23, 2, 0
                        Call PressKey
                        Call DisplayScreen2
                        Colorf White
                        Locatef 2, 2, 0
                        Printf "Marker list:"
                        Var2 = 2
                     End If
                  End If
               Next
               If CountFlag = False Then
                  Colorf Yellow
                  Locatef 3, 2, 0
                  Printf "No markers stored."
                  Locatef 23, 2, 0
                  Call PressKey
               End If
               If PageCount > False Then
                  Locatef 23, 2, 0
                  Call PressKey
               End If
               ValidFunction = True
               Exit Sub
            End If
         End If
      End If
   End If
   ValidFunction = False
   StatusMessage = "Invalid marker range."
   Call DisplayStatus2
   Exit Sub

   DeleteMarkerRange:
   Call ClearStatus
   Printf "Enter beginning marker number?"
   ByteString$ = LineInput$(2, 35, 10)
   If Len(ByteString$) Then
      If UCase$(Left$(ByteString$, 1)) = "H" Then
         ByteString$ = "&" + ByteString$
      End If
      MarkerPosition1 = Int(Val(ByteString$))
      If MarkerPosition1 >= 1! And MarkerPosition1 <= MarkerCount Then
         Call ClearStatus
         Printf "Enter ending marker number?"
         ByteString$ = LineInput$(2, 32, 10)
         If Len(ByteString$) Then
            If UCase$(Left$(ByteString$, 1)) = "H" Then
               ByteString$ = "&" + ByteString$
            End If
            MarkerPosition2 = Int(Val(ByteString$))
            If MarkerPosition2 >= 1! And MarkerPosition2 <= MarkerCount Then
               For MarkerPosition = MarkerPosition1 To MarkerPosition2
                  Get #7, MarkerPosition, MarkerFile
                  Mid$(MarkerFile.Markers1, (CurrentFile - 1) * 8 + 1, 8) = MKD$(0#)
                  Put #7, MarkerPosition, MarkerFile
               Next
               StatusMessage = "Range of markers deleted."
               Call DisplayStatus2
               Exit Sub
            End If
         End If
      End If
   End If
   StatusMessage = "Invalid marker range."
   Call DisplayStatus2
   Exit Sub

   DeleteAllMarkers:
   CurrentMarker = False
   MarkerCount = False
   StatusMessage = "All markers deleted."
   Call DisplayStatus2
   Exit Sub

   DeleteMarkersOfValue:
   Call ClearStatus
   Printf "Enter marker value?"
   ByteString$ = LineInput$(2, 24, 10)
   If Len(ByteString$) Then
      If UCase$(Left$(ByteString$, 1)) = "H" Then
         Call CheckHexValue(ByteString$)
         If ValidHexValue = False Then
            Exit Sub
         End If
         TempPosition1 = HexValue
      Else
         Call CheckASCIIValue(ByteString$)
         If ValidASCIIValue = False Then
            Exit Sub
         End If
         TempPosition1 = ASCIIValue3
      End If
      For MarkerPosition = 1! To MarkerCount
         If Markers#(MarkerPosition) = TempPosition1 Then
            Get #7, MarkerPosition, MarkerFile
            Mid$(MarkerFile.Markers1, (CurrentFile - 1) * 8 + 1, 8) = MKD$(0#)
            Put #7, MarkerPosition, MarkerFile
         End If
      Next
   End If
   StatusMessage = "All markers of value deleted."
   Call DisplayStatus2
   Exit Sub
End Sub

Rem Hilighting key routines:

Rem process left mouse button drag.
Rem   also includes shift-<key> hilighting.

Sub MouseButton1Drag (Var)
   If Var = 0 Then GoTo DragMouse
   If Var = 1 Then GoTo ShiftLeftKey
   If Var = 2 Then GoTo ShiftRightKey
   If Var = 3 Then GoTo ShiftUpKey
   If Var = 4 Then GoTo ShiftDownKey
   If Var = 5 Then GoTo ShiftPageUpKey
   If Var = 6 Then GoTo ShiftPageDownKey
   If Var = 7 Then GoTo ShiftEndKey
   If Var = 8 Then GoTo ShiftHomeKey
   If Var = 9 Then GoTo DragMousePageUp
   If Var = 10 Then GoTo DragMousePageDown
   Exit Sub

   ' move hilight area left.
   ShiftLeftKey:
   If FilePosition = 1 Then
      GoSub StoreHilight
   Else
      If PageColumn - 1 >= 1 Then
         GoSub StoreHilight
         If CopyPositionEnd - 1 >= CopyPositionPivot Then
            Call ClearHilightByte
            PageColumn = PageColumn - 1
            FilePosition = FilePosition - 1
            CopyPositionEnd = CopyPositionEnd - 1
         Else
            If CopyPositionStart - 1 <= CopyPositionPivot Then
               PageColumn = PageColumn - 1
               FilePosition = FilePosition - 1
               CopyPositionStart = CopyPositionStart - 1
            Else
               Exit Sub
            End If
         End If
      End If
   End If
   Call DisplayHilightByte
   Call LocateHilightCursor
   Exit Sub

   ' move hilight area right.
   ShiftRightKey:
   If FilePosition = FileLength Then
      GoSub StoreHilight
   Else
      If PageColumn = 20 Then
         GoSub StoreHilight
      Else
         If PageColumn + 1 <= 20 Then
            If FilePosition + 1 <= FileLength Then
               If CopyPositionStart = DFalse Then
                  GoSub StoreHilight
               Else
                  If CopyPositionStart + 1 <= CopyPositionPivot Then
                     Call ClearHilightByte
                     PageColumn = PageColumn + 1
                     FilePosition = FilePosition + 1
                     CopyPositionStart = CopyPositionStart + 1
                  Else
                     If CopyPositionEnd + 1 >= CopyPositionPivot Then
                        PageColumn = PageColumn + 1
                        FilePosition = FilePosition + 1
                        CopyPositionEnd = CopyPositionEnd + 1
                     Else
                        Exit Sub
                     End If
                  End If
               End If
            End If
         End If
      End If
   End If
   Call DisplayHilightByte
   Call LocateHilightCursor
   Exit Sub

   ' move hilight area up.
   ShiftUpKey:
   If PageRow - 1 >= 1 Then
      GoSub StoreHilight
      If CopyPositionEnd > CopyPositionPivot Then
         If CopyPositionEnd - 20 >= CopyPositionPivot Then
            Temp# = FilePosition
            Temp2# = PageRow
            For FilePosition = CopyPositionEnd To CopyPositionEnd - 20 Step -1
               Call CalculatePosition1
               Call ClearHilightByte
            Next
            PageRow = Temp2# - 1
            FilePosition = Temp# - 20
            CopyPositionEnd = CopyPositionEnd - 20
            Call CalculatePosition1
            Call DisplayHilightByte
            Call LocateHilightCursor
         Else
            If CopyPositionEnd - 20 < CopyPositionPivot Then
               Temp# = FilePosition
               Temp2# = PageRow
               For FilePosition = CopyPositionPivot To CopyPositionEnd
                  Call CalculatePosition1
                  Call ClearHilightByte
               Next
               CopyPositionStart = CopyPositionEnd - 20
               CopyPositionEnd = CopyPositionPivot
               For FilePosition = CopyPositionStart To CopyPositionPivot
                  Call CalculatePosition1
                  Call DisplayHilightByte
               Next
               PageRow = Temp2# - 1
               FilePosition = Temp# - 20
               Call CalculatePosition1
               Call DisplayHilightByte
               Call LocateHilightCursor
            End If
         End If
      Else
         Temp# = FilePosition
         Temp2# = PageRow
         For FilePosition = CopyPositionStart - 20 To CopyPositionStart
            Call CalculatePosition1
            Call DisplayHilightByte
         Next
         CopyPositionStart = CopyPositionStart - 20
         PageRow = Temp2# - 1
         FilePosition = Temp# - 20
         Call CalculatePosition1
         Call DisplayHilightByte
         Call LocateHilightCursor
      End If
   End If
   Exit Sub

   ' move hilight area down.
   ShiftDownKey:
   If PageRow + 1 <= 16 Then
      If FilePosition + 20 <= FileLength Then
         GoSub StoreHilight
         If CopyPositionStart < CopyPositionPivot Then
            Temp# = FilePosition
            Temp2# = PageRow
            If CopyPositionStart + 20 < CopyPositionPivot Then
               For FilePosition = CopyPositionStart To CopyPositionStart + 20
                  Call CalculatePosition1
                  Call ClearHilightByte
               Next
               PageRow = Temp2# + 1
               FilePosition = Temp# + 20
               CopyPositionStart = CopyPositionStart + 20
               Call DisplayHilightByte
               Call LocateHilightCursor
            Else
               For FilePosition = CopyPositionStart To CopyPositionPivot
                  Call CalculatePosition1
                  Call ClearHilightByte
               Next
               CopyPositionStart = CopyPositionPivot
               CopyPositionEnd = Temp# + 20
               For FilePosition = CopyPositionPivot To CopyPositionEnd
                  Call CalculatePosition1
                  Call DisplayHilightByte
               Next
               PageRow = Temp2# + 1
               FilePosition = CopyPositionEnd
               Call DisplayHilightByte
               Call LocateHilightCursor
            End If
         Else
            If CopyPositionEnd >= CopyPositionPivot Then
               Temp# = FilePosition
               Temp2# = PageRow
               For FilePosition = CopyPositionEnd To CopyPositionEnd + 20
                  Call CalculatePosition1
                  Call DisplayHilightByte
               Next
               PageRow = Temp2# + 1
               FilePosition = Temp# + 20
               CopyPositionEnd = CopyPositionEnd + 20
               Call DisplayHilightByte
               Call LocateHilightCursor
            End If
         End If
      End If
   End If
   Exit Sub

   ' move hilight area up one page.
   ShiftPageUpKey:
   ' check there is a page to move up.
   If FilePosition - 320 >= 1 Then
      GoSub StoreHilight
      ' move copypositionstart up one page.
      If CopyPositionEnd = CopyPositionPivot Then
         FilePage = FilePage - 1
         FilePosition = FilePosition - 320
         CopyPositionStart = CopyPositionStart - 320
      Else
         If CopyPositionEnd > CopyPositionPivot Then
            ' move copypositionend up one page before pivot.
            If CopyPositionEnd - 320 < CopyPositionPivot Then
               FilePage = FilePage - 1
               FilePosition = FilePosition - 320
               CopyPositionStart = FilePosition
               CopyPositionEnd = CopyPositionPivot
            Else
               ' move copypositionend up one page.
               If CopyPositionEnd - 320 >= CopyPositionPivot Then
                  FilePage = FilePage - 1
                  FilePosition = FilePosition - 320
                  CopyPositionEnd = CopyPositionEnd - 320
               End If
            End If
         End If
      End If
   Else
      ' check there is a first position on the first page to move up to.
      If FilePosition > 1 Then
         GoSub StoreHilight
         PageRow = 1
         PageColumn = 1
         FilePosition = 1
         CopyPositionStart = 1
         CopyPositionEnd = CopyPositionPivot
      Else
         Exit Sub
      End If
   End If
   Call CalculatePosition1
   Call DisplayHexPage
   Reset1 = False
   Call ResetByte
   Call DisplayHilightByte
   Call LocateHilightCursor
   Exit Sub

   ' move hilight area down one page.
   ShiftPageDownKey:
   ' check there is a page to move down.
   If FilePosition + 320 <= FileLength Then
      GoSub StoreHilight
      ' move copypositionend down one page.
      If CopyPositionStart = CopyPositionPivot Then
         FilePage = FilePage + 1
         FilePosition = FilePosition + 320
         CopyPositionEnd = CopyPositionEnd + 320
      Else
         If CopyPositionStart < CopyPositionPivot Then
            ' move copypositionstart down one page after pivot.
            If CopyPositionStart + 320 <= CopyPositionPivot Then
               FilePage = FilePage + 1
               FilePosition = FilePosition + 320
               CopyPositionStart = FilePosition
               CopyPositionEnd = CopyPositionPivot
            Else
               ' move copypositionstart down one page.
               If CopyPositionStart + 320 > CopyPositionPivot Then
                  FilePage = FilePage + 1
                  FilePosition = FilePosition + 320
                  CopyPositionStart = CopyPositionPivot
                  CopyPositionEnd = FilePosition
               End If
            End If
         End If
      End If
   Else
      ' check there is a last position on the last page to move down to.
      If FilePosition < FileLength Then
         GoSub StoreHilight
         FilePosition = FileLength
         CopyPositionStart = CopyPositionPivot
         CopyPositionEnd = FileLength
      Else
         Exit Sub
      End If
   End If
   Call CalculatePosition1
   Call DisplayHexPage
   Reset1 = False
   Call ResetByte
   Call DisplayHilightByte
   Call LocateHilightCursor
   Exit Sub

   ' move hilight area to end of line.
   ShiftEndKey:
   ' set to column 20
   If PageColumn < 20 Then
      ' check column 20 is positioned before end of file
      GoSub StoreHilight
      If FilePosition - PageColumn + 20 <= FileLength Then
         Temp# = FilePosition
         Temp2# = PageColumn
         TempPosition3 = CopyPositionPivot
         Call CalculatePosition2
         If PageRow = PageRow2 Then
            If Temp# - Temp2# + 20 >= CopyPositionPivot Then
               For FilePosition = Temp# - Temp2# + 1 To CopyPositionPivot
                  Call CalculatePosition1
                  Call ClearHilightByte
               Next
               For FilePosition = CopyPositionPivot To Temp# - Temp2# + 20
                  Call CalculatePosition1
                  Call DisplayHilightByte
               Next
            End If
            CopyPositionEnd = Temp# - Temp2# + 20
            CopyPositionStart = CopyPositionPivot
         Else
            If Temp# - Temp2# + 20 >= CopyPositionPivot Then
               For FilePosition = Temp# To Temp# - Temp2# + 20
                  Call CalculatePosition1
                  Call DisplayHilightByte
               Next
               CopyPositionEnd = Temp# - Temp2# + 20
               CopyPositionStart = CopyPositionPivot
            Else
               For FilePosition = Temp# To Temp# - Temp2# + 20
                  Call CalculatePosition1
                  Call ClearHilightByte
               Next
               CopyPositionStart = Temp# - Temp2# + 1
               CopyPositionEnd = CopyPositionPivot
            End If
         End If
         FilePosition = Temp# - Temp2# + 20
         PageColumn = 20
         Call DisplayHilightByte
         Call LocateHilightCursor
      Else
         ' last position is end of file.
         Temp# = FilePosition
         Temp2# = PageColumn
         TempPosition3 = CopyPositionPivot
         Call CalculatePosition2
         If PageRow = PageRow2 Then
            If FileLength >= CopyPositionPivot Then
               For FilePosition = Temp# - Temp2# + 1 To CopyPositionPivot
                  Call CalculatePosition1
                  Call ClearHilightByte
               Next
               For FilePosition = CopyPositionPivot To FileLength
                  Call CalculatePosition1
                  Call DisplayHilightByte
               Next
            End If
         End If
         FilePosition = FileLength
         CopyPositionEnd = FileLength
         CopyPositionStart = CopyPositionPivot
         Call CalculatePosition1
         Call DisplayHilightByte
         Call LocateHilightCursor
      End If
   End If
   Exit Sub

   ' move hilight area to start of line.
   ShiftHomeKey:
   ' set to column 1
   If PageColumn > 1 Then
      GoSub StoreHilight
      Temp# = FilePosition
      Temp2# = PageColumn
      TempPosition3 = CopyPositionPivot
      Call CalculatePosition2
      If PageRow = PageRow2 Then
         If Temp# - Temp2# + 1 <= CopyPositionPivot Then
            For FilePosition = CopyPositionPivot To Temp#
               Call CalculatePosition1
               Call ClearHilightByte
            Next
            For FilePosition = Temp# - Temp2# + 1 To CopyPositionPivot
               Call CalculatePosition1
               Call DisplayHilightByte
            Next
         End If
         CopyPositionStart = Temp# - Temp2# + 1
         CopyPositionEnd = CopyPositionPivot
      Else
         If Temp# - Temp2# + 1 <= CopyPositionPivot Then
            For FilePosition = Temp# - Temp2# + 1 To Temp#
               Call CalculatePosition1
               Call DisplayHilightByte
            Next
            CopyPositionStart = Temp# - Temp2# + 1
            CopyPositionEnd = CopyPositionPivot
         Else
            For FilePosition = Temp# - Temp2# + 1 To Temp#
               Call CalculatePosition1
               Call ClearHilightByte
            Next
            CopyPositionEnd = Temp# - Temp2# + 1
            CopyPositionStart = CopyPositionPivot
         End If
      End If
      FilePosition = Temp# - Temp2# + 1
      PageColumn = 1
      Call DisplayHilightByte
      Call LocateHilightCursor
   End If
   Exit Sub

   ' store inital hilight start
   StoreHilight:
   If CopyPositionStart = DFalse Then
      CopyPositionStart = FilePosition
      CopyPositionPivot = FilePosition
      CopyPositionEnd = FilePosition
   End If
   Return

   Rem Mouse hilighting routines:

   DragMouse:
   ' check mouse position in screen editing area.
   If MouseX > 3 And MouseX < 20 Then
      If MouseY >= 6 And MouseY <= 49 Then
         ' check initial click is inside editing area.
         If CopyStart = DFalse Then
            Exit Sub
         End If
         ' check screen character.
         VarX = Screen(MouseX, MouseY)
         ' check space.
         If VarX = 32 Then
            Exit Sub
         End If
         ' check new position.
         If VarX <> 32 Then
            ' calculate new position.
            NewPosition = CalculatePosition3
            ' initialize copy area.
            If CopyPositionStart = DFalse Then
               CopyPositionStart = CopyStart
               CopyPositionPivot = CopyStart
               CopyPositionEnd = CopyStart
            End If
            ' check initial click area.
            If NewPosition = CopyPositionPivot Then
               For TempPosition3 = CopyPositionStart To CopyPositionEnd
                  Call CalculatePosition2
                  If FilePage2 = FilePage Then
                     FilePosition = TempPosition3
                     Call CalculatePosition1
                     Colorf White
                     Call BytePrint
                  End If
               Next
               CopyPositionStart = NewPosition
               CopyPositionEnd = NewPosition
               FilePosition = CopyPositionPivot
               Call CalculatePosition1
               Colorf2 0, 7
               Call BytePrint
               Colorf2 7, 0
            End If
            ' check backwards wrap.
            If NewPosition < CopyPositionPivot Then
               If CopyPositionEnd > CopyPositionPivot Then
                  For TempPosition3 = CopyPositionPivot To CopyPositionEnd
                     Call CalculatePosition2
                     If FilePage2 = FilePage Then
                        FilePosition = TempPosition3
                        Call CalculatePosition1
                        Colorf White
                        Call BytePrint
                     End If
                  Next
               End If
               If NewPosition > CopyPositionStart Then
                  For TempPosition3 = CopyPositionStart To NewPosition
                     Call CalculatePosition2
                     If FilePage2 = FilePage Then
                        FilePosition = TempPosition3
                        Call CalculatePosition1
                        Colorf White
                        Call BytePrint
                     End If
                  Next
               End If
               CopyPositionStart = NewPosition
               CopyPositionEnd = CopyPositionPivot
               For TempPosition3 = CopyPositionStart To CopyPositionPivot
                  Call CalculatePosition2
                  If FilePage2 = FilePage Then
                     FilePosition = TempPosition3
                     Call CalculatePosition1
                     Colorf2 0, 7
                     Call BytePrint
                  End If
               Next
               Colorf2 7, 0
            End If
            ' check forwards wrap.
            If NewPosition > CopyPositionPivot Then
               If CopyPositionStart < CopyPositionPivot Then
                  For TempPosition3 = CopyPositionStart To CopyPositionPivot
                     Call CalculatePosition2
                     If FilePage2 = FilePage Then
                        FilePosition = TempPosition3
                        Call CalculatePosition1
                        Colorf White
                        Call BytePrint
                     End If
                  Next
               End If
               If NewPosition < CopyPositionEnd Then
                  For TempPosition3 = NewPosition To CopyPositionEnd
                     Call CalculatePosition2
                     If FilePage2 = FilePage Then
                        FilePosition = TempPosition3
                        Call CalculatePosition1
                        Colorf White
                        Call BytePrint
                     End If
                  Next
               End If
               CopyPositionStart = CopyPositionPivot
               CopyPositionEnd = NewPosition
               For TempPosition3 = CopyPositionPivot To CopyPositionEnd
                  Call CalculatePosition2
                  If FilePage2 = FilePage Then
                     FilePosition = TempPosition3
                     Call CalculatePosition1
                     Colorf2 0, 7
                     Call BytePrint
                  End If
               Next
               Colorf2 7, 0
            End If
            ' get new position and locate there.
            FilePosition = NewPosition
            Call CalculatePosition1
            Colorf2 0, 7
            Call BytePrint
            Colorf2 7, 0
            Call DisplayPosition
            Call LocateCursor
         End If
      End If
   End If
   Exit Sub

   ' move hilight area up one page.
   DragMousePageUp:
   ' check initial click is inside editing area.
   If CopyStart = DFalse Then
      Exit Sub
   End If
   ' check scrolling interval.
   If Time1 = SFalse Then
      Time1 = Timer
   End If
   GoSub TimeElapsed
   If VarT = SFalse Then
      Exit Sub
   End If
   Time1 = Timer
   ' check drag variables.
   If CopyPositionEnd = DFalse Then
      CopyPositionEnd = CopyStart
   End If
   If CopyPositionPivot = DFalse Then
      CopyPositionPivot = CopyPositionEnd
   End If
   If CopyPositionStart = DFalse Then
      CopyPositionStart = (FilePage - 1) * 320 + 1
   End If
   ' check there is a page to move up.
   If FilePage - 1 >= 1 Then
      ' move copypositionstart up one page.
      FilePage = FilePage - 1
      FilePosition = (FilePage - 1) * 320 + 1
      CopyPositionStart = FilePosition
      Call CalculatePosition1
      Call DisplayHexPage
      Reset1 = False
      Call ResetByte
      Call DisplayHilightByte
      Call LocateHilightCursor
   End If
   Exit Sub

   ' move hilight area down one page.
   DragMousePageDown:
   ' check initial click is inside editing area.
   If CopyStart = DFalse Then
      Exit Sub
   End If
   ' check scrolling interval.
   If Time1 = SFalse Then
      Time1 = Timer
   End If
   GoSub TimeElapsed
   If VarT = SFalse Then
      Exit Sub
   End If
   Time1 = Timer
   ' check drag variables.
   If CopyPositionStart = DFalse Then
      CopyPositionStart = CopyStart
   End If
   If CopyPositionPivot = DFalse Then
      CopyPositionPivot = CopyPositionStart
   End If
   If CopyPositionEnd = DFalse Then
      CopyPositionEnd = (FilePage - 1) * 320 + 320
   End If
   ' check there is a page to move down.
   FilePage2 = Int((FileLength - 1) / 320) + 1
   If FilePage + 1 <= FilePage2 Then
      ' move copypositionend down one page.
      FilePage = FilePage + 1
      FilePosition = (FilePage - 1) * 320 + 320
      If FilePosition > FileLength Then
         FilePosition = FileLength
      End If
      CopyPositionEnd = FilePosition
      Call CalculatePosition1
      Call DisplayHexPage
      Reset1 = False
      Call ResetByte
      Call DisplayHilightByte
      Call LocateHilightCursor
   End If
   Exit Sub

   ' calculate elapsed time.
   TimeElapsed:
   Elapsed.Time! = Timer - Time1
   If Elapsed.Time! < SFalse Then
      Elapsed.Time! = Elapsed.Time! + 86400!
   End If
   If Elapsed.Time! > MouseTime Then
      VarT = True
   Else
      VarT = False
   End If
   Return
End Sub

' realtime hex/dec calculator.
Sub HexCalc
   GoSub MakeBox ' create edit box.
   Ins = -1 ' reset insert flag.
   CalcBox = 1 ' reset to left box.
   Box$ = "0" ' current box
   Box1$ = "0" ' left box string
   Box2$ = "0" ' right box string
   GoSub SelectBox2 ' display box 2.
   GoSub SelectBox1 ' display box 1.
   Do ' calculator loop
      Do ' keystroke loop
         Z = MouseDriver ' get mouse
         If MouseButton1 Then
            Colorf2 7, 0
            Exit Sub
         End If
         If MouseButton2 Then
            Colorf2 7, 0
            Exit Sub
         End If
         Var$ = INKEYx$ ' get keystroke
         If Len(Var$) Then ' check keystroke
            Exit Do
         End If
      Loop
      Select Case Len(Var$)
         Case 1 ' single ascii key
            Select Case Asc(Var$)
               Case 8 ' backspace
                  If Ycoor1 - Column3 > False Then
                     If Ins Then
                        Box$ = Left$(Box$, Ycoor1 - Column3 - 1) + Mid$(Box$, Ycoor1 - Column3 + 1)
                        Ycoor1 = Ycoor1 - 1
                        Locatef Xcoor1, Ycoor1, 1
                        Var$ = Mid$(Box$, Ycoor1 - Column3 + 1) + " "
                        Colorf2 15, 0
                        Printf Var$
                        Locatef Xcoor1, Ycoor1, 1
                        GoSub PrintBoxes
                     Else ' move left
                        Ycoor1 = Ycoor1 - 1
                        Locate Xcoor1, Ycoor1, 1
                     End If
                  End If
               Case 9 ' tab
                  If CalcBox = 1 Then
                     CalcBox = 2
                     GoSub SelectBox2
                     GoSub PrintBoxes
                  End If
               Case 27 ' escape
                  Colorf2 7, 0
                  Exit Sub
               Case Else ' keystroke
                  VarX = False
                  TempX$ = UCase$(Var$)
                  Select Case TempX$
                     Case "0" To "9"
                        VarX = True
                     Case "A" To "F"
                        If CalcBox = 1 Then
                           VarX = True
                        End If
                  End Select
                  If VarX Then
                     If Ycoor1 - Column3 + 1 <= LineLength Then
                        ' insert digit
                        If Ins Then
                           Box$ = Left$(Box$, Ycoor1 - Column3) + TempX$ + Mid$(Box$, Ycoor1 - Column3 + 1)
                           Box$ = Left$(Box$, LineLength)
                           Locatef Xcoor1, Ycoor1, 1
                           Var$ = Mid$(Box$, Ycoor1 - Column3 + 1)
                           Colorf2 15, 0
                           Printf Var$
                           Ycoor1 = Ycoor1 + 1
                           Locatef Xcoor1, Ycoor1, 1
                           GoSub PrintBoxes
                        Else ' overstrike char
                           If Ycoor1 - Column3 + 1 > Len(Box$) Then
                              Box$ = Box$ + TempX$ ' append box
                           Else
                              Mid$(Box$, Ycoor1 - Column3 + 1, 1) = TempX$ ' replace
                           End If
                           Locatef Xcoor1, Ycoor1, 1
                           Colorf2 15, 0
                           Printf TempX$
                           Ycoor1 = Ycoor1 + 1
                           Locatef Xcoor1, Ycoor1, 1
                           GoSub PrintBoxes
                        End If
                     End If
                  End If
            End Select
         Case 2 ' extended key
            Select Case Asc(Right$(Var$, 1))
               Case 15 ' shift-tab
                  If CalcBox = 2 Then
                     CalcBox = 1
                     GoSub SelectBox1
                     GoSub PrintBoxes
                  End If
               Case 71 ' home
                  Ycoor1 = Column3
               Case 79 ' end
                  Ycoor1 = Len(Box$) + Column3
               Case 77 ' right
                  If Ycoor1 - Column3 + 1 <= Len(Box$) Then
                     Ycoor1 = Ycoor1 + 1
                  End If
               Case 75 ' left
                  If Ycoor1 - Column3 > False Then
                     Ycoor1 = Ycoor1 - 1
                  End If
               Case 82 ' insert
                  Ins = Not Ins
                  Colorf2 14, 1
                  If Ins Then
                     Locatef 4, 30, 1
                     Printf "<ins>"
                  Else
                     Locatef 4, 30, 1
                     Printf String$(5, 205)
                  End If
                  Colorf2 15, 0
               Case 83 ' delete
                  If Ycoor1 - Column3 + 1 <= Len(Box$) Then
                     Box$ = Left$(Box$, Ycoor1 - Column3) + Mid$(Box$, Ycoor1 - Column3 + 2)
                     Locatef Xcoor1, Ycoor1, 1
                     Var$ = Mid$(Box$, Ycoor1 - Column3 + 1) + " "
                     Colorf2 15, 0
                     Printf Var$
                     Locatef Xcoor1, Ycoor1, 1
                     GoSub PrintBoxes
                  End If
               Case 76, 119 ' control-home
                  Ycoor1 = Column3
               Case 117, 143 ' control-end
                  Ycoor1 = Len(Box$) + Column3
            End Select
            Locatef Xcoor1, Ycoor1, 1
      End Select
   Loop
   Exit Sub

   ' create edit box.
   MakeBox:
   Colorf2 14, 1
   Locatef 4, 6, 1
   Var$ = " " + Chr$(201) + String$(1, 205) + "<esc>=Quit" + String$(11, 205) + "<ins>" + Chr$(187) + " "
   Printf Var$
   Locatef 5, 6, 1
   Var$ = " " + Chr$(186) + Space$(9) + "Hex" + Space$(11) + "Dec " + Chr$(186) + " "
   Printf Var$
   Locatef 6, 6, 1
   Var$ = " " + Chr$(200) + String$(1, 205) + "<tab>/<shift-tab>=switch" + String$(2, 205) + Chr$(188) + " "
   Printf Var$
   Return

   ' move to box 1 (left box).
   SelectBox1:
   Box2$ = Box$ ' store right box.
   Box$ = Box1$ ' reset to left box.

   ' reset editing parameters.
   Xcoor1 = 5
   Ycoor1 = 9
   Column3 = 9
   LineLength = 8

   ' display left box.
   Colorf2 15, 0
   Locatef Xcoor1, Ycoor1, 1
   Printf Space$(8)
   Locatef Xcoor1, Ycoor1, 1
   Printf Box$
   Ycoor1 = Ycoor1 + Len(Box$)
   Locatef Xcoor1, Ycoor1, 1
   Return

   ' move to box 2 (right box).
   SelectBox2:
   Box1$ = Box$ ' store left box.
   Box$ = Box2$ ' reset to right box.

   ' reset editing parameters.
   Xcoor1 = 5
   Ycoor1 = 21
   Column3 = 21
   LineLength = 10

   ' display right box.
   Colorf2 15, 0
   Locatef Xcoor1, Ycoor1, 1
   Printf Space$(10)
   Locatef Xcoor1, Ycoor1, 1
   Printf Box$
   Ycoor1 = Ycoor1 + Len(Box$)
   Locatef Xcoor1, Ycoor1, 1
   Return

   ' calculates value of current box,
   ' displays result in calculated form
   ' in opposite box.
   PrintBoxes:
   If CalcBox = 1 Then ' is in hex box.
      ' strip leading zeroes for signed bit conversion.
      TempBox$ = Box$
      Do
         If Left$(TempBox$, 1) = "0" Then
            TempBox$ = Mid$(TempBox$, 2)
         Else
            Exit Do
         End If
      Loop
      Value# = Val("&H" + TempBox$) ' retreive decimal value.
      If Value# < 0# Then ' check twos-complement from signed value.
         If Len(TempBox$) = 8 Then ' 8000 0000 to FFFF FFFF
            Value# = Value# + 4294967296#
         Else
            If Len(TempBox$) = 4 Then ' 8000 to FFFF
               Value# = Value# + 65536
            End If
         End If
      End If
      ' display decimal value.
      Box2$ = Mid$(Str$(Value#), 2)
      Colorf2 15, 0
      Locatef 5, 21, 1
      Printf Space$(10)
      Locatef 5, 21, 1
      Printf Box2$
   End If
   If CalcBox = 2 Then ' is in decimal box.
      Value# = Val(Box$) ' retreive hex value.
      If Value# >= 4294967296# Then ' check overflow.
         Colorf2 15, 0
         Locatef 5, 9, 1
         Var$ = "overflow"
         Printf Var$
         Box1$ = "0"
      Else
         If Value# > 2147483647# Then ' force to twos-complement.
            Value# = Value# - 4294967296# ' 8000 0000 to FFFF FFFF
         End If
         ' display hex value.
         Box1$ = Hex$(Value#)
         Colorf2 15, 0
         Locatef 5, 9, 1
         Printf Space$(8)
         Locatef 5, 9, 1
         Printf Box1$
      End If
   End If
   Locatef Xcoor1, Ycoor1, 1
   Return
End Sub

' formatting function.
'   Var#  input value.
'   Var3  format type:
'      1 = filelength in hexedit.
'      0 = file status area in file menu box.
'     -1 = filesize in file menu box.
Function FormatX$ (Var#, Var3)
   If Var3 = -1 Then
      Select Case FileSizeType
         Case 0 ' Byte
            VarX$ = FormatString$(Var#, 0) + " B. "
         Case 1 ' Kilobyte
            Var# = Var# / 1024#
            VarX$ = FormatString$(Var#, 1) + " KB. "
         Case 2 ' Megabyte
            Var# = Var# / 1048576#
            VarX$ = FormatString$(Var#, 2) + " MB. "
         Case 3 ' Gigabyte
            Var# = Var# / 1073741824#
            VarX$ = FormatString$(Var#, 3) + " GB. "
      End Select
      If Left$(VarX$, 1) = "." Then
         FormatX$ = "0" + VarX$
      End If
      Exit Function
   End If
   FormatX$ = FormatString$(Var#, 0)
End Function

' formats a double numeric string
Function FormatString$ (s#, x) ' x = 0 B, 1 K, 2 M, 3 G
   x$ = Nul
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If

   ' construct string
   Select Case x
      Case 0 ' B
         x$ = e$ + x$
      Case 1 ' K .0
         If Len(q$) Then
            q$ = Left$(q$, 2)
         End If
         x$ = e$ + x$ + q$
      Case 2 ' M .00
         If Len(q$) Then
            q$ = Left$(q$, 3)
         End If
         x$ = e$ + x$ + q$
      Case 3 ' G .000
         If Len(q$) Then
            q$ = Left$(q$, 4)
         End If
         x$ = e$ + x$ + q$
   End Select
   FormatString$ = x$
End Function

' file menu box move subroutine.
Sub MoveMenu
   GoSub StoreArea
   GoSub RestoreArea
   I$ = Nul
   Do
      I$ = Nul
      Do
         I$ = INKEYx$
         If Len(I$) Then
            Exit Do
         End If
         Z = MouseDriver ' get mouse
         If MouseButton1 Then
            MouseButton1 = False
            Call ClearMouse
            If Xcoor - 1 >= 2 Then
               Xcoor = Xcoor - 1
               GoSub RestoreArea
            End If
         End If
         If MouseButton2 Then
            MouseButton2 = False
            Call ClearMouse
            If Xcoor + 1 <= 8 Then
               Xcoor = Xcoor + 1
               GoSub RestoreArea
            End If
         End If
         If MouseButton3 Then
            I$ = Chr$(0) + Chr$(76) ' center box
            Exit Do
         End If
         If MouseWheel = -1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(80) ' down
            Else
               I$ = Chr$(0) + Chr$(72) ' up
            End If
            MouseWheel = 0
            Exit Do
         End If
         If MouseWheel = 1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(72) ' up
            Else
               I$ = Chr$(0) + Chr$(80) ' down
            End If
            MouseWheel = 0
            Exit Do
         End If
      Loop
      Var = False
      Select Case Len(I$)
         Case 1
            Select Case I$
               Case Chr$(27) ' exit
                  I$ = Nul
                  Exit Do
               Case "|"
                  Xcoor = 2
                  Var = True
               Case "#"
                  Xcoor = 8
                  Var = True
               Case "<" ' Up
                  If Xcoor - 1 >= 2 Then
                     Xcoor = Xcoor - 1
                     Var = True
                  End If
               Case ">" ' Down
                  If Xcoor + 1 <= 8 Then
                     Xcoor = Xcoor + 1
                     Var = True
                  End If
               Case "1", "`", "~" ' left
                  If Ycoor - 1 >= 1 Then
                     Ycoor = Ycoor - 1
                     Var = True
                  End If
               Case "2" To "8" ' up/down
                  Xcoor = Int(Val(I$))
                  Var = True
               Case "9", "0", "-", "=", "_", "+" ' right
                  If Ycoor + 1 <= 39 Then
                     Ycoor = Ycoor + 1
                     Var = True
                  End If
               Case "!", "@", "#", "$", "%", "^", "&", "*", "(", ")" ' center box
                  Xcoor = 5
                  Ycoor = 20
                  Var = True
            End Select
         Case 2
            VarQ = Asc(Right$(I$, 1))
            Select Case VarQ
               Case 59 ' F1
                  Xcoor = 2
                  Var = True
               Case 60 To 66 ' F2 to F8
                  Xcoor = VarQ - 58
                  Var = True
               Case 67, 68 ' F9, F10
                  Xcoor = 8
                  Var = True
               Case 94 ' Ctrl-F1
                  Xcoor = 2
                  Var = True
               Case 95 To 101 ' Ctrl-F2 to Ctrl-F8
                  Xcoor = VarQ - 93
                  Var = True
               Case 102, 103 ' Ctrl-F9, Ctrl-F10
                  Xcoor = 8
                  Var = True
               Case 104 ' Alt-F1
                  Xcoor = 2
                  Var = True
               Case 105 To 111 ' Alt-F2 to Alt-F8
                  Xcoor = VarQ - 103
                  Var = True
               Case 112, 113 ' Alt-F9, Alt-F10
                  Xcoor = 8
                  Var = True
               Case 120 ' Alt-1
                  Xcoor = 2
                  Var = True
               Case 121 To 127 ' Alt-2 to Alt-8
                  Xcoor = VarQ - 119
                  Var = True
               Case 128, 129 ' Alt-9, Alt-0
                  Xcoor = 8
                  Var = True
               Case 133, 134 ' F11, F12
                  Xcoor = 8
                  Var = True
               Case 137, 138 ' Ctrl-F11, Ctrl-F12
                  Xcoor = 8
                  Var = True
               Case 139, 140 ' Alt-F11, Alt-F12
                  Xcoor = 8
                  Var = True
               Case 152, 72, 142, 74, 130 ' Alt-Up/Up/Ctrl--/Alt--
                  If Xcoor - 1 >= 2 Then
                     Xcoor = Xcoor - 1
                     Var = True
                  End If
               Case 160, 80, 144, 78, 131 ' Alt-Down/Down/Ctrl-+/Alt-=
                  If Xcoor + 1 <= 8 Then
                     Xcoor = Xcoor + 1
                     Var = True
                  End If
               Case 75, 155 ' Left/Alt-Left
                  If Ycoor - 1 >= 1 Then
                     Ycoor = Ycoor - 1
                     Var = True
                  End If
               Case 77, 157 ' Right/Alt-Right
                  If Ycoor + 1 <= 39 Then
                     Ycoor = Ycoor + 1
                     Var = True
                  End If
               Case 71, 119, 132 ' Home/Ctrl-Home/Ctrl-PageUp = move to upper-left
                  Xcoor = 2
                  Ycoor = 1
                  Var = True
               Case 79, 117, 118 ' End/Ctrl-End/Ctrl-PageDown = move to lower-right
                  Xcoor = 8
                  Ycoor = 39
                  Var = True
               Case 73 ' PageUp = move to upper-right
                  Xcoor = 2
                  Ycoor = 39
                  Var = True
               Case 81 ' PageDown = move to lower-left
                  Xcoor = 8
                  Ycoor = 1
                  Var = True
               Case 115, 155 ' Ctrl-Left/Alt-Left = move to left-middle
                  Xcoor = 4
                  Ycoor = 1
                  Var = True
               Case 116, 157 ' Ctrl-Right/Alt-Right = move to right-middle
                  Xcoor = 4
                  Ycoor = 39
                  Var = True
               Case 141 ' Ctrl-Up = move to upper-middle
                  Xcoor = 2
                  Ycoor = 20
                  Var = True
               Case 145 ' Ctrl-Down = move to lower-middle
                  Xcoor = 8
                  Ycoor = 20
                  Var = True
               Case 76, 143 ' Keypad-5/Ctrl-Keypad-5 = center box
                  Xcoor = 5
                  Ycoor = 20
                  Var = True
               Case 74, 142 ' Alt-Keypad-/Ctrl-Keypad- = move to left-middle
                  Xcoor = 4
                  Ycoor = 1
                  Var = True
               Case 78, 144 ' Alt-Keypad+/Ctrl-Keypad+ = move to right-middle
                  Xcoor = 4
                  Ycoor = 39
                  Var = True
            End Select
      End Select
      If Var Then
         GoSub RestoreArea
      End If
   Loop
   Exit Sub

   ' store area.
   StoreArea:
   RowX1 = False
   ColumnY1 = False
   For RowX2 = Xcoor - 1 To Xcoor + 16
      RowX1 = RowX1 + 1
      ColumnY1 = False
      For ColumnY2 = Ycoor To Ycoor + 41
         ColumnY1 = ColumnY1 + 1
         ' store ascii character.
         Area1(RowX1, ColumnY1) = Screen(RowX2, ColumnY2)
         ' store color. (undocumented: also stores background color).
         Area2(RowX1, ColumnY1) = Screen(RowX2, ColumnY2, 1)
      Next
   Next
   Return

   ' restore area.
   RestoreArea:
   Colorf2 White, BackGround
   Cls
   RowX1 = False
   ColumnY1 = False
   For RowX2 = Xcoor - 1 To Xcoor + 16
      RowX1 = RowX1 + 1
      ColumnY1 = False
      For ColumnY2 = Ycoor To Ycoor + 41
         ColumnY1 = ColumnY1 + 1
         Locatef RowX2, ColumnY2, 1
         ' restore color.
         TempZ = Area2(RowX1, ColumnY1)
         ' undocumented: also stores background color.
         VarB = Int(TempZ / 16)
         VarF = TempZ Mod 16
         Colorf2 VarF, VarB
         ' restore ascii character.
         Printf Chr$(Area1(RowX1, ColumnY1))
      Next
   Next
   Return
End Sub

Sub OverridePrompt
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require readonly bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireReadOnly = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireReadOnly = False
         Exit Do
      End If
   Loop
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require hidden bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireHidden = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireHidden = False
         Exit Do
      End If
   Loop
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require system bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireSystem = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireSystem = False
         Exit Do
      End If
   Loop
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require archive bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireArchive = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireArchive = False
         Exit Do
      End If
   Loop
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require dir readonly bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireDirReadOnly = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireDirReadOnly = False
         Exit Do
      End If
   Loop
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require dir hidden bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireDirHidden = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireDirHidden = False
         Exit Do
      End If
   Loop
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require dir system bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireDirSystem = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireDirSystem = False
         Exit Do
      End If
   Loop
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Require dir archive bit. Press <y/n>:"
   Do
      M$ = Nul
      While M$ = Nul
         M$ = INKEYx$
      Wend
      M$ = UCase$(M$)
      If M$ = "Y" Then
         RequireDirArchive = True
         Exit Do
      End If
      If M$ = "N" Then
         RequireDirArchive = False
         Exit Do
      End If
   Loop
End Sub

' routine compares occurrence of filename1$ in filename2$.
'  allows imbedded ? and * characters,
'  also compares ^ character exclusion.
Sub CheckExcluded (Filename1$, Filename2$, Match)
   Match = True ' assume mask matches filename2
   Length1 = 1
   Length2 = 1
   Do
      ' global replacement
      If Mid$(Filename1$, Length1, 1) = "*" Then
         Do
            Length1 = Length1 + 1
            If Length1 > Len(Filename1$) Then
               Exit Sub
            End If
            ' global replacement followed by exclusion character
            ' searches remaining string until exclusion character found or not.
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               Do
                  If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                     Length2 = Length2 + 1
                  Else
                     Match = False
                     Exit Sub
                  End If
                  If Length2 > Len(Filename2$) Then
                     Exit Sub
                  End If
               Loop
            End If
            ' global replacement followed by ? or another *
            ' skips to next character.
            If Mid$(Filename1$, Length1, 1) <> "*" Then
               If Mid$(Filename1$, Length1, 1) <> "?" Then
                  Exit Do
               End If
            End If
         Loop
         ' global replacement
         ' searches for next matching character
         Do
            If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
               Exit Do
            Else
               Length2 = Length2 + 1
            End If
            If Length2 > Len(Filename2$) Then
               Exit Do
            End If
         Loop
      Else
         ' character replacement
         ' matches any next character
         If Mid$(Filename1$, Length1, 1) = "?" Then
            Length1 = Length1 + 1
            Length2 = Length2 + 1
         Else
            ' exclusion character
            ' checks next character unmatched
            If Mid$(Filename1$, Length1, 1) = "^" Then
               Length1 = Length1 + 1
               Not.Include$ = Mid$(Filename1$, Length1, 1)
               If Not.Include$ <> Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match = False
                  Exit Do
               End If
            Else
               ' matches next character
               If Mid$(Filename1$, Length1, 1) = Mid$(Filename2$, Length2, 1) Then
                  Length1 = Length1 + 1
                  Length2 = Length2 + 1
               Else
                  Match = False
                  Exit Do
               End If
               ' check string lengths
               If Length1 > Len(Filename1$) Then
                  If Length2 <= Len(Filename2$) Then
                     Match = False
                  End If
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
   Exit Sub
End Sub

Sub Parse.Path (D$, X$)
   ' parse out imbedded \.\ path.
   GoSub PathOverride1
   ' parse out trailing \.. path with multiple dots.
   GoSub PathOverride2
   ' parse out leading ..\ path with multiple dots.
   GoSub PathOverride3
   ' parse out leading \..\ path with multiple dots.
   GoSub PathOverride4
   ' parse out imbedded \..\ path with multiple dots.
   GoSub PathOverride5
   ' parse out imbedded \\ from path.
   GoSub PathOverride6
   Exit Sub

   ' parse out imbedded \.\ path.
   PathOverride1:
   If Len(X$) Then
      Do
         V = InStr(X$, "\.\")
         If V Then
            X$ = Left$(X$, V) + Mid$(X$, V + 3)
         Else
            Exit Do
         End If
      Loop
   End If
   Return

   ' parse out trailing \.. path with multiple dots.
   PathOverride2:
   Z$ = Nul
   If Len(X$) Then
      ' search for trailing path.
      Do
         Z = False
         L = False
         If Right$(X$, 1) = "." Then
            For V = Len(X$) To 1 Step -1
               If Mid$(X$, V, 1) = "." Then
                  L = L + 1
               Else
                  If Mid$(X$, V, 1) = "\" Then
                     Z = True
                     Exit For
                  Else
                     Exit For
                  End If
               End If
            Next
         End If
         If Z = False Then
            Exit Do
         End If
         Z$ = Mid$(X$, V) + Z$
         X$ = Left$(X$, V - 1)
      Loop
      If Z$ = Nul Then
         ' strip trailing dots.
         If InStr(X$, "\") Then
            Do
               If Right$(X$, 1) = "." Then
                  X$ = Left$(X$, Len(X$) - 1)
               Else
                  Exit Do
               End If
            Loop
         End If
         Return
      End If
      Do
         ' search leading dots.
         L = False
         For V = 2 To Len(Z$)
            If Mid$(Z$, V, 1) = "." Then
               L = L + 1
               If V = Len(Z$) Then
                  Z$ = Nul
                  Exit For
               End If
            Else
               If Mid$(Z$, V, 1) = "\" Then
                  Z$ = Mid$(Z$, V)
                  Exit For
               End If
            End If
         Next
         ' strip trailing path.
         Do
            L2 = 1
            Z = False
            For V = Len(X$) To 1 Step -1
               If Mid$(X$, V, 1) = "\" Then
                  L2 = L2 + 1
                  If L = L2 Then
                     Z = True
                     Exit Do
                  End If
               End If
            Next
            If Z = False Then
               Exit Do
            End If
         Loop
         If Z = False Then
            X$ = Nul
            Exit Do
         End If
         If V = 1 Then
            If Left$(X$, 1) = "\" Then
               X$ = "\"
               Exit Do
            End If
         End If
         X$ = Left$(X$, V - 1)
         If Z$ = Nul Then
            Exit Do
         End If
      Loop
   End If
   ' strip trailing dots.
   If InStr(X$, "\") Then
      Do
         If Right$(X$, 1) = "." Then
            X$ = Left$(X$, Len(X$) - 1)
         Else
            Exit Do
         End If
      Loop
   End If
   Return

   ' parse out leading ..\ path with multiple dots.
   PathOverride3:
   Z$ = D$
   Do
      ' search for leading dots.
      Z = False
      L = False
      If Left$(X$, 1) = "." Then
         For V = 1 To Len(X$)
            If Mid$(X$, V, 1) = "." Then
               L = L + 1
            Else
               If Mid$(X$, V, 1) = "\" Then
                  Z = True
                  Exit For
               Else
                  Exit For
               End If
            End If
         Next
      End If
      If Z = False Then
         Exit Do
      End If
      X$ = Mid$(X$, V + 1)
      ' parse off trailing path.
      If L > 1 Then
         L2 = 1
         Do
            Z = False
            For V = Len(Z$) To 1 Step -1
               If Mid$(Z$, V, 1) = "\" Then
                  Z$ = Left$(Z$, V - 1)
                  L2 = L2 + 1
                  Z = True
                  Exit For
               End If
            Next
            If Z = False Then
               Z$ = Nul
               Exit Do
            End If
            If L2 = L Then
               Exit Do
            End If
         Loop
      End If
   Loop
   D$ = Z$
   Return

   ' parse out leading \..\ path with multiple dots.
   PathOverride4:
   Do
      If Left$(X$, 1) = "\" Then
         If Len(X$) = 1 Then
            Exit Do
         End If
         L = False
         For V = 2 To Len(X$)
            If Mid$(X$, V, 1) = "." Then
               L = L + 1
            Else
               If Mid$(X$, V, 1) = "\" Then
                  If L > 0 Then
                     X$ = Mid$(X$, V)
                     Exit For
                  End If
               End If
               Exit Do
            End If
         Next
      Else
         Exit Do
      End If
   Loop
   Return

   ' parse out imbedded \..\ path with multiple dots.
   PathOverride5:
   If Len(X$) Then
      Do
         ' search for \.\
         Z = False
         For V = 1 To Len(X$)
            If Mid$(X$, V, 1) = "\" Then
               L = False
               For V2 = V + 1 To Len(X$)
                  If Mid$(X$, V2, 1) = "." Then
                     L = L + 1
                  Else
                     If Mid$(X$, V2, 1) = "\" Then
                        If L > 0 Then
                           Z = True
                        End If
                        Exit For
                     Else
                        Exit For
                     End If
                  End If
               Next
            End If
            If Z = True Then
               Exit For
            End If
         Next
         If Z = False Then
            Exit Do
         End If
         Z$ = "\" + String$(L, ".") + "\"
         V4 = InStr(X$, Z$)
         A$ = Mid$(X$, V4 + L + 2)
         L2 = 1
         Do
            V4 = V4 - 1
            If V4 = False Then
               Exit Do
            End If
            If Mid$(X$, V4, 1) = "\" Then
               L2 = L2 + 1
               If L2 = L Then
                  Exit Do
               End If
            End If
         Loop
         If V4 = False Then
            X$ = A$
         Else
            X$ = Left$(X$, V4) + A$
         End If
      Loop
   End If

   ' search for imbedded ..\
   Do
      V = InStr(X$, ".\")
      If V Then
         L = False
         For V2 = V To 1 Step -1
            If Mid$(X$, V2, 1) = "." Then
               L = L + 1
            Else
               X$ = Left$(X$, V2) + Mid$(X$, V + 1)
               Exit For
            End If
         Next
      Else
         Exit Do
      End If
   Loop
   Return

   ' strip imbedded \\ from path.
   PathOverride6:
   Do
      V = InStr(X$, "\\")
      If V Then
         X$ = Left$(X$, V - 1) + Mid$(X$, V + 1)
      Else
         Exit Do
      End If
   Loop
   Return
End Sub

' strip multiple dots from path.
Sub Parse.Path2 (D$, X$)
   Do
      If Left$(X$, 2) = ".." Then
         Z = False
         For Var = Len(D$) To 1 Step -1
            If Mid$(D$, Var, 1) = "\" Then
               D$ = Left$(D$, Var - 1)
               X$ = Mid$(X$, 2)
               Z = True
               Exit For
            End If
         Next
         If Z = False Then
            D$ = Nul
            X$ = Nul
            Exit Do
         End If
      Else
         X$ = Nul
         Exit Do
      End If
   Loop
End Sub

' specialized keyboard scan function
'  uses keymap function call.
Function INKEYq$
   _Limit 100
   X = _KeyHit
   If X Then
      If X < 0 Then
         Select Case X
            Case -12 ' keypad-5
               X$ = Chr$(0) + Chr$(76)
               INKEYq$ = KeymapChar$(X$)
               KeyPressed = True
            Case -108 ' ctrl-keypad-5
               X$ = Chr$(0) + Chr$(143)
               INKEYq$ = KeymapChar$(X$)
               KeyPressed = True
         End Select
      Else
         X$ = InKey$
         If Len(X$) Then
            INKEYq$ = KeymapChar$(X$)
            KeyPressed = True
         End If
      End If
   End If
End Function

' custom Inkey$ function.
Function INKEYx$
   _Limit 100
   X = _KeyHit
   If X < 0 Then
      Select Case X
         Case -12 ' keypad-5
            INKEYx$ = Chr$(0) + Chr$(76)
            KeyPressed = -1
            Exit Function
         Case -108 ' ctrl-keypad-5
            INKEYx$ = Chr$(0) + Chr$(143)
            KeyPressed = -1
            Exit Function
      End Select
   End If
   X$ = InKey$
   If Len(X$) Then
      INKEYx$ = X$
      KeyPressed = -1
   End If
End Function

' Custom line input function.
' Input:
'    XC = X-coordinate
'    YC = Y-coordinate
'    LC = Edit area length
Function LineInput$ (XC, YC, LC)
   ' init entry area position.
   Xposition1 = 1
   Xposition2 = 0

   ' display edit entry area.
   Insert = -1
   GoSub DisplayFileLine

   ' main input loop.
   Do
      ' get keypress.
      I$ = INKEYx$

      ' check key.
      If Len(I$) = 1 Then

         ' enter key.
         If I$ = Chr$(13) Then
            LineInput$ = X$
            Exit Do
         End If

         ' escape key.
         If I$ = Chr$(27) Then
            LineInput$ = Nul
            Exit Do
         End If

         ' backspace.
         If I$ = Chr$(8) Then
            If Len(X$) Then
               If Xposition2 > 0 Then
                  If Insert Then ' destructive backspace
                     X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                  End If
                  Xposition2 = Xposition2 - 1
                  If Xposition2 - LC <= Xposition1 Then
                     Xposition1 = Xposition1 - 1
                     If Xposition1 < 1 Then
                        Xposition1 = 1
                     End If
                  End If
                  GoSub DisplayFileLine
               End If
            End If
         Else
            ' append/insert character into edit area.
            OK = -1
            If Asc(I$) >= 0 And Asc(I$) <= 31 Then
               OK = 0 ' disallow control charcters
            End If
            If OK Then
               If Insert Then
                  X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                  Xposition2 = Xposition2 + 1
                  If Xposition2 > LC Then
                     Xposition1 = Xposition1 + 1
                  End If
               Else
                  If Xposition2 + 1 > Len(X$) Then
                     X$ = X$ + I$ ' append
                     Xposition2 = Xposition2 + 1
                     If Xposition2 > LC Then
                        Xposition1 = Xposition1 + 1
                     End If
                  Else ' insert
                     Mid$(X$, Xposition2 + 1, 1) = I$
                     Xposition2 = Xposition2 + 1
                  End If
               End If
               GoSub DisplayFileLine
            End If
         End If
      End If

      ' check extended key
      If Len(I$) = 2 Then
         Select Case Asc(Right$(I$, 1))
            Case 82 ' Insert
               Insert = Not Insert
               If Insert Then
                  Locate , , 1, 8, 8 ' block cursor
               Else
                  Locate , , 1, 0, 8 ' line cursor
               End If
            Case 83 ' Delete
               If Len(X$) > 0 Then
                  X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                  GoSub DisplayFileLine
               End If
            Case 71, 73, 119 ' Home/PageUp/Ctrl-Home
               If Xposition2 > 0 Then
                  Xposition1 = 1
                  Xposition2 = 0
                  GoSub DisplayFileLine
               End If
            Case 79, 81, 117 ' End/PageDown/Ctrl-End
               If Xposition2 < Len(X$) Then
                  Xposition2 = Len(X$)
                  Xposition1 = Xposition2 - LC + 1
                  If Xposition1 < 1 Then
                     Xposition1 = 1
                  End If
                  GoSub DisplayFileLine
               End If
            Case 75, 115, 155 ' Left/Ctrl-Left/Alt-Left
               If Len(X$) Then
                  If Xposition2 > 0 Then
                     Xposition2 = Xposition2 - 1
                     If Xposition2 - LC <= Xposition1 Then
                        Xposition1 = Xposition1 - 1
                        If Xposition1 < 1 Then
                           Xposition1 = 1
                        End If
                        GoSub DisplayFileLine
                     End If
                  End If
               End If
            Case 77, 116, 157 ' Right/Ctrl-Right/Alt-Right
               If Len(X$) Then
                  If Xposition2 < Len(X$) Then
                     Xposition2 = Xposition2 + 1
                     If Xposition2 > Xposition1 + LC - 1 Then
                        Xposition1 = Xposition1 + 1
                     End If
                     GoSub DisplayFileLine
                  End If
               End If
         End Select
      End If
   Loop
   Locate , , 1, 8, 8
   Exit Function

   ' display current entry area.
   DisplayFileLine:
   Locatef XC, YC, 1
   Printf Space$(LC)
   ' display edit line and position cursor.
   Locatef XC, YC, 1
   If Len(X$) Then
      Colorf White
      Printf Mid$(X$, Xposition1, LC)
   End If
   Locatef XC, YC + Xposition2 - Xposition1 + 1, 1
   Colorf2 Plain, Black
   Return
End Function

' load current directories.
Sub LoadDirSpec (DirY$, N$, C$, D$)
   If RequireDirReadOnly Or RequireDirHidden Or RequireDirSystem Or RequireDirArchive Then
      Required = True
   Else
      Required = False
   End If
   Colorf White
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Space$(26)
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf DirLoadMessage
   Colorf Plain

   ' reset directory counter.
   If D$ = "" Or D$ = "\" Then
      Num.Dirs = 0
   Else
      Num.Dirs = 1
      WinFileStruc.Name = ".."
      Put #3, 1, WinFileStruc
   End If

   ' find directories.
   F$ = MakeFilename3$(N$, C$, D$)
   F$ = F$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(F$), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         X$ = finddata.cFileName
         VarX = InStr(X$, Chr$(0))
         If VarX Then
            X$ = Left$(X$, VarX - 1)
         End If

         If InStr(X$, "?") Then ' unicode
            X$ = finddata.cAlternateFileName
            VarX = InStr(X$, Chr$(0))
            If VarX Then
               X$ = Left$(X$, VarX - 1)
            End If
         End If

         If Len(X$) Then
            Attr = finddata.dwFileAttributes
            If (Attr And &H10) = &H10 Then
               If X$ = "." Or X$ = ".." Then
                  Eat$ = Nul
               Else
                  ' check file counter.
                  If Num.Dirs >= MaxPrecision Then
                     Exit Do
                  End If

                  ' reset file flag.
                  Flag = True
                  If Required Then
                     GoSub Check.Required1
                  End If

                  ' check flag.
                  If Flag Then
                     ' check excluded list.
                     If Len(DirY$) Then
                        GoSub Check.List1
                     End If
                     If Flag Then
                        ' store directory.
                        Num.Dirs = Num.Dirs + 1!
                        WinFileStruc.Name = X$
                        Put #3, Num.Dirs, WinFileStruc
                     End If
                  End If
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If

   ' display number of directories.
   Locatef Xcoor + 3, Ycoor + 24, 0
   Printf Space$(8)
   Locatef Xcoor + 3, Ycoor + 24, 0
   Colorf White

   ' format display
   Var# = CDbl(Num.Dirs)
   If Var# > 32767# Then
      Var# = Int(Var# / 1024#)
   End If
   Value$ = FormatX$(Var#, 0)
   If Num.Dirs > 32767! Then
      Value$ = Value$ + "K"
   End If
   Printf Value$
   Colorf Plain

   ' sort directories.
   If HeapSortOff Then
      Exit Sub
   End If
   If Num.Dirs < 2 Then
      Exit Sub
   End If
   If SortMax2 > 0! Then
      If Num.Dirs >= SortMax2 Then
         Locatef Xcoor + 1, Ycoor + 2, 1
         Printf Space$(38)
         Locatef Xcoor + 1, Ycoor + 2, 1
         Colorf2 White, 0
         Var! = Int(SortMax2 / 1024!)
         Printf "Dirs exceed" + Str$(Var!) + "K. Sort anyway<y/n>:"
         Do
            M$ = Nul
            While M$ = Nul
               M$ = INKEYx$
            Wend
            If M$ = Chr$(27) Then
               GoSub FileDisplay
               Exit Sub
            End If
            M$ = UCase$(M$)
            If M$ = "Y" Then
               GoSub FileDisplay
               Exit Do
            End If
            If M$ = "N" Then
               GoSub FileDisplay
               Exit Sub
            End If
         Loop
      End If
   End If
   Colorf White
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Space$(26)
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf "Sorting dirs.."
   Colorf Plain
   Call SortFiles(2)
   Exit Sub

   ' display filename
   FileDisplay:
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf "Filename: "
   Return

   ' check dir exclusion list.
   Check.List1:
   Y2$ = UCase$(DirY$)
   L1$ = UCase$(X$)
   Do
      ' parse list.
      Y1 = InStr(Y2$, " ")
      If Y1 Then
         Y1$ = Left$(Y2$, Y1 - 1)
         Y2$ = Mid$(Y2$, Y1 + 1)
      Else
         Y1$ = Y2$
         Y2$ = Nul
      End If
      Y1$ = LTrim$(Y1$)
      Y1$ = RTrim$(Y1$)
      Y2$ = LTrim$(Y2$)
      Y2$ = RTrim$(Y2$)
      ' check excluded file in filename.
      If Len(Y1$) Then
         Call CheckExcluded(Y1$, L1$, Exclude.File)
         If Exclude.File Then
            Flag = False
            Exit Do
         End If
      End If
      If Y2$ = Nul Then
         Exit Do
      End If
   Loop
   Return

   ' check requirements.
   Check.Required1:
   If RequireDirReadOnly Then
      If (Attr And 1) = 0 Then
         Flag = False
      End If
   End If
   If RequireDirHidden Then
      If (Attr And 2) = 0 Then
         Flag = False
      End If
   End If
   If RequireDirSystem Then
      If (Attr And 4) = 0 Then
         Flag = False
      End If
   End If
   If RequireDirArchive Then
      If (Attr And 32) = 0 Then
         Flag = False
      End If
   End If
   Return
End Sub

' load specified files.
Sub LoadFileSpec (FileY$, F$)
   If RequireReadOnly Or RequireHidden Or RequireSystem Or RequireArchive Then
      Required = True
   Else
      Required = False
   End If
   Colorf White
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Space$(26)
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf FileLoadMessage
   Colorf Plain
   Num.Files = False

   ' find files.
   If Right$(F$, 1) = "\" Then
      F$ = F$ + "*.*"
   End If
   F$ = F$ + Chr$(0)
   hfind = FindFirstFileA(_Offset(F$), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Do
         X$ = finddata.cFileName
         VarX = InStr(X$, Chr$(0))
         If VarX Then
            X$ = Left$(X$, VarX - 1)
         End If

         If InStr(X$, "?") Then ' unicode
            X$ = finddata.cAlternateFileName
            VarX = InStr(X$, Chr$(0))
            If VarX Then
               X$ = Left$(X$, VarX - 1)
            End If
         End If

         If Len(X$) Then
            Attr = finddata.dwFileAttributes
            If (Attr And &H10) = &H0 Then
               ' check file counter.
               If Num.Files >= MaxPrecision Then
                  Exit Do
               End If

               ' reset file flag.
               Flag = True
               If Required Then
                  GoSub Check.Required2
               End If

               ' check flag.
               If Flag Then
                  ' check excluded list.
                  If Len(FileY$) Then
                     GoSub Check.List2
                  End If

                  ' check flag.
                  If Flag Then
                     ' store filename.
                     Num.Files = Num.Files + 1!
                     WinFileStruc.Name = X$
                     Put #2, Num.Files, WinFileStruc
                  End If
               End If
            End If
         End If
      Loop While FindNextFileA(hfind, _Offset(finddata))
      x = FindClose(hfind)
   End If

   ' display number of files.
   Locatef Xcoor + 3, Ycoor + 9, 0
   Printf Space$(9)
   Locatef Xcoor + 3, Ycoor + 9, 0
   Colorf White

   ' format display
   Var# = CDbl(Num.Files)
   If Var# > 32767# Then
      Var# = Int(Var# / 1024#)
   End If
   Value$ = FormatX$(Var#, 0)
   If Num.Files > 32767! Then
      Value$ = Value$ + "K"
   End If
   Printf Value$
   Colorf Plain

   ' sort files.
   If HeapSortOff Then
      Exit Sub
   End If
   If Num.Files < 2 Then
      Exit Sub
   End If
   If SortMax > 0! Then
      If Num.Files >= SortMax Then
         Locatef Xcoor + 1, Ycoor + 2, 1
         Printf Space$(38)
         Locatef Xcoor + 1, Ycoor + 2, 1
         Colorf2 White, 0
         Var! = Int(SortMax / 1024!)
         Printf "Files exceed" + Str$(Var!) + "K. Sort anyway<y/n>:"
         Do
            M$ = Nul
            While M$ = Nul
               M$ = INKEYx$
            Wend
            If M$ = Chr$(27) Then
               GoSub FileDisplay2
               Exit Sub
            End If
            M$ = UCase$(M$)
            If M$ = "Y" Then
               GoSub FileDisplay2
               Exit Do
            End If
            If M$ = "N" Then
               GoSub FileDisplay2
               Exit Sub
            End If
         Loop
      End If
   End If
   Colorf White
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Space$(26)
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf "Sorting files.."
   Colorf Plain
   Call SortFiles(1)
   Exit Sub

   ' display filename
   FileDisplay2:
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf "Filename: "
   Return

   ' check file exclusion list.
   Check.List2:
   Y2$ = UCase$(FileY$)
   L1$ = UCase$(X$)
   Do
      ' parse list.
      Y1 = InStr(Y2$, " ")
      If Y1 Then
         Y1$ = Left$(Y2$, Y1 - 1)
         Y2$ = Mid$(Y2$, Y1 + 1)
      Else
         Y1$ = Y2$
         Y2$ = Nul
      End If
      Y1$ = LTrim$(Y1$)
      Y1$ = RTrim$(Y1$)
      Y2$ = LTrim$(Y2$)
      Y2$ = RTrim$(Y2$)
      ' check excluded file in filename.
      If Len(Y1$) Then
         Call CheckExcluded(Y1$, L1$, Exclude.File)
         If Exclude.File Then
            Flag = False
            Exit Do
         End If
      End If
      If Y2$ = Nul Then
         Exit Do
      End If
   Loop
   Return

   ' check requirements.
   Check.Required2:
   If RequireReadOnly Then
      If (Attr And 1) = 0 Then
         Flag = False
      End If
   End If
   If RequireHidden Then
      If (Attr And 2) = 0 Then
         Flag = False
      End If
   End If
   If RequireSystem Then
      If (Attr And 4) = 0 Then
         Flag = False
      End If
   End If
   If RequireArchive Then
      If (Attr And 32) = 0 Then
         Flag = False
      End If
   End If
   Return
End Sub

' subroutine to access subdirectories
Sub Silentdel_Directories (Directory.Search$)
   ' declare subroutine variables
   Dim Attribute As Integer
   Dim TempASCIIZ As String * 260
   Dim finddata2 As WIN32_FIND_DATA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make directory filename
   TempASCIIZ = Directory.Search$ + "*.*" + Chr$(0)

   ' start directory search
   Wfile.Handle = FindFirstFileA(_Offset(TempASCIIZ), _Offset(finddata2))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' delete filenames
      Call Silentdel_DeleteFiles(Directory.Search$)

      ' recurse subdirectories
      Do
         ' check directory attribute
         Attribute = finddata2.dwFileAttributes

         ' check directory
         If (Attribute And &H10) = &H10 Then

            ' store directory name
            Directory$ = finddata2.cFileName
            Directory$ = Left$(Directory$, InStr(Directory$, Chr$(0)) - 1)

            ' check directory name
            If Directory$ <> "." And Directory$ <> ".." Then

               ' store short filename
               If InStr(Directory$, "?") Then
                  Directory$ = finddata2.cAlternateFileName
                  V = InStr(Directory$, Chr$(0))
                  If V Then Directory$ = Left$(Directory$, V - 1)
               End If

               ' make next search directory
               If Len(Directory$) Then
                  ' make next search directory
                  Next.Directory$ = Directory.Search$ + Directory$ + "\"

                  ' recursively search subdirectories
                  Call Silentdel_Directories(Next.Directory$)
               End If
            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata2))
      x = FindClose(Wfile.Handle)
   End If

   ' delete directory
   Call Silentdel_DeleteDirectory(Directory.Search$)
End Sub

' subroutine to delete an empty directory
Sub Silentdel_DeleteDirectory (Directory$)
   ' declare subroutine variables
   Dim TempASCIIZ As String * 260

   ' store directory filename
   TempASCIIZ = Directory$ + Chr$(0)

   ' change directory attribute
   AttrX = GetFileAttributes(TempASCIIZ)
   AttrX = AttrX And Not &H1 ' remove read-only bit
   x = SetFileAttributes&(TempASCIIZ, AttrX)

   ' delete directory
   x = RemoveDirectoryA(TempASCIIZ)
End Sub

' subroutine to delete files in a directory
Sub Silentdel_DeleteFiles (Directory$)
   ' declare subroutine variables
   Dim TempASCIIZ As String * 260
   Dim TempASCIIZ2 As String * 260
   Dim finddata2 As WIN32_FIND_DATA
   Dim Wfile.Handle As _Unsigned _Offset

   ' make filename
   TempASCIIZ = Directory$ + "*.*" + Chr$(0)

   Wfile.Handle = FindFirstFileA(_Offset(TempASCIIZ), _Offset(finddata2))
   If Wfile.Handle <> INVALID_HANDLE_VALUE Then

      ' filename loop
      Do
         ' store filename
         Filename$ = finddata2.cFileName
         Filename$ = Left$(Filename$, InStr(Filename$, Chr$(0)) - 1)

         ' check filename
         If Filename$ <> "." And Filename$ <> ".." Then
            ' store filename
            TempASCIIZ2 = Directory$ + Filename$ + Chr$(0)

            ' change filename attribute
            AttrX = GetFileAttributes(TempASCIIZ2)
            AttrX = AttrX And Not &H1 ' remove read-only bit
            x = SetFileAttributes&(TempASCIIZ2, AttrX)

            ' delete long filename
            x = DeleteFileA(TempASCIIZ2)

            ' check error and delete 8.3 filename
            If x = 0 Then
               Short.Filename$ = finddata2.cAlternateFileName
               V = InStr(Short.Filename$, Chr$(0))
               If V Then Short.Filename$ = Left$(Short.Filename$, V - 1)
               TempASCIIZ2 = Directory$ + Short.Filename$ + Chr$(0)

               ' change filename attribute
               AttrX = GetFileAttributes(TempASCIIZ2)
               AttrX = AttrX And Not &H1
               x = SetFileAttributes&(TempASCIIZ2, AttrX)

               ' delete short filename
               x = DeleteFileA(TempASCIIZ2)
            End If
         End If
      Loop While FindNextFileA(Wfile.Handle, _Offset(finddata2))
      x = FindClose(Wfile.Handle)
   End If
End Sub

Sub Menu3 (NetPath$, Drive$, Directory$, FileSpec2$)
   ' read filename from dialog box.
   FileSpec2$ = _OpenFileDialog$("Hexedit Open File", StartDir$)

   ' store current menu box netpath.
   If Left$(FileSpec2$, 2) = "\\" Then
      ' \\netpath\share\filename.ext
      Drive$ = ""
      VarX$ = Mid$(FileSpec2$, 3)
      VarX = InStr(VarX$, "\")
      If VarX Then
         VarX = InStr(VarX + 1, VarX$, "\")
         If VarX Then
            VarX$ = Left$(VarX$, VarX - 1)
         End If
      End If
      NetPath$ = "\\" + VarX$
      Directory$ = Mid$(FileSpec2$, VarX + 2)
      For x = Len(Directory$) To 1 Step -1
         If Mid$(Directory$, x, 1) = "\" Then
            Directory$ = Left$(Directory$, x - 1)
            Exit For
         End If
      Next
      For x = Len(FileSpec2$) To 1 Step -1
         If Mid$(FileSpec2$, x, 1) = "\" Then
            FileSpec2$ = Mid$(FileSpec2$, x + 1)
            Exit For
         End If
      Next
   Else
      If InStr(FileSpec2$, ":") Then
         Drive$ = Left$(FileSpec2$, InStr(FileSpec2$, ":") - 1)
      End If
      Directory$ = Mid$(FileSpec2$, InStr(FileSpec2$, ":") + 1)
      For x = Len(Directory$) To 1 Step -1
         If Mid$(Directory$, x, 1) = "\" Then
            Directory$ = Left$(Directory$, x - 1)
            Exit For
         End If
      Next
      For x = Len(FileSpec2$) To 1 Step -1
         If Mid$(FileSpec2$, x, 1) = "\" Then
            FileSpec2$ = Mid$(FileSpec2$, x + 1)
            Exit For
         End If
      Next
   End If
End Sub

Rem File menu box routine:

Sub Menu (N$, C$, D$, X$, E$)
   Rem Call to Menu() Returns:
   Rem   N$  -  Network path
   Rem       \\server\share
   Rem       Without trailing slash
   Rem         Or Nul for no net
   Rem   C$  -  Drive letter
   Rem       Normally C without : or \
   Rem   D$  -  Directory
   Rem       Without leading or trailing \ (can be null)
   Rem       Can be long pathname. No trailing spaces.
   Rem   X$  -  Filespec
   Rem       Normally *.*
   Rem   E$  -  Filename.ext
   Rem       Can be long filename. No trailing spaces.
   Rem
   Rem Concatenate upon return:
   Rem   IF N$ = Nul THEN
   Rem      IF D$ = Nul THEN
   Rem         Filename = C$ + ":\" + E$
   Rem      ELSE
   Rem         Filename = C$ + ":\" + D$ + "\" + E$
   Rem      END IF
   Rem   ELSE
   Rem      IF D$ = Nul THEN
   Rem         Filename = N$ + "\" + E$
   Rem      ELSE
   Rem         Filename = N$ + "\" + D$ + "\" + E$
   Rem      END IF
   Rem   END IF
   Rem
   Rem Fixed 06/10/2023 now supports both drive and netpath:
   Rem   \\server\c\
   Rem
   Rem During editing,
   Rem   I$  -  Current keystroke.
   Rem   F$  -  Fully qualified pathname with filename and drive letter.
   Rem   Q$  -  Current subdirectory.
   Rem   D1$ -  Temporary directory storage.
   Rem   X1$ -  Temporary file entry area path/file.
   Rem   X2$ -  Temporary filename storage.
   Rem   G$  -  Pathname constructed for KILL, MKDIR, RMDIR.
   Rem
   Rem Mouse variables,
   Rem   IsMenu =
   Rem     1  -  Click in file box.
   Rem     2  -  Click in dir box.
   Rem     3  -  Click in drive box.
   Rem     4  -  Click in entry area.
   Rem     5  -  Click on 'x' to exit.
   _Title "HEXEDIT"

   ' reset flags.
   Ambiguate = AmbiguateSwitch
   FileSort = False
   DirSort = False

   ' open structure files.
   Call OpenDataFiles1

   ' display menu screen.
   Call FileMainMenu

   ' initialize drives.
   Current.Drive = False
   GoSub InitDrive

   ' get current filespec.
   GoSub InitFileSpec

   ' get current directory spec.
   GoSub InitDirSpec

   ' read all filenames.
   GoSub ClearFileBox
   FileLoadMessage = "Initing files.."
   Call LoadFileSpec(FileY$, F$)
   GoSub DisplayFileSpec
   GoSub DisplayCurrentPath

   ' read all subdirectories.
   GoSub ClearDirBox
   DirLoadMessage = "Initing dirs.."
   Call LoadDirSpec(DirY$, N$, C$, D$)
   GoSub DisplayDirSpec
   GoSub DisplayCurrentDir
   GoSub DisplayCurrentPath

   ' display first directory.
   Current.Dir! = 1!
   Dir.Box.Line = 1
   GoSub DisplayInitDir

   ' display all drives.
   GoSub InitDrives

   ' display first file.
   GoSub ClearLongName2
   If Num.Files > 0 Then
      Current.File! = 1!
      Box.Line = 1
      GoSub InitFiles
   End If

   ' reset filename attribute overrides.
   RequireReadOnly = False
   RequireHidden = False
   RequireSystem = False
   RequireArchive = False
   RequireDirReadOnly = False
   RequireDirHidden = False
   RequireDirSystem = False
   RequireDirArchive = False

   Rem File entry area variables:
   Rem   ProcessEditLine - processes X$ edit line when set to True.
   Rem   Xstart     - hilights file entry area for overstrike when set to True.
   Rem   Xposition1 - left position in file entry area editing string.
   Rem   Xposition2 - position of character in file entry area editing string.
   Rem

   Rem main input loop..

   Xstart = True
   Xposition1 = 1
   Do
      ' reset filespec.
      If X$ = Nul Then
         X$ = "*.*"
         Xposition1 = 1
         Xposition2 = 3
      End If

      ' display file entry area.
      GoSub DisplayFileLine

      ' start input loop.
      Do
         ' reset input.
         I$ = Nul

         ' reset edit line.
         ProcessEditLine = False

         ' process input.
         Do
            ' get keypress.
            I$ = INKEYx$

            ' process keypress.
            If Len(I$) Then
               IsMenu = False
               Exit Do
            End If

            ' call mouse subroutine.
            Z = MouseDriver2

            ' check exit symbol.
            If IsMenu = 5 Then
               I$ = Chr$(27)
               Exit Do
            End If

            ' check mouse wheel down
            If MouseWheel = -1 Then
               MouseWheel = 0
               If WheelReverse Then
                  I$ = Chr$(9) ' down
                  GoTo TabFile
               End If
            End If
            If MouseWheel = 1 Then
               MouseWheel = 0
               If WheelReverse = 0 Then
                  I$ = Chr$(9) ' down
                  GoTo TabFile
               End If
            End If

            ' check left mouse button.
            If MouseButton1 = -1 Then
               GoSub MouseButton1Z
               Select Case IsMenu
                  Case 1 ' file box.
                     If I$ = Chr$(13) Then
                        E$ = RTrim$(Filenames(Current.File!))
                        GoTo EndLoop2
                     Else
                        GoSub FileBoxKey
                     End If
                  Case 2 ' dir box.
                     If I$ = Chr$(13) Then
                        GoSub GetNewPath
                        Exit Do
                     Else
                        GoSub DirBoxKey
                     End If
                  Case 3 ' drive box.
                     If I$ = Chr$(13) Then
                        X$ = Chr$(Current.Drive + 64) + ":\*.*"
                        ProcessEditLine = True
                        Exit Do
                     Else
                        GoSub DriveBoxKey
                     End If
               End Select
            Else
               If MouseButton1 = 2 Or MouseButton2 Then
                  GoSub MouseButton1Z
                  If IsMenu = 1 Then
                     ZZ$ = RTrim$(Filenames(Current.File!))
                     Var$ = ZZ$
                     Call ViewFileInfo(Var$)
                     If Var$ = Nul Then
                        Var$ = ZZ$
                        Call ViewFileInfo2(Var$)
                     End If
                     x = MessageBox(" Filename ", ZZ$ + "|" + Var$)
                  End If
                  If IsMenu = 2 Then
                     ZZ$ = RTrim$(Directories(Current.Dir!))
                     Var$ = ZZ$
                     Call ViewFileInfo2(Var$)
                     x = MessageBox(" Directory ", ZZ$ + "|" + Var$)
                  End If
                  If IsMenu = 3 Then
                     Call GetDriveInfo(DriveAttribute$)
                     If Len(DriveAttribute$) = 0 Then
                        ZZ$ = DriveType
                     Else
                        ZZ$ = DriveAttribute$
                     End If
                     x = MessageBox(" Drive ", ZZ$)
                  End If
               Else
                  ' check mouse position.
                  If MouseX Or MouseY Then
                     GoSub MouseOverX1
                     GoSub DisplayFileLine
                  End If
               End If
            End If
         Loop

         ' ignore slash
         If I$ = "/" Then
            I$ = Nul
         End If

         StartLoop0:

         ' check alt-<key>
         If Len(I$) = 2 Then
            GoSub GetAltKey
            If VarZ Then
               ' specify drive letter.
               X$ = Chr$(Var2 + 64) + ":\*.*"
               I$ = Nul
               ProcessEditLine = True
               Exit Do
            End If
         End If

         StartLoop1:

         ' check extended key
         If Len(I$) = 2 Then
            Select Case Asc(Right$(I$, 1))
               Case 71, 119 ' Home/Ctrl-Home
                  If Xposition2 > 0 Then
                     Xstart = False
                     Xposition1 = 1
                     Xposition2 = 0
                     GoSub DisplayFileLine
                  End If
               Case 80, 145, 160 ' Down/Ctrl-Down/Alt-Down
                  I$ = Chr$(9)
                  GoTo TabFile
               Case 79, 117 ' End/Ctrl-End
                  If Xposition2 < Len(X$) Then
                     Xstart = False
                     Xposition2 = Len(X$)
                     Xposition1 = Xposition2 - 25
                     If Xposition1 < 1 Then
                        Xposition1 = 1
                     End If
                     GoSub DisplayFileLine
                  End If
               Case 83 ' Delete
                  If Len(X$) > 0 Then
                     Xstart = False
                     X$ = Left$(X$, Xposition2) + Mid$(X$, Xposition2 + 2)
                     GoSub DisplayFileLine
                  End If
               Case 75, 115, 155 ' Left/Ctrl-Left/Alt-Left
                  If Len(X$) Then
                     If Xposition2 > 0 Then
                        Xposition2 = Xposition2 - 1
                        If Xposition2 - 25 <= Xposition1 Then
                           Xposition1 = Xposition1 - 1
                           If Xposition1 < 1 Then
                              Xposition1 = 1
                           End If
                           GoSub DisplayFileLine
                        End If
                     End If
                  End If
               Case 77, 116, 157 ' Right/Ctrl-Right/Alt-Right
                  If Len(X$) Then
                     If Xposition2 < Len(X$) Then
                        Xposition2 = Xposition2 + 1
                        If Xposition2 > Xposition1 + 25 Then
                           Xposition1 = Xposition1 + 1
                        End If
                        GoSub DisplayFileLine
                     End If
                  End If
               Case 59 ' F1  - change drive letter.
                  I$ = Nul
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 Yellow, 0
                  Printf "Drive letter: "
                  Do
                     Z$ = INKEYx$
                     If Len(Z$) = 1 Then
                        Z$ = UCase$(Z$)
                        If Z$ >= "A" And Z$ <= "Z" Then
                           Exit Do
                        End If
                     End If
                  Loop
                  GoSub DisplayFilename6
                  I$ = Nul
                  X$ = Z$ + ":\*.*"
                  ProcessEditLine = True
                  Exit Do
               Case 60 ' F2  - toggle heap sorting.
                  I$ = Nul
                  HeapSortOff = Not HeapSortOff
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  If HeapSortOff Then
                     Printf "Sorting Off. Press <esc>:"
                  Else
                     Printf "Sorting On. Press <esc>:"
                  End If
                  Call PromptInkey
                  GoSub UpdateDisplay
                  Exit Do
               Case 61 ' F3 - move file menu box.
                  I$ = Nul
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf "Use cursor keys. Press <esc> to quit."
                  Call MoveMenu
                  Call BottomRow
                  GoSub DisplayCurrentPath
                  If Num.Files > 0 Then
                     GoSub DisplayLongName2
                  End If
                  GoSub DisplayFilename6
                  GoSub DisplayFileLine
               Case 62 ' F4 - backward 1 drive letter.
                  I$ = Nul
                  GoSub MoveDriveUp
                  X$ = Chr$(Current.Drive + 64) + ":\*.*"
                  ProcessEditLine = True
                  Exit Do
               Case 63 ' F5 - forward 1 drive letter.
                  I$ = Nul
                  GoSub MoveDriveDown
                  X$ = Chr$(Current.Drive + 64) + ":\*.*"
                  ProcessEditLine = True
                  Exit Do
               Case 64 ' F6 - toggle ambiguate.
                  I$ = Nul
                  Ambiguate = Not Ambiguate
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  If Ambiguate = False Then
                     Printf "Ambiguation Off. Press <esc>:"
                  Else
                     Printf "Ambiguation On. Press <esc>:"
                  End If
                  Call PromptInkey
                  GoSub UpdateDisplay
                  Exit Do
               Case 65 ' F7 - redraw screen
                  GoSub RedrawScreen
                  Exit Do
               Case 66 ' F8 - attribute override
                  I$ = Nul
                  Call OverridePrompt
                  GoSub UpdateDisplay
                  Exit Do
               Case 67 ' F9 - help screen
                  I$ = Nul
                  Call DisplayHelp
                  GoSub RedrawScreen
               Case 68 ' F10 - exit program
                  I$ = Chr$(27)
                  Exit Do
               Case 133 ' F11 - drop to DOS
                  Colorf Plain
                  Cls
                  Printf "Type 'Exit' to return to editor.."
                  Locatef 2, 1, 1
                  Comspec$ = Environ$("COMSPEC")
                  If Len(Comspec$) Then
                     Shell Comspec$
                  Else
                     Shell "CMD"
                  End If
                  GoSub RedrawScreen
                  Exit Do
               Case 134 ' F12 - enter filespec
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf "Enter file spec?"
                  X$ = LineInput$(Xcoor + 1, Ycoor + 19, 21)
                  I$ = Nul
                  If Len(X$) Then
                     E$ = X$
                     If Mid$(E$, 2, 1) = ":" Then
                        C$ = Left$(E$, 1)
                        E$ = Mid$(E$, 3)
                        N$ = Nul
                     End If
                     For VarQ = Len(E$) To 1 Step -1
                        If Mid$(E$, VarQ, 1) = "\" Then
                           D$ = Left$(E$, VarQ)
                           E$ = Mid$(E$, VarQ + 1)
                           Exit For
                        End If
                     Next
                     If Right$(D$, 1) = "\" Then
                        D$ = Left$(D$, Len(D$) - 1)
                     End If
                     If Left$(D$, 1) = "\" Then
                        D$ = Mid$(D$, 2)
                     End If
                     X$ = "*.*"
                     I$ = Chr$(13)
                     Exit Do
                  End If
                  GoSub DisplayFilename6
                  GoSub DisplayFileLine
                  Exit Do
               Case 137, 138 ' Ctrl-F11, Ctrl-F12 - call screen saver
                  I$ = Nul
                  s%& = SendMessageA(GetDesktopWindow, wm_syscommand, sc_screensave, 0&)
                  Exit Do
               Case 94, 104 ' Ctrl-F1/Alt-F1 - toggle quiet mode.
                  I$ = Nul
                  Select Case QuietSwitch
                     Case -1
                        QuietSwitch = 0
                     Case 0
                        QuietSwitch = 1
                     Case 1
                        QuietSwitch = 2
                     Case 2
                        QuietSwitch = 3
                     Case 3
                        QuietSwitch = 4
                     Case 4
                        QuietSwitch = 5
                     Case 5
                        QuietSwitch = 6
                     Case 6
                        QuietSwitch = -1
                  End Select
                  Select Case QuietSwitch
                     Case 0
                        P$ = "Quiet switch off."
                     Case -1
                        P$ = "Quiet switch on."
                     Case Else
                        P$ = "Quiet switch level" + Str$(QuietSwitch) + "."
                  End Select
                  P$ = P$ + " Press <esc>."
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf P$
                  Call PromptInkey
                  GoSub UpdateDisplay
                  Exit Do
               Case 95, 105 ' Ctrl-F2/Alt-F2 - file exclusion entry.
                  I$ = Nul
                  Call ExcludeList(1, Y$)
                  FileY$ = Y$
                  GoSub RedrawScreen
                  Exit Do
               Case 96, 106 ' Ctrl-F3/Alt-F3 - dir exclusion entry.
                  I$ = Nul
                  Call ExcludeList(2, Y$)
                  DirY$ = Y$
                  GoSub RedrawScreen
                  Exit Do
               Case 97, 107 ' Ctrl-F4/Alt-F4 - toggle file sort ascending/descending.
                  I$ = Nul
                  FileSort = Not FileSort
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  If FileSort Then
                     Printf "File sort descending. Press <esc>:"
                  Else
                     Printf "File sort ascending. Press <esc>:"
                  End If
                  Call PromptInkey
                  GoSub UpdateDisplay
                  Exit Do
               Case 98, 108 ' Ctrl-F5/Alt-F5 - toggle dir sort ascending/descending.
                  I$ = Nul
                  DirSort = Not DirSort
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  If DirSort Then
                     Printf "Dir sort descending. Press <esc>:"
                  Else
                     Printf "Dir sort ascending. Press <esc>:"
                  End If
                  Call PromptInkey
                  GoSub UpdateDisplay
                  Exit Do
               Case 99, 109 ' Ctrl-F6/Alt-F6 - toggle file date/time switch.
                  I$ = Nul
                  Select Case FileSwitch
                     Case 0
                        FileSwitch = 1
                     Case 1
                        FileSwitch = 2
                     Case 2
                        FileSwitch = 0
                  End Select
                  P$ = "File switch level" + Str$(FileSwitch) + "."
                  P$ = P$ + " Press <esc>."
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf P$
                  Call PromptInkey
                  GoSub UpdateDisplay
                  Exit Do
               Case 100, 110 ' Ctrl-F7/Alt-F7 - toggle file size switch.
                  I$ = Nul
                  Select Case FileSizeType
                     Case 0
                        FileSizeType = 1
                        Var$ = "KB."
                     Case 1
                        FileSizeType = 2
                        Var$ = "MB."
                     Case 2
                        FileSizeType = 3
                        Var$ = "GB."
                     Case 3
                        FileSizeType = 0
                        Var$ = "B."
                  End Select
                  P$ = "File size switch: " + Var$
                  P$ = P$ + " Press <esc>."
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf P$
                  Call PromptInkey
                  GoSub UpdateDisplay
                  Exit Do
               Case 101, 111 ' Ctrl-F8/Alt-F8 - network path.
                  I$ = Nul
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf "Net path?"
                  Z$ = LineInput$(Xcoor + 1, Ycoor + 12, 28)
                  X$ = Nul
                  If Len(Z$) Then
                     If Left$(Z$, 2) = "\\" Then
                        X$ = Z$
                     End If
                  End If
                  GoSub DisplayFilename6
                  GoSub DisplayFileLine
                  ProcessEditLine = True
                  Exit Do
               Case 102, 112 ' Ctrl-F9/Alt-F9 - default network path.
                  I$ = Nul
                  X$ = Nul
                  ' store default server name
                  If RTrim$(DefaultNetPath) <> Nul Then
                     X$ = "\\" + RTrim$(DefaultNetPath) + "\C\"
                     GoSub DisplayFilename6
                     GoSub DisplayFileLine
                     ProcessEditLine = True
                     Exit Do
                  End If
               Case 103, 113 ' Ctrl-F10/Alt-F10 - load default net w/ drive letter
                  I$ = Nul
                  X$ = Nul
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf "Drive letter: "
                  Do
                     Z$ = INKEYx$
                     If Len(Z$) = 1 Then
                        Z$ = UCase$(Z$)
                        If Z$ >= "A" And Z$ <= "Z" Then
                           Exit Do
                        End If
                     End If
                  Loop
                  Printf Z$
                  ' store default server name
                  If RTrim$(DefaultNetPath) <> Nul Then
                     X$ = "\\" + RTrim$(DefaultNetPath) + "\" + UCase$(Z$) + "\"
                     GoSub DisplayFilename6
                     GoSub DisplayFileLine
                     ProcessEditLine = True
                     Exit Do
                  End If
               Case Else
                  I$ = Nul ' nul activity
            End Select
            I$ = Nul ' nul keystroke
         End If

         Rem tab key label.
         TabFile:

         ' Tab moves to file loop, or
         '   directory loop if there are no files.
         If I$ = Chr$(9) Then
            If Num.Files > 0 Then
               GoSub FileInputLoop

               ' check function key.
               If Len(I$) = 2 Then
                  VarQ = Asc(Right$(I$, 1))
                  Select Case VarQ
                     Case 59 To 68, 104 To 113, 133, 134
                        GoTo StartLoop1
                  End Select
                  GoSub GetAltKey
                  If VarZ Then
                     GoTo StartLoop0
                  End If
               End If

               ' tab from drive input loop.
               If I$ = Chr$(9) Then
                  I$ = Nul
                  Exit Do
               End If

               ' shift-tab from dir input loop.
               If I$ = Chr$(0) + Chr$(15) Then
                  I$ = Nul
                  Exit Do
               End If

               ' click on file entry area.
               If IsMenu = 4 Then
                  GoSub DisplayCurrentPath
                  If Num.Files > 0 Then
                     GoSub DisplayLongName2
                  End If
                  Exit Do
               End If
               If I$ = Chr$(13) Then
                  Select Case IsMenu
                     Case 1 ' file box.
                        E$ = RTrim$(Filenames(Current.File!))
                        GoTo EndLoop2
                     Case 2 ' dir box.
                        GoSub GetNewPath
                     Case 3 ' drive box.
                        X$ = Chr$(Current.Drive + 64) + ":\*.*"
                        I$ = Nul
                        ProcessEditLine = True
                        Exit Do
                     Case 4 ' entry area.
                        GoSub DisplayCurrentPath
                        If Num.Files > 0 Then
                           GoSub DisplayLongName2
                        End If
                        Exit Do
                     Case 5
                        I$ = Chr$(27)
                        Exit Do
                     Case Else
                        E$ = RTrim$(Filenames(Current.File!))
                        GoTo EndLoop2
                  End Select
               End If
            Else
               GoSub DirInputLoop
               ' check function key.
               If Len(I$) = 2 Then
                  VarQ = Asc(Right$(I$, 1))
                  Select Case VarQ
                     Case 59 To 68, 104 To 113, 133, 134
                        GoTo StartLoop1
                  End Select
                  GoSub GetAltKey
                  If VarZ Then
                     GoTo StartLoop0
                  End If
               End If
               ' tab from drive input loop.
               If I$ = Chr$(9) Then
                  I$ = Nul
                  Exit Do
               End If
               ' shift-tab from drive input loop.
               If I$ = Chr$(0) + Chr$(15) Then
                  I$ = Nul
                  Exit Do
               End If
               If IsMenu = 4 Then
                  GoSub DisplayCurrentPath
                  If Num.Files > 0 Then
                     GoSub DisplayLongName2
                  End If
                  Exit Do
               End If
               If I$ = Chr$(13) Then
                  Select Case IsMenu
                     Case 1 ' file box.
                        E$ = RTrim$(Filenames(Current.File!))
                        GoTo EndLoop2
                     Case 2 ' dir box.
                        GoSub GetNewPath
                     Case 3 ' drive box.
                        X$ = Chr$(Current.Drive + 64) + ":\*.*"
                        I$ = Nul
                        ProcessEditLine = True
                        Exit Do
                     Case 4 ' entry area.
                        GoSub DisplayCurrentPath
                        If Num.Files > 0 Then
                           GoSub DisplayLongName2
                        End If
                        Exit Do
                     Case 5
                        I$ = Chr$(27)
                        Exit Do
                     Case Else
                        GoSub GetNewPath
                  End Select
               End If
            End If
         End If

         ' test break key.
         If I$ = Chr$(3) Then ' Ctrl-C
            If Control.Break Then
               I$ = ""
            End If
            _Delay 1.2 ' delay for break
         End If

         ' test error key.
         If I$ = Chr$(5) Then ' Ctrl-E
            If Debug Then
               I$ = Nul
               V = Sqr(-1) ' test syntax error
            End If
         End If

         ' enter key.
         If I$ = Chr$(13) Then
            I$ = Nul
            ProcessEditLine = True
            Exit Do
         End If

         ' escape key.
         If I$ = Chr$(27) Then
            Exit Do ' exit box.
         End If

         ' backspace.
         If I$ = Chr$(8) Then
            If Len(X$) Then
               If Xstart = True And Xposition2 = 0 Then
                  X$ = Nul
                  Xstart = False
                  Xposition1 = 1
                  Xposition2 = 0
                  GoSub DisplayFileLine
               Else
                  If Xposition2 > 0 Then
                     Xstart = False
                     X$ = Left$(X$, Xposition2 - 1) + Mid$(X$, Xposition2 + 1)
                     Xposition2 = Xposition2 - 1
                     If Xposition2 - 25 <= Xposition1 Then
                        Xposition1 = Xposition1 - 1
                        If Xposition1 < 1 Then
                           Xposition1 = 1
                        End If
                     End If
                     GoSub DisplayFileLine
                  End If
               End If
            End If
         Else
            ' append/insert character into filename area.
            If Len(I$) Then
               ' check input length.
               If Len(X$) >= 259 Then ' asciiz
                  X$ = Nul
                  Xstart = False
                  Xposition1 = 1
                  Xposition2 = 0
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf "Edit line error. Press <esc>:"
                  Call PromptInkey
               Else
                  If Xstart Then
                     X$ = Nul
                     Xstart = False
                     Xposition1 = 1
                     Xposition2 = 0
                     GoSub DisplayFileLine
                  End If
                  X$ = Left$(X$, Xposition2) + I$ + Mid$(X$, Xposition2 + 1)
                  Xposition2 = Xposition2 + 1
                  If Xposition2 > 26 Then
                     Xposition1 = Xposition1 + 1
                  End If
                  GoSub DisplayFileLine
               End If
            End If
         End If
      Loop

      ' exit menu box w/o filename.
      If I$ = Chr$(27) Then
         E$ = Nul
         Exit Do
      End If

      ' exit menu box with filename.
      If I$ = Chr$(13) Then
         Exit Do
      End If

      Rem Process edit line in X$
      Rem
      Rem Parses
      Rem   c:\path\filename.ext
      Rem     or
      Rem   \\netpath\share\path
      Rem
      Rem With partial pathname override,
      Rem filename ambiguation detection, and
      Rem multi-dot imbedded path retracting.

      ' check process flag.
      If ProcessEditLine Then

         ' store values.
         D1$ = D$
         X2$ = F$

         ' change netpath.
         If Left$(X$, 2) = "\\" Then
            If Right$(X$, 1) <> "\" Then
               X$ = X$ + "\"
            End If
            N$ = X$

            ' display message.
            Colorf White
            Locatef Xcoor + 1, Ycoor + 12, 1
            Printf Space$(26)
            Locatef Xcoor + 1, Ycoor + 12, 1
            Printf "Checking path.."
            Colorf Plain

            ' check netpath not available.
            Disk.Ready = NETPATHEXISTS(N$)
            If Disk.Ready Then
               N$ = Nul
               GoSub PromptNet
               GoSub InitFileSpec
               Xstart = True
               GoTo EndLoop1
            End If

            ' store new netpath.
            N$ = Left$(N$, Len(N$) - 1)
            D$ = Nul ' root.
            X$ = "*.*"

            ' parse dospath from netpath
            VX = InStr(3, N$, "\") + 1
            VX = InStr(VX + 1, N$, "\")
            If VX Then
               D$ = Mid$(N$, VX)
               N$ = Left$(N$, VX - 1)
            End If
            New.Net = True
         End If

         ' change drive.
         If Mid$(X$, 2, 1) = ":" Then

            ' display message.
            Colorf White
            Locatef Xcoor + 1, Ycoor + 12, 1
            Printf Space$(26)
            Locatef Xcoor + 1, Ycoor + 12, 1
            Printf "Loading drive.."
            Colorf Plain

            ' check drive.
            Z$ = UCase$(Left$(X$, 1))
            X$ = Mid$(X$, 3)

            ' check last drive.
            V = Asc(Z$) - 64
            If V > Last.Drive Then
               GoSub PromptDisk
               GoSub InitFileSpec
               Xstart = True
               GoTo EndLoop1
            End If

            ' check disk available.
            Disk.Ready = DRIVEEXISTS(V)

            ' check disk ready.
            If Disk.Ready Then
               GoSub PromptDisk
               GoSub InitFileSpec
               Xstart = True
               GoTo EndLoop1
            End If

            ' check media exists.
            If Disk.Ready = False Then
               If MEDIAEXISTS(V) = False Then
                  Disk.Ready = True
               End If
            End If

            ' check disk ready.
            If Disk.Ready Then
               GoSub PromptMedia
               GoSub InitFileSpec
               Xstart = True
               GoTo EndLoop1
            End If

            ' store new drive.
            If C$ <> Z$ Or N$ <> Nul Then
               N$ = Nul
               C$ = Z$
               New.Drive = V
               If X$ = Nul Then
                  X$ = "\"
               End If
               If Right$(X$, 1) = "\" Then
                  X$ = X$ + "*.*"
               End If
            End If
         End If

         ' parse out path.
         Call Parse.Path(D$, X$)

         ' parse off directory.
         If InStr(X$, "\") Then
            For Var = Len(X$) To 1 Step -1
               If Mid$(X$, Var, 1) = "\" Then
                  Exit For
               End If
            Next

            ' parse filename.
            Select Case Var
               Case 1 ' check root.
                  D$ = Nul
                  X$ = Mid$(X$, Var + 1)
               Case Len(X$) ' check nul filename.
                  D$ = Left$(X$, Var - 1)
                  X$ = Nul
                  ' parse directory/filename.
               Case Else
                  If Left$(X$, 1) = "\" Then
                     D$ = Left$(X$, Var - 1)
                  Else
                     D$ = D$ + "\" + Left$(X$, Var - 1)
                  End If
                  X$ = Mid$(X$, Var + 1)
            End Select
         End If

         ' process directory.
         If Left$(D$, 1) = "\" Then
            D$ = Mid$(D$, 2)
         End If
         If Right$(D$, 1) = "\" Then
            D$ = Left$(D$, Len(D$) - 1)
         End If
         If Left$(D$, 1) = "\" Then
            D$ = Nul
         End If
         If Right$(D$, 1) = "\" Then
            D$ = Nul
         End If
         If D$ = "\" Then
            D$ = Nul
         End If

         ' check directory.
         GoSub CheckPath
         If ValidPath = False Then
            D$ = D1$
            X$ = X1$
            Xposition1 = 1
            Xposition2 = 0
            GoTo EndLoop1
         End If

         ' store directory.
         D3$ = D$
         X3$ = X$

         ' prevent directory from loading twice.
         LoadedDir = False

         ' check filename.
         If X$ = String$(Len(X$), ".") Then
            ' strip multiple dots from path.
            Call Parse.Path2(D$, X$)
         End If

         ' construct partial path.
         If D$ = Nul Then
            D$ = X$
         Else
            If X$ <> Nul Then
               D$ = D$ + "\" + X$
            End If
         End If

         ' check path.
         GoSub CheckPath

         ' check valid path.
         If ValidPath = False Then
            D$ = D3$
            X$ = X3$
         End If

         ' check valid path.
         If ValidPath Then
            ' check directory already loaded.
            If D$ <> D1$ Or New.Drive > 0 Or New.Net Then
               ' load current directory.
               DirLoadMessage = "Loading dirs.."
               Call LoadDirSpec(DirY$, N$, C$, D$)
               New.Drive = True
               New.Net = False
            End If
            ' reset filename.
            X$ = Nul
            ' set loaded flag.
            LoadedDir = True
            GoSub DisplayCurrentDir
         End If

         ' check filename.
         If X$ = Nul Then
            GoSub InitFileSpec
         End If

         ' check loaded dir.
         If LoadedDir = False Then
            ' check filename characters.
            If InStr(X$, "?") = False Then
               If InStr(X$, "*") = False Then
                  ' search for directory spec override.
                  For Var! = 1! To Num.Dirs
                     S$ = UCase$(RTrim$(Directories(Var!)))
                     ' check X$ is directory in current one.
                     If D$ = Nul Then
                        ASCIIZ = "\" + S$ + Chr$(0)
                     Else
                        ASCIIZ = "\" + D$ + "\" + S$ + Chr$(0)
                     End If
                     Flag = False
                     ' get conanicalized directory name.
                     V4 = False
                     GoSub ShortFilenameX
                     ' check directory name.
                     If UCase$(X$) = Short.Filename$ Then
                        Flag = True
                     End If
                     ' check directory name.
                     If Flag = False Then
                        If UCase$(X$) = S$ Then
                           Flag = True
                        End If
                     End If
                     If Flag Then
                        ' store directory.
                        S$ = RTrim$(Directories(Var!))
                        If D$ = Nul Then
                           D$ = S$
                        Else
                           D$ = D$ + "\" + S$
                        End If
                        ' restore filename override.
                        GoSub InitFileSpec
                        Exit For
                     End If
                  Next
               End If
            End If
         End If

         ' store current filespec.
         If X$ = "." Then
            X$ = Nul
         End If

         ' store and load directories.
         If LoadedDir = False Then
            ' check directory already loaded.
            If D$ <> D1$ Or New.Drive > 0 Or New.Net Then
               ' load directories.
               GoSub LoadNewDir
               New.Drive = True
               New.Net = False
            End If
         Else
            ' init directories.
            GoSub LoadNewDir2
            GoSub DisplayCurrentDir
         End If

         ' store filename.
         GoSub InitDirSpec

         ' store filename.
         X1$ = X$
         Xposition1 = 1
         Xposition2 = 0

         ' compare filespecs.
         If UCase$(F$) <> UCase$(X2$) Then
            ' store filespec.
            X2$ = F$
            ' load file box.
            GoSub LoadNewFiles
         End If

         ' check filename characters.
         If InStr(X$, "?") = False Then
            If InStr(X$, "*") = False Then
               ' search for filename spec override.
               For Var! = 1! To Num.Files
                  S$ = UCase$(RTrim$(Filenames(Var!)))
                  ' check X$ is filename in current directory.
                  If D$ = Nul Then
                     ASCIIZ = "\" + S$ + Chr$(0)
                  Else
                     ASCIIZ = "\" + D$ + "\" + S$ + Chr$(0)
                  End If
                  Flag = False
                  ' get conanicalized filename.
                  V4 = False
                  GoSub ShortFilenameX
                  ' check filename.
                  If UCase$(X$) = Short.Filename$ Then
                     Flag = True
                  End If
                  ' check filename.
                  If Flag = False Then
                     If UCase$(X$) = S$ Then
                        Flag = True
                     End If
                  End If
                  If Flag Then
                     ' select file for editing.
                     E$ = RTrim$(Filenames(Var!))
                     Exit Do
                  End If
               Next
            End If
         End If

         ' construct dir/filename.
         V$ = MakeFilename$(N$, C$, D$, X$)

         ' check filename characters.
         If InStr(V$, "?") = False Then
            If InStr(V$, "*") = False Then
               ' select file for editing.
               E$ = X$
               Exit Do
            End If
         End If

         ' display all drives.
         If New.Drive = True Then
            Current.Drive = Asc(C$) - 64
            GoSub InitDrives
            New.Drive = False
         End If

         ' restart editing loop.
         Xstart = True
      End If
      EndLoop1:
   Loop

   ' exit editing loop.
   EndLoop2:

   ' exit file menu box.
   Colorf2 7, 0
   Cls

   ' return to editor.
   Exit Sub

   ' reset file menu box.
   UpdateDisplay:
   GoSub DisplayFilename6
   Colorf2 Plain, Black
   ' init dir box.
   GoSub ClearDirBox
   DirLoadMessage = "Updating dirs.."
   Call LoadDirSpec(DirY$, N$, C$, D$)
   GoSub DisplayDirSpec
   Current.Dir! = 1!
   Dir.Box.Line = 1
   GoSub DisplayCurrentDir
   ' init file box.
   GoSub ClearFileBox
   FileLoadMessage = "Updating files.."
   Call LoadFileSpec(FileY$, F$)
   GoSub DisplayFileSpec
   GoSub DisplayCurrentPath
   ' display first file.
   GoSub ClearLongName2
   If Num.Files > 0 Then
      Current.File! = 1!
      Box.Line = 1
      GoSub InitFiles
   End If
   ' init drive box.
   GoSub InitDrives
   Return

   ' init filespec.
   InitFileSpec:
   ' compare stored filename.
   If X1$ = Nul Then
      X$ = "*.*"
      Xposition1 = 1
      Xposition2 = 3
   Else
      ' restore filename spec.
      X$ = X1$
      Xposition1 = 1
      Xposition2 = 0
   End If
   ' check filename.
   If X$ = "." Then
      X$ = Nul
   End If
   Return

   ' init current directory.
   InitDirSpec:
   F$ = MakeFilename$(N$, C$, D$, X$)
   Return

   ' inits dir box with new dirspec.
   LoadNewDir:
   Current.Dir! = 1!
   Dir.Box.Line = 1
   GoSub ClearDirBox
   GoSub CheckPath
   If ValidPath = False Then
      D$ = D1$
      X$ = X1$
      Xposition1 = 1
      Xposition2 = 0
   End If
   DirLoadMessage = "Reloading dirs.."
   Call LoadDirSpec(DirY$, N$, C$, D$)
   GoSub DisplayDirSpec
   GoSub DisplayCurrentDir
   GoSub DisplayCurrentPath
   GoSub DisplayDirectory
   Return

   ' inits dir box without new dirspec.
   LoadNewDir2:
   Current.Dir! = 1!
   Dir.Box.Line = 1
   GoSub ClearDirBox
   GoSub CheckPath
   If ValidPath = False Then
      D$ = D1$
      X$ = X1$
      Xposition1 = 1
      Xposition2 = 0
   End If
   GoSub DisplayDirSpec
   GoSub DisplayCurrentDir
   GoSub DisplayCurrentPath2
   GoSub DisplayDirectory
   Return

   ' inits file box.
   LoadNewFiles:
   GoSub ClearFileBox
   FileLoadMessage = "Reloading files.."
   Call LoadFileSpec(FileY$, F$)
   GoSub DisplayFileSpec
   If Num.Files > 0 Then
      Current.File! = 1!
      Box.Line = 1
      GoSub InitFiles
   Else
      GoSub ClearLongName2
   End If
   Return

   ' display current filename entry area.
   DisplayFileLine:
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Space$(26)
   ' check hilighting.
   If Xstart Then
      Colorf2 Black, Plain
   End If
   ' display edit line and position cursor.
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Mid$(X$, Xposition1, 26)
   Locatef Xcoor + 1, Ycoor + Xposition2 - Xposition1 + 13, 1
   Colorf2 Plain, Black
   Return

   ' display invalid disk message.
   PromptMedia:
   Z2$ = "Media not ready. Press <esc>:"
   GoTo NextPrompt
   PromptDisk:
   Z2$ = "Disk not ready. Press <esc>:"
   GoTo NextPrompt
   ' display invalid netpath message.
   PromptNet:
   Z2$ = "Net not ready. Press <esc>:"
   NextPrompt:
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf Z2$
   Call PromptInkey
   GoSub DisplayFilename6
   Colorf2 Plain, Black
   Return

   ' init filename input loop.
   InitFiles:
   E$ = RTrim$(Filenames(1!))
   Colorf2 Black, Plain
   Locatef Xcoor + 5, Ycoor + 3, 1
   Printf Left$(E$, 12)
   Colorf2 Plain, Black
   GoSub DisplayLongName2
   Return

   ' filename input loop.
   FileInputLoop:
   I$ = Nul
   Do
      If Current.File! > 0 Then
         GoSub DisplayLongName2
         GoSub ClearFilename
         GoSub DisplayFilename1
      End If
      Do
         ' get keystroke.
         I$ = INKEYx$
         If Len(I$) Then
            IsMenu = False
            Exit Do
         End If

         ' call mouse subroutine.
         Z = MouseDriver2

         ' check file entry area.
         If IsMenu >= 4 Then
            Return
         End If

         ' check mouse wheel.
         If MouseWheel = -1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(80) ' down
            Else
               I$ = Chr$(0) + Chr$(72) ' up
            End If
            MouseWheel = 0
            Exit Do
         End If
         If MouseWheel = 1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(72) ' up
            Else
               I$ = Chr$(0) + Chr$(80) ' down
            End If
            MouseWheel = 0
            Exit Do
         End If

         ' check left mouse button.
         If MouseButton1 = -1 Then
            GoSub MouseButton1Z
            Select Case IsMenu
               Case 1 ' file box.
                  If I$ = Chr$(13) Then
                     Exit Do
                  Else
                     GoSub FileBoxKey
                  End If
               Case 2 ' dir box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub DirBoxKey
                  End If
               Case 3 ' drive box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub DriveBoxKey
                  End If
            End Select
         Else
            If MouseButton1 = 2 Or MouseButton2 Then
               GoSub MouseButton1Z
               ZZ$ = RTrim$(Filenames(Current.File!))
               Var$ = ZZ$
               Call ViewFileInfo(Var$)
               If Var$ = Nul Then
                  Var$ = ZZ$
                  Call ViewFileInfo2(Var$)
               End If
               x = MessageBox(" Filename ", ZZ$ + "|" + Var$)
            Else
               ' check mouse position.
               If MouseX Or MouseY Then
                  GoSub MouseOverX1
               End If
            End If
         End If
      Loop

      ' check function key.
      If Len(I$) = 2 Then
         VarQ = Asc(Right$(I$, 1))
         Select Case VarQ
            Case 59 To 68, 104 To 113, 133, 134
               Return
         End Select
         GoSub GetAltKey
         If VarZ Then
            Return
         End If
      End If

      ' up returns shift-tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 72 Then
            If Current.File! = 1! Then
               If Box.Line = 1 Then
                  I$ = Chr$(0) + Chr$(15)
               End If
            End If
         End If
      End If

      ' shift-tab returns to top.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 15 Then
            Return
         End If
      End If

      ' right returns tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 77 Then
            I$ = Chr$(9)
         End If
      End If

      ' Tab moves to directory loop.
      If I$ = Chr$(9) Then
         GoSub DirInputLoop
         ' check function key.
         If Len(I$) = 2 Then
            VarQ = Asc(Right$(I$, 1))
            Select Case VarQ
               Case 59 To 68, 104 To 113, 133, 134
                  Return
            End Select
            GoSub GetAltKey
            If VarZ Then
               Return
            End If
         End If
         If IsMenu >= 4 Then
            Return
         End If
         If I$ = Chr$(9) Then
            GoSub DisplayCurrentPath
            Return
         End If
      End If
      If I$ = Chr$(13) Then
         Return
      End If
      If I$ = Chr$(27) Then
         Return
      End If
      If Len(I$) = 1 Then
         Select Case I$
            Case "A" To "Z", "a" To "z", "0" To "9"
               ' scan the first character of the filenames.
               J$ = I$
               Do
                  If Current.File! + 1! <= Num.Files Then
                     If Box.Line < 10 Then
                        GoSub ClearFilename
                        Box.Line = Box.Line + 1
                        Current.File! = Current.File! + 1!
                        GoSub DisplayFilename1
                        GoSub DisplayLongName2
                     Else
                        Current.File! = Current.File! + 1!
                        GoSub DisplayFilename2
                        GoSub DisplayFileBox1
                        GoSub DisplayFilename3
                        GoSub DisplayLongName2
                     End If
                     E$ = RTrim$(Filenames(Current.File!))
                     If Left$(E$, 1) = J$ Then
                        Exit Do
                     End If
                     I$ = INKEYx$
                     If I$ = Chr$(27) Then
                        Exit Do
                     End If
                  Else
                     Exit Do
                  End If
               Loop
         End Select
         I$ = Nul
      End If
      If Len(I$) = 2 Then
         GoSub FileBoxKey
         If Num.Files = 0 Then
            I$ = Chr$(0) + Chr$(15)
            Return
         End If
      End If
   Loop
   Return

   ' process key in file box.
   FileBoxKey:
   V = Asc(Right$(I$, 1))
   Select Case V
      Case 82 ' insert
         Locatef Xcoor + 1, Ycoor + 2, 1
         Printf Space$(38)
         Locatef Xcoor + 1, Ycoor + 2, 1
         Colorf2 White, 0

         ' get new file.
         Printf "Filename?"
         ZQ$ = LineInput$(Xcoor + 1, Ycoor + 12, 28)

         ' parse new file.
         If Len(ZQ$) Then

            ' create filename.
            G$ = MakeFilename$(N$, C$, D$, ZQ$)
            If _FileExists(G$) = 0 Then
               ' init file box.
               x = FreeFile
               Open G$ For Output As #x
               GoSub DisplayFilename6
               GoSub ClearFileBox
               FileLoadMessage = "Updating files.."
               Call LoadFileSpec(FileY$, F$)
               GoSub DisplayFileSpec
               GoSub DisplayCurrentPath
               ' display first file.
               GoSub ClearLongName2
               If Num.Files > 0 Then
                  Current.File! = 1!
                  Box.Line = 1
                  GoSub InitFiles
               End If
            Else
               Locatef Xcoor + 1, Ycoor + 2, 1
               Printf Space$(38)
               Locatef Xcoor + 1, Ycoor + 2, 1
               Colorf2 White, 0
               If GetLastError& = &H50 Then ' check already exists
                  Printf "Filename already exists. Press <esc>:"
               Else
                  Printf "Error 0x" + Hex$(GetLastError) + " Press <esc>:"
               End If
               Call PromptInkey
            End If
         End If
         GoSub DisplayFilename6
         GoSub DisplayFileLine
         GoSub DisplayLongName2
      Case 83 ' delete
         ' check file.
         If Num.Files > 0 Then
            E$ = RTrim$(Filenames(Current.File!))
            Locatef Xcoor + 1, Ycoor + 2, 1
            Printf Space$(38)
            Locatef Xcoor + 1, Ycoor + 2, 1
            Colorf2 White, 0
            Printf "Delete current file(y/n)?"
            ErrorRespond$ = Nul
            Do
               ErrorRespond$ = INKEYx$
               If Len(ErrorRespond$) Then
                  If UCase$(ErrorRespond$) = "Y" Then
                     Exit Do
                  End If
                  If UCase$(ErrorRespond$) = "N" Then
                     Exit Do
                  End If
               End If
            Loop
            ' parse key.
            If UCase$(ErrorRespond$) = "Y" Then

               ' delete filename.
               G$ = MakeFilename$(N$, C$, D$, E$)
               G$ = G$ + Chr$(0)

               ' change filename attribute
               AttrX = GetFileAttributes(G$)
               AttrX = AttrX And Not &H1 ' remove read-only bit
               x = SetFileAttributes&(G$, AttrX)
               x = DeleteFileA(G$)

               ' check carry flag error
               If x = 0 Then
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf "Error 0x" + Hex$(GetLastError) + " Press <esc>:"
                  Call PromptInkey
               Else
                  ' init file box.
                  GoSub DisplayFilename6
                  GoSub ClearFileBox
                  FileLoadMessage = "Updating files.."
                  Call LoadFileSpec(FileY$, F$)
                  GoSub DisplayFileSpec
                  GoSub DisplayCurrentPath
                  ' display first file.
                  GoSub ClearLongName2
                  If Num.Files > 0 Then
                     Current.File! = 1!
                     Box.Line = 1
                     GoSub InitFiles
                  End If
               End If
            End If
            GoSub DisplayFilename6
            GoSub DisplayFileLine
            GoSub DisplayLongName2
         End If
         ' Up/Ctrl-Up/Alt-Up/Ctrl--,Alt-- = MoveUp
      Case 72, 141, 152, 142, 74, 130
         If Current.File! - 1 > 0 Then
            If Box.Line > 1 Then
               GoSub ClearFilename
               Box.Line = Box.Line - 1
               Current.File! = Current.File! - 1!
               GoSub DisplayFilename1
               GoSub DisplayLongName2
            Else
               Current.File! = Current.File! - 1!
               GoSub DisplayFilename2
               GoSub DisplayFileBox2
               GoSub DisplayFilename4
               GoSub DisplayLongName2
            End If
         End If
         ' Down/Ctrl-Down/Alt-Down/Ctrl-+/Alt-= = MoveDown
      Case 80, 145, 160, 144, 78, 131
         If Current.File! + 1 <= Num.Files Then
            If Box.Line < 10 Then
               GoSub ClearFilename
               Box.Line = Box.Line + 1
               Current.File! = Current.File! + 1!
               GoSub DisplayFilename1
               GoSub DisplayLongName2
            Else
               Current.File! = Current.File! + 1!
               GoSub DisplayFilename2
               GoSub DisplayFileBox1
               GoSub DisplayFilename3
               GoSub DisplayLongName2
            End If
         End If
      Case 73, 132 ' pageup/ctrl-pageup
         If Current.File! - 10 > 0 Then
            Box.Line = 1
            Current.File! = Current.File! - 10!
         Else
            Box.Line = 1
            Current.File! = 1!
         End If
         GoSub DisplayFilename2
         GoSub DisplayFileBox2
         GoSub DisplayFilename4
         GoSub DisplayLongName2
      Case 81, 118 ' pagedown/ctrl-pagedown
         If Current.File! + 10 <= Num.Files Then
            Box.Line = 10
            Current.File! = Current.File! + 10!
            GoSub DisplayFilename2
            GoSub DisplayFileBox1
            GoSub DisplayFilename3
            GoSub DisplayLongName2
         Else
            If Current.File! + 1 <= Num.Files Then
               Do Until Current.File! = Num.Files
                  If Box.Line < 10 Then
                     GoSub ClearFilename
                     Box.Line = Box.Line + 1
                     Current.File! = Current.File! + 1!
                     GoSub DisplayFilename1
                     GoSub DisplayLongName2
                  Else
                     Current.File! = Current.File! + 1!
                     GoSub DisplayFilename2
                     GoSub DisplayFileBox1
                     GoSub DisplayFilename3
                     GoSub DisplayLongName2
                  End If
               Loop
            End If
         End If
      Case 71, 119 ' home/ctrl-home
         If Current.File! > 1 Then
            Box.Line = 1
            Current.File! = 1!
         End If
         GoSub DisplayFilename2
         GoSub DisplayFileBox2
         GoSub DisplayFilename4
         GoSub DisplayLongName2
      Case 79, 117 ' end/ctrl-end
         If Current.File! + 1 <= Num.Files Then
            Do Until Current.File! = Num.Files
               If Box.Line < 10 Then
                  GoSub ClearFilename
                  Box.Line = Box.Line + 1
                  Current.File! = Current.File! + 1!
                  GoSub DisplayFilename1
                  GoSub DisplayLongName2
               Else
                  Current.File! = Current.File! + 1!
                  GoSub DisplayFilename2
                  GoSub DisplayFileBox1
                  GoSub DisplayFilename3
                  GoSub DisplayLongName2
               End If
               I$ = INKEYx$
               If I$ = Chr$(27) Then
                  Exit Do
               End If
            Loop
         End If
   End Select
   Return

   ' clear filename.
   ClearFilename:
   Colorf2 Plain, Black
   Locatef Box.Line + Xcoor + 4, Ycoor + 3, 1
   Printf Left$(RTrim$(Filenames(Current.File!)), 12)
   Return

   ' display filename.
   DisplayFilename1:
   E$ = RTrim$(Filenames(Current.File!))
   Colorf2 Plain, Black
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Space$(26)
   Locatef Xcoor + 1, Ycoor + 12, 1
   GoSub TruncateFilename
   Printf A$
   Colorf2 Black, Plain
   Locatef Box.Line + Xcoor + 4, Ycoor + 3, 1
   Printf Left$(E$, 12)
   V9 = Len(RTrim$(Left$(E$, 12)))
   Locatef Box.Line + Xcoor + 4, Ycoor + V9 + 3, 1
   Colorf2 Plain, Black
   Return

   ' display filename.
   DisplayFilename2:
   E$ = RTrim$(Filenames(Current.File!))
   Colorf2 Plain, Black
   Locatef Xcoor + 1, Ycoor + 12, 1
   Printf Space$(26)
   Locatef Xcoor + 1, Ycoor + 12, 1
   GoSub TruncateFilename
   Printf A$
   GoSub ClearFileBox
   Colorf2 Plain, Black
   Return

   ' display filename.
   DisplayFilename3:
   E$ = RTrim$(Filenames(Current.File!))
   Colorf2 Black, Plain
   Locatef Xcoor + 14, Ycoor + 3, 1
   Printf Left$(E$, 12)
   V9 = Len(RTrim$(Left$(E$, 12)))
   Locatef Xcoor + 14, Ycoor + V9 + 3, 1
   Return

   ' display filename.
   DisplayFilename4:
   E$ = RTrim$(Filenames(Current.File!))
   Colorf2 Black, Plain
   Locatef Xcoor + 5, Ycoor + 3, 1
   Printf Left$(E$, 12)
   V9 = Len(RTrim$(Left$(E$, 12)))
   Locatef Xcoor + 5, Ycoor + V9 + 3, 1
   Return

   ' display filename.
   DisplayFilename5:
   E$ = RTrim$(Filenames(Current.File!))
   Colorf2 Black, Plain
   Locatef Box.Line + Xcoor + 4, Ycoor + 3, 1
   Printf Left$(E$, 12)
   Colorf2 Plain, Black
   Return

   ' display filename line.
   DisplayFilename6:
   Locatef Xcoor + 1, Ycoor + 2, 1
   Printf Space$(38)
   Locatef Xcoor + 1, Ycoor + 2, 1
   Colorf2 White, 0
   Printf "Filename: "
   Colorf2 Plain, Black
   Return

   ' update filename box.
   DisplayFileBox1:
   For V = 1 To 9
      Locatef Xcoor - V + 14, Ycoor + 3, 1
      Printf Left$(RTrim$(Filenames(Current.File! - V)), 12)
   Next
   Return

   ' update filename box.
   DisplayFileBox2:
   For V = 1 To 9
      If Current.File! + V <= Num.Files Then
         Locatef Xcoor + V + 5, Ycoor + 3, 1
         Printf Left$(RTrim$(Filenames(Current.File! + V)), 12)
      End If
   Next
   Return

   ' display init directory.
   DisplayInitDir:
   Q$ = RTrim$(Directories(Current.Dir!))
   Locatef Dir.Box.Line + Xcoor + 4, Ycoor + 19, 1
   Colorf2 Black, Plain
   Printf Left$(Q$, 12)
   Colorf2 Plain, Black
   Return

   ' directory input loop.
   DirInputLoop:
   GoSub DisplayInitDir
   GoSub DisplayLongName0
   I$ = Nul
   Do
      Do
         ' get keystroke.
         I$ = INKEYx$
         If Len(I$) Then
            IsMenu = False
            Exit Do
         End If

         ' call mouse subroutine.
         Z = MouseDriver2

         ' check file entry area.
         If IsMenu >= 4 Then
            Return
         End If

         ' check mouse wheel.
         If MouseWheel = -1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(80) ' down
            Else
               I$ = Chr$(0) + Chr$(72) ' up
            End If
            MouseWheel = 0
            Exit Do
         End If
         If MouseWheel = 1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(72) ' up
            Else
               I$ = Chr$(0) + Chr$(80) ' down
            End If
            MouseWheel = 0
            Exit Do
         End If

         ' check left mouse button.
         If MouseButton1 = -1 Then
            GoSub MouseButton1Z
            Select Case IsMenu
               Case 1 ' file box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub FileBoxKey
                  End If
               Case 2 ' dir box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub DirBoxKey
                  End If
               Case 3 ' drive box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub DriveBoxKey
                  End If
            End Select
         Else
            If MouseButton1 = 2 Or MouseButton2 Then
               GoSub MouseButton1Z
               ZZ$ = RTrim$(Directories(Current.Dir!))
               Var$ = ZZ$
               Call ViewFileInfo2(Var$)
               x = MessageBox(" Directory ", ZZ$ + "|" + Var$)
            Else
               ' check mouse position.
               If MouseX Or MouseY Then
                  GoSub MouseOverX1
               End If
            End If
         End If
      Loop

      ' check function key.
      If Len(I$) = 2 Then
         VarQ = Asc(Right$(I$, 1))
         Select Case VarQ
            Case 59 To 68, 104 To 113, 133, 134
               Return
         End Select
         GoSub GetAltKey
         If VarZ Then
            Return
         End If
      End If

      ' up returns shift-tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 72 Then
            If Current.Dir! = 1! Then
               If Dir.Box.Line = 1 Then
                  I$ = Chr$(0) + Chr$(15)
               End If
            End If
         End If
      End If

      ' left returns shift-tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 75 Then
            I$ = Chr$(0) + Chr$(15)
         End If
      End If

      ' shift-tab returns to file loop.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 15 Then
            ' display current filename.
            GoSub ClearLongName2
            If Num.Files > 0 Then
               GoSub DisplayLongName2
               GoSub ClearFilename
               GoSub DisplayFilename1
            End If
            ' display current directory.
            GoSub ClearDirectory
            GoSub DisplayCurrentPath
            Return
         End If
      End If

      ' right returns tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 77 Then
            I$ = Chr$(9)
         End If
      End If

      ' Tab moves to drive input loop.
      If I$ = Chr$(9) Then
         GoSub DriveInputLoop
         ' check function key.
         If Len(I$) = 2 Then
            VarQ = Asc(Right$(I$, 1))
            Select Case VarQ
               Case 59 To 68, 104 To 113, 133, 134
                  Return
            End Select
            GoSub GetAltKey
            If VarZ Then
               Return
            End If
         End If
         If IsMenu >= 3 Then
            GoSub DisplayCurrentPath
            If Num.Files > 0 Then
               GoSub DisplayLongName2
            End If
            Return
         End If
         If I$ = Chr$(9) Then
            GoSub DisplayCurrentPath
            If Num.Files > 0 Then
               GoSub DisplayLongName2
            End If
            Return
         End If
         Q$ = RTrim$(Directories(Current.Dir!))
         GoSub DisplayLongName1
      End If
      If I$ = Chr$(13) Then
         IsMenu = 2
         Return
      End If
      If I$ = Chr$(27) Then
         Return
      End If
      If Len(I$) = 1 Then
         Select Case I$
            Case "A" To "Z", "a" To "z", "0" To "9"
               ' scan the first character of the directories.
               J$ = I$
               Do
                  If Current.Dir! + 1! <= Num.Dirs Then
                     If Dir.Box.Line < 10 Then
                        GoSub ClearDirectory
                        Dir.Box.Line = Dir.Box.Line + 1
                        Current.Dir! = Current.Dir! + 1!
                        GoSub DisplayDirectory
                     Else
                        GoSub ClearDirBox
                        Current.Dir! = Current.Dir! + 1!
                        GoSub DisplayDirBox1
                        GoSub DisplayDirectory2
                     End If
                     Q$ = RTrim$(Directories(Current.Dir!))
                     GoSub DisplayLongName1
                     If Left$(Q$, 1) = J$ Then
                        Exit Do
                     End If
                     I$ = INKEYx$
                     If I$ = Chr$(27) Then
                        Exit Do
                     End If
                  Else
                     Exit Do
                  End If
               Loop
         End Select
         I$ = Nul
      End If
      If Len(I$) = 2 Then
         GoSub DirBoxKey
      End If
   Loop
   Return

   ' clear directory.
   ClearDirectory:
   Locatef Dir.Box.Line + Xcoor + 4, Ycoor + 19, 1
   Colorf2 Plain, Black
   Printf Left$(RTrim$(Directories(Current.Dir!)), 12)
   Return

   ' display directory.
   DisplayDirectory:
   Locatef Dir.Box.Line + Xcoor + 4, Ycoor + 19, 1
   Colorf2 Black, Plain
   Printf Left$(RTrim$(Directories(Current.Dir!)), 12)
   Colorf2 Plain, Black
   Return

   ' display directory.
   DisplayDirectory2:
   Colorf2 Black, Plain
   Locatef Xcoor + 14, Ycoor + 19, 1
   Printf Left$(RTrim$(Directories(Current.Dir!)), 12)
   Colorf2 Plain, Black
   Return

   ' display directory.
   DisplayDirectory3:
   Colorf2 Black, Plain
   Locatef Xcoor + 5, Ycoor + 19, 1
   Printf Left$(RTrim$(Directories(Current.Dir!)), 12)
   Colorf2 Plain, Black
   Return

   ' update dir box.
   DisplayDirBox1:
   Colorf2 Plain, Black
   For V = 1 To 9
      Locatef Xcoor - V + 14, Ycoor + 19, 1
      Printf Left$(RTrim$(Directories(Current.Dir! - V)), 12)
   Next
   Return

   ' update dir box.
   DisplayDirBox2:
   Colorf2 Plain, Black
   For V = 1 To 9
      If Current.Dir! + V <= Num.Dirs Then
         Locatef Xcoor + V + 5, Ycoor + 19, 1
         Printf Left$(RTrim$(Directories(Current.Dir! + V)), 12)
      End If
   Next
   Return

   ' process dir box key.
   DirBoxKey:
   V = Asc(Right$(I$, 1))
   Select Case V
      Case 82 ' insert
         Locatef Xcoor + 1, Ycoor + 2, 1
         Printf Space$(38)
         Locatef Xcoor + 1, Ycoor + 2, 1
         Colorf2 White, 0

         ' get new path.
         Printf "Dir path?"
         ZQ$ = LineInput$(Xcoor + 1, Ycoor + 12, 28)

         ' parse new path.
         If Len(ZQ$) Then

            ' create directory.
            G$ = MakeFilename$(N$, C$, D$, ZQ$)
            G$ = G$ + Chr$(0)
            x = CreateDirectoryA(G$, 0)

            ' check carry flag error
            If x = 0 Then
               Locatef Xcoor + 1, Ycoor + 2, 1
               Printf Space$(38)
               Locatef Xcoor + 1, Ycoor + 2, 1
               Colorf2 White, 0
               If GetLastError& = &HB7 Then
                  Printf "Directory already exists. Press <esc>:"
               Else
                  If GetLastError& = &H7B Then
                     Printf "Illegal path characters. Press <esc>:"
                  Else
                     Printf "Error 0x" + Hex$(GetLastError) + " Press <esc>:"
                  End If
               End If
               Call PromptInkey
            Else
               ' redisplay dir box.
               GoSub DisplayFilename6
               GoSub ClearDirBox
               DirLoadMessage = "Loading dirs.."
               Call LoadDirSpec(DirY$, N$, C$, D$)
               GoSub DisplayDirSpec
               GoSub DisplayCurrentDir
               GoSub DisplayCurrentPath
               ' display first directory.
               Current.Dir! = 1!
               Dir.Box.Line = 1
               GoSub DisplayInitDir
            End If
         End If
         GoSub DisplayFilename6
         GoSub DisplayFileLine
         GoSub DisplayInitDir
         GoSub DisplayLongName1
      Case 83 ' delete
         ' check path.
         Q$ = RTrim$(Directories(Current.Dir!))
         If Q$ = "." Or Q$ = ".." Then
            Locatef Xcoor + 1, Ycoor + 2, 1
            Printf Space$(38)
            Locatef Xcoor + 1, Ycoor + 2, 1
            Colorf2 White, 0
            Printf "Can't delete directory. Press <esc>:"
            Call PromptInkey
         Else
            Locatef Xcoor + 1, Ycoor + 2, 1
            Printf Space$(38)
            Locatef Xcoor + 1, Ycoor + 2, 1
            Colorf2 White, 0
            Printf "Delete current path(y/n)?"
            ErrorRespond$ = Nul
            Do
               ErrorRespond$ = INKEYx$
               If Len(ErrorRespond$) Then
                  If UCase$(ErrorRespond$) = "Y" Then
                     Exit Do
                  End If
                  If UCase$(ErrorRespond$) = "N" Then
                     Exit Do
                  End If
               End If
            Loop
            If UCase$(ErrorRespond$) = "Y" Then

               ' delete directory.
               G$ = MakeFilename$(N$, C$, D$, Q$) + "\"
               Call Silentdel_Directories(G$)

               ' check carry flag error
               If _DirExists(G$) Then
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Printf Space$(38)
                  Locatef Xcoor + 1, Ycoor + 2, 1
                  Colorf2 White, 0
                  Printf "Error deleting directory. Press <esc>:"
                  Call PromptInkey
               Else
                  ' redisplay dir box.
                  GoSub DisplayFilename6
                  GoSub ClearDirBox
                  DirLoadMessage = "Loading dirs.."
                  Call LoadDirSpec(DirY$, N$, C$, D$)
                  GoSub DisplayDirSpec
                  GoSub DisplayCurrentDir
                  GoSub DisplayCurrentPath
                  ' display first directory.
                  Current.Dir! = 1!
                  Dir.Box.Line = 1
                  GoSub DisplayInitDir
               End If
            End If
         End If
         GoSub DisplayFilename6
         GoSub DisplayFileLine
         GoSub DisplayInitDir
         GoSub DisplayLongName1
         ' Up/Ctrl-Up/Alt-Up/Ctrl--,Alt-- = MoveUp
      Case 72, 141, 152, 142, 74, 130
         If Current.Dir! - 1 > 0 Then
            If Dir.Box.Line > 1 Then
               GoSub ClearDirectory
               Dir.Box.Line = Dir.Box.Line - 1
               Current.Dir! = Current.Dir! - 1!
               GoSub DisplayDirectory
            Else
               GoSub ClearDirBox
               Current.Dir! = Current.Dir! - 1!
               GoSub DisplayDirBox2
               GoSub DisplayDirectory3
            End If
            Q$ = RTrim$(Directories(Current.Dir!))
            GoSub DisplayLongName1
         End If
         ' Down/Ctrl-Down/Alt-Down/Ctrl-+/Alt-= = MoveDown
      Case 80, 145, 160, 144, 78, 131
         If Current.Dir! + 1 <= Num.Dirs Then
            If Dir.Box.Line < 10 Then
               GoSub ClearDirectory
               Dir.Box.Line = Dir.Box.Line + 1
               Current.Dir! = Current.Dir! + 1!
               GoSub DisplayDirectory
            Else
               GoSub ClearDirBox
               Current.Dir! = Current.Dir! + 1!
               GoSub DisplayDirBox1
               GoSub DisplayDirectory2
            End If
            Q$ = RTrim$(Directories(Current.Dir!))
            GoSub DisplayLongName1
         End If
      Case 73, 132 ' pageup/ctrl-pageup
         If Current.Dir! - 10 > 0 Then
            Dir.Box.Line = 1
            Current.Dir! = Current.Dir! - 10!
         Else
            Dir.Box.Line = 1
            Current.Dir! = 1!
         End If
         GoSub ClearDirBox
         GoSub DisplayDirBox2
         GoSub DisplayDirectory3
         Q$ = RTrim$(Directories(Current.Dir!))
         GoSub DisplayLongName1
      Case 81, 118 ' pagedown/ctrl-pagedown
         If Current.Dir! + 10 <= Num.Dirs Then
            GoSub ClearDirBox
            Dir.Box.Line = 10
            Current.Dir! = Current.Dir! + 10!
            GoSub DisplayDirBox1
            GoSub DisplayDirectory2
            Q$ = RTrim$(Directories(Current.Dir!))
            GoSub DisplayLongName1
         Else
            If Current.Dir! + 1 <= Num.Dirs Then
               Do Until Current.Dir! = Num.Dirs
                  If Dir.Box.Line < 10 Then
                     GoSub ClearDirectory
                     Dir.Box.Line = Dir.Box.Line + 1
                     Current.Dir! = Current.Dir! + 1!
                     GoSub DisplayDirectory
                  Else
                     GoSub ClearDirBox
                     Current.Dir! = Current.Dir! + 1!
                     GoSub DisplayDirBox1
                     GoSub DisplayDirectory2
                  End If
               Loop
               Q$ = RTrim$(Directories(Current.Dir!))
               GoSub DisplayLongName1
            End If
         End If
      Case 71, 119 ' home/ctrl-home
         If Current.Dir! > 1 Then
            Dir.Box.Line = 1
            Current.Dir! = 1!
         End If
         GoSub ClearDirBox
         GoSub DisplayDirBox2
         GoSub DisplayDirectory3
         Q$ = RTrim$(Directories(Current.Dir!))
         GoSub DisplayLongName1
      Case 79, 117 ' end/ctrl-end
         If Current.Dir! + 1 <= Num.Dirs Then
            Do Until Current.Dir! = Num.Dirs
               If Dir.Box.Line < 10 Then
                  GoSub ClearDirectory
                  Dir.Box.Line = Dir.Box.Line + 1
                  Current.Dir! = Current.Dir! + 1!
                  GoSub DisplayDirectory
               Else
                  GoSub ClearDirBox
                  Current.Dir! = Current.Dir! + 1!
                  GoSub DisplayDirBox1
                  GoSub DisplayDirectory2
               End If
               I$ = INKEYx$
               If I$ = Chr$(27) Then
                  Exit Do
               End If
            Loop
            Q$ = RTrim$(Directories(Current.Dir!))
            GoSub DisplayLongName1
         End If
   End Select
   Return

   ' drive input loop.
   DriveInputLoop:
   I$ = Nul
   Do
      GoSub DisplayDrive
      Do
         ' get keystroke.
         I$ = INKEYx$
         If Len(I$) Then
            IsMenu = False
            Exit Do
         End If

         ' call mouse subroutine.
         Z = MouseDriver2

         ' check file entry area.
         If IsMenu >= 4 Then
            Return
         End If

         ' check mouse wheel.
         If MouseWheel = -1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(80) ' down
            Else
               I$ = Chr$(0) + Chr$(72) ' up
            End If
            MouseWheel = 0
            Exit Do
         End If
         If MouseWheel = 1 Then
            If WheelReverse Then
               I$ = Chr$(0) + Chr$(72) ' up
            Else
               I$ = Chr$(0) + Chr$(80) ' down
            End If
            MouseWheel = 0
            Exit Do
         End If

         ' check left mouse button.
         If MouseButton1 = -1 Then
            GoSub MouseButton1Z
            Select Case IsMenu
               Case 1 ' file box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub FileBoxKey
                  End If
               Case 2 ' dir box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub DirBoxKey
                  End If
               Case 3 ' drive box.
                  If I$ = Chr$(13) Then
                     Return
                  Else
                     GoSub DriveBoxKey
                  End If
            End Select
         Else
            If MouseButton1 = 2 Or MouseButton2 Then
               GoSub MouseButton1Z
               Call GetDriveInfo(DriveAttribute$)
               If Len(DriveAttribute$) = 0 Then
                  ZZ$ = DriveType
               Else
                  ZZ$ = DriveAttribute$
               End If
               x = MessageBox(" Drive ", ZZ$)
            Else
               ' check mouse position.
               If MouseX Or MouseY Then
                  GoSub MouseOverX1
                  GoSub DisplayDrive
               End If
            End If
         End If
      Loop

      ' check function key.
      If Len(I$) = 2 Then
         VarQ = Asc(Right$(I$, 1))
         Select Case VarQ
            Case 59 To 68, 104 To 113, 133, 134
               Return
         End Select
         GoSub GetAltKey
         If VarZ Then
            Return
         End If
      End If

      ' left returns shift-tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 75 Then
            I$ = Chr$(0) + Chr$(15)
         End If
      End If

      ' shift-tab returns to directory loop.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 15 Then
            I$ = Nul
            GoSub DisplayDirectory
            Return
         End If
      End If

      ' up returns tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 72 Then
            If Current.Drive = 1 Then
               If Drive.Box.Line = 1 Then
                  I$ = Chr$(9)
               End If
            End If
         End If
      End If

      ' right returns tab.
      If Len(I$) = 2 Then
         If Asc(Right$(I$, 1)) = 77 Then
            I$ = Chr$(9)
         End If
      End If

      ' Tab returns to top loop.
      If I$ = Chr$(9) Then
         Return
      End If

      ' select a drive.
      If I$ = Chr$(13) Then
         IsMenu = 3
         Return
      End If

      ' exit from drive box.
      If I$ = Chr$(27) Then
         Return
      End If

      ' process drive box keystroke.
      If Len(I$) Then
         GoSub DriveBoxKey
      End If
   Loop
   Return

   ' process drive letter.
   GetAltKey:
   ' get alt keycode.
   Var = Asc(Right$(I$, 1))
   VarZ = False
   ' compare all Alt-n keys.
   For Var2 = 1 To 26 ' A - Z
      ' check key.
      If Keys(Var2) = Var Then
         If Var2 <= Last.Drive Then
            VarZ = True
         End If
         Return
      End If
   Next
   Return

   ' process drive box key.
   DriveBoxKey:
   Select Case Len(I$)
      Case 1
         ' select a drive letter.
         Select Case I$
            Case "A" To "Z"
               V0 = Asc(I$) - 64
               GoSub MoveSelectDrive
            Case "a" To "z"
               V0 = Asc(I$) - 96
               GoSub MoveSelectDrive
            Case "<", "-" ' up
               GoSub MoveDriveUp
            Case ">", "+" ' down
               V6 = False
               GoSub MoveDriveDown
            Case "|" ' drive A:
               GoSub MoveFirstDrive
            Case "#" ' drive Z:
               GoSub MoveLastDrive
         End Select
      Case 2
         V = Asc(Right$(I$, 1))
         Select Case V
            Case 71, 119 ' home/ctrl-home
               GoSub MoveFirstDrive
            Case 79, 117 ' end/ctrl-end
               GoSub MoveLastDrive
               ' Up/Ctrl-Up/Alt-Up/Ctrl--,Alt-- = MoveUp
            Case 72, 141, 152, 142, 74, 130
               GoSub MoveDriveUp
               ' Down/Ctrl-Down/Alt-Down/Ctrl-+/Alt-= = MoveDown
            Case 80, 145, 160, 144, 78, 131
               V6 = False
               GoSub MoveDriveDown
            Case 73, 132 ' pageup/ctrl-pageup
               For V7 = 1 To 5 ' scroll up one-half page
                  GoSub MoveDriveUp
               Next
            Case 81, 118 ' pagedown/ctrl-pagedown
               For V7 = 1 To 5 ' scroll down one-half page
                  V6 = False
                  GoSub MoveDriveDown
               Next
         End Select
   End Select
   Return

   ' move to selected drive.
   MoveSelectDrive:
   If V0 > Last.Drive Then
      V0 = Last.Drive
   End If
   GoSub MoveFirstDrive ' assume A:
   ' scroll down to drive letter.
   For V7 = 2 To V0 ' B: to Z:
      V6 = False
      GoSub MoveDriveDown
   Next
   Return

   ' move to drive A:
   MoveFirstDrive:
   Do
      If Current.Drive > 1 Then
         GoSub MoveDriveUp
      Else
         Exit Do
      End If
   Loop
   Return

   ' move to last drive.
   MoveLastDrive:
   Do
      If Current.Drive + 1 <= Last.Drive Then
         V6 = False
         GoSub MoveDriveDown
      Else
         Exit Do
      End If
   Loop
   Return

   ' move up one drive letter.
   MoveDriveUp:
   If Current.Drive - 1 > 0 Then
      If Drive.Box.Line > 1 Then
         GoSub ClearDrive
         Drive.Box.Line = Drive.Box.Line - 1
         Current.Drive = Current.Drive - 1
         GoSub DisplayDrive
      Else
         Current.Drive = Current.Drive - 1
         GoSub ClearDriveBox
         For VX = 1 To 9
            VZ = Current.Drive + VX
            If DRIVEEXISTS(VZ) = 0 Then
               If MEDIAEXISTS(VZ) Then
                  Colorf2 Green, Black
               Else
                  Colorf2 Blue, Black
               End If
            Else
               Colorf2 Red, Black
            End If
            Locatef Xcoor + VX + 5, Ycoor + 35, 0
            Printf "[" + Chr$(Current.Drive + VX + 64) + "]"
         Next
         Drive.Box.Line = 1
         GoSub DisplayDrive
      End If
   End If
   Return

   ' move down one drive letter with drive info.
   MoveDriveDown:
   If Current.Drive + 1 <= Last.Drive Then
      If Drive.Box.Line < 10 Then
         GoSub ClearDrive
         Drive.Box.Line = Drive.Box.Line + 1
         Current.Drive = Current.Drive + 1
         If V6 = False Then
            GoSub DisplayDrive
         Else
            GoSub DisplayDrive2
         End If
      Else
         Current.Drive = Current.Drive + 1
         GoSub ClearDriveBox
         Colorf2 Plain, Black
         For VX = 1 To 9
            VZ = Current.Drive - VX
            If DRIVEEXISTS(VZ) = 0 Then
               If MEDIAEXISTS(VZ) Then
                  Colorf2 Green, Black
               Else
                  Colorf2 Blue, Black
               End If
            Else
               Colorf2 Red, Black
            End If
            Locatef Xcoor - VX + 14, Ycoor + 35, 1
            Printf "[" + Chr$(Current.Drive - VX + 64) + "]"
         Next
         Drive.Box.Line = 10
         If V6 = False Then
            GoSub DisplayDrive
         Else
            GoSub DisplayDrive2
         End If
      End If
   End If
   Return

   ' display path with dir info.
   DisplayCurrentPath:
   GoSub DisplayCurrentPath3
   GoSub DisplayLongName0
   Return

   ' display path w/o dir info.
   DisplayCurrentPath2:
   GoSub DisplayCurrentPath3
   GoSub DisplayLongName3
   Return

   ' format pathname for display.
   DisplayCurrentPath3:
   Q$ = D$
   For Var = Len(Q$) To 1 Step -1
      If Mid$(Q$, Var, 1) = "\" Then
         Q$ = Mid$(Q$, Var + 1)
         Exit For
      End If
   Next
   If Q$ = Nul Then
      Q$ = "\"
   End If
   Return

   ' display long directory w/o dir info.
   DisplayLongName0:
   Colorf2 Green, BackGround
   If Xcoor + 17 <= 24 Then
      Length = 80 - Ycoor - 1
      Locatef Xcoor + 17, Ycoor, 0
      Printf Space$(Length)
      Locatef Xcoor + 17, Ycoor, 0
      If Q$ = "." Or Q$ = ".." Then
         G$ = Q$
      Else
         G$ = MakeFilename2$(N$, C$, D$)
         G$ = UnAmbiguateFile$(G$)
      End If
      P$ = "Path: " + G$
      If Len(P$) > Length Then
         P$ = Left$(P$, Length - 3) + "..."
      End If
      Printf P$
   End If
   Colorf2 Plain, Black
   Return

   ' display long directory with dir info.
   DisplayLongName1:
   Colorf2 Green, BackGround
   If Xcoor + 17 <= 24 Then
      Length = 80 - Ycoor - 1
      Locatef Xcoor + 17, Ycoor, 0
      Printf Space$(Length)
      Locatef Xcoor + 17, Ycoor, 0
      If Q$ = "." Or Q$ = ".." Then
         G$ = Q$
      Else
         G$ = MakeFilename$(N$, C$, D$, Q$)
         G$ = UnAmbiguateFile$(G$)
      End If
      P$ = "Path: " + G$
      If Len(P$) > Length Then
         P$ = Left$(P$, Length - 3) + "..."
      End If
      Printf P$
   End If
   Colorf2 Plain, Black
   GoSub DisplayDirInfo
   V = Len(RTrim$(Directories(Current.Dir!)))
   If V > 12 Then
      V = 12
   End If
   Locatef Dir.Box.Line + Xcoor + 4, Ycoor + V + 19, 1
   Return

   ' display long filename with file info.
   DisplayLongName2:
   Colorf2 Green, BackGround
   If Xcoor + 18 <= 24 Then
      Length = 80 - Ycoor - 1
      Locatef Xcoor + 18, Ycoor, 0
      Printf Space$(Length)
      Locatef Xcoor + 18, Ycoor, 0
      G$ = MakeFilename$(N$, C$, D$, E$)
      G$ = UnAmbiguateFile$(G$)
      P$ = "File: " + G$
      If Len(P$) > Length Then
         P$ = Left$(P$, Length - 3) + "..."
      End If
      Printf P$
   End If
   Colorf2 Plain, Black
   GoSub DisplayFileInfo
   V = Len(RTrim$(Filenames(Current.File!)))
   If V > 12 Then
      V = 12
   End If
   Locatef Box.Line + Xcoor + 4, Ycoor + V + 3, 1
   Return

   ' display long directory w/o dir info.
   DisplayLongName3:
   Colorf2 Green, BackGround
   If Xcoor + 17 <= 24 Then
      Length = 80 - Ycoor - 1
      Locatef Xcoor + 17, Ycoor, 0
      Printf Space$(Length)
      Locatef Xcoor + 17, Ycoor, 0
      P$ = "Path: " + Q$
      If Len(P$) > Length Then
         P$ = Left$(P$, Length - 3) + "..."
      End If
      Printf P$
   End If
   Colorf2 Plain, Black
   Return

   ' display filename information.
   DisplayFileInfo:
   Colorf2 Green, BackGround
   If Xcoor + 19 <= 24 Then
      GoSub GetFileInfo
      Var# = FileSize
      P$ = "Info: " + FormatX$(Var#, -1)
      Select Case QuietSwitch
         Case -1, 1, 3, 5
            ' nul
         Case Else
            If Len(FileDateTime) Then
               P$ = P$ + FileDateTime
            End If
      End Select
      Select Case QuietSwitch
         Case -1, 2, 3, 6
            ' nul
         Case Else
            GoSub GetAttribute
      End Select
      GoSub DisplayInfo
   End If
   Colorf2 Plain, Black
   Return

   ' display directory information.
   DisplayDirInfo:
   Colorf2 Green, BackGround
   If Xcoor + 19 <= 24 Then
      GoSub GetDirInfo
      P$ = "Info: <dir> "
      Select Case QuietSwitch
         Case -1, 1, 3, 5
            ' nul
         Case Else
            If Len(FileDateTime) Then
               P$ = P$ + FileDateTime
            End If
      End Select
      Select Case QuietSwitch
         Case -1, 2, 3, 6
            ' nul
         Case Else
            GoSub GetAttribute
      End Select
      GoSub DisplayInfo
   End If
   Colorf2 Plain, Black
   Return

   ' display drive attribute.
   DisplayDriveInfo:
   Colorf2 Green, BackGround
   If Xcoor + 19 <= 24 Then
      P$ = "Info: " + Chr$(Current.Drive + 64) + ":\"
      Call GetDriveInfo(DriveAttribute$)
      P$ = P$ + DriveAttribute$
      GoSub DisplayInfo
   End If
   Colorf2 Plain, Black
   Return

   ' display file info.
   DisplayInfo:
   Length = 80 - Ycoor - 1
   Locatef Xcoor + 19, Ycoor, 0
   Printf Space$(Length)
   Locatef Xcoor + 19, Ycoor, 0
   If Ycoor + Len(P$) >= 80 Then
      P$ = Left$(P$, 80 - Ycoor - 1)
   End If
   Printf P$
   Return

   ' get filesize, date/time, and attribute.
   GetFileInfo:
   ' store long filename.
   ASCIIZ = MakeFilename$(N$, C$, D$, E$) + Chr$(0)
   ' get file info
   Call GetInfo(-1, V$)
   Return

   ' get dir date/time, attribute.
   GetDirInfo:
   ' store long filename.
   ASCIIZ = MakeFilename$(N$, C$, D$, Q$) + Chr$(0)
   ' get file info
   Call GetInfo(-1, V$)
   Return

   ' get file/dir attribute.
   GetAttribute:
   Call GetInfo(0, A$)
   If A$ <> Nul Then
      If Ycoor + Len(P$) + Len(A$) < 80 Then
         P$ = P$ + A$
      End If
   End If
   Return

   ' clear long directory area.
   ClearLongName1:
   Colorf2 Green, BackGround
   If Xcoor + 17 <= 24 Then
      Length = 80 - Ycoor - 1
      Locatef Xcoor + 17, Ycoor, 0
      Printf Space$(Length)
      Locatef Xcoor + 17, Ycoor, 0
      Printf "Path: "
   End If
   Colorf2 Plain, Black
   Return

   ' clear long filename area.
   ClearLongName2:
   Colorf2 Green, BackGround
   If Xcoor + 18 <= 24 Then
      Length = 80 - Ycoor - 1
      Locatef Xcoor + 18, Ycoor, 0
      Printf Space$(Length)
      Locatef Xcoor + 18, Ycoor, 0
      Printf "File: "
   End If
   ' clear size area.
   If Xcoor + 19 <= 24 Then
      Length = 80 - Ycoor - 1
      Locatef Xcoor + 19, Ycoor, 0
      Printf Space$(Length)
      Locatef Xcoor + 19, Ycoor, 0
      Printf "Info: "
   End If
   Colorf2 Plain, Black
   Return

   ' construct new path.
   GetNewPath:
   ' check filespec.
   If InStr(X$, "?") = False Then
      If InStr(X$, "*") = False Then
         X$ = "*.*"
         Xposition1 = 1
         Xposition2 = 3
      End If
   End If
   ' check file.
   If X$ = Nul Then
      X$ = "*.*"
      Xposition1 = 1
      Xposition2 = 3
   End If
   ' store new path.
   Q$ = RTrim$(Directories(Current.Dir!))
   ' store path to be parsed.
   X$ = Q$ + "\" + X$
   Return

   ' truncate filename for display.
   TruncateFilename:
   A$ = RTrim$(E$)
   If Len(A$) > 26 Then
      A$ = Left$(A$, 23) + "..."
   End If
   Return

   ' return current drive.
   InitDrive:
   If C$ = Nul Then
      D1$ = _CWD$
      C$ = UCase$(Left$(D1$, 1))
      Drive.Number = Asc(C$) - 65 ' 0=a, 1=b,..
      Return
   End If
   Drive.Number = Asc(C$) - 65
   Return

   ' check path.
   CheckPath:
   ' reset flag.
   ValidPath = True

   ' check path.
   If D$ = Nul Then
      Return
   End If
   If D$ = "\" Then
      Return
   End If

   ' store directory.
   ASCIIZ = MakeFilename2$(N$, C$, D$) + Chr$(0)
   AttributeX = GetFileAttr(ASCIIZ)

   ' check filename is not path.
   If (AttributeX And &H10) <> &H10 Then
      ValidPath = False
   End If
   Return

   ' display directory box.
   DisplayDirSpec:
   VarX! = SFalse
   Do
      VarX! = VarX! + 1!
      If VarX! > 10! Then
         Exit Do
      End If
      If VarX! > Num.Dirs Then
         Exit Do
      End If
      Locatef CInt(VarX!) + Xcoor + 4, Ycoor + 19, 1
      Q$ = Directories(VarX!)
      Q$ = RTrim$(Q$)
      Printf Left$(Q$, 12)
   Loop
   Return

   ' clear directory box.
   ClearDirBox:
   For VarX = 1 To 10
      Locatef VarX + Xcoor + 4, Ycoor + 19, 1
      Printf Space$(12)
   Next
   Return

   ' display directory.
   DisplayCurrentDir:

   ' ambiguate dospath.
   If Right$(D$, 2) = "\." Then
      D$ = Left$(D$, Len(D$) - 2)
   End If
   ASCIIZ = MakeFilename4$(N$, C$, D$) + Chr$(0)
   V4 = True
   GoSub ShortFilenameX
   If Short.Filename$ = Nul Then
      If N$ = Nul Then
         Short.Filename$ = C$ + ":\"
      Else
         Short.Filename$ = N$
      End If
   End If
   Z$ = Short.Filename$
   If N$ = Nul Then
      If Mid$(Z$, 2, 1) <> ":" Then
         Z$ = C$ + ":" + Z$
      End If
   Else
      If Mid$(Z$, 2, 1) = ":" Then
         Z$ = Mid$(Z$, 3)
      End If
   End If

   ' get deconcatenated filename.
   N1$ = N$
   Call Deconcatenate(N$, Z$, 37)
   N$ = N1$

   ' display filename.
   Locatef Xcoor + 2, Ycoor + 2, 1
   Printf Space$(37)
   Locatef Xcoor + 2, Ycoor + 2, 1
   Printf UCase$(Z$)
   Return

   ' display filename box.
   DisplayFileSpec:
   VarX! = SFalse
   Do
      VarX! = VarX! + 1!
      If VarX! > 10! Then
         Exit Do
      End If
      If VarX! > Num.Files Then
         Exit Do
      End If
      Locatef CInt(VarX!) + Xcoor + 4, Ycoor + 3, 1
      Q$ = Filenames(VarX!)
      Q$ = RTrim$(Q$)
      Printf Left$(Q$, 12)
   Loop
   Return

   ' clear filename box.
   ClearFileBox:
   For VarX = 1 To 10
      Locatef VarX + Xcoor + 4, Ycoor + 3, 1
      Printf Space$(12)
   Next
   Return

   ' format filename for display and search purposes.
   ShortFilenameX:
   If D$ = "\" Then
      Short.Filename$ = "\"
      Return
   End If
   If D$ = Nul Then
      Short.Filename$ = "\"
      Return
   End If

   ' read ambiguated 8.3 filename.
   Call GetShortFilename(Short.Filename$)
   If Short.Filename$ = Nul Then
      Return
   End If

   ' check 8.3 flag.
   If V4 Then
      Return
   End If

   ' store 8.3 filename.
   For V = Len(Short.Filename$) To 1 Step -1
      If Mid$(Short.Filename$, V, 1) = "\" Then
         Short.Filename$ = Mid$(Short.Filename$, V + 1)
         Exit For
      End If
   Next
   Return

   ' clear current drive.
   ClearDrive:
   If DRIVEEXISTS(Current.Drive) = 0 Then
      If MEDIAEXISTS(Current.Drive) Then
         Colorf2 Green, Black
      Else
         Colorf2 Blue, Black
      End If
   Else
      Colorf2 Red, Black
   End If
   Locatef Xcoor + Drive.Box.Line + 4, Ycoor + 35, 0
   Printf "[" + Chr$(Current.Drive + 64) + "]"
   Return

   ' clear drive box.
   ClearDriveBox:
   For Var = 1 To 10
      Locatef Xcoor + 4 + Var, Ycoor + 35, 1
      Printf "   "
   Next
   Return

   ' display current drive with info.
   DisplayDrive:
   GoSub DisplayDriveInfo
   Colorf2 Black, Plain
   Locatef Xcoor + Drive.Box.Line + 4, Ycoor + 35, 1
   Printf "[" + Chr$(Current.Drive + 64) + "]"
   Locatef Xcoor + Drive.Box.Line + 4, Ycoor + 38, 1
   Colorf2 Plain, Black
   Return

   ' display current drive w/o info.
   DisplayDrive2:
   Colorf2 Black, Plain
   Locatef Xcoor + Drive.Box.Line + 4, Ycoor + 35, 1
   Printf "[" + Chr$(Current.Drive + 64) + "]"
   Locatef Xcoor + Drive.Box.Line + 4, Ycoor + 38, 1
   Colorf2 Plain, Black
   Return

   ' display available drives.
   DisplayDrives:
   For Var = 1 To Last.Drive
      If Var > 10 Then
         Exit For
      End If
      If DRIVEEXISTS(Var) = 0 Then
         If MEDIAEXISTS(Var) Then
            Colorf2 Green, Black
         Else
            Colorf2 Blue, Black
         End If
      Else
         Colorf2 Red, Black
      End If
      Locatef Xcoor + 4 + Var, Ycoor + 35, 1
      Printf "[" + Chr$(Var + 64) + "]"
   Next
   Return

   ' display current drives.
   InitDrives:
   ' init drive letter.
   If Current.Drive = False Then
      Current.Drive = Drive.Number + 1
   End If
   ' display drives.
   V3 = Current.Drive
   If V3 > Last.Drive Then
      V3 = Last.Drive
   End If
   GoSub ClearDriveBox
   Drive.Box.Line = 1
   Current.Drive = 1
   GoSub DisplayDrives
   GoSub DisplayDrive2
   ' scroll to drive.
   Do Until Current.Drive >= V3
      V6 = True
      GoSub MoveDriveDown
   Loop
   GoSub DisplayDriveInfo
   Return

   ' process left mouse button single-click.
   MouseButton1Z:
   ' store mouse variables.
   IsMenu = False
   ' file box pageup
   If MouseX = Xcoor + 4 Then
      If MouseY = Ycoor + 16 Then
         I$ = Chr$(0) + Chr$(73)
         IsMenu = 1
         Return
      End If
   End If
   ' file box up
   If MouseX = Xcoor + 5 Then
      If MouseY = Ycoor + 16 Then
         I$ = Chr$(0) + Chr$(72)
         IsMenu = 1
         Return
      End If
   End If
   ' file box down
   If MouseX = Xcoor + 14 Then
      If MouseY = Ycoor + 16 Then
         I$ = Chr$(0) + Chr$(80)
         IsMenu = 1
         Return
      End If
   End If
   ' file box pagedown
   If MouseX = Xcoor + 15 Then
      If MouseY = Ycoor + 16 Then
         I$ = Chr$(0) + Chr$(81)
         IsMenu = 1
         Return
      End If
   End If
   ' directory box pageup
   If MouseX = Xcoor + 4 Then
      If MouseY = Ycoor + 32 Then
         I$ = Chr$(0) + Chr$(73)
         IsMenu = 2
         Return
      End If
   End If
   ' directory box up
   If MouseX = Xcoor + 5 Then
      If MouseY = Ycoor + 32 Then
         I$ = Chr$(0) + Chr$(72)
         IsMenu = 2
         Return
      End If
   End If
   ' directory box down
   If MouseX = Xcoor + 14 Then
      If MouseY = Ycoor + 32 Then
         I$ = Chr$(0) + Chr$(80)
         IsMenu = 2
         Return
      End If
   End If
   ' directory box pagedown
   If MouseX = Xcoor + 15 Then
      If MouseY = Ycoor + 32 Then
         I$ = Chr$(0) + Chr$(81)
         IsMenu = 2
         Return
      End If
   End If
   ' drive box up
   If MouseX = Xcoor + 5 Then
      If MouseY = Ycoor + 39 Then
         I$ = Chr$(0) + Chr$(72)
         IsMenu = 3
         Return
      End If
   End If
   ' drive box down
   If MouseX = Xcoor + 14 Then
      If MouseY = Ycoor + 39 Then
         I$ = Chr$(0) + Chr$(80)
         IsMenu = 3
         Return
      End If
   End If
   ' check mouse selection boundaries for file box.
   If MouseX >= Xcoor + 5 And MouseX <= Xcoor + 14 Then
      If MouseY >= Ycoor + 3 And MouseY <= Ycoor + 14 Then
         If Num.Files > 0 Then
            I$ = Nul
            Valid = False
            V = MouseX - (Xcoor + 4)
            If V = Box.Line Then
               Valid = True
            End If
            If V > Box.Line Then
               If Current.File! + (V - Box.Line) <= Num.Files Then
                  Current.File! = Current.File! + (V - Box.Line)
                  Valid = True
               End If
            End If
            If V < Box.Line Then
               If Current.File! - (Box.Line - V) > 0 Then
                  Current.File! = Current.File! - (Box.Line - V)
                  Valid = True
               End If
            End If
            If Valid Then
               I$ = Chr$(13)
               IsMenu = 1
            End If
         End If
         Return
      End If
   End If
   ' check mouse selection boundaries for dir box.
   If MouseX >= Xcoor + 5 And MouseX <= Xcoor + 14 Then
      If MouseY >= Ycoor + 19 And MouseY <= Ycoor + 31 Then
         I$ = Nul
         Valid = False
         V = MouseX - (Xcoor + 4)
         If V = Dir.Box.Line Then
            Valid = True
         End If
         If V > Dir.Box.Line Then
            If Current.Dir! + (V - Dir.Box.Line) <= Num.Dirs Then
               Current.Dir! = Current.Dir! + (V - Dir.Box.Line)
               Valid = True
            End If
         End If
         If V < Dir.Box.Line Then
            If Current.Dir! - (Dir.Box.Line - V) > 0 Then
               Current.Dir! = Current.Dir! - (Dir.Box.Line - V)
               Valid = True
            End If
         End If
         If Valid Then
            I$ = Chr$(13)
            IsMenu = 2
         End If
         Return
      End If
   End If
   ' check mouse selection boundaries for drive box.
   If MouseX >= Xcoor + 5 And MouseX <= Xcoor + 14 Then
      If MouseY >= Ycoor + 35 And MouseY <= Ycoor + 37 Then
         I$ = Nul
         Valid = False
         V = MouseX - (Xcoor + 4)
         If V = Drive.Box.Line Then
            Valid = True
         End If
         If V > Drive.Box.Line Then
            If Current.Drive + (V - Drive.Box.Line) <= Last.Drive Then
               GoSub ClearDrive
               Current.Drive = Current.Drive + (V - Drive.Box.Line)
               Drive.Box.Line = Drive.Box.Line + (V - Drive.Box.Line)
               GoSub DisplayDrive
               Valid = True
            End If
         End If
         If V < Drive.Box.Line Then
            If Current.Drive - (Drive.Box.Line - V) > 0 Then
               GoSub ClearDrive
               Current.Drive = Current.Drive - (Drive.Box.Line - V)
               Drive.Box.Line = Drive.Box.Line - (Drive.Box.Line - V)
               GoSub DisplayDrive
               Valid = True
            End If
         End If
         If Valid Then
            I$ = Chr$(13)
            IsMenu = 3
         End If
         Return
      End If
   End If
   ' check mouse selection boundaries for file entry area.
   If MouseX = Xcoor + 1 Then
      If MouseY >= Ycoor + 2 And MouseY <= Ycoor + 39 Then
         I$ = Nul
         IsMenu = 4
         Return
      End If
   End If
   ' check mouse selection boundaries for file box help.
   If MouseX = Xcoor Then
      If MouseY = Ycoor + 39 Then
         I$ = Nul
         Call DisplayHelp
         GoSub RedrawScreen
         Return
      End If
   End If
   ' check mouse selection boundaries for file box exit.
   If MouseX = Xcoor Then
      If MouseY = Ycoor + 40 Then
         I$ = Nul
         IsMenu = 5
         Return
      End If
   End If
   Return

   ' mouseover for file/dir/drive boxes.
   MouseOverX1:
   ' check mouse selection boundaries for file box.
   If MouseX >= Xcoor + 5 And MouseX <= Xcoor + 14 Then
      If MouseY >= Ycoor + 3 And MouseY <= Ycoor + 14 Then
         If Num.Files > 0 Then
            B1 = MouseX - (Xcoor + 4)
            If B1 > Box.Line Then
               B2 = B1 - Box.Line
               If B2 <= Num.Files Then
                  For B3 = 1 To B2
                     If Current.File! + 1 <= Num.Files Then
                        If Box.Line < 10 Then
                           GoSub ClearFilename
                           Box.Line = Box.Line + 1
                           Current.File! = Current.File! + 1!
                           GoSub DisplayFilename5
                           GoSub DisplayLongName2
                        End If
                     End If
                  Next
               End If
            Else
               If B1 < Box.Line Then
                  B2 = Box.Line - B1
                  If B2 > 0 Then
                     For B3 = 1 To B2
                        If Current.File! - 1 > 0 Then
                           If Box.Line > 1 Then
                              GoSub ClearFilename
                              Box.Line = Box.Line - 1
                              Current.File! = Current.File! - 1!
                              GoSub DisplayFilename5
                              GoSub DisplayLongName2
                           End If
                        End If
                     Next
                  End If
               Else
                  If B1 = Box.Line Then
                     GoSub ClearFilename
                     GoSub DisplayFilename5
                     GoSub DisplayLongName2
                  End If
               End If
            End If
         End If
         Return
      End If
   End If
   ' check mouse selection boundaries for dir box.
   If MouseX >= Xcoor + 5 And MouseX <= Xcoor + 14 Then
      If MouseY >= Ycoor + 19 And MouseY <= Ycoor + 31 Then
         If Num.Dirs > 0 Then
            D1 = MouseX - (Xcoor + 4)
            If D1 > Dir.Box.Line Then
               D2 = D1 - Dir.Box.Line
               If D2 > 0 Then
                  If D2 <= Num.Dirs Then
                     For D3 = 1 To D2
                        If Current.Dir! + 1 <= Num.Dirs Then
                           If Dir.Box.Line < 10 Then
                              GoSub ClearDirectory
                              Dir.Box.Line = Dir.Box.Line + 1
                              Current.Dir! = Current.Dir! + 1!
                              GoSub DisplayDirectory
                              Q$ = RTrim$(Directories(Current.Dir!))
                              GoSub DisplayLongName1
                           End If
                        End If
                     Next
                  End If
               End If
            Else
               If D1 < Dir.Box.Line Then
                  D2 = Dir.Box.Line - D1
                  If D2 > 0 Then
                     If D2 <= Num.Dirs Then
                        For D3 = 1 To D2
                           If Current.Dir! - 1 > 0 Then
                              If Dir.Box.Line > 1 Then
                                 GoSub ClearDirectory
                                 Dir.Box.Line = Dir.Box.Line - 1
                                 Current.Dir! = Current.Dir! - 1!
                                 GoSub DisplayDirectory
                                 Q$ = RTrim$(Directories(Current.Dir!))
                                 GoSub DisplayLongName1
                              End If
                           End If
                        Next
                     End If
                  End If
               Else
                  If D1 = Dir.Box.Line Then
                     GoSub DisplayDirectory
                     Q$ = RTrim$(Directories(Current.Dir!))
                     GoSub DisplayLongName1
                  End If
               End If
            End If
         End If
         Return
      End If
   End If
   ' check mouse selection boundaries for drive box.
   If MouseX >= Xcoor + 5 And MouseX <= Xcoor + 14 Then
      If MouseY >= Ycoor + 35 And MouseY <= Ycoor + 37 Then
         X0 = MouseX - (Xcoor + 4)
         If X0 > Drive.Box.Line Then
            X1 = Current.Drive + (X0 - Drive.Box.Line)
            If X1 <= Last.Drive Then
               GoSub ClearDrive
               Current.Drive = Current.Drive + (X0 - Drive.Box.Line)
               Drive.Box.Line = Drive.Box.Line + (X0 - Drive.Box.Line)
               GoSub DisplayDrive
            End If
         Else
            If X0 < Drive.Box.Line Then
               X1 = Current.Drive - (Drive.Box.Line - X0)
               If X1 > 0 Then
                  GoSub ClearDrive
                  Current.Drive = Current.Drive - (Drive.Box.Line - X0)
                  Drive.Box.Line = Drive.Box.Line - (Drive.Box.Line - X0)
                  GoSub DisplayDrive
               End If
            Else
               If X0 = Drive.Box.Line Then
                  GoSub DisplayDrive
               End If
            End If
         End If
      End If
   End If
   Return

   ' redraws editing screen.
   RedrawScreen:
   Colorf2 White, BackGropund
   Cls
   Call FileMainMenu
   GoSub UpdateDisplay
   GoSub DisplayCurrentPath
   If Num.Files > 0 Then
      GoSub DisplayLongName2
   End If
   GoSub DisplayFilename6
   GoSub DisplayFileLine
   Return
End Sub

Rem Replacement stub subroutines:
Rem  LseekFile()
Rem  ReadFile()
Rem  Writefile()
Rem  LockedFile()
Rem  LocateCursor()
Rem  LocateCursor2()
Rem  LocateHilightCursor()
Rem  BytePrint()
Rem  DisplayX()
Rem  DisplayPosition()
Rem  ClearStatus()
Rem  DisplayFilename()
Rem  DisplayFileTitle()
Rem  DisplayPageByte()
Rem  ResetHilightBytes()
Rem  ResetBytes()
Rem  RestoreHilightBytes()
Rem  ResetByte()
Rem  ClearPageByte()
Rem  ClearHilightByte()
Rem  DisplayHilightByte()
Rem  DisplayStatus1()
Rem  DisplayStatus2()
Rem  DisplayStatusLine()
Rem  DisplayHexPage()
Rem  RedrawRightWindow()
Rem  RedrawWindow1()
Rem  RedrawWindow2()
Rem  CheckASCIIValue(S$)
Rem  CheckString(S$)
Rem  CheckHexValue(S$)
Rem  FormatPosition2(V%)
Rem  AsciiToHex1(S$)
Rem  AsciiToHex2(S$)
Rem  CheckAsciiBytes(S$)
Rem  CheckHexBytes(S$)
Rem  GetShortFilename(S$)

Rem position pointer in file.
Sub LseekFile
   Seek Handle, SeekPosition
End Sub

Rem read 1 byte from file.
Sub ReadFile
   Get Handle, SeekPosition, Buffer
End Sub

Rem write 1 byte to file.
Sub WriteFile
   Share.Count = 0
   If FileLocked Then
      Write.Error = True
      Exit Sub
   End If
   Check.Disk = True
   Disk.Ready = False
   Write.Error = False
   Buffer = FileByte
   Put Handle, SeekPosition, Buffer
   Check.Disk = False
   If Disk.Ready Then
      Write.Error = True
   End If
End Sub

Rem display file status message.
Sub LockedFile
   Colorf White
   If FileLocked Then
      If FileLength = False Then
         Printf "<locked file>"
      Else
         Printf "<read-only>"
      End If
   Else
      Printf "<zero-byte>"
   End If
   Locatef 1, 1, 0
End Sub

Rem locate cursor on window.
Sub LocateCursor
   If FileLength = False Then
      Locatef 1, 1, 0
      Exit Sub
   End If
   If CurrentWindow = False Then
      Locatef PageRow + 3, Column + 5, 1
   Else
      Locatef PageRow + 3, PageColumn + 54, 1
   End If
End Sub

Rem select cursor on window.
Sub LocateCursor2
   If CopyPositionStart = False Then
      Call LocateCursor
   Else
      Call LocateHilightCursor
   End If
End Sub

Rem locate cursor on window for hilighted area.
Sub LocateHilightCursor
   If FileLength = False Then
      Locatef 1, 1, 0
      Exit Sub
   End If
   If CurrentWindow = False Then
      Locatef PageRow + 3, Column + 7, 1
   Else
      Locatef PageRow + 3, PageColumn + 55, 1
   End If
End Sub

Rem print byte at fileposition in edit area.
Sub BytePrint
   SeekPosition = FilePosition
   Call LseekFile
   Call ReadFile
   FileByte = Buffer
   ByteValue = Asc(FileByte)
   Column = CalculateColumn
   ' display hex byte.
   Locatef PageRow + 3, Column + 5, 0
   Printf Right$("00" + Hex$(ByteValue), 2)
   ' check right window toggled.
   If CurrentWindow2 = False Then
      ' display ascii byte.
      Locatef PageRow + 3, PageColumn + 54, 0
      ' check unprintable
      If CharPrint Then
         Printf FileByte
      Else
         ' skip unprintable characters.
         Select Case ByteValue
            Case 0, 7, 9 To 13, 28 To 32
               Printf "."
            Case Else
               Printf FileByte
         End Select
      End If
   End If
End Sub

Rem display info on file being edited.
Sub DisplayPosition
   Colorf2 Yellow, 0
   StringLength = Len("Editing file:" + RTrim$(Filename) + " ") + 5
   Locatef 2, StringLength, 0
   Printf Space$(77 - StringLength)
   Locatef 2, StringLength, 0
   If FileLength = False Then
      Call LockedFile
      Exit Sub
   End If
   Colorf White
   If CurrentWindow = False Then
      Printf "Pos: " + FormatX$(FilePosition - 1, 0) + " "
   Else
      Printf "Pos: " + Right$("000000000000" + Hex$(FilePosition - 1), 12) + "x "
   End If
   Printf "(Asc:" + Str$(AsciiValue)

   ' display ascii control code description
   If AsciiValue >= 0 And AsciiValue <= 32 Then
      Printf " :"
   End If
   Select Case AsciiValue
      Case 0
         Printf "nul"
      Case 1
         Printf "soh"
      Case 2
         Printf "stx"
      Case 3
         Printf "etx"
      Case 4
         Printf "eot"
      Case 5
         Printf "enq"
      Case 6
         Printf "ack"
      Case 7
         Printf "bel"
      Case 8
         Printf "bs"
      Case 9
         Printf "tab"
      Case 10
         Printf "lf"
      Case 11
         Printf "vt"
      Case 12
         Printf "np"
      Case 13
         Printf "cr"
      Case 14
         Printf "so"
      Case 15
         Printf "si"
      Case 16
         Printf "dle"
      Case 17
         Printf "dc1"
      Case 18
         Printf "dc2"
      Case 19
         Printf "dc3"
      Case 20
         Printf "dc4"
      Case 21
         Printf "nak"
      Case 22
         Printf "syn"
      Case 23
         Printf "etb"
      Case 24
         Printf "can"
      Case 25
         Printf "em"
      Case 26
         Printf "eof"
      Case 27
         Printf "esc"
      Case 28
         Printf "fs"
      Case 29
         Printf "gs"
      Case 30
         Printf "rs"
      Case 31
         Printf "us"
      Case 32
         Printf "spc"
   End Select
   Printf ") "
   Call LocateCursor2
End Sub

Rem clear top status area
Sub ClearStatus
   Colorf2 Yellow, 0
   Locatef 2, 4, 0
   Printf Space$(74)
   Locatef 2, 4, 0
End Sub

Rem display name of file being edited.
Sub DisplayFilename
   Call DisplayX
   Colorf White
   If FileLength = False Then
      Call LockedFile
      Exit Sub
   End If
   Call DisplayPosition
End Sub

Rem display 64-byte name of file being editied.
Sub DisplayFileTitle

   ' redisplay line 3.
   Locatef 3, 4, 0
   Colorf Green
   Printf Chr$(ULcorner) + String$(46, Hline) + Chr$(URcorner) + " "
   Printf Chr$(ULcorner) + String$(22, Hline) + Chr$(URcorner)

   ' display filename.
   N$ = RTrim$(CurrentNetPath)
   Z$ = RTrim$(ShortFilename)
   If N$ <> Nul Then
      If Mid$(Z$, 2, 1) = ":" Then
         Z$ = Mid$(Z$, 3)
      End If
   End If
   Call Deconcatenate(N$, Z$, 64)
   Z$ = Mid$(Str$(CurrentFile), 2) + ": " + Z$
   Var = Int((80 - (Len(RTrim$(Z$))) + 2) / 2) - 1
   Locatef 3, Var, 0
   Colorf2 0, 7
   Printf " " + Z$ + " "
   Colorf2 7, 0
   Call LocateCursor2
End Sub

Rem display current byte being edited.
Sub DisplayPageByte
   ' check filename display.
   If FileDisplay2 Then
      FileDisplay2 = False
      Call DisplayX
      Colorf White
   End If

   ' check filelength.
   If FileLength = False Then
      Locatef 1, 1, 0
      Exit Sub
   End If

   ' check hilighted bytes.
   If CopyPositionStart > 0# Then
      Call ResetHilightBytes
   End If

   ' display byte.
   Colorf Yellow
   Call BytePrint

   ' store the current byte value being edited.
   AsciiValue = Asc(FileByte)
   Call DisplayPosition
End Sub

Rem reset hilight bytes.
Sub ResetHilightBytes
   Call ResetBytes

   ' adjust file position.
   If PageColumn + 1 <= 20 Then
      If FilePosition + 1 <= FileLength Then
         Call ClearPageByte
         PageColumn = PageColumn + 1
         FilePosition = FilePosition + 1
         Call DisplayPageByte
      End If
   End If
   Colorf Yellow
   Call BytePrint
End Sub

Rem reset hilighted byte.
Sub ResetBytes
   Reset1 = True
   Call ResetByte
   CopyPositionStart = False
   CopyPositionPivot = False
   CopyPositionEnd = False
   CopyStart = False
End Sub

Rem restore hilighted bytes.
Sub RestoreHilightBytes
   CopyPositionStart = File(CurrentFile).CopyPositionStart
   CopyPositionPivot = File(CurrentFile).CopyPositionPivot
   CopyPositionEnd = File(CurrentFile).CopyPositionEnd
   FilePosition = File(CurrentFile).FilePosition
   Reset1 = False
   Call ResetByte
End Sub

Rem draw byte area.
Sub ResetByte
   Temp# = FilePosition
   Temp2# = FilePage
   Var1# = CopyPositionStart
   Var2# = CopyPositionEnd

   ' reset hilighted positions.
   If Var1# < (Temp2# - 1) * 320 + 1 Then
      Var1# = (Temp2# - 1) * 320 + 1
   End If
   If Var2# > (Temp2# - 1) * 320 + 320 Then
      Var2# = (Temp2# - 1) * 320 + 320
   End If
   If Var2# > FileLength Then
      Var2# = FileLength
   End If

   ' draw the bytes.
   For FilePosition = Var1# To Var2#
      Call CalculatePosition1
      If Reset1 Then
         Colorf White
      Else
         Colorf2 0, 7
      End If
      Call BytePrint
   Next
   Colorf2 7, 0
   FilePosition = Temp#
   Call CalculatePosition1
End Sub

Rem clear current byte on screen.
Sub ClearPageByte
   If FileLength = False Then
      Locatef 1, 1, 0
      Exit Sub
   End If
   If CopyPositionStart > 0# Then
      Call ResetHilightBytes
   End If
   Colorf White
   Call BytePrint
End Sub

Rem clear current hilighted byte on screen.
Sub ClearHilightByte
   If FileLength = False Then
      Locatef 1, 1, 0
      Exit Sub
   End If
   Colorf White
   Call BytePrint
End Sub

Rem display current hilight byte being edited.
Sub DisplayHilightByte
   If FileDisplay2 Then
      FileDisplay2 = False
      Call DisplayX
      Colorf White
   End If

   ' display byte.
   If FileLength = False Then
      Locatef 1, 1, 0
      Exit Sub
   End If
   Colorf2 0, 7
   Call BytePrint
   Colorf2 7, 0

   ' store the current byte value being edited.
   AsciiValue = Asc(FileByte)
   Call DisplayPosition
End Sub

Rem display status area.
Sub DisplayX
   Call ClearStatus
   Printf "Editing file: " + RTrim$(Filename) + " "
End Sub

Rem display status line message and prompt type 1.
Sub DisplayStatus1
   StatusMessage = StatusMessage + " Press <esc>:"
   Call DisplayStatusLine
End Sub

Rem display status line message and prompt type 2.
Sub DisplayStatus2
   StatusMessage = StatusMessage + " Press <esc> to continue:"
   Call DisplayStatusLine
End Sub

Rem display the status line message and prompt for key or mouse click.
Sub DisplayStatusLine
   Call ClearStatus
   Printf StatusMessage
   Call LocateCursor2
   Call PromptEscKey
   Call DisplayFilename
End Sub

Rem display screen of current page of hex/ascii values of file being edited.
Sub DisplayHexPage
   If FileLength = False Then
      Row = False
      Column = False
      For NextByte = 1 To 320
         Locatef Row + 4, Column + 6, 0
         Printf "  "
         ColumnSpace = ColumnSpace + 1
         If ColumnSpace = 4 Then
            Printf " "
            Column = Column + 1
            ColumnSpace = False
         End If
         Column = Column + 2
         If Column > 44 Then
            Row = Row + 1
            Column = False
         End If
      Next
      Call RedrawRightWindow
      Locatef 1, 1, 0
      Exit Sub
   End If
   Colorf White
   Row = False
   Column = False
   ColumnSpace = False
   For NextByte = (FilePage - 1) * 320 + 1 To (FilePage - 1) * 320 + 320
      Locatef Row + 4, Column + 6, 0
      If NextByte <= FileLength Then
         SeekPosition = NextByte
         Call LseekFile
         Call ReadFile
         FileByte = Buffer
         Printf Right$("00" + Hex$(Asc(FileByte)), 2)
      Else
         Printf "  "
      End If
      ColumnSpace = ColumnSpace + 1
      If ColumnSpace = 4 Then
         Printf " "
         Column = Column + 1
         ColumnSpace = False
      End If
      Column = Column + 2
      If Column > 44 Then
         Row = Row + 1
         Column = False
      End If
   Next
   Call RedrawRightWindow
End Sub

Rem redraw right window.
Sub RedrawRightWindow
   If CurrentWindow2 = False Then
      Call RedrawWindow1
   Else
      Call RedrawWindow2
   End If
End Sub

Rem redraw right window of ascii values.
Sub RedrawWindow1
   If FileLength = False Then
      Colorf White
      Row = False
      Column = False
      For NextByte = 1 To 320
         Locatef Row + 4, Column + 55, 0
         Printf " "
         Column = Column + 1
         If Column > 19 Then
            Row = Row + 1
            Column = False
         End If
      Next
      Locatef 1, 1, 0
      Exit Sub
   End If
   Row = False
   Column = False
   Colorf White
   For NextLine = 0 To 15
      Locatef NextLine + 4, 54, 0
      Printf " "
   Next
   For NextByte = (FilePage - 1) * 320 + 1 To (FilePage - 1) * 320 + 320
      Locatef Row + 4, Column + 55, 0
      If NextByte <= FileLength Then
         SeekPosition = NextByte
         Call LseekFile
         Call ReadFile
         FileByte = Buffer
         ByteValue = Asc(FileByte)
         ' check unprintable
         If CharPrint Then
            Printf FileByte
         Else
            ' skip unprintable characters
            Select Case ByteValue
               Case 0, 7, 9 To 13, 28 To 32
                  Printf "."
               Case Else
                  Printf FileByte
            End Select
         End If
      Else
         Printf " "
      End If
      Column = Column + 1
      If Column > 19 Then
         Row = Row + 1
         Column = False
      End If
   Next
End Sub

Rem redraw right window of hex ranges.
Sub RedrawWindow2
   Row = False
   For NextLine = (FilePage - 1) * 320 + 1 To (FilePage - 1) * 320 + 320 Step 20
      Locatef Row + 4, 54, 0
      Row = Row + 1
      If NextLine <= FileLength Then
         If NextLine + 19 <= FileLength Then
            Colorf White
            Printf "x" + Right$("00000000" + Hex$(NextLine - 1), 8)
            Colorf Yellow
            Printf " - "
            Colorf White
            Printf "x" + Right$("00000000" + Hex$(NextLine + 19 - 1), 8)
         Else
            Colorf White
            Printf "x" + Right$("00000000" + Hex$(NextLine - 1), 8)
            Colorf Yellow
            Printf " - "
            Colorf White
            Printf "x" + Right$("00000000" + Hex$(FileLength - 1), 8)
         End If
      Else
         Printf Space$(22)
      End If
   Next
End Sub

Rem check valid ascii value
Sub CheckASCIIValue (ByteString$)
   ValidASCIIValue = False
   ASCIIValue3 = Val(ByteString$)
   If ASCIIValue3 <= 0# Or ASCIIValue3 > 2147483647# Then
      StatusMessage = "Invalid ascii value."
      Call DisplayStatus2
      Exit Sub
   End If
   ValidASCIIValue = True
End Sub

Rem check hex byte string.
Sub CheckString (ByteString$)
   ValidString = True
   For HexPosition = 2 To Len(ByteString$)
      Select Case UCase$(Mid$(ByteString$, HexPosition, 1))
         Case "0" To "9", "A" To "F"
            ' nul activity
         Case Else
            ValidString = False
            Exit Sub
      End Select
   Next
End Sub

Rem check hex byte value.
Rem input:
Rem   ByteString$ is packed hex string.
Rem output:
Rem   returns ValidHexValue True for valid hex value.
Rem   returns HexValue contains value of hex string.
Rem parameters:
Rem   Hex string must be 8 characters or less.
Rem   Hex value from 8000 to ffff return signed bit
Rem     and must be incremented by 65536.
Rem   Since 7fff ffff is max filesize,
Rem     hex values from 8000 0000 to ffff ffff
Rem     which are length 8 return negative value.
Rem   Since hex values start from an offset of 0
Rem     then the maximum value allowed is 7fff fffe.
Sub CheckHexValue (ByteString$)
   ValidHexValue = False
   StringLength2 = Len(Mid$(ByteString$, 2))
   If StringLength2 > 8 Then
      StatusMessage = "Invalid hex value."
      Call DisplayStatus2
      Exit Sub
   End If
   Call CheckString(ByteString$)
   If ValidString = False Then
      StatusMessage = "Invalid hex string."
      Call DisplayStatus2
      Exit Sub
   End If
   ByteString$ = Mid$(ByteString$, 2)
   Do
      If Left$(ByteString$, 1) = "0" Then
         ByteString$ = Mid$(ByteString$, 2)
      Else
         Exit Do
      End If
   Loop
   StringLength2 = Len(ByteString$)
   ByteString$ = "&H" + ByteString$
   HexValue = Val(ByteString$)
   ' check signed bit error.
   If StringLength2 = 4 Then
      If HexValue < 0 Then
         HexValue = HexValue + 65536#
      End If
   End If
   If StringLength2 = 8 Then
      If HexValue < 0 Then
         StatusMessage = "Hex underflow."
         Call DisplayStatus2
         Exit Sub
      End If
   End If
   If HexValue >= 2147483647# Then
      StatusMessage = "Hex overflow."
      Call DisplayStatus2
      Exit Sub
   End If
   ValidHexValue = True
   ' adjust hex offset.
   HexValue = HexValue + 1#
End Sub

Rem check ascii byte string.
Rem   input: ByteString$ is space-separated 3-byte ascii pair string.
Rem   returns: ValidByteString equals true if string is valid,
Rem     NumBytes is number of ascii byte pairs,
Rem     ByteString$ is concatenated hex byte string.
Sub CheckAsciiBytes (ByteString$)
   AsciiByte$ = Nul
   ByteString$ = LTrim$(ByteString$)
   ByteString$ = RTrim$(ByteString$)
   If Len(ByteString$) = False Then
      ValidByteString = False
      Exit Sub
   End If
   NumBytes = 1
   ValidByteString = True
   For StringPosition = 1 To Len(ByteString$)
      Byte$ = Mid$(ByteString$, StringPosition, 1)
      If (StringPosition Mod 4) = False Then
         If Byte$ <> " " Then
            ValidByteString = False
            Exit Sub
         End If
         NumBytes = NumBytes + 1
      Else
         Select Case Byte$
            Case "0" To "9"
               AsciiByte$ = AsciiByte$ + Byte$
               If Len(AsciiByte$) = 3 Then
                  ByteValue = Val(AsciiByte$)
                  If ByteValue >= False And ByteValue <= 255 Then
                     AsciiByte$ = Nul
                  Else
                     ValidByteString = False
                     Exit Sub
                  End If
               End If
            Case Else
               ValidByteString = False
               Exit Sub
         End Select
      End If
   Next
   Var1$ = ByteString$
   Do
      Parse = InStr(Var1$, " ")
      If Parse Then
         Var1$ = Left$(Var1$, Parse - 1) + Mid$(Var1$, Parse + 1)
      Else
         Exit Do
      End If
   Loop
   ByteString$ = Var1$
   Call AsciiToHex1(ByteString$)
End Sub

Rem check hex byte string.
Rem   input: AllowWildcard true to allow ? character.
Rem     ByteString$ is space-separated hex byte pair string.
Rem   returns: ValidByteString equals true if string is valid,
Rem     NumBytes is number of hex byte pairs,
Rem     ByteString$ is concatenated hex byte string.
Sub CheckHexBytes (ByteString$)
   ByteString$ = LTrim$(ByteString$)
   ByteString$ = RTrim$(ByteString$)
   If Len(ByteString$) = False Then
      ValidByteString = False
      Exit Sub
   End If
   NumBytes = 1
   ValidByteString = True
   For StringPosition = 1 To Len(ByteString$)
      Byte$ = Mid$(ByteString$, StringPosition, 1)
      If (StringPosition Mod 3) = False Then
         If Byte$ <> " " Then
            ValidByteString = False
            Exit Sub
         End If
         NumBytes = NumBytes + 1
      Else
         Select Case Byte$
            Case "0" To "9", "A" To "F", "a" To "f", "?"
               If Byte$ = "?" Then
                  If AllowWildCard = False Then
                     ValidByteString = False
                     Exit Sub
                  End If
               End If
               Mid$(ByteString$, StringPosition, 1) = UCase$(Byte$)
            Case Else
               ValidByteString = False
               Exit Sub
         End Select
      End If
   Next
   Var1$ = ByteString$
   Do
      Parse = InStr(Var1$, " ")
      If Parse Then
         Var1$ = Left$(Var1$, Parse - 1) + Mid$(Var1$, Parse + 1)
      Else
         Exit Do
      End If
   Loop
   ByteString$ = Var1$
End Sub

Rem convert a 3-digit packed ascii string to a hex string.
Sub AsciiToHex1 (ByteString$)
   Byte$ = Nul
   NewString$ = Nul
   For StringPosition = 1 To Len(ByteString$)
      Byte$ = Byte$ + Mid$(ByteString$, StringPosition, 1)
      If Len(Byte$) = 3 Then
         NewString$ = NewString$ + Right$("00" + Hex$(Val(Byte$)), 2)
         Byte$ = Nul
      End If
   Next
   ByteString$ = NewString$
End Sub

Rem convert a 1-digit packed ascii string to a hex string.
Sub AsciiToHex2 (ByteString$)
   Byte$ = Nul
   NewString$ = Nul
   For StringPosition = 1 To Len(ByteString$)
      Byte$ = Mid$(ByteString$, StringPosition, 1)
      NewString$ = NewString$ + Right$("00" + Hex$(Asc(Byte$)), 2)
   Next
   ByteString$ = NewString$
End Sub

Rem display cell position in string format.
Sub FormatPosition2 (Var)
   If Var = 1 Then
      Printf "Marker#" + Mid$(Str$(MarkerPosition), 2) + ":"
   Else
      Printf "Marker#" + Mid$(Str$(MarkerPosition), 2) + " Position:"
   End If
   TempPosition3 = Markers#(MarkerPosition)
   If CurrentWindow = False Then
      Printf Mid$(Str$(TempPosition3 - 1), 2) + " "
   Else
      Printf Right$("00000000" + Hex$(TempPosition3 - 1), 8) + "x "
   End If
   Call CalculatePosition2
   If CurrentWindow = False Then
      Printf "(page: " + FormatX$(CDbl(FilePage2 - 1), 1) + ","
   Else
      Printf "(page:" + Right$("00000000" + Hex$(FilePage2 - 1), 8) + "x,"
   End If
   Printf "row:" + Mid$(Str$(PageRow2), 2) + ","
   Printf "column:" + Mid$(Str$(PageColumn2), 2) + ")"
   If Var = 1 Then
      Printf " Press <esc>:"
   End If
End Sub

Rem returns ambiguated filename.
Sub GetShortFilename (Short.Filename$)
   ret = GetShortPathName(ASCIIZ, ASCIIZ2, MAX_PATH + 1)
   If ret > 0 Then
      Short.Filename$ = ASCIIZ2
   Else
      Short.Filename$ = ASCIIZ
   End If
   Imbedded = InStr(Short.Filename$, Chr$(0))
   If Imbedded Then
      Short.Filename$ = Left$(Short.Filename$, Imbedded - 1)
   End If
End Sub

Rem processes mouse activity.
Function MouseDriver
   Static X1 As Integer, Y1 As Integer ' store old values
   MouseX = 0: MouseY = 0
   If _MouseInput Then
      X = CInt(_MouseX): Y = CInt(_MouseY) ' X,Y return single
      If X <> X1 Or Y <> Y1 Then
         X1 = X: Y1 = Y
         MouseX = Y: MouseY = X ' X,Y are reversed
         While _MouseInput: Wend ' empty buffer
      End If
      MouseButton1 = _MouseButton(1)
      If MouseButton1 Then
         MouseX = Y1
         MouseY = X1
      End If
      MouseButton2 = _MouseButton(2)
      If MouseButton2 Then
         MouseX = Y1
         MouseY = X1
      End If
      MouseButton3 = _MouseButton(3)
      MouseWheel = _MouseWheel
   End If
   MouseDriver = -1
End Function

Rem processes mouse activity with left double-click.
Function MouseDriver2
   Static X1 As Integer, Y1 As Integer ' store old values
   MouseX = 0: MouseY = 0
   If _MouseInput Then
      X = CInt(_MouseX): Y = CInt(_MouseY) ' X,Y return single
      If X <> X1 Or Y <> Y1 Then
         X1 = X: Y1 = Y
         MouseX = Y: MouseY = X ' X,Y are reversed
         While _MouseInput: Wend ' empty buffer
      End If
      MouseButton1 = _MouseButton(1)
      If MouseButton1 Then
         MouseX = Y1
         MouseY = X1
         MouseCount = 0
         Call ClearMouse
         ' double click
         Do
            _Delay ClickDelay
            MouseCount = MouseCount + 1
            If MouseCount >= ClickCount Then Exit Do
            If _MouseInput Then
               If _MouseButton(1) Then
                  MouseButton1 = 2
               End If
            End If
         Loop
      End If
      MouseButton2 = _MouseButton(2)
      If MouseButton2 Then
         MouseX = Y1
         MouseY = X1
      End If
      MouseButton3 = _MouseButton(3)
      MouseWheel = _MouseWheel
   End If
   MouseDriver2 = -1
End Function

Rem processes mouse activity with left triple-click.
Function MouseDriver3
   Static X1 As Integer, Y1 As Integer ' store old values
   MouseX = 0: MouseY = 0
   If _MouseInput Then
      X = CInt(_MouseX): Y = CInt(_MouseY) ' X,Y return single
      If X <> X1 Or Y <> Y1 Then
         X1 = X: Y1 = Y
         MouseX = Y: MouseY = X ' X,Y are reversed
         While _MouseInput: Wend ' empty buffer
      End If
      MouseButton1 = _MouseButton(1)
      If MouseButton1 Then
         MouseX = Y1
         MouseY = X1
         MouseCount = 0
         Call ClearMouse
         ' double click
         Do
            _Delay ClickDelay
            MouseCount = MouseCount + 1
            If MouseCount >= ClickCount Then Exit Do
            If _MouseInput Then
               If _MouseButton(1) Then
                  MouseButton1 = 2
                  MouseCount = 0
                  Call ClearMouse
                  ' triple click
                  Do
                     _Delay ClickDelay
                     MouseCount = MouseCount + 1
                     If MouseCount >= ClickCount Then Exit Do
                     If _MouseInput Then
                        If _MouseButton(1) Then
                           MouseButton1 = 3
                        End If
                     End If
                  Loop
               End If
            End If
         Loop
      End If
      MouseButton2 = _MouseButton(2)
      If MouseButton2 Then
         MouseX = Y1
         MouseY = X1
      End If
      MouseButton3 = _MouseButton(3)
      MouseWheel = _MouseWheel
   End If
   MouseDriver3 = -1
End Function

' screen restore
Sub RestoreScreen2
   V = 24
   For Var1 = 2 To V
      For Var2 = 1 To 80
         VarB = Int(TempArrayZ2((Var1 - 1) * 80 + Var2) / 16)
         VarF = TempArrayZ2((Var1 - 1) * 80 + Var2) Mod 16
         TempZ1 = TempArrayY2((Var1 - 1) * 80 + Var2)
         Locate Var1, Var2, 1
         Color VarF, VarB
         Print Chr$(TempZ1);
      Next
   Next
End Sub

' screen save
Sub SaveScreen2
   V = 24
   For Var1 = 2 To V
      For Var2 = 1 To 80
         TempZ1 = Screen(Var1, Var2) ' screen char
         TempZ2 = Screen(Var1, Var2, 1) ' char color
         TempArrayY2((Var1 - 1) * 80 + Var2) = TempZ1
         TempArrayZ2((Var1 - 1) * 80 + Var2) = TempZ2
      Next
   Next
End Sub

Rem BreakBox with OK/Quit
Function BreakBox
   Dim TempArrayY3(1 To 2000) As Integer
   Dim TempArrayZ3(1 To 2000) As Integer

   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   GoSub SaveScreenX

   ' declare break box coordinates.
   Xcoor3 = 15
   Ycoor3 = 15

   ' set break box colors
   BreakBoxBorderColor = Yellow
   BreakBoxTitleColor = White
   BreakBoxTextColor = White
   BreakBoxButton1Color = White
   BreakBoxButton2Color = Plain
   BreakBackGround1 = 1
   BreakBackGround2 = 0

   ' draw box
   BoxButton = 1
   GoSub DrawBreakBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      VarQ = _Exit
      If VarQ Then ' Control-Break
         Call Delete.Process
         System
      End If
      X$ = INKEYx$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     BoxButton = 1
                     Exit Do
                  Case "Q"
                     BoxButton = 2
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 1
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawBreakBoxButtons
                  Case Chr$(1) ' ctrl-a
                     BreakBackGround1 = BreakBackGround1 + 1
                     If BreakBackGround1 = 8 Then
                        BreakBackGround1 = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(2) ' ctrl-b
                     BreakBackGround2 = BreakBackGround2 + 1
                     If BreakBackGround2 = 8 Then
                        BreakBackGround2 = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(4) ' ctrl-d
                     BreakBoxBorderColor = BreakBoxBorderColor + 1
                     If BreakBoxBorderColor = 16 Then
                        BreakBoxBorderColor = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(5) ' ctrl-e
                     BreakBoxTitleColor = BreakBoxTitleColor + 1
                     If BreakBoxTitleColor = 16 Then
                        BreakBoxTitleColor = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(6) ' ctrl-f
                     BreakBoxTextColor = BreakBoxTextColor + 1
                     If BreakBoxTextColor = 16 Then
                        BreakBoxTextColor = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(7) ' ctrl-g
                     BreakBoxButton1Color = BreakBoxButton1Color + 1
                     If BreakBoxButton1Color = 16 Then
                        BreakBoxButton1Color = 0
                     End If
                     GoSub DrawBreakBox
                  Case Chr$(8) ' ctrl-h
                     BreakBoxButton2Color = BreakBoxButton2Color + 1
                     If BreakBoxButton2Color = 16 Then
                        BreakBoxButton2Color = 0
                     End If
                     GoSub DrawBreakBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawBreakBoxButtons
                  Case 77 ' right
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawBreakBoxButtons
                  Case 76, 143 ' keppad-5
                     X$ = ""
                     Xcoor3 = 15
                     Ycoor3 = 15
                     GoSub RestoreScreenX
                     GoSub DrawBreakBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           GoSub RestoreScreenX
                           GoSub DrawBreakBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      Z = 24
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        GoSub RestoreScreenX
                        GoSub DrawBreakBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 5 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 13 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 5 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawBreakBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawBreakBoxButtons
               End If
            End If
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   GoSub RestoreScreenX
   Color 7, 0
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then
      BreakBox = -1
   Else
      BreakBox = 0
   End If
   Exit Function

   ' draw box
   DrawBreakBox:
   Color BreakBoxBorderColor, BreakBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   Var0$ = " Break "
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color BreakBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display error text
   Color BreakBoxTextColor

   Var1$ = "Control-Break trap."
   Locate Xcoor3 + 1, Ycoor3 + 2, 0
   Print Var1$

   Var2$ = "Press <OK> to continue."
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   Print Var2$

   Var3$ = "Press <Quit> to end program."
   Locate Xcoor3 + 3, Ycoor3 + 2, 0
   Print Var3$

   GoSub DrawBreakBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawBreakBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color BreakBoxButton1Color, BreakBackGround2
      Print "<OK>";
      Locate Xcoor3 + 5, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 5, Ycoor3 + 8, 0
      Color BreakBoxButton2Color, BreakBackGround2
      Print "<Quit>";
      Locate Xcoor3 + 5, Ycoor3 + 9, 0
      Color Magenta
      Print "Q";
   Else
      Locate Xcoor3 + 5, Ycoor3 + 2, 0
      Color BreakBoxButton2Color, BreakBackGround2
      Print "<OK>";
      Locate Xcoor3 + 5, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 5, Ycoor3 + 8, 0
      Color BreakBoxButton1Color, BreakBackGround2
      Print "<Quit>";
      Locate Xcoor3 + 5, Ycoor3 + 9, 0
      Color Magenta
      Print "Q";
   End If
   Color 7, 0
   Return

   ' screen save
   SaveScreenX:
   V = 24
   For Var1 = 2 To V
      For Var2 = 1 To 80
         TempZ1 = Screen(Var1, Var2) ' screen char
         TempZ2 = Screen(Var1, Var2, 1) ' char color
         TempArrayY3((Var1 - 1) * 80 + Var2) = TempZ1
         TempArrayZ3((Var1 - 1) * 80 + Var2) = TempZ2
      Next
   Next
   Return

   ' screen restore
   RestoreScreenX:
   V = 24
   For Var1 = 2 To V
      For Var2 = 1 To 80
         VarB = Int(TempArrayZ3((Var1 - 1) * 80 + Var2) / 16)
         VarF = TempArrayZ3((Var1 - 1) * 80 + Var2) Mod 16
         TempZ1 = TempArrayY3((Var1 - 1) * 80 + Var2)
         Locate Var1, Var2, 1
         Color VarF, VarB
         Print Chr$(TempZ1);
      Next
   Next
   Return
End Function

Rem MessageBox with OK/Cancel
Function ErrorBox (Var0$, Var1$)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   ' declare error box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10

   ' set error box colors
   ErrorBoxBorderColor = Yellow
   ErrorBoxTitleColor = White
   ErrorBoxTextColor = White
   ErrorBoxButton1Color = White
   ErrorBoxButton2Color = Plain
   ErrorBackGround1 = 1
   ErrorBackGround2 = 0

   ' draw box
   BoxButton = 1
   GoSub DrawErrorBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYx$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     BoxButton = 1
                     Exit Do
                  Case "C"
                     BoxButton = 2
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 2
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawErrorBoxButtons
                  Case Chr$(1) ' ctrl-a
                     ErrorBackGround1 = ErrorBackGround1 + 1
                     If ErrorBackGround1 = 8 Then
                        ErrorBackGround1 = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(2) ' ctrl-b
                     ErrorBackGround2 = ErrorBackGround2 + 1
                     If ErrorBackGround2 = 8 Then
                        ErrorBackGround2 = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(4) ' ctrl-d
                     ErrorBoxBorderColor = ErrorBoxBorderColor + 1
                     If ErrorBoxBorderColor = 16 Then
                        ErrorBoxBorderColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(5) ' ctrl-e
                     ErrorBoxTitleColor = ErrorBoxTitleColor + 1
                     If ErrorBoxTitleColor = 16 Then
                        ErrorBoxTitleColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(6) ' ctrl-f
                     ErrorBoxTextColor = ErrorBoxTextColor + 1
                     If ErrorBoxTextColor = 16 Then
                        ErrorBoxTextColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(7) ' ctrl-g
                     ErrorBoxButton1Color = ErrorBoxButton1Color + 1
                     If ErrorBoxButton1Color = 16 Then
                        ErrorBoxButton1Color = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(8) ' ctrl-h
                     ErrorBoxButton2Color = ErrorBoxButton2Color + 1
                     If ErrorBoxButton2Color = 16 Then
                        ErrorBoxButton2Color = 0
                     End If
                     GoSub DrawErrorBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawErrorBoxButtons
                  Case 77 ' right
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawErrorBoxButtons
                  Case 76, 143 ' keppad-5
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen2
                     GoSub DrawErrorBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      Z = 24
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 4 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 4 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawErrorBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawErrorBoxButtons
               End If
            End If
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   Call RestoreScreen2
   Color 7, 0
   Locate CurrentX, CurrentY, 1
   If BoxButton = 1 Then
      ErrorBox = -1
   Else
      ErrorBox = 0
   End If
   Exit Function

   ' draw box
   DrawErrorBox:
   Color ErrorBoxBorderColor, ErrorBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color ErrorBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display error text
   Color ErrorBoxTextColor
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   Print Left$(Var1$, 29)
   GoSub DrawErrorBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawErrorBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color ErrorBoxButton1Color, ErrorBackGround2
      Print "<OK>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color ErrorBoxButton2Color, ErrorBackGround2
      Print "<Cancel>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   Else
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color ErrorBoxButton2Color, ErrorBackGround2
      Print "<OK>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "O";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color ErrorBoxButton1Color, ErrorBackGround2
      Print "<Cancel>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "C";
   End If
   Color 7, 0
   Return
End Function

Rem MessageBox with Escape/Box/File
Function ErrorBox2 (Var0$, Var1$)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   ' declare error box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10

   ' set error box colors
   ErrorBoxBorderColor = Yellow
   ErrorBoxTitleColor = White
   ErrorBoxTextColor = White
   ErrorBoxButton1Color = White
   ErrorBoxButton2Color = Plain
   ErrorBackGround1 = 1
   ErrorBackGround2 = 0

   ' draw box
   BoxButton = 1
   GoSub DrawErrorBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYx$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "B"
                     BoxButton = 1
                     Exit Do
                  Case "F"
                     BoxButton = 2
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     BoxButton = 3
                     Exit Do
                  Case Chr$(9) ' tab
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawErrorBoxButtons
                  Case Chr$(1) ' ctrl-a
                     ErrorBackGround1 = ErrorBackGround1 + 1
                     If ErrorBackGround1 = 8 Then
                        ErrorBackGround1 = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(2) ' ctrl-b
                     ErrorBackGround2 = ErrorBackGround2 + 1
                     If ErrorBackGround2 = 8 Then
                        ErrorBackGround2 = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(4) ' ctrl-d
                     ErrorBoxBorderColor = ErrorBoxBorderColor + 1
                     If ErrorBoxBorderColor = 16 Then
                        ErrorBoxBorderColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(5) ' ctrl-e
                     ErrorBoxTitleColor = ErrorBoxTitleColor + 1
                     If ErrorBoxTitleColor = 16 Then
                        ErrorBoxTitleColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(6) ' ctrl-f
                     ErrorBoxTextColor = ErrorBoxTextColor + 1
                     If ErrorBoxTextColor = 16 Then
                        ErrorBoxTextColor = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(7) ' ctrl-g
                     ErrorBoxButton1Color = ErrorBoxButton1Color + 1
                     If ErrorBoxButton1Color = 16 Then
                        ErrorBoxButton1Color = 0
                     End If
                     GoSub DrawErrorBox
                  Case Chr$(8) ' ctrl-h
                     ErrorBoxButton2Color = ErrorBoxButton2Color + 1
                     If ErrorBoxButton2Color = 16 Then
                        ErrorBoxButton2Color = 0
                     End If
                     GoSub DrawErrorBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 75, 15 ' left/shift-tab
                     If BoxButton = 2 Then
                        BoxButton = 1
                     Else
                        BoxButton = 2
                     End If
                     GoSub DrawErrorBoxButtons
                  Case 77 ' right
                     If BoxButton = 1 Then
                        BoxButton = 2
                     Else
                        BoxButton = 1
                     End If
                     GoSub DrawErrorBoxButtons
                  Case 76, 143 ' keppad-5
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen2
                     GoSub DrawErrorBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        If Xcoor3 - 1 > 4 Then
                           Xcoor3 = Xcoor3 - 1
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 115 ' ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 116 ' ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        If Xcoor3 - 4 > 4 Then
                           Xcoor3 = Xcoor3 - 4
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        Else
                           Xcoor3 = 5
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen2
                           GoSub DrawErrorBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      Z = 24
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 5 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen2
                        GoSub DrawErrorBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 4 Then
               If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
                  BoxButton = 1
                  Exit Do
               End If
               If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
                  BoxButton = 2
                  Exit Do
               End If
            End If
         End If
      Else
         If MouseX = Xcoor3 + 4 Then
            If MouseY >= Ycoor3 + 2 And MouseY <= Ycoor3 + 5 Then
               If BoxButton = 2 Then
                  BoxButton = 1
                  GoSub DrawErrorBoxButtons
               End If
            End If
            If MouseY >= Ycoor3 + 8 And MouseY <= Ycoor3 + 15 Then
               If BoxButton = 1 Then
                  BoxButton = 2
                  GoSub DrawErrorBoxButtons
               End If
            End If
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   Call RestoreScreen2
   Color 7, 0
   Locate CurrentX, CurrentY, 1

   ' return button press.
   If BoxButton = 1 Then
      ErrorBox2 = -1
   Else
      If BoxButton = 2 Then
         ErrorBox2 = 0
      Else
         If BoxButton = 3 Then
            ErrorBox2 = -2
         End If
      End If
   End If
   Exit Function

   ' draw box
   DrawErrorBox:
   Color ErrorBoxBorderColor, ErrorBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color ErrorBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display error text
   Color ErrorBoxTextColor
   Locate Xcoor3 + 1, Ycoor3 + 2, 0
   Print "Press <escape> to quit";
   If InStr(Var1$, "|") Then ' split line
      Varx1$ = Left$(Var1$, InStr(Var1$, "|") - 1)
      Varx2$ = Mid$(Var1$, InStr(Var1$, "|") + 1)
      Locate Xcoor3 + 2, Ycoor3 + 2, 0
      Print Left$(Varx1$, 29)
      Locate Xcoor3 + 3, Ycoor3 + 2, 0
      Print Left$(Varx2$, 29)
   Else
      Locate Xcoor3 + 2, Ycoor3 + 2, 0
      Print Left$(Var1$, 29)
   End If
   GoSub DrawErrorBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawErrorBoxButtons:
   If BoxButton = 1 Then
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color ErrorBoxButton1Color, ErrorBackGround2
      Print "<Box>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "B";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color ErrorBoxButton2Color, ErrorBackGround2
      Print "<File>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "F";
   Else
      Locate Xcoor3 + 4, Ycoor3 + 2, 0
      Color ErrorBoxButton2Color, ErrorBackGround2
      Print "<Box>";
      Locate Xcoor3 + 4, Ycoor3 + 3, 0
      Color Magenta
      Print "B";

      Locate Xcoor3 + 4, Ycoor3 + 8, 0
      Color ErrorBoxButton1Color, ErrorBackGround2
      Print "<File>";
      Locate Xcoor3 + 4, Ycoor3 + 9, 0
      Color Magenta
      Print "F";
   End If
   Color 7, 0
   Return
End Function

Rem MessageBox with OK
Function MessageBox (Var0$, Var1$)
   ' clear mouse activity.
   MouseButton1 = 0
   MouseButton2 = 0
   MouseButton3 = 0
   Call ClearMouse

   ' store screen area.
   CurrentX = CsrLin
   CurrentY = Pos(0)
   Call SaveScreen2

   ' declare error box coordinates.
   Xcoor3 = 10
   Ycoor3 = 10

   ' set error box colors
   MessageBoxBorderColor = Yellow
   MessageBoxTitleColor = White
   MessageBoxTextColor = White
   MessageBoxButton1Color = White
   MessageBoxButton2Color = Plain
   MessageBackGround1 = 1
   MessageBackGround2 = 0

   ' draw box
   GoSub DrawMessageBox

   ' wait for keypress or mouse
   _KeyClear
   Do
      X$ = INKEYx$
      If Len(X$) Then
         Select Case Len(X$)
            Case 1
               Select Case UCase$(X$)
                  Case "O"
                     Exit Do
                  Case Chr$(13)
                     Exit Do
                  Case Chr$(27)
                     Exit Do
                  Case Chr$(1) ' ctrl-a
                     MessageBackGround1 = MessageBackGround1 + 1
                     If MessageBackGround1 = 8 Then
                        MessageBackGround1 = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(2) ' ctrl-b
                     MessageBackGround2 = MessageBackGround2 + 1
                     If MessageBackGround2 = 8 Then
                        MessageBackGround2 = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(4) ' ctrl-d
                     MessageBoxBorderColor = MessageBoxBorderColor + 1
                     If MessageBoxBorderColor = 16 Then
                        MessageBoxBorderColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(5) ' ctrl-e
                     MessageBoxTitleColor = MessageBoxTitleColor + 1
                     If MessageBoxTitleColor = 16 Then
                        MessageBoxTitleColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(6) ' ctrl-f
                     MessageBoxTextColor = MessageBoxTextColor + 1
                     If MessageBoxTextColor = 16 Then
                        MessageBoxTextColor = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(7) ' ctrl-g
                     MessageBoxButton1Color = MessageBoxButton1Color + 1
                     If MessageBoxButton1Color = 16 Then
                        MessageBoxButton1Color = 0
                     End If
                     GoSub DrawMessageBox
                  Case Chr$(8) ' ctrl-h
                     MessageBoxButton2Color = MessageBoxButton2Color + 1
                     If MessageBoxButton2Color = 16 Then
                        MessageBoxButton2Color = 0
                     End If
                     GoSub DrawMessageBox
               End Select
            Case 2
               Select Case Asc(Right$(X$, 1))
                  Case 76, 143 ' keppad-5
                     X$ = ""
                     Xcoor3 = 10
                     Ycoor3 = 10
                     Call RestoreScreen2
                     GoSub DrawMessageBox
                     _KeyClear
                  Case 72, 141 ' up/ctrl-up
                     X$ = ""
                     If Xcoor3 > 2 Then
                        Xcoor3 = Xcoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 80, 145 ' down/ctrl-down
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z Then
                        Xcoor3 = Xcoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 75, 115 ' left/ctrl-left
                     X$ = ""
                     If Ycoor3 > 1 Then
                        Ycoor3 = Ycoor3 - 1
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 77, 116 ' right/ctrl-right
                     X$ = ""
                     If Ycoor3 < 49 Then
                        Ycoor3 = Ycoor3 + 1
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     End If
                     _KeyClear
                  Case 152 ' alt-up
                     X$ = ""
                     If Xcoor3 > 5 Then
                        Xcoor3 = Xcoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     Else
                        If Xcoor3 > 2 Then
                           Xcoor3 = 2
                           Call RestoreScreen2
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 160 ' alt-dn
                     Z = 24
                     X$ = ""
                     If Xcoor3 + 7 < Z - 4 Then
                        Xcoor3 = Xcoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     Else
                        If Xcoor3 + 7 < Z Then
                           Xcoor3 = Z - 7
                           Call RestoreScreen2
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 155 ' alt-left
                     X$ = ""
                     If Ycoor3 > 4 Then
                        Ycoor3 = Ycoor3 - 4
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     Else
                        If Ycoor3 > 1 Then
                           Ycoor3 = 1
                           Call RestoreScreen2
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
                  Case 157 ' alt-right
                     X$ = ""
                     If Ycoor3 < 45 Then
                        Ycoor3 = Ycoor3 + 4
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     Else
                        If Ycoor3 < 49 Then
                           Ycoor3 = 49
                           Call RestoreScreen2
                           GoSub DrawMessageBox
                        End If
                     End If
                     _KeyClear
               End Select
         End Select
      End If
      Z = 24
      X = MouseDriver
      If MouseButton1 Then
         ' hover over titlebar
         If MouseX = Xcoor3 Then
            If MouseY >= Ycoor3 And MouseY <= Ycoor3 + 31 Then
               ' store mouse XY during click
               MouseTempX = MouseX
               MouseTempY = MouseY
               Do
                  X = MouseDriver
                  If MouseX Or MouseY Then ' drag
                     MoveBox = 0
                     ' difference in mouse X
                     If MouseX <> MouseTempX Then
                        If MouseX >= 2 And MouseX <= Z - 7 Then
                           Xcoor3 = MouseX
                           MouseTempX = MouseX
                           MoveBox = -1
                        End If
                     End If
                     ' difference in mouse Y
                     If MouseY <> MouseTempY Then
                        MoveY = Ycoor3 + (MouseY - MouseTempY)
                        If MoveY >= 1 And MoveY <= 49 Then
                           Ycoor3 = MoveY
                           MouseTempY = MouseY
                           MoveBox = -1
                        End If
                     End If
                     ' move box
                     If MoveBox Then
                        Call RestoreScreen2
                        GoSub DrawMessageBox
                     End If
                  End If
               Loop Until MouseButton1 = 0
            End If
         Else
            If MouseX = Xcoor3 + 4 Then
               If MouseY >= Ycoor3 + 14 And MouseY <= Ycoor3 + 17 Then
                  Exit Do
               End If
            End If
         End If
      End If
   Loop
   _Delay .2
   _KeyClear
   _Delay .2

   ' restore screen area.
   Call RestoreScreen2
   Color 7, 0
   Locate CurrentX, CurrentY, 1
   MessageBox = -1
   Exit Function

   ' draw box
   DrawMessageBox:
   Color MessageBoxBorderColor, MessageBackGround1
   Locate Xcoor3, Ycoor3, 0
   Print Chr$(ULcorner) + String$(30, Hline) + Chr$(URcorner);
   For RowX1 = Xcoor3 + 1 To Xcoor3 + 6
      Locate RowX1, Ycoor3, 0
      Print Chr$(Vline) + Space$(30) + Chr$(Vline);
   Next
   Locate Xcoor3 + 7, Ycoor3, 0
   Print Chr$(LLcorner) + String$(30, Hline) + Chr$(LRcorner);

   ' display box title
   TempX = 16 - Len(Var0$) \ 2 ' center of titlebar
   TempX = Ycoor3 + TempX
   If TempX < 1 Then TempX = 1
   Color MessageBoxTitleColor
   Locate Xcoor3, TempX, 0
   Print Var0$;

   ' display message text
   Color MessageBoxTextColor
   Locate Xcoor3 + 2, Ycoor3 + 2, 0
   If InStr(Var1$, "|") Then ' split line
      VarX$ = Left$(Var1$, InStr(Var1$, "|") - 1)
      VarY$ = Mid$(Var1$, InStr(Var1$, "|") + 1)
      Locate Xcoor3 + 2, Ycoor3 + 2, 0
      Print Left$(VarX$, 29)
      Locate Xcoor3 + 3, Ycoor3 + 2, 0
      Print Left$(VarY$, 29)
   Else
      Locate Xcoor3 + 2, Ycoor3 + 2, 0
      Print Left$(Var1$, 29)
   End If
   GoSub DrawMessageBoxButtons
   Locate , , , 8, 8
   Return

   ' display buttuns
   DrawMessageBoxButtons:
   Locate Xcoor3 + 4, Ycoor3 + 14, 0
   Color MessageBoxButton1Color, MessageBackGround2
   Print "<OK>";

   Locate Xcoor3 + 4, Ycoor3 + 15, 0
   Color Magenta
   Print "O";

   Color 7, 0
   Return
End Function

Rem Functions:
Rem   Conanicalize         --  trims a filename.
Rem   CalculateColumn      --  calculate column groups.
Rem   CalculateColumn2     --  calculate column groups.
Rem   CalculatePosition3#  --  calculate mouse position.
Rem   DumpLineRange$       --  format line range.
Rem   Directories          --  get a directory from temp data file.
Rem   Filenames            --  get a filename from temp data file.
Rem   UndoByte             --  get an undo byte from temp data file.
Rem   UndoPosition         --  get an undo position from temp data file.
Rem   Markers              --  get a marker value from temp data file.

Rem conanicalizes filename.
Function Conanicalize$ (Var$)
   Var1$ = Var$

   ' strip drive letter.
   Var1$ = UCase$(Var1$)
   If Mid$(Var1$, 2, 1) = ":" Then
      Var1$ = Mid$(Var1$, 3)
   End If

   ' strip dos path.
   Do
      Path = InStr(Var1$, "\")
      If Path Then
         Var1$ = Mid$(Var1$, Path + 1)
      Else
         Exit Do
      End If
   Loop
   Conanicalize$ = Var1$
End Function

Rem function to calculate column groups.
Function CalculateColumn
   Select Case PageColumn
      Case 1 To 4
         CalculateColumn = (PageColumn - 1) * 2 + 1
      Case 5 To 8
         CalculateColumn = (PageColumn - 1) * 2 + 2
      Case 9 To 12
         CalculateColumn = (PageColumn - 1) * 2 + 3
      Case 13 To 16
         CalculateColumn = (PageColumn - 1) * 2 + 4
      Case 17 To 20
         CalculateColumn = (PageColumn - 1) * 2 + 5
   End Select
End Function

Rem function to calculate column groups.
Function CalculateColumn2
   Select Case PageColumn2
      Case 1 To 4
         CalculateColumn2 = (PageColumn2 - 1) * 2 + 1
      Case 5 To 8
         CalculateColumn2 = (PageColumn2 - 1) * 2 + 2
      Case 9 To 12
         CalculateColumn2 = (PageColumn2 - 1) * 2 + 3
      Case 13 To 16
         CalculateColumn2 = (PageColumn2 - 1) * 2 + 4
      Case 17 To 20
         CalculateColumn2 = (PageColumn2 - 1) * 2 + 5
   End Select
End Function

Rem function to calculate mouse position.
Function CalculatePosition3#
   Var1# = (FilePage - 1) * 320 + (MouseX - 4) * 20
   Select Case MouseY
      Case 6, 7
         Var1# = Var1# + 1#
      Case 8, 9
         Var1# = Var1# + 2#
      Case 10, 11
         Var1# = Var1# + 3#
      Case 12, 13
         Var1# = Var1# + 4#
      Case 15, 16
         Var1# = Var1# + 5#
      Case 17, 18
         Var1# = Var1# + 6#
      Case 19, 20
         Var1# = Var1# + 7#
      Case 21, 22
         Var1# = Var1# + 8#
      Case 24, 25
         Var1# = Var1# + 9#
      Case 26, 27
         Var1# = Var1# + 10#
      Case 28, 29
         Var1# = Var1# + 11#
      Case 30, 31
         Var1# = Var1# + 12#
      Case 33, 34
         Var1# = Var1# + 13#
      Case 35, 36
         Var1# = Var1# + 14#
      Case 37, 38
         Var1# = Var1# + 15#
      Case 39, 40
         Var1# = Var1# + 16#
      Case 42, 43
         Var1# = Var1# + 17#
      Case 44, 45
         Var1# = Var1# + 18#
      Case 46, 47
         Var1# = Var1# + 19#
      Case 48, 49
         Var1# = Var1# + 20#
   End Select
   CalculatePosition3# = Var1#
End Function

Rem function to format line range.
Function DumpLineRange$
   Var$ = "File: " + RTrim$(Filename) + " Bytes: "
   Var$ = Var$ + FormatX$(FirstByte, 1) + "-"
   If LastByte <= FileLength Then
      Var$ = Var$ + FormatX$(LastByte, 1)
   Else
      Var$ = Var$ + FormatX$(FileLength, 1)
   End If
   Var$ = Var$ + " (x" + Right$("000000000000" + Hex$(FirstByte - 1), 12) + "-x"
   If LastByte <= FileLength Then
      Var$ = Var$ + Right$("000000000000" + Hex$(LastByte - 1), 12)
   Else
      Var$ = Var$ + Right$("000000000000" + Hex$(FileLength - 1), 12)
   End If
   Var$ = Var$ + ")."
   DumpLineRange$ = Var$
End Function

' unambiguate filename
Function UnAmbiguateFile$ (Var$)
   Dim finddata2 As WIN32_FIND_DATA
   Dim hfind2 As _Unsigned _Offset
   Dim TempASCIIZ As String * 260
   File$ = Var$
   TempASCIIZ = Var$ + Chr$(0)
   hfind2 = FindFirstFileA(_Offset(TempASCIIZ), _Offset(finddata2))
   If hfind2 <> INVALID_HANDLE_VALUE Then
      File$ = finddata2.cFileName
      V = InStr(File$, Chr$(0))
      If V Then File$ = Left$(File$, V - 1)
      x = FindClose(hfind2)
   End If
   UnAmbiguateFile$ = File$
End Function

Rem filename structure function.
Function Filenames$ (Var1!)
   If Var1! > 0! Then
      Get #2, Var1!, WinFileStruc
      Filenames$ = WinFileStruc.Name
   Else
      Filenames$ = Nul
   End If
End Function

Rem directory structure function.
Function Directories$ (Var1!)
   If Num.Dirs = 0! Then
      Directories$ = "."
      Exit Function
   End If
   If Var1! > 0! Then
      Get #3, Var1!, WinFileStruc
      Directories$ = WinFileStruc.Name
   Else
      Directories$ = Nul
   End If
End Function

Rem undo structure function.
Function UndoByte% (Var1!)
   Get #6, Var1!, UndoFile
   UndoByte% = CVI(Mid$(UndoFile.UndoByte1, (CurrentFile - 1) * 2 + 1, 2))
End Function

Rem undo structure function.
Function UndoPosition# (Var1!)
   Get #6, Var1!, UndoFile
   UndoPosition# = CVD(Mid$(UndoFile.UndoPosition1, (CurrentFile - 1) * 8 + 1, 8))
End Function

Rem marker structure function.
Function Markers# (Var1!)
   Get #7, Var1!, MarkerFile
   Markers# = CVD(Mid$(MarkerFile.Markers1, (CurrentFile - 1) * 8 + 1, 8))
End Function

Rem Functions:
Rem   MakeFilename?$  --  constructs filename for file menu box.

Function MakeFilename$ (N$, C$, D$, X$)
   If N$ = Nul Then
      If D$ = Nul Then
         MakeFilename$ = C$ + ":\" + X$
      Else
         MakeFilename$ = C$ + ":\" + D$ + "\" + X$
      End If
   Else
      If D$ = Nul Then
         MakeFilename$ = N$ + "\" + X$
      Else
         MakeFilename$ = N$ + "\" + D$ + "\" + X$
      End If
   End If
End Function

Function MakeFilename2$ (N$, C$, D$)
   If N$ = Nul Then
      If D$ = Nul Then
         MakeFilename2$ = C$ + ":\"
      Else
         If D$ = "\" Then
            MakeFilename2$ = C$ + ":\"
         Else
            MakeFilename2$ = C$ + ":\" + D$
         End If
      End If
   Else
      If D$ = Nul Then
         MakeFilename2$ = N$ + "\"
      Else
         If D$ = "\" Then
            MakeFilename2$ = N$ + "\"
         Else
            MakeFilename2$ = N$ + "\" + D$
         End If
      End If
   End If
End Function

Function MakeFilename3$ (N$, C$, D$)
   If N$ = Nul Then
      If D$ = Nul Then
         MakeFilename3$ = C$ + ":\*.*"
      Else
         If D$ = "\" Then
            MakeFilename3$ = C$ + ":\*.*"
         Else
            MakeFilename3$ = C$ + ":\" + D$ + "\*.*"
         End If
      End If
   Else
      If D$ = Nul Then
         MakeFilename3$ = N$ + "\*.*"
      Else
         If D$ = "\" Then
            MakeFilename3$ = N$ + "\*.*"
         Else
            MakeFilename3$ = N$ + "\" + D$ + "\*.*"
         End If
      End If
   End If
End Function

Function MakeFilename4$ (N$, C$, D$)
   If N$ = Nul Then
      MakeFilename4$ = C$ + ":\" + D$
   Else
      If D$ = "\" Then
         MakeFilename4$ = N$ + "\"
      Else
         MakeFilename4$ = N$ + "\" + D$
      End If
   End If
End Function

Rem Subroutines:
Rem   PressKey()        --  prompts for key press.
Rem   PromptInkey()     --  prompts for escape key.
Rem   PromptKey()       --  prompts for any key or left mouse click.
Rem   PromptEscKey      --  prompts for escape key or left mouse click.

Rem prompts for key press.
Sub PressKey
   Colorf White
   Printf "Press a key:"
   Do
      If INKEYx$ <> "" Then
         Exit Do
      End If
   Loop
End Sub

' prompt for escape key.
Sub PromptInkey
   Z$ = Nul
   Do
      Z$ = INKEYx$
      ' escape
      If Z$ = Chr$(27) Then
         Exit Do
      End If
   Loop
End Sub

Rem prompts for any key or left mouse click.
Sub PromptKey
   Do
      If INKEYx$ <> Nul Then
         Exit Do
      End If

      ' call mouse subroutine.
      Z = MouseDriver

      ' check left mouse button.
      If MouseButton1 Then
         Exit Do
      End If
   Loop
End Sub

Rem prompts for escape key or left mouse click.
Sub PromptEscKey
   I$ = Nul
   Do
      I$ = INKEYx$
      If Len(I$) Then
         ' check escape key pressed.
         If I$ = Chr$(27) Then
            Exit Do
         End If
      End If

      ' call mouse subroutine.
      Z = MouseDriver

      ' check left mouse button.
      If MouseButton1 Then
         Exit Do
      End If
   Loop
End Sub

Rem Subroutines:
Rem   GetFileLength(V%) --  get filelength from handle.
Rem   GetFileAttr(Var$) --  get file attributes.
Rem   GetDrives()       --  get default drives.
Rem   InstrSub(V%,V1$,V2$)  --  match substrings.

Rem read filelength from handle.
Sub GetFileLength (Var)
   FileLength = 0
   If Var > 0 Then
      FileLength = LOF(Var)
   End If
End Sub

Rem get file attributes.
Function GetFileAttr (Var$)
   Var = GetFileAttributes(Var$)
   If Var < 0 Then
      Var = 0
   End If
   GetFileAttr = Var
End Function

Rem get default drives.
Sub GetDrives
   ' get current drive.
   Default.Drive = Asc(Left$(_CWD$, 1)) - 65 ' 0=a, 1=b,..

   ' set maximum drive.
   Last.Drive = 26
End Sub

' function to match substring with ?, * characters in substring.
Sub InstrSUB (Var, Var1$, Var2$)

   ' store string match variables
   S2$ = UCase$(Var2$)
   S3$ = UCase$(Var1$)

   ' check default instr
   If InStr(S2$, "*") = 0 Then
      If InStr(S2$, "?") = 0 Then
         Var = InStr(S3$, S2$)
         Exit Sub
      End If
   End If

   Var = -1 ' assume match

   ' see if S2$ matches in S3$ with substrings
   For S3 = 1 To Len(S3$)
      S1$ = Mid$(S3$, S3)
      P1 = 1 ' pointer to S1$
      P2 = 1 ' pointer to S2$
      Do
         ' check token beyond string
         If P2 >= Len(S2$) Then
            Exit Sub
         End If

         ' check character in S2$ at P2
         V$ = Mid$(S2$, P2, 1)
         Select Case V$
            Case "*" ' global character
               ' scan to next char
               If P2 >= Len(S2$) Then
                  Exit Do
               End If
               S4$ = Mid$(S2$, P2 + 1, 1)
               Select Case S4$
                  Case "*", "?" ' imbedded
                     P2 = P2 + 1
                  Case Else
                     Do
                        If Mid$(S1$, P1, 1) = S4$ Then
                           Exit Do
                        End If
                        If P1 >= Len(S1$) Then
                           Exit Do
                        End If
                        P1 = P1 + 1
                     Loop
                     P2 = P2 + 1
               End Select
            Case "?" ' wildcard character
               P1 = P1 + 1
               P2 = P2 + 1
            Case Else ' ascii character
               If Mid$(S1$, P1, 1) <> V$ Then ' no match
                  Exit Do
               End If
               P1 = P1 + 1
               P2 = P2 + 1
         End Select
      Loop
   Next
   Var = 0 ' no match
   Exit Sub
End Sub

Rem File/Structure pack subroutines.
Rem   Pack.Files1  -  Pack paste undo files w/debug.
Rem   Pack.Arrays1  -  Pack byte undo file arrays.
Rem   Pack.Arrays2  -  Pack marker file array.

' pack paste undo files.
'   kills current paste undo file.
Sub Pack.Files1
   If Debug3 Then
      Cls
   End If
   Close #4
   Close #5
   V1$ = RTrim$(MultiFilenames(CurrentFile))
   If Len(V1$) Then
      If _FileExists(V1$) Then
         G$ = V1$ + Chr$(0)
         x = DeleteFileA(G$)
         If Debug3 Then
            Colorf White
            Print "Killed: " + V1$
         End If
      End If
   End If
   For Var = CurrentFile To MaxFiles - 1
      V1$ = RTrim$(MultiFilenames(Var))
      V2$ = RTrim$(MultiFilenames(Var + 1))
      If Len(V2$) = 0 Then
         Exit For
      End If
      If _FileExists(V2$) = 0 Then
         Exit For
      End If
      If Len(V1$) Then
         Name V2$ As V1$
         If Debug3 Then
            Colorf Yellow
            Print "Renamed: " + V2$ + " AS " + V1$
         End If
      End If
   Next
   If Debug3 Then
      Colorf White
      Print "Press a key:";
      While INKEYx$ = Nul
         Eat$ = Nul
      Wend
      Cls
      Print "Press Alt-R to redraw screen"
   End If
End Sub

' pack byte undo file.
Sub Pack.Arrays1
   For Tmp1! = 1! To LOF(6) / Len(UndoFile)
      Get #6, Tmp1!, UndoFile
      For Var = CurrentFile To MaxFiles - 1
         TempM = CVI(Mid$(UndoFile.UndoByte1, Var * 2 + 1, 2))
         Mid$(UndoFile.UndoByte1, (Var - 1) * 2 + 1, 2) = MKI$(TempM)
         TempM# = CVD(Mid$(UndoFile.UndoPosition1, Var * 8 + 1, 8))
         Mid$(UndoFile.UndoPosition1, (Var - 1) * 8 + 1, 8) = MKD$(TempM#)
      Next
      Mid$(UndoFile.UndoByte1, (MaxFiles - 1) * 2 + 1, 2) = MKI$(0%)
      Mid$(UndoFile.UndoPosition1, (MaxFiles - 1) * 8 + 1, 8) = MKD$(0#)
      Put #6, Tmp1!, UndoFile
   Next
End Sub

' pack marker file.
Sub Pack.Arrays2
   For Tmp1! = 1! To LOF(7) / Len(MarkerFile)
      Get #7, Tmp1!, MarkerFile
      For Var = CurrentFile To MaxFiles - 1
         TempM# = CVD(Mid$(MarkerFile.Markers1, Var * 8 + 1, 8))
         Mid$(MarkerFile.Markers1, (Var - 1) * 8 + 1, 8) = MKD$(TempM#)
      Next
      Mid$(MarkerFile.Markers1, (MaxFiles - 1) * 8 + 1, 8) = MKD$(0#)
      Put #7, Tmp1!, MarkerFile
   Next
End Sub

Function LOADICON& (file As String, fram As Integer)
   'file identity header
   PD = _Dest
   Type File_Head
      reserved As Integer '0
      id_Type As Integer '1
      id_Count As Integer 'number of frames in file
   End Type

   Type ICO_Head
      bWidth As _Unsigned _Byte
      bHeight As _Unsigned _Byte
      color_count As _Unsigned _Byte '0 = >256 colors
      bReserved As _Unsigned _Byte '0
      wPlanes As _Unsigned Integer 'number of bit layers
      wBitCount As _Unsigned Integer 'bites per pixel
      dwBytesInRes As Long 'image lenght included palette
      dwImageOffset As Long 'icon begin from file begin (driving record)
   End Type

   Type Ico_Image
      ThisSize As Long '40
      width As Long
      height As Long
      biPlanes As Integer '1
      BitCount As Integer 'bites per pixel, tj 1, 4 , 8, 24
      Compression As Long '0 = BI_RGB, 1 = BI_RLE8, 2 = BI_RLE4
      SizeImage As Long 'image size
      XPelsPerMeter As Long '0
      YPelsPerMeter As Long '0
      nic As Long '0        'nothing :)
      taky_nic As Long '0   'also nothing :)  i have none informations and none sources - for what is this!
   End Type

   Type IcIm 'help array (maybe? - this is wroted long time ago... :-/ )
      W As Integer
      H As Integer
      colors As _Unsigned _Byte
      BPP As _Unsigned _Byte
      L As Long
      Offset As Long
      WP As _Unsigned Integer
   End Type

   Dim FH As File_Head, IH As ICO_Head, II As Ico_Image
   ch = FreeFile
   If _FileExists(file$) = 0 Then
      Exit Function
   End If
   Open file$ For Binary As #ch
   Get #ch, , FH
   If FH.reserved = 0 And FH.id_Type = 1 Then
      ' nul
   Else
      ' Print "unknown format!"
      Exit Function
   End If
   frames = FH.id_Count
   If fram < 0 Then LOADICON& = frames: Exit Function ' -1 is for returning number frames in file
   If fram > frames Then
      Exit Function
   End If
   ReDim Ico(frames) As IcIm
   For al_fr = 1 To frames
      Get #ch, , IH
      Ico(al_fr).W = IH.bWidth
      Ico(al_fr).H = IH.bHeight
      Ico(al_fr).colors = IH.color_count '0 = >256 colors
      Ico(al_fr).BPP = IH.wBitCount 'bites per pixel
      Ico(al_fr).L = IH.dwBytesInRes 'image lenght included palette
      Ico(al_fr).Offset = IH.dwImageOffset + 1 'icon record byte start position from file begin
      If IH.color_count = 0 Then IHcolor_count = 256 Else IHcolor_count = IH.color_count
      Ico(al_fr).WP = IHcolor_count
   Next al_fr

   If fram = 0 Then vs = 1: ve = frames Else vs = fram: ve = fram
   For all = vs To ve
      Seek #ch, Ico(all).Offset 'posun na spravnou pozici       skip to correct position

      If Ico(all).BPP = 32 Then ' nejprve otestuju pritomnost PNG pokud je hloubka 32 bit: 'first testing, if PNG is contained in file, when bites per pixel is 32
         current_position = Seek(ch)
         Dim start_test As String * 8
         '            DIM end_test AS STRING * 12
         start$ = Chr$(137) + Chr$(80) + Chr$(78) + Chr$(71) + Chr$(13) + Chr$(10) + Chr$(26) + Chr$(10)
         Get #ch, , start_test$
         If start_test$ = start$ Then
            Ico(all).BPP = 32
            Ico(all).W = 256
            Ico(all).H = 256
            icon& = _CopyImage(extract_png&(ch), 32): GoTo skip
         Else
            Seek #ch, current_position
         End If
      End If
      Get #ch, , II

      If Ico(all).BPP > 0 And Ico(all).BPP <= 8 Then depth = 256 Else depth = 32
      If Ico(all).W = 0 Then Ico(all).W = 256
      If Ico(all).H = 0 Then Ico(all).H = 256

      icon& = _NewImage(Ico(all).W, Ico(all).H, depth)
      _Dest icon&

      Select Case Ico(all).BPP '   za havou bitmapy nasleduje paleta   After bitmap header is palette
         Case 1
            PalLenght = 1
         Case 4
            PalLenght = 15 'ok pro 4 barvy  OK for 4 colors
         Case 8
            PalLenght = 255
         Case 0, 32
            GoTo noPalete
      End Select

      ReDim pal As _Unsigned Long
      For palete = 0 To PalLenght
         Get #ch, , pal
         _PaletteColor palete, pal, icon&
      Next palete
      noPalete:
      Select Case Ico(all).BPP
         Case 1
            ReDim bwi As String, valuee As _Unsigned _Byte
            For draw1 = 1 To Ico(all).W * Ico(all).H
               Get #ch, , valuee
               bwi = bwi + DECtoBIN$(valuee)
            Next
            drawX = 0
            drawY = Ico(all).H
            For DrawXOR = 1 To Ico(all).W * Ico(all).H
               If (Mid$(bwi$, DrawXOR, 1)) = "1" Then PSet (drawX, drawY)
               drawX = drawX + 1: If drawX >= Ico(all).W And Ico(all).H Mod 4 = 0 Then drawX = 0: drawY = drawY - 1
            Next
         Case 4
            Dim R4 As _Unsigned _Byte
            binary$ = ""
            For READ_XOR_DATA = 1 To (Ico(all).W * Ico(all).H) / 2
               Get #ch, , R4
               binary$ = binary$ + DECtoBIN$(R4)
            Next READ_XOR_DATA
            Dim colors4(Len(binary$)) As _Byte
            calc_color = 0
            For calc_colors = 1 To Len(binary$) Step 4
               colors4(calc_color) = BINtoDEC(Mid$(binary$, calc_colors, 4))
               calc_color = calc_color + 1
            Next calc_colors
            binary$ = ""
            clc = 0
            drawX = -1
            drawY = Ico(all).H - 1
            For DrawXOR = 0 To Ico(all).W * Ico(all).H
               drawX = drawX + 1: If drawX >= Ico(all).W And Ico(all).H Mod 8 = 0 Then drawX = 0: drawY = drawY - 1
               If drawX < Ico(all).W Then PSet (drawX, drawY), colors4(clc): clc = clc + 1
            Next
            Erase colors4: binary$ = ""
            AndMaskLen = (Ico(all).H * Ico(all).W) / 8
            For AM = 1 To AndMaskLen
               Get #ch, , R4
               binary$ = binary$ + DECtoBIN$(R4)
            Next AM
            clc = 0
            For DrawAND = 0 To Ico(all).W * Ico(all).H
               drawX = drawX + 1: If drawX >= Ico(all).W And Ico(all).H Mod 8 = 0 Then drawX = 0: drawY = drawY - 1
               If drawX <= Ico(all).W And Mid$(binary$, clc, 1) = "1" Then
                  _Source icon&
                  cur = Point(drawX, drawY)
                  PSet (drawX, drawY), 255 And cur: clc = clc + 1
               End If
            Next
            _Source 0
         Case 8
            ReDim colors8(Ico(all).H * Ico(all).W) As _Unsigned _Byte
            For calc_colors = 1 To Ico(all).H * Ico(all).W
               Get #ch, , colors8(calc_colors)
            Next calc_colors
            binary$ = ""
            AndMaskLen = (Ico(all).H * Ico(all).W) / 8 'predelavano
            ReDim r5 As _Unsigned _Byte
            For AM = 1 To AndMaskLen
               Get #ch, , r5
               binary$ = binary$ + DECtoBIN$(r5)
            Next AM
            clc = 0
            For draw_itY = 1 To Ico(all).H
               For draw_itX = 0 To Ico(all).W - 1
                  clc = clc + 1
                  _Source icon&
                  cur = Point(draw_itX + 1, draw_itY)
                  PSet (draw_itX, Ico(all).H - draw_itY), colors8(clc) ' XOR cur
            Next: Next
            drawY = Ico(all).H - 1
            clc = 0
            For DrawAND = 1 To Ico(all).W * Ico(all).H
               drawX = drawX + 1: If drawX >= Ico(all).W And Ico(all).H Mod 4 = 0 Then drawX = 0: drawY = drawY - 1
               clrr = Point(drawX, drawY)
               clc = clc + 1
               If Mid$(binary$, clc, 1) = "1" Then PSet (drawX, drawY), 255 And clrr
            Next
            _Source 0
         Case 0, 32
            ReDim cache(1 To Ico(all).W, 1 To Ico(all).H) As _Unsigned Long
            For draw_itY = 1 To Ico(all).H
               For draw_itX = 1 To Ico(all).W
                  Get #ch, , cache(draw_itX, draw_itY)
            Next: Next
            For draw_itY = 1 To Ico(all).H
               For draw_itX = 1 To Ico(all).W
                  PSet (draw_itX - 1, Ico(all).H - draw_itY), cache(draw_itX, draw_itY)
            Next: Next
            Erase cache
      End Select

      skip:
      _Dest PD
      If fram = 0 Then 'function paramter 0 as fram is for view all images in ico file (my loop muss be in 32 bit graphic mode)
         If _PixelSize(_Dest) < 4 Then
            Exit Function
         End If
         resetview:
         'If listed = 0 Then listed = 1: Cls: _PrintString (300, 20), "    Image nr.   Width   Height    BPP    Color count": row = 40
         'If _Height - (row + 10) < 256 Then _PrintString (50, row + 100), "Press key for view next...": Sleep: Cls: listed = 0: GoTo resetview
         _PutImage (50, row), icon&, 0
         _FreeImage icon&
         row = row + Ico(all).H + 10
         info$ = "  " + Str$(all) + "      " + Str$(Ico(all).W) + "      " + Str$(Ico(all).H) + "    " + Str$(Ico(all).BPP) + "         " + Str$(Ico(all).WP)
         '_PrintString (350, row - (Ico(all).H + 10 / 2)), info$
      Else
         If all = fram Then
            LOADICON& = icon&
            _Dest PD
            Exit Function
         Else
            _FreeImage icon&
         End If
      End If
   Next all
End Function

Function DECtoBIN$ (vstup)
   For rj = 7 To 0 Step -1
      If vstup And 2 ^ rj Then DECtoBI$ = DECtoBI$ + "1" Else DECtoBI$ = DECtoBI$ + "0"
   Next rj
   DECtoBIN$ = DECtoBI$
End Function

Function BINtoDEC (b As String)
   For SI = 1 To Len(b)
      e$ = Mid$(b$, SI, 1)
      c = Val(e$) '
      Sj = Len(b) - SI
      BINtoDE = BINtoDE + (c * 2 ^ Sj)
   Next SI
   BINtoDEC = BINtoDE
End Function

Function extract_png& (ch) 'Warning. This function can be very easy used for extraction PNG files from all (also binary) files!
   start$ = Chr$(137) + Chr$(80) + Chr$(78) + Chr$(71) + Chr$(13) + Chr$(10) + Chr$(26) + Chr$(10) 'PNG start ID string
   eend$ = Chr$(0) + Chr$(0) + Chr$(0) + Chr$(0) + Chr$(73) + Chr$(69) + Chr$(78) + Chr$(68) + Chr$(174) + Chr$(66) + Chr$(96) + Chr$(130) 'PNG end ID string
   Seek #ch, Seek(ch) - 8
   Z = Seek(ch)
   Dim scan As String * 12
   Do
      Get #ch, , scan$
      If scan$ = eend$ Then Exit Do
      Seek #ch, Seek(ch) - 11
   Loop
   K = Seek(ch)
   png$ = Space$(K - Z)
   Seek #ch, Z
   Get #ch, , png$
   swp = FreeFile
   Temp$ = "external.tmp"
   Open Temp$ For Output As #swp
   Close #swp
   Open Temp$ For Binary As #swp
   Put #swp, , png$
   Close #swp
   extract_png& = _LoadImage(Temp$, 32)
   f$ = Temp$ + Chr$(0)
   x = DeleteFileA(f$)
   png$ = ""
End Function

Sub DisplayIcon (Var$)
   Icon$ = UCase$(Var$)
   If Right$(Icon$, 4) = ".ICO" Then
      If _FileExists(Icon$) Then
         Icon& = LOADICON&(Icon$, 1)
         If Icon& < -1 Then
            _Icon Icon&
            _FreeImage Icon&
         End If
      End If
   Else
      Icon& = _LoadImage(Icon$, 32)
      If Icon& < -1 Then
         _Icon Icon&
         _FreeImage Icon&
      End If
   End If
End Sub

' cycle splash screen moon.
Sub CallSplash
   Static x As Integer
   x = x + 1
   If x = 5 Then x = 1
   Call AnsiScreen(x)
End Sub

Rem Ansi screen blanker/copyright screen display utility v1.5a

Rem Input VarY is:
Rem  0 = ansi ship screen
Rem  1 = white moon
Rem  2 = red moon
Rem  3 = blue moon
Rem  4 = green skull moon

Sub AnsiScreen (VarY)
   ' display screen blanker
   Select Case VarY
      Case 1
         Color 15
         GoTo New.Moon
      Case 2
         Color 12
         GoTo New.Moon
      Case 3
         Color 9
         GoTo New.Moon
      Case 4
         GoTo Skull.Moon
   End Select
   Cls
   Color 12
   Print Space$(4);
   Color 7
   Print "";
   Color 8
   Print ""; Space$(15);
   Color 7
   Print ""; Space$(25);
   Color 8
   Print "       ";
   Color 7
   Print ""; Space$(6); "        ";
   Color 8
   Print "";
   Color 7
   Print ""
   Print Space$(6);
   Color 8
   Print "";
   Color 7
   Print ""; Space$(10);
   Color 8
   Print " "; Space$(8);
   Color 7
   Print "      ";
   Color 15
   Print "ܲ   ";
   Color 7
   Print " ";
   Color 8
   Print ""; Space$(15);
   Color 15
   Print "Welcome To";
   Color 8
   Print " ";
   Color 7
   Print ""
   Print "    ";
   Color 8
   Print " ";
   Color 7
   Print ""; Space$(9);
   Color 8
   Print " "; Space$(12);
   Color 15
   Print " ۲۲    ";
   Color 8
   Print " "; Space$(6);
   Color 15
   Print "HexEdit Version "; Version$
   Print Space$(5);
   Color 8
   Print ""; Space$(9);
   Color 7
   Print "  ";
   Color 8
   Print "  ";
   Color 7
   Print ". ";
   Color 15
   Print " ";
   Color 8
   Print "     ";
   Color 15
   Print "߲۲"; Space$(6);
   Color 8
   Print "    ";
   Color 7
   Print ""; Space$(6);

   Color 15
   Print "Release "; Release$

   Print "  ";
   Color 15
   Print ".      ";
   Color 7
   Print "  "; Space$(6); " ";
   Color 8
   Print "  ";
   Color 7
   Print " . ";
   Color 8
   Print ""; Space$(17);
   Color 7
   Print " ";
   Color 8
   Print ""; Space$(8);

   Color 15
   Print "  Tweak "; Tweak$

   Color 10
   Print "     ";
   Color 8
   Print "  "; Space$(8); "";
   Color 7
   Print "    ";
   Color 8
   Print "   ";
   Color 7
   Print "      ";
   Color 8
   Print "          ";
   Color 7
   Print ""; Space$(3);
   Color 15
   Print "  . "; YearRelease$; " .    "
   Print Space$(3);
   Color 10
   Print "";
   Color 2
   Print "";
   Color 10
   Print "  ";
   Color 8
   Print ""; Space$(6);
   Color 7
   Print "     ";
   Color 8
   Print "     "; Space$(13);
   Color 7
   Print ""; Space$(8);
   Color 8
   Print " ";
   Color 7
   Print ""; Space$(6);
   Color 15
   Print ".   "
   Print "  ";
   Color 10
   Print "";
   Color 2
   Print "";
   Color 10
   Print "";
   Color 2
   Print "";
   Color 10
   Print "";
   Color 15
   Print "    "; Space$(11);
   Color 8
   Print "  ";
   Color 7
   Print "  ";
   Color 8
   Print "  ";
   Color 7
   Print ". ";
   Color 15
   Print "   ";
   Color 6
   Print " ";
   Color 4
   Print "  ";
   Color 7
   Print "";
   Color 6
   Print "";
   Color 4
   Print ""; Space$(9);
   Color 7
   Print Space$(11)
   Print " ";
   Color 2
   Print ""; Space$(10);
   Color 7
   Print ""; Space$(7);
   Color 8
   Print "    "; Space$(6);
   Color 7
   Print "";
   Color 6
   Print "";
   Color 7
   Print "  ";
   Color 6
   Print ""; Space$(7); "";
   Color 4
   Print "  ";
   Color 8
   Print "";
   Color 7
   Print ""
   Color 10
   Print ""; Space$(17);
   Color 8
   Print "";
   Color 7
   Print "    ";
   Color 8
   Print "   ";
   Color 7
   Print "۲";
   Color 6
   Print "";
   Color 7
   Print " ܲ۲    ";
   Color 6
   Print "   ";
   Color 8
   Print " ";
   Color 7
   Print "";
   Color 8
   Print "  ";
   Color 7
   Print ". ";
   Color 15
   Print ""
   Color 2
   Print "۲"; Space$(14);
   Color 8
   Print "     ";
   Color 6
   Print "\";
   Color 7
   Print "۲";
   Color 6
   Print "";
   Color 7
   Print "۲۲۲  ۲";
   Color 6
   Print "";
   Color 7
   Print "   ";
   Color 15
   Print ""; Space$(7);
   Color 8
   Print "  ";
   Color 7
   Print " ."
   Color 10
   Print ""; Space$(8);
   Color 7
   Print "     ";
   Color 8
   Print "     ";
   Color 6
   Print "\\";
   Color 7
   Print "۲";
   Color 6
   Print "";
   Color 7
   Print " ";
   Color 7
   Print "\۲۲  ";
   Color 6
   Print "";
   Color 7
   Print "۲   ";
   Color 15
   Print "   ";
   Color 7
   Print ".    ";
   Color 8
   Print " "
   Color 2
   Print ""; Space$(13);
   Color 7
   Print "   ";
   Color 6
   Print "\\";
   Color 7
   Print " ";
   Color 6
   Print "";
   Color 7
   Print "\  \۲/ ";
   Color 6
   Print "";
   Color 7
   Print ""; Space$(9); "   ";
   Color 8
   Print ""
   Color 2
   Print "";
   Color 2
   Print "";
   Color 14
   Print ""; Space$(8);
   Color 7
   Print "   ";
   Color 6
   Print "\";
   Color 4
   Print "";
   Color 6
   Print "_";
   Color 7
   Print "\";
   Color 6
   Print "__";
   Color 7
   Print "\";
   Color 6
   Print "_";
   Color 7
   Print "/";
   Color 6
   Print "_";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6, 4
   Print "/";
   Color 15, 0
   Print Space$(5); "."
   Color 2
   Print "";
   Color 2
   Print "";
   Color 10
   Print "";
   Color 2
   Print "";
   Color 10
   Print "";
   Color 2
   Print "";
   Color 10
   Print "";
   Color 2
   Print "";
   Color 10
   Print "";
   Color 2
   Print "";
   Color 14
   Print "";
   Color 1
   Print "";
   Color 15, 1
   Print "";
   Color 1, 0
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6
   Print "";
   Color 4
   Print "";
   Color 6, 4
   Print "/";
   Color 1, 0
   Print "";
   Color 2
   Print "";
   Color 14
   Print "۲";
   Color 1
   Print "";
   Color 15, 1
   Print "";
   Color 1, 0
   Print "";
   Color 4
   Print "";
   Color 6, 4
   Print "/";
   Color 1, 0
   Print "";
   Color 2
   Print "۲۲۲";
   Color 14
   Print "۲";
   Color 1
   Print "";
   Color 15, 1
   Print "";
   Color 1, 0
   Print "";
   Color 4
   Print "";
   Color 6, 4
   Print "/";
   Color 1, 0
   Print "";
   Color 2
   Print "۲";
   Color 14
   Print "۲۲";
   Color 1
   Print "";
   Color , 7
   Print "";
   Color 15, 1
   Print "";
   Color 1, 0
   Print "";
   Color 14
   Print "";
   Color 2
   Print "";
   Color 14
   Print "";
   Color 1
   Print "";
   Color 15, 1
   Print "";
   Color 1, 7
   Print "";
   Color 15, 1
   Print "";
   Color 1, 0
   Print "";
   Color 14
   Print "";
   Color 2
   Print "";
   Color 14
   Print "";
   Color 1
   Print "";
   Color 15, 1
   Print "";
   Color 1, 7
   Print "";
   Color 15, 1
   Print "";
   Color 1, 0
   Print "";
   Color 14
   Print "";
   Color 2
   Print "";
   Color 14
   Print "";
   Color 2
   Print "";
   Color 14
   Print "";
   Color 2
   Print "";
   Color 14
   Print "";
   Color 7
   Locate 24, 1, 1
   Locate , , 0
   Exit Sub
   New.Moon:
   Locate 2, 37
   Print " ܲ"
   Locate 3, 37
   Print " ۲۲ "
   Locate 4, 37
   Print " ߲۲";
   Locate 24, 1, 1
   Locate , , 0
   Exit Sub
   Skull.Moon:
   Color 10
   Locate 2, 37
   Print " ܲ"
   Locate 3, 37
   Print " ";
   Color 15
   Print "\";
   Color 10
   Print "۲";
   Color 15
   Print "/";
   Color 10
   Print " "
   Locate 4, 37
   Print " ߲";
   Color 15
   Print "--";
   Color 10
   Print "";
   Locate 24, 1, 1
   Locate , , 0
End Sub

' stores config filename.
Function GetConfigFilename$
   Var$ = Environ$("PROGRAMFILES")
   If Len(Var$) = 0 Then
      Var$ = "C:\Program Files"
   End If
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   If Right$(Var$, 1) <> "\" Then
      Var$ = Var$ + "\"
   End If
   Var$ = Var$ + "Hexeditor"
   If _DirExists(Var$) = 0 Then
      f$ = Var$ + Chr$(0)
      x = CreateDirectoryA(f$, 0)
   End If
   Var$ = Var$ + "\" + "hexedit" + LTrim$(Str$(Node)) + ".cfg"
   GetConfigFilename$ = Var$
End Function

Sub ReadConfig
   WindowX = _ScreenX: WindowY = _ScreenY
   f$ = CurrentDirectory + "hexedit" + LTrim$(Str$(Node)) + ".cfg"
   ' init config file.
   If _FileExists(f$) = 0 Then
      Call WriteConfig
      Exit Sub
   End If
   ' open file for input.
   X = FreeFile
   Open f$ For Input As #X
   ' read values from file.
   If EOF(X) = 0 Then
      Input #X, WindowX
   End If
   If EOF(X) = 0 Then
      Input #X, WindowY
   End If
   Close X
End Sub

Sub WriteConfig
   ' avoid writing to LAN
   If Left$(CurrentDirectory, 2) = "\\" Then
      Exit Sub
   End If
   ' check drivetype
   V = Asc(UCase$(Left$(CurrentDirectory, 1))) - 64
   x = DRIVEEXISTS(V)
   ' can't write to cd-rom
   If DriveType = "[CDROM]" Then
      Exit Sub
   End If
   ' open file for output.
   x = FreeFile
   f$ = CurrentDirectory + "hexedit" + LTrim$(Str$(Node)) + ".cfg"
   Open f$ For Output As #x
   ' write values to file.
   Print #x, _ScreenX
   Print #x, _ScreenY
   Close x
End Sub

' var = 0 test file, 1 = create file, 2 = append file
Function CreateFileA& (Filename$, Var)
   If Var = 0 Then
      If _FileExists(Filename$) Then
         CreateFileA = -1
      Else
         CreateFileA = 0
      End If
   End If
   If Var = 1 Then
      If _FileExists(Filename$) Then
         CreateFileA = 0
      Else
         x = FreeFile
         Open Filename$ For Output As #x
         CreateFileA = -1
         Close x
      End If
   End If
   If Var = 2 Then
      If _FileExists(Filename$) Then
         CreateFileA = 0
      Else
         x = FreeFile
         Open Filename$ For Append As #x
         CreateFileA = -1
         Close x
      End If
   End If
End Function

Sub ViewFileInfo (Var$)
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATA
   Dim hfind As _Unsigned _Offset

   If InStr(Var$, "?") Then
      Var$ = Nul
      Exit Sub
   End If
   If InStr(Var$, "*") Then
      Var$ = Nul
      Exit Sub
   End If

   ' display file date/time.
   ASCIIZ = Var$ + Chr$(0)
   Var$ = Nul
   hfind = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
      Var$ = "Create: " + GetDateTime(z)
      x = FindClose(hfind)
   End If
End Sub

Sub ViewFileInfo2 (Var$)
   Dim ASCIIZ As String * 260
   Dim finddata As WIN32_FIND_DATA
   Dim hfind As _Unsigned _Offset
   Dim Attribute As Long
   If InStr(Var$, "?") Then
      Var$ = Nul
      Exit Sub
   End If
   If InStr(Var$, "*") Then
      Var$ = Nul
      Exit Sub
   End If

   ' display file date/time.
   ASCIIZ = Var$ + Chr$(0)
   Var$ = Nul
   hfind = FindFirstFileA(_Offset(ASCIIZ), _Offset(finddata))
   If hfind <> INVALID_HANDLE_VALUE Then
      Attribute = finddata.dwFileAttributes
      If (Attribute And &H1) = &H1 Then ' read-only
         Var$ = Var$ + "Read-Only "
      End If
      If (Attribute And &H2) = &H2 Then ' hidden
         Var$ = Var$ + "Hidden "
      End If
      If (Attribute And &H4) = &H4 Then ' system
         Var$ = Var$ + "System "
      End If
      If (Attribute And &H20) = &H20 Then ' archive
         Var$ = Var$ + "Archive"
      End If
      x = FindClose(hfind)
   End If
End Sub

Sub Amount (Var#, Var$)
   If Var# = 0# Then
      Var$ = " 0"
   Else
      If InStr(Str$(Var#), "D") Then
         Var$ = Str$(Var#)
      Else
         Var$ = " " + FormatString$(Var#, 0)
      End If
   End If
End Sub

Sub Back.Space
   Locate CsrLin, Pos(0) - 1, 0
   Print " ";
   Locate CsrLin, Pos(0) - 1, 1
End Sub

' function to match case-sensitive substring with ?, * characters in substring
'  Return Var = -1 if match
'  VarQ = -1 force case-sensitive
'  See if Var1$ exists in Var2$
Sub InstrSUB1 (Var, Var1$, Var2$, VarQ)

   ' store case-sensitive string match variables
   If VarQ Then
      S2$ = Var1$
      S3$ = Var2$
   Else
      S2$ = LCase$(Var1$)
      S3$ = LCase$(Var2$)
   End If

   ' check default instr
   If InStr(S2$, "*") = 0 Then
      If InStr(S2$, "?") = 0 Then
         Var = InStr(S3$, S2$)
         Exit Sub
      End If
   End If

   Var = -1 ' assume match

   ' see if S2$ matches in S3$ with substrings
   For S3 = 1 To Len(S3$)
      S1$ = Mid$(S3$, S3)
      P1 = 1 ' pointer to S1$
      P2 = 1 ' pointer to S2$
      Do
         ' check match
         If P2 > Len(S2$) Then
            Exit Sub
         End If

         ' check character in S2$ at P2
         V$ = Mid$(S2$, P2, 1)
         Select Case V$
            Case "*" ' global character
               ' scan to next char
               If P2 > Len(S2$) Then
                  Exit Do
               End If
               S4$ = Mid$(S2$, P2 + 1, 1)
               Select Case S4$
                  Case "*", "?"
                     P2 = P2 + 1
                  Case Else
                     Do
                        If Mid$(S1$, P1, 1) = S4$ Then
                           Exit Do
                        End If
                        If P1 >= Len(S1$) Then
                           Exit Do
                        End If
                        P1 = P1 + 1
                     Loop
                     P2 = P2 + 1
               End Select
            Case "?" ' wildcard character
               P1 = P1 + 1
               P2 = P2 + 1
            Case Else ' ascii character
               If Mid$(S1$, P1, 1) <> V$ Then ' no match
                  Exit Do
               End If
               P1 = P1 + 1
               P2 = P2 + 1
         End Select
      Loop
   Next
   Var = 0 ' no match
End Sub

Function IsNumeric (X$)
   For V = 1 To Len(X$)
      If Mid$(X$, V, 1) >= "0" And Mid$(X$, V, 1) <= "9" Then
         Eat$ = ""
      Else
         IsNumeric = 0
         Exit Function
      End If
   Next
   IsNumeric = -1
End Function

Sub Make.Format (Var#, Var$)
   Var2# = Var#
   If Var2# <= 0 Then
      Var$ = "0.00 B"
      Exit Sub
   End If
   TempA = False
   Do
      If Var2# < 1024# Then
         Exit Do
      End If
      Var2# = Var2# / 1024#
      TempA = TempA + 1
      If TempA = 8 Then
         Exit Do
      End If
   Loop
   Strng$ = ""
   If TempA >= 1 And TempA <= 8 Then
      Strng$ = Mid$("KMGTPEZY", TempA, 1)
   End If
   Var$ = FormatString$(Var2#, 0)
End Sub

Function DeconcatenateX$ (Var$)
   VarX$ = Var$
   If InStr(VarX$, ":") Then
      VarX$ = Mid$(VarX$, InStr(VarX$, ":") + 1)
   End If
   For VarX = Len(VarX$) To 1 Step -1
      If Mid$(VarX$, VarX, 1) = "\" Then
         VarX$ = Mid$(VarX$, VarX + 1)
         Exit For
      End If
   Next
   DeconcatenateX$ = VarX$
End Function

Rem Snall full screen editor for QB v1.0a 08/20/2022 PD.

Sub Scrnedit (OutX$)
   Const MaxInt = 32766 ' zero-based
   Const MaxLong = 2147483647
   Const Nul = ""
   Dim VarX As String * 1
   Dim VarY As String * 1
   Dim LineX As String
   Dim Max.Row As Integer
   Dim Temp.ArrayS(1) As String
   Dim Max.Lines As Long
   Dim Max.File As Long
   Max.Row = 25
   Cls
   FilenameX$ = OutX$
   If Left$(FilenameX$, 1) = Quote Then
      FilenameX$ = Mid$(FilenameX$, 2)
      If Right$(FilenameX$, 1) = Quote Then
         FilenameX$ = Left$(FilenameX$, Len(FilenameX$) - 1)
      End If
   End If
   File5 = FreeFile
   Close #File5
   Control.Break = 0
   If FilenameX$ = "" Then
      Exit Sub
   End If
   If _FileExists(FilenameX$) Then
      Open FilenameX$ For Binary As #File5 ' read file in binary
      Max.Lines = 0
      Var& = 0&
      LineX = Nul
      VarD = False
      VarE = False
      VarF! = Timer
      Print "Edit file in Linux binary read mode(y/n)? ";
      Do
         _Limit 50
         X$ = InKey$
         If LCase$(X$) = "y" Then Print: LINUXLoad = -1: Exit Do
         If LCase$(X$) = "n" Then Print: LINUXLoad = 0: Exit Do
      Loop
      Do
         Var& = Var& + 1&
         If Var& > LOF(File5) Then
            If Len(LineX) Then
               If Max.Lines >= MaxLong Then
                  Print "Out of memory."
                  Close #File5
                  Erase Temp.ArrayS
                  Exit Sub
               End If
               Max.Lines = Max.Lines + 1
               ReDim _Preserve Temp.ArrayS(Max.Lines) As String
               Temp.ArrayS(Max.Lines) = LineX
            End If
            Exit Do
         End If
         Get #File5, Var&, VarX
         If Control.Break Then
            Control.Break = False
            Print "Program load halted."
            Close #File5
            Erase Temp.ArrayS
            Exit Sub
         End If
         LineFeed = 0
         If LINUXLoad Then
            If VarX = Chr$(10) Then
               LineFeed = -1
            End If
         End If
         If VarX = Chr$(13) Then
            If Var& + 1& <= LOF(File5) Then
               Get #File5, Var& + 1&, VarY
               If VarY = Chr$(10) Then
                  Var& = Var& + 1&
                  LineFeed = -1
               End If
            End If
         End If
         If LineFeed Then
            If Max.Lines >= MaxLong Then
               Print "Out of memory."
               Close #File5
               Erase Temp.ArrayS
               Exit Sub
            End If
            Max.Lines = Max.Lines + 1
            ReDim _Preserve Temp.ArrayS(Max.Lines) As String
            Temp.ArrayS(Max.Lines) = LineX
            LineX = Nul
         Else
            LineX = LineX + VarX
         End If
      Loop
      Close #File5
      Max.File = Max.Lines
   End If
   Print
   If Max.Lines = 0 Then
      Max.File = 1
      Max.Lines = 1
      Line.Number = 1
      ReDim Temp.ArrayS(Max.Lines) As String
   End If
   Xcoor = 1
   Ycoor = 1
   Column = 1
   Row = 1
   Line.Number = 1
   Line.Length = 78
   GoSub Display.Screen
   Do
      V = Column + Ycoor - 1
      Var# = CDbl(Line.Number)
      If Var# = 0# Then
         Var$ = " 0"
      Else
         Call Amount(Var#, Var$)
      End If
      If V = 0 Then
         Var2$ = " 0"
      Else
         Call Amount(CDbl(V), Var2$)
      End If
      Strng$ = "Row" + Var$ + " Column" + Var2$

      If V > 0 And V <= Len(Temp.ArrayS(Line.Number)) Then
         V2 = Asc(Mid$(Temp.ArrayS(Line.Number), V, 1))
         Strng$ = Strng$ + " Ascii" + Str$(V2)

         Select Case V2
            Case 0
               Strng$ = Strng$ + " (nul)"
            Case 1
               Strng$ = Strng$ + " (soh)"
            Case 2
               Strng$ = Strng$ + " (stx)"
            Case 3
               Strng$ = Strng$ + " (etx)"
            Case 4
               Strng$ = Strng$ + " (eot)"
            Case 5
               Strng$ = Strng$ + " (enq)"
            Case 6
               Strng$ = Strng$ + " (ack)"
            Case 7
               Strng$ = Strng$ + " (bel)"
            Case 8
               Strng$ = Strng$ + " (bs)"
            Case 9
               Strng$ = Strng$ + " (tab)"
            Case 10
               Strng$ = Strng$ + " (lf)"
            Case 11
               Strng$ = Strng$ + " (vt)"
            Case 12
               Strng$ = Strng$ + " (np)"
            Case 13
               Strng$ = Strng$ + " (cr)"
            Case 14
               Strng$ = Strng$ + " (so)"
            Case 15
               Strng$ = Strng$ + " (si)"
            Case 16
               Strng$ = Strng$ + " (dle)"
            Case 17
               Strng$ = Strng$ + " (dc1)"
            Case 18
               Strng$ = Strng$ + " (dc2)"
            Case 19
               Strng$ = Strng$ + " (dc3)"
            Case 20
               Strng$ = Strng$ + " (dc4)"
            Case 21
               Strng$ = Strng$ + " (nak)"
            Case 22
               Strng$ = Strng$ + " (syn)"
            Case 23
               Strng$ = Strng$ + " (etb)"
            Case 24
               Strng$ = Strng$ + " (can)"
            Case 25
               Strng$ = Strng$ + " (em)"
            Case 26
               Strng$ = Strng$ + " (eof)"
            Case 27
               Strng$ = Strng$ + " (esc)"
            Case 28
               Strng$ = Strng$ + " (fs)"
            Case 29
               Strng$ = Strng$ + " (gs)"
            Case 30
               Strng$ = Strng$ + " (rs)"
            Case 31
               Strng$ = Strng$ + " (us)"
            Case 32
               Strng$ = Strng$ + " (spc)"
            Case 255
               Strng$ = Strng$ + " (?)"
            Case Else
               Strng$ = Strng$ + " (" + Chr$(V2) + ")"
         End Select
      End If

      Color 14, 1
      Locate Max.Row - 1, 1
      Print Space$(80);

      Strng$ = Left$(Strng$, 40)
      Strng$ = Strng$ + Space$(40 - Len(Strng$))

      VarZ$ = OutX$
      If InStr(VarZ$, ":") Then VarZ$ = Mid$(VarZ$, InStr(VarZ$, ":") + 1)
      For Q = Len(VarZ$) To 1 Step -1
         If Mid$(VarZ$, Q, 1) = "\" Then
            VarZ$ = Mid$(VarZ$, Q + 1)
            Exit For
         End If
      Next

      Strng$ = Strng$ + " File: " + VarZ$
      Strng$ = Left$(Strng$, 80)

      Color 14, 1
      Locate Max.Row - 1, 1
      Print Strng$;

      Locate Xcoor, Ycoor, 1
      Color 15, 0
      TempX$ = ""
      Do While TempX$ = ""
         _Limit 50
         TempX$ = InKey$
      Loop
      Select Case Len(TempX$)
         Case 1
            Select Case TempX$
               Case Chr$(18) ' ctrl-r = searchreplace
                  GoSub Replace.String
               Case Chr$(6) ' search string (ctrl-f)
                  If Max.Lines > 0 Then
                     GoSub Search.String
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case Chr$(10) ' jump to byte (ctrl-j)
                  If Max.Lines > 0 Then
                     GoSub Jump.Byte
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case Chr$(7) ' goto to line (ctrl-g)
                  If Max.Lines > 0 Then
                     GoSub Jump.Line
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case Chr$(13) ' insert line
                  ' always increases array
                  If Max.File < MaxLong Then
                     Max.File = Max.File + 1
                     ReDim _Preserve Temp.ArrayS(Max.File) As String
                     ' above
                     If Column + Ycoor - 1 = 1 Then
                        For Temp1 = Max.Lines To Line.Number Step -1
                           Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                        Next
                        Temp.ArrayS(Line.Number) = Nul
                        Line.Number = Line.Number + 1
                        Max.Lines = Max.Lines + 1
                        If Xcoor < Max.Row - 2 Then
                           Xcoor = Xcoor + 1
                        End If
                     Else
                        ' below
                        If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                           Line.Number = Line.Number + 1 ' below
                           For Temp1 = Max.Lines To Line.Number Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           Temp.ArrayS(Line.Number) = Nul
                           If Xcoor < Max.Row - 2 Then
                              Xcoor = Xcoor + 1
                           End If
                           Max.Lines = Max.Lines + 1
                        Else
                           ' split line
                           For Temp1 = Max.Lines To Line.Number + 1 Step -1
                              Temp.ArrayS(Temp1 + 1) = Temp.ArrayS(Temp1)
                           Next
                           T$ = Temp.ArrayS(Line.Number)
                           U$ = Mid$(T$, Column + Ycoor - 1)
                           T$ = Left$(T$, Column + Ycoor - 2)
                           Temp.ArrayS(Line.Number) = T$
                           Line.Number = Line.Number + 1 ' below
                           Temp.ArrayS(Line.Number) = U$
                           If Xcoor < Max.Row - 2 Then
                              Xcoor = Xcoor + 1
                           End If
                           Max.Lines = Max.Lines + 1
                        End If
                     End If
                  End If
                  Column = 1
                  Ycoor = 1
                  GoSub Display.Screen
               Case Chr$(8) ' backspace
                  Q = Column + Ycoor - 1
                  If Line.Number <= 1 And Q <= 1 Then ' no backspace at 1,1
                     Eat$ = Nul
                  Else
                     ' remove current line
                     If Temp.ArrayS(Line.Number) = Nul Then
                        ' pack array
                        For Temp1 = Line.Number To Max.Lines - 1
                           Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                        Next
                        If Xcoor > 1 Then
                           Xcoor = Xcoor - 1
                        End If
                        Line.Number = Line.Number - 1
                        Max.Lines = Max.Lines - 1
                        ' position at eol
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= 80 Then
                           Column = End.Line - 78
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     Else
                        ' concatenate previous line
                        If Column + Ycoor - 1 <= 1 Then
                           If Line.Number > 1 Then
                              If Line.Number <= Max.Lines Then
                                 Var = 0
                                 If Temp.ArrayS(Line.Number - 1) = Nul Then
                                    If Ycoor = 1 Then
                                       Var = -1
                                    End If
                                 End If

                                 ' position at eol
                                 If Var = 0 Then
                                    End.Line = Len(Temp.ArrayS(Line.Number - 1))
                                 End If

                                 Temp.ArrayS(Line.Number - 1) = Temp.ArrayS(Line.Number - 1) + Temp.ArrayS(Line.Number)
                                 For Temp1 = Line.Number To Max.Lines - 1
                                    Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                                 Next
                                 If Xcoor > 1 Then
                                    Xcoor = Xcoor - 1
                                 End If
                                 Line.Number = Line.Number - 1
                                 Max.Lines = Max.Lines - 1
                                 Column = 1
                                 Ycoor = 1

                                 ' position at eol
                                 If Var = 0 Then
                                    If End.Line >= 80 Then
                                       Column = End.Line - 78
                                       Ycoor = End.Line - Column + 2
                                    Else
                                       Ycoor = End.Line - Column + 2
                                    End If
                                 End If

                                 GoSub Display.Screen
                              End If
                           End If
                        Else
                           ' backspace 1 character
                           If Column + Ycoor - 2 > False Then
                              T$ = Temp.ArrayS(Line.Number)
                              T$ = Left$(T$, Column + Ycoor - 3) + Mid$(T$, Column + Ycoor - 1)
                              Temp.ArrayS(Line.Number) = T$
                              ' move cursor 1 left
                              If Ycoor > 1 Then
                                 Ycoor = Ycoor - 1
                                 GoSub Display.Screen
                              Else
                                 If Column > 1 Then
                                    Column = Column - 1
                                    GoSub Display.Screen
                                 End If
                              End If
                           End If
                        End If
                     End If
                  End If
               Case Chr$(9) ' tab
                  If Column + Ycoor + 7 <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor + 8 < 80 Then
                        Ycoor = Ycoor + 8
                     Else
                        Column = Column + 8
                        GoSub Display.Screen
                     End If
                  Else ' end
                     End.Line = Len(Temp.ArrayS(Line.Number))
                     If End.Line >= 80 Then
                        Column = End.Line - 78
                        Ycoor = End.Line - Column + 2
                        GoSub Display.Screen
                     Else
                        Ycoor = End.Line - Column + 2
                     End If
                  End If
               Case Chr$(27) ' escape, exit editor
                  Exit Do
               Case Else ' insert character
                  If Line.Number > 0 Then
                     T$ = Temp.ArrayS(Line.Number)
                     T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
                     Temp.ArrayS(Line.Number) = T$
                     If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                        If Ycoor < 80 Then
                           Ycoor = Ycoor + 1
                           GoSub Display.Screen
                        Else
                           Column = Column + 1
                           GoSub Display.Screen
                        End If
                     End If
                  End If
            End Select
         Case 2
            Temp = Asc(Mid$(TempX$, 2, 1))
            Select Case Temp
               Case 96 ' Ctrl-F3 - repeat replace
                  If Search$ = Nul Then
                     GoSub Replace.String
                  Else
                     GoSub Replace.String2
                  End If
               Case 61 ' F3 - continue search
                  If Max.Lines > 0 Then
                     If LastSearchLine& = 0& Then ' init search
                        GoSub Search.String
                     Else
                        GoSub Search.String2
                     End If
                     If VarX2 Then
                        Line.Number = Count&
                        If Line.Number <= Max.Row - 2 Then
                           Xcoor = Line.Number
                        Else
                           Xcoor = 1
                        End If
                        Ycoor = 1
                        Column = 1
                     End If
                  End If
                  Color 15, 0
                  GoSub Display.Screen
               Case 15 ' shift-tab
                  If Column + Ycoor - 8 > 0 Then
                     If Column + Ycoor - 7 > 1 Then
                        Ycoor = Ycoor - 7
                     Else
                        If Column > 8 Then
                           Column = Column - 7
                           GoSub Display.Screen
                        End If
                     End If
                  Else ' home
                     If Column > 1 Then
                        Column = 1
                        Ycoor = 1
                        GoSub Display.Screen
                     Else
                        Column = 1
                        Ycoor = 1
                     End If
                  End If
               Case 83, 147 ' delete/control-delete
                  Q = Column + Ycoor - 1
                  ' no delete at 1,1
                  If (Line.Number <= 1 And Q < 1) Or Max.Lines < 1 Then
                     Eat$ = Nul
                  Else
                     ' remove line
                     If Temp.ArrayS(Line.Number) = Nul Then
                        If Line.Number = 1 And Max.Lines = 1 Then ' 1,1
                           Eat$ = Nul
                        Else
                           ' pack array
                           For Temp1 = Line.Number To Max.Lines - 1
                              Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                           Next
                           If Line.Number = Max.Lines Then
                              Line.Number = Line.Number - 1
                              If Xcoor > 1 Then
                                 Xcoor = Xcoor - 1
                              End If
                           End If
                           Max.Lines = Max.Lines - 1
                           Column = 1
                           Ycoor = 1
                           GoSub Display.Screen
                        End If
                     Else
                        ' delete line
                        If Len(Temp.ArrayS(Line.Number)) < 1 Then
                           Temp.ArrayS(Line.Number) = Nul
                           GoSub Display.Screen
                        Else
                           ' concatenate line
                           If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then
                              If Line.Number + 1 <= Max.Lines Then
                                 T$ = Temp.ArrayS(Line.Number)
                                 T$ = T$ + Temp.ArrayS(Line.Number + 1)
                                 Temp.ArrayS(Line.Number) = T$

                                 ' pack array
                                 For Temp1 = Line.Number + 1 To Max.Lines - 1
                                    Temp.ArrayS(Temp1) = Temp.ArrayS(Temp1 + 1)
                                 Next
                                 Max.Lines = Max.Lines - 1

                                 GoSub Display.Screen
                              End If
                           Else
                              ' delete character
                              T$ = Temp.ArrayS(Line.Number)
                              T$ = Left$(T$, Column + Ycoor - 2) + Mid$(T$, Column + Ycoor)
                              Temp.ArrayS(Line.Number) = T$
                              GoSub Display.Screen
                           End If
                        End If
                     End If
                  End If
               Case 71 ' home
                  If Column > 1 Then
                     Column = 1
                     Ycoor = 1
                     GoSub Display.Screen
                  Else
                     Column = 1
                     Ycoor = 1
                  End If
               Case 79 ' end
                  End.Line = Len(Temp.ArrayS(Line.Number))
                  If End.Line >= 80 Then
                     Column = End.Line - 78
                     Ycoor = End.Line - Column + 2
                     GoSub Display.Screen
                  Else
                     Ycoor = End.Line - Column + 2
                  End If
               Case 75, 155 ' left/alt-left
                  If Ycoor > 1 Then
                     Ycoor = Ycoor - 1
                  Else
                     If Column > 1 Then
                        Column = Column - 1
                        GoSub Display.Screen
                     End If
                  End If
               Case 77, 157 ' right/alt-right
                  If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                     If Ycoor < 80 Then
                        Ycoor = Ycoor + 1
                     Else
                        Column = Column + 1
                        GoSub Display.Screen
                     End If
                  End If
                  ' Up/Ctrl-Up/Alt-Up/Ctrl--,Alt-- = MoveUp
               Case 72, 141, 152, 142, 74, 130
                  Var = 0
                  If Line.Number > 1 Then
                     Line.Number = Line.Number - 1
                     If Xcoor = 1 Then
                        Var = -1
                     Else
                        Xcoor = Xcoor - 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
                  ' Down/Ctrl-Down/Alt-Down/Ctrl-+/Alt-= = MoveDown
               Case 80, 145, 160, 144, 78, 131
                  Var = 0
                  If Line.Number < Max.Lines Then
                     Line.Number = Line.Number + 1
                     If Xcoor >= Max.Row - 2 Then
                        Var = -1
                     Else
                        Xcoor = Xcoor + 1
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     If Var Then
                        GoSub Display.Screen
                     End If
                  End If
               Case 73, 132 ' pageup/ctrl-pageup
                  If Line.Number > 1 Then
                     If Line.Number - 22 > 1 Then
                        Line.Number = Line.Number - 22
                     Else
                        Line.Number = 1
                     End If
                     Xcoor = 1
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 81, 118 ' pagedown/ctrl-pagedn
                  If Line.Number < Max.Lines Then
                     If Line.Number + 22 < Max.Lines Then
                        Line.Number = Line.Number + 22
                        Xcoor = 1
                     Else
                        Line.Number = Max.Lines
                        If Max.Lines < Max.Row - 3 Then
                           Xcoor = Max.Lines
                        Else
                           Xcoor = Max.Row - 3
                        End If
                     End If
                     End.Line = Len(Temp.ArrayS(Line.Number)) + 1
                     If Column + Ycoor - 1 > End.Line Then
                        Ycoor = End.Line - Column + 1
                        If Ycoor <= 0 Then
                           Ycoor = End.Line
                           If Column > 1 Then
                              Var = -1
                           End If
                           Column = 1
                        End If
                     End If
                     GoSub Display.Screen
                  End If
               Case 116 ' control-right
                  If Column + Ycoor - 1 > Len(Temp.ArrayS(Line.Number)) Then ' eol
                     If Line.Number + 1 <= Max.Lines Then
                        Line.Number = Line.Number + 1
                        If Xcoor = Max.Row - 3 Then
                           Var = True
                        Else
                           Xcoor = Xcoor + 1
                        End If
                        Ycoor = 1
                        Column = 1
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     For Temp2 = Column + Ycoor - 1 To Len(Temp.ArrayS(Line.Number))
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              Exit For
                           End If
                        End If
                     Next
                     'shift right
                     For Var3 = 1 To P
                        If Ycoor < 80 Then
                           Ycoor = Ycoor + 1
                        Else
                           Column = Column + 1
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 115 ' control-left
                  If Column + Ycoor - 1 <= 1 Then
                     If Line.Number > 1 Then
                        Line.Number = Line.Number - 1
                        If Xcoor = 1 Then
                           Var = True
                        Else
                           Xcoor = Xcoor - 1
                        End If
                        End.Line = Len(Temp.ArrayS(Line.Number))
                        If End.Line >= 80 Then
                           Column = End.Line - 78
                           Ycoor = End.Line - Column + 2
                        Else
                           Ycoor = End.Line - Column + 2
                        End If
                        GoSub Display.Screen
                     End If
                  Else
                     P = 0
                     V = 0
                     For Temp2 = Column + Ycoor - 3 To 1 Step -1
                        P = P + 1
                        If Mid$(Temp.ArrayS(Line.Number), Temp2, 1) = " " Then
                           If Mid$(Temp.ArrayS(Line.Number), Temp2 + 1, 1) <> " " Then
                              V = -1
                              Exit For
                           End If
                        End If
                     Next
                     If V = 0 Then
                        P = P + 1
                     End If
                     ' shift left
                     For Var3 = 1 To P
                        If Ycoor > 1 Then
                           Ycoor = Ycoor - 1
                        Else
                           If Column > 1 Then
                              Column = Column - 1
                           End If
                        End If
                     Next
                     GoSub Display.Screen
                  End If
               Case 119 ' control-home
                  If Max.Lines > 0 Then
                     Line.Number = 1
                     Xcoor = 1
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
               Case 117 ' control-end
                  If Max.Lines > 0 Then
                     Line.Number = Max.Lines
                     If Max.Lines < Max.Row - 3 Then
                        Xcoor = Max.Lines
                     Else
                        Xcoor = Max.Row - 3
                     End If
                     Ycoor = 1
                     Column = 1
                     GoSub Display.Screen
                  End If
               Case 82 ' insert
                  If Line.Number > 0 Then
                     Var = False
                     Ascii$ = Nul
                     GoSub Display.Ascii.Line
                     Do
                        Var$ = Nul
                        Do
                           _Limit 50
                           Var$ = InKey$
                           If Len(Var$) Then
                              Exit Do
                           End If
                        Loop
                        If Len(Var$) = 1 Then
                           If Var$ = Chr$(8) Then
                              If Len(Ascii$) > 0 Then
                                 Ascii$ = Left$(Ascii$, Len(Ascii$) - 1)
                                 GoSub Display.Ascii.Line
                                 Var = Var - 1
                                 Locate Max.Row - 1, 27
                                 Print Ascii$ + " ";
                                 Locate Max.Row - 1, 27
                                 Print Ascii$;
                              End If
                           End If
                           If Var$ = Chr$(13) Then
                              Exit Do
                           End If
                           If LCase$(Var$) = "x" Or LCase$(Var$) = "o" Or LCase$(Var$) = "b" Then
                              If Var = 0 Then
                                 Ascii$ = Ascii$ + LCase$(Var$)
                                 GoSub Display.Ascii.Line
                                 Var = Var + 1
                                 Locate Max.Row - 1, 26 + Var
                                 Strng$ = LCase$(Var$)
                                 Print Strng$;
                              End If
                           End If
                           If LCase$(Var$) >= "a" And LCase$(Var$) <= "f" Then
                              If Var >= 1 And Var < 3 Then
                                 If Left$(Ascii$, 1) = "x" Then
                                    Var = Var + 1
                                    Locate Max.Row - 1, 26 + Var
                                    Strng$ = Var$
                                    Print Strng$;
                                    Ascii$ = Ascii$ + Var$
                                 End If
                              End If
                           End If
                           If Left$(Ascii$, 1) = "o" Then
                              If Var$ >= "0" And Var$ <= "7" Then
                                 If Var < 4 Then
                                    Var = Var + 1
                                    Locate Max.Row - 1, 26 + Var
                                    Strng$ = Var$
                                    Print Strng$;
                                    Ascii$ = Ascii$ + Var$
                                 End If
                              End If
                           Else
                              If Left$(Ascii$, 1) = "b" Then
                                 If Var$ = "0" Or Var$ = "1" Then
                                    If Var < 9 Then
                                       Var = Var + 1
                                       Locate Max.Row - 1, 26 + Var
                                       Strng$ = Var$
                                       Print Strng$;
                                       Ascii$ = Ascii$ + Var$
                                    End If
                                 End If
                              Else
                                 If Var$ >= "0" And Var$ <= "9" Then
                                    If Var < 3 Then
                                       Var = Var + 1
                                       Locate Max.Row - 1, 26 + Var
                                       Print Var$;
                                       Ascii$ = Ascii$ + Var$
                                    End If
                                 End If
                              End If
                           End If
                        End If
                     Loop
                     Color 15, 0

                     ' insert ascii character
                     If Left$(Ascii$, 1) = "x" Then
                        Ascii.Value = Int(Val("&H" + Mid$(Ascii$, 2)))
                     Else
                        If Left$(Ascii$, 1) = "o" Then
                           Ascii.Value = Int(Val("&O" + Mid$(Ascii$, 2)))
                        Else
                           If Left$(Ascii$, 1) = "b" Then ' binary
                              Ascii$ = Mid$(Ascii$, 2)
                              GoSub Binary.String
                           Else
                              Ascii.Value = Int(Val(Ascii$))
                           End If
                        End If
                     End If
                     If Ascii.Value >= 0 And Ascii.Value <= 255 Then
                        TempX$ = Chr$(Ascii.Value)
                        T$ = Temp.ArrayS(Line.Number)
                        T$ = Left$(T$, Column + Ycoor - 2) + TempX$ + Mid$(T$, Column + Ycoor - 1)
                        Temp.ArrayS(Line.Number) = T$
                        If Column + Ycoor - 1 <= Len(Temp.ArrayS(Line.Number)) Then
                           If Ycoor < 80 Then
                              Ycoor = Ycoor + 1
                              GoSub Display.Screen
                           Else
                              Column = Column + 1
                              GoSub Display.Screen
                           End If
                        End If
                     End If
                  End If
            End Select
      End Select
   Loop
   Color 15, 0
   Cls
   Locate Max.Row - 1, 1
   Q = 0
   Print "Write "; FilenameX$; " to disk(y/n)? ";
   Do
      _Limit 50
      Char$ = InKey$
      Char$ = UCase$(Char$)
      If Char$ = "Y" Then
         Q = -1
         Print "y"
         Exit Do
      End If
      If Char$ = "N" Then
         Print "n"
         Exit Do
      End If
   Loop
   If Q Then
      Close #File5
      If _FileExists(FilenameX$) Then
         f$ = FilenameX$ + Chr$(0)
         x = DeleteFileA%(f$)
      End If
      Print "Save file in Linux binary write mode(y/n)? ";
      Do
         _Limit 50
         X$ = InKey$
         If LCase$(X$) = "y" Then Print: LINUXSave = -1: Exit Do
         If LCase$(X$) = "n" Then Print: LINUXSave = 0: Exit Do
      Loop
      If LINUXSave Then
         Open FilenameX$ For Binary As #File5
         Var& = 0&
         For Count& = 1& To Max.Lines
            For Count2 = 1 To Len(Temp.ArrayS(Count&))
               VarX = Mid$(Temp.ArrayS(Count&), Count2, 1)
               Var& = Var& + 1&
               Put File5, Var&, VarX
            Next
            Var& = Var& + 1&
            VarX = Chr$(10)
            Put File5, Var&, VarX
         Next
      Else
         Var& = 0&
         Open FilenameX$ For Output As #File5
         For Count& = 1& To Max.Lines
            Var& = Var& + Len(Temp.ArrayS(Count&)) + 2&
            Print #File5, Temp.ArrayS(Count&)
         Next
      End If
      Close #File5
      Erase Temp.ArrayS
      If LINUXSave Then
         Print Str$(Var&) + " binary bytes stored to disk."
      Else
         Print Str$(Var&) + " bytes stored to disk."
      End If
      Print "-more-";
      While InKey$ = ""
         _Limit 50
      Wend
      Print
      ' read config file.
      Print "Reload Hexedit.cfg settings(y/n)?";
      Do
         _Limit 50
         X$ = InKey$
         If LCase$(X$) = "y" Then
            Print
            Call ReadConfigFile(FilenameZ$)
            Exit Do
         End If
         If LCase$(X$) = "n" Then
            Print
            Exit Do
         End If
      Loop
      Print "-more-";
      While InKey$ = ""
         _Limit 50
      Wend
   End If
   Exit Sub

   Display.Ascii.Line:
   Color 15, 1
   Locate Max.Row - 1, 1, 1
   Color 15, 1
   Strng$ = Space$(41)
   Print Strng$;
   Locate Max.Row - 1, 1, 1
   If Left$(Ascii$, 1) = "x" Then
      Var2$ = "Enter 2-digit ascii code: "
   Else
      If Left$(Ascii$, 1) = "o" Then
         Var2$ = "Enter 3-digit ascii code: "
      Else
         If Left$(Ascii$, 1) = "b" Then
            Var2$ = "Enter 8-digit ascii code: "
         Else
            Var2$ = "Enter 3-digit ascii code: "
         End If
      End If
   End If
   VarC = Len(Var2$) + Len(Ascii$)
   Var2$ = Var2$ + Space$(41 - Len(Var2$))
   Print Var2$;
   Locate Max.Row - 1, VarC, 1
   Return

   Binary.String:
   Ascii.Value = False
   Binary.Power = False
   For Binary.Digit = Len(Ascii$) To 1 Step -1
      OutX2$ = Mid$(Ascii$, Binary.Digit, 1)
      Select Case OutX2$
         Case "0"
            ' nul
         Case "1"
            Ascii.Value = Ascii.Value + 2 ^ Binary.Power
      End Select
      Binary.Power = Binary.Power + 1
   Next
   Return

   Jump.Line:
   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(80)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   prompt$ = "Enter line number(1-" + LTrim$(Str$(Max.Lines)) + ")? "
   Print prompt$;
   Line Input X$

   VarX2 = -1
   If Len(X$) = 0 Then
      VarX2 = 0
   Else
      If Len(X$) > 7 Then
         VarX2 = 0
      Else
         VarX2 = IsNumeric(X$)
      End If
   End If
   Count& = 0&
   If VarX2 Then
      If Val(X$) > 0 And Val(X$) <= Max.Lines Then
         Count& = Val(X$)
      Else
         VarX2 = 0
      End If
   End If
   Return

   Jump.Byte:
   ' count bytes in edit array
   X# = 0#
   For x& = 1 To Max.Lines
      X# = X# + Len(Temp.ArrayS(x&))
   Next

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(80)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   prompt$ = "Enter byte number(1-" + LTrim$(Str$(X#)) + ")? "
   Print prompt$;
   Line Input X$

   VarX2 = -1
   If Len(X$) = 0 Then
      VarX2 = 0
   Else
      If Len(X$) > 15 Then
         VarX2 = 0
      Else
         VarX2 = IsNumeric(X$)
      End If
   End If
   T# = 0#
   If VarX2 Then
      Count# = Val(X$)
      If Count# > 0 And Count# <= X# Then
         For Count& = 1 To Max.Lines
            If T# + Len(Temp.ArrayS(Count&)) >= Count# Then
               Exit For
            End If
            T# = T# + Len(Temp.ArrayS(Count&))
         Next
      Else
         VarX2 = 0
      End If
   End If
   Return

   Replace.String:
   If Max.Lines > 0 Then
      Color 15, 1
      Locate Max.Row - 1, 1
      Strng$ = Space$(80)
      Print Strng$;
      Color 14, 1
      Locate Max.Row - 1, 1
      Line Input ; "Enter search string? "; Search$

      Color 15, 1
      Locate Max.Row - 1, 1
      Strng$ = Space$(80)
      Print Strng$;
      Color 14, 1
      Locate Max.Row - 1, 1
      Line Input ; "Enter replace string? "; Replace$

      Replace.String2:

      Color 15, 1
      Locate Max.Row - 1, 1
      Strng$ = Space$(80)
      Print Strng$;
      Color 14, 1
      Locate Max.Row - 1, 1
      Print "Enter (R)eplace, Replace(A)ll, (C)ancel? ";
      Do
         _Limit 50
         X$ = InKey$
         x = 0
         If UCase$(X$) = "R" Then x = 1: Exit Do
         If UCase$(X$) = "A" Then x = 2: Exit Do
         If UCase$(X$) = "C" Then x = 0: Exit Do
      Loop
      If x Then
         Color 15, 1
         Locate Max.Row - 1, 1
         Strng$ = Space$(80)
         Print Strng$;
         Color 14, 1
         Locate Max.Row - 1, 1
         Print "Case-sensitive(y/n)? ";
         Do
            _Limit 50
            Y$ = InKey$
            If UCase$(Y$) = "Y" Then SensitiveSelect = -1: Exit Do
            If UCase$(Y$) = "N" Then SensitiveSelect = 0: Exit Do
         Loop
      End If

      If x = 1 Then ' replace
         ' store current screen
         Store1 = Xcoor
         Store2 = Ycoor
         Store3 = Column
         Store& = Line.Number
         ' start replace
         Count& = 0&
         If Len(Search$) Then
            For x& = Store& To Max.Lines
               S1 = 1
               Text$ = Temp.ArrayS(x&)
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     ' jump to line
                     Ycoor = 1
                     Column = 1
                     Line.Number = x&
                     If Line.Number <= 23 Then
                        Xcoor = Line.Number
                     Else
                        Xcoor = 1
                     End If
                     ' display screen
                     Color 15, 0
                     GoSub Display.Screen

                     ' display text to replace fixed 09/08/2022
                     If P1 + Len(Search$) < 80 Then
                        If Len(Search$) < 80 Then
                           Locate Xcoor, P1
                           Color 12, 1
                           Var1$ = Mid$(Text$, P1, Len(Search$))
                           Print Var1$;
                           Color 15, 0
                        End If
                     Else
                        If Len(Search$) < 80 Then
                           ' move right until search fits
                           Do
                              If Column + Ycoor + 1 < P1 + Len(Search$) Then
                                 If Ycoor < 80 Then
                                    Ycoor = Ycoor + 1
                                 Else
                                    Column = Column + 1
                                 End If
                              Else
                                 Exit Do
                              End If
                           Loop
                           ' decrease until display search fits in line
                           Do Until Ycoor + Len(Search$) < 80
                              Ycoor = Ycoor - 1
                           Loop
                           ' check display search at end of line
                           If Ycoor + Len(Search$) <= 80 Then
                              GoSub Display.Screen
                              Locate Xcoor, Ycoor, 1
                              Color 12, 1
                              Var1$ = Mid$(Text$, P1, Len(Search$))
                              Print Var1$;
                              Color 15, 0
                           End If
                        End If
                     End If

                     ' z=-1 replace, z=1 skip
                     Color 15, 1
                     Locate Max.Row - 1, 1
                     Strng$ = Space$(80)
                     Print Strng$;
                     Color 14, 1
                     Locate Max.Row - 1, 1
                     Print "Enter (R)eplace, (S)kip, (C)ancel? ";
                     Do
                        _Limit 50
                        X$ = InKey$
                        Z = 0
                        If UCase$(X$) = "R" Then Z = -1: Exit Do
                        If UCase$(X$) = "S" Then Z = 1: Exit Do
                        If UCase$(X$) = "C" Then Z = 0: Exit Do
                     Loop
                     If Z = 0 Then ' cancel
                        Exit For
                     End If
                     If Z = -1 Then
                        Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                        Temp.ArrayS(x&) = Text$
                        Count& = Count& + 1&
                     End If
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
            Next
         End If
         ' restore current screen
         Color 15, 0
         GoSub Display.Screen

         Xcoor = Store1
         Ycoor = Store2
         Column = Store3
         Line.Number = Store&

         Color 15, 1
         Locate Max.Row - 1, 1
         Strng$ = Space$(80)
         Print Strng$;
         Color 14, 1
         Locate Max.Row - 1, 1
         ' display replacements
         If Count& = 0& Then
            Print "Text not found. Press any key.";
         Else
            Print "Replaced" + Str$(Count&) + " strings. Press any key.";
         End If
         While InKey$ = ""
            _Limit 50
         Wend
         Color 15, 0
         GoSub Display.Screen
      End If
      If x = 2 Then ' replaceall
         Count& = 0&
         If Len(Search$) Then
            For x& = 1& To Max.Lines
               Text$ = Temp.ArrayS(x&)
               Flag = 0
               S1 = 1
               Do
                  If SensitiveSelect Then
                     P1 = InStr(S1, Text$, Search$)
                  Else
                     P1 = InStr(S1, UCase$(Text$), UCase$(Search$))
                  End If
                  If P1 Then
                     Flag = -1
                     Text$ = Left$(Text$, P1 - 1) + Replace$ + Mid$(Text$, P1 + Len(Search$))
                     Count& = Count& + 1&
                  Else
                     Exit Do
                  End If
                  S1 = P1 + Len(Replace$)
               Loop
               If Flag Then
                  Temp.ArrayS(x&) = Text$
               End If
            Next
         End If
         Color 15, 0
         GoSub Display.Screen
         Color 15, 1
         Locate Max.Row - 1, 1
         Strng$ = Space$(80)
         Print Strng$;
         Color 14, 1
         Locate Max.Row - 1, 1
         ' display replacements
         If Count& = 0& Then
            Print "Text not found. Press any key.";
         Else
            Print "Replaced" + Str$(Count&) + " strings. Press any key.";
         End If
         While InKey$ = ""
            _Limit 50
         Wend
         Color 15, 0
         GoSub Display.Screen
      End If
   End If
   Return

   ' init search
   Search.String:

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(80)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   Line Input ; "Enter search string? "; X$

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(80)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   Line Input ; "Case-sensitive(y/n)? "; Y$
   If UCase$(Y$) = "Y" Then CaseSensitive = -1
   If UCase$(Y$) = "N" Then CaseSensitive = 0

   Color 15, 1
   Locate Max.Row - 1, 1
   Strng$ = Space$(80)
   Print Strng$;
   Color 14, 1
   Locate Max.Row - 1, 1
   Line Input ; "Use wildcards(y/n)? "; Z$
   If UCase$(Z$) = "Y" Then WildCards = -1
   If UCase$(Z$) = "N" Then WildCards = 0

   LastSearchLine& = 0&
   LastSearchString$ = X$
   VarX2 = 0
   If Len(X$) = 0 Then
      Return
   End If
   For Count& = 1 To Max.Lines
      If WildCards Then
         VarX1$ = Temp.ArrayS(Count&)
         VarX2$ = X$
         Call InstrSUB1(VarX2, VarX2$, VarX1$, CaseSensitive)
         If VarX2 Then
            LastSearchLine& = Count&
            Exit For
         End If
      Else
         If CaseSensitive Then
            If InStr(Temp.ArrayS(Count&), X$) Then
               LastSearchLine& = Count&
               VarX2 = -1
               Exit For
            End If
         Else
            VarX1$ = UCase$(Temp.ArrayS(Count&))
            VarX2$ = UCase$(X$)
            If InStr(VarX1$, VarX2$) Then
               LastSearchLine& = Count&
               VarX2 = -1
               Exit For
            End If
         End If
      End If
   Next
   Return

   ' continue search
   Search.String2:
   X$ = LastSearchString$
   VarX2 = 0
   If Len(X$) Then
      For Count& = LastSearchLine& + 1& To Max.Lines
         If WildCards Then
            VarX1$ = Temp.ArrayS(Count&)
            VarX2$ = X$
            Call InstrSUB1(VarX2, VarX2$, VarX1$, CaseSensitive)
            If VarX2 Then
               LastSearchLine& = Count&
               Exit For
            End If
         Else
            If CaseSensitive Then
               If InStr(Temp.ArrayS(Count&), X$) Then
                  LastSearchLine& = Count&
                  VarX2 = -1
                  Exit For
               End If
            Else
               VarX1$ = UCase$(Temp.ArrayS(Count&))
               VarX2$ = UCase$(X$)
               If InStr(VarX1$, VarX2$) Then
                  LastSearchLine& = Count&
                  VarX2 = -1
                  Exit For
               End If
            End If
         End If
      Next
   End If
   Return

   ' redisplay editor screen
   Display.Screen:
   Color 15, 0
   Cls
   Locate 1, 1
   Count2 = 0
   Do
      Count2 = Count2 + 1
      If Count2 = Max.Row - 1 Then
         Exit Do
      End If
      If Count2 + Line.Number - Xcoor > Max.Lines Then
         Exit Do
      End If
      Locate Count2, 1
      Strng$ = Mid$(Temp.ArrayS(Count2 + Line.Number - Xcoor), Column)
      If Len(Strng$) > 80 Then
         Strng$ = Left$(Strng$, 80)
      End If
      Print Strng$;
   Loop
   If Count2 < Max.Row - 1 Then
      Locate Count2, 1
      Color 12, 0
      Print "<end of file>";
   End If
   Color 14, 1
   Locate Max.Row - 1, 1
   Print Space$(78);
   Color 0, 1
   Locate Max.Row - 1, 79, 0
   Print " ";
   Locate Max.Row - 1, 80, 0
   Print " ";
   Color 15, 0
   Locate , , 1
   Return
End Sub

Rem get command$
Function Read.Command$
   Declare Library
      Function GetCommandLineA%& ()
   End Declare
   Dim m As _MEM, ms As String * 1000
   a%& = GetCommandLineA
   m = _Mem(a%&, Len(ms))
   ms = _MemGet(m, m.OFFSET, String * 1000)
   If a%& Then
      cmd$ = ms
      eol = InStr(cmd$, Chr$(0))
      If eol Then
         cmd$ = Left$(cmd$, eol - 1)
      End If
      ' parse off program name.
      eol = InStr(2, cmd$, Chr$(34)) + 1
      cmd$ = Mid$(cmd$, eol)
   End If
   _MemFree m
   Read.Command$ = cmd$
End Function

' arrays: KeyMap() and KeyMapExtended()
' dimension array subscript 1 equals:
'   1 is:
'     0 = no point.
'     1 = point to 2
'     2 = point to 3.
'   2 = ascii map.
'   3 = extended map.
Sub Keymapper (x1$)
   Cls
   Locate 25, 1, 0
   Color White, Blue
   d$ = "KeyMapper Utility: " + Version
   d$ = d$ + Space$(80 - Len(d$))
   Print d$;
   Locate _Height - 1, 1, 1
   Color White, Black
   If LTrim$(RTrim$(LCase$(x1$))) = "save" Then
      Color White
      Print "Enter keymap filename number(001-999)";
      Input Var$
      Var = Int(Val(Var$))
      If Var <= 0 Then Exit Sub
      If Var >= 1 And Var <= 999 Then
         Filespec$ = StartDir$ + "hexedit" + Right$("000" + LTrim$(Str$(Var)), 3) + ".key"
         If _FileExists(Filespec$) Then
            Print "File exists. Overwrite(y/n)?";
            Do
               _Limit 50
               x$ = InKey$
               If LCase$(x$) = "n" Then Print: Exit Sub
               If LCase$(x$) = "y" Then Print: Exit Do
            Loop
         End If
         h = FreeFile
         Open Filespec$ For Output As #h
         For x = 1 To 3
            For y = 0 To 255
               Print #h, KeyMap(x, y)
               Print #h, KeyMapExtended(x, y)
            Next
         Next
         Close #h
         Color Yellow
         Print "Key Map arrays saved."
         Print "Press any key:"
         Call PromptKey
      End If
      Exit Sub
   End If
   If LTrim$(RTrim$(LCase$(x1$))) = "load" Then
      Color White
      Print "Enter keymap filename number(001-999/-1 to list)";
      Input Var$
      Var = Int(Val(Var$))
      If Var = False Then Exit Sub
      If Var < False Then
         Filespec$ = StartDir$ + "hexedit*.key"
         Call ListFiles(Filespec$, -1)
         Print "Press any key:"
         Call PromptKey
      End If
      If Var >= 1 And Var <= 999 Then
         Filespec$ = StartDir$ + "hexedit" + Right$("000" + LTrim$(Str$(Var)), 3) + ".key"
         If _FileExists(Filespec$) = False Then
            Print "File not found."
            Print "Press any key:"
            Call PromptKey
            Exit Sub
         End If
         ' pretest file.
         h = FreeFile
         Open Filespec$ For Input As #h
         For x = 1 To 3
            For y = 0 To 255
               If EOF(h) Then
                  Print "File contents error."
                  Close #h
                  Print "Press any key:"
                  Call PromptKey
                  Exit Sub
               End If
            Next
         Next
         Close #h
         ' read file.
         h = FreeFile
         Open Filespec$ For Input As #h
         For x = 1 To 3
            For y = 0 To 255
               If EOF(h) Then
                  Print "File contents error."
                  Close #h
                  Print "Press any key:"
                  Call PromptKey
                  Exit Sub
               End If
               Input #h, z
               KeyMap(x, y) = z
               If EOF(h) Then
                  Print "File contents error."
                  Close #h
                  Print "Press any key:"
                  Call PromptKey
                  Exit Sub
               End If
               Input #h, z
               KeyMapExtended(x, y) = z
            Next
         Next
         Close #h
         Color Yellow
         Print "Key Map arrays loaded."
         Print "Press any key:"
         Call PromptKey
      End If
      Exit Sub
   End If
   If LTrim$(RTrim$(LCase$(x1$))) = "list" Then
      Cls
      Call ListChart
      Call ListChart2
      Call ListChart3
      Call ListChart4
      V = _Height
      Locate V - 1, 1, 1
      Print "Press any key:"
      Call PromptKey
      Exit Sub
   End If
   If LTrim$(RTrim$(LCase$(x1$))) = "help" Then
      Color Yellow
      Print "KEYMAP [LIST][RESET][SAVE][LOAD]"
      Print ""
      Color White
      Print "  Keyboard mapper functions:"
      Print "    <enter> start keymapper."
      Print "    'list' all keyboard scancodes."
      Print "    'reset' clear all keymap arrays."
      Print "    'save' save key map arrays."
      Print "    'load' load key map arrays."
      Color Yellow
      Print "Press any key:"
      Call PromptKey
      Exit Sub
   End If
   If LTrim$(RTrim$(LCase$(x1$))) = "reset" Then
      For x = 1 To 3
         For y = 0 To 255
            KeyMap(x, y) = 0
            KeyMapExtended(x, y) = 0
         Next
      Next
      Color White
      Print "Key Map arrays reset."
      Print "Press any key:"
      Call PromptKey
      Exit Sub
   End If
   If Len(x1$) Then
      Color White
      Print "Unknown Keymap function. Type HELP for help."
      Print "Press any key:"
      Call PromptKey
      Exit Sub
   End If

   ' main loop.
   Do
      ' start loop.
      Do
         Color White
         Print "Menu Select"
         Color Yellow
         Print " (1)Enter Mapper"
         Print " (2)Ascii Chart"
         Print " (3)Clear Keys"
         Print " (4)List Ascii Keymap table"
         Print " (5)List Extended Keymap table"
         Print " (6)Quit"
         Color White
         Print "Enter Option?";
         Do
            _Limit 50
            Inpt$ = InKey$
            If Len(Inpt$) Then
               If Inpt$ = Chr$(3) Then
                  ' nul
               Else
                  Entry = Int(Val(Inpt$))
                  If Entry >= 1 And Entry <= 6 Then
                     Print Entry
                     Exit Do
                  End If
               End If
            End If
         Loop
         If Entry = 1 Then Exit Do
         If Entry = 2 Then Call AsciiChart
         If Entry = 3 Then
            For x = 1 To 3
               For y = 0 To 255
                  KeyMap(x, y) = 0
                  KeyMapExtended(x, y) = 0
               Next
            Next
            Color Yellow
            Print "Key Map arrays reset."
         End If
         If Entry = 4 Then
            Call ListChart
            Call ListChart2
         End If
         If Entry = 5 Then
            Call ListChart3
            Call ListChart4
         End If
         If Entry = 6 Then
            Color Plain
            Exit Sub
         End If
      Loop
      ' mapper loop.
      Color Red
      Print "Enter mapper loop:"
      Do
         Color White
         Print "Select From Option"
         Color Yellow
         Print " (1)Ascii KeyScan"
         Print " (2)Extended KeyScan"
         Print " (3)Continue to Keytest"
         Print " (4)Exit Mapper"
         Color White
         Print "Enter Option?";
         Do
            _Limit 50
            Inpt$ = InKey$
            If Len(Inpt$) Then
               If Inpt$ = Chr$(3) Then
                  ' nul
               Else
                  KeyType1 = Int(Val(Inpt$))
                  If KeyType1 >= 1 And KeyType1 <= 4 Then
                     Print KeyType1
                     Exit Do
                  End If
               End If
            End If
         Loop
         If KeyType1 = 3 Then Exit Do
         If KeyType1 = 4 Then Exit Sub
         Color White
         Print "Select To Option"
         Color Yellow
         Print " (1)Ascii KeyScan"
         Print " (2)Extended KeyScan"
         Print " (3)Continue to Keytest"
         Print " (4)Exit mapper"
         Color White
         Print "Enter Option?";
         Do
            _Limit 50
            Inpt$ = InKey$
            If Len(Inpt$) Then
               If Inpt$ = Chr$(3) Then
                  ' nul
               Else
                  KeyType2 = Int(Val(Inpt$))
                  If KeyType2 >= 1 And KeyType2 <= 4 Then
                     Print KeyType2
                     Exit Do
                  End If
               End If
            End If
         Loop
         If KeyType2 = 3 Then Exit Do
         If KeyType2 = 4 Then Exit Sub
         If (KeyType1 = 1 Or KeyType1 = 2) And (KeyType2 = 1 Or KeyType2 = 2) Then
            Color Red
            Print "Enter mapper key scan codes:"
            If KeyType1 = 1 Then
               Color Yellow
               Print "Enter ascii key scan code to map(1-255)?";
               Color White
               Scan$ = LineInput$(CsrLin, Pos(0), 20): Print
               Scan.From = GetAsciiKey(Scan$)
            End If
            If KeyType1 = 2 Then
               Color Yellow
               Print "Enter extended key scan code to map(1-255)?";
               Color White
               Scan$ = LineInput$(CsrLin, Pos(0), 20): Print
               Scan.From = GetExtendedKey(Scan$)
            End If
            If KeyType2 = 1 Then
               Color Yellow
               Print "Enter target ascii key scan code(0-255)?";
               Color White
               Scan$ = LineInput$(CsrLin, Pos(0), 20): Print
               Scan.To = GetAsciiKey(Scan$)
            End If
            If KeyType2 = 2 Then
               Color Yellow
               Print "Enter target extended key scan code(0-255)?";
               Color White
               Scan$ = LineInput$(CsrLin, Pos(0), 20): Print
               Scan.To = GetExtendedKey(Scan$)
            End If

            If Scan.From >= 1 And Scan.From <= 255 Then
               If Scan.To = False Then
                  If KeyType1 = 1 Then
                     KeyMap(1, Scan.From) = 0
                  End If
                  If KeyType1 = 2 Then
                     KeyMapExtended(1, Scan.From) = 0
                  End If
                  Color White
                  Print "Key cleared."
               End If
               If Scan.To >= 1 And Scan.To <= 255 Then
                  If KeyType1 = 1 Then
                     If KeyType2 = 1 Then
                        KeyMap(1, Scan.From) = 1
                        KeyMap(2, Scan.From) = Scan.To
                     Else
                        KeyMap(1, Scan.From) = 2
                        KeyMap(3, Scan.From) = Scan.To
                     End If
                     Color White
                     Print "Ascii key set."
                  End If
                  If KeyType1 = 2 Then
                     If KeyType2 = 1 Then
                        KeyMapExtended(1, Scan.From) = 1
                        KeyMapExtended(2, Scan.From) = Scan.To
                     Else
                        KeyMapExtended(1, Scan.From) = 2
                        KeyMapExtended(3, Scan.From) = Scan.To
                     End If
                     Color White
                     Print "Extended key set."
                  End If
               End If
            End If
         End If
      Loop
      ' test mapper loop.
      Color White
      Print "Test key(Ctrl-Break to exit).."
      Color Yellow
      Do
         _Limit 50
         x$ = INKEYx$
         If Control.Break Then Exit Do
         If x$ = Chr$(3) Then ' ctrl-c
            _Delay 1.0
            If Control.Break Then Exit Do
         End If
         ' map ascii code.
         If Len(x$) = 1 Then
            y = Asc(x$)
            If KeyMap(1, y) = 0 Then
               Color Yellow
               Print "From: "; x$; " to: ";
               Color White
               Print Chr$(y)
            End If
            If KeyMap(1, y) = 1 Then
               z = KeyMap(2, y)
               Color Yellow
               Print "From: "; x$; " to: ";
               Color Red
               Print Chr$(z)
            End If
            If KeyMap(1, y) = 2 Then
               z = KeyMap(3, y)
               Color Yellow
               Print "From: "; x$; " to: ";
               Color Green
               Print "0:"; LTrim$(Str$(z))
            End If
         End If
         ' map extended code.
         If Len(x$) = 2 Then
            y = Asc(Right$(x$, 1))
            If KeyMapExtended(1, y) = False Then
               Color Yellow
               Print "From:"; y; "to: ";
               Color White
               Print "0:"; LTrim$(Str$(y))
            End If
            If KeyMapExtended(1, y) = 1 Then
               z = KeyMapExtended(2, y)
               Color Yellow
               Print "From:"; y; "to: ";
               Color Red
               Print Chr$(z)
            End If
            If KeyMapExtended(1, y) = 2 Then
               z = KeyMapExtended(3, y)
               Color Yellow
               Print "From:"; y; "to: ";
               Color Green
               Print "0:"; LTrim$(Str$(z))
            End If
         End If
      Loop
   Loop
End Sub

Function KeymapChar$ (x$)
   ' map ascii code.
   If Len(x$) = 1 Then
      y = Asc(x$)
      If KeyMap(1, y) = 0 Then
         KeymapChar = Chr$(y)
      End If
      If KeyMap(1, y) = 1 Then
         z = KeyMap(2, y)
         KeymapChar = Chr$(z)
      End If
      If KeyMap(1, y) = 2 Then
         z = KeyMap(3, y)
         KeymapChar = Chr$(0) + Chr$(z)
      End If
   End If
   ' map extended code.
   If Len(x$) = 2 Then
      y = Asc(Right$(x$, 1))
      If KeyMapExtended(1, y) = 0 Then
         KeymapChar = Chr$(0) + Chr$(y)
      End If
      If KeyMapExtended(1, y) = 1 Then
         z = KeyMapExtended(2, y)
         KeymapChar = Chr$(z)
      End If
      If KeyMapExtended(1, y) = 2 Then
         z = KeyMapExtended(3, y)
         KeymapChar = Chr$(0) + Chr$(z)
      End If
   End If
End Function

Function GetAsciiKey (x$)
   z$ = x$
   If Left$(z$, 1) = Quote And Right$(z$, 1) = Quote Then
      z$ = Left$(z$, Len(z$) - 1)
      z$ = Mid$(z$, 2)
      If Len(z$) = 1 Then
         If Asc(z$) >= 1 And Asc(z$) <= 255 Then
            GetAsciiKey = Asc(z$)
            Exit Function
         End If
      End If
   End If
   If Int(Val(x$)) >= 1 And Int(Val(x$)) <= 255 Then
      GetAsciiKey = Int(Val(x$))
      Exit Function
   End If
   If Len(x$) = 1 Then
      If Asc(x$) >= 1 And Asc(x$) <= 255 Then
         GetAsciiKey = Asc(x$)
         Exit Function
      End If
   End If
   z$ = UCase$(x$)
   For z = 1 To 26
      y$ = "CTRL-" + Chr$(z + 64)
      If z$ = y$ Then
         GetAsciiKey = z
         Exit Function
      End If
      y$ = "CONTROL-" + Chr$(z + 64)
      If z$ = y$ Then
         GetAsciiKey = z
         Exit Function
      End If
   Next
   GetAsciiKey = 0
End Function

Function GetExtendedKey (x$)
   If Int(Val(x$)) >= 1 And Int(Val(x$)) <= 255 Then
      GetExtendedKey = Int(Val(x$))
      Exit Function
   End If
   z$ = UCase$(x$)
   Select Case z$
      Case "UP"
         x = 72
      Case "CTRL-UP"
         x = 141
      Case "ALT-UP"
         x = 152
      Case "DOWN"
         x = 80
      Case "CTRL-DOWN"
         x = 145
      Case "ALT-DOWN"
         x = 160
      Case "LEFT"
         x = 75
      Case "CTRL-LEFT"
         x = 115
      Case "ALT-LEFT"
         x = 155
      Case "RIGHT"
         x = 77
      Case "CTRL-RIGHT"
         x = 116
      Case "ALT-RIGHT"
         x = 157
      Case "KEYPAD-5"
         x = 76
      Case "SHIFT-KEYPAD-5"
         x = 53
      Case "CTRL-KEYPAD-5"
         x = 143
      Case "ALT-KEYPAD-5"
         x = 5
      Case "PAGEUP"
         x = 73
      Case "SHIFT-PAGEUP"
         x = 57
      Case "CTRL-PAGEUP"
         x = 132
      Case "ALT-PAGEUP"
         x = 9
      Case "PAGEDOWN"
         x = 81
      Case "SHIFT-PAGEDOWN"
         x = 51
      Case "CTRL-PAGEDOWN"
         x = 118
      Case "ALT-PAGEDOWN"
         x = 3
      Case "HOME"
         x = 71
      Case "SHIFT-HOME"
         x = 55
      Case "CTRL-HOME"
         x = 119
      Case "ALT-HOME"
         x = 7
      Case "END"
         x = 79
      Case "SHIFT-END"
         x = 49
      Case "CTRL-END"
         x = 117
      Case "ALT-END"
         x = 1
      Case "INSERT"
         x = 82
      Case "SHIFT-INSERT"
         x = 48
      Case "CTRL-INSERT"
         x = 146
      Case "ALT-INSERT"
      Case "DELETE"
         x = 83
      Case "SHIFT-DELETE"
         x = 46
      Case "CTRL-DELETE"
         x = 147
      Case "ALT-DELETE"
      Case "F1"
         x = 59
      Case "F2"
         x = 60
      Case "F3"
         x = 61
      Case "F4"
         x = 62
      Case "F5"
         x = 63
      Case "F6"
         x = 64
      Case "F7"
         x = 65
      Case "F8"
         x = 66
      Case "F9"
         x = 67
      Case "F10"
         x = 68
      Case "SHIFT-F1"
         x = 84
      Case "SHIFT-F2"
         x = 85
      Case "SHIFT-F3"
         x = 86
      Case "SHIFT-F4"
         x = 87
      Case "SHIFT-F5"
         x = 88
      Case "SHIFT-F6"
         x = 89
      Case "SHIFT-F7"
         x = 90
      Case "SHIFT-F8"
         x = 91
      Case "SHIFT-F9"
         x = 92
      Case "SHIFT-F10"
         x = 93
      Case "CTRL-F1"
         x = 94
      Case "CTRL-F2"
         x = 95
      Case "CTRL-F3"
         x = 96
      Case "CTRL-F4"
         x = 97
      Case "CTRL-F5"
         x = 98
      Case "CTRL-F6"
         x = 99
      Case "CTRL-F7"
         x = 100
      Case "CTRL-F8"
         x = 101
      Case "CTRL-F9"
         x = 102
      Case "CTRL-F10"
         x = 103
      Case "ALT-F1"
         x = 104
      Case "ALT-F2"
         x = 105
      Case "ALT-F3"
         x = 106
      Case "ALT-F4"
         x = 107
      Case "ALT-F5"
         x = 108
      Case "ALT-F6"
         x = 109
      Case "ALT-F7"
         x = 110
      Case "ALT-F8"
         x = 111
      Case "ALT-F9"
         x = 112
      Case "ALT-F10"
         x = 113
      Case "F11"
         x = 133
      Case "SHIFT-F11"
         x = 135
      Case "CTRL-F11"
         x = 137
      Case "ALT-F11"
         x = 139
      Case "F12"
         x = 134
      Case "SHIFT-F12"
         x = 136
      Case "CTRL-F12"
         x = 138
      Case "ALT-F12"
         x = 140
      Case "ALT-1"
         x = 120
      Case "ALT-2"
         x = 121
      Case "ALT-3"
         x = 122
      Case "ALT-4"
         x = 123
      Case "ALT-5"
         x = 124
      Case "ALT-6"
         x = 125
      Case "ALT-7"
         x = 126
      Case "ALT-8"
         x = 127
      Case "ALT-9"
         x = 128
      Case "ALT-0"
         x = 129
      Case "ALT--"
         x = 130
      Case "ALT-="
         x = 131
      Case "ALT-A"
         x = 30
      Case "ALT-B"
         x = 48
      Case "ALT-C"
         x = 46
      Case "ALT-D"
         x = 32
      Case "ALT-E"
         x = 18
      Case "ALT-F"
         x = 33
      Case "ALT-G"
         x = 34
      Case "ALT-H"
         x = 35
      Case "ALT-I"
         x = 23
      Case "ALT-J"
         x = 36
      Case "ALT-K"
         x = 37
      Case "ALT-L"
         x = 38
      Case "ALT-M"
         x = 50
      Case "ALT-N"
         x = 49
      Case "ALT-O"
         x = 24
      Case "ALT-P"
         x = 25
      Case "ALT-Q"
         x = 16
      Case "ALT-R"
         x = 19
      Case "ALT-S"
         x = 31
      Case "ALT-T"
         x = 20
      Case "ALT-U"
         x = 22
      Case "ALT-V"
         x = 47
      Case "ALT-W"
         x = 17
      Case "ALT-X"
         x = 45
      Case "ALT-Y"
         x = 21
      Case "ALT-Z"
         x = 44
   End Select
   GetExtendedKey = x
End Function

' routine to display ascii-ascii chart.
Sub ListChart
   Cls
   Color White
   Locate 2, 2, 0
   Print "ASCII - ASCII Chart for characters 1 to 127:"
   Var2 = 3
   Locate 3, 2, 0
   For Char = 1 To 127
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Green
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMap(1, Char) = 1 Then ' ascii
         Color Red
         KeyType = KeyMap(2, Char) ' scanto
      End If

      Var$ = Mid$(Str$(KeyType), 2)
      Var1$ = Right$("000" + Var$, 3)
      Print Var1$;
      If Char < 127 Then Print " ";

      ' check full screen line
      If (Char Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color White
   Locate 2, 2, 0
   Print "ASCII - ASCII Chart for characters 128 to 255:";
   Var2 = 3
   Locate 3, 2, 0
   For Char = 128 To 255
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Red
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMap(1, Char) = 1 Then ' ascii
         Color Red
         KeyType = KeyMap(2, Char) ' scanto
      End If

      Print LTrim$(Str$(KeyType));
      If Char < 255 Then Print " ";
      ' check full screen line
      If ((Char - 7) Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color Plain
End Sub

' routine to display ascii-extended chart.
Sub ListChart2
   Cls
   Color White
   Locate 2, 2, 0
   Print "ASCII - EXTENDED Chart for characters 1 to 127:"
   Var2 = 3
   Locate 3, 2, 0
   For Char = 1 To 127
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Green
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMap(1, Char) = 2 Then ' ascii extended
         Color Red
         KeyType = KeyMap(3, Char) ' scanto
      End If

      Var$ = Mid$(Str$(KeyType), 2)
      Var1$ = Right$("000" + Var$, 3)
      Print Var1$;
      If Char < 127 Then Print " ";

      ' check full screen line
      If (Char Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color White
   Locate 2, 2, 0
   Print "ASCII - EXTENDED Chart for characters 128 to 255:";
   Var2 = 3
   Locate 3, 2, 0
   For Char = 128 To 255
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Green
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMap(1, Char) = 2 Then ' ascii extended
         Color Red
         KeyType = KeyMap(3, Char) ' scanto
      End If

      Print LTrim$(Str$(KeyType));
      If Char < 255 Then Print " ";

      ' check full screen line
      If ((Char - 7) Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color Plain
End Sub

' routine to display extended-ascii chart.
Sub ListChart3
   Cls
   Color White
   Locate 2, 2, 0
   Print "EXTENDED - ASCII Chart for characters 1 to 127:"
   Var2 = 3
   Locate 3, 2, 0
   For Char = 1 To 127
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Green
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMapExtended(1, Char) = 1 Then ' ascii
         Color Red
         KeyType = KeyMapExtended(2, Char) ' scanto
      End If

      Var$ = Mid$(Str$(KeyType), 2)
      Var1$ = Right$("000" + Var$, 3)
      Print Var1$;
      If Char < 127 Then Print " ";

      ' check full screen line
      If (Char Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color White
   Locate 2, 2, 0
   Print "EXTENDED - ASCII Chart for characters 128 to 255:";
   Var2 = 3
   Locate 3, 2, 0
   For Char = 128 To 255
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Green
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMapExtended(1, Char) = 1 Then ' ascii
         Color Red
         KeyType = KeyMapExtended(2, Char) ' scanto
      End If

      Print LTrim$(Str$(KeyType));
      If Char < 255 Then Print " ";

      ' check full screen line
      If ((Char - 7) Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color Plain
End Sub

' routine to display extended-extended chart.
Sub ListChart4
   Cls
   Color White
   Locate 2, 2, 0
   Print "EXTENDED - EXTENDED Chart for characters 1 to 127:"
   Var2 = 3
   Locate 3, 2, 0
   For Char = 1 To 127
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Green
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMapExtended(1, Char) = 2 Then ' ascii extended
         Color Red
         KeyType = KeyMapExtended(3, Char) ' scanto
      End If

      Var$ = Mid$(Str$(KeyType), 2)
      Var1$ = Right$("000" + Var$, 3)
      Print Var1$;
      If Char < 127 Then Print " ";

      ' check full screen line
      If (Char Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color White
   Locate 2, 2, 0
   Print "EXTENDED - EXTENDED Chart for characters 128 to 255:";
   Var2 = 3
   Locate 3, 2, 0
   For Char = 128 To 255
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("000" + Var$, 3) + " "
      Color Green
      Print Var1$;
      Color Yellow

      KeyType = Char
      If KeyMapExtended(1, Char) = 2 Then ' ascii extended
         Color Red
         KeyType = KeyMapExtended(3, Char) ' scanto
      End If

      Print LTrim$(Str$(KeyType));
      If Char < 255 Then Print " ";

      ' check full screen line
      If ((Char - 7) Mod 10) = False Then
         Var2 = Var2 + 1
         Locate Var2, 2, 0
      End If
   Next
   Color White
   Locate 16, 2, 0
   Print "Press key:"
   While InKey$ = Nul: _Limit 50: Wend
   Color Plain
End Sub

Sub ListFiles (VarZ$, VarQ)
   Dim ASCIIZ4 As String * 260
   Dim finddata As WIN32_FIND_DATA
   Dim hfind As _Unsigned _Offset

   ErrorCount = False
   ErrorType2 = True

   ' reset search parameter
   If Len(VarZ$) Then
      Var4$ = VarZ$
   Else
      Var4$ = "hexedit*.key"
   End If

   ' check filename
   If Right$(Var4$, 1) = Quote Then
      If Left$(Var4$, 1) = Quote Then
         Var4$ = Left$(Var4$, Len(Var4$) - 1)
         Var4$ = Mid$(Var4$, 2)
         If Var4$ = Nul Then Exit Sub
      End If
   End If

   ' display header
   Color White, Black
   Print "Searching: " + Var4$
   If VarQ = True Then l = 2 Else l = 1
   GoSub TitleHeader

   c = 0
   q = 0
   v = 3
   t = 0
   For l = 1 To 2 ' dirs/files
      If l = 2 Then
         If VarQ = False Then
            Exit For
         End If
      End If
      ASCIIZ4 = Var4$ + Chr$(0)
      hfind = FindFirstFileA(_Offset(ASCIIZ4), _Offset(finddata))
      If hfind <> INVALID_HANDLE_VALUE Then
         z = 0
         Do
            If Control.Break Then Exit Do
            OK = False
            Var# = finddata.dwFileAttributes
            If l = 1 Then
               If (Var# And &H10) = &H10 Then
                  OK = True
               End If
            End If
            If l = 2 Then
               If (Var# And &H10) = &H0 Then
                  OK = True
               End If
            End If

            X$ = finddata.cFileName
            VarX = InStr(X$, Chr$(0))
            If VarX Then
               X$ = Left$(X$, VarX - 1)
            End If
            X$ = RTrim$(X$)
            If X$ = "." Or X$ = ".." Then
               OK = False
            End If
            If OK Then
               If t Then
                  t = 0
                  GoSub TitleHeader
               End If
               If l = 1 Then
                  d1 = d1 + 1
               Else
                  f1 = f1 + 1
               End If
               q = -1

               ' print shortfilename
               z$ = finddata.cAlternateFileName
               vx = InStr(z$, Chr$(0))
               If vx Then
                  z$ = Left$(z$, vx - 1)
               End If
               If z$ = Nul Then
                  z$ = finddata.cFileName
                  vx = InStr(z$, Chr$(0))
                  If vx Then
                     z$ = Left$(z$, vx - 1)
                  End If
               End If
               If Len(z$) > 12 Then
                  z$ = Left$(z$, 12)
               End If
               Color Yellow, Black
               Print UCase$(z$);
               If Len(z$) <= 14 Then
                  Print Space$(14 - Len(z$));
               End If

               ' print date/time
               x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)

               Var$ = Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
               Var$ = Var$ + LTrim$(Str$(SysTime.wYear)) + "  "
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wMonth)), 2) + "-"
               Var$ = Var$ + Right$("00" + LTrim$(Str$(SysTime.wDay)), 2) + "-"
               Var$ = Var$ + LTrim$(Str$(SysTime.wYear))
               Color Green, Black
               Print Var$;

               ' print longfilename
               z$ = finddata.cFileName
               VarX = InStr(z$, Chr$(0))
               If VarX Then
                  z$ = Left$(z$, VarX - 1)
               End If
               z$ = RTrim$(z$)
               If Len(z$) Then
                  If Len(z$) > 41 Then
                     z$ = Left$(z$, 40) + "..."
                  End If
                  Color Yellow, Black
                  Print " "; z$;
               End If
               Print

               ' prompt
               v = v + 1
               If v >= _Height - 2 Then
                  v = 2
                  If c = 0 Then
                     Color White, Black
                     Print "-more(y/n/c/q)-";
                     X$ = Nul
                     Do
                        X$ = INKEYx$
                        If Control.Break Then
                           Control.Break = False
                           Exit Do
                        End If
                        If Len(X$) Then
                           Select Case LCase$(X$)
                              Case "c" ' continuous
                                 c = -1
                                 Exit Do
                              Case "n", "q" ' no/quit
                                 v = 0
                                 Print
                                 Exit For
                              Case " ", Chr$(13), "y" ' yes/continue
                                 Exit Do
                           End Select
                        End If
                     Loop
                     Print
                     t = -1
                  End If
               End If
            End If
         Loop While FindNextFileA(hfind, _Offset(finddata))
         x = FindClose(hfind)
      End If
      If Control.Break Then
         Control.Break = 0
         Exit For
      End If
   Next
   If q = 0 Then
      Color Yellow, Black
      Print "-none-"
   End If

   ' print totals
   Color White, Black
   Print "------------"
   TotalLine$ = "Files " + FormatString2$(CDbl(f1))
   TotalLine$ = TotalLine$ + " Dirs " + FormatString2$(CDbl(d1))
   TotalLine$ = Left$(TotalLine$, 39)
   Print TotalLine$
   Exit Sub

   TitleHeader:
   Color White, Black
   If l = 1 Then
      Print "Directory     Date        Time       Longfilename"
   Else
      Print "Filename      Date        Time       Longfilename"
   End If
   Print "------------  ----------  --------   ------------"
   Return
End Sub

' Displays ASCII character chart. v1.1a. PD 2006.
'  v1.1a modify unprintable char output for QB64.
Sub AsciiChart
   Color Plain, Black
   Cls
   Color White, Black
   Print "ASCII Chart for characters 1 to 127:"
   For Char = 1 To 127
      DisplayChar$ = Chr$(Char)
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("00" + Var$, 3) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If (Char Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   While INKEYx$ = Nul: Wend
   Color Plain, Black
   Print
   Cls
   Color White, Black
   Print "ASCII Chart for characters 128 to 255:"
   For Char = 128 To 255
      DisplayChar$ = Chr$(Char)
      Var$ = Mid$(Str$(Char), 2)
      Var1$ = Right$("00" + Var$, 3) + " "
      Color Green, Black
      Print Var1$;
      Color Yellow, Black
      Print DisplayChar$;
      Print " ";
      ' check full screen line
      If ((Char - 7) Mod 10) = 0 Then Print
   Next
   Print
   Color White, Black
   Print "Press a key:";
   While INKEYx$ = Nul: Wend
   Print
   Exit Sub
End Sub

' calculate byte suffix.
Function Suffix$ (Var)
   Dim Var3 As Double
   ' Var - input value
   ' SuffixType - 0 = bytes, 1 = kilo, 2 = mega, 3 = giga
   Rem B  (Byte) = 00x - 0FFx
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB
   Rem GB (Gigabyte) = 1024 MB

   ' 1.#INF and -1.#INF and -1.#IND and 1#QNAN
   If InStr(Str$(Var), "#") Then
      Suffix$ = LTrim$(Str$(Var))
      Exit Function
   End If

   ' check sign
   If Var < False Then
      Suffix$ = " -1B"
      Exit Function
   End If

   ' check bytes.
   Var3 = Var
   If SuffixType = False Then
      Suffix$ = FormatString2$(Var3) + " B"
      Exit Function
   End If

   ' calculate byte suffix.
   TempA = False
   Do
      If Var3 >= ByteDivisor2 Then
         Var3 = Var3 / ByteDivisor2
         TempA = TempA + 1
         If TempA >= SuffixType Then
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop

   ' calculate byte string
   '   Var2$ = FormatString2$(Var3)
   If TempA = 3 Then
      Var3 = Var3 + .1
   End If
   Var2$ = FormatString2$(Var3)
   If InStr(Var2$, ".") Then
      Var2$ = Left$(Var2$, InStr(Var2$, ".") + 1)
   End If
   Var$ = "B"
   Select Case TempA
      Case 1
         Var$ = "KB"
      Case 2
         Var$ = "MB"
      Case 3
         Var$ = "GB"
   End Select
   ' append suffix.
   Suffix$ = Var2$ + " " + Var$
End Function

' calculate byte suffix
Sub Suffix (Var#, Var3$)

   Rem B  (Byte) = 00x - 0FFx (hexidecimal zero-based)
   Rem KB (Kilobyte) = 1024 B
   Rem MB (Megabyte) = 1024 KB (1 MB B)
   Rem GB (Gigabyte) = 1024 MB
   Rem TB (Terabyte) = 1024 GB (1 MB MB)
   Rem PB (Petabyte) = 1024 TB
   Rem EB (Exabyte) = 1024 PB (1 MB TB)
   Rem ZB (Zettabyte) = 1024 EB
   Rem YB (Yottabyte) = 1024 ZB (1 MB EB)

   ' 1.#INF and -1.#INF and -1.#IND and 1#QNAN
   If InStr(Str$(Var#), "#") Then
      Var3$ = LTrim$(Str$(Var#))
      Exit Sub
   End If

   ' check double
   VarX# = Var#
   s$ = Str$(VarX#)
   If InStr(s$, "D") Then
      Var3$ = s$
      Exit Sub
   End If

   ' get sign
   If VarX# < DFalse Then
      Sign = True
      VarX# = Abs(VarX#)
   End If

   ' calculate bytes
   TempA = False
   Do
      If VarX# >= ByteDivisor Then
         VarX# = VarX# / ByteDivisor
         TempA = TempA + 1
         If TempA = 8 Then
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop

   ' calculate byte string
   Var3$ = FormatString2$(VarX#)
   If InStr(Var3$, ".") Then
      Var3$ = Left$(Var3$, InStr(Var3$, ".") + 1)
   Else
      Var3$ = Var3$ + ".0"
   End If

   ' calculate byte suffix
   Var$ = Nul
   If TempA > 0 Then
      Var$ = Mid$("KMGTPEZY", TempA, 1)
   End If
   Var3$ = Var3$ + " " + Var$ + "B"

   ' calculate byte sign
   If Sign Then
      Var3$ = "-" + Var3$
   End If
End Sub

' formats a double numeric string
Function FormatString2$ (s#)
   x$ = Nul
   s$ = Str$(s#)
   If InStr(s$, "D") Then ' return string
      FormatString2$ = s$
      Exit Function
   End If
   If Left$(s$, 1) = "-" Then ' store sign
      e$ = "-"
      s$ = Mid$(s$, 2)
   End If
   s$ = LTrim$(s$) ' format string
   If InStr(s$, ".") Then
      q$ = Mid$(s$, InStr(s$, "."))
      s$ = Left$(s$, InStr(s$, ".") - 1)
   End If
   For l = Len(s$) To 3 Step -3
      x$ = Mid$(s$, l - 2, 3) + "," + x$
   Next
   If l > 0 Then
      x$ = Mid$(s$, 1, l) + "," + x$
   End If
   If Len(s$) < 3 Then
      x$ = s$
   End If
   If Right$(x$, 1) = "," Then
      x$ = Left$(x$, Len(x$) - 1)
   End If
   x$ = e$ + x$ + q$ ' construct string
   FormatString2$ = x$
End Function


