REM Memory Usage Monitor

_DEFINE A-Z AS _UNSIGNED _INTEGER64

DECLARE LIBRARY "mem"
    FUNCTION MemInUsePercent~&&
    FUNCTION TotalPhysicalMem~&&
    FUNCTION FreePhysicalMem~&&
    FUNCTION TotalPagingFile~&&
    FUNCTION FreePagingFile~&&
    FUNCTION TotalVirtualMem~&&
    FUNCTION FreeVirtualMem~&&
    FUNCTION FreeExtendedMem~&&
    FUNCTION GetCPULoad#
END DECLARE

' byte suffix type
DIM SHARED Var2 AS INTEGER

' check os
IF INSTR(_OS$, "[WINDOWS]") = 0 THEN
    PRINT "This program only works in Windows."
    END
END IF
IF INSTR(_OS$, "[ANDROID]") THEN
    PRINT "This program only works in Windows."
    END
END IF

_TITLE "MEMORY USAGE"
DO
    _DELAY 1
    I$ = INKEY$
    IF _EXIT OR I$ = CHR$(27) THEN
        END
    END IF
    CLS
    COLOR 14, 0
    PRINT "Press <escape> to quit."
    PRINT
    COLOR 15, 0

    ' GetCPULoad = 0 is idle, 1 is fully used.
    '  Multiply by 100 for a percentage
    '    PRINT "CPU used:"; STR$(INT(GetCPULoad * 10000) / 100); "%"

    PRINT "CPU used:";
    S$ = STR$(INT(GetCPULoad * 10000) / 100) ' 100.00
    IF INSTR(S$, ".") THEN
        X$ = MID$(S$, INSTR(S$, ".") + 1)
        S$ = LEFT$(S$, INSTR(S$, ".") - 1)
        X$ = LEFT$(X$, 3)
        S$ = S$ + "." + X$
    ELSE
        S$ = S$ + ".0"
    END IF
    PRINT S$; "%" ' 100.00

    PRINT "Memory used:"; STR$(MemInUsePercent); "%"
    PRINT

    PRINT "Total Physical Memory: "
    T = TotalPhysicalMem
    GOSUB DisplayBytes

    PRINT "Free Physical Memory: "
    T = FreePhysicalMem
    GOSUB DisplayBytes

    PRINT "Total Paging File: "
    T = TotalPagingFile
    GOSUB DisplayBytes

    PRINT "Free Paging File: "
    T = FreePagingFile
    GOSUB DisplayBytes

    PRINT "Total Virtual Memory: "
    T = TotalVirtualMem
    GOSUB DisplayBytes

    PRINT "Free Virtual Memory:"
    T = FreeVirtualMem
    GOSUB DisplayBytes

    ' always seems to be zero:
    '    PRINT "Free Extended Virtual Memory:"
    '    T = FreeExtendedMem
    '    GOSUB DisplayBytes
LOOP
END

' format output line
DisplayBytes:
S$ = ""
FOR Var2 = 0 TO 3
    S$ = S$ + ByteFormat$(T)
NEXT
PRINT S$
RETURN

' format byte for output line
FUNCTION ByteFormat$ (S)
T$ = Suffix$(S)
SELECT CASE Var2
    CASE 0 ' bytes
        ' 1,234,567,789
        T$ = SPACE$(15 - LEN(T$)) + T$
    CASE 1 ' kilo
        ' 4,567,789.0 KB
        T$ = SPACE$(16 - LEN(T$)) + T$
    CASE 2 ' mega
        ' 7,789.01 MB
        T$ = SPACE$(13 - LEN(T$)) + T$
    CASE 3 ' giga
        ' 9.012 GB
        T$ = SPACE$(10 - LEN(T$)) + T$
END SELECT
ByteFormat$ = T$
END FUNCTION

' calculate byte suffix.
FUNCTION Suffix$ (Var)
DIM Var3 AS SINGLE
' Var - input value
' Var2 - 0 = bytes, 1 = kilo, 2 = mega, 3 = giga
REM B  (Byte) = 00x - 0FFx
REM KB (Kilobyte) = 1024 B
REM MB (Megabyte) = 1024 KB
REM GB (Gigabyte) = 1024 MB

' check exponent.
Var3 = CSNG(Var)
s$ = STR$(Var3)
IF INSTR(s$, "D") THEN
    Suffix$ = s$
    EXIT FUNCTION
END IF

' check bytes.
IF Var2 = 0 THEN
    Suffix$ = FormatString$(Var)
    EXIT FUNCTION
END IF

' calculate byte suffix.
FOR TempA = 1 TO Var2
    Var3 = Var3 / 1024
NEXT

' calculate byte string
Suffix$ = FormatString$(Var3)

' make byte suffix.
Var$ = ""
SELECT CASE Var2
    CASE 1
        Var$ = "KB"
    CASE 2
        Var$ = "MB"
    CASE 3
        Var$ = "GB"
END SELECT

' get single precision decimal place.
IF INT(Var3) <> Var3 THEN
    x$ = STR$(Var3)
    x = INSTR(x$, ".")
    x$ = MID$(x$, x)
    SELECT CASE Var2
        CASE 1 ' KB
            x$ = LEFT$(x$, 2)
        CASE 2 ' MB
            x$ = LEFT$(x$, 3)
        CASE 3 ' GB
            x$ = LEFT$(x$, 4)
    END SELECT
    Suffix$ = Suffix$ + x$
ELSE
    Suffix$ = Suffix$ + ".0"
END IF

' append suffix.
Suffix$ = Suffix$ + " " + Var$
END FUNCTION

' formats a numeric string.
FUNCTION FormatString$ (s)
x$ = ""
s$ = STR$(s)
s$ = LTRIM$(s$)
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
FormatString$ = x$
END FUNCTION

