REM file: Copyit.bas - Public Domain QB64 Utility v9.0a r7.0a 2018.

REM v9.0a r7.0a updates:
REM    Adds /zc to not copy compressed files.
REM    Adds /ze to not copy encrypted files.
REM
REM v9.0a r6.0a updates:
REM    Adds /xc to copy only compressed files.
REM    Adds /xe to copy only encrypted files.
REM
REM v9.0a r5.0a updates:
REM    Now preserves unicode filenames.
REM    Now also preserves unicode directories.
REM    Adds break option to break trap.
REM
REM v9.0a r4.0a updates:
REM    Adds quit option to disk full error.
REM    Now copies ambiguated unicode filenames.
REM    Fixes switches in moreprompt.
REM
REM v9.0a r3.0a updates:
REM    Adds skip all to copy prompt.
REM    Extends moreprompts to be verbose.
REM    Adds /-5 switch to skip all.
REM
REM v9.0a updates:
REM    Repairs call to parameter in CreateDirectory()
REM    Successful test with large database using /b3 and with
REM      source/dest both netpath excluding *.* to copy
REM      directory structure only.
REM
REM v8.0a updates:
REM    Fixes memory leak in CreateDirectory()
REM    Only attempts to createdir if not exist.
REM
REM v7.0 updates:
REM    Fixes flags in excluded filelists
REM    Only copies directories with specified files using /b3
REM
REM v6.0 updates:
REM    Added check for error x3E6 during CreateDir
REM    Adds Startdir$ for default directory
REM    Edits Curdir$ in Readconfig
REM    (Initial port from v5.5a to 32-bit 10/01/2016.)

' default integer variables
DEFINT A-Z

' dimension variables at runtime
REM $DYNAMIC

' make windows title
_TITLE "COPYIT"

' define boolean values
CONST True = -1
CONST False = 0
CONST SFalse = 0!
CONST DFalse = 0#
CONST Nul = ""

' define color values
CONST Black = 0
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' define filelist constant
CONST RecurseLevel = 8

' define version value
CONST Version$ = "v9.0a"
CONST Release$ = "r7.0a"

' declare filename buffer
CONST buflen = 4096 ' can be changed
DIM SHARED fbuffer AS STRING * BUFLEN

' declare filename strings
DIM SHARED ASCIIZcopy AS STRING * 260
DIM SHARED ASCIIZfile AS STRING * 260

' declare drive variables
DIM SHARED Current.Drive AS STRING * 1
DIM SHARED Drive.Search AS STRING * 1

' declare default directory variables
DIM SHARED StartDir AS STRING

' declare filename variables
DIM SHARED File.Create AS INTEGER
DIM SHARED Filename.Search AS STRING * 260

' declare exclusion flag variables
DIM SHARED Number.Excluded AS INTEGER
DIM SHARED Max.Excluded AS INTEGER
DIM SHARED Check.Flag AS INTEGER
DIM SHARED Pattern.Flag AS INTEGER
DIM SHARED Exclude.Flag AS INTEGER
DIM SHARED Synched.Flag AS INTEGER
DIM SHARED Range.Flag AS INTEGER
DIM SHARED Size.Flag AS INTEGER

' declare filename arrays
DIM SHARED Excluded.Files(1) AS STRING * 128
DIM SHARED Parameters(1) AS STRING * 348
DIM SHARED Skip.Filenames(1) AS STRING * 12

' declare ascii arrays
DIM SHARED Convert.Ascii(10, 1) AS INTEGER
DIM SHARED Strip.Ascii(1) AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Disk.Full AS INTEGER
DIM SHARED Error.Level AS INTEGER
DIM SHARED Imbedded AS INTEGER
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER
DIM SHARED Quote AS STRING * 1

' declare work variables
DIM SHARED Continue.Searching AS INTEGER
DIM SHARED Continuous.Display AS INTEGER
DIM SHARED Continuous.Display2 AS INTEGER
DIM SHARED Continuous.Display3 AS INTEGER
DIM SHARED Double.Line AS INTEGER
DIM SHARED Dot.Count AS INTEGER
DIM SHARED Dot.Total AS INTEGER
DIM SHARED Files.Counted AS DOUBLE
DIM SHARED More.Display AS INTEGER
DIM SHARED Dirs.Counted AS DOUBLE
DIM SHARED Dirs.Created AS DOUBLE
DIM SHARED Total.Deleted AS DOUBLE
DIM SHARED Quit.Searching AS INTEGER
DIM SHARED Skip.All AS INTEGER
DIM SHARED Control.Break AS INTEGER

' declare file synchronize work variables
DIM SHARED Synch.Files AS INTEGER
DIM SHARED Synch.Files1 AS INTEGER, Synch.Files2 AS INTEGER
DIM SHARED Synch.Files3 AS INTEGER, Synch.Files4 AS INTEGER
DIM SHARED Synch.Files5 AS INTEGER, Synch.Files6 AS INTEGER
DIM SHARED Synch.Files7 AS INTEGER, Synch.Files8 AS INTEGER
DIM SHARED Synch.Files9 AS INTEGER, Synch.FilesA AS INTEGER
DIM SHARED Synch.FilesB AS INTEGER, Synch.FilesC AS INTEGER
DIM SHARED Synch.Type1 AS INTEGER, Synch.Type2 AS INTEGER
DIM SHARED Synch.Type3 AS INTEGER

' declare search work variables
DIM SHARED Search.Date AS INTEGER, Search.Time AS INTEGER
DIM SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
DIM SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE
DIM SHARED File.Size AS DOUBLE, Recurse.Directories AS INTEGER

' declare pattern search work variables
DIM SHARED Pattern.Filename AS STRING
DIM SHARED Pattern.Match AS INTEGER
DIM SHARED Pattern.Search.Date AS INTEGER
DIM SHARED Pattern.Search.From.Date AS STRING
DIM SHARED Pattern.Search.To.Date AS STRING
DIM SHARED Pattern.Search AS INTEGER

' declare attribute search variables
DIM SHARED Display.Attribute AS INTEGER, Display.Hidden AS INTEGER
DIM SHARED Display.System AS INTEGER, Display.Readonly AS INTEGER
DIM SHARED Display.Archive AS INTEGER, Display.Any AS INTEGER
DIM SHARED Display.Compressed AS INTEGER, Display.Encrypted AS INTEGER
DIM SHARED No.Display.Archive AS INTEGER, No.Display.Readonly AS INTEGER
DIM SHARED No.Display.System AS INTEGER, No.Display.Hidden AS INTEGER
DIM SHARED No.Display.Any AS INTEGER, File.Attribute AS _UNSIGNED LONG
DIM SHARED No.Display.Compressed AS INTEGER, No.Display.Encrypted AS INTEGER

' declare destination attribute work variables
DIM SHARED Dir.Attribute AS _UNSIGNED LONG, Set.Dest.Archive AS INTEGER
DIM SHARED Set.Dest.Readonly AS INTEGER, Set.Dest.System AS INTEGER
DIM SHARED Set.Dest.Hidden AS INTEGER, Set.Dest.Any AS INTEGER
DIM SHARED Clear.Dest.Archive AS INTEGER, Clear.Dest.Readonly AS INTEGER
DIM SHARED Clear.Dest.System AS INTEGER, Clear.Dest.Hidden AS INTEGER
DIM SHARED Clear.Dest.Any AS INTEGER, Dest.Attribute AS _UNSIGNED LONG

' declare source attribute work variables
DIM SHARED Source.Attribute AS _UNSIGNED LONG, Set.Source.Archive AS INTEGER
DIM SHARED Set.Source.Readonly AS INTEGER, Set.Source.System AS INTEGER
DIM SHARED Set.Source.Hidden AS INTEGER, Set.Source.Any AS INTEGER
DIM SHARED Clear.Source.Archive AS INTEGER, Clear.Source.Readonly AS INTEGER
DIM SHARED Clear.Source.System AS INTEGER, Clear.Source.Hidden AS INTEGER
DIM SHARED Clear.Source.Any AS INTEGER, Set.Source.Attribute AS INTEGER

' declare work variables
DIM SHARED Overwrite.Prompt AS INTEGER, Debug.ModeX AS INTEGER
DIM SHARED Dont.Overwrite AS INTEGER, Debug.Mode AS INTEGER
DIM SHARED Dot.Mode AS INTEGER, Rate.Mode AS INTEGER
DIM SHARED Start.Time AS SINGLE, Stop.Time AS SINGLE
DIM SHARED Time.Elapsed AS SINGLE, Percent.Display AS INTEGER
DIM SHARED Percent AS SINGLE, Percent.Flag AS INTEGER
DIM SHARED Progress.Bar AS INTEGER, Current.Progress AS INTEGER
DIM SHARED Display.Errors AS INTEGER, Last.Percent AS SINGLE
DIM SHARED Display.Header AS INTEGER, Title.Percent AS STRING

' declare copy work variables
DIM SHARED Display.Lowercase AS INTEGER, Copy.Ascii AS INTEGER
DIM SHARED Ascii.Strips AS INTEGER, Ascii.Filters AS INTEGER
DIM SHARED Max.Filters AS INTEGER, Max.Strips AS INTEGER
DIM SHARED Directory.Exists AS INTEGER, Filename.Exists AS INTEGER
DIM SHARED Dir.Copy.Name AS STRING * 260, Dir.Copy.Target AS STRING * 260
DIM SHARED Force.LowerCase AS INTEGER

' declare bytes copied variables
DIM SHARED Bytes.Copied AS DOUBLE
DIM SHARED Total.Bytes AS DOUBLE
DIM SHARED Total.Bytes2 AS DOUBLE

' declare file date/time override work varibles
DIM SHARED Override.Create.Date AS INTEGER
DIM SHARED Override.Access.Date AS INTEGER
DIM SHARED Override.Modify.Date AS INTEGER

DIM SHARED Override.Date.Month AS INTEGER
DIM SHARED Override.Date.Day AS INTEGER
DIM SHARED Override.Date.Year AS INTEGER
DIM SHARED Override.Date AS INTEGER

DIM SHARED Override.Time.Hour AS INTEGER
DIM SHARED Override.Time.Minute AS INTEGER
DIM SHARED Override.Time.Second AS INTEGER
DIM SHARED Override.Time AS INTEGER

DIM SHARED Source.File.Date AS INTEGER
DIM SHARED Source.File.Time AS INTEGER
DIM SHARED Directory.Path AS STRING

DIM SHARED Extended.Time AS INTEGER

' declare copy date/time range work variables
DIM SHARED Compare.Create.Date AS INTEGER
DIM SHARED Compare.Access.Date AS INTEGER
DIM SHARED Compare.Modify.Date AS INTEGER

' declare synchronize date/time work variables
DIM SHARED Synch.File.Create.Date AS SINGLE
DIM SHARED Synch.File.Access.Date AS SINGLE
DIM SHARED Synch.File.Modify.Date AS SINGLE
DIM SHARED Synch.File.Create.Time AS SINGLE
DIM SHARED Synch.File.Access.Time AS SINGLE
DIM SHARED Synch.File.Modify.Time AS SINGLE

' declare synchronize date/time work variables
DIM SHARED Synch.Work.Create.Date AS SINGLE
DIM SHARED Synch.Work.Access.Date AS SINGLE
DIM SHARED Synch.Work.Modify.Date AS SINGLE
DIM SHARED Synch.Work.Create.Time AS SINGLE
DIM SHARED Synch.Work.Access.Time AS SINGLE
DIM SHARED Synch.Work.Modify.Time AS SINGLE

' declare filesize work variables
DIM SHARED Copy.Zero AS INTEGER
DIM SHARED Dest.File.Size AS DOUBLE
DIM SHARED Search.File.Size AS INTEGER
DIM SHARED Search.Size.From AS DOUBLE
DIM SHARED Search.Size.To AS DOUBLE

' declare destination work variables
DIM SHARED Ambiguate.Display AS INTEGER, Append.Handle AS INTEGER
DIM SHARED Copy.Directory AS INTEGER, Copy.Target AS STRING
DIM SHARED Default.Dest AS STRING, Default.Dir AS STRING
DIM SHARED Dest.Dir AS STRING, Dest.File AS STRING
DIM SHARED Display.Path AS INTEGER, Display.Wide AS INTEGER
DIM SHARED Drive.Letter AS INTEGER, Short.Display AS INTEGER
DIM SHARED Short.Display2 AS INTEGER, Short.Display3 AS INTEGER
DIM SHARED Short.Display4 AS INTEGER, Start.Dir AS STRING
DIM SHARED Wide.List AS INTEGER, Title.Header AS STRING
DIM SHARED Skip.Directory AS INTEGER, Current.Directory AS STRING

' declare append variables
DIM SHARED Append.Dest AS INTEGER, Append.Files AS INTEGER
DIM SHARED Byte.Switch AS INTEGER, Byte.Override AS DOUBLE
DIM SHARED Resume.File AS INTEGER

' declare destination work arrays
DIM SHARED Destinate.Directory(1) AS STRING * 260
DIM SHARED Destinate.Filename(1) AS STRING * 260
DIM SHARED Destinate.Netpaths(1) AS STRING * 260

' declare destination work variables
DIM SHARED Max.Dest.Dirs AS INTEGER, Max.Dest.Files AS INTEGER
DIM SHARED Max.Dest.Nets AS INTEGER, Number.Dest.Dirs AS INTEGER
DIM SHARED Number.Dest.Files AS INTEGER, Number.Dest.Nets AS INTEGER
DIM SHARED Default.Net AS STRING * 64, Source.Net AS STRING * 64
DIM SHARED Zero.Dirs AS INTEGER, Zero.Nets AS INTEGER

' declare nest recursion variables
DIM SHARED Nested.Recurse AS INTEGER, Nested.Levels AS INTEGER
DIM SHARED Recursion AS INTEGER, Zero.Nest AS INTEGER
DIM SHARED Recurse.Error AS INTEGER, Max.Recurse AS INTEGER

' declare delete copied files variables
DIM SHARED Continue.Deleting AS INTEGER, Continue.Subdelete AS INTEGER
DIM SHARED Delete.Copied AS INTEGER, Delete.Directory AS INTEGER
DIM SHARED Prompt.Delete1 AS INTEGER, Prompt.Delete2 AS INTEGER
DIM SHARED Deleted.Dirs AS DOUBLE, Deleted.Files AS DOUBLE

' declare DOS command work variables
DIM SHARED DOS.Command(1) AS STRING * 128, Disable.Cmd AS INTEGER
DIM SHARED Max.Commands AS INTEGER, Number.Commands AS INTEGER

' declare ignore switches
DIM SHARED Ignore.Config AS INTEGER, Ignore.Skip AS INTEGER

' declare filelist variables
DIM SHARED Enable.Redirect AS INTEGER, Disable.Prompts AS INTEGER

' declare error variables
DIM SHARED DataError AS INTEGER, Error.Flag AS INTEGER

' declare floppy copy variables (unused).
DIM SHARED Force.Copy AS INTEGER, Prompt.Insert AS INTEGER
DIM SHARED Temp.Drive.Dir AS STRING * 260

' declare debug switches
DIM SHARED DebugDelay AS SINGLE

' declare dos command work variables
REDIM DOS.Command(1 TO 10) AS STRING * 128
REDIM Parameters(1 TO 12) AS STRING * 348

' declare filename arrays
REDIM Skip.Filenames(1 TO 10) AS STRING * 12
REDIM Excluded.Files(1 TO 10) AS STRING * 128

' declare work arrays
REDIM Convert.Ascii(1 TO 10, 1 TO 2) AS INTEGER
REDIM Strip.Ascii(1 TO 10) AS INTEGER

' declare destination work arrays
REDIM Destinate.Directory(1 TO 10) AS STRING * 260
REDIM Destinate.Filename(1 TO 10) AS STRING * 260
REDIM Destinate.Netpaths(1 TO 10) AS STRING * 260

' declare library constants.
CONST MAX_PATH = 260
CONST MAX_PATH2 = 520 ' length of a Unicode ASCIIZ string
CONST INVALID_HANDLE_VALUE = -1

' declare unicode variables
DIM SHARED FileIsUnicode AS INTEGER
DIM SHARED UnicodeShort AS STRING
DIM SHARED UnicodeLong AS STRING

DIM SHARED DirIsUnicode AS INTEGER
DIM SHARED DirUnicodeShort AS STRING
DIM SHARED DirUnicodeLong AS STRING

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' windows structure for a wide FindFile
TYPE WIN32_FIND_DATAW
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH2
    cAlternateFileName AS STRING * 28
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindFirstFileW~%& (lpwszFileName$, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileW& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION MoveFileW (f$, g$)

    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
    FUNCTION GetDiskFreeSpaceExA& (filename$, free AS _UNSIGNED _INTEGER64, total AS _UNSIGNED _INTEGER64, free2 AS _UNSIGNED _INTEGER64)

    FUNCTION DeleteFileA% (F$)
    FUNCTION RemoveDirectoryA% (F$)
    FUNCTION CreateDirectoryA% (F$, BYVAL X%%)
    FUNCTION SetCurrentDirectoryA% (f$)

    FUNCTION CloseHandle& (BYVAL hfile AS _OFFSET)
    FUNCTION GetFileTime& (BYVAL hFile AS _OFFSET, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME)
    FUNCTION SetFileTime& (BYVAL hFile AS _OFFSET, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION SystemTimeToFileTime& (lpSystemTime AS SYSTEMTIME, lpFileTime AS FILETIME)

    FUNCTION GetLastError& ()
END DECLARE

DECLARE LIBRARY
    FUNCTION CreateFile& (filename$, BYVAL access&, BYVAL sharing&, BYVAL sec_attr%&, BYVAL create&, BYVAL flags&, BYVAL template%&)
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
    FUNCTION getcwd$ (buffer$, BYVAL buflen)
END DECLARE

' declare library variables.
DIM SHARED CreateDate AS FILETIME
DIM SHARED AccessDate AS FILETIME
DIM SHARED ModifyDate AS FILETIME

DIM SHARED SourceCreateDate AS FILETIME
DIM SHARED SourceAccessDate AS FILETIME
DIM SHARED SourceModifyDate AS FILETIME

DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' start timer trap.
ON TIMER(1) GOSUB Timer.Trap
TIMER ON
VarQ = _EXIT

' force default path
x$ = _STARTDIR$
StartDir$ = x$
IF RIGHT$(StartDir$, 1) <> "\" THEN
    StartDir$ = StartDir$ + "\"
END IF
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
VarX$ = COMMAND$
IF VarX$ = Nul THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "File list(<enter>=*.*): ";
    LINE INPUT VarX$
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            CALL BootUsage
        ELSE
            VarX$ = VarX$ + Var$
            EXIT DO
        END IF
    LOOP
END IF

' read command line switches
CALL ReadSwitches(VarX$)
Last.Switch = 0
Switch.Exist = 0

' store skip file list
Skip.Filenames(1) = "WIN386.SWP"
Skip.Filenames(2) = "PAGEFILE.SYS"
Skip.Filenames(3) = "HIBERFIL.SYS"
Skip.Filenames(4) = "SWAPFILE.SYS"

' read current drive
Current.Drive = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' store default directory
IF LEFT$(_CWD$, 2) = "\\" THEN
    Default.Dir = _CWD$
ELSE
    Default.Dir = MID$(_CWD$, 3)
END IF

' store default server name
Default.Net = Nul
Var$ = ENVIRON$("COMPUTERNAME")
IF LEN(Var$) THEN
    Default.Net = "\\" + Var$
END IF

' reset number of destination filenames
IF Number.Dest.Files = False THEN
    Number.Dest.Files = 1
    Destinate.Filename(1) = Nul
END IF

' reset number of destination directories
IF Number.Dest.Dirs = False OR Zero.Dirs THEN
    Zero.Dirs = True
    Number.Dest.Dirs = 1
    IF Number.Dest.Nets = False THEN
        Destinate.Directory(1) = Default.Dir
    ELSE
        Destinate.Directory(1) = "\"
    END IF
END IF

' reset and check netpaths
IF Zero.Nets THEN
    Var2$ = RTRIM$(Default.Net)
    IF LEN(Var2$) THEN
        Var2$ = Var2$ + LCASE$(Current.Drive) + "\"
        Number.Dest.Nets = 1
        Destinate.Netpaths(1) = Var2$
    END IF
END IF
IF Number.Dest.Nets = False THEN
    Number.Dest.Nets = 1
    Destinate.Netpaths(1) = Nul
END IF
FOR Count0 = 1 TO Number.Dest.Nets
    Next.Dest.Net$ = Destinate.Netpaths(Count0)
    Next.Dest.Net$ = RTRIM$(Next.Dest.Net$)
    IF Next.Dest.Net$ <> Nul THEN
        ' check netpath
        IF RIGHT$(Next.Dest.Net$, 1) = "\" THEN
            Next.Dest.Net$ = LEFT$(Next.Dest.Net$, LEN(Next.Dest.Net$) - 1)
        END IF
        IF LEFT$(Next.Dest.Net$, 2) <> "\\" THEN
            Next.Dest.Net$ = "\" + Next.Dest.Net$
        END IF
        IF LEFT$(Next.Dest.Net$, 2) <> "\\" THEN
            Next.Dest.Net$ = "\" + Next.Dest.Net$
        END IF
        Destinate.Netpaths(Count0) = Next.Dest.Net$
    END IF
NEXT

' check /d omitted or specified w/o parameters
IF Zero.Dirs THEN
    ' compare /g\\serv\c\ to default.net
    IF Number.Dest.Nets = 1 THEN
        Var1$ = RTRIM$(Destinate.Netpaths(1))
        IF LEN(Var1$) THEN
            Var1$ = UCASE$(Var1$) + "\"
            Var2$ = RTRIM$(Default.Net)
            IF LEN(Var2$) THEN
                Var2$ = UCASE$(Var2$) + Current.Drive + "\"
                IF Var1$ = Var2$ THEN
                    Destinate.Directory(1) = Default.Dir
                END IF
            END IF
        END IF
    END IF
END IF

' store time copying began
Start.Time = TIMER

' search filespecs
DO

    ' store input filename
    Stored.Command.Line$ = Command.Line

    ' create filenames
    CALL MakeFilename

    ' locate filelist character
    Command.Out$ = Command.Work

    ' check filelist character
    Flag = FilelistIS(Command.Out$)
    IF Flag AND Enable.Redirect THEN

        ' reset recurse counter
        Max.Recurse = 0

        ' process work filename containing filelist
        CALL ProcessFilelist(Command.Out$, -1)

        ' check overwrite flag
        IF Quit.Searching THEN
            Error.Level = 1
            GOTO End.Copy
        END IF
    ELSE

        ' process filename
        CALL ProcessCommand(Quit)

        ' check overwrite flag
        IF Quit OR Quit.Searching THEN
            Error.Level = 1
            GOTO End.Copy
        END IF
    END IF

    ' check command line
    IF Command.Line = Nul THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

' program end label
End.Copy:

' check append files
IF Append.Files THEN
    CALL CloseFile(-1)
END IF

' calculate time elapsed during file copying
Stop.Time = TIMER
Time.Elapsed = Stop.Time - Start.Time

' check timing past midnight
IF Time.Elapsed < SFalse THEN
    Time.Elapsed = Time.Elapsed + 86400! ' add one day of seconds
END IF

' display end program
IF Continuous.Display = False THEN
    IF Wide.List THEN
        Wide.List = False
        PRINT
    END IF
    COLOR Yellow, Black

    IF Continuous.Display2 = False THEN
        PRINT "Directories copied: ";
        PRINT FormatString$(Dirs.Counted)
        IF Dirs.Created > 0 THEN
            PRINT "Directories created: ";
            PRINT FormatString$(Dirs.Created)
        END IF
        IF Double.Line >= 4 THEN
            PRINT "Directories deleted: ";
            PRINT FormatString$(Total.Deleted)
        END IF
        PRINT "Files copied: ";
        PRINT FormatString$(Files.Counted)
        IF Double.Line >= 4 THEN
            PRINT "Bytes counted: ";
            PRINT FormatString$(Bytes.Copied)
            PRINT "Bytes copied: ";
            PRINT FormatString$(Total.Bytes)
            IF Deleted.Files > 0# THEN
                PRINT "Files deleted: ";
                PRINT FormatString$(Deleted.Files)
            END IF
        END IF
    END IF

    ' check to display time/rate
    IF Rate.Mode THEN
        ' display transfer time
        CALL Time.Display1

        ' display transfer rate
        CALL Time.Display2
    END IF

    ' prompt to exit Copyit
    Prompt$ = "Press <enter> to exit to DOS:"
    CALL MorePrompt(Prompt$, CHR$(13), Outpt$, CHR$(13))
END IF

' reset color
COLOR Plain, Black

' exit in debug mode
IF Debug.Mode THEN
    SYSTEM
END IF

' return error level to DOS
SELECT CASE Error.Level
    CASE 1
        END 8
    CASE -1
        END 4
    CASE 0
        IF Files.Counted = DFalse THEN
            END 2
        ELSE
            END 0
        END IF
END SELECT
END 2

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Copyit " + Version$ + " " + Release$ + ": File copy utility; "
END IF
RETURN

' timer ctrl-break trap.
Timer.Trap:
VarQ = _EXIT
IF VarQ THEN ' Control-Break
    Prompt$ = "Press B to break, C to continue, Q to quit:"
    CALL MorePrompt(Prompt$, "bqc", Outpt$, "c")
    IF Outpt$ = "b" THEN
        Control.Break = True
    END IF
    IF Outpt$ = "q" THEN
        SYSTEM
    END IF
END IF
RETURN

' critical error trap
Error.Routine:
' process error
DataError = ERR
IF Error.Flag THEN
    RESUME NEXT
END IF
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
' display error
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$, "c")
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Copy
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' clear display progress
SUB ClearDisplay (Var)
' break wide list
IF Var = 0 THEN
    IF Wide.List THEN
        Wide.List = False
        PRINT
    END IF
END IF
' clear dots
FOR Count = 1 TO Dot.Count
    PRINT CHR$(29); " "; CHR$(29);
NEXT
' clear percent display
IF Percent.Display THEN
    IF Percent.Flag THEN
        FOR Imbedded = 1 TO 4
            PRINT CHR$(29); " "; CHR$(29);
        NEXT
    END IF
END IF
' clear progress bar
IF Progress.Bar THEN
    FOR Imbedded = 1 TO Current.Progress
        PRINT CHR$(29); " "; CHR$(29);
    NEXT
END IF
Dot.Count = False
Dot.Total = False
Count.Forward = True
Current.Progress = False
END SUB

' process filelist recursively
SUB ProcessFilelist (Command.Out$, PromptFlag)
DIM ASCIIZ AS STRING * 260
DIM hfind AS _OFFSET

' check recurse error
IF Max.Recurse >= RecurseLevel THEN
    EXIT SUB
END IF

' process work filename
Var$ = Nul
IF Command.Out$ <> Nul THEN
    IF _FILEEXISTS(Command.Out$) THEN
        Var$ = Command.Out$
    END IF
END IF

' check filelist exists
IF Var$ <> Nul THEN

    ' concatenate work filename
    Var$ = Command.Work ' command line filename
    FOR Var = LEN(Var$) TO 1 STEP -1
        IF MID$(Var$, Var, 1) = "\" THEN
            Var$ = MID$(Var$, Var + 1)
            EXIT FOR
        END IF
    NEXT
    IF MID$(Var$, 2, 1) = ":" THEN
        Var$ = MID$(Var$, 3)
    END IF
    Filename2$ = Var$
    Var$ = MID$(Var$, 2)
    Var2$ = Command.Out$
    FOR Var = LEN(Var2$) TO 1 STEP -1
        IF MID$(Var2$, Var, 1) = "\" THEN
            Var2$ = LEFT$(Var2$, Var)
            Var$ = Var2$ + Var$
            EXIT FOR
        END IF
    NEXT

    ' check filename
    CALL CheckFile(Filename2$, True)
    IF Check.Flag = False THEN
        Var$ = Nul
    END IF

    ' prompt for filelist
    IF Disable.Prompts = False THEN
        IF Var$ <> Nul THEN
            IF PromptFlag THEN
                ' prompt to use filelist
                Prompt$ = "Use '" + LCASE$(Var$) + "' as filelist(y)es,(n)o,(q)uit?"
                CALL MorePrompt(Prompt$, "ynq", Outpt$, "y")
                SELECT CASE Outpt$
                    CASE "q"
                        Quit.Searching = True
                        EXIT SUB
                    CASE "n"
                        Var$ = Nul
                        EXIT SUB
                END SELECT
            END IF
        END IF
    END IF
END IF

' check filelist exists
IF Var$ = Nul THEN

    ' restore original command line
    Command.Line = Stored.Command.Line$

    ' create filenames
    CALL MakeFilename

    ' continue processing filename
    EXIT SUB
END IF

' open filename list
x = 0
ASCIIZ = Command.Out$ + CHR$(0)
hfind = CreateFile(ASCIIZ, &H180, &H3, 0, 3, 0, 0)
IF hfind <> INVALID_HANDLE_VALUE THEN
    x = CloseHandle(hfind)
END IF
IF x = 0 THEN
    ' display filename error
    CALL DisplayError("Error" + STR$(GetLastError&) + " opening listfile.")
    EXIT SUB
END IF

V = FREEFILE
DataError = False
Error.Flag = True
OPEN Command.Out$ FOR INPUT SHARED AS #V
Error.Flag = False

' check error flag
IF DataError THEN
    ' display filename error
    CALL DisplayError("Error" + STR$(DataError) + " opening listfile.")
    EXIT SUB
END IF

' check recursion level
Max.Recurse = Max.Recurse + 1
IF Max.Recurse >= RecurseLevel THEN
    CALL DisplayError("Recursive filelist error.")
    EXIT SUB
END IF

' process input filenames
DO UNTIL EOF(V)

    ' read next filename from input file
    LINE INPUT #V, Command.Work
    Command.Work = RTRIM$(Command.Work)

    ' check input
    IF LEN(Command.Work) THEN

        ' locate filelist character
        Var2$ = Command.Work
        Flag = FilelistIS(Var2$)
        IF Flag THEN
            ' recursively call filelist
            CALL ProcessFilelist(Var2$, 0)
        ELSE
            ' process filename
            CALL ProcessCommand(Quit)
        END IF

        ' check overwrite flag
        IF Quit OR Quit.Searching THEN
            Error.Level = 1
            EXIT DO
        END IF
    END IF
LOOP
CLOSE #V

' check recursion level
Max.Recurse = Max.Recurse - 1
END SUB

' return -1 for filelist character
FUNCTION FilelistIS (Command.Out$)
Flag = False
Command.Out2$ = Nul
IF MID$(Command.Out$, 2, 1) = ":" THEN
    Command.Out2$ = LEFT$(Command.Out$, 2)
    Command.Out$ = MID$(Command.Out$, 3)
END IF
IF LEFT$(Command.Out$, 1) = "@" THEN
    Flag = True
    Command.Out$ = MID$(Command.Out$, 2)
ELSE
    FOR Var = LEN(Command.Out$) TO 1 STEP -1
        IF MID$(Command.Out$, Var, 1) = "\" THEN
            Char$ = MID$(Command.Out$, Var + 1)
            IF LEFT$(Char$, 1) = "@" THEN
                Flag = True
                Command.Out$ = LEFT$(Command.Out$, Var) + MID$(Char$, 2)
            END IF
            EXIT FOR
        END IF
    NEXT
END IF
IF LEN(Command.Out2$) THEN
    Command.Out$ = Command.Out2$ + Command.Out$
END IF
FilelistIS = Flag
END FUNCTION

' routine to copy a filename
SUB CopyFiles (Next.Dest.Net$, Source.Directory$, Source.Filename$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM ASCIIZwrite AS STRING * 260
DIM Handle AS INTEGER
DIM Number.Bytes AS INTEGER
DIM Sum.Bytes AS DOUBLE
DIM Sum.Bytes2 AS DOUBLE

' make filename
Temp.Net$ = RTRIM$(Source.Net)
IF Temp.Net$ = Nul THEN
    ASCIIZ = Source.Directory$ + Source.Filename$ + CHR$(0)
ELSE
    IF LEFT$(Directory.Search$, 1) = "\" THEN
        ASCIIZ = Temp.Net$ + Source.Directory$ + Source.Filename$ + CHR$(0)
    ELSE
        ASCIIZ = Temp.Net$ + "\" + Source.Directory$ + Source.Filename$ + CHR$(0)
    END IF
END IF

' read file attributes
Attribute = GetFileAttributes(ASCIIZ)

' check directory
IF (Attribute AND &H10) = &H10 THEN
    EXIT SUB
END IF

' store file attribute
Source.Attribute = Attribute

' check file attribute
IF Display.Attribute THEN

    ' check for readonly file
    IF Display.Readonly = True THEN
        IF (Attribute AND 1) <> 1 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Readonly = True THEN
        IF (Attribute AND 1) = 1 THEN
            EXIT SUB
        END IF
    END IF

    ' check for hidden file
    IF Display.Hidden = True THEN
        IF (Attribute AND 2) <> 2 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Hidden = True THEN
        IF (Attribute AND 2) = 2 THEN
            EXIT SUB
        END IF
    END IF

    ' check for system file
    IF Display.System = True THEN
        IF (Attribute AND 4) <> 4 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.System = True THEN
        IF (Attribute AND 4) = 4 THEN
            EXIT SUB
        END IF
    END IF

    ' check for archive file
    IF Display.Archive = True THEN
        IF (Attribute AND &H20) <> &H20 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Archive = True THEN
        IF (Attribute AND &H20) = &H20 THEN
            EXIT SUB
        END IF
    END IF

    ' check for compressed file
    IF Display.Compressed = True THEN
        IF (Attribute AND &H800) <> &H800 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Compressed = True THEN
        IF (Attribute AND &H800) = &H800 THEN
            EXIT SUB
        END IF
    END IF

    ' check for encrypted file
    IF Display.Encrypted = True THEN
        IF (Attribute AND &H4000) <> &H4000 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Encrypted = True THEN
        IF (Attribute AND &H4000) = &H4000 THEN
            EXIT SUB
        END IF
    END IF

    ' check for no attributes
    IF Display.Any = True THEN
        IF (Attribute AND 1) = 1 THEN
            EXIT SUB
        END IF
        IF (Attribute AND 2) = 2 THEN
            EXIT SUB
        END IF
        IF (Attribute AND 4) = 4 THEN
            EXIT SUB
        END IF
        IF (Attribute AND &H20) = &H20 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Any = True THEN
        IF (Attribute AND 1) = False THEN
            IF (Attribute AND 2) = False THEN
                IF (Attribute AND 4) = False THEN
                    IF (Attribute AND &H20) = False THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF

' reset destination file attribute
IF Set.Dest.Readonly THEN
    Attribute = Attribute OR 1
END IF
IF Set.Dest.Hidden THEN
    Attribute = Attribute OR 2
END IF
IF Set.Dest.System THEN
    Attribute = Attribute OR 4
END IF
IF Set.Dest.Archive THEN
    Attribute = Attribute OR &H20
END IF
IF Set.Dest.Any THEN
    Attribute = Attribute OR &H27
END IF
IF Clear.Dest.Readonly THEN
    Attribute = Attribute AND NOT 1
END IF
IF Clear.Dest.Hidden THEN
    Attribute = Attribute AND NOT 2
END IF
IF Clear.Dest.System THEN
    Attribute = Attribute AND NOT 4
END IF
IF Clear.Dest.Archive THEN
    Attribute = Attribute AND NOT &H20
END IF
IF Clear.Dest.Any THEN
    Attribute = Attribute AND NOT &H27
END IF

' reset source file attribute
IF Set.Source.Readonly THEN
    Source.Attribute = Source.Attribute OR 1
END IF
IF Set.Source.Hidden THEN
    Source.Attribute = Source.Attribute OR 2
END IF
IF Set.Source.System THEN
    Source.Attribute = Source.Attribute OR 4
END IF
IF Set.Source.Archive THEN
    Source.Attribute = Source.Attribute OR &H20
END IF
IF Set.Source.Any THEN
    Source.Attribute = Source.Attribute OR &H27
END IF
IF Clear.Source.Readonly THEN
    Source.Attribute = Source.Attribute AND NOT 1
END IF
IF Clear.Source.Hidden THEN
    Source.Attribute = Source.Attribute AND NOT 2
END IF
IF Clear.Source.System THEN
    Source.Attribute = Source.Attribute AND NOT 4
END IF
IF Clear.Source.Archive THEN
    Source.Attribute = Source.Attribute AND NOT &H20
END IF
IF Clear.Source.Any THEN
    Source.Attribute = Source.Attribute AND NOT &H27
END IF

' check file size range
CALL CheckSizeRange(Varble)

' check return flag
IF Size.Flag THEN
    EXIT SUB
END IF

' store file date and time
x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
GOSUB Convert.Date
Synch.Work.Create.Date = Work.Date.Temp!

x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
GOSUB Convert.Date
Synch.Work.Access.Date = Work.Date.Temp!

x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
GOSUB Convert.Date
Synch.Work.Modify.Date = Work.Date.Temp!

x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
GOSUB Convert.Time
Synch.Work.Create.Time = Work.Time.Temp!

x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
GOSUB Convert.Time
Synch.Work.Access.Time = Work.Time.Temp!

x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
GOSUB Convert.Time
Synch.Work.Modify.Time = Work.Time.Temp!

' check date/time range
CALL CheckDateRange(Varble)

' check return flag
IF Range.Flag THEN
    EXIT SUB
END IF

' construct extended date/time string
FileInfo$ = Nul
IF Double.Line >= 1 THEN
    ' make file info
    FileInfo$ = MakeDate(1)
    FileInfo$ = FileInfo$ + "\" + MakeDate(2)
    FileInfo$ = FileInfo$ + "\" + MakeDate(3)
END IF

' store filename being copying
Copy.File$ = Source.Directory$ + Source.Filename$
IF Append.Files THEN
    Copy.Dest$ = Dest.Dir
ELSE
    IF Copy.Directory = False THEN
        Copy.Dest$ = Dest.Dir + Source.Filename$
    ELSE
        Copy.Dest$ = Copy.Target + Source.Filename$
    END IF
    IF Next.Dest.Net$ = Nul THEN
        ASCIIZwrite = Copy.Dest$ + CHR$(0)
    ELSE
        IF LEFT$(Copy.Dest$, 1) = "\" THEN
            ASCIIZwrite = Next.Dest.Net$ + Copy.Dest$ + CHR$(0)
        ELSE
            ASCIIZwrite = Next.Dest.Net$ + "\" + Copy.Dest$ + CHR$(0)
        END IF
    END IF
END IF

' check filename
Filename2$ = Source.Filename$
CALL CheckFile(Filename2$, False)
IF Check.Flag = False THEN
    EXIT SUB
END IF

' make target directory only if files exist
IF Skip.Directory THEN
    CALL CreateDirectory(Next.Dest.Net$)
END IF

' check if appending files
IF Append.Files THEN
    ' store output file info
    IF Next.Dest.Net$ = Nul THEN
        ASCIIZfile = Dest.Dir + CHR$(0)
    ELSE
        IF LEFT$(Dest.Dir, 1) = "\" THEN
            ASCIIZfile = Next.Dest.Net$ + Dest.Dir + CHR$(0)
        ELSE
            ASCIIZfile = Next.Dest.Net$ + "\" + Dest.Dir + CHR$(0)
        END IF
    END IF

    ' check if files similar
    CALL ReadFileSynch

    ' check files
    CALL CheckSynched(Varble)
    IF Synched.Flag THEN
        EXIT SUB
    END IF
ELSE
    ' store output file info
    ASCIIZfile = ASCIIZwrite

    ' check if files similar
    CALL ReadFileSynch

    ' check files
    CALL CheckSynched(Varble)
    IF Synched.Flag THEN
        EXIT SUB
    END IF
END IF

' verify/display filename
CALL CheckFileExists(Next.Dest.Net$, Copy.File$, Copy.Dest$, Response)
IF Response = False AND Skip.All THEN
    Eat$ = Nul
ELSE
    CALL FilenameCopying(Next.Dest.Net$, Copy.File$, Copy.Dest$)
END IF

' check copying flag
IF Filename.Exists THEN
    EXIT SUB
END IF

' get filename date/time
ASCIIZcopy = ASCIIZ
CALL ExtendedFile(1)

' reset flag error
Handle = 0

' open file for input
Open.Filename$ = ASCIIZ
V = INSTR(Open.Filename$, CHR$(0))
IF V THEN
    Open.Filename$ = LEFT$(Open.Filename$, V - 1)
END IF
Handle = FREEFILE

DataError = False
Error.Flag = True
OPEN Open.Filename$ FOR BINARY SHARED AS #Handle
Error.Flag = False

' check error flag
IF DataError THEN
    Handle = 0
END IF

' check open file error
IF Handle = 0 THEN
    ' display any error
    IF Debug.Mode THEN
        IF DataError <> 70 THEN ' ignore share violation
            CALL DisplayError("Error" + STR$(DataError) + " opening input filename.")
        END IF
    END IF
    EXIT SUB
END IF

' set seek position to start of file
SeekPosition# = 1#

' check byte position override
IF Byte.Switch THEN
    ' offset from specified byte position
    SeekPosition# = Byte.Override
END IF

' check byte position override
IF Resume.File THEN
    ' offset from dest. filesize position
    SeekPosition# = Dest.File.Size
END IF

' seek position in input file
SEEK Handle, SeekPosition#

' reset delete file flag
Copy.Error = False

' check if appending files
IF Append.Files THEN
    ' store output file info
    IF Next.Dest.Net$ = Nul THEN
        ASCIIZfile = Dest.Dir + CHR$(0)
    ELSE
        IF LEFT$(Dest.Dir, 1) = "\" THEN
            ASCIIZfile = Next.Dest.Net$ + Dest.Dir + CHR$(0)
        ELSE
            ASCIIZfile = Next.Dest.Net$ + "\" + Dest.Dir + CHR$(0)
        END IF
    END IF
    File.Attribute = Attribute

    ' check to overwrite
    IF Overwrite.Prompt = False THEN
        Copy.File$ = Directory.Search$ + RTRIM$(Filename.Search)
        Copy.Dest$ = Dest.Dir
        CALL PromptOverwrite(Next.Dest.Net$, Copy.File$, Copy.Dest$, Response)
        IF Response = False THEN
            GOTO End.Copy.File1
        END IF
    END IF

    ' open output file
    CALL OpenFile(OpenError)

    ' check error opening output file
    IF OpenError THEN
        EXIT SUB
    END IF
ELSE
    ' store output file info
    ASCIIZfile = ASCIIZwrite
    File.Attribute = Attribute

    ' check to overwrite
    IF Overwrite.Prompt = False THEN
        CALL PromptOverwrite(Next.Dest.Net$, Copy.File$, Copy.Dest$, Response)
        IF Response = False THEN
            GOTO End.Copy.File1
        END IF
    END IF

    ' open output file
    CALL OpenFile(OpenError)

    ' check error opening output file
    IF OpenError THEN
        GOTO End.Copy.File1
    END IF
END IF

' reset error flag
Error.Type = False
Percent.Flag = False
Current.Progress = False

' copy file
Count.Forward = True
Dot.Count = False
Dot.Total = False

' file input loop
DO
    ' reset and store error flag
    DataError = False
    Error.Flag = True

    ' read from file
    Number.Bytes = buflen
    position# = LOC(Handle)
    GET Handle, , fbuffer

    ' restore and check error flag
    Error.Flag = False
    IF DataError THEN
        Error.Type = DataError
        EXIT DO
    END IF

    ' store buffer and length of buffer
    buffer$ = Nul
    IF position# + buflen > LOF(Handle) THEN
        Number.Bytes = LOF(Handle) - position#
    END IF
    IF Number.Bytes > 0 THEN
        buffer$ = LEFT$(fbuffer, Number.Bytes)
    END IF

    ' show disk activity
    IF Continuous.Display = False AND Dot.Mode = False THEN
        Dot.Total = Dot.Total + 1 ' count buflen blocks
        IF Dot.Total >= 256 THEN ' could be increased
            Dot.Total = 0
            IF Count.Forward THEN
                PRINT ".";
                Dot.Count = Dot.Count + 1
                IF Dot.Count = 16 THEN
                    Count.Forward = False
                END IF
            ELSE
                PRINT CHR$(29); " "; CHR$(29);
                Dot.Count = Dot.Count - 1
                IF Dot.Count = False THEN
                    Count.Forward = True
                END IF
            END IF
        END IF
    END IF

    ' add total bytes counted
    Sum.Bytes2 = Sum.Bytes2 + Number.Bytes

    ' check total filesize to copy
    IF File.Size > 0# THEN

        ' check to display percent copied
        P$ = Nul
        Percent = (Sum.Bytes2 / File.Size) * 100!
        Percent = INT(Percent)
        IF Percent = 0 THEN
            IF Percent.Flag = 0 THEN
                P$ = "000%"
                IF Percent.Display THEN
                    PRINT P$;
                    Percent.Flag = True
                END IF
            END IF
        ELSE
            IF Percent <> Last.Percent THEN
                Last.Percent = Percent
                P$ = RIGHT$(STR$(Percent + 1000%), 3) + "%"
                IF Percent.Display THEN
                    IF Percent.Flag THEN
                        FOR Imbedded = 1 TO 4
                            PRINT CHR$(29); " "; CHR$(29);
                        NEXT
                    END IF
                    PRINT P$;
                    Percent.Flag = True
                END IF
            END IF
        END IF

        ' display percent copied on title
        IF LEN(P$) THEN
            IF P$ <> Title.Percent THEN
                Title.Percent = P$
                _TITLE Title.Header + " " + P$
            END IF
        END IF

        ' check to display progress bar
        IF Progress.Bar THEN
            Percent = (Sum.Bytes2 / File.Size) * 100#
            Percent = INT(Percent / 10)
            DO WHILE Percent > Current.Progress
                IF Current.Progress >= 10 THEN
                    EXIT DO
                END IF
                PRINT "#";
                Current.Progress = Current.Progress + 1
            LOOP
        END IF
    END IF

    ' check binary copy
    IF Copy.Ascii = False THEN
        Ascii.Exit = False
    ELSE
        IF INSTR(buffer$, CHR$(26)) THEN ' eof char
            buffer$ = LEFT$(buffer$, INSTR(buffer$, CHR$(26)))
            Number.Bytes = LEN(buffer$)
            Ascii.Exit = True
        END IF
    END IF

    ' check number of bytes to copy
    IF Number.Bytes > False THEN

        ' check ascii filters
        FOR Count = 1 TO Ascii.Filters
            Ascii.From = Convert.Ascii(Count, 1)
            Ascii.To = Convert.Ascii(Count, 2)
            Next.Imbedded = 1
            DO
                Imbedded = INSTR(Next.Imbedded, buffer$, CHR$(Ascii.From))
                IF Imbedded THEN
                    Next.Imbedded = Imbedded + 1
                    MID$(buffer$, Imbedded, 1) = CHR$(Ascii.To)
                ELSE
                    EXIT DO
                END IF
                IF Next.Imbedded >= Number.Bytes THEN
                    EXIT DO
                END IF
            LOOP
        NEXT
    END IF

    ' check number of bytes to copy
    IF Number.Bytes > False THEN

        ' check ascii strips
        FOR Count = 1 TO Ascii.Strips
            ' check entire buffer is stripped
            IF LEFT$(buffer$, Number.Bytes) = STRING$(Number.Bytes, CHR$(Strip.Ascii(Count))) THEN
                Number.Bytes = 0
                EXIT FOR
            END IF

            ' check strip values
            DO
                Imbedded = INSTR(buffer$, CHR$(Strip.Ascii(Count)))
                IF Imbedded > False AND Imbedded <= Number.Bytes THEN
                    buffer$ = LEFT$(buffer$, Imbedded - 1) + MID$(buffer$, Imbedded + 1)
                    Number.Bytes = Number.Bytes - 1
                ELSE
                    EXIT DO
                END IF
            LOOP
        NEXT
    END IF

    ' check number of bytes to copy
    IF Number.Bytes > False THEN
        ' reset and store error flag
        DataError = False
        Error.Flag = True

        ' append to file
        PUT Append.Handle, , buffer$

        ' restore and check error flag
        Error.Flag = False
        IF DataError THEN
            Error.Type = DataError
            EXIT DO
        END IF

        ' increment bytes copied
        Sum.Bytes = Sum.Bytes + Number.Bytes

        ' check binary copy
        IF Ascii.Exit THEN
            EXIT DO
        END IF
    END IF

    ' check for more input
    IF EOF(Handle) THEN
        EXIT DO
    END IF
LOOP

' clear display progress
CALL ClearDisplay(-1)

' update counter
Files.Counted = Files.Counted + 1#

' check copying file error
IF DataError THEN
    IF Wide.List THEN
        Wide.List = False
        PRINT
    END IF
    Copy.Error = True
    IF Display.Errors = False THEN
        COLOR Red, Black
        IF Error.Type = 61 THEN ' disk full
            Disk.Full = True
            Quit.Searching = True
        END IF
        CALL DisplayCriticalError(Error.Type)
    END IF
END IF

' close output file
CALL CloseFile(0)

' pcocess end of input file parsing
End.Copy.File1:
' close input file
IF Handle THEN
    CLOSE #Handle
END IF

' display any errors
IF Debug.Mode THEN
    IF CloseError > False THEN
        CALL DisplayError("Error closing input filename.")
    END IF
END IF

' check disk full flag
IF Disk.Full THEN
    ' delete destination file
    IF Append.Dest = False THEN
        CALL DeleteDestFile(False, Next.Dest.Net$, Source.Filename$)
    END IF
    EXIT SUB
END IF

' check copy error flag
IF Copy.Error THEN
    ' delete destination file
    IF Append.Dest = False THEN
        CALL DeleteDestFile(True, Next.Dest.Net$, Source.Filename$)
    END IF
    EXIT SUB
END IF

' check to change source attribute
Reset.Source = False
IF RTRIM$(Source.Net) <> Nul THEN
    Reset.Source = True
END IF
IF Set.Source.Attribute OR Reset.Source THEN
    ' reset source attribute
    x = SetFileAttributes&(ASCIIZ, Source.Attribute)
END IF

' store total bytes copied
IF OpenError = 0 THEN
    Total.Bytes2 = Total.Bytes2 + File.Size
END IF

' store actual bytes copied
IF OpenError = 0 THEN
    Total.Bytes = Total.Bytes + Sum.Bytes
END IF

' store virtual bytes copied
IF Resume.File THEN
    Var# = File.Size - Dest.File.Size
ELSE
    IF Byte.Switch THEN
        Var# = File.Size - Byte.Override
    ELSE
        Var# = File.Size
    END IF
END IF
IF Var# < 0# THEN
    Var# = 0#
END IF
IF OpenError = 0 THEN
    Bytes.Copied = Bytes.Copied + Var#
END IF

' check display type
Var = False
IF Double.Line >= 1 THEN
    ' display file date/time
    COLOR Green, Black
    PRINT FileInfo$ + " ";
    Var = True
END IF

' check display type
IF Double.Line >= 2 THEN
    ' display file size
    COLOR Red, Black
    PRINT FormatString$(File.Size);
    Var = True
END IF

' check display type
IF Double.Line >= 3 THEN
    ' check for archive file
    COLOR White, Black
    IF (Attribute AND &H20) = &H20 THEN
        PRINT " Archive";
    END IF

    ' check for read-only file
    IF (Attribute AND 1) = 1 THEN
        PRINT " Read-only";
    END IF

    ' check for hidden file
    IF (Attribute AND 2) = 2 THEN
        PRINT " Hidden";
    END IF

    ' check for system file
    IF (Attribute AND 4) = 4 THEN
        PRINT " System";
    END IF

    ' check for compressed file
    IF (Attribute AND &H800) = &H800 THEN
        PRINT " Compressed";
    END IF

    ' check for encrypted file
    IF (Attribute AND &H4000) = &H4000 THEN
        PRINT " Encrypted";
    END IF
    Var = True
END IF
IF Var THEN
    Wide.List = False
    PRINT
END IF

' check to delete source file
IF Delete.Copied THEN
    CALL DeleteSourceFile(Source.Directory$, Source.Filename$)
END IF
EXIT SUB

Convert.Date:
YearTemp! = SysTime.wYear
MonthTemp! = SysTime.wMonth
DayTemp! = SysTime.wDay
Work.Date.Temp! = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
RETURN

Convert.Time:
HourTemp! = SysTime.wHour
MinuteTemp! = SysTime.wMinute
SecondsTemp! = SysTime.wSecond
Work.Time.Temp! = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
RETURN
END SUB

' display error trap message.
SUB DisplayCriticalError (Var)
SELECT CASE Var
    CASE 6
        PRINT "Overflow";
    CASE 9
        PRINT "Subscript out of range";
    CASE 14
        PRINT "Out of string space";
    CASE 24
        PRINT "Device timeout";
    CASE 25
        PRINT "Device fault";
    CASE 27
        PRINT "Out of paper";
    CASE 52
        PRINT "Bad file name or number";
    CASE 53
        PRINT "File not found";
    CASE 54
        PRINT "Bad file mode";
    CASE 55
        PRINT "File already open";
    CASE 57
        PRINT "Device I/O error";
    CASE 58
        PRINT "File already exists";
    CASE 59
        PRINT "Bad record length";
    CASE 61
        PRINT "Disk full";
    CASE 62
        PRINT "Input past eof";
    CASE 63
        PRINT "Bad record length";
    CASE 64
        PRINT "Bad file name";
    CASE 67
        PRINT "Not enough file handles";
    CASE 68
        PRINT "Device unavailable";
    CASE 70
        PRINT "Permission denied";
    CASE 71
        PRINT "Disk not ready";
    CASE 72
        PRINT "Disk-media error";
    CASE 75
        PRINT "Path/File access error";
    CASE 76
        PRINT "Pathname not found";
    CASE 81
        PRINT "Invalid name";
    CASE 90
        PRINT "Too many processes";
    CASE ELSE
        PRINT "Untrapped error" + STR$(Var);
END SELECT
PRINT " copying files."
END SUB

' routine to access directories
SUB Directories (Next.Dest.Net$, Directory.Search$, Directory.Target$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ.Sub AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' declare wide functions
DIM ASCIIZ.FileW AS STRING * MAX_PATH2 ' a null terminated filename
DIM finddataw AS WIN32_FIND_DATAW ' the windows filename structure
DIM Wfile.HandleW AS _UNSIGNED _OFFSET ' windows file handle for FindFile

' make directory filename
Temp.Net$ = RTRIM$(Source.Net)
IF Temp.Net$ = Nul THEN
    ASCIIZ.Sub = Directory.Search$ + "*.*" + CHR$(0)
    Source.Search$ = Directory.Search$
ELSE
    IF LEFT$(Directory.Search$, 1) = "\" THEN
        ASCIIZ.Sub = Temp.Net$ + Directory.Search$ + "*.*" + CHR$(0)
        Source.Search$ = Temp.Net$ + Directory.Search$
    ELSE
        ASCIIZ.Sub = Temp.Net$ + "\" + Directory.Search$ + "*.*" + CHR$(0)
        Source.Search$ = Temp.Net$ + "\" + Directory.Search$
    END IF
END IF
IF RIGHT$(Source.Search$, 1) = "\" THEN
    Source.Search$ = LEFT$(Source.Search$, LEN(Source.Search$) - 1)
END IF

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ.Sub), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' store source copied directory filename
    Copy.Target = Directory.Target$

    ' check to copy directory structure
    Directory.Exists = False
    IF Copy.Directory THEN
        Dir.Copy.Name = Directory.Search$
        Dir.Copy.Target = Directory.Target$
        IF Skip.Directory = 0 THEN
            CALL CopyDirectory(Source.Search$, Next.Dest.Net$)
        END IF
    END IF

    ' check directory exists
    IF Directory.Exists = False THEN

        ' search directory names
        CALL Filenames(Directory.Target$, Next.Dest.Net$, Directory.Search$)

        ' check to recurse directories
        IF Recurse.Directories THEN

            ' recursive subdirectories
            DO
                ' check to quit
                IF Quit.Searching THEN
                    EXIT DO
                END IF

                ' check directory attribute
                Attribute = finddata.dwFileAttributes
                IF (Attribute AND &H10) = &H10 THEN

                    ' store directory name
                    Next.Search$ = finddata.cFileName
                    Imbedded = INSTR(Next.Search$, CHR$(0))
                    IF Imbedded THEN
                        Next.Search$ = LEFT$(Next.Search$, Imbedded - 1)
                    END IF

                    ' check unicode
                    DirIsUnicode = 0
                    IF INSTR(Next.Search$, "?") THEN
                        Next.Search$ = finddata.cAlternateFileName
                        Imbedded = INSTR(Next.Search$, CHR$(0))
                        IF Imbedded THEN
                            Next.Search$ = LEFT$(Next.Search$, Imbedded - 1)
                        END IF
                        Unicode$ = Directory.Search$ + Next.Search$
                        WideZ$ = AsciiToWide$(Unicode$) + CHR$(0)
                        Wfile.HandleW = FindFirstFileW(WideZ$, _OFFSET(finddataw))
                        IF Wfile.HandleW <> INVALID_HANDLE_VALUE THEN
                            DirIsUnicode = -1
                            DirUnicodeShort = WideZ$
                            DirUnicodeLong = finddataw.cFileName
                            x = FindClose(Wfile.HandleW)
                        END IF
                    END IF

                    ' check directory name
                    IF Next.Search$ <> "." AND Next.Search$ <> ".." THEN
                        ' check recursion levels
                        Recursion = True
                        IF Nested.Recurse > False THEN
                            Nested.Levels = Nested.Levels + 1
                            IF Nested.Levels >= Nested.Recurse THEN
                                Recursion = False
                            END IF
                        END IF

                        ' recursively search subdirectories
                        IF Recursion THEN
                            Temp1$ = Directory.Search$ + Next.Search$ + "\"
                            Temp2$ = Directory.Target$ + Next.Search$ + "\"
                            CALL Directories(Next.Dest.Net$, Temp1$, Temp2$)
                        END IF
                        IF Nested.Recurse > False THEN
                            Nested.Levels = Nested.Levels - 1
                        END IF
                    END IF
                END IF
            LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
        END IF
    END IF
    x = FindClose(Wfile.Handle)
END IF

' check to delete subdirectory
IF Recurse.Error = False THEN
    IF Delete.Directory THEN
        CALL DeleteSubdirectory(Directory.Search$)
    END IF
END IF
END SUB

' routine to access filenames in directory
SUB Filenames (Source.Search$, Next.Dest.Net$, Directory.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM ASCIIZ.File AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
DIM Recurse.Temp AS INTEGER

' declare wide functions
DIM ASCIIZ.FileW AS STRING * MAX_PATH2 ' a null terminated filename
DIM finddataw AS WIN32_FIND_DATAW ' the windows filename structure
DIM Wfile.HandleW AS _UNSIGNED _OFFSET ' windows file handle for FindFile

' make filename
Temp.Net$ = RTRIM$(Source.Net)
Var$ = Filename.Search
Var$ = RTRIM$(Var$)
IF Temp.Net$ = Nul THEN
    ASCIIZ.File = Directory.Search$ + Var$ + CHR$(0)
ELSE
    IF LEFT$(Directory.Search$, 1) = "\" THEN
        ASCIIZ.File = Temp.Net$ + Directory.Search$ + Var$ + CHR$(0)
    ELSE
        ASCIIZ.File = Temp.Net$ + "\" + Directory.Search$ + Var$ + CHR$(0)
    END IF
END IF

' find first long filename
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ.File), _OFFSET(finddata))
 
' check findirst error
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    DO
        ' store filename
        Filename$ = finddata.cFileName
        Imbedded = INSTR(Filename$, CHR$(0))
        IF Imbedded THEN
            Filename$ = LEFT$(Filename$, Imbedded - 1)
        END IF

        ' check unicode
        FileIsUnicode = 0
        IF INSTR(Filename$, "?") THEN
            Filename$ = finddata.cAlternateFileName
            Imbedded = INSTR(Filename$, CHR$(0))
            IF Imbedded THEN
                Filename$ = LEFT$(Filename$, Imbedded - 1)
            END IF
            WideZ$ = AsciiToWide$(Filename$) + CHR$(0)
            Wfile.HandleW = FindFirstFileW(WideZ$, _OFFSET(finddataw))
            IF Wfile.HandleW <> INVALID_HANDLE_VALUE THEN
                FileIsUnicode = -1
                UnicodeShort = WideZ$
                UnicodeLong = finddataw.cFileName
                x = FindClose(Wfile.HandleW)
            END IF
        END IF

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN

            ' store file info
            File.Size = finddata.nFileSizeHigh * &H100000000~&& OR finddata.nFileSizeLow

            ' store filename structure buffer
            finddatatemp = finddata

            ' store target directory
            Directory.Path = Source.Search$

            ' call subroutine to copy files
            CALL CopyFiles(Next.Dest.Net$, Directory.Search$, Filename$)
        END IF

        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF

    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' make a wide ascii filename
FUNCTION AsciiToWide$ (Var$)
Var2$ = Var$
FOR X = 1 TO LEN(Var2$)
    VarX$ = VarX$ + MID$(Var2$, X, 1) + CHR$(0)
NEXT
AsciiToWide$ = VarX$
END FUNCTION

' routine to open output file
SUB OpenFile (OpenError)
DIM hfind AS _OFFSET

' reset file open error flags
Disk.Full = False
OpenError = False

' declare filename to open
Open.Filename$ = ASCIIZfile
V = INSTR(Open.Filename$, CHR$(0))
IF V THEN
    Open.Filename$ = LEFT$(Open.Filename$, V - 1)
END IF
IF LEN(Open.Filename$) = 0 THEN
    IF Debug.Mode THEN
        Var$ = "Error" + STR$(DataError) + " opening output filename."
        CALL DisplayError(Var$)
    END IF
    OpenError = -1
    EXIT SUB
END IF

' change filename attribute
AttrX& = GetFileAttributes(ASCIIZfile)
AttrX& = AttrX& AND NOT &H1 ' reset read-only bit
x = SetFileAttributes&(ASCIIZfile, AttrX&)

' overwrite destination file
IF Append.Dest = 0 THEN
    hfind = CreateFile(ASCIIZfile, &H180, &H3, 0, 3, 0, 0)
    IF hfind <> INVALID_HANDLE_VALUE THEN
        x = CloseHandle(hfind)

        ' delete destination filename
        x = DeleteFileA(ASCIIZfile)

        ' display any errors
        IF x = 0 THEN
            IF Debug.Mode THEN
                Var$ = "Error (0x" + HEX$(GetLastError&) + ") deleting output filename."
                CALL DisplayError(Var$)
            END IF
            OpenError = -1
            EXIT SUB
        END IF
    END IF
END IF

' open destination file
DataError = False
Error.Flag = True
Append.Handle = FREEFILE
OPEN Open.Filename$ FOR BINARY AS #Append.Handle
Error.Flag = False

' check error flag
IF DataError THEN
    IF Debug.Mode THEN
        Var$ = "Error" + STR$(DataError) + " opening output filename."
        CALL DisplayError(Var$)
    END IF
    OpenError = -1
    EXIT SUB
END IF

' reset and store error flag
DataError = False
Error.Flag = True

' seek file position to eof
SeekPosition2# = LOF(Append.Handle) + 1#
SEEK Append.Handle, SeekPosition2#

' reset and check error flag
Error.Flag = False
IF DataError THEN
    IF Debug.Mode THEN
        Var$ = "Error" + STR$(DataError) + " opening output filename."
        CALL DisplayError(Var$)
    END IF
    OpenError = -1
END IF
END SUB

' routine to close output file
SUB CloseFile (CloseType%)
' check file handle
IF Append.Handle = False THEN
    EXIT SUB
END IF

' close file
CLOSE #Append.Handle

' reset file handle
Append.Handle = False

' write dest. filename attributes
IF CloseType% = 0 THEN
    x = SetFileAttributes&(ASCIIZfile, File.Attribute)
END IF

' set filename date/time
CALL ExtendedFile(2)

' restore unicode long filename
CALL RenameUnicode
END SUB

SUB RenameUnicode
' check if file is unicode
IF FileIsUnicode THEN
    UnicodeShort = AsciiToWide$(ASCIIZfile) + CHR$(0)

    ' parse unicode filename
    Var$ = ASCIIZfile
    IF INSTR(Var$, CHR$(0)) THEN
        Var$ = LEFT$(Var$, INSTR(Var$, CHR$(0)) - 1)
    END IF
    Var = 0
    FOR X = LEN(Var$) TO 1 STEP -1
        IF MID$(Var$, X, 1) = "\" THEN
            Var$ = AsciiToWide$(LEFT$(Var$, X)) + UnicodeLong
            Var = -1
            EXIT FOR
        END IF
    NEXT
    IF Var = 0 THEN
        Var$ = UnicodeLong
    END IF

    ' rename the filename
    r = MoveFileW(UnicodeShort, Var$ + CHR$(0))
    IF r = 0 THEN
        IF Debug.ModeX THEN
            PRINT "Unicode file rename error: "; HEX$(GetLastError)
        END IF
    END IF
END IF
END SUB

' routine overrides destination file date/time.
'   1 = get filename date/time
'   2 = set filename date/time
SUB ExtendedFile (T)
DIM hfind AS _OFFSET

' get source filename date/time.
IF T = 1 THEN
    hfind = CreateFile(ASCIIZcopy, &H180, &H3, 0, 3, 0, 0)
    IF hfind <> INVALID_HANDLE_VALUE THEN
        x = GetFileTime&(hfind, SourceCreateDate, SourceAccessDate, SourceModifyDate)
        ' display any errors.
        IF x = 0 THEN
            IF Debug.Mode THEN
                Var$ = "Error (0x" + HEX$(GetLastError&) + ") reading filename date/time."
                CALL DisplayError(Var$)
            END IF
        END IF
        x = CloseHandle(hfind)
    END IF
    EXIT SUB
END IF

' override filename date/time.
IF Override.Create.Date OR Override.Access.Date OR Override.Modify.Date THEN
    ' store default date/time.
    CreateDate = SourceCreateDate
    AccessDate = SourceAccessDate
    ModifyDate = SourceModifyDate

    ' store override date/time.
    IF Override.Date AND Override.Time THEN
        GOSUB GetSysDate
        IF Override.Create.Date THEN
            x = SystemTimeToFileTime&(SysTime, CreateDate)
        END IF
        IF Override.Access.Date THEN
            x = SystemTimeToFileTime&(SysTime, AccessDate)
        END IF
        IF Override.Modify.Date THEN
            x = SystemTimeToFileTime&(SysTime, ModifyDate)
        END IF
    END IF

    ' set the destination filename date/time.
    hfind = CreateFile(ASCIIZfile, &H180, &H3, 0, 3, 0, 0)
    IF hfind <> INVALID_HANDLE_VALUE THEN
        x = SetFileTime&(hfind, CreateDate, AccessDate, ModifyDate)
        ' display any errors.
        IF x = 0 THEN
            IF Debug.Mode THEN
                Var$ = "Error (0x" + HEX$(GetLastError&) + ") touching filename date/time."
                CALL DisplayError(Var$)
            END IF
        END IF
        x = CloseHandle(hfind)
    END IF
END IF
EXIT SUB

GetSysDate:
' store override variables
SysTime.wMonth = Override.Date.Month
SysTime.wDay = Override.Date.Day
SysTime.wYear = Override.Date.Year
SysTime.wHour = Override.Time.Hour
SysTime.wMinute = Override.Time.Minute
SysTime.wSecond = Override.Time.Second
RETURN
END SUB

' routine to read file info
SUB ReadFileSynch
' declare subroutine variables
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZfile), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
    ' store file size
    Dest.File.Size = finddata.nFileSizeHigh * &H100000000~&& OR finddata.nFileSizeLow

    ' store file date and time
    x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
    GOSUB Convert.Date
    Synch.File.Create.Date = Work.Date.Temp!

    x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
    GOSUB Convert.Date
    Synch.File.Access.Date = Work.Date.Temp!

    x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
    GOSUB Convert.Date
    Synch.File.Modify.Date = Work.Date.Temp!

    x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
    GOSUB Convert.Time
    Synch.File.Create.Time = Work.Time.Temp!

    x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
    GOSUB Convert.Time
    Synch.File.Access.Time = Work.Time.Temp!

    x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
    GOSUB Convert.Time
    Synch.File.Modify.Time = Work.Time.Temp!

    x = FindClose(Wfile.Handle)
END IF
EXIT SUB

Convert.Date:
YearTemp! = SysTime.wYear
MonthTemp! = SysTime.wMonth
DayTemp! = SysTime.wDay
Work.Date.Temp! = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
RETURN

Convert.Time:
HourTemp! = SysTime.wHour
MinuteTemp! = SysTime.wMinute
SecondsTemp! = SysTime.wSecond
Work.Time.Temp! = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
RETURN
END SUB

' routine to preprocess filenames in command line
SUB ProcessCommand (Quit)
' declare work variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM ASCIIZ2 AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
DIM hfind AS _OFFSET

' reset quit flag
Quit = False

' store current drive
IF MID$(Command.Work, 2, 1) = ":" THEN
    Drive.Search = LEFT$(UCASE$(Command.Work), 1)
    Command.Work = MID$(Command.Work, 3)
ELSE
    Drive.Search = UCASE$(Current.Drive)
END IF

' read current directory
Temp.Search$ = ""
Drive.Temp = ASC(Drive.Search) - 64
IF MEDIAEXISTS(Drive.Temp) THEN
    IF _DIREXISTS(Drive.Search + ":") THEN
        x = SetCurrentDirectoryA(Drive.Search + ":" + CHR$(0))
        Temp.Search$ = RTRIM$(MID$(_CWD$, 4)) ' C:\TEMP
    END IF
END IF

' store source netpath
Source.Net = Nul
IF LEFT$(_CWD$, 2) = "\\" THEN
    Source.Net = _CWD$
END IF

' store current directory
Directory.Search$ = Nul
IF LEN(Command.Work) THEN
    Imbedded = INSTR(Command.Work, "\")
    Imbedded.Char = Imbedded
    WHILE Imbedded
        Imbedded.Char = Imbedded
        Imbedded = INSTR(Imbedded + 1, Command.Work, "\")
    WEND
    IF Imbedded.Char THEN
        Directory.Search$ = LEFT$(Command.Work, Imbedded.Char)
        Command.Work = MID$(Command.Work, Imbedded.Char + 1)
    ELSE
        IF RTRIM$(Source.Net) <> Nul THEN
            Directory.Search$ = "\"
        END IF
    END IF
END IF
IF Directory.Search$ = Nul THEN
    IF Temp.Search$ = "\" THEN
        Directory.Search$ = "\"
    ELSE
        Directory.Search$ = "\" + Temp.Search$
    END IF
END IF
IF RIGHT$(Directory.Search$, 1) <> "\" THEN
    Directory.Search$ = Directory.Search$ + "\"
END IF
Directory.Search$ = RTRIM$(Directory.Search$)

' read filename spec
Filename.Search = Command.Work
IF RTRIM$(Filename.Search) = Nul THEN
    Filename.Search = "*.*"
END IF
Command.Work = Nul
   
' check search filename
Target.Dir$ = Nul
Imbedded1 = INSTR(Filename.Search, "?")
Imbedded2 = INSTR(Filename.Search, "*")
IF Imbedded1 = False AND Imbedded2 = False THEN
    ' check search directory
    ASCIIZ = Directory.Search$ + RTRIM$(Filename.Search) + CHR$(0)

    ' find first directory
    Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
    IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

        ' check source is directory or filename
        Attribute = finddata.dwFileAttributes
        IF (Attribute AND &H10) = &H10 THEN
            Directory.Search$ = Directory.Search$ + RTRIM$(Filename.Search) + "\"
            Target.Dir$ = RTRIM$(Filename.Search)
            Filename.Search = "*.*"
        END IF
        x = FindClose(Wfile.Handle)
    END IF
END IF

' display search filename
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    IF RTRIM$(Source.Net) = Nul THEN
        PRINT "Searching: " + Drive.Search + ":" + Directory.Search$ + RTRIM$(Filename.Search)
    ELSE
        IF LEFT$(Directory.Search$, 1) = "\" THEN
            PRINT "Searching: " + RTRIM$(Source.Net) + Directory.Search$ + RTRIM$(Filename.Search)
        ELSE
            PRINT "Searching: " + RTRIM$(Source.Net) + "\" + Directory.Search$ + RTRIM$(Filename.Search)
        END IF
    END IF
END IF

' process destination netpaths
FOR Count0 = 1 TO Number.Dest.Nets

    ' store netpath
    Next.Dest.Net$ = Destinate.Netpaths(Count0)
    Next.Dest.Net$ = RTRIM$(Next.Dest.Net$)

    ' process destination directories
    FOR Count1 = 1 TO Number.Dest.Dirs
        ' store directory
        Next.Dest.Dir$ = Destinate.Directory(Count1)
        Next.Dest.Dir$ = RTRIM$(Next.Dest.Dir$)

        ' check destination drive
        IF MID$(Next.Dest.Dir$, 2, 1) = ":" THEN
            Drive.Number = ASC(UCASE$(MID$(Next.Dest.Dir$, 1, 1)))
            Next.Dest.Dir$ = MID$(Next.Dest.Dir$, 3)
        ELSE
            Drive.Number = ASC(UCASE$(Current.Drive))
        END IF

        ' store destination directory
        MediaError = 0
        IF Next.Dest.Net$ = Nul THEN
            GOSUB Store.Dest.Dir
        END IF

        ' recheck destination directory
        IF LEFT$(Next.Dest.Dir$, 1) <> "\" THEN
            Next.Dest.Dir$ = Default.Dest + Next.Dest.Dir$
        END IF
        IF RIGHT$(Next.Dest.Dir$, 1) <> "\" THEN
            Next.Dest.Dir$ = Next.Dest.Dir$ + "\"
        END IF

        ' store destination drive/netpath
        IF Next.Dest.Net$ = Nul THEN
            IF LEFT$(Next.Dest.Dir$, 2) <> "\\" THEN
                Next.Dest.Dir$ = CHR$(Drive.Number) + ":" + Next.Dest.Dir$
            END IF
        END IF

        ' process destination filenames
        FOR Count2 = 1 TO Number.Dest.Files

            ' store filename
            Dest.File = Destinate.Filename(Count2)
            Dest.File = RTRIM$(Dest.File)

            ' check filelist filename
            IF LEFT$(Dest.File, 1) = "@" AND Enable.Redirect THEN
                Dest.Out$ = MID$(Dest.File$, 2)

                ' open filename list
                x = 0
                ASCIIZ2 = Dest.Out$ + CHR$(0)
                hfind = CreateFile(ASCIIZ2, &H180, &H3, 0, 3, 0, 0)
                IF hfind <> INVALID_HANDLE_VALUE THEN
                    x = CloseHandle(hfind)
                END IF
                IF x = 0 THEN
                    ' display filename error
                    CALL DisplayError("Error" + STR$(GetLastError&) + " opening listfile.")
                ELSE

                    V = FREEFILE
                    DataError = False
                    Error.Flag = True
                    OPEN Dest.Out$ FOR INPUT SHARED AS #V
                    Error.Flag = False

                    ' check error flag
                    IF DataError THEN
                        CALL DisplayError("Error" + STR$(DataError) + " opening filelist.")
                    ELSE
                        ' process input filenames
                        DO UNTIL EOF(V)
                            LINE INPUT #V, Next.Filename$
                            Next.Filename$ = RTRIM$(Next.Filename$)
                            IF LEN(Next.Filename$) THEN
                                ' process search filename
                                Dest.File$ = Next.Filename$
                                GOSUB ProcessDestinate
                            END IF
                            ' check to quit
                            IF Quit.Searching THEN
                                EXIT DO
                            END IF
                        LOOP
                        CLOSE #V
                    END IF
                END IF
            ELSE
                GOSUB ProcessDestinate
            END IF

            ' check quit flag
            IF Quit.Searching THEN
                Quit = True
                EXIT FOR
            END IF
        NEXT

        ' check quit flag
        IF Quit.Searching THEN
            EXIT FOR
        END IF
    NEXT

    ' check netpaths
    IF Next.Dest.Net$ = Nul THEN
        EXIT FOR
    END IF
NEXT
EXIT SUB

ProcessDestinate:
' check destination drive exists.
IF MediaError THEN
    RETURN
END IF

' reset work variable
Append.Files = False

' check destination filename
Dest.Dir = Next.Dest.Dir$
IF Dest.File <> Nul THEN
    Dest.Dir = Dest.Dir + Dest.File
    Append.Files = True
END IF

' store target directory for directory structure copy
Directory.Target$ = Dest.Dir
IF Zero.Nest = False THEN
    IF LEN(Target.Dir$) THEN
        Directory.Target$ = Directory.Target$ + Target.Dir$ + "\"
    END IF
END IF

' construct target directory
IF Copy.Directory THEN
    Directory.Path = Directory.Target$
    CALL CreateDirectory(Next.Dest.Net$)
END IF

' reset recurse flag
Recurse.Error = False

' recursively copy files
CALL Directories(Next.Dest.Net$, Directory.Search$, Directory.Target$)

' close output file
IF Append.Files THEN
    CALL CloseFile(-1)
END IF
RETURN

' get default directory of target drive
Store.Dest.Dir:
Default.Dest = ""
IF LEFT$(_CWD$, 2) = "\\" THEN
    Default.Dest = _CWD$
    IF RIGHT$(Default.Dest, 1) <> "\" THEN
        Default.Dest = Default.Dest + "\"
    END IF
    RETURN
END IF
IF MEDIAEXISTS(Drive.Number - 64) = 0 THEN
    IF Debug.Mode THEN
        CALL DisplayError("Error accessing target drive.")
    END IF
    MediaError = -1
    RETURN
END IF
IF _DIREXISTS(CHR$(Drive.Number) + ":") = 0 THEN
    IF Debug.Mode THEN
        CALL DisplayError("Error accessing target directory.")
    END IF
    MediaError = -1
    RETURN
END IF

' store directory
x = SetCurrentDirectoryA(CHR$(Drive.Number) + ":" + CHR$(0))
Default.Dest = RTRIM$(MID$(_CWD$, 4)) ' C:\TEMP

' restore directory
Drive.Temp = ASC(Drive.Search) - 64
IF MEDIAEXISTS(Drive.Temp) THEN
    x = SetCurrentDirectoryA(Drive.Search + ":" + CHR$(0))
END IF

' parse directory
IF Default.Dest = Nul THEN
    Default.Dest = "\"
END IF
IF Default.Dest <> "\" THEN
    Default.Dest = "\" + Default.Dest
END IF
IF RIGHT$(Default.Dest, 1) <> "\" THEN
    Default.Dest = Default.Dest + "\"
END IF
RETURN
END SUB

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = Nul
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

' routine to see if destination file exists
SUB CheckFileExists (Dest.Net$, Source.File$, Destination.File$, Response)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM PromptASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' reset continue searching flag
Response = True

' make filename
IF Dest.Net$ = Nul THEN
    PromptASCIIZ = Destination.File$ + CHR$(0)
ELSE
    IF LEFT$(Destination.File$, 1) = "\" THEN
        PromptASCIIZ = Dest.Net$ + Destination.File$ + CHR$(0)
    ELSE
        PromptASCIIZ = Dest.Net$ + "\" + Destination.File$ + CHR$(0)
    END IF
END IF

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(PromptASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
    Response = False
    x = FindClose(Wfile.Handle)
END IF
END SUB

' routine to prompt before overwriting files
SUB PromptOverwrite (Dest.Net$, Source.File$, Destination.File$, Response)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM PromptASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' reset continue searching flag
Response = True

' make filename
IF Dest.Net$ = Nul THEN
    PromptASCIIZ = Destination.File$ + CHR$(0)
ELSE
    IF LEFT$(Destination.File$, 1) = "\" THEN
        PromptASCIIZ = Dest.Net$ + Destination.File$ + CHR$(0)
    ELSE
        PromptASCIIZ = Dest.Net$ + "\" + Destination.File$ + CHR$(0)
    END IF
END IF

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(PromptASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' make drive
    Start.Dir = Dest.Dir
    IF MID$(Start.Dir, 2, 1) = ":" THEN
        Drive.Number = ASC(UCASE$(LEFT$(Start.Dir, 1)))
        Start.Dir = MID$(Start.Dir, 3)
    ELSE
        Drive.Number = ASC(UCASE$(Drive.Search))
    END IF

    ' make filename
    To.File$ = Destination.File$
    IF MID$(To.File$, 2, 1) = ":" THEN
        To.File$ = MID$(To.File$, 3)
    END IF

    ' make filename
    From.File$ = Source.File$
    IF MID$(From.File$, 2, 1) = ":" THEN
        From.File$ = MID$(From.File$, 3)
    END IF

    ' check overwrite flag
    IF Dont.Overwrite THEN
        ' display file
        Response = False

        ' check display flags
        IF Short.Display OR Short.Display4 THEN
            Eat$ = Nul
        ELSE
            ' make filename
            Outpt$ = RTRIM$(From.File$)
            Temp.Net$ = RTRIM$(Source.Net)
            IF Temp.Net$ = Nul THEN
                Outpt$ = CHR$(Drive.Number) + ":" + Outpt$
            ELSE
                IF LEFT$(Outpt$, 1) = "\" THEN
                    Outpt$ = Temp.Net$ + Outpt$
                ELSE
                    Outpt$ = Temp.Net$ + "\" + Outpt$
                END IF
            END IF

            IF Display.Lowercase THEN
                Outpt$ = LCASE$(Outpt$)
            END IF

            ' check continuous display
            IF Continuous.Display = False THEN
                Outpt$ = "Not copying file " + Outpt$
            END IF

            ' display filename
            IF Wide.List THEN
                Wide.List = False
                PRINT
            END IF
            COLOR White, Black
            PRINT Outpt$
        END IF
    ELSE
        ' check continuous copying
        IF Continue.Searching = False THEN
            ' check to skip all copied files
            IF Skip.All THEN
                Response = False
            ELSE

                ' make filename
                Prompt$ = RTRIM$(To.File$)
                IF Dest.Net$ = Nul THEN
                    Prompt$ = CHR$(Drive.Number) + ":" + Prompt$
                ELSE
                    IF LEFT$(Prompt$, 1) = "\" THEN
                        Prompt$ = Dest.Net$ + Prompt$
                    ELSE
                        Prompt$ = Dest.Net$ + "\" + Prompt$
                    END IF
                END IF
                IF Display.Lowercase THEN
                    Prompt$ = LCASE$(Prompt$)
                END IF

                ' make prompt
                IF Short.Display4 THEN
                    Response = True
                ELSE
                    IF Continuous.Display3 THEN
                        Response = True
                    ELSE
                        IF Short.Display3 THEN
                            Prompt$ = "File exists. "
                        ELSE
                            Prompt$ = "File " + Prompt$ + " exists."
                            PRINT Prompt$
                            Prompt$ = Nul
                        END IF
                        IF Append.Dest THEN
                            IF Resume.File THEN
                                Prompt$ = Prompt$ + "Resume"
                            ELSE
                                Prompt$ = Prompt$ + "Append"
                            END IF
                        ELSE
                            Prompt$ = Prompt$ + "Overwrite"
                        END IF
                        Prompt$ = Prompt$ + "(y)es,(n)o,(c)opy all,(s)kip all,(q)uit?"
                        CALL MorePrompt(Prompt$, "ynqsc", Outpt$, "y")
                        SELECT CASE Outpt$
                            CASE "c"
                                Response = True
                                Continue.Searching = True
                            CASE "q"
                                Response = False
                                Quit.Searching = True
                            CASE "s"
                                Skip.All = True
                                Response = False
                            CASE "y"
                                Response = True
                            CASE "n"
                                Response = False
                        END SELECT
                    END IF
                END IF
            END IF
        END IF
    END IF
    x = FindClose(Wfile.Handle)
END IF
END SUB

' routine to create directory,
'   and copy directory attributes.
SUB CopyDirectory (Source.Path$, Target.Net$)
' declare subroutine variables
DIM ASCIIZ AS STRING * 260

' check for copying directory onto itself
CALL DirectoryCopying(Target.Net$)

' process directory copying
IF Directory.Exists THEN
    Recurse.Error = True
    IF Display.Errors = False THEN
        IF Directory.Exists = -1 THEN
            CALL DisplayError("Recursive directory error.")
        ELSE
            IF Directory.Exists = -2 THEN
                CALL DisplayError("Self-Recursive directory error.")
            END IF
        END IF
    END IF
    EXIT SUB
END IF

' make directory
Filename$ = RTRIM$(Dir.Copy.Target)
Filename$ = LEFT$(Filename$, LEN(Filename$) - 1)

' check directory name
IF Filename$ <> "." AND Filename$ <> ".." THEN

    ' create directory
    Directory.Path = Filename$
    CALL CreateDirectory(Target.Net$)

    ' increment directory counter
    Dirs.Counted = Dirs.Counted + 1!

    ' display directory created
    IF Debug.ModeX THEN
        PRINT "Verified: " + Filename$
    END IF
    EXIT SUB

    ' make directory name
    Directory$ = RTRIM$(Dir.Copy.Name)
    Directory$ = LEFT$(Directory$, LEN(Directory$) - 1)

    ' make source directory name
    IF Source.Path$ = Nul THEN
        ASCIIZ = Directory$ + CHR$(0)
    ELSE
        ASCIIZ = Source.Path$ + CHR$(0)
    END IF

    ' store source directory attribute
    Dir.Attribute = GetFileAttributes(ASCIIZ)

    ' make target directory name
    IF Target.Net$ = Nul THEN
        ASCIIZ = Filename$ + CHR$(0)
    ELSE
        IF LEFT$(Filename$, 1) = "\" THEN
            IF RIGHT$(Target.Net$, 1) = "\" THEN
                ASCIIZ = Target.Net$ + MID$(Filename$, 2) + CHR$(0)
            ELSE
                ASCIIZ = Target.Net$ + Filename$ + CHR$(0)
            END IF
        ELSE
            IF RIGHT$(Target.Net$, 1) = "\" THEN
                ASCIIZ = Target.Net$ + Filename$ + CHR$(0)
            ELSE
                ASCIIZ = Target.Net$ + "\" + Filename$ + CHR$(0)
            END IF
        END IF
    END IF

    ' copy directory attribute
    x = SetFileAttributes&(ASCIIZ, Dir.Attribute)
END IF
END SUB

' routine to create directory structure
SUB CreateDirectory (Next.Dest.Net$)
' construct path
Directory$ = RTRIM$(Directory.Path$)
IF Next.Dest.Net$ = Nul THEN
    IF MID$(Directory$, 2, 1) = ":" THEN
        Drive.Create$ = LEFT$(Directory$, 1)
        Directory$ = MID$(Directory$, 3)
    ELSE
        Drive.Create$ = Current.Drive
    END IF
END IF
IF RIGHT$(Directory$, 1) <> "\" THEN
    Directory$ = Directory$ + "\"
END IF

' create path
Next.Dir = INSTR(Directory$, "\")
DO
    IF Next.Dir = False THEN
        EXIT DO
    END IF

    Filename$ = LEFT$(Directory$, Next.Dir - 1) ' \temp\t1\t\
    Next.Dir = INSTR(Next.Dir + 1, Directory$, "\")

    ' make directory name
    IF LEN(Filename$) THEN
        IF LEN(Next.Dest.Net$) THEN
            Filename$ = Next.Dest.Net$ + "\" + Filename$
        ELSE
            Filename$ = Drive.Create$ + ":" + Filename$
        END IF

        ' check directory
        IF _DIREXISTS(Filename$) = 0 THEN
            ' create directory
            f$ = Filename$ + CHR$(0)
            x = CreateDirectoryA(f$, 0) ' critical error solved!

            ' increment directory counter
            IF x THEN
                Dirs.Created = Dirs.Created + 1!
                IF Debug.ModeX THEN
                    PRINT "Created: "; Filename$
                END IF
            END IF

            ' display any error
            IF x = 0 THEN
                IF Debug.ModeX THEN
                    IF GetLastError& = &HB7 THEN ' ignore already exists
                        ' nul
                    ELSE
                        Var$ = "Error (0x" + HEX$(GetLastError&) + ") creating directory."
                        CALL DisplayError(Var$)
                    END IF
                END IF
            END IF
        END IF
    END IF
LOOP

' check if file is unicode
IF DirIsUnicode THEN
    IF LEN(Next.Dest.Net$) THEN
        Filename$ = Next.Dest.Net$ + "\" + Directory$
    ELSE
        Filename$ = Drive.Create$ + ":" + Directory$
    END IF
    DirUnicodeShort = AsciiToWide$(Filename$) + CHR$(0)

    ' parse unicode filename
    Var$ = Filename$
    IF RIGHT$(Var$, 1) = "\" THEN
        Var$ = LEFT$(Var$, LEN(Var$) - 1)
    END IF
    Var = 0
    FOR x = LEN(Var$) TO 1 STEP -1
        IF MID$(Var$, x, 1) = "\" THEN
            Var$ = AsciiToWide$(LEFT$(Var$, x)) + DirUnicodeLong
            Var = -1
            EXIT FOR
        END IF
    NEXT
    IF Var = 0 THEN
        Var$ = DirUnicodeLong
    END IF

    ' rename the filename
    r = MoveFileW(DirUnicodeShort, Var$ + CHR$(0))
    IF r = 0 THEN
        IF Debug.ModeX THEN
            PRINT "Unicode directory rename error: "; HEX$(GetLastError)
        END IF
    END IF
END IF
END SUB

' subroutine to delete destination filename
SUB DeleteDestFile (Delete.Prompt, Work.Net$, Filename$)
' declare subroutine variables
DIM ASCIIZ AS STRING * 260

' close output file
IF Append.Files THEN
    CALL CloseFile(-1)
END IF

' make drive
Start.Dir = Dest.Dir
IF MID$(Start.Dir, 2, 1) = ":" THEN
    Drive.Number = ASC(UCASE$(LEFT$(Start.Dir, 1)))
    Start.Dir = MID$(Start.Dir, 3)
ELSE
    Drive.Number = ASC(UCASE$(Drive.Search))
END IF
 
' display file being deleted
IF Dest.File = Nul THEN
    IF Work.Net$ = Nul THEN
        Source.File$ = CHR$(Drive.Number) + ":" + Start.Dir + Filename$
    ELSE
        Source.File$ = Work.Net$ + "\" + Start.Dir + Filename$
    END IF
ELSE
    IF Work.Net$ = Nul THEN
        Source.File$ = CHR$(Drive.Number) + ":" + Start.Dir
    ELSE
        Source.File$ = Work.Net$ + "\" + Start.Dir
    END IF
END IF

' check prompt to delete
IF Delete.Prompt THEN
    Prompt$ = Nul
    IF Display.Errors THEN
        Prompt$ = "Error copying file. "
    END IF
    Prompt$ = Prompt$ + "Delete partially copied destination file: " + Source.File$ + "(y)es,(n)o,(q)uit?"
    CALL MorePrompt(Prompt$, "ynq", Respond$, "y")
    SELECT CASE Respond$
        CASE "n"
            EXIT SUB
        CASE "q"
            Quit.Searching = True
            EXIT SUB
    END SELECT
END IF

' check to display file
Deleted.Files = Deleted.Files + 1
IF Continuous.Display = False THEN
    IF Wide.List THEN
        Wide.List = False
        PRINT
    END IF
    COLOR White, Black
    PRINT "Deleting file: " + Source.File$
END IF

' delete filename
ASCIIZ = Source.File$ + CHR$(0)

' change filename attribute
AttrX& = GetFileAttributes(ASCIIZ)
AttrX& = AttrX& AND NOT &H1 ' remove read-only bit
x = SetFileAttributes&(ASCIIZ, AttrX&)

' delete long filename
x = DeleteFileA(ASCIIZ)

' check delete error
IF x = 0 THEN
    IF Debug.Mode THEN
        Var$ = "Error (0x" + HEX$(GetLastError&) + ") deleting file."
        CALL DisplayError(Var$)
    END IF
END IF
END SUB

' subroutine to delete source filename
SUB DeleteSourceFile (Directory$, Filename$)
' declare subroutine variables
DIM ASCIIZ AS STRING * 260

' make filename
Source.File$ = Directory$ + Filename$

' make directory name
Temp.Dir$ = Directory$
CALL MakeFile(Nul, Source.File$, Temp.Dir$)

' reset delete flag
Response = False

' check continue flag
IF Continue.Deleting THEN
    Response = True
END IF

' check delete prompting
IF Prompt.Delete1 THEN
    Response = True
END IF

' prompt to delete
IF Response = False THEN
    Outpt$ = Source.File$
    IF Display.Lowercase THEN
        Outpt$ = LCASE$(Outpt$)
    END IF
    Prompt$ = "Delete copied source file: " + Outpt$ + "(y)es,(n)o,(d)elete all,(q)uit?"
    CALL MorePrompt(Prompt$, "ynqd", Respond$, "y")
    SELECT CASE Respond$
        CASE "d"
            Response = True
            Continue.Deleting = True
        CASE "q"
            Response = False
            Quit.Searching = True
        CASE "y"
            Response = True
        CASE "n"
            Response = False
    END SELECT
END IF

' check delete flag
IF Response = True THEN
    Deleted.Files = Deleted.Files + 1
    ' display file being deleted
    IF Continuous.Display = False THEN
        IF Wide.List THEN
            Wide.List = False
            PRINT
        END IF
        COLOR White, Black
        Prompt$ = "Deleting file: " + Outpt$
        PRINT Prompt$
    END IF

    ' delete filename
    ASCIIZ = Source.File$ + CHR$(0)

    ' change filename attribute
    AttrX& = GetFileAttributes(ASCIIZ)
    AttrX& = AttrX& AND NOT &H1 ' reset read-only bit
    x = SetFileAttributes&(ASCIIZ, AttrX&)

    ' delete long filename
    x = DeleteFileA(ASCIIZ)

    ' check error and delete 8.3 filename
    IF x = 0 THEN
        Short.Filename$ = finddatatemp.cAlternateFileName
        V = INSTR(Short.Filename$, CHR$(0))
        IF V THEN Short.Filename$ = LEFT$(Short.Filename$, V - 1)
        ASCIIZ = Directory$ + Short.Filename$ + CHR$(0)

        ' change filename attribute
        AttrX& = GetFileAttributes(ASCIIZ)
        AttrX& = AttrX& AND NOT &H1
        x = SetFileAttributes&(ASCIIZ, AttrX&)

        ' delete short filename
        x = DeleteFileA(ASCIIZ)
    END IF

    ' check delete error
    IF x = 0 THEN
        IF Debug.Mode THEN
            Var$ = "Error (0x" + HEX$(GetLastError&) + ") deleting file."
            CALL DisplayError(Var$)
        END IF
    END IF
END IF
END SUB

' subroutine to delete subdirectory
SUB DeleteSubdirectory (Source.Directory$)
' declare work variables
DIM Attribute AS _UNSIGNED LONG
DIM DeleteASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory name
Directory$ = Source.Directory$
Temp.Dir$ = Directory$
CALL MakeFile(Nul, Directory$, Temp.Dir$)

' find first directory
IF RIGHT$(Source.Directory$, 1) = "\" THEN
    DeleteASCIIZ = LEFT$(Source.Directory$, LEN(Source.Directory$) - 1) + CHR$(0)
ELSE
    DeleteASCIIZ = Source.Directory$ + CHR$(0)
END IF
Wfile.Handle = FindFirstFileA(_OFFSET(DeleteASCIIZ), _OFFSET(finddata))
IF Wfile.Handle = 0 THEN
    EXIT SUB
END IF
x = FindClose(Wfile.Handle)

' reset delete flag
Response = False

' check to continue
IF Continue.Subdelete THEN
    Response = True
END IF

' check for prompting
IF Prompt.Delete2 THEN
    Response = True
END IF

' make directory name
Outpt$ = Directory$
IF Display.Lowercase THEN
    Outpt$ = LCASE$(Outpt$)
END IF

' check delete flag
IF Response = False THEN
    ' prompt to delete
    Prompt$ = "Delete copied source directory: " + Outpt$ + "(y)es,(n)o,(d)elete all,(q)uit?"
    CALL MorePrompt(Prompt$, "ynqd", Respond$, "y")
    SELECT CASE Respond$
        CASE "d"
            Response = True
            Continue.Subdelete = True
        CASE "q"
            Response = False
            Quit.Searching = True
        CASE "y"
            Response = True
        CASE "n"
            Response = False
    END SELECT
END IF

' check delete flag
IF Response THEN
    Deleted.Dirs = Deleted.Dirs + 1
    IF Continuous.Display = False THEN
        IF Wide.List THEN
            Wide.List = False
            PRINT
        END IF
        COLOR White, Black
        PRINT "Deleting directory: " + Outpt$
    END IF
    CALL TreeDirectories(Directory$)
END IF
END SUB

' subroutine to delete subdirectories
SUB TreeDirectories (Directory.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' delete filenames
    CALL DeleteFiles(Directory.Search$)

    ' recurse subdirectories
    DO
        ' check directory attribute
        Attribute = finddata.dwFileAttributes

        ' check for directory
        IF (Attribute AND &H10) = &H10 THEN

            ' store directory name
            Directory$ = finddata.cFileName
            Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

            ' check for unicode
            IF INSTR(Directory$, "?") THEN
                Directory$ = finddata.cAlternateFileName
                V = INSTR(Directory$, CHR$(0))
                IF V THEN Directory$ = LEFT$(Directory$, V - 1)
            END IF

            ' check directory name
            IF Directory$ <> "." AND Directory$ <> ".." THEN
                ' make next search directory
                Next.Directory$ = Directory.Search$ + Directory$ + "\"

                ' recursively search subdirectories
                CALL TreeDirectories(Next.Directory$)
            END IF
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF

' delete directory
CALL DeleteDirectory(Directory.Search$)
END SUB

' subroutine to delete files in a directory
SUB DeleteFiles (Directory$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM ASCIIZ2 AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make filename
ASCIIZ = Directory$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
    ' search filenames
    DO
        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN
            ' delete file
            ASCIIZ2 = Directory$ + Filename$ + CHR$(0)

            ' change filename attribute
            AttrX& = GetFileAttributes(ASCIIZ2)
            AttrX& = AttrX& AND NOT &H1 ' reset read-only bit
            x = SetFileAttributes&(ASCIIZ2, AttrX&)

            ' delete long filename
            x = DeleteFileA(ASCIIZ2)

            ' check error and delete 8.3 filename
            IF x = 0 THEN
                Short.Filename$ = finddata.cAlternateFileName
                V = INSTR(Short.Filename$, CHR$(0))
                IF V THEN Short.Filename$ = LEFT$(Short.Filename$, V - 1)
                ASCIIZ2 = Directory$ + Short.Filename$ + CHR$(0)

                ' change filename attribute
                AttrX& = GetFileAttributes(ASCIIZ2)
                AttrX& = AttrX& AND NOT &H1
                x = SetFileAttributes&(ASCIIZ2, AttrX&)

                ' delete short filename
                x = DeleteFileA(ASCIIZ2)
            END IF
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to delete an empty directory
SUB DeleteDirectory (Directory$)
' declare subroutine variables
DIM ASCIIZ AS STRING * 260

' make filename
Temp.Dir$ = Directory$
IF RIGHT$(Temp.Dir$, 1) = "\" THEN
    Temp.Dir$ = LEFT$(Temp.Dir$, LEN(Temp.Dir$) - 1)
END IF
ASCIIZ = Temp.Dir$ + CHR$(0)

' change directory attribute
AttrX& = GetFileAttributes(ASCIIZ)
AttrX& = AttrX& AND NOT &H1 ' remove read-only bit
x = SetFileAttributes&(ASCIIZ, AttrX&)

' remove an empty directory
x = RemoveDirectoryA(ASCIIZ)

' check delete error flag
IF x = 0 THEN
    IF Debug.Mode THEN
        Var$ = "Error (0x" + HEX$(GetLastError&) + ") deleting directory."
        CALL DisplayError(Var$)
    END IF
END IF

' check delete error flag
IF x THEN
    Total.Deleted = Total.Deleted + 1
END IF
END SUB

' verifies duplicate filenames,
'   displays filenames being copied.
SUB FilenameCopying (Copy.Net$, From$, To$)
' reset flag
Filename.Exists = False

' make filenames
From.File$ = From$
To.File$ = To$
CALL MakeFile(Copy.Net$, From.File$, To.File$)

' check filename length
IF LEN(To.File$) > 259 THEN
    Filename.Exists = True
    EXIT SUB
END IF

' check to run DOS commands
FOR Count = 1 TO Number.Commands
    Next.Command$ = RTRIM$(DOS.Command(Count))
    IF LEN(Next.Command$) THEN
        CALL ExecuteCommand(Next.Command$, From.File$)
    END IF
NEXT

' store filenames
From.Filename$ = From.File$
To.Filename$ = To.File$

' display filename
GOSUB Display.File

' make source netpath
IF Copy.Net$ <> Nul THEN
    From.Filename$ = From$
    CALL MakeFile2(From.Filename$)
END IF

' compare filenames
IF LCASE$(From.Filename$) = LCASE$(To.Filename$) THEN
    Filename.Exists = True
    IF Continuous.Display = False THEN
        IF Wide.List THEN
            Wide.List = False
            PRINT
        END IF
        COLOR White, Black
        PRINT "File in list cannot be copied onto itself."
    END IF
END IF
EXIT SUB

' display filename being copied
Display.File:

' display file being copied in title
Var1$ = AmbiguateFile$(From.File$)
Var2$ = AmbiguateFile$(To.File$)
Title.Header = "COPYIT - " + Var1$ + " -> " + Var2$
_TITLE Title.Header

' ambiguate filenames
IF Display.Wide OR Ambiguate.Display THEN
    From.File$ = Ambiguate1$(From.File$)
    To.File$ = Ambiguate1$(To.File$)
END IF

' convert to lowercase
IF Display.Lowercase THEN
    From.File$ = LCASE$(From.File$)
    To.File$ = LCASE$(To.File$)
END IF

' truncate pathname
IF Display.Path OR Display.Wide THEN
    FOR Imbedded = LEN(From.File$) TO 1 STEP -1
        IF MID$(From.File$, Imbedded, 1) = "\" THEN
            From.File$ = LEFT$(From.File$, 2) + MID$(From.File$, Imbedded + 1)
            EXIT FOR
        END IF
    NEXT
    FOR Imbedded = LEN(To.File$) TO 1 STEP -1
        IF MID$(To.File$, Imbedded, 1) = "\" THEN
            To.File$ = LEFT$(To.File$, 2) + MID$(To.File$, Imbedded + 1)
            EXIT FOR
        END IF
    NEXT
END IF

' truncate drive letter
IF Drive.Letter THEN
    IF MID$(From.File$, 2, 1) = ":" THEN
        From.File$ = MID$(From.File$, 3)
    END IF
    IF MID$(To.File$, 2, 1) = ":" THEN
        To.File$ = MID$(To.File$, 3)
    END IF
END IF

' store filename
COLOR Yellow, Black
Outpt$ = RTRIM$(From.File$)

' truncate drive letter
IF Copy.Net$ <> Nul THEN
    IF MID$(Outpt$, 2, 1) = ":" THEN
        Outpt$ = MID$(Outpt$, 3)
    END IF
END IF

' display filename in wide list format
IF Display.Wide THEN
    IF Short.Display4 = 0 THEN
        ' check filename
        IF LEN(Outpt$) > 14 THEN
            Outpt$ = LEFT$(Outpt$, 13) + "~"
        END IF

        ' display filename in wide format
        IF LEFT$(Outpt$, 2) = "\\" THEN
            Outpt$ = MID$(Outpt$, 3)
        END IF
        PRINT Outpt$ + SPACE$(15 - LEN(Outpt$));

        ' count wide display filenames
        Wide.List = Wide.List + 1
        IF Wide.List = 5 THEN
            Wide.List = False
            PRINT
        END IF
    END IF
    RETURN
END IF

' prepend copying type
IF Short.Display2 = False THEN
    IF Append.Dest THEN
        IF Resume.File THEN
            Outpt$ = "Resuming: " + Outpt$
        ELSE
            Outpt$ = "Appending: " + Outpt$
        END IF
    ELSE
        Outpt$ = "Copying: " + Outpt$
    END IF
END IF

' display only source filename
IF Short.Display4 = 0 THEN
    IF Short.Display THEN
        PRINT Outpt$
    ELSE
        ' display source/destination filenames
        Outpt$ = Outpt$ + " - " + To.File$
        PRINT Outpt$
    END IF
END IF
RETURN
END SUB

' ambiguate filename
FUNCTION Ambiguate1$ (Var$)
' declare subroutine variables
DIM ASCIIZ1 AS STRING * 260
DIM ASCIIZ2 AS STRING * 260
VarX$ = Var$

' read 8.3 filename
ASCIIZ1 = VarX$ + CHR$(0)
ret = GetShortPathName(ASCIIZ1, ASCIIZ2, MAX_PATH)

' check function error
IF ret > 0 THEN
    ' store 8.3 filename
    VarX$ = ASCIIZ2
    Imbedded = INSTR(VarX$, CHR$(0))
    IF Imbedded THEN
        VarX$ = LEFT$(VarX$, Imbedded - 1)
    END IF
END IF
Ambiguate1$ = VarX$
END FUNCTION

' ambiguate filename
FUNCTION AmbiguateFile$ (Var$)
' declare subroutine variables
DIM ASCIIZ1 AS STRING * 260
DIM ASCIIZ2 AS STRING * 260
VarX$ = Var$

' read 8.3 filename
ASCIIZ1 = VarX$ + CHR$(0)
ret = GetShortPathName(ASCIIZ1, ASCIIZ2, MAX_PATH)

' check function error
IF ret > 0 THEN
    ' store 8.3 filename
    VarX$ = ASCIIZ2
    Imbedded = INSTR(VarX$, CHR$(0))
    IF Imbedded THEN
        VarX$ = LEFT$(VarX$, Imbedded - 1)
    END IF
END IF

' strip path
FOR Imbedded = LEN(VarX$) TO 1 STEP -1
    IF MID$(VarX$, Imbedded, 1) = "\" THEN
        VarX$ = MID$(VarX$, Imbedded + 1)
        EXIT FOR
    END IF
NEXT

' strip drive
IF MID$(VarX$, 2, 1) = ":" THEN
    VarX$ = MID$(VarX$, 3)
END IF
AmbiguateFile$ = VarX$
END FUNCTION

' subroutine to execute DOS command
SUB ExecuteCommand (Next.Command$, DOS.Filename$)
' make replacement parameters
DOS.Pathname$ = DOS.Filename$
Imbedded1 = INSTR(DOS.Pathname$, "\")
Imbedded2 = False
WHILE Imbedded1
    Imbedded2 = Imbedded1
    Imbedded1 = INSTR(Imbedded1 + 1, DOS.Pathname$, "\")
WEND
Filename$ = MID$(DOS.Pathname$, Imbedded2 + 1)
IF Imbedded2 THEN
    DOS.Pathname$ = LEFT$(DOS.Pathname$, Imbedded2 - 1)
ELSE
    DOS.Pathname$ = Nul
END IF
Extension$ = Nul
Imbedded = INSTR(Filename$, ".")
IF Imbedded THEN
    Extension$ = MID$(Filename$, Imbedded + 1)
    Filename$ = LEFT$(Filename$, Imbedded - 1)
END IF

' store replacement parameters
IF LEFT$(DOS.Filename$, 2) = "\\" THEN
    Parameters(1) = "\\"
    Parameters(2) = "\\"
    Parameters(3) = DOS.Pathname$
    Parameters(4) = DOS.Pathname$ + "\"
    Parameters(5) = DOS.Filename$
ELSE
    Parameters(1) = Drive.Search + ":"
    Parameters(2) = Drive.Search + ":\"
    Parameters(3) = Drive.Search + ":" + DOS.Pathname$
    Parameters(4) = Drive.Search + ":" + DOS.Pathname$ + "\"
    Parameters(5) = Drive.Search + ":" + DOS.Filename$
END IF
Parameters(6) = DOS.Pathname$
Parameters(7) = DOS.Pathname$ + "\"
Parameters(8) = DOS.Filename$
Parameters(9) = Filename$ + "." + Extension$
Parameters(10) = Filename$
Parameters(11) = "." + Extension$
Parameters(12) = Extension$

' create DOS command
Execute.Command$ = Next.Command$

' replace parameters
Count = 1
DO
    IF Count >= LEN(Execute.Command$) THEN
        EXIT DO
    END IF
    Imbed$ = MID$(Execute.Command$, Count, 1)
    IF Imbed$ = "%" THEN
        Imbed2$ = MID$(Execute.Command$, Count + 1, 1)
        SELECT CASE UCASE$(Imbed2$)
            CASE "1" TO "9", "A" TO "C"
                Count2 = VAL("&H" + Imbed2$)
                Execute.Command$ = LEFT$(Execute.Command$, Count - 1) + RTRIM$(Parameters(Count2)) + MID$(Execute.Command$, Count + 2)
                Count = Count + LEN(RTRIM$(Parameters(Count2)))
            CASE ELSE
                Count = Count + 1
        END SELECT
    ELSE
        Count = Count + 1
    END IF
LOOP

' start DOS command shell
IF LEN(Execute.Command$) THEN
    ' check display counter
    IF Wide.List THEN
        Wide.List = False
        PRINT
    END IF

    ' read command path from environment
    Comspec$ = ENVIRON$("COMSPEC")
    IF LEN(Comspec$) THEN
        ' call shell routine
        IF Disable.Cmd THEN
            Shell.Command$ = Comspec$ + " /K " + Execute.Command$
        ELSE
            Shell.Command$ = Comspec$ + " /C " + Execute.Command$
        END IF
        SHELL Shell.Command$
    END IF
END IF
END SUB

' command line switch position function
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line switch parser function.
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    Switch.Exist = -1
    ParseLine = True
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        Switch.Exist = -1
        ParseLine = True
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

' routine parses command line for switches, filenames, and additional info.
SUB ReadSwitches (VarX$)
' assign a quote.
Quote = CHR$(34)

' get command line
Command.Line = VarX$

' check command line.
IF Command.Line = "/?" THEN
    CALL BootUsage
    COLOR Plain, Black
    PRINT "Exiting to DOS:"
    END 2
END IF

' concatenate environment variable.
IF INSTR(Command.Line, "/J") OR INSTR(Command.Line, "/j") THEN
    Force.LowerCase = True
END IF
IF Force.LowerCase THEN
    Command.Line = Command.Line + LCASE$(ENVIRON$("COPYIT"))
ELSE
    Command.Line = Command.Line + ENVIRON$("COPYIT")
END IF

' read config switches.
Ignore.Config = ParseLine("/.")
Ignore.Skip = ParseLine("/:")

' check config switch.
IF Ignore.Config = False THEN

    ' search for config file in dos path.
    CALL ReadConfig(StartDir$, File.Found)

    ' search for config file in dosutils path.
    IF File.Found = False THEN
        CALL ReadConfig(ENVIRON$("DOSUTILS"), File.Found)
    END IF

    ' search config file in path variable.
    IF File.Found = False THEN
        Var$ = ENVIRON$("PATH")
        IF Var$ <> Nul THEN
            DO
                Imbedded = INSTR(Var$, ";")
                IF Imbedded THEN
                    Path$ = LEFT$(Var$, Imbedded - 1)
                    Var$ = MID$(Var$, Imbedded + 1)
                ELSE
                    Path$ = Var$
                    Var$ = Nul
                END IF
                IF LEN(Path$) THEN
                    CALL ReadConfig(Path$, File.Found)
                    IF File.Found THEN
                        EXIT DO
                    END IF
                END IF
                IF Var$ = Nul THEN
                    EXIT DO
                END IF
            LOOP
        END IF
    END IF
END IF

' check command line.
IF Command.Line = "" THEN
    Boot.List$ = "Error specifying command line."
    GOTO Boot.Error
END IF

' read command line display switch.
IF INSTR(Command.Line, "/P") OR INSTR(Command.Line, "/p") THEN
    Display.CommandLine = True
END IF
IF Display.CommandLine THEN
    PRINT Command.Line
END IF

' read startup command line switches.
Force.LowerCase = ParseLine("/J")
Display.CommandLine = ParseLine("/P")
Ignore.Sort = ParseLine("/-1")
IF ParseLine("/-2") THEN
    Sort.Method = 1
END IF
IF Sort.Method = 0 THEN
    IF ParseLine("/-3") THEN
        Sort.Method = 2
    END IF
END IF

' read attribute switches.
Set.Source.Archive = ParseLine("///XA")
Set.Source.Hidden = ParseLine("///XH")
Set.Source.Readonly = ParseLine("///XO")
Set.Source.System = ParseLine("///XS")
Set.Source.Any = ParseLine("///XX")

Clear.Source.Archive = ParseLine("///ZA")
Clear.Source.Hidden = ParseLine("///ZH")
Clear.Source.Readonly = ParseLine("///ZO")
Clear.Source.System = ParseLine("///ZS")
Clear.Source.Any = ParseLine("///ZX")

Set.Dest.Archive = ParseLine("//XA")
Set.Dest.Hidden = ParseLine("//XH")
Set.Dest.Readonly = ParseLine("//XO")
Set.Dest.System = ParseLine("//XS")
Set.Dest.Any = ParseLine("//XX")

Clear.Dest.Archive = ParseLine("//ZA")
Clear.Dest.Hidden = ParseLine("//ZH")
Clear.Dest.Readonly = ParseLine("//ZO")
Clear.Dest.System = ParseLine("//ZS")
Clear.Dest.Any = ParseLine("//ZX")

Display.Archive = ParseLine("/XA")
Display.Hidden = ParseLine("/XH")
Display.Readonly = ParseLine("/XO")
Display.System = ParseLine("/XS")
Display.Any = ParseLine("/XX")

Display.Compressed = ParseLine("/XC")
Display.Encrypted = ParseLine("/XE")

No.Display.Archive = ParseLine("/ZA")
No.Display.Hidden = ParseLine("/ZH")
No.Display.Readonly = ParseLine("/ZO")
No.Display.System = ParseLine("/ZS")
No.Display.Any = ParseLine("/ZX")

No.Display.Compressed = ParseLine("/ZC")
No.Display.Encrypted = ParseLine("/ZE")

' read synchronize switches.
Synch.Files1 = ParseLine("/A1")
Synch.Files2 = ParseLine("/A2")
Synch.Files3 = ParseLine("/A3")
Synch.Files4 = ParseLine("/A4")
Synch.Files5 = ParseLine("/A5")
Synch.Files6 = ParseLine("/A6")
Synch.Files7 = ParseLine("/A7")
Synch.Files8 = ParseLine("/A8")
Synch.Files9 = ParseLine("/A9")
Synch.FilesA = ParseLine("/AA")
Synch.FilesB = ParseLine("/AB")
Synch.FilesC = ParseLine("/AC")

' read synchronize override switches.
Synch.Type1 = ParseLine("/Z1")
Synch.Type2 = ParseLine("/Z2")
Synch.Type3 = ParseLine("/Z3")

' reset default date/time switch.
IF Synch.Type1 = False THEN
    IF Synch.Type2 = False THEN
        IF Synch.Type3 = False THEN
            Synch.Type3 = True
        END IF
    END IF
END IF

' read synchronize override switches.
Compare.Create.Date = ParseLine("/S1")
Compare.Access.Date = ParseLine("/S2")
Compare.Modify.Date = ParseLine("/S3")

' reset default synchronize override switch.
IF Compare.Create.Date = False THEN
    IF Compare.Access.Date = False THEN
        IF Compare.Modify.Date = False THEN
            Compare.Modify.Date = True
        END IF
    END IF
END IF

' read remaining alphabetic switches.
Synch.Files = ParseLine("/A")
Copy.Directory = ParseLine("/B1")
Zero.Nest = ParseLine("/B2")
Skip.Directory = ParseLine("/B3")
Continuous.Display2 = ParseLine("/C1")
Continuous.Display3 = ParseLine("/C2")
Continuous.Display = ParseLine("/C")
Drive.Letter = ParseLine("/H")
Delete.Copied = ParseLine("/I")
Delete.Directory = ParseLine("/K")
Dont.Overwrite = ParseLine("/M")
Prompt.Delete1 = ParseLine("/N")
Display.Wide = ParseLine("/O1")
Ambiguate.Display = ParseLine("/O2")
Prompt.Delete2 = ParseLine("/Q")
Recurse.Directories = ParseLine("/R")
Display.Path = ParseLine("/S")
Overwrite.Prompt = ParseLine("/W")
Short.Display = ParseLine("/X1")
Short.Display2 = ParseLine("/X2")
Short.Display3 = ParseLine("/X3")
Short.Display4 = ParseLine("/X4")
Display.Lowercase = ParseLine("/Y")
Display.Errors = ParseLine("/Z")
Disable.Cmd = ParseLine("/_")
Extended.Time = ParseLine("/-4")
Skip.All = ParseLine("/-5")

' parse append switches
Imbedded = INSTR(UCASE$(Command.Line), "/V2")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 3)
    CALL GetNumeric(Var#)
    IF Var# > 4294967295# THEN
        Boot.List$ = "Error specifying append value."
        GOTO Boot.Error
    END IF
    Byte.Switch = True
    Byte.Override = Var#
    Append.Dest = ParseLine("/V")
ELSE
    Resume.File = ParseLine("/V1")
    IF Resume.File THEN
        Append.Dest = True
    ELSE
        Append.Dest = ParseLine("/V")
    END IF
END IF

' read more switches
Pattern.Match = ParseLine("/@2")
Enable.Redirect = ParseLine("/@")
Disable.Prompts = ParseLine("/#")

' read extended display switches.
IF ParseLine("/L1") THEN
    Double.Line = 1
END IF
IF ParseLine("/L2") THEN
    Double.Line = 2
END IF
IF ParseLine("/L3") THEN
    Double.Line = 3
END IF
IF ParseLine("/L4") THEN
    Double.Line = 4
END IF
IF ParseLine("/L") THEN
    Double.Line = 4
END IF
 
' init first copied directory flag.
IF Zero.Nest THEN
    Copy.Directory = True
END IF
IF Skip.Directory THEN
    Copy.Directory = True
END IF

' parse special debug switch.
Debug.ModeX = ParseLine("/-=")

' parse progress switches.
Progress.Bar = ParseLine("/*")
Percent.Display = ParseLine("/!")
Dot.Mode = ParseLine("/-")

' init display switches.
IF Percent.Display THEN
    Dot.Mode = True
END IF
IF Progress.Bar THEN
    Percent.Display = False
    Dot.Mode = True
END IF

' read timing switch.
Rate.Mode = ParseLine("/+")

' read debug mode switches
DebugDelay! = 3!
Var2 = 0
FOR Var = 0 TO 9
    Var2 = ParseLine("/=" + MID$(STR$(Var), 2))
    IF Var2 THEN
        DebugDelay! = CSNG(Var)
        Debug.Mode = -1
        EXIT FOR
    END IF
NEXT
IF Var2 = 0 THEN
    Debug.Mode = ParseLine("/=")
END IF

' set attribute display variable.
Display.Attribute = False
IF Display.Archive OR No.Display.Archive THEN
    Display.Attribute = True
END IF
IF Display.Hidden OR No.Display.Hidden THEN
    Display.Attribute = True
END IF
IF Display.Readonly OR No.Display.Readonly THEN
    Display.Attribute = True
END IF
IF Display.System OR No.Display.System THEN
    Display.Attribute = True
END IF
IF Display.Any OR No.Display.Any THEN
    Display.Attribute = True
END IF
IF Display.Compressed OR Display.Encrypted THEN
    Display.Attribute = True
END IF
IF No.Display.Compressed OR No.Display.Encrypted THEN
    Display.Attribute = True
END IF

' set source attribute flag.
Set.Source.Attribute = False
IF Clear.Source.Archive OR Set.Source.Archive THEN
    Set.Source.Attribute = True
END IF
IF Clear.Source.Hidden OR Set.Source.Hidden THEN
    Set.Source.Attribute = True
END IF
IF Clear.Source.Readonly OR Set.Source.Readonly THEN
    Set.Source.Attribute = True
END IF
IF Clear.Source.System OR Set.Source.System THEN
    Set.Source.Attribute = True
END IF
IF Clear.Source.Any OR Set.Source.Any THEN
    Set.Source.Attribute = True
END IF

' reset file counter variables.
Error.Level = False
Dirs.Counted = SFalse
Dirs.Created = SFalse
Files.Counted = DFalse
More.Display = False
Total.Deleted = False

' read excluded filename specs from command line.
Max.Excluded = 10
Number.Excluded = False
DO
    Excluded = INSTR(Command.Line, "/(")
    IF Excluded = False THEN
        EXIT DO
    END IF
    Var = LastSwitch(Excluded)
    Excluded.Spec$ = Nul
    Next.Bracket = INSTR(Excluded + 2, Command.Line, ")")
    IF Next.Bracket THEN
        Excluded.Spec$ = MID$(Command.Line, Excluded + 2, Next.Bracket - Excluded - 2)
        Command.Line = LEFT$(Command.Line, Excluded - 1) + MID$(Command.Line, Next.Bracket + 1)
    END IF
    IF Excluded.Spec$ = Nul THEN
        Boot.List$ = "Error specifying excluded list."
        GOTO Boot.Error
    END IF
    Number.Excluded = Number.Excluded + 1
    IF Number.Excluded > Max.Excluded THEN
        Max.Excluded = Max.Excluded + 10
        REDIM _PRESERVE Excluded.Files(1 TO Max.Excluded) AS STRING * 128
    END IF
    Excluded.Files(Number.Excluded) = UCASE$(Excluded.Spec$)
    Command.Line = RTRIM$(Command.Line)
LOOP

' read DOS commands from command line.
Max.Commands = 10
Number.Commands = False
DO
    DOSswitch = INSTR(Command.Line, "/[")
    IF DOSswitch = False THEN
        EXIT DO
    END IF
    Var = LastSwitch(DOSswitch)
    DOS.Spec$ = Nul
    Next.Bracket = INSTR(DOSswitch + 2, Command.Line, "]")
    IF Next.Bracket THEN
        DOS.Spec$ = MID$(Command.Line, DOSswitch + 2, Next.Bracket - DOSswitch - 2)
        Command.Line = LEFT$(Command.Line, DOSswitch - 1) + MID$(Command.Line, Next.Bracket + 1)
    END IF
    IF DOS.Spec$ = Nul THEN
        Boot.List$ = "Error specifying DOS command."
        GOTO Boot.Error
    END IF
    Number.Commands = Number.Commands + 1
    IF Number.Commands > Max.Commands THEN
        Max.Commands = Max.Commands + 10
        REDIM _PRESERVE DOS.Command(1 TO Max.Commands) AS STRING * 128
    END IF
    DOS.Command(Number.Commands) = DOS.Spec$
    Command.Line = RTRIM$(Command.Line)
LOOP

' parse dos command parameters.
FOR Count = 1 TO Number.Commands
    Next.Command$ = DOS.Command(Count)
    Imbedded = INSTR(Next.Command$, "//1")
    WHILE Imbedded
        Next.Command$ = LEFT$(Next.Command$, Imbedded - 1) + ">" + MID$(Next.Command$, Imbedded + 3)
        Imbedded = INSTR(Next.Command$, "//1")
    WEND
    Imbedded = INSTR(Next.Command$, "//2")
    WHILE Imbedded
        Next.Command$ = LEFT$(Next.Command$, Imbedded - 1) + "<" + MID$(Next.Command$, Imbedded + 3)
        Imbedded = INSTR(Next.Command$, "//2")
    WEND
    Imbedded = INSTR(Next.Command$, "//3")
    WHILE Imbedded
        Next.Command$ = LEFT$(Next.Command$, Imbedded - 1) + "|" + MID$(Next.Command$, Imbedded + 3)
        Imbedded = INSTR(Next.Command$, "//3")
    WEND
    Imbedded = INSTR(Next.Command$, "//4")
    WHILE Imbedded
        Next.Command$ = LEFT$(Next.Command$, Imbedded - 1) + "%" + MID$(Next.Command$, Imbedded + 3)
        Imbedded = INSTR(Next.Command$, "//4")
    WEND
    Imbedded = INSTR(Next.Command$, "//5")
    WHILE Imbedded
        Next.Command$ = LEFT$(Next.Command$, Imbedded - 1) + "]" + MID$(Next.Command$, Imbedded + 3)
        Imbedded = INSTR(Next.Command$, "//5")
    WEND
    DOS.Command(Count) = Next.Command$
NEXT

' read destination file date override.
Override.Date.Month = False
Override.Date.Day = False
Override.Date.Year = False
Override.Date = False
Imbedded = INSTR(Command.Line, "/5")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Date.Override$ = MID$(Command.Line, Imbedded + 2, 10)
    IF MID$(Date.Override$, 3, 1) <> "/" THEN
        Boot.List$ = "Error specifying override date."
        GOTO Boot.Error
    END IF
    IF MID$(Date.Override$, 6, 1) <> "/" THEN
        Boot.List$ = "Error specifying override date."
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 12)
    Override.Date.Month = INT(VAL(MID$(Date.Override$, 1, 2)))
    Override.Date.Day = INT(VAL(MID$(Date.Override$, 4, 2)))
    Override.Date.Year = INT(VAL(MID$(Date.Override$, 7, 4)))
    IF Override.Date.Month = 99 AND Override.Date.Day = 99 AND Override.Date.Year = 9999 THEN
        Override.Date.Month = VAL(LEFT$(DATE$, 2))
        Override.Date.Day = VAL(MID$(DATE$, 4, 2))
        Override.Date.Year = VAL(RIGHT$(DATE$, 4))
    END IF
    Override.Date = True
END IF

' read destination file time override.
Override.Time.Hour = False
Override.Time.Minute = False
Override.Time.Second = False
Override.Time = False
Imbedded = INSTR(Command.Line, "/6")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Time.Override$ = MID$(Command.Line, Imbedded + 2, 8)
    IF MID$(Time.Override$, 3, 1) <> ":" THEN
        Boot.List$ = "Error specifying override time."
        GOTO Boot.Error
    END IF
    IF MID$(Time.Override$, 6, 1) <> ":" THEN
        Boot.List$ = "Error specifying override time."
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 10)
    Override.Time.Hour = INT(VAL(MID$(Time.Override$, 1, 2)))
    Override.Time.Minute = INT(VAL(MID$(Time.Override$, 4, 2)))
    Override.Time.Second = INT(VAL(MID$(Time.Override$, 7, 2)))
    IF Override.Time.Hour = 99 AND Override.Time.Minute = 99 AND Override.Time.Second = 99 THEN
        Override.Time.Hour = INT(VAL(LEFT$(TIME$, 2)))
        Override.Time.Minute = INT(VAL(MID$(TIME$, 4, 2)))
        Override.Time.Second = INT(VAL(RIGHT$(TIME$, 2)))
    END IF
    Override.Time = True
END IF

' read date from command line.
Search.Date = False
Search.From.Date = False
Search.To.Date = False
Imbedded = INSTR(UCASE$(Command.Line), "/E")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Search.Date = True
    ' /e01/01/1997-01/01/1997
    IF MID$(Command.Line, Imbedded + 4, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 7, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 12, 1) = "-" AND _
    MID$(Command.Line, Imbedded + 15, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 18, 1) = "/" THEN
        D$ = MID$(Command.Line, Imbedded + 2, 21)
        S$ = LEFT$(D$, 10)
        D1! = INT(VAL(MID$(S$, 1, 2))) ' month
        D2! = INT(VAL(MID$(S$, 4, 2))) ' day
        D3! = INT(VAL(MID$(S$, 7, 4))) ' year
        IF D1! = 99! AND D2! = 99! AND D3! = 9999! THEN ' current date
            D1! = VAL(LEFT$(DATE$, 2))
            D2! = VAL(MID$(DATE$, 4, 2))
            D3! = VAL(RIGHT$(DATE$, 4))
        END IF
        Search.From.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
        S$ = RIGHT$(D$, 10)
        D1! = INT(VAL(MID$(S$, 1, 2))) ' month
        D2! = INT(VAL(MID$(S$, 4, 2))) ' day
        D3! = INT(VAL(MID$(S$, 7, 4))) ' year
        IF D1! = 99! AND D2! = 99! AND D3! = 9999! THEN ' current date
            D1! = VAL(LEFT$(DATE$, 2))
            D2! = VAL(MID$(DATE$, 4, 2))
            D3! = VAL(RIGHT$(DATE$, 4))
        END IF
        Search.To.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
    ELSE
        ' /e-01/01/1997
       IF MID$(Command.Line, Imbedded + 2, 1) = "-" AND _
       MID$(Command.Line, Imbedded + 5, 1) = "/" AND _
       MID$(Command.Line, Imbedded + 8, 1) = "/" THEN
            Search.From.Date = False
            S$ = MID$(Command.Line, Imbedded + 3, 10)
            D1! = INT(VAL(MID$(S$, 1, 2))) ' month
            D2! = INT(VAL(MID$(S$, 4, 2))) ' day
            D3! = INT(VAL(MID$(S$, 7, 4))) ' year
            IF D1! = 99! AND D2! = 99! AND D3! = 9999! THEN ' current date
                D1! = VAL(LEFT$(DATE$, 2))
                D2! = VAL(MID$(DATE$, 4, 2))
                D3! = VAL(RIGHT$(DATE$, 4))
            END IF
            Search.To.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
            Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 13)
        ELSE
            ' /e01/01/1997-
          IF MID$(Command.Line, Imbedded + 4, 1) = "/" AND _
          MID$(Command.Line, Imbedded + 7, 1) = "/" AND _
          MID$(Command.Line, Imbedded + 12, 1) = "-" THEN
                Search.To.Date = False
                S$ = MID$(Command.Line, Imbedded + 2, 10)
                D1! = INT(VAL(MID$(S$, 1, 2))) ' month
                D2! = INT(VAL(MID$(S$, 4, 2))) ' day
                D3! = INT(VAL(MID$(S$, 7, 4))) ' year
                IF D1! = 99! AND D2! = 99! AND D3! = 9999! THEN ' current date
                    D1! = VAL(LEFT$(DATE$, 2))
                    D2! = VAL(MID$(DATE$, 4, 2))
                    D3! = VAL(RIGHT$(DATE$, 4))
                END IF
                Search.From.Date = (D3! - 1980) * 512 + D1! * 32 + D2!
                Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 13)
            ELSE
                Boot.List$ = "Error specifying search date."
                GOTO Boot.Error
            END IF
        END IF
    END IF
    IF Search.From.Date < False OR Search.To.Date < False THEN
        Boot.List$ = "Error specifying search date."
        GOTO Boot.Error
    END IF
END IF

' read time from command line.
Search.Time = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Search.Time = True
    ' /t12:00:00-12:00:00
    IF MID$(Command.Line, Imbedded + 4, 1) = ":" AND _
    MID$(Command.Line, Imbedded + 7, 1) = ":" AND _
    MID$(Command.Line, Imbedded + 10, 1) = "-" AND _
    MID$(Command.Line, Imbedded + 13, 1) = ":" AND _
    MID$(Command.Line, Imbedded + 16, 1) = ":" THEN
        D$ = MID$(Command.Line, Imbedded + 2, 17)
        S$ = LEFT$(D$, 8)
        T1! = INT(VAL(MID$(S$, 1, 2))) ' hours
        T2! = INT(VAL(MID$(S$, 4, 2))) ' minutes
        T3! = INT(VAL(MID$(S$, 7, 2))) ' seconds
        IF T1! = 99 AND T2! = 99 AND T3! = 99 THEN
            T1! = INT(VAL(LEFT$(TIME$, 2)))
            T2! = INT(VAL(MID$(TIME$, 4, 2)))
            T3! = INT(VAL(RIGHT$(TIME$, 2)))
        END IF
        Search.From.Time = T1! * 2048 + T2! * 32 + T3!
        S$ = RIGHT$(D$, 8)
        T1! = INT(VAL(MID$(S$, 1, 2))) ' hours
        T2! = INT(VAL(MID$(S$, 4, 2))) ' minutes
        T3! = INT(VAL(MID$(S$, 7, 2))) ' seconds
        IF T1! = 99 AND T2! = 99 AND T3! = 99 THEN
            T1! = INT(VAL(LEFT$(TIME$, 2)))
            T2! = INT(VAL(MID$(TIME$, 4, 2)))
            T3! = INT(VAL(RIGHT$(TIME$, 2)))
        END IF
        Search.To.Time = T1! * 2048 + T2! * 32 + T3!
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
    ELSE
        ' /t-12:00:00
       IF MID$(Command.Line, Imbedded + 2, 1) = "-" AND _
       MID$(Command.Line, Imbedded + 5, 1) = ":" AND _
       MID$(Command.Line, Imbedded + 8, 1) = ":" THEN
            Search.From.Time = False
            S$ = MID$(Command.Line, Imbedded + 3, 8)
            T1! = INT(VAL(MID$(S$, 1, 2))) ' hours
            T2! = INT(VAL(MID$(S$, 4, 2))) ' minutes
            T3! = INT(VAL(MID$(S$, 7, 4))) ' seconds
            IF T1! = 99 AND T2! = 99 AND T3! = 99 THEN
                T1! = INT(VAL(LEFT$(TIME$, 2)))
                T2! = INT(VAL(MID$(TIME$, 4, 2)))
                T3! = INT(VAL(RIGHT$(TIME$, 2)))
            END IF
            Search.To.Time = T1! * 2048 + T2! * 32 + T3!
            Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 11)
        ELSE
            ' /t12:00:00-
          IF MID$(Command.Line, Imbedded + 4, 1) = ":" AND _
          MID$(Command.Line, Imbedded + 7, 1) = ":" AND _
          MID$(Command.Line, Imbedded + 10, 1) = "-" THEN
                Search.To.Time = False
                S$ = MID$(Command.Line, Imbedded + 2, 10)
                T1! = INT(VAL(MID$(S$, 1, 2))) ' hours
                T2! = INT(VAL(MID$(S$, 4, 2))) ' minutes
                T3! = INT(VAL(MID$(S$, 7, 4))) ' seconds
                IF T1! = 99 AND T2! = 99 AND T3! = 99 THEN
                    T1! = INT(VAL(LEFT$(TIME$, 2)))
                    T2! = INT(VAL(MID$(TIME$, 4, 2)))
                    T3! = INT(VAL(RIGHT$(TIME$, 2)))
                END IF
                Search.From.Time = T1! * 2048 + T2! * 32 + T3!
                Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 11)
            ELSE
                Boot.List$ = "Error specifying search time."
                GOTO Boot.Error
            END IF
        END IF
    END IF
    IF Search.From.Time < False OR Search.To.Time < False THEN
        Boot.List$ = "Error specifying search time."
        GOTO Boot.Error
    END IF
END IF

' read file size from command line.
Search.File.Size = False
Search.Size.From = DFalse
Search.Size.To = DFalse
Imbedded = INSTR(UCASE$(Command.Line), "/U")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Search.File.Size = True
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    CALL GetNumeric(Var#)
    Search.Size.From = Var#
    IF MID$(Command.Line, Imbedded, 1) <> "-" THEN
        Boot.List$ = "Error specifying search size."
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    CALL GetNumeric(Var#)
    Search.Size.To = Var#
    Search.Size.From = Search.Size.From * 1024#
    Search.Size.To = Search.Size.To * 1024#
END IF

' read pattern date from command line.
Pattern.Search.Date = False
Pattern.Search.From.Date = Nul
Pattern.Search.To.Date = Nul
Imbedded = INSTR(UCASE$(Command.Line), "/E1:")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Pattern.Search.Date = True
    ' /e1:01/01/2000-01/01/2010
    IF MID$(Command.Line, Imbedded + 6, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 9, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 14, 1) = "-" AND _
    MID$(Command.Line, Imbedded + 17, 1) = "/" AND _
    MID$(Command.Line, Imbedded + 20, 1) = "/" THEN
        D$ = MID$(Command.Line, Imbedded + 4, 21)
        Pattern.Search.From.Date = LEFT$(D$, 10)
        IF Pattern.Search.From.Date = "99/99/9999" THEN ' current date
            Pattern.Search.From.Date = DATE$
            MID$(Pattern.Search.From.Date, 3, 1) = "/"
            MID$(Pattern.Search.From.Date, 6, 1) = "/"
        END IF
        Pattern.Search.To.Date = RIGHT$(D$, 10)
        IF Pattern.Search.To.Date = "99/99/9999" THEN ' current date
            Pattern.Search.To.Date = DATE$
            MID$(Pattern.Search.To.Date, 3, 1) = "/"
            MID$(Pattern.Search.To.Date, 6, 1) = "/"
        END IF
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 25)
    ELSE
        Boot.List$ = "Error specifying pattern search date."
        GOTO Boot.Error
    END IF
END IF

' read filename pattern from command line.
Pattern.Search = False
Pattern.Filename = Nul
Imbedded = INSTR(UCASE$(Command.Line), "/E2:")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    IF MID$(Command.Line, Imbedded + 4, 1) = Quote THEN
        FOR Var = Imbedded + 5 TO LEN(Command.Line)
            IF MID$(Command.Line, Var, 1) = Quote THEN
                Pattern.Search = True
                Pattern.Filename = UCASE$(MID$(Command.Line, Imbedded + 5, Var - Imbedded - 5))
                Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Var + 1)
                EXIT FOR
            END IF
        NEXT
        IF Pattern.Search = False THEN
            Boot.List$ = "Error specifying filename pattern."
            GOTO Boot.Error
        END IF
    END IF
END IF

' verify both parameters set.
IF Pattern.Search OR Pattern.Search.Date THEN
    IF Pattern.Search = False OR Pattern.Search.Date = False THEN
        Boot.List$ = "Error specifying filename pattern."
        GOTO Boot.Error
    END IF
END IF

' read remaining numeric switches.
Copy.Zero = ParseLine("/0")
Copy.Ascii = ParseLine("/1")

' read ascii replacement filters from command line.
Ascii.Filters = False
Max.Filters = 10
DO
    Imbedded = INSTR(Command.Line, "/2")
    IF Imbedded = False THEN
        EXIT DO
    END IF
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    CALL GetNumeric(Var#)
    IF Var# > 255# THEN
        Boot.List$ = "Error specifying search filter."
        GOTO Boot.Error
    END IF
    Ascii.From = CINT(Var#)
    IF MID$(Command.Line, Imbedded, 1) <> "-" THEN
        Boot.List$ = "Error specifying search filter."
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    CALL GetNumeric(Var#)
    IF Var# > 255# THEN
        Boot.List$ = "Error specifying search filter."
        GOTO Boot.Error
    END IF
    Ascii.To = CINT(Var#)
    IF Ascii.To <> Ascii.From THEN
        Ascii.Filters = Ascii.Filters + 1
        IF Ascii.Filters > Max.Filters THEN
            Max.Filters = Max.Filters + 10
            REDIM _PRESERVE Convert.Ascii(1 TO Max.Filters, 1 TO 2) AS INTEGER
        END IF
        Convert.Ascii(Ascii.Filters, 1) = Ascii.From
        Convert.Ascii(Ascii.Filters, 2) = Ascii.To
    END IF
LOOP

' read ascii strip filters from command line.
Ascii.Strips = False
Max.Strips = 10
DO
    Imbedded = INSTR(Command.Line, "/3")
    IF Imbedded = False THEN
        EXIT DO
    END IF
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    CALL GetNumeric(Var#)
    IF Var# > 255# THEN
        Boot.List$ = "Error specifying strip filter."
        GOTO Boot.Error
    END IF
    Ascii.Strips = Ascii.Strips + 1
    IF Ascii.Strips > Max.Strips THEN
        Max.Strips = Max.Strips + 10
        REDIM _PRESERVE Strip.Ascii(1 TO Max.Strips) AS INTEGER
    END IF
    Strip.Ascii(Ascii.Strips) = CINT(Var#)
LOOP

' read nest override switch.
Imbedded = INSTR(Command.Line, "/4")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    CALL GetNumeric(Var#)
    IF Var# > 32767# THEN
        Boot.List$ = "Error specifying nest override."
        GOTO Boot.Error
    END IF
    Nested.Recurse = CINT(Var#)
END IF

' read override switches.
Override.Create.Date = ParseLine("/7")
Override.Access.Date = ParseLine("/8")
Override.Modify.Date = ParseLine("/9")

' reset remaining variables.
Dest.Dir = Nul
Max.Dest.Dirs = 10
Number.Dest.Dirs = False

Dest.File = Nul
Max.Dest.Files = 10
Number.Dest.Files = False

Max.Dest.Nets = 10
Number.Dest.Nets = False

Temp.Drive.Dir = Nul

' check command line.
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' read remaining filename switches.
DO
    IF INSTR(Command.Line, "/") = False THEN
        ' check trailing command line.
        Command.Line = RTRIM$(Command.Line)
        IF Switch.Exist THEN
            IF LEN(Command.Line) > Last.Switch THEN
                Boot.List$ = "Unknown command line characters."
                GOTO Boot.Error
            END IF
        END IF
        EXIT DO
    END IF
    FOR Count = LEN(Command.Line) TO 1 STEP -1
        IF MID$(Command.Line, Count, 1) = "/" THEN
            ' store switch letter.
            Switch$ = MID$(Command.Line, Count + 1, 1)

            ' store switch value.
            Var = LastSwitch(Count)
            Switch.Line$ = MID$(Command.Line, Count + 2)
            Switch.Line$ = LTRIM$(Switch.Line$)
            Switch.Line$ = RTRIM$(Switch.Line$)

            ' check quoted string.
            File.Quotes = False
            IF RIGHT$(Switch.Line$, 1) = Quote THEN
                IF LEFT$(Switch.Line$, 1) = Quote THEN
                    Switch.Line$ = MID$(Switch.Line$, 2)
                    Switch.Line$ = LEFT$(Switch.Line$, LEN(Switch.Line$) - 1)
                    File.Quotes = True
                END IF
            END IF

            ' process switch.
            SELECT CASE UCASE$(Switch$)
                CASE "F" ' filename
                    Var = LastSwitch(Count)
                    IF LEN(Switch.Line$) = False THEN
                        Boot.List$ = "Missing command line characters."
                        GOTO Boot.Error
                    END IF
                    IF INSTR(Switch.Line$, " ") THEN
                        IF File.Quotes = False THEN
                            Boot.List$ = "Unknown command line characters."
                            GOTO Boot.Error
                        END IF
                    END IF
                    Number.Dest.Files = Number.Dest.Files + 1
                    IF Number.Dest.Files > Max.Dest.Files THEN
                        Max.Dest.Files = Max.Dest.Files + 10
                        REDIM _PRESERVE Destinate.Filename(1 TO Max.Dest.Files) AS STRING * 260
                    END IF
                    Destinate.Filename(Number.Dest.Files) = Switch.Line$
                    Dest.File = Switch.Line$
                CASE "D" ' directory
                    Var = LastSwitch(Count)
                    IF LEN(Switch.Line$) = False THEN
                        ' check /d w/o parameters specified
                        IF Zero.Dirs THEN
                            Boot.List$ = "Multiple nul directories not allowed."
                            GOTO Boot.Error
                        END IF
                        ' set /d w/o parameters specified
                        Zero.Dirs = True
                    END IF
                    IF INSTR(Switch.Line$, " ") THEN
                        IF File.Quotes = False THEN
                            Boot.List$ = "Unknown command line characters."
                            GOTO Boot.Error
                        END IF
                    END IF
                    Number.Dest.Dirs = Number.Dest.Dirs + 1
                    IF Number.Dest.Dirs > Max.Dest.Dirs THEN
                        Max.Dest.Dirs = Max.Dest.Dirs + 10
                        REDIM _PRESERVE Destinate.Directory(1 TO Max.Dest.Dirs) AS STRING * 260
                    END IF
                    ' check /d w/o parameters specified
                    IF Number.Dest.Dirs > 1 THEN
                        IF Zero.Dirs THEN
                            Boot.List$ = "Combined specified and nul directory not allowed."
                            GOTO Boot.Error
                        END IF
                    END IF
                    Destinate.Directory(Number.Dest.Dirs) = Switch.Line$
                CASE "G" ' netpath
                    Var = LastSwitch(Count)
                    IF LEN(Switch.Line$) = False THEN
                        ' check /g w/o parameters specified
                        IF Zero.Nets THEN
                            Boot.List$ = "Multiple nul netpaths not allowed."
                            GOTO Boot.Error
                        END IF
                        ' set /g w/o parameters specified
                        Zero.Nets = True
                    END IF
                    IF INSTR(Switch.Line$, " ") THEN
                        IF File.Quotes = False THEN
                            Boot.List$ = "Unknown command line characters."
                            GOTO Boot.Error
                        END IF
                    END IF
                    Number.Dest.Nets = Number.Dest.Nets + 1
                    IF Number.Dest.Nets > Max.Dest.Nets THEN
                        Max.Dest.Nets = Max.Dest.Nets + 10
                        REDIM _PRESERVE Destinate.Netpaths(1 TO Max.Dest.Nets) AS STRING * 260
                    END IF
                    ' check /g w/o parameters specified
                    IF Number.Dest.Nets > 1 THEN
                        IF Zero.Nets THEN
                            Boot.List$ = "Combined specified and nul netpaths not allowed."
                            GOTO Boot.Error
                        END IF
                    END IF
                    IF LEFT$(Switch.Line$, 2) <> "\\" THEN
                        IF Zero.Nets = False THEN
                            Boot.List$ = "Unknown netpath characters."
                            GOTO Boot.Error
                        END IF
                    END IF
                    Destinate.Netpaths(Number.Dest.Nets) = Switch.Line$
                CASE ELSE ' unknown switch
                    EXIT DO
            END SELECT
            Command.Line = LEFT$(Command.Line, Count - 1)
            Command.Line = RTRIM$(Command.Line)
            EXIT FOR
        END IF
    NEXT
LOOP

' check trailing command line.
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        Boot.List$ = "Unknown command line characters."
        GOTO Boot.Error
    END IF
END IF

' check zero dirs specified
IF Number.Dest.Nets > 1 THEN
    IF Zero.Dirs THEN
        Boot.List$ = "Nul directory and multiple netpaths not allowed."
        GOTO Boot.Error
    END IF
END IF

' check zero nets specified
IF Number.Dest.Nets > 1 THEN
    IF Zero.Nets THEN
        Boot.List$ = "Nul netpath and multiple netpaths not allowed."
        GOTO Boot.Error
    END IF
END IF

' reset temporary drive.
IF Temp.Drive.Dir = Nul THEN
    Temp$ = ENVIRON$("TEMP")
    IF LEN(Temp$) THEN
        Temp.Drive.Dir = Temp$
    ELSE
        Temp$ = ENVIRON$("TMP")
        IF LEN(Temp$) THEN
            Temp.Drive.Dir = Temp$
        END IF
    END IF
END IF

' recheck command line.
IF INSTR(Command.Line, "/") THEN
    Boot.List$ = "Unknown / switch."
    GOTO Boot.Error
END IF

' reset work variables.
Copy.Target = Nul
Continue.Searching = False
Nested.Levels = False
Quit.Searching = False
   
' store remaining command line.
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' leave arrays in reverse order.
IF Ignore.Sort THEN
    EXIT SUB
END IF

' sort arrays ascending.
IF Sort.Method = 1 THEN
    IF Number.Dest.Files > 1 THEN
        FOR Var1 = 1 TO Number.Dest.Files
            FOR Var2 = Var1 + 1 TO Number.Dest.Files
                IF Destinate.Filename(Var1) > Destinate.Filename(Var2) THEN
                    SWAP Destinate.Filename(Var1), Destinate.Filename(Var2)
                END IF
            NEXT
        NEXT
    END IF
    IF Number.Dest.Dirs > 1 THEN
        FOR Var1 = 1 TO Number.Dest.Dirs
            FOR Var2 = Var1 + 1 TO Number.Dest.Dirs
                IF Destinate.Directory(Var1) > Destinate.Directory(Var2) THEN
                    SWAP Destinate.Directory(Var1), Destinate.Directory(Var2)
                END IF
            NEXT
        NEXT
    END IF
    IF Number.Dest.Nets > 1 THEN
        FOR Var1 = 1 TO Number.Dest.Nets
            FOR Var2 = Var1 + 1 TO Number.Dest.Nets
                IF Destinate.Netpaths(Var1) > Destinate.Netpaths(Var2) THEN
                    SWAP Destinate.Netpaths(Var1), Destinate.Netpaths(Var2)
                END IF
            NEXT
        NEXT
    END IF
    EXIT SUB
END IF

' sort arrays descending.
IF Sort.Method = 2 THEN
    IF Number.Dest.Files > 1 THEN
        FOR Var1 = 1 TO Number.Dest.Files
            FOR Var2 = Var1 + 1 TO Number.Dest.Files
                IF Destinate.Filename(Var1) < Destinate.Filename(Var2) THEN
                    SWAP Destinate.Filename(Var1), Destinate.Filename(Var2)
                END IF
            NEXT
        NEXT
    END IF
    IF Number.Dest.Dirs > 1 THEN
        FOR Var1 = 1 TO Number.Dest.Dirs
            FOR Var2 = Var1 + 1 TO Number.Dest.Dirs
                IF Destinate.Directory(Var1) < Destinate.Directory(Var2) THEN
                    SWAP Destinate.Directory(Var1), Destinate.Directory(Var2)
                END IF
            NEXT
        NEXT
    END IF
    IF Number.Dest.Nets > 1 THEN
        FOR Var1 = 1 TO Number.Dest.Nets
            FOR Var2 = Var1 + 1 TO Number.Dest.Nets
                IF Destinate.Netpaths(Var1) < Destinate.Netpaths(Var2) THEN
                    SWAP Destinate.Netpaths(Var1), Destinate.Netpaths(Var2)
                END IF
            NEXT
        NEXT
    END IF
    EXIT SUB
END IF

' restore arrays to original order.
IF Number.Dest.Files > 1 THEN
    Last.Array = Number.Dest.Files
    Pivot.Array = INT(Last.Array / 2)
    FOR Var = 1 TO Pivot.Array
        SWAP Destinate.Filename(Var), Destinate.Filename(Last.Array)
        Last.Array = Last.Array - 1
    NEXT
END IF
IF Number.Dest.Dirs > 1 THEN
    Last.Array = Number.Dest.Dirs
    Pivot.Array = INT(Last.Array / 2)
    FOR Var = 1 TO Pivot.Array
        SWAP Destinate.Directory(Var), Destinate.Directory(Last.Array)
        Last.Array = Last.Array - 1
    NEXT
END IF
IF Number.Dest.Nets > 1 THEN
    Last.Array = Number.Dest.Nets
    Pivot.Array = INT(Last.Array / 2)
    FOR Var = 1 TO Pivot.Array
        SWAP Destinate.Netpaths(Var), Destinate.Netpaths(Last.Array)
        Last.Array = Last.Array - 1
    NEXT
END IF
EXIT SUB

Boot.Error:
IF Display.Header = 0 THEN
    COLOR White, Black
    PRINT "Copyit " + Version$ + " " + Release$ + ": File copy utility; "
END IF
COLOR Yellow, Black
PRINT Boot.List$
PRINT "Type Copyit /? for help. Or edit Copyit.cfg file."
COLOR Plain, Black
PRINT "Exiting to DOS:"
END 2

' trap any errors before switch subroutine exits to main copying code.
Boot.Error2:
DataError = ERR
Boot.List$ = "Critical error:" + STR$(DataError) + " IDE line:" + STR$(_ERRORLINE)
RESUME Boot.Error
END SUB

' subroutines searchs for and parses config file.
SUB ReadConfig (Var$, File.Found)
VarX$ = Var$
File.Found = False
IF LEFT$(VarX$, 1) = Quote THEN
    VarX$ = MID$(VarX$, 2)
END IF
IF RIGHT$(VarX$, 1) = Quote THEN
    VarX$ = LEFT$(VarX$, LEN(VarX$) - 1)
END IF
IF RIGHT$(VarX$, 1) <> "\" THEN
    VarX$ = VarX$ + "\"
END IF
VarX$ = VarX$ + "COPYIT.CFG"
IF _FILEEXISTS(VarX$) THEN
    CLOSE #1
    OPEN VarX$ FOR INPUT AS #1
    File.Found = True
    DO UNTIL EOF(1)
        LINE INPUT #1, Param$
        Var2$ = LTRIM$(RTRIM$(Param$))
        IF Var2$ <> Nul THEN
            IF LEFT$(Var2$, 1) <> ";" THEN
                Command.Line = Command.Line + Param$
            END IF
        END IF
    LOOP
END IF
CLOSE #1
END SUB

' subroutine converts string to numeric value
SUB GetNumeric (Value#)
Value# = DFalse
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Value# = Value# * 10# + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT SUB
    END IF
LOOP
END SUB

' display program usage
SUB BootUsage
Display.Page = 1
DO
    SELECT CASE Display.Page
        CASE 1
            GOSUB Display.Page.One
        CASE 2
            GOSUB Display.Page.Two
        CASE 3
            GOSUB Display.Page.Three
        CASE 4
            GOSUB Display.Page.Four
        CASE 5
            GOSUB Display.Page.Five
        CASE 6
            GOSUB Display.Page.Six
        CASE 7
            GOSUB Display.Page.Seven
        CASE 8
            GOSUB Display.Page.Eight
        CASE 9
            GOSUB Display.Page.Nine
        CASE 10
            GOSUB Display.Page.Ten
        CASE 11
            GOSUB Display.Page.Eleven
    END SELECT
    Prompt$ = "Press 1, 2, 3, 4, 5, a, b, n, s, x, ?, or q to quit:"
    CALL MorePrompt(Prompt$, "12345abnsx?q", Outpt$, "q")
    SELECT CASE Outpt$
        CASE "1"
            Display.Page = 1
        CASE "2"
            Display.Page = 2
        CASE "3"
            Display.Page = 3
        CASE "4"
            Display.Page = 4
        CASE "5"
            Display.Page = 5
        CASE "a"
            Display.Page = 6
        CASE "b"
            Display.Page = 7
        CASE "n"
            Display.Page = 8
        CASE "s"
            Display.Page = 9
        CASE "x"
            Display.Page = 10
        CASE "?"
            Display.Page = 11
        CASE "q"
            EXIT SUB
    END SELECT
LOOP
COLOR Plain, Black
PRINT "Exiting to DOS:"
END 2

Display.Page.One:
GOSUB Display.Header
PRINT "Where:"
PRINT "   <filelist> is source files to copy and are:"
PRINT "     multiple files specified:"
PRINT "       [@][d:][\path\][filename.ext]"
PRINT "     or with netpath specified \\server\share\"
PRINT "       @ prefix specifies filename containing filelist to copy"
PRINT "   (destination switches):"
PRINT "     /d[d:][\pathname\]  is destination directory"
PRINT "     /f[filename.ext]    is destination filename"
PRINT "     /g[\\server\share\] is destination netpath"
PRINT "   (directory/file switches):"
PRINT "     /a  synchronize dest. files"
PRINT "     /b1 copy directory structure w\o rename"
PRINT "     /b2 copy directory structure w\ rename"
PRINT "     /b3 only copy directories with files found"
PRINT "     /i  delete files after copy"
PRINT "     /k  delete directory after copy"
PRINT "     /n  don't prompt to delete file after copy"
PRINT "     /q  don't prompt to delete directory after copy"
PRINT "     /0  don't copy zero-length files"
RETURN

Display.Page.Two:
GOSUB Display.Header
PRINT "Where:"
PRINT "   (standard copying switches):"
PRINT "     /j  force environment variable to lowercase"
PRINT "     /m  don't overwrite dest. file"
PRINT "     /p  display command line"
PRINT "     /r  recurse directories"
PRINT "     /v  append to dest. file"
PRINT "     /v1 append/resume to dest. file"
PRINT "     /v2### copy from byte position"
PRINT "     /w  don't prompt before overwrite"
PRINT "   (display switches):"
PRINT "     /c  continuous display         /x1 don't display dest. filename"
PRINT "     /c1  continuous output display /x2 don't prepend display type"
PRINT "     /c2  skip file overwrite       /x3 don't display override display"
PRINT "     /h  don't display drive letter /x4 don't display any filenames"
PRINT "     /o1 display wide list          /y  display files in lowercase"
PRINT "     /o2 ambiguate filename         /z  suppress error messages"
PRINT "     /s  don't display pathname"
PRINT "   (filelist switches):"
PRINT "     /@  enable filelists           /#  disable filelist prompts"
PRINT "     /@2 ignore pattern matching for filelist filenames"
RETURN

Display.Page.Three:
GOSUB Display.Header
PRINT "Where:"
PRINT "   (copy filter switches):"
PRINT "     /1  copy file to eof"
PRINT "     /2xxx-xxx  convert ascii filter (fast)"
PRINT "     /3xxx  strip ascii values (slow)"
PRINT "     /4xxx nested directories"
PRINT "   (file override switches):"
PRINT "     /5mm/dd/yyyy  override destination file date"
PRINT "     /6hh:mm:ss    override destination file time"
PRINT "     /7  creation date/time"
PRINT "     /8  last access date/time"
PRINT "     /9  last modified (write) date/time"
PRINT "   (file override ranges):"
PRINT "     /e  search date in form mm/dd/yyyy-mm/dd/yyyy"
PRINT "     /t  search time in form hh:mm:ss-hh:mm:ss"
PRINT "     /u  search file size in form xxx-xxx in kilobytes"
PRINT "   (compare switches used with /e, /t):"
PRINT "     /s1  compare source creation date/time"
PRINT "     /s2  compare source last access date/time"
PRINT "     /s3  compare source last modified date/time"
RETURN

Display.Page.Four:
GOSUB Display.Header
PRINT "Where:"
PRINT "   (date range switches):"
PRINT "     /e1:mm/dd/yyyy-mm/dd/yyyy  pattern match date range"
PRINT "     /e2:" + Quote + "filename.ext" + Quote + "  pattern match filename, include:"
PRINT "       MM, DD, YY, or YYYY, ?, to match with /e1:"
PRINT "   (file attributes switches):"
PRINT "     [prefix1][prefix2][ahosx]"
PRINT "       prefix1: / copy files, // reset dest. file, /// reset source file;"
PRINT "       prefix2: x  with\clear, z  without\set;"
PRINT "       attribute: a  archive, h  hidden, o  read-only, s  system, x  none"
PRINT "   (additional display switches):"
PRINT "     /l1  display file creation\last access\last modified date/time."
PRINT "     /l2  display /l1 plus filesize."
PRINT "     /l3  display /l2 plus file attributes."
PRINT "     /l4  display /l3 plus bytes counted\copied, directories deleted."
PRINT "     /l   same as /l4"
PRINT "   (extended display switches):"
PRINT "     /*  display progress bar  /!  display percent copied"
PRINT "     /-  disable copying dots  /+  display transfer rate"
RETURN

Display.Page.Five:
GOSUB Display.Header
PRINT "Where:"
PRINT "   (debug switches):"
PRINT "     /=<x>  set /= and more prompt to <x> seconds"
PRINT "     /=  enable extended error messages  /:  ignore skipped files"
PRINT "     /.  disable reading configure file"
PRINT "   (exclude file list switch):"
PRINT "     /(<filename.ext>)"
PRINT "       Excludes files containing ? and * characters when"
PRINT "       enclosed in parenthesis. Multiple exclusions allowed."
PRINT "   (DOS command switch): (use /_ for /K in command call);"
PRINT "     /[<command>]  with command replacement parameters:"
PRINT "       %1 = d:, %2 = d:\, %3 = d:\pathname, %4 = d:\pathname\"
PRINT "       %5 = d:\pathname\filename.ext, %6 = \pathname, %7 = \pathname\"
PRINT "       %8 = \pathname\filename.ext, %9 = filename.ext, %a = filename"
PRINT "       %b = .ext, %c = ext, //1 = >, //2 = <, //3 = |, //4 = %, //5 = ]"
PRINT "   (exit errorlevel codes):"
PRINT "     0 = files copied successfully   2 = no files were copied"
PRINT "     4 = disk full/disk not ready    8 = copy interrupted by user"
RETURN

Display.Page.Six:
CLS
COLOR White, Black
PRINT "Alphabetic list of Copyit command line switches (page 'a'):"
COLOR Yellow, Black
PRINT "/a - synchronize dest. files           /p - display command line"
PRINT "/b - copy directory structure          /q - don't prompt to delete directory"
PRINT "/c - continuous list                   /r - recursive directory search"
PRINT "/c1 - continuous output display        /s - don't display pathname"
PRINT "/c2 - skip file overwrite              /t - time range hh:mm:ss-hh:mm:ss"
PRINT "/d - destination directory [d:][\path] /u - file size range in KB"
PRINT "/e - date range mm/dd/yyyy-mm/dd/yyyy  /v - append to dest. file"
PRINT "/f - destination file [filename.ext]   /v1 - append/resume to dest. file"
PRINT "/g - specifies dest. \\server\share\   /v2 - copy from byte position"
PRINT "/h - don't display drive letter        /w - don't prompt before overwrite"
PRINT "/i - delete files after copy           /x1 - don't display dest. filename"
PRINT "/j - force environment to lowercase    /x2 - don't prepend display type"
PRINT "/k - delete directory after copy       /x3 - don't display override display"
PRINT "/lx - added info switches x=1-4        /x4 - don't display any filenames"
PRINT "/m - don't overwrite dest. file        /y - display files in lowercase"
PRINT "/n - don't prompt to delete file       /z - don't display errors"
PRINT "/o1 - display wide list"
PRINT "/o2 - ambiguate filename"
RETURN

Display.Page.Seven:
CLS
COLOR White, Black
PRINT "Bit copying list of Copyit command line switches (page 'b'):"
COLOR Yellow, Black
PRINT "Source copy bits:"
PRINT "/xa - with archive bit                  /xh - with hidden bit"
PRINT "/xo - with read-only bit                /xs - with system bit"
PRINT "/xx - with no bits (without all bits)"
PRINT "/za - without archive bit               /zh - without hidden bit"
PRINT "/zo - without read-only bit             /zs - without system bit"
PRINT "/zx - without no bits (with only all bits)"
PRINT "Destination reset bits:"
PRINT "//xa - set dest. archive bit            //xh - set dest. hidden bit"
PRINT "//xo - set dest. read-only bit          //xs - set dest. system bit"
PRINT "//xx - set all dest. bits"
PRINT "//za - clear dest. archive bit          //zh - clear dest. hidden bit"
PRINT "//zo - clear dest. read-only bit        //zs - clear dest. system bit"
PRINT "//zx - clear all dest. bits"
PRINT "Source reset bits:"
PRINT "///xa - set source archive bit          ///xh - set source hidden bit"
PRINT "///xo - set source read-only bit        ///xs - set source system bit"
PRINT "///xx - set all source bits"
PRINT "///za - clear source archive bit        ///zh - clear source hidden bit"
PRINT "///zo - clear source read-only bit      ///zs - clear source system bit"
PRINT "///zx - clear all source bits"
RETURN

Display.Page.Eight:
CLS
COLOR White, Black
PRINT "Numeric list of Copyit command line switches (page 'n'):"
COLOR Yellow, Black
PRINT "/0 - don't copy zero-length files"
PRINT "/1 - copy ascii file to eof"
PRINT "/2 - convert ascii filter xxx-xxx (fast)"
PRINT "/3 - strip ascii filter (slow)"
PRINT "/4 - override nested directories"
PRINT "/5 - specify dest. file date mm/dd/yyyy override"
PRINT "/6 - specify dest. file time hh:mm:ss override"
PRINT "/7 - file creation date/time override"
PRINT "/8 - file last access date/time override"
PRINT "/9 - file last modified date/time override"
PRINT "/-1 - ignore file sort during command line parsing"
PRINT "/-2 - sort command line files ascending"
PRINT "/-3 - sort command line files descending"
PRINT "/-4 - display extended time for /L"
PRINT "/-5 - skips all duplicate files from being copied"
RETURN

Display.Page.Nine:
CLS
COLOR White, Black
PRINT "List of extended /a synchronize numeric switches (page 's'):"
COLOR Yellow, Black
PRINT "/a1  copy source files with sizes less than destination file sizes."
PRINT "/a2  copy source files with sizes greater than destination file sizes."
PRINT "/a3  copy source files with sizes equal to destination file sizes."
PRINT "/a4  copy source files with sizes not equal to destination file sizes."
PRINT "/a5  copy source files with dates earlier than destination file dates."
PRINT "/a6  copy source files with dates greater than destination file dates."
PRINT "/a7  copy source files with dates equal to destination file dates."
PRINT "/a8  copy source files with dates not equal to destination file dates."
PRINT "/a9  copy source files with times earlier than destination file times."
PRINT "/aa  copy source files with times greater than destination file times."
PRINT "/ab  copy source files with times equal to destination file times."
PRINT "/ac  copy source files with times not equal to destination file times."
COLOR White, Black
PRINT "Synchronize switches for date/time comparing: (used with /a)"
COLOR Yellow, Black
PRINT "/z1  compare source creation date/time"
PRINT "/z2  compare source last access date/time"
PRINT "/z3  compare source last modified date/time"
COLOR White, Black
PRINT "Special copy switches:"
COLOR Yellow, Black
PRINT "/xc copy only compressed files, /xe copy only encrypted files."
PRINT "/zc don't copy compressed files,  /ze  don't copy encrypted files."
RETURN

Display.Page.Ten:
CLS
COLOR White, Black
PRINT "List of Copyit examples (page 'x'):"
COLOR Yellow, Black
PRINT "Copy all .doc files to the \temp directory:"
PRINT "  Copyit *.doc /d\temp"
PRINT "Copy all .lst and .txt files to the c: drive \temp directory:"
PRINT "  Copyit *.lst *.txt /dc:\temp\"
PRINT "Copy the file temp.lst to the file temp2.lst in the temp directory:"
PRINT "  Copyit temp.lst /d\temp /ftemp2.lst"
PRINT "Copy files with the hidden attribute set:"
PRINT "  Copyit *.* /d\temp\ /xh"
PRINT "Copy hidden files, and remove the hidden attribute:"
PRINT "  Copyit *.* /d\temp\ /xh //xh"
PRINT "Copy all .doc files into one file:"
PRINT "  Copyit *.doc /ffiles.txt /v"
PRINT "Copy all directories and files to another directory:"
PRINT "  Copyit \dos /d\temp /r/b2"
PRINT "Copy, then delete source files:"
PRINT "  Copyit \dos /d\temp /r/b2/i/k"
PRINT "Copy a file and take out linefeeds:"
PRINT "  Copyit filename.ext /ffile2.txt /310"
PRINT "Copy a file and change linefeeds to carriage returns:"
PRINT "  Copyit filename.ext /ffile3.txt /210-13"
Prompt$ = "Press <enter> to continue:"
CALL MorePrompt(Prompt$, CHR$(13), Outpt$, CHR$(13))
CLS
COLOR White, Black
PRINT "List of Copyit examples (page 'x'):"
COLOR Yellow, Black
PRINT "Copy long filenames specified in quotes:"
PRINT "  Copyit " + Quote + "c:\program files" + Quote + " /d" + Quote + "d:\program files" + Quote + " /r/b2"
PRINT "Copy all files in root to both directories:"
PRINT "  Copyit \*.* /dc:\tmp1 /dc:\tmp2"
PRINT "Copy all doc and tmp files to both files:"
PRINT "  Copyit *.doc *.tmp /ffile1.out /ffile2.out"
PRINT "Copy all files to both filenames in the directory:"
PRINT "  Copyit *.* /dd:\tmp1 /ffilea.out /ffileb.out"
PRINT "Excludes file starting with 'temp' followed by the extension .dat"
PRINT "  Copyit *.dat /dd:\work /(temp*.dat)"
PRINT "Excludes files starting with 'temp'."
PRINT "  Copyit *.* /dd:\work /(temp*.*)"
PRINT "Copy files with different file sizes:"
PRINT "  Copyit *.* /d\tmp1 /r/b1/a4"
PRINT "Copy files and changes its creation time:"
PRINT "  Copyit file? /foutput.txt /612:00:00/7"
PRINT "Copy files with sizes from 128k to 256k:"
PRINT "  Copyit file? /foutput.txt /u128-256"
PRINT "Copy files and display transfer rate and percent being copied:"
PRINT "  Copyit \*.bak /d\backup.1 /+/!"
RETURN

Display.Page.Eleven:
GOSUB Display.Header
PRINT "Where:"
COLOR White, Black
PRINT "List of reserved characters:"
COLOR Yellow, Black
PRINT "In DOS the 8.3 filename cannot contain any of the following characters:"
COLOR White, Black
PRINT "\:/*?" + Quote + ">|<"
COLOR Yellow, Black
PRINT "In Windows command line the following characters are reserved and should be"
PRINT "enclosed in quotes when used in filenames on the command line:"
COLOR White, Black
PRINT "<space>"
PRINT "&()[]{}^=;!'+,`~"
COLOR Yellow, Black
PRINT "Otherwise, prepend the reserved character with ^ character when"
PRINT "being used on the Copyit command line, for example:"
PRINT "  Copyit file.dat /ffile.bak /^&"
RETURN

' make header.
Display.Header:
CLS
COLOR White, Black
PRINT "Copyit " + Version$ + " " + Release$ + ": File copy utility help page";
IF Display.Page = 11 THEN
    PRINT " '?';"
ELSE
    PRINT STR$(Display.Page) + ";"
END IF
COLOR Yellow, Black
PRINT "Usage: Copyit <filelist>[/dfg][<switches>]"
RETURN
END SUB

' routine prompts user for an option
SUB MorePrompt (Input.String$, Input.Mask$, Output.String$, Default$)
CALL ClearDisplay(0)
Rate.Mode = False
Start.Timer! = TIMER
Input.Char$ = Nul
COLOR White, Black
PRINT Input.String$ + " ";
DO
    LOCATE , , 1
    DO
        _LIMIT 50
        Input.Char$ = INKEY$
        IF LEN(Input.Char$) THEN
            EXIT DO
        END IF
        IF Control.Break THEN
            Control.Break = False
            Input.Char$ = Default$
            EXIT DO
        END IF

        ' exits with default prompt in debug mode after timer.
        IF Debug.Mode THEN
            IF DebugDelay! = 0! THEN
                Input.Char$ = Default$
                EXIT DO
            END IF
            IF DebugDelay! > 0! THEN
                Elapsed.Time! = TIMER - Start.Timer!
                IF Elapsed.Time! < SFalse THEN
                    Elapsed.Time! = Elapsed.Time! + 86400!
                END IF
                IF Elapsed.Time! >= DebugDelay! THEN
                    Input.Char$ = Default$
                    EXIT DO
                END IF
            END IF
        END IF
    LOOP

    ' check keyboard input.
    Input.Char$ = LCASE$(Input.Char$)
    IF INSTR(Input.Mask$, Input.Char$) THEN
        IF Input.Char$ = CHR$(13) THEN
            PRINT
        ELSE
            PRINT Input.Char$
        END IF
        Output.String$ = Input.Char$
        EXIT DO
    END IF
LOOP
END SUB

' displays function error
SUB DisplayError (Temp$)
' check display errors flag.
IF Display.Errors = False THEN
    ' clear display progress
    CALL ClearDisplay(0)
    ' display error.
    COLOR Red, Black
    PRINT Temp$
END IF

' write error to file
IF Debug.ModeX THEN
    V = FREEFILE
    OPEN StartDir$ + "copyerr.log" FOR APPEND AS #V
    PRINT #V, DATE$ + " " + TIME$ + " " + Temp$ ' + " - Line:" + STR$(_ERRORLINE)
    CLOSE #V
END IF
END SUB

' subroutine to check for copying directory structure onto itself
SUB DirectoryCopying (Work.Net$)
' reset return flag.
Directory.Exists = False

' read source drive.
From.Drive = ASC(UCASE$(Drive.Search)) - 64

' read source directory.
Copy.From$ = RTRIM$(Dir.Copy.Name)
Copy.From2$ = Copy.From$
Work.Net3$ = RTRIM$(Source.Net)
Work.Net4$ = RTRIM$(Default.Net)
IF LEFT$(Copy.From$, 1) = "\" THEN
    IF Work.Net3$ <> Nul THEN
        Copy.From$ = RTRIM$(Work.Net3$) + Copy.From$
    ELSE
        IF Work.Net4$ <> Nul THEN
            Copy.From$ = RTRIM$(Work.Net4$) + Drive.Search + Copy.From$
        END IF
    END IF
ELSE
    IF Work.Net3$ <> Nul THEN
        Copy.From$ = RTRIM$(Work.Net3$) + "\" + Copy.From$
    ELSE
        IF Work.Net4$ <> Nul THEN
            Copy.From$ = RTRIM$(Work.Net4$) + Drive.Search + "\" + Copy.From$
        END IF
    END IF
END IF

' read target drive.
Copy.To$ = Copy.Target
IF MID$(Copy.To$, 2, 1) = ":" THEN
    Drive.Number = ASC(UCASE$(LEFT$(Copy.To$, 1))) - 64
    Copy.To$ = MID$(Copy.To$, 3)
ELSE
    Drive.Number = ASC(UCASE$(Drive.Search)) - 64
END IF

' read target directory.
IF LEFT$(Copy.To$, 1) <> "\" THEN
    Copy.To$ = Dest.Dir
    IF MID$(Copy.To$, 2, 1) = ":" THEN
        Drive.Number = ASC(UCASE$(LEFT$(Copy.To$, 1))) - 64
        Copy.To$ = MID$(Copy.To$, 3)
    ELSE
        Drive.Number = ASC(UCASE$(Drive.Search)) - 64
    END IF
    IF Work.Net$ = Nul THEN
        Copy.To$ = Default.Dir + "\" + Copy.To$
    END IF
END IF
IF Work.Net$ <> Nul THEN
    IF LEFT$(Copy.To$, 1) = "\" THEN
        Copy.To$ = Work.Net$ + Copy.To$
    ELSE
        Copy.To$ = Work.Net$ + "\" + Copy.To$
    END IF
END IF
Copy.From$ = LCASE$(Copy.From$)
Copy.To$ = LCASE$(Copy.To$)

' compare drives.
IF From.Drive = Drive.Number THEN
    ' check directories.
    IF Copy.From$ = Copy.To$ THEN
        Directory.Exists = -1
    END IF

    ' check recursing directories.
    IF Recurse.Directories THEN
        IF Copy.From2$ <> "\" THEN
            ' check recursive copying.
            IF Copy.From$ = LEFT$(Copy.To$, LEN(Copy.From$)) THEN
                Directory.Exists = -2
            END IF
        END IF
    END IF
END IF
END SUB

' subroutine constructs base filenames
SUB MakeFile (Work.Net$, From.File$, To.File$)
' make destination filename.
IF MID$(To.File$, 2, 1) = ":" THEN
    To.File$ = MID$(To.File$, 3)
END IF
IF LEFT$(To.File$, 1) <> "\" THEN
    IF Work.Net$ = Nul THEN
        IF Default.Dir = "\" THEN
            To.File$ = Default.Dir + To.File$
        ELSE
            To.File$ = Default.Dir + "\" + To.File$
        END IF
    END IF
    IF MID$(To.File$, 2, 1) = ":" THEN
        To.File$ = MID$(To.File$, 3)
    END IF
END IF
IF MID$(Dest.Dir, 2, 1) = ":" THEN
    Drive.Number = ASC(UCASE$(LEFT$(Dest.Dir, 1)))
ELSE
    Drive.Number = ASC(UCASE$(Drive.Search))
END IF
IF Work.Net$ = Nul THEN
    IF LEFT$(To.File$, 2) <> "\\" THEN
        To.File$ = CHR$(Drive.Number) + ":" + To.File$
    END IF
ELSE
    IF LEFT$(To.File$, 1) = "\" THEN
        To.File$ = Work.Net$ + To.File$
    ELSE
        To.File$ = Work.Net$ + "\" + To.File$
    END IF
END IF

' make source filename.
Work.Net2$ = RTRIM$(Source.Net)
IF MID$(From.File$, 2, 1) = ":" THEN
    From.File$ = MID$(From.File$, 3)
END IF
IF LEFT$(From.File$, 1) <> "\" THEN
    IF Work.Net2$ = Nul THEN
        IF Default.Dir = "\" THEN
            From.File$ = Default.Dir + From.File$
        ELSE
            From.File$ = Default.Dir + "\" + From.File$
        END IF
    END IF
    IF MID$(From.File$, 2, 1) = ":" THEN
        From.File$ = MID$(From.File$, 3)
    END IF
END IF
IF Work.Net2$ = Nul THEN
    IF LEFT$(From.File$, 2) <> "\\" THEN
        From.File$ = Drive.Search + ":" + From.File$
    END IF
ELSE
    IF LEFT$(From.File$, 1) = "\" THEN
        From.File$ = Work.Net2$ + From.File$
    ELSE
        From.File$ = Work.Net2$ + "\" + From.File$
    END IF
END IF

' check filenames.
IF Display.Lowercase THEN
    From.File$ = LCASE$(From.File$)
    To.File$ = LCASE$(To.File$)
END IF
END SUB

' subroutine constructs base netpath
SUB MakeFile2 (From.File$)
Work.Net$ = RTRIM$(Source.Net)
Work.Net2$ = RTRIM$(Default.Net)
IF MID$(From.File$, 2, 1) = ":" THEN
    From.File$ = MID$(From.File$, 3)
END IF
IF LEFT$(From.File$, 1) <> "\" THEN
    IF Work.Net$ = Nul AND Work.Net2$ = Nul THEN
        IF Default.Dir = "\" THEN
            From.File$ = Default.Dir + From.File$
        ELSE
            From.File$ = Default.Dir + "\" + From.File$
        END IF
    END IF
    IF MID$(From.File$, 2, 1) = ":" THEN
        From.File$ = MID$(From.File$, 3)
    END IF
END IF
IF Work.Net$ = Nul AND Work.Net2$ = Nul THEN
    From.File$ = Drive.Search + ":" + From.File$
ELSE
    IF LEFT$(From.File$, 1) = "\" THEN
        IF Work.Net$ <> Nul THEN
            From.File$ = RTRIM$(Work.Net$) + From.File$
        ELSE
            From.File$ = RTRIM$(Work.Net2$) + Drive.Search + From.File$
        END IF
    ELSE
        IF Work.Net$ <> Nul THEN
            From.File$ = RTRIM$(Work.Net$) + "\" + From.File$
        ELSE
            From.File$ = RTRIM$(Work.Net2$) + Drive.Search + "\" + From.File$
        END IF
    END IF
END IF
From.File$ = LCASE$(From.File$)
END SUB

' subroutine to create source filename from command line
SUB MakeFilename
' store entire command.
IF LEFT$(Command.Line, 1) = Quote THEN
    Imbedded = INSTR(2, Command.Line, Quote)
    IF Imbedded THEN
        Command.Work = MID$(Command.Line, 2, Imbedded - 2)
        Command.Line = MID$(Command.Line, Imbedded + 1)
    ELSE
        Command.Work = Command.Line
        Command.Line = Nul
    END IF
ELSE
    Imbedded = INSTR(Command.Line, " ")
    IF Imbedded THEN
        Command.Work = LEFT$(Command.Line, Imbedded - 1)
        Command.Line = MID$(Command.Line, Imbedded + 1)
    ELSE
        Command.Work = Command.Line
        Command.Line = Nul
    END IF
END IF
Command.Line = LTRIM$(Command.Line)
Command.Line = RTRIM$(Command.Line)
END SUB

' routine constructs file date string
FUNCTION MakeDate$ (Var)
SELECT CASE Var
    CASE 1
        x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
    CASE 2
        x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
    CASE 3
        x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
END SELECT
YearTemp! = SysTime.wYear
MonthTemp! = SysTime.wMonth
DayTemp! = SysTime.wDay
File.Date$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wMonth)), 2) + "-"
File.Date$ = File.Date$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wDay)), 2) + "-"
File.Date$ = File.Date$ + LTRIM$(STR$(SysTime.wYear))

IF Extended.Time THEN
    HourTemp! = SysTime.wHour
    MinuteTemp! = SysTime.wMinute
    SecondsTemp! = SysTime.wSecond
    File.Time$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wHour)), 2) + ":"
    File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wMinute)), 2) + ":"
    File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wSecond)), 2)
    File.Date$ = File.Date$ + " " + File.Time$
END IF

MakeDate$ = File.Date$
END FUNCTION

' routine checks file size range
SUB CheckSizeRange (Range)
' reset return flag.
Size.Flag = False

' check for zero-byte files.
IF Copy.Zero THEN
    IF File.Size = DFalse THEN
        Size.Flag = True
        EXIT SUB
    END IF
END IF

' check file size range.
IF Search.File.Size = False THEN
    EXIT SUB
END IF

' files of zero-byte are copied.
IF Search.Size.From = DFalse AND Search.Size.To = DFalse THEN
    IF File.Size <> DFalse THEN
        Size.Flag = True
    END IF
    EXIT SUB
END IF

' check /u10-
IF Search.Size.From > DFalse THEN
    IF Search.Size.To = DFalse THEN
        IF File.Size < Search.Size.From THEN
            Size.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /u-10
IF Search.Size.From = DFalse THEN
    IF Search.Size.To > DFalse THEN
        IF File.Size > Search.Size.To THEN
            Size.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /u10-20
IF Search.Size.From <= Search.Size.To THEN
    IF File.Size < Search.Size.From OR File.Size > Search.Size.To THEN
        Size.Flag = True
        EXIT SUB
    END IF
END IF

' check /u20-10
IF Search.Size.From > Search.Size.To THEN
    IF File.Size < Search.Size.From AND File.Size > Search.Size.To THEN
        Size.Flag = True
        EXIT SUB
    END IF
END IF
END SUB

' routine checks date/time ranges
'   checks creation, last access, last modified date/time.
SUB CheckDateRange (Range)
' reset return flag.
Range.Flag = False

' check date range.
IF Search.Date THEN
    IF Compare.Create.Date THEN ' /s1
        IF Search.From.Date > False OR Search.To.Date > False THEN
            ' /e01/01/1980-
            IF Search.From.Date > False THEN
                IF Search.To.Date = False THEN
                    IF Synch.Work.Create.Date < Search.From.Date THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /e-12/31/2010
            IF Search.From.Date = False THEN
                IF Search.To.Date > False THEN
                    IF Synch.Work.Create.Date > Search.To.Date THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /e01/01/1980-12/31/2010
            IF Search.From.Date <= Search.To.Date THEN
                IF Synch.Work.Create.Date < Search.From.Date OR Synch.Work.Create.Date > Search.To.Date THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
            ' /e12/31/2010-01/01/1980
            IF Search.From.Date > Search.To.Date THEN
                IF Synch.Work.Create.Date < Search.From.Date AND Synch.Work.Create.Date > Search.To.Date THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
    IF Compare.Access.Date THEN ' /s2
        IF Search.From.Date > False OR Search.To.Date > False THEN
            ' /e01/01/1980-
            IF Search.From.Date > False THEN
                IF Search.To.Date = False THEN
                    IF Synch.Work.Access.Date < Search.From.Date THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /e-12/31/2010
            IF Search.From.Date = False THEN
                IF Search.To.Date > False THEN
                    IF Synch.Work.Access.Date > Search.To.Date THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /e01/01/1980-12/31/2010
            IF Search.From.Date <= Search.To.Date THEN
                IF Synch.Work.Access.Date < Search.From.Date OR Synch.Work.Access.Date > Search.To.Date THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
            ' /e12/31/2010-01/01/1980
            IF Search.From.Date > Search.To.Date THEN
                IF Synch.Work.Access.Date < Search.From.Date AND Synch.Work.Access.Date > Search.To.Date THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
    IF Compare.Modify.Date THEN ' /s3
        IF Search.From.Date > False OR Search.To.Date > False THEN
            ' /e01/01/1980-
            IF Search.From.Date > False THEN
                IF Search.To.Date = False THEN
                    IF Synch.Work.Modify.Date < Search.From.Date THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /e-12/31/2010
            IF Search.From.Date = False THEN
                IF Search.To.Date > False THEN
                    IF Synch.Work.Modify.Date > Search.To.Date THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /e01/01/1980-12/31/2010
            IF Search.From.Date <= Search.To.Date THEN
                IF Synch.Work.Modify.Date < Search.From.Date OR Synch.Work.Modify.Date > Search.To.Date THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
            ' /e12/31/2010-01/01/1980
            IF Search.From.Date > Search.To.Date THEN
                IF Synch.Work.Modify.Date < Search.From.Date AND Synch.Work.Modify.Date > Search.To.Date THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
END IF

' check time range.
IF Search.Time THEN
    IF Compare.Create.Date THEN ' /s1
        IF Search.From.Time > False OR Search.To.Time > False THEN
            ' /t00:00:01-
            IF Search.From.Time > False THEN
                IF Search.To.Time = False THEN
                    IF Synch.Work.Create.Time < Search.From.Time THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /t-23:59:59
            IF Search.From.Time = False THEN
                IF Search.To.Time > False THEN
                    IF Synch.Work.Create.Time > Search.To.Time THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /t00:00:01-23:59:59
            IF Search.From.Time <= Search.To.Time THEN
                IF Synch.Work.Create.Time < Search.From.Time OR Synch.Work.Create.Time > Search.To.Time THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
            ' /t23:59:59-00:00:01
            IF Search.From.Time > Search.To.Time THEN
                IF Synch.Work.Create.Time < Search.From.Time AND Synch.Work.Create.Time > Search.To.Time THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
    IF Compare.Access.Date THEN ' /s2
        IF Search.From.Time > False OR Search.To.Time > False THEN
            ' /t00:00:01-
            IF Search.From.Time > False THEN
                IF Search.To.Time = False THEN
                    IF Synch.Work.Access.Time < Search.From.Time THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /t-23:59:59
            IF Search.From.Time = False THEN
                IF Search.To.Time > False THEN
                    IF Synch.Work.Access.Time > Search.To.Time THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /t00:00:01-23:59:59
            IF Search.From.Time <= Search.To.Time THEN
                IF Synch.Work.Access.Time < Search.From.Time OR Synch.Work.Access.Time > Search.To.Time THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
            ' /t23:59:59-00:00:01
            IF Search.From.Time > Search.To.Time THEN
                IF Synch.Work.Access.Time < Search.From.Time AND Synch.Work.Access.Time > Search.To.Time THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
    IF Compare.Modify.Date THEN ' /s3
        IF Search.From.Time > SFalse OR Search.To.Time > SFalse THEN
            ' /t00:00:01-
            IF Search.From.Time > SFalse THEN
                IF Search.To.Time = SFalse THEN
                    IF Synch.Work.Modify.Time < Search.From.Time THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /t-23:59:59
            IF Search.From.Time = SFalse THEN
                IF Search.To.Time > SFalse THEN
                    IF Synch.Work.Modify.Time > Search.To.Time THEN
                        Range.Flag = True
                        EXIT SUB
                    END IF
                END IF
            END IF
            ' /t00:00:01-23:59:59
            IF Search.From.Time <= Search.To.Time THEN
                IF Synch.Work.Modify.Time < Search.From.Time OR Synch.Work.Modify.Time > Search.To.Time THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
            ' /t23:59:59-00:00:01
            IF Search.From.Time > Search.To.Time THEN
                IF Synch.Work.Modify.Time < Search.From.Time AND Synch.Work.Modify.Time > Search.To.Time THEN
                    Range.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
END IF
END SUB

' routine verifies source - destination synchronized file size, date/time.
'   checks creation, last access, last modified date/time.
SUB CheckSynched (Synched)
' reset return value.
Synched.Flag = False

' check /a
IF Synch.Files THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF File.Size = Dest.File.Size THEN
            IF Synch.Work.Create.Date = Synch.File.Create.Date THEN
                IF Synch.Work.Create.Time = Synch.File.Create.Time THEN
                    Synched.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF File.Size = Dest.File.Size THEN
            IF Synch.Work.Access.Date = Synch.File.Access.Date THEN
                IF Synch.Work.Access.Time = Synch.File.Access.Time THEN
                    Synched.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF File.Size = Dest.File.Size THEN
            IF Synch.Work.Modify.Date = Synch.File.Modify.Date THEN
                IF Synch.Work.Modify.Time = Synch.File.Modify.Time THEN
                    Synched.Flag = True
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
END IF

' check /a1
IF Synch.Files1 THEN
    IF File.Size >= Dest.File.Size THEN
        Synched.Flag = True
        EXIT SUB
    END IF
END IF

' check /a2
IF Synch.Files2 THEN
    IF File.Size <= Dest.File.Size THEN
        Synched.Flag = True
        EXIT SUB
    END IF
END IF

' check /a3
IF Synch.Files3 THEN
    IF File.Size <> Dest.File.Size THEN
        Synched.Flag = True
        EXIT SUB
    END IF
END IF

' check /a4
IF Synch.Files4 THEN
    IF File.Size = Dest.File.Size THEN
        Synched.Flag = True
        EXIT SUB
    END IF
END IF

' check /a5
IF Synch.Files5 THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Date >= Synch.File.Create.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Date >= Synch.File.Access.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Date >= Synch.File.Modify.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /a6
IF Synch.Files6 THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Date <= Synch.File.Create.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Date <= Synch.File.Access.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Date <= Synch.File.Modify.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /a7
IF Synch.Files7 THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Date <> Synch.File.Create.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Date <> Synch.File.Access.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Date <> Synch.File.Modify.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /a8
IF Synch.Files8 THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Date = Synch.File.Create.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Date = Synch.File.Access.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Date = Synch.File.Modify.Date THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /a9
IF Synch.Files9 THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Time >= Synch.File.Create.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Time >= Synch.File.Access.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Time >= Synch.File.Modify.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /aa
IF Synch.FilesA THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Time <= Synch.File.Create.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Time <= Synch.File.Access.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Time <= Synch.File.Modify.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /ab
IF Synch.FilesB THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Time <> Synch.File.Create.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Time <> Synch.File.Access.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Time <> Synch.File.Modify.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF

' check /ac
IF Synch.FilesC THEN
    IF Synch.Type1 THEN ' creation date/time.
        IF Synch.Work.Create.Time = Synch.File.Create.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type2 THEN ' last access date/time.
        IF Synch.Work.Access.Time = Synch.File.Access.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
    IF Synch.Type3 THEN ' last modified date/time.
        IF Synch.Work.Modify.Time = Synch.File.Modify.Time THEN
            Synched.Flag = True
            EXIT SUB
        END IF
    END IF
END IF
END SUB

' routine checks filename
SUB CheckFile (Var$, Check)
' store test flag
Check.Flag = True

' store input filename
Var2$ = UCASE$(Var$)
Var2$ = RTRIM$(Var2$)

' check skip files
IF Ignore.Skip = 0 THEN
    FOR Skip.File = 1 TO 10
        Var1$ = Skip.Filenames(Skip.File)
        Var1$ = UCASE$(Var1$)
        Var1$ = RTRIM$(Var1$)
        IF LEN(Var1$) THEN
            IF Var1$ = Var2$ THEN
                Check.Flag = False
                EXIT SUB
            END IF
        END IF
    NEXT
END IF

' check excluded files
FOR File.Number = 1 TO Number.Excluded
    Var1$ = Excluded.Files(File.Number)
    Var1$ = UCASE$(Var1$)
    Var1$ = RTRIM$(Var1$)
    IF LEN(Var1$) THEN
        CALL CheckExcluded(Var1$, Var2$)
        IF Exclude.Flag THEN
            Check.Flag = False
            EXIT SUB
        END IF
    END IF
NEXT

' check pattern files
IF Check THEN
    IF Pattern.Match THEN
        EXIT SUB
    END IF
END IF
CALL CheckPattern(Var2$)
IF Pattern.Flag = False THEN
    Check.Flag = False
END IF
END SUB

' routine compares occurrence of filename1$ in filename2$
'  with pattern matching.
SUB CheckExcluded (Filename1$, Filename2$)
Exclude.Flag = True ' assume mask matches filename2.
Length1 = 1
Length2 = 1
DO
    ' global replacement.
    IF MID$(Filename1$, Length1, 1) = "*" THEN
        DO
            Length1 = Length1 + 1
            IF Length1 > LEN(Filename1$) THEN
                EXIT SUB
            END IF
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            IF MID$(Filename1$, Length1, 1) = "^" THEN
                Length1 = Length1 + 1
                Not.Include$ = MID$(Filename1$, Length1, 1)
                DO
                    IF Not.Include$ <> MID$(Filename2$, Length2, 1) THEN
                        Length2 = Length2 + 1
                    ELSE
                        Exclude.Flag = False
                        EXIT SUB
                    END IF
                    IF Length2 > LEN(Filename2$) THEN
                        EXIT SUB
                    END IF
                LOOP
            END IF
            ' global replacement followed by ? or another *
            ' skips to next character.
            IF MID$(Filename1$, Length1, 1) <> "*" THEN
                IF MID$(Filename1$, Length1, 1) <> "?" THEN
                    EXIT DO
                END IF
            END IF
        LOOP
        ' global replacement.
        ' searches for next matching character.
        DO
            IF MID$(Filename1$, Length1, 1) = MID$(Filename2$, Length2, 1) THEN
                EXIT DO
            ELSE
                Length2 = Length2 + 1
            END IF
            IF Length2 > LEN(Filename2$) THEN
                EXIT DO
            END IF
        LOOP
    ELSE
        ' character replacement.
        ' matches any next character.
        IF MID$(Filename1$, Length1, 1) = "?" THEN
            Length1 = Length1 + 1
            Length2 = Length2 + 1
        ELSE
            ' exclusion character.
            ' checks next character unmatched.
            IF MID$(Filename1$, Length1, 1) = "^" THEN
                Length1 = Length1 + 1
                Not.Include$ = MID$(Filename1$, Length1, 1)
                IF Not.Include$ <> MID$(Filename2$, Length2, 1) THEN
                    Length1 = Length1 + 1
                    Length2 = Length2 + 1
                ELSE
                    Exlcude.Flag = False
                    EXIT DO
                END IF
            ELSE
                ' matches next character.
                IF MID$(Filename1$, Length1, 1) = MID$(Filename2$, Length2, 1) THEN
                    Length1 = Length1 + 1
                    Length2 = Length2 + 1
                ELSE
                    Exclude.Flag = False
                    EXIT DO
                END IF
                ' check string lengths.
                IF Length1 > LEN(Filename1$) THEN
                    IF Length2 <= LEN(Filename2$) THEN
                        Exlcude.Flag = False
                    END IF
                    EXIT DO
                END IF
            END IF
        END IF
    END IF
LOOP
END SUB

' routine checks filename date pattern
SUB CheckPattern (Filename2$)
' reset to match.
Pattern.Flag = True
' exit for no matching.
IF Pattern.Search = False THEN
    EXIT SUB
END IF
' compare exact filename lengths.
IF LEN(Filename2$) <> LEN(Pattern.Filename) THEN
    Pattern.Flag = False
    EXIT SUB
END IF
' scan pattern.
FOR Var = 1 TO LEN(Pattern.Filename)
    Var$ = MID$(Pattern.Filename, Var, 1)
    SELECT CASE Var$
        CASE "?" ' nul
            Var0$ = Nul
        CASE "M", "D", "Y" ' skip
            Var0$ = Nul
        CASE ELSE
            ' match exact filename character.
            IF MID$(Filename2$, Var, 1) <> Var$ THEN
                Pattern.Flag = False
                EXIT SUB
            END IF
    END SELECT
NEXT
' scan year pattern type 1.
Year1 = False
FOR Var = 1 TO LEN(Pattern.Filename)
    IF MID$(Pattern.Filename, Var, 4) = "YYYY" THEN
        Year1 = VAL(MID$(Filename2$, Var, 4))
        EXIT FOR
    END IF
NEXT
' scan year pattern type 2.
IF Year1 = False THEN
    FOR Var = 1 TO LEN(Pattern.Filename)
        IF MID$(Pattern.Filename, Var, 2) = "YY" THEN
            Year1 = VAL(MID$(Filename2$, Var, 2))
            EXIT FOR
        END IF
    NEXT
END IF
' scan month pattern.
Month1 = False
FOR Var = 1 TO LEN(Pattern.Filename)
    IF MID$(Pattern.Filename, Var, 2) = "MM" THEN
        Month1 = VAL(MID$(Filename2$, Var, 2))
        EXIT FOR
    END IF
NEXT
' scan day pattern.
Day1 = False
FOR Var = 1 TO LEN(Pattern.Filename)
    IF MID$(Pattern.Filename, Var, 2) = "DD" THEN
        Day1 = VAL(MID$(Filename2$, Var, 2))
        EXIT FOR
    END IF
NEXT

' store date patterns.
Day.From = VAL(MID$(Pattern.Search.From.Date, 4, 2))
Month.From = VAL(LEFT$(Pattern.Search.From.Date, 2))
Year.From = VAL(RIGHT$(Pattern.Search.From.Date, 4))
Day.To = VAL(MID$(Pattern.Search.To.Date, 4, 2))
Month.To = VAL(LEFT$(Pattern.Search.To.Date, 2))
Year.To = VAL(RIGHT$(Pattern.Search.To.Date, 4))

' match date patterns. checks all possible patterned combinations.
IF Day1 > False AND Month1 > False AND Year1 > False THEN ' DD-MM-YYYY
    ' for a complete date, serial function can be used.
    From.Serial# = DateSerial(Year.From, Month.From, Day.From)
    To.Serial# = DateSerial(Year.To, Month.To, Day.To)
    Now.Serial# = DateSerial(Year1, Month1, Day1)
    IF From.Serial# <= To.Serial# THEN
        IF Now.Serial# >= From.Serial# AND Now.Serial# <= To.Serial# THEN
            Pattern.Flag = True
        ELSE
            Pattern.Flag = False
        END IF
    ELSE
        Pattern.Flag = False
    END IF
ELSE
    ' for all remaining combinations, specific ranges must be checked.
    IF Day1 > False AND Month1 > False AND Year1 = False THEN ' DD-MM
        IF Month.From = Month.To THEN
            IF Month1 = Month.From THEN
                IF Day.From <= Day.To THEN
                    IF Day1 >= Day.From AND Day1 <= Day.To THEN
                        Pattern.Flag = True
                    ELSE
                        Pattern.Flag = False
                    END IF
                ELSE
                    Pattern.Flag = False
                END IF
            ELSE
                Pattern.Flag = False
            END IF
        ELSE
            IF Month.From < Month.To THEN
                IF Month1 >= Month.From AND Month1 <= Month.To THEN
                    IF Day.From > Day.To THEN
                        IF Day1 >= Day.From OR Day1 <= Day.To THEN
                            Pattern.Flag = True
                        ELSE
                            Pattern.Flag = False
                        END IF
                    ELSE
                        IF Day1 >= Day.From AND Day1 <= Day.To THEN
                            Pattern.Flag = True
                        ELSE
                            Pattern.Flag = False
                        END IF
                    END IF
                ELSE
                    Pattern.Flag = False
                END IF
            ELSE
                Pattern.Flag = False
            END IF
        END IF
    ELSE
        IF Day1 > False AND Month1 = False AND Year1 > False THEN ' DD-YYYY
            IF Year.From = Year.To THEN
                IF Year1 = Year.From THEN
                    IF Day.From <= Day.To THEN
                        IF Day1 >= Day.From AND Day1 <= Day.To THEN
                            Pattern.Flag = True
                        ELSE
                            Pattern.Flag = False
                        END IF
                    ELSE
                        Pattern.Flag = False
                    END IF
                ELSE
                    Pattern.Flag = False
                END IF
            ELSE
                IF Year.From < Year.To THEN
                    IF Year1 >= Year.From AND Year1 <= Year.To THEN
                        IF Day.From > Day.To THEN
                            IF Day1 >= Day.From OR Day1 <= Day.To THEN
                                Pattern.Flag = True
                            ELSE
                                Pattern.Flag = False
                            END IF
                        ELSE
                            IF Day1 >= Day.From AND Day1 <= Day.To THEN
                                Pattern.Flag = True
                            ELSE
                                Pattern.Flag = False
                            END IF
                        END IF
                    ELSE
                        Pattern.Flag = False
                    END IF
                ELSE
                    Pattern.Flag = False
                END IF
            END IF
        ELSE
            IF Day1 > False AND Month1 = False AND Year1 = False THEN ' DD
                IF Day1 >= Day.From AND Day1 <= Day.To THEN
                    Pattern.Flag = True
                ELSE
                    Pattern.Flag = False
                END IF
            ELSE
                IF Day1 = False AND Month1 > False AND Year1 > False THEN ' MM-YYYY
                    IF Year.From = Year.To THEN
                        IF Year1 = Year.From THEN
                            IF Month.From <= Month.To THEN
                                IF Month1 >= Month.From AND Month1 <= Month.To THEN
                                    Pattern.Flag = True
                                ELSE
                                    Pattern.Flag = False
                                END IF
                            ELSE
                                Pattern.Flag = False
                            END IF
                        ELSE
                            Pattern.Flag = False
                        END IF
                    ELSE
                        IF Year.From < Year.To THEN
                            IF Year1 >= Year.From AND Year1 <= Year.To THEN
                                IF Month.From > Month.To THEN
                                    IF Month1 >= Month.From OR Month1 <= Month.To THEN
                                        Pattern.Flag = True
                                    ELSE
                                        Pattern.Flag = False
                                    END IF
                                ELSE
                                    IF Month1 >= Month.From AND Month1 <= Month.To THEN
                                        Pattern.Flag = True
                                    ELSE
                                        Pattern.Flag = False
                                    END IF
                                END IF
                            ELSE
                                Pattern.Flag = False
                            END IF
                        ELSE
                            Pattern.Flag = False
                        END IF
                    END IF
                ELSE
                    IF Day1 = False AND Month1 > False AND Year1 = False THEN ' MM
                        IF Month1 >= Month.From AND Month1 <= Month.To THEN
                            Pattern.Flag = True
                        ELSE
                            Pattern.Flag = False
                        END IF
                    ELSE
                        IF Day1 = False AND Month1 = False AND Year1 > False THEN ' YYYY
                            IF Year1 >= Year.From AND Year1 <= Year.To THEN
                                Pattern.Flag = True
                            ELSE
                                Pattern.Flag = False
                            END IF
                        ELSE
                            IF Day1 = False AND Month1 = False AND Year1 = False THEN ' nul
                                ' no date in pattern, so filename matches.
                                EXIT SUB
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF
END SUB

' format and display time elapsed copying file
SUB Time.Display1
Var1! = Time.Elapsed
Hours = INT(Var1! / 3600!)
Var1! = Var1! - Hours * 3600!
Minutes = INT(Var1! / 60!)
Var1! = Var1! - Minutes * 60!
Seconds = INT(Var1!)
PRINT "Transfer time: ";
IF Hours > 23 THEN
    Days = INT(Hours / 24)
    PRINT RIGHT$("00" + MID$(STR$(Days), 2), 2); ":";
END IF
PRINT RIGHT$("00" + MID$(STR$(Hours), 2), 2); ":";
PRINT RIGHT$("00" + MID$(STR$(Minutes), 2), 2); ":";
PRINT RIGHT$("00" + MID$(STR$(Seconds), 2), 2);
Var1$ = STR$(Var1!)
Var = INSTR(Var1$, ".")
IF Var THEN
    PRINT MID$(Var1$, Var, 3)
ELSE
    PRINT ".00"
END IF
END SUB

' format and display time rate copying file
SUB Time.Display2
REM 1 B (Byte) = 00x - 0FFx (hexidecimal zero-based)
REM KB (Kilobyte) = 1024 B
REM MB (Megabyte) = 1024 KB (1 MB B)
REM GB (Gigabyte) = 1024 MB
REM TB (Terabyte) = 1024 GB (1 MB MB)
REM PB (Petabyte) = 1024 TB
REM EB (Exabyte) = 1024 PB (1 MB TB)

' division by zero
IF Time.Elapsed = 0! THEN
    Var# = 0#
    S$ = "B"
    GOTO EndCalc
END IF

' rate of bytes copied/sec.
Total.Bytes2 = Total.Bytes2 / Time.Elapsed

' zero bytes copied
IF Total.Bytes2 = 0# THEN
    Var# = 0#
    S$ = "B"
    GOTO EndCalc
END IF

' calculate suffix
TempA = False
Var# = Total.Bytes2
DO
    IF Var# < 1024# THEN
        EXIT DO
    END IF
    Var# = Var# / 1024#
    TempA = TempA + 1
    IF TempA = 6 THEN
        EXIT DO
    END IF
LOOP

' determine suffix
S$ = ""
IF TempA > 0 THEN
    S$ = MID$("KMGTPE", TempA, 1)
END IF
S$ = S$ + "B"
EndCalc:
' display rate
PRINT "Transfer rate: " + FormatString$(Var#) + " " + S$ + "/second."
END SUB

