REM file: Deldir.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "DELDIR"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' initialize drive variables
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED Current.Drive AS STRING * 1

' declare work variables
DIM SHARED Continuous.Display AS INTEGER
DIM SHARED Display.Errors AS INTEGER
DIM SHARED Prompt.Delete AS INTEGER
DIM SHARED Quit.Searching AS INTEGER
DIM SHARED Dirs.Counted AS DOUBLE

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER
DIM SHARED Display.Drive AS INTEGER
DIM SHARED Display.Path AS INTEGER

' declare library constants.
CONST MAX_PATH = 260

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
    FUNCTION RemoveDirectoryA% (F$)
    FUNCTION CreateDirectoryA% (F$, X$)
    FUNCTION CloseHandle& (BYVAL hfile AS _OFFSET)
    FUNCTION GetLastError& ()
    FUNCTION FormatMessageA& (BYVAL f AS LONG, f$, BYVAL e AS LONG, BYVAL d AS LONG, g$, s AS LONG, h$)
END DECLARE

DECLARE LIBRARY
    FUNCTION CreateFile& (filename$, BYVAL access&, BYVAL sharing&, BYVAL sec_attr%&, BYVAL create&, BYVAL flags&, BYVAL template%&)
    FUNCTION GetDriveType& (d$)
END DECLARE

' declare library variables.
DIM SHARED ASCIIZ AS STRING * 260
DIM SHARED DriveType AS STRING

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' get current drive
Current.Drive = LEFT$(_CWD$, 1)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' store command line
Command.Line = RTRIM$(COMMAND$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset counters
Dirs.Counted = False

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT _CWD$
    PRINT "Dir path: ";
    LINE INPUT Command.Line
    IF Command.Line = NUL THEN
        GOTO end.deldir
    END IF
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' get switches from command line
Continuous.Display = ParseLine("/C")
Display.Drive = ParseLine("/D")
Prompt.Delete = ParseLine("/P")
Display.Path = ParseLine("/V")
Display.Errors = ParseLine("/Z")

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GOSUB Header

' filename processing loop
DO

    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF
    Command.Line = LTRIM$(Command.Line)
    Command.Line = RTRIM$(Command.Line)

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = UCASE$(LEFT$(Command.Work, 1))
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Search = Current.Drive
    END IF

    ' check drive
    Flag = -1
    IF LEFT$(_CWD$, 2) = "\\" THEN
        Flag = -1
    ELSE
        V = ASC(UCASE$(LEFT$(Drive.Search, 1))) - 64
        IF MEDIAEXISTS(V) = 0 THEN
            ' display any errors
            CALL DisplayError("Error accessing drive " + CHR$(V + 64) + ":")
            Flag = 0
        END IF
    END IF
    IF Flag THEN

        ' check directory exists
        ASCIIZ = Command.Work + CHR$(0)
        hfind = CreateFile(ASCIIZ, &H180, &H3, 0, 3, FILE_FLAG_BACKUP_SEMANTICS, 0)
        IF hfind <> INVALID_HANDLE_VALUE THEN
            x = CloseHandle(hfind)

            ' reset delete flag
            Delete.File = True

            ' check delete flag
            IF Prompt.Delete = 0 THEN
                Prompt$ = "Delete directory " + Filename$(0) + "(y/n/q/c)?"
                CALL MorePrompt(Prompt$, "ynqc", Outpt$)
                SELECT CASE Outpt$
                    CASE "c"
                        Prompt.Delete = True
                    CASE "n"
                        Delete.File = False
                    CASE "q"
                        Delete.File = False
                        Quit.Searching = True
                END SELECT
            END IF

            ' check delete flag
            IF Delete.File THEN
                ' make directory name
                Temp.Dir$ = Command.Work + CHR$(0)
                x = RemoveDirectoryA(Temp.Dir$)
                ' check error flag
                IF x = 0 THEN
                    CALL DisplayWinError(x)
                ELSE
                    ' display drive letter
                    IF Display.Drive THEN
                        COLOR Yellow, Black
                        PRINT Drive.Search; ":";
                    END IF

                    ' display pathname
                    IF Display.Path = False THEN
                        COLOR Yellow, Black
                        Outpt$ = Filename$(0)
                        IF MID$(Outpt$, 2, 1) = ":" THEN
                            Outpt$ = MID$(Outpt$, 3)
                        END IF
                        PRINT Outpt$
                    END IF
                    IF Display.Drive AND Display.Path THEN
                        PRINT
                    END IF
                    ' count directories deleted
                    Dirs.Counted = Dirs.Counted + 1
                END IF
            ELSE
                CALL DisplayWinError(x)
            END IF
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP
end.deldir:

' display counters
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    Total$ = FormatString$(Dirs.Counted)
    PRINT "Directories counted: "; Total$
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            New.Drive = 0
            Volumes.Counted = 0
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Deldir v1.0a: Directory delete utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Deldir [d:][path] [/cdpvz]"
PRINT "Where:"
PRINT "   /c  continuous display"
PRINT "   /d  display drive letter"
PRINT "   /p  don't prompt defore delete"
PRINT "   /v  don't display pathname"
PRINT "   /z  suppress error messages"
COLOR Plain, Black
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Makdir /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Deldir v1.0a: Directory delete utility; "
END IF
RETURN

' critical error trap
Error.Routine:
DataError = ERR
IF Error.Flag THEN
    RESUME NEXT
END IF
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME end.deldir
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' displays windows error
SUB DisplayWinError (x)
' define error message space
DIM m AS STRING * 32767
' check display errors flag
IF Display.Errors = False THEN
    ' call windows error message routine
    x& = FormatMessageA&(&H1200, "", GetLastError, 0, m$, 260, "")
    IF x& THEN
        ' display error
        v = CINT(x&) - 2
        IF v > 0 THEN
            COLOR Red, Black
            PRINT LEFT$(m$, v)
        END IF
    END IF
END IF
END SUB

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

' gets default directory
FUNCTION Filename$ (Var)

' fully qualified netpath
IF LEFT$(Command.Work, 2) = "\\" THEN
    Filename$ = Command.Work
    EXIT FUNCTION
END IF

' fully qualified root path
IF LEFT$(Command.Work, 1) = "\" THEN
    Var$ = Drive.Search + ":"
    Filename$ = Var$ + Command.Work
    EXIT FUNCTION
END IF

' get current directory
Drive$ = Drive.Search + ":"
IF LEFT$(_CWD$, 2) = "\\" THEN
    Directory.Search$ = _CWD$
ELSE ' path\filename
    IF Drive.Search = Current.Drive THEN
        Directory.Search$ = _CWD$
    ELSE
        Original$ = _CWD$
        CHDIR Drive$
        Directory.Search$ = _CWD$
        CHDIR Original$
    END IF
END IF

' store default directory
Filename.Search$ = Command.Work
IF RIGHT$(Directory.Search$, 1) = "\" THEN
    Directory.Search$ = Directory.Search$ + Filename.Search$
ELSE
    Directory.Search$ = Directory.Search$ + "\" + Filename.Search$
END IF
Filename$ = Directory.Search$
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

