REM file: Dirattr.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "DIRATTR"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare work variables
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED Files.Counter AS INTEGER, Quit.Searching AS INTEGER
DIM SHARED List.Archive AS INTEGER, List.Hidden AS INTEGER
DIM SHARED List.Readonly AS INTEGER, List.System AS INTEGER
DIM SHARED List.Directory AS INTEGER, List.Lowercase AS INTEGER
DIM SHARED List.Drive AS INTEGER, List.Filename AS INTEGER
DIM SHARED List.Compressed AS INTEGER, List.Encrypted AS INTEGER

DIM SHARED No.List.Archive AS INTEGER, No.List.Hidden AS INTEGER
DIM SHARED No.List.Readonly AS INTEGER, No.List.System AS INTEGER
DIM SHARED No.List.Directory AS INTEGER, No.List.Compressed AS INTEGER
DIM SHARED No.List.Encrypted AS INTEGER

' declare nest recursion variables
DIM SHARED Nested.Recurse AS INTEGER, Nested.Levels AS INTEGER

' declare search work variables
DIM SHARED Continuous.Display AS INTEGER, Display.Descrip AS INTEGER
DIM SHARED Recurse.Directories AS INTEGER
DIM SHARED Display.Filenames AS INTEGER, Lines.Counted AS INTEGER
DIM SHARED More.Display AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Display.Errors2 AS INTEGER, Display.Errors3 AS INTEGER
DIM SHARED Only.Error AS INTEGER, Debug.Mode AS INTEGER
DIM SHARED Debug.Mode2 AS INTEGER, Display.Errors4 AS INTEGER
DIM SHARED Short.Attr AS INTEGER, Short.File AS INTEGER

' initialize drive work variables
DIM SHARED Drive.Number AS INTEGER, Dirs.Counted AS DOUBLE
DIM SHARED Search.Drive AS INTEGER, Files.Counted AS DOUBLE
DIM SHARED Volumes.Counted AS INTEGER, Current.Directory AS STRING
DIM SHARED Errors.Counted AS DOUBLE, DriveType AS STRING

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' command line input loop
Command.Line = COMMAND$
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset count variables
Dirs.Counted = 0#
Files.Counted = 0#
Errors.Counted = 0#
Display.Lines = False
Continuous.Display = False
Quit.Searching = False

' get current drive
Current.Drive$ = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Dir spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' get command line switches
No.List.Archive = ParseLine("//A")
No.List.Hidden = ParseLine("//H")
No.List.Directory = ParseLine("//I")
No.List.Readonly = ParseLine("//O")
No.List.System = ParseLine("//S")
No.List.Compressed = ParseLine("//J")
No.List.Encrypted = ParseLine("//K")

List.Archive = ParseLine("/A")
List.Hidden = ParseLine("/H")
List.Directory = ParseLine("/I")
List.Readonly = ParseLine("/O")
List.System = ParseLine("/S")
List.Compressed = ParseLine("/J")
List.Encrypted = ParseLine("/K")

List.Filename = ParseLine("/E")
Continuous.Display = ParseLine("/C")
List.Lowercase = ParseLine("/U")
Recurse.Directories = ParseLine("/R")
Display.Filenames = ParseLine("/X")
Display.Descrip = ParseLine("/Y")
Display.Errors2 = ParseLine("/Z1")
Display.Errors3 = ParseLine("/Z2")
Display.Errors4 = ParseLine("/Z3")
Display.Errors = ParseLine("/Z")
Debug.Mode2 = ParseLine("/=2")
Debug.Mode = ParseLine("/=")
More.Display = Continuous.Display
Short.File = ParseLine("/W2")
Short.Attr = ParseLine("/W")

' get nested switch from command line
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = CINT(Var#)
END IF

' get error switch from command line
Imbedded = INSTR(UCASE$(Command.Line), "/Q")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Only.Error = CINT(Var#)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF

' check trailing command line
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
IF Display.Header = False THEN
    IF Continuous.Display = False THEN
        COLOR White, Black
        GOSUB Header
    END IF
END IF

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Search = Current.Drive$
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store current directory
    Directory.Search$ = ""
    Imbedded1 = INSTR(Command.Work, "\")
    Imbedded2 = Imbedded1
    WHILE Imbedded1
        Imbedded2 = Imbedded1
        Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
    WEND
    IF Imbedded2 THEN
        Directory.Search$ = LEFT$(Command.Work, Imbedded2)
        Command.Work = MID$(Command.Work, Imbedded2 + 1)
    END IF
    IF Directory.Search$ = "" THEN
        IF LEFT$(Current.Directory, 2) = "\\" THEN
            Directory.Search$ = Current.Directory
        ELSE
            IF Drive.Search = Current.Drive$ THEN
                Directory.Search$ = MID$(Current.Directory, 3)
            ELSE
                Directory.Search$ = "\"
            END IF
        END IF
    END IF
    IF RIGHT$(Directory.Search$, 1) <> "\" THEN
        Directory.Search$ = Directory.Search$ + "\"
    END IF
   
    ' get filename spec
    Filename.Search$ = Command.Work
    IF Filename.Search$ = NUL THEN
        Filename.Search$ = "*.*"
    END IF
    Command.Work = NUL
   
    ' display search filename
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        IF LEFT$(Directory.Search$, 2) = "\\" THEN
            PRINT "Searching: " + Directory.Search$ + Filename.Search$
        ELSE
            PRINT "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
        END IF
        Lines.Counted = Lines.Counted + 1
    END IF

    ' call routine to search for files
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$, Filename.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Drive.Search, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$, Filename.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

End.Dirattr:

' display counters
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    Total$ = FormatString$(Dirs.Counted)
    PRINT "Directories counted " + Total$
    Total$ = FormatString$(Files.Counted)
    PRINT "Files counted " + Total$
    'Total$ = FormatString$(Errors.Counted)
    'PRINT "Errors counted " + Total$
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

Boot.Usage:
' make header
COLOR White, Black
PRINT "Dirattr v1.0a: File/directory attribute display utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Dirattr [[d:\path\]filename.ext][//ahios][/cdenqruwxyz]"
PRINT "Where:"
PRINT "   Don't list files with bits:"
PRINT "     //a  archive  //h  hidden  //i  directory  //o  read-only"
PRINT "     //s  system   //j  compressed   //k  encrypted"
PRINT "   Only list files with bits:"
PRINT "     /a  archive   /h  hidden   /i  directory   /o  read-only"
PRINT "     /s  system    /j  compressed    /k  encrypted"
PRINT "   Remaining switches:"
PRINT "     /c  continuous display     /u  display files in lowercase"
PRINT "     /d  prepend drive letter   /x  don't display filename"
PRINT "     /e  don't display drive    /y  don't display attributes"
PRINT "     /r  recurse directories    /z  don't display errors"
PRINT "     /w  short attribute display  /w2  strip pathname"
PRINT "     /n###  override nested directories"
COLOR Plain, Black
RETURN

Prompt$ = "-more-"
CALL MorePrompt(Prompt$, CHR$(13) + " ", Outpt$)
COLOR Yellow, Black
PRINT "   Debug switches:"
PRINT "     /z1  also display files with attribute errors"
PRINT "     /z2  only display files with attribute errors"
PRINT "     /z3  for errors list files greater than 260 ASCIIZ length"
PRINT "     /q###  only list error files with type in AX"
PRINT "     /=  debug mode trap switch   /=2  ignore more.prompt for debug"
COLOR Plain, Black
RETURN

Get.Numeric:
Var# = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var# = Var# * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Dirattr /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Dirattr v1.0a: File/directory attribute display utility;"
END IF
RETURN

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Dirattr
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make directory filename
ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' search directory names
    CALL Filenames(Directory.Search$, Filename.Search$)

    ' check to recurse directories
    IF Recurse.Directories THEN

        ' recurse directories
        DO
            ' check to quit
            IF Quit.Searching THEN
                EXIT DO
            END IF

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            IF (Attribute AND &H10) = &H10 THEN

                ' store directory name
                Directory$ = finddata.cFileName
                Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

                ' check directory name
                IF Directory$ <> "." AND Directory$ <> ".." THEN

                    ' check unicode
                    IF INSTR(Directory$, "?") THEN
                        Directory$ = finddata.cAlternateFileName
                        V = INSTR(Directory$, CHR$(0))
                        IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                    END IF

                    ' make next search directory
                    Next.Directory$ = Directory.Search$ + Directory$ + "\"

                    ' check recursion levels
                    Recursion% = True
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels + 1
                        IF Nested.Levels >= Nested.Recurse THEN
                            Recursion% = False
                        END IF
                    END IF

                    ' recursively search subdirectories
                    IF Recursion% THEN
                        CALL Directories(Next.Directory$, Filename.Search$)
                    END IF
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels - 1
                    END IF
                END IF
            END IF

        LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
        x = FindClose(Wfile.Handle)
    END IF
END IF
END SUB

' subroutine to access filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET

' make filename
ASCIIZ = Directory.Search$ + Filename.Search$ + CHR$(0)

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' search filenames
    DO
        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN

            ' store file data
            finddatatemp = finddata

            ' display filename
            CALL DisplayFiles(Directory.Search$, Filename$)
        END IF

        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to display a filename description
SUB DisplayFiles (Search.Directory$, Display.Filename$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG

' make filename
Search.Filename$ = Search.Directory$ + Display.Filename$

' check file attribute
Attribute = finddatatemp.dwFileAttributes

' get full pathname
Var$ = Search.Filename$
IF LEFT$(Var$, 2) <> "\\" THEN
    IF List.Filename = 0 THEN
        Var$ = Drive.Search + ":" + Var$
    END IF
END IF

' store list work variable
List.File = True

' check list attribute
IF List.Readonly THEN
    IF (Attribute AND &H1) = &H0 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF List.Hidden THEN
    IF (Attribute AND &H2) = &H0 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF List.System THEN
    IF (Attribute AND &H4) = &H0 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF List.Directory THEN
    IF (Attribute AND &H10) = &H0 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF List.Archive THEN
    IF (Attribute AND &H20) = &H0 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF List.Compressed THEN
    IF (Attribute AND &H800) = &H0 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF List.Encrypted THEN
    IF (Attribute AND &H4000) = &H0 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF No.List.Readonly THEN
    IF (Attribute AND &H1) = &H1 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF No.List.Hidden THEN
    IF (Attribute AND &H2) = &H2 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF No.List.System THEN
    IF (Attribute AND &H4) = &H4 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF No.List.Directory THEN
    IF (Attribute AND &H10) = &H10 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF No.List.Archive THEN
    IF (Attribute AND &H20) = &H20 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF No.List.Compressed THEN
    IF (Attribute AND &H800) = &H800 THEN
        List.File = False
    END IF
END IF

' check list attribute
IF No.List.Encrypted THEN
    IF (Attribute AND &H4000) = &H4000 THEN
        List.File = False
    END IF
END IF

' check list work variable
IF List.File THEN

    ' count files displayed
    IF (Attribute AND &H10) = &H10 THEN
        Dirs.Counted = Dirs.Counted + 1#
    ELSE
        Files.Counted = Files.Counted + 1#
    END IF

    ' calculate lines counted
    IF Display.Filenames THEN
        IF Display.Descrip = False THEN
            Flag = False
            IF (Attribute AND &H1) = &H1 THEN ' read-only
                Flag = True
            END IF
            IF (Attribute AND &H2) = &H2 THEN ' hidden
                Flag = True
            END IF
            IF (Attribute AND &H4) = &H4 THEN ' system
                Flag = True
            END IF
            IF (Attribute AND &H10) = &H10 THEN ' directory
                Flag = True
            END IF
            IF (Attribute AND &H20) = &H20 THEN ' archive
                Flag = True
            END IF
            IF (Attribute AND &H800) = &H800 THEN ' compressed
                Flag = True
            END IF
            IF (Attribute AND &H4000) = &H4000 THEN ' encrypted
                Flag = True
            END IF
            IF Flag THEN
                Lines.Counted = Lines.Counted + 1
            END IF
        END IF
    END IF

    ' display filename
    IF Display.Filenames = False THEN
        IF LEFT$(Search.Directory$, 2) <> "\\" THEN
            IF List.Filename = False THEN
                IF Short.File = 0 THEN
                    Outpt$ = Drive.Search + ":" + Search.Filename$
                ELSE
                    Outpt$ = Search.Filename$
                END IF
            ELSE
                Outpt$ = Search.Filename$
            END IF
            IF Short.File THEN
                FOR V = LEN(Outpt$) TO 1 STEP -1
                    IF MID$(Outpt$, V, 1) = "\" THEN
                        Outpt$ = MID$(Outpt$, V + 1)
                        EXIT FOR
                    END IF
                NEXT
            END IF
        ELSE
            Outpt$ = Search.Filename$
        END IF
        Outpt$ = RTRIM$(Outpt$)

        ' calculate line length
        Outpt.Length = LEN(Outpt$)
        IF Display.Descrip = False THEN
            Outpt.Length = Outpt.Length + 1
            IF (Attribute AND &H1) = &H1 THEN
                IF Short.Attr THEN
                    Outpt.Length = Outpt.Length + 2
                ELSE
                    Outpt.Length = Outpt.Length + LEN("Read-only ")
                END IF
            END IF
            IF (Attribute AND &H2) = &H2 THEN
                IF Short.Attr THEN
                    Outpt.Length = Outpt.Length + 2
                ELSE
                    Outpt.Length = Outpt.Length + LEN("Hidden ")
                END IF
            END IF
            IF (Attribute AND &H4) = &H4 THEN
                IF Short.Attr THEN
                    Outpt.Length = Outpt.Length + 2
                ELSE
                    Outpt.Length = Outpt.Length + LEN("System ")
                END IF
            END IF
            IF (Attribute AND &H10) = &H10 THEN
                IF Short.Attr THEN
                    Outpt.Length = Outpt.Length + 2
                ELSE
                    Outpt.Length = Outpt.Length + LEN("Directory ")
                END IF
            END IF
            IF (Attribute AND &H20) = &H20 THEN
                IF Short.Attr THEN
                    Outpt.Length = Outpt.Length + 2
                ELSE
                    Outpt.Length = Outpt.Length + LEN("Archive ")
                END IF
            END IF
            IF (Attribute AND &H800) = &H800 THEN
                IF Short.Attr THEN
                    Outpt.Length = Outpt.Length + 2
                ELSE
                    Outpt.Length = Outpt.Length + LEN("Compressed ")
                END IF
            END IF
            IF (Attribute AND &H4000) = &H4000 THEN
                IF Short.Attr THEN
                    Outpt.Length = Outpt.Length + 2
                ELSE
                    Outpt.Length = Outpt.Length + LEN("Encrypted ")
                END IF
            END IF
        END IF

        ' preprompt for more
        GOSUB More.Display2

        ' check to quit
        IF Quit.Searching THEN
            EXIT SUB
        END IF

        ' display filename
        COLOR Yellow, Black
        IF List.Lowercase THEN
            PRINT LCASE$(Outpt$);
        ELSE
            PRINT Outpt$;
        END IF

        ' check suppress display
        IF Display.Descrip THEN
            PRINT

            ' prompt for more
            GOSUB More.Display3
            EXIT SUB
        END IF
        PRINT " ";
    END IF

    ' check suppress display
    IF Display.Descrip = False THEN

        ' display attributes
        COLOR White, Black
        Flag = False

        ' check for read-only file
        IF (Attribute AND &H1) = &H1 THEN
            IF Short.Attr THEN
                PRINT "O ";
            ELSE
                PRINT "Read-only ";
            END IF
            Flag = True
        END IF

        ' check for hidden file
        IF (Attribute AND &H2) = &H2 THEN
            IF Short.Attr THEN
                PRINT "H ";
            ELSE
                PRINT "Hidden ";
            END IF
            Flag = True
        END IF

        ' check for system file
        IF (Attribute AND &H4) = &H4 THEN
            IF Short.Attr THEN
                PRINT "S ";
            ELSE
                PRINT "System ";
            END IF
            Flag = True
        END IF

        ' check for directory file
        IF (Attribute AND &H10) = &H10 THEN
            IF Short.Attr THEN
                PRINT "D ";
            ELSE
                PRINT "Directory ";
            END IF
            Flag = True
        END IF

        ' check for archive file
        IF (Attribute AND &H20) = &H20 THEN
            IF Short.Attr THEN
                PRINT "A ";
            ELSE
                PRINT "Archive ";
            END IF
            Flag = True
        END IF

        ' check for compressed file
        IF (Attribute AND &H800) = &H800 THEN
            IF Short.Attr THEN
                PRINT "C ";
            ELSE
                PRINT "Compressed ";
            END IF
            Flag = True
        END IF

        ' check for encrypted file
        IF (Attribute AND &H4000) = &H4000 THEN
            IF Short.Attr THEN
                PRINT "E ";
            ELSE
                PRINT "Encrypted ";
            END IF
            Flag = True
        END IF

        ' check display
        IF Display.Filenames = False THEN
            PRINT
        ELSE
            IF Flag THEN
                PRINT
            END IF
        END IF

        ' prompt for more
        GOSUB More.Display3
    END IF
END IF
EXIT SUB

' check to display more prompt before line list
More.Display2:
' check continuous display
IF More.Display THEN
    RETURN
END IF

' reset lines displayed
Lines.Counted2 = False

' calculate length of display
IF Outpt.Length > 240 THEN
    Lines.Counted = Lines.Counted + 4
    Lines.Counted2 = Lines.Counted2 + 4
ELSE
    IF Outpt.Length > 160 THEN
        Lines.Counted = Lines.Counted + 3
        Lines.Counted2 = Lines.Counted2 + 3
    ELSE
        IF Outpt.Length > 80 THEN
            Lines.Counted = Lines.Counted + 2
            Lines.Counted2 = Lines.Counted2 + 2
        ELSE
            Lines.Counted = Lines.Counted + 1
            Lines.Counted2 = Lines.Counted2 + 1
        END IF
    END IF
END IF

' check lines dislpayed
IF Lines.Counted >= 23 THEN

    ' store lines displayed after prompt
    Lines.Counted = Lines.Counted2

    ' prompt for more
    COLOR Yellow, Black
    Prompt$ = "More(y/n/c)?"
    CALL MorePrompt(Prompt$, "ync", Outpt2$)
    SELECT CASE Outpt2$
        CASE "c"
            More.Display = True
        CASE "n"
            Quit.Searching = True
    END SELECT
END IF
RETURN

' check to display more prompt after line list
More.Display3:
' check continuous display
IF More.Display THEN
    RETURN
END IF

' check lines displayed
IF Lines.Counted >= 23 THEN

    ' reset lines displayed
    Lines.Counted = False

    ' prompt for more
    COLOR Yellow, Black
    Prompt$ = "More(y/n/c)?"
    CALL MorePrompt(Prompt$, "ync", Outpt2$)
    SELECT CASE Outpt2$
        CASE "c"
            More.Display = True
        CASE "n"
            Quit.Searching = True
    END SELECT
END IF
RETURN
END SUB

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

