REM File compare utility. v1.0a PD 04/10/2016 QB64.

' store all default variables as integer
DEFINT A-Z

' dimension arrays at runtime
REM $DYNAMIC

' declare common variables
COMMON SHARED Buffer1 AS STRING * 1
COMMON SHARED Buffer2 AS STRING * 1
COMMON SHARED BufferFileName1 AS STRING
COMMON SHARED BufferFileName2 AS STRING
COMMON SHARED BypassPrompt AS INTEGER
COMMON SHARED File1 AS STRING
COMMON SHARED File2 AS STRING
COMMON SHARED FileLength1 AS DOUBLE
COMMON SHARED FileLength2 AS DOUBLE
COMMON SHARED FileName AS STRING
COMMON SHARED FileName2 AS STRING
COMMON SHARED Position AS DOUBLE
COMMON SHARED Position1 AS DOUBLE
COMMON SHARED Position2 AS DOUBLE
COMMON SHARED TotalBytes AS DOUBLE

' declare constants
CONST True = -1
CONST False = 0
CONST DFalse = 0#
CONST Nul = ""
CONST Quote = "'"

' declare error routine
ON ERROR GOTO Error.Routine

' display banner
COLOR 15, 0
PRINT "File compare v1.0a QB64."

' check command line
X$ = UCASE$(COMMAND$)
IF X$ = "/?" THEN
    GOTO BootUsage
END IF
L = INSTR(X$, "/C")
IF L > 0 THEN
    BypassPrompt = True
    X$ = LEFT$(X$, L - 1) + MID$(X$, L + 2)
END IF
L = INSTR(X$, "/L")
IF L > 0 THEN
    DisplayType = 1
    X$ = LEFT$(X$, L - 1) + MID$(X$, L + 2)
ELSE
    FOR Z = 1 TO 4
        Z$ = "/P" + MID$(STR$(Z), 2)
        L = INSTR(X$, Z$)
        IF L > 0 THEN
            X$ = LEFT$(X$, L - 1) + MID$(X$, L + 3)
            PortNumber = Z
            FileName2 = "LPT" + Z$ + ":"
            OPEN FileName2 FOR APPEND AS #1
            DisplayType = 3
            EXIT FOR
        END IF
    NEXT
END IF
DO
    X$ = LTRIM$(X$)
    X$ = RTRIM$(X$)
    IF LEFT$(X$, 3) = "/O:" THEN
        IF DisplayType > 0 THEN
            GOTO BootError
        END IF
        F = 0
        X$ = MID$(X$, 4)
        IF LEFT$(X$, 1) = Quote THEN
            FOR L = 2 TO LEN(X$)
                IF MID$(X$, L, 1) = Quote THEN
                    DisplayType = 2
                    FileName2 = LEFT$(X$, L - 1)
                    FileName2 = MID$(FileName2, 2)
                    OPEN FileName2 FOR APPEND AS #1
                    X$ = MID$(X$, L + 1)
                    F = -1
                    EXIT FOR
                END IF
            NEXT
        END IF
        IF F = 0 THEN
            GOTO BootError
        END IF
    ELSE
        IF LEFT$(X$, 4) = "/F1:" THEN
            IF LEN(F1$) THEN
                GOTO BootError
            END IF
            F = 0
            X$ = MID$(X$, 5)
            IF LEFT$(X$, 1) = Quote THEN
                FOR L = 2 TO LEN(X$)
                    IF MID$(X$, L, 1) = Quote THEN
                        F1$ = LEFT$(X$, L - 1)
                        F1$ = MID$(F1$, 2)
                        X$ = MID$(X$, L + 1)
                        F = -1
                        EXIT FOR
                    END IF
                NEXT
            END IF
            IF F = 0 THEN
                GOTO BootError
            END IF
        ELSE
            IF LEFT$(X$, 4) = "/F2:" THEN
                IF LEN(F2$) THEN
                    GOTO BootError
                END IF
                F = 0
                X$ = MID$(X$, 5)
                IF LEFT$(X$, 1) = Quote THEN
                    FOR L = 2 TO LEN(X$)
                        IF MID$(X$, L, 1) = Quote THEN
                            F2$ = LEFT$(X$, L - 1)
                            F2$ = MID$(F2$, 2)
                            X$ = MID$(X$, L + 1)
                            F = -1
                            EXIT FOR
                        END IF
                    NEXT
                END IF
                IF F = 0 THEN
                    GOTO BootError
                END IF
            ELSE
                EXIT DO
            END IF
        END IF
    END IF
LOOP
X$ = RTRIM$(X$)
IF LEN(X$) THEN
    GOTO BootError
END IF
IF DisplayType = 0 THEN

    ' read output type
    COLOR 14, 0
    DO
        PRINT "Output type(1=screen,2=file,3=printer,4=quit)? ";
        LOCATE , , 1
        DO
            _LIMIT 100
            InputChar$ = INKEY$
            IF InputChar$ >= "1" AND InputChar$ <= "4" THEN
                EXIT DO
            END IF
        LOOP
        PRINT InputChar$
        DisplayType = INT(VAL(InputChar$))
        SELECT CASE DisplayType
            CASE 1
                EXIT DO
            CASE 2
                PRINT "Enter output filename: ";
                LINE INPUT FileName2
                IF _FILEEXISTS(FileName2) THEN
                    PRINT "File exists. Append anyway(y/n)";
                    DO
                        _LIMIT 100
                        InputChar$ = INKEY$
                        IF LCASE$(InputChar$) = "y" THEN
                            PRINT "y"
                            EXIT DO
                        END IF
                        IF LCASE$(InputChar$) = "n" THEN
                            PRINT "n"
                            GOTO Terminate
                        END IF
                    LOOP
                END IF
                OPEN FileName2 FOR APPEND AS #1
                EXIT DO
            CASE 3
                PRINT "Enter printer port(1-4)? ";
                DO
                    _LIMIT 100
                    InputChar$ = INKEY$
                    IF InputChar$ >= "1" AND InputChar$ <= "4" THEN
                        EXIT DO
                    END IF
                LOOP
                PRINT InputChar$
                PortNumber = INT(VAL(InputChar$))
                FileName2 = "LPT" + MID$(STR$(PortNumber), 2) + ":"
                OPEN FileName2 FOR APPEND AS #1
                EXIT DO
            CASE 4
                GOTO Terminate
        END SELECT
    LOOP
END IF

' read filename#1
DO
    IF LEN(F1$) THEN
        BufferFileName1 = F1$
    ELSE
        COLOR 14, 0
        PRINT "Enter filename#1 to compare: ";
        LINE INPUT BufferFileName1
        IF BufferFileName1 = Nul THEN
            GOTO Terminate
        END IF
    END IF
    FileName = BufferFileName1
    File1 = BufferFileName1
    GOSUB GetFileInfo
    IF Temp# = DFalse THEN
        COLOR 15
        PRINT "File: '"; BufferFileName1; "' is zero-length."
        IF LEN(F1$) THEN
            GOTO Terminate
        END IF
    ELSE
        IF Temp# = -1# THEN
            COLOR 15
            PRINT "File: '"; BufferFileName1; "' does not exist."
            IF LEN(F1$) THEN
                GOTO Terminate
            END IF
        ELSE
            EXIT DO
        END IF
    END IF
LOOP
FileLength1 = Temp#
BufferFileName1 = FileName3$

' read filename#2
DO
    IF LEN(F2$) THEN
        BufferFileName2 = F2$
    ELSE
        COLOR 14, 0
        PRINT "Enter filename#2 to compare: ";
        LINE INPUT BufferFileName2
        IF BufferFileName2 = Nul THEN
            GOTO Terminate
        END IF
    END IF
    FileName = BufferFileName2
    File2 = BufferFileName2
    GOSUB GetFileInfo
    IF Temp# = DFalse THEN
        COLOR 15
        PRINT "File: '"; BufferFileName2; "' is zero-length."
        IF LEN(F2$) THEN
            GOTO Terminate
        END IF
    ELSE
        IF Temp# = -1# THEN
            COLOR 15
            PRINT "File '"; BufferFileName2; "' does not exist."
            IF LEN(F2$) THEN
                GOTO Terminate
            END IF
        ELSE
            EXIT DO
        END IF
    END IF
LOOP
FileLength2 = Temp#
BufferFileName2 = FileName3$

' compare file sizes
IF FileLength1 <> FileLength2 THEN
    PRINT "Files are different size."
    GOTO Terminate
END IF

' open files for input
OPEN File1 FOR BINARY AS #4
OPEN File2 FOR BINARY AS #5

' reset display flags
Display1 = False
QuitFlag = False

' file input loop
DO
    ' read from file1
    Buffer1 = Nul
    Position1 = Position1 + 1
    GET #4, Position1, Buffer1

    ' read from file2
    Buffer2 = Nul
    Position2 = Position2 + 1
    GET #5, Position2, Buffer2

    ' check buffers
    IF Buffer1 <> Buffer2 THEN

        ' check display flag
        IF Display1 = False THEN
            GOSUB Header
        END IF

        ' display prompt
        IF DisplayType = 1 THEN
            IF LineCount = 23 THEN
                IF BypassPrompt = False THEN
                    COLOR 15, 0
                    PRINT "Press any key(q to quit):";
                    LOCATE , , 1
                    InputChar$ = Nul
                    DO
                        _LIMIT 100
                        InputChar$ = INKEY$
                        IF InputChar$ <> Nul THEN
                            IF LCASE$(InputChar$) = "q" THEN
                                PRINT "q";
                                QuitFlag = True
                            END IF
                            EXIT DO
                        END IF
                    LOOP
                    PRINT
                    IF QuitFlag THEN
                        EXIT DO
                    END IF
                END IF
                GOSUB Header
            END IF
        END IF

        ' printer formfeed
        IF DisplayType = 3 THEN
            IF LineCount >= 55 THEN
                PRINT #1, CHR$(12);
                GOSUB Header
            END IF
        END IF

        ' create output string
        Output$ = "0x" + RIGHT$("00000000" + HEX$(Position), 8) + " "
        Output$ = Output$ + "(" + RIGHT$("0000000000" + MID$(STR$(Position + 1), 2), 10) + ") "

        Var1 = ASC(Buffer1)
        Var1$ = "0x" + RIGHT$("000" + HEX$(Var1), 2) + " "
        Var1$ = Var1$ + "(" + RIGHT$("000" + MID$(STR$(Var1), 2), 3) + ")"

        Var2 = ASC(Buffer2)
        Var2$ = "0x" + RIGHT$("000" + HEX$(Var2), 2) + " "
        Var2$ = Var2$ + "(" + RIGHT$("000" + MID$(STR$(Var2), 2), 3) + ")"

        Output$ = Output$ + "   " + Var1$
        Output$ = Output$ + "   " + Var2$

        ' output string
        SELECT CASE DisplayType
            CASE 1 ' display on screen
                COLOR 14, 0
                PRINT Output$
                LineCount = LineCount + 1
            CASE 2 ' print to file
                PRINT #1, Output$
            CASE 3 ' send to printer
                PRINT #1, Output$
                LineCount = LineCount + 1
        END SELECT

        ' increment mismatched byte counter
        TotalBytes = TotalBytes + 1#
    END IF

    ' check escape key
    IF INKEY$ = CHR$(27) THEN
        QuitFlag = True
    END IF

    ' check quit flag
    IF QuitFlag THEN
        EXIT DO
    END IF

    ' increment file position
    Position = Position + 1
    IF Position > FileLength1 THEN
        EXIT DO
    END IF
LOOP

' display final message
COLOR 15, 0
IF Display1 = False THEN
    Output$ = "Files: " + BufferFileName1 + "(" + MID$(STR$(FileLength1), 2) + ")"
    Output$ = Output$ + " - " + BufferFileName2 + "(" + MID$(STR$(FileLength2), 2) + ")"
    Output$ = Output$ + " are equal."
    PRINT Output$
    IF DisplayType = 2 THEN
        PRINT #1, ""
        PRINT #1, "FileComp: " + DATE$ + " " + TIME$
        PRINT #1, Output$
    ELSE
        IF DisplayType = 3 THEN
            PRINT #1, Output$
        END IF
    END IF
ELSE
    Output$ = "Total bytes not matching:" + STR$(TotalBytes)
    PRINT Output$
    IF DisplayType >= 2 THEN
        PRINT #1, Output$
    END IF
END IF
IF DisplayType >= 2 THEN
    PRINT "File info appended to " + FileName2
END IF
IF DisplayType = 3 THEN
    PRINT #1, CHR$(12);
END IF
IF DisplayType = 1 THEN
    IF BypassPrompt = False THEN
        PRINT "Press any key:";
        LOCATE , , 1
        DO
            _LIMIT 100
            IF INKEY$ <> Nul THEN
                EXIT DO
            END IF
        LOOP
        PRINT
    END IF
END IF

' terminate program
Terminate:
COLOR 7, 0
PRINT "Returning to system:"
END

' display header
Header:
COLOR 15, 0
LineCount = 2
IF Display1 = False THEN
    LineCount = 3
    Output2$ = "Files: " + BufferFileName1 + "(" + MID$(STR$(FileLength1), 2) + ")"
    Output2$ = Output2$ + " - " + BufferFileName2 + "(" + MID$(STR$(FileLength2), 2) + ")"
    IF DisplayType = 1 THEN
        PRINT Output2$
    ELSE
        IF DisplayType = 2 THEN
            PRINT #1, ""
            PRINT #1, "FileComp: " + DATE$ + " " + TIME$
            PRINT #1, Output2$
        ELSE
            PRINT #1, Output2$
        END IF
    END IF
END IF
IF Display1 THEN
    IF DisplayType = 1 THEN
        IF BypassPrompt THEN
            RETURN
        END IF
    END IF
END IF
Display1 = True
Strng1$ = BufferFileName1
Strng1$ = Strng1$ + SPACE$(12 - LEN(Strng1$))
Strng2$ = BufferFileName2
Strng2$ = Strng2$ + SPACE$(12 - LEN(Strng2$))
Output2$ = "Position offset (hex/asc)  " + Strng1$ + " " + Strng2$
Output3$ = "-------------------------  ------------ ------------"
IF DisplayType = 1 THEN
    PRINT Output2$
    PRINT Output3$
ELSE
    PRINT #1, Output2$
    PRINT #1, Output3$
END IF
RETURN

' read filesize
GetFileInfo:
' reset filesize
Temp# = DFalse

' check file exists
FileName3$ = RTRIM$(FileName)
IF _FILEEXISTS(FileName3$) = 0 THEN
    Temp# = -1#
    RETURN
END IF

' open filename
CLOSE #3
OPEN FileName3$ FOR BINARY AS #3

' store file size
Temp# = LOF(3)
RETURN

' boot error display
BootError:
COLOR 14, 0
PRINT "Command line error. Type Filecomp /? for help."
COLOR 7, 0
END

' boot usage display
BootUsage:
COLOR 14, 0
PRINT "Usage:"
Outpt$ = "  Filecomp [/C][/L|/Px|/O:" + Quote + "file.ext" + Quote + "]"
Outpt$ = Outpt$ + "[/F1:" + Quote + "file.ext" + Quote + "]"
Outpt$ = Outpt$ + "[/F2:" + Quote + "file.ext" + Quote + "]"
PRINT Outpt$
PRINT "Where:"
PRINT "  /C  bypass prompts"
PRINT "Output:"
PRINT "  /L  display to screen, or"
PRINT "  /Px send to printer port(x=1 to 4), or"
PRINT "  /O:" + Quote + "filename.ext" + Quote + " send to output file."
PRINT "    (must be enclosed in quotes)"
PRINT "Files to compare are:"
PRINT "  /F1:" + Quote + "c:\path\filename.ext" + Quote
PRINT "  /F2:" + Quote + "c:\path\filename.ext" + Quote
PRINT "    (must be enclosed in quotes)"
GOTO Terminate

' critical error trap
Error.Routine:
COLOR 7, 0
ErrorNum = ERR
Temp.Outpt$ = "Critical error:" + STR$(ErrorNum)
PRINT Temp.Outpt$
Temp.Outpt$ = "IDE line:" + STR$(_ERRORLINE)
PRINT Temp.Outpt$
END

