REM file: Listvols.bas - Public Domain QB64 Utility

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "LISTVOLS"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare work variables
DIM SHARED Default.Drive AS INTEGER, Drives AS INTEGER
DIM SHARED Last.Drive AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Continuous.Display AS INTEGER, Drive.Number AS INTEGER
DIM SHARED Display.Current AS INTEGER, Original.Drive AS INTEGER
DIM SHARED Display.Drive.Letter AS INTEGER, Drive.Not.Ready AS INTEGER
DIM SHARED Display.Serial AS INTEGER, Display.Date AS INTEGER
DIM SHARED Display.FatType AS INTEGER, Attribute AS _UNSIGNED LONG
DIM SHARED Display.Attribute AS INTEGER, Windows.Detected AS INTEGER
DIM SHARED ASCIIZ.Root AS STRING * 4, File.Work.Date AS SINGLE
DIM SHARED File.Work.Time AS SINGLE, Display.Not.Ready AS INTEGER
DIM SHARED Display.Volumes AS INTEGER, DriveType AS STRING
DIM SHARED Volumes.Counted AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING, Control.Break AS INTEGER
DIM SHARED Last.Switch AS INTEGER, Skip.Drives AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1
CONST ERROR_FILE_NOT_FOUND = 2
CONST ERROR_NO_MORE_FILES = &H12

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
    FUNCTION GetDiskFreeSpaceExA& (filename$, free AS _UNSIGNED _INTEGER64, total AS _UNSIGNED _INTEGER64, free2 AS _UNSIGNED _INTEGER64)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED finddata AS WIN32_FIND_DATAA
DIM SHARED hfind AS _UNSIGNED _OFFSET
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED Out3 AS STRING

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' dimension work variables
REDIM Skip.Drives(1 TO 26) AS INTEGER

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' command line input loop
Command.Line = COMMAND$
Start.Loop:

' get current drive
Default.Drive = ASC(LEFT$(_CWD$, 1)) - 65
Original.Drive = Default.Drive
Last.Drive = 26

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Drive letter: ";
    DO
        _LIMIT 100
        I$ = INKEY$
        IF LEN(I$) THEN
            I$ = UCASE$(I$)
            IF I$ >= "A" AND I$ <= "Z" THEN
                PRINT I$
                Command.Line = I$ + ":"
                EXIT DO
            END IF
            IF I$ = CHR$(13) THEN
                PRINT
                EXIT DO
            END IF
        END IF
    LOOP

    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)
Command.Line = UCASE$(Command.Line)

' check command line switches
Skip.Drives(1) = ParseLine("/A")
Skip.Drives(2) = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Display.Serial = ParseLine("/E")
Display.FatType = ParseLine("/F")
Display.Volumes = ParseLine("/W")
Display.Current = ParseLine("/X")
Display.Drive.Letter = ParseLine("/Y")
Display.Errors = ParseLine("/Z")

' get skip drives list
FOR Var = 3 TO 26
    Skip.Drives(Var) = ParseLine("/1:" + CHR$(Var + 64))
NEXT

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' check command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
Command.Line = UCASE$(Command.Line)
IF LEN(Command.Line) = 2 THEN
    IF RIGHT$(Command.Line, 1) = ":" THEN
        New.Drive = ASC(LEFT$(Command.Line, 1)) - 64
        IF New.Drive >= 1 AND New.Drive <= 26 THEN
            Command.Line = NUL
        END IF
    END IF
END IF
IF LEN(Command.Line) THEN
    GOTO Boot.Error
END IF

' check new drive
IF New.Drive THEN
    New.Drive = New.Drive - 1
    IF New.Drive >= False AND New.Drive <= Last.Drive THEN
        Default.Drive = New.Drive
        Display.Current = True
    ELSE
        GOSUB Header
        GOTO End.Listvols
    END IF
END IF

' make header
GOSUB Header

' check to display current drive
IF Display.Current THEN
    Drive.Number = Default.Drive + 1
    GOSUB Get.Volume.Label
ELSE
    ' display drives A: to last drive
    FOR Drive.Number = 1 TO Last.Drive
        ' display drive letter volume
        GOSUB Get.Volume.Label
    NEXT
END IF
End.Listvols:

' display counters
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    PRINT "Volumes counted"; Volumes.Counted
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            New.Drive = 0
            Volumes.Counted = 0
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' make header
Header:
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Listvols v1.0a: Volume display utility;"
END IF
RETURN

' display volume information for drive number
Get.Volume.Label:
' check skip drive letter array
IF Skip.Drives(Drive.Number) THEN
    RETURN
END IF

' check drive
IF DRIVEEXISTS(Drive.Number) THEN
    RETURN
END IF

' increment counter
Volumes.Counted = Volumes.Counted + 1

' display drive letter
COLOR Yellow, Black
IF Display.Drive.Letter = False THEN
    PRINT CHR$(Drive.Number + 64); ":";
END IF

' display volume label
Out3 = CHR$(Drive.Number + 64)
CALL Vlabel(Out3)
IF RTRIM$(Out3) = NUL THEN
    z$ = DriveType
ELSE
    z$ = RTRIM$(Out3)
END IF
PRINT z$; " ";

' display volume serial number
IF Display.Serial THEN
    COLOR Red, Black
    Out3 = CHR$(Drive.Number + 64)
    CALL Vserial(Out3)
    PRINT Out3; " ";
END IF

' display volume file system type
IF Display.FatType THEN
    COLOR White, Black
    Out3 = CHR$(Drive.Number + 64)
    CALL Vtype(Out3)
    PRINT Out3;
END IF
PRINT
RETURN

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Listvols v1.0a: Volume display utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Listvols [d:][/abcefwxyz1]"
PRINT "Where:"
PRINT "   d:  list drive D: volume only"
PRINT "   /a  ignore drive A: volume"
PRINT "   /b  ignore drive B: volume"
PRINT "   /c  continuous display"
PRINT "   /e  display volume serial number"
PRINT "   /f  display volume file system type"
PRINT "   /w  don't list invalid volumes"
PRINT "   /x  list only current volume"
PRINT "   /y  don't display drive letter"
PRINT "   /z  suppress errors"
PRINT "   /1:d  skip drive d (d is C to Z)"
COLOR Plain, Black
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Listvols /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; STR$(DataError); " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        RESUME End.Listvols
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' prompt for keypress
SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
DO
    LOCATE , , 1
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

' get volume label
SUB Vlabel (Var$)
' Note: in DOS the volume label was 8.3 format,
'  however, in windows XP+ it is 32 char.

' get drive info.
VarX$ = Var$ + ":\" + CHR$(0)
Var$ = NUL
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    ' get volume label.
    Var$ = RTRIM$(Vname$)
    v = INSTR(Var$, CHR$(0))
    IF v THEN Var$ = LEFT$(Var$, v - 1)
END IF
END SUB

' get volume serial number
SUB Vserial (Var$)

' get drive info.
VarX$ = Var$ + ":\" + CHR$(0)
Var$ = NUL
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    ' serial number.
    Var$ = LEFT$(HEX$(serial~&), 4) + "-" + RIGHT$(HEX$(serial~&), 4)
END IF
END SUB

' get volume system type
SUB Vtype (Var$)

' get drive info.
VarX$ = Var$ + ":\" + CHR$(0)
Var$ = NUL
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    ' get volume system type.
    Var$ = RTRIM$(Fname$)
    v = INSTR(Var$, CHR$(0))
    IF v THEN Var$ = LEFT$(Var$, v - 1)
END IF
END SUB

