REM file: Renvol.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "RENVOL"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' initialize filename buffer
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED DriveType AS STRING

' declare work variables
DIM SHARED Continuous.Display AS INTEGER
DIM SHARED Display.Errors AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER
DIM SHARED Display.Drive AS INTEGER
DIM SHARED Display.Volume AS INTEGER

' declare library constants.
CONST MAX_PATH = 260

' declare external library
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION SetVolumeLabelA% (d$, f$)
    FUNCTION GetLastError& ()
    FUNCTION FormatMessageA& (BYVAL f AS LONG, f$, BYVAL e AS LONG, BYVAL d AS LONG, g$, s AS LONG, h$)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetDriveType& (d$)
END DECLARE

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' get current drive
Current.Drive$ = LEFT$(_CWD$, 1)

' check command line
IF COMMAND$ = "/?" THEN
    GOTO Boot.Usage
END IF

' read command line
Command.Line = COMMAND$
Command.Line = RTRIM$(Command.Line)

' get switches from command line
Continuous.Display = ParseLine("/C")
Display.Drive = ParseLine("/D")
Display.Volume = ParseLine("/X")
Display.Errors = ParseLine("/Z")

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' display header
GOSUB Header

' store entire command
Command.Work = Command.Line

DO
    ' store entire command
    Imbedded = INSTR(Command.Line, " ")
    IF Imbedded THEN
        Command.Work = LEFT$(Command.Line, Imbedded - 1)
        Command.Line = MID$(Command.Line, Imbedded + 1)
    ELSE
        Command.Work = Command.Line
        Command.Line = NUL
    END IF

    ' store current drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
        Command.Work = MID$(Command.Work, 3)
    ELSE
        Drive.Search = Current.Drive$
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' display drive searched
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        PRINT "Searching: "; Drive.Search$; ":"
    END IF

    ' check drive exists
    V = ASC(UCASE$(LEFT$(Drive.Search$, 1))) - 64
    IF MEDIAEXISTS(V) THEN
        ' store new volume label
        Volume.Label$ = Command.Work + CHR$(0)
        Drive$ = Drive.Search$ + ":\" + CHR$(0)

        ' change volume label
        x = SetVolumeLabelA%(Drive$, Volume.Label$)

        ' check volume flag
        IF x = 0 THEN
            Temp$ = "Error 0x" + HEX$(GetLastError) + " naming volume."
            CALL DisplayError(Temp$)
            CALL DisplayWinError(x)
        ELSE
            GOSUB Display.Label
        END IF
    ELSE
        Temp$ = "Error accessing drive " + Drive.Search$ + ":\"
        CALL DisplayError(Temp$)
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF
LOOP

End.Renvol:

' display end program
IF Continuous.Display = False THEN
    Prompt$ = "Press <enter> to exit to DOS:"
    CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF
COLOR Plain, Black
END

' display volume label
Display.Label:
' display drive letter
IF Display.Drive THEN
    COLOR Yellow, Black
    PRINT Drive.Search; ":";
END IF
' display volume label
IF Display.Volume = False THEN
    COLOR Yellow, Black
    PRINT Volume.Label$
END IF
IF Display.Drive AND Display.Volume THEN
    PRINT
END IF
RETURN

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Renvol v1.0a: Volume update utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Renvol [d:][volumename][/cdxz]"
PRINT "Where:"
PRINT "   /c  continuous display"
PRINT "   /d  display drive letter"
PRINT "   /x  don't list volume label"
PRINT "   /z  suppress errors"
COLOR Plain, Black
END

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Renvol /? for help."
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Renvol v1.0a: Volume update utility;"
END IF
RETURN
   
' critical error trap
Error.Routine:
Data.Error = ERR
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Renvol
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' displays error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' displays windows error
SUB DisplayWinError (x)
' define error message space
DIM m AS STRING * 32767
' check display errors flag
IF Display.Errors = False THEN
    ' call windows error message routine
    x& = FormatMessageA&(&H1200, "", GetLastError, 0, m$, 260, "")
    IF x& THEN
        ' display error
        v = CINT(x&) - 2
        IF v > 0 THEN
            COLOR Red, Black
            PRINT LEFT$(m$, v)
        END IF
    END IF
END IF
END SUB

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

