REM file: Whatis - Public Domain QB64 Utility. v1.0a.

REM type: Recursive Descent Expression Parser.

' set startup declarations
DEFINT A-Z
REM $DYNAMIC
_TITLE "WHATIS"

' constant declarations
CONST FalseD = 0#
CONST TrueD = -1#
CONST False = 0
CONST True = -1
CONST Nul = ""

CONST Max.Arrays = 128 ' can be changed
CONST Max.History = 10 ' can be changed
CONST Max.Recurse = 16 ' can be changed
CONST Max.FNs = 26 ' can be changed

' define color values
CONST Black = 0
CONST Plain = 7
CONST White = 15
CONST Yellow = 14

' global variables
DIM SHARED Assign AS INTEGER
DIM SHARED DataError AS INTEGER
DIM SHARED Last.Token AS INTEGER
DIM SHARED Out2 AS STRING
DIM SHARED Out3 AS STRING
DIM SHARED Out4 AS STRING
DIM SHARED Recurse AS INTEGER
DIM SHARED Strng AS STRING
DIM SHARED Token AS INTEGER
DIM SHARED Token.Index AS INTEGER
DIM SHARED Token.List AS STRING
DIM SHARED White.Space AS STRING

' data areas
DIM SHARED Arrays(0 TO 26, 1) AS DOUBLE ' variable arrays A() to Z()
DIM SHARED Definitions(1) AS STRING ' DEF FN functions
DIM SHARED Strngs(1) AS STRING ' string variables A$ to Z$
DIM SHARED Variables(1) AS DOUBLE ' variables A to Z

' multi-dimensional command history arrays
DIM SHARED History.Count2(1) AS INTEGER
DIM SHARED History2(1 TO 3, 1) AS STRING * 256

' multi-dimensional command history variable
DIM SHARED Temp0 AS INTEGER

' subroutine declarations
DECLARE SUB Arith (T$, T1#, T2#)
DECLARE SUB Assignment1 (T$, T%)
DECLARE SUB Assignment2 (T$, T1%, T2%)
DECLARE SUB Enter.Equate ()
DECLARE SUB Equate (T#)
DECLARE SUB Get.Token ()
DECLARE SUB Get.Token2 (V%)
DECLARE SUB Get.Token3 ()
DECLARE SUB Get.Token4 ()
DECLARE SUB Parse.Alphabetic1 (T#)
DECLARE SUB Parse.Alphabetic2 (T#)
DECLARE SUB Parse.Alphabetic3 (T#)
DECLARE SUB Parse.Numeric (T#)
DECLARE SUB Parse.Quoted ()
DECLARE SUB Parse1 (T#)
DECLARE SUB Parse2 (T#)
DECLARE SUB Parse3 (T#)
DECLARE SUB Parse4 (T#)
DECLARE SUB Parse5 (T#)
DECLARE SUB Parse6 (T#)
DECLARE SUB Parse7 (T#)
DECLARE SUB Parse8 (T#)
DECLARE SUB Parse9 (T#)
DECLARE SUB Remove.Spaces ()

' function declarations
DECLARE FUNCTION KeyboardLine$()

' program variables
REDIM Arrays(0 TO 26, 0 TO Max.Arrays) AS DOUBLE
REDIM Definitions(0 TO Max.FNs) AS STRING
REDIM Strngs(0 TO 26) AS STRING
REDIM Variables(0 TO 26) AS DOUBLE

' initialize multi-dimensional command history arrays
REDIM History2(1 TO 3, 1 TO Max.History) AS STRING * 256
REDIM History.Count2(1 TO 3) AS INTEGER

' reset multi-dimensional command history arrays
FOR VarQ1 = 1 TO 3
    History.Count2(VarQ1) = 0
    FOR VarQ2 = 1 TO Max.History
        History2(VarQ1, VarQ2) = Nul
    NEXT
NEXT

' declare global error routine
ON ERROR GOTO Error.Routine

' initialize some variables
Token.List = " -+*/\^()[]{}<>=|&!%~?:#@`;," + CHR$(34) ' cannot be changed
White.Space = CHR$(32) + CHR$(9) ' can be changed

' read command line
Command.Line$ = COMMAND$
Command.Line$ = LTRIM$(Command.Line$)
Command.Line$ = RTRIM$(Command.Line$)
IF LEN(Command.Line$) THEN
    Out2 = Command.Line$
    PRINT Out2; " Equals: ";
    Recurse = 0
    CALL Enter.Equate
    Error.Resume1:
    COLOR Plain, Black
    END
END IF

' reset error flow
DataError = True

' display header
COLOR White, Black
PRINT "Whatis v1.0a: Expression parser;"
PRINT "Enter 'quit' to return to system."

Error.Resume2:

' keyboard input loop
DO
    COLOR Yellow, Black
    LOCATE , 1, 1
    PRINT ">";
    LOCATE , , 1
    ' get input line
    Temp0 = 3
    Out2 = KeyboardLine$
    PRINT
    ' parse input line
    CALL Remove.Spaces
    IF UCASE$(Out2) = "QUIT" THEN
        EXIT DO
    END IF
    ' calculate line
    Recurse = 0
    CALL Enter.Equate
LOOP

' end program
COLOR White, Black
PRINT "Press <enter> to return to DOS:";
DO
    _LIMIT 50
    Input.Char$ = INKEY$
    IF Input.Char$ = CHR$(13) THEN
        EXIT DO
    END IF
LOOP
PRINT

' end program label
End.Whatis:

' stop program
COLOR Plain, Black
END

' main error routine
Error.Routine:
IF DataError = False THEN
    PRINT
END IF
Error.Mode = ERR
SELECT CASE Error.Mode
    ' standard errors.
    CASE 7
        PRINT "Out of memory."
    CASE 9
        PRINT "Subscript out of range."
    CASE 14
        PRINT "Out of string space."
    CASE 53
        PRINT "File not found."
    CASE 57
        PRINT "Media error."
    CASE 61
        PRINT "Disk full."
    CASE 70
        PRINT "Permission denied."
    CASE 71
        PRINT "Disk not ready."
        ' extended errors.
    CASE 5
        PRINT "Error #001: Illegal function call."
    CASE 6
        PRINT "Error #002: Overflow."
    CASE 9
        PRINT "Error #003: Subscript out of range."
    CASE 11
        PRINT "Error #004: Division by zero."
    CASE 92
        PRINT "Error #005: Whatis: "; Strng
    CASE 130
        PRINT "Error #006: Bad numeric specifier."
    CASE 140
        PRINT "Error #007: Bad exponent specifier."
    CASE 145
        PRINT "Error #008: Bad DEFFN declaration."
    CASE ELSE
        PRINT "Critical error: '" + STR$(Error.Mode) + "' in Whatis."
        '    PRINT "Error #000: Error"; Error.Mode
END SELECT
Error.Exit1:
IF DataError = False THEN
    RESUME Error.Resume1
ELSE
    RESUME Error.Resume2
END IF
END

' routine accepts an operation and performs on two values, string or numeric
SUB Arith (Token.Parsed$, Temp#, Temp2#)
IF Last.Token THEN
    SELECT CASE Token.Parsed$
        CASE "-"
            Temp# = Temp# - Temp2#
        CASE "+"
            Temp# = Temp# + Temp2#
        CASE "/"
            Temp# = Temp# / Temp2#
        CASE "\"
            Temp# = Temp# \ Temp2#
        CASE "*"
            Temp# = Temp# * Temp2#
        CASE "^"
            Temp# = Temp# ^ Temp2#
        CASE "<"
            Temp# = (Temp# < Temp2#)
        CASE ">"
            Temp# = (Temp# > Temp2#)
        CASE "<<"
            Temp# = Temp# * 2#
        CASE ">>"
            Temp# = Temp# \ 2#
        CASE "++"
            Temp# = Temp# + 1#
        CASE "--"
            Temp# = Temp# - 1#
        CASE "**"
            Temp# = Temp# ^ 2#
        CASE "//"
            Temp# = SQR(Temp#)
        CASE "="
            Temp# = (Temp# = Temp2#)
        CASE "<="
            Temp# = (Temp# <= Temp2#)
        CASE ">="
            Temp# = (Temp# >= Temp2#)
        CASE "<>"
            Temp# = (Temp# <> Temp2#)
        CASE "|"
            Temp# = Temp# OR Temp2#
        CASE "&"
            Temp# = Temp# AND Temp2#
        CASE "%"
            Temp# = Temp# MOD Temp2#
        CASE "~"
            Temp# = Temp# XOR Temp2#
        CASE "?"
            Temp# = Temp# IMP Temp2#
        CASE ":"
            Temp# = Temp# EQV Temp2#
        CASE "#"
            Temp# = NOT (Temp# OR Temp2#)
        CASE "@"
            Temp# = NOT (Temp# IMP Temp2#)
        CASE "`"
            Temp# = NOT (Temp# AND Temp2#)
    END SELECT
    EXIT SUB
END IF
SELECT CASE Token.Parsed$
    CASE "-"
        IF RIGHT$(Out3, LEN(Out4)) = Out4 THEN
            Out3 = LEFT$(Out3, LEN(Out3) - LEN(Out4))
        END IF
    CASE "+"
        Out3 = Out3 + Out4
    CASE "/", "\"
        IF LEN(Out3) > False AND LEN(Out4) > False THEN
            Imbedded = INSTR(Out3, Out4)
            WHILE Imbedded
                Out3 = LEFT$(Out3, Imbedded - 1) + MID$(Out3, Imbedded + LEN(Out4))
                Imbedded = INSTR(Out3, Out4)
            WEND
        END IF
    CASE "<"
        Last.Token = True
        Temp# = Out3 < Out4
    CASE ">"
        Last.Token = True
        Temp# = Out3 > Out4
    CASE "="
        Last.Token = True
        Temp# = Out3 = Out4
    CASE "<="
        Last.Token = True
        Temp# = Out3 <= Out4
    CASE ">="
        Last.Token = True
        Temp# = Out3 >= Out4
    CASE "<>"
        Last.Token = True
        Temp# = Out3 <> Out4
END SELECT
END SUB

SUB Assignment1 (S$, S%)
IF LEFT$(S$, 2) = "<<" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Variables(S%) = Variables(S%) * 2#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = ">>" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Variables(S%) = Variables(S%) \ 2#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "--" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Variables(S%) = Variables(S%) - 1#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "++" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Variables(S%) = Variables(S%) + 1#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "**" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Variables(S%) = Variables(S%) ^ 2#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "//" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Variables(S%) = SQR(Variables(S%))
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "-=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) - T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "+=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) + T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "/=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) / T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "\=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) \ T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "*=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) * T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "^=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) ^ T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 3) = "^-=" THEN
    Out2 = MID$(S$, 4)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) ^ (-T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "%=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) MOD T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "|=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) OR T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "&=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) AND T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "~=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) XOR T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "?=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) IMP T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = ":=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = Variables(S%) EQV T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "#=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = NOT (Variables(S%) OR T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "@=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = NOT (Variables(S%) IMP T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "`=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = NOT (Variables(S%) AND T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 1) = "=" THEN
    Out2 = MID$(S$, 2)
    Out2 = LTRIM$(Out2)
    CALL Equate(T#)
    IF Last.Token = True THEN
        Assign = True
        Variables(S%) = T#
    END IF
    EXIT SUB
END IF
END SUB

SUB Assignment2 (S$, S1%, S2%)
IF LEFT$(S$, 2) = "<<" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Arrays(S1%, S2%) = Arrays(S1%, S2%) * 2#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = ">>" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Arrays(S1%, S2%) = Arrays(S1%, S2%) \ 2#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "--" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Arrays(S1%, S2%) = Arrays(S1%, S2%) - 1#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "++" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Arrays(S1%, S2%) = Arrays(S1%, S2%) + 1#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "**" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ 2#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "//" THEN
    Assign = True
    Strng = MID$(S$, 3)
    IF Strng = Nul THEN
        Arrays(S1%, S2%) = SQR(Arrays(S1%, S2%))
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "-=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) - T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "+=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) + T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "/=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) / T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "\=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) \ T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "*=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) * T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "^=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 3) = "^-=" THEN
    Out2 = MID$(S$, 4)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) ^ (-T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "%=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) MOD T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "|=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) OR T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "&=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) AND T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "~=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) XOR T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "?=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) IMP T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = ":=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = Arrays(S1%, S2%) EQV T#
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "#=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = NOT (Arrays(S1%, S2%) OR T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "@=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = NOT (Arrays(S1%, S2%) IMP T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 2) = "`=" THEN
    Out2 = MID$(S$, 3)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = NOT (Arrays(S1%, S2%) AND T#)
    END IF
    EXIT SUB
END IF
IF LEFT$(S$, 1) = "=" THEN
    Out2 = MID$(S$, 2)
    Out2 = LTRIM$(Out2)
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(T#)
    IF Last.Token = True THEN
        Assign = True
        Arrays(S1%, S2%) = T#
    END IF
END IF
END SUB

' parses single letter tokens
SUB Parse.Alphabetic1 (Temp#)
SELECT CASE UCASE$(Strng) ' test variable symbol
    CASE "A" TO "Z"
        Element = ASC(UCASE$(Strng)) - 64
        Element.Type$ = MID$(Out2, Token.Index, 1)
        SELECT CASE Element.Type$
            CASE "("
                CALL Get.Token
                CALL Get.Token
                CALL Parse1(Temp#)
                IF Strng = ")" THEN
                    Temp# = Arrays(Element, CINT(Temp#))
                    Last.Token = True
                ELSE
                    Strng = "<missing closing token>"
                    ERROR 92
                END IF
            CASE "["
                CALL Get.Token
                CALL Get.Token
                CALL Parse1(Temp#)
                IF Strng = "]" THEN
                    Temp# = Arrays(Element, CINT(Temp#))
                    Last.Token = True
                ELSE
                    Strng = "<missing closing token>"
                    ERROR 92
                END IF
            CASE "{"
                CALL Get.Token
                CALL Get.Token
                CALL Parse1(Temp#)
                IF Strng = "}" THEN
                    Temp# = Arrays(Element, CINT(Temp#))
                    Last.Token = True
                ELSE
                    Strng = "<missing closing token>"
                    ERROR 92
                END IF
            CASE ELSE
                Temp# = Variables(Element)
                Last.Token = True
        END SELECT
    CASE ELSE
        ERROR 92
END SELECT
END SUB

' parses two-letter tokens
SUB Parse.Alphabetic2 (Temp#)
SELECT CASE UCASE$(Strng)
    ' user defined functions
    CASE "FN"
        CALL ParseFN(Temp#)
    CASE "FZ"
        CALL ParseFZ(Temp#)
        ' functions w/o parameters
    CASE "PI" ' calculate PI
        Temp# = ATN(1#) * 4#
        Last.Token = True
    CASE "EX" ' calculate E
        Temp# = EXP(1#)
        Last.Token = True
        ' special case functions
    CASE "OR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# OR Temp#
        CALL Get.Token4
        Last.Token = True
    CASE ELSE
        IF MID$(Strng, 2, 1) = "$" THEN
            SELECT CASE MID$(Out2, Token.Index, 1)
                CASE "(", "[", "{"
                    Strng = "<bad string token>"
                    ERROR 92
            END SELECT
            SELECT CASE UCASE$(LEFT$(Strng, 1))
                CASE "A" TO "Z"
                    Element = ASC(UCASE$(LEFT$(Strng, 1))) - 64
                    Out3 = Strngs(Element)
                    Last.Token = False
            END SELECT
        ELSE
            ERROR 92
        END IF
END SELECT
END SUB

' parses FN(<x>)
SUB ParseFN (Temp#)
Var$ = LEFT$(Out2, Token.Index - 3)
CALL Get.Token3
CALL Get.Token
CALL Parse1(Temp4#)
CALL Get.Token4
Func% = CINT(Temp4#)
IF Func% >= 1 AND Func% <= Max.FNs THEN
    Var2$ = MID$(Out2, Token.Index)
    Out2 = Definitions(Func%)
    Out2 = LTRIM$(Out2)
    ' test for nul token
    IF Out2 = Nul THEN
        Strng = "<bad FN token>"
        ERROR 92
    END IF
    ' count recursing calls
    Recurse = Recurse + 1
    IF Recurse > Max.Recurse THEN
        Strng = "<bad FN recurse>"
        ERROR 92
    END IF
    ' recursively call functions
    Token.Index = 1
    CALL Get.Token
    CALL Parse1(Temp#)
    ' test huge recursed FN
    IF LEN(Var$) + LEN(Var2$) >= 1024 THEN
        Var$ = Nul
        Var2$ = Nul
        Strng = "<bad FN string>"
        ERROR 92
    END IF
    Out2 = Var$ + Var2$
    Token.Index = LEN(Var$) + 1
    EXIT SUB
END IF
Strng = "<bad FN range>"
ERROR 92
END SUB

' parses FZ(<x>)
SUB ParseFZ (Temp#)
CALL Get.Token3
CALL Get.Token
CALL Parse1(Temp4#)
CALL Get.Token4
Func% = CINT(Temp4#)
IF Func% >= 1 AND Func% <= Max.FNs THEN
    Out3 = Definitions(Func%)
    Out3 = LTRIM$(Out3)
    Out3 = RTRIM$(Out3)
    IF Out3 = Nul THEN
        Strng = "<bad FZ token>"
        ERROR 92
    END IF
    Last.Token = False
    EXIT SUB
END IF
Strng = "<bad FZ range>"
ERROR 92
END SUB

' parses three and greater letter tokens
SUB Parse.Alphabetic3 (Temp#)
SELECT CASE UCASE$(Strng)
    ' constant functions
    CASE "AUTHOR$"
        Out3 = "Erik Jon Oredson AS. CSci"
        Last.Token = False
    CASE "EMAIL$"
        Out3 = "eoredson@gmail.com"
        Last.Token = False
    CASE "URL$"
        Out3 = "www.filegate.net"
        Last.Token = False
    CASE "VERSION$"
        Out3 = "1.0a"
        Last.Token = False
    CASE "RELEASE$"
        Out3 = "1.0"
        Last.Token = False
    CASE "PROGRAM$"
        Out3 = "whatis"
        Last.Token = False
    CASE "PUBLISH$"
        Out3 = "10/15/2014"
        Last.Token = False
    CASE "COOKIE$"
        Out3 = "Thank you for all the cookies!"
        Last.Token = False
    CASE "ERROR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        ERROR CINT(Temp#)
        CALL Get.Token4
        Last.Token = True
        ' functions w/o parameters
    CASE "FALSE"
        Temp# = FalseD
        Last.Token = True
    CASE "TRUE"
        Temp# = TrueD
        Last.Token = True
    CASE "TIMER"
        Temp# = TIMER
        Last.Token = True
    CASE "RND"
        Temp# = RND
        Last.Token = True
        ' boolean functions
    CASE "AND"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# AND Temp#
        CALL Get.Token4
        Last.Token = True
    CASE "MOD"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# MOD Temp#
        CALL Get.Token4
        Last.Token = True
    CASE "NOR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = NOT (Number# OR Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "NON"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = NOT (Number# IMP Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "XAN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = NOT (Number# AND Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "XOR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# XOR Temp#
        CALL Get.Token4
        Last.Token = True
    CASE "IMP"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# IMP Temp#
        CALL Get.Token4
        Last.Token = True
    CASE "EQV"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# EQV Temp#
        CALL Get.Token4
        Last.Token = True
    CASE "NOT"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = NOT Temp#
        CALL Get.Token4
        Last.Token = True
        ' third-order boolean
    CASE "TAND"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number1# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Number2# = Temp#
        CALL Get.Token4
        SELECT CASE Number1#
            CASE -1, 0, 1
                SELECT CASE Number2#
                    CASE -1, 0, 1
                        Temp# = Number1# AND Number2#
                        Last.Token = True
                        EXIT SUB
                END SELECT
        END SELECT
        ERROR 5
    CASE "TOR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number1# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Number2# = Temp#
        CALL Get.Token4
        SELECT CASE Number1#
            CASE -1, 0, 1
                SELECT CASE Number2#
                    CASE -1, 0, 1
                        Temp# = Number1# OR Number2#
                        Last.Token = True
                        EXIT SUB
                END SELECT
        END SELECT
        ERROR 5
    CASE "TXOR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number1# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Number2# = Temp#
        CALL Get.Token4
        SELECT CASE Number1#
            CASE -1, 0, 1
                SELECT CASE Number2#
                    CASE -1, 0, 1
                        Temp# = Number1# XOR Number2#
                        Last.Token = True
                        EXIT SUB
                END SELECT
        END SELECT
        ERROR 5
        ' date\time functions
    CASE "CLOCK"
        Temp# = TIMER
        Last.Token = True
    CASE "DATE$"
        Out3 = DATE$
        Last.Token = False
    CASE "TIME$"
        Out3 = TIME$
        Last.Token = False
        ' conversion/calculation functions
    CASE "BIN$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = Nul
        IF Temp# >= FalseD THEN
            Digits = False
            DO
                IF 2 ^ (Digits + 1) > Temp# THEN
                    EXIT DO
                END IF
                Digits = Digits + 1
            LOOP
            FOR Power = Digits TO 0 STEP -1
                IF Temp# - 2 ^ Power >= 0 THEN
                    Temp# = Temp# - 2 ^ Power
                    Out3 = Out3 + "1"
                ELSE
                    Out3 = Out3 + "0"
                END IF
            NEXT
        END IF
        CALL Get.Token4
        Last.Token = False
    CASE "CHR$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = CHR$(CINT(Temp#))
        CALL Get.Token4
        Last.Token = False
    CASE "HEX$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = HEX$(Temp#)
        CALL Get.Token4
        Last.Token = False
    CASE "OCT$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = OCT$(Temp#)
        CALL Get.Token4
        Last.Token = False
    CASE "STR$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = STR$(Temp#)
        CALL Get.Token4
        Last.Token = False
    CASE "LCASE$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = LCASE$(Out3)
        CALL Get.Token4
        Last.Token = False
    CASE "UCASE$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = UCASE$(Out3)
        CALL Get.Token4
        Last.Token = False
    CASE "RTRIM$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = RTRIM$(Out3)
        CALL Get.Token4
        Last.Token = False
    CASE "LTRIM$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = LTRIM$(Out3)
        CALL Get.Token4
        Last.Token = False
    CASE "TRIM$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = LTRIM$(RTRIM$(Out3))
        CALL Get.Token4
        Last.Token = False
    CASE "SPACE$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = STRING$(Temp#, 32)
        CALL Get.Token4
        Last.Token = False
    CASE "MID$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp4# = Temp#
        IF Strng = "," THEN
            CALL Get.Token
            CALL Parse1(Temp#)
            Length# = Temp#
            Out3 = MID$(Out3, Temp4#, Length#)
        ELSE
            Out3 = MID$(Out3, Temp4#)
        END IF
        CALL Get.Token4
        Last.Token = False
    CASE "REMID$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        CALL Get.Token
        CALL Parse1(Temp#)
        Start# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Length# = Temp#
        Out3 = LEFT$(Out3, Start# - 1) + MID$(Out3, Start# + Length#)
        CALL Get.Token4
        Last.Token = False
    CASE "DEMID$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        String1$ = Out3
        CALL Get.Token
        CALL Parse1(Temp#)
        IF LEN(String1$) AND LEN(Out3) THEN
            Imbedded = INSTR(String1$, Out3)
            WHILE Imbedded
                String1$ = LEFT$(String1$, Imbedded - 1) + MID$(String1$, Imbedded + LEN(Out3))
                Imbedded = INSTR(String1$, Out3)
            WEND
        END IF
        Out3 = String1$
        CALL Get.Token4
        Last.Token = False
    CASE "REPLACE$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        String1$ = Out3
        CALL Get.Token
        CALL Parse1(Temp#)
        String2$ = Out3
        CALL Get.Token
        CALL Parse1(Temp#)
        String3$ = Out3
        IF String1$ = Nul OR String2$ = Nul OR String2$ = String3$ THEN
            Out3 = String1$
            EXIT SUB
        END IF
        Temp1 = 1
        DO
            IF String1$ = Nul THEN
                EXIT DO
            END IF
            Var1 = INSTR(Temp1, String1$, String2$)
            IF Var1 = False THEN
                EXIT DO
            END IF
            String1$ = LEFT$(String1$, Var1 - 1) + String3$ + MID$(String1$, Var1 + LEN(String2$))
            Temp1 = Temp1 + LEN(String3$)
        LOOP
        Out3 = String1$
        CALL Get.Token4
        Last.Token = False
    CASE "LEFT$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = LEFT$(Out3, Temp#)
        CALL Get.Token4
        Last.Token = False
    CASE "RIGHT$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        CALL Get.Token
        CALL Parse1(Temp#)
        Out3 = RIGHT$(Out3, Temp#)
        CALL Get.Token4
        Last.Token = False
    CASE "STRING$"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        IF Last.Token THEN
            Out3 = STRING$(Number#, Temp#)
        ELSE
            Out3 = STRING$(Number#, Out3)
        END IF
        CALL Get.Token4
        Last.Token = False
    CASE "ABS"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ABS(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "ASC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ASC(Out3)
        CALL Get.Token4
        Last.Token = True
    CASE "EXP"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = EXP(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "FBN" ' calculate xth fibonachi value
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Fibo.A# = 1
        Fibo.B# = 1
        IF Temp# >= 1 THEN
            FOR Fibo.Number# = 1 TO Temp# - 1
                Fibo.Temp# = Fibo.B#
                Fibo.B# = Fibo.A# + Fibo.B#
                Fibo.A# = Fibo.Temp#
            NEXT
        END IF
        Temp# = Fibo.B#
        CALL Get.Token4
        Last.Token = True
    CASE "FCT"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Factorial# = 1
        Factorial.Count# = INT(Temp#)
        IF Factorial.Count# >= 1 THEN
            FOR Factorial.Count# = 1 TO Temp#
                Factorial# = Factorial# * Factorial.Count#
            NEXT
        END IF
        Temp# = Factorial#
        CALL Get.Token4
        Last.Token = True
    CASE "FIX"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = FIX(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "INSTR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        IF Last.Token THEN
            Start# = Temp#
            CALL Get.Token
            CALL Parse1(Temp#)
            Stored.String$ = Out3
            CALL Get.Token
            CALL Parse1(Temp#)
        ELSE
            Start# = 1#
            Stored.String$ = Out3
            CALL Get.Token
            CALL Parse1(Temp#)
        END IF
        Temp# = INSTR(Start#, Stored.String$, Out3)
        CALL Get.Token4
        Last.Token = True
    CASE "INT"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = INT(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "LEN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LEN(Out3)
        CALL Get.Token4
        Last.Token = True
    CASE "LOG"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LOG(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "ISEVEN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = (Temp# MOD 2#) = 0
        CALL Get.Token4
        Last.Token = True
    CASE "ISODD"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = (Temp# MOD 2#) = 1
        CALL Get.Token4
        Last.Token = True
    CASE "ISPRM" ' calculate x is prime
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Prime# = INT(Temp#)
        Prime.Flag = True
        IF Prime# > 2# THEN
            FOR Loop.Count# = 2# TO INT(SQR(Prime#))
                IF Prime# / Loop.Count# = INT(Prime# / Loop.Count#) THEN
                    Prime.Flag = False
                    EXIT FOR
                END IF
            NEXT
        END IF
        IF Prime.Flag = False THEN
            Temp# = FalseD
        ELSE
            Temp# = TrueD
        END IF
        CALL Get.Token4
        Last.Token = True
    CASE "PRF" ' calculate xth perfect number
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        CALL Get.Token4
        Last.Token = True
        Perfect# = INT(Temp#)
        SELECT CASE Perfect#
            CASE 1#
                X# = 1#
            CASE 2#
                X# = 2#
            CASE 3#
                X# = 4#
            CASE 4#
                X# = 6#
            CASE 5#
                X# = 12#
            CASE 6#
                X# = 16#
            CASE 7#
                X# = 18#
                'CASE 8# ' overflows beyond double precision
                '  X# = 30#
            CASE ELSE
                ERROR 130
        END SELECT
        ' equation for perfect number
        Temp# = 2 ^ X# * (2 ^ (X# + 1) - 1)
        Last.Token = True
    CASE "PRM" ' calculate xth prime
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Prime.Number# = INT(Temp#)
        Prime# = 1
        IF Prime.Number# > FalseD THEN
            Prime.Counter# = False
            DO
                Prime# = Prime# + 1
                Prime.Flag = False
                FOR Factor# = 2# TO INT(SQR(Prime#))
                    IF Prime# / Factor# = INT(Prime# / Factor#) THEN
                        Prime.Flag = True
                        EXIT FOR
                    END IF
                NEXT
                IF Prime.Flag = False THEN
                    Prime.Counter# = Prime.Counter# + 1
                END IF
                IF Prime.Counter# = Prime.Number# THEN
                    EXIT DO
                END IF
            LOOP
        END IF
        Temp# = Prime#
        CALL Get.Token4
        Last.Token = True
    CASE "SGN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = SGN(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "SQR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = SQR(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "CBR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Temp# ^ (1# / 3#)
        CALL Get.Token4
        Last.Token = True
    CASE "GCM"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number1# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Number2# = Temp#
        ' find last factor which divides into both numbers
        Factor1# = 1
        Number3# = Number1#
        FOR Factor2# = 2 TO Number1#
            DO
                IF Number3# / Factor2# = Number3# \ Factor2# THEN
                    IF Number2# / Factor2# = Number2# \ Factor2# THEN
                        IF Factor2# > Factor1# THEN
                            Factor1# = Factor2#
                        END IF
                    END IF
                    Number3# = Number3# / Factor2#
                ELSE
                    EXIT DO
                END IF
            LOOP
        NEXT
        Temp# = Factor1#
        CALL Get.Token4
        Last.Token = True
    CASE "LCD"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number1# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Number2# = Temp#
        ' find first factor which divides into both numbers
        Factor1# = 0
        FOR Factor2# = 2 TO Number1#
            IF Number1# / Factor2# = Number1# \ Factor2# THEN
                IF Number2# / Factor2# = Number2# \ Factor2# THEN
                    Factor1# = Factor2#
                    EXIT FOR
                END IF
            END IF
        NEXT
        IF Factor1# = 0# THEN
            Factor1# = 1#
        END IF
        IF Factor1# = Number2# THEN
            Factor1# = 1#
        END IF
        Temp# = Factor1#
        CALL Get.Token4
        Last.Token = True
    CASE "NTH"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# ^ (1# / Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "PWR"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = Number# ^ Temp#
        CALL Get.Token4
        Last.Token = True
    CASE "VAL"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = VAL(Out3)
        CALL Get.Token4
        Last.Token = True

        REM Basic trigonometric functions..

    CASE "ATN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ATN(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "COS"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = COS(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "COT"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = COS(Temp#) / SIN(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "CSC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = 1# / SIN(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "SEC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = 1# / COS(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "SIN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = SIN(Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE "TAN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = TAN(Temp#)
        CALL Get.Token4
        Last.Token = True

        REM Remaining nonintrinsic trigonmetric functions..

        'Inverse Cosine
    CASE "ARCCOS"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ATN(-Temp# / SQR(-Temp# * Temp# + 1)) + 2 * ATN(1)
        CALL Get.Token4
        Last.Token = True
        'Inverse Cosecant
    CASE "ARCCOSEC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ATN(Temp# / SQR(Temp# * Temp# - 1)) + (SGN(Temp#) - 1) * (2 * ATN(1))
        CALL Get.Token4
        Last.Token = True
        'Inverse Cotangent
    CASE "ARCCOTAN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ATN(Temp#) + 2 * ATN(1)
        CALL Get.Token4
        Last.Token = True
        'Inverse Secant
    CASE "ARCSEC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ATN(Temp# / SQR(Temp# * Temp# - 1)) + SGN((Temp#) - 1) * (2 * ATN(1))
        CALL Get.Token4
        Last.Token = True
        'Inverse Sine
    CASE "ARCSIN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ATN(Temp# / SQR(-Temp# * Temp# + 1))
        CALL Get.Token4
        Last.Token = True
        'Convert Degrees to Radians
    CASE "DEGTORAD"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = ((ATN(1) * 4) / 180) * Temp#
        CALL Get.Token4
        Last.Token = True
        'Inverse Hyperbolic Cosine
    CASE "HARCCOS"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LOG(Temp# + SQR(Temp# * Temp# - 1))
        CALL Get.Token4
        Last.Token = True
        'Inverse Hyperbolic Cosecant
    CASE "HARCCOSEC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LOG((SGN(Temp#) * SQR(Temp# * Temp# + 1) + 1) / Temp#)
        CALL Get.Token4
        Last.Token = True
        'Inverse Hyperbolic Cotangent
    CASE "HARCCOTAN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LOG((Temp# + 1) / (Temp# - 1)) / 2
        CALL Get.Token4
        Last.Token = True
        'Inverse Hyperbolic Secant
    CASE "HARCSEC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LOG((SQR(-Temp# * Temp# + 1) + 1) / Temp#)
        CALL Get.Token4
        Last.Token = True
        'Inverse Hyperbolic Sine
    CASE "HARCSIN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LOG(Temp# + SQR(Temp# * Temp# + 1))
        CALL Get.Token4
        Last.Token = True
        'Inverse Hyperbolic Tangent
    CASE "HARCTAN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = LOG((1 + Temp#) / (1 - Temp#)) / 2
        CALL Get.Token4
        Last.Token = True
        'Hyperbolic Cosine
    CASE "HCOS"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = (EXP(Temp#) + EXP(-Temp#)) / 2
        CALL Get.Token4
        Last.Token = True
        'Hyperbolic Cosecant
    CASE "HCOSEC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = 2 / (EXP(Temp#) - EXP(-Temp#))
        CALL Get.Token4
        Last.Token = True
        'Hyperbolic Cotangent
    CASE "HCOTAN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = (EXP(Temp#) + EXP(-Temp#)) / (EXP(Temp#) - EXP(-Temp#))
        CALL Get.Token4
        Last.Token = True
        'Hyperbolic Secant
    CASE "HSEC"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = 2 / (EXP(Temp#) + EXP(-Temp#))
        CALL Get.Token4
        Last.Token = True
        'Hyperbolic Sine
    CASE "HSIN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = (EXP(Temp#) - EXP(-Temp#)) / 2
        CALL Get.Token4
        Last.Token = True
        'Hyperbolic Tangent
    CASE "HTAN"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = (EXP(Temp#) - EXP(-Temp#)) / (EXP(Temp#) + EXP(-Temp#))
        CALL Get.Token4
        Last.Token = True
        'Convert Radians to Degrees
    CASE "RADTODEG"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = (180 / (ATN(1) * 4)) * Temp#
        CALL Get.Token4
        Last.Token = True
        ' Hypotenuse
    CASE "HYPOT"
        CALL Get.Token3
        CALL Get.Token
        CALL Parse1(Temp#)
        Number# = Temp#
        CALL Get.Token
        CALL Parse1(Temp#)
        Temp# = SQR(Number# * Number# + Temp# * Temp#)
        CALL Get.Token4
        Last.Token = True
    CASE ELSE
        ERROR 92
END SELECT
END SUB

' uses direct keyboard input to get an input line
'   and edit multi-dimensional command history arrays with line-wrapping,
'     where Temp0 (history array type) equals:
'       1=<n/a>
'       2=<n/a>
'       3=whatis prompt

FUNCTION KeyboardLine$
History.Count2(Temp0) = 0 ' reset
Var$ = Nul
DO
    _LIMIT 50
    Var2$ = INKEY$ ' get character
    SELECT CASE LEN(Var2$)
        CASE 0
            Eat$ = Nul
        CASE 1
            SELECT CASE Var2$
                CASE CHR$(9) ' tab
                    IF LEN(Var$) + 8 <= 256 THEN
                        FOR VarX = 1 TO 8
                            PRINT " ";
                            LOCATE , , 1
                            Var$ = Var$ + " "
                        NEXT
                    END IF
                CASE CHR$(13) ' return
                    GOSUB Enter.History
                    EXIT DO
                CASE CHR$(8) ' backspace
                    IF LEN(Var$) > 0 THEN
                        Var$ = LEFT$(Var$, LEN(Var$) - 1)
                        GOSUB Back.Space
                    END IF
                CASE CHR$(27) ' escape
                    GOSUB Erase.Line
                CASE ELSE ' store input
                    IF LEN(Var$) < 256 THEN
                        PRINT Var2$;
                        LOCATE , , Visible
                        Var$ = Var$ + Var2$
                    END IF
            END SELECT
        CASE 2
            SELECT CASE ASC(RIGHT$(Var2$, 1))
                CASE 77 ' right
                    GOSUB Get.Count
                    IF Var1 > 0 THEN
                        SELECT CASE History.Count2(Temp0)
                            CASE 0
                                GOSUB Erase.Line
                                History.Count2(Temp0) = Var1
                                Var$ = RTRIM$(History2(Temp0, Var1))
                                PRINT Var$;
                            CASE 1 TO Max.History - 1
                                IF History.Count2(Temp0) + 1 <= Var1 THEN
                                    GOSUB Erase.Line
                                    History.Count2(Temp0) = History.Count2(Temp0) + 1
                                    Var$ = RTRIM$(History2(Temp0, History.Count2(Temp0)))
                                    PRINT Var$;
                                ELSE
                                    IF History.Count2(Temp0) = Var1 THEN
                                        GOSUB Erase.Line
                                        Var$ = RTRIM$(History2(Temp0, Var1))
                                        PRINT Var$;
                                    END IF
                                END IF
                            CASE Max.History
                                GOSUB Erase.Line
                                Var$ = RTRIM$(History2(Temp0, Max.History))
                                PRINT Var$;
                        END SELECT
                    END IF
                CASE 75 ' left
                    GOSUB Get.Count
                    IF Var1 > 0 THEN
                        SELECT CASE History.Count2(Temp0)
                            CASE 0
                                GOSUB Erase.Line
                                History.Count2(Temp0) = Var1
                                Var$ = RTRIM$(History2(Temp0, Var1))
                                PRINT Var$;
                            CASE 1
                                GOSUB Erase.Line
                                Var$ = RTRIM$(History2(Temp0, 1))
                                PRINT Var$;
                            CASE ELSE
                                IF History.Count2(Temp0) - 1 > 0 THEN
                                    GOSUB Erase.Line
                                    History.Count2(Temp0) = History.Count2(Temp0) - 1
                                    Var$ = RTRIM$(History2(Temp0, History.Count2(Temp0)))
                                    PRINT Var$;
                                END IF
                        END SELECT
                    END IF
                CASE 71 ' home
                    GOSUB Get.Count
                    IF Var1 > 0 THEN
                        GOSUB Erase.Line
                        History.Count2(Temp0) = 1
                        Var$ = RTRIM$(History2(Temp0, 1))
                        PRINT Var$;
                    END IF
                CASE 79 ' end
                    GOSUB Get.Count
                    IF Var1 > 0 THEN
                        GOSUB Erase.Line
                        History.Count2(Temp0) = Var1
                        Var$ = RTRIM$(History2(Temp0, Var1))
                        PRINT Var$;
                    END IF
            END SELECT
    END SELECT
    LOCATE , , 1
LOOP

' return input line
KeyboardLine$ = Var$
EXIT FUNCTION

Enter.History:
IF LEN(Var$) THEN
    GOSUB Get.Count
    ' init
    IF Var1 = 0 THEN
        History.Count2(Temp0) = 1
        History2(Temp0, 1) = Var$
    ELSE
        ' add history
        IF History.Count2(Temp0) = 0 THEN
            IF Var1 < Max.History THEN
                History.Count2(Temp0) = Var1 + 1
                History2(Temp0, Var1 + 1) = Var$
            ELSE
                FOR Var = 1 TO Max.History - 1
                    History2(Temp0, Var) = History2(Temp0, Var + 1)
                NEXT
                History.Count2(Temp0) = Max.History
                History2(Temp0, Max.History) = Var$
            END IF
        ELSE
            ' pack history
            IF Var1 = Max.History THEN
                FOR Var = History.Count2(Temp0) TO Max.History - 1
                    History2(Temp0, Var) = History2(Temp0, Var + 1)
                NEXT
                History.Count2(Temp0) = Max.History
                History2(Temp0, Max.History) = Var$
            ELSE
                FOR Var = History.Count2(Temp0) TO Var1 - 1
                    History2(Temp0, Var) = History2(Temp0, Var + 1)
                NEXT
                History2(Temp0, Var1) = Var$
            END IF
        END IF
    END IF
END IF
RETURN

Erase.Line:
FOR VarX = 1 TO LEN(Var$)
    GOSUB Back.Space
NEXT
Var$ = Nul
RETURN

Back.Space:
IF POS(0) > 1 THEN ' check cursor location
    LOCATE CSRLIN, POS(0) - 1, 0
    PRINT " ";
    LOCATE CSRLIN, POS(0) - 1, 1
ELSE ' line-wrap
    LOCATE CSRLIN - 1, 80, 0
    PRINT " ";
    LOCATE CSRLIN - 1, 80, 1
END IF
RETURN

Get.Count:
Var1 = 0
FOR Var2 = Max.History TO 1 STEP -1
    IF RTRIM$(History2(Temp0, Var2)) <> Nul THEN
        Var1 = Var2
        EXIT FOR
    END IF
NEXT
RETURN
END FUNCTION

' beginning of the command/equation parser
SUB Enter.Equate
Strng = Nul
Out2 = LTRIM$(Out2)
IF Out2 = Nul THEN
    EXIT SUB
END IF
Store.Input$ = Out2
Assign = False
GOSUB Assignment
IF Assign THEN
    EXIT SUB
END IF
Out2 = Store.Input$
D$ = UCASE$(Out2)
IF LEFT$(D$, 3) = "MID" THEN
    GOSUB Assign.Mid.String
    IF Assign THEN
        EXIT SUB
    END IF
END IF
IF LEFT$(D$, 4) = "LEFT" THEN
    GOSUB Assign.Left.String
    IF Assign THEN
        EXIT SUB
    END IF
END IF
IF LEFT$(D$, 5) = "RIGHT" THEN
    GOSUB Assign.Right.String
    IF Assign THEN
        EXIT SUB
    END IF
END IF
IF LEFT$(D$, 5) = "DEFFN" THEN
    GOSUB Define.Function
    IF Assign THEN
        EXIT SUB
    END IF
END IF
Out2 = Store.Input$
Last.Token = False
Out3 = Nul
Out4 = Nul
Temp# = False
Token.Index = 1
CALL Get.Token
CALL Parse1(T#)

' parse leftover tokens
WHILE LEN(Strng)
    CALL Parse1(X#)
    ' toss away any unwanted tokens
    IF Last.Token = 3 THEN
        Strng = "<extra token>"
        ERROR 92
    END IF
WEND

' display output result
IF Last.Token = False THEN
    PRINT Out3
ELSE
    PRINT LTRIM$(STR$(T#))
END IF
EXIT SUB

Assignment:
Assign = False
Temp1$ = UCASE$(LEFT$(Out2, 1))
IF Temp1$ = "?" THEN
    Temp1$ = MID$(Out2, 2)
    Temp2$ = LEFT$(Temp1$, 1)
    IF Temp2$ = "=" THEN
        Temp1$ = MID$(Temp1$, 2)
        Out2 = Temp1$
        CALL Equate(Temp4#)
        Assign = True
        EXIT SUB
    END IF
END IF
IF Temp1$ >= "A" AND Temp1$ <= "Z" THEN
    Variable = ASC(Temp1$) - 64
    Temp1$ = MID$(Out2, 2)
    Temp1$ = LTRIM$(Temp1$)
    CALL Assignment1(Temp1$, Variable)
    IF Assign THEN
        GOSUB Assign.End
        RETURN
    END IF
    IF LEFT$(Temp1$, 1) = "$" THEN
        Temp1$ = MID$(Temp1$, 2)
        Temp1$ = LTRIM$(Temp1$)
        IF LEFT$(Temp1$, 1) = "(" THEN
            Strng = "<bad string token>"
            ERROR 92
        END IF
        IF LEFT$(Temp1$, 1) = "[" THEN
            Strng = "<bad string token>"
            ERROR 92
        END IF
        IF LEFT$(Temp1$, 1) = "{" THEN
            Strng = "<bad string token>"
            ERROR 92
        END IF
        IF LEFT$(Temp1$, 1) = "=" THEN
            Out2 = MID$(Temp1$, 2)
            Out2 = LTRIM$(Out2)
            Token.Index = 1
            CALL Get.Token
            CALL Parse1(Temp3#)
            IF Last.Token = False THEN
                Strngs(Variable) = Out3
                Assign = True
                GOSUB Assign.End
                RETURN
            END IF
        END IF
    END IF
    IF LEFT$(Temp1$, 1) = "(" THEN
        Out2 = MID$(Temp1$, 2)
        Out2 = LTRIM$(Out2)
        Last.Token = False
        Token.Index = 1
        CALL Get.Token
        CALL Parse1(Temp3#)
        IF Last.Token = True THEN
            Element = CINT(Temp3#)
            Temp1$ = MID$(Out2, Token.Index)
            Temp1$ = LTRIM$(Temp1$)
            CALL Assignment2(Temp1$, Variable, Element)
            IF Assign THEN
                GOSUB Assign.End
                RETURN
            END IF
        END IF
    END IF
END IF
RETURN

Assign.Mid.String:
Out2 = MID$(Out2, 4)
IF LEN(Out2) THEN
    Out2 = LTRIM$(Out2)
    Out2 = MID$(Out2, 3)
    V$ = UCASE$(LEFT$(Out2, 1))
    IF V$ >= "A" AND V$ <= "Z" THEN
        Variable = ASC(V$) - 64
        IF MID$(Out2, 2, 1) = "$" THEN
            Out2 = MID$(Out2, 4)
            Last.Token = False
            Token.Index = 1
            CALL Get.Token
            CALL Parse1(T#)
            Start = CINT(T#)
            IF Strng = "," THEN
                CALL Get.Token
                CALL Parse1(T#)
                Length = CINT(T#)
                Out2 = MID$(Out2, Token.Index)
                Out2 = LTRIM$(Out2)
                IF LEFT$(Out2, 1) = "=" THEN
                    Out2 = MID$(Out2, 2)
                    Out2 = LTRIM$(Out2)
                    Token.Index = 1
                    CALL Get.Token
                    CALL Parse1(T#)
                    IF Last.Token = False THEN
                        Assign = True
                        IF Strngs(Variable) = Nul THEN
                            IF Start = 1 THEN
                                IF LEN(Out3) = Length THEN
                                    Strngs(Variable) = Out3
                                    GOSUB Assign.End
                                    RETURN
                                END IF
                            END IF
                            Strng = "<bad string>"
                            ERROR 92
                            RETURN
                        END IF
                        MID$(Strngs(Variable), Start, Length) = Out3
                        GOSUB Assign.End
                        RETURN
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF
RETURN

Assign.Left.String:
Out2 = MID$(Out2, 5)
IF LEN(Out2) THEN
    Out2 = LTRIM$(Out2)
    Out2 = MID$(Out2, 3)
    V$ = UCASE$(LEFT$(Out2, 1))
    IF V$ >= "A" AND V$ <= "Z" THEN
        Variable = ASC(V$) - 64
        IF MID$(Out2, 2, 1) = "$" THEN
            Out2 = MID$(Out2, 4)
            Last.Token = False
            Token.Index = 1
            CALL Get.Token
            CALL Parse1(T#)
            Start = CINT(T#)
            Out2 = MID$(Out2, Token.Index)
            Out2 = LTRIM$(Out2)
            IF LEFT$(Out2, 1) = "=" THEN
                Assign = True
                Out2 = MID$(Out2, 2)
                Out2 = LTRIM$(Out2)
                Token.Index = 1
                CALL Get.Token
                CALL Parse1(T#)
                IF Last.Token = False THEN
                    Assign = True
                    IF Strngs(Variable) = Nul THEN
                        IF LEN(Out3) = Start THEN
                            Strngs(Variable) = Out3
                            GOSUB Assign.End
                            RETURN
                        END IF
                        Strng = "<bad string>"
                        ERROR 92
                        RETURN
                    END IF
                    MID$(Strngs(Variable), 1, Start) = Out3
                    GOSUB Assign.End
                    RETURN
                END IF
            END IF
        END IF
    END IF
END IF
RETURN

Assign.Right.String:
Out2 = MID$(Out2, 6)
IF LEN(Out2) THEN
    Out2 = LTRIM$(Out2)
    Out2 = MID$(Out2, 3)
    V$ = UCASE$(LEFT$(Out2, 1))
    IF V$ >= "A" AND V$ <= "Z" THEN
        Variable = ASC(V$) - 64
        IF MID$(Out2, 2, 1) = "$" THEN
            Out2 = MID$(Out2, 4)
            Last.Token = False
            Token.Index = 1
            CALL Get.Token
            CALL Parse1(T#)
            Start = CINT(T#)
            Out2 = MID$(Out2, Token.Index)
            Out2 = LTRIM$(Out2)
            IF LEFT$(Out2, 1) = "=" THEN
                Assign = True
                Out2 = MID$(Out2, 2)
                Out2 = LTRIM$(Out2)
                Token.Index = 1
                CALL Get.Token
                CALL Parse1(T#)
                Length = LEN(Strngs(Variable)) - Start + 1
                IF Last.Token = False THEN
                    Assign = True
                    IF Length > False THEN
                        MID$(Strngs(Variable), Length, Start) = Out3
                        GOSUB Assign.End
                        RETURN
                    ELSE
                        IF Strngs(Variable) = Nul THEN
                            IF LEN(Out3) = Start THEN
                                Strngs(Variable) = Out3
                                GOSUB Assign.End
                                RETURN
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF
RETURN

Assign.End:
IF LEN(Strng) THEN
    CALL Parse1(X#)
    Strng = "<extra token>"
    ERROR 92
END IF
RETURN

Define.Function:
Out2 = MID$(Out2, 6)
Out2 = LTRIM$(Out2)
Token.Index = 1
CALL Get.Token3
CALL Get.Token
CALL Parse1(Temp4#)
CALL Get.Token4
Func% = CINT(Temp4#)
IF Func% >= 1 AND Func% <= Max.FNs THEN
    Out2 = MID$(Out2, Token.Index)
    Out2 = LTRIM$(Out2)
    IF LEFT$(Out2, 1) = "=" THEN
        Out2 = MID$(Out2, 2)
        Definitions(Func%) = Out2
        Assign = True
        RETURN
    END IF
END IF
ERROR 145
END SUB

' returns next token in string form,
' increments pointer to next token,
' determines token type.
SUB Get.Token
Strng = Nul ' reset token
Token = False ' reset token type
' locate symbols
CALL Get.Token2(Token.Exists)
IF Token.Exists THEN
    EXIT SUB
END IF
IF Token.Index > LEN(Out2) THEN
    Strng = Nul
    Token = False
    Token.Index = Token.Index + 1
    EXIT SUB
END IF
' locate expression symbol
Token.Element$ = MID$(Out2, Token.Index, 1)
IF INSTR(Token.List, Token.Element$) THEN
    Token = 1 ' store token type
    Strng = Token.Element$ ' store token
    Token.Index = Token.Index + 1 ' increment pointer
    EXIT SUB
END IF
' locate expression is number
Token.Element$ = MID$(Out2, Token.Index, 1)
IF Token.Element$ >= "0" AND Token.Element$ <= "9" THEN
    ' increment token until token is other than number
    DO
        IF LEN(Token.Element$) = False THEN
            EXIT DO
        END IF
        IF INSTR(Token.List, Token.Element$) THEN
            EXIT DO
        END IF
        Strng = Strng + Token.Element$
        Token.Index = Token.Index + 1
        Token.Element$ = MID$(Out2, Token.Index, 1)
    LOOP
    Token = 2 ' store token type
    EXIT SUB
END IF
' locate expression is number beginning with decimal
Token.Element$ = MID$(Out2, Token.Index, 1)
IF Token.Element$ = "." THEN
    ' increment token until token is other than number
    DO
        IF LEN(Token.Element$) = False THEN
            EXIT DO
        END IF
        IF INSTR(Token.List, Token.Element$) THEN
            EXIT DO
        END IF
        Strng = Strng + Token.Element$
        Token.Index = Token.Index + 1
        Token.Element$ = MID$(Out2, Token.Index, 1)
    LOOP
    Token = 2 ' store token type
    EXIT SUB
END IF
' locate expression is alphabetic
Token.Element$ = UCASE$(MID$(Out2, Token.Index, 1))
IF Token.Element$ >= "A" AND Token.Element$ <= "Z" THEN
    ' increment token until token is other than alphabetic
    DO
        IF LEN(Token.Element$) = False THEN
            EXIT DO
        END IF
        IF INSTR(Token.List, Token.Element$) THEN
            EXIT DO
        END IF
        Strng = Strng + Token.Element$
        Token.Index = Token.Index + 1
        Token.Element$ = UCASE$(MID$(Out2, Token.Index, 1))
    LOOP
    Token = 3 ' store token type
    EXIT SUB
END IF
Token = False
Strng = Token.Element$
Token.Index = Token.Index + 1
END SUB

' gets two-symbol tokens,
' increments pointer to next token.
SUB Get.Token2 (Token.Exists)
Token.Exists = False
Stored.Token$ = Out2
' locate expression symbols
Next.Token$ = MID$(Stored.Token$, Token.Index, 2)
SELECT CASE Next.Token$
    CASE "<<"
        Token = 1 ' store token type
        Strng = "<<" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE ">>"
        Token = 1 ' store token type
        Strng = ">>" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE "--"
        Token = 1 ' store token type
        Strng = "--" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE "++"
        Token = 1 ' store token type
        Strng = "++" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE "**"
        Token = 1 ' store token type
        Strng = "**" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE "//"
        Token = 1 ' store token type
        Strng = "//" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE ">=", "=>"
        Token = 1 ' store token type
        Strng = ">=" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE "<=", "=<"
        Token = 1 ' store token type
        Strng = "<=" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
    CASE "<>", "><"
        Token = 1 ' store token type
        Strng = "<>" ' store token
        Token.Index = Token.Index + 2 ' increment pointer
        Token.Exists = True
END SELECT
END SUB

' verifies next token is opening parenthesis.
SUB Get.Token3
Strng = Nul
Token = False
IF Token.Index > LEN(Out2) THEN
    Strng = "<missing opening parenthesis>"
    ERROR 92
END IF
' locate parenthesis symbol
Token.Element$ = MID$(Out2, Token.Index, 1)
IF Token.Element$ = "(" THEN
    Token = 1 ' store token type
    Strng = Token.Element$ ' store token
    Token.Index = Token.Index + 1 ' increment pointer
    EXIT SUB
END IF
Strng = "<missing opening parenthesis>"
ERROR 92
END SUB

' verifies last token is closing parenthesis.
SUB Get.Token4
' locate parenthesis symbol
IF Strng = ")" THEN
    EXIT SUB
END IF
Strng = "<missing closing parenthesis>"
ERROR 92
END SUB

' process a number
SUB Parse.Numeric (Temp#)
SELECT CASE RIGHT$(UCASE$(Strng), 1) ' compare character after number
    CASE "Q" ' perfect number suffix
        FOR Digit = 1 TO LEN(Strng) - 1
            OutX$ = UCASE$(MID$(Strng, Digit, 1))
            SELECT CASE OutX$
                CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                    ' nul
                CASE ELSE
                    ERROR 130
            END SELECT
        NEXT
        Temp# = CDBL(VAL(LEFT$(Strng, LEN(Strng) - 1)))
        Perfect# = 0#
        Perfect.Number# = INT(Temp#)
        IF ABS(Perfect.Number#) > 7# THEN
            ERROR 130
        END IF
        IF Perfect.Number# > FalseD THEN
            SELECT CASE Perfect.Number#
                CASE 1#
                    X# = 1#
                CASE 2#
                    X# = 2#
                CASE 3#
                    X# = 4#
                CASE 4#
                    X# = 6#
                CASE 5#
                    X# = 12#
                CASE 6#
                    X# = 16#
                CASE 7#
                    X# = 18#
                    'CASE 8# ' overflows beyond double precision
                    '  X# = 30#
                CASE ELSE
                    ERROR 130
            END SELECT
            ' equation for perfect number
            Perfect# = 2 ^ X# * (2 ^ (X# + 1) - 1)
        END IF
        Temp# = Perfect#
    CASE "P" ' prime number suffix
        FOR Digit = 1 TO LEN(Strng) - 1
            OutX$ = UCASE$(MID$(Strng, Digit, 1))
            SELECT CASE OutX$
                CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                    ' nul
                CASE ELSE
                    ERROR 130
            END SELECT
        NEXT
        Temp# = CDBL(VAL(LEFT$(Strng, LEN(Strng) - 1)))
        Prime.Number# = INT(Temp#)
        Prime# = 1
        IF Prime.Number# > False THEN
            Prime.Counter# = False
            DO
                Prime# = Prime# + 1
                Prime.Flag = False
                FOR Factor# = 2# TO INT(SQR(Prime#))
                    IF Prime# / Factor# = INT(Prime# / Factor#) THEN
                        Prime.Flag = True
                        EXIT FOR
                    END IF
                NEXT
                IF Prime.Flag = False THEN
                    Prime.Counter# = Prime.Counter# + 1
                END IF
                IF Prime.Counter# = Prime.Number# THEN
                    EXIT DO
                END IF
            LOOP
        END IF
        Temp# = Prime#
    CASE "F" ' factorial
        Temp2 = False
        Temp3 = LEN(Strng)
        DO
            IF UCASE$(MID$(Strng, Temp3, 1)) <> "F" THEN
                EXIT DO
            END IF
            Temp2 = Temp2 + 1
            Temp3 = Temp3 - 1
        LOOP
        FOR Decimal.Digit = 1 TO Temp3
            OutX$ = UCASE$(MID$(Strng, Decimal.Digit, 1))
            SELECT CASE OutX$
                CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
                    ' nul
                CASE ELSE
                    ERROR 130
            END SELECT
        NEXT
        Temp4# = VAL(LEFT$(Strng, Temp3))
        FOR Number = 1 TO Temp2
            Temp# = 1#
            FOR Factorial# = 2# TO Temp4#
                Temp# = Temp# * Factorial#
            NEXT
            Temp4# = Temp#
        NEXT
    CASE "H" ' hexidecimal suffix
        Temp# = False
        Hex.Power = False
        FOR Hex.Digit = LEN(Strng) - 1 TO 1 STEP -1
            OutX$ = UCASE$(MID$(Strng, Hex.Digit, 1))
            SELECT CASE OutX$
                CASE "0" TO "9", "A" TO "F"
                    Hex.Value = VAL("&H" + OutX$)
                    Temp# = Temp# + Hex.Value * 16 ^ Hex.Power
                    Hex.Power = Hex.Power + 1
                CASE ELSE
                    ERROR 130
            END SELECT
        NEXT
    CASE "O" ' octal suffix
        Temp# = False
        Octal.Power = False
        FOR Octal.Digit = LEN(Strng) - 1 TO 1 STEP -1
            OutX$ = MID$(Strng, Octal.Digit, 1)
            IF OutX$ >= "0" AND OutX$ <= "7" THEN
                Octal.Value = VAL(OutX$)
                Temp# = Temp# + Octal.Value * 8 ^ Octal.Power
                Octal.Power = Octal.Power + 1
            ELSE
                ERROR 130
            END IF
        NEXT
    CASE "B" ' binary suffix
        Temp# = False
        Binary.Power = False
        FOR Binary.Digit = LEN(Strng) - 1 TO 1 STEP -1
            OutX$ = MID$(Strng, Binary.Digit, 1)
            SELECT CASE OutX$
                CASE "0"
                    ' nul
                CASE "1"
                    Temp# = Temp# + 2 ^ Binary.Power
                CASE ELSE
                    ERROR 130
            END SELECT
            Binary.Power = Binary.Power + 1
        NEXT
    CASE "0" TO "9", "D", "E" ' decimal/exponent suffix
        Decimal = False
        Exponent = False
        Number$ = Strng
        Start.Token:
        FOR Decimal.Digit = 1 TO LEN(Number$)
            OutX$ = UCASE$(MID$(Number$, Decimal.Digit, 1))
            SELECT CASE OutX$
                CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "+"
                    ' nul
                CASE "D", "E"
                    IF Exponent THEN
                        ERROR 140
                    END IF
                    Exponent = True
                    Exponent$ = UCASE$(RIGHT$(Number$, 1))
                    IF Exponent$ = "D" OR Exponent$ = "E" THEN
                        ' concatenate pre-parsed tokens into exponent
                        Unary$ = MID$(Out2, Token.Index, 1)
                        IF Unary$ = "+" OR Unary$ = "-" THEN
                            Var$ = LEFT$(Out2, Token.Index - 1)
                            CALL Get.Token
                            Out2 = Var$ + Strng + MID$(Out2, Token.Index)
                            CALL Get.Token
                            IF Strng = Nul THEN
                                ERROR 140
                            END IF
                            Number$ = Number$ + Unary$ + Strng
                            IF Strng = "-" OR Strng = "+" THEN
                                ERROR 140
                            END IF
                            IF INSTR(Strng, ".") THEN
                                ERROR 140
                            END IF
                            DO
                                IF LEFT$(Number$, 1) = "-" THEN
                                    Number$ = MID$(Number$, 2)
                                ELSE
                                    IF LEFT$(Number$, 1) = "+" THEN
                                        Number$ = MID$(Number$, 2)
                                    ELSE
                                        EXIT DO
                                    END IF
                                END IF
                            LOOP
                            Decimal = False
                            Exponent = False
                            GOTO Start.Token
                        ELSE
                            ERROR 140
                        END IF
                    END IF
                CASE "."
                    IF Exponent THEN
                        ERROR 140
                    END IF
                    IF Decimal THEN
                        ERROR 140
                    END IF
                    Decimal = True
                CASE ELSE
                    ERROR 130
            END SELECT
        NEXT
        Temp# = CDBL(VAL(Number$))
    CASE ELSE
        ERROR 130
END SELECT
CALL Get.Token
Last.Token = True
END SUB

' parse string in quotes
SUB Parse.Quoted
Out3 = Nul
DO UNTIL MID$(Out2, Token.Index, 1) = CHR$(34)
    Out3 = Out3 + MID$(Out2, Token.Index, 1)
    Token.Index = Token.Index + 1
    IF Token.Index > LEN(Out2) THEN
        ERROR 92
        EXIT DO
    END IF
LOOP
CALL Get.Token
CALL Get.Token
Last.Token = False
END SUB

REM entry to expression parser, each following parser is higher precedence,
REM this routine called by higher precedence routines recursively.

REM precedence of operators:
REM   !, +, -  Not, Unary plus, Unary minus
REM   <<, >>, --, ++, **, //  Dual unary
REM   ^        Power
REM   *, /     Multiplication, Division
REM   \        Integer Division
REM   %        Modulo
REM   +, -     Addition, Subtraction
REM   =, <, >, <>, >=, <=   Relational
REM   |, &, ~, ?, :, #, @, `  Logical (or, and, xor, imp, eqv, nor, non, xan)

SUB Equate (Temp#)
Last.Token = False
Out3 = Nul ' reset string storage
Out4 = Nul ' reset string concatenate storage
Temp# = False ' reset result
Token.Index = 1 ' reset pointer to expression token
CALL Get.Token ' read next token
CALL Parse1(Temp#) ' entry to parse the expression
' parse leftover tokens
WHILE LEN(Strng)
    CALL Parse1(X#)
    ' toss away any unwanted tokens
    IF Last.Token = 3 THEN
        Strng = "<extra token>"
        ERROR 92
    END IF
WEND
END SUB

' logical parser
SUB Parse1 (Temp#)
CALL Parse2(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "|", "&", "~", "?", ":", "#", "@", "`"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    CALL Parse2(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' relational parser
SUB Parse2 (Temp#)
CALL Parse3(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "<", ">", "=", ">=", "<=", "<>"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    CALL Parse3(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' addition/subtraction parser
SUB Parse3 (Temp#)
CALL Parse4(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "+", "-"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    CALL Parse4(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' modulo parser
SUB Parse4 (Temp#)
CALL Parse5(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "%"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    CALL Parse5(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' integer division parser
SUB Parse5 (Temp#)
CALL Parse6(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "\"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    CALL Parse6(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' multiplication/division parser
SUB Parse6 (Temp#)
CALL Parse7(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "*", "/"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    CALL Parse7(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' power parser
SUB Parse7 (Temp#)
CALL Parse7a(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "^"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    CALL Parse7a(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' dual-unary parser
SUB Parse7a (Temp#)
CALL Parse8(Temp#) ' get next operator precedence
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "<<", ">>", "--", "++", "**", "//"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    Token.Stored$ = Out3 ' store current token
    CALL Get.Token ' read next token
    '    CALL Parse8(Temp2#) ' get next operator
    Out4 = Out3 ' reset current string
    Out3 = Token.Stored$ ' restore previous string
    CALL Arith(Token.Parsed$, Temp#, Temp2#) ' calculate expression
    Token.Parsed$ = Strng ' store next token
LOOP
END SUB

' not/unary plus/unary negative parser
SUB Parse8 (Temp#)
Token.Negate$ = Nul ' reset not/unary tokens
Token.Parsed$ = Strng ' store token
' process token
DO
    SELECT CASE Token.Parsed$
        CASE "!", "-", "+", "--", "++"
            ' Nul
        CASE ELSE
            EXIT DO
    END SELECT
    CALL Get.Token ' read next token
    ' store combined not/unary tokens
    Token.Negate$ = Token.Negate$ + Token.Parsed$
    Token.Parsed$ = Strng
LOOP
CALL Parse9(Temp#) ' get next operator precedence
' process the combined operators in reverse
FOR Token.Type = LEN(Token.Negate$) TO 1 STEP -1
    SELECT CASE MID$(Token.Negate$, Token.Type, 1)
        CASE "+"
            ' nul calculation for unary plus
        CASE "-"
            Temp# = -Temp# ' perform negate
        CASE "!" ' not
            Temp# = NOT Temp# ' perform not calculation
    END SELECT
NEXT
END SUB

' string/numeric expression parser,
' routine returns calculated expression string/value,
' calls Parse1 recursively for values inside parenthesis/functions.
SUB Parse9 (Temp#)
SELECT CASE Token ' determine token type
    CASE 0 ' unknown token
        IF Last.Token = 3 THEN
            Strng = "<extra token>"
            ERROR 92
        END IF
        IF Strng = Nul THEN
            Strng = "<missing token>"
        END IF
        ERROR 92
        Last.Token = False
    CASE 1 ' token is symbol
        Token.Parsed$ = Strng
        SELECT CASE Token.Parsed$ ' determine token
            CASE ",", ";" ' separaters
                Last.Token = 3
            CASE CHR$(34) ' parse string
                CALL Parse.Quoted
                Quotes = True
            CASE "(" ' calculate opening parenthesis
                CALL Get.Token ' read next token value inside parenthesis
                IF Strng = ")" THEN
                    Strng = "<empty closing token>"
                    ERROR 92
                END IF
                IF Strng <> ")" THEN
                    DO ' calculate value
                        CALL Parse1(Temp#) ' call parse entry
                    LOOP UNTIL Strng = ")" OR Token = False ' check closing parenthesis
                END IF
                IF Token = False THEN
                    Strng = "<missing closing token>"
                    ERROR 92
                END IF
                CALL Get.Token ' read next token after parenthesis
            CASE "["
                CALL Get.Token
                IF Strng = "]" THEN
                    Strng = "<empty closing token>"
                    ERROR 92
                END IF
                IF Strng <> "]" THEN
                    DO
                        CALL Parse1(Temp#)
                    LOOP UNTIL Strng = "]" OR Token = False
                END IF
                IF Token = False THEN
                    Strng = "<missing closing token>"
                    ERROR 92
                END IF
                CALL Get.Token
            CASE "{"
                CALL Get.Token
                IF Strng = "}" THEN
                    Strng = "<empty closing token>"
                    ERROR 92
                END IF
                IF Strng <> "}" THEN
                    DO
                        CALL Parse1(Temp#)
                    LOOP UNTIL Strng = "}" OR Token = False
                END IF
                IF Token = False THEN
                    Strng = "<missing closing token>"
                    ERROR 92
                END IF
                CALL Get.Token
            CASE ")", "]", "}" ' check token is closing parenthesis
                Strng = "<extra closing token>"
                ERROR 92
        END SELECT
    CASE 2 ' token is numeric value
        CALL Parse.Numeric(Temp#)
    CASE 3 ' token type is alphabetic
        SELECT CASE LEN(Strng) ' check variable type
            CASE 1
                CALL Parse.Alphabetic1(Temp#)
            CASE 2
                CALL Parse.Alphabetic2(Temp#)
            CASE ELSE
                CALL Parse.Alphabetic3(Temp#)
        END SELECT
        CALL Get.Token
END SELECT
END SUB

' remove all white spaces, skip white spaces in quotes.
SUB Remove.Spaces
Var$ = Out2
Temp = False
DO
    Temp = Temp + 1
    IF Temp > LEN(Var$) THEN
        EXIT DO
    END IF
    IF MID$(Var$, Temp, 1) = CHR$(34) THEN
        DO
            Temp = Temp + 1
            IF Temp > LEN(Var$) THEN
                EXIT DO
            END IF
            IF MID$(Var$, Temp, 1) = CHR$(34) THEN
                EXIT DO
            END IF
        LOOP
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
        IF MID$(Var$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
            Var$ = LEFT$(Var$, Temp - 1) + MID$(Var$, Temp + 1)
            Temp = Temp - 1
            EXIT FOR
        END IF
    NEXT
LOOP
Out2 = Var$
END SUB

