REM file: Whereis.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "WHEREIS"

' define boolean values
CONST True = -1
CONST TrueD = -1#
CONST False = 0
CONST FalseD = 0#
CONST FalseS = 0!
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Magenta = 12
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' define filelist constant
CONST RecurseLevel = 8

' declare work variables
DIM SHARED Files.Counter AS INTEGER, Quit.Searching AS INTEGER
DIM SHARED Continuous.Display AS INTEGER, Double.Line AS INTEGER
DIM SHARED Files.Counted AS DOUBLE, More.Display AS INTEGER
DIM SHARED Dirs.Counted AS DOUBLE, Display.Dirs.Counted AS INTEGER
DIM SHARED Dirs.Displayed AS DOUBLE, Drive.Search AS STRING * 1
DIM SHARED Length AS INTEGER, Volumes.Counted AS INTEGER

' declare search work variables
DIM SHARED Search.From.Date AS SINGLE, Search.To.Date AS SINGLE
DIM SHARED Search.From.Time AS SINGLE, Search.To.Time AS SINGLE
DIM SHARED File.Size AS DOUBLE, Recurse.Directories AS INTEGER
DIM SHARED Display.Hidden AS INTEGER, Display.System AS INTEGER
DIM SHARED Display.Readonly AS INTEGER, Display.Archive AS INTEGER
DIM SHARED Display.Attribute AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Display.Volume AS INTEGER, Redirected.Input AS INTEGER
DIM SHARED Display.Any AS INTEGER, No.Display.Archive AS INTEGER
DIM SHARED No.Display.Readonly AS INTEGER, No.Display.System AS INTEGER
DIM SHARED No.Display.Hidden AS INTEGER, No.Display.Any AS INTEGER
DIM SHARED No.Display.Directory AS INTEGER, No.Display.Drive AS INTEGER
DIM SHARED Display.Compress AS INTEGER, No.Display.Compress AS INTEGER
DIM SHARED Display.Encrypt AS INTEGER, No.Display.Encrypt AS INTEGER
DIM SHARED Display.Directory AS INTEGER, Short.Display AS INTEGER
DIM SHARED Wide.Display AS INTEGER, Wide.List AS INTEGER
DIM SHARED Current.Drive AS STRING * 1, Display.Search AS INTEGER
DIM SHARED Remove.Slash AS INTEGER, Skip.Current AS INTEGER
DIM SHARED First.Directory AS INTEGER, Max.Recurse AS INTEGER
DIM SHARED Display.Only.Errors AS INTEGER, Short.Directory AS STRING
DIM SHARED Current.Directory AS STRING, Exclude.File AS INTEGER

' declare file date\time and filesize work variables
DIM SHARED File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
DIM SHARED Total.Bytes AS DOUBLE, Parameters(1) AS STRING * 348
DIM SHARED Search.Size.From AS DOUBLE, Search.Size.To AS DOUBLE
DIM SHARED Search.File.Size, Display.Lowercase AS INTEGER
DIM SHARED Creation.Time AS INTEGER, Short.Filenames AS INTEGER
DIM SHARED Access.Time AS INTEGER, Modified.Time AS INTEGER

' declare nest recursion variables
DIM SHARED Nested.Recurse AS INTEGER, Nested.Levels AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING, Command.Line.Redirect AS STRING
DIM SHARED Command.Work AS STRING, Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER, Debug.Mode AS INTEGER

' declare filelist variables
DIM SHARED Enable.Redirect AS INTEGER, Ignore.Prompts AS INTEGER

' declare dos command work variables
DIM SHARED DOS.Command AS STRING, Exclude.List AS STRING
DIM SHARED Disable.Cmd AS INTEGER

' declare error trap variables
DIM SHARED DataError AS INTEGER, Error.Flag AS INTEGER

' dimension arrays
REDIM Parameters(1 TO 12) AS STRING * 348

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION GetDiskFreeSpaceA& (f$, sectors&, bytes&, free&, total&)
    FUNCTION GetDiskFreeSpaceExA& (filename$, free AS _UNSIGNED _INTEGER64, total AS _UNSIGNED _INTEGER64, free2 AS _UNSIGNED _INTEGER64)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetFileAttributes& (f$)
    FUNCTION SetFileAttributes& (f$, BYVAL a&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetShortPathName& (InP$, OutP$, BYVAL length&)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

DECLARE DYNAMIC LIBRARY "advapi32"
    FUNCTION FileEncryptionStatusA% (f$, f&)
END DECLARE

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING
DIM SHARED finddatatemp AS WIN32_FIND_DATAA

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' store command line
Command.Line = RTRIM$(COMMAND$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' get current drive
Current.Drive = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "File spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' get exclude switch
Exclude.List = NUL
Imbedded = INSTR(Command.Line, "/(")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Exclude.List = NUL
    Next.Bracket = INSTR(Imbedded + 2, Command.Line, ")")
    IF Next.Bracket THEN
        Exclude.List = MID$(Command.Line, Imbedded + 2, Next.Bracket - Imbedded - 2)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Next.Bracket + 1)
    END IF
    IF Exclude.List = NUL THEN
        GOTO Boot.Error
    END IF
END IF
Command.Line = RTRIM$(Command.Line)

' get dos command
DOS.Command = NUL
Imbedded = INSTR(Command.Line, "/[")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    DOS.Command = NUL
    Next.Bracket = INSTR(Imbedded + 2, Command.Line, "]")
    IF Next.Bracket THEN
        DOS.Command = MID$(Command.Line, Imbedded + 2, Next.Bracket - Imbedded - 2)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Next.Bracket + 1)
    END IF
    IF DOS.Command = NUL THEN
        GOTO Boot.Error
    END IF
END IF
Command.Line = RTRIM$(Command.Line)

' edit special DOS command parameters
Imbedded = INSTR(DOS.Command, "//1")
WHILE Imbedded
    DOS.Command = LEFT$(DOS.Command, Imbedded - 1) + ">" + MID$(DOS.Command, Imbedded + 3)
    Imbedded = INSTR(DOS.Command, "//1")
WEND
Imbedded = INSTR(DOS.Command, "//2")
WHILE Imbedded
    DOS.Command = LEFT$(DOS.Command, Imbedded - 1) + "<" + MID$(DOS.Command, Imbedded + 3)
    Imbedded = INSTR(DOS.Command, "//2")
WEND
Imbedded = INSTR(DOS.Command, "//3")
WHILE Imbedded
    DOS.Command = LEFT$(DOS.Command, Imbedded - 1) + "|" + MID$(DOS.Command, Imbedded + 3)
    Imbedded = INSTR(DOS.Command, "//3")
WEND
Imbedded = INSTR(DOS.Command, "//4")
WHILE Imbedded
    DOS.Command = LEFT$(DOS.Command, Imbedded - 1) + "%" + MID$(DOS.Command, Imbedded + 3)
    Imbedded = INSTR(DOS.Command, "//4")
WEND
Imbedded = INSTR(DOS.Command, "//5")
WHILE Imbedded
    DOS.Command = LEFT$(DOS.Command, Imbedded - 1) + "]" + MID$(DOS.Command, Imbedded + 3)
    Imbedded = INSTR(DOS.Command, "//5")
WEND

' check command line switches
Display.Archive = ParseLine("//A")
Display.Hidden = ParseLine("//H")
Display.Directory = ParseLine("//I")
Display.Readonly = ParseLine("//O")
Display.System = ParseLine("//S")
Display.Any = ParseLine("//X")

Display.Compress = ParseLine("//M1")
Display.Encrypt = ParseLine("//M2")

No.Display.Archive = ParseLine("/A")
No.Display.Hidden = ParseLine("/H")
No.Display.Directory = ParseLine("/I")
No.Display.Readonly = ParseLine("/O")
No.Display.System = ParseLine("/S")
No.Display.Any = ParseLine("/X")

No.Display.Compress = ParseLine("/M1")
No.Display.Encrypt = ParseLine("/M2")

No.Display.Drive = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Short.Display = ParseLine("/E")
Display.Search = ParseLine("/G")
Skip.Current = ParseLine("/J")
Short.Filenames = ParseLine("/K")
Double.Line = ParseLine("/L")
Disable.Cmd = ParseLine("/P")
Display.Dirs.Counted = ParseLine("/Q")
Recurse.Directories = ParseLine("/R")
Remove.Slash = ParseLine("/U")
Display.Volume = ParseLine("/V")
Wide.Display = ParseLine("/W")
Display.Lowercase = ParseLine("/Y")
Display.Only.Errors = ParseLine("/Z1")
Display.Errors = ParseLine("/Z")
Enable.Redirect = ParseLine("/@")
Ignore.Prompts = ParseLine("/#")
Debug.Mode = ParseLine("/-=")

' check wide display
IF Wide.Display THEN
    Double.Line = False
    Short.Display = True
    Short.Filenames = True
END IF

' set attribute display variable
Display.Attribute = False
IF Display.Archive OR No.Display.Archive THEN
    Display.Attribute = True
END IF
IF Display.Hidden OR No.Display.Hidden THEN
    Display.Attribute = True
END IF
IF Display.Readonly OR No.Display.Readonly THEN
    Display.Attribute = True
END IF
IF Display.System OR No.Display.System THEN
    Display.Attribute = True
END IF
IF Display.Any OR No.Display.Any THEN
    Display.Attribute = True
END IF
IF Display.Directory OR No.Display.Directory THEN
    Display.Attribute = True
END IF
IF Display.Compress OR No.Display.Compress THEN
    Display.Attribute = True
END IF
IF Display.Encrypt OR No.Display.Encrypt THEN
    Display.Attribute = True
END IF

' reset file counter variable
Dirs.Counted = FalseD
Dirs.Displayed = FalseD
Files.Counted = FalseD
More.Display = False
   
' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/D")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    D$ = MID$(Command.Line, Imbedded + 2, 21)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
    IF LEN(D$) <> 21 THEN
        GOTO Boot.Error
    END IF
    IF MID$(D$, 11, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    S$ = RIGHT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    IF Search.From.Date < False OR Search.To.Date < False THEN
        GOTO Boot.Error
    END IF
END IF
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    T$ = MID$(Command.Line, Imbedded + 2, 17)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
    IF LEN(T$) <> 17 THEN
        GOTO Boot.Error
    END IF
    IF MID$(T$, 9, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.From.Time = T1! * 2048 + T2! * 32 + T3!
    S$ = RIGHT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.To.Time = T1! * 2048 + T2! * 32 + T3!
    IF Search.From.Time < False OR Search.To.Time < False THEN
        GOTO Boot.Error
    END IF
END IF

' get file size from command line
Search.File.Size = False
Search.Size.From = FalseD
Search.Size.To = FalseD
Imbedded = INSTR(UCASE$(Command.Line), "/F")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Search.File.Size = True
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Search.Size.From = Var#
    IF MID$(Command.Line, Imbedded, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    GOSUB Get.Numeric
    Search.Size.To = Var#
    Search.Size.From = Search.Size.From * 1024#
    Search.Size.To = Search.Size.To * 1024#
END IF

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
IF Creation.Time = False THEN
    IF Access.Time = False THEN
        IF Modified.Time = False THEN
            Modified.Time = True
        END IF
    END IF
END IF

' get nested switch from command line
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = CINT(Var#)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' reset work variables
Files.Counter = False
Nested.Levels = False
Quit.Searching = False
Total.Bytes = False
Files.Counted = False
Dirs.Counted = False
Volumes.Counted = False

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GOSUB Header

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF
    Command.Line = LTRIM$(Command.Line)
    Command.Line = RTRIM$(Command.Line)

    ' locate filelist character
    Flag = False
    Command.Out$ = Command.Work
    Command.Out2$ = NUL
    IF MID$(Command.Out$, 2, 1) = ":" THEN
        Command.Out2$ = LEFT$(Command.Out$, 2)
        Command.Out$ = MID$(Command.Out$, 3)
    END IF
    IF LEFT$(Command.Out$, 1) = "@" THEN
        Flag = True
        Command.Out$ = MID$(Command.Out$, 2)
    ELSE
        FOR Var = LEN(Command.Out$) TO 1 STEP -1
            IF MID$(Command.Out$, Var, 1) = "\" THEN
                Char$ = MID$(Command.Out$, Var + 1)
                IF LEFT$(Char$, 1) = "@" THEN
                    Flag = True
                    Command.Out$ = LEFT$(Command.Out$, Var) + MID$(Char$, 2)
                END IF
                EXIT FOR
            END IF
        NEXT
    END IF
    IF LEN(Command.Out2$) THEN
        Command.Out$ = Command.Out2$ + Command.Out$
    END IF

    ' process work filename
    IF Flag AND Enable.Redirect THEN

        ' concatenate work filename
        Var$ = Command.Work ' command line filename
        FOR Var = LEN(Var$) TO 1 STEP -1
            IF MID$(Var$, Var, 1) = "\" THEN
                Var$ = MID$(Var$, Var + 1)
                EXIT FOR
            END IF
        NEXT
        IF MID$(Var$, 2, 1) = ":" THEN
            Var$ = MID$(Var$, 3)
        END IF
        Filename2$ = Var$
        Var$ = MID$(Var$, 2)
        Var2$ = Command.Out$
        FOR Var = LEN(Var2$) TO 1 STEP -1
            IF MID$(Var2$, Var, 1) = "\" THEN
                Var2$ = LEFT$(Var2$, Var)
                Var$ = Var2$ + Var$
                EXIT FOR
            END IF
        NEXT

        ' check excluded file
        IF LEN(Exclude.List) THEN
            Filename1$ = UCASE$(RTRIM$(Exclude.List))
            Filename2$ = UCASE$(RTRIM$(Filename2$))
            CALL CheckExcluded(Filename1$, Filename2$)
            IF Exclude.File THEN
                Max.Recurse = 0
                CALL ProcessCommand
                GOTO Next.Filename
            END IF
        END IF

        ' prompt for filelist
        IF Ignore.Prompts = False THEN

            ' prompt to use filelist
            Prompt$ = "Use '" + LCASE$(Var$) + "' as filelist(y/n/q)?"
            CALL MorePrompt(Prompt$, "ynq", Outpt$)
            SELECT CASE Outpt$
                CASE "q"
                    Quit.Searching = True
                    GOTO Next.Filename
                CASE "n"
                    Max.Recurse = 0
                    CALL ProcessCommand
                    GOTO Next.Filename
            END SELECT
        END IF

        ' open work filename
        DataError = False
        Error.Flag = True
        CLOSE #1
        OPEN Command.Out$ FOR INPUT SHARED AS #1
        Error.Flag = False

        ' check error flag
        IF DataError THEN
            CALL DisplayError("Error opening filelist.")
        ELSE
            ' process input filenames
            Max.Recurse = 0
            DO UNTIL EOF(1)
                ' get next filename
                LINE INPUT #1, Command.Work

                ' process search filename
                Command.Work = RTRIM$(Command.Work)
                IF LEN(Command.Work) THEN
                    CALL ProcessCommand
                    ' check recurse error
                    IF Max.Recurse >= RecurseLevel THEN
                        EXIT DO
                    END IF
                END IF
            LOOP
        END IF
    ELSE
        ' process remaining filenames
        Max.Recurse = 0
        CALL ProcessCommand
    END IF

    ' continue label
    Next.Filename:

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

End.Whereis:

' display end program
IF Continuous.Display = False THEN
    IF Display.Search = False THEN
        IF Double.Line = False THEN
            IF Wide.List THEN
                Wide.List = False
                PRINT
            END IF
        END IF
    END IF
    COLOR Yellow, Black
    IF Display.Volume THEN
        Total$ = FormatString$(CDBL(Volumes.Counted))
        PRINT "Volumes counted: "; Total$
    ELSE
        IF Display.Dirs.Counted = False THEN
            Total$ = FormatString$(Dirs.Counted)
            PRINT "Directories counted: "; Total$
        ELSE
            Total$ = FormatString$(Dirs.Displayed)
            PRINT "Directories displayed: "; Total$
        END IF
        Total$ = FormatString$(Files.Counted)
        PRINT "Files counted: "; Total$
        IF Double.Line THEN
            Total$ = FormatString$(Total.Bytes)
            PRINT "Bytes counted: "; Total$
        END IF
    END IF
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF

' reset color
COLOR Plain, Black
END

' process command work
' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Whereis v1.0a: File search utility;"
END IF
RETURN

' display program usage
Boot.Usage:
Display.Page = 1
DO
    SELECT CASE Display.Page
        CASE 1
            GOSUB Display.Page.One
        CASE 2
            GOSUB Display.Page.Two
    END SELECT
    Prompt$ = "Press 1, 2, or q to quit:"
    CALL MorePrompt(Prompt$, "12q", Outpt$)
    SELECT CASE Outpt$
        CASE "1"
            Display.Page = 1
        CASE "2"
            Display.Page = 2
        CASE "q"
            COLOR Plain, Black
            RETURN
    END SELECT
LOOP
COLOR Plain, Black
PRINT "Exiting to DOS:"
END

Display.Page.One:
GOSUB Display.Header
PRINT "  /b  suppress drive letter      /c  continuous display"
PRINT "  /e  short filename display     /g  display search directories"
PRINT "  /j  skip current directory     /k  use 8.3 short filenames"
PRINT "  /l  double line display        /nxxx  nested directories"
PRINT "  /q  directory count override   /r  recurse directories"
PRINT "  /u  remove trailing slash      /v  display volume label"
PRINT "  /w  wide file list             /y  display lowercase"
PRINT "  /z  no error messages          /z1 display only errors"
PRINT "display ranges:"
PRINT "  /1  creation, /2  last access, /3  modify time"
PRINT "  /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
PRINT "  /t  is range of file times in form hh:mm:ss-hh:mm:ss"
PRINT "  /f  is range of file sizes in form xxx-xxx in kilobytes"
RETURN

Display.Page.Two:
GOSUB Display.Header
PRINT "  filelist switches:"
PRINT "    /@  enable filelists   /#  ignore filelist prompts"
PRINT "  exclude file list switch:"
PRINT "    /(<filename.ext>)"
PRINT "      excludes files containing ? and * characters."
PRINT "  display file attributes: // prefix for files with, / prefix for files without"
PRINT "    a  archive, h  hidden, i  directory, o  read-only, s  system"
PRINT "    m1  compressed,  m2  encrypted, x  none"
PRINT "  DOS command: /[<command>]"
PRINT "    with command replacement parameters: (use /p for /c override);"
PRINT "      %1 = d:, %2 = d:\, %3 = d:\pathname, %4 = d:\pathname\"
PRINT "      %5 = d:\pathname\filename.ext, %6 = \pathname, %7 = \pathname\"
PRINT "      %8 = \pathname\filename.ext, %9 = filename.ext, %a = filename"
PRINT "      %b = .ext, %c = ext, //1 = >, //2 = <, //3 = |, //4 = %, //5 = ]"
RETURN

Display.Header:
CLS
COLOR White, Black
PRINT "Whereis v1.0a: File search utility;"
COLOR Yellow, Black
PRINT "Usage:"
PRINT "  Whereis [@][d:\path\filename.ext][//ahiosx][/bcdefgjklnpqrtuvwyz@#][/123]"
PRINT "Where:"
RETURN

Get.Numeric:
Var# = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var# = Var# * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Whereis /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
IF Error.Flag THEN
    RESUME NEXT
END IF
IF Display.Errors THEN
    Error.Level = True
    RESUME NEXT
END IF
IF Wide.List THEN
    Wide.List = False
    PRINT
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Whereis
    CASE "c"
        RESUME NEXT
END SELECT
END 0

REM constructs and checks filelist filename exists.
REM   returns ambiguated filename.
FUNCTION FILELISTEXISTS$ (Var$)
' construct filelist filename.
VarX$ = Var$
V = INSTR(VarX$, "@")
IF V = 0 THEN
    FILELISTEXISTS$ = NUL
    EXIT FUNCTION
END IF
FOR V = LEN(VarX$) TO 1 STEP -1
    IF MID$(VarX$, V, 1) = "@" THEN
        EXIT FOR
    END IF
NEXT
IF V = 1 THEN ' @filelist.txt
    VarX$ = MID$(VarX$, V + 1)
ELSE
    IF V > 1 THEN
        IF MID$(VarX$, V - 1, 1) = "\" THEN ' \dos\@filelist.txt
            VarX$ = LEFT$(VarX$, V - 1) + MID$(VarX$, V + 1)
        ELSE
            IF MID$(VarX$, V - 1, 1) = ":" THEN ' c:@filelist.txt
                VarX$ = LEFT$(VarX$, V - 1) + MID$(VarX$, V + 1)
            END IF
        END IF
    END IF
END IF
' check filelist filename exists.
IF INSTR(V, VarX$, "\") THEN ' c:\@path\filename.ext
    FILELISTEXISTS$ = NUL
ELSE
    IF _FILEEXISTS(VarX$) = 0 THEN
        FILELISTEXISTS$ = NUL
    ELSE
        FILELISTEXISTS$ = VarX$
    END IF
END IF
END FUNCTION

SUB ProcessCommand
' check recurse error
IF Max.Recurse >= RecurseLevel THEN
    EXIT SUB
END IF

' store current drive
IF MID$(Command.Work, 2, 1) = ":" THEN
    Drive.Search = LEFT$(Command.Work, 1)
    Command.Work = MID$(Command.Work, 3)
ELSE
    Drive.Search = Current.Drive
END IF
Drive.Search = UCASE$(Drive.Search)

' store current directory
Directory.Search$ = ""
Imbedded1 = INSTR(Command.Work, "\")
Imbedded2 = Imbedded1
WHILE Imbedded1
    Imbedded2 = Imbedded1
    Imbedded1 = INSTR(Imbedded1 + 1, Command.Work, "\")
WEND
IF Imbedded2 THEN
    Directory.Search$ = LEFT$(Command.Work, Imbedded2)
    Command.Work = MID$(Command.Work, Imbedded2 + 1)
END IF
IF Directory.Search$ = "" THEN
    IF LEFT$(Current.Directory, 2) = "\\" THEN
        Directory.Search$ = Current.Directory
    ELSE
        IF Drive.Search = Current.Drive THEN
            Directory.Search$ = MID$(Current.Directory, 3)
        ELSE
            Directory.Search$ = "\"
        END IF
    END IF
END IF
IF RIGHT$(Directory.Search$, 1) <> "\" THEN
    Directory.Search$ = Directory.Search$ + "\"
END IF
   
' get filename spec
Filename.Search$ = Command.Work
IF Filename.Search$ = NUL THEN
    Filename.Search$ = "*.*"
END IF
Command.Work = NUL
   
' display search filename
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        PRINT "Searching: " + Directory.Search$ + Filename.Search$
    ELSE
        IF Display.Volume THEN
            PRINT "Searching: " + Drive.Search + ":"
        ELSE
            IF LEFT$(Directory.Search$, 1) = "@" THEN
                PRINT "Searching: " + Directory.Search$ + Filename.Search$
            ELSE
                PRINT "Searching: " + Drive.Search + ":" + Directory.Search$ + Filename.Search$
            END IF
        END IF
    END IF
    Files.Counter = Files.Counter + 1
END IF

' call routine to search for files
IF Display.Volume THEN
    CALL DisplayVolume(Drive.Search)
ELSE
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$, Filename.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Drive.Search$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$, Filename.Search$)
        END IF
    END IF
END IF
END SUB

' subroutine to access directories
SUB Directories (Directory.Search$, Filename.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
DIM Recurse.Temp AS INTEGER

' check to quit
IF Quit.Searching THEN
    EXIT SUB
END IF

' check recurse error
IF Max.Recurse >= RecurseLevel THEN
    EXIT SUB
END IF

' display directories searched
IF Display.Search THEN
    ' check skip directory
    Flag = True
    IF Skip.Current THEN
        IF First.Directory = False THEN
            First.Directory = True
            Flag = False
        END IF
    END IF
    IF Flag THEN
        ' count only directories displayed
        Dirs.Displayed = Dirs.Displayed + 1#
        ' store directory
        Filename$ = Directory.Search$
        IF Filename$ <> "" THEN
            IF Remove.Slash THEN
                Filename$ = LEFT$(Filename$, LEN(Filename$) - 1)
            END IF
        END IF
        ' store drive letter
        IF No.Display.Drive = False THEN
            IF LEFT$(Filename$, 2) <> "\\" THEN
                Filename$ = Drive.Search + ":" + Filename$
            END IF
        END IF
        ' store directory
        Outpt$ = Filename$
        Length = LEN(Outpt$)
        ' calculate display lines
        CALL PageCount
        ' check overflow past line 22
        IF Files.Counter > 22 THEN
            CALL PagePrompt
            IF Quit.Searching THEN
                EXIT SUB
            END IF
            ' reset display lines
            CALL PageCount
        END IF
        ' display directory
        COLOR Yellow, Black
        PRINT Outpt$
        ' check paginate
        CALL PagePrompt
        IF Quit.Searching THEN
            EXIT SUB
        END IF
    END IF
END IF

' store directory asciiz
IF LEFT$(Directory.Search$, 2) <> "\\" THEN
    IF LEFT$(Directory.Search$, 1) = "@" THEN
        ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)
    ELSE
        ASCIIZ = Drive.Search + ":" + Directory.Search$ + "*.*" + CHR$(0)
    END IF
ELSE
    ASCIIZ = Directory.Search$ + "*.*" + CHR$(0)
END IF

' start directory search
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
    ' search directory names
    CALL Filenames(Directory.Search$, Filename.Search$)

    ' check to recurse directories
    IF Recurse.Directories THEN

        ' recurse directories
        DO
            ' check to quit
            IF Quit.Searching THEN
                EXIT DO
            END IF

            ' check max recurse levevl
            IF Max.Recurse >= RecurseLevel THEN
                EXIT DO
            END IF

            ' check directory attribute
            Attribute = finddata.dwFileAttributes

            ' check for directory
            IF (Attribute AND &H10) = &H10 THEN

                ' store directory name
                Directory$ = finddata.cFileName
                Directory$ = LEFT$(Directory$, INSTR(Directory$, CHR$(0)) - 1)

                ' check directory name
                IF Directory$ <> "." AND Directory$ <> ".." THEN

                    ' check unicode
                    IF INSTR(Directory$, "?") THEN
                        Directory$ = finddata.cAlternateFileName
                        V = INSTR(Directory$, CHR$(0))
                        IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                    END IF

                    ' make next search directory
                    Next.Directory$ = Directory.Search$ + Directory$ + "\"

                    ' check recursion levels
                    Recursion% = True
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels + 1
                        IF Nested.Levels >= Nested.Recurse THEN
                            Recursion% = False
                        END IF
                    END IF

                    ' recursively search subdirectories
                    IF Recursion% THEN
                        CALL Directories(Next.Directory$, Filename.Search$)
                    END IF
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels - 1
                    END IF
                END IF
            END IF
        LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    END IF
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to access filenames in directory
SUB Filenames (Directory.Search$, Filename.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
DIM Recurse.Temp AS INTEGER

' check to quit
IF Quit.Searching THEN
    EXIT SUB
END IF

' check recurse error
IF Max.Recurse >= RecurseLevel THEN
    EXIT SUB
END IF

' make filename
Var1$ = Directory.Search$
IF LEFT$(Var1$, 2) <> "\\" THEN
    IF LEFT$(Var1$, 1) = "\" THEN
        Var1$ = Drive.Search + ":" + Var1$
    END IF
END IF
Var2$ = Filename.Search$
IF LEFT$(Var2$, 1) = "@" AND Enable.Redirect THEN
    Var2$ = MID$(Var2$, 2)
END IF

Var1$ = RTRIM$(Var1$)
Var2$ = RTRIM$(Var2$)

ASCIIZ = Var1$ + Var2$ + CHR$(0)
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN
    ' search filenames
    DO
        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF

        ' store file data
        finddatatemp = finddata

        ' check directory attribute
        Attribute = finddata.dwFileAttributes

        ' check for directory
        IF (Attribute AND &H10) = &H10 THEN
            ' increment directories actually searched
            Dirs.Counted = Dirs.Counted + 1#
        END IF

        ' store filename
        Filename$ = finddata.cFileName
        Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)

        ' store short filename
        Short.Directory$ = finddata.cAlternateFileName
        V = INSTR(Short.Directory$, CHR$(0))
        IF V THEN Short.Directory$ = LEFT$(Short.Directory$, V - 1)
        IF Short.Directory$ = NUL THEN
            Short.Directory$ = finddata.cFileName
            V = INSTR(Short.Directory$, CHR$(0))
            IF V THEN Short.Directory$ = LEFT$(Short.Directory$, V - 1)
        END IF

        ' check filename
        IF Filename$ <> "." AND Filename$ <> ".." THEN
            ' store file size
            File.Size = finddata.nFileSizeHigh * &H100000000~&& OR finddata.nFileSizeLow

            ' recursively call filelists
            IF LEFT$(Filename.Search$, 1) = "@" AND Enable.Redirect THEN
                Filelist.Filename$ = Directory.Search$ + Filename$

                ' check recursion level
                Max.Recurse = Max.Recurse + 1
                IF Max.Recurse >= RecurseLevel THEN
                    CALL DisplayError("Recursive filelist error.")
                    Flag = False
                    EXIT DO
                END IF

                ' reset prompt flag
                Flag = True

                ' concatenate work filename
                Var$ = Filename$ ' command line filename
                FOR Var = LEN(Var$) TO 1 STEP -1
                    IF MID$(Var$, Var, 1) = "\" THEN
                        Var$ = MID$(Var$, Var + 1)
                        EXIT FOR
                    END IF
                NEXT
                IF MID$(Var$, 2, 1) = ":" THEN
                    Var$ = MID$(Var$, 3)
                END IF
                Filename2$ = Var$
                Var2$ = Filelist.Filename$
                FOR Var = LEN(Var2$) TO 1 STEP -1
                    IF MID$(Var2$, Var, 1) = "\" THEN
                        Var2$ = LEFT$(Var2$, Var)
                        Var$ = Var2$ + Var$
                        EXIT FOR
                    END IF
                NEXT

                ' check excluded file
                IF LEN(Exclude.List) THEN
                    Filename1$ = UCASE$(RTRIM$(Exclude.List))
                    Filename2$ = UCASE$(RTRIM$(Filename2$))
                    CALL CheckExcluded(Filename1$, Filename2$)
                    IF Exclude.File THEN
                        Flag = False
                    END IF
                END IF

                ' prompt for filelist
                IF Ignore.Prompts = False THEN

                    ' prompt to use filelist
                    IF Flag THEN
                        Prompt$ = "Use '" + LCASE$(Var$) + "' as filelist(y/n/q)?"
                        CALL MorePrompt(Prompt$, "ynq", Outpt$)
                        SELECT CASE Outpt$
                            CASE "q"
                                Quit.Searching = True
                                Flag = False
                            CASE "n"
                                Flag = False
                        END SELECT
                    END IF
                END IF

                ' open work filename
                IF Flag THEN
                    V = FREEFILE
                    DataError = False
                    Error.Flag = True
                    OPEN Filelist.Filename$ FOR INPUT SHARED AS #V
                    Error.Flag = False

                    ' check error flag
                    IF DataError THEN
                        CALL DisplayError("Error opening filelist.")
                    ELSE
                        ' process input filenames
                        DO UNTIL EOF(V)
                            LINE INPUT #V, Next.Filename$
                            Next.Filename$ = RTRIM$(Next.Filename$)
                            IF LEN(Next.Filename$) THEN
                                ' process search filename
                                Command.Work = Next.Filename$
                                CALL ProcessCommand
                                ' check recurse error
                                IF Max.Recurse >= RecurseLevel THEN
                                    EXIT DO
                                END IF
                            END IF
                        LOOP
                        CLOSE #V
                    END IF
                END IF
            ELSE
                ' display filename info
                CALL DisplayFiles(Directory.Search$, Filename$)
            END IF
        END IF

        ' check to quit
        IF Quit.Searching THEN
            EXIT DO
        END IF

        ' check max recurse levevl
        IF Max.Recurse >= RecurseLevel THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
END SUB

' subroutine to display volume information
SUB DisplayVolume (Var$)
' check drive exists
D = ASC(Var$) - 64
IF DRIVEEXISTS(D) THEN
    EXIT SUB
END IF

' increment volume counter
Volumes.Counted = Volumes.Counted + 1

' get drive info.
VarX$ = Var$ + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)

' display volume information
COLOR Yellow, Black
PRINT Var$; ":";
IF R = 0 THEN
    PRINT DriveType;
    IF Double.Line THEN
        COLOR Red, Black
        PRINT " (????-????)";
        COLOR White, Black
        PRINT " [????]";
    END IF
    PRINT
    EXIT SUB
END IF

' volume label
Outpt$ = RTRIM$(Vname$)
v = INSTR(Outpt$, CHR$(0))
IF v THEN Outpt$ = LEFT$(Outpt$, v - 1)
IF Outpt$ = "" THEN Outpt$ = "<none>"
PRINT Outpt$;
IF Double.Line = False THEN
    PRINT
    EXIT SUB
END IF

' display volume serial number
COLOR Red, Black
Outpt$ = LEFT$(HEX$(serial~&), 4) + "-" + RIGHT$(HEX$(serial~&), 4)
PRINT " ("; Outpt$; ")";

' display volume system type.
COLOR White, Black
Outpt$ = RTRIM$(Fname$)
v = INSTR(Outpt$, CHR$(0))
IF v THEN Outpt$ = LEFT$(Outpt$, v - 1)
PRINT " ["; Outpt$; "]"
END SUB

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = ""
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = 0
ELSE
    DRIVEEXISTS = -1
END IF
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' subroutine to display a filename
SUB DisplayFiles (Search.Directory$, Search.Filename$)
' declare subroutine variables
DIM Attribute AS _UNSIGNED LONG
DIM ASCIIZ AS STRING * 260

' get file attributes
Attribute = finddatatemp.dwFileAttributes

' make filename
File.List$ = Search.Directory$ + Search.Filename$
IF LEFT$(File.List$, 2) <> "\\" THEN
    File.List$ = Drive.Search$ + ":" + File.List$
END IF
ASCIIZ = File.List$ + CHR$(0)

' check file attribute
IF Display.Attribute THEN

    ' check for readonly file
    IF Display.Readonly THEN
        IF (Attribute AND 1) <> 1 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Readonly THEN
        IF (Attribute AND 1) = 1 THEN
            EXIT SUB
        END IF
    END IF

    ' check for hidden file
    IF Display.Hidden THEN
        IF (Attribute AND 2) <> 2 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Hidden THEN
        IF (Attribute AND 2) = 2 THEN
            EXIT SUB
        END IF
    END IF

    ' check for system file
    IF Display.System THEN
        IF (Attribute AND 4) <> 4 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.System THEN
        IF (Attribute AND 4) = 4 THEN
            EXIT SUB
        END IF
    END IF

    ' check for directory file
    IF Display.Directory THEN
        IF (Attribute AND &H10) <> &H10 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Directory THEN
        IF (Attribute AND &H10) = &H10 THEN
            EXIT SUB
        END IF
    END IF

    ' check for archive file
    IF Display.Archive THEN
        IF (Attribute AND &H20) <> &H20 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Archive THEN
        IF (Attribute AND &H20) = &H20 THEN
            EXIT SUB
        END IF
    END IF

    ' check for compressed file
    IF Display.Compress THEN
        IF (Attribute AND &H800) <> &H800 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Compress THEN
        IF (Attribute AND &H800) = &H800 THEN
            EXIT SUB
        END IF
    END IF

    ' check for encrypted file
    IF Display.Encrypt THEN
        IF (Attribute AND &H4000) <> &H4000 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Encrypt THEN
        IF (Attribute AND &H4000) = &H4000 THEN
            EXIT SUB
        END IF
    END IF

    ' check for no attributes
    IF Display.Any THEN
        IF (Attribute AND 1) = 1 THEN
            EXIT SUB
        END IF
        IF (Attribute AND 2) = 2 THEN
            EXIT SUB
        END IF
        IF (Attribute AND 4) = 4 THEN
            EXIT SUB
        END IF
        IF (Attribute AND &H10) = &H10 THEN
            EXIT SUB
        END IF
        IF (Attribute AND &H20) = &H20 THEN
            EXIT SUB
        END IF
        IF (Attribute AND &H800) = &H800 THEN
            EXIT SUB
        END IF
        IF (Attribute AND &H4000) = &H4000 THEN
            EXIT SUB
        END IF
    END IF
    IF No.Display.Any THEN
        IF (Attribute AND 1) = False THEN
            IF (Attribute AND 2) = False THEN
                IF (Attribute AND 4) = False THEN
                    IF (Attribute AND &H10) = False THEN
                        IF (Attribute AND &H20) = False THEN
                            IF (Attribute AND &H800) = &H0 THEN
                                IF (Attribute AND &H4000) = &H0 THEN
                                    EXIT SUB
                                END IF
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF

' check file size
IF Search.File.Size THEN
    IF Search.Size.From = FalseD AND Search.Size.To = FalseD THEN
        IF File.Size <> FalseD THEN
            EXIT SUB
        END IF
    ELSE
        IF Search.Size.From > FalseD OR Search.Size.To > FalseD THEN
            IF Search.Size.From > FalseD THEN
                IF Search.Size.To = FalseD THEN
                    IF File.Size < Search.Size.From THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From = FalseD THEN
                IF Search.Size.To > FalseD THEN
                    IF File.Size > Search.Size.To THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
            IF Search.Size.From <= Search.Size.To THEN
                IF File.Size < Search.Size.From OR File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
            IF Search.Size.From > Search.Size.To THEN
                IF File.Size < Search.Size.From AND File.Size > Search.Size.To THEN
                    EXIT SUB
                END IF
            END IF
        END IF
    END IF
END IF

' store file date and time
IF Creation.Time THEN
    x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
ELSE
    IF Access.Time THEN
        x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
        GOSUB Convert.Date
        GOSUB Convert.Time
    ELSE
        IF Modified.Time THEN
            x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
            GOSUB Convert.Date
            GOSUB Convert.Time
        END IF
    END IF
END IF

' check date\time range
IF Search.From.Date OR Search.To.Date THEN
    IF Debug.Mode THEN
        PRINT "Searchdate:";Search.From.Date;"-";Search.To.Date
        PRINT "Fileworkdate:";File.Work.Date
    END IF
    IF File.Work.Date < Search.From.Date THEN
        EXIT SUB
    END IF
    IF File.Work.Date > Search.To.Date THEN
        EXIT SUB
    END IF
END IF
IF Search.From.Time OR Search.To.Time THEN
    IF Debug.Mode THEN
        PRINT "Searchtime:";Search.From.Time;"-";Search.To.Time
        PRINT "Fileworktime:";File.Work.Time
    END IF
    IF File.Work.Time < Search.From.Time THEN
        EXIT SUB
    END IF
    IF File.Work.Time > Search.To.Time THEN
        EXIT SUB
    END IF
END IF

' make filename
File.List$ = Search.Filename$
Display.Filename$ = Search.Filename$
IF Short.Filenames THEN
    Display.Filename$ = Short.Directory$
END IF
IF Short.Display THEN
    File.List$ = Display.Filename$
ELSE
    File.List$ = Search.Directory$ + Display.Filename$
END IF
IF No.Display.Drive = False THEN
    IF LEFT$(File.List$, 2) <> "\\" THEN
        File.List$ = Drive.Search + ":" + File.List$
    END IF
END IF
IF LEFT$(Search.Directory$, 2) = "\\" THEN
    IF MID$(File.List$, 2, 1) = ":" THEN
        File.List$ = MID$(File.List$, 3)
    END IF
END IF
IF (Attribute AND &H10) = &H10 THEN
    IF Display.Only.Errors = False THEN
        IF Remove.Slash = False THEN
            File.List$ = File.List$ + "\"
        END IF
    END IF
END IF

' check excluded file
IF LEN(Exclude.List) THEN
    Filename1$ = UCASE$(RTRIM$(Exclude.List))
    Filename2$ = UCASE$(RTRIM$(Search.Filename$))
    CALL CheckExcluded(Filename1$, Filename2$)
    IF Exclude.File THEN
        EXIT SUB
    END IF
END IF

' check for directory bit
IF (Attribute AND &H10) <> &H10 THEN
    ' increment files counted
    Files.Counted = Files.Counted + 1#
    Total.Bytes = Total.Bytes + File.Size
END IF

' display directory/filename
IF Display.Search = False THEN
    ' check for directory bit
    IF (Attribute AND &H10) = &H10 THEN
        Dirs.Displayed = Dirs.Displayed + 1#
    END IF

    ' format filename
    IF Display.Lowercase THEN
        Outpt$ = LCASE$(File.List$)
    ELSE
        IF Short.Filenames THEN
            Outpt$ = UCASE$(File.List$)
        ELSE
            Outpt$ = RTRIM$(File.List$)
        END IF
    END IF

    ' reset line length
    Length = LEN(Outpt$)

    ' display wide format
    IF Wide.Display THEN
        COLOR Yellow, Black
        IF LEN(Outpt$) > 15 THEN
            Outpt$ = LEFT$(Outpt$, 14) + "~"
        END IF
        Outpt$ = LEFT$(Outpt$, 15)
        Outpt$ = Outpt$ + SPACE$(16 - LEN(Outpt$))
        PRINT Outpt$;
        Wide.List = Wide.List + 1
        IF Wide.List = 5 THEN
            Wide.List = False
            PRINT
            Files.Counter = Files.Counter + 1
        END IF
    ELSE
        ' check past line 22
        CALL PageCount
        IF Files.Counter > 22 THEN
            CALL PagePrompt
            IF Quit.Searching THEN
                EXIT SUB
            END IF
            ' reset display lines
            CALL PageCount
        END IF

        ' display filename
        COLOR Yellow, Black
        PRINT Outpt$
    END IF

    ' reset paginate
    CALL PagePrompt
    IF Quit.Searching THEN
        EXIT SUB
    END IF

    ' check max recurse levevl
    IF Max.Recurse >= RecurseLevel THEN
        EXIT SUB
    END IF

    ' reset line length
    Length = False

    ' check extended display info
    IF Double.Line THEN
        ' increment counter for extra line
        Files.Counter = Files.Counter + 1

        ' reset display flag
        Var = False

        ' display file date\time
        COLOR Green, Black
        IF Creation.Time THEN
            GOSUB Make.Date1
            GOSUB Convert.Date
            GOSUB Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
            Var = True
        END IF
        IF Access.Time THEN
            IF Creation.Time THEN
                Outpt$ = "\"
                Length = Length + LEN(Outpt$)
                COLOR White, Black
                PRINT Outpt$;
                COLOR Green, Black
                GOSUB LengthCount
            END IF
            GOSUB Make.Date2
            GOSUB Convert.Date
            GOSUB Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
            Var = True
        END IF
        IF Modified.Time THEN
            IF Creation.Time OR Access.Time THEN
                Outpt$ = "\"
                Length = Length + LEN(Outpt$)
                COLOR White, Black
                PRINT Outpt$;
                COLOR Green, Black
                GOSUB LengthCount
            END IF
            GOSUB Make.Date3
            GOSUB Convert.Date
            GOSUB Convert.Time
            Outpt$ = File.Date$ + " " + File.Time$
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
            Var = True
        END IF
        IF Var THEN ' check flag
            Outpt$ = " "
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
        END IF

        ' check for directory bit
        IF (Attribute AND &H10) = &H10 THEN
            Size$ = "<dir>"
        ELSE
            Size$ = FormatString$(File.Size)
        END IF

        ' display file size
        COLOR Red, Black
        Outpt$ = Size$
        Length = Length + LEN(Outpt$)
        PRINT Outpt$;
        GOSUB LengthCount
        COLOR White, Black

        ' check for directory file
        IF (Attribute AND &H10) = &H10 THEN
            Outpt$ = " Directory"
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
        END IF

        ' check for archive file
        IF (Attribute AND &H20) = &H20 THEN
            Outpt$ = " Archive"
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
        END IF

        ' check for read-only file
        IF (Attribute AND 1) = 1 THEN
            Outpt$ = " Read-only"
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
        END IF

        ' check for hidden file
        IF (Attribute AND 2) = 2 THEN
            Outpt$ = " Hidden"
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
        END IF

        ' check for system file
        IF (Attribute AND 4) = 4 THEN
            Outpt$ = " System"
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
            GOSUB LengthCount
        END IF

        ' check for compressed
        IF (Attribute AND &H800) = &H800 THEN
            Outpt$ = " Compressed"
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
        END IF

        ' check for encryption
        IF (Attribute AND &H4000) = &H4000 THEN
            Outpt$ = " Encrypted"
            Length = Length + LEN(Outpt$)
            PRINT Outpt$;
        END IF
        PRINT
    END IF

    ' check paginate
    CALL PagePrompt
    IF Quit.Searching THEN
        EXIT SUB
    END IF

    ' check max recurse levevl
    IF Max.Recurse >= RecurseLevel THEN
        EXIT SUB
    END IF
END IF

End.Display:

' check to run DOS command
IF LEN(DOS.Command) THEN
    CALL ExecuteCommand(Search.Directory$ + Display.Filename$)
END IF
EXIT SUB

' calculate line length
LengthCount:
' check line length
IF Length > 80 THEN
    Files.Counter = Files.Counter + 1
    Length = False
END IF
' check past line 22
IF Files.Counter > 22 THEN
    CALL PagePrompt
    Length = False
END IF
RETURN

Make.Date1:
x& = FileTimeToSystemTime&(finddatatemp.ftCreationTime, SysTime)
RETURN

Make.Date2:
x& = FileTimeToSystemTime&(finddatatemp.ftLastAccessTime, SysTime)
RETURN

Make.Date3:
x& = FileTimeToSystemTime&(finddatatemp.ftLastWriteTime, SysTime)
RETURN

Convert.Date:
YearTemp! = SysTime.wYear
MonthTemp! = SysTime.wMonth
DayTemp! = SysTime.wDay
File.Date$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wMonth)), 2) + "-"
File.Date$ = File.Date$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wDay)), 2) + "-"
File.Date$ = File.Date$ + LTRIM$(STR$(SysTime.wYear))
File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
RETURN

Convert.Time:
HourTemp! = SysTime.wHour
MinuteTemp! = SysTime.wMinute
SecondsTemp! = SysTime.wSecond
File.Time$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wHour)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wMinute)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wSecond)), 2)
File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
RETURN
END SUB

' counts display lines
SUB PageCount
IF Length > 240 THEN
    Files.Counter = Files.Counter + 4
ELSE
    IF Length > 160 THEN
        Files.Counter = Files.Counter + 3
    ELSE
        IF Length > 80 THEN
            Files.Counter = Files.Counter + 2
        ELSE
            Files.Counter = Files.Counter + 1
        END IF
    END IF
END IF
END SUB

' check to paginate
SUB PagePrompt
IF Files.Counter >= 22 THEN
    Files.Counter = False
    IF Continuous.Display = False THEN
        IF More.Display = False THEN
            Prompt$ = "More(y/n/c)?"
            CALL MorePrompt(Prompt$, "ync", Outpt$)
            SELECT CASE Outpt$
                CASE "c"
                    More.Display = True
                CASE "n"
                    Quit.Searching = True
            END SELECT
        END IF
    END IF
END IF
END SUB

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' displays carry flag error
SUB DisplayError (Temp$)
' check display errors flag
IF Display.Errors = False THEN
    ' display error
    COLOR Red, Black
    PRINT Temp$
END IF
END SUB

' subroutine to execute DOS command
SUB ExecuteCommand (DOS.Filename$)
' make replacement parameters
DOS.Pathname$ = DOS.Filename$
Imbedded1 = INSTR(DOS.Pathname$, "\")
Imbedded2 = False
WHILE Imbedded1
    Imbedded2 = Imbedded1
    Imbedded1 = INSTR(Imbedded1 + 1, DOS.Pathname$, "\")
WEND
Filename$ = MID$(DOS.Pathname$, Imbedded2 + 1)
IF Imbedded2 THEN
    DOS.Pathname$ = LEFT$(DOS.Pathname$, Imbedded2 - 1)
ELSE
    DOS.Pathname$ = NUL
END IF
Extension$ = NUL
Imbedded = INSTR(Filename$, ".")
IF Imbedded THEN
    Extension$ = MID$(Filename$, Imbedded + 1)
    Filename$ = LEFT$(Filename$, Imbedded - 1)
END IF

' store replacement parameters
IF LEFT$(DOS.Filename$, 2) = "\\" THEN
    Parameters(1) = "\\"
    Parameters(2) = "\\"
    Parameters(3) = DOS.Pathname$
    Parameters(4) = DOS.Pathname$ + "\"
    Parameters(5) = DOS.Filename$
ELSE
    Parameters(1) = Drive.Search + ":"
    Parameters(2) = Drive.Search + ":\"
    Parameters(3) = Drive.Search + ":" + DOS.Pathname$
    Parameters(4) = Drive.Search + ":" + DOS.Pathname$ + "\"
    Parameters(5) = Drive.Search + ":" + DOS.Filename$
END IF
Parameters(6) = DOS.Pathname$
Parameters(7) = DOS.Pathname$ + "\"
Parameters(8) = DOS.Filename$
Parameters(9) = Filename$ + "." + Extension$
Parameters(10) = Filename$
Parameters(11) = "." + Extension$
Parameters(12) = Extension$

' create DOS command
Execute.Command$ = DOS.Command

' replace parameters
Count = 1
DO
    IF Count >= LEN(Execute.Command$) THEN
        EXIT DO
    END IF
    Imbed$ = MID$(Execute.Command$, Count, 1)
    IF Imbed$ = "%" THEN
        Imbed2$ = MID$(Execute.Command$, Count + 1, 1)
        SELECT CASE UCASE$(Imbed2$)
            CASE "1" TO "9", "A" TO "C"
                Count2 = VAL("&H" + Imbed2$)
                Execute.Command$ = LEFT$(Execute.Command$, Count - 1) + RTRIM$(Parameters(Count2)) + MID$(Execute.Command$, Count + 2)
                Count = Count + LEN(RTRIM$(Parameters(Count2)))
            CASE ELSE
                Count = Count + 1
        END SELECT
    ELSE
        Count = Count + 1
    END IF
LOOP

' start DOS command shell
IF LEN(Execute.Command$) THEN
    ' check display counter
    IF Wide.List THEN
        Wide.List = False
        PRINT
    END IF

    ' read command path from environment
    Comspec$ = ENVIRON$("COMSPEC")
    IF LEN(Comspec$) THEN
        ' call shell routine
        IF Disable.Cmd THEN
            Shell.Command$ = Comspec$ + " /C " + Execute.Command$
        ELSE
            Shell.Command$ = Comspec$ + " /K " + Execute.Command$
        END IF
        SHELL Shell.Command$
    END IF
END IF
END SUB

' routine compares occurrence of filename1$ in filename2$
' with pattern matching.
SUB CheckExcluded (Filename1$, Filename2$)
Exclude.File = True ' assume mask matches filename2.
Length1 = 1
Length2 = 1
DO
    ' global replacement.
    IF MID$(Filename1$, Length1, 1) = "*" THEN
        DO
            Length1 = Length1 + 1
            IF Length1 > LEN(Filename1$) THEN
                EXIT SUB
            END IF
            ' global replacement followed by exclusion character.
            ' searches remaining string until exclusion character found or not.
            IF MID$(Filename1$, Length1, 1) = "^" THEN
                Length1 = Length1 + 1
                Not.Include$ = MID$(Filename1$, Length1, 1)
                DO
                    IF Not.Include$ <> MID$(Filename2$, Length2, 1) THEN
                        Length2 = Length2 + 1
                    ELSE
                        Exclude.File = False
                        EXIT SUB
                    END IF
                    IF Length2 > LEN(Filename2$) THEN
                        EXIT SUB
                    END IF
                LOOP
            END IF
            ' global replacement followed by ? or another *
            ' skips to next character.
            IF MID$(Filename1$, Length1, 1) <> "*" THEN
                IF MID$(Filename1$, Length1, 1) <> "?" THEN
                    EXIT DO
                END IF
            END IF
        LOOP
        ' global replacement.
        ' searches for next matching character.
        DO
            IF MID$(Filename1$, Length1, 1) = MID$(Filename2$, Length2, 1) THEN
                EXIT DO
            ELSE
                Length2 = Length2 + 1
            END IF
            IF Length2 > LEN(Filename2$) THEN
                EXIT DO
            END IF
        LOOP
    ELSE
        ' character replacement.
        ' matches any next character.
        IF MID$(Filename1$, Length1, 1) = "?" THEN
            Length1 = Length1 + 1
            Length2 = Length2 + 1
        ELSE
            ' exclusion character.
            ' checks next character unmatched.
            IF MID$(Filename1$, Length1, 1) = "^" THEN
                Length1 = Length1 + 1
                Not.Include$ = MID$(Filename1$, Length1, 1)
                IF Not.Include$ <> MID$(Filename2$, Length2, 1) THEN
                    Length1 = Length1 + 1
                    Length2 = Length2 + 1
                ELSE
                    Exclude.File = False
                    EXIT DO
                END IF
            ELSE
                ' matches next character.
                IF MID$(Filename1$, Length1, 1) = MID$(Filename2$, Length2, 1) THEN
                    Length1 = Length1 + 1
                    Length2 = Length2 + 1
                ELSE
                    Exclude.File = False
                    EXIT DO
                END IF
                ' check string lengths.
                IF Length1 > LEN(Filename1$) THEN
                    IF Length2 <= LEN(Filename2$) THEN
                        Exclude.File = False
                    END IF
                    EXIT DO
                END IF
            END IF
        END IF
    END IF
LOOP
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' formats a double numeric string
FUNCTION FormatString$ (s#)
x$ = ""
s$ = STR$(s#)
IF INSTR(s$, "D") THEN ' return string
    FormatString$ = s$
    EXIT FUNCTION
END IF
IF LEFT$(s$, 1) = "-" THEN ' store sign
    e$ = "-"
    s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
    q$ = MID$(s$, INSTR(s$, "."))
    s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
    x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
    x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
    x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
    x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

