REM file: Xtree.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "XTREE"

' define boolean values
CONST True = -1
CONST TrueD = -1#
CONST False = 0
CONST FalseD = 0#
CONST FalseS = 0!
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Magenta = 12
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare date\time variables
DIM SHARED Creation.Time AS INTEGER
DIM SHARED Access.Time AS INTEGER
DIM SHARED Modified.Time AS INTEGER

' declare work variables
DIM SHARED Search.Archive AS INTEGER, Search.Hidden AS INTEGER
DIM SHARED Search.Readonly AS INTEGER, Search.System AS INTEGER
DIM SHARED Search.Compress AS INTEGER, Search.Encrypt AS INTEGER
DIM SHARED Recurse.Directories AS INTEGER, Attribute AS _UNSIGNED LONG
DIM SHARED Extended.List AS INTEGER, Display.Errors AS INTEGER
DIM SHARED Continuous.Display AS INTEGER, Directories.Counted AS SINGLE
DIM SHARED Display.Lines AS INTEGER, Display.Lowercase AS INTEGER
DIM SHARED Drive.Search AS STRING * 1, Current.Drive AS STRING * 1
DIM SHARED Nested.Levels AS INTEGER, Nested.Recurse AS INTEGER
DIM SHARED Short.Filenames AS INTEGER, Short.Display AS INTEGER
DIM SHARED Wide.Display AS INTEGER, Display.Length AS INTEGER
DIM SHARED Truncate.Slash AS INTEGER, Strip.Drive AS INTEGER
DIM SHARED Check.Root AS INTEGER, First.Dir AS INTEGER, Length AS INTEGER
DIM SHARED Quit.Searching AS INTEGER, More.Display AS INTEGER
DIM SHARED Append.Slash AS INTEGER, Current.Directory AS STRING
DIM SHARED Wide.Display2 AS INTEGER, DriveType AS STRING
DIM SHARED Lines.Counted AS DOUBLE, Max.Lines AS DOUBLE

' declare sort variables
DIM SHARED Num AS DOUBLE, Span AS DOUBLE, Start AS DOUBLE, Element AS DOUBLE

' declare sort array
DIM SHARED Sort.Array(1) AS STRING

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
    FUNCTION CloseHandle& (BYVAL hfile AS _OFFSET)
END DECLARE

DECLARE LIBRARY
    FUNCTION CreateFile& (filename$, BYVAL access&, BYVAL sharing&, BYVAL sec_attr%&, BYVAL create&, BYVAL flags&, BYVAL template%&)
    FUNCTION GetDriveType& (d$)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE
DIM hfind AS _OFFSET

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' redimension sort array
REDIM Sort.Array(1 TO 128) AS STRING

' reset count variables
Max.Lines = 128

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' command line input loop
Command.Line = COMMAND$
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset counters
Directories.Counted = FalseS
Display.Lines = False
Continuous.Display = False
Quit.Searching = False
Lines.Counted = False

' get current drive/directory
Current.Drive$ = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Dir spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' check command line switches
Search.Archive = ParseLine("/A")
Append.Slash = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Extended.List = ParseLine("/E")
Short.Display = ParseLine("/F")
Search.Hidden = ParseLine("/H")
Search.Readonly = ParseLine("/O")
Search.System = ParseLine("/S")

Search.Compress = ParseLine("/J")
Search.Encrypt = ParseLine("/K")

Recurse.Directories = ParseLine("/R")
Display.Lowercase = ParseLine("/Y")
Strip.Drive = ParseLine("/U")
Short.Filenames = ParseLine("/V")
Wide.Display2 = ParseLine("/W1")
Wide.Display = ParseLine("/W")
Truncate.Slash = ParseLine("/X")
Display.Errors = ParseLine("/Z")

' reset some display variables
IF Wide.Display THEN
    Extended.List = False
    Short.Display = True
    Short.Filenames = True
END IF

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
IF Creation.Time = False THEN
    IF Access.Time = False THEN
        IF Modified.Time = False THEN
            Modified.Time = True
        END IF
    END IF
END IF

' get nested switch from command line
Nested.Levels = 256%
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = Var%
END IF

' get new filename from command line
Command.Line = RTRIM$(Command.Line)
Filename2$ = ""
Imbedded = INSTR(UCASE$(Command.Line), "/G")
IF Imbedded THEN
    IF INSTR(Imbedded + 1, Command.Line, "/") THEN
        GOTO Boot.Error
    END IF
    Filename2$ = MID$(Command.Line, Imbedded + 2)
    IF LEFT$(Filename2$, 1) = CHR$(34) AND RIGHT$(Filename2$, 1) = CHR$(34) THEN
        Filename2$ = MID$(Filename2$, 2)
        Filename2$ = LEFT$(Filename$, LEN(Filename2$) - 1)
    ELSE
        IF INSTR(Filename2$, " ") THEN
            GOTO Boot.Error
        END IF
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1)
END IF
IF Filename2$ = "" THEN
    Filename2$ = "scrn:"
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF

' check trailing command line
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
IF Command.Line = "" THEN
    Command.Line = "*.*"
END IF

' store entire command
Command.Work = Command.Line

' test file for output
f$ = Filename2$ + CHR$(0)
hfind = CreateFile(f$, &H180, 0, 0, 4, 0, 0)
IF hfind = 0 THEN
    GOTO Boot.Error
END IF
x = CloseHandle(hfind)

' display header
IF Display.Header = False THEN
    IF Continuous.Display = False THEN
        COLOR White, Black
        GOSUB Header
    END IF
END IF

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF

    ' store search drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
    ELSE
        Drive.Search = Current.Drive
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store current directory
    Directory.Search$ = Command.Work

    ' parse drive letter
    Temp.Directory$ = Directory.Search$
    IF MID$(Temp.Directory$, 2, 1) = ":" THEN
        Temp.Drive$ = UCASE$(LEFT$(Temp.Directory$, 1))
        Temp.Directory$ = MID$(Temp.Directory$, 3)
    ELSE
        Temp.Drive$ = Drive.Search
    END IF

    ' parse directory
    IF LEFT$(Temp.Directory$, 2) <> "\\" THEN
        IF LEFT$(Temp.Directory$, 1) <> "\" THEN
            IF Temp.Drive$ <> LEFT$(Current.Directory, 1) THEN
                Directory.Search$ = Drive.Search + ":\" + Temp.Directory$
            ELSE
                Directory.Search$ = Current.Directory + Temp.Directory$
            END IF
        ELSE
            Directory.Search$ = Temp.Drive$ + ":" + Temp.Directory$
        END IF
    END IF

    ' display search header
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        Display.Lines = Display.Lines + 1
        PRINT "Searching: " + Directory.Search$
    END IF

    ' call subroutine to search directories
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Temp.Drive$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP

' shell sort
Sort.Swaps = False
Num = Lines.Counted
Span = INT(Num / 2)
DO WHILE Span > False
    FOR Start = Span TO Num - 1
        FOR Element = (Start - Span + 1) TO 1 STEP -Span
            Sort.Column1$ = MID$(Sort.Array(Element), Sort.Column)
            Sort.Column2$ = MID$(Sort.Array(Element + Span), Sort.Column)
            IF Ignore.Case THEN
                Sort.Column1$ = UCASE$(Sort.Column1$)
                Sort.Column2$ = UCASE$(Sort.Column2$)
            END IF
            IF Reverse.Sort THEN
                IF Sort.Column2$ <= Sort.Column1$ THEN
                    EXIT FOR
                END IF
            ELSE
                IF Sort.Column1$ <= Sort.Column2$ THEN
                    EXIT FOR
                END IF
            END IF
            SWAP Sort.Array(Element), Sort.Array(Element + Span)
            Sort.Swaps = Sort.Swaps + 1
        NEXT
    NEXT
    Span = INT(Span / 2)
LOOP

' output array
X = FREEFILE
OPEN Filename2$ FOR APPEND AS #X
FOR Array.Line# = 1 TO Lines.Counted
    X$ = RTRIM$(Sort.Array(Array.Line#))
    PRINT #X, Sort.Array(Array.Line#)
NEXT
CLOSE #X
End.Xtree:

' display counters
IF Continuous.Display = False THEN
    IF Wide.Display THEN
        IF Display.Length THEN
            PRINT
        END IF
    END IF
    COLOR Yellow, Black
    PRINT "Directories counted"; Directories.Counted
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Xtree v1.0a: Directory search utility;"
END IF
RETURN

Get.Numeric:
Var% = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var% = Var% * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Xtree v1.0a: Directory sort utility;"
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Xtree [d:\path\][/ahos][/bcefnruvwxyz][/123][/gfilename.ext]"
PRINT "Where:"
PRINT "   /g  is optional output filename at end of command line"
PRINT "   /b  append slash         /c  continuous display"
PRINT "   /e  extended display     /f  short filename display"
PRINT "   /r  recurse directories  /u  strip leading drive letter"
PRINT "   /v  use 8.3 filenames    /w  wide list display"
PRINT "   /w1 prepend slash        /x  truncate slash"
PRINT "   /y  lowercase display    /z  suppress errors"
PRINT "   /nxxx  recurse levels override"
PRINT "   display directory ranges:"
PRINT "      /1  creation, /2 accessed, /3 modified"
PRINT "   display directory attributes:"
PRINT "      /a  archive, /h  hidden, /o  read-only, /s  system"
PRINT "      /j  compressed  /k  encrypted"
COLOR Plain, Black
RETURN
END

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Xtree /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    RESUME NEXT
END IF
IF Wide.Display THEN
    IF Display.Length THEN
        Display.Length = False
        PRINT
    END IF
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        RESUME End.Xtree
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB Directories (Directory.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
DIM Recurse.Temp AS INTEGER

' reset wildcard flag
Wild = 0

' make directory filename
Temp.Dir$ = Directory.Search$
Recurse.Temp = Recurse.Directories
IF Recurse.Directories THEN
    IF INSTR(Temp.Dir$, "?") OR INSTR(Temp.Dir$, "*") THEN
        ' Recurse.Temp = False
    ELSE
        IF RIGHT$(Temp.Dir$, 1) <> "\" THEN
            Temp.Dir$ = Temp.Dir$ + "\"
        END IF
        Temp.Dir$ = Temp.Dir$ + "*.*"
    END IF
END IF
ASCIIZ = Temp.Dir$ + CHR$(0)

' find first long filename
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))

' check findirst error
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' filename/directory loop
    DO
        ' get file attributes
        Attribute = finddata.dwFileAttributes

        ' check directory attribute
        IF (Attribute AND &H10) = &H10 THEN

            ' check to recurse directories
            IF Recurse.Temp = 0 THEN
                ' store directory name
                Directory$ = finddata.cFileName
                V = INSTR(Directory$, CHR$(0))
                IF V THEN Directory$ = LEFT$(Directory$, V - 1)

                ' display directory
                GOSUB Display.Directory
            END IF

            ' check to recurse directories
            IF Recurse.Temp THEN

                ' store directory name
                Directory$ = finddata.cFileName
                V = INSTR(Directory$, CHR$(0))
                IF V THEN Directory$ = LEFT$(Directory$, V - 1)

                ' check unicode
                Unicode = 0
                IF INSTR(Directory$, "?") THEN
                    Unicode = -1
                    Directory$ = finddata.cAlternateFileName
                    V = INSTR(Directory$, CHR$(0))
                    IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                END IF

                ' check directory name
                Valid.Flag = -1
                IF Directory$ = "." THEN
                    Valid.Flag = 0
                END IF
                IF Directory$ = ".." THEN
                    Valid.Flag = 0
                END IF
                IF Directory$ = NUL THEN
                    Valid.Flag = 0
                END IF
                IF Valid.Flag THEN

                    ' display directory
                    GOSUB Display.Directory

                    ' check recursion levels
                    Recursion% = True
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels + 1
                        IF Nested.Levels >= Nested.Recurse THEN
                            Recursion% = False
                        END IF
                    END IF

                    ' recursively search subdirectories
                    IF Recursion% THEN
                        CALL Directories(Next.Directory$)
                    END IF
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels - 1
                    END IF
                END IF
            END IF
        END IF

        ' check quit searching
        IF Quit.Searching THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
EXIT SUB

Display.Directory:
' retract one directory if wildcard/global characters in trailing path
IF INSTR(Directory.Search$, "?") OR INSTR(Directory.Search$, "*") THEN
    Wild = -1
    FOR V = LEN(Directory.Search$) TO 1 STEP -1
        IF MID$(Directory.Search$, V, 1) = "\" THEN
            Directory.Search$ = LEFT$(Directory.Search$, V)
            EXIT FOR
        END IF
    NEXT
END IF

' make next search directory
IF RIGHT$(Directory.Search$, 1) <> "\" THEN
    Next.Directory$ = Directory.Search$ + "\" + Directory$
ELSE
    Next.Directory$ = Directory.Search$ + Directory$
END IF

' store directory name
Temp.Directory$ = finddata.cFileName
V = INSTR(Temp.Directory$, CHR$(0))
IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)

IF Temp.Directory$ = NUL THEN
    RETURN
END IF
IF Temp.Directory$ = "." THEN
    RETURN
END IF
IF Temp.Directory$ = ".." THEN
    RETURN
END IF

' construct directory for display
IF Recurse.Directories = 0 THEN
    IF Wild THEN
        IF RIGHT$(Directory.Search$, 1) <> "\" THEN
            Temp.Directory$ = Directory.Search$ + "\" + Directory$
        ELSE
            Temp.Directory$ = Directory.Search$ + Directory$
        END IF
    ELSE
        Temp.Directory$ = Directory.Search$
    END IF
ELSE
    Temp.Directory$ = Next.Directory$
    Wild = -1
END IF

' get short filename
IF Short.Filenames THEN
    Temp.Directory$ = finddata.cAlternateFileName
    V = INSTR(Temp.Directory$, CHR$(0))
    IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)
    IF Temp.Directory$ = NUL THEN
        Temp.Directory$ = finddata.cFileName
        V = INSTR(Temp.Directory$, CHR$(0))
        IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)
    END IF
END IF

' check directory attribute
Valid.Attribute = True

' check for read-only file
IF Search.Readonly THEN
    IF (Attribute AND &H1) <> &H1 THEN
        Valid.Attribute = False
    END IF
END IF

' check for hidden file
IF Search.Hidden THEN
    IF (Attribute AND &H2) <> &H2 THEN
        Valid.Attribute = False
    END IF
END IF

' check for system file
IF Search.System THEN
    IF (Attribute AND &H4) <> &H4 THEN
        Valid.Attribute = False
    END IF
END IF

' check for archive file
IF Search.Archive THEN
    IF (Attribute AND &H20) <> &H20 THEN
        Valid.Attribute = False
    END IF
END IF

' check for compressed file
IF Search.Compress THEN
    IF (Attribute AND &H800) <> &H800 THEN
        Valid.Attribute = False
    END IF
END IF

' check for compressed file
IF Search.Encrypt THEN
    IF (Attribute AND &H4000) <> &H4000 THEN
        Valid.Attribute = False
    END IF
END IF

' check for valid directory
IF Valid.Attribute THEN

    ' store directory name
    Outpt$ = RTRIM$(Temp.Directory$)
    IF Short.Display THEN
        IF RIGHT$(Outpt$, 1) = "\" THEN
            Outpt$ = LEFT$(Outpt$, LEN(Outpt$) - 1)
        END IF
        FOR Imbedded = LEN(Outpt$) TO 1 STEP -1
            IF MID$(Outpt$, Imbedded, 1) = "\" THEN
                Outpt$ = MID$(Outpt$, Imbedded + 1)
                EXIT FOR
            END IF
        NEXT
    END IF
    IF Truncate.Slash THEN
        IF Outpt$ <> "\" THEN
            IF RIGHT$(Outpt$, 1) = "\" THEN
                Outpt$ = LEFT$(Outpt$, LEN(Outpt$) - 1)
            END IF
        END IF
    END IF
    IF Short.Filenames = False OR Short.Display THEN
        IF MID$(Outpt$, 2, 1) <> ":" THEN
            IF LEFT$(Directory.Search$, 2) <> "\\" THEN
                Outpt$ = Drive.Search + ":" + Outpt$
            END IF
        END IF
    END IF
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        IF MID$(Outpt$, 2, 1) = ":" THEN
            Outpt$ = MID$(Outpt$, 3)
        END IF
    END IF
    IF Strip.Drive THEN
        IF MID$(Outpt$, 2, 1) = ":" THEN
            Outpt$ = MID$(Outpt$, 3)
        END IF
    END IF
    IF Display.Lowercase THEN
        Outpt$ = LCASE$(Outpt$)
    END IF

    ' increment directories counted
    Directories.Counted = Directories.Counted + 1!

    ' check slash switch
    IF Append.Slash THEN
        IF RIGHT$(Outpt$, 1) <> "\" THEN
            Outpt$ = Outpt$ + "\"
        END IF
    END IF

    ' store full directory pathname
    Lines.Counted = Lines.Counted + 1
    IF Lines.Counted > Max.Lines THEN
        Max.Lines = Max.Lines + 16
        REDIM _PRESERVE Sort.Array(1 TO Max.Lines) AS STRING
    END IF
    Sort.Array(Lines.Counted) = Outpt$
END IF
RETURN
END SUB

' prompt for more
SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
DO
    DO
        _LIMIT 50
        LOCATE , , 1
        Input.Char$ = INKEY$
        IF LEN(Input.Char$) THEN
            EXIT DO
        END IF
    LOOP
    Input.Char$ = LCASE$(Input.Char$)
    IF INSTR(Input.Mask$, Input.Char$) THEN
        PRINT Input.Char$
        Output.String$ = Input.Char$
        EXIT DO
    END IF
LOOP
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

