REM file: Zsort.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "ZSORT"

' define boolean values
CONST True = -1
CONST False = NOT True
CONST TrueD = -1#
CONST FalseD = NOT TrueD
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare work variables
DIM SHARED Reverse.Sort AS INTEGER, Sort.Column AS INTEGER
DIM SHARED Lines.Counted AS DOUBLE, Max.Lines AS DOUBLE
DIM SHARED Ignore.Case AS INTEGER, Continuous.Display AS INTEGER
DIM SHARED Strip.Blanks AS INTEGER, Sort.Swaps AS DOUBLE
DIM SHARED Control.Break AS INTEGER, Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare sort variables
DIM SHARED Num AS DOUBLE, Span AS DOUBLE, Start AS DOUBLE, Element AS DOUBLE

' declare sort array
DIM SHARED Sort.Array(1) AS STRING

' declare command line work variables
DIM SHARED Command.Line AS STRING

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION CloseHandle& (BYVAL hfile AS _OFFSET)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE
DECLARE LIBRARY
    FUNCTION CreateFile& (filename$, BYVAL access&, BYVAL sharing&, BYVAL sec_attr%&, BYVAL create&, BYVAL flags&, BYVAL template%&)
END DECLARE
DIM hfind AS _OFFSET

' declare standard error trap
ON ERROR GOTO Error.Routine

' redimension sort array
REDIM Sort.Array(1 TO 128) AS STRING

' reset count variables
Max.Lines = 128

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOTO Boot.Usage
END IF

' read command line
Command.Line = RTRIM$(COMMAND$)

' check command line switches
Continuous.Display = ParseLine("/C")
Ignore.Case = ParseLine("/I")
Reverse.Sort = ParseLine("/R")
Strip.Blanks = ParseLine("/T")

' get sort column
Sort.Column = 1
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Imbedded2 = Imbedded + 2
    DO
        Switch$ = MID$(Command.Line, Imbedded2, 1)
        IF Switch$ >= "0" AND Switch$ <= "9" THEN
            Column$ = Column$ + Switch$
        ELSE
            EXIT DO
        END IF
        Imbedded2 = Imbedded2 + 1
    LOOP
    IF Column$ = NUL THEN
        GOTO Boot.Error
    END IF
    Sort.Column = INT(VAL(Column$))
    IF Sort.Column = False THEN
        GOTO Boot.Error
    END IF
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded2)
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF
Command.Line = RTRIM$(LTRIM$(Command.Line))
IF Command.Line = "" THEN
    GOTO Boot.Error
END IF

v = INSTR(Command.Line, " ")
IF v THEN
    Filename1$ = LEFT$(Command.Line, v - 1)
    Filename2$ = MID$(Command.Line, v + 1)
ELSE
    Filename1$ = Command.Line
    Filename2$ = "scrn:"
    IF Filename1$ = "" THEN
        GOTO Boot.Error
    END IF
END IF

f$ = Filename1$ + CHR$(0)
hfind = CreateFile(f$, &H180, 0, 0, 4, 0, 0)
IF hfind = 0 THEN
    GOTO Boot.Error
END IF
x = CloseHandle(hfind)

f$ = Filename2$ + CHR$(0)
hfind = CreateFile(f$, &H180, 0, 0, 4, 0, 0)
IF hfind = 0 THEN
    GOTO Boot.Error
END IF
x = CloseHandle(hfind)

IF _FILEEXISTS(Filename1$) = 0 THEN
    GOTO Boot.Error
END IF
OPEN Filename1$ FOR BINARY AS #1
Count# = 0#
IF LOF(1) > 0 THEN
    DO UNTIL EOF(1)
        LINE INPUT #1, line1$
        Count# = Count# + LEN(line1$) + 2#
        Lines.Counted = Lines.Counted + 1
        IF Lines.Counted > Max.Lines THEN
            Max.Lines = Max.Lines + 16
            REDIM _PRESERVE Sort.Array(Max.Lines) AS STRING
        END IF
        Sort.Array(Lines.Counted) = line1$
    LOOP
    IF Count# < LOF(1) THEN
        Lines.Counted = Lines.Counted + 1
        IF Lines.Counted > Max.Lines THEN
            Max.Lines = Max.Lines + 16
            REDIM _PRESERVE Sort.Array(Max.Lines) AS STRING
        END IF
        Sort.Array(Lines.Counted) = ""
    END IF
END IF
CLOSE #1

' shell sort
Sort.Swaps = False
Num = Lines.Counted
Span = INT(Num / 2)
DO WHILE Span > False
    FOR Start = Span TO Num - 1
        FOR Element = (Start - Span + 1) TO 1 STEP -Span
            Sort.Column1$ = RTRIM$(MID$(Sort.Array(Element), Sort.Column))
            Sort.Column2$ = RTRIM$(MID$(Sort.Array(Element + Span), Sort.Column))
            IF Ignore.Case THEN
                Sort.Column1$ = UCASE$(Sort.Column1$)
                Sort.Column2$ = UCASE$(Sort.Column2$)
            END IF
            IF Reverse.Sort THEN
                IF Sort.Column2$ = "" THEN
                    EXIT FOR
                ELSE
                    IF Sort.Column2$ <= Sort.Column1$ THEN
                        EXIT FOR
                    END IF
                END IF
            ELSE
                IF Sort.Column1$ = "" THEN
                    EXIT FOR
                ELSE
                    IF Sort.Column1$ <= Sort.Column2$ THEN
                        EXIT FOR
                    END IF
                END IF
            END IF
            SWAP Sort.Array(Element), Sort.Array(Element + Span)
            Sort.Swaps = Sort.Swaps + 1
        NEXT
    NEXT
    Span = INT(Span / 2)
LOOP

' output array
OPEN Filename2$ FOR OUTPUT AS #1
FOR Array.Line# = 1 TO Lines.Counted
    X$ = RTRIM$(Sort.Array(Array.Line#))
    IF X$ = "" THEN
        IF Strip.Blanks = 0 THEN
            PRINT #1, Sort.Array(Array.Line#)
        END IF
    ELSE
        IF LCASE$(Filename2$) = "scrn:" THEN
            _CONTROLCHR OFF
            PRINT Sort.Array(Array.Line#)
            _CONTROLCHR ON
        ELSE
            PRINT #1, Sort.Array(Array.Line#)
        END IF
    END IF
NEXT
CLOSE #1
End.Zsort:

' display counters
IF Continuous.Display = False THEN
    COLOR Yellow, Black
    PRINT "Lines counted"; Lines.Counted
    PRINT "Sort swaps made"; Sort.Swaps
    Prompt$ = "Press <enter> to exit to DOS:"
    CALL MorePrompt(Prompt$, CHR$(13), Outpt$)
END IF
COLOR Plain, Black
END

Boot.Usage:
' make header
COLOR White, Black
PRINT "Zsort v1.0a: Sort utility; "
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Zsort <inputname> [<outputname>] [/cinrt]"
PRINT "Where:"
PRINT "   <inputname> is the pathname of the input file."
PRINT "   <outputname> is the optional pathname of the output file."
PRINT "Switches:"
PRINT "   /c  continuous list"
PRINT "   /i  ignore case"
PRINT "   /n###  sort at column"
PRINT "   /r  reverse order"
PRINT "   /t  strip blank lines"
COLOR Plain, Black
END

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Zsort /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
COLOR Green, Black
SELECT CASE DataError
    CASE 9
        PRINT "Subscript out of range."
        COLOR 7, 0
        END
    CASE 14
        PRINT "Out of string space."
        COLOR 7, 0
        END
    CASE ELSE
        Temp.Outpt$ = "Critical error:" + STR$(DataError) + " IDE line:" + STR$(_ERRORLINE)
END SELECT
PRINT Temp.Outpt$
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        Error.Level = True
        RESUME End.Zsort
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
LOCATE , , 1
DO
    _LIMIT 100
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
        Input.Char$ = LCASE$(Input.Char$)
        IF INSTR(Input.Mask$, Input.Char$) THEN
            PRINT Input.Char$
            Output.String$ = Input.Char$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

