Rem file: Deldir.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DefInt A-Z
Rem $DYNAMIC
_Title "DELDIR"

' define boolean values
Const True = -1
Const False = Not True
Const TrueD = -1#
Const FalseD = Not TrueD
Const NUL = ""

' define color values
Const Black = 0
Const Cyan = 11
Const Green = 10
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' initialize drive variables
Dim Shared Drive.Search As String * 1
Dim Shared Current.Drive As String * 1

' declare work variables
Dim Shared Continuous.Display As Integer
Dim Shared Display.Errors As Integer
Dim Shared Prompt.Delete As Integer
Dim Shared Quit.Searching As Integer
Dim Shared Dirs.Counted As Double

' declare command line work variables
Dim Shared Command.Line As String
Dim Shared Command.Work As String
Dim Shared Last.Switch As Integer
Dim Shared Switch.Exist As Integer
Dim Shared Display.Drive As Integer
Dim Shared Display.Path As Integer

' declare library constants.
Const MAX_PATH = 260

' declare external libraries.
Declare Dynamic Library "kernel32"
    Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, Byval nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, Byval nFileSystemNameSize&)
    Function SetCurrentDirectoryA% (f$)
    Function RemoveDirectoryA% (F$)
    Function CreateDirectoryA% (F$, X$)
    Function CloseHandle& (ByVal hfile As _Offset)
    Function GetLastError& ()
    Function FormatMessageA& (ByVal f As Long, f$, Byval e As Long, Byval d As Long, g$, s As Long, h$)
End Declare

Declare Library
    Function CreateFile%& (filename$, Byval access&, Byval sharing&, Byval sec_attr%&, Byval create&, Byval flags&, Byval template%&)
    Function GetDriveType& (d$)
End Declare

' declare library variables.
Dim Shared ASCIIZ As String * 260
Dim Shared DriveType As String
Dim Shared hfind As _Offset

' declare standard error trap
On Error GoTo Error.Routine

' force default path
x$ = _StartDir$
f$ = x$ + Chr$(0)
x = SetCurrentDirectoryA(f$)

' get current drive
Current.Drive = Left$(_CWD$, 1)

' check command line
If Command$ = "/?" Then
    GoSub Boot.Usage
    End
End If

' store command line
Command.Line = RTrim$(Command$)
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset counters
Dirs.Counted = False

' check command line
If Command.Line = NUL Then
    ' display header
    Color White, Black
    GoSub Header
    Display.Header = True

    ' get command line input
    Print _CWD$
    Print "Dir path: ";
    Line Input Command.Line
    If Command.Line = NUL Then
        GoTo end.deldir
    End If
    Do
        Color White, Black
        Print "Switches(?=list): ";
        Line Input Var$
        If Var$ = "?" Then
            GoSub Boot.Usage
        Else
            Command.Line = Command.Line + Var$
            Exit Do
        End If
    Loop
End If

' store command line
Command.Line = RTrim$(Command.Line)

' get switches from command line
Continuous.Display = ParseLine("/C")
Display.Drive = ParseLine("/D")
Prompt.Delete = ParseLine("/P")
Display.Path = ParseLine("/V")
Display.Errors = ParseLine("/Z")

' recheck command line
If InStr(Command.Line, "/") Then
    GoTo Boot.Error
End If
Command.Line = RTrim$(Command.Line)
If Switch.Exist Then
    If Len(Command.Line) > Last.Switch Then
        GoTo Boot.Error
    End If
End If

' remove blanks from command line
Command.Line = RTrim$(Command.Line)
Command.Line = LTrim$(Command.Line)

' store entire command
Command.Work = Command.Line

' display header
GoSub Header

' filename processing loop
Do

    ' store entire command
    If Left$(Command.Line, 1) = Chr$(34) Then
        Imbedded = InStr(2, Command.Line, Chr$(34))
        If Imbedded Then
            Command.Work = Mid$(Command.Line, 2, Imbedded - 2)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
        Else
            Command.Work = Command.Line
            Command.Line = NUL
        End If
    Else
        Imbedded = InStr(Command.Line, " ")
        If Imbedded Then
            Command.Work = Left$(Command.Line, Imbedded - 1)
            Command.Line = Mid$(Command.Line, Imbedded + 1)
        Else
            Command.Work = Command.Line
            Command.Line = NUL
        End If
    End If
    Command.Line = LTrim$(Command.Line)
    Command.Line = RTrim$(Command.Line)

    ' store current drive
    If Mid$(Command.Work, 2, 1) = ":" Then
        Drive.Search = UCase$(Left$(Command.Work, 1))
        Command.Work = Mid$(Command.Work, 3)
    Else
        Drive.Search = Current.Drive
    End If

    ' check drive
    Flag = -1
    If Left$(_CWD$, 2) = "\\" Then
        Flag = -1
    Else
        V = Asc(UCase$(Left$(Drive.Search, 1))) - 64
        If MEDIAEXISTS(V) = 0 Then
            ' display any errors
            Call DisplayError("Error accessing drive " + Chr$(V + 64) + ":")
            Flag = 0
        End If
    End If
    If Flag Then

        ' check directory exists
        ASCIIZ = Command.Work + Chr$(0)
        hfind = CreateFile(ASCIIZ, &H180, &H3, 0, 3, FILE_FLAG_BACKUP_SEMANTICS, 0)
        If hfind <> INVALID_HANDLE_VALUE Then
            x = CloseHandle(hfind)
            ' reset delete flag
            Delete.File = True

            ' check delete flag
            If Prompt.Delete = 0 Then
                Prompt$ = "Delete directory " + Filename$(0) + "(y/n/q/c)?"
                Call MorePrompt(Prompt$, "ynqc", Outpt$)
                Select Case Outpt$
                    Case "c"
                        Prompt.Delete = True
                    Case "n"
                        Delete.File = False
                    Case "q"
                        Delete.File = False
                        Quit.Searching = True
                End Select
            End If

            ' check delete flag
            If Delete.File Then
                ' make directory name
                Temp.Dir$ = Command.Work + Chr$(0)
                x = RemoveDirectoryA(Temp.Dir$)
                ' check error flag
                If x = 0 Then
                    Call DisplayWinError(x)
                Else
                    ' display drive letter
                    If Display.Drive Then
                        Color Yellow, Black
                        Print Drive.Search; ":";
                    End If

                    ' display pathname
                    If Display.Path = False Then
                        Color Yellow, Black
                        Outpt$ = Filename$(0)
                        If Mid$(Outpt$, 2, 1) = ":" Then
                            Outpt$ = Mid$(Outpt$, 3)
                        End If
                        Print Outpt$
                    End If
                    If Display.Drive And Display.Path Then
                        Print
                    End If
                    ' count directories deleted
                    Dirs.Counted = Dirs.Counted + 1
                End If
            Else
                Call DisplayWinError(x)
            End If
        End If
    End If

    ' check search filename
    If Command.Line = NUL Then
        Exit Do
    End If
    If Quit.Searching Then
        Exit Do
    End If
Loop
end.deldir:

' display counters
If Continuous.Display = False Then
    Color Yellow, Black
    Total$ = FormatString$(Dirs.Counted)
    Print "Directories counted: "; Total$
    Color White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    Print Prompt$;
    Do
        _Limit 50
        Locate , , 1
        I$ = InKey$
        If UCase$(I$) = "Q" Then
            Color Plain, Black
            System
        End If
        If UCase$(I$) = "A" Then
            Command.Line = NUL
            New.Drive = 0
            Volumes.Counted = 0
            Color Plain, Black
            Print
            GoTo Start.Loop
        End If
    Loop
End If
Color Plain, Black
End

' display program usage
Boot.Usage:
' make header
Color White, Black
Print "Deldir v1.0a: Directory delete utility; "
Color Yellow, Black
Print "Usage:"
Print "   Deldir [d:][path] [/cdpvz]"
Print "Where:"
Print "   /c  continuous display"
Print "   /d  display drive letter"
Print "   /p  don't prompt defore delete"
Print "   /v  don't display pathname"
Print "   /z  suppress error messages"
Color Plain, Black
Return

Boot.Error:
Color White, Black
Print "Command line error. Type Makdir /? for help."
Color Plain, Black
End

' make header
Header:
If Header.Flag Then
    Return
End If
Header.Flag = True
If Continuous.Display = False Then
    Color White, Black
    Print "Deldir v1.0a: Directory delete utility; "
End If
Return

' critical error trap
Error.Routine:
DataError = Err
If Error.Flag Then
    Resume Next
End If
If Display.Errors Then
    Error.Level = True
    Resume Next
End If
Color Green, Black
Print "Critical error:"; DataError; " IDE line:"; _ErrorLine
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$)
Select Case Outpt$
    Case "r"
        Resume
    Case "q"
        Error.Level = True
        Resume end.deldir
    Case "c"
        Resume Next
End Select
Color Plain, Black
End 0

' command line switch position function.
Function LastSwitch (Var)
    LastSwitch = -1
    If Last.Switch = 0 Then
        Last.Switch = Var - 1
        Switch.Exist = -1
    Else
        If Var < Last.Switch Then
            Last.Switch = Var - 1
            Switch.Exist = -1
        End If
    End If
End Function

' command line parser
Function ParseLine (X$)
    Imbedded = InStr(Command.Line, LCase$(X$))
    If Imbedded Then
        Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    Else
        Imbedded = InStr(Command.Line, UCase$(X$))
        If Imbedded Then
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
            Last.Switch = Imbedded - 1
            ParseLine = True
            Switch.Exist = -1
        Else
            ParseLine = False
        End If
    End If
End Function

Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
    Color White, Black
    Print Input.String$ + " ";
    Input.Char$ = NUL
    Locate , , 1
    Do
        _Limit 100
        Input.Char$ = InKey$
        If Len(Input.Char$) Then
            Input.Char$ = LCase$(Input.Char$)
            If InStr(Input.Mask$, Input.Char$) Then
                Print Input.Char$
                Output.String$ = Input.Char$
                Exit Do
            End If
        End If
    Loop
End Sub

' displays error
Sub DisplayError (Temp$)
    ' check display errors flag
    If Display.Errors = False Then
        ' display error
        Color Red, Black
        Print Temp$
    End If
End Sub

' displays windows error
Sub DisplayWinError (x)
    ' define error message space
    Dim m As String * 32767
    ' check display errors flag
    If Display.Errors = False Then
        ' call windows error message routine
        x& = FormatMessageA&(&H1200, "", GetLastError, 0, m$, 260, "")
        If x& Then
            ' display error
            v = CInt(x&) - 2
            If v > 0 Then
                Color Red, Black
                Print Left$(m$, v)
            End If
        End If
    End If
End Sub

' test volume media inserted.
Function MEDIAEXISTS (V)
    ' check drive exists.
    If DRIVEEXISTS(V) Then
        MEDIAEXISTS = False
        Exit Function
    End If

    ' get drive info.
    VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
    Vname$ = Space$(MAX_PATH)
    Fname$ = Space$(MAX_PATH)
    R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
    If R Then
        MEDIAEXISTS = True
    Else
        MEDIAEXISTS = False
    End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
    VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
    VarX = GetDriveType(VarX$)
    DriveType = NUL
    Select Case VarX
        Case 0
            DriveType = "[UNKNOWN]"
        Case 1
            DriveType = "[BADROOT]"
        Case 2
            DriveType = "[REMOVABLE]"
        Case 3
            DriveType = "[FIXED]"
        Case 4
            DriveType = "[REMOTE]"
        Case 5
            DriveType = "[CDROM]"
        Case 6
            DriveType = "[RAMDISK]"
    End Select
    If VarX > 1 Then
        DRIVEEXISTS = False
    Else
        DRIVEEXISTS = True
    End If
End Function

' gets default directory
Function Filename$ (Var)

    ' fully qualified netpath
    If Left$(Command.Work, 2) = "\\" Then
        Filename$ = Command.Work
        Exit Function
    End If

    ' fully qualified root path
    If Left$(Command.Work, 1) = "\" Then
        Var$ = Drive.Search + ":"
        Filename$ = Var$ + Command.Work
        Exit Function
    End If

    ' get current directory
    Drive$ = Drive.Search + ":"
    If Left$(_CWD$, 2) = "\\" Then
        Directory.Search$ = _CWD$
    Else ' path\filename
        If Drive.Search = Current.Drive Then
            Directory.Search$ = _CWD$
        Else
            Original$ = _CWD$
            ChDir Drive$
            Directory.Search$ = _CWD$
            ChDir Original$
        End If
    End If

    ' store default directory
    Filename.Search$ = Command.Work
    If Right$(Directory.Search$, 1) = "\" Then
        Directory.Search$ = Directory.Search$ + Filename.Search$
    Else
        Directory.Search$ = Directory.Search$ + "\" + Filename.Search$
    End If
    Filename$ = Directory.Search$
End Function

' formats a double numeric string
Function FormatString$ (s#)
    x$ = ""
    s$ = Str$(s#)
    If InStr(s$, "D") Then ' return string
        FormatString$ = s$
        Exit Function
    End If
    If Left$(s$, 1) = "-" Then ' store sign
        e$ = "-"
        s$ = Mid$(s$, 2)
    End If
    s$ = LTrim$(s$) ' format string
    If InStr(s$, ".") Then
        q$ = Mid$(s$, InStr(s$, "."))
        s$ = Left$(s$, InStr(s$, ".") - 1)
    End If
    For l = Len(s$) To 3 Step -3
        x$ = Mid$(s$, l - 2, 3) + "," + x$
    Next
    If l > 0 Then
        x$ = Mid$(s$, 1, l) + "," + x$
    End If
    If Len(s$) < 3 Then
        x$ = s$
    End If
    If Right$(x$, 1) = "," Then
        x$ = Left$(x$, Len(x$) - 1)
    End If
    x$ = e$ + x$ + q$ ' construct string
    FormatString$ = x$
End Function

