Rem file: Renvol.bas - QB64 Utility v1.0a PD 2016.

' default integer variables
DefInt A-Z
Rem $DYNAMIC
_Title "RENVOL"

' define boolean values
Const True = -1
Const False = Not True
Const TrueD = -1#
Const FalseD = Not TrueD
Const NUL = ""

' define color values
Const Black = 0
Const Cyan = 11
Const Green = 10
Const Plain = 7
Const Red = 12
Const White = 15
Const Yellow = 14

' initialize filename buffer
Dim Shared Drive.Search As String * 1
Dim Shared DriveType As String

' declare work variables
Dim Shared Continuous.Display As Integer
Dim Shared Display.Errors As Integer

' declare command line work variables
Dim Shared Command.Line As String
Dim Shared Command.Work As String
Dim Shared Last.Switch As Integer
Dim Shared Switch.Exist As Integer
Dim Shared Display.Drive As Integer
Dim Shared Display.Volume As Integer

' declare library constants.
Const MAX_PATH = 260

' declare external library
Declare Dynamic Library "kernel32"
    Function SetVolumeLabelA% (d$, f$)
    Function GetLastError& ()
    Function FormatMessageA& (ByVal f As Long, f$, Byval e As Long, Byval d As Long, g$, s As Long, h$)
    Function GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, Byval nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, Byval nFileSystemNameSize&)
    Function SetCurrentDirectoryA% (f$)
End Declare

Declare Library
    Function GetDriveType& (d$)
End Declare

' declare standard error trap
On Error GoTo Error.Routine

' force default path
x$ = _StartDir$
f$ = x$ + Chr$(0)
x = SetCurrentDirectoryA(f$)

' get current drive
Current.Drive$ = Left$(_CWD$, 1)

' check command line
If Command$ = "/?" Then
    GoTo Boot.Usage
End If

' read command line
Command.Line = Command$
Command.Line = RTrim$(Command.Line)

' reset command line
If Command.Line = "" Then
    Color 15
    Print "Enter drive";
    Input D$
    If D$ = "" Then GoTo Boot.Error
    If Len(D$) = 1 Then
        D$ = UCase$(D$)
        If D$ >= "A" And D$ <= "Z" Then
            Print "Enter label";
            Input L$
            If InStr(L$, " ") Then GoTo Boot.Error
            Command.Line = D$ + ":" + L$
        Else
            GoTo Boot.Error
        End If
    Else
        GoTo Boot.Error
    End If
End If

' get switches from command line
Continuous.Display = ParseLine("/C")
Display.Drive = ParseLine("/D")
Display.Volume = ParseLine("/X")
Display.Errors = ParseLine("/Z")

' recheck command line
If InStr(Command.Line, "/") Then
    GoTo Boot.Error
End If
Command.Line = RTrim$(Command.Line)
If Switch.Exist Then
    If Len(Command.Line) > Last.Switch Then
        GoTo Boot.Error
    End If
End If

' remove blanks from command line
Command.Line = RTrim$(Command.Line)
Command.Line = LTrim$(Command.Line)

' display header
GoSub Header

' store entire command
Command.Work = Command.Line

Do
    ' store entire command
    Imbedded = InStr(Command.Line, " ")
    If Imbedded Then
        Command.Work = Left$(Command.Line, Imbedded - 1)
        Command.Line = Mid$(Command.Line, Imbedded + 1)
    Else
        Command.Work = Command.Line
        Command.Line = NUL
    End If

    ' store current drive
    If Mid$(Command.Work, 2, 1) = ":" Then
        Drive.Search = Left$(Command.Work, 1)
        Command.Work = Mid$(Command.Work, 3)
    Else
        Drive.Search = Current.Drive$
    End If
    Drive.Search = UCase$(Drive.Search)

    ' display drive searched
    If Continuous.Display = False Then
        Color Yellow, Black
        Print "Searching: "; Drive.Search$; ":"
    End If

    ' check drive exists
    V = Asc(UCase$(Left$(Drive.Search$, 1))) - 64
    If MEDIAEXISTS(V) Then
        ' store new volume label
        Volume.Label$ = Command.Work + Chr$(0)
        Drive$ = Drive.Search$ + ":\" + Chr$(0)

        ' change volume label
        x = SetVolumeLabelA%(Drive$, Volume.Label$)

        ' check volume flag
        If x = 0 Then
            Temp$ = "Error 0x" + Hex$(GetLastError) + " naming volume."
            Call DisplayError(Temp$)
            Call DisplayWinError(x)
        Else
            GoSub Display.Label
        End If
    Else
        Temp$ = "Error accessing drive " + Drive.Search$ + ":\"
        Call DisplayError(Temp$)
    End If

    ' check search filename
    If Command.Line = NUL Then
        Exit Do
    End If
Loop

End.Renvol:

' display end program
If Continuous.Display = False Then
    Prompt$ = "Press <enter> to exit to DOS:"
    Call MorePrompt(Prompt$, Chr$(13), Outpt$)
End If
Color Plain, Black
End

' display volume label
Display.Label:
' display drive letter
If Display.Drive Then
    Color Yellow, Black
    Print Drive.Search; ":";
End If
' display volume label
If Display.Volume = False Then
    Color Yellow, Black
    Print Volume.Label$
End If
If Display.Drive And Display.Volume Then
    Print
End If
Return

' display program usage
Boot.Usage:
' make header
Color White, Black
Print "Renvol v1.0a: Volume update utility; "
Color Yellow, Black
Print "Usage:"
Print "   Renvol [d:][volumename][/cdxz]"
Print "Where:"
Print "   /c  continuous display"
Print "   /d  display drive letter"
Print "   /x  don't list volume label"
Print "   /z  suppress errors"
Color Plain, Black
End

Boot.Error:
Color White, Black
Print "Command line error. Type Renvol /? for help."
Color Plain, Black
End

' make header
Header:
If Header.Flag Then
    Return
End If
Header.Flag = True
If Continuous.Display = False Then
    Color White, Black
    Print "Renvol v1.0a: Volume update utility;"
End If
Return
   
' critical error trap
Error.Routine:
Data.Error = Err
If Display.Errors Then
    Error.Level = True
    Resume Next
End If
Color Green, Black
Print "Critical error:"; DataError; " IDE line:"; _ErrorLine
Prompt$ = "Press R to retry, Q to quit, C to continue:"
Call MorePrompt(Prompt$, "rqc", Outpt$)
Select Case Outpt$
    Case "r"
        Resume
    Case "q"
        Error.Level = True
        Resume End.Renvol
    Case "c"
        Resume Next
End Select
Color Plain, Black
End 0

Sub MorePrompt (Input.String$, Input.Mask$, Output.String$)
    Color White, Black
    Print Input.String$ + " ";
    Input.Char$ = NUL
    Locate , , 1
    Do
        _Limit 100
        Input.Char$ = InKey$
        If Len(Input.Char$) Then
            Input.Char$ = LCase$(Input.Char$)
            If InStr(Input.Mask$, Input.Char$) Then
                Print Input.Char$
                Output.String$ = Input.Char$
                Exit Do
            End If
        End If
    Loop
End Sub

' command line switch position function.
Function LastSwitch (Var)
    If Last.Switch = 0 Then
        Last.Switch = Var - 1
        Switch.Exist = -1
    Else
        If Var < Last.Switch Then
            Last.Switch = Var - 1
            Switch.Exist = -1
        End If
    End If
End Function

' command line parser
Function ParseLine (X$)
    Imbedded = InStr(Command.Line, LCase$(X$))
    If Imbedded Then
        Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    Else
        Imbedded = InStr(Command.Line, UCase$(X$))
        If Imbedded Then
            Command.Line = Left$(Command.Line, Imbedded - 1) + Mid$(Command.Line, Imbedded + Len(X$))
            Last.Switch = Imbedded - 1
            ParseLine = True
            Switch.Exist = -1
        Else
            ParseLine = False
        End If
    End If
End Function

' displays error
Sub DisplayError (Temp$)
    ' check display errors flag
    If Display.Errors = False Then
        ' display error
        Color Red, Black
        Print Temp$
    End If
End Sub

' displays windows error
Sub DisplayWinError (x)
    ' define error message space
    Dim m As String * 32767
    ' check display errors flag
    If Display.Errors = False Then
        ' call windows error message routine
        x& = FormatMessageA&(&H1200, "", GetLastError, 0, m$, 260, "")
        If x& Then
            ' display error
            v = CInt(x&) - 2
            If v > 0 Then
                Color Red, Black
                Print Left$(m$, v)
            End If
        End If
    End If
End Sub

' test volume media inserted.
Function MEDIAEXISTS (V)
    ' check drive exists.
    If DRIVEEXISTS(V) Then
        MEDIAEXISTS = False
        Exit Function
    End If

    ' get drive info.
    VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
    Vname$ = Space$(MAX_PATH)
    Fname$ = Space$(MAX_PATH)
    R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
    If R Then
        MEDIAEXISTS = True
    Else
        MEDIAEXISTS = False
    End If
End Function

' check drive exists.
'  returns -1 if drive not detected.
Function DRIVEEXISTS (V)
    VarX$ = Chr$(V + 64) + ":\" + Chr$(0)
    VarX = GetDriveType(VarX$)
    DriveType = NUL
    Select Case VarX
        Case 0
            DriveType = "[UNKNOWN]"
        Case 1
            DriveType = "[BADROOT]"
        Case 2
            DriveType = "[REMOVABLE]"
        Case 3
            DriveType = "[FIXED]"
        Case 4
            DriveType = "[REMOTE]"
        Case 5
            DriveType = "[CDROM]"
        Case 6
            DriveType = "[RAMDISK]"
    End Select
    If VarX > 1 Then
        DRIVEEXISTS = False
    Else
        DRIVEEXISTS = True
    End If
End Function

