REM file: Stree.bas - QB64 Utility v1.2a PD 2016.

' default integer variables
DEFINT A-Z
REM $DYNAMIC
_TITLE "STREE"

' define boolean values
CONST True = -1
CONST TrueD = -1#
CONST False = 0
CONST FalseD = 0#
CONST FalseS = 0!
CONST NUL = ""

' define color values
CONST Black = 0
CONST Cyan = 11
CONST Green = 10
CONST Magenta = 12
CONST Plain = 7
CONST Red = 12
CONST White = 15
CONST Yellow = 14

' declare date\time variables
DIM SHARED Creation.Time AS INTEGER
DIM SHARED Access.Time AS INTEGER
DIM SHARED Modified.Time AS INTEGER
DIM SHARED Search.From.Date AS SINGLE
DIM SHARED Search.To.Date AS SINGLE
DIM SHARED Search.From.Time AS SINGLE
DIM SHARED Search.To.Time AS SINGLE

' declare work variables
DIM SHARED Search.Archive AS INTEGER
DIM SHARED Search.Hidden AS INTEGER
DIM SHARED Search.Readonly AS INTEGER
DIM SHARED Search.System AS INTEGER
DIM SHARED Search.Compressed AS INTEGER
DIM SHARED Search.Encrypted AS INTEGER

DIM SHARED Recurse.Directories AS INTEGER
DIM SHARED Attribute AS _UNSIGNED LONG
DIM SHARED Extended.List AS INTEGER
DIM SHARED Display.Errors AS INTEGER
DIM SHARED Continuous.Display AS INTEGER
DIM SHARED Directories.Counted AS SINGLE
DIM SHARED Display.Lines AS INTEGER
DIM SHARED Display.Lowercase AS INTEGER
DIM SHARED Drive.Search AS STRING * 1
DIM SHARED Current.Drive AS STRING * 1
DIM SHARED Nested.Levels AS INTEGER
DIM SHARED Nested.Recurse AS INTEGER
DIM SHARED Short.Filenames AS INTEGER
DIM SHARED Short.Display AS INTEGER
DIM SHARED Wide.Display AS INTEGER
DIM SHARED Display.Length AS INTEGER
DIM SHARED Truncate.Slash AS INTEGER
DIM SHARED Strip.Drive AS INTEGER
DIM SHARED Check.Root AS INTEGER
DIM SHARED First.Dir AS INTEGER
DIM SHARED Length AS INTEGER
DIM SHARED Quit.Searching AS INTEGER
DIM SHARED More.Display AS INTEGER
DIM SHARED Append.Slash AS INTEGER
DIM SHARED Current.Directory AS STRING
DIM SHARED Wide.Display2 AS INTEGER

' declare command line work variables
DIM SHARED Command.Line AS STRING
DIM SHARED Command.Work AS STRING
DIM SHARED Last.Switch AS INTEGER
DIM SHARED Switch.Exist AS INTEGER

' declare library constants.
CONST MAX_PATH = 260
CONST INVALID_HANDLE_VALUE = -1

' declare library structures.
TYPE FILETIME
    dwLowDateTime AS _UNSIGNED LONG
    dwHighDateTime AS _UNSIGNED LONG
END TYPE

TYPE SYSTEMTIME
    wYear AS INTEGER
    wMonth AS INTEGER
    wDayOfWeek AS INTEGER
    wDay AS INTEGER
    wHour AS INTEGER
    wMinute AS INTEGER
    wSecond AS INTEGER
    wMilliseconds AS INTEGER
END TYPE

TYPE WIN32_FIND_DATAA
    dwFileAttributes AS _UNSIGNED LONG
    ftCreationTime AS FILETIME
    ftLastAccessTime AS FILETIME
    ftLastWriteTime AS FILETIME
    nFileSizeHigh AS _UNSIGNED LONG
    nFileSizeLow AS _UNSIGNED LONG
    dwReserved0 AS _UNSIGNED LONG
    dwReserved1 AS _UNSIGNED LONG
    cFileName AS STRING * MAX_PATH
    cAlternateFileName AS STRING * 14
END TYPE

' declare external libraries.
DECLARE DYNAMIC LIBRARY "kernel32"
    FUNCTION FindFirstFileA~%& (BYVAL lpFileName~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindNextFileA& (BYVAL hFindFile~%&, BYVAL lpFindFileData~%&)
    FUNCTION FindClose& (BYVAL hFindFile~%&)
    FUNCTION FileTimeToSystemTime& (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME)
    FUNCTION GetVolumeInformationA& (lpRootPathName$, lpVolumeNameBuffer$, BYVAL nVolumeNameSize~&, lpVolumeSerialNumber~&, lpMaximumComponentLength~&, lpFileSystemFlags~&, lpFileSystemNameBuffer$, BYVAL nFileSystemNameSize&)
    FUNCTION SetCurrentDirectoryA% (f$)
END DECLARE

DECLARE LIBRARY
    FUNCTION GetDriveType& (d$)
    FUNCTION GetModuleFileNameA (BYVAL Module AS LONG, FileName AS STRING, BYVAL nSize AS LONG)
END DECLARE

' declare library variables.
DIM SHARED SysTime AS SYSTEMTIME
DIM SHARED DriveType AS STRING

' declare standard error trap
ON ERROR GOTO Error.Routine

' force default path
x$ = _STARTDIR$
f$ = x$ + CHR$(0)
x = SetCurrentDirectoryA(f$)

' check command line
IF COMMAND$ = "/?" THEN
    GOSUB Boot.Usage
    END
END IF

' command line input loop
Command.Line = COMMAND$
Start.Loop:
Last.Switch = 0
Switch.Exist = 0

' reset counters
Directories.Counted = FalseS
Display.Lines = False
Continuous.Display = False
Quit.Searching = False

' get current drive/directory
Current.Drive = LEFT$(_CWD$, 1)
Current.Directory = _CWD$
IF RIGHT$(Current.Directory, 1) <> "\" THEN
    Current.Directory = Current.Directory + "\"
END IF

' check command line
IF Command.Line = NUL THEN
    ' display header
    COLOR White, Black
    GOSUB Header
    Display.Header = True

    ' get command line input
    PRINT "Dir spec: ";
    LINE INPUT Command.Line
    DO
        COLOR White, Black
        PRINT "Switches(?=list): ";
        LINE INPUT Var$
        IF Var$ = "?" THEN
            GOSUB Boot.Usage
        ELSE
            Command.Line = Command.Line + Var$
            EXIT DO
        END IF
    LOOP
END IF

' store command line
Command.Line = RTRIM$(Command.Line)

' check command line switches
Append.Slash = ParseLine("/B")
Continuous.Display = ParseLine("/C")
Extended.List = ParseLine("/E")
Short.Display = ParseLine("/F")

Search.Archive = ParseLine("/A")
Search.Hidden = ParseLine("/H")
Search.Readonly = ParseLine("/O")
Search.System = ParseLine("/S")
Search.Compressed = ParseLine("/J")
Search.Encrypted = ParseLine("/K")

Display.Lowercase = ParseLine("/Y")
Strip.Drive = ParseLine("/U")
Recurse.Directories = ParseLine("/R")
Short.Filenames = ParseLine("/V")
Wide.Display2 = ParseLine("/W1")
Wide.Display = ParseLine("/W")
Truncate.Slash = ParseLine("/X")
Display.Errors = ParseLine("/Z")

' reset some display variables
IF Wide.Display THEN
    Extended.List = False
    Short.Display = True
    Short.Filenames = True
END IF

' get date\time from command line
Search.From.Date = False
Search.To.Date = False
Search.From.Time = False
Search.To.Time = False
Imbedded = INSTR(UCASE$(Command.Line), "/D")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    D$ = MID$(Command.Line, Imbedded + 2, 21)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 23)
    IF LEN(D$) <> 21 THEN
        GOTO Boot.Error
    END IF
    IF MID$(D$, 11, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.From.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    S$ = RIGHT$(D$, 10)
    D1! = INT(VAL(MID$(S$, 1, 2)))
    D2! = INT(VAL(MID$(S$, 4, 2)))
    D3! = INT(VAL(MID$(S$, 7, 4)))
    Search.To.Date = ((D3! - 1980) * 512) + D1! * 32 + D2!
    IF Search.From.Date < False OR Search.To.Date < False THEN
        GOTO Boot.Error
    END IF
END IF
Imbedded = INSTR(UCASE$(Command.Line), "/T")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    T$ = MID$(Command.Line, Imbedded + 2, 17)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 19)
    IF LEN(T$) <> 17 THEN
        GOTO Boot.Error
    END IF
    IF MID$(T$, 9, 1) <> "-" THEN
        GOTO Boot.Error
    END IF
    S$ = LEFT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.From.Time = T1! * 2048 + T2! * 32 + T3!
    S$ = RIGHT$(T$, 8)
    T1! = INT(VAL(MID$(S$, 1, 2)))
    T2! = INT(VAL(MID$(S$, 4, 2)))
    T3! = INT(VAL(MID$(S$, 7, 2)))
    Search.To.Time = T1! * 2048 + T2! * 32 + T3!
    IF Search.From.Time < False OR Search.To.Time < False THEN
        GOTO Boot.Error
    END IF
END IF

' get extended date\time switches
Creation.Time = ParseLine("/1")
Access.Time = ParseLine("/2")
Modified.Time = ParseLine("/3")
IF Creation.Time = False THEN
    IF Access.Time = False THEN
        IF Modified.Time = False THEN
            Modified.Time = True
        END IF
    END IF
END IF

' get nested switch from command line
Nested.Levels = 256%
Imbedded = INSTR(UCASE$(Command.Line), "/N")
IF Imbedded THEN
    Var = LastSwitch(Imbedded)
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 2)
    GOSUB Get.Numeric
    Nested.Recurse = Var%
END IF

' recheck command line
IF INSTR(Command.Line, "/") THEN
    GOTO Boot.Error
END IF

' check trailing command line
Command.Line = RTRIM$(Command.Line)
IF Switch.Exist THEN
    IF LEN(Command.Line) > Last.Switch THEN
        GOTO Boot.Error
    END IF
END IF

' remove blanks from command line
Command.Line = RTRIM$(Command.Line)
Command.Line = LTRIM$(Command.Line)
IF Command.Line = "" THEN
    Command.Line = "*.*"
END IF

' store entire command
Command.Work = Command.Line

' display header
IF Display.Header = False THEN
    IF Continuous.Display = False THEN
        COLOR White, Black
        GOSUB Header
    END IF
END IF

' filename processing loop
DO
    ' store entire command
    IF LEFT$(Command.Line, 1) = CHR$(34) THEN
        Imbedded = INSTR(2, Command.Line, CHR$(34))
        IF Imbedded THEN
            Command.Work = MID$(Command.Line, 2, Imbedded - 2)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    ELSE
        Imbedded = INSTR(Command.Line, " ")
        IF Imbedded THEN
            Command.Work = LEFT$(Command.Line, Imbedded - 1)
            Command.Line = MID$(Command.Line, Imbedded + 1)
        ELSE
            Command.Work = Command.Line
            Command.Line = NUL
        END IF
    END IF

    ' store search drive
    IF MID$(Command.Work, 2, 1) = ":" THEN
        Drive.Search = LEFT$(Command.Work, 1)
    ELSE
        Drive.Search = Current.Drive
    END IF
    Drive.Search = UCASE$(Drive.Search)

    ' store current directory
    Directory.Search$ = Command.Work

    ' parse drive letter
    Temp.Directory$ = Directory.Search$
    IF MID$(Temp.Directory$, 2, 1) = ":" THEN
        Temp.Drive$ = UCASE$(LEFT$(Temp.Directory$, 1))
        Temp.Directory$ = MID$(Temp.Directory$, 3)
    ELSE
        Temp.Drive$ = Drive.Search
    END IF

    ' parse directory
    IF LEFT$(Temp.Directory$, 2) <> "\\" THEN
        IF LEFT$(Temp.Directory$, 1) <> "\" THEN
            IF Temp.Drive$ <> LEFT$(Current.Directory, 1) THEN
                Directory.Search$ = Drive.Search + ":\" + Temp.Directory$
            ELSE
                Directory.Search$ = Current.Directory + Temp.Directory$
            END IF
        ELSE
            Directory.Search$ = Temp.Drive$ + ":" + Temp.Directory$
        END IF
    END IF

    ' display search header
    IF Continuous.Display = False THEN
        COLOR Yellow, Black
        Display.Lines = Display.Lines + 1
        PRINT "Searching: " + Directory.Search$
    END IF

    ' call subroutine to search directories
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        CALL Directories(Directory.Search$)
    ELSE
        V = ASC(UCASE$(LEFT$(Temp.Drive$, 1))) - 64
        IF MEDIAEXISTS(V) THEN
            CALL Directories(Directory.Search$)
        END IF
    END IF

    ' check search filename
    IF Command.Line = NUL THEN
        EXIT DO
    END IF

    ' check quit searching
    IF Quit.Searching THEN
        EXIT DO
    END IF
LOOP
End.Stree:

' display counters
IF Continuous.Display = False THEN
    IF Wide.Display THEN
        IF Display.Length THEN
            PRINT
        END IF
    END IF
    COLOR Yellow, Black
    PRINT "Directories counted"; Directories.Counted
    COLOR White, Black
    Prompt$ = "Press (A)gain, (Q)uit:"
    PRINT Prompt$;
    DO
        _LIMIT 50
        LOCATE , , 1
        I$ = INKEY$
        IF UCASE$(I$) = "Q" THEN
            COLOR Plain, Black
            SYSTEM
        END IF
        IF UCASE$(I$) = "A" THEN
            Command.Line = NUL
            COLOR Plain, Black
            PRINT
            GOTO Start.Loop
        END IF
    LOOP
END IF
COLOR Plain, Black
END

' make header
Header:
IF Header.Flag THEN
    RETURN
END IF
Header.Flag = True
IF Continuous.Display = False THEN
    COLOR White, Black
    PRINT "Stree v1.2a: Directory search utility;"
END IF
RETURN

Get.Numeric:
Var% = False
DO
    Temp$ = MID$(Command.Line, Imbedded, 1)
    IF Temp$ >= "0" AND Temp$ <= "9" THEN
        Var% = Var% * 10 + VAL(Temp$)
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + 1)
    ELSE
        EXIT DO
    END IF
LOOP
RETURN

' display program usage
Boot.Usage:
' make header
COLOR White, Black
PRINT "Stree v1.2a: Directory search utility;"
COLOR Yellow, Black
PRINT "Usage:"
PRINT "   Stree [d:\path\][/ahos][/bcdefnrtuvwxyz][/123]"
PRINT "Where:"
PRINT "   /b  append slash         /c  continuous display"
PRINT "   /e  extended display     /f  short filename display"
PRINT "   /r  recurse directories  /u  strip leading drive letter"
PRINT "   /v  use 8.3 filenames    /w  wide list display"
PRINT "   /w1 prepend slash        /x  truncate slash"
PRINT "   /y  lowercase display    /z  suppress errors"
PRINT "   /nxxx  recurse levels override"
PRINT "   display directory ranges:"
PRINT "      /1  creation, /2 accessed, /3 modified"
PRINT "      /d  is range of file dates in form mm/dd/yyyy-mm/dd/yyyy"
PRINT "      /t  is range of file times in form hh:mm:ss-hh:mm:ss"
PRINT "   display directory attributes:"
PRINT "      /a  archive, /h  hidden, /o  read-only, /s  system"
PRINT "      /j  compressed,  /k  encrypted"
COLOR Plain, Black
RETURN
END

Boot.Error:
COLOR White, Black
PRINT "Command line error. Type Stree /? for help."
COLOR Plain, Black
END

' critical error trap
Error.Routine:
DataError = ERR
IF Display.Errors THEN
    RESUME NEXT
END IF
IF Wide.Display THEN
    IF Display.Length THEN
        Display.Length = False
        PRINT
    END IF
END IF
COLOR Green, Black
PRINT "Critical error:"; DataError; " IDE line:"; _ERRORLINE
Prompt$ = "Press R to retry, Q to quit, C to continue:"
CALL MorePrompt(Prompt$, "rqc", Outpt$)
SELECT CASE Outpt$
    CASE "r"
        RESUME
    CASE "q"
        RESUME End.Stree
    CASE "c"
        RESUME NEXT
END SELECT
COLOR Plain, Black
END 0

' subroutine to access directories
SUB Directories (Directory.Search$)
' declare subroutine variables
'  local only to this subroutine for recursion.
DIM ASCIIZ AS STRING * 260
DIM finddata AS WIN32_FIND_DATAA
DIM Wfile.Handle AS _UNSIGNED _OFFSET
DIM Recurse.Temp AS INTEGER

' reset wildcard flag
Wild = 0

' make directory filename
Temp.Dir$ = Directory.Search$
Recurse.Temp = Recurse.Directories
IF Recurse.Directories THEN
    IF INSTR(Temp.Dir$, "?") OR INSTR(Temp.Dir$, "*") THEN
        ' Recurse.Temp = False
    ELSE
        IF RIGHT$(Temp.Dir$, 1) <> "\" THEN
            Temp.Dir$ = Temp.Dir$ + "\"
        END IF
        Temp.Dir$ = Temp.Dir$ + "*.*"
    END IF
END IF
ASCIIZ = Temp.Dir$ + CHR$(0)

' find first long filename
Wfile.Handle = FindFirstFileA(_OFFSET(ASCIIZ), _OFFSET(finddata))

' check findirst error
IF Wfile.Handle <> INVALID_HANDLE_VALUE THEN

    ' filename/directory loop
    DO
        ' get file attributes
        Attribute = finddata.dwFileAttributes

        ' check directory attribute
        IF (Attribute AND &H10) = &H10 THEN

            ' check to recurse directories
            IF Recurse.Temp = 0 THEN
                ' store directory name
                Directory$ = finddata.cFileName
                V = INSTR(Directory$, CHR$(0))
                IF V THEN Directory$ = LEFT$(Directory$, V - 1)

                ' display directory
                GOSUB Display.Directory
            END IF

            ' check to recurse directories
            IF Recurse.Temp THEN

                ' store directory name
                Directory$ = finddata.cFileName
                V = INSTR(Directory$, CHR$(0))
                IF V THEN Directory$ = LEFT$(Directory$, V - 1)

                ' check unicode
                Unicode = 0
                IF INSTR(Directory$, "?") THEN
                    Unicode = -1
                    Directory$ = finddata.cAlternateFileName
                    V = INSTR(Directory$, CHR$(0))
                    IF V THEN Directory$ = LEFT$(Directory$, V - 1)
                END IF

                ' check directory name
                Valid.Flag = -1
                IF Directory$ = "." THEN
                    Valid.Flag = 0
                END IF
                IF Directory$ = ".." THEN
                    Valid.Flag = 0
                END IF
                IF Directory$ = NUL THEN
                    Valid.Flag = 0
                END IF
                IF Valid.Flag THEN

                    ' display directory
                    GOSUB Display.Directory

                    ' check recursion levels
                    Recursion% = True
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels + 1
                        IF Nested.Levels >= Nested.Recurse THEN
                            Recursion% = False
                        END IF
                    END IF

                    ' recursively search subdirectories
                    IF Recursion% THEN
                        CALL Directories(Next.Directory$)
                    END IF
                    IF Nested.Recurse > False THEN
                        Nested.Levels = Nested.Levels - 1
                    END IF
                END IF
            END IF
        END IF

        ' check quit searching
        IF Quit.Searching THEN
            EXIT DO
        END IF
    LOOP WHILE FindNextFileA(Wfile.Handle, _OFFSET(finddata))
    x = FindClose(Wfile.Handle)
END IF
EXIT SUB

Display.Directory:
' retract one directory if wildcard/global characters in trailing path
IF INSTR(Directory.Search$, "?") OR INSTR(Directory.Search$, "*") THEN
    Wild = -1
    FOR V = LEN(Directory.Search$) TO 1 STEP -1
        IF MID$(Directory.Search$, V, 1) = "\" THEN
            Directory.Search$ = LEFT$(Directory.Search$, V)
            EXIT FOR
        END IF
    NEXT
END IF

' make next search directory
IF RIGHT$(Directory.Search$, 1) <> "\" THEN
    Next.Directory$ = Directory.Search$ + "\" + Directory$
ELSE
    Next.Directory$ = Directory.Search$ + Directory$
END IF

' store directory name
Temp.Directory$ = finddata.cFileName
V = INSTR(Temp.Directory$, CHR$(0))
IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)

IF Temp.Directory$ = NUL THEN
    RETURN
END IF
IF Temp.Directory$ = "." THEN
    RETURN
END IF
IF Temp.Directory$ = ".." THEN
    RETURN
END IF

' construct directory for display
IF Recurse.Directories = 0 THEN
    IF Wild THEN
        IF RIGHT$(Directory.Search$, 1) <> "\" THEN
            Temp.Directory$ = Directory.Search$ + "\" + Directory$
        ELSE
            Temp.Directory$ = Directory.Search$ + Directory$
        END IF
    ELSE
        Temp.Directory$ = Directory.Search$
    END IF
ELSE
    IF Unicode THEN
        Unicode.Directory$ = finddata.cFileName
        V = INSTR(Unicode.Directory$, CHR$(0))
        IF V THEN Unicode.Directory$ = LEFT$(Unicode.Directory$, V - 1)
        IF RIGHT$(Directory.Search$, 1) <> "\" THEN
            Temp.Directory$ = Directory.Search$ + "\" + Unicode.Directory$
        ELSE
            Temp.Directory$ = Directory.Search$ + Unicode.Directory$
        END IF
    ELSE
        Temp.Directory$ = Next.Directory$
    END IF
    Wild = -1
END IF

' get short filename
IF Short.Filenames THEN
    Temp.Directory$ = finddata.cAlternateFileName
    V = INSTR(Temp.Directory$, CHR$(0))
    IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)
    IF Temp.Directory$ = NUL THEN
        Temp.Directory$ = finddata.cFileName
        V = INSTR(Temp.Directory$, CHR$(0))
        IF V THEN Temp.Directory$ = LEFT$(Temp.Directory$, V - 1)
    END IF
END IF

' check directory attribute
Valid.Attribute = True

' check for read-only file
IF Search.Readonly THEN
    IF (Attribute AND &H1) <> &H1 THEN
        Valid.Attribute = False
    END IF
END IF

' check for hidden file
IF Search.Hidden THEN
    IF (Attribute AND &H2) <> &H2 THEN
        Valid.Attribute = False
    END IF
END IF

' check for system file
IF Search.System THEN
    IF (Attribute AND &H4) <> &H4 THEN
        Valid.Attribute = False
    END IF
END IF

' check for archive file
IF Search.Archive THEN
    IF (Attribute AND &H20) <> &H20 THEN
        Valid.Attribute = False
    END IF
END IF

' check for compressed file
IF Search.Compressed THEN
    IF (Attribute AND &H800) <> &H800 THEN
        Valid.Attribute = False
    END IF
END IF

' check for encrypted file
IF Search.Encrypted THEN
    IF (Attribute AND &H4000) <> &H4000 THEN
        Valid.Attribute = False
    END IF
END IF

' store file date and time
IF Creation.Time THEN
    x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
ELSE
    IF Access.Time THEN
        x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
        GOSUB Convert.Date
        GOSUB Convert.Time
    ELSE
        IF Modified.Time THEN
            x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
            GOSUB Convert.Date
            GOSUB Convert.Time
        END IF
    END IF
END IF

' check date\time range
IF Search.From.Date OR Search.To.Date THEN
    IF File.Work.Date < Search.From.Date THEN
        Valid.Attribute = False
    END IF
    IF File.Work.Date > Search.To.Date THEN
        Valid.Attribute = False
    END IF
END IF
IF Search.From.Time OR Search.To.Time THEN
    IF File.Work.Time < Search.From.Time THEN
        Valid.Attribute = False
    END IF
    IF File.Work.Time > Search.To.Time THEN
        Valid.Attribute = False
    END IF
END IF

' check for valid directory
IF Valid.Attribute THEN

    ' store directory name
    Outpt$ = RTRIM$(Temp.Directory$)
    IF Short.Display THEN
        IF RIGHT$(Outpt$, 1) = "\" THEN
            Outpt$ = LEFT$(Outpt$, LEN(Outpt$) - 1)
        END IF
        FOR Imbedded = LEN(Outpt$) TO 1 STEP -1
            IF MID$(Outpt$, Imbedded, 1) = "\" THEN
                Outpt$ = MID$(Outpt$, Imbedded + 1)
                EXIT FOR
            END IF
        NEXT
    END IF
    IF Truncate.Slash THEN
        IF Outpt$ <> "\" THEN
            IF RIGHT$(Outpt$, 1) = "\" THEN
                Outpt$ = LEFT$(Outpt$, LEN(Outpt$) - 1)
            END IF
        END IF
    END IF
    IF Short.Filenames = False OR Short.Display THEN
        IF MID$(Outpt$, 2, 1) <> ":" THEN
            IF LEFT$(Directory.Search$, 2) <> "\\" THEN
                Outpt$ = Drive.Search + ":" + Outpt$
            END IF
        END IF
    END IF
    IF LEFT$(Directory.Search$, 2) = "\\" THEN
        IF MID$(Outpt$, 2, 1) = ":" THEN
            Outpt$ = MID$(Outpt$, 3)
        END IF
    END IF
    IF Strip.Drive THEN
        IF MID$(Outpt$, 2, 1) = ":" THEN
            Outpt$ = MID$(Outpt$, 3)
        END IF
    END IF
    IF Display.Lowercase THEN
        Outpt$ = LCASE$(Outpt$)
    END IF

    ' set directory flag
    Flag = True

    ' display directory
    IF Flag THEN
        ' increment directories counted
        Directories.Counted = Directories.Counted + 1!

        ' check wide display output
        IF Wide.Display THEN
            COLOR Yellow, Black
            ' append/prepend slash
            IF Strip.Drive THEN
                IF Wide.Display2 THEN ' prepend
                    IF LEFT$(Outpt$, 1) <> "\" THEN
                        Outpt$ = "\" + Outpt$
                    END IF
                END IF
                IF Append.Slash THEN ' append
                    IF RIGHT$(Outpt$, 1) <> "\" THEN
                        Outpt$ = Outpt$ + "\"
                    END IF
                END IF
            END IF
            Outpt$ = LEFT$(Outpt$, 14)
            PRINT Outpt$;
            PRINT SPACE$(15 - LEN(Outpt$));
            ' count directories in one line
            Display.Length = Display.Length + 1
            IF Display.Length = 5 THEN
                ' reset counters
                PRINT
                Display.Length = False
                Display.Lines = Display.Lines + 1
                GOSUB Page.Prompt
                IF Quit.Searching THEN
                    EXIT SUB
                END IF
            END IF
        ELSE
            ' check slash switch
            IF Append.Slash THEN
                IF RIGHT$(Outpt$, 1) <> "\" THEN
                    Outpt$ = Outpt$ + "\"
                END IF
            END IF

            ' store length of directory name
            Length = LEN(Outpt$)
            ' calculate length variable
            GOSUB Calc.Length

            ' check for overflow past more prompt
            ' before directory displayed
            IF Continuous.Display = False THEN
                ' reset display line counter
                IF Display.Lines > 22 THEN
                    GOSUB Page.Prompt
                    IF Quit.Searching THEN
                        EXIT SUB
                    END IF
                    ' recalculate length
                    GOSUB Calc.Length
                END IF
            END IF

            ' display full directory pathname
            COLOR Yellow, Black
            PRINT Outpt$

            ' check for paginate
            ' after directory displayed
            IF Continuous.Display = False THEN
                GOSUB Page.Prompt
                IF Quit.Searching THEN
                    EXIT SUB
                END IF
            END IF

            ' check output type
            IF Extended.List THEN
                ' display extended directory attributes
                GOSUB Display.List
                ' check for paginate
                ' after extended info displayed
                IF Continuous.Display = False THEN
                    GOSUB Page.Prompt
                    IF Quit.Searching THEN
                        EXIT SUB
                    END IF
                END IF
            END IF
        END IF
    END IF
END IF
RETURN

' check for page length
Page.Prompt:
IF Display.Lines >= 22 THEN
    Display.Lines = False
    IF Continuous.Display = False THEN
        IF More.Display = False THEN
            Prompt$ = "More (y)es/(n)o/(c)ontinuous?"
            CALL MorePrompt(Prompt$, "ync", Outpt2$)
            SELECT CASE Outpt2$
                CASE "c"
                    More.Display = True
                CASE "n"
                    Quit.Searching = True
            END SELECT
        END IF
    END IF
END IF
RETURN

' calculates line length,
' increments total lines displayed
Calc.Length:
IF Length > 240 THEN
    Display.Lines = Display.Lines + 4
ELSE
    IF Length > 160 THEN
        Display.Lines = Display.Lines + 3
    ELSE
        IF Length > 80 THEN
            Display.Lines = Display.Lines + 2
        ELSE
            Display.Lines = Display.Lines + 1
        END IF
    END IF
END IF
RETURN

' routine to display extended directory attributes
Display.List:
Length = False
' store file creation date\time
IF Creation.Time THEN
    x& = FileTimeToSystemTime&(finddata.ftCreationTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
    Outpt$ = File.Date$ + " " + File.Time$
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR Red, Black
    PRINT Outpt$;
END IF
IF Access.Time THEN
    x& = FileTimeToSystemTime&(finddata.ftLastAccessTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
    IF Creation.Time THEN
        Length = Length + 1
        GOSUB Line.Check
        COLOR White, Black
        PRINT "\";
    END IF
    Outpt$ = File.Date$ + " " + File.Time$
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR Red, Black
    PRINT Outpt$;
END IF
IF Modified.Time THEN
    x& = FileTimeToSystemTime&(finddata.ftLastWriteTime, SysTime)
    GOSUB Convert.Date
    GOSUB Convert.Time
    IF Creation.Time OR Access.Time THEN
        Length = Length + 1
        GOSUB Line.Check
        COLOR White, Black
        PRINT "\";
    END IF
    Outpt$ = File.Date$ + " " + File.Time$
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR Red, Black
    PRINT Outpt$;
END IF

' display file attributes
IF (Attribute AND &H1) = &H1 THEN
    Outpt$ = " Read-only"
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR White, Black
    PRINT Outpt$;
END IF
IF (Attribute AND &H2) = &H2 THEN
    Outpt$ = " Hidden"
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR White, Black
    PRINT Outpt$;
END IF
IF (Attribute AND &H4) = &H4 THEN
    Outpt$ = " System"
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR White, Black
    PRINT Outpt$;
END IF
IF (Attribute AND &H20) = &H20 THEN
    Outpt$ = " Archive"
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR White, Black
    PRINT Outpt$;
END IF
IF (Attribute AND &H800) = &H800 THEN
    Outpt$ = " Compressed"
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR White, Black
    PRINT Outpt$;
END IF
IF (Attribute AND &H4000) = &H4000 THEN
    Outpt$ = " Encrypted"
    Length = Length + LEN(Outpt$)
    GOSUB Line.Check
    COLOR White, Black
    PRINT Outpt$;
END IF
IF Length THEN
    PRINT
END IF
Display.Lines = Display.Lines + Temp.Lines
RETURN

Convert.Date:
YearTemp! = SysTime.wYear
MonthTemp! = SysTime.wMonth
DayTemp! = SysTime.wDay
File.Date$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wMonth)), 2) + "-"
File.Date$ = File.Date$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wDay)), 2) + "-"
File.Date$ = File.Date$ + LTRIM$(STR$(SysTime.wYear))
File.Work.Date = ((YearTemp! - 1980) * 512) + MonthTemp! * 32 + DayTemp!
RETURN

Convert.Time:
HourTemp! = SysTime.wHour
MinuteTemp! = SysTime.wMinute
SecondsTemp! = SysTime.wSecond
File.Time$ = RIGHT$("00" + LTRIM$(STR$(SysTime.wHour)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wMinute)), 2) + ":"
File.Time$ = File.Time$ + RIGHT$("00" + LTRIM$(STR$(SysTime.wSecond)), 2)
File.Work.Time = HourTemp! * 2048 + MinuteTemp! * 32 + SecondsTemp!
RETURN

' check for page length
Line.Check:
' calculate lines past current line display counter
IF Length THEN
    Temp.Lines = 1
    IF Length > 80 THEN
        Temp.Lines = 2
    END IF
END IF
' check overflow past line 22
IF Display.Lines + Temp.Lines > 22 THEN
    ' page break
    IF Length THEN
        IF Continuous.Display = False THEN
            PRINT
        END IF
    END IF
    ' reset counters
    Length = False
    Display.Lines = False
    IF Continuous.Display = False THEN
        IF More.Display = False THEN
            ' prompt for more
            Prompt$ = "More (y)es/(n)o/(c)ontinuous?"
            CALL MorePrompt(Prompt$, "ync", Outpt2$)
            SELECT CASE Outpt2$
                CASE "c"
                    More.Display = True
                CASE "n"
                    Quit.Searching = True
            END SELECT
        END IF
    END IF
END IF
RETURN
END SUB

' prompt for more
SUB MorePrompt (Input.String$, Input.Mask$, Output.String$)
COLOR White, Black
PRINT Input.String$ + " ";
Input.Char$ = NUL
DO
    DO
        _LIMIT 50
        LOCATE , , 1
        Input.Char$ = INKEY$
        IF LEN(Input.Char$) THEN
            EXIT DO
        END IF
    LOOP
    Input.Char$ = LCASE$(Input.Char$)
    IF INSTR(Input.Mask$, Input.Char$) THEN
        PRINT Input.Char$
        Output.String$ = Input.Char$
        EXIT DO
    END IF
LOOP
END SUB

' command line switch position function.
FUNCTION LastSwitch (Var)
IF Last.Switch = 0 THEN
    Last.Switch = Var - 1
    Switch.Exist = -1
ELSE
    IF Var < Last.Switch THEN
        Last.Switch = Var - 1
        Switch.Exist = -1
    END IF
END IF
END FUNCTION

' command line parser
FUNCTION ParseLine (X$)
Imbedded = INSTR(Command.Line, LCASE$(X$))
IF Imbedded THEN
    Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
    Last.Switch = Imbedded - 1
    ParseLine = True
    Switch.Exist = -1
ELSE
    Imbedded = INSTR(Command.Line, UCASE$(X$))
    IF Imbedded THEN
        Command.Line = LEFT$(Command.Line, Imbedded - 1) + MID$(Command.Line, Imbedded + LEN(X$))
        Last.Switch = Imbedded - 1
        ParseLine = True
        Switch.Exist = -1
    ELSE
        ParseLine = False
    END IF
END IF
END FUNCTION

' test volume media inserted.
FUNCTION MEDIAEXISTS (V)
' check drive exists.
IF DRIVEEXISTS(V) THEN
    MEDIAEXISTS = False
    EXIT FUNCTION
END IF

' get drive info.
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
Vname$ = SPACE$(MAX_PATH)
Fname$ = SPACE$(MAX_PATH)
R = GetVolumeInformationA(VarX$, Vname$, MAX_PATH, serial~&, empty1~&, empty2~&, Fname$, MAX_PATH)
IF R THEN
    MEDIAEXISTS = True
ELSE
    MEDIAEXISTS = False
END IF
END FUNCTION

' check drive exists.
'  returns -1 if drive not detected.
FUNCTION DRIVEEXISTS (V)
VarX$ = CHR$(V + 64) + ":\" + CHR$(0)
VarX = GetDriveType(VarX$)
DriveType = NUL
SELECT CASE VarX
    CASE 0
        DriveType = "[UNKNOWN]"
    CASE 1
        DriveType = "[BADROOT]"
    CASE 2
        DriveType = "[REMOVABLE]"
    CASE 3
        DriveType = "[FIXED]"
    CASE 4
        DriveType = "[REMOTE]"
    CASE 5
        DriveType = "[CDROM]"
    CASE 6
        DriveType = "[RAMDISK]"
END SELECT
IF VarX > 1 THEN
    DRIVEEXISTS = False
ELSE
    DRIVEEXISTS = True
END IF
END FUNCTION

